//
// C++ Interface: woksearcher
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef WOKSEARCHER_H
#define WOKSEARCHER_H

#include "searcher.h"
#include "searcherconfigwidget.h"

#include <kurl.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/

class KLineEdit;
class KComboBox;

class WOKSearcher;

class WOKConfigWidget : public SearcherConfigWidget {
	public:
		WOKConfigWidget(QWidget* parent, WOKSearcher* searcher = 0);
		virtual void updateSearcher();
private:
    KLineEdit* m_hostEdit;
    KComboBox* m_dataBaseCombo;

};

class WOKSearcher : public searcher
{
Q_OBJECT
	public:
		WOKSearcher(QObject* parent, const char* name=0);
		
		virtual ~WOKSearcher();

		virtual QString source() const;
		virtual void setSource(const QString );
		virtual bool isSearching() const { return m_started; }
		virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
		virtual void stop();
		virtual Type type() const { return WOK; }
		virtual void readConfig(KConfig* config, const QString& group);
		virtual void saveConfig(KConfig* config);
		virtual SearcherConfigWidget* configWidget(QWidget* parent);
		
		friend class WOKConfigWidget;
		virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
		virtual void retrieveRange(unsigned int min, unsigned int max);
		virtual QStringList searchKey();
		virtual int maxSearchTerms() {return 100; }
		static QString defaultName();
		void setDataBase(QString db) {m_dbname = db; } 
		void setHost(QString host) { m_host = host; }

	private slots:
		void slotData(KIO::Job* job, const QByteArray& data);
		void slotComplete(KIO::Job* job);

	private:
		void searchResults();
		void fetchResults();

		enum Step {
			Begin,
			Search,
			Wait,
			Fetch
		};

		KURL m_url;
		QString m_host;
		QString m_dbname;
		QByteArray m_data;
		QString m_query;
		int m_total;
		QString m_queryKey;
		QString m_sessionID;
		QGuardedPtr<KIO::Job> m_job;
		Step m_step;
		bool m_started;
};



#endif
