//
// C++ Interface: urlfieldwidget
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIURLFIELDWIDGET_H
#define GUIURLFIELDWIDGET_H

#include <fieldwidget.h>
#include <qcheckbox.h>

class KURLRequester;
class KPushButton;
class KPopupMenu;


namespace GUI {

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class UrlFieldWidget : public FieldWidget
{
Q_OBJECT
		
public:
    UrlFieldWidget(QString _name, RefField* field,  QStringList macroKeys, QWidget *parent = 0, const char *name = 0);

    ~UrlFieldWidget();
	virtual void setText(QString );
	virtual void setMacro(bool macro) {m_stringMacroIndicator->setChecked(macro); }
	virtual QString getText();
	virtual bool getMacro(void) { return m_stringMacroIndicator->isChecked(); }
	virtual void setAutoCompletion(QStringList) {};
	
private slots:
	void slotMacroMenuActivated(int);		
	
private:
	KURLRequester *m_requester;
	QCheckBox *m_stringMacroIndicator;
	KPushButton *m_stringMacroSelect;	
	KPopupMenu *m_stringMacroMenu;

};

}

#endif
