//
// C++ Interface: searchmanager
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef SEARCHMANAGER_H
#define SEARCHMANAGER_H

#include "searcher.h"
#include <qobject.h>
#include <qptrlist.h>



typedef QMap<Type, QString> SearchMap;
typedef QMap<SearchKey, QString> SearchKeyMap;

class searchManager : public QObject {
Q_OBJECT

public:
	static searchManager* self() {  if(!s_self) s_self = new searchManager(); return s_self; }
	searchManager();
	~searchManager();

  QStringList sources();
  void loadSearchers();
  const QPtrList<searcher>& searchers() const { return searchersList; }
  int numSearcher() const { return searchersList.count(); }
  void startSearch(const QString& source, SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
  void stop();
  SearchKey searchKey(const QString& key_) const;
  QString searchKeyString(const SearchKey& key_) const;
  QStringList searchKeyList(const QString& source);
  int maxSearchTerms(const QString& source_);
  void retrieveRange(unsigned int, unsigned int);

  static QString typeName(Type type);
  static SearchMap sourceMap();
  
signals:
  void signalResultFound(BibEntry* e);  
  void signalQueryResult(unsigned int);
  void signalMessage(QString, int);
  void signalDone();
private slots:
  void slotSearcherDone(searcher *);  
  
private:
  static searchManager* s_self;
  searcher* createSearcher(KConfig* config, const QString& configGroup);
  QPtrList<searcher> searchersList;
  SearchKeyMap m_keyMap;
  bool m_loadDefaults;
  
  
};



#endif
