//
// C++ Interface: referencetypesdialog
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef REFERENCETYPESDIALOG_H
#define REFERENCETYPESDIALOG_H

#include <kdialogbase.h>
#include "bibentrydeftable.h"

class KComboBox;
class KLineEdit;
class KPushButton;
class KPopupMenu;

class QString;
class QLabel;
class QRadioButton;
class QCheckBox;
class QPainter;
#include <qlistbox.h>
#include <qmap.h>
#include <qstringlist.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class ReferenceTypesDialog : public KDialogBase
{
Q_OBJECT
public:
    ReferenceTypesDialog(QWidget *parent = 0, const char *name = 0);

    ~ReferenceTypesDialog();
	void saveTypes();
	
	private slots:
		virtual void slotOk();
		void slotTypeHighlightedChanged(int);
		void slotNewType();
		void slotDeleteType();
		void slotNewRequiredFieldMenu(int);
		void slotNewOptionalFieldMenu(int);
		void slotDeleteRequiredField();
		void slotDeleteOptionalField();
		void slotRequiredHighlightedChanged(int);
		void slotOptionalHighlightedChanged(int);
		void slotMoveRequiredUp();
		void slotMoveRequiredDown();
		void slotMoveOptionalUp();
		void slotMoveOptionalDown();
		
	private:
		bool fieldExist(QString);
		bool checkType();
		bool updateType();
		
		
		QDict<BibEntryDef>  m_refTypes;
		QListBox *m_typesBox;
		KPushButton *m_btnDeleteType;
		KLineEdit *m_nameEdit;
		QListBox *m_requiredBox;
		QListBox *m_optionalBox;
		KPushButton *m_btnRequiredUp;
		KPushButton *m_btnRequiredDown;
		KPushButton *m_btnOptionalUp;
		KPushButton *m_btnOptionalDown;
		KPushButton *m_btnDeleteRequiredField;
		KPushButton *m_btnDeleteOptionalField;
		KPopupMenu *m_newRequiredFieldMenu;
		KPopupMenu *m_newOptionalFieldMenu;
		
		int prevIndex;
		QString prevName;
		int newTypeCnt;
};

#endif
