/***************************************************************************
                          kbibcreatebiliographydlg  -  description
                             -------------------
    begin                : Thu Nov 25 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach@dragon.thach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbibcreatebiliographydlg.h"

#include <kiconloader.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <qcolor.h>
#include <qlayout.h>
#include <qhbox.h>

KBibCreateBiliographyDlg::KBibCreateBiliographyDlg(QWidget *parent, const char *name)
    :KDialogBase( parent, name , true, 0, KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{
  QWidget* page = new QWidget(this);
  setMainWidget(page);
  QVBoxLayout* l = new QVBoxLayout(page, 0, KDialog::spacingHint());



  label = new QLabel("Biliography Style:", page);
  l->addWidget(label);


  QHBox* box1 = new QHBox(page);
  box1->setMargin(4);
  box1->setSpacing(4);


  bibStyle = new KComboBox(false, box1);
  bibStyle->insertItem("amsalpha", -1);
  bibStyle->insertItem("amsplain", -1);
  bibStyle->insertItem("amsxport", -1);
  bibStyle->insertItem("abbrv", -1);
  bibStyle->insertItem("alpha", -1);
  bibStyle->insertItem("apalike", -1);
  bibStyle->insertItem("ieeetr", -1);
  bibStyle->insertItem("plain", -1);

  bibStyle->setEditable(true);

  browseBttn = new KPushButton("...", box1) ;
  QPixmap pix = KGlobal::iconLoader()->loadIcon(QString::fromLatin1("fileopen"), KIcon::Small);
  browseBttn->setPixmap(pix);
  browseBttn->setMinimumWidth(40);
  box1->setStretchFactor(bibStyle, 1);
  box1->setStretchFactor(browseBttn, 0);

  l->addWidget(box1);

  additionalFileLabel = new QLabel("Addtional file:", page);

  l->addWidget(additionalFileLabel);

  QHBox* box2 = new QHBox(page);
  box2->setMargin(4);
  box2->setSpacing(4);

  additionalFile = new KLineEdit(0, box2);
  additionalFile->setMinimumWidth(200);
  additionalFilebrowseBttn = new KPushButton("...", box2) ;
  additionalFilebrowseBttn->setPixmap(pix);
  additionalFilebrowseBttn->setMinimumWidth(40);
  box2->setStretchFactor(additionalFilebrowseBttn, 0);

  l->addWidget(box2);
  l->addSpacing(10);
  l->addStretch(1);


  connect(browseBttn, SIGNAL(clicked()), this, SLOT(slotBrowseBttn()) );
  connect(additionalFilebrowseBttn, SIGNAL(clicked()), this, SLOT(slotAdditionalFilebrowseBttn()) );

}


KBibCreateBiliographyDlg::~KBibCreateBiliographyDlg()
{
  delete label;
  delete browseBttn;
  delete bibStyle;
  delete additionalFileLabel;
  delete additionalFile;
  delete additionalFilebrowseBttn;
}

void KBibCreateBiliographyDlg::slotBrowseBttn()
{
  QString filter = i18n("*.bst|Biliography style files (*.bst)");


  QString fn = KFileDialog::getOpenFileName(QString::fromLatin1(":open"), filter,
               this, i18n("Open File..."));

  if (!fn.isEmpty())
  {
    bibStyle->setCurrentText(fn);
  }

}

void KBibCreateBiliographyDlg::slotAdditionalFilebrowseBttn()
{
  QString filter = i18n("*.bib|Bitex files (*.bst)");


  QString fn = KFileDialog::getOpenFileName(QString::fromLatin1(":open"), filter,
               this, i18n("Open File..."));

  if (!fn.isEmpty())
  {
    additionalFile->setText(fn);
  }

}


QString KBibCreateBiliographyDlg::getBibStyle()
{

  return bibStyle->currentText();

}

QString KBibCreateBiliographyDlg::getAdditionalFile()
{
  return (additionalFile->text()).stripWhiteSpace ();
}

KBibBiliographyDlg::KBibBiliographyDlg(QWidget *parent, const char *name):
	KDialogBase( parent, name , false, 0, KDialogBase::Ok, KDialogBase::Ok, false )
//    KDialogBase(Plain, i18n("Create Biliography"), Ok, Ok, parent,name)
{
  QWidget* page = new QWidget(this);
  setMainWidget(page);
  QVBoxLayout* l = new QVBoxLayout(page, 0, KDialog::spacingHint());

  label = new QLabel(i18n("You can copy following text into your Latex editor"), page);
  l->addWidget(label);
  textView = new QTextEdit(page);
  textView->setReadOnly(TRUE);
  textView->setColor(QColor(255,0,0));
  textView->setMinimumWidth(400);
  textView->setMinimumHeight(300);
  l->addWidget(textView);
  copyBttn = new KPushButton("Copy", page) ;
  copyBttn->setMaximumWidth(50);
  l->addWidget(copyBttn);

  //label->setGeometry(QRect(20,20, 300 , 20) );
  //textView->setGeometry(QRect(20,50, 400 , 400) );
  //copyBttn->setGeometry(QRect(20,465, 50 , 25) );

  //int x = this->x();
  //int y = this->y();

  //this->setGeometry(QRect(x,y, 450 , 500) );

  connect(copyBttn, SIGNAL(clicked()), this, SLOT(slotCopyBttn()) );


}

KBibBiliographyDlg::~ KBibBiliographyDlg()
{
  delete label;
  delete textView;
}

void KBibBiliographyDlg::setText(QString st)
{
  textView->setText(st);
}

void KBibBiliographyDlg::slotCopyBttn()
{
  textView->selectAll();
  textView->copy();
  textView->selectAll(FALSE);
}


#include "kbibcreatebiliographydlg.moc"
