
// Released under the GNU GPL v2
// Copyright (C) 2004-2006 John Eriksson

#include <iostream>
#include <stdlib.h>
#include <time.h>

#define DM_VERSION "0.1"
#define PROGRAM_NAME "decision maker"

void version()
{
	using namespace std;
	cout << PROGRAM_NAME << " " << DM_VERSION << "\n";
	exit(0);
}

void usage(char *progname)
{
	using namespace std;
	cout << "Usage: " << progname << " [OPTION]..." << endl;
	cout << "Output either 'Yes.' or 'No.' randomly";
	cout << " for help with decision making." << "\n\n";
	cout << "  -f, --full\tdisplay longer output ('Do it.')\n\n";
	cout << "  -h, --help\tdisplay this help and exit\n";
	cout << "  -v, --version\toutput version information and exit\n\n";
	cout << "Report bugs to <johne@rootlinux.org>.\n";
	exit(1);
}

int main(int argc, char *argv[])
{
	using namespace std;

	int result;  // the result variable
	bool mode = false; // output mode

	srand(time(NULL)); // srand with the output from time()
	result=(int)(2.0*rand()/(RAND_MAX)+1.0)-1; // put a one or a zero here

        if (argc > 1)
	{
		if ( strcmp(argv[1],"-h") == 0 || strcmp(argv[1],"--help") == 0 )
		{
			usage(argv[0]);
		}
		else if ( strcmp(argv[1],"-v") == 0 || strcmp(argv[1],"--version") == 0 )
		{
			version();
		}
		else if ( strcmp(argv[1],"-f") == 0 || strcmp(argv[1],"--full") == 0 )
		{
			mode = true; // set mode to true
		}
		else
		{
			cout << argv[0] << ": unknown option '" << argv[1] << "'.\n";
			cout << "try " << argv[0] << " --help for more information.\n";
			exit(1);
		}
	}

	if ( result == 0 )
	{
		if ( mode == false )
		{
			cout << "No." << endl;
		}
		else
		{
			cout << "Don't do it." << endl;
		}
	}
	else
	{
		if ( mode == false )
		{
			cout << "Yes." << endl;
		}
		else
		{
			cout << "Do it." << endl;
		}
	}
	return 0;
}
