/* Copyright (C) 1999 Thorsten Kukuk
   This file is part of the NIS+ utilities.
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef _RPCSVC_NIS_CACHE_H_
#define _RPCSVC_NIS_CACHE_H_

#include <rpc/rpc.h>

#ifdef __cplusplus
extern "C" {
#endif

#include <rpc/types.h>
#include <rpcsvc/nis.h>

#define CACHEFILE        "/var/nis/NIS_SHARED_DIRCACHE"
#define COLD_START_FILE  "/var/nis/NIS_COLD_START"
#define CACHEPROGSOCK    "/var/run/nis_cachemgrsock"

#define CACHEPROG 100301
#define CACHE_VER_1 1

#if defined(__STDC__) || defined(__cplusplus)
#define NIS_CACHE_READ_COLDSTART 3
extern  enum clnt_stat nis_cache_read_coldstart_1(void *, void *, CLIENT *);
extern  bool_t nis_cache_read_coldstart_1_svc(void *, void *, struct svc_req *);

#else /* K&R C */
#define NIS_CACHE_READ_COLDSTART 3
extern  enum clnt_stat nis_cache_read_coldstart_1();
extern  bool_t nis_cache_read_coldstart_1_svc();
#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_RPCSVC_NIS_CACHE_H_ */
