/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <mcheck.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "nis_db.h"
#include "db_private.h"

static table_obj *
create_table (void)
{
  table_obj *table = (table_obj *)malloc (sizeof (table_obj));
  table_col *tcol = malloc (sizeof (table_col) * 7);

  memset (table, '\0', sizeof(table_obj));
  memset (tcol, '\0', sizeof (table_col) * 7);

  table->ta_type = strdup ("passwd_tbl");
  table->ta_maxcol = 64;
  table->ta_sep = ':';
  table->ta_path = strdup ("foo");

  tcol[0].tc_name = strdup ("name");
  tcol[0].tc_flags = TA_SEARCHABLE | TA_CASE;
  tcol[0].tc_rights = DEFAULT_RIGHTS;

  tcol[1].tc_name = strdup ("passwd");
  tcol[1].tc_flags = TA_CASE;
  tcol[1].tc_rights = DEFAULT_RIGHTS;

  tcol[2].tc_name = strdup ("uid");
  tcol[2].tc_flags = TA_SEARCHABLE | TA_CASE;
  tcol[2].tc_rights = DEFAULT_RIGHTS;

  tcol[3].tc_name = strdup ("gid");
  tcol[3].tc_flags = TA_SEARCHABLE | TA_CASE;
  tcol[3].tc_rights = DEFAULT_RIGHTS;

  tcol[4].tc_name = strdup ("gecos");
  tcol[4].tc_flags = TA_CASE;
  tcol[4].tc_rights = DEFAULT_RIGHTS;

  tcol[5].tc_name = strdup ("home");
  tcol[5].tc_flags = TA_CASE;
  tcol[5].tc_rights = DEFAULT_RIGHTS;

  tcol[6].tc_name = strdup ("shell");
  tcol[6].tc_flags = TA_SEARCHABLE | TA_CASE;
  tcol[6].tc_rights = DEFAULT_RIGHTS;

  table->ta_cols.ta_cols_len = 7;
  table->ta_cols.ta_cols_val = tcol;

  return table;
}

static entry_obj *
create_entry (unsigned int number)
{
  entry_obj *entry;
  entry_col *col;
  char buf[1024];

  entry = (entry_obj *)calloc(1, sizeof(entry_obj));
  col = (entry_col *)calloc(1, sizeof(entry_col) * 7);

  /* Username */
  sprintf (buf, "user%.6d", number);
  col[0].ec_flags = 0;
  col[0].ec_value.ec_value_val = strdup (buf);
  col[0].ec_value.ec_value_len = strlen(col[0].ec_value.ec_value_val) + 1;

  col[1].ec_flags = 0;
  col[1].ec_value.ec_value_val = strdup ("*");
  col[1].ec_value.ec_value_len = strlen(col[1].ec_value.ec_value_val) + 1;

  /* uid */
  sprintf (buf, "%d", number);
  col[2].ec_flags = 0;
  col[2].ec_value.ec_value_val = strdup (buf);
  col[2].ec_value.ec_value_len = strlen(col[2].ec_value.ec_value_val) + 1;

  col[3].ec_flags = 0;
  col[3].ec_value.ec_value_val = strdup ("0");
  col[3].ec_value.ec_value_len = strlen(col[3].ec_value.ec_value_val) + 1;

  col[4].ec_flags = 0;
  col[4].ec_value.ec_value_val = strdup ("This is a sample account");
  col[4].ec_value.ec_value_len = strlen(col[4].ec_value.ec_value_val) + 1;

  col[5].ec_flags = 0;
  col[5].ec_value.ec_value_val = strdup ("/dev/null");
  col[5].ec_value.ec_value_len = strlen(col[5].ec_value.ec_value_val) + 1;

  col[6].ec_flags = 0;
  col[6].ec_value.ec_value_val = strdup ("/bin/false");
  col[6].ec_value.ec_value_len = strlen(col[6].ec_value.ec_value_val) + 1;

  entry->en_type = strdup ("passwd_tbl");
  entry->en_cols.en_cols_len = 7;
  entry->en_cols.en_cols_val = col;

  return entry;
}

int
main ()
{
  char *catalog_file = "list_entries";
  db_result *result;
  nis_attr *attrs;
  char buf[255];

  mtrace ();

  /* Initialize the database backend */
  if (db_initialize (catalog_file) == FALSE)
    {
      fprintf (stderr, "db_initialize (%s) failed.\n", catalog_file);
      return 1;
    }

  attrs = (nis_attr *)calloc(1, sizeof(nis_attr) * 7);

  attrs[0].zattr_ndx = "name";
  attrs[0].zattr_val.zattr_val_len = 1;
  attrs[0].zattr_val.zattr_val_val = "";

  attrs[1].zattr_ndx = "uid";
  attrs[1].zattr_val.zattr_val_len = strlen("0") + 1;
  attrs[1].zattr_val.zattr_val_val = "0";

  sprintf (buf, "table_list_entry");

  {
    db_status status;
    unsigned int j;
    table_obj *obj = create_table ();

    status = db_create_table (buf, obj);
    xdr_free ((xdrproc_t) __nisdb_xdr_table_obj, (caddr_t)obj);
    free (obj);
    if (status != DB_SUCCESS)
      {
	fprintf (stderr, "db_create_table (\"%s\") failed: %d\n", buf,
		 status);
	return 1;
      }

    for (j = 0; j < 100; ++j)
      {
	entry_obj *eobj = create_entry (j);

	result = db_add_entry (buf, 2, attrs, eobj);
	if (result->status != DB_SUCCESS)
	  {
	    fprintf (stderr, "db_add_entry (\"%s\", %d) failed: %d\n",
		     buf, j, result->status);
	    return 1;
	  }
	xdr_free ((xdrproc_t) __nisdb_xdr_entry_obj, (caddr_t)eobj);
	free (eobj);
	db_free_result (result);

      }
  }

  attrs[0].zattr_ndx = "uid";
  attrs[0].zattr_val.zattr_val_len = 2;
  attrs[0].zattr_val.zattr_val_val = "0";

  result = db_list_entries (buf, 1, attrs);
  if (result->status != DB_SUCCESS)
    {
      fprintf (stderr, "db_list_entries (\"%s\") failed: %d\n",
	       buf, result->status);
      return 1;
    }
  else if (result->objects.objects_len != 1)
    {
      fprintf (stderr, "db_list_entries: found: %d, should be: 1\n",
	       result->objects.objects_len);
      return 1;
    }
  db_free_result (result);

  free (attrs);

  db_checkpoint (buf);

  muntrace ();

  unlink ("list_entries");
  unlink ("list_entries.log");
  unlink (buf);

  return 0;
}
