/*
 * logging.c
 *
 * Simple logging functions that can be compiled away into nothing.
 *
 * Copyright (C) 2001 Greg Kroah-Hartman <greg@kroah.com>
 *
 *	This program is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by the
 *	Free Software Foundation, version 2 of the License.
 * 
 *	This program is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	General Public License for more details.
 * 
 *	You should have received a copy of the GNU General Public License along
 *	with this program; if not, write to the Free Software Foundation, Inc.,
 *	675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: logging.c,v 1.2 2001/08/29 05:18:33 kroah Exp $
 *
 */

#include <stdarg.h>
#include <syslog.h>
#include "hotplug.h"

#ifdef DEBUG

static int logging_init = 0;

static void init_logging (void)
{
	openlog ("hotplug", 0, LOG_DAEMON);
	logging_init = 1;
}

/**
 * log_message - sends a message to the logging facility
 */
int log_message (int level, const char *format, ...)
{
	va_list	args;

	if (!logging_init)
		init_logging();
	va_start (args, format);
	vsyslog (level, format, args);
	va_end (args);
	return 1;
}

#endif
