/*
 * automount.h
 *
 * Header file for automounter modules
 *
 */

#ifndef AUTOMOUNT_H
#define AUTOMOUNT_H

#include <paths.h>

#ifndef _PATH_MOUNT
#define _PATH_MOUNT "/bin/mount"
#endif
#ifndef _PATH_UMOUNT
#define _PATH_UMOUNT "/bin/umount"
#endif

/* Standard function used by modules */

int spawnl(char *, ...);


/* Prototype for module functions */

#define AUTOFS_LOOKUP_VERSION 1
#ifndef IN_DAEMON
int lookup_init(int, char **);
int lookup_mount(char *, char *, int);
int lookup_done(void);
#endif

#endif
