#| twm theme.jl

   Copyright (c) 1999-2000 John Harper <john@dcs.warwick.ac.uk>

   $Id: theme.jl,v 1.1 2000/07/03 14:58:57 john Exp $

   Requires sawfish 0.30 upwards (in gdk-pixbuf mode?)
|#

(defgroup twm-style "TWM style" :group appearance)

(defcustom twm:title-color (get-color "mediumvioletred")
  "Title color"
  :group (appearance twm-style)
  :type color
  :after-set (lambda () (rebuild-images) (after-setting-frame-option)))

(defcustom twm:frame-color (get-color "cadetblue")
  "Frame color"
  :group (appearance twm-style)
  :type color
  :after-set after-setting-frame-option)

(defcustom twm:text-color (get-color "black")
  "Text color"
  :group (appearance twm-style)
  :type color
  :after-set (lambda () (rebuild-images) (after-setting-frame-option)))

(define stipple-i (make-sized-image 32 32))

(define h-stipple-i (make-sized-image 32 2))

(define v-stipple-i (make-sized-image 2 32))

(define button-i (list (make-image "button.png") nil
		       nil (make-image "button-c.png")))

(define (h-stipple) (list h-stipple-i twm:frame-color))
(define (v-stipple) (list v-stipple-i twm:frame-color))

(define (hashed-offset w) (+ (text-width (window-name w)) 24))

(define (rebuild-images)
  (let* ((fg-pixel (nconc (color-rgb-8 twm:text-color) '(255)))
	 (col-white-map
	  (vector (nconc (color-rgb-8 twm:title-color) '(255)) fg-pixel)))

    (define (black-white x y)
      (aref [(255 255 255 255) (0 0 0 255)] (logand (logxor x y) 1)))
 
    (define (color-white x y)
      (aref col-white-map (logand (logxor x y) 1)))

    (define (solid->text pixel) (and (> (nth 3 pixel) 0) fg-pixel))
    
    (image-fill black-white h-stipple-i)
    (image-fill black-white v-stipple-i)
    (image-fill color-white stipple-i)

    (mapc (lambda (x)
	    (when x
	      (image-map solid->text x))) button-i)))

(define (update w)
  (if (eq (window-get w 'current-frame-style) 'twm)
      (rebuild-frame w)))

(define frame `(((foreground . ,(lambda () twm:text-color))
	       (background . ,(lambda () twm:title-color))
	       (text . ,window-name)
	       (x-justify . 20)
	       (y-justify . center)
	       (left-edge . 0)
	       (right-edge . 0)
	       (top-edge . -20)
	       (height . 18)
	       (class . title))
	      ((background . ,(lambda () twm:title-color))
	       (foreground . ,button-i)
	       (left-edge . 2)
	       (top-edge . -18)
	       (width . 14)
	       (height . 14)
	       (class . menu-button))
	      ((background . ,(lambda () (list twm:title-color stipple-i)))
	       (right-edge . 2)
	       (left-edge . ,hashed-offset)
	       (top-edge . -18)
	       (height . 14)
	       (class . title))
	      ((background . ,h-stipple)
	       (left-edge . 0)
	       (right-edge . 0)
	       (top-edge . -22)
	       (height . 2)
	       (class . top-border))
	      ((background . ,h-stipple)
	       (left-edge . 0)
	       (right-edge . 0)
	       (top-edge . -2)
	       (height . 2))
	      ((background . ,h-stipple)
	       (left-edge . 0)
	       (right-edge . 0)
	       (bottom-edge . -2)
	       (height . 2)
	       (class . bottom-border))
	      ((background . ,v-stipple)
	       (left-edge . -2)
	       (width . 2)
	       (top-edge . -22)
	       (bottom-edge . -2)
	       (class . left-border))
	      ((background . ,v-stipple)
	       (right-edge . -2)
	       (width . 2)
	       (top-edge . -22)
	       (bottom-edge . -2)
	       (class . right-border))))

(define shaped-frame `(((foreground . ,(lambda () twm:title-color))
		      (background . ,(lambda () twm:title-color))
		      (text . ,window-name)
		      (x-justify . 32)
		      (y-justify . center)
		      (left-edge . 0)
		      (right-edge . 0)
		      (top-edge . -20)
		      (height . 18)
		      (class . title))
		     ((background . ,(lambda ()
				       (list twm:title-color stipple-i)))
		      (right-edge . 32)
		      (left-edge . ,hashed-offset)
		      (top-edge . -18)
		      (height . 14)
		      (class . title))
		     ((background . ,h-stipple)
		      (left-edge . 0)
		      (right-edge . 0)
		      (top-edge . -22)
		      (height . 2)
		      (class . top-border))
		     ((background . ,h-stipple)
		      (left-edge . 0)
		      (right-edge . 0)
		      (top-edge . -2)
		      (height . 2))
		     ((background . ,v-stipple)
		      (left-edge . -2)
		      (width . 2)
		      (top-edge . -22)
		      (height . 22)
		      (class . left-border))
		     ((background . ,v-stipple)
		      (right-edge . -2)
		      (width . 2)
		      (top-edge . -22)
		      (height . 22)
		      (class . right-border))))

(define transient-frame `(((background . ,h-stipple)
			 (left-edge . 0)
			 (right-edge . 0)
			 (top-edge . -2)
			 (height . 2)
			 (class . title))
			((background . ,h-stipple)
			 (left-edge . 0)
			 (right-edge . 0)
			 (bottom-edge . -2)
			 (height . 2)
			 (class . bottom-border))
			((background . ,v-stipple)
			 (left-edge . -2)
			 (width . 2)
			 (top-edge . -2)
			 (bottom-edge . -2)
			 (class . left-border))
			((background . ,v-stipple)
			 (right-edge . -2)
			 (width . 2)
			 (top-edge . -2)
			 (bottom-edge . -2)
			 (class . right-border))))

(define shaped-transient-frame `(((background . ,h-stipple)
				(left-edge . 0)
				(right-edge . 0)
				(top-edge . -2)
				(height . 2)
				(class . title))))

(mapc (lambda (i)
	(image-put i 'tiled t))
      (list stipple-i h-stipple-i v-stipple-i))

(add-frame-style 'twm
		 (lambda (w type)
		   (case type
		     ((default) frame)
		     ((unframed) nil-frame)
		     ((transient) transient-frame)
		     ((shaped-transient) shaped-transient-frame)
		     ((shaped) shaped-frame))))

(rebuild-images)
(call-after-property-changed 'WM_NAME update)
