/* arch-tag: 4c90aaf8-a5c0-49fb-9fdc-305380d48923 */

/*  eXperience GTK engine: match.c
 *  
 *  Copyright (C) 2004-2005  Benjamin Berg <benjamin@sipsolutions.net>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "match.h"

void
experience_match_init (eXperienceMatch * match)
{
	g_assert (match != NULL);
	match->flags = MATCH_NONE;
	match->details = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL);
	
	/* no other initialization needed here. */
}

void
experience_match_finalize (eXperienceMatch * match)
{
	g_assert(match != NULL);
	
	g_hash_table_destroy(match->details);
}

void
experience_match_add_states (eXperienceMatch * match, GtkStateType state)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_STATE;
	match->state = state;
}

void
experience_match_add_functions (eXperienceMatch * match, GtkDrawingFunctions functions)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_FUNCTION;
	match->functions = functions;
}

void
experience_match_add_detail (eXperienceMatch * match, gchar * detail)
{
	g_assert (match != NULL);
	g_assert (detail != NULL);
	
	match->flags |= MATCH_DETAIL;
	
	g_hash_table_insert (match->details, detail, GINT_TO_POINTER(TRUE));
}

void
experience_match_add_has_default (eXperienceMatch * match, gboolean has_default)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_HAS_DEFAULT;
	match->has_default |= has_default ? EXPERIENCE_TRUE : EXPERIENCE_FALSE;
}

void
experience_match_add_has_focus (eXperienceMatch * match, gboolean has_focus)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_HAS_FOCUS;
	match->has_focus |= (has_focus ? EXPERIENCE_TRUE : EXPERIENCE_FALSE);
}

void
experience_match_add_shadows (eXperienceMatch * match, GtkShadowType shadow)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_SHADOW;
	match->shadow = shadow;
}

void
experience_match_add_arrow_directions (eXperienceMatch * match, GtkArrowType arrow_direction)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_ARROW_DIRECTION;
	match->arrow_direction = arrow_direction;
}

void
experience_match_add_orientations (eXperienceMatch * match, GtkOrientation orientation)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_ORIENTATION;
	match->orientation = orientation;
}

void
experience_match_add_gap_sides (eXperienceMatch * match, GtkPositionType gap_side)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_GAP_SIDE;
	match->gap_side = gap_side;
}

void
experience_match_add_expander_styles (eXperienceMatch * match, GtkExpanderStyle expander_style)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_EXPANDER_STYLE;
	match->expander_style = expander_style;
}

void
experience_match_add_window_edges (eXperienceMatch * match, GdkWindowEdge window_edge)
{
	g_assert (match != NULL);
	
	match->flags |= MATCH_WINDOW_EDGE;
	match->window_edge = window_edge;
}

/* ---- */

static void
copy_detail_keys (gchar * key, gpointer dummy, GHashTable * dest)
{
	g_hash_table_insert (dest, g_strdup(key), GINT_TO_POINTER(TRUE));
}

void
experience_match_inherit (eXperienceMatch * match, eXperienceMatch * from)
{
	if (!(match->flags & MATCH_STATE))       match->state       = from->state;
	if (!(match->flags & MATCH_FUNCTION))    match->functions   = from->functions;
	if (!(match->flags & MATCH_HAS_FOCUS))   match->has_focus   = from->has_focus;
	if (!(match->flags & MATCH_HAS_DEFAULT)) match->has_default = from->has_default;
	
	if (!(match->flags & MATCH_DETAIL)) {
		g_hash_table_foreach (from->details, (GHFunc) copy_detail_keys, match->details);
	}
	
	if (!(match->flags & MATCH_SHADOW))          match->shadow         = from->shadow;
	if (!(match->flags & MATCH_ARROW_DIRECTION)) match->arrow_direction= from->arrow_direction;
	if (!(match->flags & MATCH_ORIENTATION))     match->orientation    = from->orientation;
	if (!(match->flags & MATCH_GAP_SIDE))        match->gap_side       = from->gap_side;
	if (!(match->flags & MATCH_EXPANDER_STYLE))  match->expander_style = from->expander_style;
	if (!(match->flags & MATCH_WINDOW_EDGE))     match->window_edge    = from->window_edge;
	
	match->flags = match->flags | from->flags;
}

gboolean
experience_match (eXperienceMatch * match, eXperienceMatchTemp * to)
{
	eXperienceMatchFlags flags;
	g_assert (match != NULL);
	g_assert (to != NULL);
	flags = match->flags & to->flags;
	
	if (flags & MATCH_STATE)
		if (!(match->state & to->state)) return FALSE;
	if (flags & MATCH_FUNCTION)
		if (!(match->functions & to->function)) return FALSE;
	if (flags & MATCH_HAS_FOCUS) {
		if (to->has_focus) {
			if (!(match->has_focus & EXPERIENCE_TRUE))  return FALSE;
		} else {
			if (!(match->has_focus & EXPERIENCE_FALSE)) return FALSE;
		}
	}
	if (flags & MATCH_HAS_DEFAULT) {
		if (to->has_default) {
			if (!(match->has_default & EXPERIENCE_TRUE))  return FALSE;
		} else {
			if (!(match->has_default & EXPERIENCE_FALSE)) return FALSE;
		}
	}
	if (flags & MATCH_SHADOW)
		if (!(match->shadow & to->shadow)) return FALSE;
	if (flags & MATCH_ARROW_DIRECTION)
		if (!(match->arrow_direction & to->arrow_direction)) return FALSE;
	if (flags & MATCH_ORIENTATION)
		if (!(match->orientation & to->orientation)) return FALSE;
	if (flags & MATCH_GAP_SIDE)
		if (!(match->gap_side & to->gap_side)) return FALSE;
	if (flags & MATCH_EXPANDER_STYLE)
		if (!(match->expander_style & to->expander_style)) return FALSE;
	if (flags & MATCH_WINDOW_EDGE)
		if (!(match->window_edge & to->window_edge)) return FALSE;
	if (flags & MATCH_DETAIL)
		if (to->detail != NULL)
			if (GPOINTER_TO_INT(g_hash_table_lookup(match->details, to->detail)) != TRUE) return FALSE;

	return TRUE;
}
