/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __YELP_VIEW_HOME_H__
#define __YELP_VIEW_HOME_H__

#include <gtk/gtktreemodel.h>
#include <libgtkhtml/gtkhtml.h>
#include "yelp-section.h"

#define YELP_TYPE_VIEW_HOME    (yelp_view_home_get_type ())
#define YELP_VIEW_HOME(o)      (GTK_CHECK_CAST ((o), YELP_TYPE_VIEW_HOME, YelpViewHome))
#define YELP_VIEW_HOME_CLASS(k)(GTK_CHECK_FOR_CAST((k), YELP_TYPE_VIEW_HOME, YelpViewHomeClass))
#define YELP_IS_VIEW_HOME(o)       (GTK_CHECK_TYPE ((o), YELP_TYPE_VIEW_HOME))
#define YELP_IS_VIEW_HOME_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), YELP_TYPE_VIEW_HOME))

typedef struct _YelpViewHome        YelpViewHome;
typedef struct _YelpViewHomeClass   YelpViewHomeClass;
typedef struct _YelpViewHomePriv    YelpViewHomePriv;

struct _YelpViewHome {
	HtmlView          parent;

	YelpViewHomePriv *priv;
};

struct _YelpViewHomeClass {
	HtmlViewClass parent_class;

	/* Signals */
	
	void (*path_selected)   (YelpViewHome   *view,
				 GtkTreePath    *path);
};

GType           yelp_view_home_get_type       (void);
GtkWidget      *yelp_view_home_new            (GtkTreeModel *tree_model);

#endif /* __YELP_VIEW_HOME__ */
