/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "xchat.h"
#include "gtkutil.h"
#include <signal.h>


extern GSList *url_list;
extern char *nocasestrstr (char *, char *);


GtkWidget *urlgrabberwindow = 0;
GtkWidget *urlgrabberlist;
void url_addurlgui (char *urltext);


int 
url_closegui (void)
{
   urlgrabberwindow = 0;
   return 0;
}

void 
url_button_sendlynx (void)
{
   int row;
   char *url;
   char buf[256];

   row = gtkutil_clist_selection (urlgrabberlist);
   if (row == -1)
      return;
   gtk_clist_get_text (GTK_CLIST (urlgrabberlist), row, 0, &url);
   snprintf (buf, 256, "xterm -e lynx %s", url);
   popen (buf, "r");
}

void 
url_button_send (void)
{
   int row;
   char *url;
   char buf[256];

   row = gtkutil_clist_selection (urlgrabberlist);
   if (row == -1)
      return;
   gtk_clist_get_text (GTK_CLIST (urlgrabberlist), row, 0, &url);
   snprintf (buf, 256, "netscape -remote 'openURL(%s)'", url);
   popen (buf, "r");
}

void 
url_button_clear (void)
{
   while (url_list)
   {
      free (url_list->data);
      url_list = g_slist_remove (url_list, url_list->data);
   }
   gtk_clist_clear (GTK_CLIST (urlgrabberlist));
}

void 
url_save_callback (GtkWidget * b, GtkWidget * d)
{
   FILE *fd;
   GSList *list;
   char *f;

   f = gtk_file_selection_get_filename (GTK_FILE_SELECTION (d));

   if (f)
   {
      fd = fopen (f, "w");
      if (fd == NULL)
         return;
      list = url_list;
      while (list)
      {
         fprintf (fd, "%s\n", (char *) list->data);
         list = list->next;
      }
      fclose (fd);
   }
   gtk_widget_destroy (d);
}

void 
url_save_cancel (GtkWidget * b, GtkWidget * d)
{
   gtk_widget_destroy (d);
}

void 
url_button_save (void)
{
   GtkWidget *d;

   d = gtk_file_selection_new ("Select a file to save to");

   gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (d)->cancel_button),
                       "clicked", (GtkSignalFunc) url_save_cancel, (gpointer) d);
   gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (d)->ok_button),
                       "clicked", (GtkSignalFunc) url_save_callback, (gpointer) d);
   gtk_widget_show (d);
}

void 
url_opengui ()
{
   GtkWidget *vbox, *hbox;

   if (urlgrabberwindow)
   {
      gtk_widget_destroy (urlgrabberwindow);
      return;
   }
   urlgrabberwindow = gtkutil_window_new ("X-Chat: URL Grabber", "urlgrabber", 350, 100,
                     url_closegui, 0);

   vbox = gtk_vbox_new (FALSE, 1);
   gtk_container_add (GTK_CONTAINER (urlgrabberwindow), vbox);
   gtk_container_set_border_width (GTK_CONTAINER (vbox), 4);
   gtk_widget_show (vbox);

   urlgrabberlist = gtkutil_clist_new (1, 0, vbox, GTK_POLICY_AUTOMATIC,
                                 0, 0,
          0, 0, GTK_SELECTION_BROWSE);
   gtk_widget_set_usize (urlgrabberlist, 350, 0);
   gtk_clist_set_column_width (GTK_CLIST (urlgrabberlist), 0, 100);

   hbox = gtk_hbox_new (FALSE, 1);
   gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 2);
   gtk_widget_show (hbox);

   gtkutil_button_new ("Clear", 0, 0, url_button_clear, 0, hbox);
#ifdef USE_GNOME
   gtkutil_stock_button (urlgrabberwindow, GNOME_STOCK_PIXMAP_FORWARD,
                         "Lynx", url_button_sendlynx, 0, hbox);
   gtkutil_stock_button (urlgrabberwindow, GNOME_STOCK_PIXMAP_FORWARD,
                         "Netscape", url_button_send, 0, hbox);
#else
   gtkutil_button_new ("-> Lynx", 0, 0, url_button_sendlynx, 0, hbox);
   gtkutil_button_new ("-> Netscape", 0, 0, url_button_send, 0, hbox);
#endif
   gtkutil_button_new ("Save", 0, 0, url_button_save, 0, hbox);

   gtk_widget_show (urlgrabberwindow);

   {
      GSList *list = url_list;
      while (list)
      {
         url_addurlgui ((char *) list->data);
         list = list->next;
      }
   }
}

void 
url_addurlgui (char *urltext)
{
   if (urlgrabberwindow)
      gtk_clist_append ((GtkCList *) urlgrabberlist, &urltext);
}

int 
url_findurl (char *urltext)
{
   GSList *list = url_list;
   while (list)
   {
      if (!strcasecmp (urltext, (char *) list->data))
         return 1;
      list = list->next;
   }
   return 0;
}

void 
url_addurl (char *urltext)
{
   char *data = strdup (urltext);
   if (!data)
      return;

   if (data[strlen (data) - 1] == '.')  /* chop trailing dot */
      data[strlen (data) - 1] = 0;

   if (url_findurl (data))
      return;

   url_list = g_slist_append (url_list, data);
   url_addurlgui (data);
}

void 
url_checkurl (char *buf)
{
   char *po, *urltext = nocasestrstr (buf, "http:");
   if (!urltext)
      urltext = nocasestrstr (buf, "www.");
   if (!urltext)
      urltext = nocasestrstr (buf, "ftp.");
   if (!urltext)
      urltext = nocasestrstr (buf, "ftp:");
   if (urltext)
   {
      po = strchr (urltext, ' ');
      if (po)
      {
         char t;
         t = *po;
         *po = 0;
         url_addurl (urltext);
         *po = t;
      } else
         url_addurl (urltext);
   }
}
