/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "style.h"
#include "xchat.h"
#include "gtkutil.h"
#include <time.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include "dcc.h"
#include "util.h"
#include "menu.h"
#ifdef USE_GNOME
#include <zvt/zvtterm.h>
#endif

extern gushort rxvt_red[];
extern gushort rxvt_blu[];
extern gushort rxvt_grn[];
extern GSList *sess_list;
extern struct xchatprefs prefs;
extern GdkFont *dialog_font_normal;
extern GdkFont *dialog_font_bold;
extern GdkColor colors[];
extern GtkStyle *channelwin_style;
extern GtkStyle *dialogwin_style;
extern GtkWidget *main_window;
extern GtkWidget *main_book;
extern GtkStyle *greentab_style;
extern struct session *current_tab;
extern struct session *menu_sess;
extern GtkStyle *normaltab_style;

#ifdef USE_GNOME
extern void createmenus(void *app, struct session *sess);
#else
extern GtkWidget *createmenus(struct session *sess);
#endif
extern void zvt_clear(GtkWidget *wid);
extern void gui_set_title(struct session *sess);
extern void menu_popup(struct session *sess, GdkEventButton *event, char *nick);
extern void show_and_unfocus(GtkWidget *wid);
extern void term_change_pos(GtkWidget *widget);
extern void add_tip(GtkWidget *wid, char *text);
extern void maingui_panelize(GtkWidget *button, struct session *sess);
extern void maingui_unpanelize(GtkWidget *button, struct session *sess);
extern int textgad_get_focus_cb(GtkWidget* wid, GdkEventKey* event, struct session* sess);
extern int tcp_send_len(struct server *serv, char *buf, int len);
extern int tcp_send(struct server *serv, char *buf);
extern int handle_command(char *cmd, struct session *sess, int history, int);
extern unsigned char *strip_color(unsigned char *text);
extern void end_logging (int fd);
extern int open_log_file (char *servname, char *channame);
struct session *new_dialog(struct session *sess);
extern void PrintTextRaw(GtkWidget *textwidget, unsigned char *text, char, char, GdkFont *normal, GdkFont *bold);
extern void PrintTextRawZvt(GtkWidget *textwidget, unsigned char *text);
extern void zvt_set_style(GtkWidget *zvt, char *bg_pic, int trans, int tint,
		   GdkFont *norm_font, GdkFont *bold_font);
extern void dcc_send(struct session *sess, char *tbuf, char *to, char *file);
extern int relink_window (GtkWidget *w, struct session *sess);
extern void handle_inputgad(GtkWidget *igad, struct session *sess);
extern gint kill_session_callback(GtkWidget *win, struct session *sess);
extern void gui_new_tab(GtkWidget *widget, GtkNotebookPage *nbpage, guint page);
extern void focus_in(GtkWindow *win, GtkWidget *wid, struct session *sess);

#ifdef USE_GNOME
void dialog_dnd_drop (GtkWidget *widget, GdkDragContext *context, gint x,
			gint y, GtkSelectionData *selection_data, guint info,
			guint32 time, struct session *sess)
{
   GList  *list = NULL;
   char *file, tbuf[1024];

   if (!sess->channel[0])
      return;

   list = gnome_uri_list_extract_filenames(selection_data->data);
   while (list) {
      file = (char *) (list->data);
      dcc_send(sess, tbuf, sess->nick, file);
      list = list->next;
   }
   gnome_uri_list_free_strings(list);
}
#endif

struct session *find_dialog(struct server *serv, char *nick)
{
   GSList *list = sess_list;
   struct session *sess;

   while(list)
   {
      sess = (struct session *)list -> data;
      if(sess->server == serv && sess->is_dialog)
      {
	 if(!strcasecmp(nick, sess->channel)) return(sess);
      }
      list = list -> next;
   }
   return 0;
}

void dialog_change_nick(struct server *serv, char *nick, char *newnick)
{
   struct session *sess = find_dialog(serv, nick);
   if(sess)
   {
      strcpy(sess->channel, newnick);
      if (!sess->is_tab)
         gtk_window_set_title(GTK_WINDOW(sess->window), newnick);
   }
}

void dialog_whois(GtkWidget *wid, struct session *sess)
{
   char tbuf[256];
   snprintf(tbuf, sizeof(tbuf), "WHOIS %s\r\n", sess->channel);
   tcp_send(sess->server, tbuf);
}

void dialog_send(GtkWidget *wid, struct session *sess)
{
   if (sess)
      dcc_send_filereq(sess, sess->channel);
}

void dialog_ping(GtkWidget *wid, struct session *sess)
{
   if(sess->server->connected)
   {
      char tbuf[256];
      unsigned long tim;
      struct timeval timev;

      gettimeofday(&timev, 0);
      tim = (timev.tv_sec - 50000) * 1000000 + timev.tv_usec;

      snprintf(tbuf, sizeof(tbuf), "PRIVMSG %s :\001PING %lu\001\r\n", sess->channel, tim);
      tcp_send(sess->server, tbuf); 
   }
}

void dialog_clear(GtkWidget *wid, struct session *sess)
{
   if(sess->zvt)
     zvt_clear(sess->textgad);
   else
     gtk_text_backward_delete((GtkText *)sess->textgad,
			      gtk_text_get_length((GtkText *)sess->textgad));
}

int close_dialog(GtkWidget *wid, struct session *sess)
{
   gtk_signal_disconnect_by_data(GTK_OBJECT(sess->window), sess);
   gtk_widget_destroy(sess->window);
     
   return 0;
}

/* this server is being removed, close all dialogs associated with it */

void dialog_notify_kill(struct server *serv)
{
   GSList *list = sess_list;
   struct session *sess;

   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->server == serv && sess->is_dialog) {
	 gtk_signal_disconnect_by_data(GTK_OBJECT(sess->window), sess);
	 gtk_widget_destroy(sess->window);
	 close_dialog(0, sess);
	 dialog_notify_kill(serv);
	 return;
      }
      list = list -> next;
   }
}

void dialog_click(GtkWidget *widget, GdkEventButton *even, struct session *sess)
{
   if (!even)
      return;
   if(even->button == 3)
      menu_popup(sess, even, sess->channel);
}

#ifdef USE_GNOME
static GtkTargetEntry dnd_targets[] = {
     { "text/uri-list", 0, 1 }
};
#endif

void open_dialog_window(struct session *sess)
{
   GtkWidget *hbox, *vbox, *wid;
   int	page = prefs.privmsgtab;
   
   if (!main_book)
      page = 0;
   if (!page) {
#ifdef USE_GNOME
      sess->window = gnome_app_new("X-Chat", sess->channel);
      gtk_signal_connect((GtkObject *)sess->window, "destroy",
      		GTK_SIGNAL_FUNC(kill_session_callback), sess);
#else
      sess->window = gtkutil_window_new(sess->channel, "X-Chat", 300, 100,
					kill_session_callback, sess);
#endif
      gtk_signal_connect ((GtkObject *)sess->window, "focus_in_event",
      	GTK_SIGNAL_FUNC(focus_in), sess);
      gtk_window_set_policy((GtkWindow *)sess->window, TRUE, TRUE, FALSE);
      sess->is_tab = FALSE;
   }
   else {
      sess->window = gtk_hbox_new(0, 0);
      sess->is_tab = TRUE;
   }
   vbox = gtk_vbox_new(0, 0);
   sess->vbox = vbox;
   gtk_container_set_border_width(GTK_CONTAINER(vbox), 2);

   if (!page) {
#ifdef USE_GNOME
      gnome_app_set_contents(GNOME_APP(sess->window), vbox);
#else
      gtk_container_add(GTK_CONTAINER(sess->window), vbox);
#endif
   } else
      gtk_container_add(GTK_CONTAINER(sess->window), vbox);
   if (page) {
         sess->changad = gtk_label_new(sess->channel);
         gtk_notebook_append_page(GTK_NOTEBOOK(main_book), sess->window, sess->changad);
         gtk_widget_show(sess->window);
   }
   else
      sess->changad = NULL;
   gtk_widget_show(vbox);
   
   if(page)
   {
      gtk_signal_connect((GtkObject *)sess->window, "destroy",
			 GTK_SIGNAL_FUNC(kill_session_callback), sess);
   }
   hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(hbox), 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 2);
   gtk_widget_show(hbox);

#ifdef USE_GNOME
      wid = gtkutil_stock_button(sess->window, GNOME_STOCK_BUTTON_CANCEL,
				0, gtkutil_destroy_window, sess, 0);
      gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
      gtk_widget_show(wid);
#else
      wid = gtk_button_new_with_label("X");
      gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
      gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(gtkutil_destroy_window), sess);
      gtk_widget_show(wid);
#endif
      add_tip(wid, "Close Dialog");
#ifdef USE_GNOME
      wid = gtkutil_stock_button(sess->window, GNOME_STOCK_BUTTON_UP,
				 0, relink_window, sess, 0);
      gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
#else
      wid = gtk_button_new_with_label("^");
      gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
      gtk_signal_connect(GTK_OBJECT(wid), "clicked",
       	GTK_SIGNAL_FUNC(relink_window), sess);
#endif
      add_tip(wid, "Link/DeLink this tab");
   gtk_widget_show(wid);

#ifdef USE_PANEL
   wid = gtkutil_stock_button(sess->window, GNOME_STOCK_BUTTON_DOWN,
			      0, maingui_panelize, sess, 0);
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   add_tip(wid, "Panelize");
#endif

   wid = gtk_button_new_with_label("WhoIs");
   gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_whois), sess);
   gtk_widget_show(wid);
   
   wid = gtk_button_new_with_label("Send");
   gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_send), sess);
   gtk_widget_show(wid);

   sess->topicgad = gtk_entry_new();
   gtk_entry_set_editable((GtkEntry *)sess->topicgad, FALSE);
   gtk_container_add(GTK_CONTAINER(hbox), sess->topicgad);
   gtk_widget_show(sess->topicgad);

   wid = gtk_button_new_with_label("Ping");
   gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_ping), sess); 
   gtk_widget_show(wid);

   wid = gtk_button_new_with_label("Clear");
   gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_clear), sess);
   gtk_widget_show(wid);

   hbox = gtk_hbox_new(FALSE, 0);
   sess->leftpane = hbox;
   gtk_container_add(GTK_CONTAINER(vbox), hbox);
   gtk_widget_show(hbox);

#ifdef USE_GNOME
   if(prefs.dialog_zvt)
   {
      sess->zvt = TRUE;
      sess->textgad = zvt_term_new();
      gtk_signal_connect (GTK_OBJECT(sess->textgad), "key_press_event",
			  GTK_SIGNAL_FUNC(textgad_get_focus_cb), sess);
      if(sess->is_tab)
	gtk_signal_connect_object(GTK_OBJECT(main_window),"configure_event",
				  GTK_SIGNAL_FUNC(term_change_pos),
				  GTK_OBJECT(sess->textgad));
      else
	gtk_signal_connect_object(GTK_OBJECT(sess->window),"configure_event",
				  GTK_SIGNAL_FUNC(term_change_pos),
				  GTK_OBJECT(sess->textgad));
      gtk_widget_set_usize(sess->textgad,
			   prefs.mainwindow_width-115,
			   prefs.mainwindow_height-105);
      zvt_term_set_scrollback((ZvtTerm*)sess->textgad, prefs.zvt_lines);
      zvt_set_style(sess->textgad, prefs.background_dialog, prefs.dialog_transparent,
		    prefs.dialog_tint, dialog_font_normal, dialog_font_bold);
      gtk_container_add(GTK_CONTAINER(hbox), sess->textgad);
      gtk_widget_show(sess->textgad);

      sess->vscrollbar = gtk_vscrollbar_new (((ZvtTerm*)sess->textgad)->adjustment);
      gtk_box_pack_start(GTK_BOX(hbox), sess->vscrollbar, FALSE, FALSE, 0);
      show_and_unfocus(sess->vscrollbar);
   } else {
#endif
      sess->textgad = gtk_text_new(0, 0);
      gtk_signal_connect (GTK_OBJECT(sess->textgad), "key_press_event",
			  GTK_SIGNAL_FUNC(textgad_get_focus_cb), sess);
      gtk_signal_connect(GTK_OBJECT(sess->textgad), "button_press_event",
			 GTK_SIGNAL_FUNC(dialog_click), sess);
      gtk_widget_set_style(sess->textgad, dialogwin_style);
      gtk_text_set_word_wrap(GTK_TEXT(sess->textgad), TRUE);
      gtk_container_add(GTK_CONTAINER(hbox), sess->textgad);
#ifdef USE_GNOME
      gtk_drag_dest_set(sess->textgad, GTK_DEST_DEFAULT_ALL, dnd_targets, 1,
             GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
      gtk_signal_connect(GTK_OBJECT(sess->textgad), "drag_data_received",
             GTK_SIGNAL_FUNC(dialog_dnd_drop), sess);
#endif
      gtk_widget_show(sess->textgad);
   
      wid = gtk_vscrollbar_new(GTK_TEXT(sess->textgad)->vadj);
      gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
      gtk_widget_show(wid);
#ifdef USE_GNOME
   }
#endif

   gtk_widget_realize(sess->textgad);

   sess->inputgad = gtk_entry_new_with_max_length( 2048 );
   gtk_box_pack_end(GTK_BOX(vbox), sess->inputgad, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(sess->inputgad), "activate",
		      GTK_SIGNAL_FUNC(handle_inputgad), sess);
   gtk_signal_connect(GTK_OBJECT(sess->inputgad), "key_press_event",
		      GTK_SIGNAL_FUNC(history_keypress), &sess->history);
   gtk_widget_show(sess->inputgad);

   if (!page) {
/*#ifdef USE_GNOME
      createmenus(GNOME_APP(sess->window), sess);
      sess->menu = GNOME_APP(sess->window)->menubar;
#else
      wid = createmenus(sess);
      gtk_box_pack_start(GTK_BOX(sess->vbox), wid, FALSE, FALSE, 0);
      gtk_box_reorder_child(GTK_BOX(sess->vbox), wid, 0);
      gtk_widget_show(wid);
      sess->menu = wid;
#endif*/
      gtk_widget_show(sess->window);
   } else {
      if (prefs.newtabstofront) {
	 while(gtk_events_pending()) gtk_main_iteration();
         page = gtk_notebook_page_num(GTK_NOTEBOOK(main_book), sess->window);
         gtk_notebook_set_page(GTK_NOTEBOOK(main_book), page);
         gtk_widget_grab_focus(sess->inputgad);
	 current_tab = sess;
	 menu_sess = sess;
	 sess->server->front_session = sess;
	 sess->nick_said = FALSE;
	 sess->new_data = FALSE;
	 gtk_widget_set_style(sess->changad, normaltab_style);
      } else
         sess->new_data = TRUE;
   }

#ifdef USE_GNOME
   if(prefs.dialog_zvt)
   {
      zvt_term_set_color_scheme ((ZvtTerm*)sess->textgad, rxvt_red, rxvt_grn, rxvt_blu);
      gtk_widget_hide(sess->textgad);
      gtk_widget_show(sess->textgad);
   }
#endif
   gui_set_title(sess);
}

struct session *new_dialog(struct session *sess)
{
   if (prefs.logging)
   	sess->logfd = open_log_file(sess->server->servername, sess->channel);
   else
   	sess->logfd = -1;
   open_dialog_window(sess);
   sess->new_data = FALSE;

   return(sess);
}
