/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;
typedef struct _ValaTypeRegisterFunctionPrivate ValaTypeRegisterFunctionPrivate;
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
typedef struct _ValaParamSpecTypeRegisterFunction ValaParamSpecTypeRegisterFunction;

struct _ValaTypeRegisterFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaTypeRegisterFunctionPrivate * priv;
};

struct _ValaTypeRegisterFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (ValaTypeRegisterFunction *self);
	ValaTypeSymbol* (*get_type_declaration) (ValaTypeRegisterFunction* self);
	char* (*get_type_struct_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_instance_struct_size) (ValaTypeRegisterFunction* self);
	char* (*get_instance_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_parent_type_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_init_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_peek_pointer_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_free_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_copy_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_lcopy_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_collect_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_type_flags) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_declaration) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_statements) (ValaTypeRegisterFunction* self);
	ValaSymbolAccessibility (*get_accessibility) (ValaTypeRegisterFunction* self);
};

struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* source_declaration_fragment;
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
	ValaCodeContext* _context;
};

struct _ValaParamSpecTypeRegisterFunction {
	GParamSpec parent_instance;
};


static gpointer vala_typeregister_function_parent_class = NULL;

gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
#define VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPEREGISTER_FUNCTION_DUMMY_PROPERTY
};
ValaCodeContext* vala_typeregister_function_get_context (ValaTypeRegisterFunction* self);
ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self);
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_base_finalize_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_class_finalize_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin);
static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_class_finalize_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_source_declaration (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self);
static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self);
ValaTypeRegisterFunction* vala_typeregister_function_construct (GType object_type);
void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value);
static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj);



static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin) {
	gboolean use_thread_safe;
	gboolean fundamental;
	ValaTypeSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp1_;
	gboolean _tmp2_;
	char* _tmp4_;
	ValaTypeSymbol* _tmp3_;
	char* _tmp5_;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeFunction* fun;
	char* type_value_table_decl_name;
	ValaCCodeBlock* type_init;
	ValaTypeSymbol* _tmp41_;
	gboolean _tmp42_;
	ValaCCodeFragment* _tmp57_;
	gboolean _tmp58_;
	ValaCCodeFunctionCall* reg_call;
	ValaTypeSymbol* _tmp73_;
	gboolean _tmp74_;
	ValaCCodeConstant* _tmp93_;
	char* _tmp92_;
	char* _tmp91_;
	ValaTypeSymbol* _tmp90_;
	ValaTypeSymbol* _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp106_;
	ValaCCodeFragment* _tmp111_;
	ValaCCodeFunction* _tmp132_;
	g_return_if_fail (self != NULL);
	use_thread_safe = vala_code_context_require_glib_version (self->priv->_context, 2, 14);
	fundamental = FALSE;
	cl = (_tmp0_ = vala_typeregister_function_get_type_declaration (self), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL);
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if (cl != NULL) {
		_tmp2_ = !vala_class_get_is_compact (cl);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		fundamental = TRUE;
	}
	type_id_name = (_tmp5_ = g_strdup_printf ("%s_type_id", _tmp4_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp3_ = vala_typeregister_function_get_type_declaration (self)), NULL)), _g_free0 (_tmp4_), _vala_code_node_unref0 (_tmp3_), _tmp5_);
	type_block = vala_ccode_block_new ();
	_cdecl_ = NULL;
	if (use_thread_safe) {
		ValaCCodeDeclaration* _tmp6_;
		ValaCCodeVariableDeclarator* _tmp9_;
		ValaCCodeConstant* _tmp8_;
		char* _tmp7_;
		_cdecl_ = (_tmp6_ = vala_ccode_declaration_new ("gsize"), _vala_ccode_node_unref0 (_cdecl_), _tmp6_);
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp9_ = vala_ccode_variable_declarator_new (_tmp7_ = g_strconcat (type_id_name, "__volatile", NULL), (ValaCCodeExpression*) (_tmp8_ = vala_ccode_constant_new ("0")), NULL)));
		_vala_ccode_node_unref0 (_tmp9_);
		_vala_ccode_node_unref0 (_tmp8_);
		_g_free0 (_tmp7_);
	} else {
		ValaCCodeDeclaration* _tmp10_;
		ValaCCodeVariableDeclarator* _tmp12_;
		ValaCCodeConstant* _tmp11_;
		_cdecl_ = (_tmp10_ = vala_ccode_declaration_new ("GType"), _vala_ccode_node_unref0 (_cdecl_), _tmp10_);
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp12_ = vala_ccode_variable_declarator_new (type_id_name, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("0")), NULL)));
		_vala_ccode_node_unref0 (_tmp12_);
		_vala_ccode_node_unref0 (_tmp11_);
	}
	vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (use_thread_safe) {
		vala_ccode_declaration_set_modifiers (_cdecl_, vala_ccode_declaration_get_modifiers (_cdecl_) | VALA_CCODE_MODIFIERS_VOLATILE);
	}
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) _cdecl_);
	} else {
		vala_ccode_fragment_append (self->priv->source_declaration_fragment, (ValaCCodeNode*) _cdecl_);
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* _tmp16_;
		char* _tmp15_;
		char* _tmp14_;
		ValaTypeSymbol* _tmp13_;
		fun = (_tmp16_ = vala_ccode_function_new (_tmp15_ = g_strdup_printf ("%s_get_type", _tmp14_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp13_ = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), _vala_ccode_node_unref0 (fun), _tmp16_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp14_);
		_vala_code_node_unref0 (_tmp13_);
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
	} else {
		ValaCCodeFunction* _tmp20_;
		char* _tmp19_;
		char* _tmp18_;
		ValaTypeSymbol* _tmp17_;
		ValaCCodeFormalParameter* _tmp21_;
		char* _tmp24_;
		char* _tmp23_;
		ValaTypeSymbol* _tmp22_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* _tmp26_;
		ValaCCodeBlock* _tmp27_;
		ValaCCodeReturnStatement* _tmp29_;
		ValaCCodeIdentifier* _tmp28_;
		fun = (_tmp20_ = vala_ccode_function_new (_tmp19_ = g_strdup_printf ("%s_register_type", _tmp18_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp17_ = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), _vala_ccode_node_unref0 (fun), _tmp20_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp17_);
		vala_ccode_function_add_parameter (fun, _tmp21_ = vala_ccode_formal_parameter_new ("module", "GTypeModule *"));
		_vala_ccode_node_unref0 (_tmp21_);
		get_fun = (_tmp25_ = vala_ccode_function_new (_tmp24_ = g_strdup_printf ("%s_get_type", _tmp23_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp22_ = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), _g_free0 (_tmp24_), _g_free0 (_tmp23_), _vala_code_node_unref0 (_tmp22_), _tmp25_);
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		vala_ccode_fragment_append (self->priv->declaration_fragment, (ValaCCodeNode*) (_tmp26_ = vala_ccode_function_copy (get_fun)));
		_vala_ccode_node_unref0 (_tmp26_);
		vala_ccode_function_set_block (get_fun, _tmp27_ = vala_ccode_block_new ());
		_vala_ccode_node_unref0 (_tmp27_);
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), (ValaCCodeNode*) (_tmp29_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new (type_id_name)))));
		_vala_ccode_node_unref0 (_tmp29_);
		_vala_ccode_node_unref0 (_tmp28_);
		vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) get_fun);
		_vala_ccode_node_unref0 (get_fun);
	}
	type_value_table_decl_name = NULL;
	type_init = vala_ccode_block_new ();
	if (fundamental) {
		ValaCCodeDeclaration* cgtypetabledecl;
		ValaCCodeVariableDeclarator* _tmp38_;
		ValaCCodeConstant* _tmp37_;
		char* _tmp36_;
		char* _tmp35_;
		char* _tmp34_;
		char* _tmp33_;
		char* _tmp32_;
		char* _tmp31_;
		char* _tmp30_;
		char* _tmp39_;
		cgtypetabledecl = vala_ccode_declaration_new ("const GTypeValueTable");
		vala_ccode_declaration_set_modifiers (cgtypetabledecl, VALA_CCODE_MODIFIERS_STATIC);
		vala_ccode_declaration_add_declarator (cgtypetabledecl, (ValaCCodeDeclarator*) (_tmp38_ = vala_ccode_variable_declarator_new ("g_define_type_value_table", (ValaCCodeExpression*) (_tmp37_ = vala_ccode_constant_new (_tmp36_ = g_strdup_printf ("{ %s, %s, %s, %s, \"p\", %s, \"p\", %s }", _tmp30_ = vala_typeregister_function_get_gtype_value_table_init_function_name (self), _tmp31_ = vala_typeregister_function_get_gtype_value_table_free_function_name (self), _tmp32_ = vala_typeregister_function_get_gtype_value_table_copy_function_name (self), _tmp33_ = vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (self), _tmp34_ = vala_typeregister_function_get_gtype_value_table_collect_value_function_name (self), _tmp35_ = vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (self)))), NULL)));
		_vala_ccode_node_unref0 (_tmp38_);
		_vala_ccode_node_unref0 (_tmp37_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp30_);
		type_value_table_decl_name = (_tmp39_ = g_strdup ("&g_define_type_value_table"), _g_free0 (type_value_table_decl_name), _tmp39_);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) cgtypetabledecl);
		_vala_ccode_node_unref0 (cgtypetabledecl);
	} else {
		char* _tmp40_;
		type_value_table_decl_name = (_tmp40_ = g_strdup ("NULL"), _g_free0 (type_value_table_decl_name), _tmp40_);
	}
	if ((_tmp42_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp41_ = vala_typeregister_function_get_type_declaration (self)), _vala_code_node_unref0 (_tmp41_), _tmp42_)) {
		ValaCCodeDeclaration* ctypedecl;
		char* _tmp43_;
		ValaCCodeVariableDeclarator* _tmp54_;
		ValaCCodeConstant* _tmp53_;
		char* _tmp52_;
		char* _tmp51_;
		char* _tmp50_;
		char* _tmp49_;
		char* _tmp48_;
		char* _tmp47_;
		char* _tmp46_;
		ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
		vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp43_ = NULL;
		if (plugin) {
			char* _tmp44_;
			_tmp43_ = (_tmp44_ = vala_typeregister_function_get_base_finalize_func_name (self), _g_free0 (_tmp43_), _tmp44_);
		} else {
			char* _tmp45_;
			_tmp43_ = (_tmp45_ = g_strdup ("NULL"), _g_free0 (_tmp43_), _tmp45_);
		}
		vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp54_ = vala_ccode_variable_declarator_new ("g_define_type_info", (ValaCCodeExpression*) (_tmp53_ = vala_ccode_constant_new (_tmp52_ = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) %s, (GClassInitFunc) %s, (GClassFinalizeFunc) %s, NULL, %s, 0, (GInstanceInitFunc) %s, %s }", _tmp46_ = vala_typeregister_function_get_type_struct_name (self), _tmp47_ = vala_typeregister_function_get_base_init_func_name (self), _tmp43_, _tmp48_ = vala_typeregister_function_get_class_init_func_name (self), _tmp49_ = vala_typeregister_function_get_class_finalize_func_name (self), _tmp50_ = vala_typeregister_function_get_instance_struct_size (self), _tmp51_ = vala_typeregister_function_get_instance_init_func_name (self), type_value_table_decl_name))), NULL)));
		_vala_ccode_node_unref0 (_tmp54_);
		_vala_ccode_node_unref0 (_tmp53_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp51_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp46_);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) ctypedecl);
		if (fundamental) {
			ValaCCodeDeclaration* ctypefundamentaldecl;
			ValaCCodeVariableDeclarator* _tmp56_;
			ValaCCodeConstant* _tmp55_;
			ctypefundamentaldecl = vala_ccode_declaration_new ("const GTypeFundamentalInfo");
			vala_ccode_declaration_set_modifiers (ctypefundamentaldecl, VALA_CCODE_MODIFIERS_STATIC);
			vala_ccode_declaration_add_declarator (ctypefundamentaldecl, (ValaCCodeDeclarator*) (_tmp56_ = vala_ccode_variable_declarator_new ("g_define_type_fundamental_info", (ValaCCodeExpression*) (_tmp55_ = vala_ccode_constant_new ("{ (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) }")), NULL)));
			_vala_ccode_node_unref0 (_tmp56_);
			_vala_ccode_node_unref0 (_tmp55_);
			vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) ctypefundamentaldecl);
			_vala_ccode_node_unref0 (ctypefundamentaldecl);
		}
		_vala_ccode_node_unref0 (ctypedecl);
		_g_free0 (_tmp43_);
	}
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp57_ = vala_typeregister_function_get_type_interface_init_declaration (self)));
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = FALSE;
	if (cl != NULL) {
		_tmp58_ = vala_class_get_has_class_private_fields (cl);
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		ValaCCodeFunctionCall* quark_reg_call;
		ValaCCodeConstant* _tmp66_;
		char* _tmp65_;
		char* _tmp64_;
		ValaTypeSymbol* _tmp63_;
		ValaCCodeExpressionStatement* _tmp72_;
		ValaCCodeAssignment* _tmp71_;
		ValaCCodeIdentifier* _tmp70_;
		char* _tmp69_;
		char* _tmp68_;
		ValaTypeSymbol* _tmp67_;
		quark_reg_call = NULL;
		if (plugin) {
			ValaCCodeFunctionCall* _tmp60_;
			ValaCCodeIdentifier* _tmp59_;
			quark_reg_call = (_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("g_quark_from_string"))), _vala_ccode_node_unref0 (quark_reg_call), _tmp60_);
			_vala_ccode_node_unref0 (_tmp59_);
		} else {
			ValaCCodeFunctionCall* _tmp62_;
			ValaCCodeIdentifier* _tmp61_;
			quark_reg_call = (_tmp62_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new ("g_quark_from_static_string"))), _vala_ccode_node_unref0 (quark_reg_call), _tmp62_);
			_vala_ccode_node_unref0 (_tmp61_);
		}
		vala_ccode_function_call_add_argument (quark_reg_call, (ValaCCodeExpression*) (_tmp66_ = vala_ccode_constant_new (_tmp65_ = g_strdup_printf ("\"Vala%sClassPrivate\"", _tmp64_ = vala_typesymbol_get_cname (_tmp63_ = vala_typeregister_function_get_type_declaration (self), FALSE)))));
		_vala_ccode_node_unref0 (_tmp66_);
		_g_free0 (_tmp65_);
		_g_free0 (_tmp64_);
		_vala_code_node_unref0 (_tmp63_);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp72_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp71_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp70_ = vala_ccode_identifier_new (_tmp69_ = g_strdup_printf ("_vala_%s_class_private_quark", _tmp68_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp67_ = vala_typeregister_function_get_type_declaration (self)), NULL)))), (ValaCCodeExpression*) quark_reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		_vala_ccode_node_unref0 (_tmp72_);
		_vala_ccode_node_unref0 (_tmp71_);
		_vala_ccode_node_unref0 (_tmp70_);
		_g_free0 (_tmp69_);
		_g_free0 (_tmp68_);
		_vala_code_node_unref0 (_tmp67_);
		_vala_ccode_node_unref0 (quark_reg_call);
	}
	reg_call = NULL;
	if ((_tmp74_ = VALA_IS_STRUCT (_tmp73_ = vala_typeregister_function_get_type_declaration (self)), _vala_code_node_unref0 (_tmp73_), _tmp74_)) {
		ValaCCodeFunctionCall* _tmp76_;
		ValaCCodeIdentifier* _tmp75_;
		reg_call = (_tmp76_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("g_boxed_type_register_static"))), _vala_ccode_node_unref0 (reg_call), _tmp76_);
		_vala_ccode_node_unref0 (_tmp75_);
	} else {
		if (fundamental) {
			ValaCCodeFunctionCall* _tmp78_;
			ValaCCodeIdentifier* _tmp77_;
			ValaCCodeFunctionCall* _tmp80_;
			ValaCCodeIdentifier* _tmp79_;
			reg_call = (_tmp78_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp77_ = vala_ccode_identifier_new ("g_type_register_fundamental"))), _vala_ccode_node_unref0 (reg_call), _tmp78_);
			_vala_ccode_node_unref0 (_tmp77_);
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp80_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp79_ = vala_ccode_identifier_new ("g_type_fundamental_next")))));
			_vala_ccode_node_unref0 (_tmp80_);
			_vala_ccode_node_unref0 (_tmp79_);
		} else {
			if (!plugin) {
				ValaCCodeFunctionCall* _tmp82_;
				ValaCCodeIdentifier* _tmp81_;
				ValaCCodeIdentifier* _tmp84_;
				char* _tmp83_;
				reg_call = (_tmp82_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp81_ = vala_ccode_identifier_new ("g_type_register_static"))), _vala_ccode_node_unref0 (reg_call), _tmp82_);
				_vala_ccode_node_unref0 (_tmp81_);
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp84_ = vala_ccode_identifier_new (_tmp83_ = vala_typeregister_function_get_parent_type_name (self))));
				_vala_ccode_node_unref0 (_tmp84_);
				_g_free0 (_tmp83_);
			} else {
				ValaCCodeFunctionCall* _tmp86_;
				ValaCCodeIdentifier* _tmp85_;
				ValaCCodeIdentifier* _tmp87_;
				ValaCCodeIdentifier* _tmp89_;
				char* _tmp88_;
				reg_call = (_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85_ = vala_ccode_identifier_new ("g_type_module_register_type"))), _vala_ccode_node_unref0 (reg_call), _tmp86_);
				_vala_ccode_node_unref0 (_tmp85_);
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp87_ = vala_ccode_identifier_new ("module")));
				_vala_ccode_node_unref0 (_tmp87_);
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp89_ = vala_ccode_identifier_new (_tmp88_ = vala_typeregister_function_get_parent_type_name (self))));
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp88_);
			}
		}
	}
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp93_ = vala_ccode_constant_new (_tmp92_ = g_strdup_printf ("\"%s\"", _tmp91_ = vala_typesymbol_get_cname (_tmp90_ = vala_typeregister_function_get_type_declaration (self), FALSE)))));
	_vala_ccode_node_unref0 (_tmp93_);
	_g_free0 (_tmp92_);
	_g_free0 (_tmp91_);
	_vala_code_node_unref0 (_tmp90_);
	if ((_tmp95_ = VALA_IS_STRUCT (_tmp94_ = vala_typeregister_function_get_type_declaration (self)), _vala_code_node_unref0 (_tmp94_), _tmp95_)) {
		ValaStruct* st;
		ValaCCodeCastExpression* _tmp98_;
		ValaCCodeIdentifier* _tmp97_;
		char* _tmp96_;
		ValaCCodeCastExpression* _tmp101_;
		ValaCCodeIdentifier* _tmp100_;
		char* _tmp99_;
		st = VALA_STRUCT (vala_typeregister_function_get_type_declaration (self));
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp98_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp97_ = vala_ccode_identifier_new (_tmp96_ = vala_typesymbol_get_dup_function ((ValaTypeSymbol*) st))), "GBoxedCopyFunc")));
		_vala_ccode_node_unref0 (_tmp98_);
		_vala_ccode_node_unref0 (_tmp97_);
		_g_free0 (_tmp96_);
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp101_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp100_ = vala_ccode_identifier_new (_tmp99_ = vala_typesymbol_get_free_function ((ValaTypeSymbol*) st))), "GBoxedFreeFunc")));
		_vala_ccode_node_unref0 (_tmp101_);
		_vala_ccode_node_unref0 (_tmp100_);
		_g_free0 (_tmp99_);
		_vala_code_node_unref0 (st);
	} else {
		ValaCCodeIdentifier* _tmp102_;
		ValaCCodeConstant* _tmp105_;
		char* _tmp104_;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp102_ = vala_ccode_identifier_new ("&g_define_type_info")));
		_vala_ccode_node_unref0 (_tmp102_);
		if (fundamental) {
			ValaCCodeIdentifier* _tmp103_;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp103_ = vala_ccode_identifier_new ("&g_define_type_fundamental_info")));
			_vala_ccode_node_unref0 (_tmp103_);
		}
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp105_ = vala_ccode_constant_new (_tmp104_ = vala_typeregister_function_get_type_flags (self))));
		_vala_ccode_node_unref0 (_tmp105_);
		_g_free0 (_tmp104_);
	}
	_tmp106_ = FALSE;
	if (use_thread_safe) {
		_tmp106_ = !plugin;
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaCCodeDeclaration* temp_decl;
		ValaCCodeVariableDeclarator* _tmp107_;
		temp_decl = vala_ccode_declaration_new ("GType");
		vala_ccode_declaration_add_declarator (temp_decl, (ValaCCodeDeclarator*) (_tmp107_ = vala_ccode_variable_declarator_new (type_id_name, (ValaCCodeExpression*) reg_call, NULL)));
		_vala_ccode_node_unref0 (_tmp107_);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) temp_decl);
		_vala_ccode_node_unref0 (temp_decl);
	} else {
		ValaCCodeExpressionStatement* _tmp110_;
		ValaCCodeAssignment* _tmp109_;
		ValaCCodeIdentifier* _tmp108_;
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp110_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp109_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp108_ = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		_vala_ccode_node_unref0 (_tmp110_);
		_vala_ccode_node_unref0 (_tmp109_);
		_vala_ccode_node_unref0 (_tmp108_);
	}
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp111_ = vala_typeregister_function_get_type_interface_init_statements (self)));
	_vala_ccode_node_unref0 (_tmp111_);
	if (!plugin) {
		ValaCCodeExpression* condition;
		ValaCCodeIfStatement* cif;
		condition = NULL;
		if (use_thread_safe) {
			ValaCCodeIdentifier* _tmp112_;
			ValaCCodeFunctionCall* _tmp113_;
			ValaCCodeFunctionCall* enter;
			ValaCCodeUnaryExpression* _tmp116_;
			ValaCCodeIdentifier* _tmp115_;
			char* _tmp114_;
			ValaCCodeExpression* _tmp117_;
			ValaCCodeIdentifier* _tmp118_;
			ValaCCodeFunctionCall* _tmp119_;
			ValaCCodeFunctionCall* leave;
			ValaCCodeUnaryExpression* _tmp122_;
			ValaCCodeIdentifier* _tmp121_;
			char* _tmp120_;
			ValaCCodeIdentifier* _tmp123_;
			ValaCCodeExpressionStatement* _tmp124_;
			enter = (_tmp113_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp112_ = vala_ccode_identifier_new ("g_once_init_enter"))), _vala_ccode_node_unref0 (_tmp112_), _tmp113_);
			vala_ccode_function_call_add_argument (enter, (ValaCCodeExpression*) (_tmp116_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp115_ = vala_ccode_identifier_new (_tmp114_ = g_strconcat (type_id_name, "__volatile", NULL))))));
			_vala_ccode_node_unref0 (_tmp116_);
			_vala_ccode_node_unref0 (_tmp115_);
			_g_free0 (_tmp114_);
			condition = (_tmp117_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) enter), _vala_ccode_node_unref0 (condition), _tmp117_);
			leave = (_tmp119_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp118_ = vala_ccode_identifier_new ("g_once_init_leave"))), _vala_ccode_node_unref0 (_tmp118_), _tmp119_);
			vala_ccode_function_call_add_argument (leave, (ValaCCodeExpression*) (_tmp122_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp121_ = vala_ccode_identifier_new (_tmp120_ = g_strconcat (type_id_name, "__volatile", NULL))))));
			_vala_ccode_node_unref0 (_tmp122_);
			_vala_ccode_node_unref0 (_tmp121_);
			_g_free0 (_tmp120_);
			vala_ccode_function_call_add_argument (leave, (ValaCCodeExpression*) (_tmp123_ = vala_ccode_identifier_new (type_id_name)));
			_vala_ccode_node_unref0 (_tmp123_);
			vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp124_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) leave)));
			_vala_ccode_node_unref0 (_tmp124_);
			_vala_ccode_node_unref0 (enter);
			_vala_ccode_node_unref0 (leave);
		} else {
			ValaCCodeIdentifier* id;
			ValaCCodeConstant* zero;
			ValaCCodeExpression* _tmp125_;
			id = vala_ccode_identifier_new (type_id_name);
			zero = vala_ccode_constant_new ("0");
			condition = (_tmp125_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) id, (ValaCCodeExpression*) zero), _vala_ccode_node_unref0 (condition), _tmp125_);
			_vala_ccode_node_unref0 (id);
			_vala_ccode_node_unref0 (zero);
		}
		cif = vala_ccode_if_statement_new (condition, (ValaCCodeStatement*) type_init, NULL);
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) cif);
		_vala_ccode_node_unref0 (condition);
		_vala_ccode_node_unref0 (cif);
	} else {
		ValaCCodeBlock* _tmp126_;
		type_block = (_tmp126_ = _vala_ccode_node_ref0 (type_init), _vala_ccode_node_unref0 (type_block), _tmp126_);
	}
	if (use_thread_safe) {
		ValaCCodeReturnStatement* _tmp129_;
		ValaCCodeIdentifier* _tmp128_;
		char* _tmp127_;
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) (_tmp129_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp128_ = vala_ccode_identifier_new (_tmp127_ = g_strconcat (type_id_name, "__volatile", NULL))))));
		_vala_ccode_node_unref0 (_tmp129_);
		_vala_ccode_node_unref0 (_tmp128_);
		_g_free0 (_tmp127_);
	} else {
		ValaCCodeReturnStatement* _tmp131_;
		ValaCCodeIdentifier* _tmp130_;
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) (_tmp131_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp130_ = vala_ccode_identifier_new (type_id_name)))));
		_vala_ccode_node_unref0 (_tmp131_);
		_vala_ccode_node_unref0 (_tmp130_);
	}
	vala_ccode_fragment_append (self->priv->declaration_fragment, (ValaCCodeNode*) (_tmp132_ = vala_ccode_function_copy (fun)));
	_vala_ccode_node_unref0 (_tmp132_);
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) fun);
	_vala_code_node_unref0 (cl);
	_g_free0 (type_id_name);
	_vala_ccode_node_unref0 (type_block);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (fun);
	_g_free0 (type_value_table_decl_name);
	_vala_ccode_node_unref0 (type_init);
	_vala_ccode_node_unref0 (reg_call);
}


static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_declaration'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


static char* vala_typeregister_function_real_get_class_finalize_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_class_finalize_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_finalize_func_name (self);
}


static char* vala_typeregister_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_base_finalize_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_finalize_func_name (self);
}


static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_init_function_name (self);
}


static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_peek_pointer_function_name (self);
}


static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_free_function_name (self);
}


static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_copy_function_name (self);
}


static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_lcopy_value_function_name (self);
}


static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_collect_value_function_name (self);
}


static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup ("0");
	return result;
}


char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = vala_ccode_fragment_new ();
	return result;
}


ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_interface_init_statements'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


ValaCCodeFragment* vala_typeregister_function_get_source_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_ccode_node_ref0 (self->priv->source_declaration_fragment);
	return result;
}


ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_ccode_node_ref0 (self->priv->declaration_fragment);
	return result;
}


ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_ccode_node_ref0 (self->priv->definition_fragment);
	return result;
}


static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, 0);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_accessibility'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}


ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_accessibility (self);
}


ValaTypeRegisterFunction* vala_typeregister_function_construct (GType object_type) {
	ValaTypeRegisterFunction* self;
	self = (ValaTypeRegisterFunction*) g_type_create_instance (object_type);
	return self;
}


ValaCodeContext* vala_typeregister_function_get_context (ValaTypeRegisterFunction* self) {
	ValaCodeContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_context;
	return result;
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_context = (_tmp0_ = _vala_code_context_ref0 (value), _vala_code_context_unref0 (self->priv->_context), _tmp0_);
}


static void vala_value_typeregister_function_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_typeregister_function_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_typeregister_function_unref (value->data[0].v_pointer);
	}
}


static void vala_value_typeregister_function_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_typeregister_function_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_typeregister_function_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_typeregister_function_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaTypeRegisterFunction* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_typeregister_function_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_typeregister_function_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaTypeRegisterFunction** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_typeregister_function_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecTypeRegisterFunction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_typeregister_function (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_typeregister_function (GValue* value, gpointer v_object) {
	ValaTypeRegisterFunction* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TYPEREGISTER_FUNCTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_typeregister_function_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_typeregister_function_unref (old);
	}
}


static void vala_typeregister_function_class_init (ValaTypeRegisterFunctionClass * klass) {
	vala_typeregister_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_typeregister_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_typeregister_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_typeregister_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_typeregister_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_finalize_func_name = vala_typeregister_function_real_get_class_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_finalize_func_name = vala_typeregister_function_real_get_base_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_typeregister_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_typeregister_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_typeregister_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_typeregister_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_init_function_name = vala_typeregister_function_real_get_gtype_value_table_init_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_peek_pointer_function_name = vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_free_function_name = vala_typeregister_function_real_get_gtype_value_table_free_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_copy_function_name = vala_typeregister_function_real_get_gtype_value_table_copy_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_lcopy_value_function_name = vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_collect_value_function_name = vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_typeregister_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_typeregister_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_typeregister_function_real_get_type_interface_init_statements;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_typeregister_function_real_get_accessibility;
}


static void vala_typeregister_function_instance_init (ValaTypeRegisterFunction * self) {
	self->priv = VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->source_declaration_fragment = vala_ccode_fragment_new ();
	self->priv->declaration_fragment = vala_ccode_fragment_new ();
	self->priv->definition_fragment = vala_ccode_fragment_new ();
	self->ref_count = 1;
}


static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (obj);
	_vala_ccode_node_unref0 (self->priv->source_declaration_fragment);
	_vala_ccode_node_unref0 (self->priv->declaration_fragment);
	_vala_ccode_node_unref0 (self->priv->definition_fragment);
	_vala_code_context_unref0 (self->priv->_context);
}


GType vala_typeregister_function_get_type (void) {
	static GType vala_typeregister_function_type_id = 0;
	if (vala_typeregister_function_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_typeregister_function_init, vala_value_typeregister_function_free_value, vala_value_typeregister_function_copy_value, vala_value_typeregister_function_peek_pointer, "p", vala_value_typeregister_function_collect_value, "p", vala_value_typeregister_function_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeregister_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_typeregister_function_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_typeregister_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaTypeRegisterFunction", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_typeregister_function_type_id;
}


gpointer vala_typeregister_function_ref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_typeregister_function_unref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




