/* valaccodedelegatemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gee_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (gee_collection_object_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTryStatement* current_try;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_constructor;
	gboolean in_static_or_class_context;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* void_type;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};


static gpointer vala_ccode_delegate_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
enum  {
	VALA_CCODE_DELEGATE_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeArrayModule* vala_ccode_array_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_ccode_delegate_module_real_generate_delegate_declaration (ValaCCodeBaseModule* base, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_delegate_declaration (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d);
static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
gint vala_ccode_base_module_get_block_id (ValaCCodeBaseModule* self, ValaBlock* b);
ValaDataType* vala_ccode_base_module_get_this_type (ValaCCodeBaseModule* self);
ValaMethod* vala_ccode_base_module_get_current_method (ValaCCodeBaseModule* self);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr);
static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
static char* vala_ccode_delegate_module_generate_delegate_wrapper (ValaCCodeDelegateModule* self, ValaMethod* m, ValaDelegate* d);
ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
char* vala_ccode_module_get_dynamic_signal_cname (ValaCCodeModule* self, ValaDynamicSignal* node);
gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static void vala_ccode_delegate_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeDelegateModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeDelegateModule*) vala_ccode_array_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_delegate_module_construct (VALA_TYPE_CCODE_DELEGATE_MODULE, codegen, next);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_ccode_delegate_module_real_generate_delegate_declaration (ValaCCodeBaseModule* base, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space) {
	ValaCCodeDelegateModule * self;
	char* _tmp0_;
	gboolean _tmp1_;
	char* return_type_cname;
	char* _tmp2_;
	gboolean _tmp3_;
	char* _tmp5_;
	ValaCCodeFunctionDeclarator* _tmp6_;
	ValaCCodeFunctionDeclarator* cfundecl;
	gboolean _tmp19_;
	GeeList* _tmp25_;
	gboolean _tmp26_;
	ValaCCodeTypeDefinition* ctypedef;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (d != NULL);
	g_return_if_fail (decl_space != NULL);
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) d, _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), _g_free0 (_tmp0_), _tmp1_)) {
		return;
	}
	return_type_cname = vala_data_type_get_cname (vala_delegate_get_return_type (d));
	if ((_tmp3_ = _vala_strcmp0 (return_type_cname, _tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)) == 0, _g_free0 (_tmp2_), _tmp3_)) {
		char* _tmp4_;
		return_type_cname = (_tmp4_ = g_strdup ("GCallback"), _g_free0 (return_type_cname), _tmp4_);
	} else {
		vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_delegate_get_return_type (d), decl_space);
	}
	cfundecl = (_tmp6_ = vala_ccode_function_declarator_new (_tmp5_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), _g_free0 (_tmp5_), _tmp6_);
	{
		GeeList* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _param_it;
		_param_it = (_tmp8_ = gee_iterable_iterator ((GeeIterable*) (_tmp7_ = vala_delegate_get_parameters (d))), _gee_collection_object_unref0 (_tmp7_), _tmp8_);
		while (TRUE) {
			ValaFormalParameter* param;
			GeeHashMap* _tmp9_;
			gboolean _tmp10_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, decl_space, (GeeMap*) (_tmp9_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal)), NULL);
			_gee_collection_object_unref0 (_tmp9_);
			vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
			_tmp10_ = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp10_ = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaArrayType* array_type;
				char* length_ctype;
				array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)));
				length_ctype = g_strdup ("int");
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp11_;
					length_ctype = (_tmp11_ = g_strdup ("int*"), _g_free0 (length_ctype), _tmp11_);
				}
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp12_;
						_tmp12_ = TRUE;
						while (TRUE) {
							char* _tmp14_;
							char* _tmp13_;
							ValaCCodeFormalParameter* _tmp15_;
							ValaCCodeFormalParameter* cparam;
							if (!_tmp12_) {
								dim++;
							}
							_tmp12_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							cparam = (_tmp15_ = vala_ccode_formal_parameter_new (_tmp14_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp13_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), dim), length_ctype), _g_free0 (_tmp14_), _g_free0 (_tmp13_), _tmp15_);
							vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
							_vala_ccode_node_unref0 (cparam);
						}
					}
				}
				_vala_code_node_unref0 (array_type);
				_g_free0 (length_ctype);
			}
			if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				ValaDelegateType* deleg_type;
				ValaDelegate* param_d;
				deleg_type = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)));
				param_d = _vala_code_node_ref0 (vala_delegate_type_get_delegate_symbol (deleg_type));
				if (vala_delegate_get_has_target (param_d)) {
					char* _tmp17_;
					char* _tmp16_;
					ValaCCodeFormalParameter* _tmp18_;
					ValaCCodeFormalParameter* cparam;
					cparam = (_tmp18_ = vala_ccode_formal_parameter_new (_tmp17_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp16_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), "void*"), _g_free0 (_tmp17_), _g_free0 (_tmp16_), _tmp18_);
					vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
					_vala_ccode_node_unref0 (cparam);
				}
				_vala_code_node_unref0 (deleg_type);
				_vala_code_node_unref0 (param_d);
			}
			_vala_code_node_unref0 (param);
		}
		_gee_collection_object_unref0 (_param_it);
	}
	_tmp19_ = FALSE;
	if (!vala_delegate_get_no_array_length (d)) {
		_tmp19_ = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (d));
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		ValaArrayType* array_type;
		array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_delegate_get_return_type (d)));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp20_;
				_tmp20_ = TRUE;
				while (TRUE) {
					char* _tmp21_;
					ValaCCodeFormalParameter* _tmp22_;
					ValaCCodeFormalParameter* cparam;
					if (!_tmp20_) {
						dim++;
					}
					_tmp20_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					cparam = (_tmp22_ = vala_ccode_formal_parameter_new (_tmp21_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _g_free0 (_tmp21_), _tmp22_);
					vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
					_vala_ccode_node_unref0 (cparam);
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_delegate_get_return_type (d))) {
			ValaDelegateType* deleg_type;
			ValaDelegate* result_d;
			deleg_type = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (vala_delegate_get_return_type (d)));
			result_d = _vala_code_node_ref0 (vala_delegate_type_get_delegate_symbol (deleg_type));
			if (vala_delegate_get_has_target (result_d)) {
				char* _tmp23_;
				ValaCCodeFormalParameter* _tmp24_;
				ValaCCodeFormalParameter* cparam;
				cparam = (_tmp24_ = vala_ccode_formal_parameter_new (_tmp23_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result"), "void**"), _g_free0 (_tmp23_), _tmp24_);
				vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
				_vala_ccode_node_unref0 (cparam);
			}
			_vala_code_node_unref0 (deleg_type);
			_vala_code_node_unref0 (result_d);
		}
	}
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("user_data", "void*");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		_vala_ccode_node_unref0 (cparam);
	}
	if ((_tmp26_ = gee_collection_get_size ((GeeCollection*) (_tmp25_ = vala_code_node_get_error_types ((ValaCodeNode*) d))) > 0, _gee_collection_object_unref0 (_tmp25_), _tmp26_)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		_vala_ccode_node_unref0 (cparam);
	}
	ctypedef = vala_ccode_type_definition_new (return_type_cname, (ValaCCodeDeclarator*) cfundecl);
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) ctypedef);
	_g_free0 (return_type_cname);
	_vala_ccode_node_unref0 (cfundecl);
	_vala_ccode_node_unref0 (ctypedef);
}


static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d) {
	ValaCCodeDelegateModule * self;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (d != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, ((ValaCCodeBaseModule*) self)->source_declarations);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) d)) {
		vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, ((ValaCCodeBaseModule*) self)->header_declarations);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) d)) {
		vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, ((ValaCCodeBaseModule*) self)->internal_header_declarations);
	}
}


static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	char* result;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	result = g_strdup_printf ("%s_target", delegate_cname);
	return result;
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr) {
	ValaCCodeDelegateModule * self;
	ValaCCodeExpression* result;
	gboolean is_out;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (delegate_expr)) {
		ValaUnaryExpression* unary_expr;
		gboolean _tmp0_;
		unary_expr = _vala_code_node_ref0 (VALA_UNARY_EXPRESSION (delegate_expr));
		_tmp0_ = FALSE;
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF;
		}
		if (_tmp0_) {
			delegate_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		_vala_code_node_unref0 (unary_expr);
	}
	if (VALA_IS_METHOD_CALL (delegate_expr)) {
		ValaMethodCall* invocation_expr;
		invocation_expr = _vala_code_node_ref0 (VALA_METHOD_CALL (delegate_expr));
		result = _vala_ccode_node_ref0 (vala_expression_get_delegate_target ((ValaExpression*) invocation_expr));
		_vala_code_node_unref0 (invocation_expr);
		return result;
	} else {
		if (VALA_IS_LAMBDA_EXPRESSION (delegate_expr)) {
			ValaSymbol* _tmp1_;
			ValaBlock* closure_block;
			closure_block = _vala_code_node_ref0 ((_tmp1_ = ((ValaCCodeBaseModule*) self)->current_symbol, VALA_IS_BLOCK (_tmp1_) ? ((ValaBlock*) _tmp1_) : NULL));
			while (TRUE) {
				gboolean _tmp2_;
				ValaBlock* _tmp4_;
				ValaSymbol* _tmp3_;
				_tmp2_ = FALSE;
				if (closure_block != NULL) {
					_tmp2_ = !vala_block_get_captured (closure_block);
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					break;
				}
				closure_block = (_tmp4_ = _vala_code_node_ref0 ((_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) closure_block), VALA_IS_BLOCK (_tmp3_) ? ((ValaBlock*) _tmp3_) : NULL)), _vala_code_node_unref0 (closure_block), _tmp4_);
			}
			if (closure_block != NULL) {
				char* _tmp5_;
				ValaCCodeExpression* _tmp6_;
				result = (_tmp6_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp5_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, closure_block))), _g_free0 (_tmp5_), _tmp6_);
				_vala_code_node_unref0 (closure_block);
				return result;
			} else {
				gboolean _tmp7_;
				ValaDataType* _tmp8_;
				gboolean _tmp9_;
				_tmp7_ = FALSE;
				if ((_tmp9_ = (_tmp8_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self)) != NULL, _vala_code_node_unref0 (_tmp8_), _tmp9_)) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = ((ValaCCodeBaseModule*) self)->in_constructor;
				}
				if (_tmp7_) {
					result = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
					_vala_code_node_unref0 (closure_block);
					return result;
				} else {
					result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
					_vala_code_node_unref0 (closure_block);
					return result;
				}
			}
			_vala_code_node_unref0 (closure_block);
		} else {
			if (vala_expression_get_symbol_reference (delegate_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr))) {
					ValaFormalParameter* param;
					param = _vala_code_node_ref0 (VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr)));
					if (vala_formal_parameter_get_captured (param)) {
						ValaBlock* block;
						char* _tmp13_;
						char* _tmp12_;
						ValaCCodeExpression* _tmp11_;
						char* _tmp10_;
						ValaCCodeExpression* _tmp14_;
						block = _vala_code_node_ref0 (vala_method_get_body (VALA_METHOD (vala_symbol_get_parent_symbol ((ValaSymbol*) param))));
						result = (_tmp14_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (_tmp11_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp10_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, block))), _tmp13_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp12_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), _g_free0 (_tmp13_), _g_free0 (_tmp12_), _vala_ccode_node_unref0 (_tmp11_), _g_free0 (_tmp10_), _tmp14_);
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (param);
						return result;
						_vala_code_node_unref0 (block);
					} else {
						gboolean _tmp15_;
						_tmp15_ = FALSE;
						if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
							_tmp15_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
						} else {
							_tmp15_ = FALSE;
						}
						if (_tmp15_) {
							char* _tmp18_;
							char* _tmp17_;
							ValaCCodeIdentifier* _tmp16_;
							ValaCCodeExpression* _tmp19_;
							result = (_tmp19_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("data")), _tmp18_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp17_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), _g_free0 (_tmp18_), _g_free0 (_tmp17_), _vala_ccode_node_unref0 (_tmp16_), _tmp19_);
							_vala_code_node_unref0 (param);
							return result;
						} else {
							char* _tmp21_;
							char* _tmp20_;
							ValaCCodeExpression* _tmp22_;
							ValaCCodeExpression* target_expr;
							target_expr = (_tmp22_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp21_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp20_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), _g_free0 (_tmp21_), _g_free0 (_tmp20_), _tmp22_);
							if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
								ValaCCodeExpression* _tmp23_;
								target_expr = (_tmp23_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, target_expr), _vala_ccode_node_unref0 (target_expr), _tmp23_);
							}
							if (is_out) {
								result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr);
								_vala_ccode_node_unref0 (target_expr);
								_vala_code_node_unref0 (param);
								return result;
							} else {
								result = target_expr;
								_vala_code_node_unref0 (param);
								return result;
							}
							_vala_ccode_node_unref0 (target_expr);
						}
					}
					_vala_code_node_unref0 (param);
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr))) {
						ValaLocalVariable* local;
						local = _vala_code_node_ref0 (VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr)));
						if (vala_local_variable_get_captured (local)) {
							ValaBlock* block;
							char* _tmp27_;
							char* _tmp26_;
							ValaCCodeExpression* _tmp25_;
							char* _tmp24_;
							ValaCCodeExpression* _tmp28_;
							block = _vala_code_node_ref0 (VALA_BLOCK (vala_symbol_get_parent_symbol ((ValaSymbol*) local)));
							result = (_tmp28_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (_tmp25_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp24_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, block))), _tmp27_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp26_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))), _g_free0 (_tmp27_), _g_free0 (_tmp26_), _vala_ccode_node_unref0 (_tmp25_), _g_free0 (_tmp24_), _tmp28_);
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (local);
							return result;
							_vala_code_node_unref0 (block);
						} else {
							gboolean _tmp29_;
							_tmp29_ = FALSE;
							if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
								_tmp29_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
							} else {
								_tmp29_ = FALSE;
							}
							if (_tmp29_) {
								char* _tmp32_;
								char* _tmp31_;
								ValaCCodeIdentifier* _tmp30_;
								ValaCCodeExpression* _tmp33_;
								result = (_tmp33_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("data")), _tmp32_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp31_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))), _g_free0 (_tmp32_), _g_free0 (_tmp31_), _vala_ccode_node_unref0 (_tmp30_), _tmp33_);
								_vala_code_node_unref0 (local);
								return result;
							} else {
								char* _tmp35_;
								char* _tmp34_;
								ValaCCodeIdentifier* _tmp36_;
								ValaCCodeIdentifier* target_expr;
								target_expr = (_tmp36_ = vala_ccode_identifier_new (_tmp35_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp34_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))), _g_free0 (_tmp35_), _g_free0 (_tmp34_), _tmp36_);
								if (is_out) {
									result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) target_expr);
									_vala_ccode_node_unref0 (target_expr);
									_vala_code_node_unref0 (local);
									return result;
								} else {
									result = (ValaCCodeExpression*) target_expr;
									_vala_code_node_unref0 (local);
									return result;
								}
								_vala_ccode_node_unref0 (target_expr);
							}
						}
						_vala_code_node_unref0 (local);
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (delegate_expr))) {
							ValaField* field;
							char* _tmp37_;
							char* _tmp38_;
							char* target_cname;
							ValaMemberAccess* ma;
							ValaCCodeExpression* target_expr;
							field = _vala_code_node_ref0 (VALA_FIELD (vala_expression_get_symbol_reference (delegate_expr)));
							target_cname = (_tmp38_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp37_ = vala_field_get_cname (field)), _g_free0 (_tmp37_), _tmp38_);
							ma = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (delegate_expr));
							target_expr = NULL;
							if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
								ValaDataType* instance_expression_type;
								ValaDataType* instance_target_type;
								ValaCCodeExpression* pub_inst;
								ValaCCodeExpression* typed_inst;
								ValaCCodeExpression* inst;
								instance_expression_type = _vala_code_node_ref0 (vala_expression_get_value_type (vala_member_access_get_inner (ma)));
								instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)));
								pub_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
								typed_inst = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, pub_inst, instance_expression_type, instance_target_type, NULL);
								inst = NULL;
								if (vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
									ValaCCodeExpression* _tmp39_;
									inst = (_tmp39_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), _vala_ccode_node_unref0 (inst), _tmp39_);
								} else {
									ValaCCodeExpression* _tmp40_;
									inst = (_tmp40_ = _vala_ccode_node_ref0 (typed_inst), _vala_ccode_node_unref0 (inst), _tmp40_);
								}
								if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
									ValaCCodeExpression* _tmp41_;
									target_expr = (_tmp41_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, target_cname), _vala_ccode_node_unref0 (target_expr), _tmp41_);
								} else {
									ValaCCodeExpression* _tmp42_;
									target_expr = (_tmp42_ = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, target_cname, FALSE), _vala_ccode_node_unref0 (target_expr), _tmp42_);
								}
								_vala_code_node_unref0 (instance_expression_type);
								_vala_code_node_unref0 (instance_target_type);
								_vala_ccode_node_unref0 (pub_inst);
								_vala_ccode_node_unref0 (typed_inst);
								_vala_ccode_node_unref0 (inst);
							} else {
								ValaCCodeExpression* _tmp43_;
								target_expr = (_tmp43_ = (ValaCCodeExpression*) vala_ccode_identifier_new (target_cname), _vala_ccode_node_unref0 (target_expr), _tmp43_);
							}
							if (is_out) {
								result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr);
								_vala_code_node_unref0 (field);
								_g_free0 (target_cname);
								_vala_code_node_unref0 (ma);
								_vala_ccode_node_unref0 (target_expr);
								return result;
							} else {
								result = target_expr;
								_vala_code_node_unref0 (field);
								_g_free0 (target_cname);
								_vala_code_node_unref0 (ma);
								return result;
							}
							_vala_code_node_unref0 (field);
							_g_free0 (target_cname);
							_vala_code_node_unref0 (ma);
							_vala_ccode_node_unref0 (target_expr);
						} else {
							if (VALA_IS_METHOD (vala_expression_get_symbol_reference (delegate_expr))) {
								ValaMethod* m;
								ValaMemberAccess* ma;
								m = _vala_code_node_ref0 (VALA_METHOD (vala_expression_get_symbol_reference (delegate_expr)));
								ma = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (delegate_expr));
								if (vala_method_get_binding (m) == MEMBER_BINDING_STATIC) {
									result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
									_vala_code_node_unref0 (m);
									_vala_code_node_unref0 (ma);
									return result;
								} else {
									if (vala_method_get_is_async_callback (m)) {
										result = (ValaCCodeExpression*) vala_ccode_identifier_new ("data");
										_vala_code_node_unref0 (m);
										_vala_code_node_unref0 (ma);
										return result;
									} else {
										result = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
										_vala_code_node_unref0 (m);
										_vala_code_node_unref0 (ma);
										return result;
									}
								}
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (ma);
							} else {
								if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (delegate_expr))) {
									result = _vala_ccode_node_ref0 (vala_expression_get_delegate_target (delegate_expr));
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
	return result;
}


static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	char* result;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	result = g_strdup_printf ("%s_target_destroy_notify", delegate_cname);
	return result;
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeDelegateModule * self;
	ValaCCodeExpression* result;
	gboolean _tmp0_;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_DELEGATE_TYPE (target_type)) {
		_tmp0_ = VALA_IS_METHOD_TYPE (expression_type);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaDelegateType* dt;
		ValaMethodType* mt;
		ValaMethod* method;
		char* _tmp3_;
		ValaCCodeExpression* _tmp4_;
		dt = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (target_type));
		mt = _vala_code_node_ref0 (VALA_METHOD_TYPE (expression_type));
		method = _vala_code_node_ref0 (vala_method_type_get_method_symbol (mt));
		if (vala_method_get_base_method (method) != NULL) {
			ValaMethod* _tmp1_;
			method = (_tmp1_ = _vala_code_node_ref0 (vala_method_get_base_method (method)), _vala_code_node_unref0 (method), _tmp1_);
		} else {
			if (vala_method_get_base_interface_method (method) != NULL) {
				ValaMethod* _tmp2_;
				method = (_tmp2_ = _vala_code_node_ref0 (vala_method_get_base_interface_method (method)), _vala_code_node_unref0 (method), _tmp2_);
			}
		}
		result = (_tmp4_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp3_ = vala_ccode_delegate_module_generate_delegate_wrapper (self, method, vala_delegate_type_get_delegate_symbol (dt))), _g_free0 (_tmp3_), _tmp4_);
		_vala_code_node_unref0 (dt);
		_vala_code_node_unref0 (mt);
		_vala_code_node_unref0 (method);
		return result;
		_vala_code_node_unref0 (dt);
		_vala_code_node_unref0 (mt);
		_vala_code_node_unref0 (method);
	}
	result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_delegate_module_parent_class)->get_implicit_cast_expression ((ValaCCodeBaseModule*) VALA_CCODE_ARRAY_MODULE (self), source_cexpr, expression_type, target_type, expr);
	return result;
}


static char* vala_ccode_delegate_module_generate_delegate_wrapper (ValaCCodeDelegateModule* self, ValaMethod* m, ValaDelegate* d) {
	char* result;
	char* delegate_name;
	ValaSymbol* _tmp0_;
	ValaSignal* sig;
	ValaSignal* _tmp1_;
	ValaDynamicSignal* dynamic_sig;
	char* _tmp8_;
	char* _tmp9_;
	char* wrapper_name;
	char* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	GeeList* d_params;
	gboolean _tmp12_;
	GeeList* _tmp18_;
	gboolean _tmp19_;
	gint last_pos;
	gint min_pos;
	GeeHashMap* carg_map;
	gint i;
	gboolean _tmp25_;
	gboolean first;
	gboolean _tmp58_;
	GeeList* _tmp65_;
	gboolean _tmp66_;
	ValaCCodeIdentifier* _tmp69_;
	char* _tmp68_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp78_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (d != NULL, NULL);
	delegate_name = NULL;
	sig = _vala_code_node_ref0 ((_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) d), VALA_IS_SIGNAL (_tmp0_) ? ((ValaSignal*) _tmp0_) : NULL));
	dynamic_sig = _vala_code_node_ref0 ((_tmp1_ = sig, VALA_IS_DYNAMIC_SIGNAL (_tmp1_) ? ((ValaDynamicSignal*) _tmp1_) : NULL));
	if (dynamic_sig != NULL) {
		char* _tmp2_;
		delegate_name = (_tmp2_ = vala_ccode_module_get_dynamic_signal_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), dynamic_sig), _g_free0 (delegate_name), _tmp2_);
	} else {
		if (sig != NULL) {
			char* _tmp5_;
			char* _tmp4_;
			char* _tmp3_;
			delegate_name = (_tmp5_ = g_strconcat (_tmp3_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), _tmp4_ = vala_signal_get_cname (sig), NULL), _g_free0 (delegate_name), _tmp5_);
			_g_free0 (_tmp4_);
			_g_free0 (_tmp3_);
		} else {
			char* _tmp7_;
			char* _tmp6_;
			delegate_name = (_tmp7_ = vala_symbol_camel_case_to_lower_case (_tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), _g_free0 (delegate_name), _tmp7_);
			_g_free0 (_tmp6_);
		}
	}
	wrapper_name = (_tmp9_ = g_strdup_printf ("_%s_%s", _tmp8_ = vala_method_get_cname (m), delegate_name), _g_free0 (_tmp8_), _tmp9_);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, wrapper_name)) {
		result = wrapper_name;
		_g_free0 (delegate_name);
		_vala_code_node_unref0 (sig);
		_vala_code_node_unref0 (dynamic_sig);
		return result;
	}
	function = (_tmp11_ = vala_ccode_function_new (wrapper_name, _tmp10_ = vala_data_type_get_cname (vala_method_get_return_type (m))), _g_free0 (_tmp10_), _tmp11_);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) function);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("self", "gpointer");
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), cparam);
		_vala_ccode_node_unref0 (cparam);
	}
	if (vala_delegate_get_sender_type (d) != NULL) {
		ValaFormalParameter* param;
		param = vala_formal_parameter_new ("_sender", vala_delegate_get_sender_type (d), NULL);
		vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, NULL);
		_vala_code_node_unref0 (param);
	}
	d_params = vala_delegate_get_parameters (d);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) d_params);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, NULL);
			_vala_code_node_unref0 (param);
		}
		_gee_collection_object_unref0 (_param_it);
	}
	_tmp12_ = FALSE;
	if (!vala_delegate_get_no_array_length (d)) {
		_tmp12_ = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (d));
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaArrayType* array_type;
		array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_delegate_get_return_type (d)));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp13_;
				_tmp13_ = TRUE;
				while (TRUE) {
					char* _tmp14_;
					ValaCCodeFormalParameter* _tmp15_;
					ValaCCodeFormalParameter* cparam;
					if (!_tmp13_) {
						dim++;
					}
					_tmp13_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					cparam = (_tmp15_ = vala_ccode_formal_parameter_new (_tmp14_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _g_free0 (_tmp14_), _tmp15_);
					gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_carray_length_parameter_position (d) + (0.01 * dim), FALSE)), cparam);
					_vala_ccode_node_unref0 (cparam);
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_delegate_get_return_type (d))) {
			ValaDelegateType* deleg_type;
			deleg_type = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (vala_delegate_get_return_type (d)));
			if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (deleg_type))) {
				char* _tmp16_;
				ValaCCodeFormalParameter* _tmp17_;
				ValaCCodeFormalParameter* cparam;
				cparam = (_tmp17_ = vala_ccode_formal_parameter_new (_tmp16_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result"), "void**"), _g_free0 (_tmp16_), _tmp17_);
				gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cdelegate_target_parameter_position (d), FALSE)), cparam);
				_vala_ccode_node_unref0 (cparam);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	if ((_tmp19_ = gee_collection_get_size ((GeeCollection*) (_tmp18_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, _gee_collection_object_unref0 (_tmp18_), _tmp19_)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), cparam);
		_vala_ccode_node_unref0 (cparam);
	}
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp24_;
		min_pos = -1;
		{
			GeeSet* _tmp20_;
			GeeIterator* _tmp21_;
			GeeIterator* _pos_it;
			_pos_it = (_tmp21_ = gee_iterable_iterator ((GeeIterable*) (_tmp20_ = gee_map_get_keys ((GeeMap*) cparam_map))), _gee_collection_object_unref0 (_tmp20_), _tmp21_);
			while (TRUE) {
				gint pos;
				gboolean _tmp22_;
				if (!gee_iterator_next (_pos_it)) {
					break;
				}
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp22_ = FALSE;
				if (pos > last_pos) {
					gboolean _tmp23_;
					_tmp23_ = FALSE;
					if (min_pos == (-1)) {
						_tmp23_ = TRUE;
					} else {
						_tmp23_ = pos < min_pos;
					}
					_tmp22_ = _tmp23_;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					min_pos = pos;
				}
			}
			_gee_collection_object_unref0 (_pos_it);
		}
		if (min_pos == (-1)) {
			break;
		}
		vala_ccode_function_add_parameter (function, _tmp24_ = (ValaCCodeFormalParameter*) gee_map_get ((GeeMap*) cparam_map, GINT_TO_POINTER (min_pos)));
		_vala_ccode_node_unref0 (_tmp24_);
		last_pos = min_pos;
	}
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	i = 0;
	_tmp25_ = FALSE;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = vala_method_get_closure (m);
	}
	if (_tmp25_) {
		ValaCCodeExpression* arg;
		arg = NULL;
		if (vala_delegate_get_has_target (d)) {
			ValaCCodeExpression* _tmp26_;
			arg = (_tmp26_ = (ValaCCodeExpression*) vala_ccode_identifier_new ("self"), _vala_ccode_node_unref0 (arg), _tmp26_);
		} else {
			ValaCCodeExpression* _tmp29_;
			ValaFormalParameter* _tmp27_;
			ValaCCodeNode* _tmp28_;
			arg = (_tmp29_ = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name ((_tmp28_ = vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp27_ = (ValaFormalParameter*) gee_list_get (d_params, 0))), VALA_IS_CCODE_FORMAL_PARAMETER (_tmp28_) ? ((ValaCCodeFormalParameter*) _tmp28_) : NULL))), _vala_ccode_node_unref0 (arg), _tmp29_);
			_vala_code_node_unref0 (_tmp27_);
			i = 1;
		}
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), arg);
		_vala_ccode_node_unref0 (arg);
	}
	first = TRUE;
	{
		GeeList* _tmp30_;
		GeeIterator* _tmp31_;
		GeeIterator* _param_it;
		_param_it = (_tmp31_ = gee_iterable_iterator ((GeeIterable*) (_tmp30_ = vala_method_get_parameters (m))), _gee_collection_object_unref0 (_tmp30_), _tmp31_);
		while (TRUE) {
			ValaFormalParameter* param;
			gboolean _tmp32_;
			gboolean _tmp33_;
			ValaCCodeExpression* arg;
			ValaCCodeExpression* _tmp39_;
			ValaFormalParameter* _tmp37_;
			ValaCCodeNode* _tmp38_;
			gboolean _tmp40_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp32_ = FALSE;
			_tmp33_ = FALSE;
			if (first) {
				_tmp33_ = vala_delegate_get_sender_type (d) != NULL;
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				GeeList* _tmp35_;
				GeeList* _tmp34_;
				_tmp32_ = gee_collection_get_size ((GeeCollection*) (_tmp34_ = vala_method_get_parameters (m))) == (gee_collection_get_size ((GeeCollection*) (_tmp35_ = vala_delegate_get_parameters (d))) + 1);
				_gee_collection_object_unref0 (_tmp35_);
				_gee_collection_object_unref0 (_tmp34_);
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				ValaCCodeIdentifier* _tmp36_;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("_sender")));
				_vala_ccode_node_unref0 (_tmp36_);
				first = FALSE;
				_vala_code_node_unref0 (param);
				continue;
			}
			arg = NULL;
			arg = (_tmp39_ = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name ((_tmp38_ = vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp37_ = (ValaFormalParameter*) gee_list_get (d_params, i))), VALA_IS_CCODE_FORMAL_PARAMETER (_tmp38_) ? ((ValaCCodeFormalParameter*) _tmp38_) : NULL))), _vala_ccode_node_unref0 (arg), _tmp39_);
			_vala_code_node_unref0 (_tmp37_);
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), arg);
			_tmp40_ = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp40_ = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				ValaArrayType* array_type;
				array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)));
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp41_;
						_tmp41_ = TRUE;
						while (TRUE) {
							ValaCCodeExpression* clength;
							ValaFormalParameter* _tmp42_;
							gboolean _tmp43_;
							if (!_tmp41_) {
								dim++;
							}
							_tmp41_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							clength = NULL;
							if ((_tmp43_ = vala_formal_parameter_get_array_null_terminated (_tmp42_ = (ValaFormalParameter*) gee_list_get (d_params, i)), _vala_code_node_unref0 (_tmp42_), _tmp43_)) {
								ValaCCodeIdentifier* _tmp44_;
								ValaCCodeFunctionCall* _tmp45_;
								ValaCCodeFunctionCall* len_call;
								ValaCCodeIdentifier* _tmp47_;
								ValaFormalParameter* _tmp46_;
								ValaCCodeExpression* _tmp48_;
								((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
								len_call = (_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("_vala_array_length"))), _vala_ccode_node_unref0 (_tmp44_), _tmp45_);
								vala_ccode_function_call_add_argument (len_call, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) (_tmp46_ = (ValaFormalParameter*) gee_list_get (d_params, i))))));
								_vala_ccode_node_unref0 (_tmp47_);
								_vala_code_node_unref0 (_tmp46_);
								clength = (_tmp48_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) len_call), _vala_ccode_node_unref0 (clength), _tmp48_);
								_vala_ccode_node_unref0 (len_call);
							} else {
								ValaFormalParameter* _tmp49_;
								gboolean _tmp50_;
								if ((_tmp50_ = vala_formal_parameter_get_no_array_length (_tmp49_ = (ValaFormalParameter*) gee_list_get (d_params, i)), _vala_code_node_unref0 (_tmp49_), _tmp50_)) {
									ValaCCodeExpression* _tmp51_;
									clength = (_tmp51_ = (ValaCCodeExpression*) vala_ccode_constant_new ("-1"), _vala_ccode_node_unref0 (clength), _tmp51_);
								} else {
									ValaCCodeExpression* _tmp54_;
									char* _tmp53_;
									ValaFormalParameter* _tmp52_;
									clength = (_tmp54_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp53_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) (_tmp52_ = (ValaFormalParameter*) gee_list_get (d_params, i))), dim)), _vala_ccode_node_unref0 (clength), _tmp54_);
									_g_free0 (_tmp53_);
									_vala_code_node_unref0 (_tmp52_);
								}
							}
							gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), clength);
							_vala_ccode_node_unref0 (clength);
						}
					}
				}
				_vala_code_node_unref0 (array_type);
			} else {
				if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaDelegateType* deleg_type;
					deleg_type = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)));
					if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (deleg_type))) {
						char* _tmp56_;
						ValaFormalParameter* _tmp55_;
						ValaCCodeIdentifier* _tmp57_;
						ValaCCodeIdentifier* ctarget;
						ctarget = (_tmp57_ = vala_ccode_identifier_new (_tmp56_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) (_tmp55_ = (ValaFormalParameter*) gee_list_get (d_params, i))))), _g_free0 (_tmp56_), _vala_code_node_unref0 (_tmp55_), _tmp57_);
						gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (ValaCCodeExpression*) ctarget);
						_vala_ccode_node_unref0 (ctarget);
					}
					_vala_code_node_unref0 (deleg_type);
				}
			}
			i++;
			_vala_code_node_unref0 (param);
			_vala_ccode_node_unref0 (arg);
		}
		_gee_collection_object_unref0 (_param_it);
	}
	_tmp58_ = FALSE;
	if (!vala_method_get_no_array_length (m)) {
		_tmp58_ = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		ValaArrayType* array_type;
		array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_method_get_return_type (m)));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp59_;
				_tmp59_ = TRUE;
				while (TRUE) {
					ValaCCodeExpression* clength;
					if (!_tmp59_) {
						dim++;
					}
					_tmp59_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					clength = NULL;
					if (vala_delegate_get_no_array_length (d)) {
						ValaCCodeExpression* _tmp60_;
						clength = (_tmp60_ = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), _vala_ccode_node_unref0 (clength), _tmp60_);
					} else {
						ValaCCodeExpression* _tmp62_;
						char* _tmp61_;
						clength = (_tmp62_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp61_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim)), _vala_ccode_node_unref0 (clength), _tmp62_);
						_g_free0 (_tmp61_);
					}
					gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), clength);
					_vala_ccode_node_unref0 (clength);
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* deleg_type;
			deleg_type = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (vala_method_get_return_type (m)));
			if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (deleg_type))) {
				char* _tmp63_;
				ValaCCodeIdentifier* _tmp64_;
				ValaCCodeIdentifier* ctarget;
				ctarget = (_tmp64_ = vala_ccode_identifier_new (_tmp63_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result")), _g_free0 (_tmp63_), _tmp64_);
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) ctarget);
				_vala_ccode_node_unref0 (ctarget);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	if ((_tmp66_ = gee_collection_get_size ((GeeCollection*) (_tmp65_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, _gee_collection_object_unref0 (_tmp65_), _tmp66_)) {
		ValaCCodeIdentifier* _tmp67_;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("error")));
		_vala_ccode_node_unref0 (_tmp67_);
	}
	ccall = (_tmp70_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp69_ = vala_ccode_identifier_new (_tmp68_ = vala_method_get_cname (m)))), _vala_ccode_node_unref0 (_tmp69_), _g_free0 (_tmp68_), _tmp70_);
	last_pos = -1;
	while (TRUE) {
		ValaCCodeExpression* _tmp75_;
		min_pos = -1;
		{
			GeeSet* _tmp71_;
			GeeIterator* _tmp72_;
			GeeIterator* _pos_it;
			_pos_it = (_tmp72_ = gee_iterable_iterator ((GeeIterable*) (_tmp71_ = gee_map_get_keys ((GeeMap*) carg_map))), _gee_collection_object_unref0 (_tmp71_), _tmp72_);
			while (TRUE) {
				gint pos;
				gboolean _tmp73_;
				if (!gee_iterator_next (_pos_it)) {
					break;
				}
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp73_ = FALSE;
				if (pos > last_pos) {
					gboolean _tmp74_;
					_tmp74_ = FALSE;
					if (min_pos == (-1)) {
						_tmp74_ = TRUE;
					} else {
						_tmp74_ = pos < min_pos;
					}
					_tmp73_ = _tmp74_;
				} else {
					_tmp73_ = FALSE;
				}
				if (_tmp73_) {
					min_pos = pos;
				}
			}
			_gee_collection_object_unref0 (_pos_it);
		}
		if (min_pos == (-1)) {
			break;
		}
		vala_ccode_function_call_add_argument (ccall, _tmp75_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
		_vala_ccode_node_unref0 (_tmp75_);
		last_pos = min_pos;
	}
	block = vala_ccode_block_new ();
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpressionStatement* _tmp76_;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp76_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		_vala_ccode_node_unref0 (_tmp76_);
	} else {
		ValaCCodeReturnStatement* _tmp77_;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp77_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
		_vala_ccode_node_unref0 (_tmp77_);
	}
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp78_ = vala_ccode_function_copy (function)));
	_vala_ccode_node_unref0 (_tmp78_);
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = wrapper_name;
	_g_free0 (delegate_name);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (dynamic_sig);
	_vala_ccode_node_unref0 (function);
	_gee_collection_object_unref0 (cparam_map);
	_gee_collection_object_unref0 (d_params);
	_gee_collection_object_unref0 (carg_map);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (block);
	return result;
}


static void vala_ccode_delegate_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map) {
	ValaCCodeDelegateModule * self;
	gboolean _tmp0_;
	char* ctypename;
	char* target_ctypename;
	gboolean _tmp1_;
	ValaCCodeFormalParameter* _tmp8_;
	char* _tmp7_;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (param != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param));
	}
	if (!_tmp0_) {
		VALA_CCODE_METHOD_MODULE_CLASS (vala_ccode_delegate_module_parent_class)->generate_parameter ((ValaCCodeMethodModule*) VALA_CCODE_ARRAY_MODULE (self), param, decl_space, cparam_map, carg_map);
		return;
	}
	ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param));
	target_ctypename = g_strdup ("void*");
	_tmp1_ = FALSE;
	if (VALA_IS_DELEGATE (vala_symbol_get_parent_symbol ((ValaSymbol*) param))) {
		char* _tmp3_;
		char* _tmp2_;
		_tmp1_ = _vala_strcmp0 (_tmp2_ = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)), _tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) VALA_DELEGATE (vala_symbol_get_parent_symbol ((ValaSymbol*) param)), FALSE)) == 0;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp4_;
		ctypename = (_tmp4_ = g_strdup ("GCallback"), _g_free0 (ctypename), _tmp4_);
	}
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		char* _tmp5_;
		char* _tmp6_;
		ctypename = (_tmp5_ = g_strconcat (ctypename, "*", NULL), _g_free0 (ctypename), _tmp5_);
		target_ctypename = (_tmp6_ = g_strconcat (target_ctypename, "*", NULL), _g_free0 (target_ctypename), _tmp6_);
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) param, (ValaCCodeNode*) (_tmp8_ = vala_ccode_formal_parameter_new (_tmp7_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), ctypename)));
	_vala_ccode_node_unref0 (_tmp8_);
	_g_free0 (_tmp7_);
	gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
	if (carg_map != NULL) {
		ValaCCodeExpression* _tmp9_;
		gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), _tmp9_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)));
		_vala_ccode_node_unref0 (_tmp9_);
	}
	if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		ValaDelegateType* deleg_type;
		ValaDelegate* d;
		deleg_type = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)));
		d = _vala_code_node_ref0 (vala_delegate_type_get_delegate_symbol (deleg_type));
		vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, decl_space);
		if (vala_delegate_get_has_target (d)) {
			char* _tmp11_;
			char* _tmp10_;
			ValaCCodeFormalParameter* _tmp12_;
			ValaCCodeFormalParameter* cparam;
			cparam = (_tmp12_ = vala_ccode_formal_parameter_new (_tmp11_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp10_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), target_ctypename), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _tmp12_);
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeExpression* _tmp13_;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp13_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
				_vala_ccode_node_unref0 (_tmp13_);
			}
			if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
				ValaCCodeFormalParameter* _tmp16_;
				char* _tmp15_;
				char* _tmp14_;
				cparam = (_tmp16_ = vala_ccode_formal_parameter_new (_tmp15_ = vala_ccode_base_module_get_delegate_target_destroy_notify_cname ((ValaCCodeBaseModule*) self, _tmp14_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), "GDestroyNotify"), _vala_ccode_node_unref0 (cparam), _tmp16_);
				_g_free0 (_tmp15_);
				_g_free0 (_tmp14_);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
				if (carg_map != NULL) {
					ValaCCodeExpression* _tmp17_;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), _tmp17_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
					_vala_ccode_node_unref0 (_tmp17_);
				}
			}
			_vala_ccode_node_unref0 (cparam);
		}
		_vala_code_node_unref0 (deleg_type);
		_vala_code_node_unref0 (d);
	} else {
		if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
			char* _tmp19_;
			char* _tmp18_;
			ValaCCodeFormalParameter* _tmp20_;
			ValaCCodeFormalParameter* cparam;
			cparam = (_tmp20_ = vala_ccode_formal_parameter_new (_tmp19_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp18_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), target_ctypename), _g_free0 (_tmp19_), _g_free0 (_tmp18_), _tmp20_);
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeExpression* _tmp21_;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp21_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
				_vala_ccode_node_unref0 (_tmp21_);
			}
			_vala_ccode_node_unref0 (cparam);
		}
	}
	_g_free0 (ctypename);
	_g_free0 (target_ctypename);
}


static void vala_ccode_delegate_module_class_init (ValaCCodeDelegateModuleClass * klass) {
	vala_ccode_delegate_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_delegate_declaration = vala_ccode_delegate_module_real_generate_delegate_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_delegate = vala_ccode_delegate_module_real_visit_delegate;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_delegate_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_delegate_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_implicit_cast_expression = vala_ccode_delegate_module_real_get_implicit_cast_expression;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_parameter = vala_ccode_delegate_module_real_generate_parameter;
}


static void vala_ccode_delegate_module_instance_init (ValaCCodeDelegateModule * self) {
}


GType vala_ccode_delegate_module_get_type (void) {
	static GType vala_ccode_delegate_module_type_id = 0;
	if (vala_ccode_delegate_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDelegateModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_delegate_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDelegateModule), 0, (GInstanceInitFunc) vala_ccode_delegate_module_instance_init, NULL };
		vala_ccode_delegate_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ARRAY_MODULE, "ValaCCodeDelegateModule", &g_define_type_info, 0);
	}
	return vala_ccode_delegate_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




