/* valainstancecast.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <valaccode.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_INSTANCE_CAST (vala_instance_cast_get_type ())
#define VALA_INSTANCE_CAST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INSTANCE_CAST, ValaInstanceCast))
#define VALA_INSTANCE_CAST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INSTANCE_CAST, ValaInstanceCastClass))
#define VALA_IS_INSTANCE_CAST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INSTANCE_CAST))
#define VALA_IS_INSTANCE_CAST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INSTANCE_CAST))
#define VALA_INSTANCE_CAST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INSTANCE_CAST, ValaInstanceCastClass))

typedef struct _ValaInstanceCast ValaInstanceCast;
typedef struct _ValaInstanceCastClass ValaInstanceCastClass;
typedef struct _ValaInstanceCastPrivate ValaInstanceCastPrivate;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

/**
 * Represents a runtime checked object instance cast expression in the C code.
 */
struct _ValaInstanceCast {
	ValaCCodeFunctionCall parent_instance;
	ValaInstanceCastPrivate * priv;
};

struct _ValaInstanceCastClass {
	ValaCCodeFunctionCallClass parent_class;
};

struct _ValaInstanceCastPrivate {
	ValaTypeSymbol* _type_reference;
	ValaCCodeExpression* _inner;
};


static gpointer vala_instance_cast_parent_class = NULL;

GType vala_instance_cast_get_type (void);
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
GType vala_symbol_get_type (void);
GType vala_typesymbol_get_type (void);
#define VALA_INSTANCE_CAST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INSTANCE_CAST, ValaInstanceCastPrivate))
enum  {
	VALA_INSTANCE_CAST_DUMMY_PROPERTY
};
void vala_instance_cast_set_inner (ValaInstanceCast* self, ValaCCodeExpression* value);
void vala_instance_cast_set_type_reference (ValaInstanceCast* self, ValaTypeSymbol* value);
ValaTypeSymbol* vala_instance_cast_get_type_reference (ValaInstanceCast* self);
char* vala_typesymbol_get_upper_case_cname (ValaTypeSymbol* self, const char* infix);
ValaCCodeExpression* vala_instance_cast_get_inner (ValaInstanceCast* self);
ValaInstanceCast* vala_instance_cast_new (ValaCCodeExpression* expr, ValaTypeSymbol* type);
ValaInstanceCast* vala_instance_cast_construct (GType object_type, ValaCCodeExpression* expr, ValaTypeSymbol* type);
static void vala_instance_cast_finalize (ValaCCodeNode* obj);



/**
 * Creates a new instance cast expression.
 *
 * @param expr an expression
 * @param type the target type
 * @return     newly created instance cast expression
 */
ValaInstanceCast* vala_instance_cast_construct (GType object_type, ValaCCodeExpression* expr, ValaTypeSymbol* type) {
	ValaInstanceCast* self;
	ValaCCodeIdentifier* _tmp1_;
	char* _tmp0_;
	g_return_val_if_fail (expr != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	self = (ValaInstanceCast*) g_type_create_instance (object_type);
	vala_instance_cast_set_inner (self, expr);
	vala_instance_cast_set_type_reference (self, type);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	vala_ccode_function_call_set_call ((ValaCCodeFunctionCall*) self, (ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new (_tmp0_ = vala_typesymbol_get_upper_case_cname (self->priv->_type_reference, NULL))));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp0_ = (g_free (_tmp0_), NULL);
	vala_ccode_function_call_add_argument ((ValaCCodeFunctionCall*) self, VALA_CCODE_EXPRESSION (self->priv->_inner));
	return self;
}


ValaInstanceCast* vala_instance_cast_new (ValaCCodeExpression* expr, ValaTypeSymbol* type) {
	return vala_instance_cast_construct (VALA_TYPE_INSTANCE_CAST, expr, type);
}


ValaTypeSymbol* vala_instance_cast_get_type_reference (ValaInstanceCast* self) {
	ValaTypeSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_reference;
	return result;
}


void vala_instance_cast_set_type_reference (ValaInstanceCast* self, ValaTypeSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_type_reference = value;
}


ValaCCodeExpression* vala_instance_cast_get_inner (ValaInstanceCast* self) {
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_inner;
	return result;
}


void vala_instance_cast_set_inner (ValaInstanceCast* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp1_;
	ValaCCodeExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_inner = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_)), (self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL)), _tmp1_);
}


static void vala_instance_cast_class_init (ValaInstanceCastClass * klass) {
	vala_instance_cast_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_instance_cast_finalize;
	g_type_class_add_private (klass, sizeof (ValaInstanceCastPrivate));
}


static void vala_instance_cast_instance_init (ValaInstanceCast * self) {
	self->priv = VALA_INSTANCE_CAST_GET_PRIVATE (self);
}


static void vala_instance_cast_finalize (ValaCCodeNode* obj) {
	ValaInstanceCast * self;
	self = VALA_INSTANCE_CAST (obj);
	(self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL));
	VALA_CCODE_NODE_CLASS (vala_instance_cast_parent_class)->finalize (obj);
}


GType vala_instance_cast_get_type (void) {
	static GType vala_instance_cast_type_id = 0;
	if (vala_instance_cast_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInstanceCastClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_instance_cast_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInstanceCast), 0, (GInstanceInitFunc) vala_instance_cast_instance_init, NULL };
		vala_instance_cast_type_id = g_type_register_static (VALA_TYPE_CCODE_FUNCTION_CALL, "ValaInstanceCast", &g_define_type_info, 0);
	}
	return vala_instance_cast_type_id;
}




