/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
enum  {
	VALA_CCODE_METHOD_CALL_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeAssignmentModule* vala_ccode_assignment_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeAssignmentModule* vala_ccode_assignment_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
void vala_ccode_module_generate_dynamic_method_wrapper (ValaCCodeModule* self, ValaDynamicMethod* method);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gpointer vala_ccode_method_call_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodCallModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE, codegen, next);
}


static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeFunctionCall* async_call;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp1_;
	ValaExpression* _tmp0_;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2_;
	ValaDataType* itype;
	GeeList* _tmp3_;
	GeeHashMap* in_arg_map;
	GeeHashMap* out_arg_map;
	gboolean _tmp18_;
	gboolean _tmp19_;
	ValaCCodeExpression* _tmp58_;
	ValaCCodeExpression* ccall_expr;
	ValaCCodeExpression* instance;
	gboolean _tmp62_;
	gboolean _tmp63_;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gboolean _tmp207_;
	gboolean _tmp223_;
	gboolean _tmp234_;
	gboolean _tmp245_;
	gint last_pos;
	gint min_pos;
	gboolean _tmp265_;
	gboolean _tmp266_;
	gboolean _tmp268_;
	gboolean _tmp269_;
	gboolean _tmp270_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))));
	async_call = NULL;
	m = NULL;
	params = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	ma = (_tmp1_ = (_tmp0_ = vala_method_call_get_call (expr), VALA_IS_MEMBER_ACCESS (_tmp0_) ? ((ValaMemberAccess*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	itype = (_tmp2_ = vala_expression_get_value_type (vala_method_call_get_call (expr)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	_tmp3_ = NULL;
	params = (_tmp3_ = vala_data_type_get_parameters (itype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp3_);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5_;
		ValaMethod* _tmp4_;
		g_assert (ma != NULL);
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		m = (_tmp5_ = (_tmp4_ = vala_method_type_get_method_symbol (VALA_METHOD_TYPE (itype)), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp5_);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaSignalType* _tmp6_;
			ValaSignalType* sig_type;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = NULL;
			sig_type = (_tmp6_ = VALA_SIGNAL_TYPE (itype), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
			_tmp7_ = FALSE;
			_tmp8_ = FALSE;
			if (ma != NULL) {
				_tmp8_ = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				_tmp7_ = vala_signal_get_is_virtual (vala_signal_type_get_signal_symbol (sig_type));
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				ValaMethod* _tmp9_;
				_tmp9_ = NULL;
				m = (_tmp9_ = vala_signal_get_method_handler (vala_signal_type_get_signal_symbol (sig_type)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp9_);
			} else {
				ValaCCodeFunctionCall* _tmp11_;
				ValaCCodeFunctionCall* _tmp10_;
				_tmp11_ = NULL;
				_tmp10_ = NULL;
				ccall = (_tmp11_ = (_tmp10_ = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))), (_tmp10_ == NULL) ? NULL : vala_ccode_node_ref (_tmp10_)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp11_);
			}
			(sig_type == NULL) ? NULL : (sig_type = (vala_code_node_unref (sig_type), NULL));
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp12_;
				ValaClass* cl;
				ValaMethod* _tmp14_;
				ValaMethod* _tmp13_;
				ValaCCodeFunctionCall* _tmp17_;
				ValaCCodeIdentifier* _tmp16_;
				char* _tmp15_;
				/* constructor*/
				_tmp12_ = NULL;
				cl = (_tmp12_ = VALA_CLASS (vala_object_type_get_type_symbol (VALA_OBJECT_TYPE (itype))), (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_));
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				m = (_tmp14_ = (_tmp13_ = vala_class_get_default_construction_method (cl), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp14_);
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations);
				_tmp17_ = NULL;
				_tmp16_ = NULL;
				_tmp15_ = NULL;
				ccall = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new (_tmp15_ = vala_method_get_real_cname (m)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp17_);
				(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
				_tmp15_ = (g_free (_tmp15_), NULL);
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
		}
	}
	in_arg_map = NULL;
	out_arg_map = NULL;
	_tmp18_ = FALSE;
	_tmp19_ = FALSE;
	if (m != NULL) {
		_tmp19_ = vala_method_get_coroutine (m);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp20_ = FALSE;
		_tmp21_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp21_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			gboolean _tmp22_;
			_tmp22_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp22_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp22_ = FALSE;
			}
			_tmp20_ = _tmp22_;
		}
		_tmp18_ = _tmp20_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GeeHashMap* _tmp23_;
		GeeHashMap* _tmp24_;
		ValaCCodeFunctionCall* _tmp28_;
		ValaCCodeIdentifier* _tmp27_;
		char* _tmp26_;
		char* _tmp25_;
		gboolean _tmp29_;
		/* async call*/
		_tmp23_ = NULL;
		in_arg_map = (_tmp23_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp23_);
		_tmp24_ = NULL;
		out_arg_map = (_tmp24_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp24_);
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		_tmp26_ = NULL;
		_tmp25_ = NULL;
		async_call = (_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new (_tmp26_ = g_strconcat (_tmp25_ = vala_method_get_cname (m), "_async", NULL)))), (async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL)), _tmp28_);
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
		_tmp26_ = (g_free (_tmp26_), NULL);
		_tmp25_ = (g_free (_tmp25_), NULL);
		_tmp29_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp29_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			ValaCCodeFunctionCall* _tmp31_;
			ValaCCodeFunctionCall* _tmp30_;
			/* no finish call*/
			_tmp31_ = NULL;
			_tmp30_ = NULL;
			ccall = (_tmp31_ = (_tmp30_ = async_call, (_tmp30_ == NULL) ? NULL : vala_ccode_node_ref (_tmp30_)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp31_);
		} else {
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeIdentifier* _tmp34_;
			char* _tmp33_;
			char* _tmp32_;
			ValaCCodeMemberAccess* _tmp37_;
			ValaCCodeIdentifier* _tmp36_;
			_tmp35_ = NULL;
			_tmp34_ = NULL;
			_tmp33_ = NULL;
			_tmp32_ = NULL;
			ccall = (_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new (_tmp33_ = g_strconcat (_tmp32_ = vala_method_get_cname (m), "_finish", NULL)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp35_);
			(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
			_tmp33_ = (g_free (_tmp33_), NULL);
			_tmp32_ = (g_free (_tmp32_), NULL);
			/* pass GAsyncResult stored in closure to finish function*/
			_tmp37_ = NULL;
			_tmp36_ = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp37_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("data")), "res")));
			(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
			(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		}
	} else {
		GeeHashMap* _tmp38_;
		GeeHashMap* _tmp40_;
		GeeHashMap* _tmp39_;
		_tmp38_ = NULL;
		in_arg_map = (_tmp38_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp38_);
		_tmp40_ = NULL;
		_tmp39_ = NULL;
		out_arg_map = (_tmp40_ = (_tmp39_ = in_arg_map, (_tmp39_ == NULL) ? NULL : gee_collection_object_ref (_tmp39_)), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp40_);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeIdentifier* _tmp41_;
		_tmp41_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new ("object_type")));
		(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
		{
			GeeList* _tmp42_;
			GeeIterator* _tmp43_;
			GeeIterator* _base_type_it;
			_tmp42_ = NULL;
			_tmp43_ = NULL;
			_base_type_it = (_tmp43_ = gee_iterable_iterator ((GeeIterable*) (_tmp42_ = vala_class_get_base_types (((ValaCCodeBaseModule*) self)->current_class))), (_tmp42_ == NULL) ? NULL : (_tmp42_ = (gee_collection_object_unref (_tmp42_), NULL)), _tmp43_);
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
					{
						GeeList* _tmp44_;
						GeeIterator* _tmp45_;
						GeeIterator* _type_arg_it;
						_tmp44_ = NULL;
						_tmp45_ = NULL;
						_type_arg_it = (_tmp45_ = gee_iterable_iterator ((GeeIterable*) (_tmp44_ = vala_data_type_get_type_arguments (base_type))), (_tmp44_ == NULL) ? NULL : (_tmp44_ = (gee_collection_object_unref (_tmp44_), NULL)), _tmp45_);
						while (gee_iterator_next (_type_arg_it)) {
							ValaDataType* type_arg;
							type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
							if (VALA_IS_GENERIC_TYPE (type_arg)) {
								char* type_param;
								ValaCCodeIdentifier* _tmp47_;
								char* _tmp46_;
								ValaCCodeIdentifier* _tmp49_;
								char* _tmp48_;
								ValaCCodeIdentifier* _tmp51_;
								char* _tmp50_;
								/* map generic type parameter*/
								type_param = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg)), -1);
								_tmp47_ = NULL;
								_tmp46_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new (_tmp46_ = g_strdup_printf ("%s_type", type_param))));
								(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
								_tmp46_ = (g_free (_tmp46_), NULL);
								_tmp49_ = NULL;
								_tmp48_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new (_tmp48_ = g_strdup_printf ("%s_dup_func", type_param))));
								(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
								_tmp48_ = (g_free (_tmp48_), NULL);
								_tmp51_ = NULL;
								_tmp50_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new (_tmp50_ = g_strdup_printf ("%s_destroy_func", type_param))));
								(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
								_tmp50_ = (g_free (_tmp50_), NULL);
								type_param = (g_free (type_param), NULL);
							} else {
								ValaCCodeIdentifier* _tmp53_;
								char* _tmp52_;
								_tmp53_ = NULL;
								_tmp52_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new (_tmp52_ = vala_data_type_get_type_id (type_arg))));
								(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
								_tmp52_ = (g_free (_tmp52_), NULL);
								if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, type_arg)) {
									ValaCCodeExpression* dup_func;
									ValaCCodeCastExpression* _tmp54_;
									ValaCCodeExpression* _tmp55_;
									dup_func = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, type_arg, vala_code_node_get_source_reference ((ValaCodeNode*) type_arg));
									if (dup_func == NULL) {
										/* type doesn't contain a copy function*/
										vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
										(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
										(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
										(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
										(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
										(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
										(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
										(async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL));
										(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
										(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
										(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
										(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
										(in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL));
										(out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL));
										return;
									}
									_tmp54_ = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_cast_expression_new (dup_func, "GBoxedCopyFunc")));
									(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
									_tmp55_ = NULL;
									vala_ccode_function_call_add_argument (ccall, _tmp55_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, type_arg));
									(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
									(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
								} else {
									ValaCCodeConstant* _tmp56_;
									ValaCCodeConstant* _tmp57_;
									_tmp56_ = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_constant_new ("NULL")));
									(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
									_tmp57_ = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp57_ = vala_ccode_constant_new ("NULL")));
									(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
								}
							}
							(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
						}
						(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
					}
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					break;
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp58_ = NULL;
	ccall_expr = (_tmp58_ = (ValaCCodeExpression*) ccall, (_tmp58_ == NULL) ? NULL : vala_ccode_node_ref (_tmp58_));
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp59_;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp61_;
		char* _tmp60_;
		_tmp59_ = NULL;
		array_type = (_tmp59_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp59_ == NULL) ? NULL : vala_code_node_ref (_tmp59_));
		_tmp61_ = NULL;
		_tmp60_ = NULL;
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) 0, FALSE)), (ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new (_tmp60_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
		_tmp60_ = (g_free (_tmp60_), NULL);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	_tmp62_ = FALSE;
	_tmp63_ = FALSE;
	if (m != NULL) {
		_tmp63_ = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		_tmp62_ = !VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		ValaCCodeExpression* _tmp65_;
		ValaCCodeExpression* _tmp64_;
		gboolean _tmp66_;
		ValaStruct* _tmp71_;
		ValaSymbol* _tmp70_;
		ValaStruct* st;
		gboolean _tmp72_;
		_tmp65_ = NULL;
		_tmp64_ = NULL;
		instance = (_tmp65_ = (_tmp64_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp64_ == NULL) ? NULL : vala_ccode_node_ref (_tmp64_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp65_);
		_tmp66_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp66_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp66_ = FALSE;
		}
		if (_tmp66_) {
			ValaMemberAccess* _tmp67_;
			ValaMemberAccess* inner_ma;
			ValaCCodeExpression* _tmp69_;
			ValaCCodeExpression* _tmp68_;
			_tmp67_ = NULL;
			inner_ma = (_tmp67_ = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp67_ == NULL) ? NULL : vala_code_node_ref (_tmp67_));
			_tmp69_ = NULL;
			_tmp68_ = NULL;
			instance = (_tmp69_ = (_tmp68_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (inner_ma))), (_tmp68_ == NULL) ? NULL : vala_ccode_node_ref (_tmp68_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp69_);
			(inner_ma == NULL) ? NULL : (inner_ma = (vala_code_node_unref (inner_ma), NULL));
		}
		_tmp71_ = NULL;
		_tmp70_ = NULL;
		st = (_tmp71_ = (_tmp70_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_STRUCT (_tmp70_) ? ((ValaStruct*) _tmp70_) : NULL), (_tmp71_ == NULL) ? NULL : vala_code_node_ref (_tmp71_));
		_tmp72_ = FALSE;
		if (st != NULL) {
			_tmp72_ = !vala_struct_is_simple_type (st);
		} else {
			_tmp72_ = FALSE;
		}
		if (_tmp72_) {
			ValaCCodeUnaryExpression* _tmp74_;
			ValaCCodeExpression* _tmp73_;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp75_;
			/* we need to pass struct instance by reference*/
			_tmp74_ = NULL;
			_tmp73_ = NULL;
			unary = (_tmp74_ = (_tmp73_ = instance, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp73_) ? ((ValaCCodeUnaryExpression*) _tmp73_) : NULL), (_tmp74_ == NULL) ? NULL : vala_ccode_node_ref (_tmp74_));
			_tmp75_ = FALSE;
			if (unary != NULL) {
				_tmp75_ = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp75_ = FALSE;
			}
			if (_tmp75_) {
				ValaCCodeExpression* _tmp77_;
				ValaCCodeExpression* _tmp76_;
				/* *expr => expr*/
				_tmp77_ = NULL;
				_tmp76_ = NULL;
				instance = (_tmp77_ = (_tmp76_ = vala_ccode_unary_expression_get_inner (unary), (_tmp76_ == NULL) ? NULL : vala_ccode_node_ref (_tmp76_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp77_);
			} else {
				gboolean _tmp78_;
				_tmp78_ = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (instance)) {
					_tmp78_ = TRUE;
				} else {
					_tmp78_ = VALA_IS_CCODE_MEMBER_ACCESS (instance);
				}
				if (_tmp78_) {
					ValaCCodeExpression* _tmp79_;
					_tmp79_ = NULL;
					instance = (_tmp79_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp79_);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp81_;
					ValaCCodeExpression* _tmp80_;
					ValaCCodeUnaryExpression* _tmp83_;
					ValaCCodeExpression* _tmp82_;
					ValaCCodeExpression* _tmp85_;
					ValaCCodeExpression* _tmp84_;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp81_ = NULL;
					_tmp80_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp81_ = vala_ccode_assignment_new (_tmp80_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
					(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
					_tmp83_ = NULL;
					_tmp82_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp83_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp82_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)))));
					(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
					(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
					_tmp85_ = NULL;
					_tmp84_ = NULL;
					instance = (_tmp85_ = (_tmp84_ = (ValaCCodeExpression*) ccomma, (_tmp84_ == NULL) ? NULL : vala_ccode_node_ref (_tmp84_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp85_);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		gboolean _tmp86_;
		_tmp86_ = FALSE;
		if (m != NULL) {
			_tmp86_ = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
		} else {
			_tmp86_ = FALSE;
		}
		if (_tmp86_) {
			ValaClass* _tmp87_;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp90_;
			char* _tmp89_;
			char* _tmp88_;
			ValaCCodeFunctionCall* _tmp91_;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			_tmp87_ = NULL;
			cl = (_tmp87_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp87_ == NULL) ? NULL : vala_code_node_ref (_tmp87_));
			_tmp90_ = NULL;
			_tmp89_ = NULL;
			_tmp88_ = NULL;
			_tmp91_ = NULL;
			cast = (_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp90_ = vala_ccode_identifier_new (_tmp89_ = g_strconcat (_tmp88_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL)), _tmp89_ = (g_free (_tmp89_), NULL), _tmp88_ = (g_free (_tmp88_), NULL), _tmp91_);
			klass = NULL;
			if (vala_member_access_get_inner (ma) == NULL) {
				if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp92_;
					/* Accessing the method from a static or class constructor*/
					_tmp92_ = NULL;
					klass = (_tmp92_ = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp92_);
				} else {
					ValaCCodeIdentifier* _tmp93_;
					ValaCCodeFunctionCall* _tmp94_;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp95_;
					ValaCCodeExpression* _tmp97_;
					ValaCCodeExpression* _tmp96_;
					/* Accessing the method from within an instance method*/
					_tmp93_ = NULL;
					_tmp94_ = NULL;
					k = (_tmp94_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp93_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL)), _tmp94_);
					_tmp95_ = NULL;
					vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp95_ = vala_ccode_identifier_new ("self")));
					(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
					_tmp97_ = NULL;
					_tmp96_ = NULL;
					klass = (_tmp97_ = (_tmp96_ = (ValaCCodeExpression*) k, (_tmp96_ == NULL) ? NULL : vala_ccode_node_ref (_tmp96_)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp97_);
					(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
				}
			} else {
				ValaCCodeIdentifier* _tmp98_;
				ValaCCodeFunctionCall* _tmp99_;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp101_;
				ValaCCodeExpression* _tmp100_;
				/* Accessing the method of an instance*/
				_tmp98_ = NULL;
				_tmp99_ = NULL;
				k = (_tmp99_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp98_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL)), _tmp99_);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
				_tmp101_ = NULL;
				_tmp100_ = NULL;
				klass = (_tmp101_ = (_tmp100_ = (ValaCCodeExpression*) k, (_tmp100_ == NULL) ? NULL : vala_ccode_node_ref (_tmp100_)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp101_);
				(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
			(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp102_;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp103_;
		ValaCCodeFunctionCall* _tmp104_;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp106_;
		char* _tmp105_;
		_tmp102_ = NULL;
		array_type = (_tmp102_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp102_ == NULL) ? NULL : vala_code_node_ref (_tmp102_));
		_tmp103_ = NULL;
		_tmp104_ = NULL;
		csizeof = (_tmp104_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp103_ = vala_ccode_identifier_new ("sizeof"))), (_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL)), _tmp104_);
		_tmp106_ = NULL;
		_tmp105_ = NULL;
		vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp106_ = vala_ccode_identifier_new (_tmp105_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp106_ == NULL) ? NULL : (_tmp106_ = (vala_ccode_node_unref (_tmp106_), NULL));
		_tmp105_ = (g_free (_tmp105_), NULL);
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) csizeof);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* _tmp107_;
				GeeIterator* _tmp108_;
				GeeIterator* _arg_it;
				_tmp107_ = NULL;
				_tmp108_ = NULL;
				_arg_it = (_tmp108_ = gee_iterable_iterator ((GeeIterable*) (_tmp107_ = vala_method_call_get_argument_list (expr))), (_tmp107_ == NULL) ? NULL : (_tmp107_ = (gee_collection_object_unref (_tmp107_), NULL)), _tmp108_);
				while (gee_iterator_next (_arg_it)) {
					ValaExpression* arg;
					ValaUnaryExpression* _tmp110_;
					ValaExpression* _tmp109_;
					ValaUnaryExpression* unary;
					gboolean _tmp111_;
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					_tmp110_ = NULL;
					_tmp109_ = NULL;
					unary = (_tmp110_ = (_tmp109_ = arg, VALA_IS_UNARY_EXPRESSION (_tmp109_) ? ((ValaUnaryExpression*) _tmp109_) : NULL), (_tmp110_ == NULL) ? NULL : vala_code_node_ref (_tmp110_));
					_tmp111_ = FALSE;
					if (unary != NULL) {
						_tmp111_ = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp111_ = FALSE;
					}
					if (_tmp111_) {
						char* _tmp112_;
						ValaFormalParameter* _tmp113_;
						ValaFormalParameter* param;
						/* out argument*/
						_tmp112_ = NULL;
						_tmp113_ = NULL;
						param = (_tmp113_ = vala_formal_parameter_new (_tmp112_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp112_ = (g_free (_tmp112_), NULL), _tmp113_);
						vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
						vala_method_add_parameter (m, param);
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					} else {
						gboolean _tmp114_;
						_tmp114_ = FALSE;
						if (unary != NULL) {
							_tmp114_ = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp114_ = FALSE;
						}
						if (_tmp114_) {
							char* _tmp115_;
							ValaFormalParameter* _tmp116_;
							ValaFormalParameter* param;
							/* ref argument*/
							_tmp115_ = NULL;
							_tmp116_ = NULL;
							param = (_tmp116_ = vala_formal_parameter_new (_tmp115_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp115_ = (g_free (_tmp115_), NULL), _tmp116_);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
							vala_method_add_parameter (m, param);
							(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						} else {
							ValaFormalParameter* _tmp118_;
							char* _tmp117_;
							/* in argument*/
							_tmp118_ = NULL;
							_tmp117_ = NULL;
							vala_method_add_parameter (m, _tmp118_ = vala_formal_parameter_new (_tmp117_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (arg), NULL));
							(_tmp118_ == NULL) ? NULL : (_tmp118_ = (vala_code_node_unref (_tmp118_), NULL));
							_tmp117_ = (g_free (_tmp117_), NULL);
						}
					}
					param_nr++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			{
				GeeList* _tmp119_;
				GeeIterator* _tmp120_;
				GeeIterator* _param_it;
				_tmp119_ = NULL;
				_tmp120_ = NULL;
				_param_it = (_tmp120_ = gee_iterable_iterator ((GeeIterable*) (_tmp119_ = vala_method_get_parameters (m))), (_tmp119_ == NULL) ? NULL : (_tmp119_ = (gee_collection_object_unref (_tmp119_), NULL)), _tmp120_);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					vala_code_node_accept ((ValaCodeNode*) param, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			vala_ccode_module_generate_dynamic_method_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_METHOD (m));
		} else {
			if (VALA_IS_CREATION_METHOD (m)) {
				ValaCCodeExpression* _tmp125_;
				ValaCCodeCastExpression* _tmp124_;
				char* _tmp123_;
				char* _tmp122_;
				ValaCCodeIdentifier* _tmp121_;
				_tmp125_ = NULL;
				_tmp124_ = NULL;
				_tmp123_ = NULL;
				_tmp122_ = NULL;
				_tmp121_ = NULL;
				ccall_expr = (_tmp125_ = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp121_ = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp124_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp123_ = g_strconcat (_tmp122_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, FALSE), "*", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp125_);
				(_tmp124_ == NULL) ? NULL : (_tmp124_ = (vala_ccode_node_unref (_tmp124_), NULL));
				_tmp123_ = (g_free (_tmp123_), NULL);
				_tmp122_ = (g_free (_tmp122_), NULL);
				(_tmp121_ == NULL) ? NULL : (_tmp121_ = (vala_ccode_node_unref (_tmp121_), NULL));
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator ((GeeIterable*) params);
	{
		GeeList* _tmp126_;
		GeeIterator* _tmp127_;
		GeeIterator* _arg_it;
		_tmp126_ = NULL;
		_tmp127_ = NULL;
		_arg_it = (_tmp127_ = gee_iterable_iterator ((GeeIterable*) (_tmp126_ = vala_method_call_get_argument_list (expr))), (_tmp126_ == NULL) ? NULL : (_tmp126_ = (gee_collection_object_unref (_tmp126_), NULL)), _tmp127_);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			ValaCCodeExpression* _tmp128_;
			ValaCCodeExpression* cexpr;
			GeeHashMap* _tmp129_;
			GeeHashMap* carg_map;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			_tmp128_ = NULL;
			cexpr = (_tmp128_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp128_ == NULL) ? NULL : vala_ccode_node_ref (_tmp128_));
			_tmp129_ = NULL;
			carg_map = (_tmp129_ = in_arg_map, (_tmp129_ == NULL) ? NULL : gee_collection_object_ref (_tmp129_));
			if (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				gboolean _tmp130_;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				_tmp130_ = FALSE;
				if (vala_formal_parameter_get_params_array (param)) {
					_tmp130_ = TRUE;
				} else {
					_tmp130_ = vala_formal_parameter_get_ellipsis (param);
				}
				ellipsis = _tmp130_;
				if (!ellipsis) {
					gboolean _tmp131_;
					gboolean _tmp132_;
					gboolean multiple_cargs;
					gboolean _tmp139_;
					ValaCCodeExpression* _tmp169_;
					gboolean _tmp170_;
					gboolean _tmp176_;
					gboolean _tmp177_;
					gboolean _tmp178_;
					_tmp131_ = FALSE;
					_tmp132_ = FALSE;
					if (vala_formal_parameter_get_async_only (param)) {
						gboolean _tmp133_;
						_tmp133_ = FALSE;
						if (((ValaCCodeBaseModule*) self)->current_method == NULL) {
							_tmp133_ = TRUE;
						} else {
							_tmp133_ = !vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
						}
						_tmp132_ = _tmp133_;
					} else {
						_tmp132_ = FALSE;
					}
					if (_tmp132_) {
						gboolean _tmp134_;
						_tmp134_ = FALSE;
						if (ma == NULL) {
							_tmp134_ = TRUE;
						} else {
							_tmp134_ = _vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0;
						}
						_tmp131_ = _tmp134_;
					} else {
						_tmp131_ = FALSE;
					}
					if (_tmp131_) {
						ValaCCodeCommaExpression* comma;
						ValaCCodeExpression* _tmp136_;
						ValaCCodeExpression* _tmp135_;
						/* only skip if we are in a sync function (or property handler) 
						 and not manually starting async 
						 [CCode (async_only = true)] and we're making a
						 * synchronous version of the call.  Emit the arg
						 * at the start of a comma expression so that we
						 * get any side effects but otherwise ignore the
						 * value.
						 */
						comma = vala_ccode_comma_expression_new ();
						vala_ccode_comma_expression_append_expression (comma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)));
						vala_ccode_comma_expression_append_expression (comma, ccall_expr);
						_tmp136_ = NULL;
						_tmp135_ = NULL;
						ccall_expr = (_tmp136_ = (_tmp135_ = (ValaCCodeExpression*) comma, (_tmp135_ == NULL) ? NULL : vala_ccode_node_ref (_tmp135_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp136_);
						(comma == NULL) ? NULL : (comma = (vala_ccode_node_unref (comma), NULL));
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
						(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
						continue;
					}
					/* if the vala argument expands to multiple C arguments,
					 we have to make sure that the C arguments don't depend
					 on each other as there is no guaranteed argument
					 evaluation order
					 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
					multiple_cargs = FALSE;
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
						GeeHashMap* _tmp138_;
						GeeHashMap* _tmp137_;
						_tmp138_ = NULL;
						_tmp137_ = NULL;
						carg_map = (_tmp138_ = (_tmp137_ = out_arg_map, (_tmp137_ == NULL) ? NULL : gee_collection_object_ref (_tmp137_)), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), _tmp138_);
					}
					_tmp139_ = FALSE;
					if (!vala_formal_parameter_get_no_array_length (param)) {
						_tmp139_ = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp139_ = FALSE;
					}
					if (_tmp139_) {
						ValaArrayType* _tmp140_;
						ValaArrayType* array_type;
						_tmp140_ = NULL;
						array_type = (_tmp140_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp140_ == NULL) ? NULL : vala_code_node_ref (_tmp140_));
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								ValaCCodeExpression* _tmp141_;
								_tmp141_ = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp141_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
								(_tmp141_ == NULL) ? NULL : (_tmp141_ = (vala_ccode_node_unref (_tmp141_), NULL));
							}
						}
						multiple_cargs = TRUE;
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaDelegateType* _tmp142_;
							ValaDelegateType* deleg_type;
							ValaDelegate* _tmp143_;
							ValaDelegate* d;
							_tmp142_ = NULL;
							deleg_type = (_tmp142_ = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp142_ == NULL) ? NULL : vala_code_node_ref (_tmp142_));
							_tmp143_ = NULL;
							d = (_tmp143_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp143_ == NULL) ? NULL : vala_code_node_ref (_tmp143_));
							if (vala_delegate_get_has_target (d)) {
								ValaCCodeExpression* delegate_target;
								delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg);
								if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
									ValaCCodeExpression* delegate_target_destroy_notify;
									ValaMethod* _tmp145_;
									ValaSymbol* _tmp144_;
									ValaMethod* delegate_method;
									ValaLambdaExpression* _tmp147_;
									ValaExpression* _tmp146_;
									ValaLambdaExpression* lambda;
									ValaMemberAccess* _tmp149_;
									ValaExpression* _tmp148_;
									ValaMemberAccess* arg_ma;
									gboolean _tmp150_;
									gboolean _tmp151_;
									delegate_target_destroy_notify = NULL;
									_tmp145_ = NULL;
									_tmp144_ = NULL;
									delegate_method = (_tmp145_ = (_tmp144_ = vala_expression_get_symbol_reference (arg), VALA_IS_METHOD (_tmp144_) ? ((ValaMethod*) _tmp144_) : NULL), (_tmp145_ == NULL) ? NULL : vala_code_node_ref (_tmp145_));
									_tmp147_ = NULL;
									_tmp146_ = NULL;
									lambda = (_tmp147_ = (_tmp146_ = arg, VALA_IS_LAMBDA_EXPRESSION (_tmp146_) ? ((ValaLambdaExpression*) _tmp146_) : NULL), (_tmp147_ == NULL) ? NULL : vala_code_node_ref (_tmp147_));
									_tmp149_ = NULL;
									_tmp148_ = NULL;
									arg_ma = (_tmp149_ = (_tmp148_ = arg, VALA_IS_MEMBER_ACCESS (_tmp148_) ? ((ValaMemberAccess*) _tmp148_) : NULL), (_tmp149_ == NULL) ? NULL : vala_code_node_ref (_tmp149_));
									_tmp150_ = FALSE;
									_tmp151_ = FALSE;
									if (lambda != NULL) {
										_tmp151_ = ((ValaCCodeBaseModule*) self)->current_method != NULL;
									} else {
										_tmp151_ = FALSE;
									}
									if (_tmp151_) {
										_tmp150_ = vala_method_get_binding (((ValaCCodeBaseModule*) self)->current_method) == MEMBER_BINDING_INSTANCE;
									} else {
										_tmp150_ = FALSE;
									}
									if (_tmp150_) {
										ValaCCodeExpression* _tmp152_;
										ValaCCodeFunctionCall* _tmp153_;
										ValaCCodeFunctionCall* ref_call;
										ValaCCodeExpression* _tmp155_;
										ValaCCodeExpression* _tmp154_;
										ValaCCodeExpression* _tmp156_;
										/* type of delegate target is same as `this'
										 for lambda expressions in instance methods*/
										_tmp152_ = NULL;
										_tmp153_ = NULL;
										ref_call = (_tmp153_ = vala_ccode_function_call_new (_tmp152_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (vala_method_get_this_parameter (((ValaCCodeBaseModule*) self)->current_method)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp152_ == NULL) ? NULL : (_tmp152_ = (vala_ccode_node_unref (_tmp152_), NULL)), _tmp153_);
										vala_ccode_function_call_add_argument (ref_call, delegate_target);
										_tmp155_ = NULL;
										_tmp154_ = NULL;
										delegate_target = (_tmp155_ = (_tmp154_ = (ValaCCodeExpression*) ref_call, (_tmp154_ == NULL) ? NULL : vala_ccode_node_ref (_tmp154_)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp155_);
										_tmp156_ = NULL;
										delegate_target_destroy_notify = (_tmp156_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (vala_method_get_this_parameter (((ValaCCodeBaseModule*) self)->current_method))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp156_);
										(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
									} else {
										gboolean _tmp157_;
										gboolean _tmp158_;
										gboolean _tmp159_;
										gboolean _tmp160_;
										gboolean _tmp161_;
										_tmp157_ = FALSE;
										_tmp158_ = FALSE;
										_tmp159_ = FALSE;
										_tmp160_ = FALSE;
										_tmp161_ = FALSE;
										if (delegate_method != NULL) {
											_tmp161_ = vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE;
										} else {
											_tmp161_ = FALSE;
										}
										if (_tmp161_) {
											_tmp160_ = arg_ma != NULL;
										} else {
											_tmp160_ = FALSE;
										}
										if (_tmp160_) {
											_tmp159_ = vala_member_access_get_inner (arg_ma) != NULL;
										} else {
											_tmp159_ = FALSE;
										}
										if (_tmp159_) {
											_tmp158_ = vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))) != NULL;
										} else {
											_tmp158_ = FALSE;
										}
										if (_tmp158_) {
											_tmp157_ = vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))));
										} else {
											_tmp157_ = FALSE;
										}
										if (_tmp157_) {
											ValaCCodeExpression* _tmp162_;
											ValaCCodeFunctionCall* _tmp163_;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp165_;
											ValaCCodeExpression* _tmp164_;
											ValaCCodeExpression* _tmp166_;
											_tmp162_ = NULL;
											_tmp163_ = NULL;
											ref_call = (_tmp163_ = vala_ccode_function_call_new (_tmp162_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp162_ == NULL) ? NULL : (_tmp162_ = (vala_ccode_node_unref (_tmp162_), NULL)), _tmp163_);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp165_ = NULL;
											_tmp164_ = NULL;
											delegate_target = (_tmp165_ = (_tmp164_ = (ValaCCodeExpression*) ref_call, (_tmp164_ == NULL) ? NULL : vala_ccode_node_ref (_tmp164_)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp165_);
											_tmp166_ = NULL;
											delegate_target_destroy_notify = (_tmp166_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp166_);
											(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
										} else {
											ValaCCodeExpression* _tmp167_;
											_tmp167_ = NULL;
											delegate_target_destroy_notify = (_tmp167_ = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp167_);
										}
									}
									gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
									(delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL));
									(delegate_method == NULL) ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL));
									(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
									(arg_ma == NULL) ? NULL : (arg_ma = (vala_code_node_unref (arg_ma), NULL));
								}
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
								multiple_cargs = TRUE;
								(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
							}
							(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
							(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
						} else {
							if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeExpression* _tmp168_;
								_tmp168_ = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp168_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg));
								(_tmp168_ == NULL) ? NULL : (_tmp168_ = (vala_ccode_node_unref (_tmp168_), NULL));
								multiple_cargs = TRUE;
							}
						}
					}
					_tmp169_ = NULL;
					cexpr = (_tmp169_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp169_);
					_tmp170_ = FALSE;
					if (multiple_cargs) {
						_tmp170_ = VALA_IS_METHOD_CALL (arg);
					} else {
						_tmp170_ = FALSE;
					}
					if (_tmp170_) {
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_decl;
						ValaCCodeAssignment* _tmp172_;
						ValaCCodeExpression* _tmp171_;
						ValaCCodeExpression* _tmp173_;
						ValaCCodeExpression* _tmp175_;
						ValaCCodeExpression* _tmp174_;
						/* if vala argument is invocation expression
						 the auxiliary C argument(s) will depend on the main C argument
						 (tmp = arg1, call (tmp, arg2, arg3,...))*/
						ccomma = vala_ccode_comma_expression_new ();
						temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg), TRUE, NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
						_tmp172_ = NULL;
						_tmp171_ = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp172_ = vala_ccode_assignment_new (_tmp171_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp172_ == NULL) ? NULL : (_tmp172_ = (vala_ccode_node_unref (_tmp172_), NULL));
						(_tmp171_ == NULL) ? NULL : (_tmp171_ = (vala_ccode_node_unref (_tmp171_), NULL));
						_tmp173_ = NULL;
						cexpr = (_tmp173_ = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp173_);
						vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						_tmp175_ = NULL;
						_tmp174_ = NULL;
						ccall_expr = (_tmp175_ = (_tmp174_ = (ValaCCodeExpression*) ccomma, (_tmp174_ == NULL) ? NULL : vala_ccode_node_ref (_tmp174_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp175_);
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
					}
					_tmp176_ = FALSE;
					_tmp177_ = FALSE;
					_tmp178_ = FALSE;
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						_tmp178_ = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg));
					} else {
						_tmp178_ = FALSE;
					}
					if (_tmp178_) {
						gboolean _tmp179_;
						_tmp179_ = FALSE;
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							_tmp179_ = TRUE;
						} else {
							_tmp179_ = !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param));
						}
						_tmp177_ = _tmp179_;
					} else {
						_tmp177_ = FALSE;
					}
					if (_tmp177_) {
						_tmp176_ = !VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp176_ = FALSE;
					}
					/* unref old value for non-null non-weak ref/out arguments
					 disabled for arrays for now as that requires special handling
					 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
					if (_tmp176_) {
						ValaUnaryExpression* _tmp180_;
						ValaUnaryExpression* unary;
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* _tmp182_;
						ValaCCodeExpression* _tmp181_;
						ValaLocalVariable* ret_temp_var;
						ValaDataType* _tmp187_;
						gboolean _tmp188_;
						ValaCCodeCommaExpression* cassign_comma;
						ValaLocalVariable* assign_temp_var;
						ValaCCodeAssignment* _tmp196_;
						ValaCCodeExpression* _tmp195_;
						ValaCCodeExpression* _tmp194_;
						ValaCCodeExpression* _tmp193_;
						ValaCCodeExpression* _tmp197_;
						ValaCCodeExpression* _tmp198_;
						ValaCCodeAssignment* _tmp199_;
						ValaDataType* _tmp200_;
						gboolean _tmp201_;
						ValaCCodeExpression* _tmp204_;
						ValaCCodeExpression* _tmp203_;
						_tmp180_ = NULL;
						unary = (_tmp180_ = VALA_UNARY_EXPRESSION (arg), (_tmp180_ == NULL) ? NULL : vala_code_node_ref (_tmp180_));
						ccomma = vala_ccode_comma_expression_new ();
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp182_ = NULL;
						_tmp181_ = NULL;
						cexpr = (_tmp182_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp181_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp182_);
						(_tmp181_ == NULL) ? NULL : (_tmp181_ = (vala_ccode_node_unref (_tmp181_), NULL));
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
							ValaCCodeCommaExpression* crefcomma;
							ValaCCodeAssignment* _tmp184_;
							ValaCCodeExpression* _tmp183_;
							ValaCCodeExpression* _tmp186_;
							ValaCCodeExpression* _tmp185_;
							crefcomma = vala_ccode_comma_expression_new ();
							_tmp184_ = NULL;
							_tmp183_ = NULL;
							vala_ccode_comma_expression_append_expression (crefcomma, (ValaCCodeExpression*) (_tmp184_ = vala_ccode_assignment_new (_tmp183_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp184_ == NULL) ? NULL : (_tmp184_ = (vala_ccode_node_unref (_tmp184_), NULL));
							(_tmp183_ == NULL) ? NULL : (_tmp183_ = (vala_ccode_node_unref (_tmp183_), NULL));
							vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
							_tmp186_ = NULL;
							_tmp185_ = NULL;
							cexpr = (_tmp186_ = (_tmp185_ = (ValaCCodeExpression*) crefcomma, (_tmp185_ == NULL) ? NULL : vala_ccode_node_ref (_tmp185_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp186_);
							(crefcomma == NULL) ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL));
						}
						/* call function*/
						ret_temp_var = NULL;
						_tmp187_ = NULL;
						if ((_tmp188_ = VALA_IS_VOID_TYPE (_tmp187_ = vala_data_type_get_return_type (itype)), (_tmp187_ == NULL) ? NULL : (_tmp187_ = (vala_code_node_unref (_tmp187_), NULL)), _tmp188_)) {
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						} else {
							ValaLocalVariable* _tmp190_;
							ValaDataType* _tmp189_;
							ValaCCodeAssignment* _tmp192_;
							ValaCCodeExpression* _tmp191_;
							_tmp190_ = NULL;
							_tmp189_ = NULL;
							ret_temp_var = (_tmp190_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp189_ = vala_data_type_get_return_type (itype), TRUE, NULL), (ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)), _tmp190_);
							(_tmp189_ == NULL) ? NULL : (_tmp189_ = (vala_code_node_unref (_tmp189_), NULL));
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, ret_temp_var);
							_tmp192_ = NULL;
							_tmp191_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp192_ = vala_ccode_assignment_new (_tmp191_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp192_ == NULL) ? NULL : (_tmp192_ = (vala_ccode_node_unref (_tmp192_), NULL));
							(_tmp191_ == NULL) ? NULL : (_tmp191_ = (vala_ccode_node_unref (_tmp191_), NULL));
						}
						cassign_comma = vala_ccode_comma_expression_new ();
						assign_temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, assign_temp_var);
						_tmp196_ = NULL;
						_tmp195_ = NULL;
						_tmp194_ = NULL;
						_tmp193_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp196_ = vala_ccode_assignment_new (_tmp193_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)), _tmp195_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, _tmp194_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp196_ == NULL) ? NULL : (_tmp196_ = (vala_ccode_node_unref (_tmp196_), NULL));
						(_tmp195_ == NULL) ? NULL : (_tmp195_ = (vala_ccode_node_unref (_tmp195_), NULL));
						(_tmp194_ == NULL) ? NULL : (_tmp194_ = (vala_ccode_node_unref (_tmp194_), NULL));
						(_tmp193_ == NULL) ? NULL : (_tmp193_ = (vala_ccode_node_unref (_tmp193_), NULL));
						/* unref old value*/
						_tmp197_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp197_ = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), vala_expression_get_value_type (arg), arg));
						(_tmp197_ == NULL) ? NULL : (_tmp197_ = (vala_ccode_node_unref (_tmp197_), NULL));
						_tmp198_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp198_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)));
						(_tmp198_ == NULL) ? NULL : (_tmp198_ = (vala_ccode_node_unref (_tmp198_), NULL));
						/* assign new value*/
						_tmp199_ = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp199_ = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), (ValaCCodeExpression*) cassign_comma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp199_ == NULL) ? NULL : (_tmp199_ = (vala_ccode_node_unref (_tmp199_), NULL));
						/* return value*/
						_tmp200_ = NULL;
						if ((_tmp201_ = !VALA_IS_VOID_TYPE (_tmp200_ = vala_data_type_get_return_type (itype)), (_tmp200_ == NULL) ? NULL : (_tmp200_ = (vala_code_node_unref (_tmp200_), NULL)), _tmp201_)) {
							ValaCCodeExpression* _tmp202_;
							_tmp202_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, _tmp202_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)));
							(_tmp202_ == NULL) ? NULL : (_tmp202_ = (vala_ccode_node_unref (_tmp202_), NULL));
						}
						_tmp204_ = NULL;
						_tmp203_ = NULL;
						ccall_expr = (_tmp204_ = (_tmp203_ = (ValaCCodeExpression*) ccomma, (_tmp203_ == NULL) ? NULL : vala_ccode_node_ref (_tmp203_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp204_);
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL));
						(cassign_comma == NULL) ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL));
						(assign_temp_var == NULL) ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL));
					}
					if (vala_formal_parameter_get_ctype (param) != NULL) {
						ValaCCodeExpression* _tmp205_;
						_tmp205_ = NULL;
						cexpr = (_tmp205_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp205_);
					}
				}
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			} else {
				/* default argument position*/
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) i, ellipsis);
			}
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
			(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	if (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		gboolean _tmp206_;
		param = (ValaFormalParameter*) gee_iterator_get (params_it);
		_tmp206_ = FALSE;
		if (vala_formal_parameter_get_params_array (param)) {
			_tmp206_ = TRUE;
		} else {
			_tmp206_ = vala_formal_parameter_get_ellipsis (param);
		}
		/* if there are more parameters than arguments,
		 * the additional parameter is an ellipsis parameter
		 * otherwise there is a bug in the semantic analyzer
		 */
		g_assert (_tmp206_);
		ellipsis = TRUE;
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	_tmp207_ = FALSE;
	if (m != NULL) {
		_tmp207_ = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp207_ = FALSE;
	}
	/* add length argument for methods returning arrays */
	if (_tmp207_) {
		ValaArrayType* _tmp208_;
		ValaArrayType* array_type;
		_tmp208_ = NULL;
		array_type = (_tmp208_ = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp208_ == NULL) ? NULL : vala_code_node_ref (_tmp208_));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (vala_method_get_array_null_terminated (m)) {
					ValaDataType* _tmp209_;
					ValaLocalVariable* _tmp210_;
					ValaLocalVariable* temp_var;
					ValaCCodeExpression* temp_ref;
					ValaCCodeExpression* _tmp211_;
					ValaCCodeIdentifier* _tmp212_;
					ValaCCodeFunctionCall* _tmp213_;
					ValaCCodeFunctionCall* len_call;
					/* handle calls to methods returning null-terminated arrays*/
					_tmp209_ = NULL;
					_tmp210_ = NULL;
					temp_var = (_tmp210_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp209_ = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp209_ == NULL) ? NULL : (_tmp209_ = (vala_code_node_unref (_tmp209_), NULL)), _tmp210_);
					temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp211_ = NULL;
					ccall_expr = (_tmp211_ = (ValaCCodeExpression*) vala_ccode_assignment_new (temp_ref, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp211_);
					((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
					_tmp212_ = NULL;
					_tmp213_ = NULL;
					len_call = (_tmp213_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp212_ = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp212_ == NULL) ? NULL : (_tmp212_ = (vala_ccode_node_unref (_tmp212_), NULL)), _tmp213_);
					vala_ccode_function_call_add_argument (len_call, temp_ref);
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) len_call);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
				} else {
					if (!vala_method_get_no_array_length (m)) {
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* temp_ref;
						ValaCCodeUnaryExpression* _tmp214_;
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
						temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp214_ = NULL;
						gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp214_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
						(_tmp214_ == NULL) ? NULL : (_tmp214_ = (vala_ccode_node_unref (_tmp214_), NULL));
						vala_method_call_append_array_size (expr, temp_ref);
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					} else {
						ValaCCodeConstant* _tmp215_;
						_tmp215_ = NULL;
						vala_method_call_append_array_size (expr, (ValaCCodeExpression*) (_tmp215_ = vala_ccode_constant_new ("-1")));
						(_tmp215_ == NULL) ? NULL : (_tmp215_ = (vala_ccode_node_unref (_tmp215_), NULL));
					}
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp216_;
		_tmp216_ = FALSE;
		if (m != NULL) {
			_tmp216_ = VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m));
		} else {
			_tmp216_ = FALSE;
		}
		if (_tmp216_) {
			ValaDelegateType* _tmp217_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp218_;
			ValaDelegate* d;
			_tmp217_ = NULL;
			deleg_type = (_tmp217_ = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp217_ == NULL) ? NULL : vala_code_node_ref (_tmp217_));
			_tmp218_ = NULL;
			d = (_tmp218_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp218_ == NULL) ? NULL : vala_code_node_ref (_tmp218_));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp220_;
				ValaVoidType* _tmp219_;
				ValaLocalVariable* _tmp221_;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp222_;
				_tmp220_ = NULL;
				_tmp219_ = NULL;
				_tmp221_ = NULL;
				temp_var = (_tmp221_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp220_ = vala_pointer_type_new ((ValaDataType*) (_tmp219_ = vala_void_type_new (NULL)), NULL)), TRUE, NULL), (_tmp220_ == NULL) ? NULL : (_tmp220_ = (vala_code_node_unref (_tmp220_), NULL)), (_tmp219_ == NULL) ? NULL : (_tmp219_ = (vala_code_node_unref (_tmp219_), NULL)), _tmp221_);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp222_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp222_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp222_ == NULL) ? NULL : (_tmp222_ = (vala_ccode_node_unref (_tmp222_), NULL));
				vala_method_call_set_delegate_target (expr, temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp223_ = FALSE;
	if (m != NULL) {
		_tmp223_ = vala_method_get_coroutine (m);
	} else {
		_tmp223_ = FALSE;
	}
	if (_tmp223_) {
		gboolean _tmp224_;
		gboolean _tmp225_;
		_tmp224_ = FALSE;
		_tmp225_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp225_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp225_ = FALSE;
		}
		if (_tmp225_) {
			_tmp224_ = TRUE;
		} else {
			gboolean _tmp226_;
			_tmp226_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp226_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp226_ = FALSE;
			}
			_tmp224_ = _tmp226_;
		}
		if (_tmp224_) {
			gboolean _tmp227_;
			_tmp227_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp227_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp227_ = FALSE;
			}
			/* asynchronous call*/
			if (_tmp227_) {
				ValaCCodeConstant* _tmp228_;
				ValaCCodeConstant* _tmp229_;
				_tmp228_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp228_ = vala_ccode_constant_new ("NULL")));
				(_tmp228_ == NULL) ? NULL : (_tmp228_ = (vala_ccode_node_unref (_tmp228_), NULL));
				_tmp229_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp229_ = vala_ccode_constant_new ("NULL")));
				(_tmp229_ == NULL) ? NULL : (_tmp229_ = (vala_ccode_node_unref (_tmp229_), NULL));
			} else {
				ValaCCodeIdentifier* _tmp232_;
				char* _tmp231_;
				char* _tmp230_;
				ValaCCodeIdentifier* _tmp233_;
				_tmp232_ = NULL;
				_tmp231_ = NULL;
				_tmp230_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp232_ = vala_ccode_identifier_new (_tmp231_ = g_strconcat (_tmp230_ = vala_method_get_cname (((ValaCCodeBaseModule*) self)->current_method), "_ready", NULL))));
				(_tmp232_ == NULL) ? NULL : (_tmp232_ = (vala_ccode_node_unref (_tmp232_), NULL));
				_tmp231_ = (g_free (_tmp231_), NULL);
				_tmp230_ = (g_free (_tmp230_), NULL);
				_tmp233_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp233_ = vala_ccode_identifier_new ("data")));
				(_tmp233_ == NULL) ? NULL : (_tmp233_ = (vala_ccode_node_unref (_tmp233_), NULL));
			}
		}
	}
	_tmp234_ = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeList* _tmp235_;
		_tmp235_ = NULL;
		_tmp234_ = gee_collection_get_size ((GeeCollection*) (_tmp235_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0;
		(_tmp235_ == NULL) ? NULL : (_tmp235_ = (gee_collection_object_unref (_tmp235_), NULL));
	} else {
		_tmp234_ = FALSE;
	}
	if (_tmp234_) {
		ValaCCodeIdentifier* _tmp236_;
		_tmp236_ = NULL;
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp236_ = vala_ccode_identifier_new ("error")));
		(_tmp236_ == NULL) ? NULL : (_tmp236_ = (vala_ccode_node_unref (_tmp236_), NULL));
	} else {
		if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
			ValaCCodeUnaryExpression* _tmp238_;
			ValaCCodeExpression* _tmp237_;
			/* method can fail*/
			((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
			/* add &inner_error before the ellipsis arguments*/
			_tmp238_ = NULL;
			_tmp237_ = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp238_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp237_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_"))));
			(_tmp238_ == NULL) ? NULL : (_tmp238_ = (vala_ccode_node_unref (_tmp238_), NULL));
			(_tmp237_ == NULL) ? NULL : (_tmp237_ = (vala_ccode_node_unref (_tmp237_), NULL));
		}
	}
	if (ellipsis) {
		gboolean _tmp239_;
		_tmp239_ = FALSE;
		if (!vala_method_get_printf_format (m)) {
			_tmp239_ = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
		} else {
			_tmp239_ = FALSE;
		}
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (_tmp239_) {
			ValaCCodeConstant* _tmp240_;
			_tmp240_ = NULL;
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp240_ = vala_ccode_constant_new (vala_method_get_sentinel (m))));
			(_tmp240_ == NULL) ? NULL : (_tmp240_ = (vala_ccode_node_unref (_tmp240_), NULL));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp241_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp242_;
			ValaDelegate* d;
			_tmp241_ = NULL;
			deleg_type = (_tmp241_ = VALA_DELEGATE_TYPE (itype), (_tmp241_ == NULL) ? NULL : vala_code_node_ref (_tmp241_));
			_tmp242_ = NULL;
			d = (_tmp242_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp242_ == NULL) ? NULL : vala_code_node_ref (_tmp242_));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp243_;
				ValaCCodeExpression* _tmp244_;
				_tmp243_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp243_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp243_ == NULL) ? NULL : (_tmp243_ = (vala_ccode_node_unref (_tmp243_), NULL));
				_tmp244_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp244_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp244_ == NULL) ? NULL : (_tmp244_ = (vala_ccode_node_unref (_tmp244_), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp245_ = FALSE;
	if (VALA_IS_SIGNAL_TYPE (itype)) {
		ValaDataType* _tmp246_;
		_tmp246_ = NULL;
		_tmp245_ = !VALA_IS_VOID_TYPE (_tmp246_ = vala_data_type_get_return_type (itype));
		(_tmp246_ == NULL) ? NULL : (_tmp246_ = (vala_code_node_unref (_tmp246_), NULL));
	} else {
		_tmp245_ = FALSE;
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	if (_tmp245_) {
		ValaSignal* _tmp247_;
		ValaSignal* sig;
		gboolean _tmp248_;
		gboolean _tmp249_;
		_tmp247_ = NULL;
		sig = (_tmp247_ = vala_signal_type_get_signal_symbol (VALA_SIGNAL_TYPE (itype)), (_tmp247_ == NULL) ? NULL : vala_code_node_ref (_tmp247_));
		_tmp248_ = FALSE;
		_tmp249_ = FALSE;
		if (ma != NULL) {
			_tmp249_ = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
		} else {
			_tmp249_ = FALSE;
		}
		if (_tmp249_) {
			_tmp248_ = vala_signal_get_is_virtual (sig);
		} else {
			_tmp248_ = FALSE;
		}
		if (_tmp248_) {
		} else {
			if (!vala_signal_get_has_emitter (sig)) {
				ValaDataType* _tmp250_;
				ValaLocalVariable* _tmp251_;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp252_;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp254_;
				ValaCCodeExpression* _tmp253_;
				_tmp250_ = NULL;
				_tmp251_ = NULL;
				temp_var = (_tmp251_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp250_ = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp250_ == NULL) ? NULL : (_tmp250_ = (vala_code_node_unref (_tmp250_), NULL)), _tmp251_);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp252_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp252_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp252_ == NULL) ? NULL : (_tmp252_ = (vala_ccode_node_unref (_tmp252_), NULL));
				ccomma = vala_ccode_comma_expression_new ();
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
				_tmp254_ = NULL;
				_tmp253_ = NULL;
				ccall_expr = (_tmp254_ = (_tmp253_ = (ValaCCodeExpression*) ccomma, (_tmp253_ == NULL) ? NULL : vala_ccode_node_ref (_tmp253_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp254_);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	}
	/* append C arguments in the right order*/
	last_pos = 0;
	min_pos = 0;
	if (async_call != ccall) {
		/* don't append out arguments for .begin() calls*/
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp259_;
			min_pos = -1;
			{
				GeeSet* _tmp255_;
				GeeIterator* _tmp256_;
				GeeIterator* _pos_it;
				_tmp255_ = NULL;
				_tmp256_ = NULL;
				_pos_it = (_tmp256_ = gee_iterable_iterator ((GeeIterable*) (_tmp255_ = gee_map_get_keys ((GeeMap*) out_arg_map))), (_tmp255_ == NULL) ? NULL : (_tmp255_ = (gee_collection_object_unref (_tmp255_), NULL)), _tmp256_);
				while (gee_iterator_next (_pos_it)) {
					gint pos;
					gboolean _tmp257_;
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp257_ = FALSE;
					if (pos > last_pos) {
						gboolean _tmp258_;
						_tmp258_ = FALSE;
						if (min_pos == (-1)) {
							_tmp258_ = TRUE;
						} else {
							_tmp258_ = pos < min_pos;
						}
						_tmp257_ = _tmp258_;
					} else {
						_tmp257_ = FALSE;
					}
					if (_tmp257_) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp259_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp259_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) out_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp259_ == NULL) ? NULL : (_tmp259_ = (vala_ccode_node_unref (_tmp259_), NULL));
			last_pos = min_pos;
		}
	}
	if (async_call != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp264_;
			min_pos = -1;
			{
				GeeSet* _tmp260_;
				GeeIterator* _tmp261_;
				GeeIterator* _pos_it;
				_tmp260_ = NULL;
				_tmp261_ = NULL;
				_pos_it = (_tmp261_ = gee_iterable_iterator ((GeeIterable*) (_tmp260_ = gee_map_get_keys ((GeeMap*) in_arg_map))), (_tmp260_ == NULL) ? NULL : (_tmp260_ = (gee_collection_object_unref (_tmp260_), NULL)), _tmp261_);
				while (gee_iterator_next (_pos_it)) {
					gint pos;
					gboolean _tmp262_;
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp262_ = FALSE;
					if (pos > last_pos) {
						gboolean _tmp263_;
						_tmp263_ = FALSE;
						if (min_pos == (-1)) {
							_tmp263_ = TRUE;
						} else {
							_tmp263_ = pos < min_pos;
						}
						_tmp262_ = _tmp263_;
					} else {
						_tmp262_ = FALSE;
					}
					if (_tmp262_) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp264_ = NULL;
			vala_ccode_function_call_add_argument (async_call, _tmp264_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) in_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp264_ == NULL) ? NULL : (_tmp264_ = (vala_ccode_node_unref (_tmp264_), NULL));
			last_pos = min_pos;
		}
	}
	_tmp265_ = FALSE;
	_tmp266_ = FALSE;
	if (m != NULL) {
		_tmp266_ = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp266_ = FALSE;
	}
	if (_tmp266_) {
		_tmp265_ = vala_method_get_returns_modified_pointer (m);
	} else {
		_tmp265_ = FALSE;
	}
	if (_tmp265_) {
		ValaCCodeAssignment* _tmp267_;
		_tmp267_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp267_ = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp267_ == NULL) ? NULL : (_tmp267_ = (vala_ccode_node_unref (_tmp267_), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall_expr);
	}
	_tmp268_ = FALSE;
	_tmp269_ = FALSE;
	_tmp270_ = FALSE;
	if (m != NULL) {
		_tmp270_ = vala_method_get_coroutine (m);
	} else {
		_tmp270_ = FALSE;
	}
	if (_tmp270_) {
		_tmp269_ = ((ValaCCodeBaseModule*) self)->current_method != NULL;
	} else {
		_tmp269_ = FALSE;
	}
	if (_tmp269_) {
		_tmp268_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp268_ = FALSE;
	}
	if (_tmp268_) {
		gboolean _tmp271_;
		_tmp271_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0) {
			_tmp271_ = TRUE;
		} else {
			_tmp271_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) != vala_expression_get_symbol_reference ((ValaExpression*) ma);
		}
		if (_tmp271_) {
			ValaCCodeExpressionStatement* _tmp273_;
			gint state;
			ValaCCodeExpressionStatement* _tmp279_;
			ValaCCodeAssignment* _tmp278_;
			ValaCCodeConstant* _tmp277_;
			char* _tmp276_;
			ValaCCodeMemberAccess* _tmp275_;
			ValaCCodeIdentifier* _tmp274_;
			ValaCCodeReturnStatement* _tmp281_;
			ValaCCodeConstant* _tmp280_;
			ValaCCodeCaseStatement* _tmp284_;
			ValaCCodeConstant* _tmp283_;
			char* _tmp282_;
			if (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) {
				ValaCCodeFragment* _tmp272_;
				_tmp272_ = NULL;
				((ValaCCodeBaseModule*) self)->pre_statement_fragment = (_tmp272_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->pre_statement_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->pre_statement_fragment), NULL)), _tmp272_);
			}
			_tmp273_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp273_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) async_call)));
			(_tmp273_ == NULL) ? NULL : (_tmp273_ = (vala_ccode_node_unref (_tmp273_), NULL));
			state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
			_tmp279_ = NULL;
			_tmp278_ = NULL;
			_tmp277_ = NULL;
			_tmp276_ = NULL;
			_tmp275_ = NULL;
			_tmp274_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp279_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp278_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp275_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp274_ = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp277_ = vala_ccode_constant_new (_tmp276_ = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp279_ == NULL) ? NULL : (_tmp279_ = (vala_ccode_node_unref (_tmp279_), NULL));
			(_tmp278_ == NULL) ? NULL : (_tmp278_ = (vala_ccode_node_unref (_tmp278_), NULL));
			(_tmp277_ == NULL) ? NULL : (_tmp277_ = (vala_ccode_node_unref (_tmp277_), NULL));
			_tmp276_ = (g_free (_tmp276_), NULL);
			(_tmp275_ == NULL) ? NULL : (_tmp275_ = (vala_ccode_node_unref (_tmp275_), NULL));
			(_tmp274_ == NULL) ? NULL : (_tmp274_ = (vala_ccode_node_unref (_tmp274_), NULL));
			_tmp281_ = NULL;
			_tmp280_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp281_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp280_ = vala_ccode_constant_new ("FALSE")))));
			(_tmp281_ == NULL) ? NULL : (_tmp281_ = (vala_ccode_node_unref (_tmp281_), NULL));
			(_tmp280_ == NULL) ? NULL : (_tmp280_ = (vala_ccode_node_unref (_tmp280_), NULL));
			_tmp284_ = NULL;
			_tmp283_ = NULL;
			_tmp282_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp284_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp283_ = vala_ccode_constant_new (_tmp282_ = g_strdup_printf ("%i", state))))));
			(_tmp284_ == NULL) ? NULL : (_tmp284_ = (vala_ccode_node_unref (_tmp284_), NULL));
			(_tmp283_ == NULL) ? NULL : (_tmp283_ = (vala_ccode_node_unref (_tmp283_), NULL));
			_tmp282_ = (g_free (_tmp282_), NULL);
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp285_;
		GeeIterator* _tmp286_;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp288_;
		ValaExpression* _tmp287_;
		ValaCCodeExpression* _tmp289_;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp290_;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp291_;
		ValaArrayType* array_type;
		char* _tmp293_;
		char* _tmp292_;
		ValaCCodeIdentifier* _tmp294_;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp295_;
		ValaCCodeFunctionCall* _tmp296_;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp297_;
		ValaCCodeConstant* _tmp298_;
		ValaCCodeBinaryExpression* _tmp299_;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp300_;
		ValaCCodeConditionalExpression* _tmp302_;
		ValaCCodeConstant* _tmp301_;
		ValaCCodeAssignment* _tmp304_;
		ValaCCodeExpression* _tmp303_;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp285_ = NULL;
		_tmp286_ = NULL;
		arg_it = (_tmp286_ = gee_iterable_iterator ((GeeIterable*) (_tmp285_ = vala_method_call_get_argument_list (expr))), (_tmp285_ == NULL) ? NULL : (_tmp285_ = (gee_collection_object_unref (_tmp285_), NULL)), _tmp286_);
		gee_iterator_next (arg_it);
		_tmp288_ = NULL;
		_tmp287_ = NULL;
		_tmp289_ = NULL;
		new_size = (_tmp289_ = (_tmp288_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp287_ = (ValaExpression*) gee_iterator_get (arg_it)))), (_tmp288_ == NULL) ? NULL : vala_ccode_node_ref (_tmp288_)), (_tmp287_ == NULL) ? NULL : (_tmp287_ = (vala_code_node_unref (_tmp287_), NULL)), _tmp289_);
		temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
		temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
		/* memset needs string.h */
		vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
		clen = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1);
		_tmp290_ = NULL;
		celems = (_tmp290_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp290_ == NULL) ? NULL : vala_ccode_node_ref (_tmp290_));
		_tmp291_ = NULL;
		array_type = (_tmp291_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp291_ == NULL) ? NULL : vala_code_node_ref (_tmp291_));
		_tmp293_ = NULL;
		_tmp292_ = NULL;
		_tmp294_ = NULL;
		csizeof = (_tmp294_ = vala_ccode_identifier_new (_tmp293_ = g_strdup_printf ("sizeof (%s)", _tmp292_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))), _tmp293_ = (g_free (_tmp293_), NULL), _tmp292_ = (g_free (_tmp292_), NULL), _tmp294_);
		cdelta = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, temp_ref, clen);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, temp_ref, clen);
		_tmp295_ = NULL;
		_tmp296_ = NULL;
		czero = (_tmp296_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp295_ = vala_ccode_identifier_new ("memset"))), (_tmp295_ == NULL) ? NULL : (_tmp295_ = (vala_ccode_node_unref (_tmp295_), NULL)), _tmp296_);
		_tmp297_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp297_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen)));
		(_tmp297_ == NULL) ? NULL : (_tmp297_ = (vala_ccode_node_unref (_tmp297_), NULL));
		_tmp298_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp298_ = vala_ccode_constant_new ("0")));
		(_tmp298_ == NULL) ? NULL : (_tmp298_ = (vala_ccode_node_unref (_tmp298_), NULL));
		_tmp299_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp299_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) csizeof, (ValaCCodeExpression*) cdelta)));
		(_tmp299_ == NULL) ? NULL : (_tmp299_ = (vala_ccode_node_unref (_tmp299_), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp300_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp300_ = vala_ccode_assignment_new (temp_ref, new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp300_ == NULL) ? NULL : (_tmp300_ = (vala_ccode_node_unref (_tmp300_), NULL));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp302_ = NULL;
		_tmp301_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp302_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccheck, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) (_tmp301_ = vala_ccode_constant_new ("NULL")))));
		(_tmp302_ == NULL) ? NULL : (_tmp302_ = (vala_ccode_node_unref (_tmp302_), NULL));
		(_tmp301_ == NULL) ? NULL : (_tmp301_ = (vala_ccode_node_unref (_tmp301_), NULL));
		_tmp304_ = NULL;
		_tmp303_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp304_ = vala_ccode_assignment_new (_tmp303_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1), temp_ref, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp304_ == NULL) ? NULL : (_tmp304_ = (vala_ccode_node_unref (_tmp304_), NULL));
		(_tmp303_ == NULL) ? NULL : (_tmp303_ = (vala_ccode_node_unref (_tmp303_), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
		(clen == NULL) ? NULL : (clen = (vala_ccode_node_unref (clen), NULL));
		(celems == NULL) ? NULL : (celems = (vala_ccode_node_unref (celems), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
		(cdelta == NULL) ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL));
		(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
		(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	}
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
	(in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL));
	(out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL));
	(ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL));
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
}


static void vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass) {
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_method_call_module_real_visit_method_call;
}


static void vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self) {
}


GType vala_ccode_method_call_module_get_type (void) {
	static GType vala_ccode_method_call_module_type_id = 0;
	if (vala_ccode_method_call_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_call_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




