/* valagtypemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_INTERFACE_REGISTER_FUNCTION (vala_interface_register_function_get_type ())
#define VALA_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunction))
#define VALA_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_INTERFACE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))

typedef struct _ValaInterfaceRegisterFunction ValaInterfaceRegisterFunction;
typedef struct _ValaInterfaceRegisterFunctionClass ValaInterfaceRegisterFunctionClass;

#define VALA_TYPE_STRUCT_REGISTER_FUNCTION (vala_struct_register_function_get_type ())
#define VALA_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunction))
#define VALA_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))
#define VALA_IS_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_IS_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_STRUCT_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))

typedef struct _ValaStructRegisterFunction ValaStructRegisterFunction;
typedef struct _ValaStructRegisterFunctionClass ValaStructRegisterFunctionClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
enum  {
	VALA_GTYPE_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaGErrorModule* vala_gerror_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGErrorModule* vala_gerror_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGTypeModule* vala_gtype_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
void vala_ccode_base_module_generate_class_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_interface_declaration (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
char* vala_ccode_base_module_get_type_check_function (ValaCCodeBaseModule* self, ValaTypeSymbol* type);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_base_module_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
ValaInterfaceRegisterFunction* vala_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context);
ValaInterfaceRegisterFunction* vala_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context);
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_interface_register_function_get_type (void);
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self);
static void vala_gtype_module_real_generate_interface_declaration (ValaCCodeBaseModule* base, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
static void vala_gtype_module_add_interface_base_init_function (ValaGTypeModule* self, ValaInterface* iface);
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self);
static void vala_gtype_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
ValaCCodeFunctionCall* vala_ccode_module_get_param_spec (ValaCCodeModule* self, ValaProperty* prop);
ValaCCodeFunctionCall* vala_ccode_module_get_signal_creation (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
ValaCCodeFragment* vala_ccode_module_register_dbus_info (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
void vala_ccode_module_visit_struct (ValaCCodeModule* self, ValaStruct* st);
ValaStructRegisterFunction* vala_struct_register_function_new (ValaStruct* st, ValaCodeContext* context);
ValaStructRegisterFunction* vala_struct_register_function_construct (GType object_type, ValaStruct* st, ValaCodeContext* context);
GType vala_struct_register_function_get_type (void);
static void vala_gtype_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st);
static gpointer vala_gtype_module_parent_class = NULL;



ValaGTypeModule* vala_gtype_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGTypeModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGTypeModule*) vala_gerror_module_construct (object_type, codegen, next);
	return self;
}


ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gtype_module_construct (VALA_TYPE_GTYPE_MODULE, codegen, next);
}


static void vala_gtype_module_real_generate_interface_declaration (ValaCCodeBaseModule* base, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space) {
	ValaGTypeModule * self;
	char* _tmp0;
	gboolean _tmp1;
	char* _tmp9;
	char* _tmp8;
	ValaCCodeStruct* _tmp10;
	ValaCCodeStruct* type_struct;
	ValaCCodeNewline* _tmp11;
	char* _tmp12;
	char* _tmp13;
	char* macro;
	ValaCCodeMacroReplacement* _tmp15;
	char* _tmp14;
	char* _tmp18;
	char* _tmp17;
	char* _tmp16;
	ValaCCodeMacroReplacement* _tmp21;
	char* _tmp20;
	char* _tmp19;
	char* _tmp23;
	char* _tmp22;
	ValaCCodeMacroReplacement* _tmp26;
	char* _tmp25;
	char* _tmp24;
	char* _tmp29;
	char* _tmp28;
	char* _tmp27;
	ValaCCodeMacroReplacement* _tmp32;
	char* _tmp31;
	char* _tmp30;
	ValaCCodeNewline* _tmp33;
	ValaCCodeTypeDefinition* _tmp38;
	ValaCCodeVariableDeclarator* _tmp37;
	char* _tmp36;
	char* _tmp35;
	char* _tmp34;
	ValaCCodeTypeDefinition* _tmp42;
	ValaCCodeVariableDeclarator* _tmp41;
	char* _tmp40;
	char* _tmp39;
	ValaInterfaceRegisterFunction* type_fun;
	ValaCCodeFragment* _tmp68;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (iface != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0 = NULL;
	if ((_tmp1 = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) iface, _tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), _tmp0 = (g_free (_tmp0), NULL), _tmp1)) {
		return;
	}
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _prerequisite_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_prerequisite_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_interface_get_prerequisites (iface))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_prerequisite_it)) {
			ValaDataType* prerequisite;
			ValaClass* _tmp5;
			ValaTypeSymbol* _tmp4;
			ValaClass* prereq_cl;
			ValaInterface* _tmp7;
			ValaTypeSymbol* _tmp6;
			ValaInterface* prereq_iface;
			prerequisite = (ValaDataType*) gee_iterator_get (_prerequisite_it);
			_tmp5 = NULL;
			_tmp4 = NULL;
			prereq_cl = (_tmp5 = (_tmp4 = vala_data_type_get_data_type (prerequisite), VALA_IS_CLASS (_tmp4) ? ((ValaClass*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
			_tmp7 = NULL;
			_tmp6 = NULL;
			prereq_iface = (_tmp7 = (_tmp6 = vala_data_type_get_data_type (prerequisite), VALA_IS_INTERFACE (_tmp6) ? ((ValaInterface*) _tmp6) : NULL), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
			if (prereq_cl != NULL) {
				vala_ccode_base_module_generate_class_declaration ((ValaCCodeBaseModule*) self, prereq_cl, decl_space);
			} else {
				if (prereq_iface != NULL) {
					vala_ccode_base_module_generate_interface_declaration ((ValaCCodeBaseModule*) self, prereq_iface, decl_space);
				}
			}
			(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
			(prereq_cl == NULL) ? NULL : (prereq_cl = (vala_code_node_unref (prereq_cl), NULL));
			(prereq_iface == NULL) ? NULL : (prereq_iface = (vala_code_node_unref (prereq_iface), NULL));
		}
		(_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL));
	}
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp10 = NULL;
	type_struct = (_tmp10 = vala_ccode_struct_new (_tmp9 = g_strdup_printf ("_%s", _tmp8 = vala_interface_get_type_cname (iface))), _tmp9 = (g_free (_tmp9), NULL), _tmp8 = (g_free (_tmp8), NULL), _tmp10);
	_tmp11 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp11 = vala_ccode_newline_new ()));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	_tmp13 = NULL;
	macro = (_tmp13 = g_strdup_printf ("(%s_get_type ())", _tmp12 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp12 = (g_free (_tmp12), NULL), _tmp13);
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp15 = vala_ccode_macro_replacement_new (_tmp14 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), macro)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp14 = (g_free (_tmp14), NULL);
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	macro = (_tmp18 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", _tmp16 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), _tmp17 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), macro = (g_free (macro), NULL), _tmp18);
	_tmp17 = (g_free (_tmp17), NULL);
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp21 = vala_ccode_macro_replacement_new (_tmp20 = g_strdup_printf ("%s(obj)", _tmp19 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL)), macro)));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp20 = (g_free (_tmp20), NULL);
	_tmp19 = (g_free (_tmp19), NULL);
	_tmp23 = NULL;
	_tmp22 = NULL;
	macro = (_tmp23 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", _tmp22 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface)), macro = (g_free (macro), NULL), _tmp23);
	_tmp22 = (g_free (_tmp22), NULL);
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp26 = vala_ccode_macro_replacement_new (_tmp25 = g_strdup_printf ("%s(obj)", _tmp24 = vala_ccode_base_module_get_type_check_function ((ValaCCodeBaseModule*) self, (ValaTypeSymbol*) iface)), macro)));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp25 = (g_free (_tmp25), NULL);
	_tmp24 = (g_free (_tmp24), NULL);
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	macro = (_tmp29 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", _tmp27 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), _tmp28 = vala_interface_get_type_cname (iface)), macro = (g_free (macro), NULL), _tmp29);
	_tmp28 = (g_free (_tmp28), NULL);
	_tmp27 = (g_free (_tmp27), NULL);
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp32 = vala_ccode_macro_replacement_new (_tmp31 = g_strdup_printf ("%s_GET_INTERFACE(obj)", _tmp30 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL)), macro)));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp31 = (g_free (_tmp31), NULL);
	_tmp30 = (g_free (_tmp30), NULL);
	_tmp33 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp33 = vala_ccode_newline_new ()));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	_tmp38 = NULL;
	_tmp37 = NULL;
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp38 = vala_ccode_type_definition_new (_tmp35 = g_strdup_printf ("struct _%s", _tmp34 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), (ValaCCodeDeclarator*) (_tmp37 = vala_ccode_variable_declarator_new (_tmp36 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), NULL)))));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	_tmp36 = (g_free (_tmp36), NULL);
	_tmp35 = (g_free (_tmp35), NULL);
	_tmp34 = (g_free (_tmp34), NULL);
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	_tmp39 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp42 = vala_ccode_type_definition_new (_tmp39 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (type_struct)), (ValaCCodeDeclarator*) (_tmp41 = vala_ccode_variable_declarator_new (_tmp40 = vala_interface_get_type_cname (iface), NULL)))));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	_tmp40 = (g_free (_tmp40), NULL);
	_tmp39 = (g_free (_tmp39), NULL);
	vala_ccode_struct_add_field (type_struct, "GTypeInterface", "parent_iface");
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) iface)) != NULL) {
		ValaCCodeComment* _tmp43;
		_tmp43 = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp43 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) iface)))));
		(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) type_struct);
	{
		GeeList* _tmp44;
		GeeIterator* _tmp45;
		GeeIterator* _m_it;
		_tmp44 = NULL;
		_tmp45 = NULL;
		_m_it = (_tmp45 = gee_iterable_iterator ((GeeIterable*) (_tmp44 = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp44 == NULL) ? NULL : (_tmp44 = (gee_collection_object_unref (_tmp44), NULL)), _tmp45);
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			gboolean _tmp46;
			gboolean _tmp47;
			ValaCCodeFunctionDeclarator* vdeclarator;
			GeeHashMap* cparam_map;
			ValaCCodeFunction* _tmp48;
			char* _tmp49;
			ValaCCodeDeclaration* _tmp50;
			ValaCCodeDeclaration* vdecl;
			m = (ValaMethod*) gee_iterator_get (_m_it);
			_tmp46 = FALSE;
			_tmp47 = FALSE;
			if (!vala_method_get_is_abstract (m)) {
				_tmp47 = !vala_method_get_is_virtual (m);
			} else {
				_tmp47 = FALSE;
			}
			if (_tmp47) {
				_tmp46 = TRUE;
			} else {
				_tmp46 = vala_method_get_coroutine (m);
			}
			if (_tmp46) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			/* add vfunc field to the type struct*/
			vdeclarator = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m));
			cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			_tmp48 = NULL;
			vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, decl_space, (GeeMap*) cparam_map, _tmp48 = vala_ccode_function_new ("fake", "void"), vdeclarator, NULL, NULL, 3);
			(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
			_tmp49 = NULL;
			_tmp50 = NULL;
			vdecl = (_tmp50 = vala_ccode_declaration_new (_tmp49 = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp49 = (g_free (_tmp49), NULL), _tmp50);
			vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
			vala_ccode_struct_add_declaration (type_struct, vdecl);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
			(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
			(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	{
		GeeList* _tmp51;
		GeeIterator* _tmp52;
		GeeIterator* _prop_it;
		_tmp51 = NULL;
		_tmp52 = NULL;
		_prop_it = (_tmp52 = gee_iterable_iterator ((GeeIterable*) (_tmp51 = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface))), (_tmp51 == NULL) ? NULL : (_tmp51 = (gee_collection_object_unref (_tmp51), NULL)), _tmp52);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			gboolean _tmp53;
			ValaObjectTypeSymbol* _tmp54;
			ValaObjectTypeSymbol* t;
			gboolean returns_real_struct;
			ValaObjectType* this_type;
			char* _tmp55;
			ValaCCodeFormalParameter* _tmp56;
			ValaCCodeFormalParameter* cselfparam;
			ValaCCodeFormalParameter* cvalueparam;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp53 = FALSE;
			if (!vala_property_get_is_abstract (prop)) {
				_tmp53 = !vala_property_get_is_virtual (prop);
			} else {
				_tmp53 = FALSE;
			}
			if (_tmp53) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			_tmp54 = NULL;
			t = (_tmp54 = VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp54 == NULL) ? NULL : vala_code_node_ref (_tmp54));
			returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
			this_type = vala_object_type_new (t);
			_tmp55 = NULL;
			_tmp56 = NULL;
			cselfparam = (_tmp56 = vala_ccode_formal_parameter_new ("self", _tmp55 = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp55 = (g_free (_tmp55), NULL), _tmp56);
			cvalueparam = NULL;
			if (returns_real_struct) {
				ValaCCodeFormalParameter* _tmp59;
				char* _tmp58;
				char* _tmp57;
				_tmp59 = NULL;
				_tmp58 = NULL;
				_tmp57 = NULL;
				cvalueparam = (_tmp59 = vala_ccode_formal_parameter_new ("value", _tmp58 = g_strconcat (_tmp57 = vala_data_type_get_cname (vala_property_get_property_type (prop)), "*", NULL)), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp59);
				_tmp58 = (g_free (_tmp58), NULL);
				_tmp57 = (g_free (_tmp57), NULL);
			} else {
				ValaCCodeFormalParameter* _tmp61;
				char* _tmp60;
				_tmp61 = NULL;
				_tmp60 = NULL;
				cvalueparam = (_tmp61 = vala_ccode_formal_parameter_new ("value", _tmp60 = vala_data_type_get_cname (vala_property_get_property_type (prop))), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp61);
				_tmp60 = (g_free (_tmp60), NULL);
			}
			if (vala_property_get_get_accessor (prop) != NULL) {
				char* _tmp62;
				ValaCCodeFunctionDeclarator* _tmp63;
				ValaCCodeFunctionDeclarator* vdeclarator;
				char* creturn_type;
				ValaCCodeDeclaration* vdecl;
				_tmp62 = NULL;
				_tmp63 = NULL;
				vdeclarator = (_tmp63 = vala_ccode_function_declarator_new (_tmp62 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))), _tmp62 = (g_free (_tmp62), NULL), _tmp63);
				vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
				creturn_type = NULL;
				if (returns_real_struct) {
					char* _tmp64;
					vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
					_tmp64 = NULL;
					creturn_type = (_tmp64 = g_strdup ("void"), creturn_type = (g_free (creturn_type), NULL), _tmp64);
				} else {
					char* _tmp65;
					_tmp65 = NULL;
					creturn_type = (_tmp65 = vala_data_type_get_cname (vala_property_get_property_type (prop)), creturn_type = (g_free (creturn_type), NULL), _tmp65);
				}
				vdecl = vala_ccode_declaration_new (creturn_type);
				vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
				vala_ccode_struct_add_declaration (type_struct, vdecl);
				(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
				creturn_type = (g_free (creturn_type), NULL);
				(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
			}
			if (vala_property_get_set_accessor (prop) != NULL) {
				char* _tmp66;
				ValaCCodeFunctionDeclarator* _tmp67;
				ValaCCodeFunctionDeclarator* vdeclarator;
				ValaCCodeDeclaration* vdecl;
				_tmp66 = NULL;
				_tmp67 = NULL;
				vdeclarator = (_tmp67 = vala_ccode_function_declarator_new (_tmp66 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))), _tmp66 = (g_free (_tmp66), NULL), _tmp67);
				vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
				vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
				vdecl = vala_ccode_declaration_new ("void");
				vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
				vala_ccode_struct_add_declaration (type_struct, vdecl);
				(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
				(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
			(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
			(cselfparam == NULL) ? NULL : (cselfparam = (vala_ccode_node_unref (cselfparam), NULL));
			(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	type_fun = vala_interface_register_function_new (iface, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
	vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
	_tmp68 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) (_tmp68 = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
	(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
	(type_struct == NULL) ? NULL : (type_struct = (vala_ccode_node_unref (type_struct), NULL));
	macro = (g_free (macro), NULL);
	(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
}


static void vala_gtype_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface) {
	ValaGTypeModule * self;
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaTypeSymbol* _tmp3;
	ValaTypeSymbol* _tmp2;
	char* _tmp4;
	gboolean _tmp5;
	ValaInterfaceRegisterFunction* type_fun;
	ValaCCodeFragment* _tmp8;
	ValaTypeSymbol* _tmp9;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (iface != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp1 = (_tmp0 = (ValaSymbol*) iface, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp3 = (_tmp2 = (ValaTypeSymbol*) iface, (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp3);
	_tmp4 = NULL;
	if ((_tmp5 = g_utf8_strlen (_tmp4 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), -1) < 3, _tmp4 = (g_free (_tmp4), NULL), _tmp5)) {
		char* _tmp7;
		char* _tmp6;
		vala_code_node_set_error ((ValaCodeNode*) iface, TRUE);
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) iface), _tmp7 = g_strdup_printf ("Interface name `%s' is too short", _tmp6 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp6 = (g_free (_tmp6), NULL);
		return;
	}
	vala_ccode_base_module_generate_interface_declaration ((ValaCCodeBaseModule*) self, iface, ((ValaCCodeBaseModule*) self)->source_declarations);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_gtype_module_add_interface_base_init_function (self, iface);
	type_fun = vala_interface_register_function_new (iface, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
	vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
	_tmp8 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp8 = vala_typeregister_function_get_definition ((ValaTypeRegisterFunction*) type_fun)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp9 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp9 = NULL, (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp9);
	(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
}


static void vala_gtype_module_add_interface_base_init_function (ValaGTypeModule* self, ValaInterface* iface) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* _tmp6;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeConstant* _tmp9;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeIfStatement* _tmp13;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFragment* _tmp33;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	base_init = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_base_init", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (base_init, _tmp5 = vala_ccode_formal_parameter_new ("iface", _tmp4 = g_strdup_printf ("%sIface *", _tmp3 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	/* make sure not to run the initialization code twice */
	_tmp6 = NULL;
	vala_ccode_function_set_block (base_init, _tmp6 = vala_ccode_block_new ());
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	_tmp8 = NULL;
	decl = (_tmp8 = vala_ccode_declaration_new (_tmp7 = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->bool_type)), _tmp7 = (g_free (_tmp7), NULL), _tmp8);
	vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | VALA_CCODE_MODIFIERS_STATIC);
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (decl, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("initialized", (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("FALSE")))));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) decl);
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	cif = (_tmp13 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("initialized")))), (ValaCCodeStatement*) init_block, NULL), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp13);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) cif);
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp17 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("initialized")), (ValaCCodeExpression*) (_tmp15 = vala_ccode_constant_new ("TRUE")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) iface, ((ValaCCodeBaseModule*) self)->gobject_type)) {
		GeeList* props;
		/* create properties */
		props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface);
		{
			GeeIterator* _prop_it;
			_prop_it = gee_iterable_iterator ((GeeIterable*) props);
			while (gee_iterator_next (_prop_it)) {
				ValaProperty* prop;
				prop = (ValaProperty*) gee_iterator_get (_prop_it);
				if (vala_property_get_is_abstract (prop)) {
					ValaCCodeIdentifier* _tmp18;
					ValaCCodeFunctionCall* _tmp19;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeIdentifier* _tmp20;
					ValaCCodeFunctionCall* _tmp21;
					ValaCCodeExpressionStatement* _tmp22;
					_tmp18 = NULL;
					_tmp19 = NULL;
					cinst = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("g_object_interface_install_property"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
					_tmp20 = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("iface")));
					(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
					_tmp21 = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp21 = vala_ccode_module_get_param_spec (vala_ccode_module_get_head ((ValaCCodeModule*) self), prop)));
					(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
					_tmp22 = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
					(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
					(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
				}
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			}
			(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
		}
		(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
	}
	/* create signals */
	{
		GeeList* _tmp23;
		GeeIterator* _tmp24;
		GeeIterator* _sig_it;
		/* create signals */
		_tmp23 = NULL;
		_tmp24 = NULL;
		_sig_it = (_tmp24 = gee_iterable_iterator ((GeeIterable*) (_tmp23 = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) iface))), (_tmp23 == NULL) ? NULL : (_tmp23 = (gee_collection_object_unref (_tmp23), NULL)), _tmp24);
		/* create signals */
		while (gee_iterator_next (_sig_it)) {
			ValaSignal* sig;
			ValaCCodeExpressionStatement* _tmp26;
			ValaCCodeFunctionCall* _tmp25;
			/* create signals */
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			_tmp26 = NULL;
			_tmp25 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp26 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_module_get_signal_creation (vala_ccode_module_get_head ((ValaCCodeModule*) self), sig, (ValaTypeSymbol*) iface)))));
			(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
			(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	/* connect default implementations*/
	{
		GeeList* _tmp27;
		GeeIterator* _tmp28;
		GeeIterator* _m_it;
		/* connect default implementations*/
		_tmp27 = NULL;
		_tmp28 = NULL;
		_m_it = (_tmp28 = gee_iterable_iterator ((GeeIterable*) (_tmp27 = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp27 == NULL) ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)), _tmp28);
		/* connect default implementations*/
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			/* connect default implementations*/
			m = (ValaMethod*) gee_iterator_get (_m_it);
			if (vala_method_get_is_virtual (m)) {
				ValaCCodeIdentifier* ciface;
				char* cname;
				ValaCCodeExpressionStatement* _tmp32;
				ValaCCodeAssignment* _tmp31;
				ValaCCodeIdentifier* _tmp30;
				ValaCCodeMemberAccess* _tmp29;
				ciface = vala_ccode_identifier_new ("iface");
				cname = vala_method_get_real_cname (m);
				_tmp32 = NULL;
				_tmp31 = NULL;
				_tmp30 = NULL;
				_tmp29 = NULL;
				vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) (_tmp32 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, vala_method_get_vfunc_name (m))), (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
				(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
				(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
				(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
				(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
				cname = (g_free (cname), NULL);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	_tmp33 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp33 = vala_ccode_module_register_dbus_info (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaObjectTypeSymbol*) iface)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) base_init);
	(base_init == NULL) ? NULL : (base_init = (vala_ccode_node_unref (base_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(decl == NULL) ? NULL : (decl = (vala_ccode_node_unref (decl), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_gtype_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st) {
	ValaGTypeModule * self;
	ValaCCodeNewline* _tmp0;
	char* _tmp1;
	char* _tmp2;
	char* macro;
	ValaCCodeMacroReplacement* _tmp4;
	char* _tmp3;
	ValaStructRegisterFunction* type_fun;
	ValaCCodeFragment* _tmp5;
	ValaCCodeFragment* _tmp6;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (st != NULL);
	VALA_CCODE_MODULE_CLASS (vala_gtype_module_parent_class)->visit_struct ((ValaCCodeModule*) VALA_GERROR_MODULE (self), st);
	_tmp0 = NULL;
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp0 = vala_ccode_newline_new ()));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	_tmp2 = NULL;
	macro = (_tmp2 = g_strdup_printf ("(%s_get_type ())", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) st, NULL)), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp4 = vala_ccode_macro_replacement_new (_tmp3 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), macro)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	type_fun = vala_struct_register_function_new (st, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
	vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
	_tmp5 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5 = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp6 = vala_typeregister_function_get_definition ((ValaTypeRegisterFunction*) type_fun)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	macro = (g_free (macro), NULL);
	(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
}


static void vala_gtype_module_class_init (ValaGTypeModuleClass * klass) {
	vala_gtype_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_interface_declaration = vala_gtype_module_real_generate_interface_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_interface = vala_gtype_module_real_visit_interface;
	VALA_CCODE_MODULE_CLASS (klass)->visit_struct = vala_gtype_module_real_visit_struct;
}


static void vala_gtype_module_instance_init (ValaGTypeModule * self) {
}


GType vala_gtype_module_get_type (void) {
	static GType vala_gtype_module_type_id = 0;
	if (vala_gtype_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGTypeModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gtype_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGTypeModule), 0, (GInstanceInitFunc) vala_gtype_module_instance_init, NULL };
		vala_gtype_module_type_id = g_type_register_static (VALA_TYPE_GERROR_MODULE, "ValaGTypeModule", &g_define_type_info, 0);
	}
	return vala_gtype_module_type_id;
}




