/* valaccodevariabledeclarator.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;
typedef struct _ValaCCodeNodePrivate ValaCCodeNodePrivate;

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;

#define VALA_TYPE_CCODE_DECLARATOR (vala_ccode_declarator_get_type ())
#define VALA_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclarator))
#define VALA_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))
#define VALA_IS_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_IS_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_CCODE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))

typedef struct _ValaCCodeDeclarator ValaCCodeDeclarator;
typedef struct _ValaCCodeDeclaratorClass ValaCCodeDeclaratorClass;
typedef struct _ValaCCodeDeclaratorPrivate ValaCCodeDeclaratorPrivate;

#define VALA_TYPE_CCODE_VARIABLE_DECLARATOR (vala_ccode_variable_declarator_get_type ())
#define VALA_CCODE_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclarator))
#define VALA_CCODE_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorClass))
#define VALA_IS_CCODE_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR))
#define VALA_IS_CCODE_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_VARIABLE_DECLARATOR))
#define VALA_CCODE_VARIABLE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorClass))

typedef struct _ValaCCodeVariableDeclarator ValaCCodeVariableDeclarator;
typedef struct _ValaCCodeVariableDeclaratorClass ValaCCodeVariableDeclaratorClass;
typedef struct _ValaCCodeVariableDeclaratorPrivate ValaCCodeVariableDeclaratorPrivate;

#define VALA_TYPE_CCODE_EXPRESSION (vala_ccode_expression_get_type ())
#define VALA_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression))
#define VALA_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))
#define VALA_IS_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_IS_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_CCODE_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))

typedef struct _ValaCCodeExpression ValaCCodeExpression;
typedef struct _ValaCCodeExpressionClass ValaCCodeExpressionClass;

#define VALA_TYPE_CCODE_INITIALIZER_LIST (vala_ccode_initializer_list_get_type ())
#define VALA_CCODE_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerList))
#define VALA_CCODE_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerListClass))
#define VALA_IS_CCODE_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_INITIALIZER_LIST))
#define VALA_IS_CCODE_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_INITIALIZER_LIST))
#define VALA_CCODE_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerListClass))

typedef struct _ValaCCodeInitializerList ValaCCodeInitializerList;
typedef struct _ValaCCodeInitializerListClass ValaCCodeInitializerListClass;

#define VALA_TYPE_CCODE_LINE_DIRECTIVE (vala_ccode_line_directive_get_type ())
#define VALA_CCODE_LINE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirective))
#define VALA_CCODE_LINE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectiveClass))
#define VALA_IS_CCODE_LINE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE))
#define VALA_IS_CCODE_LINE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_LINE_DIRECTIVE))
#define VALA_CCODE_LINE_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectiveClass))

typedef struct _ValaCCodeLineDirective ValaCCodeLineDirective;
typedef struct _ValaCCodeLineDirectiveClass ValaCCodeLineDirectiveClass;

/**
 * Represents a node in the C code tree.
 */
struct _ValaCCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeNodePrivate * priv;
};

struct _ValaCCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeNode *self);
	void (*write) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_declaration) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_combined) (ValaCCodeNode* self, ValaCCodeWriter* writer);
};

/**
 * Represents a variable or function pointer declarator in the C code.
 */
struct _ValaCCodeDeclarator {
	ValaCCodeNode parent_instance;
	ValaCCodeDeclaratorPrivate * priv;
};

struct _ValaCCodeDeclaratorClass {
	ValaCCodeNodeClass parent_class;
	void (*write_initialization) (ValaCCodeDeclarator* self, ValaCCodeWriter* writer);
};

/**
 * Represents a variable declarator in the C code.
 */
struct _ValaCCodeVariableDeclarator {
	ValaCCodeDeclarator parent_instance;
	ValaCCodeVariableDeclaratorPrivate * priv;
};

struct _ValaCCodeVariableDeclaratorClass {
	ValaCCodeDeclaratorClass parent_class;
};

struct _ValaCCodeVariableDeclaratorPrivate {
	char* _name;
	ValaCCodeExpression* _initializer;
};



gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void);
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void);
GType vala_ccode_declarator_get_type (void);
GType vala_ccode_variable_declarator_get_type (void);
GType vala_ccode_expression_get_type (void);
#define VALA_CCODE_VARIABLE_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorPrivate))
enum  {
	VALA_CCODE_VARIABLE_DECLARATOR_DUMMY_PROPERTY
};
void vala_ccode_variable_declarator_set_name (ValaCCodeVariableDeclarator* self, const char* value);
void vala_ccode_variable_declarator_set_initializer (ValaCCodeVariableDeclarator* self, ValaCCodeExpression* value);
ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new (const char* name, ValaCCodeExpression* initializer);
ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_construct (GType object_type, const char* name, ValaCCodeExpression* initializer);
ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new (const char* name, ValaCCodeExpression* initializer);
void vala_ccode_writer_write_string (ValaCCodeWriter* self, const char* s);
const char* vala_ccode_variable_declarator_get_name (ValaCCodeVariableDeclarator* self);
ValaCCodeExpression* vala_ccode_variable_declarator_get_initializer (ValaCCodeVariableDeclarator* self);
void vala_ccode_node_write (ValaCCodeNode* self, ValaCCodeWriter* writer);
static void vala_ccode_variable_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
GType vala_ccode_initializer_list_get_type (void);
static void vala_ccode_variable_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
GType vala_ccode_line_directive_get_type (void);
void vala_ccode_writer_write_indent (ValaCCodeWriter* self, ValaCCodeLineDirective* line);
ValaCCodeLineDirective* vala_ccode_node_get_line (ValaCCodeNode* self);
void vala_ccode_writer_write_newline (ValaCCodeWriter* self);
static void vala_ccode_variable_declarator_real_write_initialization (ValaCCodeDeclarator* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_variable_declarator_parent_class = NULL;
static void vala_ccode_variable_declarator_finalize (ValaCCodeNode* obj);



ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_construct (GType object_type, const char* name, ValaCCodeExpression* initializer) {
	ValaCCodeVariableDeclarator* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaCCodeVariableDeclarator*) g_type_create_instance (object_type);
	vala_ccode_variable_declarator_set_name (self, name);
	vala_ccode_variable_declarator_set_initializer (self, initializer);
	return self;
}


ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new (const char* name, ValaCCodeExpression* initializer) {
	return vala_ccode_variable_declarator_construct (VALA_TYPE_CCODE_VARIABLE_DECLARATOR, name, initializer);
}


static void vala_ccode_variable_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeVariableDeclarator * self;
	self = (ValaCCodeVariableDeclarator*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, self->priv->_name);
	if (self->priv->_initializer != NULL) {
		vala_ccode_writer_write_string (writer, " = ");
		vala_ccode_node_write ((ValaCCodeNode*) self->priv->_initializer, writer);
	}
}


static void vala_ccode_variable_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeVariableDeclarator * self;
	self = (ValaCCodeVariableDeclarator*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, self->priv->_name);
	/* initializer lists can't be moved to a separate statement*/
	if (VALA_IS_CCODE_INITIALIZER_LIST (self->priv->_initializer)) {
		vala_ccode_writer_write_string (writer, " = ");
		vala_ccode_node_write ((ValaCCodeNode*) self->priv->_initializer, writer);
	}
}


static void vala_ccode_variable_declarator_real_write_initialization (ValaCCodeDeclarator* base, ValaCCodeWriter* writer) {
	ValaCCodeVariableDeclarator * self;
	gboolean _tmp0;
	self = (ValaCCodeVariableDeclarator*) base;
	g_return_if_fail (writer != NULL);
	_tmp0 = FALSE;
	if (self->priv->_initializer != NULL) {
		_tmp0 = !VALA_IS_CCODE_INITIALIZER_LIST (self->priv->_initializer);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line ((ValaCCodeNode*) self));
		vala_ccode_writer_write_string (writer, self->priv->_name);
		vala_ccode_writer_write_string (writer, " = ");
		vala_ccode_node_write ((ValaCCodeNode*) self->priv->_initializer, writer);
		vala_ccode_writer_write_string (writer, ";");
		vala_ccode_writer_write_newline (writer);
	}
}


const char* vala_ccode_variable_declarator_get_name (ValaCCodeVariableDeclarator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_ccode_variable_declarator_set_name (ValaCCodeVariableDeclarator* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
}


ValaCCodeExpression* vala_ccode_variable_declarator_get_initializer (ValaCCodeVariableDeclarator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_initializer;
}


void vala_ccode_variable_declarator_set_initializer (ValaCCodeVariableDeclarator* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_initializer = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_initializer == NULL) ? NULL : (self->priv->_initializer = (vala_ccode_node_unref (self->priv->_initializer), NULL)), _tmp2);
}


static void vala_ccode_variable_declarator_class_init (ValaCCodeVariableDeclaratorClass * klass) {
	vala_ccode_variable_declarator_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_variable_declarator_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeVariableDeclaratorPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_variable_declarator_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_variable_declarator_real_write_declaration;
	VALA_CCODE_DECLARATOR_CLASS (klass)->write_initialization = vala_ccode_variable_declarator_real_write_initialization;
}


static void vala_ccode_variable_declarator_instance_init (ValaCCodeVariableDeclarator * self) {
	self->priv = VALA_CCODE_VARIABLE_DECLARATOR_GET_PRIVATE (self);
}


static void vala_ccode_variable_declarator_finalize (ValaCCodeNode* obj) {
	ValaCCodeVariableDeclarator * self;
	self = VALA_CCODE_VARIABLE_DECLARATOR (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->_initializer == NULL) ? NULL : (self->priv->_initializer = (vala_ccode_node_unref (self->priv->_initializer), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_variable_declarator_parent_class)->finalize (obj);
}


GType vala_ccode_variable_declarator_get_type (void) {
	static GType vala_ccode_variable_declarator_type_id = 0;
	if (vala_ccode_variable_declarator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeVariableDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_variable_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeVariableDeclarator), 0, (GInstanceInitFunc) vala_ccode_variable_declarator_instance_init, NULL };
		vala_ccode_variable_declarator_type_id = g_type_register_static (VALA_TYPE_CCODE_DECLARATOR, "ValaCCodeVariableDeclarator", &g_define_type_info, 0);
	}
	return vala_ccode_variable_declarator_type_id;
}




