/* valaccodecontrolflowmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
enum  {
	VALA_CCODE_CONTROL_FLOW_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeMethodModule* vala_ccode_method_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars);
static void vala_ccode_control_flow_module_real_visit_if_statement (ValaCCodeModule* base, ValaIfStatement* stmt);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
static void vala_ccode_control_flow_module_visit_string_switch_statement (ValaCCodeControlFlowModule* self, ValaSwitchStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_switch_statement (ValaCCodeModule* base, ValaSwitchStatement* stmt);
void vala_ccode_module_visit_block (ValaCCodeModule* self, ValaBlock* b);
static void vala_ccode_control_flow_module_real_visit_switch_section (ValaCCodeModule* base, ValaSwitchSection* section);
static void vala_ccode_control_flow_module_real_visit_switch_label (ValaCCodeModule* base, ValaSwitchLabel* label);
static void vala_ccode_control_flow_module_real_visit_while_statement (ValaCCodeModule* base, ValaWhileStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_do_statement (ValaCCodeModule* base, ValaDoStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_for_statement (ValaCCodeModule* base, ValaForStatement* stmt);
void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
void vala_ccode_module_add_simple_check (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
static void vala_ccode_control_flow_module_real_visit_foreach_statement (ValaCCodeModule* base, ValaForeachStatement* stmt);
void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop);
static void vala_ccode_control_flow_module_real_visit_break_statement (ValaCCodeModule* base, ValaBreakStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_continue_statement (ValaCCodeModule* base, ValaContinueStatement* stmt);
static gpointer vala_ccode_control_flow_module_parent_class = NULL;



ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeControlFlowModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeControlFlowModule*) vala_ccode_method_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_control_flow_module_construct (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, codegen, next);
}


static void vala_ccode_control_flow_module_real_visit_if_statement (ValaCCodeModule* base, ValaIfStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_condition (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_true_statement (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_false_statement (stmt))))));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	} else {
		ValaCCodeIfStatement* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp1 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_condition (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_true_statement (stmt))), NULL)));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	}
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_if_statement_get_condition (stmt)->temp_vars);
}


static void vala_ccode_control_flow_module_visit_string_switch_statement (ValaCCodeControlFlowModule* self, ValaSwitchStatement* stmt) {
	ValaLocalVariable* temp_var;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeConstant* czero;
	ValaCCodeFragment* cswitchblock;
	ValaCCodeConstant* _tmp0;
	ValaCCodeBinaryExpression* _tmp1;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* cquark;
	ValaCCodeConstant* _tmp4;
	ValaCCodeConditionalExpression* _tmp5;
	ValaCCodeConditionalExpression* ccond;
	ValaLocalVariable* _tmp6;
	gint label_count;
	ValaCCodeExpressionStatement* _tmp15;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeAssignment* _tmp17;
	ValaCCodeExpressionStatement* _tmp18;
	GeeList* default_statements;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	/* we need a temporary variable to save the property value*/
	temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), TRUE, (ValaCodeNode*) stmt);
	gee_list_insert ((GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars, 0, temp_var);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
	cinit = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_statement_get_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	czero = vala_ccode_constant_new ("0");
	cswitchblock = vala_ccode_fragment_new ();
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cswitchblock);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cisnull = (_tmp1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp0 = vala_ccode_constant_new ("NULL")), (ValaCCodeExpression*) ctemp), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cquark = (_tmp3 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("g_quark_from_string"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	vala_ccode_function_call_add_argument (cquark, (ValaCCodeExpression*) ctemp);
	_tmp4 = NULL;
	_tmp5 = NULL;
	ccond = (_tmp5 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new ("0")), (ValaCCodeExpression*) cquark), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
	_tmp6 = NULL;
	temp_var = (_tmp6 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL), (temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)), _tmp6);
	gee_list_insert ((GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars, 0, temp_var);
	label_count = 0;
	{
		GeeList* _tmp7;
		GeeIterator* _tmp8;
		GeeIterator* _section_it;
		_tmp7 = NULL;
		_tmp8 = NULL;
		_section_it = (_tmp8 = gee_iterable_iterator ((GeeIterable*) (_tmp7 = vala_switch_statement_get_sections (stmt))), (_tmp7 == NULL) ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL)), _tmp8);
		while (gee_iterator_next (_section_it)) {
			ValaSwitchSection* section;
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			{
				GeeList* _tmp9;
				GeeIterator* _tmp10;
				GeeIterator* _label_it;
				_tmp9 = NULL;
				_tmp10 = NULL;
				_label_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_switch_section_get_labels (section))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
				while (gee_iterator_next (_label_it)) {
					ValaSwitchLabel* label;
					ValaCCodeExpression* _tmp11;
					ValaCCodeExpression* cexpr;
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp11 = NULL;
					cexpr = (_tmp11 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))), (_tmp11 == NULL) ? NULL : vala_ccode_node_ref (_tmp11));
					if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, cexpr)) {
						char* cname;
						char* _tmp12;
						ValaCCodeDeclaration* _tmp13;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp14;
						cname = g_strdup_printf ("%s_label%d", vala_symbol_get_name ((ValaSymbol*) temp_var), label_count++);
						_tmp12 = NULL;
						_tmp13 = NULL;
						cdecl_ = (_tmp13 = vala_ccode_declaration_new (_tmp12 = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->gquark_type)), _tmp12 = (g_free (_tmp12), NULL), _tmp13);
						vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
						_tmp14 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new (cname, (ValaCCodeExpression*) czero)));
						(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
						vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) cdecl_);
						cname = (g_free (cname), NULL);
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	_tmp15 = NULL;
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) (_tmp15 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	ctemp = (_tmp16 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), _tmp16);
	_tmp17 = NULL;
	cinit = (_tmp17 = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, (ValaCCodeExpression*) ccond, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)), _tmp17);
	_tmp18 = NULL;
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) (_tmp18 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars);
	default_statements = NULL;
	label_count = 0;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GeeList* _tmp19;
		GeeIterator* _tmp20;
		GeeIterator* _section_it;
		_tmp19 = NULL;
		_tmp20 = NULL;
		_section_it = (_tmp20 = gee_iterable_iterator ((GeeIterable*) (_tmp19 = vala_switch_statement_get_sections (stmt))), (_tmp19 == NULL) ? NULL : (_tmp19 = (gee_collection_object_unref (_tmp19), NULL)), _tmp20);
		while (gee_iterator_next (_section_it)) {
			ValaSwitchSection* section;
			ValaCCodeBinaryExpression* cor;
			ValaCCodeBlock* cblock;
			ValaCCodeConstant* _tmp42;
			ValaCCodeDoStatement* _tmp43;
			ValaCCodeDoStatement* cdo;
			ValaCCodeIfStatement* cif;
			ValaCCodeIfStatement* _tmp47;
			ValaCCodeIfStatement* _tmp46;
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				GeeList* _tmp21;
				_tmp21 = NULL;
				default_statements = (_tmp21 = vala_block_get_statements ((ValaBlock*) section), (default_statements == NULL) ? NULL : (default_statements = (gee_collection_object_unref (default_statements), NULL)), _tmp21);
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			cor = NULL;
			{
				GeeList* _tmp22;
				GeeIterator* _tmp23;
				GeeIterator* _label_it;
				_tmp22 = NULL;
				_tmp23 = NULL;
				_label_it = (_tmp23 = gee_iterable_iterator ((GeeIterable*) (_tmp22 = vala_switch_section_get_labels (section))), (_tmp22 == NULL) ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL)), _tmp23);
				while (gee_iterator_next (_label_it)) {
					ValaSwitchLabel* label;
					ValaCCodeExpression* _tmp24;
					ValaCCodeExpression* cexpr;
					ValaCCodeBinaryExpression* ccmp;
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp24 = NULL;
					cexpr = (_tmp24 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))), (_tmp24 == NULL) ? NULL : vala_ccode_node_ref (_tmp24));
					if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, cexpr)) {
						char* _tmp25;
						ValaCCodeIdentifier* _tmp26;
						ValaCCodeIdentifier* cname;
						ValaCCodeBinaryExpression* ccondition;
						ValaCCodeIdentifier* _tmp27;
						ValaCCodeFunctionCall* _tmp28;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeAssignment* _tmp29;
						ValaCCodeExpression* _tmp30;
						_tmp25 = NULL;
						_tmp26 = NULL;
						cname = (_tmp26 = vala_ccode_identifier_new (_tmp25 = g_strdup_printf ("%s_label%d", vala_symbol_get_name ((ValaSymbol*) temp_var), label_count++)), _tmp25 = (g_free (_tmp25), NULL), _tmp26);
						ccondition = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) cname);
						_tmp27 = NULL;
						_tmp28 = NULL;
						ccall = (_tmp28 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("g_quark_from_static_string"))), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp28);
						_tmp29 = NULL;
						cinit = (_tmp29 = vala_ccode_assignment_new ((ValaCCodeExpression*) cname, (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)), _tmp29);
						vala_ccode_function_call_add_argument (ccall, cexpr);
						_tmp30 = NULL;
						cexpr = (_tmp30 = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccondition, (ValaCCodeExpression*) cname, (ValaCCodeExpression*) cinit), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp30);
						(cname == NULL) ? NULL : (cname = (vala_ccode_node_unref (cname), NULL));
						(ccondition == NULL) ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
					} else {
						ValaCCodeIdentifier* _tmp31;
						ValaCCodeFunctionCall* _tmp32;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeExpression* _tmp34;
						ValaCCodeExpression* _tmp33;
						_tmp31 = NULL;
						_tmp32 = NULL;
						ccall = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("g_quark_from_string"))), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp32);
						vala_ccode_function_call_add_argument (ccall, cexpr);
						_tmp34 = NULL;
						_tmp33 = NULL;
						cexpr = (_tmp34 = (_tmp33 = (ValaCCodeExpression*) ccall, (_tmp33 == NULL) ? NULL : vala_ccode_node_ref (_tmp33)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp34);
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
					}
					ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ctemp, cexpr);
					if (cor == NULL) {
						ValaCCodeBinaryExpression* _tmp36;
						ValaCCodeBinaryExpression* _tmp35;
						_tmp36 = NULL;
						_tmp35 = NULL;
						cor = (_tmp36 = (_tmp35 = ccmp, (_tmp35 == NULL) ? NULL : vala_ccode_node_ref (_tmp35)), (cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL)), _tmp36);
					} else {
						ValaCCodeBinaryExpression* _tmp37;
						_tmp37 = NULL;
						cor = (_tmp37 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cor, (ValaCCodeExpression*) ccmp), (cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL)), _tmp37);
					}
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
					(ccmp == NULL) ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			cblock = vala_ccode_block_new ();
			{
				GeeList* _tmp38;
				GeeIterator* _tmp39;
				GeeIterator* _body_stmt_it;
				_tmp38 = NULL;
				_tmp39 = NULL;
				_body_stmt_it = (_tmp39 = gee_iterable_iterator ((GeeIterable*) (_tmp38 = vala_block_get_statements ((ValaBlock*) section))), (_tmp38 == NULL) ? NULL : (_tmp38 = (gee_collection_object_unref (_tmp38), NULL)), _tmp39);
				while (gee_iterator_next (_body_stmt_it)) {
					ValaCodeNode* body_stmt;
					body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
					if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))) {
						{
							GeeList* _tmp40;
							GeeIterator* _tmp41;
							GeeIterator* _cstmt_it;
							_tmp40 = NULL;
							_tmp41 = NULL;
							_cstmt_it = (_tmp41 = gee_iterable_iterator ((GeeIterable*) (_tmp40 = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))))), (_tmp40 == NULL) ? NULL : (_tmp40 = (gee_collection_object_unref (_tmp40), NULL)), _tmp41);
							while (gee_iterator_next (_cstmt_it)) {
								ValaCCodeNode* cstmt;
								cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
								vala_ccode_block_add_statement (cblock, cstmt);
								(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
							}
							(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
						}
					} else {
						vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					}
					(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
				}
				(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
			}
			_tmp42 = NULL;
			_tmp43 = NULL;
			cdo = (_tmp43 = vala_ccode_do_statement_new ((ValaCCodeStatement*) cblock, (ValaCCodeExpression*) (_tmp42 = vala_ccode_constant_new ("0"))), (_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)), _tmp43);
			cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) cor, (ValaCCodeStatement*) cdo, NULL);
			if (coldif != NULL) {
				vala_ccode_if_statement_set_false_statement (coldif, (ValaCCodeStatement*) cif);
			} else {
				ValaCCodeStatement* _tmp45;
				ValaCCodeStatement* _tmp44;
				_tmp45 = NULL;
				_tmp44 = NULL;
				ctopstmt = (_tmp45 = (_tmp44 = (ValaCCodeStatement*) cif, (_tmp44 == NULL) ? NULL : vala_ccode_node_ref (_tmp44)), (ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL)), _tmp45);
			}
			_tmp47 = NULL;
			_tmp46 = NULL;
			coldif = (_tmp47 = (_tmp46 = cif, (_tmp46 == NULL) ? NULL : vala_ccode_node_ref (_tmp46)), (coldif == NULL) ? NULL : (coldif = (vala_ccode_node_unref (coldif), NULL)), _tmp47);
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
			(cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL));
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
			(cdo == NULL) ? NULL : (cdo = (vala_ccode_node_unref (cdo), NULL));
			(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeConstant* _tmp48;
		ValaCCodeDoStatement* _tmp49;
		ValaCCodeDoStatement* cdo;
		cblock = vala_ccode_block_new ();
		{
			GeeIterator* _body_stmt_it;
			_body_stmt_it = gee_iterable_iterator ((GeeIterable*) default_statements);
			while (gee_iterator_next (_body_stmt_it)) {
				ValaCodeNode* body_stmt;
				body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
				vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
				(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
			}
			(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
		}
		_tmp48 = NULL;
		_tmp49 = NULL;
		cdo = (_tmp49 = vala_ccode_do_statement_new ((ValaCCodeStatement*) cblock, (ValaCCodeExpression*) (_tmp48 = vala_ccode_constant_new ("0"))), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp49);
		if (coldif == NULL) {
			ValaCCodeStatement* _tmp51;
			ValaCCodeStatement* _tmp50;
			/* there is only one section and that section
			 contains a default label*/
			_tmp51 = NULL;
			_tmp50 = NULL;
			ctopstmt = (_tmp51 = (_tmp50 = (ValaCCodeStatement*) cdo, (_tmp50 == NULL) ? NULL : vala_ccode_node_ref (_tmp50)), (ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL)), _tmp51);
		} else {
			vala_ccode_if_statement_set_false_statement (coldif, (ValaCCodeStatement*) cdo);
		}
		(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		(cdo == NULL) ? NULL : (cdo = (vala_ccode_node_unref (cdo), NULL));
	}
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) ctopstmt);
	(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
	(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
	(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
	(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
	(cswitchblock == NULL) ? NULL : (cswitchblock = (vala_ccode_node_unref (cswitchblock), NULL));
	(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
	(cquark == NULL) ? NULL : (cquark = (vala_ccode_node_unref (cquark), NULL));
	(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
	(default_statements == NULL) ? NULL : (default_statements = (gee_collection_object_unref (default_statements), NULL));
	(ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL));
	(coldif == NULL) ? NULL : (coldif = (vala_ccode_node_unref (coldif), NULL));
}


static void vala_ccode_control_flow_module_real_visit_switch_statement (ValaCCodeModule* base, ValaSwitchStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeSwitchStatement* cswitch;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_data_type_compatible (vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), ((ValaCCodeBaseModule*) self)->string_type)) {
		vala_ccode_control_flow_module_visit_string_switch_statement (self, stmt);
		return;
	}
	cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_statement_get_expression (stmt))));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cswitch);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _section_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_section_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_switch_statement_get_sections (stmt))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_section_it)) {
			ValaSwitchSection* section;
			ValaCCodeBlock* cblock;
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				ValaCCodeLabel* _tmp2;
				ValaCCodeBlock* cdefaultblock;
				_tmp2 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp2 = vala_ccode_label_new ("default")));
				(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
				cdefaultblock = vala_ccode_block_new ();
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) cdefaultblock);
				{
					GeeList* _tmp3;
					GeeIterator* _tmp4;
					GeeIterator* _default_stmt_it;
					_tmp3 = NULL;
					_tmp4 = NULL;
					_default_stmt_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_block_get_statements ((ValaBlock*) section))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
					while (gee_iterator_next (_default_stmt_it)) {
						ValaCodeNode* default_stmt;
						default_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_default_stmt_it));
						vala_ccode_block_add_statement (cdefaultblock, vala_code_node_get_ccodenode (default_stmt));
						(default_stmt == NULL) ? NULL : (default_stmt = (vala_code_node_unref (default_stmt), NULL));
					}
					(_default_stmt_it == NULL) ? NULL : (_default_stmt_it = (gee_collection_object_unref (_default_stmt_it), NULL));
				}
				(cdefaultblock == NULL) ? NULL : (cdefaultblock = (vala_ccode_node_unref (cdefaultblock), NULL));
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			{
				GeeList* _tmp5;
				GeeIterator* _tmp6;
				GeeIterator* _label_it;
				_tmp5 = NULL;
				_tmp6 = NULL;
				_label_it = (_tmp6 = gee_iterable_iterator ((GeeIterable*) (_tmp5 = vala_switch_section_get_labels (section))), (_tmp5 == NULL) ? NULL : (_tmp5 = (gee_collection_object_unref (_tmp5), NULL)), _tmp6);
				while (gee_iterator_next (_label_it)) {
					ValaSwitchLabel* label;
					ValaCCodeCaseStatement* _tmp7;
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp7 = NULL;
					vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp7 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))))));
					(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			cblock = vala_ccode_block_new ();
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) cblock);
			{
				GeeList* _tmp8;
				GeeIterator* _tmp9;
				GeeIterator* _body_stmt_it;
				_tmp8 = NULL;
				_tmp9 = NULL;
				_body_stmt_it = (_tmp9 = gee_iterable_iterator ((GeeIterable*) (_tmp8 = vala_block_get_statements ((ValaBlock*) section))), (_tmp8 == NULL) ? NULL : (_tmp8 = (gee_collection_object_unref (_tmp8), NULL)), _tmp9);
				while (gee_iterator_next (_body_stmt_it)) {
					ValaCodeNode* body_stmt;
					body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
				}
				(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
			}
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars);
	(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
}


static void vala_ccode_control_flow_module_real_visit_switch_section (ValaCCodeModule* base, ValaSwitchSection* section) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (section != NULL);
	vala_ccode_module_visit_block ((ValaCCodeModule*) self, (ValaBlock*) section);
}


static void vala_ccode_control_flow_module_real_visit_switch_label (ValaCCodeModule* base, ValaSwitchLabel* label) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (label != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) label, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
}


static void vala_ccode_control_flow_module_real_visit_while_statement (ValaCCodeModule* base, ValaWhileStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeWhileStatement* _tmp0;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_while_statement_get_condition (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_while_statement_get_body (stmt))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_while_statement_get_condition (stmt)->temp_vars);
}


static void vala_ccode_control_flow_module_real_visit_do_statement (ValaCCodeModule* base, ValaDoStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeDoStatement* _tmp0;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_do_statement_get_body (stmt))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_do_statement_get_condition (stmt))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_do_statement_get_condition (stmt)->temp_vars);
}


static void vala_ccode_control_flow_module_real_visit_for_statement (ValaCCodeModule* base, ValaForStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeExpression* ccondition;
	ValaCCodeForStatement* cfor;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	ccondition = NULL;
	if (vala_for_statement_get_condition (stmt) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		ccondition = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_for_statement_get_condition (stmt))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0)), (ccondition == NULL) ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL)), _tmp1);
	}
	cfor = vala_ccode_for_statement_new (ccondition, VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_for_statement_get_body (stmt))));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfor);
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _init_expr_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_init_expr_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_for_statement_get_initializer (stmt))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_init_expr_it)) {
			ValaExpression* init_expr;
			init_expr = (ValaExpression*) gee_iterator_get (_init_expr_it);
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) init_expr)));
			vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) init_expr->temp_vars);
			(init_expr == NULL) ? NULL : (init_expr = (vala_code_node_unref (init_expr), NULL));
		}
		(_init_expr_it == NULL) ? NULL : (_init_expr_it = (gee_collection_object_unref (_init_expr_it), NULL));
	}
	{
		GeeList* _tmp4;
		GeeIterator* _tmp5;
		GeeIterator* _it_expr_it;
		_tmp4 = NULL;
		_tmp5 = NULL;
		_it_expr_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_for_statement_get_iterator (stmt))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
		while (gee_iterator_next (_it_expr_it)) {
			ValaExpression* it_expr;
			it_expr = (ValaExpression*) gee_iterator_get (_it_expr_it);
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) it_expr)));
			vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) it_expr->temp_vars);
			(it_expr == NULL) ? NULL : (it_expr = (vala_code_node_unref (it_expr), NULL));
		}
		(_it_expr_it == NULL) ? NULL : (_it_expr_it = (gee_collection_object_unref (_it_expr_it), NULL));
	}
	if (vala_for_statement_get_condition (stmt) != NULL) {
		vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_for_statement_get_condition (stmt)->temp_vars);
	}
	(ccondition == NULL) ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL));
	(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
}


static void vala_ccode_control_flow_module_real_visit_foreach_statement (ValaCCodeModule* base, ValaForeachStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeBlock* cblock;
	ValaCCodeFragment* cfrag;
	ValaLocalVariable* _tmp0;
	ValaLocalVariable* collection_backup;
	ValaDataType* collection_type;
	gboolean _tmp1;
	gboolean _tmp8;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_element_variable (stmt), TRUE);
	vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_collection_variable (stmt), TRUE);
	if (vala_foreach_statement_get_iterator_variable (stmt) != NULL) {
		vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_iterator_variable (stmt), TRUE);
	}
	vala_ccode_module_visit_block ((ValaCCodeModule*) self, (ValaBlock*) stmt);
	cblock = vala_ccode_block_new ();
	/* sets #line*/
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cblock);
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) vala_foreach_statement_get_collection (stmt)->temp_vars);
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfrag);
	_tmp0 = NULL;
	collection_backup = (_tmp0 = vala_foreach_statement_get_collection_variable (stmt), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	collection_type = vala_data_type_copy (vala_local_variable_get_variable_type (collection_backup));
	_tmp1 = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
		_tmp1 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		char* _tmp2;
		ValaCCodeExpressionStatement* _tmp5;
		ValaCCodeAssignment* _tmp4;
		ValaCCodeExpression* _tmp3;
		_tmp2 = NULL;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp2 = vala_data_type_get_cname (collection_type), vala_symbol_get_name ((ValaSymbol*) collection_backup));
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp5 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_assignment_new (_tmp3 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	} else {
		char* _tmp6;
		ValaCCodeDeclaration* _tmp7;
		ValaCCodeDeclaration* ccoldecl;
		ValaCCodeVariableDeclarator* ccolvardecl;
		_tmp6 = NULL;
		_tmp7 = NULL;
		ccoldecl = (_tmp7 = vala_ccode_declaration_new (_tmp6 = vala_data_type_get_cname (collection_type)), _tmp6 = (g_free (_tmp6), NULL), _tmp7);
		ccolvardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) collection_backup), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt))));
		vala_ccode_node_set_line ((ValaCCodeNode*) ccolvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
		vala_ccode_declaration_add_declarator (ccoldecl, (ValaCCodeDeclarator*) ccolvardecl);
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ccoldecl);
		(ccoldecl == NULL) ? NULL : (ccoldecl = (vala_ccode_node_unref (ccoldecl), NULL));
		(ccolvardecl == NULL) ? NULL : (ccolvardecl = (vala_ccode_node_unref (ccolvardecl), NULL));
	}
	_tmp8 = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp8 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt));
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		ValaCCodeFragment* _tmp9;
		/* exception handling*/
		_tmp9 = NULL;
		cfrag = (_tmp9 = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp9);
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_foreach_statement_get_collection (stmt), cfrag);
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfrag);
	}
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaArrayType* _tmp10;
		ValaArrayType* array_type;
		ValaCCodeExpression* array_len;
		gboolean _tmp11;
		char* it_name;
		gboolean _tmp19;
		ValaCCodeBlock* cbody;
		ValaCCodeExpression* _tmp22;
		ValaCCodeExpression* _tmp21;
		ValaCCodeExpression* _tmp23;
		ValaCCodeExpression* element_expr;
		ValaDataType* element_type;
		ValaCCodeExpression* _tmp24;
		ValaCCodeFragment* _tmp25;
		gboolean _tmp26;
		ValaCCodeExpression* _tmp45;
		ValaCCodeBinaryExpression* _tmp46;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeForStatement* cfor;
		ValaCCodeAssignment* _tmp49;
		ValaCCodeConstant* _tmp48;
		ValaCCodeExpression* _tmp47;
		ValaCCodeAssignment* _tmp54;
		ValaCCodeBinaryExpression* _tmp53;
		ValaCCodeConstant* _tmp52;
		ValaCCodeExpression* _tmp51;
		ValaCCodeExpression* _tmp50;
		_tmp10 = NULL;
		array_type = (_tmp10 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt))), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10));
		array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_collection (stmt), -1);
		_tmp11 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp11 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp11 = FALSE;
		}
		/* store array length for use by _vala_array_free*/
		if (_tmp11) {
			char* _tmp12;
			ValaCCodeExpressionStatement* _tmp16;
			ValaCCodeAssignment* _tmp15;
			ValaCCodeExpression* _tmp14;
			char* _tmp13;
			_tmp12 = NULL;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", _tmp12 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) collection_backup), 1));
			_tmp12 = (g_free (_tmp12), NULL);
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp16 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_assignment_new (_tmp14 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp13 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) collection_backup), 1)), array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
			(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			_tmp13 = (g_free (_tmp13), NULL);
		} else {
			ValaCCodeDeclaration* clendecl;
			ValaCCodeVariableDeclarator* _tmp18;
			char* _tmp17;
			clendecl = vala_ccode_declaration_new ("int");
			_tmp18 = NULL;
			_tmp17 = NULL;
			vala_ccode_declaration_add_declarator (clendecl, (ValaCCodeDeclarator*) (_tmp18 = vala_ccode_variable_declarator_new (_tmp17 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) collection_backup), 1), array_len)));
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
			_tmp17 = (g_free (_tmp17), NULL);
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) clendecl);
			(clendecl == NULL) ? NULL : (clendecl = (vala_ccode_node_unref (clendecl), NULL));
		}
		it_name = g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL);
		_tmp19 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp19 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp19 = FALSE;
		}
		if (_tmp19) {
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", it_name);
		} else {
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp20;
			citdecl = vala_ccode_declaration_new ("int");
			_tmp20 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp20 = vala_ccode_variable_declarator_new (it_name, NULL)));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) citdecl);
			(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
		}
		cbody = vala_ccode_block_new ();
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp23 = NULL;
		element_expr = (_tmp23 = (ValaCCodeExpression*) vala_ccode_element_access_new (_tmp21 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), _tmp22 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name)), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), (_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)), _tmp23);
		element_type = vala_data_type_copy (vala_array_type_get_element_type (array_type));
		vala_data_type_set_value_owned (element_type, FALSE);
		_tmp24 = NULL;
		element_expr = (_tmp24 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp24);
		_tmp25 = NULL;
		cfrag = (_tmp25 = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp25);
		vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
		vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cfrag);
		gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
		_tmp26 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp26 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp26 = FALSE;
		}
		if (_tmp26) {
			char* _tmp27;
			ValaCCodeExpressionStatement* _tmp30;
			ValaCCodeAssignment* _tmp29;
			ValaCCodeExpression* _tmp28;
			_tmp27 = NULL;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp27 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), vala_foreach_statement_get_variable_name (stmt));
			_tmp27 = (g_free (_tmp27), NULL);
			_tmp30 = NULL;
			_tmp29 = NULL;
			_tmp28 = NULL;
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp30 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_assignment_new (_tmp28 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt)), element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
			(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		} else {
			char* _tmp31;
			ValaCCodeDeclaration* _tmp32;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp33;
			_tmp31 = NULL;
			_tmp32 = NULL;
			cdecl_ = (_tmp32 = vala_ccode_declaration_new (_tmp31 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt))), _tmp31 = (g_free (_tmp31), NULL), _tmp32);
			_tmp33 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp33 = vala_ccode_variable_declarator_new (vala_foreach_statement_get_variable_name (stmt), element_expr)));
			(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cdecl_);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
		/* add array length variable for stacked arrays*/
		if (VALA_IS_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt))) {
			ValaArrayType* _tmp34;
			ValaArrayType* inner_array_type;
			_tmp34 = NULL;
			inner_array_type = (_tmp34 = VALA_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt)), (_tmp34 == NULL) ? NULL : vala_code_node_ref (_tmp34));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (inner_array_type); dim++) {
					gboolean _tmp35;
					_tmp35 = FALSE;
					if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
						_tmp35 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
					} else {
						_tmp35 = FALSE;
					}
					if (_tmp35) {
						char* _tmp36;
						ValaCCodeExpressionStatement* _tmp41;
						ValaCCodeAssignment* _tmp40;
						ValaCCodeConstant* _tmp39;
						ValaCCodeExpression* _tmp38;
						char* _tmp37;
						_tmp36 = NULL;
						vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", _tmp36 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_variable_name (stmt), dim));
						_tmp36 = (g_free (_tmp36), NULL);
						_tmp41 = NULL;
						_tmp40 = NULL;
						_tmp39 = NULL;
						_tmp38 = NULL;
						_tmp37 = NULL;
						vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp41 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_assignment_new (_tmp38 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp37 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_variable_name (stmt), dim)), (ValaCCodeExpression*) (_tmp39 = vala_ccode_constant_new ("-1")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
						(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
						(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
						(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
						_tmp37 = (g_free (_tmp37), NULL);
					} else {
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp44;
						ValaCCodeConstant* _tmp43;
						char* _tmp42;
						cdecl_ = vala_ccode_declaration_new ("int");
						_tmp44 = NULL;
						_tmp43 = NULL;
						_tmp42 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp44 = vala_ccode_variable_declarator_new (_tmp42 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_variable_name (stmt), dim), (ValaCCodeExpression*) (_tmp43 = vala_ccode_constant_new ("-1")))));
						(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
						(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
						_tmp42 = (g_free (_tmp42), NULL);
						vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cdecl_);
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
				}
			}
			(inner_array_type == NULL) ? NULL : (inner_array_type = (vala_code_node_unref (inner_array_type), NULL));
		}
		vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_body (stmt)));
		_tmp45 = NULL;
		_tmp46 = NULL;
		ccond = (_tmp46 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, _tmp45 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), array_len), (_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)), _tmp46);
		cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cbody);
		_tmp49 = NULL;
		_tmp48 = NULL;
		_tmp47 = NULL;
		vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp49 = vala_ccode_assignment_new (_tmp47 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp48 = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
		(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
		(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
		_tmp54 = NULL;
		_tmp53 = NULL;
		_tmp52 = NULL;
		_tmp51 = NULL;
		_tmp50 = NULL;
		vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp54 = vala_ccode_assignment_new (_tmp50 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp53 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp51 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp52 = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
		(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
		(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
		(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
		(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfor);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(array_len == NULL) ? NULL : (array_len = (vala_ccode_node_unref (array_len), NULL));
		it_name = (g_free (it_name), NULL);
		(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
		(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
		(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
		(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
		(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
	} else {
		gboolean _tmp55;
		ValaObjectType* _tmp56;
		gboolean _tmp57;
		_tmp55 = FALSE;
		_tmp56 = NULL;
		if ((_tmp57 = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp56 = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->glist_type))), (_tmp56 == NULL) ? NULL : (_tmp56 = (vala_code_node_unref (_tmp56), NULL)), _tmp57)) {
			_tmp55 = TRUE;
		} else {
			ValaObjectType* _tmp58;
			_tmp58 = NULL;
			_tmp55 = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp58 = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->gslist_type)));
			(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_code_node_unref (_tmp58), NULL));
		}
		if (_tmp55) {
			char* it_name;
			gboolean _tmp59;
			ValaCCodeBlock* cbody;
			ValaCCodeExpression* _tmp63;
			ValaCCodeExpression* _tmp64;
			ValaCCodeExpression* element_expr;
			GeeList* _tmp65;
			gboolean _tmp66;
			ValaDataType* _tmp68;
			GeeList* _tmp67;
			ValaDataType* _tmp69;
			ValaDataType* element_data_type;
			ValaCCodeExpression* _tmp70;
			ValaCCodeExpression* _tmp71;
			ValaCCodeFragment* _tmp72;
			gboolean _tmp73;
			ValaCCodeConstant* _tmp81;
			ValaCCodeExpression* _tmp80;
			ValaCCodeBinaryExpression* _tmp82;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp85;
			ValaCCodeExpression* _tmp84;
			ValaCCodeExpression* _tmp83;
			ValaCCodeAssignment* _tmp89;
			ValaCCodeMemberAccess* _tmp88;
			ValaCCodeExpression* _tmp87;
			ValaCCodeExpression* _tmp86;
			/* iterating over a GList or GSList*/
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp59 = FALSE;
			if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
				_tmp59 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
			} else {
				_tmp59 = FALSE;
			}
			if (_tmp59) {
				char* _tmp60;
				_tmp60 = NULL;
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp60 = vala_data_type_get_cname (collection_type), it_name);
				_tmp60 = (g_free (_tmp60), NULL);
			} else {
				char* _tmp61;
				ValaCCodeDeclaration* _tmp62;
				ValaCCodeDeclaration* citdecl;
				ValaCCodeVariableDeclarator* citvardecl;
				_tmp61 = NULL;
				_tmp62 = NULL;
				citdecl = (_tmp62 = vala_ccode_declaration_new (_tmp61 = vala_data_type_get_cname (collection_type)), _tmp61 = (g_free (_tmp61), NULL), _tmp62);
				citvardecl = vala_ccode_variable_declarator_new (it_name, NULL);
				vala_ccode_node_set_line ((ValaCCodeNode*) citvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
				vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) citvardecl);
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) citdecl);
				(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
				(citvardecl == NULL) ? NULL : (citvardecl = (vala_ccode_node_unref (citvardecl), NULL));
			}
			cbody = vala_ccode_block_new ();
			_tmp63 = NULL;
			_tmp64 = NULL;
			element_expr = (_tmp64 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (_tmp63 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), "data"), (_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL)), _tmp64);
			_tmp65 = NULL;
			if ((_tmp66 = gee_collection_get_size ((GeeCollection*) (_tmp65 = vala_data_type_get_type_arguments (collection_type))) != 1, (_tmp65 == NULL) ? NULL : (_tmp65 = (gee_collection_object_unref (_tmp65), NULL)), _tmp66)) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) stmt), "internal error: missing generic type argument");
				vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
				it_name = (g_free (it_name), NULL);
				(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
				(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
				(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
				(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
				(collection_backup == NULL) ? NULL : (collection_backup = (vala_code_node_unref (collection_backup), NULL));
				(collection_type == NULL) ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL));
				return;
			}
			_tmp68 = NULL;
			_tmp67 = NULL;
			_tmp69 = NULL;
			element_data_type = (_tmp69 = vala_data_type_copy (_tmp68 = (ValaDataType*) gee_list_get (_tmp67 = vala_data_type_get_type_arguments (collection_type), 0)), (_tmp68 == NULL) ? NULL : (_tmp68 = (vala_code_node_unref (_tmp68), NULL)), (_tmp67 == NULL) ? NULL : (_tmp67 = (gee_collection_object_unref (_tmp67), NULL)), _tmp69);
			vala_data_type_set_value_owned (element_data_type, FALSE);
			_tmp70 = NULL;
			element_expr = (_tmp70 = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, element_expr, element_data_type), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp70);
			_tmp71 = NULL;
			element_expr = (_tmp71 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_data_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp71);
			_tmp72 = NULL;
			cfrag = (_tmp72 = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp72);
			vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cfrag);
			gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
			_tmp73 = FALSE;
			if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
				_tmp73 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
			} else {
				_tmp73 = FALSE;
			}
			if (_tmp73) {
				char* _tmp74;
				ValaCCodeExpressionStatement* _tmp77;
				ValaCCodeAssignment* _tmp76;
				ValaCCodeExpression* _tmp75;
				_tmp74 = NULL;
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp74 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), vala_foreach_statement_get_variable_name (stmt));
				_tmp74 = (g_free (_tmp74), NULL);
				_tmp77 = NULL;
				_tmp76 = NULL;
				_tmp75 = NULL;
				vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp77 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp76 = vala_ccode_assignment_new (_tmp75 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt)), element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
				(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
				(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
			} else {
				char* _tmp78;
				ValaCCodeDeclaration* _tmp79;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* cvardecl;
				_tmp78 = NULL;
				_tmp79 = NULL;
				cdecl_ = (_tmp79 = vala_ccode_declaration_new (_tmp78 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt))), _tmp78 = (g_free (_tmp78), NULL), _tmp79);
				cvardecl = vala_ccode_variable_declarator_new (vala_foreach_statement_get_variable_name (stmt), element_expr);
				vala_ccode_node_set_line ((ValaCCodeNode*) cvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) cvardecl);
				vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cdecl_);
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				(cvardecl == NULL) ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL));
			}
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_body (stmt)));
			_tmp81 = NULL;
			_tmp80 = NULL;
			_tmp82 = NULL;
			ccond = (_tmp82 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, _tmp80 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp81 = vala_ccode_constant_new ("NULL"))), (_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)), (_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)), _tmp82);
			cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cbody);
			_tmp85 = NULL;
			_tmp84 = NULL;
			_tmp83 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp85 = vala_ccode_assignment_new (_tmp83 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), _tmp84 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
			(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
			(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
			_tmp89 = NULL;
			_tmp88 = NULL;
			_tmp87 = NULL;
			_tmp86 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp89 = vala_ccode_assignment_new (_tmp86 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp88 = vala_ccode_member_access_new_pointer (_tmp87 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
			(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
			(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfor);
			it_name = (g_free (it_name), NULL);
			(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
			(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
			(element_data_type == NULL) ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL));
			(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
			(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
		}
	}
	{
		GeeList* _tmp90;
		GeeIterator* _tmp91;
		GeeIterator* _local_it;
		_tmp90 = NULL;
		_tmp91 = NULL;
		_local_it = (_tmp91 = gee_iterable_iterator ((GeeIterable*) (_tmp90 = vala_block_get_local_variables ((ValaBlock*) stmt))), (_tmp90 == NULL) ? NULL : (_tmp90 = (gee_collection_object_unref (_tmp90), NULL)), _tmp91);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_local_variable_get_variable_type (local))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp93;
				ValaCCodeExpression* _tmp92;
				ValaCCodeExpressionStatement* _tmp94;
				ValaCCodeExpressionStatement* cunref;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp93 = NULL;
				_tmp92 = NULL;
				_tmp94 = NULL;
				cunref = (_tmp94 = vala_ccode_expression_statement_new (_tmp93 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, _tmp92 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma)), (_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL)), (_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL)), _tmp94);
				vala_ccode_node_set_line ((ValaCCodeNode*) cunref, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cunref);
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				(cunref == NULL) ? NULL : (cunref = (vala_ccode_node_unref (cunref), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	(collection_backup == NULL) ? NULL : (collection_backup = (vala_code_node_unref (collection_backup), NULL));
	(collection_type == NULL) ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL));
}


static void vala_ccode_control_flow_module_real_visit_break_statement (ValaCCodeModule* base, ValaBreakStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeBreakStatement* _tmp0;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_break_statement_new ()));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_base_module_create_local_free ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}


static void vala_ccode_control_flow_module_real_visit_continue_statement (ValaCCodeModule* base, ValaContinueStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeContinueStatement* _tmp0;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_continue_statement_new ()));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_base_module_create_local_free ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}


static void vala_ccode_control_flow_module_class_init (ValaCCodeControlFlowModuleClass * klass) {
	vala_ccode_control_flow_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_if_statement = vala_ccode_control_flow_module_real_visit_if_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_statement = vala_ccode_control_flow_module_real_visit_switch_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_section = vala_ccode_control_flow_module_real_visit_switch_section;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_label = vala_ccode_control_flow_module_real_visit_switch_label;
	VALA_CCODE_MODULE_CLASS (klass)->visit_while_statement = vala_ccode_control_flow_module_real_visit_while_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_do_statement = vala_ccode_control_flow_module_real_visit_do_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_for_statement = vala_ccode_control_flow_module_real_visit_for_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_foreach_statement = vala_ccode_control_flow_module_real_visit_foreach_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_break_statement = vala_ccode_control_flow_module_real_visit_break_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_continue_statement = vala_ccode_control_flow_module_real_visit_continue_statement;
}


static void vala_ccode_control_flow_module_instance_init (ValaCCodeControlFlowModule * self) {
}


GType vala_ccode_control_flow_module_get_type (void) {
	static GType vala_ccode_control_flow_module_type_id = 0;
	if (vala_ccode_control_flow_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeControlFlowModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_control_flow_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeControlFlowModule), 0, (GInstanceInitFunc) vala_ccode_control_flow_module_instance_init, NULL };
		vala_ccode_control_flow_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_MODULE, "ValaCCodeControlFlowModule", &g_define_type_info, 0);
	}
	return vala_ccode_control_flow_module_type_id;
}




