/* valadbusservermodule.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
*  Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#ifndef __GOBJECT_VALADBUSSERVERMODULE_H__
#define __GOBJECT_VALADBUSSERVERMODULE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valamethodcall.h>
#include <ccode/valaccodefragment.h>
#include <vala/valaobjecttypesymbol.h>
#include <gobject/valadbusclientmodule.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valaccodemodule.h>

G_BEGIN_DECLS


#define VALA_TYPE_DBUS_SERVER_MODULE (vala_dbus_server_module_get_type ())
#define VALA_DBUS_SERVER_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_SERVER_MODULE, ValaDBusServerModule))
#define VALA_DBUS_SERVER_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_SERVER_MODULE, ValaDBusServerModuleClass))
#define VALA_IS_DBUS_SERVER_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_SERVER_MODULE))
#define VALA_IS_DBUS_SERVER_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_SERVER_MODULE))
#define VALA_DBUS_SERVER_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_SERVER_MODULE, ValaDBusServerModuleClass))

typedef struct _ValaDBusServerModule ValaDBusServerModule;
typedef struct _ValaDBusServerModuleClass ValaDBusServerModuleClass;
typedef struct _ValaDBusServerModulePrivate ValaDBusServerModulePrivate;

/**
 * The link between a dynamic method and generated code.
 */
struct _ValaDBusServerModule {
	ValaDBusClientModule parent_instance;
	ValaDBusServerModulePrivate * priv;
};

struct _ValaDBusServerModuleClass {
	ValaDBusClientModuleClass parent_class;
};


ValaDBusServerModule* vala_dbus_server_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusServerModule* vala_dbus_server_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
GType vala_dbus_server_module_get_type (void);


G_END_DECLS

#endif
