/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacreationmethod.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valasourcereference.h>
#include <vala/valavoidtype.h>
#include <vala/valadatatype.h>
#include <vala/valacodevisitor.h>
#include <vala/valaformalparameter.h>
#include <vala/valasymbol.h>
#include <vala/valatypesymbol.h>
#include <vala/valastruct.h>
#include <vala/valaclass.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valareport.h>
#include <vala/valasourcefile.h>




struct _ValaCreationMethodPrivate {
	char* _class_name;
	gint _n_construction_params;
	char* _custom_return_type_cname;
	gboolean _chain_up;
};

#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
enum  {
	VALA_CREATION_METHOD_DUMMY_PROPERTY
};
static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_creation_method_real_get_default_cname (ValaMethod* base);
static char* vala_creation_method_real_get_real_cname (ValaMethod* base);
static gboolean vala_creation_method_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_creation_method_parent_class = NULL;
static void vala_creation_method_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod* vala_creation_method_construct (GType object_type, const char* class_name, const char* name, ValaSourceReference* source_reference) {
	ValaCreationMethod* self;
	ValaVoidType* _tmp0;
	_tmp0 = NULL;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) (_tmp0 = vala_void_type_new (NULL)), source_reference);
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL));
	vala_creation_method_set_class_name (self, class_name);
	vala_method_set_carray_length_parameter_position ((ValaMethod*) self, (double) (-3));
	vala_method_set_cdelegate_target_parameter_position ((ValaMethod*) self, (double) (-3));
	return self;
}


ValaCreationMethod* vala_creation_method_new (const char* class_name, const char* name, ValaSourceReference* source_reference) {
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference);
}


static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}


static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _param_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_param_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_method_get_parameters ((ValaMethod*) self))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_code_node_accept ((ValaCodeNode*) param, visitor);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _error_type_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_error_type_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_code_node_get_error_types ((ValaCodeNode*) self))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_error_type_it)) {
			ValaDataType* error_type;
			error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
			vala_code_node_accept ((ValaCodeNode*) error_type, visitor);
			(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
		}
		(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
	}
	if (vala_method_get_body ((ValaMethod*) self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_method_get_body ((ValaMethod*) self), visitor);
	}
}


static char* vala_creation_method_real_get_default_cname (ValaMethod* base) {
	ValaCreationMethod * self;
	ValaTypeSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaTypeSymbol* parent;
	char* infix;
	self = (ValaCreationMethod*) base;
	_tmp1 = NULL;
	_tmp0 = NULL;
	parent = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) self), VALA_IS_TYPESYMBOL (_tmp0) ? ((ValaTypeSymbol*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	infix = g_strdup ("new");
	if (VALA_IS_STRUCT (parent)) {
		char* _tmp2;
		_tmp2 = NULL;
		infix = (_tmp2 = g_strdup ("init"), infix = (g_free (infix), NULL), _tmp2);
	}
	if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) self), "new") == 0) {
		char* _tmp3;
		char* _tmp4;
		char* _tmp5;
		_tmp3 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		return (_tmp5 = (_tmp4 = g_strdup_printf ("%s%s", _tmp3 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) parent), infix), _tmp3 = (g_free (_tmp3), NULL), _tmp4), (parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL)), infix = (g_free (infix), NULL), _tmp5);
	} else {
		char* _tmp6;
		char* _tmp7;
		char* _tmp8;
		_tmp6 = NULL;
		_tmp7 = NULL;
		_tmp8 = NULL;
		return (_tmp8 = (_tmp7 = g_strdup_printf ("%s%s_%s", _tmp6 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) parent), infix, vala_symbol_get_name ((ValaSymbol*) self)), _tmp6 = (g_free (_tmp6), NULL), _tmp7), (parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL)), infix = (g_free (infix), NULL), _tmp8);
	}
	(parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL));
	infix = (g_free (infix), NULL);
}


static char* vala_creation_method_real_get_real_cname (ValaMethod* base) {
	ValaCreationMethod * self;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* parent;
	gboolean _tmp2;
	char* infix;
	self = (ValaCreationMethod*) base;
	_tmp1 = NULL;
	_tmp0 = NULL;
	parent = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) self), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (parent == NULL) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = vala_class_get_is_compact (parent);
	}
	if (_tmp2) {
		char* _tmp3;
		_tmp3 = NULL;
		return (_tmp3 = vala_method_get_cname ((ValaMethod*) self), (parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL)), _tmp3);
	}
	infix = g_strdup ("construct");
	if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) self), "new") == 0) {
		char* _tmp4;
		char* _tmp5;
		char* _tmp6;
		_tmp4 = NULL;
		_tmp5 = NULL;
		_tmp6 = NULL;
		return (_tmp6 = (_tmp5 = g_strdup_printf ("%s%s", _tmp4 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) parent), infix), _tmp4 = (g_free (_tmp4), NULL), _tmp5), (parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL)), infix = (g_free (infix), NULL), _tmp6);
	} else {
		char* _tmp7;
		char* _tmp8;
		char* _tmp9;
		_tmp7 = NULL;
		_tmp8 = NULL;
		_tmp9 = NULL;
		return (_tmp9 = (_tmp8 = g_strdup_printf ("%s%s_%s", _tmp7 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) parent), infix, vala_symbol_get_name ((ValaSymbol*) self)), _tmp7 = (g_free (_tmp7), NULL), _tmp8), (parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL)), infix = (g_free (infix), NULL), _tmp9);
	}
	(parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL));
	infix = (g_free (infix), NULL);
}


static gboolean vala_creation_method_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaCreationMethod * self;
	gboolean _tmp1;
	ValaSourceFile* _tmp5;
	ValaSourceFile* old_source_file;
	ValaSymbol* _tmp6;
	ValaSymbol* old_symbol;
	ValaClass* _tmp7;
	ValaClass* old_class;
	ValaStruct* _tmp8;
	ValaStruct* old_struct;
	ValaDataType* _tmp9;
	ValaDataType* old_return_type;
	ValaDataType* _tmp15;
	ValaDataType* _tmp14;
	ValaClass* _tmp21;
	ValaClass* _tmp20;
	ValaStruct* _tmp23;
	ValaStruct* _tmp22;
	ValaDataType* _tmp25;
	ValaDataType* _tmp24;
	gboolean _tmp29;
	gboolean _tmp30;
	gboolean _tmp34;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_method_process_attributes ((ValaMethod*) self);
	_tmp1 = FALSE;
	if (self->priv->_class_name != NULL) {
		_tmp1 = _vala_strcmp0 (self->priv->_class_name, vala_symbol_get_name (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) != 0;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		char* _tmp3;
		char* _tmp2;
		/* class_name is null for constructors generated by GIdlParser*/
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp3 = g_strdup_printf ("missing return type in method `%s.%s´", _tmp2 = vala_symbol_get_full_name (vala_semantic_analyzer_get_current_symbol (analyzer)), self->priv->_class_name));
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		return FALSE;
	}
	_tmp5 = NULL;
	old_source_file = (_tmp5 = vala_semantic_analyzer_get_current_source_file (analyzer), (_tmp5 == NULL) ? NULL : vala_source_file_ref (_tmp5));
	_tmp6 = NULL;
	old_symbol = (_tmp6 = vala_semantic_analyzer_get_current_symbol (analyzer), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
	_tmp7 = NULL;
	old_class = (_tmp7 = analyzer->current_class, (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
	_tmp8 = NULL;
	old_struct = (_tmp8 = analyzer->current_struct, (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
	_tmp9 = NULL;
	old_return_type = (_tmp9 = analyzer->current_return_type, (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
		ValaClass* _tmp11;
		ValaClass* _tmp10;
		_tmp11 = NULL;
		_tmp10 = NULL;
		analyzer->current_class = (_tmp11 = (_tmp10 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10)), (analyzer->current_class == NULL) ? NULL : (analyzer->current_class = (vala_code_node_unref (analyzer->current_class), NULL)), _tmp11);
	} else {
		if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
			ValaStruct* _tmp13;
			ValaStruct* _tmp12;
			_tmp13 = NULL;
			_tmp12 = NULL;
			analyzer->current_struct = (_tmp13 = (_tmp12 = VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12)), (analyzer->current_struct == NULL) ? NULL : (analyzer->current_struct = (vala_code_node_unref (analyzer->current_struct), NULL)), _tmp13);
		}
	}
	_tmp15 = NULL;
	_tmp14 = NULL;
	analyzer->current_return_type = (_tmp15 = (_tmp14 = vala_method_get_return_type ((ValaMethod*) self), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14)), (analyzer->current_return_type == NULL) ? NULL : (analyzer->current_return_type = (vala_code_node_unref (analyzer->current_return_type), NULL)), _tmp15);
	{
		GeeList* _tmp16;
		GeeIterator* _tmp17;
		GeeIterator* _param_it;
		_tmp16 = NULL;
		_tmp17 = NULL;
		_param_it = (_tmp17 = gee_iterable_iterator ((GeeIterable*) (_tmp16 = vala_method_get_parameters ((ValaMethod*) self))), (_tmp16 == NULL) ? NULL : (_tmp16 = (gee_collection_object_unref (_tmp16), NULL)), _tmp17);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_code_node_check ((ValaCodeNode*) param, analyzer);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	{
		GeeList* _tmp18;
		GeeIterator* _tmp19;
		GeeIterator* _error_type_it;
		_tmp18 = NULL;
		_tmp19 = NULL;
		_error_type_it = (_tmp19 = gee_iterable_iterator ((GeeIterable*) (_tmp18 = vala_code_node_get_error_types ((ValaCodeNode*) self))), (_tmp18 == NULL) ? NULL : (_tmp18 = (gee_collection_object_unref (_tmp18), NULL)), _tmp19);
		while (gee_iterator_next (_error_type_it)) {
			ValaDataType* error_type;
			error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
			vala_code_node_check ((ValaCodeNode*) error_type, analyzer);
			(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
		}
		(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
	}
	if (vala_method_get_body ((ValaMethod*) self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_method_get_body ((ValaMethod*) self), analyzer);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	_tmp21 = NULL;
	_tmp20 = NULL;
	analyzer->current_class = (_tmp21 = (_tmp20 = old_class, (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20)), (analyzer->current_class == NULL) ? NULL : (analyzer->current_class = (vala_code_node_unref (analyzer->current_class), NULL)), _tmp21);
	_tmp23 = NULL;
	_tmp22 = NULL;
	analyzer->current_struct = (_tmp23 = (_tmp22 = old_struct, (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22)), (analyzer->current_struct == NULL) ? NULL : (analyzer->current_struct = (vala_code_node_unref (analyzer->current_struct), NULL)), _tmp23);
	_tmp25 = NULL;
	_tmp24 = NULL;
	analyzer->current_return_type = (_tmp25 = (_tmp24 = old_return_type, (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24)), (analyzer->current_return_type == NULL) ? NULL : (analyzer->current_return_type = (vala_code_node_unref (analyzer->current_return_type), NULL)), _tmp25);
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (vala_semantic_analyzer_get_current_symbol (analyzer)))) {
		ValaMethod* _tmp26;
		ValaMethod* up_method;
		ValaDataType* _tmp28;
		ValaDataType* _tmp27;
		/* lambda expressions produce nested methods */
		_tmp26 = NULL;
		up_method = (_tmp26 = VALA_METHOD (vala_symbol_get_parent_symbol (vala_semantic_analyzer_get_current_symbol (analyzer))), (_tmp26 == NULL) ? NULL : vala_code_node_ref (_tmp26));
		_tmp28 = NULL;
		_tmp27 = NULL;
		analyzer->current_return_type = (_tmp28 = (_tmp27 = vala_method_get_return_type (up_method), (_tmp27 == NULL) ? NULL : vala_code_node_ref (_tmp27)), (analyzer->current_return_type == NULL) ? NULL : (analyzer->current_return_type = (vala_code_node_unref (analyzer->current_return_type), NULL)), _tmp28);
		(up_method == NULL) ? NULL : (up_method = (vala_code_node_unref (up_method), NULL));
	}
	_tmp29 = FALSE;
	_tmp30 = FALSE;
	if (vala_method_get_is_abstract ((ValaMethod*) self)) {
		_tmp30 = TRUE;
	} else {
		_tmp30 = vala_method_get_is_virtual ((ValaMethod*) self);
	}
	if (_tmp30) {
		_tmp29 = TRUE;
	} else {
		_tmp29 = vala_method_get_overrides ((ValaMethod*) self);
	}
	if (_tmp29) {
		char* _tmp32;
		char* _tmp31;
		gboolean _tmp33;
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp32 = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abstract", _tmp31 = vala_symbol_get_full_name ((ValaSymbol*) self)));
		_tmp32 = (g_free (_tmp32), NULL);
		_tmp31 = (g_free (_tmp31), NULL);
		return (_tmp33 = FALSE, (old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL)), (old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)), (old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL)), (old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL)), (old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)), _tmp33);
	}
	return (_tmp34 = !vala_code_node_get_error ((ValaCodeNode*) self), (old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL)), (old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)), (old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL)), (old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL)), (old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)), _tmp34);
}


const char* vala_creation_method_get_class_name (ValaCreationMethod* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_class_name;
}


void vala_creation_method_set_class_name (ValaCreationMethod* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_class_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_class_name = (g_free (self->priv->_class_name), NULL), _tmp2);
}


gint vala_creation_method_get_n_construction_params (ValaCreationMethod* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_n_construction_params;
}


void vala_creation_method_set_n_construction_params (ValaCreationMethod* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_n_construction_params = value;
}


const char* vala_creation_method_get_custom_return_type_cname (ValaCreationMethod* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_custom_return_type_cname;
}


void vala_creation_method_set_custom_return_type_cname (ValaCreationMethod* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_custom_return_type_cname = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_custom_return_type_cname = (g_free (self->priv->_custom_return_type_cname), NULL), _tmp2);
}


gboolean vala_creation_method_get_chain_up (ValaCreationMethod* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_chain_up;
}


void vala_creation_method_set_chain_up (ValaCreationMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}


static void vala_creation_method_class_init (ValaCreationMethodClass * klass) {
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_creation_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_creation_method_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_creation_method_real_accept_children;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_creation_method_real_get_default_cname;
	VALA_METHOD_CLASS (klass)->get_real_cname = vala_creation_method_real_get_real_cname;
	VALA_CODE_NODE_CLASS (klass)->check = vala_creation_method_real_check;
}


static void vala_creation_method_instance_init (ValaCreationMethod * self) {
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void vala_creation_method_finalize (ValaCodeNode* obj) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (obj);
	self->priv->_class_name = (g_free (self->priv->_class_name), NULL);
	self->priv->_custom_return_type_cname = (g_free (self->priv->_custom_return_type_cname), NULL);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}


GType vala_creation_method_get_type (void) {
	static GType vala_creation_method_type_id = 0;
	if (vala_creation_method_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	}
	return vala_creation_method_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




