/* valacodenode.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacodenode.h>
#include <gee/readonlylist.h>
#include <gee/arraylist.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodelinedirective.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valaattribute.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valasourcefile.h>
#include <gobject/gvaluecollector.h>




struct _ValaCodeNodePrivate {
	ValaCodeNode* _parent_node;
	ValaSourceReference* _source_reference;
	gboolean _checked;
	gboolean _error;
	GeeList* _error_types;
	ValaCCodeNode* _ccodenode;
};

#define VALA_CODE_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_NODE, ValaCodeNodePrivate))
enum  {
	VALA_CODE_NODE_DUMMY_PROPERTY
};
static void _g_list_free_vala_code_node_unref (GList* self);
static GeeList* vala_code_node__empty_type_list = NULL;
static gint vala_code_node_last_temp_nr = 0;
static void vala_code_node_real_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_code_node_real_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor);
static gboolean vala_code_node_real_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
static void vala_code_node_real_replace_type (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
static void vala_code_node_real_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
static char* vala_code_node_real_to_string (ValaCodeNode* self);
static void vala_code_node_real_get_defined_variables (ValaCodeNode* self, GeeCollection* collection);
static void vala_code_node_real_get_used_variables (ValaCodeNode* self, GeeCollection* collection);
static gpointer vala_code_node_parent_class = NULL;
static void vala_code_node_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_vala_code_node_unref (GList* self) {
	g_list_foreach (self, (GFunc) vala_code_node_unref, NULL);
	g_list_free (self);
}


/**
 * Specifies the exceptions that can be thrown by this node or a child node
 */
GeeList* vala_code_node_get_error_types (ValaCodeNode* self) {
	GeeList* _tmp4;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_error_types != NULL) {
		GeeList* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = self->priv->_error_types, (_tmp0 == NULL) ? NULL : gee_collection_object_ref (_tmp0));
	}
	if (vala_code_node__empty_type_list == NULL) {
		GeeList* _tmp3;
		GeeArrayList* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_code_node__empty_type_list = (_tmp3 = (GeeList*) gee_read_only_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, (GeeList*) (_tmp2 = gee_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal))), (vala_code_node__empty_type_list == NULL) ? NULL : (vala_code_node__empty_type_list = (gee_collection_object_unref (vala_code_node__empty_type_list), NULL)), _tmp3);
		(_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL));
	}
	_tmp4 = NULL;
	return (_tmp4 = vala_code_node__empty_type_list, (_tmp4 == NULL) ? NULL : gee_collection_object_ref (_tmp4));
}


/**
 * Adds an error type to the exceptions that can be thrown by this node
 * or a child node 
 */
void vala_code_node_add_error_type (ValaCodeNode* self, ValaDataType* error_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	if (self->priv->_error_types == NULL) {
		GeeList* _tmp0;
		_tmp0 = NULL;
		self->priv->_error_types = (_tmp0 = (GeeList*) gee_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->priv->_error_types == NULL) ? NULL : (self->priv->_error_types = (gee_collection_object_unref (self->priv->_error_types), NULL)), _tmp0);
	}
	gee_collection_add ((GeeCollection*) self->priv->_error_types, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, self);
}


/**
 * Adds a collection of error types to the exceptions that can be thrown by this node
 * or a child node 
 */
void vala_code_node_add_error_types (ValaCodeNode* self, GeeList* error_types) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_types != NULL);
	{
		GeeIterator* _error_type_it;
		_error_type_it = gee_iterable_iterator ((GeeIterable*) error_types);
		while (gee_iterator_next (_error_type_it)) {
			ValaDataType* error_type;
			error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
			vala_code_node_add_error_type (self, error_type);
			(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
		}
		(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
	}
}


/**
 * Visits this code node with the specified CodeVisitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void vala_code_node_real_accept (ValaCodeNode* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
}


void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor) {
	VALA_CODE_NODE_GET_CLASS (self)->accept (self, visitor);
}


/**
 * Visits all children of this code node with the specified CodeVisitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void vala_code_node_real_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
}


void vala_code_node_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor) {
	VALA_CODE_NODE_GET_CLASS (self)->accept_children (self, visitor);
}


static gboolean vala_code_node_real_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (analyzer != NULL, FALSE);
	return TRUE;
}


gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer) {
	return VALA_CODE_NODE_GET_CLASS (self)->check (self, analyzer);
}


static void vala_code_node_real_replace_type (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
}


void vala_code_node_replace_type (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type) {
	VALA_CODE_NODE_GET_CLASS (self)->replace_type (self, old_type, new_type);
}


static void vala_code_node_real_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
}


void vala_code_node_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node) {
	VALA_CODE_NODE_GET_CLASS (self)->replace_expression (self, old_node, new_node);
}


/**
 * Returns the specified attribute.
 *
 * @param name attribute name
 * @return     attribute
 */
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	/* FIXME: use hash table*/
	{
		GList* a_collection;
		GList* a_it;
		a_collection = self->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp1;
			ValaAttribute* a;
			_tmp1 = NULL;
			a = (_tmp1 = (ValaAttribute*) a_it->data, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), name) == 0) {
					return a;
				}
				(a == NULL) ? NULL : (a = (vala_code_node_unref (a), NULL));
			}
		}
	}
	return NULL;
}


/**
 * Returns a string that represents this code node.
 *
 * @return a string representation
 */
static char* vala_code_node_real_to_string (ValaCodeNode* self) {
	GString* str;
	const char* _tmp1;
	char* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	str = g_string_new ("");
	g_string_append (str, "/* ");
	if (self->priv->_source_reference != NULL) {
		char* _tmp0;
		_tmp0 = NULL;
		g_string_append (g_string_append (str, "@"), _tmp0 = vala_source_reference_to_string (self->priv->_source_reference));
		_tmp0 = (g_free (_tmp0), NULL);
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = g_string_append (str, " */")->str, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), (str == NULL) ? NULL : (str = (g_string_free (str, TRUE), NULL)), _tmp2);
}


char* vala_code_node_to_string (ValaCodeNode* self) {
	return VALA_CODE_NODE_GET_CLASS (self)->to_string (self);
}


static void vala_code_node_real_get_defined_variables (ValaCodeNode* self, GeeCollection* collection) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection != NULL);
}


void vala_code_node_get_defined_variables (ValaCodeNode* self, GeeCollection* collection) {
	VALA_CODE_NODE_GET_CLASS (self)->get_defined_variables (self, collection);
}


static void vala_code_node_real_get_used_variables (ValaCodeNode* self, GeeCollection* collection) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection != NULL);
}


void vala_code_node_get_used_variables (ValaCodeNode* self, GeeCollection* collection) {
	VALA_CODE_NODE_GET_CLASS (self)->get_used_variables (self, collection);
}


char* vala_code_node_get_temp_name (ValaCodeNode* self) {
	char* _tmp0;
	char* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat (".", _tmp0 = g_strdup_printf ("%i", ((vala_code_node_last_temp_nr = vala_code_node_last_temp_nr + 1))), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


const char* vala_code_node_get_type_name (ValaCodeNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return g_type_name (G_TYPE_FROM_INSTANCE (self));
}


ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_parent_node;
}


void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value) {
	g_return_if_fail (self != NULL);
	self->priv->_parent_node = value;
}


ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_source_reference;
}


void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value) {
	ValaSourceReference* _tmp2;
	ValaSourceReference* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_source_reference = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_source_reference_ref (_tmp1)), (self->priv->_source_reference == NULL) ? NULL : (self->priv->_source_reference = (vala_source_reference_unref (self->priv->_source_reference), NULL)), _tmp2);
}


ValaCCodeNode* vala_code_node_get_ccodenode (ValaCodeNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_ccodenode;
}


void vala_code_node_set_ccodenode (ValaCodeNode* self, ValaCCodeNode* value) {
	gboolean _tmp1;
	ValaCCodeNode* _tmp5;
	ValaCCodeNode* _tmp4;
	g_return_if_fail (self != NULL);
	_tmp1 = FALSE;
	if (value != NULL) {
		_tmp1 = self->priv->_source_reference != NULL;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		ValaCCodeLineDirective* _tmp3;
		char* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_node_set_line (value, _tmp3 = vala_ccode_line_directive_new (_tmp2 = g_path_get_basename (vala_source_file_get_filename (vala_source_reference_get_file (self->priv->_source_reference))), vala_source_reference_get_first_line (self->priv->_source_reference)));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp2 = (g_free (_tmp2), NULL);
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->priv->_ccodenode = (_tmp5 = (_tmp4 = value, (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4)), (self->priv->_ccodenode == NULL) ? NULL : (self->priv->_ccodenode = (vala_ccode_node_unref (self->priv->_ccodenode), NULL)), _tmp5);
}


gboolean vala_code_node_get_checked (ValaCodeNode* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_checked;
}


void vala_code_node_set_checked (ValaCodeNode* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_checked = value;
}


gboolean vala_code_node_get_error (ValaCodeNode* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_error;
}


void vala_code_node_set_error (ValaCodeNode* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error = value;
}


gboolean vala_code_node_get_tree_can_fail (ValaCodeNode* self) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = FALSE;
	if (self->priv->_error_types != NULL) {
		_tmp0 = gee_collection_get_size ((GeeCollection*) self->priv->_error_types) > 0;
	} else {
		_tmp0 = FALSE;
	}
	return _tmp0;
}


static void vala_value_code_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_code_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_code_node_unref (value->data[0].v_pointer);
	}
}


static void vala_value_code_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_code_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_code_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCodeNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_code_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCodeNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCodeNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_code_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_code_node (GValue* value, gpointer v_object) {
	ValaCodeNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_node_unref (old);
	}
}


static void vala_code_node_class_init (ValaCodeNodeClass * klass) {
	vala_code_node_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_code_node_finalize;
	g_type_class_add_private (klass, sizeof (ValaCodeNodePrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_code_node_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_code_node_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->check = vala_code_node_real_check;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_code_node_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_code_node_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_code_node_real_to_string;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_code_node_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_code_node_real_get_used_variables;
}


static void vala_code_node_instance_init (ValaCodeNode * self) {
	self->priv = VALA_CODE_NODE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_code_node_finalize (ValaCodeNode* obj) {
	ValaCodeNode * self;
	self = VALA_CODE_NODE (obj);
	(self->priv->_source_reference == NULL) ? NULL : (self->priv->_source_reference = (vala_source_reference_unref (self->priv->_source_reference), NULL));
	(self->attributes == NULL) ? NULL : (self->attributes = (_g_list_free_vala_code_node_unref (self->attributes), NULL));
	(self->priv->_error_types == NULL) ? NULL : (self->priv->_error_types = (gee_collection_object_unref (self->priv->_error_types), NULL));
	(self->priv->_ccodenode == NULL) ? NULL : (self->priv->_ccodenode = (vala_ccode_node_unref (self->priv->_ccodenode), NULL));
}


GType vala_code_node_get_type (void) {
	static GType vala_code_node_type_id = 0;
	if (vala_code_node_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_node_init, vala_value_code_node_free_value, vala_value_code_node_copy_value, vala_value_code_node_peek_pointer, "p", vala_value_code_node_collect_value, "p", vala_value_code_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeNode), 0, (GInstanceInitFunc) vala_code_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_code_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeNode", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_code_node_type_id;
}


gpointer vala_code_node_ref (gpointer instance) {
	ValaCodeNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_code_node_unref (gpointer instance) {
	ValaCodeNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




