/* valaccodeexpressionstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeexpressionstatement.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodeparenthesizedexpression.h>




struct _ValaCCodeExpressionStatementPrivate {
	ValaCCodeExpression* _expression;
};

#define VALA_CCODE_EXPRESSION_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_EXPRESSION_STATEMENT, ValaCCodeExpressionStatementPrivate))
enum  {
	VALA_CCODE_EXPRESSION_STATEMENT_DUMMY_PROPERTY
};
static void vala_ccode_expression_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_expression_statement_write_expression (ValaCCodeExpressionStatement* self, ValaCCodeWriter* writer, ValaCCodeExpression* expr);
static gpointer vala_ccode_expression_statement_parent_class = NULL;
static void vala_ccode_expression_statement_finalize (ValaCCodeNode* obj);



ValaCCodeExpressionStatement* vala_ccode_expression_statement_construct (GType object_type, ValaCCodeExpression* expr) {
	ValaCCodeExpressionStatement* self;
	g_return_val_if_fail (expr != NULL, NULL);
	self = (ValaCCodeExpressionStatement*) g_type_create_instance (object_type);
	vala_ccode_expression_statement_set_expression (self, expr);
	return self;
}


ValaCCodeExpressionStatement* vala_ccode_expression_statement_new (ValaCCodeExpression* expr) {
	return vala_ccode_expression_statement_construct (VALA_TYPE_CCODE_EXPRESSION_STATEMENT, expr);
}


static void vala_ccode_expression_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeExpressionStatement * self;
	self = (ValaCCodeExpressionStatement*) base;
	g_return_if_fail (writer != NULL);
	if (VALA_IS_CCODE_COMMA_EXPRESSION (self->priv->_expression)) {
		ValaCCodeCommaExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		ValaCCodeCommaExpression* ccomma;
		/* expand comma expression into multiple statements
		 to improve code readability*/
		_tmp1 = NULL;
		_tmp0 = NULL;
		ccomma = (_tmp1 = (_tmp0 = self->priv->_expression, VALA_IS_CCODE_COMMA_EXPRESSION (_tmp0) ? ((ValaCCodeCommaExpression*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
		{
			GeeList* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* _expr_it;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_expr_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_ccode_comma_expression_get_inner (ccomma))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
			while (gee_iterator_next (_expr_it)) {
				ValaCCodeExpression* expr;
				expr = (ValaCCodeExpression*) gee_iterator_get (_expr_it);
				vala_ccode_expression_statement_write_expression (self, writer, expr);
				(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
			}
			(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
		}
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	} else {
		if (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (self->priv->_expression)) {
			ValaCCodeParenthesizedExpression* _tmp5;
			ValaCCodeExpression* _tmp4;
			ValaCCodeParenthesizedExpression* cpar;
			_tmp5 = NULL;
			_tmp4 = NULL;
			cpar = (_tmp5 = (_tmp4 = self->priv->_expression, VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp4) ? ((ValaCCodeParenthesizedExpression*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_ccode_node_ref (_tmp5));
			vala_ccode_expression_statement_write_expression (self, writer, vala_ccode_parenthesized_expression_get_inner (cpar));
			(cpar == NULL) ? NULL : (cpar = (vala_ccode_node_unref (cpar), NULL));
		} else {
			vala_ccode_expression_statement_write_expression (self, writer, self->priv->_expression);
		}
	}
}


static void vala_ccode_expression_statement_write_expression (ValaCCodeExpressionStatement* self, ValaCCodeWriter* writer, ValaCCodeExpression* expr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line ((ValaCCodeNode*) self));
	if (expr != NULL) {
		vala_ccode_node_write ((ValaCCodeNode*) expr, writer);
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


ValaCCodeExpression* vala_ccode_expression_statement_get_expression (ValaCCodeExpressionStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_expression;
}


void vala_ccode_expression_statement_set_expression (ValaCCodeExpressionStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_expression == NULL) ? NULL : (self->priv->_expression = (vala_ccode_node_unref (self->priv->_expression), NULL)), _tmp2);
}


static void vala_ccode_expression_statement_class_init (ValaCCodeExpressionStatementClass * klass) {
	vala_ccode_expression_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_expression_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeExpressionStatementPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_expression_statement_real_write;
}


static void vala_ccode_expression_statement_instance_init (ValaCCodeExpressionStatement * self) {
	self->priv = VALA_CCODE_EXPRESSION_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_expression_statement_finalize (ValaCCodeNode* obj) {
	ValaCCodeExpressionStatement * self;
	self = VALA_CCODE_EXPRESSION_STATEMENT (obj);
	(self->priv->_expression == NULL) ? NULL : (self->priv->_expression = (vala_ccode_node_unref (self->priv->_expression), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_expression_statement_parent_class)->finalize (obj);
}


GType vala_ccode_expression_statement_get_type (void) {
	static GType vala_ccode_expression_statement_type_id = 0;
	if (vala_ccode_expression_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeExpressionStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_expression_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeExpressionStatement), 0, (GInstanceInitFunc) vala_ccode_expression_statement_instance_init, NULL };
		vala_ccode_expression_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeExpressionStatement", &g_define_type_info, 0);
	}
	return vala_ccode_expression_statement_type_id;
}




