/* vala.vapi generated by valac, do not modify. */

[CCode (cprefix = "Vala", lower_case_cprefix = "vala_")]
namespace Vala {
	[CCode (cprefix = "ValaGenie", lower_case_cprefix = "vala_genie_")]
	namespace Genie {
		[CCode (cheader_filename = "vala/valagenieparser.h")]
		public class Parser : Vala.CodeVisitor {
			public Parser ();
			public void parse (Vala.CodeContext context);
			public void parse_file (Vala.SourceFile source_file);
		}
		[CCode (ref_function = "vala_genie_scanner_ref", unref_function = "vala_genie_scanner_unref", param_spec_function = "vala_genie_param_spec_scanner", cheader_filename = "vala/valageniescanner.h")]
		public class Scanner {
			public Scanner (Vala.SourceFile source_file);
			public string? pop_comment ();
			public Vala.Genie.TokenType read_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
			public int indent_spaces { get; set; }
			public Vala.SourceFile source_file { get; set; }
		}
		[CCode (cprefix = "VALA_GENIE_TOKEN_TYPE_", cheader_filename = "vala/valagenietokentype.h")]
		public enum TokenType {
			NONE,
			ABSTRACT,
			ARRAY,
			AS,
			ASSERT,
			ASSIGN,
			ASSIGN_ADD,
			ASSIGN_BITWISE_AND,
			ASSIGN_BITWISE_OR,
			ASSIGN_BITWISE_XOR,
			ASSIGN_DIV,
			ASSIGN_MUL,
			ASSIGN_PERCENT,
			ASSIGN_SHIFT_LEFT,
			ASSIGN_SUB,
			BITWISE_AND,
			BITWISE_OR,
			BREAK,
			CARRET,
			CASE,
			CHARACTER_LITERAL,
			CLASS,
			CLOSE_BRACE,
			CLOSE_BRACKET,
			CLOSE_PARENS,
			COLON,
			COMMA,
			CONST,
			CONSTRUCT,
			CONTINUE,
			DEDENT,
			DEF,
			DEFAULT,
			DELEGATE,
			DELETE,
			DICT,
			DIV,
			DO,
			DOT,
			DOWNTO,
			DYNAMIC,
			ELLIPSIS,
			ELSE,
			ENUM,
			ENSURES,
			ERRORDOMAIN,
			EOF,
			EOL,
			EVENT,
			EXCEPT,
			EXTERN,
			FALSE,
			FINAL,
			FINALLY,
			FOR,
			FOREACH,
			GET,
			HASH,
			IDENTIFIER,
			IF,
			IMPLEMENTS,
			IN,
			INDENT,
			INIT,
			INLINE,
			INTEGER_LITERAL,
			INTERFACE,
			INTERR,
			IS,
			ISA,
			LAMBDA,
			LIST,
			LOCK,
			MINUS,
			NAMESPACE,
			NEW,
			NULL,
			OF,
			OUT,
			OP_AND,
			OP_DEC,
			OP_EQ,
			OP_GE,
			OP_GT,
			OP_INC,
			OP_LE,
			OP_LT,
			OP_NE,
			OP_NEG,
			OP_OR,
			OP_PTR,
			OP_SHIFT_LEFT,
			OPEN_BRACE,
			OPEN_BRACKET,
			OPEN_PARENS,
			OVERRIDE,
			PASS,
			PERCENT,
			PLUS,
			PRINT,
			PRIVATE,
			PROP,
			PROTECTED,
			PUBLIC,
			RAISE,
			RAISES,
			REAL_LITERAL,
			READONLY,
			REF,
			REQUIRES,
			RETURN,
			SEMICOLON,
			SET,
			SIZEOF,
			STAR,
			STATIC,
			STRING_LITERAL,
			STRUCT,
			SUPER,
			THIS,
			TILDE,
			TO,
			TRUE,
			TRY,
			TYPEOF,
			USES,
			VAR,
			VIRTUAL,
			VOID,
			VOLATILE,
			WEAK,
			WHEN,
			WHILE,
			WRITEONLY;
			public unowned string to_string ();
		}
	}
	[CCode (cprefix = "ValaReport", lower_case_cprefix = "vala_report_")]
	namespace Report {
		[CCode (cheader_filename = "vala/valareport.h")]
		public static int errors;
		[CCode (cheader_filename = "vala/valareport.h")]
		public static bool verbose_errors;
		[CCode (cheader_filename = "vala/valareport.h")]
		public static int warnings;
		[CCode (cheader_filename = "vala/valareport.h")]
		public static void error (Vala.SourceReference? source, string message);
		[CCode (cheader_filename = "vala/valareport.h")]
		public static int get_errors ();
		[CCode (cheader_filename = "vala/valareport.h")]
		public static int get_warnings ();
		[CCode (cheader_filename = "vala/valareport.h")]
		public static void report_source (Vala.SourceReference source);
		[CCode (cheader_filename = "vala/valareport.h")]
		public static void set_verbose_errors (bool verbose);
		[CCode (cheader_filename = "vala/valareport.h")]
		public static void warning (Vala.SourceReference? source, string message);
	}
	[CCode (cheader_filename = "vala/valaaddressofexpression.h")]
	public class AddressofExpression : Vala.Expression {
		public AddressofExpression (Vala.Expression inner, Vala.SourceReference? source_reference = null);
		public Vala.Expression inner { get; set; }
	}
	[CCode (cheader_filename = "vala/valaarraycreationexpression.h")]
	public class ArrayCreationExpression : Vala.Expression {
		public void append_size (Vala.Expression size);
		public Gee.List<Vala.Expression> get_sizes ();
		public ArrayCreationExpression (Vala.DataType element_type, int rank, Vala.InitializerList? initializer_list, Vala.SourceReference source_reference);
		public Vala.DataType element_type { get; set; }
		public Vala.InitializerList? initializer_list { get; set; }
		public int rank { get; set; }
	}
	[CCode (cheader_filename = "vala/valaarraylengthfield.h")]
	public class ArrayLengthField : Vala.Field {
		public ArrayLengthField (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaarraymovemethod.h")]
	public class ArrayMoveMethod : Vala.Method {
		public ArrayMoveMethod (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaarrayresizemethod.h")]
	public class ArrayResizeMethod : Vala.Method {
		public ArrayResizeMethod (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaarraytype.h")]
	public class ArrayType : Vala.ReferenceType {
		public ArrayType (Vala.DataType element_type, int rank, Vala.SourceReference? source_reference);
		public Vala.DataType element_type { get; set; }
		public int rank { get; set; }
	}
	[CCode (cheader_filename = "vala/valaassignment.h")]
	public class Assignment : Vala.Expression {
		public Assignment (Vala.Expression left, Vala.Expression right, Vala.AssignmentOperator operator = AssignmentOperator.SIMPLE, Vala.SourceReference? source_reference = null);
		public Vala.Expression left { get; set; }
		public Vala.AssignmentOperator operator { get; set; }
		public Vala.Expression right { get; set; }
	}
	[CCode (cheader_filename = "vala/valaattribute.h")]
	public class Attribute : Vala.CodeNode {
		public Gee.Map<string,Vala.Expression> args;
		public void add_argument (string key, Vala.Expression value);
		public bool get_bool (string name);
		public double get_double (string name);
		public int get_integer (string name);
		public string? get_string (string name);
		public bool has_argument (string name);
		public Attribute (string name, Vala.SourceReference? source_reference = null);
		public string name { get; set; }
	}
	[CCode (cheader_filename = "vala/valabaseaccess.h")]
	public class BaseAccess : Vala.Expression {
		public BaseAccess (Vala.SourceReference? source = null);
	}
	[CCode (ref_function = "vala_basic_block_ref", unref_function = "vala_basic_block_unref", param_spec_function = "vala_param_spec_basic_block", cheader_filename = "vala/valabasicblock.h")]
	public class BasicBlock {
		public void add_child (Vala.BasicBlock block);
		public void add_dominator_frontier (Vala.BasicBlock block);
		public void add_node (Vala.CodeNode node);
		public void add_phi_function (Vala.PhiFunction phi);
		public void connect (Vala.BasicBlock target);
		public BasicBlock.entry ();
		public BasicBlock.exit ();
		public Gee.List<Vala.BasicBlock> get_children ();
		public Gee.Set<Vala.BasicBlock> get_dominator_frontier ();
		public Gee.List<Vala.CodeNode> get_nodes ();
		public Gee.Set<Vala.PhiFunction> get_phi_functions ();
		public Gee.List<weak Vala.BasicBlock> get_predecessors ();
		public Gee.List<weak Vala.BasicBlock> get_successors ();
		public BasicBlock ();
		public Vala.BasicBlock parent { get; set; }
	}
	[CCode (cheader_filename = "vala/valabinaryexpression.h")]
	public class BinaryExpression : Vala.Expression {
		public BinaryExpression (Vala.BinaryOperator op, Vala.Expression _left, Vala.Expression _right, Vala.SourceReference? source = null);
		public Vala.Expression left { get; set; }
		public Vala.BinaryOperator operator { get; set; }
		public Vala.Expression right { get; set; }
	}
	[CCode (cheader_filename = "vala/valablock.h")]
	public class Block : Vala.Symbol, Vala.Statement {
		public void add_local_variable (Vala.LocalVariable local);
		public void add_statement (Vala.Statement stmt);
		public Gee.List<Vala.LocalVariable> get_local_variables ();
		public Gee.List<Vala.Statement> get_statements ();
		public void insert_before (Vala.Statement stmt, Vala.Statement new_stmt);
		public void insert_statement (int index, Vala.Statement stmt);
		public Block (Vala.SourceReference source_reference);
		public void remove_local_variable (Vala.LocalVariable local);
		public void replace_statement (Vala.Statement old_stmt, Vala.Statement new_stmt);
		public bool contains_jump_statement { get; set; }
	}
	[CCode (cheader_filename = "vala/valabooleanliteral.h")]
	public class BooleanLiteral : Vala.Literal {
		public BooleanLiteral (bool b, Vala.SourceReference source);
		public bool value { get; set; }
	}
	[CCode (cheader_filename = "vala/valabooleantype.h")]
	public class BooleanType : Vala.ValueType {
		public BooleanType (Vala.Struct type_symbol);
	}
	[CCode (cheader_filename = "vala/valabreakstatement.h")]
	public class BreakStatement : Vala.CodeNode, Vala.Statement {
		public BreakStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valacastexpression.h")]
	public class CastExpression : Vala.Expression {
		public CastExpression (Vala.Expression inner, Vala.DataType type_reference, Vala.SourceReference source_reference, bool is_silent_cast);
		public Vala.Expression inner { get; set; }
		public bool is_silent_cast { get; set; }
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valacatchclause.h")]
	public class CatchClause : Vala.CodeNode {
		public CatchClause (Vala.DataType? error_type, string? variable_name, Vala.Block body, Vala.SourceReference? source_reference = null);
		public Vala.Block body { get; set; }
		public string? clabel_name { get; set; }
		public Vala.DataType? error_type { get; set; }
		public Vala.LocalVariable error_variable { get; set; }
		public string? variable_name { get; set; }
	}
	[CCode (cheader_filename = "vala/valacharacterliteral.h")]
	public class CharacterLiteral : Vala.Literal {
		public unichar get_char ();
		public CharacterLiteral (string c, Vala.SourceReference source);
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valaclass.h")]
	public class Class : Vala.ObjectTypeSymbol {
		public void add_base_type (Vala.DataType type);
		public void add_class (Vala.Class cl);
		public void add_constant (Vala.Constant c);
		public void add_delegate (Vala.Delegate d);
		public void add_enum (Vala.Enum en);
		public void add_field (Vala.Field f);
		public void add_method (Vala.Method m);
		public void add_property (Vala.Property prop);
		public void add_signal (Vala.Signal sig);
		public void add_struct (Vala.Struct st);
		public Gee.List<Vala.DataType> get_base_types ();
		public Gee.List<Vala.Class> get_classes ();
		public Gee.List<Vala.Constant> get_constants ();
		public string get_default_cname ();
		public string get_default_free_function ();
		public Gee.List<Vala.Delegate> get_delegates ();
		public Gee.List<Vala.Enum> get_enums ();
		public Gee.List<Vala.Field> get_fields ();
		public Gee.List<Vala.Struct> get_structs ();
		public bool is_fundamental ();
		public Class (string name, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_cname (string cname);
		public void set_dup_function (string? name);
		public void set_free_function (string name);
		public void set_param_spec_function (string name);
		public void set_ref_function (string? name);
		public void set_type_id (string type_id);
		public void set_unref_function (string? name);
		public Vala.Class base_class { get; set; }
		public Vala.Constructor class_constructor { get; set; }
		public Vala.Destructor? class_destructor { get; set; }
		public Vala.Constructor constructor { get; set; }
		public Vala.Method default_construction_method { get; set; }
		public Vala.Destructor? destructor { get; set; }
		public bool has_class_private_fields { get; set; }
		public bool has_private_fields { get; set; }
		public bool is_abstract { get; set; }
		public bool is_compact { get; set; }
		public bool is_error_base { get; }
		public bool is_immutable { get; set; }
		public bool ref_function_void { get; set; }
		public Vala.Constructor static_constructor { get; set; }
		public Vala.Destructor? static_destructor { get; set; }
		public string? type_check_function { get; set; }
	}
	[CCode (cheader_filename = "vala/valaclasstype.h")]
	public class ClassType : Vala.ReferenceType {
		public ClassType (Vala.Class class_symbol);
		public Vala.Class class_symbol { get; set; }
	}
	[CCode (ref_function = "vala_code_context_ref", unref_function = "vala_code_context_unref", param_spec_function = "vala_param_spec_code_context", cheader_filename = "vala/valacodecontext.h")]
	public class CodeContext {
		public void accept (Vala.CodeVisitor visitor);
		public void add_c_source_file (string file);
		public void add_package (string pkg);
		public void add_source_file (Vala.SourceFile file);
		public void find_header_cycles ();
		public Gee.List<string> get_c_source_files ();
		public string? get_package_path (string pkg, string[] vapi_directories);
		public Gee.List<string> get_packages ();
		public Gee.List<Vala.SourceFile> get_source_files ();
		public bool has_package (string pkg);
		public CodeContext ();
		public bool require_glib_version (int major, int minor);
		public bool assert { get; set; }
		public string basedir { get; set; }
		public bool ccode_only { get; set; }
		public bool checking { get; set; }
		public Vala.CodeGenerator codegen { get; set; }
		public bool compile_only { get; set; }
		public bool dbus_transformation { get; set; }
		public bool debug { get; set; }
		public string directory { get; set; }
		public string library { get; set; }
		public bool memory_management { get; set; }
		public Vala.Method module_init_method { get; set; }
		public bool non_null { get; set; }
		public bool non_null_experimental { get; set; }
		public int optlevel { get; set; }
		public string output { get; set; }
		public Vala.Namespace root { get; }
		public bool save_cheaders { get; }
		public bool save_csources { get; }
		public bool save_temps { get; set; }
		public int target_glib_major { get; set; }
		public int target_glib_minor { get; set; }
		public bool thread { get; set; }
	}
	[CCode (cheader_filename = "vala/valacodegenerator.h")]
	public class CodeGenerator : Vala.CodeVisitor {
		public virtual void emit (Vala.CodeContext context);
		public CodeGenerator ();
	}
	[CCode (ref_function = "vala_code_node_ref", unref_function = "vala_code_node_unref", param_spec_function = "vala_param_spec_code_node", cheader_filename = "vala/valacodenode.h")]
	public abstract class CodeNode {
		public GLib.List<Vala.Attribute> attributes;
		public virtual void accept (Vala.CodeVisitor visitor);
		public virtual void accept_children (Vala.CodeVisitor visitor);
		public void add_error_type (Vala.DataType error_type);
		public void add_error_types (Gee.List<Vala.DataType> error_types);
		public virtual bool check (Vala.SemanticAnalyzer analyzer);
		public Vala.Attribute? get_attribute (string name);
		public virtual void get_defined_variables (Gee.Collection<Vala.LocalVariable> collection);
		public Gee.List<Vala.DataType> get_error_types ();
		public string get_temp_name ();
		public virtual void get_used_variables (Gee.Collection<Vala.LocalVariable> collection);
		public virtual void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public virtual void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public virtual string to_string ();
		public Vala.CCodeNode? ccodenode { get; set; }
		public bool checked { get; set; }
		public bool error { get; set; }
		public Vala.CodeNode? parent_node { get; set; }
		public Vala.SourceReference? source_reference { get; set; }
		public bool tree_can_fail { get; }
	}
	[CCode (ref_function = "vala_code_visitor_ref", unref_function = "vala_code_visitor_unref", param_spec_function = "vala_param_spec_code_visitor", cheader_filename = "vala/valacodevisitor.h")]
	public abstract class CodeVisitor {
		public virtual void visit_addressof_expression (Vala.AddressofExpression expr);
		public virtual void visit_array_creation_expression (Vala.ArrayCreationExpression expr);
		public virtual void visit_assignment (Vala.Assignment a);
		public virtual void visit_base_access (Vala.BaseAccess expr);
		public virtual void visit_binary_expression (Vala.BinaryExpression expr);
		public virtual void visit_block (Vala.Block b);
		public virtual void visit_boolean_literal (Vala.BooleanLiteral lit);
		public virtual void visit_break_statement (Vala.BreakStatement stmt);
		public virtual void visit_cast_expression (Vala.CastExpression expr);
		public virtual void visit_catch_clause (Vala.CatchClause clause);
		public virtual void visit_character_literal (Vala.CharacterLiteral lit);
		public virtual void visit_class (Vala.Class cl);
		public virtual void visit_conditional_expression (Vala.ConditionalExpression expr);
		public virtual void visit_constant (Vala.Constant c);
		public virtual void visit_constructor (Vala.Constructor c);
		public virtual void visit_continue_statement (Vala.ContinueStatement stmt);
		public virtual void visit_creation_method (Vala.CreationMethod m);
		public virtual void visit_data_type (Vala.DataType type);
		public virtual void visit_declaration_statement (Vala.DeclarationStatement stmt);
		public virtual void visit_delegate (Vala.Delegate d);
		public virtual void visit_delete_statement (Vala.DeleteStatement stmt);
		public virtual void visit_destructor (Vala.Destructor d);
		public virtual void visit_do_statement (Vala.DoStatement stmt);
		public virtual void visit_element_access (Vala.ElementAccess expr);
		public virtual void visit_empty_statement (Vala.EmptyStatement stmt);
		public virtual void visit_end_full_expression (Vala.Expression expr);
		public virtual void visit_enum (Vala.Enum en);
		public virtual void visit_enum_value (Vala.EnumValue ev);
		public virtual void visit_error_code (Vala.ErrorCode ecode);
		public virtual void visit_error_domain (Vala.ErrorDomain edomain);
		public virtual void visit_expression (Vala.Expression expr);
		public virtual void visit_expression_statement (Vala.ExpressionStatement stmt);
		public virtual void visit_field (Vala.Field f);
		public virtual void visit_for_statement (Vala.ForStatement stmt);
		public virtual void visit_foreach_statement (Vala.ForeachStatement stmt);
		public virtual void visit_formal_parameter (Vala.FormalParameter p);
		public virtual void visit_if_statement (Vala.IfStatement stmt);
		public virtual void visit_initializer_list (Vala.InitializerList list);
		public virtual void visit_integer_literal (Vala.IntegerLiteral lit);
		public virtual void visit_interface (Vala.Interface iface);
		public virtual void visit_lambda_expression (Vala.LambdaExpression expr);
		public virtual void visit_local_variable (Vala.LocalVariable local);
		public virtual void visit_lock_statement (Vala.LockStatement stmt);
		public virtual void visit_member (Vala.Member m);
		public virtual void visit_member_access (Vala.MemberAccess expr);
		public virtual void visit_method (Vala.Method m);
		public virtual void visit_method_call (Vala.MethodCall expr);
		public virtual void visit_namespace (Vala.Namespace ns);
		public virtual void visit_null_literal (Vala.NullLiteral lit);
		public virtual void visit_object_creation_expression (Vala.ObjectCreationExpression expr);
		public virtual void visit_parenthesized_expression (Vala.ParenthesizedExpression expr);
		public virtual void visit_pointer_indirection (Vala.PointerIndirection expr);
		public virtual void visit_postfix_expression (Vala.PostfixExpression expr);
		public virtual void visit_property (Vala.Property prop);
		public virtual void visit_property_accessor (Vala.PropertyAccessor acc);
		public virtual void visit_real_literal (Vala.RealLiteral lit);
		public virtual void visit_reference_transfer_expression (Vala.ReferenceTransferExpression expr);
		public virtual void visit_return_statement (Vala.ReturnStatement stmt);
		public virtual void visit_signal (Vala.Signal sig);
		public virtual void visit_sizeof_expression (Vala.SizeofExpression expr);
		public virtual void visit_source_file (Vala.SourceFile source_file);
		public virtual void visit_string_literal (Vala.StringLiteral lit);
		public virtual void visit_struct (Vala.Struct st);
		public virtual void visit_switch_label (Vala.SwitchLabel label);
		public virtual void visit_switch_section (Vala.SwitchSection section);
		public virtual void visit_switch_statement (Vala.SwitchStatement stmt);
		public virtual void visit_throw_statement (Vala.ThrowStatement stmt);
		public virtual void visit_try_statement (Vala.TryStatement stmt);
		public virtual void visit_type_check (Vala.TypeCheck expr);
		public virtual void visit_type_parameter (Vala.TypeParameter p);
		public virtual void visit_typeof_expression (Vala.TypeofExpression expr);
		public virtual void visit_unary_expression (Vala.UnaryExpression expr);
		public virtual void visit_using_directive (Vala.UsingDirective ns);
		public virtual void visit_while_statement (Vala.WhileStatement stmt);
		public virtual void visit_yield_statement (Vala.YieldStatement y);
	}
	[CCode (cheader_filename = "vala/valacodewriter.h")]
	public class CodeWriter : Vala.CodeVisitor {
		public CodeWriter (bool dump_tree = false);
		public void write_file (Vala.CodeContext context, string filename);
	}
	[CCode (cheader_filename = "vala/valaconditionalexpression.h")]
	public class ConditionalExpression : Vala.Expression {
		public ConditionalExpression (Vala.Expression cond, Vala.Expression true_expr, Vala.Expression false_expr, Vala.SourceReference source);
		public Vala.Expression condition { get; set; }
		public Vala.Expression false_expression { get; set; }
		public Vala.Expression true_expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valaconstant.h")]
	public class Constant : Vala.Member, Vala.Lockable {
		public string get_cname ();
		public string get_default_cname ();
		public Constant (string name, Vala.DataType type_reference, Vala.Expression? initializer, Vala.SourceReference? source_reference);
		public void process_attributes ();
		public Vala.Expression? initializer { get; set; }
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valaconstructor.h")]
	public class Constructor : Vala.Symbol {
		public Constructor (Vala.SourceReference source);
		public MemberBinding binding { get; set; }
		public Vala.Block body { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala/valacontinuestatement.h")]
	public class ContinueStatement : Vala.CodeNode, Vala.Statement {
		public ContinueStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valacreationmethod.h")]
	public class CreationMethod : Vala.Method {
		public CreationMethod (string? type_name, string? name, Vala.SourceReference? source_reference = null);
		public bool chain_up { get; set; }
		public string? custom_return_type_cname { get; set; }
		public int n_construction_params { get; set; }
		public string type_name { get; set; }
	}
	[CCode (cheader_filename = "vala/valadatatype.h")]
	public abstract class DataType : Vala.CodeNode {
		public void add_type_argument (Vala.DataType arg);
		public virtual bool compatible (Vala.DataType target_type);
		public abstract Vala.DataType copy ();
		public virtual bool equals (Vala.DataType type2);
		public Vala.DataType get_actual_type (Vala.DataType? derived_instance_type, Vala.CodeNode node_reference);
		public virtual string? get_cname ();
		public string get_const_cname ();
		public virtual string? get_lower_case_cname (string? infix = null);
		public virtual Vala.Symbol? get_member (string member_name);
		public virtual Gee.List<Vala.FormalParameter>? get_parameters ();
		public virtual Vala.Symbol? get_pointer_member (string member_name);
		public virtual Vala.DataType? get_return_type ();
		public virtual Gee.List<Vala.Symbol> get_symbols ();
		public Gee.List<Vala.DataType> get_type_arguments ();
		public virtual string? get_type_id ();
		public virtual string? get_type_signature ();
		public virtual bool is_array ();
		public virtual bool is_disposable ();
		public virtual bool is_invokable ();
		public virtual bool is_real_struct_type ();
		public virtual bool is_reference_type_or_type_parameter ();
		public void remove_all_type_arguments ();
		public virtual bool stricter (Vala.DataType type2);
		public virtual string to_qualified_string (Vala.Scope? scope = null);
		public Vala.TypeSymbol data_type { get; set; }
		public bool floating_reference { get; set; }
		public bool is_dynamic { get; set; }
		public bool nullable { get; set; }
		public Vala.TypeParameter type_parameter { get; set; }
		public bool value_owned { get; set; }
	}
	[CCode (cheader_filename = "vala/valadeclarationstatement.h")]
	public class DeclarationStatement : Vala.CodeNode, Vala.Statement {
		public DeclarationStatement (Vala.Symbol declaration, Vala.SourceReference? source_reference);
		public Vala.Symbol declaration { get; set; }
	}
	[CCode (cheader_filename = "vala/valadelegate.h")]
	public class Delegate : Vala.TypeSymbol {
		public void add_parameter (Vala.FormalParameter param);
		public void add_type_parameter (Vala.TypeParameter p);
		public Gee.List<Vala.FormalParameter> get_parameters ();
		public string get_prototype_string (string name);
		public bool matches_method (Vala.Method m);
		public Delegate (string? name, Vala.DataType return_type, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_cname (string cname);
		public bool array_null_terminated { get; set; }
		public double carray_length_parameter_position { get; set; }
		public double cdelegate_target_parameter_position { get; set; }
		public double cinstance_parameter_position { get; set; }
		public bool has_target { get; set; }
		public bool no_array_length { get; set; }
		public Vala.DataType return_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valadelegatetype.h")]
	public class DelegateType : Vala.DataType {
		public DelegateType (Vala.Delegate delegate_symbol);
		public Vala.Delegate delegate_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valadeletestatement.h")]
	public class DeleteStatement : Vala.CodeNode, Vala.Statement {
		public DeleteStatement (Vala.Expression expression, Vala.SourceReference? source_reference = null);
		public Vala.Expression expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valadestructor.h")]
	public class Destructor : Vala.Symbol {
		public Destructor (Vala.SourceReference? source_reference = null);
		public MemberBinding binding { get; set; }
		public Vala.Block body { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala/valadostatement.h")]
	public class DoStatement : Vala.CodeNode, Vala.Statement {
		public DoStatement (Vala.Block body, Vala.Expression condition, Vala.SourceReference? source_reference = null);
		public Vala.Block prepare_condition_split (Vala.SemanticAnalyzer analyzer);
		public Vala.Block body { get; set; }
		public Vala.Expression condition { get; set; }
	}
	[CCode (cheader_filename = "vala/valadynamicmethod.h")]
	public class DynamicMethod : Vala.Method {
		public DynamicMethod (Vala.DataType dynamic_type, string name, Vala.DataType return_type, Vala.SourceReference? source_reference = null);
		public Vala.DataType dynamic_type { get; set; }
		public Vala.MethodCall invocation { get; set; }
	}
	[CCode (cheader_filename = "vala/valadynamicproperty.h")]
	public class DynamicProperty : Vala.Property {
		public DynamicProperty (Vala.DataType dynamic_type, string name, Vala.SourceReference? source_reference = null);
		public Vala.DataType dynamic_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valadynamicsignal.h")]
	public class DynamicSignal : Vala.Signal {
		public DynamicSignal (Vala.DataType dynamic_type, string name, Vala.DataType return_type, Vala.SourceReference? source_reference = null);
		public Vala.DataType dynamic_type { get; set; }
		public Vala.Expression handler { get; set; }
	}
	[CCode (cheader_filename = "vala/valaelementaccess.h")]
	public class ElementAccess : Vala.Expression {
		public void append_index (Vala.Expression index);
		public Gee.List<Vala.Expression> get_indices ();
		public ElementAccess (Vala.Expression container, Vala.SourceReference source_reference);
		public Vala.Expression container { get; set; }
	}
	[CCode (cheader_filename = "vala/valaemptystatement.h")]
	public class EmptyStatement : Vala.CodeNode, Vala.Statement {
		public EmptyStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valaenum.h")]
	public class Enum : Vala.TypeSymbol {
		public void add_method (Vala.Method m);
		public void add_value (Vala.EnumValue value);
		public string get_cprefix ();
		public Gee.List<Vala.Method> get_methods ();
		public Gee.List<Vala.EnumValue> get_values ();
		public Enum (string name, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_cprefix (string? cprefix);
		public void set_type_id (string? type_id);
		public bool has_type_id { get; set; }
		public bool is_flags { get; set; }
	}
	[CCode (cheader_filename = "vala/valaenumvalue.h")]
	public class EnumValue : Vala.Symbol {
		public Vala.CCodeConstant get_canonical_cconstant ();
		public string get_cname ();
		public string get_default_cname ();
		public EnumValue (string name, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_cname (string cname);
		public EnumValue.with_value (string name, Vala.Expression value, Vala.SourceReference? source_reference = null);
		public Vala.Expression value { get; set; }
	}
	[CCode (cheader_filename = "vala/valaenumvaluetype.h")]
	public class EnumValueType : Vala.ValueType {
		public EnumValueType (Vala.Enum type_symbol);
	}
	[CCode (cheader_filename = "vala/valaerrorcode.h")]
	public class ErrorCode : Vala.TypeSymbol {
		public ErrorCode (string name, Vala.SourceReference? source_reference = null);
		public ErrorCode.with_value (string name, Vala.Expression value, Vala.SourceReference? source_reference = null);
		public Vala.Expression value { get; set; }
	}
	[CCode (cheader_filename = "vala/valaerrordomain.h")]
	public class ErrorDomain : Vala.TypeSymbol {
		public void add_code (Vala.ErrorCode ecode);
		public void add_method (Vala.Method m);
		public Gee.List<Vala.ErrorCode> get_codes ();
		public string get_cprefix ();
		public Gee.List<Vala.Method> get_methods ();
		public ErrorDomain (string name, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_cprefix (string cprefix);
	}
	[CCode (cheader_filename = "vala/valaerrortype.h")]
	public class ErrorType : Vala.ReferenceType {
		public ErrorType (Vala.ErrorDomain? error_domain, Vala.ErrorCode? error_code, Vala.SourceReference? source_reference = null);
		public Vala.ErrorCode? error_code { get; set; }
		public Vala.ErrorDomain? error_domain { get; set; }
	}
	[CCode (cheader_filename = "vala/valaexpression.h")]
	public abstract class Expression : Vala.CodeNode {
		public Gee.ArrayList<Vala.LocalVariable> temp_vars;
		public void insert_statement (Vala.Block block, Vala.Statement stmt);
		public virtual bool is_constant ();
		public virtual bool is_non_null ();
		public abstract bool is_pure ();
		public Vala.Block prepare_condition_split (Vala.SemanticAnalyzer analyzer);
		public Vala.DataType? formal_target_type { get; set; }
		public Vala.DataType? formal_value_type { get; set; }
		public bool lvalue { get; set; }
		public Vala.Statement? parent_statement { get; }
		public Vala.Symbol symbol_reference { get; set; }
		public Vala.DataType target_type { get; set; }
		public Vala.DataType value_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valaexpressionstatement.h")]
	public class ExpressionStatement : Vala.CodeNode, Vala.Statement {
		public Vala.Property? assigned_property ();
		public ExpressionStatement (Vala.Expression expression, Vala.SourceReference? source_reference = null);
		public Vala.Expression expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valafield.h")]
	public class Field : Vala.Member, Vala.Lockable {
		public string? get_array_length_cname ();
		public string get_cname ();
		public string? get_ctype ();
		public string get_default_cname ();
		public Field (string name, Vala.DataType field_type, Vala.Expression? initializer, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_array_length_cname (string? array_length_cname);
		public void set_cname (string cname);
		public void set_ctype (string ctype);
		public bool array_null_terminated { get; set; }
		public MemberBinding binding { get; set; }
		public Vala.DataType field_type { get; set; }
		public bool has_array_length_cname { get; }
		public Vala.Expression? initializer { get; set; }
		public bool is_volatile { get; set; }
		public bool no_array_length { get; set; }
	}
	[CCode (cheader_filename = "vala/valafieldprototype.h")]
	public class FieldPrototype : Vala.DataType {
		public FieldPrototype (Vala.Field field_symbol);
		public Vala.Field field_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valafloatingtype.h")]
	public class FloatingType : Vala.ValueType {
		public FloatingType (Vala.Struct type_symbol);
	}
	[CCode (cheader_filename = "vala/valaflowanalyzer.h")]
	public class FlowAnalyzer : Vala.CodeVisitor {
		public void analyze (Vala.CodeContext context);
		public FlowAnalyzer ();
	}
	[CCode (cheader_filename = "vala/valaforstatement.h")]
	public class ForStatement : Vala.CodeNode, Vala.Statement {
		public void add_initializer (Vala.Expression init);
		public void add_iterator (Vala.Expression iter);
		public Gee.List<Vala.Expression> get_initializer ();
		public Gee.List<Vala.Expression> get_iterator ();
		public ForStatement (Vala.Expression? condition, Vala.Block body, Vala.SourceReference? source_reference = null);
		public Vala.Block prepare_condition_split (Vala.SemanticAnalyzer analyzer);
		public Vala.Block body { get; set; }
		public Vala.Expression? condition { get; set; }
	}
	[CCode (cheader_filename = "vala/valaforeachstatement.h")]
	public class ForeachStatement : Vala.Block {
		public ForeachStatement (Vala.DataType? type_reference, string variable_name, Vala.Expression collection, Vala.Block body, Vala.SourceReference source_reference);
		public Vala.Block body { get; set; }
		public Vala.Expression collection { get; set; }
		public Vala.LocalVariable collection_variable { get; set; }
		public Vala.LocalVariable element_variable { get; set; }
		public Vala.LocalVariable iterator_variable { get; set; }
		public Vala.DataType? type_reference { get; set; }
		public bool use_iterator { get; set; }
		public string variable_name { get; set; }
	}
	[CCode (cheader_filename = "vala/valaformalparameter.h")]
	public class FormalParameter : Vala.Symbol {
		public Vala.FormalParameter copy ();
		public FormalParameter (string name, Vala.DataType parameter_type, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public FormalParameter.with_ellipsis (Vala.SourceReference? source_reference = null);
		public bool array_null_terminated { get; set; }
		public double carray_length_parameter_position { get; set; }
		public double cdelegate_target_parameter_position { get; set; }
		public double cparameter_position { get; set; }
		public string? ctype { get; set; }
		public Vala.Expression default_expression { get; set; }
		public Vala.ParameterDirection direction { get; set; }
		public bool ellipsis { get; set; }
		public bool no_array_length { get; set; }
		public Vala.DataType parameter_type { get; set; }
		public bool params_array { get; set; }
	}
	[CCode (cheader_filename = "vala/valagenerictype.h")]
	public class GenericType : Vala.DataType {
		public GenericType (Vala.TypeParameter type_parameter);
	}
	[CCode (cheader_filename = "vala/valaifstatement.h")]
	public class IfStatement : Vala.CodeNode, Vala.Statement {
		public IfStatement (Vala.Expression cond, Vala.Block true_stmt, Vala.Block? false_stmt, Vala.SourceReference? source);
		public Vala.Expression condition { get; set; }
		public Vala.Block? false_statement { get; set; }
		public Vala.Block true_statement { get; set; }
	}
	[CCode (cheader_filename = "vala/valainitializerlist.h")]
	public class InitializerList : Vala.Expression {
		public void append (Vala.Expression expr);
		public Gee.List<Vala.Expression> get_initializers ();
		public InitializerList (Vala.SourceReference source_reference);
		public int size { get; }
	}
	[CCode (cheader_filename = "vala/valainstancecast.h")]
	public class InstanceCast : Vala.CCodeFunctionCall {
		public InstanceCast (Vala.CCodeExpression expr, Vala.TypeSymbol type);
		public Vala.CCodeExpression inner { get; set; }
		public Vala.TypeSymbol type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valaintegerliteral.h")]
	public class IntegerLiteral : Vala.Literal {
		public string get_type_name ();
		public IntegerLiteral (string i, Vala.SourceReference? source = null);
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valaintegertype.h")]
	public class IntegerType : Vala.ValueType {
		public IntegerType (Vala.Struct type_symbol, string? literal_value = null, string? literal_type_name = null);
	}
	[CCode (cheader_filename = "vala/valainterface.h")]
	public class Interface : Vala.ObjectTypeSymbol {
		public void add_class (Vala.Class cl);
		public void add_delegate (Vala.Delegate d);
		public void add_enum (Vala.Enum en);
		public void add_field (Vala.Field f);
		public void add_method (Vala.Method m);
		public void add_prerequisite (Vala.DataType type);
		public void add_property (Vala.Property prop);
		public void add_signal (Vala.Signal sig);
		public void add_struct (Vala.Struct st);
		public Gee.List<Vala.Class> get_classes ();
		public string get_default_lower_case_csuffix ();
		public Gee.List<Vala.Delegate> get_delegates ();
		public Gee.List<Vala.Enum> get_enums ();
		public Gee.List<Vala.Field> get_fields ();
		public string get_lower_case_csuffix ();
		public Gee.List<Vala.DataType> get_prerequisites ();
		public Gee.List<Vala.Struct> get_structs ();
		public string get_type_cname ();
		public Interface (string name, Vala.SourceReference? source_reference = null);
		public void prepend_prerequisite (Vala.DataType type);
		public void process_attributes ();
		public void set_lower_case_csuffix (string csuffix);
		public void set_type_cname (string type_cname);
	}
	[CCode (cheader_filename = "vala/valainterfacetype.h")]
	public class InterfaceType : Vala.ReferenceType {
		public InterfaceType (Vala.Interface interface_symbol);
		public Vala.Interface interface_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valainvalidtype.h")]
	public class InvalidType : Vala.DataType {
		public InvalidType ();
	}
	[CCode (cheader_filename = "vala/valalambdaexpression.h")]
	public class LambdaExpression : Vala.Expression {
		public void add_parameter (string param);
		public Gee.List<string> get_parameters ();
		public LambdaExpression (Vala.Expression expression_body, Vala.SourceReference source_reference);
		public LambdaExpression.with_statement_body (Vala.Block statement_body, Vala.SourceReference source_reference);
		public Vala.Expression expression_body { get; set; }
		public Vala.Method method { get; set; }
		public Vala.Block statement_body { get; set; }
	}
	[CCode (cheader_filename = "vala/valaliteral.h")]
	public abstract class Literal : Vala.Expression {
	}
	[CCode (cheader_filename = "vala/valalocalvariable.h")]
	public class LocalVariable : Vala.Symbol {
		public LocalVariable (Vala.DataType? variable_type, string name, Vala.Expression? initializer = null, Vala.SourceReference? source_reference = null);
		public bool floating { get; set; }
		public Vala.Expression? initializer { get; set; }
		public Vala.DataType? variable_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valalockstatement.h")]
	public class LockStatement : Vala.CodeNode, Vala.Statement {
		public LockStatement (Vala.Expression resource, Vala.Block body, Vala.SourceReference? source_reference = null);
		public Vala.Block body { get; set; }
		public Vala.Expression resource { get; set; }
	}
	[CCode (cheader_filename = "vala/valamember.h")]
	public abstract class Member : Vala.Symbol {
		public void add_cheader_filename (string filename);
		public Member (string? name, Vala.SourceReference? source_reference);
	}
	[CCode (cheader_filename = "vala/valamemberaccess.h")]
	public class MemberAccess : Vala.Expression {
		public void add_type_argument (Vala.DataType arg);
		public Gee.List<Vala.DataType> get_type_arguments ();
		public MemberAccess (Vala.Expression? inner, string member_name, Vala.SourceReference? source_reference = null);
		public MemberAccess.pointer (Vala.Expression inner, string member_name, Vala.SourceReference? source_reference = null);
		public MemberAccess.simple (string member_name, Vala.SourceReference? source_reference = null);
		public bool creation_member { get; set; }
		public Vala.Expression? inner { get; set; }
		public string member_name { get; set; }
		public bool pointer_member_access { get; set; }
		public bool prototype_access { get; set; }
		public bool qualified { get; set; }
	}
	[CCode (cheader_filename = "vala/valamemberinitializer.h")]
	public class MemberInitializer : Vala.CodeNode {
		public MemberInitializer (string name, Vala.Expression initializer, Vala.SourceReference? source_reference = null);
		public Vala.Expression initializer { get; set; }
		public string name { get; set; }
		public Vala.Symbol symbol_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valamethod.h")]
	public class Method : Vala.Member {
		public const string DEFAULT_SENTINEL;
		public void add_parameter (Vala.FormalParameter param);
		public void add_postcondition (Vala.Expression postcondition);
		public void add_precondition (Vala.Expression precondition);
		public void clear_parameters ();
		public bool compatible (Vala.Method base_method, out string? invalid_match);
		public string get_cname ();
		public virtual string get_default_cname ();
		public Gee.List<Vala.FormalParameter> get_parameters ();
		public Gee.List<Vala.Expression> get_postconditions ();
		public Gee.List<Vala.Expression> get_preconditions ();
		public virtual string get_real_cname ();
		public Method (string? name, Vala.DataType return_type, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_cname (string cname);
		public bool array_null_terminated { get; set; }
		public Vala.Method base_interface_method { get; }
		public Vala.Method base_method { get; }
		public MemberBinding binding { get; set; }
		public Vala.Block body { get; set; }
		public double carray_length_parameter_position { get; set; }
		public double cdelegate_target_parameter_position { get; set; }
		public double cinstance_parameter_position { get; set; }
		public bool coroutine { get; set; }
		public Vala.BasicBlock entry_block { get; set; }
		public bool entry_point { get; set; }
		public Vala.BasicBlock exit_block { get; set; }
		public bool has_construct_function { get; set; }
		public bool is_abstract { get; set; }
		public bool is_inline { get; set; }
		public bool is_virtual { get; set; }
		public bool no_array_length { get; set; }
		public bool overrides { get; set; }
		public bool printf_format { get; set; }
		public Vala.LocalVariable result_var { get; set; }
		public Vala.DataType return_type { get; set; }
		public bool returns_modified_pointer { get; set; }
		public string sentinel { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public string vfunc_name { get; set; }
	}
	[CCode (cheader_filename = "vala/valamethodcall.h")]
	public class MethodCall : Vala.Expression {
		public Vala.Expression _call;
		public void add_argument (Vala.Expression arg);
		public void append_array_size (Vala.CCodeExpression size);
		public Gee.List<Vala.Expression> get_argument_list ();
		public Gee.List<Vala.CCodeExpression> get_array_sizes ();
		public MethodCall (Vala.Expression call, Vala.SourceReference? source_reference = null);
		public Vala.Expression call { get; set; }
		public Vala.CCodeExpression delegate_target { get; set; }
	}
	[CCode (cheader_filename = "vala/valamethodtype.h")]
	public class MethodType : Vala.DataType {
		public MethodType (Vala.Method method_symbol);
		public Vala.Method method_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valanamespace.h")]
	public class Namespace : Vala.Symbol {
		public void add_class (Vala.Class cl);
		public void add_constant (Vala.Constant constant);
		public void add_cprefix (string cprefix);
		public void add_delegate (Vala.Delegate d);
		public void add_enum (Vala.Enum en);
		public void add_error_domain (Vala.ErrorDomain edomain);
		public void add_field (Vala.Field f);
		public void add_interface (Vala.Interface iface);
		public void add_method (Vala.Method m);
		public void add_namespace (Vala.Namespace ns);
		public void add_struct (Vala.Struct st);
		public string get_cheader_filename ();
		public Gee.List<Vala.Class> get_classes ();
		public Gee.List<Vala.Constant> get_constants ();
		public Gee.List<string> get_cprefixes ();
		public Gee.List<Vala.Delegate> get_delegates ();
		public Gee.List<Vala.Enum> get_enums ();
		public Gee.List<Vala.ErrorDomain> get_error_types ();
		public Gee.List<Vala.Field> get_fields ();
		public Gee.List<Vala.Interface> get_interfaces ();
		public Gee.List<Vala.Method> get_methods ();
		public Gee.List<Vala.Namespace> get_namespaces ();
		public Gee.List<Vala.Struct> get_structs ();
		public Namespace (string? name, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void remove_struct (Vala.Struct st);
		public void set_cheader_filename (string cheader_filename);
		public void set_lower_case_cprefix (string cprefix);
	}
	[CCode (cheader_filename = "vala/valanullchecker.h")]
	public class NullChecker : Vala.CodeVisitor {
		public void check (Vala.CodeContext context);
		public NullChecker ();
	}
	[CCode (cheader_filename = "vala/valanullliteral.h")]
	public class NullLiteral : Vala.Literal {
		public NullLiteral (Vala.SourceReference? source = null);
	}
	[CCode (cheader_filename = "vala/valanulltype.h")]
	public class NullType : Vala.ReferenceType {
		public NullType (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaobjectcreationexpression.h")]
	public class ObjectCreationExpression : Vala.Expression {
		public void add_argument (Vala.Expression arg);
		public void add_member_initializer (Vala.MemberInitializer init);
		public Gee.List<Vala.Expression> get_argument_list ();
		public Gee.List<Vala.MemberInitializer> get_object_initializer ();
		public ObjectCreationExpression (Vala.MemberAccess member_name, Vala.SourceReference source_reference);
		public Vala.Method constructor { get; set; }
		public Vala.MemberAccess member_name { get; set; }
		public bool struct_creation { get; set; }
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valaobjecttype.h")]
	public class ObjectType : Vala.ReferenceType {
		public ObjectType (Vala.ObjectTypeSymbol type_symbol);
		public Vala.ObjectTypeSymbol type_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valaobjecttypesymbol.h")]
	public abstract class ObjectTypeSymbol : Vala.TypeSymbol {
		public void add_type_parameter (Vala.TypeParameter p);
		public abstract Gee.List<Vala.Method> get_methods ();
		public abstract Gee.List<Vala.Property> get_properties ();
		public abstract Gee.List<Vala.Signal> get_signals ();
		public Gee.List<Vala.TypeParameter> get_type_parameters ();
		public ObjectTypeSymbol (string name, Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala/valaparenthesizedexpression.h")]
	public class ParenthesizedExpression : Vala.Expression {
		public ParenthesizedExpression (Vala.Expression _inner, Vala.SourceReference? source);
		public Vala.Expression inner { get; set; }
	}
	[CCode (cheader_filename = "vala/valaparser.h")]
	public class Parser : Vala.CodeVisitor {
		public Parser ();
		public void parse (Vala.CodeContext context);
		public void parse_file (Vala.SourceFile source_file);
	}
	[CCode (ref_function = "vala_phi_function_ref", unref_function = "vala_phi_function_unref", param_spec_function = "vala_param_spec_phi_function", cheader_filename = "vala/valaphifunction.h")]
	public class PhiFunction {
		public PhiFunction (Vala.LocalVariable variable, int num_of_ops);
		public Gee.List<Vala.LocalVariable?> operands { get; set; }
		public Vala.LocalVariable original_variable { get; set; }
	}
	[CCode (cheader_filename = "vala/valapointerindirection.h")]
	public class PointerIndirection : Vala.Expression {
		public PointerIndirection (Vala.Expression inner, Vala.SourceReference? source_reference = null);
		public Vala.Expression inner { get; set; }
	}
	[CCode (cheader_filename = "vala/valapointertype.h")]
	public class PointerType : Vala.DataType {
		public PointerType (Vala.DataType base_type, Vala.SourceReference? source_reference = null);
		public Vala.DataType base_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valapostfixexpression.h")]
	public class PostfixExpression : Vala.Expression {
		public PostfixExpression (Vala.Expression _inner, bool inc, Vala.SourceReference source);
		public bool increment { get; set; }
		public Vala.Expression inner { get; set; }
	}
	[CCode (cheader_filename = "vala/valaproperty.h")]
	public class Property : Vala.Member, Vala.Lockable {
		public bool equals (Vala.Property prop2);
		public Vala.CCodeConstant get_canonical_cconstant ();
		public string get_upper_case_cname ();
		public Property (string name, Vala.DataType? property_type, Vala.PropertyAccessor? get_accessor, Vala.PropertyAccessor? set_accessor, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public Vala.Property base_interface_property { get; }
		public Vala.Property base_property { get; }
		public MemberBinding binding { get; set; }
		public string blurb { get; set; }
		public Vala.Expression default_expression { get; set; }
		public Vala.Field field { get; set; }
		public Vala.PropertyAccessor? get_accessor { get; set; }
		public bool interface_only { get; set; }
		public bool is_abstract { get; set; }
		public bool is_virtual { get; set; }
		public string nick { get; set; }
		public bool no_accessor_method { get; set; }
		public bool notify { get; set; }
		public bool overrides { get; set; }
		public Vala.DataType? property_type { get; set; }
		public Vala.PropertyAccessor? set_accessor { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala/valapropertyaccessor.h")]
	public class PropertyAccessor : Vala.CodeNode {
		public string get_cname ();
		public PropertyAccessor (bool readable, bool writable, bool construction, Vala.Block? body, Vala.SourceReference? source_reference);
		public void process_attributes ();
		public Vala.SymbolAccessibility access { get; set; }
		public bool automatic_body { get; set; }
		public Vala.Block? body { get; set; }
		public bool construction { get; set; }
		public Vala.BasicBlock entry_block { get; set; }
		public Vala.BasicBlock exit_block { get; set; }
		public Vala.Property prop { get; set; }
		public bool readable { get; set; }
		public Vala.FormalParameter value_parameter { get; set; }
		public bool writable { get; set; }
	}
	[CCode (cheader_filename = "vala/valarealliteral.h")]
	public class RealLiteral : Vala.Literal {
		public string get_type_name ();
		public RealLiteral (string r, Vala.SourceReference source);
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valareferencetransferexpression.h")]
	public class ReferenceTransferExpression : Vala.Expression {
		public ReferenceTransferExpression (Vala.Expression inner, Vala.SourceReference? source_reference = null);
		public Vala.Expression inner { get; set; }
	}
	[CCode (cheader_filename = "vala/valareferencetype.h")]
	public abstract class ReferenceType : Vala.DataType {
	}
	[CCode (cheader_filename = "vala/valareturnstatement.h")]
	public class ReturnStatement : Vala.CodeNode, Vala.Statement {
		public ReturnStatement (Vala.Expression? return_expression = null, Vala.SourceReference? source_reference = null);
		public Vala.Expression? return_expression { get; set; }
	}
	[CCode (ref_function = "vala_scanner_ref", unref_function = "vala_scanner_unref", param_spec_function = "vala_param_spec_scanner", cheader_filename = "vala/valascanner.h")]
	public class Scanner {
		public Scanner (Vala.SourceFile source_file);
		public string? pop_comment ();
		public Vala.TokenType read_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
		public Vala.SourceFile source_file { get; set; }
	}
	[CCode (ref_function = "vala_scope_ref", unref_function = "vala_scope_unref", param_spec_function = "vala_param_spec_scope", cheader_filename = "vala/valascope.h")]
	public class Scope {
		public void add (string? name, Vala.Symbol sym);
		public bool is_subscope_of (Vala.Scope? scope);
		public Vala.Symbol? lookup (string name);
		public Scope (Vala.Symbol? owner = null);
		public void remove (string name);
		public Vala.Symbol owner { get; set; }
		public Vala.Scope parent_scope { get; set; }
	}
	[CCode (cheader_filename = "vala/valasemanticanalyzer.h")]
	public class SemanticAnalyzer : Vala.CodeVisitor {
		public Vala.DataType bool_type;
		public Vala.Class current_class;
		public Vala.DataType current_return_type;
		public Vala.Struct current_struct;
		public Vala.DataType double_type;
		public Vala.DataType garray_type;
		public Vala.Class gerror_type;
		public Vala.DataType glist_type;
		public Vala.DataType gslist_type;
		public Vala.TypeSymbol initially_unowned_type;
		public Vala.Block insert_block;
		public Vala.DataType int8_type;
		public Vala.DataType int_type;
		public Vala.Interface list_type;
		public Vala.DataType long_type;
		public Vala.Interface map_type;
		public int next_lambda_id;
		public Vala.Class object_type;
		public Gee.List<Vala.CodeNode> replaced_nodes;
		public Vala.Symbol root_symbol;
		public Vala.DataType short_type;
		public Vala.DataType size_t_type;
		public Vala.DataType ssize_t_type;
		public Vala.DataType string_type;
		public Vala.DataType type_type;
		public Vala.DataType uchar_type;
		public Vala.DataType uint64_type;
		public Vala.DataType uint_type;
		public Vala.DataType ulong_type;
		public Vala.DataType unichar_type;
		public Vala.DataType ushort_type;
		public void analyze (Vala.CodeContext context);
		public bool check_arguments (Vala.Expression expr, Vala.DataType mtype, Gee.List<Vala.FormalParameter> params, Gee.List<Vala.Expression> args);
		public Vala.Method? find_current_method ();
		public static Vala.DataType? get_actual_type (Vala.DataType derived_instance_type, Vala.GenericType generic_type, Vala.CodeNode node_reference);
		public Vala.DataType? get_arithmetic_result_type (Vala.DataType left_type, Vala.DataType right_type);
		public static Vala.DataType get_data_type_for_symbol (Vala.TypeSymbol sym);
		public Vala.DataType? get_value_type_for_symbol (Vala.Symbol sym, bool lvalue);
		public bool is_in_constructor ();
		public bool is_in_instance_method ();
		public bool is_type_accessible (Vala.Symbol sym, Vala.DataType type);
		public SemanticAnalyzer ();
		public static Vala.Symbol? symbol_lookup_inherited (Vala.Symbol sym, string name);
		public void visit_member_initializer (Vala.MemberInitializer init, Vala.DataType type);
		public Vala.CodeContext context { get; set; }
		public Vala.SourceFile current_source_file { get; set; }
		public Vala.Symbol current_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valasignal.h")]
	public class Signal : Vala.Member, Vala.Lockable {
		public void add_parameter (Vala.FormalParameter param);
		public Vala.CCodeConstant get_canonical_cconstant (string? detail = null);
		public string get_cname ();
		public Vala.Delegate get_delegate (Vala.DataType sender_type, Vala.CodeNode node_reference);
		public Vala.Method get_method_handler ();
		public Gee.List<Vala.FormalParameter> get_parameters ();
		public Signal (string name, Vala.DataType return_type, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_cname (string cname);
		public bool has_emitter { get; set; }
		public bool is_virtual { get; set; }
		public Vala.DataType return_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valasignaltype.h")]
	public class SignalType : Vala.DataType {
		public SignalType (Vala.Signal signal_symbol);
		public Vala.Signal signal_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valasizeofexpression.h")]
	public class SizeofExpression : Vala.Expression {
		public SizeofExpression (Vala.DataType type, Vala.SourceReference source);
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (ref_function = "vala_source_file_ref", unref_function = "vala_source_file_unref", param_spec_function = "vala_param_spec_source_file", cheader_filename = "vala/valasourcefile.h")]
	public class SourceFile {
		public void accept (Vala.CodeVisitor visitor);
		public void accept_children (Vala.CodeVisitor visitor);
		public void add_header_internal_include (string include);
		public void add_node (Vala.CodeNode node);
		public void add_symbol_dependency (Vala.Symbol? sym, Vala.SourceFileDependencyType dep_type);
		public void add_type_dependency (Vala.DataType type, Vala.SourceFileDependencyType dep_type);
		public void add_using_directive (Vala.UsingDirective ns);
		public bool check (Vala.SemanticAnalyzer analyzer);
		public void clear_using_directives ();
		public string get_cheader_filename ();
		public string get_cinclude_filename ();
		public string get_csource_filename ();
		public Gee.List<string> get_header_external_includes ();
		public Gee.List<weak Vala.SourceFile> get_header_internal_dependencies ();
		public Gee.List<weak Vala.SourceFile> get_header_internal_full_dependencies ();
		public Gee.List<string> get_header_internal_includes ();
		public char* get_mapped_contents ();
		public size_t get_mapped_length ();
		public Gee.List<Vala.CodeNode> get_nodes ();
		public string get_relative_filename ();
		public Gee.List<string> get_source_external_includes ();
		public Gee.List<string> get_source_internal_includes ();
		public string? get_source_line (int lineno);
		public Gee.Set<Vala.Symbol> get_source_symbol_dependencies ();
		public Gee.List<Vala.UsingDirective> get_using_directives ();
		public SourceFile (Vala.CodeContext context, string filename, bool pkg = false, string? content = null);
		public void remove_node (Vala.CodeNode node);
		public string comment { get; set; }
		public string? content { get; set; }
		public Vala.CodeContext context { get; set; }
		public Vala.SourceFileCycle cycle { get; set; }
		public bool external_package { get; set; }
		public string filename { get; set; }
		public bool is_cycle_head { get; set; }
		public int mark { get; set; }
	}
	[CCode (ref_function = "vala_source_file_cycle_ref", unref_function = "vala_source_file_cycle_unref", param_spec_function = "vala_param_spec_source_file_cycle", cheader_filename = "vala/valasourcefilecycle.h")]
	public class SourceFileCycle {
		public Gee.List<weak Vala.SourceFile> files;
		public weak Vala.SourceFile head;
		public SourceFileCycle ();
	}
	[CCode (ref_function = "vala_source_reference_ref", unref_function = "vala_source_reference_unref", param_spec_function = "vala_param_spec_source_reference", cheader_filename = "vala/valasourcereference.h")]
	public class SourceReference {
		public SourceReference (Vala.SourceFile _file, int _first_line = 0, int _first_column = 0, int _last_line = 0, int _last_column = 0);
		public string to_string ();
		public SourceReference.with_comment (Vala.SourceFile _file, int _first_line, int _first_column, int _last_line, int _last_column, string? _comment);
		public string comment { get; set; }
		public Vala.SourceFile file { get; set; }
		public int first_column { get; set; }
		public int first_line { get; set; }
		public int last_column { get; set; }
		public int last_line { get; set; }
	}
	[CCode (cheader_filename = "vala/valastatementlist.h")]
	public class StatementList : Vala.CodeNode, Vala.Statement {
		public void add (Vala.Statement stmt);
		public Vala.Statement get (int index);
		public void insert (int index, Vala.Statement stmt);
		public StatementList (Vala.SourceReference source_reference);
		public void set (int index, Vala.Statement stmt);
		public int length { get; }
	}
	[CCode (cheader_filename = "vala/valastringliteral.h")]
	public class StringLiteral : Vala.Literal {
		public string? eval ();
		public StringLiteral (string value, Vala.SourceReference? source_reference = null);
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valastruct.h")]
	public class Struct : Vala.TypeSymbol {
		public void add_base_type (Vala.DataType type);
		public void add_constant (Vala.Constant c);
		public void add_field (Vala.Field f);
		public void add_method (Vala.Method m);
		public void add_type_parameter (Vala.TypeParameter p);
		public Gee.List<Vala.DataType> get_base_types ();
		public Gee.List<Vala.Constant> get_constants ();
		public string get_default_cname ();
		public string get_default_copy_function ();
		public string get_default_destroy_function ();
		public Gee.List<Vala.Field> get_fields ();
		public Gee.List<Vala.Method> get_methods ();
		public int get_rank ();
		public Gee.List<Vala.TypeParameter> get_type_parameters ();
		public bool is_boolean_type ();
		public bool is_disposable ();
		public bool is_floating_type ();
		public bool is_integer_type ();
		public bool is_simple_type ();
		public Struct (string name, Vala.SourceReference? source_reference = null);
		public void process_attributes ();
		public void set_copy_function (string name);
		public void set_destroy_function (string name);
		public void set_simple_type (bool simple_type);
		public void set_type_id (string? name);
		public Vala.Method default_construction_method { get; set; }
		public bool has_type_id { get; set; }
	}
	[CCode (cheader_filename = "vala/valastructvaluetype.h")]
	public class StructValueType : Vala.ValueType {
		public StructValueType (Vala.Struct type_symbol);
	}
	[CCode (cheader_filename = "vala/valaswitchlabel.h")]
	public class SwitchLabel : Vala.CodeNode {
		public SwitchLabel (Vala.Expression expr, Vala.SourceReference? source = null);
		public SwitchLabel.with_default (Vala.SourceReference? source = null);
		public Vala.Expression expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valaswitchsection.h")]
	public class SwitchSection : Vala.Block {
		public void add_label (Vala.SwitchLabel label);
		public Gee.List<Vala.SwitchLabel> get_labels ();
		public bool has_default_label ();
		public SwitchSection (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaswitchstatement.h")]
	public class SwitchStatement : Vala.CodeNode, Vala.Statement {
		public void add_section (Vala.SwitchSection section);
		public Gee.List<Vala.SwitchSection> get_sections ();
		public SwitchStatement (Vala.Expression expression, Vala.SourceReference source_reference);
		public Vala.Expression expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valasymbol.h")]
	public abstract class Symbol : Vala.CodeNode {
		public static string camel_case_to_lower_case (string camel_case);
		public virtual Gee.List<string> get_cheader_filenames ();
		public virtual string get_cprefix ();
		public string get_full_name ();
		public virtual string? get_lower_case_cname (string? infix = null);
		public virtual string get_lower_case_cprefix ();
		public Vala.Scope? get_top_accessible_scope ();
		public bool is_internal_symbol ();
		public static string lower_case_to_camel_case (string lower_case);
		public Symbol (string? name, Vala.SourceReference? source_reference);
		public Vala.SymbolAccessibility access { get; set; }
		public bool active { get; set; }
		public bool external { get; set; }
		public bool external_package { get; }
		public string? name { get; set; }
		public Vala.Scope owner { get; set; }
		public Vala.Symbol? parent_symbol { get; }
		public Vala.Scope scope { get; }
		public bool used { get; set; }
	}
	[CCode (cheader_filename = "vala/valasymbolresolver.h")]
	public class SymbolResolver : Vala.CodeVisitor {
		public SymbolResolver ();
		public void resolve (Vala.CodeContext context);
	}
	[CCode (cheader_filename = "vala/valathrowstatement.h")]
	public class ThrowStatement : Vala.CodeNode, Vala.Statement {
		public ThrowStatement (Vala.Expression error_expression, Vala.SourceReference? source_reference = null);
		public Vala.Expression error_expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valatrystatement.h")]
	public class TryStatement : Vala.CodeNode, Vala.Statement {
		public void add_catch_clause (Vala.CatchClause clause);
		public Gee.List<Vala.CatchClause> get_catch_clauses ();
		public TryStatement (Vala.Block body, Vala.Block? finally_body, Vala.SourceReference? source_reference = null);
		public Vala.Block body { get; set; }
		public Vala.Block? finally_body { get; set; }
	}
	[CCode (cheader_filename = "vala/valatuple.h")]
	public class Tuple : Vala.Expression {
		public void add_expression (Vala.Expression expr);
		public Gee.List<Vala.Expression> get_expressions ();
		public Tuple ();
	}
	[CCode (cheader_filename = "vala/valatypecheck.h")]
	public class TypeCheck : Vala.Expression {
		public TypeCheck (Vala.Expression expr, Vala.DataType type, Vala.SourceReference source);
		public Vala.Expression expression { get; set; }
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valatypeparameter.h")]
	public class TypeParameter : Vala.Symbol {
		public weak Vala.TypeSymbol type;
		public bool equals (Vala.TypeParameter param2);
		public TypeParameter (string name, Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valatypesymbol.h")]
	public abstract class TypeSymbol : Vala.Symbol {
		public void add_cheader_filename (string filename);
		public abstract string get_cname (bool const_type = false);
		public virtual string? get_copy_function ();
		public virtual string? get_default_value ();
		public virtual string? get_destroy_function ();
		public virtual string? get_dup_function ();
		public virtual string? get_free_function ();
		public virtual string? get_get_value_function ();
		public virtual string? get_marshaller_type_name ();
		public virtual string? get_param_spec_function ();
		public virtual string? get_ref_function ();
		public virtual string? get_set_value_function ();
		public virtual string? get_type_id ();
		public virtual int get_type_parameter_index (string name);
		public virtual string? get_type_signature ();
		public virtual string? get_unref_function ();
		public virtual string? get_upper_case_cname (string? infix = null);
		public virtual bool is_reference_counting ();
		public virtual bool is_reference_type ();
		public virtual bool is_subtype_of (Vala.TypeSymbol t);
		public TypeSymbol (string? name, Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala/valatypeofexpression.h")]
	public class TypeofExpression : Vala.Expression {
		public TypeofExpression (Vala.DataType type, Vala.SourceReference source);
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valaunaryexpression.h")]
	public class UnaryExpression : Vala.Expression {
		public UnaryExpression (Vala.UnaryOperator op, Vala.Expression _inner, Vala.SourceReference source);
		public Vala.Expression inner { get; set; }
		public Vala.UnaryOperator operator { get; set; }
	}
	[CCode (cheader_filename = "vala/valaunresolvedsymbol.h")]
	public class UnresolvedSymbol : Vala.Symbol {
		public Vala.UnresolvedSymbol copy ();
		public UnresolvedSymbol (Vala.UnresolvedSymbol? inner, string name, Vala.SourceReference? source_reference = null);
		public Vala.UnresolvedSymbol? inner { get; set; }
		public bool qualified { get; set; }
	}
	[CCode (cheader_filename = "vala/valaunresolvedtype.h")]
	public class UnresolvedType : Vala.DataType {
		public UnresolvedType.from_symbol (Vala.UnresolvedSymbol symbol, Vala.SourceReference? source = null);
		public UnresolvedType ();
		public static Vala.UnresolvedType? new_from_expression (Vala.Expression expr);
		public Vala.UnresolvedSymbol unresolved_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valausingdirective.h")]
	public class UsingDirective : Vala.CodeNode {
		public UsingDirective (Vala.Symbol namespace_symbol, Vala.SourceReference? source_reference = null);
		public Vala.Symbol namespace_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valavaluetype.h")]
	public abstract class ValueType : Vala.DataType {
		public ValueType (Vala.TypeSymbol type_symbol);
		public Vala.TypeSymbol type_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valavoidtype.h")]
	public class VoidType : Vala.DataType {
		public VoidType (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala/valawhilestatement.h")]
	public class WhileStatement : Vala.CodeNode, Vala.Statement {
		public WhileStatement (Vala.Expression condition, Vala.Block body, Vala.SourceReference? source_reference = null);
		public Vala.Block prepare_condition_split (Vala.SemanticAnalyzer analyzer);
		public Vala.Block body { get; set; }
		public Vala.Expression condition { get; set; }
	}
	[CCode (cheader_filename = "vala/valayieldstatement.h")]
	public class YieldStatement : Vala.CodeNode, Vala.Statement {
		public YieldStatement (Vala.Expression? yield_expression, Vala.SourceReference? source_reference = null);
		public Vala.Expression? yield_expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valalockable.h")]
	public interface Lockable {
		public abstract bool get_lock_used ();
		public abstract void set_lock_used (bool used);
	}
	[CCode (cheader_filename = "vala/valastatement.h")]
	public interface Statement : Vala.CodeNode {
	}
	[CCode (type_id = "VALA_TYPE_SOURCE_LOCATION", cheader_filename = "vala/valasourcelocation.h")]
	public struct SourceLocation {
		public char* pos;
		public int line;
		public int column;
		public SourceLocation (char* _pos, int _line, int _column);
	}
	[CCode (cprefix = "VALA_ASSIGNMENT_OPERATOR_", cheader_filename = "vala/valaassignment.h")]
	public enum AssignmentOperator {
		NONE,
		SIMPLE,
		BITWISE_OR,
		BITWISE_AND,
		BITWISE_XOR,
		ADD,
		SUB,
		MUL,
		DIV,
		PERCENT,
		SHIFT_LEFT,
		SHIFT_RIGHT
	}
	[CCode (cprefix = "VALA_BINARY_OPERATOR_", cheader_filename = "vala/valabinaryexpression.h")]
	public enum BinaryOperator {
		NONE,
		PLUS,
		MINUS,
		MUL,
		DIV,
		MOD,
		SHIFT_LEFT,
		SHIFT_RIGHT,
		LESS_THAN,
		GREATER_THAN,
		LESS_THAN_OR_EQUAL,
		GREATER_THAN_OR_EQUAL,
		EQUALITY,
		INEQUALITY,
		BITWISE_AND,
		BITWISE_OR,
		BITWISE_XOR,
		AND,
		OR,
		IN
	}
	[CCode (cprefix = "VALA_PARAMETER_DIRECTION_", cheader_filename = "vala/valaformalparameter.h")]
	public enum ParameterDirection {
		IN,
		OUT,
		REF
	}
	[CCode (cprefix = "VALA_SOURCE_FILE_DEPENDENCY_TYPE_", cheader_filename = "vala/valasourcefile.h")]
	public enum SourceFileDependencyType {
		HEADER_FULL,
		HEADER_SHALLOW,
		SOURCE
	}
	[CCode (cprefix = "VALA_SYMBOL_ACCESSIBILITY_", cheader_filename = "vala/valasymbol.h")]
	public enum SymbolAccessibility {
		PRIVATE,
		INTERNAL,
		PROTECTED,
		PUBLIC
	}
	[CCode (cprefix = "VALA_TOKEN_TYPE_", cheader_filename = "vala/valatokentype.h")]
	public enum TokenType {
		NONE,
		ABSTRACT,
		AS,
		ASSIGN,
		ASSIGN_ADD,
		ASSIGN_BITWISE_AND,
		ASSIGN_BITWISE_OR,
		ASSIGN_BITWISE_XOR,
		ASSIGN_DIV,
		ASSIGN_MUL,
		ASSIGN_PERCENT,
		ASSIGN_SHIFT_LEFT,
		ASSIGN_SUB,
		BASE,
		BITWISE_AND,
		BITWISE_OR,
		BREAK,
		CARRET,
		CASE,
		CATCH,
		CHARACTER_LITERAL,
		CLASS,
		CLOSE_BRACE,
		CLOSE_BRACKET,
		CLOSE_PARENS,
		COLON,
		COMMA,
		CONST,
		CONSTRUCT,
		CONTINUE,
		DEFAULT,
		DELEGATE,
		DELETE,
		DIV,
		DO,
		DOUBLE_COLON,
		DOT,
		DYNAMIC,
		ELLIPSIS,
		ELSE,
		ENUM,
		ENSURES,
		ERRORDOMAIN,
		EOF,
		EXTERN,
		FALSE,
		FINALLY,
		FOR,
		FOREACH,
		GET,
		HASH,
		IDENTIFIER,
		IF,
		IN,
		INLINE,
		INTEGER_LITERAL,
		INTERFACE,
		INTERNAL,
		INTERR,
		IS,
		LAMBDA,
		LOCK,
		MINUS,
		NAMESPACE,
		NEW,
		NULL,
		OUT,
		OP_AND,
		OP_DEC,
		OP_EQ,
		OP_GE,
		OP_GT,
		OP_INC,
		OP_LE,
		OP_LT,
		OP_NE,
		OP_NEG,
		OP_OR,
		OP_PTR,
		OP_SHIFT_LEFT,
		OPEN_BRACE,
		OPEN_BRACKET,
		OPEN_PARENS,
		OVERRIDE,
		OWNED,
		PARAMS,
		PERCENT,
		PLUS,
		PRIVATE,
		PROTECTED,
		PUBLIC,
		REAL_LITERAL,
		REF,
		REQUIRES,
		RETURN,
		SEMICOLON,
		SET,
		SIGNAL,
		SIZEOF,
		STAR,
		STATIC,
		STRING_LITERAL,
		STRUCT,
		SWITCH,
		THIS,
		THROW,
		THROWS,
		TILDE,
		TRUE,
		TRY,
		TYPEOF,
		UNOWNED,
		USING,
		VAR,
		VERBATIM_STRING_LITERAL,
		VIRTUAL,
		VOID,
		VOLATILE,
		WEAK,
		WHILE,
		YIELD,
		YIELDS;
		public unowned string to_string ();
	}
	[CCode (cprefix = "VALA_UNARY_OPERATOR_", cheader_filename = "vala/valaunaryexpression.h")]
	public enum UnaryOperator {
		NONE,
		PLUS,
		MINUS,
		LOGICAL_NEGATION,
		BITWISE_COMPLEMENT,
		INCREMENT,
		DECREMENT,
		REF,
		OUT
	}
	[CCode (cprefix = "VALA_PARSE_ERROR_", cheader_filename = "vala/valaparser.h")]
	public errordomain ParseError {
		FAILED,
		SYNTAX,
	}
}
[CCode (cprefix = "MEMBER_BINDING_", cheader_filename = "vala/valamember.h")]
public enum MemberBinding {
	INSTANCE,
	CLASS,
	STATIC
}
