/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valatyperegisterfunction.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <gobject/gvaluecollector.h>




struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
	ValaCodeContext* _context;
};

#define VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPEREGISTER_FUNCTION_DUMMY_PROPERTY
};
static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self);
static gpointer vala_typeregister_function_parent_class = NULL;
static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj);



/**
 * Constructs the C function from the specified type.
 */
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin) {
	gboolean use_thread_safe;
	gboolean fundamental;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp1;
	gboolean _tmp2;
	char* _tmp4;
	ValaTypeSymbol* _tmp3;
	char* _tmp5;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* fun;
	char* type_value_table_decl_name;
	ValaCCodeBlock* type_init;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp48;
	ValaCCodeConstant* _tmp47;
	char* _tmp46;
	char* _tmp45;
	char* _tmp44;
	char* _tmp43;
	char* _tmp42;
	char* _tmp41;
	ValaCCodeFragment* _tmp51;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp66;
	char* _tmp65;
	char* _tmp64;
	ValaTypeSymbol* _tmp63;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeConstant* _tmp70;
	char* _tmp69;
	gboolean _tmp71;
	ValaCCodeFragment* _tmp76;
	ValaCCodeFunction* _tmp99;
	g_return_if_fail (self != NULL);
	use_thread_safe = vala_code_context_require_glib_version (self->priv->_context, 2, 14);
	fundamental = FALSE;
	_tmp0 = NULL;
	cl = (_tmp0 = vala_typeregister_function_get_type_declaration (self), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL);
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = !vala_class_get_is_compact (cl);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		_tmp1 = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		fundamental = TRUE;
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp5 = NULL;
	type_id_name = (_tmp5 = g_strdup_printf ("%s_type_id", _tmp4 = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp3 = vala_typeregister_function_get_type_declaration (self)), NULL)), _tmp4 = (g_free (_tmp4), NULL), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)), _tmp5);
	type_block = vala_ccode_block_new ();
	cdecl_ = NULL;
	if (use_thread_safe) {
		ValaCCodeDeclaration* _tmp6;
		ValaCCodeVariableDeclarator* _tmp9;
		ValaCCodeConstant* _tmp8;
		char* _tmp7;
		_tmp6 = NULL;
		cdecl_ = (_tmp6 = vala_ccode_declaration_new ("gsize"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp6);
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new_with_initializer (_tmp7 = g_strconcat (type_id_name, "__volatile", NULL), (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("0")))));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		_tmp7 = (g_free (_tmp7), NULL);
	} else {
		ValaCCodeDeclaration* _tmp10;
		ValaCCodeVariableDeclarator* _tmp12;
		ValaCCodeConstant* _tmp11;
		_tmp10 = NULL;
		cdecl_ = (_tmp10 = vala_ccode_declaration_new ("GType"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new ("0")))));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	}
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (use_thread_safe) {
		vala_ccode_declaration_set_modifiers (cdecl_, vala_ccode_declaration_get_modifiers (cdecl_) | (VALA_CCODE_MODIFIERS_VOLATILE));
	}
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) cdecl_);
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) cdecl_);
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* _tmp16;
		char* _tmp15;
		char* _tmp14;
		ValaTypeSymbol* _tmp13;
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		fun = (_tmp16 = vala_ccode_function_new (_tmp15 = g_strdup_printf ("%s_get_type", _tmp14 = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp13 = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), (fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)), _tmp16);
		_tmp15 = (g_free (_tmp15), NULL);
		_tmp14 = (g_free (_tmp14), NULL);
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_code_node_unref (_tmp13), NULL));
		/* Function will not be prototyped anyway */
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
	} else {
		ValaCCodeFunction* _tmp20;
		char* _tmp19;
		char* _tmp18;
		ValaTypeSymbol* _tmp17;
		ValaCCodeFormalParameter* _tmp21;
		char* _tmp24;
		char* _tmp23;
		ValaTypeSymbol* _tmp22;
		ValaCCodeFunction* _tmp25;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* _tmp26;
		ValaCCodeBlock* _tmp27;
		ValaCCodeReturnStatement* _tmp29;
		ValaCCodeIdentifier* _tmp28;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		fun = (_tmp20 = vala_ccode_function_new (_tmp19 = g_strdup_printf ("%s_register_type", _tmp18 = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp17 = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), (fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)), _tmp20);
		_tmp19 = (g_free (_tmp19), NULL);
		_tmp18 = (g_free (_tmp18), NULL);
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_code_node_unref (_tmp17), NULL));
		_tmp21 = NULL;
		vala_ccode_function_add_parameter (fun, _tmp21 = vala_ccode_formal_parameter_new ("module", "GTypeModule *"));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		_tmp24 = NULL;
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp25 = NULL;
		get_fun = (_tmp25 = vala_ccode_function_new (_tmp24 = g_strdup_printf ("%s_get_type", _tmp23 = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp22 = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), _tmp24 = (g_free (_tmp24), NULL), _tmp23 = (g_free (_tmp23), NULL), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL)), _tmp25);
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp26 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, (ValaCCodeNode*) (_tmp26 = vala_ccode_function_copy (get_fun)));
		(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
		_tmp27 = NULL;
		vala_ccode_function_set_block (get_fun, _tmp27 = vala_ccode_block_new ());
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp29 = NULL;
		_tmp28 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), (ValaCCodeNode*) (_tmp29 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new (type_id_name)))));
		(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) get_fun);
		(get_fun == NULL) ? NULL : (get_fun = (vala_ccode_node_unref (get_fun), NULL));
	}
	type_value_table_decl_name = NULL;
	type_init = vala_ccode_block_new ();
	if (fundamental) {
		ValaCCodeDeclaration* cgtypetabledecl;
		ValaCCodeVariableDeclarator* _tmp38;
		ValaCCodeConstant* _tmp37;
		char* _tmp36;
		char* _tmp35;
		char* _tmp34;
		char* _tmp33;
		char* _tmp32;
		char* _tmp31;
		char* _tmp30;
		char* _tmp39;
		cgtypetabledecl = vala_ccode_declaration_new ("const GTypeValueTable");
		vala_ccode_declaration_set_modifiers (cgtypetabledecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp38 = NULL;
		_tmp37 = NULL;
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp31 = NULL;
		_tmp30 = NULL;
		vala_ccode_declaration_add_declarator (cgtypetabledecl, (ValaCCodeDeclarator*) (_tmp38 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_value_table", (ValaCCodeExpression*) (_tmp37 = vala_ccode_constant_new (_tmp36 = g_strdup_printf ("{ %s, %s, %s, %s, \"p\", %s, \"p\", %s }", _tmp30 = vala_typeregister_function_get_gtype_value_table_init_function_name (self), _tmp31 = vala_typeregister_function_get_gtype_value_table_free_function_name (self), _tmp32 = vala_typeregister_function_get_gtype_value_table_copy_function_name (self), _tmp33 = vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (self), _tmp34 = vala_typeregister_function_get_gtype_value_table_collect_value_function_name (self), _tmp35 = vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (self)))))));
		(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
		(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
		_tmp36 = (g_free (_tmp36), NULL);
		_tmp35 = (g_free (_tmp35), NULL);
		_tmp34 = (g_free (_tmp34), NULL);
		_tmp33 = (g_free (_tmp33), NULL);
		_tmp32 = (g_free (_tmp32), NULL);
		_tmp31 = (g_free (_tmp31), NULL);
		_tmp30 = (g_free (_tmp30), NULL);
		_tmp39 = NULL;
		type_value_table_decl_name = (_tmp39 = g_strdup ("&g_define_type_value_table"), type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL), _tmp39);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) cgtypetabledecl);
		(cgtypetabledecl == NULL) ? NULL : (cgtypetabledecl = (vala_ccode_node_unref (cgtypetabledecl), NULL));
	} else {
		char* _tmp40;
		_tmp40 = NULL;
		type_value_table_decl_name = (_tmp40 = g_strdup ("NULL"), type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL), _tmp40);
	}
	ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
	vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
	_tmp48 = NULL;
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp41 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp48 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", (ValaCCodeExpression*) (_tmp47 = vala_ccode_constant_new (_tmp46 = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) NULL, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s, %s }", _tmp41 = vala_typeregister_function_get_type_struct_name (self), _tmp42 = vala_typeregister_function_get_base_init_func_name (self), _tmp43 = vala_typeregister_function_get_class_init_func_name (self), _tmp44 = vala_typeregister_function_get_instance_struct_size (self), _tmp45 = vala_typeregister_function_get_instance_init_func_name (self), type_value_table_decl_name))))));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	_tmp46 = (g_free (_tmp46), NULL);
	_tmp45 = (g_free (_tmp45), NULL);
	_tmp44 = (g_free (_tmp44), NULL);
	_tmp43 = (g_free (_tmp43), NULL);
	_tmp42 = (g_free (_tmp42), NULL);
	_tmp41 = (g_free (_tmp41), NULL);
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) ctypedecl);
	if (fundamental) {
		ValaCCodeDeclaration* ctypefundamentaldecl;
		ValaCCodeVariableDeclarator* _tmp50;
		ValaCCodeConstant* _tmp49;
		ctypefundamentaldecl = vala_ccode_declaration_new ("const GTypeFundamentalInfo");
		vala_ccode_declaration_set_modifiers (ctypefundamentaldecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp50 = NULL;
		_tmp49 = NULL;
		vala_ccode_declaration_add_declarator (ctypefundamentaldecl, (ValaCCodeDeclarator*) (_tmp50 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_fundamental_info", (ValaCCodeExpression*) (_tmp49 = vala_ccode_constant_new ("{ (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) }")))));
		(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
		(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) ctypefundamentaldecl);
		(ctypefundamentaldecl == NULL) ? NULL : (ctypefundamentaldecl = (vala_ccode_node_unref (ctypefundamentaldecl), NULL));
	}
	_tmp51 = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp51 = vala_typeregister_function_get_type_interface_init_declaration (self)));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	reg_call = NULL;
	if (fundamental) {
		ValaCCodeFunctionCall* _tmp53;
		ValaCCodeIdentifier* _tmp52;
		_tmp53 = NULL;
		_tmp52 = NULL;
		reg_call = (_tmp53 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new ("g_type_register_fundamental"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp53);
		(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
	} else {
		if (!plugin) {
			ValaCCodeFunctionCall* _tmp55;
			ValaCCodeIdentifier* _tmp54;
			_tmp55 = NULL;
			_tmp54 = NULL;
			reg_call = (_tmp55 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("g_type_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp55);
			(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
		} else {
			ValaCCodeFunctionCall* _tmp57;
			ValaCCodeIdentifier* _tmp56;
			ValaCCodeIdentifier* _tmp58;
			_tmp57 = NULL;
			_tmp56 = NULL;
			reg_call = (_tmp57 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new ("g_type_module_register_type"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp57);
			(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
			_tmp58 = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new ("module")));
			(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
		}
	}
	if (fundamental) {
		ValaCCodeFunctionCall* _tmp60;
		ValaCCodeIdentifier* _tmp59;
		_tmp60 = NULL;
		_tmp59 = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp60 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("g_type_fundamental_next")))));
		(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
		(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	} else {
		ValaCCodeIdentifier* _tmp62;
		char* _tmp61;
		_tmp62 = NULL;
		_tmp61 = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp62 = vala_ccode_identifier_new (_tmp61 = vala_typeregister_function_get_parent_type_name (self))));
		(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
		_tmp61 = (g_free (_tmp61), NULL);
	}
	_tmp66 = NULL;
	_tmp65 = NULL;
	_tmp64 = NULL;
	_tmp63 = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp66 = vala_ccode_constant_new (_tmp65 = g_strdup_printf ("\"%s\"", _tmp64 = vala_typesymbol_get_cname (_tmp63 = vala_typeregister_function_get_type_declaration (self), FALSE)))));
	(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
	_tmp65 = (g_free (_tmp65), NULL);
	_tmp64 = (g_free (_tmp64), NULL);
	(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_code_node_unref (_tmp63), NULL));
	_tmp67 = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("&g_define_type_info")));
	(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
	if (fundamental) {
		ValaCCodeIdentifier* _tmp68;
		_tmp68 = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp68 = vala_ccode_identifier_new ("&g_define_type_fundamental_info")));
		(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
	}
	_tmp70 = NULL;
	_tmp69 = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp70 = vala_ccode_constant_new (_tmp69 = vala_typeregister_function_get_type_flags (self))));
	(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
	_tmp69 = (g_free (_tmp69), NULL);
	_tmp71 = FALSE;
	if (use_thread_safe) {
		_tmp71 = !plugin;
	} else {
		_tmp71 = FALSE;
	}
	if (_tmp71) {
		ValaCCodeDeclaration* temp_decl;
		ValaCCodeVariableDeclarator* _tmp72;
		temp_decl = vala_ccode_declaration_new ("GType");
		_tmp72 = NULL;
		vala_ccode_declaration_add_declarator (temp_decl, (ValaCCodeDeclarator*) (_tmp72 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, (ValaCCodeExpression*) reg_call)));
		(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) temp_decl);
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_ccode_node_unref (temp_decl), NULL));
	} else {
		ValaCCodeExpressionStatement* _tmp75;
		ValaCCodeAssignment* _tmp74;
		ValaCCodeIdentifier* _tmp73;
		_tmp75 = NULL;
		_tmp74 = NULL;
		_tmp73 = NULL;
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp75 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp74 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
		(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
		(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
	}
	_tmp76 = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp76 = vala_typeregister_function_get_type_interface_init_statements (self)));
	(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
	if (!plugin) {
		ValaCCodeExpression* condition;
		ValaCCodeIfStatement* cif;
		condition = NULL;
		/* the condition that guards the type initialisation*/
		if (use_thread_safe) {
			ValaCCodeIdentifier* _tmp77;
			ValaCCodeFunctionCall* _tmp78;
			ValaCCodeFunctionCall* enter;
			ValaCCodeUnaryExpression* _tmp81;
			ValaCCodeIdentifier* _tmp80;
			char* _tmp79;
			ValaCCodeExpression* _tmp83;
			ValaCCodeExpression* _tmp82;
			ValaCCodeIdentifier* _tmp84;
			ValaCCodeFunctionCall* _tmp85;
			ValaCCodeFunctionCall* leave;
			ValaCCodeUnaryExpression* _tmp88;
			ValaCCodeIdentifier* _tmp87;
			char* _tmp86;
			ValaCCodeIdentifier* _tmp89;
			ValaCCodeExpressionStatement* _tmp90;
			_tmp77 = NULL;
			_tmp78 = NULL;
			enter = (_tmp78 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp77 = vala_ccode_identifier_new ("g_once_init_enter"))), (_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)), _tmp78);
			_tmp81 = NULL;
			_tmp80 = NULL;
			_tmp79 = NULL;
			vala_ccode_function_call_add_argument (enter, (ValaCCodeExpression*) (_tmp81 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new (_tmp79 = g_strconcat (type_id_name, "__volatile", NULL))))));
			(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
			(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
			_tmp79 = (g_free (_tmp79), NULL);
			_tmp83 = NULL;
			_tmp82 = NULL;
			condition = (_tmp83 = (_tmp82 = (ValaCCodeExpression*) enter, (_tmp82 == NULL) ? NULL : vala_ccode_node_ref (_tmp82)), (condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL)), _tmp83);
			_tmp84 = NULL;
			_tmp85 = NULL;
			leave = (_tmp85 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new ("g_once_init_leave"))), (_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL)), _tmp85);
			_tmp88 = NULL;
			_tmp87 = NULL;
			_tmp86 = NULL;
			vala_ccode_function_call_add_argument (leave, (ValaCCodeExpression*) (_tmp88 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp87 = vala_ccode_identifier_new (_tmp86 = g_strconcat (type_id_name, "__volatile", NULL))))));
			(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
			(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
			_tmp86 = (g_free (_tmp86), NULL);
			_tmp89 = NULL;
			vala_ccode_function_call_add_argument (leave, (ValaCCodeExpression*) (_tmp89 = vala_ccode_identifier_new (type_id_name)));
			(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
			_tmp90 = NULL;
			vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp90 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) leave)));
			(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
			(enter == NULL) ? NULL : (enter = (vala_ccode_node_unref (enter), NULL));
			(leave == NULL) ? NULL : (leave = (vala_ccode_node_unref (leave), NULL));
		} else {
			ValaCCodeIdentifier* id;
			ValaCCodeConstant* zero;
			ValaCCodeExpression* _tmp91;
			id = vala_ccode_identifier_new (type_id_name);
			zero = vala_ccode_constant_new ("0");
			_tmp91 = NULL;
			condition = (_tmp91 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) id, (ValaCCodeExpression*) zero), (condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL)), _tmp91);
			(id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL));
			(zero == NULL) ? NULL : (zero = (vala_ccode_node_unref (zero), NULL));
		}
		cif = vala_ccode_if_statement_new (condition, (ValaCCodeStatement*) type_init, NULL);
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) cif);
		(condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL));
		(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	} else {
		ValaCCodeBlock* _tmp93;
		ValaCCodeBlock* _tmp92;
		_tmp93 = NULL;
		_tmp92 = NULL;
		type_block = (_tmp93 = (_tmp92 = type_init, (_tmp92 == NULL) ? NULL : vala_ccode_node_ref (_tmp92)), (type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL)), _tmp93);
	}
	if (use_thread_safe) {
		ValaCCodeReturnStatement* _tmp96;
		ValaCCodeIdentifier* _tmp95;
		char* _tmp94;
		_tmp96 = NULL;
		_tmp95 = NULL;
		_tmp94 = NULL;
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) (_tmp96 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp95 = vala_ccode_identifier_new (_tmp94 = g_strconcat (type_id_name, "__volatile", NULL))))));
		(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
		(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
		_tmp94 = (g_free (_tmp94), NULL);
	} else {
		ValaCCodeReturnStatement* _tmp98;
		ValaCCodeIdentifier* _tmp97;
		_tmp98 = NULL;
		_tmp97 = NULL;
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) (_tmp98 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp97 = vala_ccode_identifier_new (type_id_name)))));
		(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
		(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
	}
	_tmp99 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, (ValaCCodeNode*) (_tmp99 = vala_ccode_function_copy (fun)));
	(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) fun);
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	type_id_name = (g_free (type_id_name), NULL);
	(type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL);
	(type_init == NULL) ? NULL : (type_init = (vala_ccode_node_unref (type_init), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
}


static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_declaration'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the data type to be registered.
 *
 * @return type to be registered
 */
ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_struct_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the type struct in C code.
 *
 * @return C struct name
 */
char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_base_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the base_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_class_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the class_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_instance_struct_size'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the size of the instance struct in C code.
 *
 * @return C instance struct size
 */
char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_instance_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the instance_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_parent_type_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the parent type in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable init function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_init_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable peek pointer function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_peek_pointer_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable free function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_free_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable copy function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_copy_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable lcopy function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_lcopy_value_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable collect value function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_collect_value_function_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return g_strdup ("0");
}


char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return vala_ccode_fragment_new ();
}


ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_interface_init_statements'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns additional C initialization statements to setup interfaces.
 *
 * @return C statements
 */
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->declaration_fragment, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->definition_fragment, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
}


static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, 0);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_accessibility'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}


/**
 * Returns the accessibility for this type.
 */
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_accessibility (self);
}


ValaCodeContext* vala_typeregister_function_get_context (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_context_ref (_tmp1)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp2);
}


static void vala_value_typeregister_function_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_typeregister_function_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_typeregister_function_unref (value->data[0].v_pointer);
	}
}


static void vala_value_typeregister_function_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_typeregister_function_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_typeregister_function_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_typeregister_function_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaTypeRegisterFunction* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_typeregister_function_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_typeregister_function_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaTypeRegisterFunction** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_typeregister_function_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecTypeRegisterFunction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_typeregister_function (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_typeregister_function (GValue* value, gpointer v_object) {
	ValaTypeRegisterFunction* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TYPEREGISTER_FUNCTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_typeregister_function_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_typeregister_function_unref (old);
	}
}


static void vala_typeregister_function_class_init (ValaTypeRegisterFunctionClass * klass) {
	vala_typeregister_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_typeregister_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_typeregister_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_typeregister_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_typeregister_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_typeregister_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_typeregister_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_typeregister_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_typeregister_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_init_function_name = vala_typeregister_function_real_get_gtype_value_table_init_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_peek_pointer_function_name = vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_free_function_name = vala_typeregister_function_real_get_gtype_value_table_free_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_copy_function_name = vala_typeregister_function_real_get_gtype_value_table_copy_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_lcopy_value_function_name = vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_collect_value_function_name = vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_typeregister_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_typeregister_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_typeregister_function_real_get_type_interface_init_statements;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_typeregister_function_real_get_accessibility;
}


static void vala_typeregister_function_instance_init (ValaTypeRegisterFunction * self) {
	self->priv = VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = vala_ccode_fragment_new ();
	self->priv->definition_fragment = vala_ccode_fragment_new ();
	self->ref_count = 1;
}


static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL) ? NULL : (self->priv->declaration_fragment = (vala_ccode_node_unref (self->priv->declaration_fragment), NULL));
	(self->priv->definition_fragment == NULL) ? NULL : (self->priv->definition_fragment = (vala_ccode_node_unref (self->priv->definition_fragment), NULL));
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
}


GType vala_typeregister_function_get_type (void) {
	static GType vala_typeregister_function_type_id = 0;
	if (vala_typeregister_function_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_typeregister_function_init, vala_value_typeregister_function_free_value, vala_value_typeregister_function_copy_value, vala_value_typeregister_function_peek_pointer, "p", vala_value_typeregister_function_collect_value, "p", vala_value_typeregister_function_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeregister_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_typeregister_function_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_typeregister_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaTypeRegisterFunction", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_typeregister_function_type_id;
}


gpointer vala_typeregister_function_ref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_typeregister_function_unref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




