/* valasizeofexpression.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valasizeofexpression.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaSizeofExpressionPrivate {
	ValaDataType* _data_type;
};

#define VALA_SIZEOF_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionPrivate))
enum  {
	VALA_SIZEOF_EXPRESSION_DUMMY_PROPERTY
};
static void vala_sizeof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_sizeof_expression_real_is_pure (ValaExpression* base);
static void vala_sizeof_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gpointer vala_sizeof_expression_parent_class = NULL;
static void vala_sizeof_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new sizeof expression.
 *
 * @param type   a data type
 * @param source reference to source code
 * @return       newly created sizeof expression
 */
ValaSizeofExpression* vala_sizeof_expression_construct (GType object_type, ValaDataType* type, ValaSourceReference* source) {
	ValaSizeofExpression* self;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = ((ValaSizeofExpression*) (g_type_create_instance (object_type)));
	vala_sizeof_expression_set_type_reference (self, type);
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source);
	return self;
}


ValaSizeofExpression* vala_sizeof_expression_new (ValaDataType* type, ValaSourceReference* source) {
	return vala_sizeof_expression_construct (VALA_TYPE_SIZEOF_EXPRESSION, type, source);
}


static void vala_sizeof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSizeofExpression * self;
	self = ((ValaSizeofExpression*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept (((ValaCodeNode*) (vala_sizeof_expression_get_type_reference (self))), visitor);
	vala_code_visitor_visit_sizeof_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, ((ValaExpression*) (self)));
}


static gboolean vala_sizeof_expression_real_is_pure (ValaExpression* base) {
	ValaSizeofExpression * self;
	self = ((ValaSizeofExpression*) (base));
	return TRUE;
}


static void vala_sizeof_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaSizeofExpression * self;
	self = ((ValaSizeofExpression*) (base));
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_sizeof_expression_get_type_reference (self) == old_type) {
		vala_sizeof_expression_set_type_reference (self, new_type);
	}
}


ValaDataType* vala_sizeof_expression_get_type_reference (ValaSizeofExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_data_type;
}


void vala_sizeof_expression_set_type_reference (ValaSizeofExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_data_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_data_type == NULL ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL))), _tmp2);
	vala_code_node_set_parent_node (((ValaCodeNode*) (self->priv->_data_type)), ((ValaCodeNode*) (self)));
}


static void vala_sizeof_expression_class_init (ValaSizeofExpressionClass * klass) {
	vala_sizeof_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_sizeof_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaSizeofExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_sizeof_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_sizeof_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_sizeof_expression_real_replace_type;
}


static void vala_sizeof_expression_instance_init (ValaSizeofExpression * self) {
	self->priv = VALA_SIZEOF_EXPRESSION_GET_PRIVATE (self);
}


static void vala_sizeof_expression_finalize (ValaCodeNode* obj) {
	ValaSizeofExpression * self;
	self = VALA_SIZEOF_EXPRESSION (obj);
	(self->priv->_data_type == NULL ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL)));
	VALA_CODE_NODE_CLASS (vala_sizeof_expression_parent_class)->finalize (obj);
}


GType vala_sizeof_expression_get_type (void) {
	static GType vala_sizeof_expression_type_id = 0;
	if (vala_sizeof_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSizeofExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_sizeof_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSizeofExpression), 0, (GInstanceInitFunc) vala_sizeof_expression_instance_init, NULL };
		vala_sizeof_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaSizeofExpression", &g_define_type_info, 0);
	}
	return vala_sizeof_expression_type_id;
}




