/* valaobjecttypesymbol.vala
 *
 * Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <vala/valaobjecttypesymbol.h>
#include <vala/valasourcereference.h>




enum  {
	VALA_OBJECT_TYPE_SYMBOL_DUMMY_PROPERTY
};
static GeeList* vala_object_type_symbol_real_get_methods (ValaObjectTypeSymbol* self);
static GeeList* vala_object_type_symbol_real_get_signals (ValaObjectTypeSymbol* self);
static GeeList* vala_object_type_symbol_real_get_properties (ValaObjectTypeSymbol* self);
static gpointer vala_object_type_symbol_parent_class = NULL;



static GeeList* vala_object_type_symbol_real_get_methods (ValaObjectTypeSymbol* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_object_type_symbol_get_methods'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_methods (self);
}


static GeeList* vala_object_type_symbol_real_get_signals (ValaObjectTypeSymbol* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_object_type_symbol_get_signals'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeList* vala_object_type_symbol_get_signals (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_signals (self);
}


static GeeList* vala_object_type_symbol_real_get_properties (ValaObjectTypeSymbol* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_object_type_symbol_get_properties'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_properties (self);
}


ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference) {
	ValaObjectTypeSymbol* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = ((ValaObjectTypeSymbol*) (g_type_create_instance (object_type)));
	self = ((ValaObjectTypeSymbol*) (vala_typesymbol_construct (object_type, name, source_reference)));
	return self;
}


ValaObjectTypeSymbol* vala_object_type_symbol_new (const char* name, ValaSourceReference* source_reference) {
	return vala_object_type_symbol_construct (VALA_TYPE_OBJECT_TYPE_SYMBOL, name, source_reference);
}


static void vala_object_type_symbol_class_init (ValaObjectTypeSymbolClass * klass) {
	vala_object_type_symbol_parent_class = g_type_class_peek_parent (klass);
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_methods = vala_object_type_symbol_real_get_methods;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_signals = vala_object_type_symbol_real_get_signals;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_properties = vala_object_type_symbol_real_get_properties;
}


static void vala_object_type_symbol_instance_init (ValaObjectTypeSymbol * self) {
}


GType vala_object_type_symbol_get_type (void) {
	static GType vala_object_type_symbol_type_id = 0;
	if (vala_object_type_symbol_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectTypeSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_type_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectTypeSymbol), 0, (GInstanceInitFunc) vala_object_type_symbol_instance_init, NULL };
		vala_object_type_symbol_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaObjectTypeSymbol", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_object_type_symbol_type_id;
}




