/* valaccodememberaccess.vala
 *
 * Copyright (C) 2006  Raffaele Sandrini
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 *	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEELEMENTACCESS_H__
#define __CCODE_VALACCODEELEMENTACCESS_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_ELEMENT_ACCESS (vala_ccode_element_access_get_type ())
#define VALA_CCODE_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ELEMENT_ACCESS, ValaCCodeElementAccess))
#define VALA_CCODE_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ELEMENT_ACCESS, ValaCCodeElementAccessClass))
#define VALA_IS_CCODE_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ELEMENT_ACCESS))
#define VALA_IS_CCODE_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ELEMENT_ACCESS))
#define VALA_CCODE_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ELEMENT_ACCESS, ValaCCodeElementAccessClass))

typedef struct _ValaCCodeElementAccess ValaCCodeElementAccess;
typedef struct _ValaCCodeElementAccessClass ValaCCodeElementAccessClass;
typedef struct _ValaCCodeElementAccessPrivate ValaCCodeElementAccessPrivate;

/**
 * Represents an access to an array member in the C code.
 */
struct _ValaCCodeElementAccess {
	ValaCCodeExpression parent_instance;
	ValaCCodeElementAccessPrivate * priv;
};

struct _ValaCCodeElementAccessClass {
	ValaCCodeExpressionClass parent_class;
};


ValaCCodeElementAccess* vala_ccode_element_access_construct (GType object_type, ValaCCodeExpression* cont, ValaCCodeExpression* i);
ValaCCodeElementAccess* vala_ccode_element_access_new (ValaCCodeExpression* cont, ValaCCodeExpression* i);
ValaCCodeExpression* vala_ccode_element_access_get_container (ValaCCodeElementAccess* self);
void vala_ccode_element_access_set_container (ValaCCodeElementAccess* self, ValaCCodeExpression* value);
ValaCCodeExpression* vala_ccode_element_access_get_index (ValaCCodeElementAccess* self);
void vala_ccode_element_access_set_index (ValaCCodeElementAccess* self, ValaCCodeExpression* value);
GType vala_ccode_element_access_get_type (void);


G_END_DECLS

#endif
