/* valainterfacewriter.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valainterfacewriter.h>
#include <stdio.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <gee/arraylist.h>
#include <float.h>
#include <math.h>
#include <vala/valascope.h>
#include <vala/valasymbol.h>
#include <vala/valatypesymbol.h>
#include <vala/valatypeparameter.h>
#include <vala/valadatatype.h>
#include <vala/valacodenode.h>
#include <vala/valaenumvalue.h>
#include <vala/valamember.h>
#include <vala/valaarraytype.h>
#include <vala/valaformalparameter.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <vala/valavaluetype.h>




struct _ValaInterfaceWriterPrivate {
	ValaCodeContext* context;
	FILE* stream;
	gint indent;
	gboolean bol;
	char* current_cheader_filename;
	ValaScope* current_scope;
};

#define VALA_INTERFACE_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE_WRITER, ValaInterfaceWriterPrivate))
enum  {
	VALA_INTERFACE_WRITER_DUMMY_PROPERTY
};
static void vala_interface_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_interface_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_interface_writer_visit_sorted (ValaInterfaceWriter* self, GeeList* symbols);
static void vala_interface_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_interface_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_interface_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_interface_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
static void vala_interface_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_interface_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_interface_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_interface_writer_write_error_domains (ValaInterfaceWriter* self, GeeList* error_domains);
static gboolean vala_interface_writer_float_equal (ValaInterfaceWriter* self, double d1, double d2);
static void vala_interface_writer_write_params (ValaInterfaceWriter* self, GeeList* params);
static void vala_interface_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void vala_interface_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_interface_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_interface_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_interface_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_interface_writer_write_indent (ValaInterfaceWriter* self);
static void vala_interface_writer_write_identifier (ValaInterfaceWriter* self, const char* s);
static void vala_interface_writer_write_return_type (ValaInterfaceWriter* self, ValaDataType* type);
static gboolean vala_interface_writer_is_weak (ValaInterfaceWriter* self, ValaDataType* type);
static void vala_interface_writer_write_type (ValaInterfaceWriter* self, ValaDataType* type);
static void vala_interface_writer_write_string (ValaInterfaceWriter* self, const char* s);
static void vala_interface_writer_write_newline (ValaInterfaceWriter* self);
static void vala_interface_writer_write_begin_block (ValaInterfaceWriter* self);
static void vala_interface_writer_write_end_block (ValaInterfaceWriter* self);
static gboolean vala_interface_writer_check_accessibility (ValaInterfaceWriter* self, ValaSymbol* sym);
static void vala_interface_writer_write_accessibility (ValaInterfaceWriter* self, ValaSymbol* sym);
static gpointer vala_interface_writer_parent_class = NULL;
static void vala_interface_writer_finalize (ValaCodeVisitor* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context  a code context
 * @param filename a relative or absolute filename
 */
void vala_interface_writer_write_file (ValaInterfaceWriter* self, ValaCodeContext* context, const char* filename) {
	ValaCodeContext* _tmp1;
	ValaCodeContext* _tmp0;
	FILE* _tmp2;
	char* _tmp4;
	char* _tmp3;
	ValaScope* _tmp6;
	ValaScope* _tmp5;
	ValaScope* _tmp7;
	FILE* _tmp8;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (filename != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->context = (_tmp1 = (_tmp0 = context, (_tmp0 == NULL ? NULL : vala_code_context_ref (_tmp0))), (self->priv->context == NULL ? NULL : (self->priv->context = (vala_code_context_unref (self->priv->context), NULL))), _tmp1);
	_tmp2 = NULL;
	self->priv->stream = (_tmp2 = fopen (filename, "w"), (self->priv->stream == NULL ? NULL : (self->priv->stream = (fclose (self->priv->stream), NULL))), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_interface_writer_write_string (self, (_tmp4 = g_strdup_printf ("/* %s generated by %s, do not modify. */", (_tmp3 = g_path_get_basename (filename)), g_get_prgname ())));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_interface_writer_write_newline (self);
	vala_interface_writer_write_newline (self);
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->priv->current_scope = (_tmp6 = (_tmp5 = vala_symbol_get_scope (((ValaSymbol*) (vala_code_context_get_root (context)))), (_tmp5 == NULL ? NULL : vala_scope_ref (_tmp5))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp6);
	vala_code_context_accept (context, ((ValaCodeVisitor*) (self)));
	_tmp7 = NULL;
	self->priv->current_scope = (_tmp7 = NULL, (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp7);
	_tmp8 = NULL;
	self->priv->stream = (_tmp8 = NULL, (self->priv->stream == NULL ? NULL : (self->priv->stream = (fclose (self->priv->stream), NULL))), _tmp8);
}


static void vala_interface_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaInterfaceWriter * self;
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaScope* _tmp4;
	ValaScope* _tmp3;
	GeeList* _tmp5;
	GeeList* _tmp6;
	GeeList* _tmp7;
	GeeList* _tmp8;
	GeeList* _tmp9;
	GeeList* _tmp10;
	GeeList* _tmp11;
	GeeList* _tmp12;
	GeeList* _tmp13;
	GeeList* _tmp14;
	ValaScope* _tmp16;
	ValaScope* _tmp15;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (ns != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (ns)))) {
		return;
	}
	if (vala_symbol_get_name (((ValaSymbol*) (ns))) == NULL) {
		vala_code_node_accept_children (((ValaCodeNode*) (ns)), ((ValaCodeVisitor*) (self)));
		return;
	}
	vala_interface_writer_write_indent (self);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_interface_writer_write_string (self, (_tmp2 = g_strdup_printf ("[CCode (cprefix = \"%s\", lower_case_cprefix = \"%s\")]", (_tmp0 = vala_symbol_get_cprefix (((ValaSymbol*) (ns)))), (_tmp1 = vala_symbol_get_lower_case_cprefix (((ValaSymbol*) (ns)))))));
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp0 = (g_free (_tmp0), NULL);
	vala_interface_writer_write_newline (self);
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_string (self, "namespace ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (ns))));
	vala_interface_writer_write_begin_block (self);
	_tmp4 = NULL;
	_tmp3 = NULL;
	self->priv->current_scope = (_tmp4 = (_tmp3 = vala_symbol_get_scope (((ValaSymbol*) (ns))), (_tmp3 == NULL ? NULL : vala_scope_ref (_tmp3))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp4);
	_tmp5 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp5 = vala_namespace_get_namespaces (ns)));
	(_tmp5 == NULL ? NULL : (_tmp5 = (gee_collection_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp6 = vala_namespace_get_classes (ns)));
	(_tmp6 == NULL ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp7 = vala_namespace_get_interfaces (ns)));
	(_tmp7 == NULL ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp8 = vala_namespace_get_structs (ns)));
	(_tmp8 == NULL ? NULL : (_tmp8 = (gee_collection_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp9 = vala_namespace_get_enums (ns)));
	(_tmp9 == NULL ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp10 = vala_namespace_get_error_types (ns)));
	(_tmp10 == NULL ? NULL : (_tmp10 = (gee_collection_object_unref (_tmp10), NULL)));
	_tmp11 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp11 = vala_namespace_get_delegates (ns)));
	(_tmp11 == NULL ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp12 = vala_namespace_get_fields (ns)));
	(_tmp12 == NULL ? NULL : (_tmp12 = (gee_collection_object_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp13 = vala_namespace_get_constants (ns)));
	(_tmp13 == NULL ? NULL : (_tmp13 = (gee_collection_object_unref (_tmp13), NULL)));
	_tmp14 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp14 = vala_namespace_get_methods (ns)));
	(_tmp14 == NULL ? NULL : (_tmp14 = (gee_collection_object_unref (_tmp14), NULL)));
	_tmp16 = NULL;
	_tmp15 = NULL;
	self->priv->current_scope = (_tmp16 = (_tmp15 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp15 == NULL ? NULL : vala_scope_ref (_tmp15))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp16);
	vala_interface_writer_write_end_block (self);
	vala_interface_writer_write_newline (self);
}


static void vala_interface_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaInterfaceWriter * self;
	char* _tmp22;
	char* _tmp21;
	gboolean _tmp23;
	char* _tmp29;
	char* _tmp28;
	char* _tmp27;
	gboolean _tmp30;
	gboolean first;
	char* cheaders;
	char* _tmp36;
	GeeList* type_params;
	GeeList* base_types;
	ValaScope* _tmp38;
	ValaScope* _tmp37;
	GeeList* _tmp39;
	GeeList* _tmp40;
	GeeList* _tmp41;
	GeeList* _tmp42;
	GeeList* _tmp43;
	GeeList* _tmp44;
	GeeList* _tmp45;
	GeeList* _tmp46;
	GeeList* _tmp47;
	ValaScope* _tmp49;
	ValaScope* _tmp48;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (cl != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (cl)))) {
		return;
	}
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (cl)))) {
		return;
	}
	if (vala_class_get_is_compact (cl)) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[Compact]");
		vala_interface_writer_write_newline (self);
	}
	if (vala_class_get_is_immutable (cl)) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[Immutable]");
		vala_interface_writer_write_newline (self);
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_string (self, "[CCode (");
	if (vala_typesymbol_is_reference_counting (((ValaTypeSymbol*) (cl)))) {
		char* _tmp2;
		char* _tmp1;
		char* _tmp0;
		gboolean _tmp3;
		char* _tmp8;
		char* _tmp7;
		char* _tmp6;
		gboolean _tmp9;
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp0 = NULL;
		if ((_tmp3 = vala_class_get_base_class (cl) == NULL || (_tmp0 = vala_typesymbol_get_ref_function (((ValaTypeSymbol*) (vala_class_get_base_class (cl))))) == NULL || _vala_strcmp0 ((_tmp1 = vala_typesymbol_get_ref_function (((ValaTypeSymbol*) (vala_class_get_base_class (cl))))), (_tmp2 = vala_typesymbol_get_ref_function (((ValaTypeSymbol*) (cl))))) != 0, (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3)) {
			char* _tmp5;
			char* _tmp4;
			_tmp5 = NULL;
			_tmp4 = NULL;
			vala_interface_writer_write_string (self, (_tmp5 = g_strdup_printf ("ref_function = \"%s\", ", (_tmp4 = vala_typesymbol_get_ref_function (((ValaTypeSymbol*) (cl)))))));
			_tmp5 = (g_free (_tmp5), NULL);
			_tmp4 = (g_free (_tmp4), NULL);
		}
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp6 = NULL;
		if ((_tmp9 = vala_class_get_base_class (cl) == NULL || (_tmp6 = vala_typesymbol_get_unref_function (((ValaTypeSymbol*) (vala_class_get_base_class (cl))))) == NULL || _vala_strcmp0 ((_tmp7 = vala_typesymbol_get_unref_function (((ValaTypeSymbol*) (vala_class_get_base_class (cl))))), (_tmp8 = vala_typesymbol_get_unref_function (((ValaTypeSymbol*) (cl))))) != 0, (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), (_tmp6 = (g_free (_tmp6), NULL)), _tmp9)) {
			char* _tmp11;
			char* _tmp10;
			_tmp11 = NULL;
			_tmp10 = NULL;
			vala_interface_writer_write_string (self, (_tmp11 = g_strdup_printf ("unref_function = \"%s\", ", (_tmp10 = vala_typesymbol_get_unref_function (((ValaTypeSymbol*) (cl)))))));
			_tmp11 = (g_free (_tmp11), NULL);
			_tmp10 = (g_free (_tmp10), NULL);
		}
	} else {
		char* _tmp12;
		gboolean _tmp13;
		char* _tmp17;
		char* _tmp16;
		gboolean _tmp18;
		_tmp12 = NULL;
		if ((_tmp13 = (_tmp12 = vala_typesymbol_get_dup_function (((ValaTypeSymbol*) (cl)))) != NULL, (_tmp12 = (g_free (_tmp12), NULL)), _tmp13)) {
			char* _tmp15;
			char* _tmp14;
			_tmp15 = NULL;
			_tmp14 = NULL;
			vala_interface_writer_write_string (self, (_tmp15 = g_strdup_printf ("copy_function = \"%s\", ", (_tmp14 = vala_typesymbol_get_dup_function (((ValaTypeSymbol*) (cl)))))));
			_tmp15 = (g_free (_tmp15), NULL);
			_tmp14 = (g_free (_tmp14), NULL);
		}
		_tmp17 = NULL;
		_tmp16 = NULL;
		if ((_tmp18 = _vala_strcmp0 ((_tmp16 = vala_typesymbol_get_free_function (((ValaTypeSymbol*) (cl)))), (_tmp17 = vala_class_get_default_free_function (cl))) != 0, (_tmp17 = (g_free (_tmp17), NULL)), (_tmp16 = (g_free (_tmp16), NULL)), _tmp18)) {
			char* _tmp20;
			char* _tmp19;
			_tmp20 = NULL;
			_tmp19 = NULL;
			vala_interface_writer_write_string (self, (_tmp20 = g_strdup_printf ("free_function = \"%s\", ", (_tmp19 = vala_typesymbol_get_free_function (((ValaTypeSymbol*) (cl)))))));
			_tmp20 = (g_free (_tmp20), NULL);
			_tmp19 = (g_free (_tmp19), NULL);
		}
	}
	_tmp22 = NULL;
	_tmp21 = NULL;
	if ((_tmp23 = _vala_strcmp0 ((_tmp21 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)), (_tmp22 = vala_class_get_default_cname (cl))) != 0, (_tmp22 = (g_free (_tmp22), NULL)), (_tmp21 = (g_free (_tmp21), NULL)), _tmp23)) {
		char* _tmp25;
		char* _tmp24;
		_tmp25 = NULL;
		_tmp24 = NULL;
		vala_interface_writer_write_string (self, (_tmp25 = g_strdup_printf ("cname = \"%s\", ", (_tmp24 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)))));
		_tmp25 = (g_free (_tmp25), NULL);
		_tmp24 = (g_free (_tmp24), NULL);
	}
	if (vala_class_get_type_check_function (cl) != NULL) {
		char* _tmp26;
		_tmp26 = NULL;
		vala_interface_writer_write_string (self, (_tmp26 = g_strdup_printf ("type_check_function = \"%s\", ", vala_class_get_type_check_function (cl))));
		_tmp26 = (g_free (_tmp26), NULL);
	}
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	if ((_tmp30 = (_tmp27 = vala_typesymbol_get_param_spec_function (((ValaTypeSymbol*) (cl)))) != NULL && (vala_class_get_base_class (cl) == NULL || _vala_strcmp0 ((_tmp28 = vala_typesymbol_get_param_spec_function (((ValaTypeSymbol*) (cl)))), (_tmp29 = vala_typesymbol_get_param_spec_function (((ValaTypeSymbol*) (vala_class_get_base_class (cl)))))) != 0), (_tmp29 = (g_free (_tmp29), NULL)), (_tmp28 = (g_free (_tmp28), NULL)), (_tmp27 = (g_free (_tmp27), NULL)), _tmp30)) {
		char* _tmp32;
		char* _tmp31;
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_interface_writer_write_string (self, (_tmp32 = g_strdup_printf ("param_spec_function = \"%s\", ", (_tmp31 = vala_typesymbol_get_param_spec_function (((ValaTypeSymbol*) (cl)))))));
		_tmp32 = (g_free (_tmp32), NULL);
		_tmp31 = (g_free (_tmp31), NULL);
	}
	first = TRUE;
	cheaders = NULL;
	{
		GeeList* cheader_collection;
		int cheader_it;
		cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (cl)));
		for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
			char* cheader;
			cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
			{
				if (first) {
					char* _tmp34;
					const char* _tmp33;
					_tmp34 = NULL;
					_tmp33 = NULL;
					cheaders = (_tmp34 = (_tmp33 = cheader, (_tmp33 == NULL ? NULL : g_strdup (_tmp33))), (cheaders = (g_free (cheaders), NULL)), _tmp34);
					first = FALSE;
				} else {
					char* _tmp35;
					_tmp35 = NULL;
					cheaders = (_tmp35 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp35);
				}
				cheader = (g_free (cheader), NULL);
			}
		}
		(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
	}
	_tmp36 = NULL;
	vala_interface_writer_write_string (self, (_tmp36 = g_strdup_printf ("cheader_filename = \"%s\")]", cheaders)));
	_tmp36 = (g_free (_tmp36), NULL);
	vala_interface_writer_write_newline (self);
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (cl)));
	if (vala_class_get_is_abstract (cl)) {
		vala_interface_writer_write_string (self, "abstract ");
	}
	vala_interface_writer_write_string (self, "class ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (cl))));
	type_params = vala_class_get_type_parameters (cl);
	if (gee_collection_get_size (((GeeCollection*) (type_params))) > 0) {
		gboolean first;
		vala_interface_writer_write_string (self, "<");
		first = TRUE;
		{
			GeeList* type_param_collection;
			int type_param_it;
			type_param_collection = type_params;
			for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
				{
					if (first) {
						first = FALSE;
					} else {
						vala_interface_writer_write_string (self, ",");
					}
					vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (type_param))));
					(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
				}
			}
		}
		vala_interface_writer_write_string (self, ">");
	}
	base_types = vala_class_get_base_types (cl);
	if (gee_collection_get_size (((GeeCollection*) (base_types))) > 0) {
		gboolean first;
		vala_interface_writer_write_string (self, " : ");
		first = TRUE;
		{
			GeeList* base_type_collection;
			int base_type_it;
			base_type_collection = base_types;
			for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
				ValaDataType* base_type;
				base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
				{
					if (!first) {
						vala_interface_writer_write_string (self, ", ");
					} else {
						first = FALSE;
					}
					vala_interface_writer_write_type (self, base_type);
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				}
			}
		}
	}
	vala_interface_writer_write_begin_block (self);
	_tmp38 = NULL;
	_tmp37 = NULL;
	self->priv->current_scope = (_tmp38 = (_tmp37 = vala_symbol_get_scope (((ValaSymbol*) (cl))), (_tmp37 == NULL ? NULL : vala_scope_ref (_tmp37))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp38);
	_tmp39 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp39 = vala_class_get_classes (cl)));
	(_tmp39 == NULL ? NULL : (_tmp39 = (gee_collection_object_unref (_tmp39), NULL)));
	_tmp40 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp40 = vala_class_get_structs (cl)));
	(_tmp40 == NULL ? NULL : (_tmp40 = (gee_collection_object_unref (_tmp40), NULL)));
	_tmp41 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp41 = vala_class_get_enums (cl)));
	(_tmp41 == NULL ? NULL : (_tmp41 = (gee_collection_object_unref (_tmp41), NULL)));
	_tmp42 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp42 = vala_class_get_delegates (cl)));
	(_tmp42 == NULL ? NULL : (_tmp42 = (gee_collection_object_unref (_tmp42), NULL)));
	_tmp43 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp43 = vala_class_get_fields (cl)));
	(_tmp43 == NULL ? NULL : (_tmp43 = (gee_collection_object_unref (_tmp43), NULL)));
	_tmp44 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp44 = vala_class_get_constants (cl)));
	(_tmp44 == NULL ? NULL : (_tmp44 = (gee_collection_object_unref (_tmp44), NULL)));
	_tmp45 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp45 = vala_object_type_symbol_get_methods (((ValaObjectTypeSymbol*) (cl)))));
	(_tmp45 == NULL ? NULL : (_tmp45 = (gee_collection_object_unref (_tmp45), NULL)));
	_tmp46 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp46 = vala_object_type_symbol_get_properties (((ValaObjectTypeSymbol*) (cl)))));
	(_tmp46 == NULL ? NULL : (_tmp46 = (gee_collection_object_unref (_tmp46), NULL)));
	_tmp47 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp47 = vala_object_type_symbol_get_signals (((ValaObjectTypeSymbol*) (cl)))));
	(_tmp47 == NULL ? NULL : (_tmp47 = (gee_collection_object_unref (_tmp47), NULL)));
	_tmp49 = NULL;
	_tmp48 = NULL;
	self->priv->current_scope = (_tmp49 = (_tmp48 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp48 == NULL ? NULL : vala_scope_ref (_tmp48))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp49);
	vala_interface_writer_write_end_block (self);
	vala_interface_writer_write_newline (self);
	cheaders = (g_free (cheaders), NULL);
	(type_params == NULL ? NULL : (type_params = (gee_collection_object_unref (type_params), NULL)));
	(base_types == NULL ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL)));
}


static void vala_interface_writer_visit_sorted (ValaInterfaceWriter* self, GeeList* symbols) {
	GeeArrayList* sorted_symbols;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	sorted_symbols = gee_array_list_new (VALA_TYPE_SYMBOL, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal);
	{
		GeeList* sym_collection;
		int sym_it;
		sym_collection = symbols;
		for (sym_it = 0; sym_it < gee_collection_get_size (GEE_COLLECTION (sym_collection)); sym_it = sym_it + 1) {
			ValaSymbol* sym;
			sym = ((ValaSymbol*) (gee_list_get (GEE_LIST (sym_collection), sym_it)));
			{
				gint left;
				gint right;
				ValaSymbol* _tmp0;
				gboolean _tmp1;
				left = 0;
				right = gee_collection_get_size (((GeeCollection*) (sorted_symbols))) - 1;
				_tmp0 = NULL;
				if ((_tmp1 = left > right || _vala_strcmp0 (vala_symbol_get_name (sym), vala_symbol_get_name ((_tmp0 = ((ValaSymbol*) (gee_list_get (((GeeList*) (sorted_symbols)), left)))))) < 0, (_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL))), _tmp1)) {
					gee_list_insert (((GeeList*) (sorted_symbols)), 0, sym);
				} else {
					ValaSymbol* _tmp2;
					gboolean _tmp3;
					_tmp2 = NULL;
					if ((_tmp3 = _vala_strcmp0 (vala_symbol_get_name (sym), vala_symbol_get_name ((_tmp2 = ((ValaSymbol*) (gee_list_get (((GeeList*) (sorted_symbols)), right)))))) > 0, (_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL))), _tmp3)) {
						gee_collection_add (((GeeCollection*) (sorted_symbols)), sym);
					} else {
						while (right - left > 1) {
							gint i;
							ValaSymbol* _tmp4;
							gboolean _tmp5;
							i = (right + left) / 2;
							_tmp4 = NULL;
							if ((_tmp5 = _vala_strcmp0 (vala_symbol_get_name (sym), vala_symbol_get_name ((_tmp4 = ((ValaSymbol*) (gee_list_get (((GeeList*) (sorted_symbols)), i)))))) > 0, (_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL))), _tmp5)) {
								left = i;
							} else {
								right = i;
							}
						}
						gee_list_insert (((GeeList*) (sorted_symbols)), left + 1, sym);
					}
				}
				(sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL)));
			}
		}
	}
	{
		GeeArrayList* sym_collection;
		int sym_it;
		sym_collection = sorted_symbols;
		for (sym_it = 0; sym_it < gee_collection_get_size (GEE_COLLECTION (sym_collection)); sym_it = sym_it + 1) {
			ValaSymbol* sym;
			sym = ((ValaSymbol*) (gee_list_get (GEE_LIST (sym_collection), sym_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (sym)), ((ValaCodeVisitor*) (self)));
				(sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL)));
			}
		}
	}
	(sorted_symbols == NULL ? NULL : (sorted_symbols = (gee_collection_object_unref (sorted_symbols), NULL)));
}


static void vala_interface_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaInterfaceWriter * self;
	char* _tmp1;
	char* _tmp0;
	gboolean _tmp2;
	char* _tmp5;
	gboolean _tmp6;
	gboolean first;
	char* cheaders;
	char* _tmp12;
	GeeList* base_types;
	ValaScope* _tmp16;
	ValaScope* _tmp15;
	GeeList* _tmp17;
	GeeList* _tmp18;
	ValaScope* _tmp20;
	ValaScope* _tmp19;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (st != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (st)))) {
		return;
	}
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (st)))) {
		return;
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_string (self, "[CCode (");
	_tmp1 = NULL;
	_tmp0 = NULL;
	if ((_tmp2 = _vala_strcmp0 ((_tmp0 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (st)), FALSE)), (_tmp1 = vala_struct_get_default_cname (st))) != 0, (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2)) {
		char* _tmp4;
		char* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_interface_writer_write_string (self, (_tmp4 = g_strdup_printf ("cname = \"%s\", ", (_tmp3 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (st)), FALSE)))));
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp3 = (g_free (_tmp3), NULL);
	}
	_tmp5 = NULL;
	if ((_tmp6 = !vala_struct_is_simple_type (st) && _vala_strcmp0 ((_tmp5 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (st)))), "G_TYPE_POINTER") != 0, (_tmp5 = (g_free (_tmp5), NULL)), _tmp6)) {
		char* _tmp8;
		char* _tmp7;
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_interface_writer_write_string (self, (_tmp8 = g_strdup_printf ("type_id = \"%s\", ", (_tmp7 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (st)))))));
		_tmp8 = (g_free (_tmp8), NULL);
		_tmp7 = (g_free (_tmp7), NULL);
	}
	first = TRUE;
	cheaders = NULL;
	{
		GeeList* cheader_collection;
		int cheader_it;
		cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (st)));
		for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
			char* cheader;
			cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
			{
				if (first) {
					char* _tmp10;
					const char* _tmp9;
					_tmp10 = NULL;
					_tmp9 = NULL;
					cheaders = (_tmp10 = (_tmp9 = cheader, (_tmp9 == NULL ? NULL : g_strdup (_tmp9))), (cheaders = (g_free (cheaders), NULL)), _tmp10);
					first = FALSE;
				} else {
					char* _tmp11;
					_tmp11 = NULL;
					cheaders = (_tmp11 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp11);
				}
				cheader = (g_free (cheader), NULL);
			}
		}
		(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
	}
	_tmp12 = NULL;
	vala_interface_writer_write_string (self, (_tmp12 = g_strdup_printf ("cheader_filename = \"%s\")]", cheaders)));
	_tmp12 = (g_free (_tmp12), NULL);
	vala_interface_writer_write_newline (self);
	if (vala_struct_is_simple_type (st)) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[SimpleType]");
		vala_interface_writer_write_newline (self);
	}
	if (vala_struct_is_integer_type (st)) {
		char* _tmp13;
		vala_interface_writer_write_indent (self);
		_tmp13 = NULL;
		vala_interface_writer_write_string (self, (_tmp13 = g_strdup_printf ("[IntegerType (rank = %d)]", vala_struct_get_rank (st))));
		_tmp13 = (g_free (_tmp13), NULL);
		vala_interface_writer_write_newline (self);
	}
	if (vala_struct_is_floating_type (st)) {
		char* _tmp14;
		vala_interface_writer_write_indent (self);
		_tmp14 = NULL;
		vala_interface_writer_write_string (self, (_tmp14 = g_strdup_printf ("[FloatingType (rank = %d)]", vala_struct_get_rank (st))));
		_tmp14 = (g_free (_tmp14), NULL);
		vala_interface_writer_write_newline (self);
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (st)));
	vala_interface_writer_write_string (self, "struct ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (st))));
	base_types = vala_struct_get_base_types (st);
	if (gee_collection_get_size (((GeeCollection*) (base_types))) > 0) {
		gboolean first;
		vala_interface_writer_write_string (self, " : ");
		first = TRUE;
		{
			GeeList* base_type_collection;
			int base_type_it;
			base_type_collection = base_types;
			for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
				ValaDataType* base_type;
				base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
				{
					if (!first) {
						vala_interface_writer_write_string (self, ", ");
					} else {
						first = FALSE;
					}
					vala_interface_writer_write_type (self, base_type);
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				}
			}
		}
	}
	vala_interface_writer_write_begin_block (self);
	_tmp16 = NULL;
	_tmp15 = NULL;
	self->priv->current_scope = (_tmp16 = (_tmp15 = vala_symbol_get_scope (((ValaSymbol*) (st))), (_tmp15 == NULL ? NULL : vala_scope_ref (_tmp15))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp16);
	{
		GeeList* field_collection;
		int field_it;
		field_collection = vala_struct_get_fields (st);
		for (field_it = 0; field_it < gee_collection_get_size (GEE_COLLECTION (field_collection)); field_it = field_it + 1) {
			ValaField* field;
			field = ((ValaField*) (gee_list_get (GEE_LIST (field_collection), field_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (field)), ((ValaCodeVisitor*) (self)));
				(field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL)));
			}
		}
		(field_collection == NULL ? NULL : (field_collection = (gee_collection_object_unref (field_collection), NULL)));
	}
	_tmp17 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp17 = vala_struct_get_constants (st)));
	(_tmp17 == NULL ? NULL : (_tmp17 = (gee_collection_object_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp18 = vala_struct_get_methods (st)));
	(_tmp18 == NULL ? NULL : (_tmp18 = (gee_collection_object_unref (_tmp18), NULL)));
	_tmp20 = NULL;
	_tmp19 = NULL;
	self->priv->current_scope = (_tmp20 = (_tmp19 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp19 == NULL ? NULL : vala_scope_ref (_tmp19))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp20);
	vala_interface_writer_write_end_block (self);
	vala_interface_writer_write_newline (self);
	cheaders = (g_free (cheaders), NULL);
	(base_types == NULL ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL)));
}


static void vala_interface_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaInterfaceWriter * self;
	gboolean first;
	char* cheaders;
	char* _tmp3;
	char* _tmp5;
	char* _tmp4;
	gboolean _tmp6;
	GeeList* type_params;
	GeeList* prerequisites;
	ValaScope* _tmp10;
	ValaScope* _tmp9;
	GeeList* _tmp11;
	GeeList* _tmp12;
	GeeList* _tmp13;
	GeeList* _tmp14;
	GeeList* _tmp15;
	GeeList* _tmp16;
	GeeList* _tmp17;
	GeeList* _tmp18;
	ValaScope* _tmp20;
	ValaScope* _tmp19;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (iface != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (iface)))) {
		return;
	}
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (iface)))) {
		return;
	}
	vala_interface_writer_write_indent (self);
	first = TRUE;
	cheaders = NULL;
	{
		GeeList* cheader_collection;
		int cheader_it;
		cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (iface)));
		for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
			char* cheader;
			cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
			{
				if (first) {
					char* _tmp1;
					const char* _tmp0;
					_tmp1 = NULL;
					_tmp0 = NULL;
					cheaders = (_tmp1 = (_tmp0 = cheader, (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (cheaders = (g_free (cheaders), NULL)), _tmp1);
					first = FALSE;
				} else {
					char* _tmp2;
					_tmp2 = NULL;
					cheaders = (_tmp2 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp2);
				}
				cheader = (g_free (cheader), NULL);
			}
		}
		(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
	}
	_tmp3 = NULL;
	vala_interface_writer_write_string (self, (_tmp3 = g_strdup_printf ("[CCode (cheader_filename = \"%s\"", cheaders)));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp5 = NULL;
	_tmp4 = NULL;
	if ((_tmp6 = _vala_strcmp0 ((_tmp4 = vala_interface_get_lower_case_csuffix (iface)), (_tmp5 = vala_interface_get_default_lower_case_csuffix (iface))) != 0, (_tmp5 = (g_free (_tmp5), NULL)), (_tmp4 = (g_free (_tmp4), NULL)), _tmp6)) {
		char* _tmp8;
		char* _tmp7;
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_interface_writer_write_string (self, (_tmp8 = g_strdup_printf (", lower_case_csuffix = \"%s\"", (_tmp7 = vala_interface_get_lower_case_csuffix (iface)))));
		_tmp8 = (g_free (_tmp8), NULL);
		_tmp7 = (g_free (_tmp7), NULL);
	}
	vala_interface_writer_write_string (self, ")]");
	vala_interface_writer_write_newline (self);
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (iface)));
	vala_interface_writer_write_string (self, "interface ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (iface))));
	type_params = vala_interface_get_type_parameters (iface);
	if (gee_collection_get_size (((GeeCollection*) (type_params))) > 0) {
		gboolean first;
		vala_interface_writer_write_string (self, "<");
		first = TRUE;
		{
			GeeList* type_param_collection;
			int type_param_it;
			type_param_collection = type_params;
			for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
				{
					if (first) {
						first = FALSE;
					} else {
						vala_interface_writer_write_string (self, ",");
					}
					vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (type_param))));
					(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
				}
			}
		}
		vala_interface_writer_write_string (self, ">");
	}
	prerequisites = vala_interface_get_prerequisites (iface);
	if (gee_collection_get_size (((GeeCollection*) (prerequisites))) > 0) {
		gboolean first;
		vala_interface_writer_write_string (self, " : ");
		first = TRUE;
		{
			GeeList* prerequisite_collection;
			int prerequisite_it;
			prerequisite_collection = prerequisites;
			for (prerequisite_it = 0; prerequisite_it < gee_collection_get_size (GEE_COLLECTION (prerequisite_collection)); prerequisite_it = prerequisite_it + 1) {
				ValaDataType* prerequisite;
				prerequisite = ((ValaDataType*) (gee_list_get (GEE_LIST (prerequisite_collection), prerequisite_it)));
				{
					if (!first) {
						vala_interface_writer_write_string (self, ", ");
					} else {
						first = FALSE;
					}
					vala_interface_writer_write_type (self, prerequisite);
					(prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)));
				}
			}
		}
	}
	vala_interface_writer_write_begin_block (self);
	_tmp10 = NULL;
	_tmp9 = NULL;
	self->priv->current_scope = (_tmp10 = (_tmp9 = vala_symbol_get_scope (((ValaSymbol*) (iface))), (_tmp9 == NULL ? NULL : vala_scope_ref (_tmp9))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp10);
	_tmp11 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp11 = vala_interface_get_classes (iface)));
	(_tmp11 == NULL ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp12 = vala_interface_get_structs (iface)));
	(_tmp12 == NULL ? NULL : (_tmp12 = (gee_collection_object_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp13 = vala_interface_get_enums (iface)));
	(_tmp13 == NULL ? NULL : (_tmp13 = (gee_collection_object_unref (_tmp13), NULL)));
	_tmp14 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp14 = vala_interface_get_delegates (iface)));
	(_tmp14 == NULL ? NULL : (_tmp14 = (gee_collection_object_unref (_tmp14), NULL)));
	_tmp15 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp15 = vala_interface_get_fields (iface)));
	(_tmp15 == NULL ? NULL : (_tmp15 = (gee_collection_object_unref (_tmp15), NULL)));
	_tmp16 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp16 = vala_object_type_symbol_get_methods (((ValaObjectTypeSymbol*) (iface)))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (gee_collection_object_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp17 = vala_object_type_symbol_get_properties (((ValaObjectTypeSymbol*) (iface)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (gee_collection_object_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	vala_interface_writer_visit_sorted (self, (_tmp18 = vala_object_type_symbol_get_signals (((ValaObjectTypeSymbol*) (iface)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (gee_collection_object_unref (_tmp18), NULL)));
	_tmp20 = NULL;
	_tmp19 = NULL;
	self->priv->current_scope = (_tmp20 = (_tmp19 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp19 == NULL ? NULL : vala_scope_ref (_tmp19))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp20);
	vala_interface_writer_write_end_block (self);
	vala_interface_writer_write_newline (self);
	cheaders = (g_free (cheaders), NULL);
	(type_params == NULL ? NULL : (type_params = (gee_collection_object_unref (type_params), NULL)));
	(prerequisites == NULL ? NULL : (prerequisites = (gee_collection_object_unref (prerequisites), NULL)));
}


static void vala_interface_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaInterfaceWriter * self;
	gboolean first;
	char* cheaders;
	char* _tmp4;
	char* _tmp3;
	char* _tmp6;
	ValaScope* _tmp15;
	ValaScope* _tmp14;
	ValaScope* _tmp17;
	ValaScope* _tmp16;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (en != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (en)))) {
		return;
	}
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (en)))) {
		return;
	}
	vala_interface_writer_write_indent (self);
	first = TRUE;
	cheaders = NULL;
	{
		GeeList* cheader_collection;
		int cheader_it;
		cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (en)));
		for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
			char* cheader;
			cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
			{
				if (first) {
					char* _tmp1;
					const char* _tmp0;
					_tmp1 = NULL;
					_tmp0 = NULL;
					cheaders = (_tmp1 = (_tmp0 = cheader, (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (cheaders = (g_free (cheaders), NULL)), _tmp1);
					first = FALSE;
				} else {
					char* _tmp2;
					_tmp2 = NULL;
					cheaders = (_tmp2 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp2);
				}
				cheader = (g_free (cheader), NULL);
			}
		}
		(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_interface_writer_write_string (self, (_tmp4 = g_strdup_printf ("[CCode (cprefix = \"%s\", ", (_tmp3 = vala_enum_get_cprefix (en)))));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	if (!vala_enum_get_has_type_id (en)) {
		char* _tmp5;
		_tmp5 = NULL;
		vala_interface_writer_write_string (self, (_tmp5 = g_strdup_printf ("has_type_id = \"%d\", ", (vala_enum_get_has_type_id (en) ? 1 : 0))));
		_tmp5 = (g_free (_tmp5), NULL);
	}
	_tmp6 = NULL;
	vala_interface_writer_write_string (self, (_tmp6 = g_strdup_printf ("cheader_filename = \"%s\")]", cheaders)));
	_tmp6 = (g_free (_tmp6), NULL);
	if (vala_enum_get_is_flags (en)) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[Flags]");
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (en)));
	vala_interface_writer_write_string (self, "enum ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (en))));
	vala_interface_writer_write_begin_block (self);
	first = TRUE;
	{
		GeeList* ev_collection;
		int ev_it;
		ev_collection = vala_enum_get_values (en);
		for (ev_it = 0; ev_it < gee_collection_get_size (GEE_COLLECTION (ev_collection)); ev_it = ev_it + 1) {
			ValaEnumValue* ev;
			ev = ((ValaEnumValue*) (gee_list_get (GEE_LIST (ev_collection), ev_it)));
			{
				char* _tmp8;
				char* _tmp7;
				gboolean _tmp9;
				if (first) {
					first = FALSE;
				} else {
					vala_interface_writer_write_string (self, ",");
					vala_interface_writer_write_newline (self);
				}
				_tmp8 = NULL;
				_tmp7 = NULL;
				if ((_tmp9 = _vala_strcmp0 ((_tmp7 = vala_enum_value_get_cname (ev)), (_tmp8 = vala_enum_value_get_default_cname (ev))) != 0, (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9)) {
					char* _tmp11;
					char* _tmp10;
					vala_interface_writer_write_indent (self);
					_tmp11 = NULL;
					_tmp10 = NULL;
					vala_interface_writer_write_string (self, (_tmp11 = g_strdup_printf ("[CCode (cname = \"%s\")]", (_tmp10 = vala_enum_value_get_cname (ev)))));
					_tmp11 = (g_free (_tmp11), NULL);
					_tmp10 = (g_free (_tmp10), NULL);
				}
				vala_interface_writer_write_indent (self);
				vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (ev))));
				(ev == NULL ? NULL : (ev = (vala_code_node_unref (ev), NULL)));
			}
		}
		(ev_collection == NULL ? NULL : (ev_collection = (gee_collection_object_unref (ev_collection), NULL)));
	}
	if (!first) {
		GeeList* _tmp12;
		gboolean _tmp13;
		_tmp12 = NULL;
		if ((_tmp13 = gee_collection_get_size (((GeeCollection*) ((_tmp12 = vala_enum_get_methods (en))))) > 0, (_tmp12 == NULL ? NULL : (_tmp12 = (gee_collection_object_unref (_tmp12), NULL))), _tmp13)) {
			vala_interface_writer_write_string (self, ";");
		}
		vala_interface_writer_write_newline (self);
	}
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->priv->current_scope = (_tmp15 = (_tmp14 = vala_symbol_get_scope (((ValaSymbol*) (en))), (_tmp14 == NULL ? NULL : vala_scope_ref (_tmp14))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp15);
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_enum_get_methods (en);
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (m)), ((ValaCodeVisitor*) (self)));
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (gee_collection_object_unref (m_collection), NULL)));
	}
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->priv->current_scope = (_tmp17 = (_tmp16 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp16 == NULL ? NULL : vala_scope_ref (_tmp16))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL))), _tmp17);
	vala_interface_writer_write_end_block (self);
	vala_interface_writer_write_newline (self);
	cheaders = (g_free (cheaders), NULL);
}


static void vala_interface_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaInterfaceWriter * self;
	gboolean first;
	char* cheaders;
	char* _tmp4;
	char* _tmp3;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (edomain != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (edomain)))) {
		return;
	}
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (edomain)))) {
		return;
	}
	vala_interface_writer_write_indent (self);
	first = TRUE;
	cheaders = NULL;
	{
		GeeList* cheader_collection;
		int cheader_it;
		cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (edomain)));
		for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
			char* cheader;
			cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
			{
				if (first) {
					char* _tmp1;
					const char* _tmp0;
					_tmp1 = NULL;
					_tmp0 = NULL;
					cheaders = (_tmp1 = (_tmp0 = cheader, (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (cheaders = (g_free (cheaders), NULL)), _tmp1);
					first = FALSE;
				} else {
					char* _tmp2;
					_tmp2 = NULL;
					cheaders = (_tmp2 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp2);
				}
				cheader = (g_free (cheader), NULL);
			}
		}
		(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_interface_writer_write_string (self, (_tmp4 = g_strdup_printf ("[CCode (cprefix = \"%s\", cheader_filename = \"%s\")]", (_tmp3 = vala_error_domain_get_cprefix (edomain)), cheaders)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (edomain)));
	vala_interface_writer_write_string (self, "errordomain ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (edomain))));
	vala_interface_writer_write_begin_block (self);
	vala_code_node_accept_children (((ValaCodeNode*) (edomain)), ((ValaCodeVisitor*) (self)));
	vala_interface_writer_write_end_block (self);
	vala_interface_writer_write_newline (self);
	cheaders = (g_free (cheaders), NULL);
}


static void vala_interface_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaInterfaceWriter * self;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (ecode != NULL);
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (ecode))));
	vala_interface_writer_write_string (self, ",");
	vala_interface_writer_write_newline (self);
}


static void vala_interface_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaInterfaceWriter * self;
	char* _tmp1;
	char* _tmp0;
	gboolean _tmp2;
	gboolean custom_cname;
	gboolean custom_cheaders;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (c != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (c)))) {
		return;
	}
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (c)))) {
		return;
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	custom_cname = (_tmp2 = (_vala_strcmp0 ((_tmp0 = vala_constant_get_cname (c)), (_tmp1 = vala_constant_get_default_cname (c))) != 0), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	custom_cheaders = (VALA_IS_NAMESPACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (c)))));
	if (custom_cname || custom_cheaders) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[CCode (");
		if (custom_cname) {
			char* _tmp4;
			char* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			vala_interface_writer_write_string (self, (_tmp4 = g_strdup_printf ("cname = \"%s\"", (_tmp3 = vala_constant_get_cname (c)))));
			_tmp4 = (g_free (_tmp4), NULL);
			_tmp3 = (g_free (_tmp3), NULL);
		}
		if (custom_cheaders) {
			gboolean first;
			char* cheaders;
			char* _tmp8;
			if (custom_cname) {
				vala_interface_writer_write_string (self, ", ");
			}
			first = TRUE;
			cheaders = NULL;
			{
				GeeList* cheader_collection;
				int cheader_it;
				cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (c)));
				for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
					char* cheader;
					cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
					{
						if (first) {
							char* _tmp6;
							const char* _tmp5;
							_tmp6 = NULL;
							_tmp5 = NULL;
							cheaders = (_tmp6 = (_tmp5 = cheader, (_tmp5 == NULL ? NULL : g_strdup (_tmp5))), (cheaders = (g_free (cheaders), NULL)), _tmp6);
							first = FALSE;
						} else {
							char* _tmp7;
							_tmp7 = NULL;
							cheaders = (_tmp7 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp7);
						}
						cheader = (g_free (cheader), NULL);
					}
				}
				(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
			}
			_tmp8 = NULL;
			vala_interface_writer_write_string (self, (_tmp8 = g_strdup_printf ("cheader_filename = \"%s\"", cheaders)));
			_tmp8 = (g_free (_tmp8), NULL);
			cheaders = (g_free (cheaders), NULL);
		}
		vala_interface_writer_write_string (self, ")]");
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (c)));
	vala_interface_writer_write_string (self, "const ");
	vala_interface_writer_write_type (self, vala_constant_get_type_reference (c));
	vala_interface_writer_write_string (self, " ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (c))));
	vala_interface_writer_write_string (self, ";");
	vala_interface_writer_write_newline (self);
}


static void vala_interface_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaInterfaceWriter * self;
	char* _tmp1;
	char* _tmp0;
	gboolean _tmp2;
	gboolean custom_cname;
	char* _tmp3;
	gboolean _tmp4;
	gboolean custom_ctype;
	gboolean custom_cheaders;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (f != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (f)))) {
		return;
	}
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (f)))) {
		return;
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	custom_cname = (_tmp2 = (_vala_strcmp0 ((_tmp0 = vala_field_get_cname (f)), (_tmp1 = vala_field_get_default_cname (f))) != 0), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp3 = NULL;
	custom_ctype = (_tmp4 = ((_tmp3 = vala_field_get_ctype (f)) != NULL), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
	custom_cheaders = (VALA_IS_NAMESPACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (f)))));
	if (custom_cname || custom_ctype || custom_cheaders) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[CCode (");
		if (custom_cname) {
			char* _tmp6;
			char* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_interface_writer_write_string (self, (_tmp6 = g_strdup_printf ("cname = \"%s\"", (_tmp5 = vala_field_get_cname (f)))));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
		}
		if (custom_ctype) {
			char* _tmp8;
			char* _tmp7;
			if (custom_cname) {
				vala_interface_writer_write_string (self, ", ");
			}
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_interface_writer_write_string (self, (_tmp8 = g_strdup_printf ("type = \"%s\"", (_tmp7 = vala_field_get_ctype (f)))));
			_tmp8 = (g_free (_tmp8), NULL);
			_tmp7 = (g_free (_tmp7), NULL);
		}
		if (custom_cheaders) {
			gboolean first;
			char* cheaders;
			char* _tmp12;
			if (custom_cname || custom_ctype) {
				vala_interface_writer_write_string (self, ", ");
			}
			first = TRUE;
			cheaders = NULL;
			{
				GeeList* cheader_collection;
				int cheader_it;
				cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (f)));
				for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
					char* cheader;
					cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
					{
						if (first) {
							char* _tmp10;
							const char* _tmp9;
							_tmp10 = NULL;
							_tmp9 = NULL;
							cheaders = (_tmp10 = (_tmp9 = cheader, (_tmp9 == NULL ? NULL : g_strdup (_tmp9))), (cheaders = (g_free (cheaders), NULL)), _tmp10);
							first = FALSE;
						} else {
							char* _tmp11;
							_tmp11 = NULL;
							cheaders = (_tmp11 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp11);
						}
						cheader = (g_free (cheader), NULL);
					}
				}
				(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
			}
			_tmp12 = NULL;
			vala_interface_writer_write_string (self, (_tmp12 = g_strdup_printf ("cheader_filename = \"%s\"", cheaders)));
			_tmp12 = (g_free (_tmp12), NULL);
			cheaders = (g_free (cheaders), NULL);
		}
		vala_interface_writer_write_string (self, ")]");
	}
	if (vala_field_get_no_array_length (f) && VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[NoArrayLength]");
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (f)));
	if (vala_field_get_binding (f) == MEMBER_BINDING_STATIC) {
		vala_interface_writer_write_string (self, "static ");
	} else {
		if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
			vala_interface_writer_write_string (self, "class ");
		}
	}
	if (vala_interface_writer_is_weak (self, vala_field_get_field_type (f))) {
		vala_interface_writer_write_string (self, "weak ");
	}
	vala_interface_writer_write_type (self, vala_field_get_field_type (f));
	vala_interface_writer_write_string (self, " ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (f))));
	vala_interface_writer_write_string (self, ";");
	vala_interface_writer_write_newline (self);
}


static void vala_interface_writer_write_error_domains (ValaInterfaceWriter* self, GeeList* error_domains) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_domains != NULL);
	if (gee_collection_get_size (((GeeCollection*) (error_domains))) > 0) {
		gboolean first;
		vala_interface_writer_write_string (self, " throws ");
		first = TRUE;
		{
			GeeList* type_collection;
			int type_it;
			type_collection = error_domains;
			for (type_it = 0; type_it < gee_collection_get_size (GEE_COLLECTION (type_collection)); type_it = type_it + 1) {
				ValaDataType* type;
				type = ((ValaDataType*) (gee_list_get (GEE_LIST (type_collection), type_it)));
				{
					if (!first) {
						vala_interface_writer_write_string (self, ", ");
					} else {
						first = FALSE;
					}
					vala_interface_writer_write_type (self, type);
					(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
				}
			}
		}
	}
}


/* equality comparison with 3 digit precision*/
static gboolean vala_interface_writer_float_equal (ValaInterfaceWriter* self, double d1, double d2) {
	g_return_val_if_fail (self != NULL, FALSE);
	return (((gint) ((d1 * 1000)))) == (((gint) ((d2 * 1000))));
}


static void vala_interface_writer_write_params (ValaInterfaceWriter* self, GeeList* params) {
	gint i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	vala_interface_writer_write_string (self, "(");
	i = 1;
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				GString* ccode_params;
				char* separator;
				if (i > 1) {
					vala_interface_writer_write_string (self, ", ");
				}
				if (vala_formal_parameter_get_ellipsis (param)) {
					vala_interface_writer_write_string (self, "...");
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					continue;
				}
				ccode_params = g_string_new ("");
				separator = g_strdup ("");
				if (vala_formal_parameter_get_ctype (param) != NULL) {
					char* _tmp0;
					g_string_append_printf (ccode_params, "%stype = \"%s\"", separator, vala_formal_parameter_get_ctype (param));
					_tmp0 = NULL;
					separator = (_tmp0 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp0);
				}
				if (!vala_interface_writer_float_equal (self, vala_formal_parameter_get_carray_length_parameter_position (param), i + 0.1)) {
					char* _tmp1;
					g_string_append_printf (ccode_params, "%sarray_length_pos = %g", separator, vala_formal_parameter_get_carray_length_parameter_position (param));
					_tmp1 = NULL;
					separator = (_tmp1 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp1);
				}
				if (!vala_interface_writer_float_equal (self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), i + 0.1)) {
					char* _tmp2;
					g_string_append_printf (ccode_params, "%sdelegate_target_pos = %g", separator, vala_formal_parameter_get_cdelegate_target_parameter_position (param));
					_tmp2 = NULL;
					separator = (_tmp2 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp2);
				}
				if (ccode_params->len > 0) {
					char* _tmp3;
					_tmp3 = NULL;
					vala_interface_writer_write_string (self, (_tmp3 = g_strdup_printf ("[CCode (%s)] ", ccode_params->str)));
					_tmp3 = (g_free (_tmp3), NULL);
				}
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
						vala_interface_writer_write_string (self, "ref ");
					} else {
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							vala_interface_writer_write_string (self, "out ");
						}
					}
					if (vala_interface_writer_is_weak (self, vala_formal_parameter_get_parameter_type (param))) {
						vala_interface_writer_write_string (self, "weak ");
					}
				}
				vala_interface_writer_write_type (self, vala_formal_parameter_get_parameter_type (param));
				if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN && vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param))) {
					vala_interface_writer_write_string (self, "#");
				}
				vala_interface_writer_write_string (self, " ");
				vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (param))));
				if (vala_formal_parameter_get_default_expression (param) != NULL) {
					char* _tmp4;
					vala_interface_writer_write_string (self, " = ");
					_tmp4 = NULL;
					vala_interface_writer_write_string (self, (_tmp4 = vala_code_node_to_string (((ValaCodeNode*) (vala_formal_parameter_get_default_expression (param))))));
					_tmp4 = (g_free (_tmp4), NULL);
				}
				i++;
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				(ccode_params == NULL ? NULL : (ccode_params = (g_string_free (ccode_params, TRUE), NULL)));
				separator = (g_free (separator), NULL);
			}
		}
	}
	vala_interface_writer_write_string (self, ")");
}


static void vala_interface_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	ValaInterfaceWriter * self;
	gboolean first;
	char* cheaders;
	char* _tmp3;
	GeeList* _tmp4;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (cb != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (cb)))) {
		return;
	}
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (cb)))) {
		return;
	}
	vala_interface_writer_write_indent (self);
	first = TRUE;
	cheaders = NULL;
	{
		GeeList* cheader_collection;
		int cheader_it;
		cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (cb)));
		for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
			char* cheader;
			cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
			{
				if (first) {
					char* _tmp1;
					const char* _tmp0;
					_tmp1 = NULL;
					_tmp0 = NULL;
					cheaders = (_tmp1 = (_tmp0 = cheader, (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (cheaders = (g_free (cheaders), NULL)), _tmp1);
					first = FALSE;
				} else {
					char* _tmp2;
					_tmp2 = NULL;
					cheaders = (_tmp2 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp2);
				}
				cheader = (g_free (cheader), NULL);
			}
		}
		(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
	}
	_tmp3 = NULL;
	vala_interface_writer_write_string (self, (_tmp3 = g_strdup_printf ("[CCode (cheader_filename = \"%s\")]", cheaders)));
	_tmp3 = (g_free (_tmp3), NULL);
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (cb)));
	if (!vala_delegate_get_has_target (cb)) {
		vala_interface_writer_write_string (self, "static ");
	}
	vala_interface_writer_write_string (self, "delegate ");
	vala_interface_writer_write_return_type (self, vala_delegate_get_return_type (cb));
	vala_interface_writer_write_string (self, " ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (cb))));
	vala_interface_writer_write_string (self, " ");
	_tmp4 = NULL;
	vala_interface_writer_write_params (self, (_tmp4 = vala_delegate_get_parameters (cb)));
	(_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)));
	vala_interface_writer_write_string (self, ";");
	vala_interface_writer_write_newline (self);
	cheaders = (g_free (cheaders), NULL);
}


static void vala_interface_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaInterfaceWriter * self;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	GString* ccode_params;
	char* separator;
	char* _tmp3;
	char* _tmp2;
	gboolean _tmp4;
	GeeList* _tmp19;
	GeeList* _tmp20;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (m != NULL);
	if (vala_symbol_get_external_package (((ValaSymbol*) (m)))) {
		return;
	}
	/* don't write interface implementation unless it's an abstract or virtual method*/
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (m))) || vala_method_get_overrides (m) || (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m))) {
		return;
	}
	_tmp0 = NULL;
	if ((_tmp1 = (_tmp0 = vala_code_node_get_attribute (((ValaCodeNode*) (m)), "NoWrapper")) != NULL, (_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL))), _tmp1)) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[NoWrapper]");
	}
	if (vala_method_get_no_array_length (m)) {
		gboolean array_found;
		array_found = (VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m)));
		{
			GeeList* param_collection;
			int param_it;
			param_collection = vala_method_get_parameters (m);
			for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
				{
					if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						array_found = TRUE;
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						break;
					}
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
		}
		if (array_found) {
			vala_interface_writer_write_indent (self);
			vala_interface_writer_write_string (self, "[NoArrayLength]");
		}
	}
	ccode_params = g_string_new ("");
	separator = g_strdup ("");
	_tmp3 = NULL;
	_tmp2 = NULL;
	if ((_tmp4 = _vala_strcmp0 ((_tmp2 = vala_method_get_cname (m)), (_tmp3 = vala_method_get_default_cname (m))) != 0, (_tmp3 = (g_free (_tmp3), NULL)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp4)) {
		char* _tmp5;
		char* _tmp6;
		_tmp5 = NULL;
		g_string_append_printf (ccode_params, "%scname = \"%s\"", separator, (_tmp5 = vala_method_get_cname (m)));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp6 = NULL;
		separator = (_tmp6 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp6);
	}
	if (VALA_IS_NAMESPACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))) {
		gboolean first;
		char* cheaders;
		char* _tmp10;
		first = TRUE;
		cheaders = NULL;
		{
			GeeList* cheader_collection;
			int cheader_it;
			cheader_collection = vala_symbol_get_cheader_filenames (((ValaSymbol*) (m)));
			for (cheader_it = 0; cheader_it < gee_collection_get_size (GEE_COLLECTION (cheader_collection)); cheader_it = cheader_it + 1) {
				char* cheader;
				cheader = ((char*) (gee_list_get (GEE_LIST (cheader_collection), cheader_it)));
				{
					if (first) {
						char* _tmp8;
						const char* _tmp7;
						_tmp8 = NULL;
						_tmp7 = NULL;
						cheaders = (_tmp8 = (_tmp7 = cheader, (_tmp7 == NULL ? NULL : g_strdup (_tmp7))), (cheaders = (g_free (cheaders), NULL)), _tmp8);
						first = FALSE;
					} else {
						char* _tmp9;
						_tmp9 = NULL;
						cheaders = (_tmp9 = g_strdup_printf ("%s,%s", cheaders, cheader), (cheaders = (g_free (cheaders), NULL)), _tmp9);
					}
					cheader = (g_free (cheader), NULL);
				}
			}
			(cheader_collection == NULL ? NULL : (cheader_collection = (gee_collection_object_unref (cheader_collection), NULL)));
		}
		g_string_append_printf (ccode_params, "%scheader_filename = \"%s\"", separator, cheaders);
		_tmp10 = NULL;
		separator = (_tmp10 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp10);
		cheaders = (g_free (cheaders), NULL);
	}
	if (!vala_interface_writer_float_equal (self, vala_method_get_cinstance_parameter_position (m), ((double) (0)))) {
		char* _tmp11;
		g_string_append_printf (ccode_params, "%sinstance_pos = %g", separator, vala_method_get_cinstance_parameter_position (m));
		_tmp11 = NULL;
		separator = (_tmp11 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp11);
	}
	if (!vala_interface_writer_float_equal (self, vala_method_get_carray_length_parameter_position (m), ((double) (-3)))) {
		char* _tmp12;
		g_string_append_printf (ccode_params, "%sarray_length_pos = %g", separator, vala_method_get_carray_length_parameter_position (m));
		_tmp12 = NULL;
		separator = (_tmp12 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp12);
	}
	if (!vala_interface_writer_float_equal (self, vala_method_get_cdelegate_target_parameter_position (m), ((double) (-3)))) {
		char* _tmp13;
		g_string_append_printf (ccode_params, "%sdelegate_target_pos = %g", separator, vala_method_get_cdelegate_target_parameter_position (m));
		_tmp13 = NULL;
		separator = (_tmp13 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp13);
	}
	if (_vala_strcmp0 (vala_method_get_sentinel (m), VALA_METHOD_DEFAULT_SENTINEL) != 0) {
		char* _tmp14;
		g_string_append_printf (ccode_params, "%ssentinel = \"%s\"", separator, vala_method_get_sentinel (m));
		_tmp14 = NULL;
		separator = (_tmp14 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp14);
	}
	if (VALA_IS_CREATION_METHOD (m) && vala_creation_method_get_custom_return_type_cname ((VALA_CREATION_METHOD (m))) != NULL) {
		char* _tmp15;
		g_string_append_printf (ccode_params, "%stype = \"%s\"", separator, vala_creation_method_get_custom_return_type_cname ((VALA_CREATION_METHOD (m))));
		_tmp15 = NULL;
		separator = (_tmp15 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp15);
	}
	if (VALA_IS_CREATION_METHOD (m) && !vala_method_get_has_construct_function (m)) {
		char* _tmp16;
		g_string_append_printf (ccode_params, "%shas_construct_function = false", separator);
		_tmp16 = NULL;
		separator = (_tmp16 = g_strdup (", "), (separator = (g_free (separator), NULL)), _tmp16);
	}
	if (ccode_params->len > 0) {
		char* _tmp17;
		vala_interface_writer_write_indent (self);
		_tmp17 = NULL;
		vala_interface_writer_write_string (self, (_tmp17 = g_strdup_printf ("[CCode (%s)]", ccode_params->str)));
		_tmp17 = (g_free (_tmp17), NULL);
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (m)));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaTypeSymbol* _tmp18;
		ValaTypeSymbol* datatype;
		_tmp18 = NULL;
		datatype = (_tmp18 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
		vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (datatype))));
		if (_vala_strcmp0 (vala_symbol_get_name (((ValaSymbol*) (m))), "new") != 0) {
			vala_interface_writer_write_string (self, ".");
			vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (m))));
		}
		vala_interface_writer_write_string (self, " ");
		(datatype == NULL ? NULL : (datatype = (vala_code_node_unref (datatype), NULL)));
	} else {
		if (vala_method_get_binding (m) == MEMBER_BINDING_STATIC) {
			vala_interface_writer_write_string (self, "static ");
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
				vala_interface_writer_write_string (self, "class ");
			} else {
				if (vala_method_get_is_abstract (m)) {
					vala_interface_writer_write_string (self, "abstract ");
				} else {
					if (vala_method_get_is_virtual (m)) {
						vala_interface_writer_write_string (self, "virtual ");
					}
				}
			}
		}
	}
	if (!(VALA_IS_CREATION_METHOD (m))) {
		vala_interface_writer_write_return_type (self, vala_method_get_return_type (m));
		vala_interface_writer_write_string (self, " ");
		vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (m))));
		vala_interface_writer_write_string (self, " ");
	}
	_tmp19 = NULL;
	vala_interface_writer_write_params (self, (_tmp19 = vala_method_get_parameters (m)));
	(_tmp19 == NULL ? NULL : (_tmp19 = (gee_collection_object_unref (_tmp19), NULL)));
	_tmp20 = NULL;
	vala_interface_writer_write_error_domains (self, (_tmp20 = vala_code_node_get_error_types (((ValaCodeNode*) (m)))));
	(_tmp20 == NULL ? NULL : (_tmp20 = (gee_collection_object_unref (_tmp20), NULL)));
	vala_interface_writer_write_string (self, ";");
	vala_interface_writer_write_newline (self);
	(ccode_params == NULL ? NULL : (ccode_params = (g_string_free (ccode_params, TRUE), NULL)));
	separator = (g_free (separator), NULL);
}


static void vala_interface_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaInterfaceWriter * self;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (m != NULL);
	vala_code_visitor_visit_method (((ValaCodeVisitor*) (self)), ((ValaMethod*) (m)));
}


static void vala_interface_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaInterfaceWriter * self;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (prop != NULL);
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (prop))) || vala_property_get_overrides (prop) || (vala_property_get_base_interface_property (prop) != NULL && !vala_property_get_is_abstract (prop) && !vala_property_get_is_virtual (prop))) {
		return;
	}
	if (vala_property_get_no_accessor_method (prop)) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[NoAccessorMethod]");
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (prop)));
	if (vala_property_get_binding (prop) == MEMBER_BINDING_STATIC) {
		vala_interface_writer_write_string (self, "static ");
	} else {
		if (vala_property_get_is_abstract (prop)) {
			vala_interface_writer_write_string (self, "abstract ");
		} else {
			if (vala_property_get_is_virtual (prop)) {
				vala_interface_writer_write_string (self, "virtual ");
			}
		}
	}
	vala_interface_writer_write_type (self, vala_property_get_property_type (prop));
	if (vala_data_type_get_value_owned (vala_property_get_property_type (prop))) {
		vala_interface_writer_write_string (self, "#");
	}
	vala_interface_writer_write_string (self, " ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (prop))));
	vala_interface_writer_write_string (self, " {");
	if (vala_property_get_get_accessor (prop) != NULL) {
		vala_interface_writer_write_string (self, " get;");
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
			vala_interface_writer_write_string (self, " set");
		}
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			vala_interface_writer_write_string (self, " construct");
		}
		vala_interface_writer_write_string (self, ";");
	}
	vala_interface_writer_write_string (self, " }");
	vala_interface_writer_write_newline (self);
}


static void vala_interface_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaInterfaceWriter * self;
	GeeList* _tmp0;
	self = ((ValaInterfaceWriter*) (base));
	g_return_if_fail (sig != NULL);
	if (!vala_interface_writer_check_accessibility (self, ((ValaSymbol*) (sig)))) {
		return;
	}
	if (vala_signal_get_has_emitter (sig)) {
		vala_interface_writer_write_indent (self);
		vala_interface_writer_write_string (self, "[HasEmitter]");
	}
	vala_interface_writer_write_indent (self);
	vala_interface_writer_write_accessibility (self, ((ValaSymbol*) (sig)));
	if (vala_signal_get_is_virtual (sig)) {
		vala_interface_writer_write_string (self, "virtual ");
	}
	vala_interface_writer_write_string (self, "signal ");
	vala_interface_writer_write_return_type (self, vala_signal_get_return_type (sig));
	vala_interface_writer_write_string (self, " ");
	vala_interface_writer_write_identifier (self, vala_symbol_get_name (((ValaSymbol*) (sig))));
	vala_interface_writer_write_string (self, " ");
	_tmp0 = NULL;
	vala_interface_writer_write_params (self, (_tmp0 = vala_signal_get_parameters (sig)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)));
	vala_interface_writer_write_string (self, ";");
	vala_interface_writer_write_newline (self);
}


static void vala_interface_writer_write_indent (ValaInterfaceWriter* self) {
	gint i;
	g_return_if_fail (self != NULL);
	i = 0;
	if (!self->priv->bol) {
		fputc ('\n', self->priv->stream);
	}
	for (i = 0; i < self->priv->indent; i++) {
		fputc ('\t', self->priv->stream);
	}
	self->priv->bol = FALSE;
}


static void vala_interface_writer_write_identifier (ValaInterfaceWriter* self, const char* s) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	if (_vala_strcmp0 (s, "base") == 0 || _vala_strcmp0 (s, "break") == 0 || _vala_strcmp0 (s, "class") == 0 || _vala_strcmp0 (s, "construct") == 0 || _vala_strcmp0 (s, "delegate") == 0 || _vala_strcmp0 (s, "delete") == 0 || _vala_strcmp0 (s, "do") == 0 || _vala_strcmp0 (s, "foreach") == 0 || _vala_strcmp0 (s, "in") == 0 || _vala_strcmp0 (s, "interface") == 0 || _vala_strcmp0 (s, "lock") == 0 || _vala_strcmp0 (s, "namespace") == 0 || _vala_strcmp0 (s, "new") == 0 || _vala_strcmp0 (s, "out") == 0 || _vala_strcmp0 (s, "ref") == 0 || _vala_strcmp0 (s, "signal") == 0) {
		fputc ('@', self->priv->stream);
	}
	vala_interface_writer_write_string (self, s);
}


static void vala_interface_writer_write_return_type (ValaInterfaceWriter* self, ValaDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (vala_interface_writer_is_weak (self, type)) {
		vala_interface_writer_write_string (self, "weak ");
	}
	vala_interface_writer_write_type (self, type);
}


static gboolean vala_interface_writer_is_weak (ValaInterfaceWriter* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (vala_data_type_get_value_owned (type)) {
		return FALSE;
	} else {
		if (VALA_IS_VOID_TYPE (type) || VALA_IS_POINTER_TYPE (type)) {
			return FALSE;
		} else {
			if (VALA_IS_VALUE_TYPE (type)) {
				if (vala_data_type_get_nullable (type)) {
					/* nullable structs are heap allocated*/
					return TRUE;
				}
				/* TODO return true for structs with destroy*/
				return FALSE;
			}
		}
	}
	return TRUE;
}


static void vala_interface_writer_write_type (ValaInterfaceWriter* self, ValaDataType* type) {
	char* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0 = NULL;
	vala_interface_writer_write_string (self, (_tmp0 = vala_data_type_to_qualified_string (type, self->priv->current_scope)));
	_tmp0 = (g_free (_tmp0), NULL);
}


static void vala_interface_writer_write_string (ValaInterfaceWriter* self, const char* s) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	fprintf (self->priv->stream, "%s", s);
	self->priv->bol = FALSE;
}


static void vala_interface_writer_write_newline (ValaInterfaceWriter* self) {
	g_return_if_fail (self != NULL);
	fputc ('\n', self->priv->stream);
	self->priv->bol = TRUE;
}


static void vala_interface_writer_write_begin_block (ValaInterfaceWriter* self) {
	g_return_if_fail (self != NULL);
	if (!self->priv->bol) {
		fputc (' ', self->priv->stream);
	} else {
		vala_interface_writer_write_indent (self);
	}
	fputc ('{', self->priv->stream);
	vala_interface_writer_write_newline (self);
	self->priv->indent++;
}


static void vala_interface_writer_write_end_block (ValaInterfaceWriter* self) {
	g_return_if_fail (self != NULL);
	self->priv->indent--;
	vala_interface_writer_write_indent (self);
	fprintf (self->priv->stream, "}");
}


static gboolean vala_interface_writer_check_accessibility (ValaInterfaceWriter* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	if (vala_symbol_get_access (sym) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC || vala_symbol_get_access (sym) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		return TRUE;
	}
	return FALSE;
}


static void vala_interface_writer_write_accessibility (ValaInterfaceWriter* self, ValaSymbol* sym) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (vala_symbol_get_access (sym) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		vala_interface_writer_write_string (self, "public ");
	} else {
		if (vala_symbol_get_access (sym) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
			vala_interface_writer_write_string (self, "protected ");
		} else {
			g_assert_not_reached ();
		}
	}
}


/**
 * Code visitor generating Vala API file for the public interface.
 */
ValaInterfaceWriter* vala_interface_writer_construct (GType object_type) {
	ValaInterfaceWriter* self;
	self = ((ValaInterfaceWriter*) (g_type_create_instance (object_type)));
	return self;
}


ValaInterfaceWriter* vala_interface_writer_new (void) {
	return vala_interface_writer_construct (VALA_TYPE_INTERFACE_WRITER);
}


static void vala_interface_writer_class_init (ValaInterfaceWriterClass * klass) {
	vala_interface_writer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_interface_writer_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfaceWriterPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_interface_writer_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_interface_writer_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_interface_writer_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_interface_writer_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_interface_writer_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_interface_writer_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = vala_interface_writer_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_interface_writer_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_interface_writer_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_interface_writer_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_interface_writer_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_interface_writer_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_interface_writer_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_interface_writer_real_visit_signal;
}


static void vala_interface_writer_instance_init (ValaInterfaceWriter * self) {
	self->priv = VALA_INTERFACE_WRITER_GET_PRIVATE (self);
	self->priv->bol = TRUE;
}


static void vala_interface_writer_finalize (ValaCodeVisitor* obj) {
	ValaInterfaceWriter * self;
	self = VALA_INTERFACE_WRITER (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (vala_code_context_unref (self->priv->context), NULL)));
	(self->priv->stream == NULL ? NULL : (self->priv->stream = (fclose (self->priv->stream), NULL)));
	self->priv->current_cheader_filename = (g_free (self->priv->current_cheader_filename), NULL);
	(self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (vala_scope_unref (self->priv->current_scope), NULL)));
	VALA_CODE_VISITOR_CLASS (vala_interface_writer_parent_class)->finalize (obj);
}


GType vala_interface_writer_get_type (void) {
	static GType vala_interface_writer_type_id = 0;
	if (vala_interface_writer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterfaceWriter), 0, (GInstanceInitFunc) vala_interface_writer_instance_init, NULL };
		vala_interface_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaInterfaceWriter", &g_define_type_info, 0);
	}
	return vala_interface_writer_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




