/* valagirparser.c generated by valac, the Vala compiler
 * generated from valagirparser.vala, do not modify */

/* valagirparser.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 * Copyright (C) 2011-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include "vala.h"
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>
#include <errno.h>

#define VALA_GIR_PARSER_TYPE_NODE (vala_gir_parser_node_get_type ())
#define VALA_GIR_PARSER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode))
#define VALA_GIR_PARSER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))
#define VALA_GIR_PARSER_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))

typedef struct _ValaGirParserNode ValaGirParserNode;
typedef struct _ValaGirParserNodeClass ValaGirParserNodeClass;

#define VALA_GIR_PARSER_TYPE_METADATA (vala_gir_parser_metadata_get_type ())
#define VALA_GIR_PARSER_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata))
#define VALA_GIR_PARSER_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))
#define VALA_GIR_PARSER_IS_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_IS_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))

typedef struct _ValaGirParserMetadata ValaGirParserMetadata;
typedef struct _ValaGirParserMetadataClass ValaGirParserMetadataClass;
typedef enum  {
	VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP,
	VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NEW,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OUT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REF,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE
} ValaGirParserArgumentType;

#define VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE (vala_gir_parser_argument_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_gir_parser_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_gir_parser_metadata_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValaGirParserNodePrivate ValaGirParserNodePrivate;

#define VALA_GIR_PARSER_TYPE_PARAMETER_INFO (vala_gir_parser_parameter_info_get_type ())
#define VALA_GIR_PARSER_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo))
#define VALA_GIR_PARSER_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))

typedef struct _ValaGirParserParameterInfo ValaGirParserParameterInfo;
typedef struct _ValaGirParserParameterInfoClass ValaGirParserParameterInfoClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _ValaGirParserParameterInfoPrivate ValaGirParserParameterInfoPrivate;

#define VALA_GIR_PARSER_TYPE_METADATA_PARSER (vala_gir_parser_metadata_parser_get_type ())
#define VALA_GIR_PARSER_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser))
#define VALA_GIR_PARSER_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))
#define VALA_GIR_PARSER_IS_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_IS_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))

typedef struct _ValaGirParserMetadataParser ValaGirParserMetadataParser;
typedef struct _ValaGirParserMetadataParserClass ValaGirParserMetadataParserClass;
#define _vala_gir_parser_metadata_parser_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_parser_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_gir_parser_parameter_info_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_parameter_info_unref (var), NULL)))
typedef struct _ValaGirParserMetadataPrivate ValaGirParserMetadataPrivate;

#define VALA_GIR_PARSER_TYPE_ARGUMENT (vala_gir_parser_argument_get_type ())
#define VALA_GIR_PARSER_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument))
#define VALA_GIR_PARSER_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))
#define VALA_GIR_PARSER_IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))

typedef struct _ValaGirParserArgument ValaGirParserArgument;
typedef struct _ValaGirParserArgumentClass ValaGirParserArgumentClass;
typedef struct _ValaGirParserArgumentPrivate ValaGirParserArgumentPrivate;
#define _vala_gir_parser_argument_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_argument_unref (var), NULL)))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecArgument ValaGirParserParamSpecArgument;

#define VALA_GIR_PARSER_TYPE_METADATA_SET (vala_gir_parser_metadata_set_get_type ())
#define VALA_GIR_PARSER_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSet))
#define VALA_GIR_PARSER_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))
#define VALA_GIR_PARSER_IS_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_IS_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_METADATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))

typedef struct _ValaGirParserMetadataSet ValaGirParserMetadataSet;
typedef struct _ValaGirParserMetadataSetClass ValaGirParserMetadataSetClass;
typedef struct _ValaGirParserMetadataSetPrivate ValaGirParserMetadataSetPrivate;
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadata ValaGirParserParamSpecMetadata;
typedef struct _ValaGirParserMetadataParserPrivate ValaGirParserMetadataParserPrivate;
#define _vala_scanner_unref0(var) ((var == NULL) ? NULL : (var = (vala_scanner_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadataParser ValaGirParserParamSpecMetadataParser;
typedef struct _ValaGirParserParamSpecNode ValaGirParserParamSpecNode;
typedef struct _ValaGirParserParamSpecParameterInfo ValaGirParserParamSpecParameterInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGirParserPrivate {
	ValaMarkupReader* reader;
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaGirParserNode* root;
	ValaArrayList* metadata_roots;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupTokenType current_token;
	gchar** cheader_filenames;
	gint cheader_filenames_length1;
	gint _cheader_filenames_size_;
	ValaArrayList* metadata_stack;
	ValaGirParserMetadata* metadata;
	ValaArrayList* tree_stack;
	ValaGirParserNode* current;
	ValaGirParserNode* old_current;
	ValaSet* provided_namespaces;
	ValaHashMap* unresolved_symbols_map;
	ValaArrayList* unresolved_gir_symbols;
	ValaHashMap* unresolved_type_arguments;
	ValaArrayList* ifaces_needing_object_prereq;
};

struct _ValaGirParserNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserNode* parent;
	gchar* element_type;
	gchar* name;
	ValaMap* girdata;
	ValaGirParserMetadata* metadata;
	ValaSourceReference* source_reference;
	ValaArrayList* members;
	ValaHashMap* scope;
	ValaGirComment* comment;
	ValaSymbol* symbol;
	gboolean new_symbol;
	gboolean merged;
	gboolean processed;
	gint return_array_length_idx;
	ValaList* parameters;
	ValaArrayList* array_length_parameters;
	ValaArrayList* closure_parameters;
	ValaArrayList* destroy_parameters;
	ValaUnresolvedSymbol* gtype_struct_for;
	ValaDataType* base_type;
	gint array_length_idx;
	gboolean deprecated;
	guint64 deprecated_version;
	gchar* deprecated_since;
	gchar* deprecated_replacement;
	ValaGirParserNodePrivate * priv;
};

struct _ValaGirParserNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserNode *self);
};

struct _ValaGirParserParameterInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaParameter* param;
	gfloat vala_idx;
	gint array_length_idx;
	gint closure_idx;
	gint destroy_idx;
	gboolean keep;
	gboolean is_async;
	gboolean is_async_result;
	gboolean is_error;
	ValaGirParserParameterInfoPrivate * priv;
};

struct _ValaGirParserParameterInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserParameterInfo *self);
};

struct _ValaGirParserMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPatternSpec* pattern_spec;
	gchar* selector;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaMap* args;
	ValaArrayList* children;
	ValaGirParserMetadataPrivate * priv;
};

struct _ValaGirParserMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadata *self);
};

struct _ValaGirParserArgument {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaExpression* expression;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaGirParserArgumentPrivate * priv;
};

struct _ValaGirParserArgumentClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserArgument *self);
};

struct _ValaGirParserParamSpecArgument {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataSet {
	ValaGirParserMetadata parent_instance;
	ValaGirParserMetadataSetPrivate * priv;
};

struct _ValaGirParserMetadataSetClass {
	ValaGirParserMetadataClass parent_class;
};

struct _ValaGirParserParamSpecMetadata {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserMetadataParserPrivate * priv;
};

struct _ValaGirParserMetadataParserClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadataParser *self);
};

struct _ValaGirParserMetadataParserPrivate {
	ValaGirParserMetadata* tree;
	ValaScanner* scanner;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaSourceLocation old_end;
	ValaTokenType current;
	ValaGirParserMetadata* parent_metadata;
};

struct _ValaGirParserParamSpecMetadataParser {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecNode {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecParameterInfo {
	GParamSpec parent_instance;
};

static gint ValaGirParser_private_offset;
static gpointer vala_gir_parser_parent_class = NULL;
static GRegex* vala_gir_parser_type_from_string_regex;
static GRegex* vala_gir_parser_type_from_string_regex = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces;
static gpointer vala_gir_parser_argument_parent_class = NULL;
static gpointer vala_gir_parser_metadata_set_parent_class = NULL;
static gpointer vala_gir_parser_metadata_parent_class = NULL;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty = NULL;
static gint ValaGirParserMetadataParser_private_offset;
static gpointer vala_gir_parser_metadata_parser_parent_class = NULL;
static gpointer vala_gir_parser_node_parent_class = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces = NULL;
static gpointer vala_gir_parser_parameter_info_parent_class = NULL;

static gpointer vala_gir_parser_node_ref (gpointer instance);
static void vala_gir_parser_node_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_node (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_node (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_node (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer vala_gir_parser_metadata_ref (gpointer instance);
static void vala_gir_parser_metadata_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType vala_gir_parser_argument_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserArgumentType* vala_gir_parser_argument_type_from_string (const gchar* name);
static ValaGirParserArgumentType* _vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self);
#define VALA_GIR_PARSER_GIR_VERSION "1.2"
static guint vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym);
static guint _vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key);
static gboolean vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                                  ValaUnresolvedSymbol* sym2);
static gboolean _vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                               gconstpointer b);
static ValaGirParserNode* vala_gir_parser_node_new (const gchar* name);
static ValaGirParserNode* vala_gir_parser_node_construct (GType object_type,
                                                   const gchar* name);
static gpointer vala_gir_parser_parameter_info_ref (gpointer instance);
static void vala_gir_parser_parameter_info_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_parameter_info (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_parameter_info (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_parameter_info (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_parameter_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_map_vala_to_gir (ValaGirParser* self);
static void vala_gir_parser_resolve_gir_symbols (ValaGirParser* self);
static void vala_gir_parser_create_new_namespaces (ValaGirParser* self);
static void vala_gir_parser_resolve_type_arguments (ValaGirParser* self);
static void vala_gir_parser_node_process (ValaGirParserNode* self,
                                   ValaGirParser* parser);
static void vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                             ValaGirParserMetadata* metadata);
static void vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                         ValaUnresolvedSymbol* map_from,
                                         ValaSymbol* map_to);
static void vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                             ValaSourceFile* source_file);
static ValaGirParserMetadata* vala_gir_parser_metadata_get_empty (void);
static void vala_gir_parser_next (ValaGirParser* self);
static void vala_gir_parser_parse_repository (ValaGirParser* self);
static void vala_gir_parser_start_element (ValaGirParser* self,
                                    const gchar* name);
static ValaSourceReference* vala_gir_parser_get_current_src (ValaGirParser* self);
static void vala_gir_parser_end_element (ValaGirParser* self,
                                  const gchar* name);
static void vala_gir_parser_skip_element (ValaGirParser* self);
static ValaSourceReference* vala_gir_parser_get_src (ValaGirParser* self,
                                              ValaSourceLocation* begin,
                                              ValaSourceLocation* end);
static void vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                              ValaSymbol* sym);
static gboolean vala_gir_parser_is_container (ValaSymbol* sym);
static ValaUnresolvedSymbol* vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                                                const gchar* symbol_string,
                                                                ValaSourceReference* source_reference);
static void vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                             ValaSignal* sig,
                                             ValaSymbol* sym,
                                             gboolean skip_first);
static ValaGirParserNode* vala_gir_parser_find_invoker (ValaGirParser* self,
                                                 ValaGirParserNode* node);
static ValaGirParserMetadata* vala_gir_parser_get_current_metadata (ValaGirParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                                             const gchar* name,
                                                             const gchar* selector);
static gboolean vala_gir_parser_push_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                                ValaGirParserArgumentType key);
static gboolean vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg,
                                            gboolean default_value);
static void vala_gir_parser_pop_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                           ValaDataType* parent_type,
                                                           const gchar* type_arguments,
                                                           ValaSourceReference* source_reference);
static ValaDataType* vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                                      const gchar* type_string,
                                                      gboolean owned_by_default,
                                                      ValaSourceReference* source_reference);
static gchar* vala_gir_parser_element_get_string (ValaGirParser* self,
                                           const gchar* attribute_name,
                                           ValaGirParserArgumentType arg_type);
static gchar* vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_element_get_type (ValaGirParser* self,
                                                ValaDataType* orig_type,
                                                gboolean owned_by_default,
                                                gboolean* no_array_length,
                                                gboolean* array_null_terminated,
                                                gboolean* changed);
static ValaSourceReference* vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                                                    ValaGirParserArgumentType arg);
static gchar* vala_gir_parser_element_get_name (ValaGirParser* self,
                                         const gchar* gir_name);
static gchar* vala_gir_parser_element_get_type_id (ValaGirParser* self);
static void vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                      ValaSymbol* sym,
                                      ValaGirParserParameterInfo* info);
static ValaGirParserNode* vala_gir_parser_node_lookup (ValaGirParserNode* self,
                                                const gchar* name,
                                                gboolean create_namespace,
                                                ValaSourceReference* source_reference);
static gchar* vala_gir_parser_node_get_cname (ValaGirParserNode* self);
static void vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                        ValaSymbol* sym);
static void vala_gir_parser_parse_namespace (ValaGirParser* self);
static void vala_gir_parser_parse_include (ValaGirParser* self);
static gchar* vala_gir_parser_parse_package (ValaGirParser* self);
static void vala_gir_parser_parse_c_include (ValaGirParser* self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static ValaGirParserNode* vala_gir_parser_resolve_node (ValaGirParser* self,
                                                 ValaGirParserNode* parent_scope,
                                                 ValaUnresolvedSymbol* unresolved_sym,
                                                 gboolean create_namespace);
static ValaSymbol* vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                            ValaGirParserNode* parent_scope,
                                            ValaUnresolvedSymbol* unresolved_sym);
static void vala_gir_parser_push_node (ValaGirParser* self,
                                const gchar* name,
                                gboolean merge);
static void vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                      ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_gir_name (ValaGirParserNode* self);
static ValaUnresolvedSymbol* vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self);
static void vala_gir_parser_pop_node (ValaGirParser* self);
static gpointer vala_gir_parser_metadata_parser_ref (gpointer instance);
static void vala_gir_parser_metadata_parser_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata_parser (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata_parser (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata_parser (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_parser_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_new (void);
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_construct (GType object_type);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                                       ValaSourceFile* metadata_file);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_gir_parser_parse_alias (ValaGirParser* self);
static void vala_gir_parser_parse_error_domain (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                        const gchar* element_name,
                                        gboolean error_domain);
static void vala_gir_parser_parse_bitfield (ValaGirParser* self);
static void vala_gir_parser_parse_method (ValaGirParser* self,
                                   const gchar* element_name);
static void vala_gir_parser_parse_callback (ValaGirParser* self);
static void vala_gir_parser_parse_record (ValaGirParser* self);
static void vala_gir_parser_parse_boxed (ValaGirParser* self,
                                  const gchar* element_name);
static void vala_gir_parser_parse_class (ValaGirParser* self);
static void vala_gir_parser_parse_interface (ValaGirParser* self);
static void vala_gir_parser_parse_union (ValaGirParser* self);
static void vala_gir_parser_parse_constant (ValaGirParser* self);
static ValaGirComment* vala_gir_parser_parse_symbol_doc (ValaGirParser* self);
static ValaDataType* vala_gir_parser_parse_type (ValaGirParser* self,
                                          gchar* * ctype,
                                          gint* array_length_idx,
                                          gboolean transfer_elements,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated);
static void vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                              gchar* * common_prefix,
                                              const gchar* cname);
static ValaComment* vala_gir_parser_parse_doc (ValaGirParser* self);
static void vala_gir_parser_parse_error_member (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration_member (ValaGirParser* self);
static ValaExpression* vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                                         ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_return_value (ValaGirParser* self,
                                                  gchar* * ctype,
                                                  gint* array_length_idx,
                                                  gboolean* no_array_length,
                                                  gboolean* array_null_terminated,
                                                  ValaComment* * comment);
static ValaParameter* vala_gir_parser_parse_parameter (ValaGirParser* self,
                                                gint* array_length_idx,
                                                gint* closure_idx,
                                                gint* destroy_idx,
                                                gchar* * scope,
                                                ValaComment* * comment,
                                                const gchar* default_name);
static gint vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                           ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                                        const gchar* type_name,
                                                        gboolean* no_array_length,
                                                        gboolean* array_null_terminated,
                                                        const gchar* ctype);
static void vala_gir_parser_parse_field (ValaGirParser* self);
static void vala_gir_parser_parse_constructor (ValaGirParser* self);
static ValaProperty* vala_gir_parser_parse_property (ValaGirParser* self);
static void vala_gir_parser_parse_signal (ValaGirParser* self);
static void vala_gir_parser_parse_function (ValaGirParser* self,
                                     const gchar* element_name);
G_GNUC_INTERNAL void vala_gir_comment_add_content_for_parameter (ValaGirComment* self,
                                                 const gchar* name,
                                                 ValaComment* comment);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_new (ValaParameter* param,
                                                                gint array_length_idx,
                                                                gint closure_idx,
                                                                gint destroy_idx,
                                                                gboolean is_async);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_construct (GType object_type,
                                                                      ValaParameter* param,
                                                                      gint array_length_idx,
                                                                      gint closure_idx,
                                                                      gint destroy_idx,
                                                                      gboolean is_async);
static gpointer vala_gir_parser_argument_ref (gpointer instance);
static void vala_gir_parser_argument_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_argument (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_argument (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_argument (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_argument (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_process_interface (ValaGirParser* self,
                                        ValaGirParserNode* iface_node);
static void vala_gir_parser_process_alias (ValaGirParser* self,
                                    ValaGirParserNode* alias);
static gchar* vala_gir_parser_node_get_full_name (ValaGirParserNode* self);
static void vala_gir_parser_process_callable (ValaGirParser* self,
                                       ValaGirParserNode* node);
static void vala_gir_parser_find_parent (ValaGirParser* self,
                                  const gchar* cname,
                                  ValaGirParserNode* current,
                                  ValaGirParserNode* * best,
                                  gint* match);
static gchar* vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self);
static gboolean vala_gir_parser_same_gir (ValaGirParser* self,
                                   ValaSymbol* gir_component,
                                   ValaSymbol* sym);
static void vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                               ValaGirParserNode* ns,
                                               ValaGirParserNode* node);
static void vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                         ValaGirParserNode* node);
static void vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                                   ValaGirParserNode* node,
                                                   ValaDelegate* d,
                                                   ValaUnresolvedSymbol* gtype_struct_for);
static gchar* vala_gir_parser_node_to_string (ValaGirParserNode* self);
static ValaArrayList* vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                                const gchar* name);
static void vala_gir_parser_process_async_method (ValaGirParser* self,
                                           ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self);
static ValaGirParserNode* vala_gir_parser_base_interface_property (ValaGirParser* self,
                                                            ValaGirParserNode* prop_node);
static ValaGirParserArgument* vala_gir_parser_argument_new (ValaExpression* expression,
                                                     ValaSourceReference* source_reference);
static ValaGirParserArgument* vala_gir_parser_argument_construct (GType object_type,
                                                           ValaExpression* expression,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_argument_finalize (ValaGirParserArgument * obj);
static GType vala_gir_parser_argument_get_type_once (void);
static GType vala_gir_parser_metadata_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_new (const gchar* selector);
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_construct (GType object_type,
                                                                  const gchar* selector);
static ValaGirParserMetadata* vala_gir_parser_metadata_new (const gchar* pattern,
                                                     const gchar* selector,
                                                     ValaSourceReference* source_reference);
static ValaGirParserMetadata* vala_gir_parser_metadata_construct (GType object_type,
                                                           const gchar* pattern,
                                                           const gchar* selector,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                               ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                         ValaGirParserMetadata* metadata);
static GType vala_gir_parser_metadata_set_get_type_once (void);
static void vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType key,
                                            ValaGirParserArgument* value);
static void vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj);
static GType vala_gir_parser_metadata_get_type_once (void);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                                              ValaSourceLocation* begin,
                                                              ValaSourceLocation* end);
static ValaTokenType vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self);
static gchar* vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                                   ValaSourceLocation* begin,
                                                   ValaSourceLocation* end);
static gchar* vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                         gboolean is_glob);
static gchar* vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self);
static ValaExpression* vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                                     ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj);
static GType vala_gir_parser_metadata_parser_get_type_once (void);
static gchar* vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_cname (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self);
static guint64 vala_gir_parser_node_parse_version_string (const gchar* version);
static void vala_gir_parser_node_finalize (ValaGirParserNode * obj);
static GType vala_gir_parser_node_get_type_once (void);
static void vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj);
static GType vala_gir_parser_parameter_info_get_type_once (void);
static void vala_gir_parser_finalize (ValaCodeVisitor * obj);
static GType vala_gir_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_gir_parser_get_instance_private (ValaGirParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGirParser_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static ValaGirParserArgumentType*
_vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self)
{
	ValaGirParserArgumentType* dup;
	dup = g_new0 (ValaGirParserArgumentType, 1);
	memcpy (dup, self, sizeof (ValaGirParserArgumentType));
	return dup;
}

static gpointer
__vala_gir_parser_argument_type_dup0 (gpointer self)
{
	return self ? _vala_gir_parser_argument_type_dup (self) : NULL;
}

static ValaGirParserArgumentType*
vala_gir_parser_argument_type_from_string (const gchar* name)
{
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp0_;
	gchar* nick = NULL;
	gchar* _tmp1_;
	GEnumValue* enum_value = NULL;
	GEnumClass* _tmp2_;
	const gchar* _tmp3_;
	GEnumValue* _tmp4_;
	ValaGirParserArgumentType* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_type_class_ref (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE);
	enum_class = (GEnumClass*) _tmp0_;
	_tmp1_ = string_replace (name, "_", "-");
	nick = _tmp1_;
	_tmp2_ = enum_class;
	_tmp3_ = nick;
	enum_value = g_enum_get_value_by_nick (_tmp2_, _tmp3_);
	_tmp4_ = enum_value;
	if (_tmp4_ != NULL) {
		ValaGirParserArgumentType value = 0;
		GEnumValue* _tmp5_;
		ValaGirParserArgumentType* _tmp6_;
		_tmp5_ = enum_value;
		value = (ValaGirParserArgumentType) (*_tmp5_).value;
		_tmp6_ = __vala_gir_parser_argument_type_dup0 (&value);
		result = _tmp6_;
		_g_free0 (nick);
		_g_type_class_unref0 (enum_class);
		return result;
	}
	result = NULL;
	_g_free0 (nick);
	_g_type_class_unref0 (enum_class);
	return result;
}

static GType
vala_gir_parser_argument_type_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, "VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP", "skip"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, "VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN", "hidden"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NEW, "VALA_GIR_PARSER_ARGUMENT_TYPE_NEW", "new"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE", "type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS", "type-arguments"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME", "cheader-filename"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_NAME", "name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED", "owned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED", "unowned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT", "parent"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, "VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE", "nullable"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED", "deprecated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT", "replacement"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE", "deprecated-since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE", "since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY", "array"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX", "array-length-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED", "array-null-terminated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT", "default"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, "VALA_GIR_PARSER_ARGUMENT_TYPE_OUT", "out"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REF, "VALA_GIR_PARSER_ARGUMENT_TYPE_REF", "ref"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME", "vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL", "virtual"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, "VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT", "abstract"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED, "VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED", "sealed"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE", "scope"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, "VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT", "struct"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS, "VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS", "throws"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT", "printf-format"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD", "array-length-field"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL, "VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL", "sentinel"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE", "closure"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY", "destroy"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX", "cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX", "lower-case-cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX", "lower-case-csuffix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, "VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE", "destroys-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE", "base-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME", "finish-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE", "finish-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE", "symbol-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX", "instance-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL", "experimental"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO, "VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO", "feature-test-macro"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, "VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING", "floating"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID", "type-id"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID", "return-void"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER", "returns-modified-pointer"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME", "delegate-target-cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME", "finish-vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, "VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD", "no-accessor-method"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME", "cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET", "delegate-target"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE", "ctype"}, {0, NULL, NULL}};
	GType vala_gir_parser_argument_type_type_id;
	vala_gir_parser_argument_type_type_id = g_enum_register_static ("ValaGirParserArgumentType", values);
	return vala_gir_parser_argument_type_type_id;
}

static GType
vala_gir_parser_argument_type_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_type_id__volatile)) {
		GType vala_gir_parser_argument_type_type_id;
		vala_gir_parser_argument_type_type_id = vala_gir_parser_argument_type_get_type_once ();
		g_once_init_leave (&vala_gir_parser_argument_type_type_id__volatile, vala_gir_parser_argument_type_type_id);
	}
	return vala_gir_parser_argument_type_type_id__volatile;
}

static guint
_vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_gir_parser_unresolved_symbol_hash ((ValaUnresolvedSymbol*) key);
	return result;
}

static gboolean
_vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                      gconstpointer b)
{
	gboolean result;
	result = vala_gir_parser_unresolved_symbol_equal ((ValaUnresolvedSymbol*) a, (ValaUnresolvedSymbol*) b);
	return result;
}

/**
 * Parses all .gir source files in the specified code
 * context and builds a code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_gir_parser_node_ref0 (gpointer self)
{
	return self ? vala_gir_parser_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_gir_parser_parse (ValaGirParser* self,
                       ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaSymbol* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	ValaGirParserNode* _tmp8_;
	ValaGirParserNode* _tmp9_;
	ValaGirParserNode* _tmp10_;
	ValaNamespace* glib_ns = NULL;
	ValaNamespace* _tmp11_;
	ValaNamespace* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaNamespace* _tmp16_;
	ValaNamespace* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_gir_parser_node_new (NULL);
	_vala_gir_parser_node_unref0 (self->priv->root);
	self->priv->root = _tmp1_;
	_tmp2_ = self->priv->root;
	_tmp3_ = vala_code_context_get_root (context);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp4_);
	_vala_code_node_unref0 (_tmp2_->symbol);
	_tmp2_->symbol = _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp6_);
	_vala_iterable_unref0 (self->priv->tree_stack);
	self->priv->tree_stack = _tmp7_;
	_tmp8_ = self->priv->root;
	_tmp9_ = _vala_gir_parser_node_ref0 (_tmp8_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp9_;
	vala_gir_parser_map_vala_to_gir (self);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	vala_gir_parser_resolve_gir_symbols (self);
	vala_gir_parser_create_new_namespaces (self);
	vala_gir_parser_resolve_type_arguments (self);
	_tmp10_ = self->priv->root;
	vala_gir_parser_node_process (_tmp10_, self);
	_tmp11_ = vala_code_context_get_root (context);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_scope_lookup (_tmp14_, "GLib");
	_tmp16_ = VALA_IS_NAMESPACE (_tmp15_) ? ((ValaNamespace*) _tmp15_) : NULL;
	if (_tmp16_ == NULL) {
		_vala_code_node_unref0 (_tmp15_);
	}
	glib_ns = _tmp16_;
	_tmp17_ = glib_ns;
	if (_tmp17_ != NULL) {
		ValaClass* object_type = NULL;
		ValaNamespace* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp18_ = glib_ns;
		_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_scope_lookup (_tmp20_, "Object");
		object_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaArrayList* _iface_list = NULL;
			ValaArrayList* _tmp22_;
			ValaArrayList* _tmp23_;
			gint _iface_size = 0;
			ValaArrayList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _iface_index = 0;
			_tmp22_ = self->priv->ifaces_needing_object_prereq;
			_tmp23_ = _vala_iterable_ref0 (_tmp22_);
			_iface_list = _tmp23_;
			_tmp24_ = _iface_list;
			_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_iface_size = _tmp26_;
			_iface_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				ValaInterface* iface = NULL;
				ValaArrayList* _tmp29_;
				gpointer _tmp30_;
				ValaInterface* _tmp31_;
				ValaClass* _tmp32_;
				ValaObjectType* _tmp33_;
				ValaObjectType* _tmp34_;
				_iface_index = _iface_index + 1;
				_tmp27_ = _iface_index;
				_tmp28_ = _iface_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _iface_list;
				_tmp30_ = vala_list_get ((ValaList*) _tmp29_, _iface_index);
				iface = (ValaInterface*) _tmp30_;
				_tmp31_ = iface;
				_tmp32_ = object_type;
				_tmp33_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp32_);
				_tmp34_ = _tmp33_;
				vala_interface_add_prerequisite (_tmp31_, (ValaDataType*) _tmp34_);
				_vala_code_node_unref0 (_tmp34_);
				_vala_code_node_unref0 (iface);
			}
			_vala_iterable_unref0 (_iface_list);
		}
		_vala_code_node_unref0 (object_type);
	}
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp35_;
		ValaArrayList* _tmp36_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _metadata_index = 0;
		_tmp35_ = self->priv->metadata_roots;
		_tmp36_ = _vala_iterable_ref0 (_tmp35_);
		_metadata_list = _tmp36_;
		_tmp37_ = _metadata_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_metadata_size = _tmp39_;
		_metadata_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp42_;
			gpointer _tmp43_;
			ValaGirParserMetadata* _tmp44_;
			_metadata_index = _metadata_index + 1;
			_tmp40_ = _metadata_index;
			_tmp41_ = _metadata_size;
			if (!(_tmp40_ < _tmp41_)) {
				break;
			}
			_tmp42_ = _metadata_list;
			_tmp43_ = vala_list_get ((ValaList*) _tmp42_, _metadata_index);
			metadata = (ValaGirParserMetadata*) _tmp43_;
			_tmp44_ = metadata;
			vala_gir_parser_report_unused_metadata (self, _tmp44_);
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_code_node_unref0 (glib_ns);
}

static void
vala_gir_parser_map_vala_to_gir (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _source_file_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _source_file_index = 0;
		_tmp0_ = self->priv->context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_source_file_list = _tmp2_;
		_tmp3_ = _source_file_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_source_file_size = _tmp5_;
		_source_file_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			gchar* gir_namespace = NULL;
			ValaSourceFile* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* gir_version = NULL;
			ValaSourceFile* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			ValaNamespace* ns = NULL;
			const gchar* _tmp18_;
			const gchar* _tmp37_;
			ValaSet* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaUnresolvedSymbol* gir_symbol = NULL;
			const gchar* _tmp43_;
			ValaUnresolvedSymbol* _tmp44_;
			const gchar* _tmp45_;
			ValaNamespace* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_source_file_index = _source_file_index + 1;
			_tmp6_ = _source_file_index;
			_tmp7_ = _source_file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _source_file_list;
			_tmp9_ = vala_list_get (_tmp8_, _source_file_index);
			source_file = (ValaSourceFile*) _tmp9_;
			_tmp10_ = source_file;
			_tmp11_ = vala_source_file_get_gir_namespace (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup (_tmp12_);
			gir_namespace = _tmp13_;
			_tmp14_ = source_file;
			_tmp15_ = vala_source_file_get_gir_version (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup (_tmp16_);
			gir_version = _tmp17_;
			ns = NULL;
			_tmp18_ = gir_namespace;
			if (_tmp18_ == NULL) {
				{
					ValaList* _node_list = NULL;
					ValaSourceFile* _tmp19_;
					ValaList* _tmp20_;
					ValaList* _tmp21_;
					gint _node_size = 0;
					ValaList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _node_index = 0;
					_tmp19_ = source_file;
					_tmp20_ = vala_source_file_get_nodes (_tmp19_);
					_tmp21_ = _vala_iterable_ref0 (_tmp20_);
					_node_list = _tmp21_;
					_tmp22_ = _node_list;
					_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_node_size = _tmp24_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp25_;
						gint _tmp26_;
						ValaCodeNode* node = NULL;
						ValaList* _tmp27_;
						gpointer _tmp28_;
						ValaCodeNode* _tmp29_;
						_node_index = _node_index + 1;
						_tmp25_ = _node_index;
						_tmp26_ = _node_size;
						if (!(_tmp25_ < _tmp26_)) {
							break;
						}
						_tmp27_ = _node_list;
						_tmp28_ = vala_list_get (_tmp27_, _node_index);
						node = (ValaCodeNode*) _tmp28_;
						_tmp29_ = node;
						if (VALA_IS_NAMESPACE (_tmp29_)) {
							ValaCodeNode* _tmp30_;
							ValaNamespace* _tmp31_;
							ValaNamespace* _tmp32_;
							gchar* _tmp33_;
							const gchar* _tmp34_;
							_tmp30_ = node;
							_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_NAMESPACE, ValaNamespace));
							_vala_code_node_unref0 (ns);
							ns = _tmp31_;
							_tmp32_ = ns;
							_tmp33_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp32_, "CCode", "gir_namespace", NULL);
							_g_free0 (gir_namespace);
							gir_namespace = _tmp33_;
							_tmp34_ = gir_namespace;
							if (_tmp34_ != NULL) {
								ValaNamespace* _tmp35_;
								gchar* _tmp36_;
								_tmp35_ = ns;
								_tmp36_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp35_, "CCode", "gir_version", NULL);
								_g_free0 (gir_version);
								gir_version = _tmp36_;
								_vala_code_node_unref0 (node);
								break;
							}
						}
						_vala_code_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
			}
			_tmp37_ = gir_namespace;
			if (_tmp37_ == NULL) {
				_vala_code_node_unref0 (ns);
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
				_vala_source_file_unref0 (source_file);
				continue;
			}
			_tmp38_ = self->priv->provided_namespaces;
			_tmp39_ = gir_namespace;
			_tmp40_ = gir_version;
			_tmp41_ = g_strdup_printf ("%s-%s", _tmp39_, _tmp40_);
			_tmp42_ = _tmp41_;
			vala_collection_add ((ValaCollection*) _tmp38_, _tmp42_);
			_g_free0 (_tmp42_);
			_tmp43_ = gir_namespace;
			_tmp44_ = vala_unresolved_symbol_new (NULL, _tmp43_, NULL);
			gir_symbol = _tmp44_;
			_tmp45_ = gir_namespace;
			_tmp46_ = ns;
			_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
			_tmp48_ = _tmp47_;
			if (g_strcmp0 (_tmp45_, _tmp48_) != 0) {
				ValaUnresolvedSymbol* _tmp49_;
				ValaNamespace* _tmp50_;
				_tmp49_ = gir_symbol;
				_tmp50_ = ns;
				vala_gir_parser_set_symbol_mapping (self, _tmp49_, (ValaSymbol*) _tmp50_);
			}
			{
				ValaList* _node_list = NULL;
				ValaSourceFile* _tmp51_;
				ValaList* _tmp52_;
				ValaList* _tmp53_;
				gint _node_size = 0;
				ValaList* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				gint _node_index = 0;
				_tmp51_ = source_file;
				_tmp52_ = vala_source_file_get_nodes (_tmp51_);
				_tmp53_ = _vala_iterable_ref0 (_tmp52_);
				_node_list = _tmp53_;
				_tmp54_ = _node_list;
				_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
				_tmp56_ = _tmp55_;
				_node_size = _tmp56_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp57_;
					gint _tmp58_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp59_;
					gpointer _tmp60_;
					ValaCodeNode* _tmp61_;
					_node_index = _node_index + 1;
					_tmp57_ = _node_index;
					_tmp58_ = _node_size;
					if (!(_tmp57_ < _tmp58_)) {
						break;
					}
					_tmp59_ = _node_list;
					_tmp60_ = vala_list_get (_tmp59_, _node_index);
					node = (ValaCodeNode*) _tmp60_;
					_tmp61_ = node;
					if (vala_code_node_has_attribute_argument (_tmp61_, "GIR", "name")) {
						ValaUnresolvedSymbol* map_from = NULL;
						ValaUnresolvedSymbol* _tmp62_;
						ValaCodeNode* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						ValaUnresolvedSymbol* _tmp66_;
						ValaUnresolvedSymbol* _tmp67_;
						ValaUnresolvedSymbol* _tmp68_;
						ValaCodeNode* _tmp69_;
						_tmp62_ = gir_symbol;
						_tmp63_ = node;
						_tmp64_ = vala_code_node_get_attribute_string (_tmp63_, "GIR", "name", NULL);
						_tmp65_ = _tmp64_;
						_tmp66_ = vala_unresolved_symbol_new (_tmp62_, _tmp65_, NULL);
						_tmp67_ = _tmp66_;
						_g_free0 (_tmp65_);
						map_from = _tmp67_;
						_tmp68_ = map_from;
						_tmp69_ = node;
						vala_gir_parser_set_symbol_mapping (self, _tmp68_, G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_SYMBOL, ValaSymbol));
						_vala_code_node_unref0 (map_from);
					}
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_vala_code_node_unref0 (gir_symbol);
			_vala_code_node_unref0 (ns);
			_g_free0 (gir_version);
			_g_free0 (gir_namespace);
			_vala_source_file_unref0 (source_file);
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}

static void
vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                        ValaSourceFile* source_file)
{
	ValaGirParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGirParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gir")) {
		vala_gir_parser_parse_file (self, source_file);
	}
}

static gpointer
_vala_gir_parser_metadata_ref0 (gpointer self)
{
	return self ? vala_gir_parser_metadata_ref (self) : NULL;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

void
vala_gir_parser_parse_file (ValaGirParser* self,
                            ValaSourceFile* source_file)
{
	gboolean has_global_context = FALSE;
	ValaCodeContext* _tmp0_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	ValaGirParserMetadata* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaSourceFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaMarkupReader* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = self->priv->context;
	has_global_context = _tmp0_ != NULL;
	if (!has_global_context) {
		ValaCodeContext* _tmp1_;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		_tmp1_ = vala_source_file_get_context (source_file);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_code_context_ref0 (_tmp2_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = _tmp3_;
	}
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	self->priv->metadata_stack = _tmp5_;
	_tmp6_ = vala_gir_parser_metadata_get_empty ();
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_gir_parser_metadata_ref0 (_tmp7_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp8_;
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	self->priv->cheader_filenames = NULL;
	self->priv->cheader_filenames_length1 = 0;
	self->priv->_cheader_filenames_size_ = self->priv->cheader_filenames_length1;
	_tmp9_ = _vala_source_file_ref0 (source_file);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp9_;
	_tmp10_ = vala_source_file_get_filename (source_file);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_markup_reader_new (_tmp11_);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = _tmp12_;
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_parse_repository (self);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = NULL;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = NULL;
	if (!has_global_context) {
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
	}
}

static void
vala_gir_parser_next (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValaMarkupTokenType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_read_token (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->begin = _tmp1_;
	self->priv->end = _tmp2_;
	self->priv->current_token = _tmp3_;
}

static void
vala_gir_parser_start_element (ValaGirParser* self,
                               const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected start element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
	}
}

static void
vala_gir_parser_end_element (ValaGirParser* self,
                             const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaMarkupTokenType _tmp1_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->current_token;
		if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
			_tmp0_ = TRUE;
		} else {
			ValaMarkupReader* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->reader;
			_tmp3_ = vala_markup_reader_get_name (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected end element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_warning (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
		vala_gir_parser_skip_element (self);
	}
	vala_gir_parser_next (self);
}

static ValaSourceReference*
vala_gir_parser_get_current_src (ValaGirParser* self)
{
	ValaSourceFile* _tmp0_;
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_source_file;
	_tmp1_ = self->priv->begin;
	_tmp2_ = self->priv->end;
	_tmp3_ = vala_source_reference_new (_tmp0_, &_tmp1_, &_tmp2_);
	result = _tmp3_;
	return result;
}

static ValaSourceReference*
vala_gir_parser_get_src (ValaGirParser* self,
                         ValaSourceLocation* begin,
                         ValaSourceLocation* end)
{
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->current_source_file;
	_tmp2_ = *begin;
	_tmp3_ = e;
	_tmp4_ = vala_source_reference_new (_tmp1_, &_tmp2_, &_tmp3_);
	result = _tmp4_;
	return result;
}

static void
vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                         ValaSymbol* sym)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (VALA_IS_CLASS (container)) {
		ValaClass* cl = NULL;
		cl = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_CLASS, ValaClass);
		if (VALA_IS_CLASS (sym)) {
			ValaClass* _tmp0_;
			_tmp0_ = cl;
			vala_symbol_add_class ((ValaSymbol*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				ValaClass* _tmp1_;
				_tmp1_ = cl;
				vala_symbol_add_constant ((ValaSymbol*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaClass* _tmp2_;
					_tmp2_ = cl;
					vala_symbol_add_enum ((ValaSymbol*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				} else {
					if (VALA_IS_FIELD (sym)) {
						ValaClass* _tmp3_;
						_tmp3_ = cl;
						vala_symbol_add_field ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
					} else {
						if (VALA_IS_METHOD (sym)) {
							ValaClass* _tmp4_;
							_tmp4_ = cl;
							vala_symbol_add_method ((ValaSymbol*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								ValaClass* _tmp5_;
								_tmp5_ = cl;
								vala_symbol_add_property ((ValaSymbol*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									ValaClass* _tmp6_;
									_tmp6_ = cl;
									vala_symbol_add_signal ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									if (VALA_IS_STRUCT (sym)) {
										ValaClass* _tmp7_;
										_tmp7_ = cl;
										vala_symbol_add_struct ((ValaSymbol*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (VALA_IS_ENUM (container)) {
			ValaEnum* en = NULL;
			en = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ENUM, ValaEnum);
			if (VALA_IS_ENUM_VALUE (sym)) {
				ValaEnum* _tmp8_;
				_tmp8_ = en;
				vala_enum_add_value (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				if (VALA_IS_CONSTANT (sym)) {
					ValaEnum* _tmp9_;
					_tmp9_ = en;
					vala_symbol_add_constant ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					if (VALA_IS_METHOD (sym)) {
						ValaEnum* _tmp10_;
						_tmp10_ = en;
						vala_symbol_add_method ((ValaSymbol*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			if (VALA_IS_INTERFACE (container)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_INTERFACE, ValaInterface);
				if (VALA_IS_CLASS (sym)) {
					ValaInterface* _tmp11_;
					_tmp11_ = iface;
					vala_symbol_add_class ((ValaSymbol*) _tmp11_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
				} else {
					if (VALA_IS_CONSTANT (sym)) {
						ValaInterface* _tmp12_;
						_tmp12_ = iface;
						vala_symbol_add_constant ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						if (VALA_IS_ENUM (sym)) {
							ValaInterface* _tmp13_;
							_tmp13_ = iface;
							vala_symbol_add_enum ((ValaSymbol*) _tmp13_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
						} else {
							if (VALA_IS_FIELD (sym)) {
								ValaInterface* _tmp14_;
								_tmp14_ = iface;
								vala_symbol_add_field ((ValaSymbol*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaInterface* _tmp15_;
									_tmp15_ = iface;
									vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										ValaInterface* _tmp16_;
										_tmp16_ = iface;
										vala_symbol_add_property ((ValaSymbol*) _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (VALA_IS_SIGNAL (sym)) {
											ValaInterface* _tmp17_;
											_tmp17_ = iface;
											vala_symbol_add_signal ((ValaSymbol*) _tmp17_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											if (VALA_IS_STRUCT (sym)) {
												ValaInterface* _tmp18_;
												_tmp18_ = iface;
												vala_symbol_add_struct ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NAMESPACE (container)) {
					ValaNamespace* ns = NULL;
					ns = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_NAMESPACE, ValaNamespace);
					if (VALA_IS_NAMESPACE (sym)) {
						ValaNamespace* _tmp19_;
						_tmp19_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp19_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						if (VALA_IS_CLASS (sym)) {
							ValaNamespace* _tmp20_;
							_tmp20_ = ns;
							vala_symbol_add_class ((ValaSymbol*) _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
						} else {
							if (VALA_IS_CONSTANT (sym)) {
								ValaNamespace* _tmp21_;
								_tmp21_ = ns;
								vala_symbol_add_constant ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								if (VALA_IS_DELEGATE (sym)) {
									ValaNamespace* _tmp22_;
									_tmp22_ = ns;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp22_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									if (VALA_IS_ENUM (sym)) {
										ValaNamespace* _tmp23_;
										_tmp23_ = ns;
										vala_symbol_add_enum ((ValaSymbol*) _tmp23_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
									} else {
										if (VALA_IS_ERROR_DOMAIN (sym)) {
											ValaNamespace* _tmp24_;
											_tmp24_ = ns;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											if (VALA_IS_FIELD (sym)) {
												ValaField* field = NULL;
												ValaField* _tmp25_;
												ValaMemberBinding _tmp26_;
												ValaMemberBinding _tmp27_;
												ValaNamespace* _tmp29_;
												ValaField* _tmp30_;
												field = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField);
												_tmp25_ = field;
												_tmp26_ = vala_field_get_binding (_tmp25_);
												_tmp27_ = _tmp26_;
												if (_tmp27_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp28_;
													_tmp28_ = field;
													vala_field_set_binding (_tmp28_, VALA_MEMBER_BINDING_STATIC);
												}
												_tmp29_ = ns;
												_tmp30_ = field;
												vala_symbol_add_field ((ValaSymbol*) _tmp29_, _tmp30_);
											} else {
												if (VALA_IS_INTERFACE (sym)) {
													ValaNamespace* _tmp31_;
													_tmp31_ = ns;
													vala_symbol_add_interface ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													if (VALA_IS_METHOD (sym)) {
														ValaMethod* method = NULL;
														ValaMethod* _tmp32_;
														ValaMemberBinding _tmp33_;
														ValaMemberBinding _tmp34_;
														ValaNamespace* _tmp36_;
														ValaMethod* _tmp37_;
														method = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod);
														_tmp32_ = method;
														_tmp33_ = vala_method_get_binding (_tmp32_);
														_tmp34_ = _tmp33_;
														if (_tmp34_ == VALA_MEMBER_BINDING_INSTANCE) {
															ValaMethod* _tmp35_;
															_tmp35_ = method;
															vala_method_set_binding (_tmp35_, VALA_MEMBER_BINDING_STATIC);
														}
														_tmp36_ = ns;
														_tmp37_ = method;
														vala_symbol_add_method ((ValaSymbol*) _tmp36_, _tmp37_);
													} else {
														if (VALA_IS_STRUCT (sym)) {
															ValaNamespace* _tmp38_;
															_tmp38_ = ns;
															vala_symbol_add_struct ((ValaSymbol*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (VALA_IS_STRUCT (container)) {
						ValaStruct* st = NULL;
						st = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_STRUCT, ValaStruct);
						if (VALA_IS_CONSTANT (sym)) {
							ValaStruct* _tmp39_;
							_tmp39_ = st;
							vala_symbol_add_constant ((ValaSymbol*) _tmp39_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							if (VALA_IS_FIELD (sym)) {
								ValaStruct* _tmp40_;
								_tmp40_ = st;
								vala_symbol_add_field ((ValaSymbol*) _tmp40_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaStruct* _tmp41_;
									_tmp41_ = st;
									vala_symbol_add_method ((ValaSymbol*) _tmp41_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										ValaStruct* _tmp42_;
										_tmp42_ = st;
										vala_symbol_add_property ((ValaSymbol*) _tmp42_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					} else {
						if (VALA_IS_ERROR_DOMAIN (container)) {
							ValaErrorDomain* ed = NULL;
							ed = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain);
							if (VALA_IS_ERROR_CODE (sym)) {
								ValaErrorDomain* _tmp43_;
								_tmp43_ = ed;
								vala_error_domain_add_code (_tmp43_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_CODE, ValaErrorCode));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaErrorDomain* _tmp44_;
									_tmp44_ = ed;
									vala_symbol_add_method ((ValaSymbol*) _tmp44_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								}
							}
						} else {
							ValaSourceReference* _tmp45_;
							ValaSourceReference* _tmp46_;
							const gchar* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							const gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
							_tmp46_ = _tmp45_;
							_tmp47_ = vala_symbol_get_name (sym);
							_tmp48_ = _tmp47_;
							_tmp49_ = vala_symbol_get_name (container);
							_tmp50_ = _tmp49_;
							_tmp51_ = g_strdup_printf ("impossible to add `%s' to container `%s'", _tmp48_, _tmp50_);
							_tmp52_ = _tmp51_;
							vala_report_error (_tmp46_, _tmp52_);
							_g_free0 (_tmp52_);
						}
					}
				}
			}
		}
	}
}

static gboolean
vala_gir_parser_is_container (ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = VALA_IS_STRUCT (sym);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = VALA_IS_NAMESPACE (sym);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALA_IS_ERROR_DOMAIN (sym);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_ENUM (sym);
	}
	result = _tmp0_;
	return result;
}

static ValaUnresolvedSymbol*
vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                          const gchar* symbol_string,
                                          ValaSourceReference* source_reference)
{
	ValaUnresolvedSymbol* sym = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	ValaUnresolvedSymbol* _tmp5_;
	ValaUnresolvedSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_;
				const gchar* _tmp3_;
				ValaUnresolvedSymbol* _tmp4_;
				_tmp2_ = sym;
				_tmp3_ = s;
				_tmp4_ = vala_unresolved_symbol_new (_tmp2_, _tmp3_, source_reference);
				_vala_code_node_unref0 (sym);
				sym = _tmp4_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = sym;
	if (_tmp5_ == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}

static void
vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                    ValaUnresolvedSymbol* map_from,
                                    ValaSymbol* map_to)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (map_from != NULL);
	g_return_if_fail (map_to != NULL);
	if (VALA_IS_UNRESOLVED_SYMBOL (map_from)) {
		ValaHashMap* _tmp0_;
		_tmp0_ = self->priv->unresolved_symbols_map;
		vala_map_set ((ValaMap*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (map_from, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol), map_to);
	}
}

static void
vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                        ValaSignal* sig,
                                        ValaSymbol* sym,
                                        gboolean skip_first)
{
	ValaIterator* iter = NULL;
	ValaList* _tmp0_;
	ValaIterator* _tmp1_;
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_callable_get_parameters (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CALLABLE, ValaCallable));
	_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
	iter = _tmp1_;
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaParameter* param = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValaParameter* _tmp14_;
			ValaIterator* _tmp15_;
			gpointer _tmp16_;
			ValaParameter* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_param_index = _param_index + 1;
			_tmp7_ = _param_index;
			_tmp8_ = _param_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _param_list;
			_tmp10_ = vala_list_get (_tmp9_, _param_index);
			param = (ValaParameter*) _tmp10_;
			_tmp11_ = iter;
			if (!vala_iterator_next (_tmp11_)) {
				_vala_code_node_unref0 (param);
				break;
			}
			if (skip_first) {
				_tmp12_ = first;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValaIterator* _tmp13_;
				_tmp13_ = iter;
				if (!vala_iterator_next (_tmp13_)) {
					_vala_code_node_unref0 (param);
					break;
				}
				first = FALSE;
			}
			_tmp14_ = param;
			_tmp15_ = iter;
			_tmp16_ = vala_iterator_get (_tmp15_);
			_tmp17_ = (ValaParameter*) _tmp16_;
			_tmp18_ = vala_symbol_get_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			vala_symbol_set_name ((ValaSymbol*) _tmp14_, _tmp19_);
			_vala_code_node_unref0 (_tmp17_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_vala_iterator_unref0 (iter);
}

static ValaGirParserNode*
vala_gir_parser_find_invoker (ValaGirParser* self,
                              ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gchar* prefix = NULL;
	ValaMethod* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	ValaGirParserNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_", _tmp4_);
	prefix = _tmp5_;
	{
		ValaArrayList* _n_list = NULL;
		ValaGirParserNode* _tmp6_;
		ValaArrayList* _tmp7_;
		ValaArrayList* _tmp8_;
		gint _n_size = 0;
		ValaArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _n_index = 0;
		_tmp6_ = node->parent;
		_tmp7_ = _tmp6_->members;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_n_list = _tmp8_;
		_tmp9_ = _n_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_n_size = _tmp11_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp14_;
			gpointer _tmp15_;
			ValaGirParserNode* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			ValaMethod* invoker = NULL;
			ValaGirParserNode* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMethod* _tmp21_;
			gboolean _tmp22_ = FALSE;
			ValaMethod* _tmp23_;
			ValaIterator* iter = NULL;
			ValaMethod* _tmp32_;
			ValaList* _tmp33_;
			ValaIterator* _tmp34_;
			ValaMethod* _tmp55_;
			_n_index = _n_index + 1;
			_tmp12_ = _n_index;
			_tmp13_ = _n_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _n_list;
			_tmp15_ = vala_list_get ((ValaList*) _tmp14_, _n_index);
			n = (ValaGirParserNode*) _tmp15_;
			_tmp16_ = n;
			_tmp17_ = _tmp16_->name;
			_tmp18_ = prefix;
			if (!g_str_has_prefix (_tmp17_, _tmp18_)) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp19_ = n;
			_tmp20_ = _tmp19_->symbol;
			_tmp21_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp20_) ? ((ValaMethod*) _tmp20_) : NULL);
			invoker = _tmp21_;
			_tmp23_ = invoker;
			if (_tmp23_ == NULL) {
				_tmp22_ = TRUE;
			} else {
				ValaMethod* _tmp24_;
				ValaList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				ValaMethod* _tmp28_;
				ValaList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				_tmp24_ = m;
				_tmp25_ = vala_callable_get_parameters ((ValaCallable*) _tmp24_);
				_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = invoker;
				_tmp29_ = vala_callable_get_parameters ((ValaCallable*) _tmp28_);
				_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp22_ = _tmp27_ != _tmp31_;
			}
			if (_tmp22_) {
				_vala_code_node_unref0 (invoker);
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp32_ = invoker;
			_tmp33_ = vala_callable_get_parameters ((ValaCallable*) _tmp32_);
			_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
			iter = _tmp34_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp35_;
				ValaList* _tmp36_;
				ValaList* _tmp37_;
				gint _param_size = 0;
				ValaList* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint _param_index = 0;
				_tmp35_ = m;
				_tmp36_ = vala_callable_get_parameters ((ValaCallable*) _tmp35_);
				_tmp37_ = _vala_iterable_ref0 (_tmp36_);
				_param_list = _tmp37_;
				_tmp38_ = _param_list;
				_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
				_tmp40_ = _tmp39_;
				_param_size = _tmp40_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp41_;
					gint _tmp42_;
					ValaParameter* param = NULL;
					ValaList* _tmp43_;
					gpointer _tmp44_;
					ValaIterator* _tmp45_;
					ValaParameter* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					ValaIterator* _tmp49_;
					gpointer _tmp50_;
					ValaParameter* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					gboolean _tmp54_;
					_param_index = _param_index + 1;
					_tmp41_ = _param_index;
					_tmp42_ = _param_size;
					if (!(_tmp41_ < _tmp42_)) {
						break;
					}
					_tmp43_ = _param_list;
					_tmp44_ = vala_list_get (_tmp43_, _param_index);
					param = (ValaParameter*) _tmp44_;
					_tmp45_ = iter;
					_vala_assert (vala_iterator_next (_tmp45_), "iter.next ()");
					_tmp46_ = param;
					_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = iter;
					_tmp50_ = vala_iterator_get (_tmp49_);
					_tmp51_ = (ValaParameter*) _tmp50_;
					_tmp52_ = vala_symbol_get_name ((ValaSymbol*) _tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = g_strcmp0 (_tmp48_, _tmp53_) != 0;
					_vala_code_node_unref0 (_tmp51_);
					if (_tmp54_) {
						_vala_code_node_unref0 (invoker);
						invoker = NULL;
						_vala_code_node_unref0 (param);
						break;
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp55_ = invoker;
			if (_tmp55_ != NULL) {
				result = n;
				_vala_iterator_unref0 (iter);
				_vala_code_node_unref0 (invoker);
				_vala_iterable_unref0 (_n_list);
				_g_free0 (prefix);
				_vala_code_node_unref0 (m);
				return result;
			}
			_vala_iterator_unref0 (iter);
			_vala_code_node_unref0 (invoker);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	result = NULL;
	_g_free0 (prefix);
	_vala_code_node_unref0 (m);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_get_current_metadata (ValaGirParser* self)
{
	gchar* selector = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* child_name = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	ValaGirParserMetadata* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaGirParserMetadata* _tmp29_;
	ValaGirParserMetadata* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	selector = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "name");
	child_name = _tmp5_;
	_tmp6_ = child_name;
	if (_tmp6_ == NULL) {
		ValaMarkupReader* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->reader;
		_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "glib:name");
		_g_free0 (child_name);
		child_name = _tmp8_;
	}
	_tmp10_ = selector;
	if (g_strcmp0 (_tmp10_, "union") == 0) {
		const gchar* _tmp11_;
		_tmp11_ = child_name;
		_tmp9_ = _tmp11_ == NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("union");
		_g_free0 (child_name);
		child_name = _tmp12_;
	}
	_tmp13_ = child_name;
	if (_tmp13_ == NULL) {
		ValaGirParserMetadata* _tmp14_;
		ValaGirParserMetadata* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		_tmp14_ = vala_gir_parser_metadata_get_empty ();
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_gir_parser_metadata_ref0 (_tmp15_);
		result = _tmp16_;
		_g_free0 (child_name);
		_g_free0 (selector);
		return result;
	}
	_tmp17_ = selector;
	_tmp18_ = string_replace (_tmp17_, "-", "_");
	_g_free0 (selector);
	selector = _tmp18_;
	_tmp19_ = child_name;
	_tmp20_ = string_replace (_tmp19_, "-", "_");
	_g_free0 (child_name);
	child_name = _tmp20_;
	_tmp21_ = selector;
	if (g_str_has_prefix (_tmp21_, "glib:")) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = selector;
		_tmp23_ = strlen ("glib:");
		_tmp24_ = _tmp23_;
		_tmp25_ = string_substring (_tmp22_, (glong) _tmp24_, (glong) -1);
		_g_free0 (selector);
		selector = _tmp25_;
	}
	_tmp26_ = self->priv->metadata;
	_tmp27_ = child_name;
	_tmp28_ = selector;
	_tmp29_ = vala_gir_parser_metadata_match_child (_tmp26_, _tmp27_, _tmp28_);
	result = _tmp29_;
	_g_free0 (child_name);
	_g_free0 (selector);
	return result;
}

static gboolean
vala_gir_parser_push_metadata (ValaGirParser* self)
{
	ValaGirParserMetadata* new_metadata = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaArrayList* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	ValaGirParserMetadata* _tmp13_;
	ValaGirParserMetadata* _tmp14_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_get_current_metadata (self);
	new_metadata = _tmp0_;
	_tmp1_ = new_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP)) {
		ValaGirParserMetadata* _tmp2_;
		_tmp2_ = new_metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, FALSE)) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	} else {
		gboolean _tmp3_ = FALSE;
		ValaMarkupReader* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "introspectable");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "0") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp3_ = TRUE;
		} else {
			ValaMarkupReader* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->reader;
			_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "private");
			_tmp10_ = _tmp9_;
			_tmp3_ = g_strcmp0 (_tmp10_, "1") == 0;
			_g_free0 (_tmp10_);
		}
		if (_tmp3_) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	}
	_tmp11_ = self->priv->metadata_stack;
	_tmp12_ = self->priv->metadata;
	vala_collection_add ((ValaCollection*) _tmp11_, _tmp12_);
	_tmp13_ = new_metadata;
	_tmp14_ = _vala_gir_parser_metadata_ref0 (_tmp13_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp14_;
	result = TRUE;
	_vala_gir_parser_metadata_unref0 (new_metadata);
	return result;
}

static void
vala_gir_parser_pop_metadata (ValaGirParser* self)
{
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadata_stack;
	_tmp1_ = self->priv->metadata_stack;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_list_remove_at ((ValaList*) _tmp0_, _tmp3_ - 1);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = (ValaGirParserMetadata*) _tmp4_;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                  ValaDataType* parent_type,
                                                  const gchar* type_arguments,
                                                  ValaSourceReference* source_reference)
{
	gint type_arguments_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* current = NULL;
	GString* _tmp2_;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp19_;
	const gchar* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	_tmp1_ = _tmp0_;
	type_arguments_length = (gint) _tmp1_;
	_tmp2_ = g_string_sized_new ((gsize) type_arguments_length);
	current = _tmp2_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = c;
					c = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(c < type_arguments_length)) {
					break;
				}
				if (string_get (type_arguments, (glong) c) == '<') {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = string_get (type_arguments, (glong) c) == '[';
				}
				if (_tmp5_) {
					gint _tmp6_;
					GString* _tmp7_;
					_tmp6_ = depth;
					depth = _tmp6_ + 1;
					_tmp7_ = current;
					g_string_append_unichar (_tmp7_, (gunichar) string_get (type_arguments, (glong) c));
				} else {
					gboolean _tmp8_ = FALSE;
					if (string_get (type_arguments, (glong) c) == '>') {
						_tmp8_ = TRUE;
					} else {
						_tmp8_ = string_get (type_arguments, (glong) c) == ']';
					}
					if (_tmp8_) {
						gint _tmp9_;
						GString* _tmp10_;
						_tmp9_ = depth;
						depth = _tmp9_ - 1;
						_tmp10_ = current;
						g_string_append_unichar (_tmp10_, (gunichar) string_get (type_arguments, (glong) c));
					} else {
						if (string_get (type_arguments, (glong) c) == ',') {
							if (depth == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp11_;
								const gchar* _tmp12_;
								ValaDataType* _tmp13_;
								ValaDataType* _tmp14_;
								ValaDataType* _tmp15_;
								GString* _tmp16_;
								_tmp11_ = current;
								_tmp12_ = _tmp11_->str;
								_tmp13_ = vala_gir_parser_parse_type_from_string (self, _tmp12_, TRUE, source_reference);
								dt = _tmp13_;
								_tmp14_ = dt;
								if (_tmp14_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp15_ = dt;
								vala_data_type_add_type_argument (parent_type, _tmp15_);
								_tmp16_ = current;
								g_string_truncate (_tmp16_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp17_;
								_tmp17_ = current;
								g_string_append_unichar (_tmp17_, (gunichar) string_get (type_arguments, (glong) c));
							}
						} else {
							GString* _tmp18_;
							_tmp18_ = current;
							g_string_append_unichar (_tmp18_, (gunichar) string_get (type_arguments, (glong) c));
						}
					}
				}
			}
		}
	}
	_tmp19_ = current;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = vala_gir_parser_parse_type_from_string (self, _tmp20_, TRUE, source_reference);
	dt = _tmp21_;
	_tmp22_ = dt;
	if (_tmp22_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp23_ = dt;
	vala_data_type_add_type_argument (parent_type, _tmp23_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                        const gchar* type_string,
                                        gboolean owned_by_default,
                                        ValaSourceReference* source_reference)
{
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gchar* type_name = NULL;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp14_;
	gchar* _tmp15_;
	gchar* array_data = NULL;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean nullable = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gboolean value_owned = FALSE;
	const gchar* _tmp39_;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp41_;
	ValaUnresolvedSymbol* _tmp42_;
	ValaUnresolvedSymbol* _tmp43_;
	ValaUnresolvedSymbol* _tmp44_;
	ValaUnresolvedType* _tmp45_;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp47_;
	const gchar* _tmp53_;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp73_;
	GError* _inner_error0_ = NULL;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gir_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[,*" \
"\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gir_parser_type_from_string_regex);
			vala_gir_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagirparser.vala:1750: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = vala_gir_parser_type_from_string_regex;
	_tmp7_ = g_regex_match (_tmp5_, type_string, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp8_ = match;
	_tmp9_ = g_match_info_fetch (_tmp8_, 1);
	ownership_data = _tmp9_;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 2);
	type_name = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 3);
	type_arguments_data = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 4);
	pointers_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 5);
	array_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 6);
	nullable_data = _tmp19_;
	_tmp21_ = nullable_data;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = nullable_data;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ > 0;
	} else {
		_tmp20_ = FALSE;
	}
	nullable = _tmp20_;
	_tmp26_ = ownership_data;
	if (_tmp26_ == NULL) {
		const gchar* _tmp27_;
		_tmp27_ = type_name;
		_tmp25_ = g_strcmp0 (_tmp27_, "void") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		_tmp29_ = array_data;
		if (_tmp29_ == NULL) {
			_tmp28_ = !nullable;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaVoidType* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = vala_void_type_new (source_reference);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp30_;
			_tmp31_ = pointers_data;
			if (_tmp31_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							const gchar* _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							ValaDataType* _tmp37_;
							ValaPointerType* _tmp38_;
							if (!_tmp32_) {
								gint _tmp33_;
								_tmp33_ = i;
								i = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = pointers_data;
							_tmp35_ = strlen (_tmp34_);
							_tmp36_ = _tmp35_;
							if (!(i < _tmp36_)) {
								break;
							}
							_tmp37_ = type;
							_tmp38_ = vala_pointer_type_new (_tmp37_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp38_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	_tmp39_ = ownership_data;
	if (g_strcmp0 (_tmp39_, "owned") == 0) {
		if (owned_by_default) {
			vala_report_error (source_reference, "unexpected `owned' keyword");
		} else {
			value_owned = TRUE;
		}
	} else {
		const gchar* _tmp40_;
		_tmp40_ = ownership_data;
		if (g_strcmp0 (_tmp40_, "unowned") == 0) {
			if (owned_by_default) {
				value_owned = FALSE;
			} else {
				vala_report_error (source_reference, "unexpected `unowned' keyword");
				result = NULL;
				_g_free0 (nullable_data);
				_g_free0 (array_data);
				_g_free0 (pointers_data);
				_g_free0 (type_arguments_data);
				_g_free0 (type_name);
				_g_free0 (ownership_data);
				_vala_code_node_unref0 (type);
				_g_match_info_unref0 (match);
				return result;
			}
		}
	}
	_tmp41_ = type_name;
	_tmp42_ = vala_gir_parser_parse_symbol_from_string (self, _tmp41_, source_reference);
	sym = _tmp42_;
	_tmp43_ = sym;
	if (_tmp43_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp44_ = sym;
	_tmp45_ = vala_unresolved_type_new_from_symbol (_tmp44_, source_reference);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp45_;
	_tmp47_ = type_arguments_data;
	if (_tmp47_ != NULL) {
		const gchar* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		_tmp48_ = type_arguments_data;
		_tmp49_ = strlen (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp46_ = _tmp50_ > 0;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		ValaDataType* _tmp51_;
		const gchar* _tmp52_;
		_tmp51_ = type;
		_tmp52_ = type_arguments_data;
		if (!vala_gir_parser_parse_type_arguments_from_string (self, _tmp51_, _tmp52_, source_reference)) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp53_ = pointers_data;
	if (_tmp53_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp54_ = FALSE;
				_tmp54_ = TRUE;
				while (TRUE) {
					const gchar* _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					ValaDataType* _tmp59_;
					ValaPointerType* _tmp60_;
					if (!_tmp54_) {
						gint _tmp55_;
						_tmp55_ = i;
						i = _tmp55_ + 1;
					}
					_tmp54_ = FALSE;
					_tmp56_ = pointers_data;
					_tmp57_ = strlen (_tmp56_);
					_tmp58_ = _tmp57_;
					if (!(i < _tmp58_)) {
						break;
					}
					_tmp59_ = type;
					_tmp60_ = vala_pointer_type_new (_tmp59_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp60_;
				}
			}
		}
	}
	_tmp62_ = array_data;
	if (_tmp62_ != NULL) {
		const gchar* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		_tmp63_ = array_data;
		_tmp64_ = strlen (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp61_ = _tmp65_ != 0;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		const gchar* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		ValaArrayType* _tmp71_;
		_tmp66_ = type;
		vala_data_type_set_value_owned (_tmp66_, TRUE);
		_tmp67_ = type;
		_tmp68_ = array_data;
		_tmp69_ = strlen (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_array_type_new (_tmp67_, ((gint) _tmp70_) - 1, source_reference);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp71_;
	}
	_tmp72_ = type;
	vala_data_type_set_nullable (_tmp72_, nullable);
	_tmp73_ = type;
	vala_data_type_set_value_owned (_tmp73_, value_owned);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}

static gchar*
vala_gir_parser_element_get_string (ValaGirParser* self,
                                    const gchar* attribute_name,
                                    ValaGirParserArgumentType arg_type)
{
	ValaGirParserMetadata* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute_name != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, arg_type)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, arg_type);
		result = _tmp2_;
		return result;
	} else {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, attribute_name);
		result = _tmp4_;
		return result;
	}
}

static ValaDataType*
vala_gir_parser_element_get_type (ValaGirParser* self,
                                  ValaDataType* orig_type,
                                  gboolean owned_by_default,
                                  gboolean* no_array_length,
                                  gboolean* array_null_terminated,
                                  gboolean* changed)
{
	gboolean _vala_changed = FALSE;
	ValaDataType* type = NULL;
	ValaDataType* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaDataType* _tmp43_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (orig_type != NULL, NULL);
	_vala_changed = FALSE;
	_tmp0_ = _vala_code_node_ref0 (orig_type);
	type = _tmp0_;
	_tmp1_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE)) {
		ValaGirParserMetadata* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserMetadata* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp2_ = self->priv->metadata;
		_tmp3_ = vala_gir_parser_metadata_get_string (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->metadata;
		_tmp6_ = vala_gir_parser_metadata_get_source_reference (_tmp5_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_gir_parser_parse_type_from_string (self, _tmp4_, owned_by_default, _tmp7_);
		_vala_code_node_unref0 (type);
		type = _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_g_free0 (_tmp4_);
		_vala_changed = TRUE;
	} else {
		ValaDataType* _tmp9_;
		_tmp9_ = type;
		if (!VALA_IS_VOID_TYPE (_tmp9_)) {
			ValaGirParserMetadata* _tmp10_;
			gboolean _tmp19_ = FALSE;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp38_;
			ValaGirParserMetadata* _tmp39_;
			ValaDataType* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			_tmp10_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS)) {
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValaGirParserMetadata* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				_tmp11_ = type;
				vala_data_type_remove_all_type_arguments (_tmp11_);
				_tmp12_ = type;
				_tmp13_ = self->priv->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->priv->metadata;
				_tmp17_ = vala_gir_parser_metadata_get_source_reference (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp18_ = _tmp17_;
				vala_gir_parser_parse_type_arguments_from_string (self, _tmp12_, _tmp15_, _tmp18_);
				_vala_source_reference_unref0 (_tmp18_);
				_g_free0 (_tmp15_);
			}
			_tmp20_ = type;
			if (!VALA_IS_ARRAY_TYPE (_tmp20_)) {
				ValaGirParserMetadata* _tmp21_;
				_tmp21_ = self->priv->metadata;
				_tmp19_ = vala_gir_parser_metadata_get_bool (_tmp21_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, FALSE);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				ValaDataType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaArrayType* _tmp27_;
				_tmp22_ = type;
				vala_data_type_set_value_owned (_tmp22_, TRUE);
				_tmp23_ = type;
				_tmp24_ = type;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_array_type_new (_tmp23_, 1, _tmp26_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp27_;
				_vala_changed = TRUE;
			}
			if (owned_by_default) {
				ValaDataType* _tmp28_;
				ValaGirParserMetadata* _tmp29_;
				ValaDataType* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp28_ = type;
				_tmp29_ = self->priv->metadata;
				_tmp30_ = type;
				_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
				_tmp32_ = _tmp31_;
				vala_data_type_set_value_owned (_tmp28_, !vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, !_tmp32_));
			} else {
				ValaDataType* _tmp33_;
				ValaGirParserMetadata* _tmp34_;
				ValaDataType* _tmp35_;
				gboolean _tmp36_;
				gboolean _tmp37_;
				_tmp33_ = type;
				_tmp34_ = self->priv->metadata;
				_tmp35_ = type;
				_tmp36_ = vala_data_type_get_value_owned (_tmp35_);
				_tmp37_ = _tmp36_;
				vala_data_type_set_value_owned (_tmp33_, vala_gir_parser_metadata_get_bool (_tmp34_, VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, _tmp37_));
			}
			_tmp38_ = type;
			_tmp39_ = self->priv->metadata;
			_tmp40_ = type;
			_tmp41_ = vala_data_type_get_nullable (_tmp40_);
			_tmp42_ = _tmp41_;
			vala_data_type_set_nullable (_tmp38_, vala_gir_parser_metadata_get_bool (_tmp39_, VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, _tmp42_));
		}
	}
	_tmp43_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp43_)) {
		ValaGirParserMetadata* _tmp44_;
		if (!VALA_IS_ARRAY_TYPE (orig_type)) {
			*no_array_length = TRUE;
		}
		_tmp44_ = self->priv->metadata;
		*array_null_terminated = vala_gir_parser_metadata_get_bool (_tmp44_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, *array_null_terminated);
	}
	result = type;
	if (changed) {
		*changed = _vala_changed;
	}
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
vala_gir_parser_element_get_name (ValaGirParser* self,
                                  const gchar* gir_name)
{
	const gchar* tag = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* name = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* pattern = NULL;
	ValaGirParserMetadata* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	tag = _tmp2_;
	_tmp3_ = g_strdup (gir_name);
	name = _tmp3_;
	_tmp4_ = name;
	if (_tmp4_ == NULL) {
		ValaMarkupReader* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->priv->reader;
		_tmp6_ = vala_markup_reader_get_attribute (_tmp5_, "name");
		_g_free0 (name);
		name = _tmp6_;
	}
	_tmp7_ = self->priv->metadata;
	_tmp8_ = vala_gir_parser_metadata_get_string (_tmp7_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	pattern = _tmp8_;
	_tmp9_ = pattern;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = pattern;
		if (string_index_of_char (_tmp10_, (gunichar) '(', 0) < 0) {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = pattern;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (name);
			name = _tmp12_;
		} else {
			{
				gchar* replacement = NULL;
				gchar* _tmp13_;
				gchar** split = NULL;
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				GRegex* regex = NULL;
				const gchar* _tmp24_;
				GRegex* _tmp25_;
				gchar* _tmp26_ = NULL;
				GRegex* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp13_ = g_strdup ("\\1");
				replacement = _tmp13_;
				_tmp14_ = pattern;
				_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "/", 0);
				split = _tmp16_;
				split_length1 = _vala_array_length (_tmp15_);
				_split_size_ = split_length1;
				_tmp17_ = split;
				_tmp17__length1 = split_length1;
				if (_tmp17__length1 > 1) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp18_ = split;
					_tmp18__length1 = split_length1;
					_tmp19_ = _tmp18_[0];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (pattern);
					pattern = _tmp20_;
					_tmp21_ = split;
					_tmp21__length1 = split_length1;
					_tmp22_ = _tmp21_[1];
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (replacement);
					replacement = _tmp23_;
				}
				_tmp24_ = pattern;
				_tmp25_ = g_regex_new (_tmp24_, G_REGEX_ANCHORED, G_REGEX_MATCH_ANCHORED, &_inner_error0_);
				regex = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch0_g_error;
				}
				_tmp27_ = regex;
				_tmp28_ = name;
				_tmp29_ = replacement;
				_tmp30_ = g_regex_replace (_tmp27_, _tmp28_, (gssize) -1, 0, _tmp29_, 0, &_inner_error0_);
				_tmp26_ = _tmp30_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_regex_unref0 (regex);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch0_g_error;
				}
				_tmp31_ = _tmp26_;
				_tmp26_ = NULL;
				_g_free0 (name);
				name = _tmp31_;
				_g_free0 (_tmp26_);
				_g_regex_unref0 (regex);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (replacement);
			}
			goto __finally0;
			__catch0_g_error:
			{
				const gchar* _tmp32_;
				gchar* _tmp33_;
				g_clear_error (&_inner_error0_);
				_tmp32_ = pattern;
				_tmp33_ = g_strdup (_tmp32_);
				_g_free0 (name);
				name = _tmp33_;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (pattern);
				_g_free0 (name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		const gchar* _tmp34_;
		_tmp34_ = tag;
		if (g_strcmp0 (_tmp34_, "enumeration") == 0) {
			gboolean _tmp35_ = FALSE;
			const gchar* _tmp36_;
			_tmp36_ = name;
			if (_tmp36_ != NULL) {
				const gchar* _tmp37_;
				_tmp37_ = name;
				_tmp35_ = g_str_has_suffix (_tmp37_, "Enum");
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gchar* _tmp44_;
				_tmp38_ = name;
				_tmp39_ = name;
				_tmp40_ = strlen (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = strlen ("Enum");
				_tmp43_ = _tmp42_;
				_tmp44_ = string_substring (_tmp38_, (glong) 0, (glong) (_tmp41_ - _tmp43_));
				_g_free0 (name);
				name = _tmp44_;
			}
		}
	}
	result = name;
	_g_free0 (pattern);
	return result;
}

static gchar*
vala_gir_parser_element_get_type_id (ValaGirParser* self)
{
	gchar* type_id = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaMarkupReader* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	_tmp1_ = vala_gir_parser_metadata_get_string (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ != NULL) {
		result = type_id;
		return result;
	}
	_tmp3_ = self->priv->reader;
	_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:get-type");
	_g_free0 (type_id);
	type_id = _tmp4_;
	_tmp5_ = type_id;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = type_id;
		_tmp7_ = g_strconcat (_tmp6_, " ()", NULL);
		_g_free0 (type_id);
		type_id = _tmp7_;
	}
	result = type_id;
	return result;
}

static void
vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                 ValaSymbol* sym,
                                 ValaGirParserParameterInfo* info)
{
	gchar* type_name = NULL;
	ValaParameter* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (info != NULL);
	vala_code_node_set_attribute_double ((ValaCodeNode*) sym, "CCode", "array_length_pos", (gdouble) info->vala_idx, NULL);
	if (VALA_IS_PARAMETER (sym)) {
		ValaParameter* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = info->param;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) _tmp0_);
		_tmp2_ = _tmp1_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_cname", _tmp2_, NULL);
	}
	_tmp3_ = info->param;
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_data_type_to_qualified_string (_tmp5_, NULL);
	type_name = _tmp6_;
	_tmp7_ = type_name;
	if (g_strcmp0 (_tmp7_, "int") != 0) {
		ValaGirParserNode* st = NULL;
		ValaGirParserNode* _tmp8_;
		const gchar* _tmp9_;
		ValaGirParserNode* _tmp10_;
		ValaGirParserNode* _tmp11_;
		_tmp8_ = self->priv->root;
		_tmp9_ = type_name;
		_tmp10_ = vala_gir_parser_node_lookup (_tmp8_, _tmp9_, FALSE, NULL);
		st = _tmp10_;
		_tmp11_ = st;
		if (_tmp11_ != NULL) {
			gboolean _tmp12_ = FALSE;
			if (VALA_IS_CALLABLE (sym)) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = VALA_IS_PARAMETER (sym);
			}
			if (_tmp12_) {
				ValaGirParserNode* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = st;
				_tmp14_ = vala_gir_parser_node_get_cname (_tmp13_);
				_tmp15_ = _tmp14_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_type", _tmp15_, NULL);
				_g_free0 (_tmp15_);
			}
		}
		_vala_gir_parser_node_unref0 (st);
	}
	_g_free0 (type_name);
}

static void
vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                   ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gchar* type_id = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "has_type_id")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "type_id");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_parser_element_get_type_id (self);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ == NULL) {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", FALSE, NULL);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = type_id;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "type_id", _tmp3_, NULL);
	}
	_g_free0 (type_id);
}

static void
vala_gir_parser_parse_repository (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "repository");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, VALA_GIR_PARSER_GIR_VERSION) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMarkupReader* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = vala_gir_parser_get_current_src (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "version");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("unsupported GIR version %s (supported: %s)", _tmp8_, VALA_GIR_PARSER_GIR_VERSION);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp5_);
		return;
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp11_;
		ValaMarkupReader* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = self->priv->current_token;
		if (!(_tmp11_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		if (g_strcmp0 (_tmp14_, "namespace") == 0) {
			vala_gir_parser_parse_namespace (self);
		} else {
			ValaMarkupReader* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = self->priv->reader;
			_tmp16_ = vala_markup_reader_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp17_, "include") == 0) {
				vala_gir_parser_parse_include (self);
			} else {
				ValaMarkupReader* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				if (g_strcmp0 (_tmp20_, "package") == 0) {
					gchar* pkg = NULL;
					gchar* _tmp21_;
					ValaSourceFile* _tmp22_;
					const gchar* _tmp23_;
					ValaCodeContext* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = vala_gir_parser_parse_package (self);
					pkg = _tmp21_;
					_tmp22_ = self->priv->current_source_file;
					_tmp23_ = pkg;
					vala_source_file_set_package_name (_tmp22_, _tmp23_);
					_tmp24_ = self->priv->context;
					_tmp25_ = pkg;
					if (vala_code_context_has_package (_tmp24_, _tmp25_)) {
						ValaSourceFile* _tmp26_;
						gboolean _tmp27_;
						gboolean _tmp28_;
						_tmp26_ = self->priv->current_source_file;
						_tmp27_ = vala_source_file_get_from_commandline (_tmp26_);
						_tmp28_ = _tmp27_;
						if (!_tmp28_) {
							_g_free0 (pkg);
							return;
						}
					} else {
						ValaCodeContext* _tmp29_;
						const gchar* _tmp30_;
						_tmp29_ = self->priv->context;
						_tmp30_ = pkg;
						vala_code_context_add_package (_tmp29_, _tmp30_);
					}
					_g_free0 (pkg);
				} else {
					ValaMarkupReader* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp31_ = self->priv->reader;
					_tmp32_ = vala_markup_reader_get_name (_tmp31_);
					_tmp33_ = _tmp32_;
					if (g_strcmp0 (_tmp33_, "c:include") == 0) {
						vala_gir_parser_parse_c_include (self);
					} else {
						ValaSourceReference* _tmp34_;
						ValaSourceReference* _tmp35_;
						ValaMarkupReader* _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp34_ = vala_gir_parser_get_current_src (self);
						_tmp35_ = _tmp34_;
						_tmp36_ = self->priv->reader;
						_tmp37_ = vala_markup_reader_get_name (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strdup_printf ("unknown child element `%s' in `repository'", _tmp38_);
						_tmp40_ = _tmp39_;
						vala_report_error (_tmp35_, _tmp40_);
						_g_free0 (_tmp40_);
						_vala_source_reference_unref0 (_tmp35_);
						vala_gir_parser_skip_element (self);
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "repository");
}

static void
vala_gir_parser_parse_include (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* version = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCodeContext* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "version");
	version = _tmp3_;
	_tmp4_ = version;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = pkg;
		_tmp6_ = version;
		_tmp7_ = g_strdup_printf ("%s-%s", _tmp5_, _tmp6_);
		_g_free0 (pkg);
		pkg = _tmp7_;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = pkg;
	vala_code_context_add_external_package (_tmp8_, _tmp9_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "include");
	_g_free0 (version);
	_g_free0 (pkg);
}

static gchar*
vala_gir_parser_parse_package (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "package");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "package");
	result = pkg;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
vala_gir_parser_parse_c_include (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "c:include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	_vala_array_add2 (&self->priv->cheader_filenames, &self->priv->cheader_filenames_length1, &self->priv->_cheader_filenames_size_, _tmp1_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "c:include");
}

static void
vala_gir_parser_skip_element (ValaGirParser* self)
{
	gint level = 0;
	g_return_if_fail (self != NULL);
	vala_gir_parser_next (self);
	level = 1;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		if (!(level > 0)) {
			break;
		}
		_tmp0_ = self->priv->current_token;
		if (_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gint _tmp1_;
			_tmp1_ = level;
			level = _tmp1_ + 1;
		} else {
			ValaMarkupTokenType _tmp2_;
			_tmp2_ = self->priv->current_token;
			if (_tmp2_ == VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
				gint _tmp3_;
				_tmp3_ = level;
				level = _tmp3_ - 1;
			} else {
				ValaMarkupTokenType _tmp4_;
				_tmp4_ = self->priv->current_token;
				if (_tmp4_ == VALA_MARKUP_TOKEN_TYPE_EOF) {
					ValaSourceReference* _tmp5_;
					ValaSourceReference* _tmp6_;
					_tmp5_ = vala_gir_parser_get_current_src (self);
					_tmp6_ = _tmp5_;
					vala_report_error (_tmp6_, "unexpected end of file");
					_vala_source_reference_unref0 (_tmp6_);
					break;
				}
			}
		}
		vala_gir_parser_next (self);
	}
}

static ValaGirParserNode*
vala_gir_parser_resolve_node (ValaGirParser* self,
                              ValaGirParserNode* parent_scope,
                              ValaUnresolvedSymbol* unresolved_sym,
                              gboolean create_namespace)
{
	ValaUnresolvedSymbol* _tmp0_;
	ValaUnresolvedSymbol* _tmp1_;
	ValaGirParserNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_unresolved_symbol_get_inner (unresolved_sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaGirParserNode* scope = NULL;
		ValaGirParserNode* _tmp2_;
		_tmp2_ = _vala_gir_parser_node_ref0 (parent_scope);
		scope = _tmp2_;
		while (TRUE) {
			ValaGirParserNode* _tmp3_;
			ValaGirParserNode* node = NULL;
			ValaGirParserNode* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaGirParserNode* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaGirParserNode* _tmp12_;
			ValaGirParserNode* _tmp13_;
			_tmp3_ = scope;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = scope;
			_tmp5_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_gir_parser_node_lookup (_tmp4_, _tmp6_, create_namespace, _tmp8_);
			node = _tmp9_;
			_tmp10_ = node;
			if (_tmp10_ != NULL) {
				result = node;
				_vala_gir_parser_node_unref0 (scope);
				return result;
			}
			_tmp11_ = scope;
			_tmp12_ = _tmp11_->parent;
			_tmp13_ = _vala_gir_parser_node_ref0 (_tmp12_);
			_vala_gir_parser_node_unref0 (scope);
			scope = _tmp13_;
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_gir_parser_node_unref0 (scope);
	} else {
		ValaGirParserNode* inner = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		ValaUnresolvedSymbol* _tmp15_;
		ValaGirParserNode* _tmp16_;
		ValaGirParserNode* _tmp17_;
		_tmp14_ = vala_unresolved_symbol_get_inner (unresolved_sym);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_gir_parser_resolve_node (self, parent_scope, _tmp15_, create_namespace);
		inner = _tmp16_;
		_tmp17_ = inner;
		if (_tmp17_ != NULL) {
			ValaGirParserNode* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaGirParserNode* _tmp23_;
			_tmp18_ = inner;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_gir_parser_node_lookup (_tmp18_, _tmp20_, create_namespace, _tmp22_);
			result = _tmp23_;
			_vala_gir_parser_node_unref0 (inner);
			return result;
		}
		_vala_gir_parser_node_unref0 (inner);
	}
	result = NULL;
	return result;
}

static ValaSymbol*
vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                ValaGirParserNode* parent_scope,
                                ValaUnresolvedSymbol* unresolved_sym)
{
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_gir_parser_resolve_node (self, parent_scope, unresolved_sym, FALSE);
	node = _tmp0_;
	_tmp1_ = node;
	if (_tmp1_ != NULL) {
		ValaGirParserNode* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp2_ = node;
		_tmp3_ = _tmp2_->symbol;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		result = _tmp4_;
		_vala_gir_parser_node_unref0 (node);
		return result;
	}
	result = NULL;
	_vala_gir_parser_node_unref0 (node);
	return result;
}

static void
vala_gir_parser_push_node (ValaGirParser* self,
                           const gchar* name,
                           gboolean merge)
{
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp14_;
	ValaGirParserNode* _tmp15_;
	gboolean _tmp16_ = FALSE;
	ValaGirParserNode* _tmp17_;
	ValaGirParserNode* _tmp27_;
	ValaMarkupReader* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	ValaGirParserNode* _tmp32_;
	ValaMarkupReader* _tmp33_;
	ValaMap* _tmp34_;
	ValaGirParserNode* _tmp35_;
	ValaGirParserMetadata* _tmp36_;
	ValaGirParserMetadata* _tmp37_;
	ValaGirParserNode* _tmp38_;
	ValaSourceReference* _tmp39_;
	gchar* gir_name = NULL;
	ValaGirParserNode* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	ValaGirParserNode* _tmp43_;
	ValaGirParserNode* _tmp44_;
	ValaArrayList* _tmp52_;
	ValaGirParserNode* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaGirParserNode* _tmp55_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	parent = _tmp1_;
	_tmp2_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT)) {
		ValaUnresolvedSymbol* target = NULL;
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaGirParserMetadata* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaUnresolvedSymbol* _tmp12_;
		ValaGirParserNode* _tmp13_;
		_tmp3_ = self->priv->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->metadata;
		_tmp7_ = vala_gir_parser_metadata_get_source_reference (_tmp6_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_gir_parser_parse_symbol_from_string (self, _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_source_reference_unref0 (_tmp8_);
		_g_free0 (_tmp5_);
		target = _tmp10_;
		_tmp11_ = self->priv->root;
		_tmp12_ = target;
		_tmp13_ = vala_gir_parser_resolve_node (self, _tmp11_, _tmp12_, TRUE);
		_vala_gir_parser_node_unref0 (parent);
		parent = _tmp13_;
		_vala_code_node_unref0 (target);
	}
	_tmp14_ = parent;
	_tmp15_ = vala_gir_parser_node_lookup (_tmp14_, name, FALSE, NULL);
	node = _tmp15_;
	_tmp17_ = node;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = node;
		_tmp20_ = _tmp19_->symbol;
		if (_tmp20_ != NULL) {
			_tmp18_ = !merge;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp16_ = _tmp18_;
	}
	if (_tmp16_) {
		ValaGirParserNode* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaGirParserNode* _tmp24_;
		_tmp21_ = vala_gir_parser_node_new (name);
		_vala_gir_parser_node_unref0 (node);
		node = _tmp21_;
		_tmp22_ = node;
		_tmp22_->new_symbol = TRUE;
		_tmp23_ = parent;
		_tmp24_ = node;
		vala_gir_parser_node_add_member (_tmp23_, _tmp24_);
	} else {
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		_tmp25_ = vala_gir_parser_node_new_namespaces;
		_tmp26_ = node;
		vala_collection_remove ((ValaCollection*) _tmp25_, _tmp26_);
	}
	_tmp27_ = node;
	_tmp28_ = self->priv->reader;
	_tmp29_ = vala_markup_reader_get_name (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (_tmp27_->element_type);
	_tmp27_->element_type = _tmp31_;
	_tmp32_ = node;
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attributes (_tmp33_);
	_vala_map_unref0 (_tmp32_->girdata);
	_tmp32_->girdata = _tmp34_;
	_tmp35_ = node;
	_tmp36_ = self->priv->metadata;
	_tmp37_ = _vala_gir_parser_metadata_ref0 (_tmp36_);
	_vala_gir_parser_metadata_unref0 (_tmp35_->metadata);
	_tmp35_->metadata = _tmp37_;
	_tmp38_ = node;
	_tmp39_ = vala_gir_parser_get_current_src (self);
	_vala_source_reference_unref0 (_tmp38_->source_reference);
	_tmp38_->source_reference = _tmp39_;
	_tmp40_ = node;
	_tmp41_ = vala_gir_parser_node_get_gir_name (_tmp40_);
	gir_name = _tmp41_;
	_tmp43_ = parent;
	_tmp44_ = self->priv->current;
	if (_tmp43_ != _tmp44_) {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp45_;
		_tmp45_ = gir_name;
		_tmp42_ = g_strcmp0 (_tmp45_, name) != 0;
	}
	if (_tmp42_) {
		const gchar* _tmp46_;
		ValaUnresolvedSymbol* _tmp47_;
		ValaUnresolvedSymbol* _tmp48_;
		ValaGirParserNode* _tmp49_;
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		_tmp46_ = gir_name;
		_tmp47_ = vala_unresolved_symbol_new (NULL, _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = node;
		_tmp50_ = vala_gir_parser_node_get_unresolved_symbol (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_gir_parser_set_symbol_mapping (self, _tmp48_, (ValaSymbol*) _tmp51_);
		_vala_code_node_unref0 (_tmp51_);
		_vala_code_node_unref0 (_tmp48_);
	}
	_tmp52_ = self->priv->tree_stack;
	_tmp53_ = self->priv->current;
	vala_collection_add ((ValaCollection*) _tmp52_, _tmp53_);
	_tmp54_ = node;
	_tmp55_ = _vala_gir_parser_node_ref0 (_tmp54_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp55_;
	_g_free0 (gir_name);
	_vala_gir_parser_node_unref0 (node);
	_vala_gir_parser_node_unref0 (parent);
}

static void
vala_gir_parser_pop_node (ValaGirParser* self)
{
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	self->priv->old_current = _tmp1_;
	_tmp2_ = self->priv->tree_stack;
	_tmp3_ = self->priv->tree_stack;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_list_remove_at ((ValaList*) _tmp2_, _tmp5_ - 1);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = (ValaGirParserNode*) _tmp6_;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}

static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static void
vala_gir_parser_parse_namespace (ValaGirParser* self)
{
	gchar* cprefix = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lower_case_cprefix = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	gchar* vala_namespace = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* gir_namespace = NULL;
	ValaMarkupReader* _tmp10_;
	gchar* _tmp11_;
	gchar* gir_version = NULL;
	ValaMarkupReader* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaSet* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gchar* metadata_filename = NULL;
	ValaCodeContext* _tmp24_;
	ValaSourceFile* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	ValaGirParserMetadata* ns_metadata = NULL;
	ValaGirParserMetadata* _tmp46_;
	const gchar* _tmp47_;
	ValaGirParserMetadata* _tmp48_;
	ValaGirParserMetadata* _tmp49_;
	const gchar* _tmp52_;
	ValaSourceFile* _tmp55_;
	const gchar* _tmp56_;
	ValaSourceFile* _tmp57_;
	const gchar* _tmp58_;
	ValaNamespace* ns = NULL;
	const gchar* _tmp59_;
	ValaGirParserNode* _tmp60_;
	ValaGirParserNode* _tmp75_;
	ValaGirParserMetadata* _tmp76_;
	ValaGirParserMetadata* _tmp77_;
	ValaGirParserMetadata* _tmp78_;
	ValaGirParserMetadata* _tmp81_;
	ValaNamespace* _tmp87_;
	const gchar* _tmp88_;
	ValaNamespace* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	const gchar* _tmp101_;
	gchar** _tmp104_;
	gint _tmp104__length1;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "namespace");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier-prefixes");
	cprefix = _tmp1_;
	_tmp2_ = cprefix;
	if (_tmp2_ != NULL) {
		gint idx = 0;
		const gchar* _tmp3_;
		_tmp3_ = cprefix;
		idx = string_index_of (_tmp3_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = cprefix;
			_tmp5_ = string_substring (_tmp4_, (glong) 0, (glong) idx);
			_g_free0 (cprefix);
			cprefix = _tmp5_;
		}
	}
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "c:symbol-prefixes");
	lower_case_cprefix = _tmp7_;
	_tmp8_ = cprefix;
	_tmp9_ = g_strdup (_tmp8_);
	vala_namespace = _tmp9_;
	_tmp10_ = self->priv->reader;
	_tmp11_ = vala_markup_reader_get_attribute (_tmp10_, "name");
	gir_namespace = _tmp11_;
	_tmp12_ = self->priv->reader;
	_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "version");
	gir_version = _tmp13_;
	_tmp14_ = lower_case_cprefix;
	if (_tmp14_ != NULL) {
		gint idx = 0;
		const gchar* _tmp15_;
		_tmp15_ = lower_case_cprefix;
		idx = string_index_of (_tmp15_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = lower_case_cprefix;
			_tmp17_ = string_substring (_tmp16_, (glong) 0, (glong) idx);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp17_;
		}
	}
	_tmp18_ = self->priv->provided_namespaces;
	_tmp19_ = gir_namespace;
	_tmp20_ = gir_version;
	_tmp21_ = g_strdup_printf ("%s-%s", _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_collection_contains ((ValaCollection*) _tmp18_, _tmp22_);
	_g_free0 (_tmp22_);
	if (_tmp23_) {
		vala_gir_parser_skip_element (self);
		_g_free0 (gir_version);
		_g_free0 (gir_namespace);
		_g_free0 (vala_namespace);
		_g_free0 (lower_case_cprefix);
		_g_free0 (cprefix);
		return;
	}
	_tmp24_ = self->priv->context;
	_tmp25_ = self->priv->current_source_file;
	_tmp26_ = vala_source_file_get_filename (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_code_context_get_metadata_path (_tmp24_, _tmp27_);
	metadata_filename = _tmp28_;
	_tmp30_ = metadata_filename;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_;
		_tmp31_ = metadata_filename;
		_tmp29_ = g_file_test (_tmp31_, G_FILE_TEST_EXISTS);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ValaGirParserMetadataParser* metadata_parser = NULL;
		ValaGirParserMetadataParser* _tmp32_;
		ValaSourceFile* metadata_file = NULL;
		ValaCodeContext* _tmp33_;
		ValaSourceFile* _tmp34_;
		ValaSourceFileType _tmp35_;
		ValaSourceFileType _tmp36_;
		const gchar* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaCodeContext* _tmp39_;
		ValaSourceFile* _tmp40_;
		ValaGirParserMetadataParser* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaGirParserMetadata* _tmp43_;
		ValaArrayList* _tmp44_;
		ValaGirParserMetadata* _tmp45_;
		_tmp32_ = vala_gir_parser_metadata_parser_new ();
		metadata_parser = _tmp32_;
		_tmp33_ = self->priv->context;
		_tmp34_ = self->priv->current_source_file;
		_tmp35_ = vala_source_file_get_file_type (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = metadata_filename;
		_tmp38_ = vala_source_file_new (_tmp33_, _tmp36_, _tmp37_, NULL, FALSE);
		metadata_file = _tmp38_;
		_tmp39_ = self->priv->context;
		_tmp40_ = metadata_file;
		vala_code_context_add_source_file (_tmp39_, _tmp40_);
		_tmp41_ = metadata_parser;
		_tmp42_ = metadata_file;
		_tmp43_ = vala_gir_parser_metadata_parser_parse_metadata (_tmp41_, _tmp42_);
		_vala_gir_parser_metadata_unref0 (self->priv->metadata);
		self->priv->metadata = _tmp43_;
		_tmp44_ = self->priv->metadata_roots;
		_tmp45_ = self->priv->metadata;
		vala_collection_add ((ValaCollection*) _tmp44_, _tmp45_);
		_vala_source_file_unref0 (metadata_file);
		_vala_gir_parser_metadata_parser_unref0 (metadata_parser);
	}
	_tmp46_ = self->priv->metadata;
	_tmp47_ = gir_namespace;
	_tmp48_ = vala_gir_parser_metadata_match_child (_tmp46_, _tmp47_, NULL);
	ns_metadata = _tmp48_;
	_tmp49_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp49_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME)) {
		ValaGirParserMetadata* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = ns_metadata;
		_tmp51_ = vala_gir_parser_metadata_get_string (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp51_;
	}
	_tmp52_ = vala_namespace;
	if (_tmp52_ == NULL) {
		const gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp53_ = gir_namespace;
		_tmp54_ = g_strdup (_tmp53_);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp54_;
	}
	_tmp55_ = self->priv->current_source_file;
	_tmp56_ = gir_namespace;
	vala_source_file_set_gir_namespace (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->current_source_file;
	_tmp58_ = gir_version;
	vala_source_file_set_gir_version (_tmp57_, _tmp58_);
	_tmp59_ = vala_namespace;
	vala_gir_parser_push_node (self, _tmp59_, TRUE);
	_tmp60_ = self->priv->current;
	if (_tmp60_->new_symbol) {
		const gchar* _tmp61_;
		ValaGirParserNode* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaNamespace* _tmp64_;
		ValaGirParserNode* _tmp65_;
		ValaNamespace* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp61_ = vala_namespace;
		_tmp62_ = self->priv->current;
		_tmp63_ = _tmp62_->source_reference;
		_tmp64_ = vala_namespace_new (_tmp61_, _tmp63_);
		_vala_code_node_unref0 (ns);
		ns = _tmp64_;
		_tmp65_ = self->priv->current;
		_tmp66_ = ns;
		_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
		_vala_code_node_unref0 (_tmp65_->symbol);
		_tmp65_->symbol = _tmp67_;
	} else {
		ValaGirParserNode* _tmp68_;
		ValaSymbol* _tmp69_;
		ValaNamespace* _tmp70_;
		ValaNamespace* _tmp71_;
		ValaNamespace* _tmp72_;
		ValaGirParserNode* _tmp73_;
		ValaSourceReference* _tmp74_;
		_tmp68_ = self->priv->current;
		_tmp69_ = _tmp68_->symbol;
		_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp70_;
		_tmp71_ = ns;
		(((ValaCodeNode*) _tmp71_)->attributes == NULL) ? NULL : (((ValaCodeNode*) _tmp71_)->attributes = (_g_list_free__vala_code_node_unref0_ (((ValaCodeNode*) _tmp71_)->attributes), NULL));
		((ValaCodeNode*) _tmp71_)->attributes = NULL;
		_tmp72_ = ns;
		_tmp73_ = self->priv->current;
		_tmp74_ = _tmp73_->source_reference;
		vala_code_node_set_source_reference ((ValaCodeNode*) _tmp72_, _tmp74_);
	}
	_tmp75_ = self->priv->current;
	_tmp76_ = ns_metadata;
	_tmp77_ = _vala_gir_parser_metadata_ref0 (_tmp76_);
	_vala_gir_parser_metadata_unref0 (_tmp75_->metadata);
	_tmp75_->metadata = _tmp77_;
	_tmp78_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp78_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp79_;
		gchar* _tmp80_;
		_tmp79_ = ns_metadata;
		_tmp80_ = vala_gir_parser_metadata_get_string (_tmp79_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (cprefix);
		cprefix = _tmp80_;
	}
	_tmp81_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp81_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
		ValaGirParserMetadata* _tmp82_;
		gchar* _tmp83_;
		_tmp82_ = ns_metadata;
		_tmp83_ = vala_gir_parser_metadata_get_string (_tmp82_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
		_g_free0 (lower_case_cprefix);
		lower_case_cprefix = _tmp83_;
	} else {
		const gchar* _tmp84_;
		_tmp84_ = lower_case_cprefix;
		if (_tmp84_ != NULL) {
			const gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp85_ = lower_case_cprefix;
			_tmp86_ = g_strconcat (_tmp85_, "_", NULL);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp86_;
		}
	}
	_tmp87_ = ns;
	_tmp88_ = gir_namespace;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp87_, "CCode", "gir_namespace", _tmp88_, NULL);
	_tmp89_ = ns;
	_tmp90_ = gir_version;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp89_, "CCode", "gir_version", _tmp90_, NULL);
	_tmp91_ = cprefix;
	if (_tmp91_ != NULL) {
		ValaNamespace* _tmp92_;
		const gchar* _tmp93_;
		const gchar* _tmp94_;
		_tmp92_ = ns;
		_tmp93_ = cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp92_, "CCode", "cprefix", _tmp93_, NULL);
		_tmp94_ = lower_case_cprefix;
		if (_tmp94_ == NULL) {
			ValaNamespace* _tmp95_;
			const gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			_tmp95_ = ns;
			_tmp96_ = cprefix;
			_tmp97_ = vala_symbol_camel_case_to_lower_case (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strconcat (_tmp98_, "_", NULL);
			_tmp100_ = _tmp99_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "CCode", "lower_case_cprefix", _tmp100_, NULL);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp98_);
		}
	}
	_tmp101_ = lower_case_cprefix;
	if (_tmp101_ != NULL) {
		ValaNamespace* _tmp102_;
		const gchar* _tmp103_;
		_tmp102_ = ns;
		_tmp103_ = lower_case_cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "CCode", "lower_case_cprefix", _tmp103_, NULL);
	}
	_tmp104_ = self->priv->cheader_filenames;
	_tmp104__length1 = self->priv->cheader_filenames_length1;
	if (_tmp104_ != NULL) {
		ValaNamespace* _tmp105_;
		gchar** _tmp106_;
		gint _tmp106__length1;
		gchar* _tmp107_;
		gchar* _tmp108_;
		_tmp105_ = ns;
		_tmp106_ = self->priv->cheader_filenames;
		_tmp106__length1 = self->priv->cheader_filenames_length1;
		_tmp107_ = _vala_g_strjoinv (",", _tmp106_, (gint) _tmp106__length1);
		_tmp108_ = _tmp107_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp105_, "CCode", "cheader_filename", _tmp108_, NULL);
		_g_free0 (_tmp108_);
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp109_;
		ValaMarkupReader* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		_tmp109_ = self->priv->current_token;
		if (!(_tmp109_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp110_ = self->priv->reader;
		_tmp111_ = vala_markup_reader_get_name (_tmp110_);
		_tmp112_ = _tmp111_;
		if (g_strcmp0 (_tmp112_, "alias") == 0) {
			vala_gir_parser_parse_alias (self);
		} else {
			ValaMarkupReader* _tmp113_;
			const gchar* _tmp114_;
			const gchar* _tmp115_;
			_tmp113_ = self->priv->reader;
			_tmp114_ = vala_markup_reader_get_name (_tmp113_);
			_tmp115_ = _tmp114_;
			if (g_strcmp0 (_tmp115_, "enumeration") == 0) {
				ValaGirParserMetadata* _tmp116_;
				_tmp116_ = self->priv->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp116_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN)) {
					ValaGirParserMetadata* _tmp117_;
					_tmp117_ = self->priv->metadata;
					if (vala_gir_parser_metadata_get_bool (_tmp117_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, FALSE)) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				} else {
					gboolean _tmp118_ = FALSE;
					ValaMarkupReader* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					gboolean _tmp122_;
					_tmp119_ = self->priv->reader;
					_tmp120_ = vala_markup_reader_get_attribute (_tmp119_, "glib:error-quark");
					_tmp121_ = _tmp120_;
					_tmp122_ = _tmp121_ != NULL;
					_g_free0 (_tmp121_);
					if (_tmp122_) {
						_tmp118_ = TRUE;
					} else {
						ValaMarkupReader* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						_tmp123_ = self->priv->reader;
						_tmp124_ = vala_markup_reader_get_attribute (_tmp123_, "glib:error-domain");
						_tmp125_ = _tmp124_;
						_tmp118_ = _tmp125_ != NULL;
						_g_free0 (_tmp125_);
					}
					if (_tmp118_) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				}
			} else {
				ValaMarkupReader* _tmp126_;
				const gchar* _tmp127_;
				const gchar* _tmp128_;
				_tmp126_ = self->priv->reader;
				_tmp127_ = vala_markup_reader_get_name (_tmp126_);
				_tmp128_ = _tmp127_;
				if (g_strcmp0 (_tmp128_, "bitfield") == 0) {
					vala_gir_parser_parse_bitfield (self);
				} else {
					ValaMarkupReader* _tmp129_;
					const gchar* _tmp130_;
					const gchar* _tmp131_;
					_tmp129_ = self->priv->reader;
					_tmp130_ = vala_markup_reader_get_name (_tmp129_);
					_tmp131_ = _tmp130_;
					if (g_strcmp0 (_tmp131_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp132_;
						const gchar* _tmp133_;
						const gchar* _tmp134_;
						_tmp132_ = self->priv->reader;
						_tmp133_ = vala_markup_reader_get_name (_tmp132_);
						_tmp134_ = _tmp133_;
						if (g_strcmp0 (_tmp134_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp135_;
							const gchar* _tmp136_;
							const gchar* _tmp137_;
							_tmp135_ = self->priv->reader;
							_tmp136_ = vala_markup_reader_get_name (_tmp135_);
							_tmp137_ = _tmp136_;
							if (g_strcmp0 (_tmp137_, "callback") == 0) {
								vala_gir_parser_parse_callback (self);
							} else {
								ValaMarkupReader* _tmp138_;
								const gchar* _tmp139_;
								const gchar* _tmp140_;
								_tmp138_ = self->priv->reader;
								_tmp139_ = vala_markup_reader_get_name (_tmp138_);
								_tmp140_ = _tmp139_;
								if (g_strcmp0 (_tmp140_, "record") == 0) {
									ValaGirParserMetadata* _tmp141_;
									_tmp141_ = self->priv->metadata;
									if (vala_gir_parser_metadata_has_argument (_tmp141_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT)) {
										ValaGirParserMetadata* _tmp142_;
										_tmp142_ = self->priv->metadata;
										if (vala_gir_parser_metadata_get_bool (_tmp142_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE)) {
											vala_gir_parser_parse_record (self);
										} else {
											vala_gir_parser_parse_boxed (self, "record");
										}
									} else {
										gchar* _tmp143_;
										gchar* _tmp144_;
										gboolean _tmp145_;
										_tmp143_ = vala_gir_parser_element_get_type_id (self);
										_tmp144_ = _tmp143_;
										_tmp145_ = _tmp144_ != NULL;
										_g_free0 (_tmp144_);
										if (_tmp145_) {
											vala_gir_parser_parse_boxed (self, "record");
										} else {
											ValaMarkupReader* _tmp146_;
											gchar* _tmp147_;
											gchar* _tmp148_;
											gboolean _tmp149_;
											_tmp146_ = self->priv->reader;
											_tmp147_ = vala_markup_reader_get_attribute (_tmp146_, "name");
											_tmp148_ = _tmp147_;
											_tmp149_ = !g_str_has_suffix (_tmp148_, "Private");
											_g_free0 (_tmp148_);
											if (_tmp149_) {
												gboolean _tmp150_ = FALSE;
												ValaMarkupReader* _tmp151_;
												gchar* _tmp152_;
												gchar* _tmp153_;
												gboolean _tmp154_;
												_tmp151_ = self->priv->reader;
												_tmp152_ = vala_markup_reader_get_attribute (_tmp151_, "glib:is-gtype-struct-for");
												_tmp153_ = _tmp152_;
												_tmp154_ = _tmp153_ == NULL;
												_g_free0 (_tmp153_);
												if (_tmp154_) {
													ValaMarkupReader* _tmp155_;
													gchar* _tmp156_;
													gchar* _tmp157_;
													_tmp155_ = self->priv->reader;
													_tmp156_ = vala_markup_reader_get_attribute (_tmp155_, "disguised");
													_tmp157_ = _tmp156_;
													_tmp150_ = g_strcmp0 (_tmp157_, "1") == 0;
													_g_free0 (_tmp157_);
												} else {
													_tmp150_ = FALSE;
												}
												if (_tmp150_) {
													vala_gir_parser_parse_boxed (self, "record");
												} else {
													vala_gir_parser_parse_record (self);
												}
											} else {
												vala_gir_parser_skip_element (self);
											}
										}
									}
								} else {
									ValaMarkupReader* _tmp158_;
									const gchar* _tmp159_;
									const gchar* _tmp160_;
									_tmp158_ = self->priv->reader;
									_tmp159_ = vala_markup_reader_get_name (_tmp158_);
									_tmp160_ = _tmp159_;
									if (g_strcmp0 (_tmp160_, "class") == 0) {
										vala_gir_parser_parse_class (self);
									} else {
										ValaMarkupReader* _tmp161_;
										const gchar* _tmp162_;
										const gchar* _tmp163_;
										_tmp161_ = self->priv->reader;
										_tmp162_ = vala_markup_reader_get_name (_tmp161_);
										_tmp163_ = _tmp162_;
										if (g_strcmp0 (_tmp163_, "interface") == 0) {
											vala_gir_parser_parse_interface (self);
										} else {
											ValaMarkupReader* _tmp164_;
											const gchar* _tmp165_;
											const gchar* _tmp166_;
											_tmp164_ = self->priv->reader;
											_tmp165_ = vala_markup_reader_get_name (_tmp164_);
											_tmp166_ = _tmp165_;
											if (g_strcmp0 (_tmp166_, "glib:boxed") == 0) {
												vala_gir_parser_parse_boxed (self, "glib:boxed");
											} else {
												ValaMarkupReader* _tmp167_;
												const gchar* _tmp168_;
												const gchar* _tmp169_;
												_tmp167_ = self->priv->reader;
												_tmp168_ = vala_markup_reader_get_name (_tmp167_);
												_tmp169_ = _tmp168_;
												if (g_strcmp0 (_tmp169_, "union") == 0) {
													gboolean _tmp170_ = FALSE;
													gchar* _tmp171_;
													gchar* _tmp172_;
													gboolean _tmp173_;
													_tmp171_ = vala_gir_parser_element_get_type_id (self);
													_tmp172_ = _tmp171_;
													_tmp173_ = _tmp172_ != NULL;
													_g_free0 (_tmp172_);
													if (_tmp173_) {
														ValaGirParserMetadata* _tmp174_;
														_tmp174_ = self->priv->metadata;
														_tmp170_ = !vala_gir_parser_metadata_get_bool (_tmp174_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE);
													} else {
														_tmp170_ = FALSE;
													}
													if (_tmp170_) {
														vala_gir_parser_parse_boxed (self, "union");
													} else {
														vala_gir_parser_parse_union (self);
													}
												} else {
													ValaMarkupReader* _tmp175_;
													const gchar* _tmp176_;
													const gchar* _tmp177_;
													_tmp175_ = self->priv->reader;
													_tmp176_ = vala_markup_reader_get_name (_tmp175_);
													_tmp177_ = _tmp176_;
													if (g_strcmp0 (_tmp177_, "constant") == 0) {
														vala_gir_parser_parse_constant (self);
													} else {
														ValaMarkupReader* _tmp178_;
														const gchar* _tmp179_;
														const gchar* _tmp180_;
														_tmp178_ = self->priv->reader;
														_tmp179_ = vala_markup_reader_get_name (_tmp178_);
														_tmp180_ = _tmp179_;
														if (g_strcmp0 (_tmp180_, "docsection") == 0) {
															vala_gir_parser_skip_element (self);
														} else {
															ValaSourceReference* _tmp181_;
															ValaSourceReference* _tmp182_;
															ValaMarkupReader* _tmp183_;
															const gchar* _tmp184_;
															const gchar* _tmp185_;
															gchar* _tmp186_;
															gchar* _tmp187_;
															_tmp181_ = vala_gir_parser_get_current_src (self);
															_tmp182_ = _tmp181_;
															_tmp183_ = self->priv->reader;
															_tmp184_ = vala_markup_reader_get_name (_tmp183_);
															_tmp185_ = _tmp184_;
															_tmp186_ = g_strdup_printf ("unknown child element `%s' in `namespace'", _tmp185_);
															_tmp187_ = _tmp186_;
															vala_report_error (_tmp182_, _tmp187_);
															_g_free0 (_tmp187_);
															_vala_source_reference_unref0 (_tmp182_);
															vala_gir_parser_skip_element (self);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "namespace");
	_vala_code_node_unref0 (ns);
	_vala_gir_parser_metadata_unref0 (ns_metadata);
	_g_free0 (metadata_filename);
	_g_free0 (gir_version);
	_g_free0 (gir_namespace);
	_g_free0 (vala_namespace);
	_g_free0 (lower_case_cprefix);
	_g_free0 (cprefix);
}

static void
vala_gir_parser_parse_alias (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaGirComment* _tmp3_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "alias");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->comment;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		ValaGirComment* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = vala_gir_parser_parse_symbol_doc (self);
		_vala_comment_unref0 (_tmp4_->comment);
		_tmp4_->comment = _tmp5_;
	} else {
		ValaGirComment* _tmp6_;
		ValaGirComment* _tmp7_;
		_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp7_ = _tmp6_;
		_vala_comment_unref0 (_tmp7_);
	}
	no_array_length = FALSE;
	array_null_terminated = FALSE;
	_tmp8_ = self->priv->current;
	_tmp9_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_gir_parser_element_get_type (self, _tmp10_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (_tmp8_->base_type);
	_tmp8_->base_type = _tmp11_;
	_vala_code_node_unref0 (_tmp10_);
	_tmp12_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaGirParserNode* _tmp13_;
		ValaGirParserMetadata* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		ValaGirParserMetadata* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp13_ = self->priv->current;
		_tmp14_ = self->priv->metadata;
		_tmp15_ = vala_gir_parser_metadata_get_string (_tmp14_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->metadata;
		_tmp18_ = vala_gir_parser_metadata_get_source_reference (_tmp17_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_gir_parser_parse_type_from_string (self, _tmp16_, TRUE, _tmp19_);
		_vala_code_node_unref0 (_tmp13_->base_type);
		_tmp13_->base_type = _tmp20_;
		_vala_source_reference_unref0 (_tmp19_);
		_g_free0 (_tmp16_);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "alias");
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                         gchar* * common_prefix,
                                         const gchar* cname)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	if ((*common_prefix) == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (cname);
		_g_free0 (*common_prefix);
		*common_prefix = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = strlen (*common_prefix);
			_tmp3_ = _tmp2_;
			if (_tmp3_ > 0) {
				_tmp1_ = !g_str_has_suffix (*common_prefix, "_");
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp4_ = strlen (*common_prefix);
			_tmp5_ = _tmp4_;
			_tmp6_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp5_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp6_;
		}
	} else {
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			if (!(!g_str_has_prefix (cname, *common_prefix))) {
				break;
			}
			_tmp7_ = strlen (*common_prefix);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp8_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp9_;
		}
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		_tmp11_ = strlen (*common_prefix);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			gboolean _tmp13_ = FALSE;
			if (!g_str_has_suffix (*common_prefix, "_")) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp16_;
				_tmp15_ = strlen (*common_prefix);
				_tmp16_ = _tmp15_;
				if (g_unichar_isdigit (string_get_char (cname, (glong) _tmp16_))) {
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp17_ = strlen (cname);
					_tmp18_ = _tmp17_;
					_tmp19_ = strlen (*common_prefix);
					_tmp20_ = _tmp19_;
					_tmp14_ = (_tmp18_ - _tmp20_) <= 1;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp13_ = _tmp14_;
			}
			_tmp10_ = _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp21_ = strlen (*common_prefix);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp22_ - 1));
		_g_free0 (*common_prefix);
		*common_prefix = _tmp23_;
	}
}

static ValaGirComment*
vala_gir_parser_parse_symbol_doc (ValaGirParser* self)
{
	ValaGirComment* comment = NULL;
	ValaGirComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaGirComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_gir_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = reader_name;
				if (g_strcmp0 (_tmp17_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					const gchar* _tmp18_;
					_tmp18_ = reader_name;
					if (g_strcmp0 (_tmp18_, "attribute") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}

static ValaComment*
vala_gir_parser_parse_doc (ValaGirParser* self)
{
	ValaComment* comment = NULL;
	ValaComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = reader_name;
				if (g_strcmp0 (_tmp17_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					const gchar* _tmp18_;
					_tmp18_ = reader_name;
					if (g_strcmp0 (_tmp18_, "attribute") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}

static void
vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                   const gchar* element_name,
                                   gboolean error_domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaSymbol* sym = NULL;
	ValaGirParserNode* _tmp2_;
	ValaSymbol* _tmp23_;
	gchar* common_prefix = NULL;
	gboolean explicit_prefix = FALSE;
	ValaGirParserMetadata* _tmp24_;
	gboolean has_member = FALSE;
	ValaSymbol* _tmp29_;
	ValaGirComment* _tmp30_;
	ValaGirComment* _tmp31_;
	const gchar* _tmp58_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		ValaGirParserNode* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		if (error_domain) {
			ValaGirParserNode* _tmp3_;
			const gchar* _tmp4_;
			ValaGirParserNode* _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaErrorDomain* _tmp7_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_->name;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_->source_reference;
			_tmp7_ = vala_error_domain_new (_tmp4_, _tmp6_, NULL);
			_vala_code_node_unref0 (sym);
			sym = (ValaSymbol*) _tmp7_;
		} else {
			ValaEnum* en = NULL;
			ValaGirParserNode* _tmp8_;
			const gchar* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaEnum* _tmp12_;
			ValaEnum* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->name;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_->source_reference;
			_tmp12_ = vala_enum_new (_tmp9_, _tmp11_, NULL);
			en = _tmp12_;
			if (g_strcmp0 (element_name, "bitfield") == 0) {
				ValaEnum* _tmp13_;
				_tmp13_ = en;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp13_, "Flags", TRUE, NULL);
			}
			_tmp14_ = en;
			_tmp15_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp14_);
			_vala_code_node_unref0 (sym);
			sym = _tmp15_;
			_vala_code_node_unref0 (en);
		}
		_tmp16_ = self->priv->current;
		_tmp17_ = sym;
		_tmp18_ = _vala_code_node_ref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp16_->symbol);
		_tmp16_->symbol = _tmp18_;
	} else {
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->symbol;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (sym);
		sym = _tmp21_;
	}
	if (!error_domain) {
		ValaSymbol* _tmp22_;
		_tmp22_ = sym;
		vala_gir_parser_set_type_id_ccode (self, _tmp22_);
	}
	_tmp23_ = sym;
	vala_symbol_set_access (_tmp23_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	common_prefix = NULL;
	explicit_prefix = FALSE;
	_tmp24_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp24_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaSymbol* _tmp25_;
		ValaGirParserMetadata* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp25_ = sym;
		_tmp26_ = self->priv->metadata;
		_tmp27_ = vala_gir_parser_metadata_get_string (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_tmp28_ = _tmp27_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp25_, "CCode", "cprefix", _tmp28_, NULL);
		_g_free0 (_tmp28_);
		explicit_prefix = TRUE;
	}
	has_member = FALSE;
	vala_gir_parser_next (self);
	_tmp29_ = sym;
	_tmp30_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp31_ = _tmp30_;
	vala_symbol_set_comment (_tmp29_, (ValaComment*) _tmp31_);
	_vala_comment_unref0 (_tmp31_);
	while (TRUE) {
		ValaMarkupTokenType _tmp32_;
		ValaMarkupReader* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp32_ = self->priv->current_token;
		if (!(_tmp32_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp33_ = self->priv->reader;
		_tmp34_ = vala_markup_reader_get_name (_tmp33_);
		_tmp35_ = _tmp34_;
		if (g_strcmp0 (_tmp35_, "member") == 0) {
			has_member = TRUE;
			if (error_domain) {
				vala_gir_parser_parse_error_member (self);
			} else {
				vala_gir_parser_parse_enumeration_member (self);
			}
			if (!explicit_prefix) {
				ValaGirParserNode* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp36_ = self->priv->old_current;
				_tmp37_ = vala_gir_parser_node_get_cname (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp38_);
				_g_free0 (_tmp38_);
			}
		} else {
			ValaMarkupReader* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			_tmp39_ = self->priv->reader;
			_tmp40_ = vala_markup_reader_get_name (_tmp39_);
			_tmp41_ = _tmp40_;
			if (g_strcmp0 (_tmp41_, "function") == 0) {
				vala_gir_parser_skip_element (self);
			} else {
				ValaMarkupReader* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				_tmp42_ = self->priv->reader;
				_tmp43_ = vala_markup_reader_get_name (_tmp42_);
				_tmp44_ = _tmp43_;
				if (g_strcmp0 (_tmp44_, "function-macro") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					ValaSourceReference* _tmp45_;
					ValaSourceReference* _tmp46_;
					ValaMarkupReader* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp45_ = vala_gir_parser_get_current_src (self);
					_tmp46_ = _tmp45_;
					_tmp47_ = self->priv->reader;
					_tmp48_ = vala_markup_reader_get_name (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = g_strdup_printf ("unknown child element `%s' in `%s'", _tmp49_, element_name);
					_tmp51_ = _tmp50_;
					vala_report_error (_tmp46_, _tmp51_);
					_g_free0 (_tmp51_);
					_vala_source_reference_unref0 (_tmp46_);
					vala_gir_parser_skip_element (self);
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	if (!has_member) {
		ValaSourceReference* _tmp52_;
		ValaSourceReference* _tmp53_;
		ValaGirParserNode* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp52_ = vala_gir_parser_get_current_src (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = self->priv->current;
		_tmp55_ = _tmp54_->name;
		_tmp56_ = g_strdup_printf ("%s `%s' has no members", element_name, _tmp55_);
		_tmp57_ = _tmp56_;
		vala_report_error (_tmp53_, _tmp57_);
		_g_free0 (_tmp57_);
		_vala_source_reference_unref0 (_tmp53_);
	}
	_tmp58_ = common_prefix;
	if (_tmp58_ != NULL) {
		ValaSymbol* _tmp59_;
		const gchar* _tmp60_;
		_tmp59_ = sym;
		_tmp60_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp59_, "CCode", "cprefix", _tmp60_, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (sym);
}

static void
vala_gir_parser_parse_error_domain (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "enumeration", TRUE);
}

static void
vala_gir_parser_parse_bitfield (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "bitfield", FALSE);
}

static void
vala_gir_parser_parse_enumeration_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaEnumValue* ev = NULL;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaGirParserNode* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaEnumValue* _tmp13_;
	ValaEnumValue* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaGirComment* _tmp17_;
	ValaGirComment* _tmp18_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = self->priv->metadata;
	_tmp9_ = vala_gir_parser_metadata_get_expression (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->source_reference;
	_tmp13_ = vala_enum_value_new (_tmp7_, _tmp10_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_vala_code_node_unref0 (_tmp10_);
	ev = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = _vala_code_node_ref0 ((ValaSymbol*) ev);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp16_;
	vala_gir_parser_next (self);
	_tmp17_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp18_ = _tmp17_;
	vala_symbol_set_comment ((ValaSymbol*) ev, (ValaComment*) _tmp18_);
	_vala_comment_unref0 (_tmp18_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_vala_code_node_unref0 (ev);
}

static void
vala_gir_parser_parse_error_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaErrorCode* ec = NULL;
	gchar* value = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaGirParserNode* _tmp18_;
	ValaErrorCode* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaErrorCode* _tmp21_;
	ValaGirComment* _tmp22_;
	ValaGirComment* _tmp23_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "value");
	value = _tmp7_;
	_tmp8_ = value;
	if (_tmp8_ != NULL) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		ValaIntegerLiteral* _tmp13_;
		ValaErrorCode* _tmp14_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = value;
		_tmp12_ = vala_integer_literal_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_error_code_new_with_value (_tmp10_, (ValaExpression*) _tmp13_, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp14_;
		_vala_code_node_unref0 (_tmp13_);
	} else {
		ValaGirParserNode* _tmp15_;
		const gchar* _tmp16_;
		ValaErrorCode* _tmp17_;
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_->name;
		_tmp17_ = vala_error_code_new (_tmp16_, NULL, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp17_;
	}
	_tmp18_ = self->priv->current;
	_tmp19_ = ec;
	_tmp20_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp19_);
	_vala_code_node_unref0 (_tmp18_->symbol);
	_tmp18_->symbol = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = ec;
	_tmp22_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp23_ = _tmp22_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp21_, (ValaComment*) _tmp23_);
	_vala_comment_unref0 (_tmp23_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_g_free0 (value);
	_vala_code_node_unref0 (ec);
}

static ValaDataType*
vala_gir_parser_parse_return_value (ValaGirParser* self,
                                    gchar* * ctype,
                                    gint* array_length_idx,
                                    gboolean* no_array_length,
                                    gboolean* array_null_terminated,
                                    ValaComment* * comment)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaComment* _vala_comment = NULL;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaComment* _tmp6_;
	gboolean transfer_elements = FALSE;
	const gchar* _tmp7_;
	ValaDataType* type = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaDataType* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "return-value");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "transfer-ownership");
	transfer = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp6_;
	_tmp7_ = transfer;
	transfer_elements = g_strcmp0 (_tmp7_, "container") != 0;
	_tmp12_ = vala_gir_parser_parse_type (self, &_tmp8_, &_tmp9_, transfer_elements, &_tmp10_, &_tmp11_);
	_g_free0 (_vala_ctype);
	_vala_ctype = _tmp8_;
	_vala_array_length_idx = _tmp9_;
	_vala_no_array_length = _tmp10_;
	_vala_array_null_terminated = _tmp11_;
	type = _tmp12_;
	_tmp14_ = transfer;
	if (g_strcmp0 (_tmp14_, "full") == 0) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = transfer;
		_tmp13_ = g_strcmp0 (_tmp15_, "container") == 0;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		_tmp16_ = type;
		vala_data_type_set_value_owned (_tmp16_, TRUE);
	}
	_tmp18_ = nullable;
	if (g_strcmp0 (_tmp18_, "1") == 0) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp19_;
		_tmp19_ = allow_none;
		_tmp17_ = g_strcmp0 (_tmp19_, "1") == 0;
	}
	if (_tmp17_) {
		ValaDataType* _tmp20_;
		_tmp20_ = type;
		vala_data_type_set_nullable (_tmp20_, TRUE);
	}
	_tmp21_ = type;
	_tmp22_ = vala_gir_parser_element_get_type (self, _tmp21_, TRUE, &_vala_no_array_length, &_vala_array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp22_;
	vala_gir_parser_end_element (self, "return-value");
	result = type;
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static ValaParameter*
vala_gir_parser_parse_parameter (ValaGirParser* self,
                                 gint* array_length_idx,
                                 gint* closure_idx,
                                 gint* destroy_idx,
                                 gchar* * scope,
                                 ValaComment* * comment,
                                 const gchar* default_name)
{
	gint _vala_array_length_idx = 0;
	gint _vala_closure_idx = 0;
	gint _vala_destroy_idx = 0;
	gchar* _vala_scope = NULL;
	ValaComment* _vala_comment = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaParameter* param = NULL;
	gchar* element_type = NULL;
	ValaMarkupReader* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMarkupTokenType _tmp6_;
	const gchar* _tmp12_;
	gchar* name = NULL;
	ValaGirParserMetadata* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp18_;
	gchar* direction = NULL;
	ValaGirParserMetadata* _tmp25_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp33_;
	gchar* _tmp34_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp35_;
	gchar* _tmp36_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* closure = NULL;
	ValaMarkupReader* _tmp40_;
	gchar* _tmp41_;
	gchar* destroy = NULL;
	ValaMarkupReader* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_;
	gboolean _tmp47_ = FALSE;
	const gchar* _tmp48_;
	ValaGirParserMetadata* _tmp50_;
	ValaGirParserMetadata* _tmp52_;
	ValaComment* _tmp54_;
	ValaMarkupReader* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp113_;
	ValaParameter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_vala_array_length_idx = -1;
	_vala_closure_idx = -1;
	_vala_destroy_idx = -1;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	element_type = _tmp4_;
	_tmp6_ = self->priv->current_token;
	if (_tmp6_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		_tmp8_ = element_type;
		if (g_strcmp0 (_tmp8_, "parameter") != 0) {
			const gchar* _tmp9_;
			_tmp9_ = element_type;
			_tmp7_ = g_strcmp0 (_tmp9_, "instance-parameter") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp5_ = _tmp7_;
	}
	if (_tmp5_) {
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		_tmp10_ = vala_gir_parser_get_current_src (self);
		_tmp11_ = _tmp10_;
		vala_report_error (_tmp11_, "expected start element of `parameter' or `instance-parameter'");
		_vala_source_reference_unref0 (_tmp11_);
	}
	_tmp12_ = element_type;
	vala_gir_parser_start_element (self, _tmp12_);
	_tmp13_ = self->priv->metadata;
	_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	name = _tmp14_;
	_tmp15_ = name;
	if (_tmp15_ == NULL) {
		ValaMarkupReader* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = self->priv->reader;
		_tmp17_ = vala_markup_reader_get_attribute (_tmp16_, "name");
		_g_free0 (name);
		name = _tmp17_;
	}
	_tmp18_ = name;
	if (_tmp18_ == NULL) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup (default_name);
		_g_free0 (name);
		name = _tmp19_;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = name;
		if (string_contains (_tmp20_, "-")) {
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp21_ = vala_gir_parser_get_current_src (self);
			_tmp22_ = _tmp21_;
			vala_report_warning (_tmp22_, "parameter name contains hyphen");
			_vala_source_reference_unref0 (_tmp22_);
			_tmp23_ = name;
			_tmp24_ = string_replace (_tmp23_, "-", "_");
			_g_free0 (name);
			name = _tmp24_;
		}
	}
	direction = NULL;
	_tmp25_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp25_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT)) {
		ValaGirParserMetadata* _tmp26_;
		_tmp26_ = self->priv->metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, FALSE)) {
			gchar* _tmp27_;
			_tmp27_ = g_strdup ("out");
			_g_free0 (direction);
			direction = _tmp27_;
		}
	} else {
		ValaGirParserMetadata* _tmp28_;
		_tmp28_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp28_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF)) {
			ValaGirParserMetadata* _tmp29_;
			_tmp29_ = self->priv->metadata;
			if (vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF, FALSE)) {
				gchar* _tmp30_;
				_tmp30_ = g_strdup ("inout");
				_g_free0 (direction);
				direction = _tmp30_;
			}
		} else {
			ValaMarkupReader* _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = self->priv->reader;
			_tmp32_ = vala_markup_reader_get_attribute (_tmp31_, "direction");
			_g_free0 (direction);
			direction = _tmp32_;
		}
	}
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attribute (_tmp33_, "transfer-ownership");
	transfer = _tmp34_;
	_tmp35_ = self->priv->reader;
	_tmp36_ = vala_markup_reader_get_attribute (_tmp35_, "nullable");
	nullable = _tmp36_;
	_tmp37_ = self->priv->reader;
	_tmp38_ = vala_markup_reader_get_attribute (_tmp37_, "allow-none");
	allow_none = _tmp38_;
	_tmp39_ = vala_gir_parser_element_get_string (self, "scope", VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE);
	_g_free0 (_vala_scope);
	_vala_scope = _tmp39_;
	_tmp40_ = self->priv->reader;
	_tmp41_ = vala_markup_reader_get_attribute (_tmp40_, "closure");
	closure = _tmp41_;
	_tmp42_ = self->priv->reader;
	_tmp43_ = vala_markup_reader_get_attribute (_tmp42_, "destroy");
	destroy = _tmp43_;
	_tmp45_ = closure;
	if (_tmp45_ != NULL) {
		_tmp44_ = (&_vala_closure_idx) != NULL;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		const gchar* _tmp46_;
		_tmp46_ = closure;
		_vala_closure_idx = atoi (_tmp46_);
	}
	_tmp48_ = destroy;
	if (_tmp48_ != NULL) {
		_tmp47_ = (&_vala_destroy_idx) != NULL;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		const gchar* _tmp49_;
		_tmp49_ = destroy;
		_vala_destroy_idx = atoi (_tmp49_);
	}
	_tmp50_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE)) {
		ValaGirParserMetadata* _tmp51_;
		_tmp51_ = self->priv->metadata;
		_vala_closure_idx = vala_gir_parser_metadata_get_integer (_tmp51_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE);
	}
	_tmp52_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp52_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY)) {
		ValaGirParserMetadata* _tmp53_;
		_tmp53_ = self->priv->metadata;
		_vala_destroy_idx = vala_gir_parser_metadata_get_integer (_tmp53_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY);
	}
	vala_gir_parser_next (self);
	_tmp54_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp54_;
	_tmp55_ = self->priv->reader;
	_tmp56_ = vala_markup_reader_get_name (_tmp55_);
	_tmp57_ = _tmp56_;
	if (g_strcmp0 (_tmp57_, "varargs") == 0) {
		ValaSourceLocation _tmp58_;
		ValaSourceReference* _tmp59_;
		ValaSourceReference* _tmp60_;
		ValaParameter* _tmp61_;
		vala_gir_parser_start_element (self, "varargs");
		vala_gir_parser_next (self);
		_tmp58_ = begin;
		_tmp59_ = vala_gir_parser_get_src (self, &_tmp58_, NULL);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_parameter_new_with_ellipsis (_tmp60_);
		_vala_code_node_unref0 (param);
		param = _tmp61_;
		_vala_source_reference_unref0 (_tmp60_);
		vala_gir_parser_end_element (self, "varargs");
	} else {
		gchar* ctype = NULL;
		gboolean no_array_length = FALSE;
		gboolean array_null_terminated = FALSE;
		ValaDataType* type = NULL;
		const gchar* _tmp62_;
		gchar* _tmp63_ = NULL;
		gint _tmp64_ = 0;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_ = FALSE;
		ValaDataType* _tmp67_;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		const gchar* _tmp70_;
		gboolean _tmp74_ = FALSE;
		const gchar* _tmp75_;
		gboolean changed = FALSE;
		gboolean _tmp80_ = FALSE;
		const gchar* _tmp81_;
		ValaDataType* _tmp83_;
		gboolean _tmp84_ = FALSE;
		ValaDataType* _tmp85_;
		const gchar* _tmp86_;
		ValaDataType* _tmp87_;
		ValaSourceLocation _tmp88_;
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		ValaParameter* _tmp91_;
		const gchar* _tmp92_;
		const gchar* _tmp95_;
		ValaDataType* _tmp99_;
		ValaParameter* _tmp105_;
		ValaGirParserMetadata* _tmp106_;
		ValaExpression* _tmp107_;
		ValaExpression* _tmp108_;
		ValaParameter* _tmp109_;
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		_tmp62_ = transfer;
		_tmp67_ = vala_gir_parser_parse_type (self, &_tmp63_, &_tmp64_, g_strcmp0 (_tmp62_, "container") != 0, &_tmp65_, &_tmp66_);
		_g_free0 (ctype);
		ctype = _tmp63_;
		_vala_array_length_idx = _tmp64_;
		no_array_length = _tmp65_;
		array_null_terminated = _tmp66_;
		type = _tmp67_;
		_tmp70_ = transfer;
		if (g_strcmp0 (_tmp70_, "full") == 0) {
			_tmp69_ = TRUE;
		} else {
			const gchar* _tmp71_;
			_tmp71_ = transfer;
			_tmp69_ = g_strcmp0 (_tmp71_, "container") == 0;
		}
		if (_tmp69_) {
			_tmp68_ = TRUE;
		} else {
			const gchar* _tmp72_;
			_tmp72_ = destroy;
			_tmp68_ = _tmp72_ != NULL;
		}
		if (_tmp68_) {
			ValaDataType* _tmp73_;
			_tmp73_ = type;
			vala_data_type_set_value_owned (_tmp73_, TRUE);
		}
		_tmp75_ = nullable;
		if (g_strcmp0 (_tmp75_, "1") == 0) {
			_tmp74_ = TRUE;
		} else {
			gboolean _tmp76_ = FALSE;
			const gchar* _tmp77_;
			_tmp77_ = allow_none;
			if (g_strcmp0 (_tmp77_, "1") == 0) {
				const gchar* _tmp78_;
				_tmp78_ = direction;
				_tmp76_ = g_strcmp0 (_tmp78_, "out") != 0;
			} else {
				_tmp76_ = FALSE;
			}
			_tmp74_ = _tmp76_;
		}
		if (_tmp74_) {
			ValaDataType* _tmp79_;
			_tmp79_ = type;
			vala_data_type_set_nullable (_tmp79_, TRUE);
		}
		_tmp81_ = direction;
		if (g_strcmp0 (_tmp81_, "out") == 0) {
			_tmp80_ = TRUE;
		} else {
			const gchar* _tmp82_;
			_tmp82_ = direction;
			_tmp80_ = g_strcmp0 (_tmp82_, "inout") == 0;
		}
		_tmp83_ = type;
		_tmp85_ = vala_gir_parser_element_get_type (self, _tmp83_, _tmp80_, &no_array_length, &array_null_terminated, &_tmp84_);
		changed = _tmp84_;
		_vala_code_node_unref0 (type);
		type = _tmp85_;
		if (!changed) {
			_g_free0 (ctype);
			ctype = NULL;
		}
		_tmp86_ = name;
		_tmp87_ = type;
		_tmp88_ = begin;
		_tmp89_ = vala_gir_parser_get_src (self, &_tmp88_, NULL);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_parameter_new (_tmp86_, _tmp87_, _tmp90_);
		_vala_code_node_unref0 (param);
		param = _tmp91_;
		_vala_source_reference_unref0 (_tmp90_);
		_tmp92_ = ctype;
		if (_tmp92_ != NULL) {
			ValaParameter* _tmp93_;
			const gchar* _tmp94_;
			_tmp93_ = param;
			_tmp94_ = ctype;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp93_, "CCode", "type", _tmp94_, NULL);
		}
		_tmp95_ = direction;
		if (g_strcmp0 (_tmp95_, "out") == 0) {
			ValaParameter* _tmp96_;
			_tmp96_ = param;
			vala_parameter_set_direction (_tmp96_, VALA_PARAMETER_DIRECTION_OUT);
		} else {
			const gchar* _tmp97_;
			_tmp97_ = direction;
			if (g_strcmp0 (_tmp97_, "inout") == 0) {
				ValaParameter* _tmp98_;
				_tmp98_ = param;
				vala_parameter_set_direction (_tmp98_, VALA_PARAMETER_DIRECTION_REF);
			}
		}
		_tmp99_ = type;
		if (VALA_IS_ARRAY_TYPE (_tmp99_)) {
			ValaGirParserMetadata* _tmp100_;
			_tmp100_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp100_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX)) {
				ValaGirParserMetadata* _tmp101_;
				_tmp101_ = self->priv->metadata;
				_vala_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp101_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
			} else {
				gboolean _tmp102_ = FALSE;
				if (no_array_length) {
					_tmp102_ = TRUE;
				} else {
					_tmp102_ = array_null_terminated;
				}
				if (_tmp102_) {
					ValaParameter* _tmp103_;
					_tmp103_ = param;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp103_, "CCode", "array_length", !no_array_length, NULL);
				}
				if (array_null_terminated) {
					ValaParameter* _tmp104_;
					_tmp104_ = param;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp104_, "CCode", "array_null_terminated", array_null_terminated, NULL);
				}
			}
		}
		_tmp105_ = param;
		_tmp106_ = self->priv->metadata;
		_tmp107_ = vala_gir_parser_metadata_get_expression (_tmp106_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
		_tmp108_ = _tmp107_;
		vala_variable_set_initializer ((ValaVariable*) _tmp105_, _tmp108_);
		_vala_code_node_unref0 (_tmp108_);
		_tmp109_ = param;
		_tmp110_ = vala_variable_get_initializer ((ValaVariable*) _tmp109_);
		_tmp111_ = _tmp110_;
		if (VALA_IS_TUPLE (_tmp111_)) {
			ValaParameter* _tmp112_;
			_tmp112_ = param;
			vala_variable_set_initializer ((ValaVariable*) _tmp112_, NULL);
		}
		_vala_code_node_unref0 (type);
		_g_free0 (ctype);
	}
	_tmp113_ = element_type;
	vala_gir_parser_end_element (self, _tmp113_);
	result = param;
	_g_free0 (destroy);
	_g_free0 (closure);
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	_g_free0 (direction);
	_g_free0 (name);
	_g_free0 (element_type);
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (closure_idx) {
		*closure_idx = _vala_closure_idx;
	}
	if (destroy_idx) {
		*destroy_idx = _vala_destroy_idx;
	}
	if (scope) {
		*scope = _vala_scope;
	} else {
		_g_free0 (_vala_scope);
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type (ValaGirParser* self,
                            gchar* * ctype,
                            gint* array_length_idx,
                            gboolean transfer_elements,
                            gboolean* no_array_length,
                            gboolean* array_null_terminated)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	gboolean is_array = FALSE;
	gchar* type_name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gint fixed_length = 0;
	ValaMarkupReader* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaGirParserMetadata* _tmp49_;
	const gchar* _tmp54_;
	ValaDataType* type = NULL;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaDataType* _tmp61_;
	const gchar* _tmp88_ = NULL;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	is_array = FALSE;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	type_name = _tmp1_;
	_g_free0 (_vala_ctype);
	_vala_ctype = NULL;
	fixed_length = -1;
	_vala_array_length_idx = -1;
	_vala_no_array_length = TRUE;
	_vala_array_null_terminated = TRUE;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "array") == 0) {
		ValaSourceReference* src = NULL;
		ValaSourceReference* _tmp5_;
		const gchar* _tmp6_;
		is_array = TRUE;
		vala_gir_parser_start_element (self, "array");
		_tmp5_ = vala_gir_parser_get_current_src (self);
		src = _tmp5_;
		_tmp6_ = type_name;
		if (_tmp6_ == NULL) {
			ValaMarkupReader* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			ValaMarkupReader* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_;
			ValaMarkupReader* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			ValaMarkupReader* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			ValaDataType* element_type = NULL;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaArrayType* _tmp36_;
			_tmp7_ = self->priv->reader;
			_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "length");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				ValaMarkupReader* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->priv->reader;
				_tmp12_ = vala_markup_reader_get_attribute (_tmp11_, "length");
				_tmp13_ = _tmp12_;
				_vala_array_length_idx = atoi (_tmp13_);
				_g_free0 (_tmp13_);
				_vala_no_array_length = FALSE;
				_vala_array_null_terminated = FALSE;
			}
			_tmp14_ = self->priv->reader;
			_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "fixed-size");
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_ != NULL;
			_g_free0 (_tmp16_);
			if (_tmp17_) {
				ValaMarkupReader* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_attribute (_tmp18_, "fixed-size");
				_tmp20_ = _tmp19_;
				fixed_length = atoi (_tmp20_);
				_g_free0 (_tmp20_);
				_vala_array_null_terminated = FALSE;
			}
			_tmp21_ = self->priv->reader;
			_tmp22_ = vala_markup_reader_get_attribute (_tmp21_, "c:type");
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strcmp0 (_tmp23_, "GStrv") == 0;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
			}
			_tmp25_ = self->priv->reader;
			_tmp26_ = vala_markup_reader_get_attribute (_tmp25_, "zero-terminated");
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_ != NULL;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				ValaMarkupReader* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = self->priv->reader;
				_tmp30_ = vala_markup_reader_get_attribute (_tmp29_, "zero-terminated");
				_tmp31_ = _tmp30_;
				_vala_array_null_terminated = atoi (_tmp31_) != 0;
				_g_free0 (_tmp31_);
			}
			vala_gir_parser_next (self);
			_tmp32_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
			element_type = _tmp32_;
			_tmp33_ = element_type;
			vala_data_type_set_value_owned (_tmp33_, transfer_elements);
			vala_gir_parser_end_element (self, "array");
			_tmp34_ = element_type;
			_tmp35_ = src;
			_tmp36_ = vala_array_type_new (_tmp34_, 1, _tmp35_);
			array_type = _tmp36_;
			if (fixed_length > 0) {
				ValaArrayType* _tmp37_;
				ValaArrayType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				ValaIntegerLiteral* _tmp41_;
				ValaIntegerLiteral* _tmp42_;
				_tmp37_ = array_type;
				vala_array_type_set_fixed_length (_tmp37_, TRUE);
				_tmp38_ = array_type;
				_tmp39_ = g_strdup_printf ("%i", fixed_length);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_integer_literal_new (_tmp40_, NULL);
				_tmp42_ = _tmp41_;
				vala_array_type_set_length (_tmp38_, (ValaExpression*) _tmp42_);
				_vala_code_node_unref0 (_tmp42_);
				_g_free0 (_tmp40_);
			}
			result = (ValaDataType*) array_type;
			_vala_code_node_unref0 (element_type);
			_vala_source_reference_unref0 (src);
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		}
		_vala_source_reference_unref0 (src);
	} else {
		ValaMarkupReader* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		_tmp43_ = self->priv->reader;
		_tmp44_ = vala_markup_reader_get_name (_tmp43_);
		_tmp45_ = _tmp44_;
		if (g_strcmp0 (_tmp45_, "callback") == 0) {
			ValaGirParserNode* _tmp46_;
			ValaSymbol* _tmp47_;
			ValaDelegateType* _tmp48_;
			vala_gir_parser_parse_callback (self);
			_tmp46_ = self->priv->old_current;
			_tmp47_ = _tmp46_->symbol;
			_tmp48_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_DELEGATE, ValaDelegate));
			result = (ValaDataType*) _tmp48_;
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		} else {
			vala_gir_parser_start_element (self, "type");
		}
	}
	_tmp49_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp49_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
		ValaGirParserMetadata* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = self->priv->metadata;
		_tmp51_ = vala_gir_parser_metadata_get_string (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
		_g_free0 (_vala_ctype);
		_vala_ctype = _tmp51_;
	} else {
		ValaMarkupReader* _tmp52_;
		gchar* _tmp53_;
		_tmp52_ = self->priv->reader;
		_tmp53_ = vala_markup_reader_get_attribute (_tmp52_, "c:type");
		_g_free0 (_vala_ctype);
		_vala_ctype = _tmp53_;
	}
	vala_gir_parser_next (self);
	_tmp54_ = type_name;
	if (_tmp54_ == NULL) {
		const gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp55_ = _vala_ctype;
		_tmp56_ = g_strdup (_tmp55_);
		_g_free0 (type_name);
		type_name = _tmp56_;
	}
	_tmp57_ = type_name;
	_tmp58_ = _vala_ctype;
	_tmp61_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp57_, &_tmp59_, &_tmp60_, _tmp58_);
	_vala_no_array_length = _tmp59_;
	_vala_array_null_terminated = _tmp60_;
	type = _tmp61_;
	while (TRUE) {
		ValaMarkupTokenType _tmp62_;
		const gchar* _tmp63_;
		ValaDataType* element_type = NULL;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		_tmp62_ = self->priv->current_token;
		if (!(_tmp62_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp63_ = type_name;
		if (g_strcmp0 (_tmp63_, "GLib.ByteArray") == 0) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp64_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
		element_type = _tmp64_;
		_tmp65_ = element_type;
		vala_data_type_set_value_owned (_tmp65_, transfer_elements);
		_tmp66_ = type;
		_tmp67_ = element_type;
		vala_data_type_add_type_argument (_tmp66_, _tmp67_);
		_tmp68_ = element_type;
		if (VALA_IS_UNRESOLVED_TYPE (_tmp68_)) {
			ValaGirParserNode* _tmp69_ = NULL;
			ValaGirParserNode* _tmp70_;
			ValaGirParserNode* parent = NULL;
			ValaGirParserNode* _tmp72_;
			ValaHashMap* _tmp85_;
			ValaDataType* _tmp86_;
			ValaGirParserNode* _tmp87_;
			_tmp70_ = self->priv->current;
			_tmp69_ = _tmp70_;
			if (_tmp69_ == NULL) {
				ValaGirParserNode* _tmp71_;
				_tmp71_ = self->priv->root;
				_tmp69_ = _tmp71_;
			}
			_tmp72_ = _vala_gir_parser_node_ref0 (_tmp69_);
			parent = _tmp72_;
			while (TRUE) {
				gboolean _tmp73_ = FALSE;
				gboolean _tmp74_ = FALSE;
				ValaGirParserNode* _tmp75_;
				ValaGirParserNode* _tmp76_;
				ValaGirParserNode* _tmp82_;
				ValaGirParserNode* _tmp83_;
				ValaGirParserNode* _tmp84_;
				_tmp75_ = parent;
				_tmp76_ = self->priv->root;
				if (_tmp75_ != _tmp76_) {
					ValaGirParserNode* _tmp77_;
					ValaGirParserNode* _tmp78_;
					_tmp77_ = parent;
					_tmp78_ = _tmp77_->parent;
					_tmp74_ = _tmp78_ != NULL;
				} else {
					_tmp74_ = FALSE;
				}
				if (_tmp74_) {
					ValaGirParserNode* _tmp79_;
					ValaGirParserNode* _tmp80_;
					ValaGirParserNode* _tmp81_;
					_tmp79_ = parent;
					_tmp80_ = _tmp79_->parent;
					_tmp81_ = self->priv->root;
					_tmp73_ = _tmp80_ != _tmp81_;
				} else {
					_tmp73_ = FALSE;
				}
				if (!_tmp73_) {
					break;
				}
				_tmp82_ = parent;
				_tmp83_ = _tmp82_->parent;
				_tmp84_ = _vala_gir_parser_node_ref0 (_tmp83_);
				_vala_gir_parser_node_unref0 (parent);
				parent = _tmp84_;
			}
			_tmp85_ = self->priv->unresolved_type_arguments;
			_tmp86_ = element_type;
			_tmp87_ = parent;
			vala_map_set ((ValaMap*) _tmp85_, G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType), _tmp87_);
			_vala_gir_parser_node_unref0 (parent);
		}
		_vala_code_node_unref0 (element_type);
	}
	if (is_array) {
		_tmp88_ = "array";
	} else {
		_tmp88_ = "type";
	}
	vala_gir_parser_end_element (self, _tmp88_);
	result = type;
	_g_free0 (type_name);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                          const gchar* type_name,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated,
                                          const gchar* ctype)
{
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	_vala_no_array_length = FALSE;
	_vala_array_null_terminated = FALSE;
	type = NULL;
	if (g_strcmp0 (type_name, "none") == 0) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		ValaVoidType* _tmp2_;
		_tmp0_ = vala_gir_parser_get_current_src (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_void_type_new (_tmp1_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp2_;
		_vala_source_reference_unref0 (_tmp1_);
	} else {
		if (g_strcmp0 (type_name, "gpointer") == 0) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaVoidType* _tmp5_;
			ValaVoidType* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaPointerType* _tmp9_;
			_tmp3_ = vala_gir_parser_get_current_src (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_void_type_new (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_gir_parser_get_current_src (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_pointer_type_new ((ValaDataType*) _tmp6_, _tmp8_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp9_;
			_vala_source_reference_unref0 (_tmp8_);
			_vala_code_node_unref0 (_tmp6_);
			_vala_source_reference_unref0 (_tmp4_);
		} else {
			if (g_strcmp0 (type_name, "GObject.Strv") == 0) {
				ValaUnresolvedType* element_type = NULL;
				ValaUnresolvedSymbol* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				ValaUnresolvedType* _tmp12_;
				ValaUnresolvedType* _tmp13_;
				ValaUnresolvedType* _tmp14_;
				ValaUnresolvedType* _tmp15_;
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaArrayType* _tmp18_;
				_tmp10_ = vala_unresolved_symbol_new (NULL, "string", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_unresolved_type_new_from_symbol (_tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_vala_code_node_unref0 (_tmp11_);
				element_type = _tmp13_;
				_tmp14_ = element_type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp14_, TRUE);
				_tmp15_ = element_type;
				_tmp16_ = vala_gir_parser_get_current_src (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_array_type_new ((ValaDataType*) _tmp15_, 1, _tmp17_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp18_;
				_vala_source_reference_unref0 (_tmp17_);
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
				_vala_code_node_unref0 (element_type);
			} else {
				gboolean known_type = FALSE;
				ValaDataType* _tmp31_;
				known_type = TRUE;
				if (g_strcmp0 (type_name, "utf8") == 0) {
					type_name = "string";
				} else {
					if (g_strcmp0 (type_name, "gboolean") == 0) {
						ValaCodeContext* _tmp19_;
						ValaNamespace* _tmp20_;
						ValaNamespace* _tmp21_;
						ValaScope* _tmp22_;
						ValaScope* _tmp23_;
						ValaSymbol* _tmp24_;
						ValaStruct* _tmp25_;
						ValaBooleanType* _tmp26_;
						_tmp19_ = self->priv->context;
						_tmp20_ = vala_code_context_get_root (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = vala_scope_lookup (_tmp23_, "bool");
						_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp26_ = vala_boolean_type_new (_tmp25_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp26_;
						_vala_code_node_unref0 (_tmp25_);
					} else {
						if (g_strcmp0 (type_name, "gchar") == 0) {
							type_name = "char";
						} else {
							if (g_strcmp0 (type_name, "gshort") == 0) {
								type_name = "short";
							} else {
								if (g_strcmp0 (type_name, "gushort") == 0) {
									type_name = "ushort";
								} else {
									if (g_strcmp0 (type_name, "gint") == 0) {
										type_name = "int";
									} else {
										if (g_strcmp0 (type_name, "guint") == 0) {
											type_name = "uint";
										} else {
											if (g_strcmp0 (type_name, "glong") == 0) {
												gboolean _tmp27_ = FALSE;
												if (ctype != NULL) {
													_tmp27_ = g_str_has_prefix (ctype, "gssize");
												} else {
													_tmp27_ = FALSE;
												}
												if (_tmp27_) {
													type_name = "ssize_t";
												} else {
													gboolean _tmp28_ = FALSE;
													if (ctype != NULL) {
														_tmp28_ = g_str_has_prefix (ctype, "gintptr");
													} else {
														_tmp28_ = FALSE;
													}
													if (_tmp28_) {
														type_name = "intptr";
													} else {
														type_name = "long";
													}
												}
											} else {
												if (g_strcmp0 (type_name, "gulong") == 0) {
													gboolean _tmp29_ = FALSE;
													if (ctype != NULL) {
														_tmp29_ = g_str_has_prefix (ctype, "gsize");
													} else {
														_tmp29_ = FALSE;
													}
													if (_tmp29_) {
														type_name = "size_t";
													} else {
														gboolean _tmp30_ = FALSE;
														if (ctype != NULL) {
															_tmp30_ = g_str_has_prefix (ctype, "guintptr");
														} else {
															_tmp30_ = FALSE;
														}
														if (_tmp30_) {
															type_name = "uintptr";
														} else {
															type_name = "ulong";
														}
													}
												} else {
													if (g_strcmp0 (type_name, "gint8") == 0) {
														type_name = "int8";
													} else {
														if (g_strcmp0 (type_name, "guint8") == 0) {
															type_name = "uint8";
														} else {
															if (g_strcmp0 (type_name, "gint16") == 0) {
																type_name = "int16";
															} else {
																if (g_strcmp0 (type_name, "guint16") == 0) {
																	type_name = "uint16";
																} else {
																	if (g_strcmp0 (type_name, "gint32") == 0) {
																		type_name = "int32";
																	} else {
																		if (g_strcmp0 (type_name, "guint32") == 0) {
																			type_name = "uint32";
																		} else {
																			if (g_strcmp0 (type_name, "gint64") == 0) {
																				type_name = "int64";
																			} else {
																				if (g_strcmp0 (type_name, "guint64") == 0) {
																					type_name = "uint64";
																				} else {
																					if (g_strcmp0 (type_name, "gfloat") == 0) {
																						type_name = "float";
																					} else {
																						if (g_strcmp0 (type_name, "gdouble") == 0) {
																							type_name = "double";
																						} else {
																							if (g_strcmp0 (type_name, "filename") == 0) {
																								type_name = "string";
																							} else {
																								if (g_strcmp0 (type_name, "GLib.offset") == 0) {
																									type_name = "int64";
																								} else {
																									if (g_strcmp0 (type_name, "gsize") == 0) {
																										type_name = "size_t";
																									} else {
																										if (g_strcmp0 (type_name, "gssize") == 0) {
																											type_name = "ssize_t";
																										} else {
																											if (g_strcmp0 (type_name, "guintptr") == 0) {
																												type_name = "uintptr";
																											} else {
																												if (g_strcmp0 (type_name, "gintptr") == 0) {
																													type_name = "intptr";
																												} else {
																													if (g_strcmp0 (type_name, "GType") == 0) {
																														type_name = "GLib.Type";
																													} else {
																														if (g_strcmp0 (type_name, "GObject.Class") == 0) {
																															type_name = "GLib.ObjectClass";
																														} else {
																															if (g_strcmp0 (type_name, "gunichar") == 0) {
																																type_name = "unichar";
																															} else {
																																if (g_strcmp0 (type_name, "Atk.ImplementorIface") == 0) {
																																	type_name = "Atk.Implementor";
																																} else {
																																	known_type = FALSE;
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp31_ = type;
				if (_tmp31_ == NULL) {
					ValaUnresolvedSymbol* sym = NULL;
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					ValaUnresolvedSymbol* _tmp34_;
					ValaUnresolvedSymbol* _tmp35_;
					ValaUnresolvedSymbol* _tmp36_;
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaUnresolvedType* _tmp39_;
					_tmp32_ = vala_gir_parser_get_current_src (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = vala_gir_parser_parse_symbol_from_string (self, type_name, _tmp33_);
					_tmp35_ = _tmp34_;
					_vala_source_reference_unref0 (_tmp33_);
					sym = _tmp35_;
					_tmp36_ = sym;
					_tmp37_ = vala_gir_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = vala_unresolved_type_new_from_symbol (_tmp36_, _tmp38_);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp39_;
					_vala_source_reference_unref0 (_tmp38_);
					if (!known_type) {
						ValaArrayList* _tmp40_;
						ValaUnresolvedSymbol* _tmp41_;
						_tmp40_ = self->priv->unresolved_gir_symbols;
						_tmp41_ = sym;
						vala_collection_add ((ValaCollection*) _tmp40_, _tmp41_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	result = type;
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}

static void
vala_gir_parser_parse_record (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaStruct* st = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp2_;
	ValaStruct* _tmp14_;
	ValaStruct* _tmp15_;
	ValaStruct* _tmp16_;
	gchar* gtype_struct_for = NULL;
	ValaMarkupReader* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean first_field = FALSE;
	ValaStruct* _tmp28_;
	ValaGirComment* _tmp29_;
	ValaGirComment* _tmp30_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "record");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	require_copy_free = FALSE;
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaStruct* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaStruct* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp3_ = vala_gir_parser_element_get_name (self, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->source_reference;
		_tmp7_ = vala_struct_new (_tmp4_, _tmp6_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp7_;
		_g_free0 (_tmp4_);
		_tmp8_ = self->priv->current;
		_tmp9_ = st;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (_tmp8_->symbol);
		_tmp8_->symbol = _tmp10_;
	} else {
		ValaGirParserNode* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->symbol;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp13_;
	}
	_tmp14_ = st;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp14_);
	_tmp15_ = st;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp15_, "CCode", "type_id");
	_tmp16_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp17_ = self->priv->reader;
	_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "glib:is-gtype-struct-for");
	gtype_struct_for = _tmp18_;
	_tmp19_ = gtype_struct_for;
	if (_tmp19_ != NULL) {
		ValaGirParserNode* _tmp20_;
		const gchar* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		ValaUnresolvedSymbol* _tmp27_;
		_tmp20_ = self->priv->current;
		_tmp21_ = gtype_struct_for;
		_tmp22_ = self->priv->current;
		_tmp23_ = _tmp22_->source_reference;
		_tmp24_ = vala_gir_parser_parse_symbol_from_string (self, _tmp21_, _tmp23_);
		_vala_code_node_unref0 (_tmp20_->gtype_struct_for);
		_tmp20_->gtype_struct_for = _tmp24_;
		_tmp25_ = self->priv->unresolved_gir_symbols;
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_->gtype_struct_for;
		vala_collection_add ((ValaCollection*) _tmp25_, _tmp27_);
	}
	first_field = TRUE;
	vala_gir_parser_next (self);
	_tmp28_ = st;
	_tmp29_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp30_ = _tmp29_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp28_, (ValaComment*) _tmp30_);
	_vala_comment_unref0 (_tmp30_);
	while (TRUE) {
		ValaMarkupTokenType _tmp31_;
		ValaMarkupReader* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp31_ = self->priv->current_token;
		if (!(_tmp31_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp32_ = FALSE;
			if (first_field) {
				ValaMarkupReader* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp33_ = self->priv->reader;
				_tmp34_ = vala_markup_reader_get_name (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp32_ = g_strcmp0 (_tmp35_, "field") == 0;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp36_ = self->priv->reader;
		_tmp37_ = vala_markup_reader_get_name (_tmp36_);
		_tmp38_ = _tmp37_;
		if (g_strcmp0 (_tmp38_, "field") == 0) {
			gboolean _tmp39_ = FALSE;
			ValaMarkupReader* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gboolean _tmp43_;
			_tmp40_ = self->priv->reader;
			_tmp41_ = vala_markup_reader_get_attribute (_tmp40_, "name");
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strcmp0 (_tmp42_, "priv") != 0;
			_g_free0 (_tmp42_);
			if (_tmp43_) {
				gboolean _tmp44_ = FALSE;
				if (first_field) {
					const gchar* _tmp45_;
					_tmp45_ = gtype_struct_for;
					_tmp44_ = _tmp45_ != NULL;
				} else {
					_tmp44_ = FALSE;
				}
				_tmp39_ = !_tmp44_;
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				vala_gir_parser_parse_field (self);
			} else {
				vala_gir_parser_skip_element (self);
			}
			first_field = FALSE;
		} else {
			ValaMarkupReader* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_tmp46_ = self->priv->reader;
			_tmp47_ = vala_markup_reader_get_name (_tmp46_);
			_tmp48_ = _tmp47_;
			if (g_strcmp0 (_tmp48_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				_tmp49_ = self->priv->reader;
				_tmp50_ = vala_markup_reader_get_name (_tmp49_);
				_tmp51_ = _tmp50_;
				if (g_strcmp0 (_tmp51_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp54_;
					_tmp52_ = self->priv->reader;
					_tmp53_ = vala_markup_reader_get_name (_tmp52_);
					_tmp54_ = _tmp53_;
					if (g_strcmp0 (_tmp54_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp55_;
						const gchar* _tmp56_;
						const gchar* _tmp57_;
						_tmp55_ = self->priv->reader;
						_tmp56_ = vala_markup_reader_get_name (_tmp55_);
						_tmp57_ = _tmp56_;
						if (g_strcmp0 (_tmp57_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp58_;
							const gchar* _tmp59_;
							const gchar* _tmp60_;
							_tmp58_ = self->priv->reader;
							_tmp59_ = vala_markup_reader_get_name (_tmp58_);
							_tmp60_ = _tmp59_;
							if (g_strcmp0 (_tmp60_, "union") == 0) {
								vala_gir_parser_parse_union (self);
							} else {
								ValaSourceReference* _tmp61_;
								ValaSourceReference* _tmp62_;
								ValaMarkupReader* _tmp63_;
								const gchar* _tmp64_;
								const gchar* _tmp65_;
								gchar* _tmp66_;
								gchar* _tmp67_;
								_tmp61_ = vala_gir_parser_get_current_src (self);
								_tmp62_ = _tmp61_;
								_tmp63_ = self->priv->reader;
								_tmp64_ = vala_markup_reader_get_name (_tmp63_);
								_tmp65_ = _tmp64_;
								_tmp66_ = g_strdup_printf ("unknown child element `%s' in `record'", _tmp65_);
								_tmp67_ = _tmp66_;
								vala_report_error (_tmp62_, _tmp67_);
								_g_free0 (_tmp67_);
								_vala_source_reference_unref0 (_tmp62_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	if (require_copy_free) {
		ValaStruct* _tmp68_;
		ValaStruct* _tmp69_;
		_tmp68_ = st;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp68_, "CCode", "copy_function", "g_boxed_copy", NULL);
		_tmp69_ = st;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp69_, "CCode", "free_function", "g_boxed_free", NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "record");
	_g_free0 (gtype_struct_for);
	_vala_code_node_unref0 (st);
}

static void
vala_gir_parser_parse_class (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaClass* cl = NULL;
	gchar* parent = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	ValaGirParserNode* _tmp4_;
	ValaClass* _tmp28_;
	ValaClass* _tmp29_;
	ValaClass* _tmp30_;
	ValaGirComment* _tmp31_;
	ValaGirComment* _tmp32_;
	gboolean first_field = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "class");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "parent");
	parent = _tmp3_;
	_tmp4_ = self->priv->current;
	if (_tmp4_->new_symbol) {
		ValaGirParserNode* _tmp5_;
		const gchar* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaClass* _tmp9_;
		ValaClass* _tmp10_;
		ValaGirParserMetadata* _tmp11_;
		ValaMarkupReader* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaClass* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		const gchar* _tmp17_;
		ValaGirParserNode* _tmp22_;
		ValaClass* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->name;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->source_reference;
		_tmp9_ = vala_class_new (_tmp6_, _tmp8_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp9_;
		_tmp10_ = cl;
		_tmp11_ = self->priv->metadata;
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "abstract");
		_tmp14_ = _tmp13_;
		vala_class_set_is_abstract (_tmp10_, vala_gir_parser_metadata_get_bool (_tmp11_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, g_strcmp0 (_tmp14_, "1") == 0));
		_g_free0 (_tmp14_);
		_tmp15_ = cl;
		_tmp16_ = self->priv->metadata;
		vala_class_set_is_sealed (_tmp15_, vala_gir_parser_metadata_get_bool (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED, FALSE));
		_tmp17_ = parent;
		if (_tmp17_ != NULL) {
			ValaClass* _tmp18_;
			const gchar* _tmp19_;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp21_;
			_tmp18_ = cl;
			_tmp19_ = parent;
			_tmp20_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp19_, NULL, NULL, NULL);
			_tmp21_ = _tmp20_;
			vala_class_add_base_type (_tmp18_, _tmp21_);
			_vala_code_node_unref0 (_tmp21_);
		}
		_tmp22_ = self->priv->current;
		_tmp23_ = cl;
		_tmp24_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp23_);
		_vala_code_node_unref0 (_tmp22_->symbol);
		_tmp22_->symbol = _tmp24_;
	} else {
		ValaGirParserNode* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaClass* _tmp27_;
		_tmp25_ = self->priv->current;
		_tmp26_ = _tmp25_->symbol;
		_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp27_;
	}
	_tmp28_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp28_);
	_tmp29_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp29_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	_tmp30_ = cl;
	_tmp31_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp32_ = _tmp31_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp30_, (ValaComment*) _tmp32_);
	_vala_comment_unref0 (_tmp32_);
	first_field = TRUE;
	while (TRUE) {
		ValaMarkupTokenType _tmp33_;
		ValaMarkupReader* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp33_ = self->priv->current_token;
		if (!(_tmp33_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp34_ = FALSE;
			if (first_field) {
				ValaMarkupReader* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				_tmp35_ = self->priv->reader;
				_tmp36_ = vala_markup_reader_get_name (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp34_ = g_strcmp0 (_tmp37_, "field") == 0;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp38_ = self->priv->reader;
		_tmp39_ = vala_markup_reader_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		if (g_strcmp0 (_tmp40_, "implements") == 0) {
			ValaClass* _tmp41_;
			ValaMarkupReader* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			vala_gir_parser_start_element (self, "implements");
			_tmp41_ = cl;
			_tmp42_ = self->priv->reader;
			_tmp43_ = vala_markup_reader_get_attribute (_tmp42_, "name");
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp44_, NULL, NULL, NULL);
			_tmp46_ = _tmp45_;
			vala_class_add_base_type (_tmp41_, _tmp46_);
			_vala_code_node_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "implements");
		} else {
			ValaMarkupReader* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			_tmp47_ = self->priv->reader;
			_tmp48_ = vala_markup_reader_get_name (_tmp47_);
			_tmp49_ = _tmp48_;
			if (g_strcmp0 (_tmp49_, "constant") == 0) {
				vala_gir_parser_parse_constant (self);
			} else {
				ValaMarkupReader* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				_tmp50_ = self->priv->reader;
				_tmp51_ = vala_markup_reader_get_name (_tmp50_);
				_tmp52_ = _tmp51_;
				if (g_strcmp0 (_tmp52_, "field") == 0) {
					gboolean _tmp53_ = FALSE;
					if (first_field) {
						const gchar* _tmp54_;
						_tmp54_ = parent;
						_tmp53_ = _tmp54_ != NULL;
					} else {
						_tmp53_ = FALSE;
					}
					if (_tmp53_) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp55_;
						gchar* _tmp56_;
						gchar* _tmp57_;
						gboolean _tmp58_;
						_tmp55_ = self->priv->reader;
						_tmp56_ = vala_markup_reader_get_attribute (_tmp55_, "name");
						_tmp57_ = _tmp56_;
						_tmp58_ = g_strcmp0 (_tmp57_, "priv") != 0;
						_g_free0 (_tmp57_);
						if (_tmp58_) {
							vala_gir_parser_parse_field (self);
						} else {
							vala_gir_parser_skip_element (self);
						}
					}
					first_field = FALSE;
				} else {
					ValaMarkupReader* _tmp59_;
					const gchar* _tmp60_;
					const gchar* _tmp61_;
					_tmp59_ = self->priv->reader;
					_tmp60_ = vala_markup_reader_get_name (_tmp59_);
					_tmp61_ = _tmp60_;
					if (g_strcmp0 (_tmp61_, "property") == 0) {
						ValaProperty* _tmp62_;
						ValaProperty* _tmp63_;
						_tmp62_ = vala_gir_parser_parse_property (self);
						_tmp63_ = _tmp62_;
						_vala_code_node_unref0 (_tmp63_);
					} else {
						ValaMarkupReader* _tmp64_;
						const gchar* _tmp65_;
						const gchar* _tmp66_;
						_tmp64_ = self->priv->reader;
						_tmp65_ = vala_markup_reader_get_name (_tmp64_);
						_tmp66_ = _tmp65_;
						if (g_strcmp0 (_tmp66_, "constructor") == 0) {
							vala_gir_parser_parse_constructor (self);
						} else {
							ValaMarkupReader* _tmp67_;
							const gchar* _tmp68_;
							const gchar* _tmp69_;
							_tmp67_ = self->priv->reader;
							_tmp68_ = vala_markup_reader_get_name (_tmp67_);
							_tmp69_ = _tmp68_;
							if (g_strcmp0 (_tmp69_, "function") == 0) {
								vala_gir_parser_parse_method (self, "function");
							} else {
								ValaMarkupReader* _tmp70_;
								const gchar* _tmp71_;
								const gchar* _tmp72_;
								_tmp70_ = self->priv->reader;
								_tmp71_ = vala_markup_reader_get_name (_tmp70_);
								_tmp72_ = _tmp71_;
								if (g_strcmp0 (_tmp72_, "function-macro") == 0) {
									vala_gir_parser_skip_element (self);
								} else {
									ValaMarkupReader* _tmp73_;
									const gchar* _tmp74_;
									const gchar* _tmp75_;
									_tmp73_ = self->priv->reader;
									_tmp74_ = vala_markup_reader_get_name (_tmp73_);
									_tmp75_ = _tmp74_;
									if (g_strcmp0 (_tmp75_, "method") == 0) {
										vala_gir_parser_parse_method (self, "method");
									} else {
										ValaMarkupReader* _tmp76_;
										const gchar* _tmp77_;
										const gchar* _tmp78_;
										_tmp76_ = self->priv->reader;
										_tmp77_ = vala_markup_reader_get_name (_tmp76_);
										_tmp78_ = _tmp77_;
										if (g_strcmp0 (_tmp78_, "virtual-method") == 0) {
											vala_gir_parser_parse_method (self, "virtual-method");
										} else {
											ValaMarkupReader* _tmp79_;
											const gchar* _tmp80_;
											const gchar* _tmp81_;
											_tmp79_ = self->priv->reader;
											_tmp80_ = vala_markup_reader_get_name (_tmp79_);
											_tmp81_ = _tmp80_;
											if (g_strcmp0 (_tmp81_, "union") == 0) {
												vala_gir_parser_parse_union (self);
											} else {
												ValaMarkupReader* _tmp82_;
												const gchar* _tmp83_;
												const gchar* _tmp84_;
												_tmp82_ = self->priv->reader;
												_tmp83_ = vala_markup_reader_get_name (_tmp82_);
												_tmp84_ = _tmp83_;
												if (g_strcmp0 (_tmp84_, "glib:signal") == 0) {
													vala_gir_parser_parse_signal (self);
												} else {
													ValaSourceReference* _tmp85_;
													ValaSourceReference* _tmp86_;
													ValaMarkupReader* _tmp87_;
													const gchar* _tmp88_;
													const gchar* _tmp89_;
													gchar* _tmp90_;
													gchar* _tmp91_;
													_tmp85_ = vala_gir_parser_get_current_src (self);
													_tmp86_ = _tmp85_;
													_tmp87_ = self->priv->reader;
													_tmp88_ = vala_markup_reader_get_name (_tmp87_);
													_tmp89_ = _tmp88_;
													_tmp90_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp89_);
													_tmp91_ = _tmp90_;
													vala_report_error (_tmp86_, _tmp91_);
													_g_free0 (_tmp91_);
													_vala_source_reference_unref0 (_tmp86_);
													vala_gir_parser_skip_element (self);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "class");
	_g_free0 (parent);
	_vala_code_node_unref0 (cl);
}

static void
vala_gir_parser_parse_interface (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaInterface* iface = NULL;
	ValaGirParserNode* _tmp2_;
	ValaInterface* _tmp14_;
	ValaInterface* _tmp15_;
	ValaInterface* _tmp16_;
	ValaGirComment* _tmp17_;
	ValaGirComment* _tmp18_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "interface");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		ValaGirParserNode* _tmp3_;
		const gchar* _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaInterface* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaInterface* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_->name;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->source_reference;
		_tmp7_ = vala_interface_new (_tmp4_, _tmp6_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp7_;
		_tmp8_ = self->priv->current;
		_tmp9_ = iface;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (_tmp8_->symbol);
		_tmp8_->symbol = _tmp10_;
	} else {
		ValaGirParserNode* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaInterface* _tmp13_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->symbol;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_INTERFACE, ValaInterface));
		_vala_code_node_unref0 (iface);
		iface = _tmp13_;
	}
	_tmp14_ = iface;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp14_);
	_tmp15_ = iface;
	vala_symbol_set_access ((ValaSymbol*) _tmp15_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	_tmp16_ = iface;
	_tmp17_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp18_ = _tmp17_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp16_, (ValaComment*) _tmp18_);
	_vala_comment_unref0 (_tmp18_);
	while (TRUE) {
		ValaMarkupTokenType _tmp19_;
		ValaMarkupReader* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp19_ = self->priv->current_token;
		if (!(_tmp19_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp20_ = self->priv->reader;
		_tmp21_ = vala_markup_reader_get_name (_tmp20_);
		_tmp22_ = _tmp21_;
		if (g_strcmp0 (_tmp22_, "prerequisite") == 0) {
			ValaInterface* _tmp23_;
			ValaMarkupReader* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			vala_gir_parser_start_element (self, "prerequisite");
			_tmp23_ = iface;
			_tmp24_ = self->priv->reader;
			_tmp25_ = vala_markup_reader_get_attribute (_tmp24_, "name");
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp26_, NULL, NULL, NULL);
			_tmp28_ = _tmp27_;
			vala_interface_add_prerequisite (_tmp23_, _tmp28_);
			_vala_code_node_unref0 (_tmp28_);
			_g_free0 (_tmp26_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "prerequisite");
		} else {
			ValaMarkupReader* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp29_ = self->priv->reader;
			_tmp30_ = vala_markup_reader_get_name (_tmp29_);
			_tmp31_ = _tmp30_;
			if (g_strcmp0 (_tmp31_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaMarkupReader* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				_tmp32_ = self->priv->reader;
				_tmp33_ = vala_markup_reader_get_name (_tmp32_);
				_tmp34_ = _tmp33_;
				if (g_strcmp0 (_tmp34_, "property") == 0) {
					ValaProperty* _tmp35_;
					ValaProperty* _tmp36_;
					_tmp35_ = vala_gir_parser_parse_property (self);
					_tmp36_ = _tmp35_;
					_vala_code_node_unref0 (_tmp36_);
				} else {
					ValaMarkupReader* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					_tmp37_ = self->priv->reader;
					_tmp38_ = vala_markup_reader_get_name (_tmp37_);
					_tmp39_ = _tmp38_;
					if (g_strcmp0 (_tmp39_, "virtual-method") == 0) {
						vala_gir_parser_parse_method (self, "virtual-method");
					} else {
						ValaMarkupReader* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						_tmp40_ = self->priv->reader;
						_tmp41_ = vala_markup_reader_get_name (_tmp40_);
						_tmp42_ = _tmp41_;
						if (g_strcmp0 (_tmp42_, "function") == 0) {
							vala_gir_parser_parse_method (self, "function");
						} else {
							ValaMarkupReader* _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							_tmp43_ = self->priv->reader;
							_tmp44_ = vala_markup_reader_get_name (_tmp43_);
							_tmp45_ = _tmp44_;
							if (g_strcmp0 (_tmp45_, "function-macro") == 0) {
								vala_gir_parser_skip_element (self);
							} else {
								ValaMarkupReader* _tmp46_;
								const gchar* _tmp47_;
								const gchar* _tmp48_;
								_tmp46_ = self->priv->reader;
								_tmp47_ = vala_markup_reader_get_name (_tmp46_);
								_tmp48_ = _tmp47_;
								if (g_strcmp0 (_tmp48_, "method") == 0) {
									vala_gir_parser_parse_method (self, "method");
								} else {
									ValaMarkupReader* _tmp49_;
									const gchar* _tmp50_;
									const gchar* _tmp51_;
									_tmp49_ = self->priv->reader;
									_tmp50_ = vala_markup_reader_get_name (_tmp49_);
									_tmp51_ = _tmp50_;
									if (g_strcmp0 (_tmp51_, "glib:signal") == 0) {
										vala_gir_parser_parse_signal (self);
									} else {
										ValaSourceReference* _tmp52_;
										ValaSourceReference* _tmp53_;
										ValaMarkupReader* _tmp54_;
										const gchar* _tmp55_;
										const gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										_tmp52_ = vala_gir_parser_get_current_src (self);
										_tmp53_ = _tmp52_;
										_tmp54_ = self->priv->reader;
										_tmp55_ = vala_markup_reader_get_name (_tmp54_);
										_tmp56_ = _tmp55_;
										_tmp57_ = g_strdup_printf ("unknown child element `%s' in `interface'", _tmp56_);
										_tmp58_ = _tmp57_;
										vala_report_error (_tmp53_, _tmp58_);
										_g_free0 (_tmp58_);
										_vala_source_reference_unref0 (_tmp53_);
										vala_gir_parser_skip_element (self);
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "interface");
	_vala_code_node_unref0 (iface);
}

static void
vala_gir_parser_parse_field (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp6_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* cname = NULL;
	ValaGirParserNode* _tmp16_;
	ValaMap* _tmp17_;
	gpointer _tmp18_;
	ValaField* field = NULL;
	const gchar* _tmp19_;
	ValaDataType* _tmp20_;
	ValaGirParserNode* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaField* _tmp23_;
	ValaField* _tmp24_;
	ValaField* _tmp25_;
	ValaGirComment* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaDataType* _tmp31_;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_;
	ValaGirParserNode* _tmp41_;
	ValaField* _tmp42_;
	ValaSymbol* _tmp43_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "field");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp6_;
	_tmp10_ = vala_gir_parser_parse_type (self, NULL, &_tmp7_, TRUE, &_tmp8_, &_tmp9_);
	array_length_idx = _tmp7_;
	no_array_length = _tmp8_;
	array_null_terminated = _tmp9_;
	type = _tmp10_;
	_tmp11_ = type;
	_tmp12_ = vala_gir_parser_element_get_type (self, _tmp11_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp12_;
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_->name;
	_tmp15_ = g_strdup (_tmp14_);
	name = _tmp15_;
	_tmp16_ = self->priv->current;
	_tmp17_ = _tmp16_->girdata;
	_tmp18_ = vala_map_get (_tmp17_, "name");
	cname = (gchar*) _tmp18_;
	_tmp19_ = name;
	_tmp20_ = type;
	_tmp21_ = self->priv->current;
	_tmp22_ = _tmp21_->source_reference;
	_tmp23_ = vala_field_new (_tmp19_, _tmp20_, NULL, _tmp22_, NULL);
	field = _tmp23_;
	_tmp24_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp25_ = field;
	_tmp26_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp25_, (ValaComment*) _tmp26_);
	_tmp27_ = name;
	_tmp28_ = cname;
	if (g_strcmp0 (_tmp27_, _tmp28_) != 0) {
		ValaField* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = field;
		_tmp30_ = cname;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp29_, "CCode", "cname", _tmp30_, NULL);
	}
	_tmp31_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp31_)) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp34_ = FALSE;
		if (!no_array_length) {
			_tmp32_ = array_length_idx > -1;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp33_;
			_tmp33_ = self->priv->current;
			_tmp33_->array_length_idx = array_length_idx;
		}
		if (no_array_length) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = array_null_terminated;
		}
		if (_tmp34_) {
			ValaField* _tmp35_;
			_tmp35_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp35_, "CCode", "array_length", !no_array_length, NULL);
		}
		if (array_null_terminated) {
			ValaField* _tmp36_;
			_tmp36_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp36_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp38_ = nullable;
	if (g_strcmp0 (_tmp38_, "1") == 0) {
		_tmp37_ = TRUE;
	} else {
		const gchar* _tmp39_;
		_tmp39_ = allow_none;
		_tmp37_ = g_strcmp0 (_tmp39_, "1") == 0;
	}
	if (_tmp37_) {
		ValaDataType* _tmp40_;
		_tmp40_ = type;
		vala_data_type_set_nullable (_tmp40_, TRUE);
	}
	_tmp41_ = self->priv->current;
	_tmp42_ = field;
	_tmp43_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp42_);
	_vala_code_node_unref0 (_tmp41_->symbol);
	_tmp41_->symbol = _tmp43_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "field");
	_vala_code_node_unref0 (field);
	_g_free0 (cname);
	_g_free0 (name);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (allow_none);
	_g_free0 (nullable);
}

static ValaProperty*
vala_gir_parser_parse_property (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean is_abstract = FALSE;
	ValaGirParserMetadata* _tmp4_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* _tmp6_;
	ValaSymbol* _tmp7_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp8_;
	gchar* _tmp9_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp10_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaProperty* prop = NULL;
	ValaGirParserNode* _tmp17_;
	const gchar* _tmp18_;
	ValaDataType* _tmp19_;
	ValaGirParserNode* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaProperty* _tmp22_;
	ValaProperty* _tmp23_;
	ValaGirComment* _tmp24_;
	ValaProperty* _tmp25_;
	ValaProperty* _tmp26_;
	gboolean _tmp27_ = FALSE;
	ValaGirParserNode* _tmp30_;
	ValaProperty* _tmp31_;
	ValaSymbol* _tmp32_;
	ValaProperty* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "property");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	vala_gir_parser_push_node (self, _tmp3_, FALSE);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->metadata;
	_tmp5_ = self->priv->current;
	_tmp6_ = _tmp5_->parent;
	_tmp7_ = _tmp6_->symbol;
	is_abstract = vala_gir_parser_metadata_get_bool (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, VALA_IS_INTERFACE (_tmp7_));
	_tmp8_ = self->priv->reader;
	_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "transfer-ownership");
	transfer = _tmp9_;
	vala_gir_parser_next (self);
	_tmp10_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp10_;
	_tmp11_ = transfer;
	_tmp14_ = vala_gir_parser_parse_type (self, NULL, NULL, g_strcmp0 (_tmp11_, "container") != 0, &_tmp12_, &_tmp13_);
	no_array_length = _tmp12_;
	array_null_terminated = _tmp13_;
	type = _tmp14_;
	_tmp15_ = type;
	_tmp16_ = vala_gir_parser_element_get_type (self, _tmp15_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp16_;
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = type;
	_tmp20_ = self->priv->current;
	_tmp21_ = _tmp20_->source_reference;
	_tmp22_ = vala_property_new (_tmp18_, _tmp19_, NULL, NULL, _tmp21_, NULL);
	prop = _tmp22_;
	_tmp23_ = prop;
	_tmp24_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp23_, (ValaComment*) _tmp24_);
	_tmp25_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp25_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp26_ = prop;
	vala_property_set_is_abstract (_tmp26_, is_abstract);
	if (no_array_length) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = array_null_terminated;
	}
	if (_tmp27_) {
		ValaProperty* _tmp28_;
		_tmp28_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp28_, "CCode", "array_length", !no_array_length, NULL);
	}
	if (array_null_terminated) {
		ValaProperty* _tmp29_;
		_tmp29_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp29_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp30_ = self->priv->current;
	_tmp31_ = prop;
	_tmp32_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp31_);
	_vala_code_node_unref0 (_tmp30_->symbol);
	_tmp30_->symbol = _tmp32_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "property");
	result = prop;
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (transfer);
	return result;
}

static void
vala_gir_parser_parse_callback (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "callback");
}

static void
vala_gir_parser_parse_constructor (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "constructor");
}

static void
vala_gir_parser_parse_function (ValaGirParser* self,
                                const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* symbol_type = NULL;
	ValaGirParserMetadata* _tmp7_;
	gchar* ctype = NULL;
	ValaGirParserMetadata* _tmp11_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* throws_string = NULL;
	ValaMarkupReader* _tmp17_;
	gchar* _tmp18_;
	gchar* invoker = NULL;
	ValaMarkupReader* _tmp19_;
	gchar* _tmp20_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp21_;
	ValaDataType* return_type = NULL;
	gchar* return_ctype = NULL;
	gint return_array_length_idx = 0;
	gboolean return_no_array_length = FALSE;
	gboolean return_array_null_terminated = FALSE;
	gboolean _tmp22_ = FALSE;
	ValaMarkupTokenType _tmp23_;
	ValaSymbol* s = NULL;
	const gchar* _tmp41_;
	ValaSymbol* _tmp98_;
	ValaSymbol* _tmp99_;
	ValaGirComment* _tmp100_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp101_;
	ValaArrayType* _tmp102_;
	gboolean _tmp103_ = FALSE;
	ValaArrayType* _tmp104_;
	ValaSymbol* _tmp116_;
	ValaSymbol* _tmp130_;
	gboolean _tmp170_ = FALSE;
	ValaSymbol* _tmp171_;
	ValaGirParserMetadata* _tmp195_;
	ValaExpression* _tmp196_;
	ValaExpression* _tmp197_;
	gboolean _tmp198_;
	ValaSymbol* _tmp227_;
	gboolean _tmp237_ = FALSE;
	ValaDataType* _tmp238_;
	ValaGirParserNode* _tmp244_;
	const gchar* _tmp245_;
	ValaGirParserNode* _tmp248_;
	ValaSymbol* _tmp249_;
	ValaSymbol* _tmp250_;
	ValaGirParserMetadata* _tmp251_;
	ValaGirParserMetadata* _tmp256_;
	gint instance_idx = 0;
	gboolean _tmp259_ = FALSE;
	ValaArrayList* parameters = NULL;
	GEqualFunc _tmp266_;
	ValaArrayList* _tmp267_;
	ValaGirParserNode* _tmp268_;
	GEqualFunc _tmp269_;
	ValaArrayList* _tmp270_;
	ValaGirParserNode* _tmp271_;
	GEqualFunc _tmp272_;
	ValaArrayList* _tmp273_;
	ValaGirParserNode* _tmp274_;
	GEqualFunc _tmp275_;
	ValaArrayList* _tmp276_;
	gboolean _tmp277_ = FALSE;
	ValaMarkupTokenType _tmp278_;
	ValaGirParserNode* _tmp353_;
	ValaArrayList* _tmp354_;
	ValaList* _tmp355_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "invoker");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_element_get_name (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "-", "_");
	_tmp6_ = _tmp5_;
	vala_gir_parser_push_node (self, _tmp6_, FALSE);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp7_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE)) {
		ValaGirParserMetadata* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->metadata;
		_tmp9_ = vala_gir_parser_metadata_get_string (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE);
		_g_free0 (symbol_type);
		symbol_type = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (element_name);
		_g_free0 (symbol_type);
		symbol_type = _tmp10_;
	}
	ctype = NULL;
	_tmp11_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp11_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
		ValaGirParserMetadata* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = self->priv->metadata;
		_tmp13_ = vala_gir_parser_metadata_get_string (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
		_g_free0 (ctype);
		ctype = _tmp13_;
	}
	_tmp14_ = self->priv->current;
	_tmp15_ = _tmp14_->name;
	_tmp16_ = g_strdup (_tmp15_);
	name = _tmp16_;
	_tmp17_ = self->priv->reader;
	_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "throws");
	throws_string = _tmp18_;
	_tmp19_ = self->priv->reader;
	_tmp20_ = vala_markup_reader_get_attribute (_tmp19_, "invoker");
	invoker = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp21_;
	return_ctype = NULL;
	return_array_length_idx = -1;
	return_no_array_length = FALSE;
	return_array_null_terminated = FALSE;
	_tmp23_ = self->priv->current_token;
	if (_tmp23_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp24_ = self->priv->reader;
		_tmp25_ = vala_markup_reader_get_name (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = g_strcmp0 (_tmp26_, "return-value") == 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaComment* return_comment = NULL;
		gchar* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ValaComment* _tmp31_ = NULL;
		ValaDataType* _tmp32_;
		ValaComment* _tmp33_;
		_tmp32_ = vala_gir_parser_parse_return_value (self, &_tmp27_, &_tmp28_, &_tmp29_, &_tmp30_, &_tmp31_);
		_g_free0 (return_ctype);
		return_ctype = _tmp27_;
		return_array_length_idx = _tmp28_;
		return_no_array_length = _tmp29_;
		return_array_null_terminated = _tmp30_;
		_vala_comment_unref0 (return_comment);
		return_comment = _tmp31_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp32_;
		_tmp33_ = return_comment;
		if (_tmp33_ != NULL) {
			ValaGirComment* _tmp34_;
			ValaGirComment* _tmp38_;
			ValaComment* _tmp39_;
			_tmp34_ = comment;
			if (_tmp34_ == NULL) {
				ValaGirParserNode* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaGirComment* _tmp37_;
				_tmp35_ = self->priv->current;
				_tmp36_ = _tmp35_->source_reference;
				_tmp37_ = vala_gir_comment_new (NULL, _tmp36_);
				_vala_comment_unref0 (comment);
				comment = _tmp37_;
			}
			_tmp38_ = comment;
			_tmp39_ = return_comment;
			vala_gir_comment_set_return_content (_tmp38_, _tmp39_);
		}
		_vala_comment_unref0 (return_comment);
	} else {
		ValaVoidType* _tmp40_;
		_tmp40_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (return_type);
		return_type = (ValaDataType*) _tmp40_;
	}
	_tmp41_ = symbol_type;
	if (g_strcmp0 (_tmp41_, "callback") == 0) {
		const gchar* _tmp42_;
		ValaDataType* _tmp43_;
		ValaGirParserNode* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaDelegate* _tmp46_;
		ValaSymbol* _tmp47_;
		_tmp42_ = name;
		_tmp43_ = return_type;
		_tmp44_ = self->priv->current;
		_tmp45_ = _tmp44_->source_reference;
		_tmp46_ = vala_delegate_new (_tmp42_, _tmp43_, _tmp45_, NULL);
		_vala_code_node_unref0 (s);
		s = (ValaSymbol*) _tmp46_;
		_tmp47_ = s;
		vala_delegate_set_has_target (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_DELEGATE, ValaDelegate), FALSE);
	} else {
		const gchar* _tmp48_;
		_tmp48_ = symbol_type;
		if (g_strcmp0 (_tmp48_, "constructor") == 0) {
			const gchar* _tmp49_;
			ValaCreationMethod* m = NULL;
			const gchar* _tmp55_;
			ValaGirParserNode* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaCreationMethod* _tmp58_;
			ValaCreationMethod* _tmp59_;
			gboolean _tmp60_ = FALSE;
			const gchar* _tmp61_;
			gchar* parent_ctype = NULL;
			ValaGirParserNode* _tmp69_;
			ValaGirParserNode* _tmp70_;
			ValaSymbol* _tmp71_;
			gboolean _tmp75_ = FALSE;
			const gchar* _tmp76_;
			ValaCreationMethod* _tmp85_;
			ValaSymbol* _tmp86_;
			_tmp49_ = name;
			if (g_strcmp0 (_tmp49_, "new") == 0) {
				_g_free0 (name);
				name = NULL;
			} else {
				const gchar* _tmp50_;
				_tmp50_ = name;
				if (g_str_has_prefix (_tmp50_, "new_")) {
					const gchar* _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					gchar* _tmp54_;
					_tmp51_ = name;
					_tmp52_ = strlen ("new_");
					_tmp53_ = _tmp52_;
					_tmp54_ = string_substring (_tmp51_, (glong) _tmp53_, (glong) -1);
					_g_free0 (name);
					name = _tmp54_;
				}
			}
			_tmp55_ = name;
			_tmp56_ = self->priv->current;
			_tmp57_ = _tmp56_->source_reference;
			_tmp58_ = vala_creation_method_new (NULL, _tmp55_, _tmp57_, NULL);
			m = _tmp58_;
			_tmp59_ = m;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp59_, FALSE);
			_tmp61_ = name;
			if (_tmp61_ != NULL) {
				ValaGirParserNode* _tmp62_;
				const gchar* _tmp63_;
				_tmp62_ = self->priv->current;
				_tmp63_ = _tmp62_->name;
				_tmp60_ = !g_str_has_prefix (_tmp63_, "new_");
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaCreationMethod* _tmp64_;
				ValaGirParserNode* _tmp65_;
				ValaMap* _tmp66_;
				gpointer _tmp67_;
				gchar* _tmp68_;
				_tmp64_ = m;
				_tmp65_ = self->priv->current;
				_tmp66_ = _tmp65_->girdata;
				_tmp67_ = vala_map_get (_tmp66_, "c:identifier");
				_tmp68_ = (gchar*) _tmp67_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp64_, "CCode", "cname", _tmp68_, NULL);
				_g_free0 (_tmp68_);
			}
			parent_ctype = NULL;
			_tmp69_ = self->priv->current;
			_tmp70_ = _tmp69_->parent;
			_tmp71_ = _tmp70_->symbol;
			if (VALA_IS_CLASS (_tmp71_)) {
				ValaGirParserNode* _tmp72_;
				ValaGirParserNode* _tmp73_;
				gchar* _tmp74_;
				_tmp72_ = self->priv->current;
				_tmp73_ = _tmp72_->parent;
				_tmp74_ = vala_gir_parser_node_get_cname (_tmp73_);
				_g_free0 (parent_ctype);
				parent_ctype = _tmp74_;
			}
			_tmp76_ = return_ctype;
			if (_tmp76_ != NULL) {
				gboolean _tmp77_ = FALSE;
				const gchar* _tmp78_;
				_tmp78_ = parent_ctype;
				if (_tmp78_ == NULL) {
					_tmp77_ = TRUE;
				} else {
					const gchar* _tmp79_;
					const gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					_tmp79_ = return_ctype;
					_tmp80_ = parent_ctype;
					_tmp81_ = g_strconcat (_tmp80_, "*", NULL);
					_tmp82_ = _tmp81_;
					_tmp77_ = g_strcmp0 (_tmp79_, _tmp82_) != 0;
					_g_free0 (_tmp82_);
				}
				_tmp75_ = _tmp77_;
			} else {
				_tmp75_ = FALSE;
			}
			if (_tmp75_) {
				ValaCreationMethod* _tmp83_;
				const gchar* _tmp84_;
				_tmp83_ = m;
				_tmp84_ = return_ctype;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp83_, "CCode", "type", _tmp84_, NULL);
			}
			_tmp85_ = m;
			_tmp86_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp85_);
			_vala_code_node_unref0 (s);
			s = _tmp86_;
			_g_free0 (parent_ctype);
			_vala_code_node_unref0 (m);
		} else {
			const gchar* _tmp87_;
			_tmp87_ = symbol_type;
			if (g_strcmp0 (_tmp87_, "glib:signal") == 0) {
				const gchar* _tmp88_;
				ValaDataType* _tmp89_;
				ValaGirParserNode* _tmp90_;
				ValaSourceReference* _tmp91_;
				ValaSignal* _tmp92_;
				_tmp88_ = name;
				_tmp89_ = return_type;
				_tmp90_ = self->priv->current;
				_tmp91_ = _tmp90_->source_reference;
				_tmp92_ = vala_signal_new (_tmp88_, _tmp89_, _tmp91_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp92_;
			} else {
				const gchar* _tmp93_;
				ValaDataType* _tmp94_;
				ValaGirParserNode* _tmp95_;
				ValaSourceReference* _tmp96_;
				ValaMethod* _tmp97_;
				_tmp93_ = name;
				_tmp94_ = return_type;
				_tmp95_ = self->priv->current;
				_tmp96_ = _tmp95_->source_reference;
				_tmp97_ = vala_method_new (_tmp93_, _tmp94_, _tmp96_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp97_;
			}
		}
	}
	_tmp98_ = s;
	vala_symbol_set_access (_tmp98_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp99_ = s;
	_tmp100_ = comment;
	vala_symbol_set_comment (_tmp99_, (ValaComment*) _tmp100_);
	_tmp101_ = return_type;
	_tmp102_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (_tmp101_) ? ((ValaArrayType*) _tmp101_) : NULL);
	array_type = _tmp102_;
	_tmp104_ = array_type;
	if (_tmp104_ != NULL) {
		ValaArrayType* _tmp105_;
		gboolean _tmp106_;
		gboolean _tmp107_;
		_tmp105_ = array_type;
		_tmp106_ = vala_array_type_get_fixed_length (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp103_ = _tmp107_;
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		ValaSymbol* _tmp108_;
		ValaArrayType* _tmp109_;
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		const gchar* _tmp112_;
		const gchar* _tmp113_;
		ValaArrayType* _tmp114_;
		ValaArrayType* _tmp115_;
		_tmp108_ = s;
		_tmp109_ = array_type;
		_tmp110_ = vala_array_type_get_length (_tmp109_);
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
		_tmp113_ = _tmp112_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp108_, "CCode", "array_length_cexpr", _tmp113_, NULL);
		_tmp114_ = array_type;
		vala_array_type_set_fixed_length (_tmp114_, FALSE);
		_tmp115_ = array_type;
		vala_array_type_set_length (_tmp115_, NULL);
	}
	_tmp116_ = s;
	if (VALA_IS_SIGNAL (_tmp116_)) {
		ValaGirParserNode* _tmp117_;
		ValaMap* _tmp118_;
		gpointer _tmp119_;
		gchar* _tmp120_;
		const gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		gboolean _tmp124_;
		_tmp117_ = self->priv->current;
		_tmp118_ = _tmp117_->girdata;
		_tmp119_ = vala_map_get (_tmp118_, "name");
		_tmp120_ = (gchar*) _tmp119_;
		_tmp121_ = name;
		_tmp122_ = string_replace (_tmp121_, "_", "-");
		_tmp123_ = _tmp122_;
		_tmp124_ = g_strcmp0 (_tmp120_, _tmp123_) != 0;
		_g_free0 (_tmp123_);
		_g_free0 (_tmp120_);
		if (_tmp124_) {
			ValaSymbol* _tmp125_;
			ValaGirParserNode* _tmp126_;
			ValaMap* _tmp127_;
			gpointer _tmp128_;
			gchar* _tmp129_;
			_tmp125_ = s;
			_tmp126_ = self->priv->current;
			_tmp127_ = _tmp126_->girdata;
			_tmp128_ = vala_map_get (_tmp127_, "name");
			_tmp129_ = (gchar*) _tmp128_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp125_, "CCode", "cname", _tmp129_, NULL);
			_g_free0 (_tmp129_);
		}
	}
	_tmp130_ = s;
	if (VALA_IS_METHOD (_tmp130_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp131_;
		ValaMethod* _tmp132_;
		gboolean _tmp133_ = FALSE;
		const gchar* _tmp134_;
		ValaGirParserMetadata* _tmp161_;
		ValaGirParserMetadata* _tmp167_;
		_tmp131_ = s;
		_tmp132_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp131_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp132_;
		_tmp134_ = symbol_type;
		if (g_strcmp0 (_tmp134_, "virtual-method") == 0) {
			_tmp133_ = TRUE;
		} else {
			const gchar* _tmp135_;
			_tmp135_ = symbol_type;
			_tmp133_ = g_strcmp0 (_tmp135_, "callback") == 0;
		}
		if (_tmp133_) {
			ValaGirParserNode* _tmp136_;
			ValaGirParserNode* _tmp137_;
			ValaSymbol* _tmp138_;
			gboolean _tmp141_ = FALSE;
			const gchar* _tmp142_;
			ValaGirParserNode* _tmp148_;
			ValaMap* _tmp149_;
			gpointer _tmp150_;
			gchar* _tmp151_;
			const gchar* _tmp152_;
			gboolean _tmp153_;
			_tmp136_ = self->priv->current;
			_tmp137_ = _tmp136_->parent;
			_tmp138_ = _tmp137_->symbol;
			if (VALA_IS_INTERFACE (_tmp138_)) {
				ValaMethod* _tmp139_;
				_tmp139_ = m;
				vala_method_set_is_abstract (_tmp139_, TRUE);
			} else {
				ValaMethod* _tmp140_;
				_tmp140_ = m;
				vala_method_set_is_virtual (_tmp140_, TRUE);
			}
			_tmp142_ = invoker;
			if (_tmp142_ == NULL) {
				ValaGirParserMetadata* _tmp143_;
				_tmp143_ = self->priv->metadata;
				_tmp141_ = !vala_gir_parser_metadata_has_argument (_tmp143_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			} else {
				_tmp141_ = FALSE;
			}
			if (_tmp141_) {
				ValaSymbol* _tmp144_;
				ValaSymbol* _tmp145_;
				ValaSourceReference* _tmp146_;
				ValaSourceReference* _tmp147_;
				_tmp144_ = s;
				_tmp145_ = s;
				_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp145_);
				_tmp147_ = _tmp146_;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp144_, "NoWrapper", TRUE, _tmp147_);
			}
			_tmp148_ = self->priv->current;
			_tmp149_ = _tmp148_->girdata;
			_tmp150_ = vala_map_get (_tmp149_, "name");
			_tmp151_ = (gchar*) _tmp150_;
			_tmp152_ = name;
			_tmp153_ = g_strcmp0 (_tmp151_, _tmp152_) != 0;
			_g_free0 (_tmp151_);
			if (_tmp153_) {
				ValaMethod* _tmp154_;
				ValaGirParserNode* _tmp155_;
				ValaMap* _tmp156_;
				gpointer _tmp157_;
				gchar* _tmp158_;
				_tmp154_ = m;
				_tmp155_ = self->priv->current;
				_tmp156_ = _tmp155_->girdata;
				_tmp157_ = vala_map_get (_tmp156_, "name");
				_tmp158_ = (gchar*) _tmp157_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp154_, "CCode", "vfunc_name", _tmp158_, NULL);
				_g_free0 (_tmp158_);
			}
		} else {
			const gchar* _tmp159_;
			_tmp159_ = symbol_type;
			if (g_strcmp0 (_tmp159_, "function") == 0) {
				ValaMethod* _tmp160_;
				_tmp160_ = m;
				vala_method_set_binding (_tmp160_, VALA_MEMBER_BINDING_STATIC);
			}
		}
		_tmp161_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp161_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING)) {
			ValaMethod* _tmp162_;
			ValaGirParserMetadata* _tmp163_;
			ValaMethod* _tmp164_;
			ValaDataType* _tmp165_;
			ValaDataType* _tmp166_;
			_tmp162_ = m;
			_tmp163_ = self->priv->metadata;
			vala_method_set_returns_floating_reference (_tmp162_, vala_gir_parser_metadata_get_bool (_tmp163_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, FALSE));
			_tmp164_ = m;
			_tmp165_ = vala_callable_get_return_type ((ValaCallable*) _tmp164_);
			_tmp166_ = _tmp165_;
			vala_data_type_set_value_owned (_tmp166_, TRUE);
		}
		_tmp167_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp167_, VALA_GIR_PARSER_ARGUMENT_TYPE_NEW)) {
			ValaMethod* _tmp168_;
			ValaGirParserMetadata* _tmp169_;
			_tmp168_ = m;
			_tmp169_ = self->priv->metadata;
			vala_symbol_set_hides ((ValaSymbol*) _tmp168_, vala_gir_parser_metadata_get_bool (_tmp169_, VALA_GIR_PARSER_ARGUMENT_TYPE_NEW, FALSE));
		}
		_vala_code_node_unref0 (m);
	}
	_tmp171_ = s;
	if (VALA_IS_METHOD (_tmp171_)) {
		ValaSymbol* _tmp172_;
		_tmp172_ = s;
		_tmp170_ = !VALA_IS_CREATION_METHOD (_tmp172_);
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* method = NULL;
		ValaSymbol* _tmp173_;
		ValaMethod* _tmp174_;
		ValaGirParserMetadata* _tmp175_;
		ValaGirParserMetadata* _tmp183_;
		ValaGirParserMetadata* _tmp189_;
		_tmp173_ = s;
		_tmp174_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp173_, VALA_TYPE_METHOD, ValaMethod));
		method = _tmp174_;
		_tmp175_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp175_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL)) {
			ValaMethod* _tmp176_;
			ValaGirParserMetadata* _tmp177_;
			ValaMethod* _tmp178_;
			_tmp176_ = method;
			_tmp177_ = self->priv->metadata;
			vala_method_set_is_virtual (_tmp176_, vala_gir_parser_metadata_get_bool (_tmp177_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, FALSE));
			_tmp178_ = method;
			vala_method_set_is_abstract (_tmp178_, FALSE);
		} else {
			ValaGirParserMetadata* _tmp179_;
			_tmp179_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp179_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT)) {
				ValaMethod* _tmp180_;
				ValaGirParserMetadata* _tmp181_;
				ValaMethod* _tmp182_;
				_tmp180_ = method;
				_tmp181_ = self->priv->metadata;
				vala_method_set_is_abstract (_tmp180_, vala_gir_parser_metadata_get_bool (_tmp181_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, FALSE));
				_tmp182_ = method;
				vala_method_set_is_virtual (_tmp182_, FALSE);
			}
		}
		_tmp183_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp183_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
			ValaMethod* _tmp184_;
			ValaGirParserMetadata* _tmp185_;
			gchar* _tmp186_;
			gchar* _tmp187_;
			ValaMethod* _tmp188_;
			_tmp184_ = method;
			_tmp185_ = self->priv->metadata;
			_tmp186_ = vala_gir_parser_metadata_get_string (_tmp185_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			_tmp187_ = _tmp186_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp184_, "CCode", "vfunc_name", _tmp187_, NULL);
			_g_free0 (_tmp187_);
			_tmp188_ = method;
			vala_method_set_is_virtual (_tmp188_, TRUE);
		}
		_tmp189_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp189_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME)) {
			ValaMethod* _tmp190_;
			ValaGirParserMetadata* _tmp191_;
			gchar* _tmp192_;
			gchar* _tmp193_;
			ValaMethod* _tmp194_;
			_tmp190_ = method;
			_tmp191_ = self->priv->metadata;
			_tmp192_ = vala_gir_parser_metadata_get_string (_tmp191_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME);
			_tmp193_ = _tmp192_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp190_, "CCode", "finish_vfunc_name", _tmp193_, NULL);
			_g_free0 (_tmp193_);
			_tmp194_ = method;
			vala_method_set_is_virtual (_tmp194_, TRUE);
		}
		_vala_code_node_unref0 (method);
	}
	_tmp195_ = self->priv->metadata;
	_tmp196_ = vala_gir_parser_metadata_get_expression (_tmp195_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
	_tmp197_ = _tmp196_;
	_tmp198_ = !VALA_IS_NULL_LITERAL (_tmp197_);
	_vala_code_node_unref0 (_tmp197_);
	if (_tmp198_) {
		ValaGirParserMetadata* _tmp199_;
		_tmp199_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp199_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS)) {
			gchar** error_types = NULL;
			ValaGirParserMetadata* _tmp200_;
			gchar* _tmp201_;
			gchar* _tmp202_;
			gchar** _tmp203_;
			gchar** _tmp204_;
			gchar** _tmp205_;
			gint _tmp205__length1;
			gint error_types_length1;
			gint _error_types_size_;
			gchar** _tmp206_;
			gint _tmp206__length1;
			_tmp200_ = self->priv->metadata;
			_tmp201_ = vala_gir_parser_metadata_get_string (_tmp200_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
			_tmp202_ = _tmp201_;
			_tmp204_ = _tmp203_ = g_strsplit (_tmp202_, ",", 0);
			_tmp205_ = _tmp204_;
			_tmp205__length1 = _vala_array_length (_tmp203_);
			_g_free0 (_tmp202_);
			error_types = _tmp205_;
			error_types_length1 = _tmp205__length1;
			_error_types_size_ = error_types_length1;
			_tmp206_ = error_types;
			_tmp206__length1 = error_types_length1;
			{
				gchar** error_type_name_collection = NULL;
				gint error_type_name_collection_length1 = 0;
				gint _error_type_name_collection_size_ = 0;
				gint error_type_name_it = 0;
				error_type_name_collection = _tmp206_;
				error_type_name_collection_length1 = _tmp206__length1;
				for (error_type_name_it = 0; error_type_name_it < error_type_name_collection_length1; error_type_name_it = error_type_name_it + 1) {
					gchar* _tmp207_;
					gchar* error_type_name = NULL;
					_tmp207_ = g_strdup (error_type_name_collection[error_type_name_it]);
					error_type_name = _tmp207_;
					{
						ValaDataType* error_type = NULL;
						const gchar* _tmp208_;
						ValaGirParserMetadata* _tmp209_;
						ValaSourceReference* _tmp210_;
						ValaSourceReference* _tmp211_;
						ValaDataType* _tmp212_;
						ValaDataType* _tmp213_;
						ValaSymbol* _tmp214_;
						_tmp208_ = error_type_name;
						_tmp209_ = self->priv->metadata;
						_tmp210_ = vala_gir_parser_metadata_get_source_reference (_tmp209_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
						_tmp211_ = _tmp210_;
						_tmp212_ = vala_gir_parser_parse_type_from_string (self, _tmp208_, TRUE, _tmp211_);
						_tmp213_ = _tmp212_;
						_vala_source_reference_unref0 (_tmp211_);
						error_type = _tmp213_;
						_tmp214_ = s;
						if (VALA_IS_METHOD (_tmp214_)) {
							ValaSymbol* _tmp215_;
							ValaDataType* _tmp216_;
							_tmp215_ = s;
							_tmp216_ = error_type;
							vala_method_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp215_, VALA_TYPE_METHOD, ValaMethod), _tmp216_);
						} else {
							ValaSymbol* _tmp217_;
							ValaDataType* _tmp218_;
							_tmp217_ = s;
							_tmp218_ = error_type;
							vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp217_, VALA_TYPE_DELEGATE, ValaDelegate), _tmp218_);
						}
						_vala_code_node_unref0 (error_type);
						_g_free0 (error_type_name);
					}
				}
			}
			error_types = (_vala_array_free (error_types, error_types_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp219_;
			_tmp219_ = throws_string;
			if (g_strcmp0 (_tmp219_, "1") == 0) {
				ValaSymbol* _tmp220_;
				_tmp220_ = s;
				if (VALA_IS_METHOD (_tmp220_)) {
					ValaSymbol* _tmp221_;
					ValaErrorType* _tmp222_;
					ValaErrorType* _tmp223_;
					_tmp221_ = s;
					_tmp222_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp223_ = _tmp222_;
					vala_method_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp221_, VALA_TYPE_METHOD, ValaMethod), (ValaDataType*) _tmp223_);
					_vala_code_node_unref0 (_tmp223_);
				} else {
					ValaSymbol* _tmp224_;
					ValaErrorType* _tmp225_;
					ValaErrorType* _tmp226_;
					_tmp224_ = s;
					_tmp225_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp226_ = _tmp225_;
					vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp224_, VALA_TYPE_DELEGATE, ValaDelegate), (ValaDataType*) _tmp226_);
					_vala_code_node_unref0 (_tmp226_);
				}
			}
		}
	}
	_tmp227_ = s;
	if (VALA_IS_METHOD (_tmp227_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp228_;
		ValaMethod* _tmp229_;
		ValaMethod* _tmp230_;
		ValaGirParserMetadata* _tmp231_;
		ValaGirParserMetadata* _tmp232_;
		_tmp228_ = s;
		_tmp229_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp228_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp229_;
		_tmp230_ = m;
		_tmp231_ = self->priv->metadata;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp230_, "PrintfFormat", vala_gir_parser_metadata_get_bool (_tmp231_, VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, FALSE), NULL);
		_tmp232_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp232_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL)) {
			ValaMethod* _tmp233_;
			ValaGirParserMetadata* _tmp234_;
			gchar* _tmp235_;
			gchar* _tmp236_;
			_tmp233_ = m;
			_tmp234_ = self->priv->metadata;
			_tmp235_ = vala_gir_parser_metadata_get_string (_tmp234_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL);
			_tmp236_ = _tmp235_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp233_, "CCode", "sentinel", _tmp236_, NULL);
			_g_free0 (_tmp236_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp238_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp238_)) {
		ValaGirParserMetadata* _tmp239_;
		_tmp239_ = self->priv->metadata;
		_tmp237_ = vala_gir_parser_metadata_has_argument (_tmp239_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		_tmp237_ = FALSE;
	}
	if (_tmp237_) {
		ValaGirParserMetadata* _tmp240_;
		_tmp240_ = self->priv->metadata;
		return_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp240_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		gboolean _tmp241_ = FALSE;
		if (return_no_array_length) {
			_tmp241_ = TRUE;
		} else {
			_tmp241_ = return_array_null_terminated;
		}
		if (_tmp241_) {
			ValaSymbol* _tmp242_;
			_tmp242_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp242_, "CCode", "array_length", !return_no_array_length, NULL);
		}
		if (return_array_null_terminated) {
			ValaSymbol* _tmp243_;
			_tmp243_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp243_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp244_ = self->priv->current;
	_tmp244_->return_array_length_idx = return_array_length_idx;
	_tmp245_ = ctype;
	if (_tmp245_ != NULL) {
		ValaSymbol* _tmp246_;
		const gchar* _tmp247_;
		_tmp246_ = s;
		_tmp247_ = ctype;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp246_, "CCode", "type", _tmp247_, NULL);
	}
	_tmp248_ = self->priv->current;
	_tmp249_ = s;
	_tmp250_ = _vala_code_node_ref0 (_tmp249_);
	_vala_code_node_unref0 (_tmp248_->symbol);
	_tmp248_->symbol = _tmp250_;
	_tmp251_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp251_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME)) {
		ValaSymbol* _tmp252_;
		ValaGirParserMetadata* _tmp253_;
		gchar* _tmp254_;
		gchar* _tmp255_;
		_tmp252_ = s;
		_tmp253_ = self->priv->metadata;
		_tmp254_ = vala_gir_parser_metadata_get_string (_tmp253_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME);
		_tmp255_ = _tmp254_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp252_, "CCode", "finish_name", _tmp255_, NULL);
		_g_free0 (_tmp255_);
	}
	_tmp256_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp256_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE)) {
		ValaSymbol* _tmp257_;
		ValaGirParserMetadata* _tmp258_;
		_tmp257_ = s;
		_tmp258_ = self->priv->metadata;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp257_, "CCode", "finish_instance", vala_gir_parser_metadata_get_bool (_tmp258_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, FALSE), NULL);
	}
	instance_idx = -2;
	if (g_strcmp0 (element_name, "function") == 0) {
		const gchar* _tmp260_;
		_tmp260_ = symbol_type;
		_tmp259_ = g_strcmp0 (_tmp260_, "method") == 0;
	} else {
		_tmp259_ = FALSE;
	}
	if (_tmp259_) {
		ValaGirParserMetadata* _tmp261_;
		_tmp261_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp261_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX)) {
			ValaGirParserMetadata* _tmp262_;
			_tmp262_ = self->priv->metadata;
			instance_idx = vala_gir_parser_metadata_get_integer (_tmp262_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX);
			if (instance_idx != 0) {
				ValaSymbol* _tmp263_;
				_tmp263_ = s;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp263_, "CCode", "instance_pos", instance_idx + 0.5, NULL);
			}
		} else {
			ValaSourceReference* _tmp264_;
			ValaSourceReference* _tmp265_;
			_tmp264_ = vala_gir_parser_get_current_src (self);
			_tmp265_ = _tmp264_;
			vala_report_error (_tmp265_, "instance_idx required when converting function to method");
			_vala_source_reference_unref0 (_tmp265_);
		}
	}
	_tmp266_ = g_direct_equal;
	_tmp267_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, (GBoxedCopyFunc) vala_gir_parser_parameter_info_ref, (GDestroyNotify) vala_gir_parser_parameter_info_unref, _tmp266_);
	parameters = _tmp267_;
	_tmp268_ = self->priv->current;
	_tmp269_ = g_direct_equal;
	_tmp270_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp269_);
	_vala_iterable_unref0 (_tmp268_->array_length_parameters);
	_tmp268_->array_length_parameters = _tmp270_;
	_tmp271_ = self->priv->current;
	_tmp272_ = g_direct_equal;
	_tmp273_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp272_);
	_vala_iterable_unref0 (_tmp271_->closure_parameters);
	_tmp271_->closure_parameters = _tmp273_;
	_tmp274_ = self->priv->current;
	_tmp275_ = g_direct_equal;
	_tmp276_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp275_);
	_vala_iterable_unref0 (_tmp274_->destroy_parameters);
	_tmp274_->destroy_parameters = _tmp276_;
	_tmp278_ = self->priv->current_token;
	if (_tmp278_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp279_;
		const gchar* _tmp280_;
		const gchar* _tmp281_;
		_tmp279_ = self->priv->reader;
		_tmp280_ = vala_markup_reader_get_name (_tmp279_);
		_tmp281_ = _tmp280_;
		_tmp277_ = g_strcmp0 (_tmp281_, "parameters") == 0;
	} else {
		_tmp277_ = FALSE;
	}
	if (_tmp277_) {
		gint current_parameter_idx = 0;
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		current_parameter_idx = -1;
		while (TRUE) {
			ValaMarkupTokenType _tmp282_;
			gint _tmp283_;
			gboolean _tmp284_ = FALSE;
			ValaMarkupReader* _tmp285_;
			const gchar* _tmp286_;
			const gchar* _tmp287_;
			gboolean is_instance_parameter = FALSE;
			gboolean _tmp291_ = FALSE;
			gint array_length_idx = 0;
			gint closure_idx = 0;
			gint destroy_idx = 0;
			gchar* scope = NULL;
			gchar* default_param_name = NULL;
			ValaComment* param_comment = NULL;
			ValaArrayList* _tmp292_;
			gint _tmp293_;
			gint _tmp294_;
			gchar* _tmp295_;
			ValaParameter* param = NULL;
			const gchar* _tmp296_;
			gint _tmp297_ = 0;
			gint _tmp298_ = 0;
			gint _tmp299_ = 0;
			gchar* _tmp300_ = NULL;
			ValaComment* _tmp301_ = NULL;
			ValaParameter* _tmp302_;
			ValaComment* _tmp331_;
			ValaGirParserParameterInfo* info = NULL;
			ValaParameter* _tmp348_;
			const gchar* _tmp349_;
			ValaGirParserParameterInfo* _tmp350_;
			ValaArrayList* _tmp351_;
			ValaGirParserParameterInfo* _tmp352_;
			_tmp282_ = self->priv->current_token;
			if (!(_tmp282_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			_tmp283_ = current_parameter_idx;
			current_parameter_idx = _tmp283_ + 1;
			_tmp285_ = self->priv->reader;
			_tmp286_ = vala_markup_reader_get_name (_tmp285_);
			_tmp287_ = _tmp286_;
			if (g_strcmp0 (_tmp287_, "instance-parameter") == 0) {
				gboolean _tmp288_ = FALSE;
				const gchar* _tmp289_;
				_tmp289_ = symbol_type;
				if (g_strcmp0 (_tmp289_, "function") == 0) {
					_tmp288_ = TRUE;
				} else {
					const gchar* _tmp290_;
					_tmp290_ = symbol_type;
					_tmp288_ = g_strcmp0 (_tmp290_, "constructor") == 0;
				}
				_tmp284_ = !_tmp288_;
			} else {
				_tmp284_ = FALSE;
			}
			is_instance_parameter = _tmp284_;
			if (instance_idx > -2) {
				_tmp291_ = instance_idx == current_parameter_idx;
			} else {
				_tmp291_ = FALSE;
			}
			if (_tmp291_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			default_param_name = NULL;
			_tmp292_ = parameters;
			_tmp293_ = vala_collection_get_size ((ValaCollection*) _tmp292_);
			_tmp294_ = _tmp293_;
			_tmp295_ = g_strdup_printf ("arg%d", _tmp294_);
			_g_free0 (default_param_name);
			default_param_name = _tmp295_;
			_tmp296_ = default_param_name;
			_tmp302_ = vala_gir_parser_parse_parameter (self, &_tmp297_, &_tmp298_, &_tmp299_, &_tmp300_, &_tmp301_, _tmp296_);
			array_length_idx = _tmp297_;
			closure_idx = _tmp298_;
			destroy_idx = _tmp299_;
			_g_free0 (scope);
			scope = _tmp300_;
			_vala_comment_unref0 (param_comment);
			param_comment = _tmp301_;
			param = _tmp302_;
			if (is_instance_parameter) {
				ValaMethod* m = NULL;
				ValaSymbol* _tmp303_;
				ValaMethod* _tmp304_;
				_tmp303_ = s;
				m = VALA_IS_METHOD (_tmp303_) ? ((ValaMethod*) _tmp303_) : NULL;
				_tmp304_ = m;
				if (_tmp304_ != NULL) {
					ValaParameter* _tmp305_;
					ValaParameterDirection _tmp306_;
					ValaParameterDirection _tmp307_;
					_tmp305_ = param;
					_tmp306_ = vala_parameter_get_direction (_tmp305_);
					_tmp307_ = _tmp306_;
					if (_tmp307_ == VALA_PARAMETER_DIRECTION_IN) {
						ValaParameter* _tmp308_;
						ValaDataType* _tmp309_;
						ValaDataType* _tmp310_;
						gboolean _tmp311_;
						gboolean _tmp312_;
						_tmp308_ = param;
						_tmp309_ = vala_variable_get_variable_type ((ValaVariable*) _tmp308_);
						_tmp310_ = _tmp309_;
						_tmp311_ = vala_data_type_get_value_owned (_tmp310_);
						_tmp312_ = _tmp311_;
						if (_tmp312_) {
							ValaMethod* _tmp313_;
							_tmp313_ = m;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp313_, "DestroysInstance", TRUE, NULL);
						}
						vala_gir_parser_pop_metadata (self);
						_vala_code_node_unref0 (param);
						_vala_comment_unref0 (param_comment);
						_g_free0 (default_param_name);
						_g_free0 (scope);
						continue;
					} else {
						ValaMethod* _tmp314_;
						_tmp314_ = m;
						vala_method_set_binding (_tmp314_, VALA_MEMBER_BINDING_STATIC);
					}
				}
			}
			if (array_length_idx != -1) {
				gboolean _tmp315_ = FALSE;
				ValaGirParserNode* _tmp317_;
				ValaArrayList* _tmp318_;
				if (instance_idx > -2) {
					_tmp315_ = instance_idx < array_length_idx;
				} else {
					_tmp315_ = FALSE;
				}
				if (_tmp315_) {
					gint _tmp316_;
					_tmp316_ = array_length_idx;
					array_length_idx = _tmp316_ - 1;
				}
				_tmp317_ = self->priv->current;
				_tmp318_ = _tmp317_->array_length_parameters;
				vala_collection_add ((ValaCollection*) _tmp318_, (gpointer) ((gintptr) array_length_idx));
			}
			if (closure_idx != -1) {
				gboolean _tmp319_ = FALSE;
				ValaGirParserNode* _tmp321_;
				ValaArrayList* _tmp322_;
				if (instance_idx > -2) {
					_tmp319_ = instance_idx < closure_idx;
				} else {
					_tmp319_ = FALSE;
				}
				if (_tmp319_) {
					gint _tmp320_;
					_tmp320_ = closure_idx;
					closure_idx = _tmp320_ - 1;
				}
				_tmp321_ = self->priv->current;
				_tmp322_ = _tmp321_->closure_parameters;
				if (vala_list_index_of ((ValaList*) _tmp322_, (gpointer) ((gintptr) current_parameter_idx)) < 0) {
					ValaGirParserNode* _tmp323_;
					ValaArrayList* _tmp324_;
					_tmp323_ = self->priv->current;
					_tmp324_ = _tmp323_->closure_parameters;
					vala_collection_add ((ValaCollection*) _tmp324_, (gpointer) ((gintptr) closure_idx));
				}
			}
			if (destroy_idx != -1) {
				gboolean _tmp325_ = FALSE;
				ValaGirParserNode* _tmp327_;
				ValaArrayList* _tmp328_;
				if (instance_idx > -2) {
					_tmp325_ = instance_idx < destroy_idx;
				} else {
					_tmp325_ = FALSE;
				}
				if (_tmp325_) {
					gint _tmp326_;
					_tmp326_ = destroy_idx;
					destroy_idx = _tmp326_ - 1;
				}
				_tmp327_ = self->priv->current;
				_tmp328_ = _tmp327_->destroy_parameters;
				if (vala_list_index_of ((ValaList*) _tmp328_, (gpointer) ((gintptr) current_parameter_idx)) < 0) {
					ValaGirParserNode* _tmp329_;
					ValaArrayList* _tmp330_;
					_tmp329_ = self->priv->current;
					_tmp330_ = _tmp329_->destroy_parameters;
					vala_collection_add ((ValaCollection*) _tmp330_, (gpointer) ((gintptr) destroy_idx));
				}
			}
			_tmp331_ = param_comment;
			if (_tmp331_ != NULL) {
				ValaGirComment* _tmp332_;
				const gchar* _tmp339_ = NULL;
				ValaParameter* _tmp340_;
				gboolean _tmp341_;
				gboolean _tmp342_;
				ValaGirComment* _tmp346_;
				ValaComment* _tmp347_;
				_tmp332_ = comment;
				if (_tmp332_ == NULL) {
					ValaSymbol* _tmp333_;
					ValaSourceReference* _tmp334_;
					ValaSourceReference* _tmp335_;
					ValaGirComment* _tmp336_;
					ValaSymbol* _tmp337_;
					ValaGirComment* _tmp338_;
					_tmp333_ = s;
					_tmp334_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp333_);
					_tmp335_ = _tmp334_;
					_tmp336_ = vala_gir_comment_new (NULL, _tmp335_);
					_vala_comment_unref0 (comment);
					comment = _tmp336_;
					_tmp337_ = s;
					_tmp338_ = comment;
					vala_symbol_set_comment (_tmp337_, (ValaComment*) _tmp338_);
				}
				_tmp340_ = param;
				_tmp341_ = vala_parameter_get_ellipsis (_tmp340_);
				_tmp342_ = _tmp341_;
				if (_tmp342_) {
					_tmp339_ = "...";
				} else {
					ValaParameter* _tmp343_;
					const gchar* _tmp344_;
					const gchar* _tmp345_;
					_tmp343_ = param;
					_tmp344_ = vala_symbol_get_name ((ValaSymbol*) _tmp343_);
					_tmp345_ = _tmp344_;
					_tmp339_ = _tmp345_;
				}
				_tmp346_ = comment;
				_tmp347_ = param_comment;
				vala_gir_comment_add_content_for_parameter (_tmp346_, _tmp339_, _tmp347_);
			}
			_tmp348_ = param;
			_tmp349_ = scope;
			_tmp350_ = vala_gir_parser_parameter_info_new (_tmp348_, array_length_idx, closure_idx, destroy_idx, g_strcmp0 (_tmp349_, "async") == 0);
			info = _tmp350_;
			_tmp351_ = parameters;
			_tmp352_ = info;
			vala_collection_add ((ValaCollection*) _tmp351_, _tmp352_);
			vala_gir_parser_pop_metadata (self);
			_vala_gir_parser_parameter_info_unref0 (info);
			_vala_code_node_unref0 (param);
			_vala_comment_unref0 (param_comment);
			_g_free0 (default_param_name);
			_g_free0 (scope);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	_tmp353_ = self->priv->current;
	_tmp354_ = parameters;
	_tmp355_ = _vala_iterable_ref0 ((ValaList*) _tmp354_);
	_vala_iterable_unref0 (_tmp353_->parameters);
	_tmp353_->parameters = _tmp355_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (s);
	_g_free0 (return_ctype);
	_vala_code_node_unref0 (return_type);
	_vala_comment_unref0 (comment);
	_g_free0 (invoker);
	_g_free0 (throws_string);
	_g_free0 (name);
	_g_free0 (ctype);
	_g_free0 (symbol_type);
}

static void
vala_gir_parser_parse_method (ValaGirParser* self,
                              const gchar* element_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_parse_function (self, element_name);
}

static void
vala_gir_parser_parse_signal (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "glib:signal");
}

static void
vala_gir_parser_parse_boxed (ValaGirParser* self,
                             const gchar* element_name)
{
	gchar* name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaClass* cl = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaClass* _tmp21_;
	ValaClass* _tmp22_;
	ValaClass* _tmp23_;
	ValaGirParserMetadata* _tmp24_;
	ValaClass* _tmp34_;
	ValaGirComment* _tmp35_;
	ValaGirComment* _tmp36_;
	ValaGirParserNode* ref_method = NULL;
	ValaGirParserNode* unref_method = NULL;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaClass* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:name");
		_g_free0 (name);
		name = _tmp4_;
	}
	_tmp5_ = name;
	_tmp6_ = vala_gir_parser_element_get_name (self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_gir_parser_push_node (self, _tmp7_, TRUE);
	_g_free0 (_tmp7_);
	require_copy_free = FALSE;
	_tmp8_ = self->priv->current;
	if (_tmp8_->new_symbol) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaClass* _tmp13_;
		ValaClass* _tmp14_;
		ValaGirParserNode* _tmp15_;
		ValaClass* _tmp16_;
		ValaSymbol* _tmp17_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->source_reference;
		_tmp13_ = vala_class_new (_tmp10_, _tmp12_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp13_;
		_tmp14_ = cl;
		vala_class_set_is_compact (_tmp14_, TRUE);
		_tmp15_ = self->priv->current;
		_tmp16_ = cl;
		_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
		_vala_code_node_unref0 (_tmp15_->symbol);
		_tmp15_->symbol = _tmp17_;
	} else {
		ValaGirParserNode* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaClass* _tmp20_;
		_tmp18_ = self->priv->current;
		_tmp19_ = _tmp18_->symbol;
		_tmp20_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp20_;
	}
	_tmp21_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp21_);
	_tmp22_ = cl;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp22_, "CCode", "type_id");
	_tmp23_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp23_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp24_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp24_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaClass* _tmp25_;
		ValaGirParserMetadata* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		ValaGirParserMetadata* _tmp29_;
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		_tmp25_ = cl;
		_tmp26_ = self->priv->metadata;
		_tmp27_ = vala_gir_parser_metadata_get_string (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->metadata;
		_tmp30_ = vala_gir_parser_metadata_get_source_reference (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_gir_parser_parse_type_from_string (self, _tmp28_, TRUE, _tmp31_);
		_tmp33_ = _tmp32_;
		vala_class_add_base_type (_tmp25_, _tmp33_);
		_vala_code_node_unref0 (_tmp33_);
		_vala_source_reference_unref0 (_tmp31_);
		_g_free0 (_tmp28_);
	}
	vala_gir_parser_next (self);
	_tmp34_ = cl;
	_tmp35_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp36_ = _tmp35_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp34_, (ValaComment*) _tmp36_);
	_vala_comment_unref0 (_tmp36_);
	ref_method = NULL;
	unref_method = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp37_;
		ValaMarkupReader* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp37_ = self->priv->current_token;
		if (!(_tmp37_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp38_ = self->priv->reader;
		_tmp39_ = vala_markup_reader_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		if (g_strcmp0 (_tmp40_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			_tmp41_ = self->priv->reader;
			_tmp42_ = vala_markup_reader_get_name (_tmp41_);
			_tmp43_ = _tmp42_;
			if (g_strcmp0 (_tmp43_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				_tmp44_ = self->priv->reader;
				_tmp45_ = vala_markup_reader_get_name (_tmp44_);
				_tmp46_ = _tmp45_;
				if (g_strcmp0 (_tmp46_, "method") == 0) {
					gchar* cname = NULL;
					ValaGirParserNode* _tmp47_;
					gchar* _tmp48_;
					gboolean _tmp49_ = FALSE;
					const gchar* _tmp50_;
					vala_gir_parser_parse_method (self, "method");
					_tmp47_ = self->priv->old_current;
					_tmp48_ = vala_gir_parser_node_get_cname (_tmp47_);
					cname = _tmp48_;
					_tmp50_ = cname;
					if (g_str_has_suffix (_tmp50_, "_ref")) {
						gboolean _tmp51_ = FALSE;
						ValaGirParserNode* _tmp52_;
						_tmp52_ = ref_method;
						if (_tmp52_ == NULL) {
							_tmp51_ = TRUE;
						} else {
							ValaGirParserNode* _tmp53_;
							const gchar* _tmp54_;
							_tmp53_ = self->priv->old_current;
							_tmp54_ = _tmp53_->name;
							_tmp51_ = g_strcmp0 (_tmp54_, "ref") == 0;
						}
						_tmp49_ = _tmp51_;
					} else {
						_tmp49_ = FALSE;
					}
					if (_tmp49_) {
						ValaGirParserNode* _tmp55_;
						ValaGirParserNode* _tmp56_;
						_tmp55_ = self->priv->old_current;
						_tmp56_ = _vala_gir_parser_node_ref0 (_tmp55_);
						_vala_gir_parser_node_unref0 (ref_method);
						ref_method = _tmp56_;
					} else {
						gboolean _tmp57_ = FALSE;
						const gchar* _tmp58_;
						_tmp58_ = cname;
						if (g_str_has_suffix (_tmp58_, "_unref")) {
							gboolean _tmp59_ = FALSE;
							ValaGirParserNode* _tmp60_;
							_tmp60_ = unref_method;
							if (_tmp60_ == NULL) {
								_tmp59_ = TRUE;
							} else {
								ValaGirParserNode* _tmp61_;
								const gchar* _tmp62_;
								_tmp61_ = self->priv->old_current;
								_tmp62_ = _tmp61_->name;
								_tmp59_ = g_strcmp0 (_tmp62_, "unref") == 0;
							}
							_tmp57_ = _tmp59_;
						} else {
							_tmp57_ = FALSE;
						}
						if (_tmp57_) {
							ValaGirParserNode* _tmp63_;
							ValaGirParserNode* _tmp64_;
							_tmp63_ = self->priv->old_current;
							_tmp64_ = _vala_gir_parser_node_ref0 (_tmp63_);
							_vala_gir_parser_node_unref0 (unref_method);
							unref_method = _tmp64_;
						}
					}
					_g_free0 (cname);
				} else {
					ValaMarkupReader* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					_tmp65_ = self->priv->reader;
					_tmp66_ = vala_markup_reader_get_name (_tmp65_);
					_tmp67_ = _tmp66_;
					if (g_strcmp0 (_tmp67_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp68_;
						const gchar* _tmp69_;
						const gchar* _tmp70_;
						_tmp68_ = self->priv->reader;
						_tmp69_ = vala_markup_reader_get_name (_tmp68_);
						_tmp70_ = _tmp69_;
						if (g_strcmp0 (_tmp70_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp71_;
							const gchar* _tmp72_;
							const gchar* _tmp73_;
							_tmp71_ = self->priv->reader;
							_tmp72_ = vala_markup_reader_get_name (_tmp71_);
							_tmp73_ = _tmp72_;
							if (g_strcmp0 (_tmp73_, "union") == 0) {
								vala_gir_parser_parse_union (self);
							} else {
								ValaSourceReference* _tmp74_;
								ValaSourceReference* _tmp75_;
								ValaMarkupReader* _tmp76_;
								const gchar* _tmp77_;
								const gchar* _tmp78_;
								gchar* _tmp79_;
								gchar* _tmp80_;
								_tmp74_ = vala_gir_parser_get_current_src (self);
								_tmp75_ = _tmp74_;
								_tmp76_ = self->priv->reader;
								_tmp77_ = vala_markup_reader_get_name (_tmp76_);
								_tmp78_ = _tmp77_;
								_tmp79_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp78_);
								_tmp80_ = _tmp79_;
								vala_report_error (_tmp75_, _tmp80_);
								_g_free0 (_tmp80_);
								_vala_source_reference_unref0 (_tmp75_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp84_ = cl;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp84_, "CCode", "ref_function")) {
		_tmp83_ = TRUE;
	} else {
		ValaClass* _tmp85_;
		_tmp85_ = cl;
		_tmp83_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp85_, "CCode", "unref_function");
	}
	if (_tmp83_) {
		_tmp82_ = TRUE;
	} else {
		ValaClass* _tmp86_;
		_tmp86_ = cl;
		_tmp82_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp86_, "CCode", "copy_function");
	}
	if (_tmp82_) {
		_tmp81_ = TRUE;
	} else {
		ValaClass* _tmp87_;
		_tmp87_ = cl;
		_tmp81_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp87_, "CCode", "free_function");
	}
	if (_tmp81_) {
	} else {
		gboolean _tmp88_ = FALSE;
		ValaGirParserNode* _tmp89_;
		_tmp89_ = ref_method;
		if (_tmp89_ != NULL) {
			ValaGirParserNode* _tmp90_;
			_tmp90_ = unref_method;
			_tmp88_ = _tmp90_ != NULL;
		} else {
			_tmp88_ = FALSE;
		}
		if (_tmp88_) {
			ValaClass* _tmp91_;
			ValaGirParserNode* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			ValaClass* _tmp95_;
			ValaGirParserNode* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			_tmp91_ = cl;
			_tmp92_ = ref_method;
			_tmp93_ = vala_gir_parser_node_get_cname (_tmp92_);
			_tmp94_ = _tmp93_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp91_, "CCode", "ref_function", _tmp94_, NULL);
			_g_free0 (_tmp94_);
			_tmp95_ = cl;
			_tmp96_ = unref_method;
			_tmp97_ = vala_gir_parser_node_get_cname (_tmp96_);
			_tmp98_ = _tmp97_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "CCode", "unref_function", _tmp98_, NULL);
			_g_free0 (_tmp98_);
		} else {
			if (require_copy_free) {
				ValaClass* _tmp99_;
				ValaClass* _tmp100_;
				_tmp99_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp99_, "CCode", "copy_function", "g_boxed_copy", NULL);
				_tmp100_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp100_, "CCode", "free_function", "g_boxed_free", NULL);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_gir_parser_node_unref0 (unref_method);
	_vala_gir_parser_node_unref0 (ref_method);
	_vala_code_node_unref0 (cl);
	_g_free0 (name);
}

static void
vala_gir_parser_parse_union (ValaGirParser* self)
{
	gchar* element_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp15_;
	ValaStruct* st = NULL;
	ValaGirParserNode* _tmp16_;
	ValaStruct* _tmp29_;
	ValaStruct* _tmp30_;
	ValaGirComment* _tmp31_;
	ValaGirComment* _tmp32_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "union");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	element_name = _tmp0_;
	_tmp1_ = element_name;
	if (_tmp1_ == NULL) {
		ValaGirComment* _tmp2_;
		ValaGirComment* _tmp3_;
		vala_gir_parser_next (self);
		_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp3_ = _tmp2_;
		_vala_comment_unref0 (_tmp3_);
		while (TRUE) {
			ValaMarkupTokenType _tmp4_;
			ValaMarkupReader* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = self->priv->current_token;
			if (!(_tmp4_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			_tmp5_ = self->priv->reader;
			_tmp6_ = vala_markup_reader_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			if (g_strcmp0 (_tmp7_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaMarkupReader* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp8_ = vala_gir_parser_get_current_src (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->priv->reader;
				_tmp11_ = vala_markup_reader_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("unknown child element `%s' in `transparent union'", _tmp12_);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp9_, _tmp14_);
				_g_free0 (_tmp14_);
				_vala_source_reference_unref0 (_tmp9_);
				vala_gir_parser_skip_element (self);
			}
			vala_gir_parser_pop_metadata (self);
		}
		vala_gir_parser_end_element (self, "union");
		_g_free0 (element_name);
		return;
	}
	_tmp15_ = element_name;
	vala_gir_parser_push_node (self, _tmp15_, TRUE);
	_tmp16_ = self->priv->current;
	if (_tmp16_->new_symbol) {
		ValaMarkupReader* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		ValaGirParserNode* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaStruct* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaStruct* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = self->priv->reader;
		_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "name");
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->source_reference;
		_tmp22_ = vala_struct_new (_tmp19_, _tmp21_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp22_;
		_g_free0 (_tmp19_);
		_tmp23_ = self->priv->current;
		_tmp24_ = st;
		_tmp25_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp24_);
		_vala_code_node_unref0 (_tmp23_->symbol);
		_tmp23_->symbol = _tmp25_;
	} else {
		ValaGirParserNode* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaStruct* _tmp28_;
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_->symbol;
		_tmp28_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp28_;
	}
	_tmp29_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp29_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	_tmp30_ = st;
	_tmp31_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp32_ = _tmp31_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp30_, (ValaComment*) _tmp32_);
	_vala_comment_unref0 (_tmp32_);
	while (TRUE) {
		ValaMarkupTokenType _tmp33_;
		ValaMarkupReader* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp33_ = self->priv->current_token;
		if (!(_tmp33_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp34_ = self->priv->reader;
		_tmp35_ = vala_markup_reader_get_name (_tmp34_);
		_tmp36_ = _tmp35_;
		if (g_strcmp0 (_tmp36_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp37_ = self->priv->reader;
			_tmp38_ = vala_markup_reader_get_name (_tmp37_);
			_tmp39_ = _tmp38_;
			if (g_strcmp0 (_tmp39_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				_tmp40_ = self->priv->reader;
				_tmp41_ = vala_markup_reader_get_name (_tmp40_);
				_tmp42_ = _tmp41_;
				if (g_strcmp0 (_tmp42_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					_tmp43_ = self->priv->reader;
					_tmp44_ = vala_markup_reader_get_name (_tmp43_);
					_tmp45_ = _tmp44_;
					if (g_strcmp0 (_tmp45_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp46_;
						const gchar* _tmp47_;
						const gchar* _tmp48_;
						_tmp46_ = self->priv->reader;
						_tmp47_ = vala_markup_reader_get_name (_tmp46_);
						_tmp48_ = _tmp47_;
						if (g_strcmp0 (_tmp48_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp49_;
							const gchar* _tmp50_;
							const gchar* _tmp51_;
							_tmp49_ = self->priv->reader;
							_tmp50_ = vala_markup_reader_get_name (_tmp49_);
							_tmp51_ = _tmp50_;
							if (g_strcmp0 (_tmp51_, "record") == 0) {
								vala_gir_parser_parse_record (self);
							} else {
								ValaSourceReference* _tmp52_;
								ValaSourceReference* _tmp53_;
								ValaMarkupReader* _tmp54_;
								const gchar* _tmp55_;
								const gchar* _tmp56_;
								gchar* _tmp57_;
								gchar* _tmp58_;
								_tmp52_ = vala_gir_parser_get_current_src (self);
								_tmp53_ = _tmp52_;
								_tmp54_ = self->priv->reader;
								_tmp55_ = vala_markup_reader_get_name (_tmp54_);
								_tmp56_ = _tmp55_;
								_tmp57_ = g_strdup_printf ("unknown child element `%s' in `union'", _tmp56_);
								_tmp58_ = _tmp57_;
								vala_report_error (_tmp53_, _tmp58_);
								_g_free0 (_tmp58_);
								_vala_source_reference_unref0 (_tmp53_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "union");
	_vala_code_node_unref0 (st);
	_g_free0 (element_name);
}

static void
vala_gir_parser_parse_constant (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp2_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaConstant* c = NULL;
	ValaGirParserNode* _tmp9_;
	const gchar* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserNode* _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaConstant* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaConstant* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaConstant* _tmp18_;
	ValaConstant* _tmp19_;
	ValaGirComment* _tmp20_;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "constant");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp6_ = vala_gir_parser_parse_type (self, NULL, &_tmp3_, TRUE, &_tmp4_, &_tmp5_);
	array_length_idx = _tmp3_;
	no_array_length = _tmp4_;
	array_null_terminated = _tmp5_;
	type = _tmp6_;
	_tmp7_ = type;
	_tmp8_ = vala_gir_parser_element_get_type (self, _tmp7_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp8_;
	_tmp9_ = self->priv->current;
	_tmp10_ = _tmp9_->name;
	_tmp11_ = type;
	_tmp12_ = self->priv->current;
	_tmp13_ = _tmp12_->source_reference;
	_tmp14_ = vala_constant_new (_tmp10_, _tmp11_, NULL, _tmp13_, NULL);
	c = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = c;
	_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp17_;
	_tmp18_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp19_ = c;
	_tmp20_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp19_, (ValaComment*) _tmp20_);
	if (no_array_length) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = array_null_terminated;
	}
	if (_tmp21_) {
		ValaConstant* _tmp22_;
		_tmp22_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp22_, "CCode", "array_length", !no_array_length, NULL);
	}
	if (array_null_terminated) {
		ValaConstant* _tmp23_;
		_tmp23_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp23_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "constant");
	_vala_code_node_unref0 (c);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
}

static void
vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                        ValaGirParserMetadata* metadata)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	if (metadata == _tmp1_) {
		return;
	}
	_tmp3_ = metadata->args;
	_tmp4_ = vala_map_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = metadata->children;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp9_;
		_tmp9_ = metadata->source_reference;
		vala_report_warning (_tmp9_, "empty metadata");
		return;
	}
	{
		ValaIterator* _arg_type_it = NULL;
		ValaMap* _tmp10_;
		ValaSet* _tmp11_;
		ValaSet* _tmp12_;
		ValaIterator* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp10_ = metadata->args;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_arg_type_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaGirParserArgumentType arg_type = 0;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaGirParserArgument* arg = NULL;
			ValaMap* _tmp18_;
			ValaGirParserArgumentType _tmp19_;
			gpointer _tmp20_;
			ValaGirParserArgument* _tmp21_;
			_tmp15_ = _arg_type_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _arg_type_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			arg_type = (ValaGirParserArgumentType) ((gintptr) _tmp17_);
			_tmp18_ = metadata->args;
			_tmp19_ = arg_type;
			_tmp20_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) _tmp19_));
			arg = (ValaGirParserArgument*) _tmp20_;
			_tmp21_ = arg;
			if (!_tmp21_->used) {
				ValaGirParserArgument* _tmp22_;
				ValaSourceReference* _tmp23_;
				_tmp22_ = arg;
				_tmp23_ = _tmp22_->source_reference;
				vala_report_warning (_tmp23_, "argument never used");
			}
			_vala_gir_parser_argument_unref0 (arg);
		}
		_vala_iterator_unref0 (_arg_type_it);
	}
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp24_;
		ValaArrayList* _tmp25_;
		gint _child_size = 0;
		ValaArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _child_index = 0;
		_tmp24_ = metadata->children;
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_child_list = _tmp25_;
		_tmp26_ = _child_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_child_size = _tmp28_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp31_;
			gpointer _tmp32_;
			ValaGirParserMetadata* _tmp33_;
			_child_index = _child_index + 1;
			_tmp29_ = _child_index;
			_tmp30_ = _child_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _child_list;
			_tmp32_ = vala_list_get ((ValaList*) _tmp31_, _child_index);
			child = (ValaGirParserMetadata*) _tmp32_;
			_tmp33_ = child;
			if (!_tmp33_->used) {
				ValaGirParserMetadata* _tmp34_;
				ValaSourceReference* _tmp35_;
				_tmp34_ = child;
				_tmp35_ = _tmp34_->source_reference;
				vala_report_warning (_tmp35_, "metadata never used");
			} else {
				ValaGirParserMetadata* _tmp36_;
				_tmp36_ = child;
				vala_gir_parser_report_unused_metadata (self, _tmp36_);
			}
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
}

static void
vala_gir_parser_resolve_gir_symbols (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _map_from_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _map_from_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _map_from_index = 0;
		_tmp0_ = self->priv->unresolved_gir_symbols;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_map_from_list = _tmp1_;
		_tmp2_ = _map_from_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_map_from_size = _tmp4_;
		_map_from_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaUnresolvedSymbol* map_from = NULL;
			ValaArrayList* _tmp7_;
			gpointer _tmp8_;
			_map_from_index = _map_from_index + 1;
			_tmp5_ = _map_from_index;
			_tmp6_ = _map_from_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _map_from_list;
			_tmp8_ = vala_list_get ((ValaList*) _tmp7_, _map_from_index);
			map_from = (ValaUnresolvedSymbol*) _tmp8_;
			while (TRUE) {
				ValaUnresolvedSymbol* _tmp9_;
				ValaSymbol* map_to = NULL;
				ValaHashMap* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				gpointer _tmp12_;
				ValaSymbol* _tmp13_;
				ValaUnresolvedSymbol* _tmp63_;
				ValaUnresolvedSymbol* _tmp64_;
				ValaUnresolvedSymbol* _tmp65_;
				ValaUnresolvedSymbol* _tmp66_;
				_tmp9_ = map_from;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = self->priv->unresolved_symbols_map;
				_tmp11_ = map_from;
				_tmp12_ = vala_map_get ((ValaMap*) _tmp10_, _tmp11_);
				map_to = (ValaSymbol*) _tmp12_;
				_tmp13_ = map_to;
				if (_tmp13_ != NULL) {
					ValaUnresolvedSymbol* _tmp14_;
					ValaUnresolvedSymbol* _tmp15_;
					ValaSymbol* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					ValaSymbol* _tmp19_;
					_tmp14_ = map_from;
					vala_unresolved_symbol_set_inner (_tmp14_, NULL);
					_tmp15_ = map_from;
					_tmp16_ = map_to;
					_tmp17_ = vala_symbol_get_name (_tmp16_);
					_tmp18_ = _tmp17_;
					vala_symbol_set_name ((ValaSymbol*) _tmp15_, _tmp18_);
					_tmp19_ = map_to;
					if (VALA_IS_UNRESOLVED_SYMBOL (_tmp19_)) {
						ValaUnresolvedSymbol* umap_to = NULL;
						ValaSymbol* _tmp20_;
						ValaUnresolvedSymbol* _tmp21_;
						_tmp20_ = map_to;
						_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol));
						umap_to = _tmp21_;
						while (TRUE) {
							ValaUnresolvedSymbol* _tmp22_;
							ValaUnresolvedSymbol* _tmp23_;
							ValaUnresolvedSymbol* _tmp24_;
							ValaUnresolvedSymbol* _tmp25_;
							ValaUnresolvedSymbol* _tmp26_;
							ValaUnresolvedSymbol* _tmp27_;
							ValaUnresolvedSymbol* _tmp28_;
							ValaUnresolvedSymbol* _tmp29_;
							ValaUnresolvedSymbol* _tmp30_;
							const gchar* _tmp31_;
							const gchar* _tmp32_;
							ValaUnresolvedSymbol* _tmp33_;
							ValaUnresolvedSymbol* _tmp34_;
							ValaUnresolvedSymbol* _tmp35_;
							ValaUnresolvedSymbol* _tmp36_;
							ValaUnresolvedSymbol* _tmp37_;
							ValaUnresolvedSymbol* _tmp38_;
							_tmp22_ = umap_to;
							_tmp23_ = vala_unresolved_symbol_get_inner (_tmp22_);
							_tmp24_ = _tmp23_;
							if (!(_tmp24_ != NULL)) {
								break;
							}
							_tmp25_ = umap_to;
							_tmp26_ = vala_unresolved_symbol_get_inner (_tmp25_);
							_tmp27_ = _tmp26_;
							_tmp28_ = _vala_code_node_ref0 (_tmp27_);
							_vala_code_node_unref0 (umap_to);
							umap_to = _tmp28_;
							_tmp29_ = map_from;
							_tmp30_ = umap_to;
							_tmp31_ = vala_symbol_get_name ((ValaSymbol*) _tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = vala_unresolved_symbol_new (NULL, _tmp32_, NULL);
							_tmp34_ = _tmp33_;
							vala_unresolved_symbol_set_inner (_tmp29_, _tmp34_);
							_vala_code_node_unref0 (_tmp34_);
							_tmp35_ = map_from;
							_tmp36_ = vala_unresolved_symbol_get_inner (_tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = _vala_code_node_ref0 (_tmp37_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp38_;
						}
						_vala_code_node_unref0 (umap_to);
					} else {
						while (TRUE) {
							gboolean _tmp39_ = FALSE;
							ValaSymbol* _tmp40_;
							ValaSymbol* _tmp41_;
							ValaSymbol* _tmp42_;
							ValaSymbol* _tmp49_;
							ValaSymbol* _tmp50_;
							ValaSymbol* _tmp51_;
							ValaSymbol* _tmp52_;
							ValaUnresolvedSymbol* _tmp53_;
							ValaSymbol* _tmp54_;
							const gchar* _tmp55_;
							const gchar* _tmp56_;
							ValaUnresolvedSymbol* _tmp57_;
							ValaUnresolvedSymbol* _tmp58_;
							ValaUnresolvedSymbol* _tmp59_;
							ValaUnresolvedSymbol* _tmp60_;
							ValaUnresolvedSymbol* _tmp61_;
							ValaUnresolvedSymbol* _tmp62_;
							_tmp40_ = map_to;
							_tmp41_ = vala_symbol_get_parent_symbol (_tmp40_);
							_tmp42_ = _tmp41_;
							if (_tmp42_ != NULL) {
								ValaSymbol* _tmp43_;
								ValaSymbol* _tmp44_;
								ValaSymbol* _tmp45_;
								ValaCodeContext* _tmp46_;
								ValaNamespace* _tmp47_;
								ValaNamespace* _tmp48_;
								_tmp43_ = map_to;
								_tmp44_ = vala_symbol_get_parent_symbol (_tmp43_);
								_tmp45_ = _tmp44_;
								_tmp46_ = self->priv->context;
								_tmp47_ = vala_code_context_get_root (_tmp46_);
								_tmp48_ = _tmp47_;
								_tmp39_ = _tmp45_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp39_ = FALSE;
							}
							if (!_tmp39_) {
								break;
							}
							_tmp49_ = map_to;
							_tmp50_ = vala_symbol_get_parent_symbol (_tmp49_);
							_tmp51_ = _tmp50_;
							_tmp52_ = _vala_code_node_ref0 (_tmp51_);
							_vala_code_node_unref0 (map_to);
							map_to = _tmp52_;
							_tmp53_ = map_from;
							_tmp54_ = map_to;
							_tmp55_ = vala_symbol_get_name (_tmp54_);
							_tmp56_ = _tmp55_;
							_tmp57_ = vala_unresolved_symbol_new (NULL, _tmp56_, NULL);
							_tmp58_ = _tmp57_;
							vala_unresolved_symbol_set_inner (_tmp53_, _tmp58_);
							_vala_code_node_unref0 (_tmp58_);
							_tmp59_ = map_from;
							_tmp60_ = vala_unresolved_symbol_get_inner (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = _vala_code_node_ref0 (_tmp61_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp62_;
						}
					}
					_vala_code_node_unref0 (map_to);
					break;
				}
				_tmp63_ = map_from;
				_tmp64_ = vala_unresolved_symbol_get_inner (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = _vala_code_node_ref0 (_tmp65_);
				_vala_code_node_unref0 (map_from);
				map_from = _tmp66_;
				_vala_code_node_unref0 (map_to);
			}
			_vala_code_node_unref0 (map_from);
		}
		_vala_iterable_unref0 (_map_from_list);
	}
}

static void
vala_gir_parser_create_new_namespaces (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _node_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _node_index = 0;
		_tmp0_ = vala_gir_parser_node_new_namespaces;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_node_list = _tmp1_;
		_tmp2_ = _node_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_node_size = _tmp4_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp7_;
			gpointer _tmp8_;
			ValaGirParserNode* _tmp9_;
			ValaSymbol* _tmp10_;
			_node_index = _node_index + 1;
			_tmp5_ = _node_index;
			_tmp6_ = _node_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _node_list;
			_tmp8_ = vala_list_get ((ValaList*) _tmp7_, _node_index);
			node = (ValaGirParserNode*) _tmp8_;
			_tmp9_ = node;
			_tmp10_ = _tmp9_->symbol;
			if (_tmp10_ == NULL) {
				ValaGirParserNode* _tmp11_;
				ValaGirParserNode* _tmp12_;
				const gchar* _tmp13_;
				ValaGirParserNode* _tmp14_;
				ValaSourceReference* _tmp15_;
				ValaNamespace* _tmp16_;
				_tmp11_ = node;
				_tmp12_ = node;
				_tmp13_ = _tmp12_->name;
				_tmp14_ = node;
				_tmp15_ = _tmp14_->source_reference;
				_tmp16_ = vala_namespace_new (_tmp13_, _tmp15_);
				_vala_code_node_unref0 (_tmp11_->symbol);
				_tmp11_->symbol = (ValaSymbol*) _tmp16_;
			}
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}

static void
vala_gir_parser_resolve_type_arguments (ValaGirParser* self)
{
	ValaMapIterator* it = NULL;
	ValaHashMap* _tmp0_;
	ValaMapIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unresolved_type_arguments;
	_tmp1_ = vala_map_map_iterator ((ValaMap*) _tmp0_);
	it = _tmp1_;
	while (TRUE) {
		ValaMapIterator* _tmp2_;
		ValaUnresolvedType* element_type = NULL;
		ValaMapIterator* _tmp3_;
		gpointer _tmp4_;
		ValaGirParserNode* parent = NULL;
		ValaMapIterator* _tmp5_;
		gpointer _tmp6_;
		ValaTypeSymbol* sym = NULL;
		ValaGirParserNode* _tmp7_;
		ValaUnresolvedType* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaStruct* st = NULL;
		ValaTypeSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		ValaStruct* _tmp16_;
		_tmp2_ = it;
		if (!vala_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		_tmp4_ = vala_map_iterator_get_key (_tmp3_);
		element_type = (ValaUnresolvedType*) _tmp4_;
		_tmp5_ = it;
		_tmp6_ = vala_map_iterator_get_value (_tmp5_);
		parent = (ValaGirParserNode*) _tmp6_;
		_tmp7_ = parent;
		_tmp8_ = element_type;
		_tmp9_ = vala_unresolved_type_get_unresolved_symbol (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_gir_parser_resolve_symbol (self, _tmp7_, _tmp10_);
		sym = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		_tmp12_ = sym;
		_tmp13_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp12_) ? ((ValaStruct*) _tmp12_) : NULL);
		st = _tmp13_;
		_tmp16_ = st;
		if (_tmp16_ != NULL) {
			ValaStruct* _tmp17_;
			_tmp17_ = st;
			_tmp15_ = !vala_struct_is_integer_type (_tmp17_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaStruct* _tmp18_;
			_tmp18_ = st;
			_tmp14_ = !vala_struct_is_floating_type (_tmp18_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaUnresolvedType* _tmp19_;
			_tmp19_ = element_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp19_, TRUE);
		}
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (sym);
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (element_type);
	}
	_vala_map_iterator_unref0 (it);
}

static void
vala_gir_parser_process_interface (ValaGirParser* self,
                                   ValaGirParserNode* iface_node)
{
	ValaInterface* iface = NULL;
	ValaSymbol* _tmp0_;
	ValaInterface* _tmp1_;
	gboolean has_instantiable_prereq = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface_node != NULL);
	_tmp0_ = iface_node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_INTERFACE, ValaInterface));
	iface = _tmp1_;
	has_instantiable_prereq = FALSE;
	{
		ValaList* _prereq_list = NULL;
		ValaInterface* _tmp2_;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _prereq_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _prereq_index = 0;
		_tmp2_ = iface;
		_tmp3_ = vala_interface_get_prerequisites (_tmp2_);
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_prereq_list = _tmp4_;
		_tmp5_ = _prereq_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_prereq_size = _tmp7_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaSymbol* sym = NULL;
			ValaDataType* _tmp12_;
			ValaSymbol* _tmp24_;
			_prereq_index = _prereq_index + 1;
			_tmp8_ = _prereq_index;
			_tmp9_ = _prereq_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _prereq_list;
			_tmp11_ = vala_list_get (_tmp10_, _prereq_index);
			prereq = (ValaDataType*) _tmp11_;
			sym = NULL;
			_tmp12_ = prereq;
			if (VALA_IS_UNRESOLVED_TYPE (_tmp12_)) {
				ValaUnresolvedSymbol* unresolved_symbol = NULL;
				ValaDataType* _tmp13_;
				ValaUnresolvedSymbol* _tmp14_;
				ValaUnresolvedSymbol* _tmp15_;
				ValaUnresolvedSymbol* _tmp16_;
				ValaGirParserNode* _tmp17_;
				ValaUnresolvedSymbol* _tmp18_;
				ValaSymbol* _tmp19_;
				_tmp13_ = prereq;
				_tmp14_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp15_ = _tmp14_;
				_tmp16_ = _vala_code_node_ref0 (_tmp15_);
				unresolved_symbol = _tmp16_;
				_tmp17_ = iface_node->parent;
				_tmp18_ = unresolved_symbol;
				_tmp19_ = vala_gir_parser_resolve_symbol (self, _tmp17_, _tmp18_);
				_vala_code_node_unref0 (sym);
				sym = _tmp19_;
				_vala_code_node_unref0 (unresolved_symbol);
			} else {
				ValaDataType* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaSymbol* _tmp23_;
				_tmp20_ = prereq;
				_tmp21_ = vala_data_type_get_type_symbol (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp22_);
				_vala_code_node_unref0 (sym);
				sym = _tmp23_;
			}
			_tmp24_ = sym;
			if (VALA_IS_CLASS (_tmp24_)) {
				has_instantiable_prereq = TRUE;
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (prereq);
				break;
			}
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	if (!has_instantiable_prereq) {
		ValaArrayList* _tmp25_;
		ValaInterface* _tmp26_;
		_tmp25_ = self->priv->ifaces_needing_object_prereq;
		_tmp26_ = iface;
		vala_collection_add ((ValaCollection*) _tmp25_, _tmp26_);
	}
	_vala_code_node_unref0 (iface);
}

static void
vala_gir_parser_process_alias (ValaGirParser* self,
                               ValaGirParserNode* alias)
{
	ValaDataType* base_type = NULL;
	ValaSymbol* type_sym = NULL;
	ValaGirParserNode* base_node = NULL;
	gboolean simple_type = FALSE;
	ValaDataType* _tmp0_;
	gboolean _tmp32_ = FALSE;
	ValaSymbol* _tmp33_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	ValaDataType* _tmp37_;
	gboolean _tmp152_ = FALSE;
	ValaSymbol* _tmp153_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alias != NULL);
	base_type = NULL;
	type_sym = NULL;
	base_node = NULL;
	simple_type = FALSE;
	_tmp0_ = alias->base_type;
	if (VALA_IS_UNRESOLVED_TYPE (_tmp0_)) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaGirParserNode* _tmp3_;
		ValaDataType* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaGirParserNode* _tmp8_;
		_tmp1_ = alias->base_type;
		_tmp2_ = _vala_code_node_ref0 (_tmp1_);
		_vala_code_node_unref0 (base_type);
		base_type = _tmp2_;
		_tmp3_ = alias->parent;
		_tmp4_ = base_type;
		_tmp5_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_gir_parser_resolve_node (self, _tmp3_, _tmp6_, FALSE);
		_vala_gir_parser_node_unref0 (base_node);
		base_node = _tmp7_;
		_tmp8_ = base_node;
		if (_tmp8_ != NULL) {
			ValaGirParserNode* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp9_ = base_node;
			_tmp10_ = _tmp9_->symbol;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp11_;
		}
	} else {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		_tmp13_ = alias->base_type;
		if (VALA_IS_POINTER_TYPE (_tmp13_)) {
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			_tmp14_ = alias->base_type;
			_tmp15_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
			_tmp16_ = _tmp15_;
			_tmp12_ = VALA_IS_VOID_TYPE (_tmp16_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			simple_type = TRUE;
		} else {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaTypeSymbol* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp17_ = alias->base_type;
			_tmp18_ = _vala_code_node_ref0 (_tmp17_);
			_vala_code_node_unref0 (base_type);
			base_type = _tmp18_;
			_tmp19_ = base_type;
			_tmp20_ = vala_data_type_get_type_symbol (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp22_;
			_tmp23_ = type_sym;
			if (_tmp23_ != NULL) {
				ValaGirParserNode* _tmp24_;
				ValaSymbol* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaUnresolvedSymbol* _tmp29_;
				ValaUnresolvedSymbol* _tmp30_;
				ValaGirParserNode* _tmp31_;
				_tmp24_ = alias->parent;
				_tmp25_ = type_sym;
				_tmp26_ = vala_symbol_get_full_name (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = alias->source_reference;
				_tmp29_ = vala_gir_parser_parse_symbol_from_string (self, _tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_gir_parser_resolve_node (self, _tmp24_, _tmp30_, FALSE);
				_vala_gir_parser_node_unref0 (base_node);
				base_node = _tmp31_;
				_vala_code_node_unref0 (_tmp30_);
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp33_ = type_sym;
	if (VALA_IS_STRUCT (_tmp33_)) {
		ValaSymbol* _tmp34_;
		_tmp34_ = type_sym;
		_tmp32_ = vala_struct_is_simple_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		simple_type = TRUE;
	}
	_tmp37_ = base_type;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		ValaSymbol* _tmp38_;
		_tmp38_ = type_sym;
		_tmp36_ = _tmp38_ == NULL;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		ValaSymbol* _tmp39_;
		_tmp39_ = type_sym;
		_tmp35_ = VALA_IS_STRUCT (_tmp39_);
	}
	if (_tmp35_) {
		ValaStruct* st = NULL;
		const gchar* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaStruct* _tmp42_;
		ValaStruct* _tmp43_;
		ValaDataType* _tmp44_;
		ValaStruct* _tmp47_;
		ValaGirComment* _tmp48_;
		ValaStruct* _tmp49_;
		ValaStruct* _tmp50_;
		ValaSymbol* _tmp51_;
		_tmp40_ = alias->name;
		_tmp41_ = alias->source_reference;
		_tmp42_ = vala_struct_new (_tmp40_, _tmp41_, NULL);
		st = _tmp42_;
		_tmp43_ = st;
		vala_symbol_set_access ((ValaSymbol*) _tmp43_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp44_ = base_type;
		if (_tmp44_ != NULL) {
			ValaStruct* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp45_ = st;
			_tmp46_ = base_type;
			vala_struct_set_base_type (_tmp45_, _tmp46_);
		}
		_tmp47_ = st;
		_tmp48_ = alias->comment;
		vala_symbol_set_comment ((ValaSymbol*) _tmp47_, (ValaComment*) _tmp48_);
		_tmp49_ = st;
		vala_struct_set_simple_type (_tmp49_, simple_type);
		_tmp50_ = st;
		_tmp51_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp50_);
		_vala_code_node_unref0 (alias->symbol);
		alias->symbol = _tmp51_;
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp52_;
		_tmp52_ = type_sym;
		if (VALA_IS_CLASS (_tmp52_)) {
			ValaClass* cl = NULL;
			const gchar* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaClass* _tmp55_;
			ValaClass* _tmp56_;
			ValaDataType* _tmp57_;
			ValaClass* _tmp60_;
			ValaGirComment* _tmp61_;
			ValaClass* _tmp62_;
			ValaSymbol* _tmp63_;
			gboolean _tmp64_;
			gboolean _tmp65_;
			ValaClass* _tmp66_;
			ValaSymbol* _tmp67_;
			_tmp53_ = alias->name;
			_tmp54_ = alias->source_reference;
			_tmp55_ = vala_class_new (_tmp53_, _tmp54_, NULL);
			cl = _tmp55_;
			_tmp56_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp56_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp57_ = base_type;
			if (_tmp57_ != NULL) {
				ValaClass* _tmp58_;
				ValaDataType* _tmp59_;
				_tmp58_ = cl;
				_tmp59_ = base_type;
				vala_class_add_base_type (_tmp58_, _tmp59_);
			}
			_tmp60_ = cl;
			_tmp61_ = alias->comment;
			vala_symbol_set_comment ((ValaSymbol*) _tmp60_, (ValaComment*) _tmp61_);
			_tmp62_ = cl;
			_tmp63_ = type_sym;
			_tmp64_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CLASS, ValaClass));
			_tmp65_ = _tmp64_;
			vala_class_set_is_compact (_tmp62_, _tmp65_);
			_tmp66_ = cl;
			_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
			_vala_code_node_unref0 (alias->symbol);
			alias->symbol = _tmp67_;
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp68_;
			_tmp68_ = type_sym;
			if (VALA_IS_INTERFACE (_tmp68_)) {
				ValaInterface* iface = NULL;
				const gchar* _tmp69_;
				ValaSourceReference* _tmp70_;
				ValaInterface* _tmp71_;
				ValaInterface* _tmp72_;
				ValaDataType* _tmp73_;
				ValaInterface* _tmp76_;
				ValaGirComment* _tmp77_;
				ValaInterface* _tmp78_;
				ValaSymbol* _tmp79_;
				_tmp69_ = alias->name;
				_tmp70_ = alias->source_reference;
				_tmp71_ = vala_interface_new (_tmp69_, _tmp70_, NULL);
				iface = _tmp71_;
				_tmp72_ = iface;
				vala_symbol_set_access ((ValaSymbol*) _tmp72_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_tmp73_ = base_type;
				if (_tmp73_ != NULL) {
					ValaInterface* _tmp74_;
					ValaDataType* _tmp75_;
					_tmp74_ = iface;
					_tmp75_ = base_type;
					vala_interface_add_prerequisite (_tmp74_, _tmp75_);
				}
				_tmp76_ = iface;
				_tmp77_ = alias->comment;
				vala_symbol_set_comment ((ValaSymbol*) _tmp76_, (ValaComment*) _tmp77_);
				_tmp78_ = iface;
				_tmp79_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp78_);
				_vala_code_node_unref0 (alias->symbol);
				alias->symbol = _tmp79_;
				_vala_code_node_unref0 (iface);
			} else {
				ValaSymbol* _tmp80_;
				_tmp80_ = type_sym;
				if (VALA_IS_DELEGATE (_tmp80_)) {
					ValaDelegate* orig = NULL;
					ValaSymbol* _tmp81_;
					ValaDelegate* _tmp82_;
					ValaGirParserNode* _tmp83_;
					ValaDelegate* deleg = NULL;
					const gchar* _tmp88_;
					ValaDelegate* _tmp89_;
					ValaDataType* _tmp90_;
					ValaDataType* _tmp91_;
					ValaDataType* _tmp92_;
					ValaDataType* _tmp93_;
					ValaSourceReference* _tmp94_;
					ValaDelegate* _tmp95_;
					ValaDelegate* _tmp96_;
					ValaDelegate* _tmp97_;
					ValaDelegate* _tmp98_;
					ValaSymbolAccessibility _tmp99_;
					ValaSymbolAccessibility _tmp100_;
					ValaArrayList* error_types = NULL;
					GEqualFunc _tmp115_;
					ValaArrayList* _tmp116_;
					ValaDelegate* _tmp117_;
					ValaArrayList* _tmp118_;
					ValaSourceReference* _tmp119_;
					ValaDelegate* _tmp133_;
					GList* _tmp134_;
					ValaDelegate* _tmp139_;
					ValaSymbol* _tmp140_;
					_tmp81_ = type_sym;
					_tmp82_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_DELEGATE, ValaDelegate));
					orig = _tmp82_;
					_tmp83_ = base_node;
					if (_tmp83_ != NULL) {
						ValaGirParserNode* _tmp84_;
						ValaGirParserNode* _tmp85_;
						ValaSymbol* _tmp86_;
						ValaDelegate* _tmp87_;
						_tmp84_ = base_node;
						vala_gir_parser_node_process (_tmp84_, self);
						_tmp85_ = base_node;
						_tmp86_ = _tmp85_->symbol;
						_tmp87_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (orig);
						orig = _tmp87_;
					}
					_tmp88_ = alias->name;
					_tmp89_ = orig;
					_tmp90_ = vala_callable_get_return_type ((ValaCallable*) _tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = vala_data_type_copy (_tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = alias->source_reference;
					_tmp95_ = vala_delegate_new (_tmp88_, _tmp93_, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					_vala_code_node_unref0 (_tmp93_);
					deleg = _tmp96_;
					_tmp97_ = deleg;
					_tmp98_ = orig;
					_tmp99_ = vala_symbol_get_access ((ValaSymbol*) _tmp98_);
					_tmp100_ = _tmp99_;
					vala_symbol_set_access ((ValaSymbol*) _tmp97_, _tmp100_);
					{
						ValaList* _param_list = NULL;
						ValaDelegate* _tmp101_;
						ValaList* _tmp102_;
						ValaList* _tmp103_;
						gint _param_size = 0;
						ValaList* _tmp104_;
						gint _tmp105_;
						gint _tmp106_;
						gint _param_index = 0;
						_tmp101_ = orig;
						_tmp102_ = vala_callable_get_parameters ((ValaCallable*) _tmp101_);
						_tmp103_ = _vala_iterable_ref0 (_tmp102_);
						_param_list = _tmp103_;
						_tmp104_ = _param_list;
						_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
						_tmp106_ = _tmp105_;
						_param_size = _tmp106_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp107_;
							gint _tmp108_;
							ValaParameter* param = NULL;
							ValaList* _tmp109_;
							gpointer _tmp110_;
							ValaDelegate* _tmp111_;
							ValaParameter* _tmp112_;
							ValaParameter* _tmp113_;
							ValaParameter* _tmp114_;
							_param_index = _param_index + 1;
							_tmp107_ = _param_index;
							_tmp108_ = _param_size;
							if (!(_tmp107_ < _tmp108_)) {
								break;
							}
							_tmp109_ = _param_list;
							_tmp110_ = vala_list_get (_tmp109_, _param_index);
							param = (ValaParameter*) _tmp110_;
							_tmp111_ = deleg;
							_tmp112_ = param;
							_tmp113_ = vala_parameter_copy (_tmp112_);
							_tmp114_ = _tmp113_;
							vala_callable_add_parameter ((ValaCallable*) _tmp111_, _tmp114_);
							_vala_code_node_unref0 (_tmp114_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					_tmp115_ = g_direct_equal;
					_tmp116_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp115_);
					error_types = _tmp116_;
					_tmp117_ = orig;
					_tmp118_ = error_types;
					_tmp119_ = alias->source_reference;
					vala_code_node_get_error_types ((ValaCodeNode*) _tmp117_, (ValaCollection*) _tmp118_, _tmp119_);
					{
						ValaArrayList* _error_type_list = NULL;
						ValaArrayList* _tmp120_;
						ValaArrayList* _tmp121_;
						gint _error_type_size = 0;
						ValaArrayList* _tmp122_;
						gint _tmp123_;
						gint _tmp124_;
						gint _error_type_index = 0;
						_tmp120_ = error_types;
						_tmp121_ = _vala_iterable_ref0 (_tmp120_);
						_error_type_list = _tmp121_;
						_tmp122_ = _error_type_list;
						_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
						_tmp124_ = _tmp123_;
						_error_type_size = _tmp124_;
						_error_type_index = -1;
						while (TRUE) {
							gint _tmp125_;
							gint _tmp126_;
							ValaDataType* error_type = NULL;
							ValaArrayList* _tmp127_;
							gpointer _tmp128_;
							ValaDelegate* _tmp129_;
							ValaDataType* _tmp130_;
							ValaDataType* _tmp131_;
							ValaDataType* _tmp132_;
							_error_type_index = _error_type_index + 1;
							_tmp125_ = _error_type_index;
							_tmp126_ = _error_type_size;
							if (!(_tmp125_ < _tmp126_)) {
								break;
							}
							_tmp127_ = _error_type_list;
							_tmp128_ = vala_list_get ((ValaList*) _tmp127_, _error_type_index);
							error_type = (ValaDataType*) _tmp128_;
							_tmp129_ = deleg;
							_tmp130_ = error_type;
							_tmp131_ = vala_data_type_copy (_tmp130_);
							_tmp132_ = _tmp131_;
							vala_delegate_add_error_type (_tmp129_, _tmp132_);
							_vala_code_node_unref0 (_tmp132_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					_tmp133_ = orig;
					_tmp134_ = ((ValaCodeNode*) _tmp133_)->attributes;
					{
						GList* attribute_collection = NULL;
						GList* attribute_it = NULL;
						attribute_collection = _tmp134_;
						for (attribute_it = attribute_collection; attribute_it != NULL; attribute_it = attribute_it->next) {
							ValaAttribute* _tmp135_;
							ValaAttribute* attribute = NULL;
							_tmp135_ = _vala_code_node_ref0 ((ValaAttribute*) attribute_it->data);
							attribute = _tmp135_;
							{
								ValaDelegate* _tmp136_;
								ValaAttribute* _tmp137_;
								ValaAttribute* _tmp138_;
								_tmp136_ = deleg;
								_tmp137_ = attribute;
								_tmp138_ = _vala_code_node_ref0 (_tmp137_);
								((ValaCodeNode*) _tmp136_)->attributes = g_list_append (((ValaCodeNode*) _tmp136_)->attributes, _tmp138_);
								_vala_code_node_unref0 (attribute);
							}
						}
					}
					_tmp139_ = deleg;
					_tmp140_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp139_);
					_vala_code_node_unref0 (alias->symbol);
					alias->symbol = _tmp140_;
					_vala_iterable_unref0 (error_types);
					_vala_code_node_unref0 (deleg);
					_vala_code_node_unref0 (orig);
				} else {
					ValaSymbol* _tmp141_;
					_tmp141_ = type_sym;
					if (_tmp141_ != NULL) {
						ValaSourceReference* _tmp142_;
						gchar* _tmp143_;
						gchar* _tmp144_;
						ValaSymbol* _tmp145_;
						gchar* _tmp146_;
						gchar* _tmp147_;
						gchar* _tmp148_;
						gchar* _tmp149_;
						ValaSymbol* _tmp150_;
						ValaSymbol* _tmp151_;
						_tmp142_ = alias->source_reference;
						_tmp143_ = vala_gir_parser_node_get_full_name (alias);
						_tmp144_ = _tmp143_;
						_tmp145_ = type_sym;
						_tmp146_ = vala_symbol_get_full_name (_tmp145_);
						_tmp147_ = _tmp146_;
						_tmp148_ = g_strdup_printf ("alias `%s' for `%s' is not supported", _tmp144_, _tmp147_);
						_tmp149_ = _tmp148_;
						vala_report_warning (_tmp142_, _tmp149_);
						_g_free0 (_tmp149_);
						_g_free0 (_tmp147_);
						_g_free0 (_tmp144_);
						_tmp150_ = type_sym;
						_tmp151_ = _vala_code_node_ref0 (_tmp150_);
						_vala_code_node_unref0 (alias->symbol);
						alias->symbol = _tmp151_;
						alias->merged = TRUE;
					}
				}
			}
		}
	}
	_tmp153_ = type_sym;
	if (VALA_IS_CLASS (_tmp153_)) {
		_tmp152_ = TRUE;
	} else {
		gboolean _tmp154_ = FALSE;
		ValaSymbol* _tmp155_;
		_tmp155_ = type_sym;
		if (VALA_IS_STRUCT (_tmp155_)) {
			_tmp154_ = !simple_type;
		} else {
			_tmp154_ = FALSE;
		}
		_tmp152_ = _tmp154_;
	}
	if (_tmp152_) {
		ValaSymbol* _tmp156_;
		_tmp156_ = type_sym;
		if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp156_, "CCode", "has_type_id")) {
			ValaSymbol* _tmp157_;
			ValaSymbol* _tmp158_;
			_tmp157_ = alias->symbol;
			_tmp158_ = type_sym;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp157_, "CCode", "has_type_id", vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp158_, "CCode", "has_type_id", FALSE), NULL);
		} else {
			ValaSymbol* _tmp159_;
			_tmp159_ = type_sym;
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp159_, "CCode", "type_id")) {
				ValaSymbol* _tmp160_;
				ValaSymbol* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				_tmp160_ = alias->symbol;
				_tmp161_ = type_sym;
				_tmp162_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp161_, "CCode", "type_id", NULL);
				_tmp163_ = _tmp162_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp160_, "CCode", "type_id", _tmp163_, NULL);
				_g_free0 (_tmp163_);
			}
		}
	}
	_vala_gir_parser_node_unref0 (base_node);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (base_type);
}

static void
vala_gir_parser_process_callable (ValaGirParser* self,
                                  ValaGirParserNode* node)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaSymbol* s = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* parameters = NULL;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValaDataType* return_type = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp12_ = FALSE;
	ValaDataType* _tmp13_;
	ValaList* _tmp240_;
	gint _tmp241_;
	gint _tmp242_;
	gint i = 0;
	gint j = 0;
	gint first_out = 0;
	gint last = 0;
	gboolean _tmp449_ = FALSE;
	ValaDataType* _tmp450_;
	ValaSymbol* _tmp455_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp1_ = node->element_type;
	if (g_strcmp0 (_tmp1_, "alias") == 0) {
		ValaSymbol* _tmp2_;
		_tmp2_ = node->symbol;
		_tmp0_ = VALA_IS_DELEGATE (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = node->symbol;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	s = _tmp4_;
	_tmp5_ = node->parameters;
	_tmp6_ = _vala_iterable_ref0 (_tmp5_);
	parameters = _tmp6_;
	return_type = NULL;
	_tmp7_ = s;
	if (VALA_IS_CALLABLE (_tmp7_)) {
		ValaSymbol* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp8_ = s;
		_tmp9_ = vala_callable_get_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CALLABLE, ValaCallable));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp11_;
	}
	_tmp13_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
		_tmp12_ = node->return_array_length_idx >= 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = parameters;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (node->return_array_length_idx >= _tmp16_) {
			ValaDataType* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			_tmp17_ = return_type;
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_error (_tmp19_, "invalid array length index");
		} else {
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaGirParserParameterInfo* _tmp22_;
			ValaArrayList* _tmp23_;
			_tmp20_ = parameters;
			_tmp21_ = vala_list_get (_tmp20_, node->return_array_length_idx);
			_tmp22_ = (ValaGirParserParameterInfo*) _tmp21_;
			_tmp22_->keep = FALSE;
			_vala_gir_parser_parameter_info_unref0 (_tmp22_);
			_tmp23_ = node->array_length_parameters;
			vala_collection_add ((ValaCollection*) _tmp23_, (gpointer) ((gintptr) node->return_array_length_idx));
		}
	} else {
		gboolean _tmp24_ = FALSE;
		ValaDataType* _tmp25_;
		_tmp25_ = return_type;
		if (VALA_IS_VOID_TYPE (_tmp25_)) {
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp26_ = parameters;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp24_ = _tmp28_ > 0;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			gint n_out_parameters = 0;
			n_out_parameters = 0;
			{
				ValaList* _info_list = NULL;
				ValaList* _tmp29_;
				ValaList* _tmp30_;
				gint _info_size = 0;
				ValaList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _info_index = 0;
				_tmp29_ = parameters;
				_tmp30_ = _vala_iterable_ref0 (_tmp29_);
				_info_list = _tmp30_;
				_tmp31_ = _info_list;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_info_size = _tmp33_;
				_info_index = -1;
				while (TRUE) {
					gint _tmp34_;
					gint _tmp35_;
					ValaGirParserParameterInfo* info = NULL;
					ValaList* _tmp36_;
					gpointer _tmp37_;
					ValaGirParserParameterInfo* _tmp38_;
					ValaParameter* _tmp39_;
					ValaParameterDirection _tmp40_;
					ValaParameterDirection _tmp41_;
					_info_index = _info_index + 1;
					_tmp34_ = _info_index;
					_tmp35_ = _info_size;
					if (!(_tmp34_ < _tmp35_)) {
						break;
					}
					_tmp36_ = _info_list;
					_tmp37_ = vala_list_get (_tmp36_, _info_index);
					info = (ValaGirParserParameterInfo*) _tmp37_;
					_tmp38_ = info;
					_tmp39_ = _tmp38_->param;
					_tmp40_ = vala_parameter_get_direction (_tmp39_);
					_tmp41_ = _tmp40_;
					if (_tmp41_ == VALA_PARAMETER_DIRECTION_OUT) {
						gint _tmp42_;
						_tmp42_ = n_out_parameters;
						n_out_parameters = _tmp42_ + 1;
					}
					_vala_gir_parser_parameter_info_unref0 (info);
				}
				_vala_iterable_unref0 (_info_list);
			}
			if (n_out_parameters == 1) {
				ValaGirParserParameterInfo* last_param = NULL;
				ValaList* _tmp43_;
				ValaList* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gpointer _tmp47_;
				ValaGirParserParameterInfo* _tmp48_;
				ValaParameter* _tmp49_;
				ValaParameterDirection _tmp50_;
				ValaParameterDirection _tmp51_;
				_tmp43_ = parameters;
				_tmp44_ = parameters;
				_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_list_get (_tmp43_, _tmp46_ - 1);
				last_param = (ValaGirParserParameterInfo*) _tmp47_;
				_tmp48_ = last_param;
				_tmp49_ = _tmp48_->param;
				_tmp50_ = vala_parameter_get_direction (_tmp49_);
				_tmp51_ = _tmp50_;
				if (_tmp51_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaGirParserParameterInfo* _tmp52_;
					ValaParameter* _tmp53_;
					ValaDataType* _tmp54_;
					ValaDataType* _tmp55_;
					_tmp52_ = last_param;
					_tmp53_ = _tmp52_->param;
					_tmp54_ = vala_variable_get_variable_type ((ValaVariable*) _tmp53_);
					_tmp55_ = _tmp54_;
					if (VALA_IS_UNRESOLVED_TYPE (_tmp55_)) {
						ValaStruct* st = NULL;
						ValaGirParserNode* _tmp56_;
						ValaGirParserParameterInfo* _tmp57_;
						ValaParameter* _tmp58_;
						ValaDataType* _tmp59_;
						ValaDataType* _tmp60_;
						ValaUnresolvedSymbol* _tmp61_;
						ValaUnresolvedSymbol* _tmp62_;
						ValaSymbol* _tmp63_;
						ValaStruct* _tmp64_;
						gboolean _tmp65_ = FALSE;
						gboolean _tmp66_ = FALSE;
						ValaStruct* _tmp67_;
						_tmp56_ = node->parent;
						_tmp57_ = last_param;
						_tmp58_ = _tmp57_->param;
						_tmp59_ = vala_variable_get_variable_type ((ValaVariable*) _tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_gir_parser_resolve_symbol (self, _tmp56_, _tmp62_);
						_tmp64_ = VALA_IS_STRUCT (_tmp63_) ? ((ValaStruct*) _tmp63_) : NULL;
						if (_tmp64_ == NULL) {
							_vala_code_node_unref0 (_tmp63_);
						}
						st = _tmp64_;
						_tmp67_ = st;
						if (_tmp67_ != NULL) {
							ValaStruct* _tmp68_;
							_tmp68_ = st;
							_tmp66_ = !vala_struct_is_simple_type (_tmp68_);
						} else {
							_tmp66_ = FALSE;
						}
						if (_tmp66_) {
							ValaGirParserParameterInfo* _tmp69_;
							ValaParameter* _tmp70_;
							ValaDataType* _tmp71_;
							ValaDataType* _tmp72_;
							gboolean _tmp73_;
							gboolean _tmp74_;
							_tmp69_ = last_param;
							_tmp70_ = _tmp69_->param;
							_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) _tmp70_);
							_tmp72_ = _tmp71_;
							_tmp73_ = vala_data_type_get_nullable (_tmp72_);
							_tmp74_ = _tmp73_;
							_tmp65_ = !_tmp74_;
						} else {
							_tmp65_ = FALSE;
						}
						if (_tmp65_) {
							ValaGirParserMetadata* _tmp75_;
							_tmp75_ = node->metadata;
							if (!vala_gir_parser_metadata_get_bool (_tmp75_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, FALSE)) {
								ValaGirParserParameterInfo* _tmp76_;
								ValaGirParserParameterInfo* _tmp77_;
								ValaParameter* _tmp78_;
								ValaDataType* _tmp79_;
								ValaDataType* _tmp80_;
								ValaDataType* _tmp81_;
								_tmp76_ = last_param;
								_tmp76_->keep = FALSE;
								_tmp77_ = last_param;
								_tmp78_ = _tmp77_->param;
								_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) _tmp78_);
								_tmp80_ = _tmp79_;
								_tmp81_ = vala_data_type_copy (_tmp80_);
								_vala_code_node_unref0 (return_type);
								return_type = _tmp81_;
							}
						}
						_vala_code_node_unref0 (st);
					}
				}
				_vala_gir_parser_parameter_info_unref0 (last_param);
			}
		} else {
			gboolean _tmp82_ = FALSE;
			ValaDataType* _tmp83_;
			_tmp83_ = return_type;
			if (VALA_IS_UNRESOLVED_TYPE (_tmp83_)) {
				ValaDataType* _tmp84_;
				gboolean _tmp85_;
				gboolean _tmp86_;
				_tmp84_ = return_type;
				_tmp85_ = vala_data_type_get_nullable (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp82_ = !_tmp86_;
			} else {
				_tmp82_ = FALSE;
			}
			if (_tmp82_) {
				ValaStruct* st = NULL;
				ValaGirParserNode* _tmp87_;
				ValaDataType* _tmp88_;
				ValaUnresolvedSymbol* _tmp89_;
				ValaUnresolvedSymbol* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaStruct* _tmp92_;
				ValaStruct* _tmp93_;
				_tmp87_ = node->parent;
				_tmp88_ = return_type;
				_tmp89_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_gir_parser_resolve_symbol (self, _tmp87_, _tmp90_);
				_tmp92_ = VALA_IS_STRUCT (_tmp91_) ? ((ValaStruct*) _tmp91_) : NULL;
				if (_tmp92_ == NULL) {
					_vala_code_node_unref0 (_tmp91_);
				}
				st = _tmp92_;
				_tmp93_ = st;
				if (_tmp93_ != NULL) {
					gboolean is_simple_type = FALSE;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp94_;
					ValaStruct* _tmp95_;
					is_simple_type = FALSE;
					_tmp94_ = st;
					_tmp95_ = _vala_code_node_ref0 (_tmp94_);
					base_st = _tmp95_;
					while (TRUE) {
						ValaStruct* _tmp96_;
						ValaStruct* _tmp97_;
						ValaStruct* _tmp98_;
						ValaDataType* _tmp99_;
						ValaDataType* _tmp100_;
						_tmp96_ = base_st;
						if (!(_tmp96_ != NULL)) {
							break;
						}
						_tmp97_ = base_st;
						if (vala_struct_is_simple_type (_tmp97_)) {
							is_simple_type = TRUE;
							break;
						}
						_tmp98_ = base_st;
						_tmp99_ = vala_struct_get_base_type (_tmp98_);
						_tmp100_ = _tmp99_;
						if (VALA_IS_UNRESOLVED_TYPE (_tmp100_)) {
							ValaGirParserNode* _tmp101_;
							ValaStruct* _tmp102_;
							ValaDataType* _tmp103_;
							ValaDataType* _tmp104_;
							ValaUnresolvedSymbol* _tmp105_;
							ValaUnresolvedSymbol* _tmp106_;
							ValaSymbol* _tmp107_;
							ValaStruct* _tmp108_;
							_tmp101_ = node->parent;
							_tmp102_ = base_st;
							_tmp103_ = vala_struct_get_base_type (_tmp102_);
							_tmp104_ = _tmp103_;
							_tmp105_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
							_tmp106_ = _tmp105_;
							_tmp107_ = vala_gir_parser_resolve_symbol (self, _tmp101_, _tmp106_);
							_tmp108_ = VALA_IS_STRUCT (_tmp107_) ? ((ValaStruct*) _tmp107_) : NULL;
							if (_tmp108_ == NULL) {
								_vala_code_node_unref0 (_tmp107_);
							}
							_vala_code_node_unref0 (base_st);
							base_st = _tmp108_;
						} else {
							ValaStruct* _tmp109_;
							ValaStruct* _tmp110_;
							ValaStruct* _tmp111_;
							ValaStruct* _tmp112_;
							_tmp109_ = base_st;
							_tmp110_ = vala_struct_get_base_struct (_tmp109_);
							_tmp111_ = _tmp110_;
							_tmp112_ = _vala_code_node_ref0 (_tmp111_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp112_;
						}
					}
					if (!is_simple_type) {
						ValaDataType* _tmp113_;
						_tmp113_ = return_type;
						vala_data_type_set_nullable (_tmp113_, TRUE);
					}
					_vala_code_node_unref0 (base_st);
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp114_;
		ValaList* _tmp115_;
		gint _info_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _info_index = 0;
		_tmp114_ = parameters;
		_tmp115_ = _vala_iterable_ref0 (_tmp114_);
		_info_list = _tmp115_;
		_tmp116_ = _info_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_info_size = _tmp118_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp121_;
			gpointer _tmp122_;
			ValaDataType* type = NULL;
			ValaGirParserParameterInfo* _tmp123_;
			ValaParameter* _tmp124_;
			ValaDataType* _tmp125_;
			ValaDataType* _tmp126_;
			gboolean _tmp127_ = FALSE;
			ValaGirParserParameterInfo* _tmp128_;
			ValaParameter* _tmp129_;
			ValaParameterDirection _tmp130_;
			ValaParameterDirection _tmp131_;
			ValaSymbol* _tmp151_;
			gboolean _tmp189_ = FALSE;
			gboolean _tmp190_ = FALSE;
			ValaGirParserParameterInfo* _tmp191_;
			ValaParameter* _tmp192_;
			ValaParameterDirection _tmp193_;
			ValaParameterDirection _tmp194_;
			_info_index = _info_index + 1;
			_tmp119_ = _info_index;
			_tmp120_ = _info_size;
			if (!(_tmp119_ < _tmp120_)) {
				break;
			}
			_tmp121_ = _info_list;
			_tmp122_ = vala_list_get (_tmp121_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp122_;
			_tmp123_ = info;
			_tmp124_ = _tmp123_->param;
			_tmp125_ = vala_variable_get_variable_type ((ValaVariable*) _tmp124_);
			_tmp126_ = _tmp125_;
			type = _tmp126_;
			_tmp128_ = info;
			_tmp129_ = _tmp128_->param;
			_tmp130_ = vala_parameter_get_direction (_tmp129_);
			_tmp131_ = _tmp130_;
			if (_tmp131_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaDataType* _tmp132_;
				gboolean _tmp133_;
				gboolean _tmp134_;
				_tmp132_ = type;
				_tmp133_ = vala_data_type_get_nullable (_tmp132_);
				_tmp134_ = _tmp133_;
				_tmp127_ = _tmp134_;
			} else {
				_tmp127_ = FALSE;
			}
			if (_tmp127_) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp135_;
				gboolean _tmp147_ = FALSE;
				ValaStruct* _tmp148_;
				st = NULL;
				_tmp135_ = type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp135_)) {
					ValaGirParserNode* _tmp136_;
					ValaDataType* _tmp137_;
					ValaUnresolvedSymbol* _tmp138_;
					ValaUnresolvedSymbol* _tmp139_;
					ValaSymbol* _tmp140_;
					ValaStruct* _tmp141_;
					_tmp136_ = node->parent;
					_tmp137_ = type;
					_tmp138_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp139_ = _tmp138_;
					_tmp140_ = vala_gir_parser_resolve_symbol (self, _tmp136_, _tmp139_);
					_tmp141_ = VALA_IS_STRUCT (_tmp140_) ? ((ValaStruct*) _tmp140_) : NULL;
					if (_tmp141_ == NULL) {
						_vala_code_node_unref0 (_tmp140_);
					}
					_vala_code_node_unref0 (st);
					st = _tmp141_;
				} else {
					ValaDataType* _tmp142_;
					_tmp142_ = type;
					if (VALA_IS_VALUE_TYPE (_tmp142_)) {
						ValaDataType* _tmp143_;
						ValaTypeSymbol* _tmp144_;
						ValaTypeSymbol* _tmp145_;
						ValaStruct* _tmp146_;
						_tmp143_ = type;
						_tmp144_ = vala_data_type_get_type_symbol (_tmp143_);
						_tmp145_ = _tmp144_;
						_tmp146_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp145_) ? ((ValaStruct*) _tmp145_) : NULL);
						_vala_code_node_unref0 (st);
						st = _tmp146_;
					}
				}
				_tmp148_ = st;
				if (_tmp148_ != NULL) {
					ValaStruct* _tmp149_;
					_tmp149_ = st;
					_tmp147_ = vala_struct_is_simple_type (_tmp149_);
				} else {
					_tmp147_ = FALSE;
				}
				if (_tmp147_) {
					ValaDataType* _tmp150_;
					_tmp150_ = type;
					vala_data_type_set_nullable (_tmp150_, FALSE);
				}
				_vala_code_node_unref0 (st);
			}
			_tmp151_ = s;
			if (VALA_IS_METHOD (_tmp151_)) {
				gchar* type_name = NULL;
				ValaUnresolvedType* unresolved_type = NULL;
				ValaDataType* _tmp152_;
				ValaUnresolvedType* _tmp153_;
				ValaGirParserParameterInfo* _tmp163_;
				gboolean _tmp177_ = FALSE;
				gboolean _tmp178_ = FALSE;
				gboolean _tmp179_ = FALSE;
				gboolean _tmp180_ = FALSE;
				gboolean _tmp181_ = FALSE;
				ValaUnresolvedType* _tmp182_;
				type_name = NULL;
				_tmp152_ = type;
				unresolved_type = VALA_IS_UNRESOLVED_TYPE (_tmp152_) ? ((ValaUnresolvedType*) _tmp152_) : NULL;
				_tmp153_ = unresolved_type;
				if (_tmp153_ != NULL) {
					ValaUnresolvedType* _tmp154_;
					ValaUnresolvedSymbol* _tmp155_;
					ValaUnresolvedSymbol* _tmp156_;
					const gchar* _tmp157_;
					const gchar* _tmp158_;
					gchar* _tmp159_;
					_tmp154_ = unresolved_type;
					_tmp155_ = vala_unresolved_type_get_unresolved_symbol (_tmp154_);
					_tmp156_ = _tmp155_;
					_tmp157_ = vala_symbol_get_name ((ValaSymbol*) _tmp156_);
					_tmp158_ = _tmp157_;
					_tmp159_ = g_strdup (_tmp158_);
					_g_free0 (type_name);
					type_name = _tmp159_;
				} else {
					ValaDataType* _tmp160_;
					_tmp160_ = type;
					if (_tmp160_ != NULL) {
						ValaDataType* _tmp161_;
						gchar* _tmp162_;
						_tmp161_ = type;
						_tmp162_ = vala_code_node_to_string ((ValaCodeNode*) _tmp161_);
						_g_free0 (type_name);
						type_name = _tmp162_;
					}
				}
				_tmp163_ = info;
				if (_tmp163_->is_async) {
					gboolean _tmp164_ = FALSE;
					gboolean _tmp165_ = FALSE;
					gboolean _tmp166_ = FALSE;
					gboolean _tmp167_ = FALSE;
					gboolean _tmp168_ = FALSE;
					ValaUnresolvedType* _tmp169_;
					_tmp169_ = unresolved_type;
					if (_tmp169_ != NULL) {
						const gchar* _tmp170_;
						_tmp170_ = type_name;
						_tmp168_ = g_strcmp0 (_tmp170_, "AsyncReadyCallback") == 0;
					} else {
						_tmp168_ = FALSE;
					}
					if (_tmp168_) {
						_tmp167_ = TRUE;
					} else {
						const gchar* _tmp171_;
						_tmp171_ = type_name;
						_tmp167_ = g_strcmp0 (_tmp171_, "GLib.AsyncReadyCallback") == 0;
					}
					if (_tmp167_) {
						_tmp166_ = TRUE;
					} else {
						const gchar* _tmp172_;
						_tmp172_ = type_name;
						_tmp166_ = g_strcmp0 (_tmp172_, "Gio.AsyncReadyCallback") == 0;
					}
					if (_tmp166_) {
						_tmp165_ = TRUE;
					} else {
						const gchar* _tmp173_;
						_tmp173_ = type_name;
						_tmp165_ = g_strcmp0 (_tmp173_, "GLib.AsyncReadyCallback?") == 0;
					}
					if (_tmp165_) {
						_tmp164_ = TRUE;
					} else {
						const gchar* _tmp174_;
						_tmp174_ = type_name;
						_tmp164_ = g_strcmp0 (_tmp174_, "Gio.AsyncReadyCallback?") == 0;
					}
					if (_tmp164_) {
						ValaSymbol* _tmp175_;
						ValaGirParserParameterInfo* _tmp176_;
						_tmp175_ = s;
						vala_method_set_coroutine (G_TYPE_CHECK_INSTANCE_CAST (_tmp175_, VALA_TYPE_METHOD, ValaMethod), TRUE);
						_tmp176_ = info;
						_tmp176_->keep = FALSE;
					}
				}
				_tmp182_ = unresolved_type;
				if (_tmp182_ != NULL) {
					const gchar* _tmp183_;
					_tmp183_ = type_name;
					_tmp181_ = g_strcmp0 (_tmp183_, "AsyncResult") == 0;
				} else {
					_tmp181_ = FALSE;
				}
				if (_tmp181_) {
					_tmp180_ = TRUE;
				} else {
					const gchar* _tmp184_;
					_tmp184_ = type_name;
					_tmp180_ = g_strcmp0 (_tmp184_, "GLib.AsyncResult") == 0;
				}
				if (_tmp180_) {
					_tmp179_ = TRUE;
				} else {
					const gchar* _tmp185_;
					_tmp185_ = type_name;
					_tmp179_ = g_strcmp0 (_tmp185_, "Gio.AsyncResult") == 0;
				}
				if (_tmp179_) {
					_tmp178_ = TRUE;
				} else {
					const gchar* _tmp186_;
					_tmp186_ = type_name;
					_tmp178_ = g_strcmp0 (_tmp186_, "GLib.AsyncResult?") == 0;
				}
				if (_tmp178_) {
					_tmp177_ = TRUE;
				} else {
					const gchar* _tmp187_;
					_tmp187_ = type_name;
					_tmp177_ = g_strcmp0 (_tmp187_, "Gio.AsyncResult?") == 0;
				}
				if (_tmp177_) {
					ValaGirParserParameterInfo* _tmp188_;
					_tmp188_ = info;
					_tmp188_->is_async_result = TRUE;
				}
				_g_free0 (type_name);
			}
			_tmp191_ = info;
			_tmp192_ = _tmp191_->param;
			_tmp193_ = vala_parameter_get_direction (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaSymbol* _tmp195_;
				_tmp195_ = s;
				_tmp190_ = VALA_IS_DELEGATE (_tmp195_);
			} else {
				_tmp190_ = FALSE;
			}
			if (_tmp190_) {
				ValaSymbol* _tmp196_;
				gboolean _tmp197_;
				gboolean _tmp198_;
				_tmp196_ = s;
				_tmp197_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp196_);
				_tmp198_ = _tmp197_;
				_tmp189_ = !_tmp198_;
			} else {
				_tmp189_ = FALSE;
			}
			if (_tmp189_) {
				ValaUnresolvedType* unresolved_type = NULL;
				ValaDataType* _tmp199_;
				gboolean _tmp200_ = FALSE;
				ValaUnresolvedType* _tmp201_;
				_tmp199_ = type;
				unresolved_type = VALA_IS_UNRESOLVED_TYPE (_tmp199_) ? ((ValaUnresolvedType*) _tmp199_) : NULL;
				_tmp201_ = unresolved_type;
				if (_tmp201_ != NULL) {
					ValaUnresolvedType* _tmp202_;
					ValaUnresolvedSymbol* _tmp203_;
					ValaUnresolvedSymbol* _tmp204_;
					gchar* _tmp205_;
					gchar* _tmp206_;
					_tmp202_ = unresolved_type;
					_tmp203_ = vala_unresolved_type_get_unresolved_symbol (_tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = vala_code_node_to_string ((ValaCodeNode*) _tmp204_);
					_tmp206_ = _tmp205_;
					_tmp200_ = g_strcmp0 (_tmp206_, "GLib.Error") == 0;
					_g_free0 (_tmp206_);
				} else {
					_tmp200_ = FALSE;
				}
				if (_tmp200_) {
					ValaSymbol* _tmp207_;
					ValaErrorType* _tmp208_;
					ValaErrorType* _tmp209_;
					ValaGirParserParameterInfo* _tmp210_;
					ValaGirParserParameterInfo* _tmp211_;
					_tmp207_ = s;
					_tmp208_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp209_ = _tmp208_;
					vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp207_, VALA_TYPE_DELEGATE, ValaDelegate), (ValaDataType*) _tmp209_);
					_vala_code_node_unref0 (_tmp209_);
					_tmp210_ = info;
					_tmp210_->is_error = TRUE;
					_tmp211_ = info;
					_tmp211_->keep = FALSE;
				}
			}
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	{
		gint param_n = 0;
		ValaList* _tmp212_;
		gint _tmp213_;
		gint _tmp214_;
		_tmp212_ = parameters;
		_tmp213_ = vala_collection_get_size ((ValaCollection*) _tmp212_);
		_tmp214_ = _tmp213_;
		param_n = _tmp214_ - 1;
		{
			gboolean _tmp215_ = FALSE;
			_tmp215_ = TRUE;
			while (TRUE) {
				ValaGirParserParameterInfo* info = NULL;
				ValaList* _tmp217_;
				gpointer _tmp218_;
				gboolean _tmp219_ = FALSE;
				ValaGirParserParameterInfo* _tmp220_;
				ValaParameter* _tmp221_;
				gboolean _tmp222_;
				gboolean _tmp223_;
				if (!_tmp215_) {
					gint _tmp216_;
					_tmp216_ = param_n;
					param_n = _tmp216_ - 1;
				}
				_tmp215_ = FALSE;
				if (!(param_n >= 0)) {
					break;
				}
				_tmp217_ = parameters;
				_tmp218_ = vala_list_get (_tmp217_, param_n);
				info = (ValaGirParserParameterInfo*) _tmp218_;
				_tmp220_ = info;
				_tmp221_ = _tmp220_->param;
				_tmp222_ = vala_parameter_get_ellipsis (_tmp221_);
				_tmp223_ = _tmp222_;
				if (!_tmp223_) {
					ValaGirParserParameterInfo* _tmp224_;
					ValaParameter* _tmp225_;
					ValaExpression* _tmp226_;
					ValaExpression* _tmp227_;
					_tmp224_ = info;
					_tmp225_ = _tmp224_->param;
					_tmp226_ = vala_variable_get_initializer ((ValaVariable*) _tmp225_);
					_tmp227_ = _tmp226_;
					_tmp219_ = _tmp227_ == NULL;
				} else {
					_tmp219_ = FALSE;
				}
				if (_tmp219_) {
					gchar* type_string = NULL;
					ValaGirParserParameterInfo* _tmp228_;
					ValaParameter* _tmp229_;
					ValaDataType* _tmp230_;
					ValaDataType* _tmp231_;
					gchar* _tmp232_;
					gboolean _tmp233_ = FALSE;
					const gchar* _tmp234_;
					_tmp228_ = info;
					_tmp229_ = _tmp228_->param;
					_tmp230_ = vala_variable_get_variable_type ((ValaVariable*) _tmp229_);
					_tmp231_ = _tmp230_;
					_tmp232_ = vala_code_node_to_string ((ValaCodeNode*) _tmp231_);
					type_string = _tmp232_;
					_tmp234_ = type_string;
					if (g_strcmp0 (_tmp234_, "GLib.Cancellable?") == 0) {
						_tmp233_ = TRUE;
					} else {
						const gchar* _tmp235_;
						_tmp235_ = type_string;
						_tmp233_ = g_strcmp0 (_tmp235_, "Gio.Cancellable?") == 0;
					}
					if (_tmp233_) {
						ValaGirParserParameterInfo* _tmp236_;
						ValaParameter* _tmp237_;
						ValaNullLiteral* _tmp238_;
						ValaNullLiteral* _tmp239_;
						_tmp236_ = info;
						_tmp237_ = _tmp236_->param;
						_tmp238_ = vala_null_literal_new (NULL);
						_tmp239_ = _tmp238_;
						vala_variable_set_initializer ((ValaVariable*) _tmp237_, (ValaExpression*) _tmp239_);
						_vala_code_node_unref0 (_tmp239_);
					} else {
						_g_free0 (type_string);
						_vala_gir_parser_parameter_info_unref0 (info);
						break;
					}
					_g_free0 (type_string);
				}
				_vala_gir_parser_parameter_info_unref0 (info);
			}
		}
	}
	_tmp240_ = parameters;
	_tmp241_ = vala_collection_get_size ((ValaCollection*) _tmp240_);
	_tmp242_ = _tmp241_;
	if (_tmp242_ > 1) {
		ValaGirParserParameterInfo* last_param = NULL;
		ValaList* _tmp243_;
		ValaList* _tmp244_;
		gint _tmp245_;
		gint _tmp246_;
		gpointer _tmp247_;
		ValaGirParserParameterInfo* _tmp248_;
		ValaParameter* _tmp249_;
		gboolean _tmp250_;
		gboolean _tmp251_;
		_tmp243_ = parameters;
		_tmp244_ = parameters;
		_tmp245_ = vala_collection_get_size ((ValaCollection*) _tmp244_);
		_tmp246_ = _tmp245_;
		_tmp247_ = vala_list_get (_tmp243_, _tmp246_ - 1);
		last_param = (ValaGirParserParameterInfo*) _tmp247_;
		_tmp248_ = last_param;
		_tmp249_ = _tmp248_->param;
		_tmp250_ = vala_parameter_get_ellipsis (_tmp249_);
		_tmp251_ = _tmp250_;
		if (_tmp251_) {
			ValaGirParserParameterInfo* first_vararg_param = NULL;
			ValaList* _tmp252_;
			ValaList* _tmp253_;
			gint _tmp254_;
			gint _tmp255_;
			gpointer _tmp256_;
			ValaGirParserParameterInfo* _tmp257_;
			ValaParameter* _tmp258_;
			const gchar* _tmp259_;
			const gchar* _tmp260_;
			_tmp252_ = parameters;
			_tmp253_ = parameters;
			_tmp254_ = vala_collection_get_size ((ValaCollection*) _tmp253_);
			_tmp255_ = _tmp254_;
			_tmp256_ = vala_list_get (_tmp252_, _tmp255_ - 2);
			first_vararg_param = (ValaGirParserParameterInfo*) _tmp256_;
			_tmp257_ = first_vararg_param;
			_tmp258_ = _tmp257_->param;
			_tmp259_ = vala_symbol_get_name ((ValaSymbol*) _tmp258_);
			_tmp260_ = _tmp259_;
			if (g_str_has_prefix (_tmp260_, "first_")) {
				ValaGirParserParameterInfo* _tmp261_;
				_tmp261_ = first_vararg_param;
				_tmp261_->keep = FALSE;
			}
			_vala_gir_parser_parameter_info_unref0 (first_vararg_param);
		}
		_vala_gir_parser_parameter_info_unref0 (last_param);
	}
	i = 0;
	j = 1;
	first_out = -1;
	last = -1;
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp262_;
		ValaList* _tmp263_;
		gint _info_size = 0;
		ValaList* _tmp264_;
		gint _tmp265_;
		gint _tmp266_;
		gint _info_index = 0;
		_tmp262_ = parameters;
		_tmp263_ = _vala_iterable_ref0 (_tmp262_);
		_info_list = _tmp263_;
		_tmp264_ = _info_list;
		_tmp265_ = vala_collection_get_size ((ValaCollection*) _tmp264_);
		_tmp266_ = _tmp265_;
		_info_size = _tmp266_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp267_;
			gint _tmp268_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp269_;
			gpointer _tmp270_;
			gboolean _tmp271_ = FALSE;
			ValaSymbol* _tmp272_;
			gboolean _tmp299_ = FALSE;
			gboolean _tmp304_ = FALSE;
			gboolean _tmp305_ = FALSE;
			gboolean _tmp313_ = FALSE;
			ValaSymbol* _tmp314_;
			gint _tmp318_;
			_info_index = _info_index + 1;
			_tmp267_ = _info_index;
			_tmp268_ = _info_size;
			if (!(_tmp267_ < _tmp268_)) {
				break;
			}
			_tmp269_ = _info_list;
			_tmp270_ = vala_list_get (_tmp269_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp270_;
			_tmp272_ = s;
			if (VALA_IS_DELEGATE (_tmp272_)) {
				ValaGirParserParameterInfo* _tmp273_;
				_tmp273_ = info;
				_tmp271_ = _tmp273_->closure_idx == i;
			} else {
				_tmp271_ = FALSE;
			}
			if (_tmp271_) {
				ValaDelegate* d = NULL;
				ValaSymbol* _tmp274_;
				ValaDelegate* _tmp275_;
				ValaDelegate* _tmp276_;
				ValaDelegate* _tmp277_;
				ValaGirParserParameterInfo* _tmp278_;
				_tmp274_ = s;
				_tmp275_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp274_, VALA_TYPE_DELEGATE, ValaDelegate));
				d = _tmp275_;
				_tmp276_ = d;
				vala_delegate_set_has_target (_tmp276_, TRUE);
				_tmp277_ = d;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp277_, "CCode", "instance_pos", j - 0.1, NULL);
				_tmp278_ = info;
				_tmp278_->keep = FALSE;
				_vala_code_node_unref0 (d);
			} else {
				gboolean _tmp279_ = FALSE;
				gboolean _tmp280_ = FALSE;
				gboolean _tmp281_ = FALSE;
				ValaGirParserParameterInfo* _tmp282_;
				_tmp282_ = info;
				if (_tmp282_->keep) {
					ValaArrayList* _tmp283_;
					_tmp283_ = node->array_length_parameters;
					_tmp281_ = !vala_collection_contains ((ValaCollection*) _tmp283_, (gpointer) ((gintptr) i));
				} else {
					_tmp281_ = FALSE;
				}
				if (_tmp281_) {
					ValaArrayList* _tmp284_;
					_tmp284_ = node->closure_parameters;
					_tmp280_ = !vala_collection_contains ((ValaCollection*) _tmp284_, (gpointer) ((gintptr) i));
				} else {
					_tmp280_ = FALSE;
				}
				if (_tmp280_) {
					ValaArrayList* _tmp285_;
					_tmp285_ = node->destroy_parameters;
					_tmp279_ = !vala_collection_contains ((ValaCollection*) _tmp285_, (gpointer) ((gintptr) i));
				} else {
					_tmp279_ = FALSE;
				}
				if (_tmp279_) {
					ValaGirParserParameterInfo* _tmp286_;
					ValaGirParserParameterInfo* _tmp287_;
					gfloat last_idx = 0.0F;
					gint _tmp296_;
					_tmp286_ = info;
					_tmp286_->vala_idx = (gfloat) j;
					_tmp287_ = info;
					_tmp287_->keep = TRUE;
					last_idx = 0.0F;
					if (last != -1) {
						ValaList* _tmp288_;
						gpointer _tmp289_;
						ValaGirParserParameterInfo* _tmp290_;
						_tmp288_ = parameters;
						_tmp289_ = vala_list_get (_tmp288_, last);
						_tmp290_ = (ValaGirParserParameterInfo*) _tmp289_;
						last_idx = _tmp290_->vala_idx;
						_vala_gir_parser_parameter_info_unref0 (_tmp290_);
					}
					{
						gint k = 0;
						k = last + 1;
						{
							gboolean _tmp291_ = FALSE;
							_tmp291_ = TRUE;
							while (TRUE) {
								ValaList* _tmp293_;
								gpointer _tmp294_;
								ValaGirParserParameterInfo* _tmp295_;
								if (!_tmp291_) {
									gint _tmp292_;
									_tmp292_ = k;
									k = _tmp292_ + 1;
								}
								_tmp291_ = FALSE;
								if (!(k < i)) {
									break;
								}
								_tmp293_ = parameters;
								_tmp294_ = vala_list_get (_tmp293_, k);
								_tmp295_ = (ValaGirParserParameterInfo*) _tmp294_;
								_tmp295_->vala_idx = last_idx + (((j - last_idx) / (i - last)) * (k - last));
								_vala_gir_parser_parameter_info_unref0 (_tmp295_);
							}
						}
					}
					last = i;
					_tmp296_ = j;
					j = _tmp296_ + 1;
				} else {
					ValaGirParserParameterInfo* _tmp297_;
					ValaGirParserParameterInfo* _tmp298_;
					_tmp297_ = info;
					_tmp297_->keep = FALSE;
					_tmp298_ = info;
					_tmp298_->vala_idx = (j - 1) + ((i - last) * 0.1F);
				}
			}
			if (first_out < 0) {
				ValaGirParserParameterInfo* _tmp300_;
				ValaParameter* _tmp301_;
				ValaParameterDirection _tmp302_;
				ValaParameterDirection _tmp303_;
				_tmp300_ = info;
				_tmp301_ = _tmp300_->param;
				_tmp302_ = vala_parameter_get_direction (_tmp301_);
				_tmp303_ = _tmp302_;
				_tmp299_ = _tmp303_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp299_ = FALSE;
			}
			if (_tmp299_) {
				first_out = i;
			}
			if (first_out >= 0) {
				ValaGirParserParameterInfo* _tmp306_;
				_tmp306_ = info;
				_tmp305_ = _tmp306_->is_async_result;
			} else {
				_tmp305_ = FALSE;
			}
			if (_tmp305_) {
				ValaSymbol* _tmp307_;
				_tmp307_ = s;
				_tmp304_ = VALA_IS_METHOD (_tmp307_);
			} else {
				_tmp304_ = FALSE;
			}
			if (_tmp304_) {
				gdouble _tmp308_ = 0.0;
				ValaSymbol* _tmp309_;
				ValaMemberBinding _tmp310_;
				ValaMemberBinding _tmp311_;
				gdouble shift = 0.0;
				ValaSymbol* _tmp312_;
				_tmp309_ = s;
				_tmp310_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp309_, VALA_TYPE_METHOD, ValaMethod));
				_tmp311_ = _tmp310_;
				if (_tmp311_ == VALA_MEMBER_BINDING_INSTANCE) {
					_tmp308_ = 1.1;
				} else {
					_tmp308_ = 0.1;
				}
				shift = _tmp308_;
				_tmp312_ = s;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp312_, "CCode", "async_result_pos", i + shift, NULL);
			}
			_tmp314_ = s;
			if (VALA_IS_DELEGATE (_tmp314_)) {
				ValaGirParserParameterInfo* _tmp315_;
				_tmp315_ = info;
				_tmp313_ = _tmp315_->is_error;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaSymbol* _tmp316_;
				_tmp316_ = s;
				if (!vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp316_, "CCode", "instance_pos")) {
					ValaSymbol* _tmp317_;
					_tmp317_ = s;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp317_, "CCode", "error_pos", j - 0.2, NULL);
				}
			}
			_tmp318_ = i;
			i = _tmp318_ + 1;
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp319_;
		ValaList* _tmp320_;
		gint _info_size = 0;
		ValaList* _tmp321_;
		gint _tmp322_;
		gint _tmp323_;
		gint _info_index = 0;
		_tmp319_ = parameters;
		_tmp320_ = _vala_iterable_ref0 (_tmp319_);
		_info_list = _tmp320_;
		_tmp321_ = _info_list;
		_tmp322_ = vala_collection_get_size ((ValaCollection*) _tmp321_);
		_tmp323_ = _tmp322_;
		_info_size = _tmp323_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp324_;
			gint _tmp325_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp326_;
			gpointer _tmp327_;
			ValaGirParserParameterInfo* _tmp328_;
			ValaSymbol* _tmp329_;
			ValaGirParserParameterInfo* _tmp333_;
			ValaGirParserParameterInfo* _tmp348_;
			ValaGirParserParameterInfo* _tmp373_;
			ValaGirParserParameterInfo* _tmp398_;
			_info_index = _info_index + 1;
			_tmp324_ = _info_index;
			_tmp325_ = _info_size;
			if (!(_tmp324_ < _tmp325_)) {
				break;
			}
			_tmp326_ = _info_list;
			_tmp327_ = vala_list_get (_tmp326_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp327_;
			_tmp328_ = info;
			if (!_tmp328_->keep) {
				_vala_gir_parser_parameter_info_unref0 (info);
				continue;
			}
			_tmp329_ = s;
			if (VALA_IS_CALLABLE (_tmp329_)) {
				ValaSymbol* _tmp330_;
				ValaGirParserParameterInfo* _tmp331_;
				ValaParameter* _tmp332_;
				_tmp330_ = s;
				_tmp331_ = info;
				_tmp332_ = _tmp331_->param;
				vala_callable_add_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_CALLABLE, ValaCallable), _tmp332_);
			}
			_tmp333_ = info;
			if (_tmp333_->array_length_idx != -1) {
				ValaGirParserParameterInfo* _tmp334_;
				ValaList* _tmp335_;
				gint _tmp336_;
				gint _tmp337_;
				ValaGirParserParameterInfo* _tmp342_;
				ValaParameter* _tmp343_;
				ValaList* _tmp344_;
				ValaGirParserParameterInfo* _tmp345_;
				gpointer _tmp346_;
				ValaGirParserParameterInfo* _tmp347_;
				_tmp334_ = info;
				_tmp335_ = parameters;
				_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
				_tmp337_ = _tmp336_;
				if (_tmp334_->array_length_idx >= _tmp337_) {
					ValaGirParserParameterInfo* _tmp338_;
					ValaParameter* _tmp339_;
					ValaSourceReference* _tmp340_;
					ValaSourceReference* _tmp341_;
					_tmp338_ = info;
					_tmp339_ = _tmp338_->param;
					_tmp340_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp339_);
					_tmp341_ = _tmp340_;
					vala_report_error (_tmp341_, "invalid array_length index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp342_ = info;
				_tmp343_ = _tmp342_->param;
				_tmp344_ = parameters;
				_tmp345_ = info;
				_tmp346_ = vala_list_get (_tmp344_, _tmp345_->array_length_idx);
				_tmp347_ = (ValaGirParserParameterInfo*) _tmp346_;
				vala_gir_parser_set_array_ccode (self, (ValaSymbol*) _tmp343_, _tmp347_);
				_vala_gir_parser_parameter_info_unref0 (_tmp347_);
			}
			_tmp348_ = info;
			if (_tmp348_->closure_idx != -1) {
				ValaGirParserParameterInfo* _tmp349_;
				ValaList* _tmp350_;
				gint _tmp351_;
				gint _tmp352_;
				ValaList* _tmp357_;
				ValaGirParserParameterInfo* _tmp358_;
				gpointer _tmp359_;
				ValaGirParserParameterInfo* _tmp360_;
				gchar* _tmp361_;
				gchar* _tmp362_;
				ValaGirParserParameterInfo* _tmp363_;
				gchar* _tmp364_;
				gchar* _tmp365_;
				gboolean _tmp366_;
				_tmp349_ = info;
				_tmp350_ = parameters;
				_tmp351_ = vala_collection_get_size ((ValaCollection*) _tmp350_);
				_tmp352_ = _tmp351_;
				if (_tmp349_->closure_idx >= _tmp352_) {
					ValaGirParserParameterInfo* _tmp353_;
					ValaParameter* _tmp354_;
					ValaSourceReference* _tmp355_;
					ValaSourceReference* _tmp356_;
					_tmp353_ = info;
					_tmp354_ = _tmp353_->param;
					_tmp355_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp354_);
					_tmp356_ = _tmp355_;
					vala_report_error (_tmp356_, "invalid closure index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp357_ = parameters;
				_tmp358_ = info;
				_tmp359_ = vala_list_get (_tmp357_, _tmp358_->closure_idx);
				_tmp360_ = (ValaGirParserParameterInfo*) _tmp359_;
				_tmp361_ = g_strdup_printf ("%g", (gdouble) _tmp360_->vala_idx);
				_tmp362_ = _tmp361_;
				_tmp363_ = info;
				_tmp364_ = g_strdup_printf ("%g", _tmp363_->vala_idx + 0.1);
				_tmp365_ = _tmp364_;
				_tmp366_ = g_strcmp0 (_tmp362_, _tmp365_) != 0;
				_g_free0 (_tmp365_);
				_g_free0 (_tmp362_);
				_vala_gir_parser_parameter_info_unref0 (_tmp360_);
				if (_tmp366_) {
					ValaGirParserParameterInfo* _tmp367_;
					ValaParameter* _tmp368_;
					ValaList* _tmp369_;
					ValaGirParserParameterInfo* _tmp370_;
					gpointer _tmp371_;
					ValaGirParserParameterInfo* _tmp372_;
					_tmp367_ = info;
					_tmp368_ = _tmp367_->param;
					_tmp369_ = parameters;
					_tmp370_ = info;
					_tmp371_ = vala_list_get (_tmp369_, _tmp370_->closure_idx);
					_tmp372_ = (ValaGirParserParameterInfo*) _tmp371_;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp368_, "CCode", "delegate_target_pos", (gdouble) _tmp372_->vala_idx, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp372_);
				}
			}
			_tmp373_ = info;
			if (_tmp373_->destroy_idx != -1) {
				ValaGirParserParameterInfo* _tmp374_;
				ValaList* _tmp375_;
				gint _tmp376_;
				gint _tmp377_;
				ValaList* _tmp382_;
				ValaGirParserParameterInfo* _tmp383_;
				gpointer _tmp384_;
				ValaGirParserParameterInfo* _tmp385_;
				gchar* _tmp386_;
				gchar* _tmp387_;
				ValaGirParserParameterInfo* _tmp388_;
				gchar* _tmp389_;
				gchar* _tmp390_;
				gboolean _tmp391_;
				_tmp374_ = info;
				_tmp375_ = parameters;
				_tmp376_ = vala_collection_get_size ((ValaCollection*) _tmp375_);
				_tmp377_ = _tmp376_;
				if (_tmp374_->destroy_idx >= _tmp377_) {
					ValaGirParserParameterInfo* _tmp378_;
					ValaParameter* _tmp379_;
					ValaSourceReference* _tmp380_;
					ValaSourceReference* _tmp381_;
					_tmp378_ = info;
					_tmp379_ = _tmp378_->param;
					_tmp380_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp379_);
					_tmp381_ = _tmp380_;
					vala_report_error (_tmp381_, "invalid destroy index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp382_ = parameters;
				_tmp383_ = info;
				_tmp384_ = vala_list_get (_tmp382_, _tmp383_->destroy_idx);
				_tmp385_ = (ValaGirParserParameterInfo*) _tmp384_;
				_tmp386_ = g_strdup_printf ("%g", (gdouble) _tmp385_->vala_idx);
				_tmp387_ = _tmp386_;
				_tmp388_ = info;
				_tmp389_ = g_strdup_printf ("%g", _tmp388_->vala_idx + 0.2);
				_tmp390_ = _tmp389_;
				_tmp391_ = g_strcmp0 (_tmp387_, _tmp390_) != 0;
				_g_free0 (_tmp390_);
				_g_free0 (_tmp387_);
				_vala_gir_parser_parameter_info_unref0 (_tmp385_);
				if (_tmp391_) {
					ValaGirParserParameterInfo* _tmp392_;
					ValaParameter* _tmp393_;
					ValaList* _tmp394_;
					ValaGirParserParameterInfo* _tmp395_;
					gpointer _tmp396_;
					ValaGirParserParameterInfo* _tmp397_;
					_tmp392_ = info;
					_tmp393_ = _tmp392_->param;
					_tmp394_ = parameters;
					_tmp395_ = info;
					_tmp396_ = vala_list_get (_tmp394_, _tmp395_->destroy_idx);
					_tmp397_ = (ValaGirParserParameterInfo*) _tmp396_;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp393_, "CCode", "destroy_notify_pos", (gdouble) _tmp397_->vala_idx, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp397_);
				}
			}
			_tmp398_ = info;
			if (_tmp398_->is_async) {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp399_;
				ValaParameter* _tmp400_;
				ValaDataType* _tmp401_;
				ValaDataType* _tmp402_;
				ValaDataType* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp413_;
				_tmp399_ = info;
				_tmp400_ = _tmp399_->param;
				_tmp401_ = vala_variable_get_variable_type ((ValaVariable*) _tmp400_);
				_tmp402_ = _tmp401_;
				_tmp403_ = _vala_code_node_ref0 (_tmp402_);
				resolved_type = _tmp403_;
				_tmp404_ = resolved_type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp404_)) {
					ValaSymbol* resolved_symbol = NULL;
					ValaGirParserNode* _tmp405_;
					ValaDataType* _tmp406_;
					ValaUnresolvedSymbol* _tmp407_;
					ValaUnresolvedSymbol* _tmp408_;
					ValaSymbol* _tmp409_;
					ValaSymbol* _tmp410_;
					_tmp405_ = node->parent;
					_tmp406_ = resolved_type;
					_tmp407_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp406_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp408_ = _tmp407_;
					_tmp409_ = vala_gir_parser_resolve_symbol (self, _tmp405_, _tmp408_);
					resolved_symbol = _tmp409_;
					_tmp410_ = resolved_symbol;
					if (VALA_IS_DELEGATE (_tmp410_)) {
						ValaSymbol* _tmp411_;
						ValaDelegateType* _tmp412_;
						_tmp411_ = resolved_symbol;
						_tmp412_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (resolved_type);
						resolved_type = (ValaDataType*) _tmp412_;
					}
					_vala_code_node_unref0 (resolved_symbol);
				}
				_tmp413_ = resolved_type;
				if (VALA_IS_DELEGATE_TYPE (_tmp413_)) {
					ValaDelegate* d = NULL;
					ValaDataType* _tmp414_;
					ValaDelegate* _tmp415_;
					ValaDelegate* _tmp416_;
					ValaDelegate* _tmp417_;
					gboolean _tmp418_ = FALSE;
					ValaDelegate* _tmp419_;
					const gchar* _tmp420_;
					const gchar* _tmp421_;
					_tmp414_ = resolved_type;
					_tmp415_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp416_ = _tmp415_;
					_tmp417_ = _vala_code_node_ref0 (_tmp416_);
					d = _tmp417_;
					_tmp419_ = d;
					_tmp420_ = vala_symbol_get_name ((ValaSymbol*) _tmp419_);
					_tmp421_ = _tmp420_;
					if (g_strcmp0 (_tmp421_, "DestroyNotify") == 0) {
						ValaDelegate* _tmp422_;
						ValaSymbol* _tmp423_;
						ValaSymbol* _tmp424_;
						const gchar* _tmp425_;
						const gchar* _tmp426_;
						_tmp422_ = d;
						_tmp423_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp422_);
						_tmp424_ = _tmp423_;
						_tmp425_ = vala_symbol_get_name (_tmp424_);
						_tmp426_ = _tmp425_;
						_tmp418_ = g_strcmp0 (_tmp426_, "GLib") == 0;
					} else {
						_tmp418_ = FALSE;
					}
					if (!_tmp418_) {
						ValaGirParserParameterInfo* _tmp427_;
						ValaParameter* _tmp428_;
						gboolean _tmp429_ = FALSE;
						ValaGirParserParameterInfo* _tmp430_;
						ValaGirParserParameterInfo* _tmp432_;
						ValaParameter* _tmp433_;
						ValaDataType* _tmp434_;
						ValaDataType* _tmp435_;
						_tmp427_ = info;
						_tmp428_ = _tmp427_->param;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp428_, "CCode", "scope", "async", NULL);
						_tmp430_ = info;
						if (_tmp430_->closure_idx != -1) {
							ValaGirParserParameterInfo* _tmp431_;
							_tmp431_ = info;
							_tmp429_ = _tmp431_->destroy_idx != -1;
						} else {
							_tmp429_ = FALSE;
						}
						_tmp432_ = info;
						_tmp433_ = _tmp432_->param;
						_tmp434_ = vala_variable_get_variable_type ((ValaVariable*) _tmp433_);
						_tmp435_ = _tmp434_;
						vala_data_type_set_value_owned (_tmp435_, _tmp429_);
					}
					_vala_code_node_unref0 (d);
				}
				_vala_code_node_unref0 (resolved_type);
			} else {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp436_;
				ValaParameter* _tmp437_;
				ValaDataType* _tmp438_;
				ValaDataType* _tmp439_;
				ValaDataType* _tmp440_;
				ValaDataType* _tmp441_;
				_tmp436_ = info;
				_tmp437_ = _tmp436_->param;
				_tmp438_ = vala_variable_get_variable_type ((ValaVariable*) _tmp437_);
				_tmp439_ = _tmp438_;
				_tmp440_ = _vala_code_node_ref0 (_tmp439_);
				resolved_type = _tmp440_;
				_tmp441_ = resolved_type;
				if (VALA_IS_DELEGATE_TYPE (_tmp441_)) {
					gboolean _tmp442_ = FALSE;
					ValaGirParserParameterInfo* _tmp443_;
					ValaGirParserParameterInfo* _tmp445_;
					ValaParameter* _tmp446_;
					ValaDataType* _tmp447_;
					ValaDataType* _tmp448_;
					_tmp443_ = info;
					if (_tmp443_->closure_idx != -1) {
						ValaGirParserParameterInfo* _tmp444_;
						_tmp444_ = info;
						_tmp442_ = _tmp444_->destroy_idx != -1;
					} else {
						_tmp442_ = FALSE;
					}
					_tmp445_ = info;
					_tmp446_ = _tmp445_->param;
					_tmp447_ = vala_variable_get_variable_type ((ValaVariable*) _tmp446_);
					_tmp448_ = _tmp447_;
					vala_data_type_set_value_owned (_tmp448_, _tmp442_);
				}
				_vala_code_node_unref0 (resolved_type);
			}
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	_tmp450_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp450_)) {
		_tmp449_ = node->return_array_length_idx >= 0;
	} else {
		_tmp449_ = FALSE;
	}
	if (_tmp449_) {
		ValaSymbol* _tmp451_;
		ValaList* _tmp452_;
		gpointer _tmp453_;
		ValaGirParserParameterInfo* _tmp454_;
		_tmp451_ = s;
		_tmp452_ = parameters;
		_tmp453_ = vala_list_get (_tmp452_, node->return_array_length_idx);
		_tmp454_ = (ValaGirParserParameterInfo*) _tmp453_;
		vala_gir_parser_set_array_ccode (self, _tmp451_, _tmp454_);
		_vala_gir_parser_parameter_info_unref0 (_tmp454_);
	}
	_tmp455_ = s;
	if (VALA_IS_CALLABLE (_tmp455_)) {
		ValaSymbol* _tmp456_;
		ValaDataType* _tmp457_;
		_tmp456_ = s;
		_tmp457_ = return_type;
		vala_callable_set_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp456_, VALA_TYPE_CALLABLE, ValaCallable), _tmp457_);
	}
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (s);
}

static void
vala_gir_parser_find_parent (ValaGirParser* self,
                             const gchar* cname,
                             ValaGirParserNode* current,
                             ValaGirParserNode* * best,
                             gint* match)
{
	ValaGirParserNode* old_best = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaGirParserNode* _tmp21_;
	gint current_match = 0;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (*best != NULL);
	_tmp0_ = _vala_gir_parser_node_ref0 (*best);
	old_best = _tmp0_;
	_tmp1_ = current->symbol;
	if (VALA_IS_NAMESPACE (_tmp1_)) {
		{
			ValaArrayList* _child_list = NULL;
			ValaArrayList* _tmp2_;
			ValaArrayList* _tmp3_;
			gint _child_size = 0;
			ValaArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _child_index = 0;
			_tmp2_ = current->members;
			_tmp3_ = _vala_iterable_ref0 (_tmp2_);
			_child_list = _tmp3_;
			_tmp4_ = _child_list;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_child_size = _tmp6_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				ValaGirParserNode* child = NULL;
				ValaArrayList* _tmp9_;
				gpointer _tmp10_;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				ValaGirParserNode* _tmp13_;
				ValaSymbol* _tmp14_;
				_child_index = _child_index + 1;
				_tmp7_ = _child_index;
				_tmp8_ = _child_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _child_list;
				_tmp10_ = vala_list_get ((ValaList*) _tmp9_, _child_index);
				child = (ValaGirParserNode*) _tmp10_;
				_tmp13_ = child;
				_tmp14_ = _tmp13_->symbol;
				if (_tmp14_ == NULL) {
					_tmp12_ = TRUE;
				} else {
					ValaGirParserNode* _tmp15_;
					ValaSymbol* _tmp16_;
					_tmp15_ = child;
					_tmp16_ = _tmp15_->symbol;
					_tmp12_ = vala_gir_parser_is_container (_tmp16_);
				}
				if (_tmp12_) {
					ValaGirParserNode* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = child;
					_tmp18_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp11_ = g_str_has_prefix (cname, _tmp19_);
					_g_free0 (_tmp19_);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					ValaGirParserNode* _tmp20_;
					_tmp20_ = child;
					vala_gir_parser_find_parent (self, cname, _tmp20_, best, match);
				}
				_vala_gir_parser_node_unref0 (child);
			}
			_vala_iterable_unref0 (_child_list);
		}
	}
	_tmp21_ = old_best;
	if ((*best) != _tmp21_) {
		_vala_gir_parser_node_unref0 (old_best);
		return;
	}
	_tmp22_ = vala_gir_parser_node_get_lower_case_cprefix (current);
	_tmp23_ = _tmp22_;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp23_);
	current_match = _tmp26_;
	if (current_match > (*match)) {
		ValaGirParserNode* _tmp27_;
		*match = current_match;
		_tmp27_ = _vala_gir_parser_node_ref0 (current);
		_vala_gir_parser_node_unref0 (*best);
		*best = _tmp27_;
	}
	_vala_gir_parser_node_unref0 (old_best);
}

static gboolean
vala_gir_parser_same_gir (ValaGirParser* self,
                          ValaSymbol* gir_component,
                          ValaSymbol* sym)
{
	gchar* gir_name = NULL;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* gir_version = NULL;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceFile* _tmp16_;
	ValaSourceFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (gir_component != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_source_reference_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_source_file_get_gir_namespace (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	gir_name = _tmp6_;
	_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_source_reference_get_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_source_file_get_gir_version (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	gir_version = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_source_reference_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_source_file_get_filename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s-%s", gir_name, gir_version);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_contains (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	result = _tmp22_;
	_g_free0 (gir_version);
	_g_free0 (gir_name);
	return result;
}

static void
vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                          ValaGirParserNode* ns,
                                          ValaGirParserNode* node)
{
	gchar* ns_cprefix = NULL;
	gchar* _tmp0_;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	gchar* cname = NULL;
	gchar* _tmp3_;
	ValaParameter* first_param = NULL;
	ValaList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaParameter* _tmp14_;
	gint match = 0;
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp73_;
	const gchar* _tmp74_;
	gchar* new_name = NULL;
	ValaMethod* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	ValaGirParserNode* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	const gchar* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gboolean _tmp88_ = FALSE;
	ValaMethod* _tmp89_;
	ValaGirParserNode* _tmp90_;
	ValaSymbol* _tmp91_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_gir_parser_node_get_lower_case_cprefix (ns);
	ns_cprefix = _tmp0_;
	_tmp1_ = node->symbol;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_METHOD, ValaMethod));
	method = _tmp2_;
	_tmp3_ = vala_gir_parser_node_get_cname (node);
	cname = _tmp3_;
	first_param = NULL;
	_tmp4_ = node->parameters;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		ValaList* _tmp7_;
		gpointer _tmp8_;
		ValaGirParserParameterInfo* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		_tmp7_ = node->parameters;
		_tmp8_ = vala_list_get (_tmp7_, 0);
		_tmp9_ = (ValaGirParserParameterInfo*) _tmp8_;
		_tmp10_ = _tmp9_->param;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (first_param);
		first_param = _tmp11_;
		_vala_gir_parser_parameter_info_unref0 (_tmp9_);
	}
	_tmp14_ = first_param;
	if (_tmp14_ != NULL) {
		ValaParameter* _tmp15_;
		ValaParameterDirection _tmp16_;
		ValaParameterDirection _tmp17_;
		_tmp15_ = first_param;
		_tmp16_ = vala_parameter_get_direction (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ == VALA_PARAMETER_DIRECTION_IN;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaParameter* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp18_ = first_param;
		_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp12_ = VALA_IS_UNRESOLVED_TYPE (_tmp20_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaUnresolvedSymbol* sym = NULL;
		ValaParameter* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaUnresolvedSymbol* _tmp25_;
		ValaUnresolvedSymbol* _tmp26_;
		ValaGirParserNode* parent = NULL;
		ValaUnresolvedSymbol* _tmp27_;
		ValaGirParserNode* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		ValaGirParserNode* _tmp33_;
		_tmp21_ = first_param;
		_tmp22_ = vala_variable_get_variable_type ((ValaVariable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp25_ = _tmp24_;
		_tmp26_ = _vala_code_node_ref0 (_tmp25_);
		sym = _tmp26_;
		_tmp27_ = sym;
		_tmp28_ = vala_gir_parser_resolve_node (self, ns, _tmp27_, FALSE);
		parent = _tmp28_;
		_tmp33_ = parent;
		if (_tmp33_ != NULL) {
			ValaMethod* _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSymbol* _tmp36_;
			_tmp34_ = method;
			_tmp35_ = parent;
			_tmp36_ = _tmp35_->symbol;
			_tmp32_ = vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp34_, _tmp36_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp37_;
			ValaGirParserNode* _tmp38_;
			_tmp37_ = parent;
			_tmp38_ = _tmp37_->parent;
			_tmp31_ = _tmp38_ == ns;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValaGirParserNode* _tmp39_;
			ValaSymbol* _tmp40_;
			_tmp39_ = parent;
			_tmp40_ = _tmp39_->symbol;
			_tmp30_ = vala_gir_parser_is_container (_tmp40_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			const gchar* _tmp41_;
			ValaGirParserNode* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp41_ = cname;
			_tmp42_ = parent;
			_tmp43_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp29_ = g_str_has_prefix (_tmp41_, _tmp44_);
			_g_free0 (_tmp44_);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			gchar* new_name = NULL;
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			ValaGirParserNode* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			const gchar* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			ValaGirParserNode* _tmp58_;
			const gchar* _tmp59_;
			ValaGirParserNode* _tmp60_;
			ValaGirParserNode* _tmp61_;
			gboolean _tmp62_;
			_tmp45_ = method;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = parent;
			_tmp49_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = strlen (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = ns_cprefix;
			_tmp54_ = strlen (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = string_substring (_tmp47_, (glong) (_tmp52_ - _tmp55_), (glong) -1);
			_tmp57_ = _tmp56_;
			_g_free0 (_tmp50_);
			new_name = _tmp57_;
			_tmp58_ = parent;
			_tmp59_ = new_name;
			_tmp60_ = vala_gir_parser_node_lookup (_tmp58_, _tmp59_, FALSE, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_ == NULL;
			_vala_gir_parser_node_unref0 (_tmp61_);
			if (_tmp62_) {
				const gchar* _tmp63_;
				gchar* _tmp64_;
				ValaList* _tmp65_;
				gpointer _tmp66_;
				ValaGirParserParameterInfo* _tmp67_;
				gint _tmp68_;
				ValaMethod* _tmp69_;
				const gchar* _tmp70_;
				ValaMethod* _tmp71_;
				ValaGirParserNode* _tmp72_;
				vala_gir_parser_node_remove_member (ns, node);
				_tmp63_ = new_name;
				_tmp64_ = g_strdup (_tmp63_);
				_g_free0 (node->name);
				node->name = _tmp64_;
				_tmp65_ = node->parameters;
				_tmp66_ = vala_list_remove_at (_tmp65_, 0);
				_tmp67_ = (ValaGirParserParameterInfo*) _tmp66_;
				_vala_gir_parser_parameter_info_unref0 (_tmp67_);
				_tmp68_ = node->return_array_length_idx;
				node->return_array_length_idx = _tmp68_ - 1;
				_tmp69_ = method;
				_tmp70_ = new_name;
				vala_symbol_set_name ((ValaSymbol*) _tmp69_, _tmp70_);
				_tmp71_ = method;
				vala_method_set_binding (_tmp71_, VALA_MEMBER_BINDING_INSTANCE);
				_tmp72_ = parent;
				vala_gir_parser_node_add_member (_tmp72_, node);
			}
			_g_free0 (new_name);
			_vala_gir_parser_node_unref0 (parent);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (first_param);
			_g_free0 (cname);
			_vala_code_node_unref0 (method);
			_g_free0 (ns_cprefix);
			return;
		}
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (sym);
	}
	match = 0;
	_tmp73_ = _vala_gir_parser_node_ref0 (ns);
	parent = _tmp73_;
	_tmp74_ = cname;
	vala_gir_parser_find_parent (self, _tmp74_, ns, &parent, &match);
	_tmp75_ = method;
	_tmp76_ = vala_symbol_get_name ((ValaSymbol*) _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = parent;
	_tmp79_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = strlen (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = ns_cprefix;
	_tmp84_ = strlen (_tmp83_);
	_tmp85_ = _tmp84_;
	_tmp86_ = string_substring (_tmp77_, (glong) (_tmp82_ - _tmp85_), (glong) -1);
	_tmp87_ = _tmp86_;
	_g_free0 (_tmp80_);
	new_name = _tmp87_;
	_tmp89_ = method;
	_tmp90_ = parent;
	_tmp91_ = _tmp90_->symbol;
	if (vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp89_, _tmp91_)) {
		ValaGirParserNode* _tmp92_;
		const gchar* _tmp93_;
		ValaGirParserNode* _tmp94_;
		ValaGirParserNode* _tmp95_;
		_tmp92_ = parent;
		_tmp93_ = new_name;
		_tmp94_ = vala_gir_parser_node_lookup (_tmp92_, _tmp93_, FALSE, NULL);
		_tmp95_ = _tmp94_;
		_tmp88_ = _tmp95_ == NULL;
		_vala_gir_parser_node_unref0 (_tmp95_);
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		const gchar* _tmp96_;
		gchar* _tmp97_;
		ValaMethod* _tmp98_;
		const gchar* _tmp99_;
		ValaGirParserNode* _tmp100_;
		vala_gir_parser_node_remove_member (ns, node);
		_tmp96_ = new_name;
		_tmp97_ = g_strdup (_tmp96_);
		_g_free0 (node->name);
		node->name = _tmp97_;
		_tmp98_ = method;
		_tmp99_ = new_name;
		vala_symbol_set_name ((ValaSymbol*) _tmp98_, _tmp99_);
		_tmp100_ = parent;
		vala_gir_parser_node_add_member (_tmp100_, node);
	}
	_g_free0 (new_name);
	_vala_gir_parser_node_unref0 (parent);
	_vala_code_node_unref0 (first_param);
	_g_free0 (cname);
	_vala_code_node_unref0 (method);
	_g_free0 (ns_cprefix);
}

static void
vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                              ValaGirParserNode* node,
                                              ValaDelegate* d,
                                              ValaUnresolvedSymbol* gtype_struct_for)
{
	ValaGirParserNode* gtype_node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaGirParserNode* _tmp3_;
	ValaArrayList* nodes = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaArrayList* _tmp17_;
	ValaArrayList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (gtype_struct_for != NULL);
	_tmp0_ = node->parent;
	_tmp1_ = vala_gir_parser_resolve_node (self, _tmp0_, gtype_struct_for, FALSE);
	gtype_node = _tmp1_;
	_tmp3_ = gtype_node;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp4_ = gtype_node;
		_tmp5_ = _tmp4_->symbol;
		_tmp2_ = !VALA_IS_OBJECT_TYPE_SYMBOL (_tmp5_);
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) gtype_struct_for);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) gtype_struct_for);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_gir_parser_node_to_string (node);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("Unknown symbol `%s' for virtual method field `%s'", _tmp9_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp7_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	_tmp14_ = gtype_node;
	_tmp15_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_gir_parser_node_lookup_all (_tmp14_, _tmp16_);
	nodes = _tmp17_;
	_tmp18_ = nodes;
	if (_tmp18_ == NULL) {
		_vala_iterable_unref0 (nodes);
		_vala_gir_parser_node_unref0 (gtype_node);
		return;
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp19_;
		ValaArrayList* _tmp20_;
		gint _n_size = 0;
		ValaArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _n_index = 0;
		_tmp19_ = nodes;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_n_list = _tmp20_;
		_tmp21_ = _n_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_n_size = _tmp23_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp26_;
			gpointer _tmp27_;
			ValaGirParserNode* _tmp28_;
			_n_index = _n_index + 1;
			_tmp24_ = _n_index;
			_tmp25_ = _n_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _n_list;
			_tmp27_ = vala_list_get ((ValaList*) _tmp26_, _n_index);
			n = (ValaGirParserNode*) _tmp27_;
			_tmp28_ = n;
			if (node != _tmp28_) {
				ValaGirParserNode* _tmp29_;
				_tmp29_ = n;
				vala_gir_parser_node_process (_tmp29_, self);
			}
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp30_;
		ValaArrayList* _tmp31_;
		gint _n_size = 0;
		ValaArrayList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _n_index = 0;
		_tmp30_ = nodes;
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		_n_list = _tmp31_;
		_tmp32_ = _n_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_n_size = _tmp34_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp37_;
			gpointer _tmp38_;
			ValaGirParserNode* _tmp39_;
			ValaSymbol* sym = NULL;
			ValaGirParserNode* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			ValaSymbol* _tmp43_;
			_n_index = _n_index + 1;
			_tmp35_ = _n_index;
			_tmp36_ = _n_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _n_list;
			_tmp38_ = vala_list_get ((ValaList*) _tmp37_, _n_index);
			n = (ValaGirParserNode*) _tmp38_;
			_tmp39_ = n;
			if (_tmp39_->merged) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp40_ = n;
			_tmp41_ = _tmp40_->symbol;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			_tmp43_ = sym;
			if (VALA_IS_SIGNAL (_tmp43_)) {
				ValaSignal* sig = NULL;
				ValaSymbol* _tmp44_;
				ValaSignal* _tmp45_;
				ValaSignal* _tmp46_;
				ValaSignal* _tmp47_;
				_tmp44_ = sym;
				_tmp45_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp45_;
				_tmp46_ = sig;
				vala_signal_set_is_virtual (_tmp46_, TRUE);
				_tmp47_ = sig;
				vala_gir_parser_assume_parameter_names (self, _tmp47_, (ValaSymbol*) d, TRUE);
				_vala_code_node_unref0 (sig);
			} else {
				ValaSymbol* _tmp48_;
				_tmp48_ = sym;
				if (VALA_IS_PROPERTY (_tmp48_)) {
					ValaProperty* prop = NULL;
					ValaSymbol* _tmp49_;
					ValaProperty* _tmp50_;
					ValaProperty* _tmp51_;
					_tmp49_ = sym;
					_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_PROPERTY, ValaProperty));
					prop = _tmp50_;
					_tmp51_ = prop;
					vala_property_set_is_virtual (_tmp51_, TRUE);
					_vala_code_node_unref0 (prop);
				}
			}
			_vala_code_node_unref0 (sym);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	_vala_iterable_unref0 (nodes);
	_vala_gir_parser_node_unref0 (gtype_node);
}

static void
vala_gir_parser_process_async_method (ValaGirParser* self,
                                      ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gboolean requires_pointer = FALSE;
	gchar* finish_method_base = NULL;
	ValaMethod* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	ValaGirParserNode* finish_method_node = NULL;
	ValaGirParserNode* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	ValaGirParserNode* _tmp55_;
	ValaGirParserNode* _tmp56_;
	ValaGirParserNode* _tmp57_;
	ValaMethod* method = NULL;
	ValaMethod* _tmp78_;
	ValaMethod* _tmp79_;
	gboolean _tmp80_ = FALSE;
	ValaGirParserNode* _tmp81_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	requires_pointer = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaMethod* _tmp2_;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _param_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _param_index = 0;
		_tmp2_ = m;
		_tmp3_ = vala_callable_get_parameters ((ValaCallable*) _tmp2_);
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_param_list = _tmp4_;
		_tmp5_ = _param_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_param_size = _tmp7_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaParameter* param = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_param_index = _param_index + 1;
			_tmp8_ = _param_index;
			_tmp9_ = _param_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _param_list;
			_tmp11_ = vala_list_get (_tmp10_, _param_index);
			param = (ValaParameter*) _tmp11_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == VALA_PARAMETER_DIRECTION_IN) {
				requires_pointer = TRUE;
			} else {
				if (requires_pointer) {
					ValaParameter* _tmp15_;
					ValaParameter* _tmp16_;
					ValaDataType* _tmp17_;
					ValaDataType* _tmp18_;
					ValaParameter* _tmp19_;
					ValaParameter* _tmp20_;
					ValaDataType* _tmp21_;
					ValaDataType* _tmp22_;
					ValaPointerType* _tmp23_;
					ValaPointerType* _tmp24_;
					ValaParameter* _tmp25_;
					ValaSourceReference* _tmp26_;
					ValaSourceReference* _tmp27_;
					_tmp15_ = param;
					vala_parameter_set_direction (_tmp15_, VALA_PARAMETER_DIRECTION_IN);
					_tmp16_ = param;
					_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
					_tmp18_ = _tmp17_;
					vala_data_type_set_nullable (_tmp18_, FALSE);
					_tmp19_ = param;
					_tmp20_ = param;
					_tmp21_ = vala_variable_get_variable_type ((ValaVariable*) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = vala_pointer_type_new (_tmp22_, NULL);
					_tmp24_ = _tmp23_;
					vala_variable_set_variable_type ((ValaVariable*) _tmp19_, (ValaDataType*) _tmp24_);
					_vala_code_node_unref0 (_tmp24_);
					_tmp25_ = param;
					_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
					_tmp27_ = _tmp26_;
					vala_report_warning (_tmp27_, "Synchronous out-parameters are not supported in async methods");
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = m;
	_tmp29_ = vala_symbol_get_name ((ValaSymbol*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == NULL) {
		ValaMethod* _tmp31_;
		gchar* _tmp32_;
		_tmp31_ = m;
		_vala_assert (VALA_IS_CREATION_METHOD (_tmp31_), "m is CreationMethod");
		_tmp32_ = g_strdup ("new");
		_g_free0 (finish_method_base);
		finish_method_base = _tmp32_;
	} else {
		ValaMethod* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp33_ = m;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (g_str_has_suffix (_tmp35_, "_async")) {
			ValaMethod* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			ValaMethod* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gchar* _tmp46_;
			_tmp36_ = m;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = m;
			_tmp40_ = vala_symbol_get_name ((ValaSymbol*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = strlen (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = strlen ("_async");
			_tmp45_ = _tmp44_;
			_tmp46_ = string_substring (_tmp38_, (glong) 0, (glong) (_tmp43_ - _tmp45_));
			_g_free0 (finish_method_base);
			finish_method_base = _tmp46_;
		} else {
			ValaMethod* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp47_ = m;
			_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strdup (_tmp49_);
			_g_free0 (finish_method_base);
			finish_method_base = _tmp50_;
		}
	}
	_tmp51_ = node->parent;
	_tmp52_ = finish_method_base;
	_tmp53_ = g_strconcat (_tmp52_, "_finish", NULL);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_gir_parser_node_lookup (_tmp51_, _tmp54_, FALSE, NULL);
	_tmp56_ = _tmp55_;
	_g_free0 (_tmp54_);
	finish_method_node = _tmp56_;
	_tmp57_ = finish_method_node;
	if (_tmp57_ == NULL) {
		gchar* method_cname = NULL;
		gchar* _tmp58_;
		_tmp58_ = vala_gir_parser_node_get_finish_cname (node);
		method_cname = _tmp58_;
		{
			ValaArrayList* _n_list = NULL;
			ValaGirParserNode* _tmp59_;
			ValaArrayList* _tmp60_;
			ValaArrayList* _tmp61_;
			gint _n_size = 0;
			ValaArrayList* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gint _n_index = 0;
			_tmp59_ = node->parent;
			_tmp60_ = _tmp59_->members;
			_tmp61_ = _vala_iterable_ref0 (_tmp60_);
			_n_list = _tmp61_;
			_tmp62_ = _n_list;
			_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
			_tmp64_ = _tmp63_;
			_n_size = _tmp64_;
			_n_index = -1;
			while (TRUE) {
				gint _tmp65_;
				gint _tmp66_;
				ValaGirParserNode* n = NULL;
				ValaArrayList* _tmp67_;
				gpointer _tmp68_;
				gboolean _tmp69_ = FALSE;
				ValaGirParserNode* _tmp70_;
				ValaSymbol* _tmp71_;
				_n_index = _n_index + 1;
				_tmp65_ = _n_index;
				_tmp66_ = _n_size;
				if (!(_tmp65_ < _tmp66_)) {
					break;
				}
				_tmp67_ = _n_list;
				_tmp68_ = vala_list_get ((ValaList*) _tmp67_, _n_index);
				n = (ValaGirParserNode*) _tmp68_;
				_tmp70_ = n;
				_tmp71_ = _tmp70_->symbol;
				if (VALA_IS_METHOD (_tmp71_)) {
					ValaGirParserNode* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					const gchar* _tmp75_;
					_tmp72_ = n;
					_tmp73_ = vala_gir_parser_node_get_cname (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = method_cname;
					_tmp69_ = g_strcmp0 (_tmp74_, _tmp75_) == 0;
					_g_free0 (_tmp74_);
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					ValaGirParserNode* _tmp76_;
					ValaGirParserNode* _tmp77_;
					_tmp76_ = n;
					_tmp77_ = _vala_gir_parser_node_ref0 (_tmp76_);
					_vala_gir_parser_node_unref0 (finish_method_node);
					finish_method_node = _tmp77_;
					_vala_gir_parser_node_unref0 (n);
					break;
				}
				_vala_gir_parser_node_unref0 (n);
			}
			_vala_iterable_unref0 (_n_list);
		}
		_g_free0 (method_cname);
	}
	_tmp78_ = m;
	_tmp79_ = _vala_code_node_ref0 (_tmp78_);
	method = _tmp79_;
	_tmp81_ = finish_method_node;
	if (_tmp81_ != NULL) {
		ValaGirParserNode* _tmp82_;
		ValaSymbol* _tmp83_;
		_tmp82_ = finish_method_node;
		_tmp83_ = _tmp82_->symbol;
		_tmp80_ = VALA_IS_METHOD (_tmp83_);
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		ValaGirParserNode* _tmp84_;
		ValaMethod* finish_method = NULL;
		ValaGirParserNode* _tmp85_;
		ValaSymbol* _tmp86_;
		ValaMethod* _tmp87_;
		ValaMethod* _tmp88_;
		ValaMethod* _tmp158_;
		ValaMethod* _tmp159_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp192_;
		ValaArrayList* _tmp193_;
		ValaMethod* _tmp194_;
		ValaArrayList* _tmp195_;
		ValaMethod* _tmp196_;
		ValaSourceReference* _tmp197_;
		ValaSourceReference* _tmp198_;
		ValaGirParserNode* _tmp210_;
		ValaGirParserNode* _tmp211_;
		_tmp84_ = finish_method_node;
		vala_gir_parser_node_process (_tmp84_, self);
		_tmp85_ = finish_method_node;
		_tmp86_ = _tmp85_->symbol;
		_tmp87_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_METHOD, ValaMethod));
		finish_method = _tmp87_;
		_tmp88_ = finish_method;
		if (VALA_IS_CREATION_METHOD (_tmp88_)) {
			ValaMethod* _tmp89_;
			const gchar* _tmp90_;
			const gchar* _tmp91_;
			ValaMethod* _tmp92_;
			ValaSourceReference* _tmp93_;
			ValaSourceReference* _tmp94_;
			ValaCreationMethod* _tmp95_;
			ValaMethod* _tmp96_;
			ValaMethod* _tmp97_;
			ValaSymbolAccessibility _tmp98_;
			ValaSymbolAccessibility _tmp99_;
			ValaMethod* _tmp100_;
			ValaMethod* _tmp101_;
			ValaMethod* _tmp102_;
			gboolean _tmp103_;
			gboolean _tmp104_;
			ValaMethod* _tmp105_;
			GList* _tmp106_;
			ValaMethod* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			const gchar* _tmp114_;
			ValaMethod* _tmp137_;
			ValaSymbol* _tmp138_;
			_tmp89_ = finish_method;
			_tmp90_ = vala_creation_method_get_class_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			_tmp91_ = _tmp90_;
			_tmp92_ = m;
			_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_creation_method_new (_tmp91_, NULL, _tmp94_, NULL);
			_vala_code_node_unref0 (method);
			method = (ValaMethod*) _tmp95_;
			_tmp96_ = method;
			_tmp97_ = m;
			_tmp98_ = vala_symbol_get_access ((ValaSymbol*) _tmp97_);
			_tmp99_ = _tmp98_;
			vala_symbol_set_access ((ValaSymbol*) _tmp96_, _tmp99_);
			_tmp100_ = method;
			vala_method_set_coroutine (_tmp100_, TRUE);
			_tmp101_ = method;
			_tmp102_ = finish_method;
			_tmp103_ = vala_method_get_has_construct_function (_tmp102_);
			_tmp104_ = _tmp103_;
			vala_method_set_has_construct_function (_tmp101_, _tmp104_);
			_tmp105_ = m;
			_tmp106_ = ((ValaCodeNode*) _tmp105_)->attributes;
			{
				GList* a_collection = NULL;
				GList* a_it = NULL;
				a_collection = _tmp106_;
				for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
					ValaAttribute* _tmp107_;
					ValaAttribute* a = NULL;
					_tmp107_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
					a = _tmp107_;
					{
						ValaMethod* _tmp108_;
						ValaAttribute* _tmp109_;
						ValaAttribute* _tmp110_;
						_tmp108_ = method;
						_tmp109_ = a;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						((ValaCodeNode*) _tmp108_)->attributes = g_list_append (((ValaCodeNode*) _tmp108_)->attributes, _tmp110_);
						_vala_code_node_unref0 (a);
					}
				}
			}
			_tmp111_ = method;
			_tmp112_ = vala_gir_parser_node_get_cname (node);
			_tmp113_ = _tmp112_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp111_, "CCode", "cname", _tmp113_, NULL);
			_g_free0 (_tmp113_);
			_tmp114_ = finish_method_base;
			if (g_strcmp0 (_tmp114_, "new") == 0) {
				ValaMethod* _tmp115_;
				_tmp115_ = method;
				vala_symbol_set_name ((ValaSymbol*) _tmp115_, NULL);
			} else {
				const gchar* _tmp116_;
				_tmp116_ = finish_method_base;
				if (g_str_has_prefix (_tmp116_, "new_")) {
					ValaMethod* _tmp117_;
					ValaMethod* _tmp118_;
					const gchar* _tmp119_;
					const gchar* _tmp120_;
					gint _tmp121_;
					gint _tmp122_;
					gchar* _tmp123_;
					gchar* _tmp124_;
					_tmp117_ = method;
					_tmp118_ = m;
					_tmp119_ = vala_symbol_get_name ((ValaSymbol*) _tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = strlen ("new_");
					_tmp122_ = _tmp121_;
					_tmp123_ = string_substring (_tmp120_, (glong) _tmp122_, (glong) -1);
					_tmp124_ = _tmp123_;
					vala_symbol_set_name ((ValaSymbol*) _tmp117_, _tmp124_);
					_g_free0 (_tmp124_);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp125_;
				ValaList* _tmp126_;
				ValaList* _tmp127_;
				gint _param_size = 0;
				ValaList* _tmp128_;
				gint _tmp129_;
				gint _tmp130_;
				gint _param_index = 0;
				_tmp125_ = m;
				_tmp126_ = vala_callable_get_parameters ((ValaCallable*) _tmp125_);
				_tmp127_ = _vala_iterable_ref0 (_tmp126_);
				_param_list = _tmp127_;
				_tmp128_ = _param_list;
				_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
				_tmp130_ = _tmp129_;
				_param_size = _tmp130_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp131_;
					gint _tmp132_;
					ValaParameter* param = NULL;
					ValaList* _tmp133_;
					gpointer _tmp134_;
					ValaMethod* _tmp135_;
					ValaParameter* _tmp136_;
					_param_index = _param_index + 1;
					_tmp131_ = _param_index;
					_tmp132_ = _param_size;
					if (!(_tmp131_ < _tmp132_)) {
						break;
					}
					_tmp133_ = _param_list;
					_tmp134_ = vala_list_get (_tmp133_, _param_index);
					param = (ValaParameter*) _tmp134_;
					_tmp135_ = method;
					_tmp136_ = param;
					vala_callable_add_parameter ((ValaCallable*) _tmp135_, _tmp136_);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp137_ = method;
			_tmp138_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp137_);
			_vala_code_node_unref0 (node->symbol);
			node->symbol = _tmp138_;
		} else {
			ValaMethod* _tmp139_;
			ValaMethod* _tmp140_;
			ValaDataType* _tmp141_;
			ValaDataType* _tmp142_;
			ValaDataType* _tmp143_;
			ValaDataType* _tmp144_;
			ValaAttribute* a = NULL;
			ValaMethod* _tmp145_;
			ValaAttribute* _tmp146_;
			ValaAttribute* _tmp147_;
			gboolean _tmp148_ = FALSE;
			ValaAttribute* _tmp149_;
			gboolean _tmp153_ = FALSE;
			ValaAttribute* _tmp154_;
			_tmp139_ = method;
			_tmp140_ = finish_method;
			_tmp141_ = vala_callable_get_return_type ((ValaCallable*) _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_data_type_copy (_tmp142_);
			_tmp144_ = _tmp143_;
			vala_callable_set_return_type ((ValaCallable*) _tmp139_, _tmp144_);
			_vala_code_node_unref0 (_tmp144_);
			_tmp145_ = finish_method;
			_tmp146_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp145_, "CCode");
			_tmp147_ = _vala_code_node_ref0 (_tmp146_);
			a = _tmp147_;
			_tmp149_ = a;
			if (_tmp149_ != NULL) {
				ValaAttribute* _tmp150_;
				_tmp150_ = a;
				_tmp148_ = vala_attribute_has_argument (_tmp150_, "array_length");
			} else {
				_tmp148_ = FALSE;
			}
			if (_tmp148_) {
				ValaMethod* _tmp151_;
				ValaAttribute* _tmp152_;
				_tmp151_ = method;
				_tmp152_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp151_, "CCode", "array_length", vala_attribute_get_bool (_tmp152_, "array_length", FALSE), NULL);
			}
			_tmp154_ = a;
			if (_tmp154_ != NULL) {
				ValaAttribute* _tmp155_;
				_tmp155_ = a;
				_tmp153_ = vala_attribute_has_argument (_tmp155_, "array_null_terminated");
			} else {
				_tmp153_ = FALSE;
			}
			if (_tmp153_) {
				ValaMethod* _tmp156_;
				ValaAttribute* _tmp157_;
				_tmp156_ = method;
				_tmp157_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp156_, "CCode", "array_null_terminated", vala_attribute_get_bool (_tmp157_, "array_null_terminated", FALSE), NULL);
			}
			_vala_code_node_unref0 (a);
		}
		_tmp158_ = method;
		_tmp159_ = finish_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp158_, (ValaCodeNode*) _tmp159_, "CCode", "async_result_pos");
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp160_;
			ValaList* _tmp161_;
			ValaList* _tmp162_;
			gint _param_size = 0;
			ValaList* _tmp163_;
			gint _tmp164_;
			gint _tmp165_;
			gint _param_index = 0;
			_tmp160_ = finish_method;
			_tmp161_ = vala_callable_get_parameters ((ValaCallable*) _tmp160_);
			_tmp162_ = _vala_iterable_ref0 (_tmp161_);
			_param_list = _tmp162_;
			_tmp163_ = _param_list;
			_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
			_tmp165_ = _tmp164_;
			_param_size = _tmp165_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp166_;
				gint _tmp167_;
				ValaParameter* param = NULL;
				ValaList* _tmp168_;
				gpointer _tmp169_;
				ValaParameter* _tmp170_;
				ValaParameterDirection _tmp171_;
				ValaParameterDirection _tmp172_;
				_param_index = _param_index + 1;
				_tmp166_ = _param_index;
				_tmp167_ = _param_size;
				if (!(_tmp166_ < _tmp167_)) {
					break;
				}
				_tmp168_ = _param_list;
				_tmp169_ = vala_list_get (_tmp168_, _param_index);
				param = (ValaParameter*) _tmp169_;
				_tmp170_ = param;
				_tmp171_ = vala_parameter_get_direction (_tmp170_);
				_tmp172_ = _tmp171_;
				if (_tmp172_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaParameter* async_param = NULL;
					ValaParameter* _tmp173_;
					ValaParameter* _tmp174_;
					ValaMethod* _tmp175_;
					ValaScope* _tmp176_;
					ValaScope* _tmp177_;
					ValaParameter* _tmp178_;
					const gchar* _tmp179_;
					const gchar* _tmp180_;
					ValaSymbol* _tmp181_;
					ValaSymbol* _tmp182_;
					gboolean _tmp183_;
					ValaMethod* _tmp190_;
					ValaParameter* _tmp191_;
					_tmp173_ = param;
					_tmp174_ = vala_parameter_copy (_tmp173_);
					async_param = _tmp174_;
					_tmp175_ = method;
					_tmp176_ = vala_symbol_get_scope ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					_tmp178_ = param;
					_tmp179_ = vala_symbol_get_name ((ValaSymbol*) _tmp178_);
					_tmp180_ = _tmp179_;
					_tmp181_ = vala_scope_lookup (_tmp177_, _tmp180_);
					_tmp182_ = _tmp181_;
					_tmp183_ = _tmp182_ != NULL;
					_vala_code_node_unref0 (_tmp182_);
					if (_tmp183_) {
						ValaParameter* _tmp184_;
						ValaParameter* _tmp185_;
						const gchar* _tmp186_;
						const gchar* _tmp187_;
						gchar* _tmp188_;
						gchar* _tmp189_;
						_tmp184_ = async_param;
						_tmp185_ = async_param;
						_tmp186_ = vala_symbol_get_name ((ValaSymbol*) _tmp185_);
						_tmp187_ = _tmp186_;
						_tmp188_ = g_strconcat (_tmp187_, "_out", NULL);
						_tmp189_ = _tmp188_;
						vala_symbol_set_name ((ValaSymbol*) _tmp185_, _tmp189_);
						_g_free0 (_tmp189_);
					}
					_tmp190_ = method;
					_tmp191_ = async_param;
					vala_callable_add_parameter ((ValaCallable*) _tmp190_, _tmp191_);
					_vala_code_node_unref0 (async_param);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp192_ = g_direct_equal;
		_tmp193_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp192_);
		error_types = _tmp193_;
		_tmp194_ = finish_method;
		_tmp195_ = error_types;
		_tmp196_ = method;
		_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp196_);
		_tmp198_ = _tmp197_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp194_, (ValaCollection*) _tmp195_, _tmp198_);
		{
			ValaArrayList* _error_type_list = NULL;
			ValaArrayList* _tmp199_;
			ValaArrayList* _tmp200_;
			gint _error_type_size = 0;
			ValaArrayList* _tmp201_;
			gint _tmp202_;
			gint _tmp203_;
			gint _error_type_index = 0;
			_tmp199_ = error_types;
			_tmp200_ = _vala_iterable_ref0 (_tmp199_);
			_error_type_list = _tmp200_;
			_tmp201_ = _error_type_list;
			_tmp202_ = vala_collection_get_size ((ValaCollection*) _tmp201_);
			_tmp203_ = _tmp202_;
			_error_type_size = _tmp203_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp204_;
				gint _tmp205_;
				ValaDataType* error_type = NULL;
				ValaArrayList* _tmp206_;
				gpointer _tmp207_;
				ValaMethod* _tmp208_;
				ValaDataType* _tmp209_;
				_error_type_index = _error_type_index + 1;
				_tmp204_ = _error_type_index;
				_tmp205_ = _error_type_size;
				if (!(_tmp204_ < _tmp205_)) {
					break;
				}
				_tmp206_ = _error_type_list;
				_tmp207_ = vala_list_get ((ValaList*) _tmp206_, _error_type_index);
				error_type = (ValaDataType*) _tmp207_;
				_tmp208_ = method;
				_tmp209_ = error_type;
				vala_method_add_error_type (_tmp208_, _tmp209_);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_tmp210_ = finish_method_node;
		_tmp210_->processed = TRUE;
		_tmp211_ = finish_method_node;
		_tmp211_->merged = TRUE;
		_vala_iterable_unref0 (error_types);
		_vala_code_node_unref0 (finish_method);
	}
	_vala_code_node_unref0 (method);
	_vala_gir_parser_node_unref0 (finish_method_node);
	_g_free0 (finish_method_base);
	_vala_code_node_unref0 (m);
}

static guint
vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	guint result = 0U;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		if (!(sym != NULL)) {
			break;
		}
		_tmp1_ = builder;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) sym);
		_tmp3_ = _tmp2_;
		g_string_append (_tmp1_, _tmp3_);
		_tmp4_ = vala_unresolved_symbol_get_inner (sym);
		_tmp5_ = _tmp4_;
		sym = _tmp5_;
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	result = g_str_hash (_tmp7_);
	_g_string_free0 (builder);
	return result;
}

static gboolean
vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                         ValaUnresolvedSymbol* sym2)
{
	gboolean result = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaUnresolvedSymbol* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		if (!(sym1 != sym2)) {
			break;
		}
		if (sym1 == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = sym2 == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) sym1);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) sym2);
		_tmp4_ = _tmp3_;
		if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
			result = FALSE;
			return result;
		}
		_tmp5_ = vala_unresolved_symbol_get_inner (sym1);
		_tmp6_ = _tmp5_;
		sym1 = _tmp6_;
		_tmp7_ = vala_unresolved_symbol_get_inner (sym2);
		_tmp8_ = _tmp7_;
		sym2 = _tmp8_;
	}
	result = TRUE;
	return result;
}

static ValaGirParserNode*
vala_gir_parser_base_interface_property (ValaGirParser* self,
                                         ValaGirParserNode* prop_node)
{
	ValaClass* cl = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* _tmp3_;
	ValaGirParserNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	_tmp0_ = prop_node->parent;
	_tmp1_ = _tmp0_->symbol;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1_) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	_tmp3_ = cl;
	if (_tmp3_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (cl);
		return result;
	}
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp4_;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _type_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _type_index = 0;
		_tmp4_ = cl;
		_tmp5_ = vala_class_get_base_types (_tmp4_);
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_type_list = _tmp6_;
		_tmp7_ = _type_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_type_size = _tmp9_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaDataType* type = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaDataType* _tmp14_;
			ValaGirParserNode* base_node = NULL;
			ValaGirParserNode* _tmp15_;
			ValaDataType* _tmp16_;
			ValaUnresolvedSymbol* _tmp17_;
			ValaUnresolvedSymbol* _tmp18_;
			ValaGirParserNode* _tmp19_;
			gboolean _tmp20_ = FALSE;
			ValaGirParserNode* _tmp21_;
			_type_index = _type_index + 1;
			_tmp10_ = _type_index;
			_tmp11_ = _type_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _type_list;
			_tmp13_ = vala_list_get (_tmp12_, _type_index);
			type = (ValaDataType*) _tmp13_;
			_tmp14_ = type;
			if (!VALA_IS_UNRESOLVED_TYPE (_tmp14_)) {
				_vala_code_node_unref0 (type);
				continue;
			}
			_tmp15_ = prop_node->parent;
			_tmp16_ = type;
			_tmp17_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_gir_parser_resolve_node (self, _tmp15_, _tmp18_, FALSE);
			base_node = _tmp19_;
			_tmp21_ = base_node;
			if (_tmp21_ != NULL) {
				ValaGirParserNode* _tmp22_;
				ValaSymbol* _tmp23_;
				_tmp22_ = base_node;
				_tmp23_ = _tmp22_->symbol;
				_tmp20_ = VALA_IS_INTERFACE (_tmp23_);
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaGirParserNode* base_prop_node = NULL;
				ValaGirParserNode* _tmp24_;
				const gchar* _tmp25_;
				ValaGirParserNode* _tmp26_;
				gboolean _tmp27_ = FALSE;
				ValaGirParserNode* _tmp28_;
				_tmp24_ = base_node;
				_tmp25_ = prop_node->name;
				_tmp26_ = vala_gir_parser_node_lookup (_tmp24_, _tmp25_, FALSE, NULL);
				base_prop_node = _tmp26_;
				_tmp28_ = base_prop_node;
				if (_tmp28_ != NULL) {
					ValaGirParserNode* _tmp29_;
					ValaSymbol* _tmp30_;
					_tmp29_ = base_prop_node;
					_tmp30_ = _tmp29_->symbol;
					_tmp27_ = VALA_IS_PROPERTY (_tmp30_);
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					ValaProperty* base_property = NULL;
					ValaGirParserNode* _tmp31_;
					ValaSymbol* _tmp32_;
					ValaProperty* _tmp33_;
					gboolean _tmp34_ = FALSE;
					ValaProperty* _tmp35_;
					gboolean _tmp36_;
					gboolean _tmp37_;
					_tmp31_ = base_prop_node;
					_tmp32_ = _tmp31_->symbol;
					_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp33_;
					_tmp35_ = base_property;
					_tmp36_ = vala_property_get_is_abstract (_tmp35_);
					_tmp37_ = _tmp36_;
					if (_tmp37_) {
						_tmp34_ = TRUE;
					} else {
						ValaProperty* _tmp38_;
						gboolean _tmp39_;
						gboolean _tmp40_;
						_tmp38_ = base_property;
						_tmp39_ = vala_property_get_is_virtual (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp34_ = _tmp40_;
					}
					if (_tmp34_) {
						result = base_prop_node;
						_vala_code_node_unref0 (base_property);
						_vala_gir_parser_node_unref0 (base_node);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						_vala_code_node_unref0 (cl);
						return result;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_gir_parser_node_unref0 (base_prop_node);
			}
			_vala_gir_parser_node_unref0 (base_node);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	result = NULL;
	_vala_code_node_unref0 (cl);
	return result;
}

ValaGirParser*
vala_gir_parser_construct (GType object_type)
{
	ValaGirParser* self = NULL;
	self = (ValaGirParser*) vala_code_visitor_construct (object_type);
	return self;
}

ValaGirParser*
vala_gir_parser_new (void)
{
	return vala_gir_parser_construct (VALA_TYPE_GIR_PARSER);
}

static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}

static ValaGirParserArgument*
vala_gir_parser_argument_construct (GType object_type,
                                    ValaExpression* expression,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserArgument* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaGirParserArgument*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (expression);
	_vala_code_node_unref0 (self->expression);
	self->expression = _tmp0_;
	_tmp1_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp1_;
	return self;
}

static ValaGirParserArgument*
vala_gir_parser_argument_new (ValaExpression* expression,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_argument_construct (VALA_GIR_PARSER_TYPE_ARGUMENT, expression, source_reference);
}

static void
vala_gir_parser_value_argument_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_argument_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_argument_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_argument_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_argument_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_argument_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_argument_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserArgument * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_argument_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_argument_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserArgument ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_argument_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_argument (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecArgument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_argument (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_argument (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_argument_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}

static void
vala_gir_parser_value_take_argument (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}

static void
vala_gir_parser_argument_class_init (ValaGirParserArgumentClass * klass,
                                     gpointer klass_data)
{
	vala_gir_parser_argument_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserArgumentClass *) klass)->finalize = vala_gir_parser_argument_finalize;
}

static void
vala_gir_parser_argument_instance_init (ValaGirParserArgument * self,
                                        gpointer klass)
{
	self->used = FALSE;
	self->ref_count = 1;
}

static void
vala_gir_parser_argument_finalize (ValaGirParserArgument * obj)
{
	ValaGirParserArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->expression);
	_vala_source_reference_unref0 (self->source_reference);
}

static GType
vala_gir_parser_argument_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_argument_init, vala_gir_parser_value_argument_free_value, vala_gir_parser_value_argument_copy_value, vala_gir_parser_value_argument_peek_pointer, "p", vala_gir_parser_value_argument_collect_value, "p", vala_gir_parser_value_argument_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserArgument), 0, (GInstanceInitFunc) vala_gir_parser_argument_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_argument_type_id;
	vala_gir_parser_argument_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserArgument", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_argument_type_id;
}

static GType
vala_gir_parser_argument_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_id__volatile)) {
		GType vala_gir_parser_argument_type_id;
		vala_gir_parser_argument_type_id = vala_gir_parser_argument_get_type_once ();
		g_once_init_leave (&vala_gir_parser_argument_type_id__volatile, vala_gir_parser_argument_type_id);
	}
	return vala_gir_parser_argument_type_id__volatile;
}

static gpointer
vala_gir_parser_argument_ref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_argument_unref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_ARGUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_construct (GType object_type,
                                        const gchar* selector)
{
	ValaGirParserMetadataSet* self = NULL;
	self = (ValaGirParserMetadataSet*) vala_gir_parser_metadata_construct (object_type, "", selector, NULL);
	return self;
}

static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_new (const gchar* selector)
{
	return vala_gir_parser_metadata_set_construct (VALA_GIR_PARSER_TYPE_METADATA_SET, selector);
}

static void
vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                          ValaGirParserMetadata* metadata)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _child_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _child_index = 0;
		_tmp0_ = metadata->children;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_child_list = _tmp1_;
		_tmp2_ = _child_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp7_;
			gpointer _tmp8_;
			ValaGirParserMetadata* _tmp9_;
			_child_index = _child_index + 1;
			_tmp5_ = _child_index;
			_tmp6_ = _child_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _child_list;
			_tmp8_ = vala_list_get ((ValaList*) _tmp7_, _child_index);
			child = (ValaGirParserMetadata*) _tmp8_;
			_tmp9_ = child;
			vala_gir_parser_metadata_add_child ((ValaGirParserMetadata*) self, _tmp9_);
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp10_;
		ValaSet* _tmp11_;
		ValaSet* _tmp12_;
		ValaIterator* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp10_ = metadata->args;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_key_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaGirParserArgumentType key = 0;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaMap* _tmp18_;
			ValaGirParserArgumentType _tmp19_;
			ValaMap* _tmp20_;
			ValaGirParserArgumentType _tmp21_;
			gpointer _tmp22_;
			ValaGirParserArgument* _tmp23_;
			_tmp15_ = _key_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _key_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			key = (ValaGirParserArgumentType) ((gintptr) _tmp17_);
			_tmp18_ = ((ValaGirParserMetadata*) self)->args;
			_tmp19_ = key;
			_tmp20_ = metadata->args;
			_tmp21_ = key;
			_tmp22_ = vala_map_get (_tmp20_, (gpointer) ((gintptr) _tmp21_));
			_tmp23_ = (ValaGirParserArgument*) _tmp22_;
			vala_map_set (_tmp18_, (gpointer) ((gintptr) _tmp19_), _tmp23_);
			_vala_gir_parser_argument_unref0 (_tmp23_);
		}
		_vala_iterator_unref0 (_key_it);
	}
}

static void
vala_gir_parser_metadata_set_class_init (ValaGirParserMetadataSetClass * klass,
                                         gpointer klass_data)
{
	vala_gir_parser_metadata_set_parent_class = g_type_class_peek_parent (klass);
}

static void
vala_gir_parser_metadata_set_instance_init (ValaGirParserMetadataSet * self,
                                            gpointer klass)
{
}

static GType
vala_gir_parser_metadata_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataSet), 0, (GInstanceInitFunc) vala_gir_parser_metadata_set_instance_init, NULL };
	GType vala_gir_parser_metadata_set_type_id;
	vala_gir_parser_metadata_set_type_id = g_type_register_static (VALA_GIR_PARSER_TYPE_METADATA, "ValaGirParserMetadataSet", &g_define_type_info, 0);
	return vala_gir_parser_metadata_set_type_id;
}

static GType
vala_gir_parser_metadata_set_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_set_type_id__volatile)) {
		GType vala_gir_parser_metadata_set_type_id;
		vala_gir_parser_metadata_set_type_id = vala_gir_parser_metadata_set_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_set_type_id__volatile, vala_gir_parser_metadata_set_type_id);
	}
	return vala_gir_parser_metadata_set_type_id__volatile;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_get_empty (void)
{
	ValaGirParserMetadata* result;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp2_;
	_tmp0_ = vala_gir_parser_metadata__empty;
	if (_tmp0_ == NULL) {
		ValaGirParserMetadata* _tmp1_;
		_tmp1_ = vala_gir_parser_metadata_new ("", NULL, NULL);
		_vala_gir_parser_metadata_unref0 (vala_gir_parser_metadata__empty);
		vala_gir_parser_metadata__empty = _tmp1_;
	}
	_tmp2_ = vala_gir_parser_metadata__empty;
	result = _tmp2_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_construct (GType object_type,
                                    const gchar* pattern,
                                    const gchar* selector,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserMetadata* self = NULL;
	GPatternSpec* _tmp0_;
	gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (pattern != NULL, NULL);
	self = (ValaGirParserMetadata*) g_type_create_instance (object_type);
	_tmp0_ = g_pattern_spec_new (pattern);
	_g_pattern_spec_free0 (self->pattern_spec);
	self->pattern_spec = _tmp0_;
	_tmp1_ = g_strdup (selector);
	_g_free0 (self->selector);
	self->selector = _tmp1_;
	_tmp2_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp2_;
	return self;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_new (const gchar* pattern,
                              const gchar* selector,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_metadata_construct (VALA_GIR_PARSER_TYPE_METADATA, pattern, selector, source_reference);
}

static void
vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                    ValaGirParserMetadata* metadata)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = self->children;
	vala_collection_add ((ValaCollection*) _tmp0_, metadata);
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                      const gchar* name,
                                      const gchar* selector)
{
	ValaGirParserMetadata* _result_ = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserMetadata* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	_result_ = _tmp2_;
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp3_;
		ValaArrayList* _tmp4_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _metadata_index = 0;
		_tmp3_ = self->children;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_metadata_list = _tmp4_;
		_tmp5_ = _metadata_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_metadata_size = _tmp7_;
		_metadata_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			_metadata_index = _metadata_index + 1;
			_tmp8_ = _metadata_index;
			_tmp9_ = _metadata_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _metadata_list;
			_tmp11_ = vala_list_get ((ValaList*) _tmp10_, _metadata_index);
			metadata = (ValaGirParserMetadata*) _tmp11_;
			if (selector == NULL) {
				_tmp14_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = metadata;
				_tmp16_ = _tmp15_->selector;
				_tmp14_ = _tmp16_ == NULL;
			}
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = metadata;
				_tmp18_ = _tmp17_->selector;
				_tmp13_ = g_strcmp0 (_tmp18_, selector) == 0;
			}
			if (_tmp13_) {
				ValaGirParserMetadata* _tmp19_;
				GPatternSpec* _tmp20_;
				_tmp19_ = metadata;
				_tmp20_ = _tmp19_->pattern_spec;
				_tmp12_ = g_pattern_match_string (_tmp20_, name);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValaGirParserMetadata* _tmp21_;
				ValaGirParserMetadata* _tmp22_;
				ValaGirParserMetadata* _tmp23_;
				ValaGirParserMetadata* _tmp24_;
				_tmp21_ = metadata;
				_tmp21_->used = TRUE;
				_tmp22_ = _result_;
				_tmp23_ = vala_gir_parser_metadata_get_empty ();
				_tmp24_ = _tmp23_;
				if (_tmp22_ == _tmp24_) {
					ValaGirParserMetadata* _tmp25_;
					ValaGirParserMetadata* _tmp26_;
					_tmp25_ = metadata;
					_tmp26_ = _vala_gir_parser_metadata_ref0 (_tmp25_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp26_;
				} else {
					ValaGirParserMetadataSet* ms = NULL;
					ValaGirParserMetadata* _tmp27_;
					ValaGirParserMetadataSet* _tmp28_;
					ValaGirParserMetadataSet* _tmp29_;
					ValaGirParserMetadataSet* _tmp33_;
					ValaGirParserMetadata* _tmp34_;
					ValaGirParserMetadataSet* _tmp35_;
					ValaGirParserMetadata* _tmp36_;
					_tmp27_ = _result_;
					_tmp28_ = _vala_gir_parser_metadata_ref0 (VALA_GIR_PARSER_IS_METADATA_SET (_tmp27_) ? ((ValaGirParserMetadataSet*) _tmp27_) : NULL);
					ms = _tmp28_;
					_tmp29_ = ms;
					if (_tmp29_ == NULL) {
						ValaGirParserMetadataSet* _tmp30_;
						ValaGirParserMetadataSet* _tmp31_;
						ValaGirParserMetadata* _tmp32_;
						_tmp30_ = vala_gir_parser_metadata_set_new (selector);
						_vala_gir_parser_metadata_unref0 (ms);
						ms = _tmp30_;
						_tmp31_ = ms;
						_tmp32_ = _result_;
						vala_gir_parser_metadata_set_add_sibling (_tmp31_, _tmp32_);
					}
					_tmp33_ = ms;
					_tmp34_ = metadata;
					vala_gir_parser_metadata_set_add_sibling (_tmp33_, _tmp34_);
					_tmp35_ = ms;
					_tmp36_ = _vala_gir_parser_metadata_ref0 ((ValaGirParserMetadata*) _tmp35_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp36_;
					_vala_gir_parser_metadata_unref0 (ms);
				}
			}
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	result = _result_;
	return result;
}

static void
vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key,
                                       ValaGirParserArgument* value)
{
	ValaMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->args;
	vala_map_set (_tmp0_, (gpointer) ((gintptr) key), value);
}

static gboolean
vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key)
{
	ValaMap* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->args;
	result = vala_map_contains (_tmp0_, (gpointer) ((gintptr) key));
	return result;
}

static ValaExpression*
vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                         ValaGirParserArgumentType arg)
{
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	ValaExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaGirParserArgument* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp3_ = val;
		_tmp3_->used = TRUE;
		_tmp4_ = val;
		_tmp5_ = _tmp4_->expression;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		result = _tmp6_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}

static gchar*
vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                     ValaGirParserArgumentType arg)
{
	ValaStringLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaStringLiteral* _tmp1_;
	ValaStringLiteral* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_STRING_LITERAL (_tmp0_) ? ((ValaStringLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaStringLiteral* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = lit;
		_tmp4_ = vala_string_literal_eval (_tmp3_);
		result = _tmp4_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (lit);
	return result;
}

static gint
vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                      ValaGirParserArgumentType arg)
{
	ValaUnaryExpression* unary = NULL;
	ValaExpression* _tmp0_;
	ValaUnaryExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryExpression* _tmp3_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_UNARY_EXPRESSION (_tmp0_) ? ((ValaUnaryExpression*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	unary = _tmp1_;
	_tmp3_ = unary;
	if (_tmp3_ != NULL) {
		ValaUnaryExpression* _tmp4_;
		ValaUnaryOperator _tmp5_;
		ValaUnaryOperator _tmp6_;
		_tmp4_ = unary;
		_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == VALA_UNARY_OPERATOR_MINUS;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaIntegerLiteral* lit = NULL;
		ValaUnaryExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		_tmp7_ = unary;
		_tmp8_ = vala_unary_expression_get_inner (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (VALA_IS_INTEGER_LITERAL (_tmp9_) ? ((ValaIntegerLiteral*) _tmp9_) : NULL);
		lit = _tmp10_;
		_tmp11_ = lit;
		if (_tmp11_ != NULL) {
			ValaIntegerLiteral* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = lit;
			_tmp13_ = vala_integer_literal_get_value (_tmp12_);
			_tmp14_ = _tmp13_;
			result = -atoi (_tmp14_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaIntegerLiteral* lit = NULL;
		ValaExpression* _tmp15_;
		ValaIntegerLiteral* _tmp16_;
		ValaIntegerLiteral* _tmp17_;
		_tmp15_ = vala_gir_parser_metadata_get_expression (self, arg);
		_tmp16_ = VALA_IS_INTEGER_LITERAL (_tmp15_) ? ((ValaIntegerLiteral*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_vala_code_node_unref0 (_tmp15_);
		}
		lit = _tmp16_;
		_tmp17_ = lit;
		if (_tmp17_ != NULL) {
			ValaIntegerLiteral* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = lit;
			_tmp19_ = vala_integer_literal_get_value (_tmp18_);
			_tmp20_ = _tmp19_;
			result = atoi (_tmp20_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	}
	result = 0;
	_vala_code_node_unref0 (unary);
	return result;
}

static gboolean
vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                   ValaGirParserArgumentType arg,
                                   gboolean default_value)
{
	ValaBooleanLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	ValaBooleanLiteral* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_BOOLEAN_LITERAL (_tmp0_) ? ((ValaBooleanLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = lit;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = default_value;
	_vala_code_node_unref0 (lit);
	return result;
}

static ValaSourceReference*
vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                               ValaGirParserArgumentType arg)
{
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp3_ = val;
		_tmp4_ = _tmp3_->source_reference;
		_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
		result = _tmp5_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}

static void
vala_gir_parser_value_metadata_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_metadata_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_metadata_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_metadata_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_metadata_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadata * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_metadata_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserMetadata ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_metadata (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecMetadata* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_metadata (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_metadata (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}

static void
vala_gir_parser_value_take_metadata (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}

static void
vala_gir_parser_metadata_class_init (ValaGirParserMetadataClass * klass,
                                     gpointer klass_data)
{
	vala_gir_parser_metadata_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataClass *) klass)->finalize = vala_gir_parser_metadata_finalize;
}

static void
vala_gir_parser_metadata_instance_init (ValaGirParserMetadata * self,
                                        gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->used = FALSE;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE, NULL, NULL, VALA_GIR_PARSER_TYPE_ARGUMENT, (GBoxedCopyFunc) vala_gir_parser_argument_ref, (GDestroyNotify) vala_gir_parser_argument_unref, _tmp0_, _tmp1_, _tmp2_);
	self->args = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	self->children = _tmp5_;
	self->ref_count = 1;
}

static void
vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj)
{
	ValaGirParserMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata);
	g_signal_handlers_destroy (self);
	_g_pattern_spec_free0 (self->pattern_spec);
	_g_free0 (self->selector);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_map_unref0 (self->args);
	_vala_iterable_unref0 (self->children);
}

static GType
vala_gir_parser_metadata_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_init, vala_gir_parser_value_metadata_free_value, vala_gir_parser_value_metadata_copy_value, vala_gir_parser_value_metadata_peek_pointer, "p", vala_gir_parser_value_metadata_collect_value, "p", vala_gir_parser_value_metadata_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadata), 0, (GInstanceInitFunc) vala_gir_parser_metadata_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_metadata_type_id;
	vala_gir_parser_metadata_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadata", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_metadata_type_id;
}

static GType
vala_gir_parser_metadata_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_type_id__volatile)) {
		GType vala_gir_parser_metadata_type_id;
		vala_gir_parser_metadata_type_id = vala_gir_parser_metadata_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_type_id__volatile, vala_gir_parser_metadata_type_id);
	}
	return vala_gir_parser_metadata_type_id__volatile;
}

static gpointer
vala_gir_parser_metadata_ref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_metadata_unref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
vala_gir_parser_metadata_parser_get_instance_private (ValaGirParserMetadataParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGirParserMetadataParser_private_offset);
}

static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_construct (GType object_type)
{
	ValaGirParserMetadataParser* self = NULL;
	ValaGirParserMetadata* _tmp0_;
	self = (ValaGirParserMetadataParser*) g_type_create_instance (object_type);
	_tmp0_ = self->priv->tree;
	_tmp0_->used = TRUE;
	return self;
}

static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_new (void)
{
	return vala_gir_parser_metadata_parser_construct (VALA_GIR_PARSER_TYPE_METADATA_PARSER);
}

static ValaSourceReference*
vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self)
{
	ValaScanner* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_scanner_get_source_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (_tmp2_, &_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}

static ValaSourceReference*
vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                         ValaSourceLocation* begin,
                                         ValaSourceLocation* end)
{
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_scanner_get_source_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *begin;
	_tmp5_ = e;
	_tmp6_ = vala_source_reference_new (_tmp3_, &_tmp4_, &_tmp5_);
	result = _tmp6_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                ValaSourceFile* metadata_file)
{
	ValaScanner* _tmp0_;
	ValaGirParserMetadata* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	ValaGirParserMetadata* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (metadata_file != NULL, NULL);
	_tmp0_ = vala_scanner_new (metadata_file);
	_vala_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp0_;
	vala_gir_parser_metadata_parser_next (self);
	while (TRUE) {
		ValaTokenType _tmp1_;
		_tmp1_ = self->priv->current;
		if (!(_tmp1_ != VALA_TOKEN_TYPE_EOF)) {
			break;
		}
		if (!vala_gir_parser_metadata_parser_parse_rule (self)) {
			ValaGirParserMetadata* _tmp2_;
			ValaGirParserMetadata* _tmp3_;
			ValaGirParserMetadata* _tmp4_;
			_tmp2_ = vala_gir_parser_metadata_get_empty ();
			_tmp3_ = _tmp2_;
			_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = self->priv->tree;
	_tmp6_ = _vala_gir_parser_metadata_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static ValaTokenType
vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaTokenType _tmp4_;
	ValaTokenType _tmp5_;
	ValaTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->end;
	self->priv->old_end = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp4_ = vala_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->begin = _tmp2_;
	self->priv->end = _tmp3_;
	self->priv->current = _tmp4_;
	_tmp5_ = self->priv->current;
	result = _tmp5_;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = _tmp0_.pos;
	_tmp2_ = self->priv->begin;
	_tmp3_ = _tmp2_.pos;
	result = _tmp1_ != _tmp3_;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	ValaSourceLocation _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = self->priv->begin;
	result = _tmp0_.line != _tmp1_.line;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                            ValaSourceLocation* begin,
                                            ValaSourceLocation* end)
{
	ValaSourceLocation b = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_;
	gchar* _tmp5_;
	ValaSourceLocation _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	b = _tmp0_;
	_tmp1_ = self->priv->end;
	e = _tmp1_;
	if (begin != NULL) {
		b = *begin;
	}
	if (end != NULL) {
		e = *end;
	}
	_tmp2_ = b;
	_tmp3_ = _tmp2_.pos;
	_tmp4_ = e;
	_tmp5_ = _tmp4_.pos;
	_tmp6_ = b;
	_tmp7_ = _tmp6_.pos;
	_tmp8_ = string_substring ((const gchar*) _tmp3_, (glong) 0, (glong) ((gint) (_tmp5_ - _tmp7_)));
	result = _tmp8_;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                  gboolean is_glob)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaTokenType _tmp2_;
	ValaSourceLocation _tmp15_;
	ValaSourceLocation _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp2_ = self->priv->current;
	if (_tmp2_ == VALA_TOKEN_TYPE_DOT) {
		_tmp1_ = TRUE;
	} else {
		ValaTokenType _tmp3_;
		_tmp3_ = self->priv->current;
		_tmp1_ = _tmp3_ == VALA_TOKEN_TYPE_HASH;
	}
	if (_tmp1_) {
		if (is_glob) {
			ValaSourceLocation _tmp4_;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			_tmp4_ = begin;
			_tmp5_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp4_, NULL);
			_tmp6_ = _tmp5_;
			vala_report_error (_tmp6_, "expected glob-style pattern");
			_vala_source_reference_unref0 (_tmp6_);
		} else {
			ValaSourceLocation _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			_tmp7_ = begin;
			_tmp8_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp7_, NULL);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "expected identifier");
			_vala_source_reference_unref0 (_tmp9_);
		}
		result = NULL;
		return result;
	}
	if (is_glob) {
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaTokenType _tmp12_;
			_tmp12_ = self->priv->current;
			if (_tmp12_ != VALA_TOKEN_TYPE_EOF) {
				ValaTokenType _tmp13_;
				_tmp13_ = self->priv->current;
				_tmp11_ = _tmp13_ != VALA_TOKEN_TYPE_DOT;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaTokenType _tmp14_;
				_tmp14_ = self->priv->current;
				_tmp10_ = _tmp14_ != VALA_TOKEN_TYPE_HASH;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			vala_gir_parser_metadata_parser_next (self);
			if (vala_gir_parser_metadata_parser_has_space (self)) {
				break;
			}
		}
	} else {
		vala_gir_parser_metadata_parser_next (self);
	}
	_tmp15_ = begin;
	_tmp16_ = self->priv->old_end;
	_tmp17_ = vala_gir_parser_metadata_parser_get_string (self, &_tmp15_, &_tmp16_);
	result = _tmp17_;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self)
{
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	gchar* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->current;
	if (_tmp1_ != VALA_TOKEN_TYPE_HASH) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_gir_parser_metadata_parser_has_space (self);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	vala_gir_parser_metadata_parser_next (self);
	_tmp2_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
	result = _tmp2_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self)
{
	ValaGirParserMetadata* metadata = NULL;
	gboolean is_relative = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	ValaGirParserMetadata* _tmp12_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp15_;
	gchar* pattern = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaSourceLocation _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaGirParserMetadata* _tmp24_;
	ValaGirParserMetadata* _tmp25_;
	ValaGirParserMetadata* _tmp26_;
	ValaGirParserMetadata* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	is_relative = FALSE;
	_tmp1_ = self->priv->current;
	if (_tmp1_ == VALA_TOKEN_TYPE_IDENTIFIER) {
		_tmp0_ = TRUE;
	} else {
		ValaTokenType _tmp2_;
		_tmp2_ = self->priv->current;
		_tmp0_ = _tmp2_ == VALA_TOKEN_TYPE_STAR;
	}
	if (_tmp0_) {
		ValaGirParserMetadata* _tmp3_;
		ValaGirParserMetadata* _tmp4_;
		_tmp3_ = self->priv->tree;
		_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp4_;
	} else {
		ValaTokenType _tmp5_;
		_tmp5_ = self->priv->current;
		if (_tmp5_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaTokenType _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->current;
			_tmp9_ = vala_token_type_to_string (_tmp8_);
			_tmp10_ = g_strdup_printf ("expected pattern or `.', got %s", _tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp7_, _tmp11_);
			_g_free0 (_tmp11_);
			_vala_source_reference_unref0 (_tmp7_);
			result = NULL;
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		vala_gir_parser_metadata_parser_next (self);
		is_relative = TRUE;
	}
	_tmp12_ = self->priv->parent_metadata;
	if (_tmp12_ == NULL) {
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp13_ = vala_gir_parser_metadata_parser_get_current_src (self);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "cannot determinate parent metadata");
		_vala_source_reference_unref0 (_tmp14_);
		result = NULL;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp15_ = self->priv->begin;
	begin = _tmp15_;
	_tmp16_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
	pattern = _tmp16_;
	_tmp17_ = pattern;
	if (_tmp17_ == NULL) {
		result = NULL;
		_g_free0 (pattern);
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp18_ = pattern;
	_tmp19_ = vala_gir_parser_metadata_parser_parse_selector (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = begin;
	_tmp22_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_gir_parser_metadata_new (_tmp18_, _tmp20_, _tmp23_);
	_vala_gir_parser_metadata_unref0 (metadata);
	metadata = _tmp24_;
	_vala_source_reference_unref0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp25_ = self->priv->parent_metadata;
	_tmp26_ = metadata;
	vala_gir_parser_metadata_add_child (_tmp25_, _tmp26_);
	while (TRUE) {
		gboolean _tmp27_ = FALSE;
		ValaTokenType _tmp28_;
		ValaTokenType _tmp29_;
		ValaSourceLocation _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		ValaGirParserMetadata* child = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValaSourceLocation _tmp42_;
		ValaSourceLocation _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaGirParserMetadata* _tmp46_;
		ValaGirParserMetadata* _tmp47_;
		ValaGirParserMetadata* _tmp48_;
		ValaGirParserMetadata* _tmp49_;
		ValaGirParserMetadata* _tmp50_;
		ValaGirParserMetadata* _tmp51_;
		_tmp28_ = self->priv->current;
		if (_tmp28_ != VALA_TOKEN_TYPE_EOF) {
			_tmp27_ = !vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp27_ = FALSE;
		}
		if (!_tmp27_) {
			break;
		}
		_tmp29_ = self->priv->current;
		if (_tmp29_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaTokenType _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp30_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->current;
			_tmp33_ = vala_token_type_to_string (_tmp32_);
			_tmp34_ = g_strdup_printf ("expected `.' got %s", _tmp33_);
			_tmp35_ = _tmp34_;
			vala_report_error (_tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
			_vala_source_reference_unref0 (_tmp31_);
			break;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp36_ = self->priv->begin;
		begin = _tmp36_;
		_tmp37_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
		_g_free0 (pattern);
		pattern = _tmp37_;
		_tmp38_ = pattern;
		if (_tmp38_ == NULL) {
			result = NULL;
			_g_free0 (pattern);
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		_tmp39_ = pattern;
		_tmp40_ = vala_gir_parser_metadata_parser_parse_selector (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = begin;
		_tmp43_ = self->priv->old_end;
		_tmp44_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp42_, &_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_gir_parser_metadata_new (_tmp39_, _tmp41_, _tmp45_);
		_tmp47_ = _tmp46_;
		_vala_source_reference_unref0 (_tmp45_);
		_g_free0 (_tmp41_);
		child = _tmp47_;
		_tmp48_ = metadata;
		_tmp49_ = child;
		vala_gir_parser_metadata_add_child (_tmp48_, _tmp49_);
		_tmp50_ = child;
		_tmp51_ = _vala_gir_parser_metadata_ref0 (_tmp50_);
		_vala_gir_parser_metadata_unref0 (metadata);
		metadata = _tmp51_;
		_vala_gir_parser_metadata_unref0 (child);
	}
	if (!is_relative) {
		ValaGirParserMetadata* _tmp52_;
		ValaGirParserMetadata* _tmp53_;
		_tmp52_ = metadata;
		_tmp53_ = _vala_gir_parser_metadata_ref0 (_tmp52_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp53_;
	}
	result = metadata;
	_g_free0 (pattern);
	return result;
}

static ValaExpression*
vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceReference* src = NULL;
	ValaSourceReference* _tmp1_;
	ValaExpression* expr = NULL;
	ValaTokenType _tmp2_;
	ValaExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_get_current_src (self);
	src = _tmp1_;
	expr = NULL;
	_tmp2_ = self->priv->current;
	switch (_tmp2_) {
		case VALA_TOKEN_TYPE_NULL:
		{
			ValaSourceReference* _tmp3_;
			ValaNullLiteral* _tmp4_;
			_tmp3_ = src;
			_tmp4_ = vala_null_literal_new (_tmp3_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp4_;
			break;
		}
		case VALA_TOKEN_TYPE_TRUE:
		{
			ValaSourceReference* _tmp5_;
			ValaBooleanLiteral* _tmp6_;
			_tmp5_ = src;
			_tmp6_ = vala_boolean_literal_new (TRUE, _tmp5_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp6_;
			break;
		}
		case VALA_TOKEN_TYPE_FALSE:
		{
			ValaSourceReference* _tmp7_;
			ValaBooleanLiteral* _tmp8_;
			_tmp7_ = src;
			_tmp8_ = vala_boolean_literal_new (FALSE, _tmp7_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp8_;
			break;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			ValaExpression* inner = NULL;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			vala_gir_parser_metadata_parser_next (self);
			_tmp9_ = vala_gir_parser_metadata_parser_parse_expression (self);
			inner = _tmp9_;
			_tmp10_ = inner;
			if (_tmp10_ == NULL) {
				ValaSourceReference* _tmp11_;
				ValaTokenType _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = src;
				_tmp12_ = self->priv->current;
				_tmp13_ = vala_token_type_to_string (_tmp12_);
				_tmp14_ = g_strdup_printf ("expected expression after `-', got %s", _tmp13_);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp11_, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				ValaExpression* _tmp16_;
				ValaSourceLocation _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaUnaryExpression* _tmp20_;
				_tmp16_ = inner;
				_tmp17_ = begin;
				_tmp18_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp17_, NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, _tmp16_, _tmp19_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp20_;
				_vala_source_reference_unref0 (_tmp19_);
			}
			result = expr;
			_vala_code_node_unref0 (inner);
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		{
			gchar* _tmp21_;
			gchar* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaIntegerLiteral* _tmp24_;
			_tmp21_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = src;
			_tmp24_ = vala_integer_literal_new (_tmp22_, _tmp23_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp24_;
			_g_free0 (_tmp22_);
			break;
		}
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaRealLiteral* _tmp28_;
			_tmp25_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = src;
			_tmp28_ = vala_real_literal_new (_tmp26_, _tmp27_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp28_;
			_g_free0 (_tmp26_);
			break;
		}
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaStringLiteral* _tmp32_;
			_tmp29_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = src;
			_tmp32_ = vala_string_literal_new (_tmp30_, _tmp31_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp32_;
			_g_free0 (_tmp30_);
			break;
		}
		case VALA_TOKEN_TYPE_IDENTIFIER:
		{
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaMemberAccess* _tmp36_;
			_tmp33_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = src;
			_tmp36_ = vala_member_access_new (NULL, _tmp34_, _tmp35_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp36_;
			_g_free0 (_tmp34_);
			while (TRUE) {
				ValaExpression* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaMemberAccess* _tmp48_;
				if (!(vala_gir_parser_metadata_parser_next (self) == VALA_TOKEN_TYPE_DOT)) {
					break;
				}
				if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_IDENTIFIER) {
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaTokenType _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp37_ = vala_gir_parser_metadata_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = self->priv->current;
					_tmp40_ = vala_token_type_to_string (_tmp39_);
					_tmp41_ = g_strdup_printf ("expected identifier got %s", _tmp40_);
					_tmp42_ = _tmp41_;
					vala_report_error (_tmp38_, _tmp42_);
					_g_free0 (_tmp42_);
					_vala_source_reference_unref0 (_tmp38_);
					break;
				}
				_tmp43_ = expr;
				_tmp44_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_member_access_new (_tmp43_, _tmp45_, _tmp47_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp48_;
				_vala_source_reference_unref0 (_tmp47_);
				_g_free0 (_tmp45_);
			}
			result = expr;
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaSourceReference* _tmp55_;
			ValaTuple* _tmp56_;
			if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaTokenType _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp49_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = self->priv->current;
				_tmp52_ = vala_token_type_to_string (_tmp51_);
				_tmp53_ = g_strdup_printf ("expected `)', got %s", _tmp52_);
				_tmp54_ = _tmp53_;
				vala_report_error (_tmp50_, _tmp54_);
				_g_free0 (_tmp54_);
				_vala_source_reference_unref0 (_tmp50_);
				break;
			}
			_tmp55_ = src;
			_tmp56_ = vala_tuple_new (_tmp55_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp56_;
			break;
		}
		default:
		{
			ValaSourceReference* _tmp57_;
			ValaTokenType _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp57_ = src;
			_tmp58_ = self->priv->current;
			_tmp59_ = vala_token_type_to_string (_tmp58_);
			_tmp60_ = g_strdup_printf ("expected literal or symbol got %s", _tmp59_);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp57_, _tmp61_);
			_g_free0 (_tmp61_);
			break;
		}
	}
	vala_gir_parser_metadata_parser_next (self);
	result = expr;
	_vala_source_reference_unref0 (src);
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                            ValaGirParserMetadata* metadata)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (metadata != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		ValaTokenType _tmp2_;
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp3_;
		gchar* id = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		ValaGirParserArgumentType* arg_type = NULL;
		const gchar* _tmp6_;
		ValaGirParserArgumentType* _tmp7_;
		ValaGirParserArgumentType* _tmp8_;
		ValaTokenType _tmp16_;
		ValaExpression* expr = NULL;
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaGirParserArgumentType* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceLocation _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaGirParserArgument* _tmp35_;
		ValaGirParserArgument* _tmp36_;
		_tmp2_ = self->priv->current;
		if (_tmp2_ != VALA_TOKEN_TYPE_EOF) {
			_tmp1_ = vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = !vala_gir_parser_metadata_parser_has_newline (self);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = self->priv->begin;
		begin = _tmp3_;
		_tmp4_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
		id = _tmp4_;
		_tmp5_ = id;
		if (_tmp5_ == NULL) {
			result = FALSE;
			_g_free0 (id);
			return result;
		}
		_tmp6_ = id;
		_tmp7_ = vala_gir_parser_argument_type_from_string (_tmp6_);
		arg_type = _tmp7_;
		_tmp8_ = arg_type;
		if (_tmp8_ == NULL) {
			ValaSourceLocation _tmp9_;
			ValaSourceLocation _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = begin;
			_tmp10_ = self->priv->old_end;
			_tmp11_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp9_, &_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = id;
			_tmp14_ = g_strdup_printf ("unknown argument `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_warning (_tmp12_, _tmp15_);
			_g_free0 (_tmp15_);
			_vala_source_reference_unref0 (_tmp12_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		_tmp16_ = self->priv->current;
		if (_tmp16_ != VALA_TOKEN_TYPE_ASSIGN) {
			ValaGirParserArgumentType* _tmp17_;
			ValaSourceLocation _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaBooleanLiteral* _tmp21_;
			ValaBooleanLiteral* _tmp22_;
			ValaSourceLocation _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaGirParserArgument* _tmp26_;
			ValaGirParserArgument* _tmp27_;
			_tmp17_ = arg_type;
			_tmp18_ = begin;
			_tmp19_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_boolean_literal_new (TRUE, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = begin;
			_tmp24_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_gir_parser_argument_new ((ValaExpression*) _tmp22_, _tmp25_);
			_tmp27_ = _tmp26_;
			vala_gir_parser_metadata_add_argument (metadata, *_tmp17_, _tmp27_);
			_vala_gir_parser_argument_unref0 (_tmp27_);
			_vala_source_reference_unref0 (_tmp25_);
			_vala_code_node_unref0 (_tmp22_);
			_vala_source_reference_unref0 (_tmp20_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp28_ = vala_gir_parser_metadata_parser_parse_expression (self);
		expr = _tmp28_;
		_tmp29_ = expr;
		if (_tmp29_ == NULL) {
			result = FALSE;
			_vala_code_node_unref0 (expr);
			_g_free0 (arg_type);
			_g_free0 (id);
			return result;
		}
		_tmp30_ = arg_type;
		_tmp31_ = expr;
		_tmp32_ = begin;
		_tmp33_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_gir_parser_argument_new (_tmp31_, _tmp34_);
		_tmp36_ = _tmp35_;
		vala_gir_parser_metadata_add_argument (metadata, *_tmp30_, _tmp36_);
		_vala_gir_parser_argument_unref0 (_tmp36_);
		_vala_source_reference_unref0 (_tmp34_);
		_vala_code_node_unref0 (expr);
		_g_free0 (arg_type);
		_g_free0 (id);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation old_end = {0};
	ValaSourceLocation _tmp0_;
	ValaGirParserMetadata* metadata = NULL;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaTokenType _tmp4_;
	ValaGirParserMetadata* _tmp7_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->end;
	old_end = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_parse_pattern (self);
	metadata = _tmp1_;
	_tmp2_ = metadata;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp4_ = self->priv->current;
	if (_tmp4_ == VALA_TOKEN_TYPE_EOF) {
		_tmp3_ = TRUE;
	} else {
		ValaSourceLocation _tmp5_;
		ValaSourceLocation _tmp6_;
		_tmp5_ = old_end;
		_tmp6_ = self->priv->end;
		_tmp3_ = _tmp5_.line != _tmp6_.line;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp7_ = metadata;
	result = vala_gir_parser_metadata_parser_parse_args (self, _tmp7_);
	_vala_gir_parser_metadata_unref0 (metadata);
	return result;
}

static void
vala_gir_parser_value_metadata_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_metadata_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_parser_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_metadata_parser_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_metadata_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_metadata_parser_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadataParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_metadata_parser_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	ValaGirParserMetadataParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	ValaGirParserParamSpecMetadataParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_metadata_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_metadata_parser (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}

static void
vala_gir_parser_value_take_metadata_parser (GValue* value,
                                            gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}

static void
vala_gir_parser_metadata_parser_class_init (ValaGirParserMetadataParserClass * klass,
                                            gpointer klass_data)
{
	vala_gir_parser_metadata_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataParserClass *) klass)->finalize = vala_gir_parser_metadata_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGirParserMetadataParser_private_offset);
}

static void
vala_gir_parser_metadata_parser_instance_init (ValaGirParserMetadataParser * self,
                                               gpointer klass)
{
	ValaGirParserMetadata* _tmp0_;
	self->priv = vala_gir_parser_metadata_parser_get_instance_private (self);
	_tmp0_ = vala_gir_parser_metadata_new ("", NULL, NULL);
	self->priv->tree = _tmp0_;
	self->ref_count = 1;
}

static void
vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj)
{
	ValaGirParserMetadataParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser);
	g_signal_handlers_destroy (self);
	_vala_gir_parser_metadata_unref0 (self->priv->tree);
	_vala_scanner_unref0 (self->priv->scanner);
	_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
}

static GType
vala_gir_parser_metadata_parser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_parser_init, vala_gir_parser_value_metadata_parser_free_value, vala_gir_parser_value_metadata_parser_copy_value, vala_gir_parser_value_metadata_parser_peek_pointer, "p", vala_gir_parser_value_metadata_parser_collect_value, "p", vala_gir_parser_value_metadata_parser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataParser), 0, (GInstanceInitFunc) vala_gir_parser_metadata_parser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_metadata_parser_type_id;
	vala_gir_parser_metadata_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadataParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaGirParserMetadataParser_private_offset = g_type_add_instance_private (vala_gir_parser_metadata_parser_type_id, sizeof (ValaGirParserMetadataParserPrivate));
	return vala_gir_parser_metadata_parser_type_id;
}

static GType
vala_gir_parser_metadata_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_parser_type_id__volatile)) {
		GType vala_gir_parser_metadata_parser_type_id;
		vala_gir_parser_metadata_parser_type_id = vala_gir_parser_metadata_parser_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_parser_type_id__volatile, vala_gir_parser_metadata_parser_type_id);
	}
	return vala_gir_parser_metadata_parser_type_id__volatile;
}

static gpointer
vala_gir_parser_metadata_parser_ref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_metadata_parser_unref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserNode*
vala_gir_parser_node_construct (GType object_type,
                                const gchar* name)
{
	ValaGirParserNode* self = NULL;
	gchar* _tmp0_;
	self = (ValaGirParserNode*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}

static ValaGirParserNode*
vala_gir_parser_node_new (const gchar* name)
{
	return vala_gir_parser_node_construct (VALA_GIR_PARSER_TYPE_NODE, name);
}

static void
vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                 ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaHashMap* _tmp6_;
		const gchar* _tmp7_;
		ValaArrayList* _tmp8_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp4_);
		_vala_iterable_unref0 (nodes);
		nodes = _tmp5_;
		_tmp6_ = self->scope;
		_tmp7_ = node->name;
		_tmp8_ = nodes;
		vala_map_set ((ValaMap*) _tmp6_, _tmp7_, _tmp8_);
	}
	_tmp9_ = nodes;
	vala_collection_add ((ValaCollection*) _tmp9_, node);
	_tmp10_ = self->members;
	vala_collection_add ((ValaCollection*) _tmp10_, node);
	node->parent = self;
	_vala_iterable_unref0 (nodes);
}

static void
vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                    ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ValaArrayList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	vala_collection_remove ((ValaCollection*) _tmp3_, node);
	_tmp4_ = nodes;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		ValaHashMap* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->scope;
		_tmp8_ = node->name;
		vala_map_remove ((ValaMap*) _tmp7_, _tmp8_);
	}
	_tmp9_ = self->members;
	vala_collection_remove ((ValaCollection*) _tmp9_, node);
	node->parent = NULL;
	_vala_iterable_unref0 (nodes);
}

static ValaGirParserNode*
vala_gir_parser_node_lookup (ValaGirParserNode* self,
                             const gchar* name,
                             gboolean create_namespace,
                             ValaSourceReference* source_reference)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserNode* node = NULL;
	ValaArrayList* _tmp2_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	nodes = (ValaArrayList*) _tmp1_;
	node = NULL;
	_tmp2_ = nodes;
	if (_tmp2_ != NULL) {
		ValaArrayList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = nodes;
		_tmp4_ = vala_list_get ((ValaList*) _tmp3_, 0);
		_vala_gir_parser_node_unref0 (node);
		node = (ValaGirParserNode*) _tmp4_;
	}
	_tmp5_ = node;
	if (_tmp5_ == NULL) {
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp6_;
		gboolean _tmp11_ = FALSE;
		ValaSymbol* _tmp12_;
		sym = NULL;
		_tmp6_ = self->symbol;
		if (_tmp6_ != NULL) {
			ValaSymbol* _tmp7_;
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			ValaSymbol* _tmp10_;
			_tmp7_ = self->symbol;
			_tmp8_ = vala_symbol_get_scope (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_scope_lookup (_tmp9_, name);
			_vala_code_node_unref0 (sym);
			sym = _tmp10_;
		}
		_tmp12_ = sym;
		if (_tmp12_ != NULL) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = create_namespace;
		}
		if (_tmp11_) {
			ValaGirParserNode* _tmp13_;
			ValaGirParserNode* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaGirParserNode* _tmp17_;
			ValaGirParserNode* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaGirParserNode* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaGirParserNode* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp13_ = vala_gir_parser_node_new (name);
			_vala_gir_parser_node_unref0 (node);
			node = _tmp13_;
			_tmp14_ = node;
			_tmp15_ = sym;
			_tmp16_ = _vala_code_node_ref0 (_tmp15_);
			_vala_code_node_unref0 (_tmp14_->symbol);
			_tmp14_->symbol = _tmp16_;
			_tmp17_ = node;
			_tmp18_ = node;
			_tmp19_ = _tmp18_->symbol;
			_tmp17_->new_symbol = _tmp19_ == NULL;
			_tmp20_ = node;
			_tmp21_ = _vala_source_reference_ref0 (source_reference);
			_vala_source_reference_unref0 (_tmp20_->source_reference);
			_tmp20_->source_reference = _tmp21_;
			_tmp22_ = node;
			vala_gir_parser_node_add_member (self, _tmp22_);
			_tmp23_ = sym;
			if (_tmp23_ == NULL) {
				ValaArrayList* _tmp24_;
				ValaGirParserNode* _tmp25_;
				_tmp24_ = vala_gir_parser_node_new_namespaces;
				_tmp25_ = node;
				vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = node;
	_vala_iterable_unref0 (nodes);
	return result;
}

static ValaArrayList*
vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                 const gchar* name)
{
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaArrayList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	result = (ValaArrayList*) _tmp1_;
	return result;
}

static ValaUnresolvedSymbol*
vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	ValaUnresolvedSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		ValaUnresolvedSymbol* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = vala_unresolved_symbol_new (NULL, _tmp2_, NULL);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		const gchar* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_unresolved_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = vala_unresolved_symbol_new (_tmp6_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}

static gchar*
vala_gir_parser_node_get_full_name (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp3_;
	ValaGirParserNode* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ValaGirParserNode* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->name;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->name;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_full_name (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = vala_gir_parser_node_get_full_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ == NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->name;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = self->parent;
	_tmp13_ = vala_gir_parser_node_get_full_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->name;
	_tmp16_ = g_strdup_printf ("%s.%s", _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp14_);
	result = _tmp17_;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self)
{
	GString* default_name = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	default_name = _tmp0_;
	{
		ValaGirParserNode* node = NULL;
		node = self;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp4_;
				ValaGirParserNode* _tmp5_;
				ValaSymbol* _tmp6_;
				GString* _tmp12_;
				ValaGirParserNode* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp1_) {
					ValaGirParserNode* _tmp2_;
					ValaGirParserNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->parent;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = node;
				_tmp6_ = _tmp5_->symbol;
				if (VALA_IS_NAMESPACE (_tmp6_)) {
					ValaGirParserNode* _tmp7_;
					ValaSymbol* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_;
					_tmp7_ = node;
					_tmp8_ = _tmp7_->symbol;
					_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "gir_namespace", NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_ != NULL;
					_g_free0 (_tmp10_);
					if (_tmp11_) {
						break;
					}
				}
				_tmp12_ = default_name;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->name;
				g_string_prepend (_tmp12_, _tmp14_);
			}
		}
	}
	_tmp15_ = default_name;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (default_name);
	return result;
}

static gchar*
vala_gir_parser_node_get_gir_name (ValaGirParserNode* self)
{
	gchar* gir_name = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->girdata;
	_tmp1_ = vala_map_get (_tmp0_, "name");
	gir_name = (gchar*) _tmp1_;
	_tmp2_ = gir_name;
	if (_tmp2_ == NULL) {
		ValaMap* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->girdata;
		_tmp4_ = vala_map_get (_tmp3_, "glib:name");
		_g_free0 (gir_name);
		gir_name = (gchar*) _tmp4_;
	}
	result = gir_name;
	return result;
}

static gchar*
vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaSymbol* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	const gchar* _tmp46_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp2_, "CCode", "lower_case_cprefix", NULL);
	prefix = _tmp3_;
	_tmp5_ = prefix;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		_tmp7_ = self->symbol;
		if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp7_)) {
			_tmp6_ = TRUE;
		} else {
			ValaSymbol* _tmp8_;
			_tmp8_ = self->symbol;
			_tmp6_ = VALA_IS_STRUCT (_tmp8_);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaGirParserMetadata* _tmp9_;
		_tmp9_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp9_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
			ValaGirParserMetadata* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->metadata;
			_tmp11_ = vala_gir_parser_metadata_get_string (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
			_g_free0 (prefix);
			prefix = _tmp11_;
		} else {
			ValaGirParserMetadata* _tmp12_;
			_tmp12_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = self->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
				_g_free0 (prefix);
				prefix = _tmp14_;
			} else {
				ValaSymbol* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = self->symbol;
				_tmp16_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp15_, "CCode", "cprefix", NULL);
				_g_free0 (prefix);
				prefix = _tmp16_;
			}
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		ValaMap* _tmp20_;
		_tmp20_ = self->girdata;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gboolean _tmp21_ = FALSE;
		ValaMap* _tmp22_;
		_tmp22_ = self->girdata;
		if (vala_map_contains (_tmp22_, "c:symbol-prefix")) {
			_tmp21_ = TRUE;
		} else {
			ValaMap* _tmp23_;
			_tmp23_ = self->girdata;
			_tmp21_ = vala_map_contains (_tmp23_, "c:symbol-prefixes");
		}
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaGirParserNode* cur = NULL;
		cur = self;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp26_;
				ValaMap* _tmp27_;
				ValaGirParserNode* _tmp44_;
				ValaGirParserNode* _tmp45_;
				if (!_tmp24_) {
					ValaGirParserNode* _tmp25_;
					_tmp25_ = cur;
					if (!(_tmp25_ != NULL)) {
						break;
					}
				}
				_tmp24_ = FALSE;
				_tmp26_ = cur;
				_tmp27_ = _tmp26_->girdata;
				if (_tmp27_ != NULL) {
					gchar* p = NULL;
					ValaGirParserNode* _tmp28_;
					ValaMap* _tmp29_;
					gpointer _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp39_;
					_tmp28_ = cur;
					_tmp29_ = _tmp28_->girdata;
					_tmp30_ = vala_map_get (_tmp29_, "c:symbol-prefix");
					p = (gchar*) _tmp30_;
					_tmp31_ = p;
					if (_tmp31_ == NULL) {
						ValaGirParserNode* _tmp32_;
						ValaMap* _tmp33_;
						gpointer _tmp34_;
						const gchar* _tmp35_;
						_tmp32_ = cur;
						_tmp33_ = _tmp32_->girdata;
						_tmp34_ = vala_map_get (_tmp33_, "c:symbol-prefixes");
						_g_free0 (p);
						p = (gchar*) _tmp34_;
						_tmp35_ = p;
						if (_tmp35_ != NULL) {
							gint idx = 0;
							const gchar* _tmp36_;
							_tmp36_ = p;
							idx = string_index_of (_tmp36_, ",", 0);
							if (idx >= 0) {
								const gchar* _tmp37_;
								gchar* _tmp38_;
								_tmp37_ = p;
								_tmp38_ = string_substring (_tmp37_, (glong) 0, (glong) idx);
								_g_free0 (p);
								p = _tmp38_;
							}
						}
					}
					_tmp39_ = p;
					if (_tmp39_ != NULL) {
						const gchar* _tmp40_ = NULL;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp41_ = prefix;
						_tmp40_ = _tmp41_;
						if (_tmp40_ == NULL) {
							_tmp40_ = "";
						}
						_tmp42_ = p;
						_tmp43_ = g_strdup_printf ("%s_%s", _tmp42_, _tmp40_);
						_g_free0 (prefix);
						prefix = _tmp43_;
					}
					_g_free0 (p);
				}
				_tmp44_ = cur;
				_tmp45_ = _tmp44_->parent;
				cur = _tmp45_;
			}
		}
	}
	_tmp46_ = prefix;
	if (_tmp46_ == NULL) {
		gchar* _tmp47_;
		_tmp47_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_g_free0 (prefix);
		prefix = _tmp47_;
	}
	result = prefix;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_node_get_lower_case_csuffix (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s%s_", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gchar*
vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* suffix = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp16_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "lower_case_csuffix", NULL);
	suffix = _tmp1_;
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX);
		_g_free0 (suffix);
		suffix = _tmp4_;
	}
	_tmp8_ = suffix;
	if (_tmp8_ == NULL) {
		ValaMap* _tmp9_;
		_tmp9_ = self->girdata;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp10_;
		gpointer _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->girdata;
		_tmp11_ = vala_map_get (_tmp10_, "c:symbol-prefix");
		_tmp12_ = (gchar*) _tmp11_;
		_tmp6_ = _tmp12_ != NULL;
		_g_free0 (_tmp12_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaGirParserMetadata* _tmp13_;
		_tmp13_ = self->metadata;
		_tmp5_ = !vala_gir_parser_metadata_has_argument (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:symbol-prefix");
		_g_free0 (suffix);
		suffix = (gchar*) _tmp15_;
	}
	_tmp16_ = suffix;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		_tmp17_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_g_free0 (suffix);
		suffix = _tmp17_;
	}
	result = suffix;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* csuffix = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp16_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	csuffix = _tmp1_;
	_tmp2_ = csuffix;
	if (g_str_has_prefix (_tmp2_, "type_")) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = csuffix;
		_tmp4_ = strlen ("type_");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (_tmp3_, (glong) _tmp5_, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("type", _tmp7_, NULL);
		_g_free0 (csuffix);
		csuffix = _tmp8_;
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = csuffix;
		if (g_str_has_prefix (_tmp9_, "is_")) {
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = csuffix;
			_tmp11_ = strlen ("is_");
			_tmp12_ = _tmp11_;
			_tmp13_ = string_substring (_tmp10_, (glong) _tmp12_, (glong) -1);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat ("is", _tmp14_, NULL);
			_g_free0 (csuffix);
			csuffix = _tmp15_;
			_g_free0 (_tmp14_);
		}
	}
	_tmp16_ = csuffix;
	if (g_str_has_suffix (_tmp16_, "_class")) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp17_ = csuffix;
		_tmp18_ = csuffix;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = strlen ("_class");
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp22_));
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, "class", NULL);
		_g_free0 (csuffix);
		csuffix = _tmp25_;
		_g_free0 (_tmp24_);
	}
	result = csuffix;
	return result;
}

static gchar*
vala_gir_parser_node_get_cprefix (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp19_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (prefix);
		prefix = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cprefix", NULL);
		_g_free0 (prefix);
		prefix = _tmp6_;
	}
	_tmp9_ = prefix;
	if (_tmp9_ == NULL) {
		ValaMap* _tmp10_;
		_tmp10_ = self->girdata;
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaMap* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->girdata;
		_tmp12_ = vala_map_get (_tmp11_, "c:identifier-prefixes");
		_tmp13_ = (gchar*) _tmp12_;
		_tmp7_ = _tmp13_ != NULL;
		_g_free0 (_tmp13_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		gint idx = 0;
		const gchar* _tmp16_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:identifier-prefixes");
		_g_free0 (prefix);
		prefix = (gchar*) _tmp15_;
		_tmp16_ = prefix;
		idx = string_index_of (_tmp16_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = prefix;
			_tmp18_ = string_substring (_tmp17_, (glong) 0, (glong) idx);
			_g_free0 (prefix);
			prefix = _tmp18_;
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		gboolean _tmp20_ = FALSE;
		ValaSymbol* _tmp21_;
		_tmp21_ = self->symbol;
		if (VALA_IS_ENUM (_tmp21_)) {
			_tmp20_ = TRUE;
		} else {
			ValaSymbol* _tmp22_;
			_tmp22_ = self->symbol;
			_tmp20_ = VALA_IS_ERROR_DOMAIN (_tmp22_);
		}
		if (_tmp20_) {
			ValaGirParserNode* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp23_ = self->parent;
			_tmp24_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_ascii_strup (_tmp25_, (gssize) -1);
			_tmp27_ = _tmp26_;
			_tmp28_ = self->name;
			_tmp29_ = g_strdup_printf ("%s%s", _tmp27_, _tmp28_);
			_g_free0 (prefix);
			prefix = _tmp29_;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
		} else {
			gchar* _tmp30_;
			_tmp30_ = vala_gir_parser_node_get_cname (self);
			_g_free0 (prefix);
			prefix = _tmp30_;
		}
	}
	result = prefix;
	return result;
}

static gchar*
vala_gir_parser_node_get_cname (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* cname = NULL;
	ValaGirParserMetadata* _tmp2_;
	ValaMap* _tmp7_;
	const gchar* _tmp14_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME);
		_g_free0 (cname);
		cname = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cname", NULL);
		_g_free0 (cname);
		cname = _tmp6_;
	}
	_tmp7_ = self->girdata;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp11_;
		_tmp8_ = cname;
		if (_tmp8_ == NULL) {
			ValaMap* _tmp9_;
			gpointer _tmp10_;
			_tmp9_ = self->girdata;
			_tmp10_ = vala_map_get (_tmp9_, "c:identifier");
			_g_free0 (cname);
			cname = (gchar*) _tmp10_;
		}
		_tmp11_ = cname;
		if (_tmp11_ == NULL) {
			ValaMap* _tmp12_;
			gpointer _tmp13_;
			_tmp12_ = self->girdata;
			_tmp13_ = vala_map_get (_tmp12_, "c:type");
			_g_free0 (cname);
			cname = (gchar*) _tmp13_;
		}
	}
	_tmp14_ = cname;
	if (_tmp14_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = vala_gir_parser_node_get_default_cname (self);
		_g_free0 (cname);
		cname = _tmp15_;
	}
	result = cname;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_cname (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	if (VALA_IS_FIELD (_tmp2_)) {
		ValaSymbol* _tmp3_;
		ValaMemberBinding _tmp4_;
		ValaMemberBinding _tmp5_;
		_tmp3_ = self->symbol;
		_tmp4_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_FIELD, ValaField));
		_tmp5_ = _tmp4_;
		if (_tmp5_ == VALA_MEMBER_BINDING_STATIC) {
			ValaGirParserNode* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = self->parent;
			_tmp7_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->name;
			_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp8_);
			result = _tmp11_;
			return result;
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = self->name;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
	} else {
		ValaSymbol* _tmp14_;
		_tmp14_ = self->symbol;
		if (VALA_IS_METHOD (_tmp14_)) {
			ValaGirParserNode* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->parent;
			_tmp16_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->name;
			_tmp19_ = g_strdup_printf ("%s%s", _tmp17_, _tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp17_);
			result = _tmp20_;
			return result;
		} else {
			ValaGirParserNode* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = self->parent;
			_tmp22_ = vala_gir_parser_node_get_cprefix (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->name;
			_tmp25_ = g_strdup_printf ("%s%s", _tmp23_, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp23_);
			result = _tmp26_;
			return result;
		}
	}
}

static gchar*
vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self)
{
	gchar* finish_cname = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "finish_name", NULL);
	finish_cname = _tmp1_;
	_tmp2_ = finish_cname;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp3_ = vala_gir_parser_node_get_cname (self);
		_g_free0 (finish_cname);
		finish_cname = _tmp3_;
		_tmp4_ = finish_cname;
		if (g_str_has_suffix (_tmp4_, "_async")) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp5_ = finish_cname;
			_tmp6_ = finish_cname;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = strlen ("_async");
			_tmp10_ = _tmp9_;
			_tmp11_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp8_ - _tmp10_));
			_g_free0 (finish_cname);
			finish_cname = _tmp11_;
		}
		_tmp12_ = finish_cname;
		_tmp13_ = g_strdup_printf ("%s_finish", _tmp12_);
		_g_free0 (finish_cname);
		finish_cname = _tmp13_;
	}
	result = finish_cname;
	return result;
}

static gchar*
vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self)
{
	ValaGirParserMetadata* _tmp0_;
	gchar* cheader_filename = NULL;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp19_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->symbol;
	_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp4_;
	_tmp5_ = cheader_filename;
	if (_tmp5_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = _tmp6_->name;
	if (_tmp7_ != NULL) {
		ValaGirParserNode* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->parent;
		_tmp9_ = vala_gir_parser_node_get_cheader_filename (_tmp8_);
		result = _tmp9_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSymbol* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		_tmp10_ = self->symbol;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaSymbol* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceFile* _tmp16_;
			ValaSourceFile* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = self->symbol;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_source_reference_get_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_cinclude_filename (_tmp17_);
			result = _tmp18_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (cheader_filename);
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala__result_;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}

static guint64
vala_gir_parser_node_parse_version_string (const gchar* version)
{
	gint64 res = 0LL;
	gint shift = 0;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	guint64 result = 0ULL;
	g_return_val_if_fail (version != NULL, 0ULL);
	res = (gint64) 0;
	shift = 16;
	_tmp1_ = _tmp0_ = g_strsplit (version, ".", 3);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp2_;
		token_collection_length1 = _tmp2__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			const gchar* token = NULL;
			token = token_collection[token_it];
			{
				gint64 t = 0LL;
				const gchar* _tmp3_;
				gint64 _tmp4_ = 0LL;
				gboolean _tmp5_;
				_tmp3_ = token;
				_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_, NULL, (guint) 0);
				t = _tmp4_;
				if (!_tmp5_) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				if (t > ((gint64) 0xffff)) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				res |= t << shift;
				shift -= 8;
			}
		}
	}
	result = (guint64) res;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
vala_gir_parser_node_process (ValaGirParserNode* self,
                              ValaGirParser* parser)
{
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	gboolean _tmp37_ = FALSE;
	ValaSymbol* _tmp38_;
	ValaMap* _tmp78_;
	gboolean _tmp801_ = FALSE;
	gboolean _tmp802_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	if (self->processed) {
		return;
	}
	_tmp1_ = self->symbol;
	if (VALA_IS_NAMESPACE (_tmp1_)) {
		ValaGirParserNode* _tmp2_;
		ValaGirParserNode* _tmp3_;
		_tmp2_ = self->parent;
		_tmp3_ = parser->priv->root;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp4_;
			ValaArrayList* _tmp5_;
			gint _node_size = 0;
			ValaArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _node_index = 0;
			_tmp4_ = self->members;
			_tmp5_ = _vala_iterable_ref0 (_tmp4_);
			_node_list = _tmp5_;
			_tmp6_ = _node_list;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_node_size = _tmp8_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp11_;
				gpointer _tmp12_;
				ValaGirParserNode* _tmp13_;
				const gchar* _tmp14_;
				_node_index = _node_index + 1;
				_tmp9_ = _node_index;
				_tmp10_ = _node_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _node_list;
				_tmp12_ = vala_list_get ((ValaList*) _tmp11_, _node_index);
				node = (ValaGirParserNode*) _tmp12_;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->element_type;
				if (g_strcmp0 (_tmp14_, "alias") == 0) {
					ValaGirParserNode* _tmp15_;
					_tmp15_ = node;
					vala_gir_parser_process_alias (parser, _tmp15_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					ValaArrayList* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp21_;
					gpointer _tmp22_;
					gboolean _tmp23_ = FALSE;
					ValaGirParserNode* _tmp24_;
					ValaSymbol* _tmp25_;
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					_tmp18_ = self->members;
					_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
					_tmp20_ = _tmp19_;
					if (!(i < _tmp20_)) {
						break;
					}
					_tmp21_ = self->members;
					_tmp22_ = vala_list_get ((ValaList*) _tmp21_, i);
					node = (ValaGirParserNode*) _tmp22_;
					_tmp24_ = node;
					_tmp25_ = _tmp24_->symbol;
					if (VALA_IS_METHOD (_tmp25_)) {
						ValaGirParserNode* _tmp26_;
						_tmp26_ = node;
						_tmp23_ = _tmp26_->new_symbol;
					} else {
						_tmp23_ = FALSE;
					}
					if (_tmp23_) {
						ValaGirParserNode* _tmp27_;
						gboolean _tmp28_ = FALSE;
						ValaArrayList* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						_tmp27_ = node;
						vala_gir_parser_process_namespace_method (parser, self, _tmp27_);
						_tmp29_ = self->members;
						_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
						_tmp31_ = _tmp30_;
						if (i < _tmp31_) {
							ValaArrayList* _tmp32_;
							gpointer _tmp33_;
							ValaGirParserNode* _tmp34_;
							ValaGirParserNode* _tmp35_;
							_tmp32_ = self->members;
							_tmp33_ = vala_list_get ((ValaList*) _tmp32_, i);
							_tmp34_ = (ValaGirParserNode*) _tmp33_;
							_tmp35_ = node;
							_tmp28_ = _tmp34_ != _tmp35_;
							_vala_gir_parser_node_unref0 (_tmp34_);
						} else {
							_tmp28_ = FALSE;
						}
						if (_tmp28_) {
							gint _tmp36_;
							_tmp36_ = i;
							i = _tmp36_ - 1;
						}
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
		}
	}
	_tmp38_ = self->symbol;
	if (VALA_IS_CLASS (_tmp38_)) {
		ValaMap* _tmp39_;
		_tmp39_ = self->girdata;
		_tmp37_ = _tmp39_ != NULL;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		gchar* class_struct = NULL;
		ValaMap* _tmp40_;
		gpointer _tmp41_;
		const gchar* _tmp42_;
		_tmp40_ = self->girdata;
		_tmp41_ = vala_map_get (_tmp40_, "glib:type-struct");
		class_struct = (gchar*) _tmp41_;
		_tmp42_ = class_struct;
		if (_tmp42_ != NULL) {
			ValaGirParserNode* klass = NULL;
			ValaGirParserNode* _tmp43_;
			const gchar* _tmp44_;
			ValaSourceReference* _tmp45_;
			ValaUnresolvedSymbol* _tmp46_;
			ValaUnresolvedSymbol* _tmp47_;
			ValaGirParserNode* _tmp48_;
			ValaGirParserNode* _tmp49_;
			ValaGirParserNode* _tmp50_;
			_tmp43_ = self->parent;
			_tmp44_ = class_struct;
			_tmp45_ = self->source_reference;
			_tmp46_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp44_, _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_gir_parser_resolve_node (parser, _tmp43_, _tmp47_, FALSE);
			_tmp49_ = _tmp48_;
			_vala_code_node_unref0 (_tmp47_);
			klass = _tmp49_;
			_tmp50_ = klass;
			if (_tmp50_ != NULL) {
				gint i = 0;
				i = 0;
				while (TRUE) {
					ValaGirParserNode* _tmp51_;
					ValaArrayList* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					ValaGirParserNode* node = NULL;
					ValaGirParserNode* _tmp55_;
					ValaArrayList* _tmp56_;
					gpointer _tmp57_;
					ValaGirParserNode* _tmp58_;
					ValaSymbol* _tmp59_;
					_tmp51_ = klass;
					_tmp52_ = _tmp51_->members;
					_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
					_tmp54_ = _tmp53_;
					if (!(i < _tmp54_)) {
						break;
					}
					_tmp55_ = klass;
					_tmp56_ = _tmp55_->members;
					_tmp57_ = vala_list_get ((ValaList*) _tmp56_, i);
					node = (ValaGirParserNode*) _tmp57_;
					_tmp58_ = node;
					_tmp59_ = _tmp58_->symbol;
					if (VALA_IS_METHOD (_tmp59_)) {
						ValaGirParserNode* _tmp60_;
						ValaGirParserNode* _tmp61_;
						ValaGirParserNode* _tmp62_;
						ValaMethod* m = NULL;
						ValaGirParserNode* _tmp63_;
						ValaSymbol* _tmp64_;
						ValaMethod* _tmp65_;
						ValaMethod* _tmp66_;
						_tmp60_ = klass;
						_tmp61_ = node;
						vala_gir_parser_node_remove_member (_tmp60_, _tmp61_);
						_tmp62_ = node;
						vala_gir_parser_node_add_member (self, _tmp62_);
						_tmp63_ = node;
						_tmp64_ = _tmp63_->symbol;
						_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp65_;
						_tmp66_ = m;
						vala_method_set_binding (_tmp66_, VALA_MEMBER_BINDING_CLASS);
						_vala_code_node_unref0 (m);
					} else {
						gint _tmp67_;
						_tmp67_ = i;
						i = _tmp67_ + 1;
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
			_vala_gir_parser_node_unref0 (klass);
		}
		_g_free0 (class_struct);
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp68_;
		ValaArrayList* _tmp69_;
		gint _node_size = 0;
		ValaArrayList* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		gint _node_index = 0;
		_tmp68_ = self->members;
		_tmp69_ = _vala_iterable_ref0 (_tmp68_);
		_node_list = _tmp69_;
		_tmp70_ = _node_list;
		_tmp71_ = vala_collection_get_size ((ValaCollection*) _tmp70_);
		_tmp72_ = _tmp71_;
		_node_size = _tmp72_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp73_;
			gint _tmp74_;
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp75_;
			gpointer _tmp76_;
			ValaGirParserNode* _tmp77_;
			_node_index = _node_index + 1;
			_tmp73_ = _node_index;
			_tmp74_ = _node_size;
			if (!(_tmp73_ < _tmp74_)) {
				break;
			}
			_tmp75_ = _node_list;
			_tmp76_ = vala_list_get ((ValaList*) _tmp75_, _node_index);
			node = (ValaGirParserNode*) _tmp76_;
			_tmp77_ = node;
			vala_gir_parser_node_process (_tmp77_, parser);
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp78_ = self->girdata;
	if (_tmp78_ != NULL) {
		ValaSymbol* _tmp79_;
		ValaGirParserMetadata* _tmp708_;
		ValaGirParserMetadata* _tmp711_;
		ValaGirParserMetadata* _tmp720_;
		const gchar* _tmp726_;
		ValaGirParserMetadata* _tmp728_;
		ValaGirParserMetadata* _tmp731_;
		ValaGirParserNode* _tmp749_;
		ValaSymbol* _tmp750_;
		gchar* _tmp759_;
		gchar* _tmp760_;
		gchar* _tmp761_;
		gchar* _tmp762_;
		gboolean _tmp763_;
		ValaGirParserMetadata* _tmp767_;
		gchar* _tmp772_;
		gchar* _tmp773_;
		gchar* _tmp774_;
		gchar* _tmp775_;
		gboolean _tmp776_;
		gchar* _tmp780_;
		gchar* _tmp781_;
		gchar* _tmp782_;
		gchar* _tmp783_;
		gboolean _tmp784_;
		gchar* gir_name = NULL;
		gchar* _tmp788_;
		gchar* default_gir_name = NULL;
		gchar* _tmp789_;
		gboolean _tmp790_ = FALSE;
		gboolean _tmp791_ = FALSE;
		ValaSymbol* _tmp792_;
		_tmp79_ = self->symbol;
		if (VALA_IS_METHOD (_tmp79_)) {
			ValaMethod* m = NULL;
			ValaSymbol* _tmp80_;
			ValaMethod* _tmp81_;
			ValaArrayList* colliding = NULL;
			ValaGirParserNode* _tmp82_;
			const gchar* _tmp83_;
			ValaArrayList* _tmp84_;
			ValaMethod* _tmp184_;
			ValaMethod* _tmp203_;
			gboolean _tmp204_;
			gboolean _tmp205_;
			_tmp80_ = self->symbol;
			_tmp81_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp81_;
			vala_gir_parser_process_callable (parser, self);
			_tmp82_ = self->parent;
			_tmp83_ = self->name;
			_tmp84_ = vala_gir_parser_node_lookup_all (_tmp82_, _tmp83_);
			colliding = _tmp84_;
			{
				ValaArrayList* _node_list = NULL;
				ValaArrayList* _tmp85_;
				ValaArrayList* _tmp86_;
				gint _node_size = 0;
				ValaArrayList* _tmp87_;
				gint _tmp88_;
				gint _tmp89_;
				gint _node_index = 0;
				_tmp85_ = colliding;
				_tmp86_ = _vala_iterable_ref0 (_tmp85_);
				_node_list = _tmp86_;
				_tmp87_ = _node_list;
				_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
				_tmp89_ = _tmp88_;
				_node_size = _tmp89_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp90_;
					gint _tmp91_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp92_;
					gpointer _tmp93_;
					ValaSymbol* sym = NULL;
					ValaGirParserNode* _tmp94_;
					ValaSymbol* _tmp95_;
					ValaSymbol* _tmp96_;
					gboolean _tmp97_ = FALSE;
					gboolean _tmp98_ = FALSE;
					ValaSymbol* _tmp99_;
					_node_index = _node_index + 1;
					_tmp90_ = _node_index;
					_tmp91_ = _node_size;
					if (!(_tmp90_ < _tmp91_)) {
						break;
					}
					_tmp92_ = _node_list;
					_tmp93_ = vala_list_get ((ValaList*) _tmp92_, _node_index);
					node = (ValaGirParserNode*) _tmp93_;
					_tmp94_ = node;
					_tmp95_ = _tmp94_->symbol;
					_tmp96_ = _vala_code_node_ref0 (_tmp95_);
					sym = _tmp96_;
					_tmp99_ = sym;
					if (VALA_IS_FIELD (_tmp99_)) {
						ValaMethod* _tmp100_;
						ValaDataType* _tmp101_;
						ValaDataType* _tmp102_;
						_tmp100_ = m;
						_tmp101_ = vala_callable_get_return_type ((ValaCallable*) _tmp100_);
						_tmp102_ = _tmp101_;
						_tmp98_ = !VALA_IS_VOID_TYPE (_tmp102_);
					} else {
						_tmp98_ = FALSE;
					}
					if (_tmp98_) {
						ValaMethod* _tmp103_;
						ValaList* _tmp104_;
						gint _tmp105_;
						gint _tmp106_;
						_tmp103_ = m;
						_tmp104_ = vala_callable_get_parameters ((ValaCallable*) _tmp103_);
						_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
						_tmp106_ = _tmp105_;
						_tmp97_ = _tmp106_ == 0;
					} else {
						_tmp97_ = FALSE;
					}
					if (_tmp97_) {
						self->merged = TRUE;
					} else {
						ValaSymbol* _tmp107_;
						_tmp107_ = sym;
						if (VALA_IS_SIGNAL (_tmp107_)) {
							ValaGirParserNode* _tmp108_;
							ValaSignal* sig = NULL;
							ValaSymbol* _tmp109_;
							ValaSignal* _tmp110_;
							gboolean _tmp111_ = FALSE;
							ValaMethod* _tmp112_;
							gboolean _tmp113_;
							gboolean _tmp114_;
							ValaSignal* _tmp120_;
							ValaMethod* _tmp121_;
							ValaMethod* _tmp122_;
							ValaList* _tmp123_;
							gint _tmp124_;
							gint _tmp125_;
							ValaSignal* _tmp126_;
							ValaList* _tmp127_;
							gint _tmp128_;
							gint _tmp129_;
							_tmp108_ = node;
							vala_gir_parser_node_process (_tmp108_, parser);
							_tmp109_ = sym;
							_tmp110_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_SIGNAL, ValaSignal));
							sig = _tmp110_;
							_tmp112_ = m;
							_tmp113_ = vala_method_get_is_virtual (_tmp112_);
							_tmp114_ = _tmp113_;
							if (_tmp114_) {
								_tmp111_ = TRUE;
							} else {
								ValaMethod* _tmp115_;
								gboolean _tmp116_;
								gboolean _tmp117_;
								_tmp115_ = m;
								_tmp116_ = vala_method_get_is_abstract (_tmp115_);
								_tmp117_ = _tmp116_;
								_tmp111_ = _tmp117_;
							}
							if (_tmp111_) {
								ValaSignal* _tmp118_;
								_tmp118_ = sig;
								vala_signal_set_is_virtual (_tmp118_, TRUE);
							} else {
								ValaSignal* _tmp119_;
								_tmp119_ = sig;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp119_, "HasEmitter", TRUE, NULL);
							}
							_tmp120_ = sig;
							_tmp121_ = m;
							vala_gir_parser_assume_parameter_names (parser, _tmp120_, (ValaSymbol*) _tmp121_, FALSE);
							_tmp122_ = m;
							_tmp123_ = vala_callable_get_parameters ((ValaCallable*) _tmp122_);
							_tmp124_ = vala_collection_get_size ((ValaCollection*) _tmp123_);
							_tmp125_ = _tmp124_;
							_tmp126_ = sig;
							_tmp127_ = vala_callable_get_parameters ((ValaCallable*) _tmp126_);
							_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
							_tmp129_ = _tmp128_;
							if (_tmp125_ != _tmp129_) {
								ValaSymbol* _tmp130_;
								ValaSourceReference* _tmp131_;
								ValaSourceReference* _tmp132_;
								gchar* _tmp133_;
								gchar* _tmp134_;
								gchar* _tmp135_;
								gchar* _tmp136_;
								_tmp130_ = self->symbol;
								_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp130_);
								_tmp132_ = _tmp131_;
								_tmp133_ = vala_gir_parser_node_get_full_name (self);
								_tmp134_ = _tmp133_;
								_tmp135_ = g_strdup_printf ("Signal `%s' conflicts with method of the same name", _tmp134_);
								_tmp136_ = _tmp135_;
								vala_report_warning (_tmp132_, _tmp136_);
								_g_free0 (_tmp136_);
								_g_free0 (_tmp134_);
							}
							self->merged = TRUE;
							_vala_code_node_unref0 (sig);
						} else {
							gboolean _tmp137_ = FALSE;
							gboolean _tmp138_ = FALSE;
							ValaSymbol* _tmp139_;
							_tmp139_ = sym;
							if (VALA_IS_METHOD (_tmp139_)) {
								ValaSymbol* _tmp140_;
								_tmp140_ = sym;
								_tmp138_ = !VALA_IS_CREATION_METHOD (_tmp140_);
							} else {
								_tmp138_ = FALSE;
							}
							if (_tmp138_) {
								ValaGirParserNode* _tmp141_;
								_tmp141_ = node;
								_tmp137_ = _tmp141_ != self;
							} else {
								_tmp137_ = FALSE;
							}
							if (_tmp137_) {
								gboolean _tmp142_ = FALSE;
								ValaMethod* _tmp143_;
								gboolean _tmp144_;
								gboolean _tmp145_;
								_tmp143_ = m;
								_tmp144_ = vala_method_get_is_virtual (_tmp143_);
								_tmp145_ = _tmp144_;
								if (_tmp145_) {
									_tmp142_ = TRUE;
								} else {
									ValaMethod* _tmp146_;
									gboolean _tmp147_;
									gboolean _tmp148_;
									_tmp146_ = m;
									_tmp147_ = vala_method_get_is_abstract (_tmp146_);
									_tmp148_ = _tmp147_;
									_tmp142_ = _tmp148_;
								}
								if (_tmp142_) {
									gboolean different_invoker = FALSE;
									ValaAttribute* attr = NULL;
									ValaMethod* _tmp149_;
									ValaAttribute* _tmp150_;
									ValaAttribute* _tmp151_;
									ValaAttribute* _tmp152_;
									different_invoker = FALSE;
									_tmp149_ = m;
									_tmp150_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp149_, "NoWrapper");
									_tmp151_ = _vala_code_node_ref0 (_tmp150_);
									attr = _tmp151_;
									_tmp152_ = attr;
									if (_tmp152_ != NULL) {
										ValaGirParserNode* invoker = NULL;
										ValaGirParserNode* _tmp153_;
										ValaGirParserNode* _tmp154_;
										_tmp153_ = vala_gir_parser_find_invoker (parser, self);
										invoker = _tmp153_;
										_tmp154_ = invoker;
										if (_tmp154_ != NULL) {
											ValaMethod* _tmp155_;
											ValaMethod* _tmp156_;
											const gchar* _tmp157_;
											const gchar* _tmp158_;
											ValaMethod* _tmp159_;
											ValaGirParserNode* _tmp160_;
											ValaSymbol* _tmp161_;
											const gchar* _tmp162_;
											const gchar* _tmp163_;
											ValaMethod* _tmp164_;
											ValaGirParserNode* _tmp165_;
											_tmp155_ = m;
											_tmp156_ = m;
											_tmp157_ = vala_symbol_get_name ((ValaSymbol*) _tmp156_);
											_tmp158_ = _tmp157_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp155_, "CCode", "vfunc_name", _tmp158_, NULL);
											_tmp159_ = m;
											_tmp160_ = invoker;
											_tmp161_ = _tmp160_->symbol;
											_tmp162_ = vala_symbol_get_name (_tmp161_);
											_tmp163_ = _tmp162_;
											vala_symbol_set_name ((ValaSymbol*) _tmp159_, _tmp163_);
											_tmp164_ = m;
											vala_code_node_set_attribute ((ValaCodeNode*) _tmp164_, "NoWrapper", FALSE, NULL);
											_tmp165_ = invoker;
											_tmp165_->merged = TRUE;
											different_invoker = TRUE;
										}
										_vala_gir_parser_node_unref0 (invoker);
									}
									if (!different_invoker) {
										ValaAttribute* _tmp166_;
										ValaGirParserNode* _tmp174_;
										_tmp166_ = attr;
										if (_tmp166_ != NULL) {
											ValaSymbol* _tmp167_;
											ValaSourceReference* _tmp168_;
											ValaSourceReference* _tmp169_;
											gchar* _tmp170_;
											gchar* _tmp171_;
											gchar* _tmp172_;
											gchar* _tmp173_;
											_tmp167_ = self->symbol;
											_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp167_);
											_tmp169_ = _tmp168_;
											_tmp170_ = vala_gir_parser_node_get_full_name (self);
											_tmp171_ = _tmp170_;
											_tmp172_ = g_strdup_printf ("Virtual method `%s' conflicts with method of the same name", _tmp171_);
											_tmp173_ = _tmp172_;
											vala_report_warning (_tmp169_, _tmp173_);
											_g_free0 (_tmp173_);
											_g_free0 (_tmp171_);
										}
										_tmp174_ = node;
										_tmp174_->merged = TRUE;
									}
									_vala_code_node_unref0 (attr);
								} else {
									ValaMethod* _tmp175_;
									_tmp175_ = m;
									if (vala_symbol_is_class_member ((ValaSymbol*) _tmp175_)) {
										ValaSymbol* _tmp176_;
										ValaSourceReference* _tmp177_;
										ValaSourceReference* _tmp178_;
										gchar* _tmp179_;
										gchar* _tmp180_;
										gchar* _tmp181_;
										gchar* _tmp182_;
										ValaGirParserNode* _tmp183_;
										_tmp176_ = self->symbol;
										_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp176_);
										_tmp178_ = _tmp177_;
										_tmp179_ = vala_gir_parser_node_get_full_name (self);
										_tmp180_ = _tmp179_;
										_tmp181_ = g_strdup_printf ("Class method `%s' conflicts with method of the same name", _tmp180_);
										_tmp182_ = _tmp181_;
										vala_report_warning (_tmp178_, _tmp182_);
										_g_free0 (_tmp182_);
										_g_free0 (_tmp180_);
										_tmp183_ = node;
										_tmp183_->merged = TRUE;
									}
								}
							}
						}
					}
					_vala_code_node_unref0 (sym);
					_vala_gir_parser_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_tmp184_ = m;
			if (!VALA_IS_CREATION_METHOD (_tmp184_)) {
				ValaGirParserMetadata* _tmp185_;
				ValaGirParserMetadata* _tmp188_;
				ValaGirParserMetadata* _tmp191_;
				_tmp185_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp185_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE)) {
					ValaMethod* _tmp186_;
					ValaGirParserMetadata* _tmp187_;
					_tmp186_ = m;
					_tmp187_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp186_, "DestroysInstance", vala_gir_parser_metadata_get_bool (_tmp187_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, FALSE), NULL);
				}
				_tmp188_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp188_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER)) {
					ValaMethod* _tmp189_;
					ValaGirParserMetadata* _tmp190_;
					_tmp189_ = m;
					_tmp190_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp189_, "ReturnsModifiedPointer", vala_gir_parser_metadata_get_bool (_tmp190_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, FALSE), NULL);
				}
				_tmp191_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp191_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
					ValaGirParserNode* vfunc = NULL;
					ValaGirParserNode* _tmp192_;
					ValaGirParserMetadata* _tmp193_;
					gchar* _tmp194_;
					gchar* _tmp195_;
					ValaGirParserNode* _tmp196_;
					ValaGirParserNode* _tmp197_;
					gboolean _tmp198_ = FALSE;
					ValaGirParserNode* _tmp199_;
					_tmp192_ = self->parent;
					_tmp193_ = self->metadata;
					_tmp194_ = vala_gir_parser_metadata_get_string (_tmp193_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_gir_parser_node_lookup (_tmp192_, _tmp195_, FALSE, NULL);
					_tmp197_ = _tmp196_;
					_g_free0 (_tmp195_);
					vfunc = _tmp197_;
					_tmp199_ = vfunc;
					if (_tmp199_ != NULL) {
						ValaGirParserNode* _tmp200_;
						_tmp200_ = vfunc;
						_tmp198_ = _tmp200_ != self;
					} else {
						_tmp198_ = FALSE;
					}
					if (_tmp198_) {
						ValaGirParserNode* _tmp201_;
						ValaGirParserNode* _tmp202_;
						_tmp201_ = vfunc;
						_tmp201_->processed = TRUE;
						_tmp202_ = vfunc;
						_tmp202_->merged = TRUE;
					}
					_vala_gir_parser_node_unref0 (vfunc);
				}
			}
			_tmp203_ = m;
			_tmp204_ = vala_method_get_coroutine (_tmp203_);
			_tmp205_ = _tmp204_;
			if (_tmp205_) {
				vala_gir_parser_process_async_method (parser, self);
			}
			_vala_iterable_unref0 (colliding);
			_vala_code_node_unref0 (m);
		} else {
			ValaSymbol* _tmp206_;
			_tmp206_ = self->symbol;
			if (VALA_IS_PROPERTY (_tmp206_)) {
				ValaArrayList* colliding = NULL;
				ValaGirParserNode* _tmp207_;
				const gchar* _tmp208_;
				ValaArrayList* _tmp209_;
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp233_;
				ValaProperty* _tmp234_;
				gchar* readable = NULL;
				ValaMap* _tmp235_;
				gpointer _tmp236_;
				gchar* writable = NULL;
				ValaMap* _tmp237_;
				gpointer _tmp238_;
				gchar* construct_ = NULL;
				ValaMap* _tmp239_;
				gpointer _tmp240_;
				gchar* construct_only = NULL;
				ValaMap* _tmp241_;
				gpointer _tmp242_;
				const gchar* _tmp243_;
				gboolean _tmp252_ = FALSE;
				const gchar* _tmp253_;
				ValaProperty* _tmp269_;
				ValaDataType* _tmp270_;
				ValaDataType* _tmp271_;
				ValaGirParserNode* getter = NULL;
				ValaArrayList* getters = NULL;
				ValaGirParserNode* _tmp272_;
				const gchar* _tmp273_;
				gchar* _tmp274_;
				gchar* _tmp275_;
				ValaArrayList* _tmp276_;
				ValaArrayList* _tmp277_;
				ValaArrayList* _tmp278_;
				ValaGirParserNode* setter = NULL;
				ValaArrayList* setters = NULL;
				ValaGirParserNode* _tmp303_;
				const gchar* _tmp304_;
				gchar* _tmp305_;
				gchar* _tmp306_;
				ValaArrayList* _tmp307_;
				ValaArrayList* _tmp308_;
				ValaArrayList* _tmp309_;
				gboolean _tmp334_ = FALSE;
				const gchar* _tmp335_;
				ValaProperty* _tmp337_;
				ValaProperty* _tmp338_;
				ValaPropertyAccessor* _tmp339_;
				ValaPropertyAccessor* _tmp340_;
				gboolean _tmp399_ = FALSE;
				gboolean _tmp400_ = FALSE;
				ValaProperty* _tmp401_;
				ValaAttribute* _tmp402_;
				ValaProperty* _tmp467_;
				ValaAttribute* _tmp468_;
				ValaGirParserMetadata* _tmp514_;
				ValaProperty* _tmp517_;
				ValaAttribute* _tmp518_;
				_tmp207_ = self->parent;
				_tmp208_ = self->name;
				_tmp209_ = vala_gir_parser_node_lookup_all (_tmp207_, _tmp208_);
				colliding = _tmp209_;
				{
					ValaArrayList* _node_list = NULL;
					ValaArrayList* _tmp210_;
					ValaArrayList* _tmp211_;
					gint _node_size = 0;
					ValaArrayList* _tmp212_;
					gint _tmp213_;
					gint _tmp214_;
					gint _node_index = 0;
					_tmp210_ = colliding;
					_tmp211_ = _vala_iterable_ref0 (_tmp210_);
					_node_list = _tmp211_;
					_tmp212_ = _node_list;
					_tmp213_ = vala_collection_get_size ((ValaCollection*) _tmp212_);
					_tmp214_ = _tmp213_;
					_node_size = _tmp214_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp215_;
						gint _tmp216_;
						ValaGirParserNode* node = NULL;
						ValaArrayList* _tmp217_;
						gpointer _tmp218_;
						ValaGirParserNode* _tmp219_;
						ValaSymbol* _tmp220_;
						_node_index = _node_index + 1;
						_tmp215_ = _node_index;
						_tmp216_ = _node_size;
						if (!(_tmp215_ < _tmp216_)) {
							break;
						}
						_tmp217_ = _node_list;
						_tmp218_ = vala_list_get ((ValaList*) _tmp217_, _node_index);
						node = (ValaGirParserNode*) _tmp218_;
						_tmp219_ = node;
						_tmp220_ = _tmp219_->symbol;
						if (VALA_IS_SIGNAL (_tmp220_)) {
							ValaGirParserNode* _tmp221_;
							ValaGirParserNode* _tmp222_;
							ValaSymbol* _tmp223_;
							ValaSourceReference* _tmp224_;
							ValaSourceReference* _tmp225_;
							gchar* _tmp226_;
							gchar* _tmp227_;
							gchar* _tmp228_;
							gchar* _tmp229_;
							_tmp221_ = node;
							_tmp221_->processed = TRUE;
							_tmp222_ = node;
							_tmp222_->merged = TRUE;
							_tmp223_ = self->symbol;
							_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp223_);
							_tmp225_ = _tmp224_;
							_tmp226_ = vala_gir_parser_node_get_full_name (self);
							_tmp227_ = _tmp226_;
							_tmp228_ = g_strdup_printf ("Signal `%s' conflicts with property of the same name", _tmp227_);
							_tmp229_ = _tmp228_;
							vala_report_warning (_tmp225_, _tmp229_);
							_g_free0 (_tmp229_);
							_g_free0 (_tmp227_);
						} else {
							ValaGirParserNode* _tmp230_;
							ValaSymbol* _tmp231_;
							_tmp230_ = node;
							_tmp231_ = _tmp230_->symbol;
							if (VALA_IS_METHOD (_tmp231_)) {
								ValaGirParserNode* _tmp232_;
								_tmp232_ = node;
								_tmp232_->merged = TRUE;
							}
						}
						_vala_gir_parser_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
				_tmp233_ = self->symbol;
				_tmp234_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp233_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp234_;
				_tmp235_ = self->girdata;
				_tmp236_ = vala_map_get (_tmp235_, "readable");
				readable = (gchar*) _tmp236_;
				_tmp237_ = self->girdata;
				_tmp238_ = vala_map_get (_tmp237_, "writable");
				writable = (gchar*) _tmp238_;
				_tmp239_ = self->girdata;
				_tmp240_ = vala_map_get (_tmp239_, "construct");
				construct_ = (gchar*) _tmp240_;
				_tmp241_ = self->girdata;
				_tmp242_ = vala_map_get (_tmp241_, "construct-only");
				construct_only = (gchar*) _tmp242_;
				_tmp243_ = readable;
				if (g_strcmp0 (_tmp243_, "0") != 0) {
					ValaProperty* _tmp244_;
					ValaProperty* _tmp245_;
					ValaDataType* _tmp246_;
					ValaDataType* _tmp247_;
					ValaDataType* _tmp248_;
					ValaDataType* _tmp249_;
					ValaPropertyAccessor* _tmp250_;
					ValaPropertyAccessor* _tmp251_;
					_tmp244_ = prop;
					_tmp245_ = prop;
					_tmp246_ = vala_property_get_property_type (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = vala_data_type_copy (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp249_, NULL, NULL, NULL);
					_tmp251_ = _tmp250_;
					vala_property_set_get_accessor (_tmp244_, _tmp251_);
					_vala_code_node_unref0 (_tmp251_);
					_vala_code_node_unref0 (_tmp249_);
				}
				_tmp253_ = writable;
				if (g_strcmp0 (_tmp253_, "1") == 0) {
					_tmp252_ = TRUE;
				} else {
					const gchar* _tmp254_;
					_tmp254_ = construct_only;
					_tmp252_ = g_strcmp0 (_tmp254_, "1") == 0;
				}
				if (_tmp252_) {
					gboolean _tmp255_ = FALSE;
					const gchar* _tmp256_;
					gboolean _tmp258_ = FALSE;
					const gchar* _tmp259_;
					ValaProperty* _tmp261_;
					ValaProperty* _tmp262_;
					ValaDataType* _tmp263_;
					ValaDataType* _tmp264_;
					ValaDataType* _tmp265_;
					ValaDataType* _tmp266_;
					ValaPropertyAccessor* _tmp267_;
					ValaPropertyAccessor* _tmp268_;
					_tmp256_ = construct_only;
					if (g_strcmp0 (_tmp256_, "1") != 0) {
						const gchar* _tmp257_;
						_tmp257_ = writable;
						_tmp255_ = g_strcmp0 (_tmp257_, "1") == 0;
					} else {
						_tmp255_ = FALSE;
					}
					_tmp259_ = construct_only;
					if (g_strcmp0 (_tmp259_, "1") == 0) {
						_tmp258_ = TRUE;
					} else {
						const gchar* _tmp260_;
						_tmp260_ = construct_;
						_tmp258_ = g_strcmp0 (_tmp260_, "1") == 0;
					}
					_tmp261_ = prop;
					_tmp262_ = prop;
					_tmp263_ = vala_property_get_property_type (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp265_ = vala_data_type_copy (_tmp264_);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_property_accessor_new (FALSE, _tmp255_, _tmp258_, _tmp266_, NULL, NULL, NULL);
					_tmp268_ = _tmp267_;
					vala_property_set_set_accessor (_tmp261_, _tmp268_);
					_vala_code_node_unref0 (_tmp268_);
					_vala_code_node_unref0 (_tmp266_);
				}
				_tmp269_ = prop;
				_tmp270_ = vala_property_get_property_type (_tmp269_);
				_tmp271_ = _tmp270_;
				vala_data_type_set_value_owned (_tmp271_, TRUE);
				getter = NULL;
				_tmp272_ = self->parent;
				_tmp273_ = self->name;
				_tmp274_ = g_strdup_printf ("get_%s", _tmp273_);
				_tmp275_ = _tmp274_;
				_tmp276_ = vala_gir_parser_node_lookup_all (_tmp272_, _tmp275_);
				_tmp277_ = _tmp276_;
				_g_free0 (_tmp275_);
				getters = _tmp277_;
				_tmp278_ = getters;
				if (_tmp278_ != NULL) {
					{
						ValaArrayList* _g_list = NULL;
						ValaArrayList* _tmp279_;
						ValaArrayList* _tmp280_;
						gint _g_size = 0;
						ValaArrayList* _tmp281_;
						gint _tmp282_;
						gint _tmp283_;
						gint _g_index = 0;
						_tmp279_ = getters;
						_tmp280_ = _vala_iterable_ref0 (_tmp279_);
						_g_list = _tmp280_;
						_tmp281_ = _g_list;
						_tmp282_ = vala_collection_get_size ((ValaCollection*) _tmp281_);
						_tmp283_ = _tmp282_;
						_g_size = _tmp283_;
						_g_index = -1;
						while (TRUE) {
							gint _tmp284_;
							gint _tmp285_;
							ValaGirParserNode* g = NULL;
							ValaArrayList* _tmp286_;
							gpointer _tmp287_;
							gboolean _tmp288_ = FALSE;
							gboolean _tmp289_ = FALSE;
							ValaGirParserNode* _tmp290_;
							_g_index = _g_index + 1;
							_tmp284_ = _g_index;
							_tmp285_ = _g_size;
							if (!(_tmp284_ < _tmp285_)) {
								break;
							}
							_tmp286_ = _g_list;
							_tmp287_ = vala_list_get ((ValaList*) _tmp286_, _g_index);
							g = (ValaGirParserNode*) _tmp287_;
							_tmp290_ = getter;
							if (_tmp290_ == NULL) {
								_tmp289_ = TRUE;
							} else {
								ValaGirParserNode* _tmp291_;
								_tmp291_ = g;
								_tmp289_ = !_tmp291_->merged;
							}
							if (_tmp289_) {
								ValaGirParserNode* _tmp292_;
								gchar* _tmp293_;
								gchar* _tmp294_;
								ValaGirParserNode* _tmp295_;
								gchar* _tmp296_;
								gchar* _tmp297_;
								const gchar* _tmp298_;
								gchar* _tmp299_;
								gchar* _tmp300_;
								_tmp292_ = g;
								_tmp293_ = vala_gir_parser_node_get_cname (_tmp292_);
								_tmp294_ = _tmp293_;
								_tmp295_ = self->parent;
								_tmp296_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp295_);
								_tmp297_ = _tmp296_;
								_tmp298_ = self->name;
								_tmp299_ = g_strdup_printf ("%sget_%s", _tmp297_, _tmp298_);
								_tmp300_ = _tmp299_;
								_tmp288_ = g_strcmp0 (_tmp294_, _tmp300_) == 0;
								_g_free0 (_tmp300_);
								_g_free0 (_tmp297_);
								_g_free0 (_tmp294_);
							} else {
								_tmp288_ = FALSE;
							}
							if (_tmp288_) {
								ValaGirParserNode* _tmp301_;
								ValaGirParserNode* _tmp302_;
								_tmp301_ = g;
								_tmp302_ = _vala_gir_parser_node_ref0 (_tmp301_);
								_vala_gir_parser_node_unref0 (getter);
								getter = _tmp302_;
							}
							_vala_gir_parser_node_unref0 (g);
						}
						_vala_iterable_unref0 (_g_list);
					}
				}
				setter = NULL;
				_tmp303_ = self->parent;
				_tmp304_ = self->name;
				_tmp305_ = g_strdup_printf ("set_%s", _tmp304_);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_gir_parser_node_lookup_all (_tmp303_, _tmp306_);
				_tmp308_ = _tmp307_;
				_g_free0 (_tmp306_);
				setters = _tmp308_;
				_tmp309_ = setters;
				if (_tmp309_ != NULL) {
					{
						ValaArrayList* _s_list = NULL;
						ValaArrayList* _tmp310_;
						ValaArrayList* _tmp311_;
						gint _s_size = 0;
						ValaArrayList* _tmp312_;
						gint _tmp313_;
						gint _tmp314_;
						gint _s_index = 0;
						_tmp310_ = setters;
						_tmp311_ = _vala_iterable_ref0 (_tmp310_);
						_s_list = _tmp311_;
						_tmp312_ = _s_list;
						_tmp313_ = vala_collection_get_size ((ValaCollection*) _tmp312_);
						_tmp314_ = _tmp313_;
						_s_size = _tmp314_;
						_s_index = -1;
						while (TRUE) {
							gint _tmp315_;
							gint _tmp316_;
							ValaGirParserNode* s = NULL;
							ValaArrayList* _tmp317_;
							gpointer _tmp318_;
							gboolean _tmp319_ = FALSE;
							gboolean _tmp320_ = FALSE;
							ValaGirParserNode* _tmp321_;
							_s_index = _s_index + 1;
							_tmp315_ = _s_index;
							_tmp316_ = _s_size;
							if (!(_tmp315_ < _tmp316_)) {
								break;
							}
							_tmp317_ = _s_list;
							_tmp318_ = vala_list_get ((ValaList*) _tmp317_, _s_index);
							s = (ValaGirParserNode*) _tmp318_;
							_tmp321_ = setter;
							if (_tmp321_ == NULL) {
								_tmp320_ = TRUE;
							} else {
								ValaGirParserNode* _tmp322_;
								_tmp322_ = s;
								_tmp320_ = !_tmp322_->merged;
							}
							if (_tmp320_) {
								ValaGirParserNode* _tmp323_;
								gchar* _tmp324_;
								gchar* _tmp325_;
								ValaGirParserNode* _tmp326_;
								gchar* _tmp327_;
								gchar* _tmp328_;
								const gchar* _tmp329_;
								gchar* _tmp330_;
								gchar* _tmp331_;
								_tmp323_ = s;
								_tmp324_ = vala_gir_parser_node_get_cname (_tmp323_);
								_tmp325_ = _tmp324_;
								_tmp326_ = self->parent;
								_tmp327_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp326_);
								_tmp328_ = _tmp327_;
								_tmp329_ = self->name;
								_tmp330_ = g_strdup_printf ("%sset_%s", _tmp328_, _tmp329_);
								_tmp331_ = _tmp330_;
								_tmp319_ = g_strcmp0 (_tmp325_, _tmp331_) == 0;
								_g_free0 (_tmp331_);
								_g_free0 (_tmp328_);
								_g_free0 (_tmp325_);
							} else {
								_tmp319_ = FALSE;
							}
							if (_tmp319_) {
								ValaGirParserNode* _tmp332_;
								ValaGirParserNode* _tmp333_;
								_tmp332_ = s;
								_tmp333_ = _vala_gir_parser_node_ref0 (_tmp332_);
								_vala_gir_parser_node_unref0 (setter);
								setter = _tmp333_;
							}
							_vala_gir_parser_node_unref0 (s);
						}
						_vala_iterable_unref0 (_s_list);
					}
				}
				_tmp335_ = readable;
				if (g_strcmp0 (_tmp335_, "0") == 0) {
					const gchar* _tmp336_;
					_tmp336_ = construct_only;
					_tmp334_ = g_strcmp0 (_tmp336_, "1") == 0;
				} else {
					_tmp334_ = FALSE;
				}
				_tmp337_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp337_, "NoAccessorMethod", _tmp334_, NULL);
				_tmp338_ = prop;
				_tmp339_ = vala_property_get_get_accessor (_tmp338_);
				_tmp340_ = _tmp339_;
				if (_tmp340_ != NULL) {
					ValaMethod* _tmp341_ = NULL;
					ValaGirParserNode* _tmp342_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp345_;
					ValaMethod* _tmp346_;
					_tmp342_ = getter;
					if (_tmp342_ != NULL) {
						ValaGirParserNode* _tmp343_;
						ValaSymbol* _tmp344_;
						_tmp343_ = getter;
						_tmp344_ = _tmp343_->symbol;
						_tmp341_ = VALA_IS_METHOD (_tmp344_) ? ((ValaMethod*) _tmp344_) : NULL;
					} else {
						_tmp341_ = NULL;
					}
					_tmp345_ = _vala_code_node_ref0 (_tmp341_);
					m = _tmp345_;
					_tmp346_ = m;
					if (_tmp346_ != NULL) {
						ValaGirParserNode* _tmp347_;
						gboolean _tmp348_ = FALSE;
						gboolean _tmp349_ = FALSE;
						ValaMethod* _tmp350_;
						ValaDataType* _tmp351_;
						ValaDataType* _tmp352_;
						_tmp347_ = getter;
						vala_gir_parser_node_process (_tmp347_, parser);
						_tmp350_ = m;
						_tmp351_ = vala_callable_get_return_type ((ValaCallable*) _tmp350_);
						_tmp352_ = _tmp351_;
						if (VALA_IS_VOID_TYPE (_tmp352_)) {
							_tmp349_ = TRUE;
						} else {
							ValaMethod* _tmp353_;
							ValaList* _tmp354_;
							gint _tmp355_;
							gint _tmp356_;
							_tmp353_ = m;
							_tmp354_ = vala_callable_get_parameters ((ValaCallable*) _tmp353_);
							_tmp355_ = vala_collection_get_size ((ValaCollection*) _tmp354_);
							_tmp356_ = _tmp355_;
							_tmp349_ = _tmp356_ != 0;
						}
						if (_tmp349_) {
							_tmp348_ = TRUE;
						} else {
							ValaMethod* _tmp357_;
							gboolean _tmp358_;
							gboolean _tmp359_;
							_tmp357_ = m;
							_tmp358_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp357_);
							_tmp359_ = _tmp358_;
							_tmp348_ = _tmp359_;
						}
						if (_tmp348_) {
							ValaProperty* _tmp360_;
							_tmp360_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp360_, "NoAccessorMethod", TRUE, NULL);
						} else {
							ValaGirParserNode* _tmp361_;
							const gchar* _tmp362_;
							const gchar* _tmp363_;
							ValaProperty* _tmp376_;
							ValaPropertyAccessor* _tmp377_;
							ValaPropertyAccessor* _tmp378_;
							ValaDataType* _tmp379_;
							ValaDataType* _tmp380_;
							ValaMethod* _tmp381_;
							ValaDataType* _tmp382_;
							ValaDataType* _tmp383_;
							gboolean _tmp384_;
							gboolean _tmp385_;
							gboolean _tmp386_ = FALSE;
							gboolean _tmp387_ = FALSE;
							ValaMethod* _tmp388_;
							gboolean _tmp389_;
							gboolean _tmp390_;
							_tmp361_ = getter;
							_tmp362_ = _tmp361_->name;
							_tmp363_ = self->name;
							if (g_strcmp0 (_tmp362_, _tmp363_) == 0) {
								{
									ValaArrayList* _node_list = NULL;
									ValaArrayList* _tmp364_;
									ValaArrayList* _tmp365_;
									gint _node_size = 0;
									ValaArrayList* _tmp366_;
									gint _tmp367_;
									gint _tmp368_;
									gint _node_index = 0;
									_tmp364_ = colliding;
									_tmp365_ = _vala_iterable_ref0 (_tmp364_);
									_node_list = _tmp365_;
									_tmp366_ = _node_list;
									_tmp367_ = vala_collection_get_size ((ValaCollection*) _tmp366_);
									_tmp368_ = _tmp367_;
									_node_size = _tmp368_;
									_node_index = -1;
									while (TRUE) {
										gint _tmp369_;
										gint _tmp370_;
										ValaGirParserNode* node = NULL;
										ValaArrayList* _tmp371_;
										gpointer _tmp372_;
										ValaGirParserNode* _tmp373_;
										ValaSymbol* _tmp374_;
										_node_index = _node_index + 1;
										_tmp369_ = _node_index;
										_tmp370_ = _node_size;
										if (!(_tmp369_ < _tmp370_)) {
											break;
										}
										_tmp371_ = _node_list;
										_tmp372_ = vala_list_get ((ValaList*) _tmp371_, _node_index);
										node = (ValaGirParserNode*) _tmp372_;
										_tmp373_ = node;
										_tmp374_ = _tmp373_->symbol;
										if (VALA_IS_METHOD (_tmp374_)) {
											ValaGirParserNode* _tmp375_;
											_tmp375_ = node;
											_tmp375_->merged = TRUE;
										}
										_vala_gir_parser_node_unref0 (node);
									}
									_vala_iterable_unref0 (_node_list);
								}
							}
							_tmp376_ = prop;
							_tmp377_ = vala_property_get_get_accessor (_tmp376_);
							_tmp378_ = _tmp377_;
							_tmp379_ = vala_property_accessor_get_value_type (_tmp378_);
							_tmp380_ = _tmp379_;
							_tmp381_ = m;
							_tmp382_ = vala_callable_get_return_type ((ValaCallable*) _tmp381_);
							_tmp383_ = _tmp382_;
							_tmp384_ = vala_data_type_get_value_owned (_tmp383_);
							_tmp385_ = _tmp384_;
							vala_data_type_set_value_owned (_tmp380_, _tmp385_);
							_tmp388_ = m;
							_tmp389_ = vala_method_get_is_abstract (_tmp388_);
							_tmp390_ = _tmp389_;
							if (!_tmp390_) {
								ValaMethod* _tmp391_;
								gboolean _tmp392_;
								gboolean _tmp393_;
								_tmp391_ = m;
								_tmp392_ = vala_method_get_is_virtual (_tmp391_);
								_tmp393_ = _tmp392_;
								_tmp387_ = !_tmp393_;
							} else {
								_tmp387_ = FALSE;
							}
							if (_tmp387_) {
								ValaProperty* _tmp394_;
								gboolean _tmp395_;
								gboolean _tmp396_;
								_tmp394_ = prop;
								_tmp395_ = vala_property_get_is_abstract (_tmp394_);
								_tmp396_ = _tmp395_;
								_tmp386_ = _tmp396_;
							} else {
								_tmp386_ = FALSE;
							}
							if (_tmp386_) {
								ValaProperty* _tmp397_;
								_tmp397_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp397_, "ConcreteAccessor", TRUE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp398_;
						_tmp398_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp398_, "NoAccessorMethod", TRUE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp401_ = prop;
				_tmp402_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp401_, "NoAccessorMethod");
				if (_tmp402_ == NULL) {
					ValaProperty* _tmp403_;
					ValaPropertyAccessor* _tmp404_;
					ValaPropertyAccessor* _tmp405_;
					_tmp403_ = prop;
					_tmp404_ = vala_property_get_set_accessor (_tmp403_);
					_tmp405_ = _tmp404_;
					_tmp400_ = _tmp405_ != NULL;
				} else {
					_tmp400_ = FALSE;
				}
				if (_tmp400_) {
					ValaProperty* _tmp406_;
					ValaPropertyAccessor* _tmp407_;
					ValaPropertyAccessor* _tmp408_;
					gboolean _tmp409_;
					gboolean _tmp410_;
					_tmp406_ = prop;
					_tmp407_ = vala_property_get_set_accessor (_tmp406_);
					_tmp408_ = _tmp407_;
					_tmp409_ = vala_property_accessor_get_writable (_tmp408_);
					_tmp410_ = _tmp409_;
					_tmp399_ = _tmp410_;
				} else {
					_tmp399_ = FALSE;
				}
				if (_tmp399_) {
					ValaMethod* _tmp411_ = NULL;
					ValaGirParserNode* _tmp412_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp415_;
					ValaMethod* _tmp416_;
					_tmp412_ = setter;
					if (_tmp412_ != NULL) {
						ValaGirParserNode* _tmp413_;
						ValaSymbol* _tmp414_;
						_tmp413_ = setter;
						_tmp414_ = _tmp413_->symbol;
						_tmp411_ = VALA_IS_METHOD (_tmp414_) ? ((ValaMethod*) _tmp414_) : NULL;
					} else {
						_tmp411_ = NULL;
					}
					_tmp415_ = _vala_code_node_ref0 (_tmp411_);
					m = _tmp415_;
					_tmp416_ = m;
					if (_tmp416_ != NULL) {
						ValaGirParserNode* _tmp417_;
						gboolean _tmp418_ = FALSE;
						gboolean _tmp419_ = FALSE;
						gboolean _tmp420_ = FALSE;
						ValaMethod* _tmp421_;
						ValaDataType* _tmp422_;
						ValaDataType* _tmp423_;
						_tmp417_ = setter;
						vala_gir_parser_node_process (_tmp417_, parser);
						_tmp421_ = m;
						_tmp422_ = vala_callable_get_return_type ((ValaCallable*) _tmp421_);
						_tmp423_ = _tmp422_;
						if (VALA_IS_VOID_TYPE (_tmp423_)) {
							_tmp420_ = TRUE;
						} else {
							ValaMethod* _tmp424_;
							ValaDataType* _tmp425_;
							ValaDataType* _tmp426_;
							_tmp424_ = m;
							_tmp425_ = vala_callable_get_return_type ((ValaCallable*) _tmp424_);
							_tmp426_ = _tmp425_;
							_tmp420_ = VALA_IS_BOOLEAN_TYPE (_tmp426_);
						}
						if (!_tmp420_) {
							_tmp419_ = TRUE;
						} else {
							ValaMethod* _tmp427_;
							ValaList* _tmp428_;
							gint _tmp429_;
							gint _tmp430_;
							_tmp427_ = m;
							_tmp428_ = vala_callable_get_parameters ((ValaCallable*) _tmp427_);
							_tmp429_ = vala_collection_get_size ((ValaCollection*) _tmp428_);
							_tmp430_ = _tmp429_;
							_tmp419_ = _tmp430_ != 1;
						}
						if (_tmp419_) {
							_tmp418_ = TRUE;
						} else {
							ValaMethod* _tmp431_;
							gboolean _tmp432_;
							gboolean _tmp433_;
							_tmp431_ = m;
							_tmp432_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp431_);
							_tmp433_ = _tmp432_;
							_tmp418_ = _tmp433_;
						}
						if (_tmp418_) {
							ValaProperty* _tmp434_;
							ValaProperty* _tmp435_;
							_tmp434_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp434_, "NoAccessorMethod", TRUE, NULL);
							_tmp435_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp435_, "ConcreteAccessor", FALSE, NULL);
						} else {
							ValaProperty* _tmp436_;
							ValaPropertyAccessor* _tmp437_;
							ValaPropertyAccessor* _tmp438_;
							ValaDataType* _tmp439_;
							ValaDataType* _tmp440_;
							ValaMethod* _tmp441_;
							ValaList* _tmp442_;
							gpointer _tmp443_;
							ValaParameter* _tmp444_;
							ValaDataType* _tmp445_;
							ValaDataType* _tmp446_;
							gboolean _tmp447_;
							gboolean _tmp448_;
							gboolean _tmp449_ = FALSE;
							gboolean _tmp450_ = FALSE;
							gboolean _tmp451_ = FALSE;
							ValaProperty* _tmp452_;
							ValaAttribute* _tmp453_;
							_tmp436_ = prop;
							_tmp437_ = vala_property_get_set_accessor (_tmp436_);
							_tmp438_ = _tmp437_;
							_tmp439_ = vala_property_accessor_get_value_type (_tmp438_);
							_tmp440_ = _tmp439_;
							_tmp441_ = m;
							_tmp442_ = vala_callable_get_parameters ((ValaCallable*) _tmp441_);
							_tmp443_ = vala_list_get (_tmp442_, 0);
							_tmp444_ = (ValaParameter*) _tmp443_;
							_tmp445_ = vala_variable_get_variable_type ((ValaVariable*) _tmp444_);
							_tmp446_ = _tmp445_;
							_tmp447_ = vala_data_type_get_value_owned (_tmp446_);
							_tmp448_ = _tmp447_;
							vala_data_type_set_value_owned (_tmp440_, _tmp448_);
							_vala_code_node_unref0 (_tmp444_);
							_tmp452_ = prop;
							_tmp453_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp452_, "ConcreteAccessor");
							if (_tmp453_ != NULL) {
								ValaMethod* _tmp454_;
								gboolean _tmp455_;
								gboolean _tmp456_;
								_tmp454_ = m;
								_tmp455_ = vala_method_get_is_abstract (_tmp454_);
								_tmp456_ = _tmp455_;
								_tmp451_ = !_tmp456_;
							} else {
								_tmp451_ = FALSE;
							}
							if (_tmp451_) {
								ValaMethod* _tmp457_;
								gboolean _tmp458_;
								gboolean _tmp459_;
								_tmp457_ = m;
								_tmp458_ = vala_method_get_is_virtual (_tmp457_);
								_tmp459_ = _tmp458_;
								_tmp450_ = !_tmp459_;
							} else {
								_tmp450_ = FALSE;
							}
							if (_tmp450_) {
								ValaProperty* _tmp460_;
								gboolean _tmp461_;
								gboolean _tmp462_;
								_tmp460_ = prop;
								_tmp461_ = vala_property_get_is_abstract (_tmp460_);
								_tmp462_ = _tmp461_;
								_tmp449_ = _tmp462_;
							} else {
								_tmp449_ = FALSE;
							}
							if (_tmp449_) {
								ValaProperty* _tmp463_;
								ValaProperty* _tmp464_;
								_tmp463_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp463_, "ConcreteAccessor", TRUE, NULL);
								_tmp464_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp464_, "NoAccessorMethod", FALSE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp465_;
						ValaProperty* _tmp466_;
						_tmp465_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp465_, "NoAccessorMethod", TRUE, NULL);
						_tmp466_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp466_, "ConcreteAccessor", FALSE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp467_ = prop;
				_tmp468_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp467_, "NoAccessorMethod");
				if (_tmp468_ != NULL) {
					gboolean _tmp469_ = FALSE;
					ValaProperty* _tmp470_;
					gboolean _tmp471_;
					gboolean _tmp472_;
					_tmp470_ = prop;
					_tmp471_ = vala_property_get_overrides (_tmp470_);
					_tmp472_ = _tmp471_;
					if (!_tmp472_) {
						ValaGirParserNode* _tmp473_;
						ValaSymbol* _tmp474_;
						_tmp473_ = self->parent;
						_tmp474_ = _tmp473_->symbol;
						_tmp469_ = VALA_IS_CLASS (_tmp474_);
					} else {
						_tmp469_ = FALSE;
					}
					if (_tmp469_) {
						ValaGirParserNode* base_prop_node = NULL;
						ValaGirParserNode* _tmp475_;
						ValaGirParserNode* _tmp476_;
						_tmp475_ = vala_gir_parser_base_interface_property (parser, self);
						base_prop_node = _tmp475_;
						_tmp476_ = base_prop_node;
						if (_tmp476_ != NULL) {
							ValaGirParserNode* _tmp477_;
							ValaProperty* base_property = NULL;
							ValaGirParserNode* _tmp478_;
							ValaSymbol* _tmp479_;
							ValaProperty* _tmp480_;
							ValaProperty* _tmp481_;
							ValaAttribute* _tmp482_;
							_tmp477_ = base_prop_node;
							vala_gir_parser_node_process (_tmp477_, parser);
							_tmp478_ = base_prop_node;
							_tmp479_ = _tmp478_->symbol;
							_tmp480_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp479_, VALA_TYPE_PROPERTY, ValaProperty));
							base_property = _tmp480_;
							_tmp481_ = base_property;
							_tmp482_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp481_, "ConcreteAccessor");
							if (_tmp482_ != NULL) {
								ValaProperty* _tmp483_;
								ValaProperty* _tmp484_;
								ValaPropertyAccessor* _tmp485_;
								ValaPropertyAccessor* _tmp486_;
								ValaProperty* _tmp499_;
								ValaPropertyAccessor* _tmp500_;
								ValaPropertyAccessor* _tmp501_;
								_tmp483_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp483_, "NoAccessorMethod", FALSE, NULL);
								_tmp484_ = prop;
								_tmp485_ = vala_property_get_get_accessor (_tmp484_);
								_tmp486_ = _tmp485_;
								if (_tmp486_ != NULL) {
									ValaProperty* _tmp487_;
									ValaPropertyAccessor* _tmp488_;
									ValaPropertyAccessor* _tmp489_;
									ValaDataType* _tmp490_;
									ValaDataType* _tmp491_;
									ValaProperty* _tmp492_;
									ValaPropertyAccessor* _tmp493_;
									ValaPropertyAccessor* _tmp494_;
									ValaDataType* _tmp495_;
									ValaDataType* _tmp496_;
									gboolean _tmp497_;
									gboolean _tmp498_;
									_tmp487_ = prop;
									_tmp488_ = vala_property_get_get_accessor (_tmp487_);
									_tmp489_ = _tmp488_;
									_tmp490_ = vala_property_accessor_get_value_type (_tmp489_);
									_tmp491_ = _tmp490_;
									_tmp492_ = base_property;
									_tmp493_ = vala_property_get_get_accessor (_tmp492_);
									_tmp494_ = _tmp493_;
									_tmp495_ = vala_property_accessor_get_value_type (_tmp494_);
									_tmp496_ = _tmp495_;
									_tmp497_ = vala_data_type_get_value_owned (_tmp496_);
									_tmp498_ = _tmp497_;
									vala_data_type_set_value_owned (_tmp491_, _tmp498_);
								}
								_tmp499_ = prop;
								_tmp500_ = vala_property_get_set_accessor (_tmp499_);
								_tmp501_ = _tmp500_;
								if (_tmp501_ != NULL) {
									ValaProperty* _tmp502_;
									ValaPropertyAccessor* _tmp503_;
									ValaPropertyAccessor* _tmp504_;
									ValaDataType* _tmp505_;
									ValaDataType* _tmp506_;
									ValaProperty* _tmp507_;
									ValaPropertyAccessor* _tmp508_;
									ValaPropertyAccessor* _tmp509_;
									ValaDataType* _tmp510_;
									ValaDataType* _tmp511_;
									gboolean _tmp512_;
									gboolean _tmp513_;
									_tmp502_ = prop;
									_tmp503_ = vala_property_get_set_accessor (_tmp502_);
									_tmp504_ = _tmp503_;
									_tmp505_ = vala_property_accessor_get_value_type (_tmp504_);
									_tmp506_ = _tmp505_;
									_tmp507_ = base_property;
									_tmp508_ = vala_property_get_set_accessor (_tmp507_);
									_tmp509_ = _tmp508_;
									_tmp510_ = vala_property_accessor_get_value_type (_tmp509_);
									_tmp511_ = _tmp510_;
									_tmp512_ = vala_data_type_get_value_owned (_tmp511_);
									_tmp513_ = _tmp512_;
									vala_data_type_set_value_owned (_tmp506_, _tmp513_);
								}
							}
							_vala_code_node_unref0 (base_property);
						}
						_vala_gir_parser_node_unref0 (base_prop_node);
					}
				}
				_tmp514_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp514_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD)) {
					ValaProperty* _tmp515_;
					ValaGirParserMetadata* _tmp516_;
					_tmp515_ = prop;
					_tmp516_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp515_, "NoAccessorMethod", vala_gir_parser_metadata_get_bool (_tmp516_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, FALSE), NULL);
				}
				_tmp517_ = prop;
				_tmp518_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp517_, "NoAccessorMethod");
				if (_tmp518_ != NULL) {
					ValaProperty* _tmp519_;
					ValaPropertyAccessor* _tmp520_;
					ValaPropertyAccessor* _tmp521_;
					ValaProperty* _tmp527_;
					ValaPropertyAccessor* _tmp528_;
					ValaPropertyAccessor* _tmp529_;
					_tmp519_ = prop;
					_tmp520_ = vala_property_get_get_accessor (_tmp519_);
					_tmp521_ = _tmp520_;
					if (_tmp521_ != NULL) {
						ValaProperty* _tmp522_;
						ValaPropertyAccessor* _tmp523_;
						ValaPropertyAccessor* _tmp524_;
						ValaDataType* _tmp525_;
						ValaDataType* _tmp526_;
						_tmp522_ = prop;
						_tmp523_ = vala_property_get_get_accessor (_tmp522_);
						_tmp524_ = _tmp523_;
						_tmp525_ = vala_property_accessor_get_value_type (_tmp524_);
						_tmp526_ = _tmp525_;
						vala_data_type_set_value_owned (_tmp526_, TRUE);
					}
					_tmp527_ = prop;
					_tmp528_ = vala_property_get_set_accessor (_tmp527_);
					_tmp529_ = _tmp528_;
					if (_tmp529_ != NULL) {
						ValaProperty* _tmp530_;
						ValaPropertyAccessor* _tmp531_;
						ValaPropertyAccessor* _tmp532_;
						ValaDataType* _tmp533_;
						ValaDataType* _tmp534_;
						_tmp530_ = prop;
						_tmp531_ = vala_property_get_set_accessor (_tmp530_);
						_tmp532_ = _tmp531_;
						_tmp533_ = vala_property_accessor_get_value_type (_tmp532_);
						_tmp534_ = _tmp533_;
						vala_data_type_set_value_owned (_tmp534_, FALSE);
					}
				}
				_vala_iterable_unref0 (setters);
				_vala_gir_parser_node_unref0 (setter);
				_vala_iterable_unref0 (getters);
				_vala_gir_parser_node_unref0 (getter);
				_g_free0 (construct_only);
				_g_free0 (construct_);
				_g_free0 (writable);
				_g_free0 (readable);
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (colliding);
			} else {
				ValaSymbol* _tmp535_;
				_tmp535_ = self->symbol;
				if (VALA_IS_FIELD (_tmp535_)) {
					ValaField* field = NULL;
					ValaSymbol* _tmp536_;
					ValaField* _tmp537_;
					ValaArrayList* colliding = NULL;
					ValaGirParserNode* _tmp538_;
					const gchar* _tmp539_;
					ValaArrayList* _tmp540_;
					ValaArrayList* _tmp541_;
					gint _tmp542_;
					gint _tmp543_;
					ValaGirParserMetadata* _tmp544_;
					ValaGirParserMetadata* _tmp547_;
					gboolean _tmp552_ = FALSE;
					ValaField* _tmp553_;
					ValaDataType* _tmp554_;
					ValaDataType* _tmp555_;
					_tmp536_ = self->symbol;
					_tmp537_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp536_, VALA_TYPE_FIELD, ValaField));
					field = _tmp537_;
					_tmp538_ = self->parent;
					_tmp539_ = self->name;
					_tmp540_ = vala_gir_parser_node_lookup_all (_tmp538_, _tmp539_);
					colliding = _tmp540_;
					_tmp541_ = colliding;
					_tmp542_ = vala_collection_get_size ((ValaCollection*) _tmp541_);
					_tmp543_ = _tmp542_;
					if (_tmp543_ > 1) {
						self->merged = TRUE;
					}
					_tmp544_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp544_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET)) {
						ValaField* _tmp545_;
						ValaGirParserMetadata* _tmp546_;
						_tmp545_ = field;
						_tmp546_ = self->metadata;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp545_, "CCode", "delegate_target", vala_gir_parser_metadata_get_bool (_tmp546_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, FALSE), NULL);
					}
					_tmp547_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp547_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME)) {
						ValaField* _tmp548_;
						ValaGirParserMetadata* _tmp549_;
						gchar* _tmp550_;
						gchar* _tmp551_;
						_tmp548_ = field;
						_tmp549_ = self->metadata;
						_tmp550_ = vala_gir_parser_metadata_get_string (_tmp549_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME);
						_tmp551_ = _tmp550_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp548_, "CCode", "delegate_target_cname", _tmp551_, NULL);
						_g_free0 (_tmp551_);
					}
					_tmp553_ = field;
					_tmp554_ = vala_variable_get_variable_type ((ValaVariable*) _tmp553_);
					_tmp555_ = _tmp554_;
					if (VALA_IS_DELEGATE_TYPE (_tmp555_)) {
						ValaGirParserNode* _tmp556_;
						ValaUnresolvedSymbol* _tmp557_;
						_tmp556_ = self->parent;
						_tmp557_ = _tmp556_->gtype_struct_for;
						_tmp552_ = _tmp557_ != NULL;
					} else {
						_tmp552_ = FALSE;
					}
					if (_tmp552_) {
						ValaDelegate* d = NULL;
						ValaField* _tmp558_;
						ValaDataType* _tmp559_;
						ValaDataType* _tmp560_;
						ValaDelegate* _tmp561_;
						ValaDelegate* _tmp562_;
						ValaDelegate* _tmp563_;
						ValaDelegate* _tmp564_;
						ValaGirParserNode* _tmp565_;
						ValaUnresolvedSymbol* _tmp566_;
						_tmp558_ = field;
						_tmp559_ = vala_variable_get_variable_type ((ValaVariable*) _tmp558_);
						_tmp560_ = _tmp559_;
						_tmp561_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp560_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp562_ = _tmp561_;
						_tmp563_ = _vala_code_node_ref0 (_tmp562_);
						d = _tmp563_;
						_tmp564_ = d;
						_tmp565_ = self->parent;
						_tmp566_ = _tmp565_->gtype_struct_for;
						vala_gir_parser_process_virtual_method_field (parser, self, _tmp564_, _tmp566_);
						self->merged = TRUE;
						_vala_code_node_unref0 (d);
					} else {
						ValaField* _tmp567_;
						ValaDataType* _tmp568_;
						ValaDataType* _tmp569_;
						_tmp567_ = field;
						_tmp568_ = vala_variable_get_variable_type ((ValaVariable*) _tmp567_);
						_tmp569_ = _tmp568_;
						if (VALA_IS_ARRAY_TYPE (_tmp569_)) {
							ValaGirParserNode* array_length = NULL;
							ValaGirParserMetadata* _tmp570_;
							gboolean _tmp607_ = FALSE;
							ValaGirParserNode* _tmp608_;
							_tmp570_ = self->metadata;
							if (vala_gir_parser_metadata_has_argument (_tmp570_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD)) {
								ValaGirParserNode* _tmp571_;
								ValaGirParserMetadata* _tmp572_;
								gchar* _tmp573_;
								gchar* _tmp574_;
								ValaGirParserNode* _tmp575_;
								_tmp571_ = self->parent;
								_tmp572_ = self->metadata;
								_tmp573_ = vala_gir_parser_metadata_get_string (_tmp572_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD);
								_tmp574_ = _tmp573_;
								_tmp575_ = vala_gir_parser_node_lookup (_tmp571_, _tmp574_, FALSE, NULL);
								_vala_gir_parser_node_unref0 (array_length);
								array_length = _tmp575_;
								_g_free0 (_tmp574_);
							} else {
								gboolean _tmp576_ = FALSE;
								if (self->array_length_idx > -1) {
									ValaGirParserNode* _tmp577_;
									ValaArrayList* _tmp578_;
									gint _tmp579_;
									gint _tmp580_;
									_tmp577_ = self->parent;
									_tmp578_ = _tmp577_->members;
									_tmp579_ = vala_collection_get_size ((ValaCollection*) _tmp578_);
									_tmp580_ = _tmp579_;
									_tmp576_ = _tmp580_ > self->array_length_idx;
								} else {
									_tmp576_ = FALSE;
								}
								if (_tmp576_) {
									ValaGirParserNode* _tmp581_;
									ValaArrayList* _tmp582_;
									gpointer _tmp583_;
									_tmp581_ = self->parent;
									_tmp582_ = _tmp581_->members;
									_tmp583_ = vala_list_get ((ValaList*) _tmp582_, self->array_length_idx);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = (ValaGirParserNode*) _tmp583_;
								} else {
									ValaGirParserNode* _tmp584_;
									ValaField* _tmp585_;
									const gchar* _tmp586_;
									const gchar* _tmp587_;
									gchar* _tmp588_;
									gchar* _tmp589_;
									ValaGirParserNode* _tmp590_;
									ValaGirParserNode* _tmp591_;
									_tmp584_ = self->parent;
									_tmp585_ = field;
									_tmp586_ = vala_symbol_get_name ((ValaSymbol*) _tmp585_);
									_tmp587_ = _tmp586_;
									_tmp588_ = g_strdup_printf ("n_%s", _tmp587_);
									_tmp589_ = _tmp588_;
									_tmp590_ = vala_gir_parser_node_lookup (_tmp584_, _tmp589_, FALSE, NULL);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = _tmp590_;
									_g_free0 (_tmp589_);
									_tmp591_ = array_length;
									if (_tmp591_ == NULL) {
										ValaGirParserNode* _tmp592_;
										ValaField* _tmp593_;
										const gchar* _tmp594_;
										const gchar* _tmp595_;
										gchar* _tmp596_;
										gchar* _tmp597_;
										ValaGirParserNode* _tmp598_;
										ValaGirParserNode* _tmp599_;
										_tmp592_ = self->parent;
										_tmp593_ = field;
										_tmp594_ = vala_symbol_get_name ((ValaSymbol*) _tmp593_);
										_tmp595_ = _tmp594_;
										_tmp596_ = g_strdup_printf ("num_%s", _tmp595_);
										_tmp597_ = _tmp596_;
										_tmp598_ = vala_gir_parser_node_lookup (_tmp592_, _tmp597_, FALSE, NULL);
										_vala_gir_parser_node_unref0 (array_length);
										array_length = _tmp598_;
										_g_free0 (_tmp597_);
										_tmp599_ = array_length;
										if (_tmp599_ == NULL) {
											ValaGirParserNode* _tmp600_;
											ValaField* _tmp601_;
											const gchar* _tmp602_;
											const gchar* _tmp603_;
											gchar* _tmp604_;
											gchar* _tmp605_;
											ValaGirParserNode* _tmp606_;
											_tmp600_ = self->parent;
											_tmp601_ = field;
											_tmp602_ = vala_symbol_get_name ((ValaSymbol*) _tmp601_);
											_tmp603_ = _tmp602_;
											_tmp604_ = g_strdup_printf ("%s_length", _tmp603_);
											_tmp605_ = _tmp604_;
											_tmp606_ = vala_gir_parser_node_lookup (_tmp600_, _tmp605_, FALSE, NULL);
											_vala_gir_parser_node_unref0 (array_length);
											array_length = _tmp606_;
											_g_free0 (_tmp605_);
										}
									}
								}
							}
							_tmp608_ = array_length;
							if (_tmp608_ != NULL) {
								ValaGirParserNode* _tmp609_;
								ValaSymbol* _tmp610_;
								_tmp609_ = array_length;
								_tmp610_ = _tmp609_->symbol;
								_tmp607_ = VALA_IS_FIELD (_tmp610_);
							} else {
								_tmp607_ = FALSE;
							}
							if (_tmp607_) {
								ValaField* length_field = NULL;
								ValaGirParserNode* _tmp611_;
								ValaSymbol* _tmp612_;
								ValaField* _tmp613_;
								ValaField* _tmp614_;
								ValaField* _tmp615_;
								const gchar* _tmp616_;
								const gchar* _tmp617_;
								gchar* length_type = NULL;
								ValaField* _tmp618_;
								ValaDataType* _tmp619_;
								ValaDataType* _tmp620_;
								gchar* _tmp621_;
								const gchar* _tmp622_;
								ValaField* _tmp631_;
								ValaField* _tmp632_;
								_tmp611_ = array_length;
								_tmp612_ = _tmp611_->symbol;
								_tmp613_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp612_, VALA_TYPE_FIELD, ValaField));
								length_field = _tmp613_;
								_tmp614_ = field;
								_tmp615_ = length_field;
								_tmp616_ = vala_symbol_get_name ((ValaSymbol*) _tmp615_);
								_tmp617_ = _tmp616_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp614_, "CCode", "array_length_cname", _tmp617_, NULL);
								_tmp618_ = length_field;
								_tmp619_ = vala_variable_get_variable_type ((ValaVariable*) _tmp618_);
								_tmp620_ = _tmp619_;
								_tmp621_ = vala_data_type_to_qualified_string (_tmp620_, NULL);
								length_type = _tmp621_;
								_tmp622_ = length_type;
								if (g_strcmp0 (_tmp622_, "int") != 0) {
									ValaGirParserNode* st = NULL;
									ValaGirParserNode* _tmp623_;
									const gchar* _tmp624_;
									ValaGirParserNode* _tmp625_;
									ValaGirParserNode* _tmp626_;
									_tmp623_ = parser->priv->root;
									_tmp624_ = length_type;
									_tmp625_ = vala_gir_parser_node_lookup (_tmp623_, _tmp624_, FALSE, NULL);
									st = _tmp625_;
									_tmp626_ = st;
									if (_tmp626_ != NULL) {
										ValaField* _tmp627_;
										ValaGirParserNode* _tmp628_;
										gchar* _tmp629_;
										gchar* _tmp630_;
										_tmp627_ = field;
										_tmp628_ = st;
										_tmp629_ = vala_gir_parser_node_get_cname (_tmp628_);
										_tmp630_ = _tmp629_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp627_, "CCode", "array_length_type", _tmp630_, NULL);
										_g_free0 (_tmp630_);
									}
									_vala_gir_parser_node_unref0 (st);
								}
								_tmp631_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp631_, "CCode", "array_length");
								_tmp632_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp632_, "CCode", "array_null_terminated");
								_g_free0 (length_type);
								_vala_code_node_unref0 (length_field);
							}
							_vala_gir_parser_node_unref0 (array_length);
						}
					}
					_vala_iterable_unref0 (colliding);
					_vala_code_node_unref0 (field);
				} else {
					gboolean _tmp633_ = FALSE;
					ValaSymbol* _tmp634_;
					_tmp634_ = self->symbol;
					if (VALA_IS_SIGNAL (_tmp634_)) {
						_tmp633_ = TRUE;
					} else {
						ValaSymbol* _tmp635_;
						_tmp635_ = self->symbol;
						_tmp633_ = VALA_IS_DELEGATE (_tmp635_);
					}
					if (_tmp633_) {
						vala_gir_parser_process_callable (parser, self);
					} else {
						ValaSymbol* _tmp636_;
						_tmp636_ = self->symbol;
						if (VALA_IS_INTERFACE (_tmp636_)) {
							vala_gir_parser_process_interface (parser, self);
						} else {
							ValaSymbol* _tmp637_;
							_tmp637_ = self->symbol;
							if (VALA_IS_STRUCT (_tmp637_)) {
								gboolean _tmp638_ = FALSE;
								ValaGirParserNode* _tmp639_;
								ValaSymbol* _tmp640_;
								_tmp639_ = self->parent;
								_tmp640_ = _tmp639_->symbol;
								if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp640_)) {
									_tmp638_ = TRUE;
								} else {
									ValaGirParserNode* _tmp641_;
									ValaSymbol* _tmp642_;
									_tmp641_ = self->parent;
									_tmp642_ = _tmp641_->symbol;
									_tmp638_ = VALA_IS_STRUCT (_tmp642_);
								}
								if (_tmp638_) {
									{
										ValaArrayList* _fn_list = NULL;
										ValaArrayList* _tmp643_;
										ValaArrayList* _tmp644_;
										gint _fn_size = 0;
										ValaArrayList* _tmp645_;
										gint _tmp646_;
										gint _tmp647_;
										gint _fn_index = 0;
										_tmp643_ = self->members;
										_tmp644_ = _vala_iterable_ref0 (_tmp643_);
										_fn_list = _tmp644_;
										_tmp645_ = _fn_list;
										_tmp646_ = vala_collection_get_size ((ValaCollection*) _tmp645_);
										_tmp647_ = _tmp646_;
										_fn_size = _tmp647_;
										_fn_index = -1;
										while (TRUE) {
											gint _tmp648_;
											gint _tmp649_;
											ValaGirParserNode* fn = NULL;
											ValaArrayList* _tmp650_;
											gpointer _tmp651_;
											ValaField* f = NULL;
											ValaGirParserNode* _tmp652_;
											ValaSymbol* _tmp653_;
											ValaField* _tmp654_;
											ValaField* _tmp655_;
											_fn_index = _fn_index + 1;
											_tmp648_ = _fn_index;
											_tmp649_ = _fn_size;
											if (!(_tmp648_ < _tmp649_)) {
												break;
											}
											_tmp650_ = _fn_list;
											_tmp651_ = vala_list_get ((ValaList*) _tmp650_, _fn_index);
											fn = (ValaGirParserNode*) _tmp651_;
											_tmp652_ = fn;
											_tmp653_ = _tmp652_->symbol;
											_tmp654_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp653_) ? ((ValaField*) _tmp653_) : NULL);
											f = _tmp654_;
											_tmp655_ = f;
											if (_tmp655_ != NULL) {
												ValaField* _tmp656_;
												ValaMemberBinding _tmp657_;
												ValaMemberBinding _tmp658_;
												ValaField* _tmp666_;
												ValaSymbol* _tmp667_;
												const gchar* _tmp668_;
												const gchar* _tmp669_;
												ValaField* _tmp670_;
												const gchar* _tmp671_;
												const gchar* _tmp672_;
												gchar* _tmp673_;
												gchar* _tmp674_;
												ValaGirParserNode* _tmp675_;
												ValaField* _tmp676_;
												const gchar* _tmp677_;
												const gchar* _tmp678_;
												gchar* _tmp679_;
												ValaGirParserNode* _tmp680_;
												ValaGirParserNode* _tmp681_;
												_tmp656_ = f;
												_tmp657_ = vala_field_get_binding (_tmp656_);
												_tmp658_ = _tmp657_;
												if (_tmp658_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp659_;
													const gchar* _tmp660_;
													ValaGirParserNode* _tmp661_;
													gchar* _tmp662_;
													gchar* _tmp663_;
													gchar* _tmp664_;
													gchar* _tmp665_;
													_tmp659_ = f;
													_tmp660_ = self->name;
													_tmp661_ = fn;
													_tmp662_ = vala_gir_parser_node_get_cname (_tmp661_);
													_tmp663_ = _tmp662_;
													_tmp664_ = g_strdup_printf ("%s.%s", _tmp660_, _tmp663_);
													_tmp665_ = _tmp664_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp659_, "CCode", "cname", _tmp665_, NULL);
													_g_free0 (_tmp665_);
													_g_free0 (_tmp663_);
												}
												_tmp666_ = f;
												_tmp667_ = self->symbol;
												_tmp668_ = vala_symbol_get_name (_tmp667_);
												_tmp669_ = _tmp668_;
												_tmp670_ = f;
												_tmp671_ = vala_symbol_get_name ((ValaSymbol*) _tmp670_);
												_tmp672_ = _tmp671_;
												_tmp673_ = g_strdup_printf ("%s_%s", _tmp669_, _tmp672_);
												_tmp674_ = _tmp673_;
												vala_symbol_set_name ((ValaSymbol*) _tmp666_, _tmp674_);
												_g_free0 (_tmp674_);
												_tmp675_ = fn;
												_tmp676_ = f;
												_tmp677_ = vala_symbol_get_name ((ValaSymbol*) _tmp676_);
												_tmp678_ = _tmp677_;
												_tmp679_ = g_strdup (_tmp678_);
												_g_free0 (_tmp675_->name);
												_tmp675_->name = _tmp679_;
												_tmp680_ = self->parent;
												_tmp681_ = fn;
												vala_gir_parser_node_add_member (_tmp680_, _tmp681_);
											}
											_vala_code_node_unref0 (f);
											_vala_gir_parser_node_unref0 (fn);
										}
										_vala_iterable_unref0 (_fn_list);
									}
									self->merged = TRUE;
								} else {
									gchar* gtype_struct_for = NULL;
									ValaMap* _tmp682_;
									gpointer _tmp683_;
									const gchar* _tmp684_;
									_tmp682_ = self->girdata;
									_tmp683_ = vala_map_get (_tmp682_, "glib:is-gtype-struct-for");
									gtype_struct_for = (gchar*) _tmp683_;
									_tmp684_ = gtype_struct_for;
									if (_tmp684_ != NULL) {
										ValaGirParserNode* iface = NULL;
										ValaGirParserNode* _tmp685_;
										const gchar* _tmp686_;
										ValaSourceReference* _tmp687_;
										ValaUnresolvedSymbol* _tmp688_;
										ValaUnresolvedSymbol* _tmp689_;
										ValaGirParserNode* _tmp690_;
										ValaGirParserNode* _tmp691_;
										gboolean _tmp692_ = FALSE;
										gboolean _tmp693_ = FALSE;
										ValaGirParserNode* _tmp694_;
										_tmp685_ = self->parent;
										_tmp686_ = gtype_struct_for;
										_tmp687_ = self->source_reference;
										_tmp688_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp686_, _tmp687_);
										_tmp689_ = _tmp688_;
										_tmp690_ = vala_gir_parser_resolve_node (parser, _tmp685_, _tmp689_, FALSE);
										_tmp691_ = _tmp690_;
										_vala_code_node_unref0 (_tmp689_);
										iface = _tmp691_;
										_tmp694_ = iface;
										if (_tmp694_ != NULL) {
											ValaGirParserNode* _tmp695_;
											ValaSymbol* _tmp696_;
											_tmp695_ = iface;
											_tmp696_ = _tmp695_->symbol;
											_tmp693_ = VALA_IS_INTERFACE (_tmp696_);
										} else {
											_tmp693_ = FALSE;
										}
										if (_tmp693_) {
											ValaGirParserNode* _tmp697_;
											gchar* _tmp698_;
											gchar* _tmp699_;
											gchar* _tmp700_;
											gchar* _tmp701_;
											gchar* _tmp702_;
											gchar* _tmp703_;
											_tmp697_ = iface;
											_tmp698_ = vala_gir_parser_node_get_cname (_tmp697_);
											_tmp699_ = _tmp698_;
											_tmp700_ = g_strdup_printf ("%sIface", _tmp699_);
											_tmp701_ = _tmp700_;
											_tmp702_ = vala_gir_parser_node_get_cname (self);
											_tmp703_ = _tmp702_;
											_tmp692_ = g_strcmp0 (_tmp701_, _tmp703_) != 0;
											_g_free0 (_tmp703_);
											_g_free0 (_tmp701_);
											_g_free0 (_tmp699_);
										} else {
											_tmp692_ = FALSE;
										}
										if (_tmp692_) {
											ValaGirParserNode* _tmp704_;
											ValaSymbol* _tmp705_;
											gchar* _tmp706_;
											gchar* _tmp707_;
											_tmp704_ = iface;
											_tmp705_ = _tmp704_->symbol;
											_tmp706_ = vala_gir_parser_node_get_cname (self);
											_tmp707_ = _tmp706_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp705_, "CCode", "type_cname", _tmp707_, NULL);
											_g_free0 (_tmp707_);
										}
										self->merged = TRUE;
										_vala_gir_parser_node_unref0 (iface);
									}
									_g_free0 (gtype_struct_for);
								}
							}
						}
					}
				}
			}
		}
		_tmp708_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp708_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT)) {
			ValaGirParserMetadata* _tmp709_;
			gchar* _tmp710_;
			self->deprecated = TRUE;
			_tmp709_ = self->metadata;
			_tmp710_ = vala_gir_parser_metadata_get_string (_tmp709_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT);
			_g_free0 (self->deprecated_replacement);
			self->deprecated_replacement = _tmp710_;
		}
		_tmp711_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp711_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE)) {
			ValaGirParserMetadata* _tmp712_;
			gchar* _tmp713_;
			self->deprecated = TRUE;
			_tmp712_ = self->metadata;
			_tmp713_ = vala_gir_parser_metadata_get_string (_tmp712_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE);
			_g_free0 (self->deprecated_since);
			self->deprecated_since = _tmp713_;
		} else {
			ValaMap* _tmp714_;
			gpointer _tmp715_;
			gchar* _tmp716_;
			gboolean _tmp717_;
			_tmp714_ = self->girdata;
			_tmp715_ = vala_map_get (_tmp714_, "deprecated-version");
			_tmp716_ = (gchar*) _tmp715_;
			_tmp717_ = _tmp716_ != NULL;
			_g_free0 (_tmp716_);
			if (_tmp717_) {
				ValaMap* _tmp718_;
				gpointer _tmp719_;
				self->deprecated = TRUE;
				_tmp718_ = self->girdata;
				_tmp719_ = vala_map_get (_tmp718_, "deprecated-version");
				_g_free0 (self->deprecated_since);
				self->deprecated_since = (gchar*) _tmp719_;
			}
		}
		_tmp720_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp720_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED)) {
			ValaGirParserMetadata* _tmp721_;
			_tmp721_ = self->metadata;
			self->deprecated = vala_gir_parser_metadata_get_bool (_tmp721_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, TRUE);
			if (!self->deprecated) {
				_g_free0 (self->deprecated_since);
				self->deprecated_since = NULL;
				_g_free0 (self->deprecated_replacement);
				self->deprecated_replacement = NULL;
			}
		} else {
			ValaMap* _tmp722_;
			gpointer _tmp723_;
			gchar* _tmp724_;
			gboolean _tmp725_;
			_tmp722_ = self->girdata;
			_tmp723_ = vala_map_get (_tmp722_, "deprecated");
			_tmp724_ = (gchar*) _tmp723_;
			_tmp725_ = _tmp724_ != NULL;
			_g_free0 (_tmp724_);
			if (_tmp725_) {
				self->deprecated = TRUE;
			}
		}
		_tmp726_ = self->deprecated_since;
		if (_tmp726_ != NULL) {
			const gchar* _tmp727_;
			_tmp727_ = self->deprecated_since;
			self->deprecated_version = vala_gir_parser_node_parse_version_string (_tmp727_);
		}
		_tmp728_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp728_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL)) {
			ValaSymbol* _tmp729_;
			ValaGirParserMetadata* _tmp730_;
			_tmp729_ = self->symbol;
			_tmp730_ = self->metadata;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp729_, "Version", "experimental", vala_gir_parser_metadata_get_bool (_tmp730_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, FALSE), NULL);
		}
		_tmp731_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp731_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE)) {
			ValaSymbol* _tmp732_;
			ValaVersionAttribute* _tmp733_;
			ValaVersionAttribute* _tmp734_;
			ValaGirParserMetadata* _tmp735_;
			gchar* _tmp736_;
			gchar* _tmp737_;
			_tmp732_ = self->symbol;
			_tmp733_ = vala_symbol_get_version (_tmp732_);
			_tmp734_ = _tmp733_;
			_tmp735_ = self->metadata;
			_tmp736_ = vala_gir_parser_metadata_get_string (_tmp735_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE);
			_tmp737_ = _tmp736_;
			vala_version_attribute_set_since (_tmp734_, _tmp737_);
			_g_free0 (_tmp737_);
		} else {
			gboolean _tmp738_ = FALSE;
			ValaSymbol* _tmp739_;
			_tmp739_ = self->symbol;
			if (VALA_IS_NAMESPACE (_tmp739_) == FALSE) {
				ValaMap* _tmp740_;
				gpointer _tmp741_;
				gchar* _tmp742_;
				_tmp740_ = self->girdata;
				_tmp741_ = vala_map_get (_tmp740_, "version");
				_tmp742_ = (gchar*) _tmp741_;
				_tmp738_ = _tmp742_ != NULL;
				_g_free0 (_tmp742_);
			} else {
				_tmp738_ = FALSE;
			}
			if (_tmp738_) {
				ValaSymbol* _tmp743_;
				ValaVersionAttribute* _tmp744_;
				ValaVersionAttribute* _tmp745_;
				ValaMap* _tmp746_;
				gpointer _tmp747_;
				gchar* _tmp748_;
				_tmp743_ = self->symbol;
				_tmp744_ = vala_symbol_get_version (_tmp743_);
				_tmp745_ = _tmp744_;
				_tmp746_ = self->girdata;
				_tmp747_ = vala_map_get (_tmp746_, "version");
				_tmp748_ = (gchar*) _tmp747_;
				vala_version_attribute_set_since (_tmp745_, _tmp748_);
				_g_free0 (_tmp748_);
			}
		}
		_tmp749_ = self->parent;
		_tmp750_ = _tmp749_->symbol;
		if (VALA_IS_NAMESPACE (_tmp750_)) {
			ValaSymbol* _tmp751_;
			gchar* _tmp752_;
			gchar* _tmp753_;
			_tmp751_ = self->symbol;
			_tmp752_ = vala_gir_parser_node_get_cheader_filename (self);
			_tmp753_ = _tmp752_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp751_, "CCode", "cheader_filename", _tmp753_, NULL);
			_g_free0 (_tmp753_);
		} else {
			ValaGirParserMetadata* _tmp754_;
			_tmp754_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp754_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
				ValaSymbol* _tmp755_;
				ValaGirParserMetadata* _tmp756_;
				gchar* _tmp757_;
				gchar* _tmp758_;
				_tmp755_ = self->symbol;
				_tmp756_ = self->metadata;
				_tmp757_ = vala_gir_parser_metadata_get_string (_tmp756_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
				_tmp758_ = _tmp757_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp755_, "CCode", "cheader_filename", _tmp758_, NULL);
				_g_free0 (_tmp758_);
			}
		}
		_tmp759_ = vala_gir_parser_node_get_cname (self);
		_tmp760_ = _tmp759_;
		_tmp761_ = vala_gir_parser_node_get_default_cname (self);
		_tmp762_ = _tmp761_;
		_tmp763_ = g_strcmp0 (_tmp760_, _tmp762_) != 0;
		_g_free0 (_tmp762_);
		_g_free0 (_tmp760_);
		if (_tmp763_) {
			ValaSymbol* _tmp764_;
			gchar* _tmp765_;
			gchar* _tmp766_;
			_tmp764_ = self->symbol;
			_tmp765_ = vala_gir_parser_node_get_cname (self);
			_tmp766_ = _tmp765_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp764_, "CCode", "cname", _tmp766_, NULL);
			_g_free0 (_tmp766_);
		}
		_tmp767_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp767_, VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO)) {
			ValaSymbol* _tmp768_;
			ValaGirParserMetadata* _tmp769_;
			gchar* _tmp770_;
			gchar* _tmp771_;
			_tmp768_ = self->symbol;
			_tmp769_ = self->metadata;
			_tmp770_ = vala_gir_parser_metadata_get_string (_tmp769_, VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO);
			_tmp771_ = _tmp770_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp768_, "CCode", "feature_test_macro", _tmp771_, NULL);
			_g_free0 (_tmp771_);
		}
		_tmp772_ = vala_gir_parser_node_get_lower_case_cprefix (self);
		_tmp773_ = _tmp772_;
		_tmp774_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_tmp775_ = _tmp774_;
		_tmp776_ = g_strcmp0 (_tmp773_, _tmp775_) != 0;
		_g_free0 (_tmp775_);
		_g_free0 (_tmp773_);
		if (_tmp776_) {
			ValaSymbol* _tmp777_;
			gchar* _tmp778_;
			gchar* _tmp779_;
			_tmp777_ = self->symbol;
			_tmp778_ = vala_gir_parser_node_get_lower_case_cprefix (self);
			_tmp779_ = _tmp778_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp777_, "CCode", "lower_case_cprefix", _tmp779_, NULL);
			_g_free0 (_tmp779_);
		}
		_tmp780_ = vala_gir_parser_node_get_lower_case_csuffix (self);
		_tmp781_ = _tmp780_;
		_tmp782_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_tmp783_ = _tmp782_;
		_tmp784_ = g_strcmp0 (_tmp781_, _tmp783_) != 0;
		_g_free0 (_tmp783_);
		_g_free0 (_tmp781_);
		if (_tmp784_) {
			ValaSymbol* _tmp785_;
			gchar* _tmp786_;
			gchar* _tmp787_;
			_tmp785_ = self->symbol;
			_tmp786_ = vala_gir_parser_node_get_lower_case_csuffix (self);
			_tmp787_ = _tmp786_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp785_, "CCode", "lower_case_csuffix", _tmp787_, NULL);
			_g_free0 (_tmp787_);
		}
		_tmp788_ = vala_gir_parser_node_get_gir_name (self);
		gir_name = _tmp788_;
		_tmp789_ = vala_gir_parser_node_get_default_gir_name (self);
		default_gir_name = _tmp789_;
		_tmp792_ = self->symbol;
		if (vala_gir_parser_is_container (_tmp792_)) {
			ValaSymbol* _tmp793_;
			_tmp793_ = self->symbol;
			_tmp791_ = !VALA_IS_NAMESPACE (_tmp793_);
		} else {
			_tmp791_ = FALSE;
		}
		if (_tmp791_) {
			gboolean _tmp794_ = FALSE;
			const gchar* _tmp795_;
			const gchar* _tmp796_;
			_tmp795_ = self->name;
			_tmp796_ = gir_name;
			if (g_strcmp0 (_tmp795_, _tmp796_) != 0) {
				_tmp794_ = TRUE;
			} else {
				const gchar* _tmp797_;
				const gchar* _tmp798_;
				_tmp797_ = gir_name;
				_tmp798_ = default_gir_name;
				_tmp794_ = g_strcmp0 (_tmp797_, _tmp798_) != 0;
			}
			_tmp790_ = _tmp794_;
		} else {
			_tmp790_ = FALSE;
		}
		if (_tmp790_) {
			ValaSymbol* _tmp799_;
			const gchar* _tmp800_;
			_tmp799_ = self->symbol;
			_tmp800_ = gir_name;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp799_, "GIR", "name", _tmp800_, NULL);
		}
		_g_free0 (default_gir_name);
		_g_free0 (gir_name);
	}
	if (self->new_symbol) {
		_tmp802_ = self->merged;
	} else {
		_tmp802_ = FALSE;
	}
	if (!_tmp802_) {
		ValaSymbol* _tmp803_;
		_tmp803_ = self->symbol;
		_tmp801_ = vala_gir_parser_is_container (_tmp803_);
	} else {
		_tmp801_ = FALSE;
	}
	if (_tmp801_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp848_;
		ValaClass* _tmp849_;
		gboolean _tmp850_ = FALSE;
		gboolean _tmp851_ = FALSE;
		ValaClass* _tmp852_;
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp804_;
			ValaArrayList* _tmp805_;
			gint _node_size = 0;
			ValaArrayList* _tmp806_;
			gint _tmp807_;
			gint _tmp808_;
			gint _node_index = 0;
			_tmp804_ = self->members;
			_tmp805_ = _vala_iterable_ref0 (_tmp804_);
			_node_list = _tmp805_;
			_tmp806_ = _node_list;
			_tmp807_ = vala_collection_get_size ((ValaCollection*) _tmp806_);
			_tmp808_ = _tmp807_;
			_node_size = _tmp808_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp809_;
				gint _tmp810_;
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp811_;
				gpointer _tmp812_;
				gboolean _tmp813_ = FALSE;
				ValaGirParserNode* _tmp819_;
				ValaGirParserNode* _tmp824_;
				const gchar* _tmp825_;
				ValaGirParserNode* _tmp832_;
				const gchar* _tmp833_;
				gboolean _tmp840_ = FALSE;
				gboolean _tmp841_ = FALSE;
				ValaGirParserNode* _tmp842_;
				_node_index = _node_index + 1;
				_tmp809_ = _node_index;
				_tmp810_ = _node_size;
				if (!(_tmp809_ < _tmp810_)) {
					break;
				}
				_tmp811_ = _node_list;
				_tmp812_ = vala_list_get ((ValaList*) _tmp811_, _node_index);
				node = (ValaGirParserNode*) _tmp812_;
				if (self->deprecated_version > ((guint64) 0)) {
					ValaGirParserNode* _tmp814_;
					_tmp814_ = node;
					_tmp813_ = _tmp814_->deprecated_version > ((guint64) 0);
				} else {
					_tmp813_ = FALSE;
				}
				if (_tmp813_) {
					ValaGirParserNode* _tmp815_;
					_tmp815_ = node;
					if (self->deprecated_version <= _tmp815_->deprecated_version) {
						ValaGirParserNode* _tmp816_;
						ValaGirParserNode* _tmp817_;
						ValaGirParserNode* _tmp818_;
						_tmp816_ = node;
						_tmp816_->deprecated = FALSE;
						_tmp817_ = node;
						_g_free0 (_tmp817_->deprecated_since);
						_tmp817_->deprecated_since = NULL;
						_tmp818_ = node;
						_g_free0 (_tmp818_->deprecated_replacement);
						_tmp818_->deprecated_replacement = NULL;
					}
				}
				_tmp819_ = node;
				if (_tmp819_->deprecated) {
					ValaGirParserNode* _tmp820_;
					ValaSymbol* _tmp821_;
					ValaVersionAttribute* _tmp822_;
					ValaVersionAttribute* _tmp823_;
					_tmp820_ = node;
					_tmp821_ = _tmp820_->symbol;
					_tmp822_ = vala_symbol_get_version (_tmp821_);
					_tmp823_ = _tmp822_;
					vala_version_attribute_set_deprecated (_tmp823_, TRUE);
				}
				_tmp824_ = node;
				_tmp825_ = _tmp824_->deprecated_since;
				if (_tmp825_ != NULL) {
					ValaGirParserNode* _tmp826_;
					ValaSymbol* _tmp827_;
					ValaVersionAttribute* _tmp828_;
					ValaVersionAttribute* _tmp829_;
					ValaGirParserNode* _tmp830_;
					const gchar* _tmp831_;
					_tmp826_ = node;
					_tmp827_ = _tmp826_->symbol;
					_tmp828_ = vala_symbol_get_version (_tmp827_);
					_tmp829_ = _tmp828_;
					_tmp830_ = node;
					_tmp831_ = _tmp830_->deprecated_since;
					vala_version_attribute_set_deprecated_since (_tmp829_, _tmp831_);
				}
				_tmp832_ = node;
				_tmp833_ = _tmp832_->deprecated_replacement;
				if (_tmp833_ != NULL) {
					ValaGirParserNode* _tmp834_;
					ValaSymbol* _tmp835_;
					ValaVersionAttribute* _tmp836_;
					ValaVersionAttribute* _tmp837_;
					ValaGirParserNode* _tmp838_;
					const gchar* _tmp839_;
					_tmp834_ = node;
					_tmp835_ = _tmp834_->symbol;
					_tmp836_ = vala_symbol_get_version (_tmp835_);
					_tmp837_ = _tmp836_;
					_tmp838_ = node;
					_tmp839_ = _tmp838_->deprecated_replacement;
					vala_version_attribute_set_replacement (_tmp837_, _tmp839_);
				}
				_tmp842_ = node;
				if (_tmp842_->new_symbol) {
					ValaGirParserNode* _tmp843_;
					_tmp843_ = node;
					_tmp841_ = !_tmp843_->merged;
				} else {
					_tmp841_ = FALSE;
				}
				if (_tmp841_) {
					ValaGirParserMetadata* _tmp844_;
					_tmp844_ = self->metadata;
					_tmp840_ = !vala_gir_parser_metadata_get_bool (_tmp844_, VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, FALSE);
				} else {
					_tmp840_ = FALSE;
				}
				if (_tmp840_) {
					ValaSymbol* _tmp845_;
					ValaGirParserNode* _tmp846_;
					ValaSymbol* _tmp847_;
					_tmp845_ = self->symbol;
					_tmp846_ = node;
					_tmp847_ = _tmp846_->symbol;
					vala_gir_parser_add_symbol_to_container (_tmp845_, _tmp847_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		_tmp848_ = self->symbol;
		_tmp849_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp848_) ? ((ValaClass*) _tmp848_) : NULL);
		cl = _tmp849_;
		_tmp852_ = cl;
		if (_tmp852_ != NULL) {
			ValaClass* _tmp853_;
			gboolean _tmp854_;
			gboolean _tmp855_;
			_tmp853_ = cl;
			_tmp854_ = vala_class_get_is_compact (_tmp853_);
			_tmp855_ = _tmp854_;
			_tmp851_ = !_tmp855_;
		} else {
			_tmp851_ = FALSE;
		}
		if (_tmp851_) {
			ValaClass* _tmp856_;
			ValaCreationMethod* _tmp857_;
			ValaCreationMethod* _tmp858_;
			_tmp856_ = cl;
			_tmp857_ = vala_class_get_default_construction_method (_tmp856_);
			_tmp858_ = _tmp857_;
			_tmp850_ = _tmp858_ == NULL;
		} else {
			_tmp850_ = FALSE;
		}
		if (_tmp850_) {
			ValaCreationMethod* cm = NULL;
			ValaClass* _tmp859_;
			ValaSourceReference* _tmp860_;
			ValaSourceReference* _tmp861_;
			ValaCreationMethod* _tmp862_;
			ValaCreationMethod* _tmp863_;
			ValaCreationMethod* _tmp864_;
			ValaClass* _tmp865_;
			ValaCreationMethod* _tmp866_;
			_tmp859_ = cl;
			_tmp860_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp859_);
			_tmp861_ = _tmp860_;
			_tmp862_ = vala_creation_method_new (NULL, NULL, _tmp861_, NULL);
			cm = _tmp862_;
			_tmp863_ = cm;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp863_, FALSE);
			_tmp864_ = cm;
			vala_symbol_set_access ((ValaSymbol*) _tmp864_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
			_tmp865_ = cl;
			_tmp866_ = cm;
			vala_symbol_add_method ((ValaSymbol*) _tmp865_, (ValaMethod*) _tmp866_);
			_vala_code_node_unref0 (cm);
		}
		_vala_code_node_unref0 (cl);
	}
	self->processed = TRUE;
}

static gchar*
vala_gir_parser_node_to_string (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = g_strdup_printf ("%s.%s", _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}

static void
vala_gir_parser_value_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_node_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_node_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_node_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_node_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ValaGirParserNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_node (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ValaGirParserParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_node (GValue* value,
                                gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}

static void
vala_gir_parser_value_take_node (GValue* value,
                                 gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}

static void
vala_gir_parser_node_class_init (ValaGirParserNodeClass * klass,
                                 gpointer klass_data)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	vala_gir_parser_node_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserNodeClass *) klass)->finalize = vala_gir_parser_node_finalize;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp0_);
	vala_gir_parser_node_new_namespaces = _tmp1_;
}

static void
vala_gir_parser_node_instance_init (ValaGirParserNode * self,
                                    gpointer klass)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashMap* _tmp8_;
	self->girdata = NULL;
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	self->metadata = _tmp2_;
	self->source_reference = NULL;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp3_);
	self->members = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp5_, _tmp6_, _tmp7_);
	self->scope = _tmp8_;
	self->return_array_length_idx = -1;
	self->array_length_idx = -1;
	self->deprecated = FALSE;
	self->deprecated_version = (guint64) 0;
	self->deprecated_since = NULL;
	self->deprecated_replacement = NULL;
	self->ref_count = 1;
}

static void
vala_gir_parser_node_finalize (ValaGirParserNode * obj)
{
	ValaGirParserNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode);
	g_signal_handlers_destroy (self);
	_g_free0 (self->element_type);
	_g_free0 (self->name);
	_vala_map_unref0 (self->girdata);
	_vala_gir_parser_metadata_unref0 (self->metadata);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_iterable_unref0 (self->members);
	_vala_map_unref0 (self->scope);
	_vala_comment_unref0 (self->comment);
	_vala_code_node_unref0 (self->symbol);
	_vala_iterable_unref0 (self->parameters);
	_vala_iterable_unref0 (self->array_length_parameters);
	_vala_iterable_unref0 (self->closure_parameters);
	_vala_iterable_unref0 (self->destroy_parameters);
	_vala_code_node_unref0 (self->gtype_struct_for);
	_vala_code_node_unref0 (self->base_type);
	_g_free0 (self->deprecated_since);
	_g_free0 (self->deprecated_replacement);
}

static GType
vala_gir_parser_node_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_node_init, vala_gir_parser_value_node_free_value, vala_gir_parser_value_node_copy_value, vala_gir_parser_value_node_peek_pointer, "p", vala_gir_parser_value_node_collect_value, "p", vala_gir_parser_value_node_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserNode), 0, (GInstanceInitFunc) vala_gir_parser_node_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_node_type_id;
	vala_gir_parser_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_node_type_id;
}

static GType
vala_gir_parser_node_get_type (void)
{
	static volatile gsize vala_gir_parser_node_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_node_type_id__volatile)) {
		GType vala_gir_parser_node_type_id;
		vala_gir_parser_node_type_id = vala_gir_parser_node_get_type_once ();
		g_once_init_leave (&vala_gir_parser_node_type_id__volatile, vala_gir_parser_node_type_id);
	}
	return vala_gir_parser_node_type_id__volatile;
}

static gpointer
vala_gir_parser_node_ref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_node_unref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_construct (GType object_type,
                                          ValaParameter* param,
                                          gint array_length_idx,
                                          gint closure_idx,
                                          gint destroy_idx,
                                          gboolean is_async)
{
	ValaGirParserParameterInfo* self = NULL;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (param != NULL, NULL);
	self = (ValaGirParserParameterInfo*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (param);
	_vala_code_node_unref0 (self->param);
	self->param = _tmp0_;
	self->array_length_idx = array_length_idx;
	self->closure_idx = closure_idx;
	self->destroy_idx = destroy_idx;
	self->vala_idx = 0.0F;
	self->keep = TRUE;
	self->is_async = is_async;
	return self;
}

static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_new (ValaParameter* param,
                                    gint array_length_idx,
                                    gint closure_idx,
                                    gint destroy_idx,
                                    gboolean is_async)
{
	return vala_gir_parser_parameter_info_construct (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, param, array_length_idx, closure_idx, destroy_idx, is_async);
}

static void
vala_gir_parser_value_parameter_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_parameter_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_parameter_info_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_parameter_info_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_parameter_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_parameter_info_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserParameterInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_parameter_info_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaGirParserParameterInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaGirParserParamSpecParameterInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_parameter_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_parameter_info (GValue* value,
                                          gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}

static void
vala_gir_parser_value_take_parameter_info (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}

static void
vala_gir_parser_parameter_info_class_init (ValaGirParserParameterInfoClass * klass,
                                           gpointer klass_data)
{
	vala_gir_parser_parameter_info_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserParameterInfoClass *) klass)->finalize = vala_gir_parser_parameter_info_finalize;
}

static void
vala_gir_parser_parameter_info_instance_init (ValaGirParserParameterInfo * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj)
{
	ValaGirParserParameterInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->param);
}

static GType
vala_gir_parser_parameter_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_parameter_info_init, vala_gir_parser_value_parameter_info_free_value, vala_gir_parser_value_parameter_info_copy_value, vala_gir_parser_value_parameter_info_peek_pointer, "p", vala_gir_parser_value_parameter_info_collect_value, "p", vala_gir_parser_value_parameter_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserParameterInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_parameter_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserParameterInfo), 0, (GInstanceInitFunc) vala_gir_parser_parameter_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_parameter_info_type_id;
	vala_gir_parser_parameter_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserParameterInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_parameter_info_type_id;
}

static GType
vala_gir_parser_parameter_info_get_type (void)
{
	static volatile gsize vala_gir_parser_parameter_info_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_parameter_info_type_id__volatile)) {
		GType vala_gir_parser_parameter_info_type_id;
		vala_gir_parser_parameter_info_type_id = vala_gir_parser_parameter_info_get_type_once ();
		g_once_init_leave (&vala_gir_parser_parameter_info_type_id__volatile, vala_gir_parser_parameter_info_type_id);
	}
	return vala_gir_parser_parameter_info_type_id__volatile;
}

static gpointer
vala_gir_parser_parameter_info_ref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_parameter_info_unref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
vala_gir_parser_class_init (ValaGirParserClass * klass,
                            gpointer klass_data)
{
	vala_gir_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGirParser_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gir_parser_real_visit_source_file;
}

static void
vala_gir_parser_instance_init (ValaGirParser * self,
                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashMap* _tmp12_;
	GEqualFunc _tmp13_;
	ValaArrayList* _tmp14_;
	self->priv = vala_gir_parser_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp0_);
	self->priv->metadata_roots = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_, _tmp3_);
	self->priv->provided_namespaces = (ValaSet*) _tmp4_;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_gir_parser_unresolved_symbol_hash_ghash_func, _vala_gir_parser_unresolved_symbol_equal_gequal_func, _tmp5_);
	self->priv->unresolved_symbols_map = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->unresolved_gir_symbols = _tmp8_;
	_tmp9_ = g_direct_hash;
	_tmp10_ = g_direct_equal;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp9_, _tmp10_, _tmp11_);
	self->priv->unresolved_type_arguments = _tmp12_;
	_tmp13_ = g_direct_equal;
	_tmp14_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp13_);
	self->priv->ifaces_needing_object_prereq = _tmp14_;
}

static void
vala_gir_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGirParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_PARSER, ValaGirParser);
	_vala_markup_reader_unref0 (self->priv->reader);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_gir_parser_node_unref0 (self->priv->root);
	_vala_iterable_unref0 (self->priv->metadata_roots);
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	_vala_iterable_unref0 (self->priv->tree_stack);
	_vala_gir_parser_node_unref0 (self->priv->current);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	_vala_iterable_unref0 (self->priv->provided_namespaces);
	_vala_map_unref0 (self->priv->unresolved_symbols_map);
	_vala_iterable_unref0 (self->priv->unresolved_gir_symbols);
	_vala_map_unref0 (self->priv->unresolved_type_arguments);
	_vala_iterable_unref0 (self->priv->ifaces_needing_object_prereq);
	VALA_CODE_VISITOR_CLASS (vala_gir_parser_parent_class)->finalize (obj);
}

/**
 * Code visitor parsing all GIR source files.
 *
 * Pipeline:
 * 1) Parse metadata
 * 2) Parse GIR with metadata, track unresolved GIR symbols, create Vala symbols
 * 3) Reconciliate the tree by mapping tracked symbols
 * 4) Process the tree
 */
static GType
vala_gir_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParser), 0, (GInstanceInitFunc) vala_gir_parser_instance_init, NULL };
	GType vala_gir_parser_type_id;
	vala_gir_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGirParser", &g_define_type_info, 0);
	ValaGirParser_private_offset = g_type_add_instance_private (vala_gir_parser_type_id, sizeof (ValaGirParserPrivate));
	return vala_gir_parser_type_id;
}

GType
vala_gir_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_type_id__volatile)) {
		GType vala_gir_parser_type_id;
		vala_gir_parser_type_id = vala_gir_parser_get_type_once ();
		g_once_init_leave (&vala_gir_parser_type_id__volatile, vala_gir_parser_type_id);
	}
	return vala_gir_parser_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

