/* valalambdaexpression.c generated by valac, the Vala compiler
 * generated from valalambdaexpression.vala, do not modify */

/* valalambdaexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaLambdaExpressionPrivate {
	ValaExpression* _expression_body;
	ValaBlock* _statement_body;
	ValaMethod* _method;
	ValaList* parameters;
};

static gint ValaLambdaExpression_private_offset;
static gpointer vala_lambda_expression_parent_class = NULL;
static gint vala_lambda_expression_next_lambda_id;
static gint vala_lambda_expression_next_lambda_id = 0;

static void vala_lambda_expression_set_expression_body (ValaLambdaExpression* self,
                                                 ValaExpression* value);
static void vala_lambda_expression_set_statement_body (ValaLambdaExpression* self,
                                                ValaBlock* value);
static void vala_lambda_expression_set_method (ValaLambdaExpression* self,
                                        ValaMethod* value);
static void vala_lambda_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_lambda_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_lambda_expression_real_is_pure (ValaExpression* base);
static gboolean vala_lambda_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_lambda_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_lambda_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_lambda_expression_finalize (ValaCodeNode * obj);
static GType vala_lambda_expression_get_type_once (void);

static inline gpointer
vala_lambda_expression_get_instance_private (ValaLambdaExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLambdaExpression_private_offset);
}

ValaExpression*
vala_lambda_expression_get_expression_body (ValaLambdaExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression_body;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_lambda_expression_set_expression_body (ValaLambdaExpression* self,
                                            ValaExpression* value)
{
	ValaExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_expression_body);
	self->priv->_expression_body = _tmp0_;
}

ValaBlock*
vala_lambda_expression_get_statement_body (ValaLambdaExpression* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_statement_body;
	result = _tmp0_;
	return result;
}

static void
vala_lambda_expression_set_statement_body (ValaLambdaExpression* self,
                                           ValaBlock* value)
{
	ValaBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_statement_body);
	self->priv->_statement_body = _tmp0_;
}

ValaMethod*
vala_lambda_expression_get_method (ValaLambdaExpression* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_method;
	result = _tmp0_;
	return result;
}

static void
vala_lambda_expression_set_method (ValaLambdaExpression* self,
                                   ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_method);
	self->priv->_method = _tmp0_;
}

/**
 * Creates a new lambda expression.
 *
 * @param expression_body  expression body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression*
vala_lambda_expression_construct (GType object_type,
                                  ValaExpression* expression_body,
                                  ValaSourceReference* source_reference)
{
	ValaLambdaExpression* self = NULL;
	g_return_val_if_fail (expression_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_lambda_expression_set_expression_body (self, expression_body);
	return self;
}

ValaLambdaExpression*
vala_lambda_expression_new (ValaExpression* expression_body,
                            ValaSourceReference* source_reference)
{
	return vala_lambda_expression_construct (VALA_TYPE_LAMBDA_EXPRESSION, expression_body, source_reference);
}

/**
 * Creates a new lambda expression with statement body.
 *
 * @param statement_body   statement body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression*
vala_lambda_expression_construct_with_statement_body (GType object_type,
                                                      ValaBlock* statement_body,
                                                      ValaSourceReference* source_reference)
{
	ValaLambdaExpression* self = NULL;
	g_return_val_if_fail (statement_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	vala_lambda_expression_set_statement_body (self, statement_body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaLambdaExpression*
vala_lambda_expression_new_with_statement_body (ValaBlock* statement_body,
                                                ValaSourceReference* source_reference)
{
	return vala_lambda_expression_construct_with_statement_body (VALA_TYPE_LAMBDA_EXPRESSION, statement_body, source_reference);
}

/**
 * Appends implicitly typed parameter.
 *
 * @param param parameter name
 */
void
vala_lambda_expression_add_parameter (ValaLambdaExpression* self,
                                      ValaParameter* param)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
}

/**
 * Returns the parameter list.
 *
 * @return parameter list
 */
ValaList*
vala_lambda_expression_get_parameters (ValaLambdaExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

static void
vala_lambda_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_lambda_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_lambda_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	ValaMethod* _tmp0_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_method;
	if (_tmp0_ == NULL) {
		ValaExpression* _tmp1_;
		_tmp1_ = self->priv->_expression_body;
		if (_tmp1_ != NULL) {
			ValaExpression* _tmp2_;
			ValaExpression* _tmp3_;
			_tmp2_ = self->priv->_expression_body;
			vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
			_tmp3_ = self->priv->_expression_body;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp3_);
		} else {
			ValaBlock* _tmp4_;
			_tmp4_ = self->priv->_statement_body;
			if (_tmp4_ != NULL) {
				ValaBlock* _tmp5_;
				_tmp5_ = self->priv->_statement_body;
				vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
			}
		}
	} else {
		ValaMethod* _tmp6_;
		_tmp6_ = self->priv->_method;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
	}
}

static gboolean
vala_lambda_expression_real_is_pure (ValaExpression* base)
{
	ValaLambdaExpression * self;
	gboolean result = FALSE;
	self = (ValaLambdaExpression*) base;
	result = FALSE;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_lambda_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaLambdaExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDelegate* cb = NULL;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDelegate* _tmp20_;
	ValaDelegate* _tmp21_;
	ValaDelegate* _tmp22_;
	ValaDataType* return_type = NULL;
	ValaDelegate* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gint _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaDataType* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaMethod* _tmp35_;
	ValaMethod* _tmp36_;
	ValaMethod* _tmp37_;
	ValaDataType* _tmp38_;
	gboolean _tmp48_ = FALSE;
	ValaDelegate* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	ValaMethod* _tmp95_;
	ValaSemanticAnalyzer* _tmp96_;
	ValaSemanticAnalyzer* _tmp97_;
	ValaSymbol* _tmp98_;
	ValaSymbol* _tmp99_;
	ValaScope* _tmp100_;
	ValaScope* _tmp101_;
	ValaList* lambda_params = NULL;
	ValaList* _tmp102_;
	ValaList* _tmp103_;
	ValaIterator* lambda_param_it = NULL;
	ValaList* _tmp104_;
	ValaIterator* _tmp105_;
	gboolean _tmp106_ = FALSE;
	ValaDelegate* _tmp107_;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	ValaIterator* _tmp163_;
	ValaArrayList* error_types = NULL;
	GEqualFunc _tmp166_;
	ValaArrayList* _tmp167_;
	ValaDelegate* _tmp168_;
	ValaArrayList* _tmp169_;
	ValaExpression* _tmp181_;
	ValaMethod* _tmp212_;
	ValaBlock* _tmp213_;
	ValaBlock* _tmp214_;
	ValaMethod* _tmp215_;
	ValaScope* _tmp216_;
	ValaScope* _tmp217_;
	ValaMethod* m = NULL;
	ValaSemanticAnalyzer* _tmp218_;
	ValaSemanticAnalyzer* _tmp219_;
	ValaSymbol* _tmp220_;
	ValaSymbol* _tmp221_;
	ValaMethod* _tmp222_;
	ValaMethod* _tmp223_;
	ValaMethod* _tmp245_;
	ValaMethod* _tmp246_;
	ValaMethod* _tmp247_;
	ValaMethodType* _tmp248_;
	ValaMethodType* _tmp249_;
	ValaDataType* _tmp250_;
	ValaDataType* _tmp251_;
	ValaDataType* _tmp252_;
	ValaDataType* _tmp253_;
	gboolean _tmp254_;
	gboolean _tmp255_;
	gboolean _tmp256_;
	gboolean _tmp257_;
	gboolean result = FALSE;
	self = (ValaLambdaExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (!VALA_IS_DELEGATE_TYPE (_tmp5_)) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Cannot convert lambda expression to `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp9_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		} else {
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp17_ = _tmp16_;
			vala_report_error (_tmp17_, "lambda expression not allowed in this context");
		}
		result = FALSE;
		return result;
	}
	_tmp18_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_DELEGATE, ValaDelegate));
	cb = _tmp22_;
	_tmp23_ = cb;
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_data_type_get_actual_type (_tmp25_, _tmp27_, NULL, (ValaCodeNode*) self);
	return_type = _tmp28_;
	_tmp29_ = vala_lambda_expression_next_lambda_id;
	vala_lambda_expression_next_lambda_id = _tmp29_ + 1;
	_tmp30_ = g_strdup_printf ("_lambda%d_", _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = return_type;
	_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_method_new (_tmp31_, _tmp32_, _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	vala_lambda_expression_set_method (self, _tmp36_);
	_vala_code_node_unref0 (_tmp36_);
	_g_free0 (_tmp31_);
	_tmp37_ = self->priv->_method;
	vala_symbol_set_used ((ValaSymbol*) _tmp37_, TRUE);
	_tmp38_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp38_)) {
		ValaMethod* _tmp39_;
		ValaDelegate* _tmp40_;
		ValaMethod* _tmp41_;
		ValaDelegate* _tmp42_;
		ValaMethod* _tmp43_;
		ValaDelegate* _tmp44_;
		_tmp39_ = self->priv->_method;
		_tmp40_ = cb;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp39_, (ValaCodeNode*) _tmp40_, "CCode", "array_length");
		_tmp41_ = self->priv->_method;
		_tmp42_ = cb;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp41_, (ValaCodeNode*) _tmp42_, "CCode", "array_null_terminated");
		_tmp43_ = self->priv->_method;
		_tmp44_ = cb;
		vala_code_node_copy_attribute_string ((ValaCodeNode*) _tmp43_, (ValaCodeNode*) _tmp44_, "CCode", "array_length_type");
	} else {
		ValaDataType* _tmp45_;
		_tmp45_ = return_type;
		if (VALA_IS_DELEGATE_TYPE (_tmp45_)) {
			ValaMethod* _tmp46_;
			ValaDelegate* _tmp47_;
			_tmp46_ = self->priv->_method;
			_tmp47_ = cb;
			vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp46_, (ValaCodeNode*) _tmp47_, "CCode", "delegate_target");
		}
	}
	_tmp49_ = cb;
	_tmp50_ = vala_delegate_get_has_target (_tmp49_);
	_tmp51_ = _tmp50_;
	if (!_tmp51_) {
		_tmp48_ = TRUE;
	} else {
		ValaSemanticAnalyzer* _tmp52_;
		ValaSemanticAnalyzer* _tmp53_;
		_tmp52_ = vala_code_context_get_analyzer (context);
		_tmp53_ = _tmp52_;
		_tmp48_ = !vala_semantic_analyzer_is_in_instance_method (_tmp53_);
	}
	if (_tmp48_) {
		ValaMethod* _tmp54_;
		_tmp54_ = self->priv->_method;
		vala_method_set_binding (_tmp54_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaSymbol* sym = NULL;
		ValaSemanticAnalyzer* _tmp55_;
		ValaSemanticAnalyzer* _tmp56_;
		ValaSymbol* _tmp57_;
		ValaSymbol* _tmp58_;
		ValaSymbol* _tmp59_;
		_tmp55_ = vala_code_context_get_analyzer (context);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_semantic_analyzer_get_current_symbol (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = _vala_code_node_ref0 (_tmp58_);
		sym = _tmp59_;
		while (TRUE) {
			ValaMethod* _tmp60_;
			ValaParameter* _tmp61_;
			ValaParameter* _tmp62_;
			ValaSymbol* _tmp63_;
			ValaSymbol* _tmp91_;
			ValaSymbol* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp60_ = self->priv->_method;
			_tmp61_ = vala_method_get_this_parameter (_tmp60_);
			_tmp62_ = _tmp61_;
			if (!(_tmp62_ == NULL)) {
				break;
			}
			_tmp63_ = sym;
			if (VALA_IS_PROPERTY (_tmp63_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp64_;
				ValaProperty* _tmp65_;
				ValaMethod* _tmp66_;
				ValaProperty* _tmp67_;
				ValaParameter* _tmp68_;
				ValaParameter* _tmp69_;
				_tmp64_ = sym;
				_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp65_;
				_tmp66_ = self->priv->_method;
				_tmp67_ = prop;
				_tmp68_ = vala_property_get_this_parameter (_tmp67_);
				_tmp69_ = _tmp68_;
				vala_method_set_this_parameter (_tmp66_, _tmp69_);
				_vala_code_node_unref0 (prop);
			} else {
				ValaSymbol* _tmp70_;
				_tmp70_ = sym;
				if (VALA_IS_CONSTRUCTOR (_tmp70_)) {
					ValaConstructor* c = NULL;
					ValaSymbol* _tmp71_;
					ValaConstructor* _tmp72_;
					ValaMethod* _tmp73_;
					ValaConstructor* _tmp74_;
					ValaParameter* _tmp75_;
					ValaParameter* _tmp76_;
					_tmp71_ = sym;
					_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
					c = _tmp72_;
					_tmp73_ = self->priv->_method;
					_tmp74_ = c;
					_tmp75_ = vala_constructor_get_this_parameter (_tmp74_);
					_tmp76_ = _tmp75_;
					vala_method_set_this_parameter (_tmp73_, _tmp76_);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp77_;
					_tmp77_ = sym;
					if (VALA_IS_DESTRUCTOR (_tmp77_)) {
						ValaDestructor* d = NULL;
						ValaSymbol* _tmp78_;
						ValaDestructor* _tmp79_;
						ValaMethod* _tmp80_;
						ValaDestructor* _tmp81_;
						ValaParameter* _tmp82_;
						ValaParameter* _tmp83_;
						_tmp78_ = sym;
						_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
						d = _tmp79_;
						_tmp80_ = self->priv->_method;
						_tmp81_ = d;
						_tmp82_ = vala_destructor_get_this_parameter (_tmp81_);
						_tmp83_ = _tmp82_;
						vala_method_set_this_parameter (_tmp80_, _tmp83_);
						_vala_code_node_unref0 (d);
					} else {
						ValaSymbol* _tmp84_;
						_tmp84_ = sym;
						if (VALA_IS_METHOD (_tmp84_)) {
							ValaMethod* m = NULL;
							ValaSymbol* _tmp85_;
							ValaMethod* _tmp86_;
							ValaMethod* _tmp87_;
							ValaMethod* _tmp88_;
							ValaParameter* _tmp89_;
							ValaParameter* _tmp90_;
							_tmp85_ = sym;
							_tmp86_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_METHOD, ValaMethod));
							m = _tmp86_;
							_tmp87_ = self->priv->_method;
							_tmp88_ = m;
							_tmp89_ = vala_method_get_this_parameter (_tmp88_);
							_tmp90_ = _tmp89_;
							vala_method_set_this_parameter (_tmp87_, _tmp90_);
							_vala_code_node_unref0 (m);
						}
					}
				}
			}
			_tmp91_ = sym;
			_tmp92_ = vala_symbol_get_parent_symbol (_tmp91_);
			_tmp93_ = _tmp92_;
			_tmp94_ = _vala_code_node_ref0 (_tmp93_);
			_vala_code_node_unref0 (sym);
			sym = _tmp94_;
		}
		_vala_code_node_unref0 (sym);
	}
	_tmp95_ = self->priv->_method;
	_tmp96_ = vala_code_context_get_analyzer (context);
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_semantic_analyzer_get_current_symbol (_tmp97_);
	_tmp99_ = _tmp98_;
	_tmp100_ = vala_symbol_get_scope (_tmp99_);
	_tmp101_ = _tmp100_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp95_, _tmp101_);
	_tmp102_ = vala_lambda_expression_get_parameters (self);
	_tmp103_ = _vala_iterable_ref0 (_tmp102_);
	lambda_params = _tmp103_;
	_tmp104_ = lambda_params;
	_tmp105_ = vala_iterable_iterator ((ValaIterable*) _tmp104_);
	lambda_param_it = _tmp105_;
	_tmp107_ = cb;
	_tmp108_ = vala_delegate_get_sender_type (_tmp107_);
	_tmp109_ = _tmp108_;
	if (_tmp109_ != NULL) {
		ValaList* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		ValaDelegate* _tmp113_;
		ValaList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		_tmp110_ = lambda_params;
		_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = cb;
		_tmp114_ = vala_callable_get_parameters ((ValaCallable*) _tmp113_);
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_tmp106_ = _tmp112_ == (_tmp116_ + 1);
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaIterator* _tmp117_;
		ValaParameter* lambda_param = NULL;
		ValaIterator* _tmp118_;
		gpointer _tmp119_;
		ValaParameter* _tmp120_;
		ValaDelegate* _tmp121_;
		ValaDataType* _tmp122_;
		ValaDataType* _tmp123_;
		ValaMethod* _tmp124_;
		ValaParameter* _tmp125_;
		_tmp117_ = lambda_param_it;
		vala_iterator_next (_tmp117_);
		_tmp118_ = lambda_param_it;
		_tmp119_ = vala_iterator_get (_tmp118_);
		lambda_param = (ValaParameter*) _tmp119_;
		_tmp120_ = lambda_param;
		_tmp121_ = cb;
		_tmp122_ = vala_delegate_get_sender_type (_tmp121_);
		_tmp123_ = _tmp122_;
		vala_variable_set_variable_type ((ValaVariable*) _tmp120_, _tmp123_);
		_tmp124_ = self->priv->_method;
		_tmp125_ = lambda_param;
		vala_callable_add_parameter ((ValaCallable*) _tmp124_, _tmp125_);
		_vala_code_node_unref0 (lambda_param);
	}
	{
		ValaList* _cb_param_list = NULL;
		ValaDelegate* _tmp126_;
		ValaList* _tmp127_;
		ValaList* _tmp128_;
		gint _cb_param_size = 0;
		ValaList* _tmp129_;
		gint _tmp130_;
		gint _tmp131_;
		gint _cb_param_index = 0;
		_tmp126_ = cb;
		_tmp127_ = vala_callable_get_parameters ((ValaCallable*) _tmp126_);
		_tmp128_ = _vala_iterable_ref0 (_tmp127_);
		_cb_param_list = _tmp128_;
		_tmp129_ = _cb_param_list;
		_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
		_tmp131_ = _tmp130_;
		_cb_param_size = _tmp131_;
		_cb_param_index = -1;
		while (TRUE) {
			ValaParameter* cb_param = NULL;
			ValaList* _tmp132_;
			gpointer _tmp133_;
			ValaIterator* _tmp134_;
			ValaParameter* lambda_param = NULL;
			ValaIterator* _tmp135_;
			gpointer _tmp136_;
			ValaParameter* _tmp137_;
			ValaParameterDirection _tmp138_;
			ValaParameterDirection _tmp139_;
			ValaParameter* _tmp140_;
			ValaParameterDirection _tmp141_;
			ValaParameterDirection _tmp142_;
			ValaParameter* _tmp151_;
			ValaParameter* _tmp152_;
			ValaDataType* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaParameter* _tmp159_;
			ValaParameter* _tmp160_;
			ValaMethod* _tmp161_;
			ValaParameter* _tmp162_;
			_cb_param_index = _cb_param_index + 1;
			if (!(_cb_param_index < _cb_param_size)) {
				break;
			}
			_tmp132_ = _cb_param_list;
			_tmp133_ = vala_list_get (_tmp132_, _cb_param_index);
			cb_param = (ValaParameter*) _tmp133_;
			_tmp134_ = lambda_param_it;
			if (!vala_iterator_next (_tmp134_)) {
				_vala_code_node_unref0 (cb_param);
				break;
			}
			_tmp135_ = lambda_param_it;
			_tmp136_ = vala_iterator_get (_tmp135_);
			lambda_param = (ValaParameter*) _tmp136_;
			_tmp137_ = lambda_param;
			_tmp138_ = vala_parameter_get_direction (_tmp137_);
			_tmp139_ = _tmp138_;
			_tmp140_ = cb_param;
			_tmp141_ = vala_parameter_get_direction (_tmp140_);
			_tmp142_ = _tmp141_;
			if (_tmp139_ != _tmp142_) {
				ValaParameter* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaSourceReference* _tmp145_;
				ValaParameter* _tmp146_;
				const gchar* _tmp147_;
				const gchar* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp143_ = lambda_param;
				_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp143_);
				_tmp145_ = _tmp144_;
				_tmp146_ = lambda_param;
				_tmp147_ = vala_symbol_get_name ((ValaSymbol*) _tmp146_);
				_tmp148_ = _tmp147_;
				_tmp149_ = g_strdup_printf ("direction of parameter `%s' is incompatible with the target delegate", _tmp148_);
				_tmp150_ = _tmp149_;
				vala_report_error (_tmp145_, _tmp150_);
				_g_free0 (_tmp150_);
			}
			_tmp151_ = lambda_param;
			_tmp152_ = cb_param;
			_tmp153_ = vala_variable_get_variable_type ((ValaVariable*) _tmp152_);
			_tmp154_ = _tmp153_;
			_tmp155_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp156_ = _tmp155_;
			_tmp157_ = vala_data_type_get_actual_type (_tmp154_, _tmp156_, NULL, (ValaCodeNode*) self);
			_tmp158_ = _tmp157_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp151_, _tmp158_);
			_vala_code_node_unref0 (_tmp158_);
			_tmp159_ = lambda_param;
			_tmp160_ = cb_param;
			vala_parameter_set_base_parameter (_tmp159_, _tmp160_);
			_tmp161_ = self->priv->_method;
			_tmp162_ = lambda_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp161_, _tmp162_);
			_vala_code_node_unref0 (lambda_param);
			_vala_code_node_unref0 (cb_param);
		}
		_vala_iterable_unref0 (_cb_param_list);
	}
	_tmp163_ = lambda_param_it;
	if (vala_iterator_next (_tmp163_)) {
		ValaSourceReference* _tmp164_;
		ValaSourceReference* _tmp165_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp165_ = _tmp164_;
		vala_report_error (_tmp165_, "lambda expression: too many parameters");
		result = FALSE;
		_vala_iterator_unref0 (lambda_param_it);
		_vala_iterable_unref0 (lambda_params);
		_vala_code_node_unref0 (return_type);
		_vala_code_node_unref0 (cb);
		return result;
	}
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp166_);
	error_types = _tmp167_;
	_tmp168_ = cb;
	_tmp169_ = error_types;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp168_, (ValaCollection*) _tmp169_, NULL);
	{
		ValaArrayList* _error_type_list = NULL;
		ValaArrayList* _tmp170_;
		ValaArrayList* _tmp171_;
		gint _error_type_size = 0;
		ValaArrayList* _tmp172_;
		gint _tmp173_;
		gint _tmp174_;
		gint _error_type_index = 0;
		_tmp170_ = error_types;
		_tmp171_ = _vala_iterable_ref0 (_tmp170_);
		_error_type_list = _tmp171_;
		_tmp172_ = _error_type_list;
		_tmp173_ = vala_collection_get_size ((ValaCollection*) _tmp172_);
		_tmp174_ = _tmp173_;
		_error_type_size = _tmp174_;
		_error_type_index = -1;
		while (TRUE) {
			ValaDataType* error_type = NULL;
			ValaArrayList* _tmp175_;
			gpointer _tmp176_;
			ValaMethod* _tmp177_;
			ValaDataType* _tmp178_;
			ValaDataType* _tmp179_;
			ValaDataType* _tmp180_;
			_error_type_index = _error_type_index + 1;
			if (!(_error_type_index < _error_type_size)) {
				break;
			}
			_tmp175_ = _error_type_list;
			_tmp176_ = vala_list_get ((ValaList*) _tmp175_, _error_type_index);
			error_type = (ValaDataType*) _tmp176_;
			_tmp177_ = self->priv->_method;
			_tmp178_ = error_type;
			_tmp179_ = vala_data_type_copy (_tmp178_);
			_tmp180_ = _tmp179_;
			vala_method_add_error_type (_tmp177_, _tmp180_);
			_vala_code_node_unref0 (_tmp180_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp181_ = self->priv->_expression_body;
	if (_tmp181_ != NULL) {
		ValaBlock* block = NULL;
		ValaSourceReference* _tmp182_;
		ValaSourceReference* _tmp183_;
		ValaBlock* _tmp184_;
		ValaBlock* _tmp185_;
		ValaScope* _tmp186_;
		ValaScope* _tmp187_;
		ValaMethod* _tmp188_;
		ValaScope* _tmp189_;
		ValaScope* _tmp190_;
		ValaMethod* _tmp191_;
		ValaDataType* _tmp192_;
		ValaDataType* _tmp193_;
		ValaTypeSymbol* _tmp194_;
		ValaTypeSymbol* _tmp195_;
		ValaMethod* _tmp208_;
		ValaBlock* _tmp209_;
		_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_block_new (_tmp183_);
		block = _tmp184_;
		_tmp185_ = block;
		_tmp186_ = vala_symbol_get_scope ((ValaSymbol*) _tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = self->priv->_method;
		_tmp189_ = vala_symbol_get_scope ((ValaSymbol*) _tmp188_);
		_tmp190_ = _tmp189_;
		vala_scope_set_parent_scope (_tmp187_, _tmp190_);
		_tmp191_ = self->priv->_method;
		_tmp192_ = vala_callable_get_return_type ((ValaCallable*) _tmp191_);
		_tmp193_ = _tmp192_;
		_tmp194_ = vala_data_type_get_type_symbol (_tmp193_);
		_tmp195_ = _tmp194_;
		if (_tmp195_ != NULL) {
			ValaBlock* _tmp196_;
			ValaExpression* _tmp197_;
			ValaSourceReference* _tmp198_;
			ValaSourceReference* _tmp199_;
			ValaReturnStatement* _tmp200_;
			ValaReturnStatement* _tmp201_;
			_tmp196_ = block;
			_tmp197_ = self->priv->_expression_body;
			_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_return_statement_new (_tmp197_, _tmp199_);
			_tmp201_ = _tmp200_;
			vala_block_add_statement (_tmp196_, (ValaStatement*) _tmp201_);
			_vala_code_node_unref0 (_tmp201_);
		} else {
			ValaBlock* _tmp202_;
			ValaExpression* _tmp203_;
			ValaSourceReference* _tmp204_;
			ValaSourceReference* _tmp205_;
			ValaExpressionStatement* _tmp206_;
			ValaExpressionStatement* _tmp207_;
			_tmp202_ = block;
			_tmp203_ = self->priv->_expression_body;
			_tmp204_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp205_ = _tmp204_;
			_tmp206_ = vala_expression_statement_new (_tmp203_, _tmp205_);
			_tmp207_ = _tmp206_;
			vala_block_add_statement (_tmp202_, (ValaStatement*) _tmp207_);
			_vala_code_node_unref0 (_tmp207_);
		}
		_tmp208_ = self->priv->_method;
		_tmp209_ = block;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp208_, _tmp209_);
		_vala_code_node_unref0 (block);
	} else {
		ValaMethod* _tmp210_;
		ValaBlock* _tmp211_;
		_tmp210_ = self->priv->_method;
		_tmp211_ = self->priv->_statement_body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp210_, _tmp211_);
	}
	_tmp212_ = self->priv->_method;
	_tmp213_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp212_);
	_tmp214_ = _tmp213_;
	_tmp215_ = self->priv->_method;
	_tmp216_ = vala_symbol_get_scope ((ValaSymbol*) _tmp215_);
	_tmp217_ = _tmp216_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp214_, _tmp217_);
	_tmp218_ = vala_code_context_get_analyzer (context);
	_tmp219_ = _tmp218_;
	_tmp220_ = vala_semantic_analyzer_get_current_symbol (_tmp219_);
	_tmp221_ = _tmp220_;
	_tmp222_ = vala_semantic_analyzer_find_parent_method (_tmp221_);
	m = _tmp222_;
	_tmp223_ = m;
	if (_tmp223_ != NULL) {
		{
			ValaList* _type_param_list = NULL;
			ValaMethod* _tmp224_;
			ValaList* _tmp225_;
			ValaList* _tmp226_;
			gint _type_param_size = 0;
			ValaList* _tmp227_;
			gint _tmp228_;
			gint _tmp229_;
			gint _type_param_index = 0;
			_tmp224_ = m;
			_tmp225_ = vala_method_get_type_parameters (_tmp224_);
			_tmp226_ = _vala_iterable_ref0 (_tmp225_);
			_type_param_list = _tmp226_;
			_tmp227_ = _type_param_list;
			_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
			_tmp229_ = _tmp228_;
			_type_param_size = _tmp229_;
			_type_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp230_;
				gpointer _tmp231_;
				ValaMethod* _tmp232_;
				ValaTypeParameter* _tmp233_;
				const gchar* _tmp234_;
				const gchar* _tmp235_;
				ValaTypeParameter* _tmp236_;
				ValaSourceReference* _tmp237_;
				ValaSourceReference* _tmp238_;
				ValaTypeParameter* _tmp239_;
				ValaTypeParameter* _tmp240_;
				ValaMethod* _tmp241_;
				ValaMethod* _tmp242_;
				ValaBlock* _tmp243_;
				ValaBlock* _tmp244_;
				_type_param_index = _type_param_index + 1;
				if (!(_type_param_index < _type_param_size)) {
					break;
				}
				_tmp230_ = _type_param_list;
				_tmp231_ = vala_list_get (_tmp230_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp231_;
				_tmp232_ = self->priv->_method;
				_tmp233_ = type_param;
				_tmp234_ = vala_symbol_get_name ((ValaSymbol*) _tmp233_);
				_tmp235_ = _tmp234_;
				_tmp236_ = type_param;
				_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp236_);
				_tmp238_ = _tmp237_;
				_tmp239_ = vala_typeparameter_new (_tmp235_, _tmp238_);
				_tmp240_ = _tmp239_;
				vala_method_add_type_parameter (_tmp232_, _tmp240_);
				_vala_code_node_unref0 (_tmp240_);
				_tmp241_ = self->priv->_method;
				vala_method_set_closure (_tmp241_, TRUE);
				_tmp242_ = m;
				_tmp243_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp242_);
				_tmp244_ = _tmp243_;
				vala_block_set_captured (_tmp244_, TRUE);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
	}
	_tmp245_ = self->priv->_method;
	vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp245_);
	_tmp246_ = self->priv->_method;
	vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
	_tmp247_ = self->priv->_method;
	_tmp248_ = vala_method_type_new (_tmp247_);
	_tmp249_ = _tmp248_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp249_);
	_vala_code_node_unref0 (_tmp249_);
	_tmp250_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp251_ = _tmp250_;
	_tmp252_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp253_ = _tmp252_;
	_tmp254_ = vala_data_type_get_value_owned (_tmp253_);
	_tmp255_ = _tmp254_;
	vala_data_type_set_value_owned (_tmp251_, _tmp255_);
	_tmp256_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp257_ = _tmp256_;
	result = !_tmp257_;
	_vala_iterable_unref0 (error_types);
	_vala_iterator_unref0 (lambda_param_it);
	_vala_iterable_unref0 (lambda_params);
	_vala_code_node_unref0 (return_type);
	_vala_code_node_unref0 (cb);
	return result;
}

static void
vala_lambda_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaLambdaExpression * self;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_lambda_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_lambda_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaLambdaExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMethod* _tmp1_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp1_ = self->priv->_method;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_method;
		_tmp3_ = vala_method_get_closure (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaMethod* _tmp5_;
		_tmp5_ = self->priv->_method;
		vala_method_get_captured_variables (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

static void
vala_lambda_expression_class_init (ValaLambdaExpressionClass * klass,
                                   gpointer klass_data)
{
	vala_lambda_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_lambda_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLambdaExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_lambda_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_lambda_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_lambda_expression_real_is_pure;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_lambda_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_lambda_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_lambda_expression_real_get_used_variables;
}

static void
vala_lambda_expression_instance_init (ValaLambdaExpression * self,
                                      gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_lambda_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_lambda_expression_finalize (ValaCodeNode * obj)
{
	ValaLambdaExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression);
	_vala_code_node_unref0 (self->priv->_expression_body);
	_vala_code_node_unref0 (self->priv->_statement_body);
	_vala_code_node_unref0 (self->priv->_method);
	_vala_iterable_unref0 (self->priv->parameters);
	VALA_CODE_NODE_CLASS (vala_lambda_expression_parent_class)->finalize (obj);
}

/**
 * Represents a lambda expression in the source code.
 *
 * Lambda expressions are anonymous methods with implicitly typed parameters.
 */
static GType
vala_lambda_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaLambdaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lambda_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLambdaExpression), 0, (GInstanceInitFunc) vala_lambda_expression_instance_init, NULL };
	GType vala_lambda_expression_type_id;
	vala_lambda_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaLambdaExpression", &g_define_type_info, 0);
	ValaLambdaExpression_private_offset = g_type_add_instance_private (vala_lambda_expression_type_id, sizeof (ValaLambdaExpressionPrivate));
	return vala_lambda_expression_type_id;
}

GType
vala_lambda_expression_get_type (void)
{
	static volatile gsize vala_lambda_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_lambda_expression_type_id__volatile)) {
		GType vala_lambda_expression_type_id;
		vala_lambda_expression_type_id = vala_lambda_expression_get_type_once ();
		g_once_init_leave (&vala_lambda_expression_type_id__volatile, vala_lambda_expression_type_id);
	}
	return vala_lambda_expression_type_id__volatile;
}

