/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;

static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp7_ = _expr_list;
			_tmp8_ = vala_list_get (_tmp7_, _expr_index);
			expr = (ValaExpression*) _tmp8_;
			_tmp9_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp8_ = vala_method_call_get_call (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_accessible (_tmp9_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			_tmp15_ = self->priv->_is_yield_expression;
			_tmp11_ = !_tmp15_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = vala_method_call_get_call (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp19_ = _tmp18_;
			_tmp10_ = g_strcmp0 (_tmp19_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp20_;
			_tmp20_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp20_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp21_;
		_tmp21_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp21_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp22_;
			ValaTypeSymbol* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaMethod* m = NULL;
			ValaClass* _tmp25_;
			ValaCreationMethod* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaMethod* _tmp28_;
			_tmp22_ = mtype;
			_tmp23_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp24_ = _tmp23_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_CLASS, ValaClass);
			_tmp25_ = cl;
			_tmp26_ = vala_class_get_default_construction_method (_tmp25_);
			_tmp27_ = _tmp26_;
			m = (ValaMethod*) _tmp27_;
			_tmp28_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp28_, collection, source_reference);
		} else {
			ValaDataType* _tmp29_;
			_tmp29_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp29_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp30_;
				ValaDelegate* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				_tmp30_ = mtype;
				_tmp31_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp32_ = _tmp31_;
				d = _tmp32_;
				_tmp33_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp34_;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp34_ = self->priv->argument_list;
		_tmp35_ = _vala_iterable_ref0 (_tmp34_);
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp39_;
			gpointer _tmp40_;
			ValaExpression* _tmp41_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp39_ = _expr_list;
			_tmp40_ = vala_list_get (_tmp39_, _expr_index);
			expr = (ValaExpression*) _tmp40_;
			_tmp41_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp41_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp104_;
	ValaExpression* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	gboolean _tmp109_ = FALSE;
	ValaProfile _tmp110_;
	ValaProfile _tmp111_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp137_;
	gboolean _tmp223_ = FALSE;
	ValaExpression* _tmp224_;
	ValaExpression* _tmp225_;
	gboolean _tmp295_ = FALSE;
	gboolean _tmp296_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp311_;
	ValaDataType* _tmp312_;
	ValaDataType* _tmp313_;
	ValaList* params = NULL;
	ValaDataType* _tmp314_;
	ValaList* _tmp315_;
	ValaList* _tmp316_;
	ValaDataType* _tmp317_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp372_;
	ValaIterator* _tmp373_;
	gboolean _tmp422_ = FALSE;
	ValaDataType* _tmp423_;
	gboolean _tmp443_ = FALSE;
	ValaDataType* _tmp444_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp522_ = FALSE;
	gboolean _tmp523_;
	gboolean _tmp524_;
	ValaDataType* _tmp543_;
	ValaDataType* _tmp554_;
	ValaDataType* _tmp555_;
	ValaDataType* _tmp556_;
	ValaDataType* _tmp557_;
	ValaDataType* _tmp558_;
	ValaDataType* _tmp559_;
	ValaList* _tmp560_;
	ValaDataType* _tmp561_;
	ValaDataType* _tmp562_;
	gboolean _tmp563_;
	ValaDataType* _tmp586_;
	ValaSemanticAnalyzer* _tmp825_;
	ValaSemanticAnalyzer* _tmp826_;
	ValaDataType* _tmp827_;
	ValaList* _tmp828_;
	ValaList* _tmp829_;
	gboolean _tmp855_ = FALSE;
	gboolean _tmp856_ = FALSE;
	ValaCreationMethod* _tmp857_;
	ValaDataType* _tmp885_;
	ValaDataType* _tmp886_;
	gboolean _tmp887_;
	gboolean _tmp888_;
	gboolean _tmp949_;
	gboolean _tmp950_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaMemberAccess* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp88_ = FALSE;
			ValaMemberAccess* _tmp89_;
			ValaSymbol* _tmp90_;
			ValaSymbol* _tmp91_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp19_ = ma;
			_tmp20_ = vala_member_access_get_prototype_access (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_method_call_get_call (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_full_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp29_);
				_tmp31_ = _tmp30_;
				vala_report_error (_tmp23_, _tmp31_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp29_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_type_arguments (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp59_;
				ValaSymbol* _tmp60_;
				ValaSymbol* _tmp61_;
				gboolean _tmp62_ = FALSE;
				ValaMethod* _tmp63_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (VALA_IS_SIGNAL (_tmp48_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
					_tmp52_ = sig;
					if (_tmp52_ != NULL) {
						ValaMemberAccess* _tmp53_;
						ValaExpression* _tmp54_;
						ValaExpression* _tmp55_;
						ValaDataType* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						_tmp53_ = sig;
						_tmp54_ = vala_member_access_get_inner (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_expression_get_value_type (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp58_;
					}
				}
				_tmp59_ = ma;
				_tmp60_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp59_);
				_tmp61_ = _tmp60_;
				m = VALA_IS_METHOD (_tmp61_) ? ((ValaMethod*) _tmp61_) : NULL;
				_tmp63_ = m;
				if (_tmp63_ != NULL) {
					ValaMethod* _tmp64_;
					gboolean _tmp65_;
					gboolean _tmp66_;
					_tmp64_ = m;
					_tmp65_ = vala_method_get_coroutine (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp62_ = _tmp66_;
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					gboolean _tmp67_ = FALSE;
					ValaMemberAccess* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					_tmp68_ = ma;
					_tmp69_ = vala_member_access_get_member_name (_tmp68_);
					_tmp70_ = _tmp69_;
					if (g_strcmp0 (_tmp70_, "begin") == 0) {
						_tmp67_ = TRUE;
					} else {
						ValaMemberAccess* _tmp71_;
						const gchar* _tmp72_;
						const gchar* _tmp73_;
						_tmp71_ = ma;
						_tmp72_ = vala_member_access_get_member_name (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp67_ = g_strcmp0 (_tmp73_, "end") == 0;
					}
					if (_tmp67_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp74_;
						ValaExpression* _tmp75_;
						ValaExpression* _tmp76_;
						gboolean _tmp77_ = FALSE;
						ValaMemberAccess* _tmp78_;
						_tmp74_ = ma;
						_tmp75_ = vala_member_access_get_inner (_tmp74_);
						_tmp76_ = _tmp75_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp76_) ? ((ValaMemberAccess*) _tmp76_) : NULL;
						_tmp78_ = method_access;
						if (_tmp78_ != NULL) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = method_access;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp77_ = _tmp81_ != NULL;
						} else {
							_tmp77_ = FALSE;
						}
						if (_tmp77_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaDataType* _tmp85_;
							ValaDataType* _tmp86_;
							ValaDataType* _tmp87_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_value_type (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp87_ = _vala_code_node_ref0 (_tmp86_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp87_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp89_ = ma;
			_tmp90_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp89_);
			_tmp91_ = _tmp90_;
			if (_tmp91_ != NULL) {
				ValaMemberAccess* _tmp92_;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaAttribute* _tmp95_;
				_tmp92_ = ma;
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp94_, "Assert");
				_tmp88_ = _tmp95_ != NULL;
			} else {
				_tmp88_ = FALSE;
			}
			if (_tmp88_) {
				ValaList* _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp96_ = self->priv->argument_list;
				_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
				_tmp98_ = _tmp97_;
				if (_tmp98_ == 1) {
					ValaList* _tmp99_;
					gpointer _tmp100_;
					ValaExpression* _tmp101_;
					ValaSourceReference* _tmp102_;
					ValaSourceReference* _tmp103_;
					_tmp99_ = self->priv->argument_list;
					_tmp100_ = vala_list_get (_tmp99_, 0);
					_tmp101_ = (ValaExpression*) _tmp100_;
					_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp101_);
					_tmp103_ = _tmp102_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp103_);
					_vala_code_node_unref0 (_tmp101_);
				}
			}
		}
	}
	_tmp104_ = vala_method_call_get_call (self);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_expression_get_value_type (_tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = _vala_code_node_ref0 (_tmp107_);
	mtype = _tmp108_;
	_tmp110_ = vala_code_context_get_profile (context);
	_tmp111_ = _tmp110_;
	if (_tmp111_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp112_;
		ValaExpression* _tmp113_;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaSemanticAnalyzer* _tmp116_;
		ValaSemanticAnalyzer* _tmp117_;
		ValaClass* _tmp118_;
		_tmp112_ = vala_method_call_get_call (self);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_expression_get_symbol_reference (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_code_context_get_analyzer (context);
		_tmp117_ = _tmp116_;
		_tmp118_ = _tmp117_->object_type;
		_tmp109_ = _tmp115_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp109_ = FALSE;
	}
	gobject_chainup = _tmp109_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp121_;
		gboolean _tmp122_ = FALSE;
		ValaMemberAccess* _tmp123_;
		gboolean _tmp131_ = FALSE;
		ValaMemberAccess* _tmp132_;
		_tmp119_ = vala_method_call_get_call (self);
		_tmp120_ = _tmp119_;
		expr = _tmp120_;
		_tmp121_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp121_) ? ((ValaMemberAccess*) _tmp121_) : NULL;
		_tmp123_ = ma;
		if (_tmp123_ != NULL) {
			ValaMemberAccess* _tmp124_;
			ValaSymbol* _tmp125_;
			ValaSymbol* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = VALA_IS_CREATION_METHOD (_tmp126_);
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaMemberAccess* _tmp127_;
			ValaExpression* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp127_ = ma;
			_tmp128_ = vala_member_access_get_inner (_tmp127_);
			_tmp129_ = _tmp128_;
			expr = _tmp129_;
			_tmp130_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp130_) ? ((ValaMemberAccess*) _tmp130_) : NULL;
		}
		_tmp132_ = ma;
		if (_tmp132_ != NULL) {
			ValaMemberAccess* _tmp133_;
			const gchar* _tmp134_;
			const gchar* _tmp135_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_member_name (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp131_ = g_strcmp0 (_tmp135_, "this") == 0;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp136_;
			_tmp136_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp136_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp137_ = self->priv->_is_chainup;
	if (_tmp137_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp138_;
		ValaSemanticAnalyzer* _tmp139_;
		ValaMethod* _tmp140_;
		ValaCreationMethod* _tmp141_;
		ValaCreationMethod* _tmp149_;
		ValaDataType* _tmp150_;
		_tmp138_ = vala_code_context_get_analyzer (context);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_semantic_analyzer_find_current_method (_tmp139_);
		cm = VALA_IS_CREATION_METHOD (_tmp140_) ? ((ValaCreationMethod*) _tmp140_) : NULL;
		_tmp141_ = cm;
		if (_tmp141_ == NULL) {
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp143_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp144_;
			gboolean _tmp145_;
			gboolean _tmp146_;
			_tmp144_ = cm;
			_tmp145_ = vala_creation_method_get_chain_up (_tmp144_);
			_tmp146_ = _tmp145_;
			if (_tmp146_) {
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				vala_report_error (_tmp148_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp149_ = cm;
		vala_creation_method_set_chain_up (_tmp149_, TRUE);
		_tmp150_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp150_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp151_;
			ValaTypeSymbol* _tmp152_;
			ValaTypeSymbol* _tmp153_;
			ValaClass* _tmp154_;
			ValaCreationMethod* _tmp155_;
			ValaCreationMethod* _tmp156_;
			ValaCreationMethod* _tmp157_;
			_tmp151_ = mtype;
			_tmp152_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp153_ = _tmp152_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_CLASS, ValaClass);
			_tmp154_ = cl;
			_tmp155_ = vala_class_get_default_construction_method (_tmp154_);
			_tmp156_ = _tmp155_;
			base_cm = _tmp156_;
			_tmp157_ = base_cm;
			if (_tmp157_ == NULL) {
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				ValaClass* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				_tmp160_ = cl;
				_tmp161_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = g_strdup_printf ("chain up to `%s' not supported", _tmp162_);
				_tmp164_ = _tmp163_;
				vala_report_error (_tmp159_, _tmp164_);
				_g_free0 (_tmp164_);
				_g_free0 (_tmp162_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp165_;
				gboolean _tmp166_;
				gboolean _tmp167_;
				_tmp165_ = base_cm;
				_tmp166_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp165_);
				_tmp167_ = _tmp166_;
				if (!_tmp167_) {
					ValaSourceReference* _tmp168_;
					ValaSourceReference* _tmp169_;
					ValaCreationMethod* _tmp170_;
					gchar* _tmp171_;
					gchar* _tmp172_;
					gchar* _tmp173_;
					gchar* _tmp174_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp169_ = _tmp168_;
					_tmp170_ = base_cm;
					_tmp171_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp170_);
					_tmp172_ = _tmp171_;
					_tmp173_ = g_strdup_printf ("chain up to `%s' not supported", _tmp172_);
					_tmp174_ = _tmp173_;
					vala_report_error (_tmp169_, _tmp174_);
					_g_free0 (_tmp174_);
					_g_free0 (_tmp172_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp175_ = FALSE;
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaSymbol* _tmp178_;
			ValaSymbol* _tmp179_;
			_tmp176_ = vala_method_call_get_call (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_expression_get_symbol_reference (_tmp177_);
			_tmp179_ = _tmp178_;
			if (VALA_IS_CREATION_METHOD (_tmp179_)) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaSymbol* _tmp184_;
				ValaSymbol* _tmp185_;
				_tmp180_ = vala_method_call_get_call (self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_symbol_get_parent_symbol (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp175_ = VALA_IS_CLASS (_tmp185_);
			} else {
				_tmp175_ = FALSE;
			}
			if (_tmp175_) {
				ValaExpression* _tmp186_;
				ValaExpression* _tmp187_;
				ValaSymbol* _tmp188_;
				ValaSymbol* _tmp189_;
				ValaCreationMethod* _tmp190_;
				gboolean _tmp191_;
				gboolean _tmp192_;
				_tmp186_ = vala_method_call_get_call (self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_expression_get_symbol_reference (_tmp187_);
				_tmp189_ = _tmp188_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp190_ = base_cm;
				_tmp191_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp190_);
				_tmp192_ = _tmp191_;
				if (!_tmp192_) {
					ValaSourceReference* _tmp193_;
					ValaSourceReference* _tmp194_;
					ValaCreationMethod* _tmp195_;
					gchar* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					gchar* _tmp199_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp194_ = _tmp193_;
					_tmp195_ = base_cm;
					_tmp196_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = g_strdup_printf ("chain up to `%s' not supported", _tmp197_);
					_tmp199_ = _tmp198_;
					vala_report_error (_tmp194_, _tmp199_);
					_g_free0 (_tmp199_);
					_g_free0 (_tmp197_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp200_;
					ValaSymbol* _tmp201_;
					ValaSymbol* _tmp202_;
					gboolean _tmp203_ = FALSE;
					ValaClass* _tmp204_;
					ValaExpression* _tmp211_;
					ValaExpression* _tmp212_;
					ValaSemanticAnalyzer* _tmp213_;
					ValaSemanticAnalyzer* _tmp214_;
					ValaClass* _tmp215_;
					ValaObjectType* _tmp216_;
					ValaObjectType* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					_tmp200_ = cm;
					_tmp201_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp200_);
					_tmp202_ = _tmp201_;
					cl = VALA_IS_CLASS (_tmp202_) ? ((ValaClass*) _tmp202_) : NULL;
					_tmp204_ = cl;
					if (_tmp204_ == NULL) {
						_tmp203_ = TRUE;
					} else {
						ValaClass* _tmp205_;
						ValaSemanticAnalyzer* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaClass* _tmp208_;
						_tmp205_ = cl;
						_tmp206_ = vala_code_context_get_analyzer (context);
						_tmp207_ = _tmp206_;
						_tmp208_ = _tmp207_->object_type;
						_tmp203_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp205_, (ValaTypeSymbol*) _tmp208_);
					}
					if (_tmp203_) {
						ValaSourceReference* _tmp209_;
						ValaSourceReference* _tmp210_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp210_ = _tmp209_;
						vala_report_error (_tmp210_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp211_ = vala_method_call_get_call (self);
					_tmp212_ = _tmp211_;
					_tmp213_ = vala_code_context_get_analyzer (context);
					_tmp214_ = _tmp213_;
					_tmp215_ = _tmp214_->object_type;
					_tmp216_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp215_);
					_tmp217_ = _tmp216_;
					vala_expression_set_value_type (_tmp212_, (ValaDataType*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_method_call_get_call (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_expression_get_value_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = _vala_code_node_ref0 (_tmp221_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp222_;
				}
			}
		}
	}
	_tmp224_ = vala_method_call_get_call (self);
	_tmp225_ = _tmp224_;
	if (VALA_IS_MEMBER_ACCESS (_tmp225_)) {
		gboolean _tmp226_ = FALSE;
		gboolean _tmp227_ = FALSE;
		ValaExpression* _tmp228_;
		ValaExpression* _tmp229_;
		ValaSymbol* _tmp230_;
		ValaSymbol* _tmp231_;
		_tmp228_ = vala_method_call_get_call (self);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_expression_get_symbol_reference (_tmp229_);
		_tmp231_ = _tmp230_;
		if (VALA_IS_CREATION_METHOD (_tmp231_)) {
			ValaExpression* _tmp232_;
			ValaExpression* _tmp233_;
			ValaSymbol* _tmp234_;
			ValaSymbol* _tmp235_;
			ValaSymbol* _tmp236_;
			ValaSymbol* _tmp237_;
			_tmp232_ = vala_method_call_get_call (self);
			_tmp233_ = _tmp232_;
			_tmp234_ = vala_expression_get_symbol_reference (_tmp233_);
			_tmp235_ = _tmp234_;
			_tmp236_ = vala_symbol_get_parent_symbol (_tmp235_);
			_tmp237_ = _tmp236_;
			_tmp227_ = VALA_IS_STRUCT (_tmp237_);
		} else {
			_tmp227_ = FALSE;
		}
		if (_tmp227_) {
			_tmp226_ = TRUE;
		} else {
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			_tmp238_ = vala_method_call_get_call (self);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp226_ = VALA_IS_STRUCT (_tmp241_);
		}
		_tmp223_ = _tmp226_;
	} else {
		_tmp223_ = FALSE;
	}
	if (_tmp223_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp242_;
		ValaExpression* _tmp243_;
		ValaSymbol* _tmp244_;
		ValaSymbol* _tmp245_;
		gboolean _tmp246_ = FALSE;
		gboolean _tmp247_ = FALSE;
		ValaStruct* _tmp248_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp259_;
		ValaExpression* _tmp260_;
		ValaSourceReference* _tmp261_;
		ValaSourceReference* _tmp262_;
		ValaObjectCreationExpression* _tmp263_;
		ValaObjectCreationExpression* _tmp264_;
		ValaObjectCreationExpression* _tmp274_;
		ValaDataType* _tmp275_;
		ValaDataType* _tmp276_;
		ValaSemanticAnalyzer* _tmp277_;
		ValaSemanticAnalyzer* _tmp278_;
		ValaList* _tmp279_;
		ValaCodeNode* _tmp280_;
		ValaCodeNode* _tmp281_;
		ValaObjectCreationExpression* _tmp282_;
		ValaObjectCreationExpression* _tmp283_;
		_tmp242_ = vala_method_call_get_call (self);
		_tmp243_ = _tmp242_;
		_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
		_tmp245_ = _tmp244_;
		st = VALA_IS_STRUCT (_tmp245_) ? ((ValaStruct*) _tmp245_) : NULL;
		_tmp248_ = st;
		if (_tmp248_ != NULL) {
			ValaStruct* _tmp249_;
			ValaCreationMethod* _tmp250_;
			ValaCreationMethod* _tmp251_;
			_tmp249_ = st;
			_tmp250_ = vala_struct_get_default_construction_method (_tmp249_);
			_tmp251_ = _tmp250_;
			_tmp247_ = _tmp251_ == NULL;
		} else {
			_tmp247_ = FALSE;
		}
		if (_tmp247_) {
			gboolean _tmp252_ = FALSE;
			gboolean _tmp253_ = FALSE;
			ValaStruct* _tmp254_;
			_tmp254_ = st;
			if (vala_struct_is_boolean_type (_tmp254_)) {
				_tmp253_ = TRUE;
			} else {
				ValaStruct* _tmp255_;
				_tmp255_ = st;
				_tmp253_ = vala_struct_is_integer_type (_tmp255_);
			}
			if (_tmp253_) {
				_tmp252_ = TRUE;
			} else {
				ValaStruct* _tmp256_;
				_tmp256_ = st;
				_tmp252_ = vala_struct_is_floating_type (_tmp256_);
			}
			_tmp246_ = _tmp252_;
		} else {
			_tmp246_ = FALSE;
		}
		if (_tmp246_) {
			ValaSourceReference* _tmp257_;
			ValaSourceReference* _tmp258_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp257_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp258_ = _tmp257_;
			vala_report_error (_tmp258_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp259_ = vala_method_call_get_call (self);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp262_ = _tmp261_;
		_tmp263_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp260_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp262_);
		struct_creation_expression = _tmp263_;
		_tmp264_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp264_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp265_;
			ValaList* _tmp266_;
			gint _arg_size = 0;
			ValaList* _tmp267_;
			gint _tmp268_;
			gint _tmp269_;
			gint _arg_index = 0;
			_tmp265_ = self->priv->argument_list;
			_tmp266_ = _vala_iterable_ref0 (_tmp265_);
			_arg_list = _tmp266_;
			_tmp267_ = _arg_list;
			_tmp268_ = vala_collection_get_size ((ValaCollection*) _tmp267_);
			_tmp269_ = _tmp268_;
			_arg_size = _tmp269_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp270_;
				gpointer _tmp271_;
				ValaObjectCreationExpression* _tmp272_;
				ValaExpression* _tmp273_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp270_ = _arg_list;
				_tmp271_ = vala_list_get (_tmp270_, _arg_index);
				arg = (ValaExpression*) _tmp271_;
				_tmp272_ = struct_creation_expression;
				_tmp273_ = arg;
				vala_object_creation_expression_add_argument (_tmp272_, _tmp273_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp274_ = struct_creation_expression;
		_tmp275_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp276_ = _tmp275_;
		vala_expression_set_target_type ((ValaExpression*) _tmp274_, _tmp276_);
		_tmp277_ = vala_code_context_get_analyzer (context);
		_tmp278_ = _tmp277_;
		_tmp279_ = _tmp278_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp279_, (ValaCodeNode*) self);
		_tmp280_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp281_ = _tmp280_;
		_tmp282_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp281_, (ValaExpression*) self, (ValaExpression*) _tmp282_);
		_tmp283_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp283_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp284_ = FALSE;
		gboolean _tmp285_ = FALSE;
		gboolean _tmp286_;
		_tmp286_ = self->priv->_is_chainup;
		if (!_tmp286_) {
			ValaExpression* _tmp287_;
			ValaExpression* _tmp288_;
			_tmp287_ = vala_method_call_get_call (self);
			_tmp288_ = _tmp287_;
			_tmp285_ = VALA_IS_MEMBER_ACCESS (_tmp288_);
		} else {
			_tmp285_ = FALSE;
		}
		if (_tmp285_) {
			ValaExpression* _tmp289_;
			ValaExpression* _tmp290_;
			ValaSymbol* _tmp291_;
			ValaSymbol* _tmp292_;
			_tmp289_ = vala_method_call_get_call (self);
			_tmp290_ = _tmp289_;
			_tmp291_ = vala_expression_get_symbol_reference (_tmp290_);
			_tmp292_ = _tmp291_;
			_tmp284_ = VALA_IS_CREATION_METHOD (_tmp292_);
		} else {
			_tmp284_ = FALSE;
		}
		if (_tmp284_) {
			ValaSourceReference* _tmp293_;
			ValaSourceReference* _tmp294_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp293_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp294_ = _tmp293_;
			vala_report_error (_tmp294_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp296_ = self->priv->_is_chainup;
	if (!_tmp296_) {
		ValaDataType* _tmp297_;
		_tmp297_ = mtype;
		_tmp295_ = VALA_IS_OBJECT_TYPE (_tmp297_);
	} else {
		_tmp295_ = FALSE;
	}
	if (_tmp295_) {
		ValaSourceReference* _tmp298_;
		ValaSourceReference* _tmp299_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp298_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp299_ = _tmp298_;
		vala_report_error (_tmp299_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp300_ = FALSE;
		ValaDataType* _tmp301_;
		_tmp301_ = mtype;
		if (_tmp301_ != NULL) {
			ValaDataType* _tmp302_;
			_tmp302_ = mtype;
			_tmp300_ = vala_data_type_is_invokable (_tmp302_);
		} else {
			_tmp300_ = FALSE;
		}
		if (_tmp300_) {
		} else {
			ValaExpression* _tmp303_;
			ValaExpression* _tmp304_;
			ValaSymbol* _tmp305_;
			ValaSymbol* _tmp306_;
			_tmp303_ = vala_method_call_get_call (self);
			_tmp304_ = _tmp303_;
			_tmp305_ = vala_expression_get_symbol_reference (_tmp304_);
			_tmp306_ = _tmp305_;
			if (VALA_IS_CLASS (_tmp306_)) {
				ValaSourceReference* _tmp307_;
				ValaSourceReference* _tmp308_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp308_ = _tmp307_;
				vala_report_error (_tmp308_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp309_;
				ValaSourceReference* _tmp310_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp309_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp310_ = _tmp309_;
				vala_report_error (_tmp310_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp311_ = mtype;
	_tmp312_ = vala_data_type_get_return_type (_tmp311_);
	_tmp313_ = _vala_code_node_ref0 (_tmp312_);
	ret_type = _tmp313_;
	_tmp314_ = mtype;
	_tmp315_ = vala_data_type_get_parameters (_tmp314_);
	_tmp316_ = _vala_iterable_ref0 (_tmp315_);
	params = _tmp316_;
	_tmp317_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp317_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp318_;
		ValaExpression* _tmp319_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp320_;
		ValaMethod* _tmp321_;
		ValaMethod* _tmp322_;
		ValaMethod* _tmp323_;
		gboolean _tmp324_;
		gboolean _tmp325_;
		gint n_type_params = 0;
		ValaMethod* _tmp356_;
		ValaList* _tmp357_;
		gint _tmp358_;
		gint _tmp359_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp360_;
		ValaList* _tmp361_;
		gint _tmp362_;
		gint _tmp363_;
		gboolean _tmp364_ = FALSE;
		_tmp318_ = vala_method_call_get_call (self);
		_tmp319_ = _tmp318_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp319_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp320_ = mtype;
		_tmp321_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp322_ = _tmp321_;
		m = _tmp322_;
		_tmp323_ = m;
		_tmp324_ = vala_method_get_coroutine (_tmp323_);
		_tmp325_ = _tmp324_;
		if (_tmp325_) {
			gboolean _tmp326_;
			_tmp326_ = self->priv->_is_yield_expression;
			if (!_tmp326_) {
				ValaMemberAccess* _tmp327_;
				const gchar* _tmp328_;
				const gchar* _tmp329_;
				_tmp327_ = ma;
				_tmp328_ = vala_member_access_get_member_name (_tmp327_);
				_tmp329_ = _tmp328_;
				if (g_strcmp0 (_tmp329_, "end") != 0) {
					ValaMemberAccess* _tmp330_;
					const gchar* _tmp331_;
					const gchar* _tmp332_;
					ValaMethod* _tmp336_;
					ValaList* _tmp337_;
					ValaVoidType* _tmp338_;
					_tmp330_ = ma;
					_tmp331_ = vala_member_access_get_member_name (_tmp330_);
					_tmp332_ = _tmp331_;
					if (g_strcmp0 (_tmp332_, "begin") != 0) {
						ValaMemberAccess* _tmp333_;
						ValaSourceReference* _tmp334_;
						ValaSourceReference* _tmp335_;
						_tmp333_ = ma;
						_tmp334_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp333_);
						_tmp335_ = _tmp334_;
						vala_report_deprecated (_tmp335_, "implicit .begin is deprecated");
					}
					_tmp336_ = m;
					_tmp337_ = vala_method_get_async_begin_parameters (_tmp336_);
					_vala_iterable_unref0 (params);
					params = _tmp337_;
					_tmp338_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp338_;
				} else {
					ValaMethod* _tmp339_;
					ValaList* _tmp340_;
					_tmp339_ = m;
					_tmp340_ = vala_method_get_async_end_parameters (_tmp339_);
					_vala_iterable_unref0 (params);
					params = _tmp340_;
				}
			} else {
				gboolean _tmp341_ = FALSE;
				ValaMemberAccess* _tmp342_;
				const gchar* _tmp343_;
				const gchar* _tmp344_;
				_tmp342_ = ma;
				_tmp343_ = vala_member_access_get_member_name (_tmp342_);
				_tmp344_ = _tmp343_;
				if (g_strcmp0 (_tmp344_, "begin") == 0) {
					_tmp341_ = TRUE;
				} else {
					ValaMemberAccess* _tmp345_;
					const gchar* _tmp346_;
					const gchar* _tmp347_;
					_tmp345_ = ma;
					_tmp346_ = vala_member_access_get_member_name (_tmp345_);
					_tmp347_ = _tmp346_;
					_tmp341_ = g_strcmp0 (_tmp347_, "end") == 0;
				}
				if (_tmp341_) {
					ValaMemberAccess* _tmp348_;
					ValaSourceReference* _tmp349_;
					ValaSourceReference* _tmp350_;
					ValaMemberAccess* _tmp351_;
					const gchar* _tmp352_;
					const gchar* _tmp353_;
					gchar* _tmp354_;
					gchar* _tmp355_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp348_ = ma;
					_tmp349_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp348_);
					_tmp350_ = _tmp349_;
					_tmp351_ = ma;
					_tmp352_ = vala_member_access_get_member_name (_tmp351_);
					_tmp353_ = _tmp352_;
					_tmp354_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp353_);
					_tmp355_ = _tmp354_;
					vala_report_error (_tmp350_, _tmp355_);
					_g_free0 (_tmp355_);
				}
			}
		}
		_tmp356_ = m;
		_tmp357_ = vala_method_get_type_parameters (_tmp356_);
		_tmp358_ = vala_collection_get_size ((ValaCollection*) _tmp357_);
		_tmp359_ = _tmp358_;
		n_type_params = _tmp359_;
		_tmp360_ = ma;
		_tmp361_ = vala_member_access_get_type_arguments (_tmp360_);
		_tmp362_ = vala_collection_get_size ((ValaCollection*) _tmp361_);
		_tmp363_ = _tmp362_;
		n_type_args = _tmp363_;
		if (n_type_args > 0) {
			_tmp364_ = n_type_args < n_type_params;
		} else {
			_tmp364_ = FALSE;
		}
		if (_tmp364_) {
			ValaMemberAccess* _tmp365_;
			ValaSourceReference* _tmp366_;
			ValaSourceReference* _tmp367_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp365_ = ma;
			_tmp366_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp365_);
			_tmp367_ = _tmp366_;
			vala_report_error (_tmp367_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp368_ = FALSE;
			if (n_type_args > 0) {
				_tmp368_ = n_type_args > n_type_params;
			} else {
				_tmp368_ = FALSE;
			}
			if (_tmp368_) {
				ValaMemberAccess* _tmp369_;
				ValaSourceReference* _tmp370_;
				ValaSourceReference* _tmp371_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp369_ = ma;
				_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp369_);
				_tmp371_ = _tmp370_;
				vala_report_error (_tmp371_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp372_ = self->priv->argument_list;
	_tmp373_ = vala_iterable_iterator ((ValaIterable*) _tmp372_);
	arg_it = _tmp373_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp374_;
		ValaList* _tmp375_;
		gint _param_size = 0;
		ValaList* _tmp376_;
		gint _tmp377_;
		gint _tmp378_;
		gint _param_index = 0;
		_tmp374_ = params;
		_tmp375_ = _vala_iterable_ref0 (_tmp374_);
		_param_list = _tmp375_;
		_tmp376_ = _param_list;
		_tmp377_ = vala_collection_get_size ((ValaCollection*) _tmp376_);
		_tmp378_ = _tmp377_;
		_param_size = _tmp378_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp379_;
			gpointer _tmp380_;
			ValaParameter* _tmp381_;
			ValaParameter* _tmp382_;
			gboolean _tmp383_;
			gboolean _tmp384_;
			ValaParameter* _tmp385_;
			gboolean _tmp386_;
			gboolean _tmp387_;
			ValaIterator* _tmp405_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp379_ = _param_list;
			_tmp380_ = vala_list_get (_tmp379_, _param_index);
			param = (ValaParameter*) _tmp380_;
			_tmp381_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp381_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp382_ = param;
			_tmp383_ = vala_parameter_get_ellipsis (_tmp382_);
			_tmp384_ = _tmp383_;
			if (_tmp384_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp385_ = param;
			_tmp386_ = vala_parameter_get_params_array (_tmp385_);
			_tmp387_ = _tmp386_;
			if (_tmp387_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp388_;
				ValaDataType* _tmp389_;
				ValaDataType* _tmp390_;
				ValaArrayType* _tmp391_;
				_tmp388_ = param;
				_tmp389_ = vala_variable_get_variable_type ((ValaVariable*) _tmp388_);
				_tmp390_ = _tmp389_;
				_tmp391_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp390_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp391_;
				while (TRUE) {
					ValaIterator* _tmp392_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp393_;
					gpointer _tmp394_;
					ValaExpression* _tmp395_;
					ValaArrayType* _tmp396_;
					ValaDataType* _tmp397_;
					ValaDataType* _tmp398_;
					ValaExpression* _tmp399_;
					ValaDataType* _tmp400_;
					ValaDataType* _tmp401_;
					ValaArrayType* _tmp402_;
					gboolean _tmp403_;
					gboolean _tmp404_;
					_tmp392_ = arg_it;
					if (!vala_iterator_next (_tmp392_)) {
						break;
					}
					_tmp393_ = arg_it;
					_tmp394_ = vala_iterator_get (_tmp393_);
					arg = (ValaExpression*) _tmp394_;
					_tmp395_ = arg;
					_tmp396_ = array_type;
					_tmp397_ = vala_array_type_get_element_type (_tmp396_);
					_tmp398_ = _tmp397_;
					vala_expression_set_target_type (_tmp395_, _tmp398_);
					_tmp399_ = arg;
					_tmp400_ = vala_expression_get_target_type (_tmp399_);
					_tmp401_ = _tmp400_;
					_tmp402_ = array_type;
					_tmp403_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp402_);
					_tmp404_ = _tmp403_;
					vala_data_type_set_value_owned (_tmp401_, _tmp404_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp405_ = arg_it;
			if (vala_iterator_next (_tmp405_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp406_;
				gpointer _tmp407_;
				ValaExpression* _tmp408_;
				ValaParameter* _tmp409_;
				ValaDataType* _tmp410_;
				ValaDataType* _tmp411_;
				ValaExpression* _tmp412_;
				ValaExpression* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaDataType* _tmp416_;
				ValaList* _tmp417_;
				ValaDataType* _tmp418_;
				ValaDataType* _tmp419_;
				ValaExpression* _tmp420_;
				ValaExpression* _tmp421_;
				_tmp406_ = arg_it;
				_tmp407_ = vala_iterator_get (_tmp406_);
				arg = (ValaExpression*) _tmp407_;
				_tmp408_ = arg;
				_tmp409_ = param;
				_tmp410_ = vala_variable_get_variable_type ((ValaVariable*) _tmp409_);
				_tmp411_ = _tmp410_;
				vala_expression_set_formal_target_type (_tmp408_, _tmp411_);
				_tmp412_ = arg;
				_tmp413_ = arg;
				_tmp414_ = vala_expression_get_formal_target_type (_tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = target_object_type;
				_tmp417_ = method_type_args;
				_tmp418_ = vala_data_type_get_actual_type (_tmp415_, _tmp416_, _tmp417_, (ValaCodeNode*) self);
				_tmp419_ = _tmp418_;
				vala_expression_set_target_type (_tmp412_, _tmp419_);
				_vala_code_node_unref0 (_tmp419_);
				_tmp420_ = arg;
				_tmp421_ = _vala_code_node_ref0 (_tmp420_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp421_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp423_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp423_)) {
		ValaDataType* _tmp424_;
		ValaMethod* _tmp425_;
		ValaMethod* _tmp426_;
		ValaAttribute* _tmp427_;
		_tmp424_ = mtype;
		_tmp425_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp424_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp426_, "Print");
		_tmp422_ = _tmp427_ != NULL;
	} else {
		_tmp422_ = FALSE;
	}
	if (_tmp422_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp428_;
		ValaSourceReference* _tmp429_;
		ValaTemplate* _tmp430_;
		ValaList* _tmp441_;
		ValaTemplate* _tmp442_;
		_tmp428_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp429_ = _tmp428_;
		_tmp430_ = vala_template_new (_tmp429_);
		template = _tmp430_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp431_;
			ValaList* _tmp432_;
			gint _arg_size = 0;
			ValaList* _tmp433_;
			gint _tmp434_;
			gint _tmp435_;
			gint _arg_index = 0;
			_tmp431_ = self->priv->argument_list;
			_tmp432_ = _vala_iterable_ref0 (_tmp431_);
			_arg_list = _tmp432_;
			_tmp433_ = _arg_list;
			_tmp434_ = vala_collection_get_size ((ValaCollection*) _tmp433_);
			_tmp435_ = _tmp434_;
			_arg_size = _tmp435_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp436_;
				gpointer _tmp437_;
				ValaExpression* _tmp438_;
				ValaTemplate* _tmp439_;
				ValaExpression* _tmp440_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp436_ = _arg_list;
				_tmp437_ = vala_list_get (_tmp436_, _arg_index);
				arg = (ValaExpression*) _tmp437_;
				_tmp438_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp438_, NULL);
				_tmp439_ = template;
				_tmp440_ = arg;
				vala_template_add_expression (_tmp439_, _tmp440_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp441_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp441_);
		_tmp442_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp442_);
		_vala_code_node_unref0 (template);
	}
	_tmp444_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp444_)) {
		ValaDataType* _tmp445_;
		ValaMethod* _tmp446_;
		ValaMethod* _tmp447_;
		gboolean _tmp448_;
		gboolean _tmp449_;
		_tmp445_ = mtype;
		_tmp446_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp445_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp447_ = _tmp446_;
		_tmp448_ = vala_method_get_printf_format (_tmp447_);
		_tmp449_ = _tmp448_;
		_tmp443_ = _tmp449_;
	} else {
		_tmp443_ = FALSE;
	}
	if (_tmp443_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp450_;
		ValaStringLiteral* _tmp498_;
		format_literal = NULL;
		_tmp450_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp450_)) {
		} else {
			ValaExpression* _tmp451_;
			_tmp451_ = last_arg;
			if (_tmp451_ != NULL) {
				ValaExpression* _tmp452_;
				ValaStringLiteral* _tmp453_;
				gboolean _tmp454_ = FALSE;
				ValaStringLiteral* _tmp455_;
				_tmp452_ = last_arg;
				_tmp453_ = vala_string_literal_get_format_literal (_tmp452_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp453_;
				_tmp455_ = format_literal;
				if (_tmp455_ == NULL) {
					ValaList* _tmp456_;
					gint _tmp457_;
					gint _tmp458_;
					ValaList* _tmp459_;
					gint _tmp460_;
					gint _tmp461_;
					_tmp456_ = self->priv->argument_list;
					_tmp457_ = vala_collection_get_size ((ValaCollection*) _tmp456_);
					_tmp458_ = _tmp457_;
					_tmp459_ = params;
					_tmp460_ = vala_collection_get_size ((ValaCollection*) _tmp459_);
					_tmp461_ = _tmp460_;
					_tmp454_ = _tmp458_ == (_tmp461_ - 1);
				} else {
					_tmp454_ = FALSE;
				}
				if (_tmp454_) {
					ValaStringLiteral* _tmp462_;
					ValaStringLiteral* _tmp463_;
					ValaSemanticAnalyzer* _tmp464_;
					ValaSemanticAnalyzer* _tmp465_;
					ValaDataType* _tmp466_;
					ValaDataType* _tmp467_;
					ValaDataType* _tmp468_;
					ValaList* _tmp469_;
					ValaList* _tmp470_;
					gint _tmp471_;
					gint _tmp472_;
					ValaStringLiteral* _tmp473_;
					ValaList* _tmp474_;
					ValaIterator* _tmp475_;
					_tmp462_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp462_;
					_tmp463_ = format_literal;
					_tmp464_ = vala_code_context_get_analyzer (context);
					_tmp465_ = _tmp464_;
					_tmp466_ = _tmp465_->string_type;
					_tmp467_ = vala_data_type_copy (_tmp466_);
					_tmp468_ = _tmp467_;
					vala_expression_set_target_type ((ValaExpression*) _tmp463_, _tmp468_);
					_vala_code_node_unref0 (_tmp468_);
					_tmp469_ = self->priv->argument_list;
					_tmp470_ = self->priv->argument_list;
					_tmp471_ = vala_collection_get_size ((ValaCollection*) _tmp470_);
					_tmp472_ = _tmp471_;
					_tmp473_ = format_literal;
					vala_list_insert (_tmp469_, _tmp472_ - 1, (ValaExpression*) _tmp473_);
					_tmp474_ = self->priv->argument_list;
					_tmp475_ = vala_iterable_iterator ((ValaIterable*) _tmp474_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp475_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp476_;
						ValaList* _tmp477_;
						gint _param_size = 0;
						ValaList* _tmp478_;
						gint _tmp479_;
						gint _tmp480_;
						gint _param_index = 0;
						_tmp476_ = params;
						_tmp477_ = _vala_iterable_ref0 (_tmp476_);
						_param_list = _tmp477_;
						_tmp478_ = _param_list;
						_tmp479_ = vala_collection_get_size ((ValaCollection*) _tmp478_);
						_tmp480_ = _tmp479_;
						_param_size = _tmp480_;
						_param_index = -1;
						while (TRUE) {
							ValaParameter* param = NULL;
							ValaList* _tmp481_;
							gpointer _tmp482_;
							gboolean _tmp483_ = FALSE;
							ValaParameter* _tmp484_;
							gboolean _tmp485_;
							gboolean _tmp486_;
							ValaIterator* _tmp490_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp481_ = _param_list;
							_tmp482_ = vala_list_get (_tmp481_, _param_index);
							param = (ValaParameter*) _tmp482_;
							_tmp484_ = param;
							_tmp485_ = vala_parameter_get_ellipsis (_tmp484_);
							_tmp486_ = _tmp485_;
							if (_tmp486_) {
								_tmp483_ = TRUE;
							} else {
								ValaParameter* _tmp487_;
								gboolean _tmp488_;
								gboolean _tmp489_;
								_tmp487_ = param;
								_tmp488_ = vala_parameter_get_params_array (_tmp487_);
								_tmp489_ = _tmp488_;
								_tmp483_ = _tmp489_;
							}
							if (_tmp483_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp490_ = arg_it;
							vala_iterator_next (_tmp490_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp491_;
				ValaExpression* _tmp492_;
				ValaMemberAccess* _tmp493_;
				_tmp491_ = vala_method_call_get_call (self);
				_tmp492_ = _tmp491_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp492_) ? ((ValaMemberAccess*) _tmp492_) : NULL;
				_tmp493_ = ma;
				if (_tmp493_ != NULL) {
					ValaMemberAccess* _tmp494_;
					ValaExpression* _tmp495_;
					ValaExpression* _tmp496_;
					ValaStringLiteral* _tmp497_;
					_tmp494_ = ma;
					_tmp495_ = vala_member_access_get_inner (_tmp494_);
					_tmp496_ = _tmp495_;
					_tmp497_ = vala_string_literal_get_format_literal (_tmp496_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp497_;
				}
			}
		}
		_tmp498_ = format_literal;
		if (_tmp498_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp499_;
			gchar* _tmp500_;
			ValaSemanticAnalyzer* _tmp501_;
			ValaSemanticAnalyzer* _tmp502_;
			const gchar* _tmp503_;
			ValaIterator* _tmp504_;
			ValaSourceReference* _tmp505_;
			ValaSourceReference* _tmp506_;
			_tmp499_ = format_literal;
			_tmp500_ = vala_string_literal_eval (_tmp499_);
			format = _tmp500_;
			_tmp501_ = vala_code_context_get_analyzer (context);
			_tmp502_ = _tmp501_;
			_tmp503_ = format;
			_tmp504_ = arg_it;
			_tmp505_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp506_ = _tmp505_;
			if (!vala_semantic_analyzer_check_print_format (_tmp502_, _tmp503_, _tmp504_, _tmp506_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp507_;
		ValaList* _tmp508_;
		gint _arg_size = 0;
		ValaList* _tmp509_;
		gint _tmp510_;
		gint _tmp511_;
		gint _arg_index = 0;
		_tmp507_ = self->priv->argument_list;
		_tmp508_ = _vala_iterable_ref0 (_tmp507_);
		_arg_list = _tmp508_;
		_tmp509_ = _arg_list;
		_tmp510_ = vala_collection_get_size ((ValaCollection*) _tmp509_);
		_tmp511_ = _tmp510_;
		_arg_size = _tmp511_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp512_;
			gpointer _tmp513_;
			ValaExpression* _tmp514_;
			gboolean _tmp515_ = FALSE;
			ValaExpression* _tmp516_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp512_ = _arg_list;
			_tmp513_ = vala_list_get (_tmp512_, _arg_index);
			arg = (ValaExpression*) _tmp513_;
			_tmp514_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp514_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp516_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp516_)) {
				ValaExpression* _tmp517_;
				ValaMethod* _tmp518_;
				ValaMethod* _tmp519_;
				gboolean _tmp520_;
				gboolean _tmp521_;
				_tmp517_ = arg;
				_tmp518_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp517_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp519_ = _tmp518_;
				_tmp520_ = vala_method_get_closure (_tmp519_);
				_tmp521_ = _tmp520_;
				_tmp515_ = _tmp521_;
			} else {
				_tmp515_ = FALSE;
			}
			if (_tmp515_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp523_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp524_ = _tmp523_;
	if (!_tmp524_) {
		_tmp522_ = force_lambda_method_closure;
	} else {
		_tmp522_ = FALSE;
	}
	if (_tmp522_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp525_;
			ValaList* _tmp526_;
			gint _arg_size = 0;
			ValaList* _tmp527_;
			gint _tmp528_;
			gint _tmp529_;
			gint _arg_index = 0;
			_tmp525_ = self->priv->argument_list;
			_tmp526_ = _vala_iterable_ref0 (_tmp525_);
			_arg_list = _tmp526_;
			_tmp527_ = _arg_list;
			_tmp528_ = vala_collection_get_size ((ValaCollection*) _tmp527_);
			_tmp529_ = _tmp528_;
			_arg_size = _tmp529_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp530_;
				gpointer _tmp531_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp532_;
				gboolean _tmp533_ = FALSE;
				ValaLambdaExpression* _tmp534_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp530_ = _arg_list;
				_tmp531_ = vala_list_get (_tmp530_, _arg_index);
				arg = (ValaExpression*) _tmp531_;
				_tmp532_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp532_) ? ((ValaLambdaExpression*) _tmp532_) : NULL;
				_tmp534_ = lambda;
				if (_tmp534_ != NULL) {
					ValaLambdaExpression* _tmp535_;
					ValaMethod* _tmp536_;
					ValaMethod* _tmp537_;
					ValaMemberBinding _tmp538_;
					ValaMemberBinding _tmp539_;
					_tmp535_ = lambda;
					_tmp536_ = vala_lambda_expression_get_method (_tmp535_);
					_tmp537_ = _tmp536_;
					_tmp538_ = vala_method_get_binding (_tmp537_);
					_tmp539_ = _tmp538_;
					_tmp533_ = _tmp539_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp533_ = FALSE;
				}
				if (_tmp533_) {
					ValaLambdaExpression* _tmp540_;
					ValaMethod* _tmp541_;
					ValaMethod* _tmp542_;
					_tmp540_ = lambda;
					_tmp541_ = vala_lambda_expression_get_method (_tmp540_);
					_tmp542_ = _tmp541_;
					vala_method_set_closure (_tmp542_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
	}
	_tmp543_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp543_)) {
		gboolean _tmp544_ = FALSE;
		gboolean _tmp545_ = FALSE;
		ValaCodeNode* _tmp546_;
		ValaCodeNode* _tmp547_;
		_tmp546_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp547_ = _tmp546_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp547_)) {
			ValaCodeNode* _tmp548_;
			ValaCodeNode* _tmp549_;
			_tmp548_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp549_ = _tmp548_;
			_tmp545_ = !VALA_IS_FOR_STATEMENT (_tmp549_);
		} else {
			_tmp545_ = FALSE;
		}
		if (_tmp545_) {
			ValaCodeNode* _tmp550_;
			ValaCodeNode* _tmp551_;
			_tmp550_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp551_ = _tmp550_;
			_tmp544_ = !VALA_IS_YIELD_STATEMENT (_tmp551_);
		} else {
			_tmp544_ = FALSE;
		}
		if (_tmp544_) {
			ValaSourceReference* _tmp552_;
			ValaSourceReference* _tmp553_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp552_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp553_ = _tmp552_;
			vala_report_error (_tmp553_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp554_ = ret_type;
	_tmp555_ = vala_data_type_copy (_tmp554_);
	_tmp556_ = _tmp555_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp556_);
	_vala_code_node_unref0 (_tmp556_);
	_tmp557_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp558_ = _tmp557_;
	_tmp559_ = target_object_type;
	_tmp560_ = method_type_args;
	_tmp561_ = vala_data_type_get_actual_type (_tmp558_, _tmp559_, _tmp560_, (ValaCodeNode*) self);
	_tmp562_ = _tmp561_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp562_);
	_vala_code_node_unref0 (_tmp562_);
	_tmp563_ = self->priv->_is_yield_expression;
	if (_tmp563_) {
		gboolean _tmp564_ = FALSE;
		ValaDataType* _tmp565_;
		gboolean _tmp573_ = FALSE;
		ValaSemanticAnalyzer* _tmp574_;
		ValaSemanticAnalyzer* _tmp575_;
		ValaMethod* _tmp576_;
		ValaMethod* _tmp577_;
		_tmp565_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp565_)) {
			_tmp564_ = TRUE;
		} else {
			ValaDataType* _tmp566_;
			ValaMethod* _tmp567_;
			ValaMethod* _tmp568_;
			gboolean _tmp569_;
			gboolean _tmp570_;
			_tmp566_ = mtype;
			_tmp567_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp566_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp568_ = _tmp567_;
			_tmp569_ = vala_method_get_coroutine (_tmp568_);
			_tmp570_ = _tmp569_;
			_tmp564_ = !_tmp570_;
		}
		if (_tmp564_) {
			ValaSourceReference* _tmp571_;
			ValaSourceReference* _tmp572_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp571_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp572_ = _tmp571_;
			vala_report_error (_tmp572_, "yield expression requires async method");
		}
		_tmp574_ = vala_code_context_get_analyzer (context);
		_tmp575_ = _tmp574_;
		_tmp576_ = vala_semantic_analyzer_get_current_method (_tmp575_);
		_tmp577_ = _tmp576_;
		if (_tmp577_ == NULL) {
			_tmp573_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp578_;
			ValaSemanticAnalyzer* _tmp579_;
			ValaMethod* _tmp580_;
			ValaMethod* _tmp581_;
			gboolean _tmp582_;
			gboolean _tmp583_;
			_tmp578_ = vala_code_context_get_analyzer (context);
			_tmp579_ = _tmp578_;
			_tmp580_ = vala_semantic_analyzer_get_current_method (_tmp579_);
			_tmp581_ = _tmp580_;
			_tmp582_ = vala_method_get_coroutine (_tmp581_);
			_tmp583_ = _tmp582_;
			_tmp573_ = !_tmp583_;
		}
		if (_tmp573_) {
			ValaSourceReference* _tmp584_;
			ValaSourceReference* _tmp585_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp584_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp585_ = _tmp584_;
			vala_report_error (_tmp585_, "yield expression not available outside async method");
		}
	}
	_tmp586_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp586_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp587_;
		ValaMethod* _tmp588_;
		ValaMethod* _tmp589_;
		ValaMethod* _tmp590_;
		gboolean _tmp591_;
		gboolean _tmp592_;
		ValaMethod* _tmp595_;
		gboolean _tmp596_;
		gboolean _tmp597_;
		gboolean _tmp625_ = FALSE;
		gboolean _tmp626_ = FALSE;
		gboolean _tmp627_ = FALSE;
		gboolean _tmp628_;
		gboolean _tmp629_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp641_;
		ValaSymbol* _tmp642_;
		ValaSymbol* _tmp643_;
		gboolean _tmp644_ = FALSE;
		ValaSignal* _tmp645_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp658_;
		ValaSymbol* _tmp659_;
		ValaSymbol* _tmp660_;
		gboolean _tmp661_ = FALSE;
		ValaDynamicSignal* _tmp662_;
		gboolean _tmp704_ = FALSE;
		ValaMethod* _tmp705_;
		gboolean _tmp812_ = FALSE;
		ValaMethod* _tmp813_;
		_tmp587_ = mtype;
		_tmp588_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp587_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp589_ = _tmp588_;
		m = _tmp589_;
		_tmp590_ = m;
		_tmp591_ = vala_method_get_returns_floating_reference (_tmp590_);
		_tmp592_ = _tmp591_;
		if (_tmp592_) {
			ValaDataType* _tmp593_;
			ValaDataType* _tmp594_;
			_tmp593_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp594_ = _tmp593_;
			vala_data_type_set_floating_reference (_tmp594_, TRUE);
		}
		_tmp595_ = m;
		_tmp596_ = vala_method_get_returns_modified_pointer (_tmp595_);
		_tmp597_ = _tmp596_;
		if (_tmp597_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp598_;
			ValaExpression* _tmp599_;
			ValaExpression* _tmp600_;
			ValaExpression* _tmp601_;
			ValaExpression* _tmp602_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp603_;
			ValaSymbol* _tmp604_;
			ValaSymbol* _tmp605_;
			gboolean _tmp606_ = FALSE;
			ValaProperty* _tmp607_;
			_tmp598_ = vala_method_call_get_call (self);
			_tmp599_ = _tmp598_;
			_tmp600_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp599_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp601_ = _tmp600_;
			inner = _tmp601_;
			_tmp602_ = inner;
			vala_expression_set_lvalue (_tmp602_, TRUE);
			_tmp603_ = inner;
			_tmp604_ = vala_expression_get_symbol_reference (_tmp603_);
			_tmp605_ = _tmp604_;
			prop = VALA_IS_PROPERTY (_tmp605_) ? ((ValaProperty*) _tmp605_) : NULL;
			_tmp607_ = prop;
			if (_tmp607_ != NULL) {
				gboolean _tmp608_ = FALSE;
				ValaProperty* _tmp609_;
				ValaPropertyAccessor* _tmp610_;
				ValaPropertyAccessor* _tmp611_;
				_tmp609_ = prop;
				_tmp610_ = vala_property_get_set_accessor (_tmp609_);
				_tmp611_ = _tmp610_;
				if (_tmp611_ == NULL) {
					_tmp608_ = TRUE;
				} else {
					ValaProperty* _tmp612_;
					ValaPropertyAccessor* _tmp613_;
					ValaPropertyAccessor* _tmp614_;
					gboolean _tmp615_;
					gboolean _tmp616_;
					_tmp612_ = prop;
					_tmp613_ = vala_property_get_set_accessor (_tmp612_);
					_tmp614_ = _tmp613_;
					_tmp615_ = vala_property_accessor_get_writable (_tmp614_);
					_tmp616_ = _tmp615_;
					_tmp608_ = !_tmp616_;
				}
				_tmp606_ = _tmp608_;
			} else {
				_tmp606_ = FALSE;
			}
			if (_tmp606_) {
				ValaExpression* _tmp617_;
				ValaSourceReference* _tmp618_;
				ValaSourceReference* _tmp619_;
				ValaProperty* _tmp620_;
				gchar* _tmp621_;
				gchar* _tmp622_;
				gchar* _tmp623_;
				gchar* _tmp624_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp617_ = inner;
				_tmp618_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp617_);
				_tmp619_ = _tmp618_;
				_tmp620_ = prop;
				_tmp621_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp620_);
				_tmp622_ = _tmp621_;
				_tmp623_ = g_strdup_printf ("Property `%s' is read-only", _tmp622_);
				_tmp624_ = _tmp623_;
				vala_report_error (_tmp619_, _tmp624_);
				_g_free0 (_tmp624_);
				_g_free0 (_tmp622_);
			}
		}
		_tmp628_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp629_ = _tmp628_;
		if (_tmp629_) {
			ValaDataType* _tmp630_;
			ValaDataType* _tmp631_;
			gboolean _tmp632_;
			gboolean _tmp633_;
			_tmp630_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp631_ = _tmp630_;
			_tmp632_ = vala_data_type_get_nullable (_tmp631_);
			_tmp633_ = _tmp632_;
			_tmp627_ = !_tmp633_;
		} else {
			_tmp627_ = FALSE;
		}
		if (_tmp627_) {
			ValaDataType* _tmp634_;
			ValaDataType* _tmp635_;
			gboolean _tmp636_;
			gboolean _tmp637_;
			_tmp634_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp635_ = _tmp634_;
			_tmp636_ = vala_data_type_get_floating_reference (_tmp635_);
			_tmp637_ = _tmp636_;
			_tmp626_ = _tmp637_;
		} else {
			_tmp626_ = FALSE;
		}
		if (_tmp626_) {
			ValaDataType* _tmp638_;
			_tmp638_ = ret_type;
			_tmp625_ = VALA_IS_OBJECT_TYPE (_tmp638_);
		} else {
			_tmp625_ = FALSE;
		}
		if (_tmp625_) {
			ValaDataType* _tmp639_;
			ValaDataType* _tmp640_;
			_tmp639_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp640_ = _tmp639_;
			vala_data_type_set_nullable (_tmp640_, TRUE);
		}
		_tmp641_ = m;
		_tmp642_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp641_);
		_tmp643_ = _tmp642_;
		sig = VALA_IS_SIGNAL (_tmp643_) ? ((ValaSignal*) _tmp643_) : NULL;
		_tmp645_ = sig;
		if (_tmp645_ != NULL) {
			ValaMethod* _tmp646_;
			const gchar* _tmp647_;
			const gchar* _tmp648_;
			_tmp646_ = m;
			_tmp647_ = vala_symbol_get_name ((ValaSymbol*) _tmp646_);
			_tmp648_ = _tmp647_;
			_tmp644_ = g_strcmp0 (_tmp648_, "disconnect") == 0;
		} else {
			_tmp644_ = FALSE;
		}
		if (_tmp644_) {
			gboolean _tmp649_ = FALSE;
			ValaList* _tmp650_;
			gboolean _tmp651_;
			gboolean _tmp652_;
			_tmp650_ = self->priv->argument_list;
			_tmp651_ = vala_collection_get_is_empty ((ValaCollection*) _tmp650_);
			_tmp652_ = _tmp651_;
			if (!_tmp652_) {
				ValaList* _tmp653_;
				gpointer _tmp654_;
				ValaExpression* _tmp655_;
				_tmp653_ = self->priv->argument_list;
				_tmp654_ = vala_list_get (_tmp653_, 0);
				_tmp655_ = (ValaExpression*) _tmp654_;
				_tmp649_ = VALA_IS_LAMBDA_EXPRESSION (_tmp655_);
				_vala_code_node_unref0 (_tmp655_);
			} else {
				_tmp649_ = FALSE;
			}
			if (_tmp649_) {
				ValaSourceReference* _tmp656_;
				ValaSourceReference* _tmp657_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp656_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp657_ = _tmp656_;
				vala_report_error (_tmp657_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp658_ = m;
		_tmp659_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp658_);
		_tmp660_ = _tmp659_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp660_) ? ((ValaDynamicSignal*) _tmp660_) : NULL;
		_tmp662_ = dynamic_sig;
		if (_tmp662_ != NULL) {
			ValaDynamicSignal* _tmp663_;
			ValaExpression* _tmp664_;
			ValaExpression* _tmp665_;
			_tmp663_ = dynamic_sig;
			_tmp664_ = vala_dynamic_signal_get_handler (_tmp663_);
			_tmp665_ = _tmp664_;
			_tmp661_ = _tmp665_ != NULL;
		} else {
			_tmp661_ = FALSE;
		}
		if (_tmp661_) {
			ValaDynamicSignal* _tmp666_;
			ValaDynamicSignal* _tmp667_;
			ValaExpression* _tmp668_;
			ValaExpression* _tmp669_;
			ValaDataType* _tmp670_;
			ValaDataType* _tmp671_;
			ValaDataType* _tmp672_;
			ValaDataType* _tmp673_;
			ValaDataType* _tmp674_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp691_;
			ValaExpression* _tmp692_;
			ValaExpression* _tmp693_;
			ValaDynamicSignal* _tmp694_;
			ValaDynamicSignal* _tmp695_;
			ValaSymbol* _tmp696_;
			ValaSymbol* _tmp697_;
			ValaObjectType* _tmp698_;
			ValaObjectType* _tmp699_;
			ValaDelegate* _tmp700_;
			ValaDelegate* _tmp701_;
			ValaDelegateType* _tmp702_;
			ValaDelegateType* _tmp703_;
			_tmp666_ = dynamic_sig;
			_tmp667_ = dynamic_sig;
			_tmp668_ = vala_dynamic_signal_get_handler (_tmp667_);
			_tmp669_ = _tmp668_;
			_tmp670_ = vala_expression_get_value_type (_tmp669_);
			_tmp671_ = _tmp670_;
			_tmp672_ = vala_data_type_get_return_type (_tmp671_);
			_tmp673_ = vala_data_type_copy (_tmp672_);
			_tmp674_ = _tmp673_;
			vala_callable_set_return_type ((ValaCallable*) _tmp666_, _tmp674_);
			_vala_code_node_unref0 (_tmp674_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp675_;
				ValaExpression* _tmp676_;
				ValaExpression* _tmp677_;
				ValaDataType* _tmp678_;
				ValaDataType* _tmp679_;
				ValaList* _tmp680_;
				ValaList* _tmp681_;
				gint _param_size = 0;
				ValaList* _tmp682_;
				gint _tmp683_;
				gint _tmp684_;
				gint _param_index = 0;
				_tmp675_ = dynamic_sig;
				_tmp676_ = vala_dynamic_signal_get_handler (_tmp675_);
				_tmp677_ = _tmp676_;
				_tmp678_ = vala_expression_get_value_type (_tmp677_);
				_tmp679_ = _tmp678_;
				_tmp680_ = vala_data_type_get_parameters (_tmp679_);
				_tmp681_ = _vala_iterable_ref0 (_tmp680_);
				_param_list = _tmp681_;
				_tmp682_ = _param_list;
				_tmp683_ = vala_collection_get_size ((ValaCollection*) _tmp682_);
				_tmp684_ = _tmp683_;
				_param_size = _tmp684_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp685_;
					gpointer _tmp686_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp685_ = _param_list;
					_tmp686_ = vala_list_get (_tmp685_, _param_index);
					param = (ValaParameter*) _tmp686_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp687_;
						ValaParameter* _tmp688_;
						ValaParameter* _tmp689_;
						ValaParameter* _tmp690_;
						_tmp687_ = dynamic_sig;
						_tmp688_ = param;
						_tmp689_ = vala_parameter_copy (_tmp688_);
						_tmp690_ = _tmp689_;
						vala_callable_add_parameter ((ValaCallable*) _tmp687_, _tmp690_);
						_vala_code_node_unref0 (_tmp690_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp691_ = dynamic_sig;
			_tmp692_ = vala_dynamic_signal_get_handler (_tmp691_);
			_tmp693_ = _tmp692_;
			_tmp694_ = dynamic_sig;
			_tmp695_ = dynamic_sig;
			_tmp696_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp695_);
			_tmp697_ = _tmp696_;
			_tmp698_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp697_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp699_ = _tmp698_;
			_tmp700_ = vala_signal_get_delegate ((ValaSignal*) _tmp694_, (ValaDataType*) _tmp699_, (ValaCodeNode*) self);
			_tmp701_ = _tmp700_;
			_tmp702_ = vala_delegate_type_new (_tmp701_);
			_tmp703_ = _tmp702_;
			vala_expression_set_target_type (_tmp693_, (ValaDataType*) _tmp703_);
			_vala_code_node_unref0 (_tmp703_);
			_vala_code_node_unref0 (_tmp701_);
			_vala_code_node_unref0 (_tmp699_);
		}
		_tmp705_ = m;
		if (_tmp705_ != NULL) {
			ValaMethod* _tmp706_;
			_tmp706_ = m;
			_tmp704_ = vala_method_has_type_parameters (_tmp706_);
		} else {
			_tmp704_ = FALSE;
		}
		if (_tmp704_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp707_;
			ValaExpression* _tmp708_;
			ValaMemberAccess* _tmp709_;
			ValaList* _tmp710_;
			gint _tmp711_;
			gint _tmp712_;
			_tmp707_ = vala_method_call_get_call (self);
			_tmp708_ = _tmp707_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp708_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp709_ = ma;
			_tmp710_ = vala_member_access_get_type_arguments (_tmp709_);
			_tmp711_ = vala_collection_get_size ((ValaCollection*) _tmp710_);
			_tmp712_ = _tmp711_;
			if (_tmp712_ == 0) {
				ValaList* _tmp779_;
				ValaIterator* _tmp780_;
				ValaDataType* _tmp806_;
				ValaDataType* _tmp807_;
				ValaDataType* _tmp808_;
				ValaList* _tmp809_;
				ValaDataType* _tmp810_;
				ValaDataType* _tmp811_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp713_;
					ValaList* _tmp714_;
					ValaList* _tmp715_;
					gint _type_param_size = 0;
					ValaList* _tmp716_;
					gint _tmp717_;
					gint _tmp718_;
					gint _type_param_index = 0;
					_tmp713_ = m;
					_tmp714_ = vala_method_get_type_parameters (_tmp713_);
					_tmp715_ = _vala_iterable_ref0 (_tmp714_);
					_type_param_list = _tmp715_;
					_tmp716_ = _type_param_list;
					_tmp717_ = vala_collection_get_size ((ValaCollection*) _tmp716_);
					_tmp718_ = _tmp717_;
					_type_param_size = _tmp718_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp719_;
						gpointer _tmp720_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp721_;
						ValaIterator* _tmp722_;
						gboolean _tmp757_ = FALSE;
						ValaDataType* _tmp758_;
						ValaDataType* _tmp768_;
						ValaMemberAccess* _tmp777_;
						ValaDataType* _tmp778_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp719_ = _type_param_list;
						_tmp720_ = vala_list_get (_tmp719_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp720_;
						type_arg = NULL;
						_tmp721_ = self->priv->argument_list;
						_tmp722_ = vala_iterable_iterator ((ValaIterable*) _tmp721_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp722_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp723_;
							ValaList* _tmp724_;
							gint _param_size = 0;
							ValaList* _tmp725_;
							gint _tmp726_;
							gint _tmp727_;
							gint _param_index = 0;
							_tmp723_ = params;
							_tmp724_ = _vala_iterable_ref0 (_tmp723_);
							_param_list = _tmp724_;
							_tmp725_ = _param_list;
							_tmp726_ = vala_collection_get_size ((ValaCollection*) _tmp725_);
							_tmp727_ = _tmp726_;
							_param_size = _tmp727_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp728_;
								gpointer _tmp729_;
								gboolean _tmp730_ = FALSE;
								ValaParameter* _tmp731_;
								gboolean _tmp732_;
								gboolean _tmp733_;
								ValaIterator* _tmp737_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp728_ = _param_list;
								_tmp729_ = vala_list_get (_tmp728_, _param_index);
								param = (ValaParameter*) _tmp729_;
								_tmp731_ = param;
								_tmp732_ = vala_parameter_get_ellipsis (_tmp731_);
								_tmp733_ = _tmp732_;
								if (_tmp733_) {
									_tmp730_ = TRUE;
								} else {
									ValaParameter* _tmp734_;
									gboolean _tmp735_;
									gboolean _tmp736_;
									_tmp734_ = param;
									_tmp735_ = vala_parameter_get_params_array (_tmp734_);
									_tmp736_ = _tmp735_;
									_tmp730_ = _tmp736_;
								}
								if (_tmp730_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp737_ = arg_it;
								if (vala_iterator_next (_tmp737_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp738_;
									gpointer _tmp739_;
									ValaParameter* _tmp740_;
									ValaDataType* _tmp741_;
									ValaDataType* _tmp742_;
									ValaTypeParameter* _tmp743_;
									ValaExpression* _tmp744_;
									ValaDataType* _tmp745_;
									ValaDataType* _tmp746_;
									ValaDataType* _tmp747_;
									ValaDataType* _tmp748_;
									ValaExpression* _tmp749_;
									ValaExpression* _tmp750_;
									ValaDataType* _tmp751_;
									ValaDataType* _tmp752_;
									ValaDataType* _tmp753_;
									ValaList* _tmp754_;
									ValaDataType* _tmp755_;
									ValaDataType* _tmp756_;
									_tmp738_ = arg_it;
									_tmp739_ = vala_iterator_get (_tmp738_);
									arg = (ValaExpression*) _tmp739_;
									_tmp740_ = param;
									_tmp741_ = vala_variable_get_variable_type ((ValaVariable*) _tmp740_);
									_tmp742_ = _tmp741_;
									_tmp743_ = type_param;
									_tmp744_ = arg;
									_tmp745_ = vala_expression_get_value_type (_tmp744_);
									_tmp746_ = _tmp745_;
									_tmp747_ = vala_data_type_infer_type_argument (_tmp742_, _tmp743_, _tmp746_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp747_;
									_tmp748_ = type_arg;
									if (_tmp748_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp749_ = arg;
									_tmp750_ = arg;
									_tmp751_ = vala_expression_get_formal_target_type (_tmp750_);
									_tmp752_ = _tmp751_;
									_tmp753_ = target_object_type;
									_tmp754_ = method_type_args;
									_tmp755_ = vala_data_type_get_actual_type (_tmp752_, _tmp753_, _tmp754_, (ValaCodeNode*) self);
									_tmp756_ = _tmp755_;
									vala_expression_set_target_type (_tmp749_, _tmp756_);
									_vala_code_node_unref0 (_tmp756_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp758_ = type_arg;
						if (_tmp758_ == NULL) {
							ValaDataType* _tmp759_;
							ValaDataType* _tmp760_;
							_tmp759_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp760_ = _tmp759_;
							_tmp757_ = _tmp760_ != NULL;
						} else {
							_tmp757_ = FALSE;
						}
						if (_tmp757_) {
							ValaMethod* _tmp761_;
							ValaDataType* _tmp762_;
							ValaDataType* _tmp763_;
							ValaTypeParameter* _tmp764_;
							ValaDataType* _tmp765_;
							ValaDataType* _tmp766_;
							ValaDataType* _tmp767_;
							_tmp761_ = m;
							_tmp762_ = vala_callable_get_return_type ((ValaCallable*) _tmp761_);
							_tmp763_ = _tmp762_;
							_tmp764_ = type_param;
							_tmp765_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp766_ = _tmp765_;
							_tmp767_ = vala_data_type_infer_type_argument (_tmp763_, _tmp764_, _tmp766_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp767_;
						}
						_tmp768_ = type_arg;
						if (_tmp768_ == NULL) {
							ValaMemberAccess* _tmp769_;
							ValaSourceReference* _tmp770_;
							ValaSourceReference* _tmp771_;
							ValaTypeParameter* _tmp772_;
							gchar* _tmp773_;
							gchar* _tmp774_;
							gchar* _tmp775_;
							gchar* _tmp776_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp769_ = ma;
							_tmp770_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp769_);
							_tmp771_ = _tmp770_;
							_tmp772_ = type_param;
							_tmp773_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp772_);
							_tmp774_ = _tmp773_;
							_tmp775_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp774_);
							_tmp776_ = _tmp775_;
							vala_report_error (_tmp771_, _tmp776_);
							_g_free0 (_tmp776_);
							_g_free0 (_tmp774_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp777_ = ma;
						_tmp778_ = type_arg;
						vala_member_access_add_type_argument (_tmp777_, _tmp778_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp779_ = self->priv->argument_list;
				_tmp780_ = vala_iterable_iterator ((ValaIterable*) _tmp779_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp780_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp781_;
					ValaList* _tmp782_;
					gint _param_size = 0;
					ValaList* _tmp783_;
					gint _tmp784_;
					gint _tmp785_;
					gint _param_index = 0;
					_tmp781_ = params;
					_tmp782_ = _vala_iterable_ref0 (_tmp781_);
					_param_list = _tmp782_;
					_tmp783_ = _param_list;
					_tmp784_ = vala_collection_get_size ((ValaCollection*) _tmp783_);
					_tmp785_ = _tmp784_;
					_param_size = _tmp785_;
					_param_index = -1;
					while (TRUE) {
						ValaParameter* param = NULL;
						ValaList* _tmp786_;
						gpointer _tmp787_;
						gboolean _tmp788_ = FALSE;
						ValaParameter* _tmp789_;
						gboolean _tmp790_;
						gboolean _tmp791_;
						ValaIterator* _tmp795_;
						_param_index = _param_index + 1;
						if (!(_param_index < _param_size)) {
							break;
						}
						_tmp786_ = _param_list;
						_tmp787_ = vala_list_get (_tmp786_, _param_index);
						param = (ValaParameter*) _tmp787_;
						_tmp789_ = param;
						_tmp790_ = vala_parameter_get_ellipsis (_tmp789_);
						_tmp791_ = _tmp790_;
						if (_tmp791_) {
							_tmp788_ = TRUE;
						} else {
							ValaParameter* _tmp792_;
							gboolean _tmp793_;
							gboolean _tmp794_;
							_tmp792_ = param;
							_tmp793_ = vala_parameter_get_params_array (_tmp792_);
							_tmp794_ = _tmp793_;
							_tmp788_ = _tmp794_;
						}
						if (_tmp788_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp795_ = arg_it;
						if (vala_iterator_next (_tmp795_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp796_;
							gpointer _tmp797_;
							ValaExpression* _tmp798_;
							ValaExpression* _tmp799_;
							ValaDataType* _tmp800_;
							ValaDataType* _tmp801_;
							ValaDataType* _tmp802_;
							ValaList* _tmp803_;
							ValaDataType* _tmp804_;
							ValaDataType* _tmp805_;
							_tmp796_ = arg_it;
							_tmp797_ = vala_iterator_get (_tmp796_);
							arg = (ValaExpression*) _tmp797_;
							_tmp798_ = arg;
							_tmp799_ = arg;
							_tmp800_ = vala_expression_get_formal_target_type (_tmp799_);
							_tmp801_ = _tmp800_;
							_tmp802_ = target_object_type;
							_tmp803_ = method_type_args;
							_tmp804_ = vala_data_type_get_actual_type (_tmp801_, _tmp802_, _tmp803_, (ValaCodeNode*) self);
							_tmp805_ = _tmp804_;
							vala_expression_set_target_type (_tmp798_, _tmp805_);
							_vala_code_node_unref0 (_tmp805_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp806_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp807_ = _tmp806_;
				_tmp808_ = target_object_type;
				_tmp809_ = method_type_args;
				_tmp810_ = vala_data_type_get_actual_type (_tmp807_, _tmp808_, _tmp809_, (ValaCodeNode*) self);
				_tmp811_ = _tmp810_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp811_);
				_vala_code_node_unref0 (_tmp811_);
			}
		}
		_tmp813_ = m;
		if (_tmp813_ != NULL) {
			ValaMethod* _tmp814_;
			gboolean _tmp815_;
			gboolean _tmp816_;
			_tmp814_ = m;
			_tmp815_ = vala_method_get_coroutine (_tmp814_);
			_tmp816_ = _tmp815_;
			_tmp812_ = _tmp816_;
		} else {
			_tmp812_ = FALSE;
		}
		if (_tmp812_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp817_;
			ValaExpression* _tmp818_;
			ValaMemberAccess* _tmp819_;
			const gchar* _tmp820_;
			const gchar* _tmp821_;
			_tmp817_ = vala_method_call_get_call (self);
			_tmp818_ = _tmp817_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp818_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp819_ = ma;
			_tmp820_ = vala_member_access_get_member_name (_tmp819_);
			_tmp821_ = _tmp820_;
			if (g_strcmp0 (_tmp821_, "end") == 0) {
				ValaMethod* _tmp822_;
				ValaMethod* _tmp823_;
				ValaMethodType* _tmp824_;
				_tmp822_ = m;
				_tmp823_ = vala_method_get_end_method (_tmp822_);
				_tmp824_ = vala_method_type_new (_tmp823_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp824_;
			}
		}
	}
	_tmp825_ = vala_code_context_get_analyzer (context);
	_tmp826_ = _tmp825_;
	_tmp827_ = mtype;
	_tmp828_ = params;
	_tmp829_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp826_, (ValaExpression*) self, _tmp827_, _tmp828_, _tmp829_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp830_;
		ValaList* _tmp831_;
		gint _arg_size = 0;
		ValaList* _tmp832_;
		gint _tmp833_;
		gint _tmp834_;
		gint _arg_index = 0;
		_tmp830_ = self->priv->argument_list;
		_tmp831_ = _vala_iterable_ref0 (_tmp830_);
		_arg_list = _tmp831_;
		_tmp832_ = _arg_list;
		_tmp833_ = vala_collection_get_size ((ValaCollection*) _tmp832_);
		_tmp834_ = _tmp833_;
		_arg_size = _tmp834_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp835_;
			gpointer _tmp836_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp837_;
			gboolean _tmp838_ = FALSE;
			ValaSizeofExpression* _tmp839_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp835_ = _arg_list;
			_tmp836_ = vala_list_get (_tmp835_, _arg_index);
			arg = (ValaExpression*) _tmp836_;
			_tmp837_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp837_) ? ((ValaSizeofExpression*) _tmp837_) : NULL;
			_tmp839_ = sizeof_expr;
			if (_tmp839_ != NULL) {
				ValaSizeofExpression* _tmp840_;
				ValaDataType* _tmp841_;
				ValaDataType* _tmp842_;
				_tmp840_ = sizeof_expr;
				_tmp841_ = vala_sizeof_expression_get_type_reference (_tmp840_);
				_tmp842_ = _tmp841_;
				_tmp838_ = VALA_IS_GENERIC_TYPE (_tmp842_);
			} else {
				_tmp838_ = FALSE;
			}
			if (_tmp838_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp843_;
				ValaDataType* _tmp844_;
				ValaDataType* _tmp845_;
				ValaDataType* _tmp846_;
				ValaList* _tmp847_;
				ValaDataType* _tmp848_;
				ValaExpression* _tmp849_;
				ValaDataType* _tmp850_;
				ValaSourceReference* _tmp851_;
				ValaSourceReference* _tmp852_;
				ValaSizeofExpression* _tmp853_;
				ValaSizeofExpression* _tmp854_;
				_tmp843_ = sizeof_expr;
				_tmp844_ = vala_sizeof_expression_get_type_reference (_tmp843_);
				_tmp845_ = _tmp844_;
				_tmp846_ = target_object_type;
				_tmp847_ = method_type_args;
				_tmp848_ = vala_data_type_get_actual_type (_tmp845_, _tmp846_, _tmp847_, (ValaCodeNode*) self);
				sizeof_type = _tmp848_;
				_tmp849_ = arg;
				_tmp850_ = sizeof_type;
				_tmp851_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp852_ = _tmp851_;
				_tmp853_ = vala_sizeof_expression_new (_tmp850_, _tmp852_);
				_tmp854_ = _tmp853_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp849_, (ValaExpression*) _tmp854_);
				_vala_code_node_unref0 (_tmp854_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp857_ = base_cm;
	if (_tmp857_ != NULL) {
		ValaCreationMethod* _tmp858_;
		_tmp858_ = base_cm;
		_tmp856_ = vala_method_is_variadic ((ValaMethod*) _tmp858_);
	} else {
		_tmp856_ = FALSE;
	}
	if (_tmp856_) {
		ValaList* _tmp859_;
		gint _tmp860_;
		gint _tmp861_;
		ValaCreationMethod* _tmp862_;
		ValaList* _tmp863_;
		gint _tmp864_;
		gint _tmp865_;
		_tmp859_ = self->priv->argument_list;
		_tmp860_ = vala_collection_get_size ((ValaCollection*) _tmp859_);
		_tmp861_ = _tmp860_;
		_tmp862_ = base_cm;
		_tmp863_ = vala_callable_get_parameters ((ValaCallable*) _tmp862_);
		_tmp864_ = vala_collection_get_size ((ValaCollection*) _tmp863_);
		_tmp865_ = _tmp864_;
		_tmp855_ = _tmp861_ == _tmp865_;
	} else {
		_tmp855_ = FALSE;
	}
	if (_tmp855_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp866_;
		ValaList* _tmp867_;
		gint _tmp868_;
		gint _tmp869_;
		gpointer _tmp870_;
		gboolean _tmp871_ = FALSE;
		ValaExpression* _tmp872_;
		ValaDataType* _tmp873_;
		ValaDataType* _tmp874_;
		_tmp866_ = self->priv->argument_list;
		_tmp867_ = self->priv->argument_list;
		_tmp868_ = vala_collection_get_size ((ValaCollection*) _tmp867_);
		_tmp869_ = _tmp868_;
		_tmp870_ = vala_list_get (_tmp866_, _tmp869_ - 1);
		this_last_arg = (ValaExpression*) _tmp870_;
		_tmp872_ = this_last_arg;
		_tmp873_ = vala_expression_get_value_type (_tmp872_);
		_tmp874_ = _tmp873_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp874_)) {
			ValaExpression* _tmp875_;
			ValaDataType* _tmp876_;
			ValaDataType* _tmp877_;
			ValaTypeSymbol* _tmp878_;
			ValaTypeSymbol* _tmp879_;
			ValaSemanticAnalyzer* _tmp880_;
			ValaSemanticAnalyzer* _tmp881_;
			ValaDataType* _tmp882_;
			ValaTypeSymbol* _tmp883_;
			ValaTypeSymbol* _tmp884_;
			_tmp875_ = this_last_arg;
			_tmp876_ = vala_expression_get_value_type (_tmp875_);
			_tmp877_ = _tmp876_;
			_tmp878_ = vala_data_type_get_type_symbol (_tmp877_);
			_tmp879_ = _tmp878_;
			_tmp880_ = vala_code_context_get_analyzer (context);
			_tmp881_ = _tmp880_;
			_tmp882_ = _tmp881_->va_list_type;
			_tmp883_ = vala_data_type_get_type_symbol (_tmp882_);
			_tmp884_ = _tmp883_;
			_tmp871_ = _tmp879_ == _tmp884_;
		} else {
			_tmp871_ = FALSE;
		}
		if (_tmp871_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp885_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp886_ = _tmp885_;
	vala_code_node_check ((ValaCodeNode*) _tmp886_, context);
	_tmp887_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp888_ = _tmp887_;
	if (_tmp888_) {
		gboolean _tmp889_ = FALSE;
		ValaCodeNode* _tmp890_;
		ValaCodeNode* _tmp891_;
		_tmp890_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp891_ = _tmp890_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp891_)) {
			_tmp889_ = TRUE;
		} else {
			ValaCodeNode* _tmp892_;
			ValaCodeNode* _tmp893_;
			_tmp892_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp893_ = _tmp892_;
			_tmp889_ = VALA_IS_EXPRESSION_STATEMENT (_tmp893_);
		}
		if (_tmp889_) {
		} else {
			ValaSemanticAnalyzer* _tmp894_;
			ValaSemanticAnalyzer* _tmp895_;
			ValaSymbol* _tmp896_;
			ValaSymbol* _tmp897_;
			_tmp894_ = vala_code_context_get_analyzer (context);
			_tmp895_ = _tmp894_;
			_tmp896_ = vala_semantic_analyzer_get_current_symbol (_tmp895_);
			_tmp897_ = _tmp896_;
			if (!VALA_IS_BLOCK (_tmp897_)) {
				ValaSourceReference* _tmp898_;
				ValaSourceReference* _tmp899_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp898_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp899_ = _tmp898_;
				vala_report_error (_tmp899_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp900_;
				ValaCodeNode* _tmp901_;
				ValaCodeNode* _tmp902_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp903_;
				ValaDataType* _tmp904_;
				ValaDataType* _tmp905_;
				ValaDataType* _tmp906_;
				gchar* _tmp907_;
				gchar* _tmp908_;
				ValaSourceReference* _tmp909_;
				ValaSourceReference* _tmp910_;
				ValaLocalVariable* _tmp911_;
				ValaLocalVariable* _tmp912_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp913_;
				ValaSourceReference* _tmp914_;
				ValaSourceReference* _tmp915_;
				ValaDeclarationStatement* _tmp916_;
				ValaDataType* _tmp917_;
				ValaDataType* _tmp918_;
				ValaSemanticAnalyzer* _tmp922_;
				ValaSemanticAnalyzer* _tmp923_;
				ValaBlock* _tmp924_;
				ValaDeclarationStatement* _tmp925_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp926_;
				ValaDataType* _tmp927_;
				ValaDataType* _tmp928_;
				ValaExpression* _tmp929_;
				ValaExpression* _tmp930_;
				ValaDataType* _tmp931_;
				ValaDataType* _tmp932_;
				ValaLocalVariable* _tmp933_;
				ValaDeclarationStatement* _tmp934_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp935_;
				ValaSemanticAnalyzer* _tmp936_;
				ValaSymbol* _tmp937_;
				ValaSymbol* _tmp938_;
				ValaBlock* _tmp939_;
				ValaBlock* _tmp940_;
				ValaLocalVariable* _tmp941_;
				ValaSemanticAnalyzer* _tmp942_;
				ValaSemanticAnalyzer* _tmp943_;
				ValaBlock* _tmp944_;
				ValaLocalVariable* _tmp945_;
				ValaCodeNode* _tmp946_;
				ValaExpression* _tmp947_;
				ValaExpression* _tmp948_;
				_tmp900_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp901_ = _tmp900_;
				_tmp902_ = _vala_code_node_ref0 (_tmp901_);
				old_parent_node = _tmp902_;
				_tmp903_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp904_ = _tmp903_;
				_tmp905_ = vala_data_type_copy (_tmp904_);
				_tmp906_ = _tmp905_;
				_tmp907_ = vala_code_node_get_temp_name ();
				_tmp908_ = _tmp907_;
				_tmp909_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp910_ = _tmp909_;
				_tmp911_ = vala_local_variable_new (_tmp906_, _tmp908_, NULL, _tmp910_);
				_tmp912_ = _tmp911_;
				_g_free0 (_tmp908_);
				_vala_code_node_unref0 (_tmp906_);
				local = _tmp912_;
				_tmp913_ = local;
				_tmp914_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp915_ = _tmp914_;
				_tmp916_ = vala_declaration_statement_new ((ValaSymbol*) _tmp913_, _tmp915_);
				decl = _tmp916_;
				_tmp917_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp918_ = _tmp917_;
				if (_tmp918_ == NULL) {
					ValaLocalVariable* _tmp919_;
					ValaDataType* _tmp920_;
					ValaDataType* _tmp921_;
					_tmp919_ = local;
					_tmp920_ = vala_variable_get_variable_type ((ValaVariable*) _tmp919_);
					_tmp921_ = _tmp920_;
					vala_data_type_set_floating_reference (_tmp921_, FALSE);
				}
				_tmp922_ = vala_code_context_get_analyzer (context);
				_tmp923_ = _tmp922_;
				_tmp924_ = _tmp923_->insert_block;
				_tmp925_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp924_, (ValaStatement*) _tmp925_);
				_tmp926_ = local;
				_tmp927_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp928_ = _tmp927_;
				_tmp929_ = vala_semantic_analyzer_create_temp_access (_tmp926_, _tmp928_);
				temp_access = _tmp929_;
				_tmp930_ = temp_access;
				_tmp931_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp932_ = _tmp931_;
				vala_expression_set_formal_target_type (_tmp930_, _tmp932_);
				_tmp933_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp933_, (ValaExpression*) self);
				_tmp934_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp934_, context);
				_tmp935_ = vala_code_context_get_analyzer (context);
				_tmp936_ = _tmp935_;
				_tmp937_ = vala_semantic_analyzer_get_current_symbol (_tmp936_);
				_tmp938_ = _tmp937_;
				_tmp939_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp938_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp939_;
				_tmp940_ = block;
				_tmp941_ = local;
				vala_block_remove_local_variable (_tmp940_, _tmp941_);
				_tmp942_ = vala_code_context_get_analyzer (context);
				_tmp943_ = _tmp942_;
				_tmp944_ = _tmp943_->insert_block;
				_tmp945_ = local;
				vala_block_add_local_variable (_tmp944_, _tmp945_);
				_tmp946_ = old_parent_node;
				_tmp947_ = temp_access;
				vala_code_node_replace_expression (_tmp946_, (ValaExpression*) self, _tmp947_);
				_tmp948_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp948_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp949_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp950_ = _tmp949_;
	result = !_tmp950_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _expr_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_expr_list = _tmp18_;
		_tmp19_ = _expr_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_expr_size = _tmp21_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaExpression* _tmp24_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp22_ = _expr_list;
			_tmp23_ = vala_list_get (_tmp22_, _expr_index);
			expr = (ValaExpression*) _tmp23_;
			_tmp24_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp24_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			GString* _tmp18_;
			ValaExpression* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp15_ = _expr_list;
			_tmp16_ = vala_list_get (_tmp15_, _expr_index);
			expr = (ValaExpression*) _tmp16_;
			if (!first) {
				GString* _tmp17_;
				_tmp17_ = b;
				g_string_append (_tmp17_, ", ");
			}
			_tmp18_ = b;
			_tmp19_ = expr;
			_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			g_string_append (_tmp18_, _tmp21_);
			_g_free0 (_tmp21_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp22_ = b;
	g_string_append (_tmp22_, "))");
	_tmp23_ = b;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

