/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

void
vala_class_set_is_singleton (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_singleton);
	self->priv->_is_singleton = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SingleInstance", value, NULL);
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp23_ = _tmp28_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaLocalVariable* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		_tmp29_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp30_ = _tmp29_;
		if (_tmp30_ != NULL) {
			ValaScope* _tmp31_;
			ValaScope* _tmp32_;
			ValaLocalVariable* _tmp33_;
			ValaLocalVariable* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp31_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_scope_remove (_tmp32_, _tmp36_);
		}
		_tmp37_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_data_type_copy (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_local_variable_new (_tmp40_, "result", NULL, _tmp42_);
		_tmp44_ = _tmp43_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp44_);
		_vala_code_node_unref0 (_tmp44_);
		_vala_code_node_unref0 (_tmp40_);
		_tmp45_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp46_ = _tmp45_;
		vala_local_variable_set_is_result (_tmp46_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp49_ = FALSE;
		ValaCreationMethod* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp47_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp50_ = cm;
		_tmp51_ = vala_creation_method_get_class_name (_tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_ != NULL) {
			ValaCreationMethod* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			_tmp53_ = cm;
			_tmp54_ = vala_creation_method_get_class_name (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp57_ = _tmp56_;
			_tmp49_ = g_strcmp0 (_tmp55_, _tmp57_) != 0;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			ValaSourceReference* _tmp58_;
			ValaSourceReference* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			ValaCreationMethod* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = cm;
			_tmp63_ = vala_creation_method_get_class_name (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp61_, _tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp59_, _tmp66_);
			_g_free0 (_tmp66_);
			_g_free0 (_tmp61_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp14_;
	ValaField* _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_parameter_new ("this", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		vala_property_set_this_parameter (prop, _tmp5_);
		_vala_code_node_unref0 (_tmp5_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_property_get_this_parameter (prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_property_get_this_parameter (prop);
		_tmp13_ = _tmp12_;
		vala_scope_add (_tmp7_, _tmp11_, (ValaSymbol*) _tmp13_);
	}
	_tmp14_ = vala_property_get_field (prop);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaField* _tmp16_;
		ValaField* _tmp17_;
		_tmp16_ = vala_property_get_field (prop);
		_tmp17_ = _tmp16_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp17_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_constructor_set_this_parameter (c, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_constructor_get_this_parameter (c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_constructor_get_this_parameter (c);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_destructor_set_this_parameter (d, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_destructor_get_this_parameter (d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_destructor_get_this_parameter (d);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp8_;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp12_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp16_;
	ValaConstructor* _tmp17_;
	ValaDestructor* _tmp20_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp24_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp28_;
	ValaDestructor* _tmp29_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp8_ = vala_class_get_constructor (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaConstructor* _tmp10_;
		ValaConstructor* _tmp11_;
		_tmp10_ = vala_class_get_constructor (self);
		_tmp11_ = _tmp10_;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
	}
	_tmp12_ = vala_class_get_class_constructor (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaConstructor* _tmp14_;
		ValaConstructor* _tmp15_;
		_tmp14_ = vala_class_get_class_constructor (self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
	}
	_tmp16_ = vala_class_get_static_constructor (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaConstructor* _tmp18_;
		ValaConstructor* _tmp19_;
		_tmp18_ = vala_class_get_static_constructor (self);
		_tmp19_ = _tmp18_;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
	_tmp20_ = vala_class_get_destructor (self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		ValaDestructor* _tmp22_;
		ValaDestructor* _tmp23_;
		_tmp22_ = vala_class_get_destructor (self);
		_tmp23_ = _tmp22_;
		vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
	}
	_tmp24_ = vala_class_get_static_destructor (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		ValaDestructor* _tmp26_;
		ValaDestructor* _tmp27_;
		_tmp26_ = vala_class_get_static_destructor (self);
		_tmp27_ = _tmp26_;
		vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
	}
	_tmp28_ = vala_class_get_class_destructor (self);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		ValaDestructor* _tmp30_;
		ValaDestructor* _tmp31_;
		_tmp30_ = vala_class_get_class_destructor (self);
		_tmp31_ = _tmp30_;
		vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = base_type;
				_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_type_symbol (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp7_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prereq_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prereq_list = _tmp1_;
		_tmp2_ = _prereq_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prereq_size = _tmp4_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp5_ = _prereq_list;
			_tmp6_ = vala_list_get (_tmp5_, _prereq_index);
			prereq = (ValaDataType*) _tmp6_;
			_tmp7_ = prereq;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (_tmp9_);
			type = _tmp10_;
			_tmp11_ = type;
			if (_tmp11_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp12_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp12_);
			_tmp13_ = type;
			if (VALA_IS_INTERFACE (_tmp13_)) {
				ValaTypeSymbol* _tmp14_;
				_tmp14_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp7_ = base_type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (VALA_IS_CLASS (_tmp9_)) {
				ValaDataType* _tmp10_;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp10_ = base_type;
				_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
				_tmp12_ = _tmp11_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp7_ = base_type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaCreationMethod* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSourceFile* _tmp29_;
	ValaSourceFile* _tmp30_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	gboolean _tmp108_ = FALSE;
	ValaClass* _tmp109_;
	gboolean _tmp122_ = FALSE;
	gboolean _tmp123_;
	gboolean _tmp124_;
	gboolean _tmp134_ = FALSE;
	gboolean _tmp135_;
	gboolean _tmp136_;
	gboolean _tmp148_ = FALSE;
	ValaClass* _tmp149_;
	gboolean _tmp161_;
	ValaConstructor* _tmp258_;
	ValaConstructor* _tmp259_;
	ValaConstructor* _tmp262_;
	ValaConstructor* _tmp263_;
	ValaConstructor* _tmp266_;
	ValaConstructor* _tmp267_;
	ValaDestructor* _tmp270_;
	ValaDestructor* _tmp271_;
	ValaDestructor* _tmp274_;
	ValaDestructor* _tmp275_;
	ValaDestructor* _tmp278_;
	ValaDestructor* _tmp279_;
	gboolean _tmp314_;
	gboolean _tmp315_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp356_;
	ValaArrayList* _tmp357_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp372_;
	ValaArrayList* _tmp373_;
	ValaList* _tmp386_;
	gint _tmp387_;
	gint _tmp388_;
	ValaSourceFileType _tmp411_;
	ValaSourceFileType _tmp412_;
	ValaSemanticAnalyzer* _tmp633_;
	ValaSemanticAnalyzer* _tmp634_;
	ValaSourceFile* _tmp635_;
	ValaSemanticAnalyzer* _tmp636_;
	ValaSemanticAnalyzer* _tmp637_;
	ValaSymbol* _tmp638_;
	gboolean _tmp639_;
	gboolean _tmp640_;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_default_construction_method;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceFile* _tmp8_;
		ValaSourceFile* _tmp9_;
		ValaSourceFileType _tmp10_;
		ValaSourceFileType _tmp11_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_source_reference_get_file (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_source_file_get_file_type (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp4_ = _tmp11_ == VALA_SOURCE_FILE_TYPE_SOURCE;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaCreationMethod* m = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaCreationMethod* _tmp16_;
		ValaSymbolAccessibility _tmp17_ = 0;
		gboolean _tmp18_;
		ValaCreationMethod* _tmp19_;
		ValaCreationMethod* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaBlock* _tmp23_;
		ValaBlock* _tmp24_;
		ValaCreationMethod* _tmp25_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_creation_method_new (_tmp13_, NULL, _tmp15_, NULL);
		m = _tmp16_;
		_tmp18_ = self->priv->_is_abstract;
		if (_tmp18_) {
			_tmp17_ = VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
		} else {
			_tmp17_ = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		}
		_tmp19_ = m;
		vala_symbol_set_access ((ValaSymbol*) _tmp19_, _tmp17_);
		_tmp20_ = m;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_block_new (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp20_, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
		_tmp25_ = m;
		vala_symbol_add_method ((ValaSymbol*) self, (ValaMethod*) _tmp25_);
		_vala_code_node_unref0 (m);
	}
	_tmp26_ = vala_code_context_get_analyzer (context);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_semantic_analyzer_get_current_source_file (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _vala_source_file_ref0 (_tmp29_);
	old_source_file = _tmp30_;
	_tmp31_ = vala_code_context_get_analyzer (context);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_semantic_analyzer_get_current_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _vala_code_node_ref0 (_tmp34_);
	old_symbol = _tmp35_;
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaSemanticAnalyzer* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		_tmp38_ = vala_code_context_get_analyzer (context);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_source_reference_get_file (_tmp41_);
		_tmp43_ = _tmp42_;
		vala_semantic_analyzer_set_current_source_file (_tmp39_, _tmp43_);
	}
	_tmp44_ = vala_code_context_get_analyzer (context);
	_tmp45_ = _tmp44_;
	vala_semantic_analyzer_set_current_symbol (_tmp45_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _base_type_reference_index = 0;
		_tmp46_ = vala_class_get_base_types (self);
		_tmp47_ = _vala_iterable_ref0 (_tmp46_);
		_base_type_reference_list = _tmp47_;
		_tmp48_ = _base_type_reference_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_base_type_reference_size = _tmp50_;
		_base_type_reference_index = -1;
		while (TRUE) {
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp51_;
			gpointer _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			ValaSemanticAnalyzer* _tmp64_;
			ValaSemanticAnalyzer* _tmp65_;
			ValaDataType* _tmp66_;
			gint n_type_args = 0;
			ValaDataType* _tmp76_;
			ValaList* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			gint n_type_params = 0;
			ValaDataType* _tmp80_;
			ValaTypeSymbol* _tmp81_;
			ValaTypeSymbol* _tmp82_;
			ValaList* _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			_base_type_reference_index = _base_type_reference_index + 1;
			if (!(_base_type_reference_index < _base_type_reference_size)) {
				break;
			}
			_tmp51_ = _base_type_reference_list;
			_tmp52_ = vala_list_get (_tmp51_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp52_;
			_tmp53_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp53_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp54_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp54_)) {
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaDataType* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp56_ = _tmp55_;
				_tmp57_ = base_type_reference;
				_tmp58_ = vala_code_node_to_string ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strdup_printf ("base type `%s' of class `%s' is not an object type", _tmp59_, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_report_error (_tmp56_, _tmp63_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp61_);
				_g_free0 (_tmp59_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp64_ = vala_code_context_get_analyzer (context);
			_tmp65_ = _tmp64_;
			_tmp66_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp65_, (ValaSymbol*) self, _tmp66_)) {
				ValaSourceReference* _tmp67_;
				ValaSourceReference* _tmp68_;
				ValaDataType* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp68_ = _tmp67_;
				_tmp69_ = base_type_reference;
				_tmp70_ = vala_code_node_to_string ((ValaCodeNode*) _tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp73_ = _tmp72_;
				_tmp74_ = g_strdup_printf ("base type `%s' is less accessible than class `%s'", _tmp71_, _tmp73_);
				_tmp75_ = _tmp74_;
				vala_report_error (_tmp68_, _tmp75_);
				_g_free0 (_tmp75_);
				_g_free0 (_tmp73_);
				_g_free0 (_tmp71_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp76_ = base_type_reference;
			_tmp77_ = vala_data_type_get_type_arguments (_tmp76_);
			_tmp78_ = vala_collection_get_size ((ValaCollection*) _tmp77_);
			_tmp79_ = _tmp78_;
			n_type_args = _tmp79_;
			_tmp80_ = base_type_reference;
			_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
			_tmp85_ = _tmp84_;
			n_type_params = _tmp85_;
			if (n_type_args < n_type_params) {
				ValaDataType* _tmp86_;
				ValaSourceReference* _tmp87_;
				ValaSourceReference* _tmp88_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp86_ = base_type_reference;
				_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp86_);
				_tmp88_ = _tmp87_;
				vala_report_error (_tmp88_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					ValaDataType* _tmp89_;
					ValaSourceReference* _tmp90_;
					ValaSourceReference* _tmp91_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp89_ = base_type_reference;
					_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp89_);
					_tmp91_ = _tmp90_;
					vala_report_error (_tmp91_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp92_;
		ValaList* _tmp93_;
		gint _type_size = 0;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _type_index = 0;
		_tmp92_ = self->priv->base_types;
		_tmp93_ = _vala_iterable_ref0 (_tmp92_);
		_type_list = _tmp93_;
		_tmp94_ = _type_list;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		_type_size = _tmp96_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp97_;
			gpointer _tmp98_;
			ValaDataType* _tmp99_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp97_ = _type_list;
			_tmp98_ = vala_list_get (_tmp97_, _type_index);
			type = (ValaDataType*) _tmp98_;
			_tmp99_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp99_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp100_;
		ValaList* _tmp101_;
		gint _p_size = 0;
		ValaList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _p_index = 0;
		_tmp100_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_tmp101_ = _vala_iterable_ref0 (_tmp100_);
		_p_list = _tmp101_;
		_tmp102_ = _p_list;
		_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_p_size = _tmp104_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp105_;
			gpointer _tmp106_;
			ValaTypeParameter* _tmp107_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp105_ = _p_list;
			_tmp106_ = vala_list_get (_tmp105_, _p_index);
			p = (ValaTypeParameter*) _tmp106_;
			_tmp107_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp107_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp109_ = self->priv->_base_class;
	if (_tmp109_ != NULL) {
		ValaClass* _tmp110_;
		gboolean _tmp111_;
		gboolean _tmp112_;
		_tmp110_ = self->priv->_base_class;
		_tmp111_ = vala_class_get_is_singleton (_tmp110_);
		_tmp112_ = _tmp111_;
		_tmp108_ = _tmp112_;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		ValaClass* _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = self->priv->_base_class;
		_tmp118_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = g_strdup_printf ("`%s' cannot inherit from SingleInstance class `%s'", _tmp116_, _tmp119_);
		_tmp121_ = _tmp120_;
		vala_report_error (_tmp114_, _tmp121_);
		_g_free0 (_tmp121_);
		_g_free0 (_tmp119_);
		_g_free0 (_tmp116_);
	}
	_tmp123_ = vala_class_get_is_singleton (self);
	_tmp124_ = _tmp123_;
	if (_tmp124_) {
		ValaSemanticAnalyzer* _tmp125_;
		ValaSemanticAnalyzer* _tmp126_;
		ValaClass* _tmp127_;
		_tmp125_ = vala_code_context_get_analyzer (context);
		_tmp126_ = _tmp125_;
		_tmp127_ = _tmp126_->object_type;
		_tmp122_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp127_);
	} else {
		_tmp122_ = FALSE;
	}
	if (_tmp122_) {
		ValaSourceReference* _tmp128_;
		ValaSourceReference* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp129_ = _tmp128_;
		_tmp130_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = g_strdup_printf ("SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp131_);
		_tmp133_ = _tmp132_;
		vala_report_error (_tmp129_, _tmp133_);
		_g_free0 (_tmp133_);
		_g_free0 (_tmp131_);
	}
	_tmp135_ = vala_class_get_is_singleton (self);
	_tmp136_ = _tmp135_;
	if (_tmp136_) {
		ValaConstructor* _tmp137_;
		ValaConstructor* _tmp138_;
		_tmp137_ = vala_class_get_constructor (self);
		_tmp138_ = _tmp137_;
		_tmp134_ = _tmp138_ == NULL;
	} else {
		_tmp134_ = FALSE;
	}
	if (_tmp134_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp139_;
		ValaSourceReference* _tmp140_;
		ValaConstructor* _tmp141_;
		ValaConstructor* _tmp142_;
		ValaSourceReference* _tmp143_;
		ValaSourceReference* _tmp144_;
		ValaBlock* _tmp145_;
		ValaBlock* _tmp146_;
		ValaConstructor* _tmp147_;
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_constructor_new (_tmp140_);
		c = _tmp141_;
		_tmp142_ = c;
		_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp144_ = _tmp143_;
		_tmp145_ = vala_block_new (_tmp144_);
		_tmp146_ = _tmp145_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp142_, _tmp146_);
		_vala_code_node_unref0 (_tmp146_);
		_tmp147_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp147_);
		_vala_code_node_unref0 (c);
	}
	_tmp149_ = self->priv->_base_class;
	if (_tmp149_ != NULL) {
		ValaClass* _tmp150_;
		gboolean _tmp151_;
		_tmp150_ = self->priv->_base_class;
		_tmp151_ = _tmp150_->priv->_is_sealed;
		_tmp148_ = _tmp151_;
	} else {
		_tmp148_ = FALSE;
	}
	if (_tmp148_) {
		ValaSourceReference* _tmp152_;
		ValaSourceReference* _tmp153_;
		gchar* _tmp154_;
		gchar* _tmp155_;
		ValaClass* _tmp156_;
		gchar* _tmp157_;
		gchar* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp153_ = _tmp152_;
		_tmp154_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp155_ = _tmp154_;
		_tmp156_ = self->priv->_base_class;
		_tmp157_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = g_strdup_printf ("`%s' cannot inherit from sealed class `%s'", _tmp155_, _tmp158_);
		_tmp160_ = _tmp159_;
		vala_report_error (_tmp153_, _tmp160_);
		_g_free0 (_tmp160_);
		_g_free0 (_tmp158_);
		_g_free0 (_tmp155_);
	}
	_tmp161_ = self->priv->_is_sealed;
	if (_tmp161_) {
		gboolean _tmp162_;
		gboolean _tmp163_;
		gboolean _tmp170_;
		gboolean _tmp177_;
		gboolean _tmp178_;
		_tmp162_ = vala_class_get_is_compact (self);
		_tmp163_ = _tmp162_;
		if (_tmp163_) {
			ValaSourceReference* _tmp164_;
			ValaSourceReference* _tmp165_;
			gchar* _tmp166_;
			gchar* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp165_ = _tmp164_;
			_tmp166_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp167_ = _tmp166_;
			_tmp168_ = g_strdup_printf ("Sealed class `%s' cannot be compact", _tmp167_);
			_tmp169_ = _tmp168_;
			vala_report_error (_tmp165_, _tmp169_);
			_g_free0 (_tmp169_);
			_g_free0 (_tmp167_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp170_ = self->priv->_is_abstract;
		if (_tmp170_) {
			ValaSourceReference* _tmp171_;
			ValaSourceReference* _tmp172_;
			gchar* _tmp173_;
			gchar* _tmp174_;
			gchar* _tmp175_;
			gchar* _tmp176_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp174_ = _tmp173_;
			_tmp175_ = g_strdup_printf ("Sealed class `%s' cannot be abstract", _tmp174_);
			_tmp176_ = _tmp175_;
			vala_report_error (_tmp172_, _tmp176_);
			_g_free0 (_tmp176_);
			_g_free0 (_tmp174_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp177_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp178_ = _tmp177_;
		if (!_tmp178_) {
			ValaSourceReference* _tmp179_;
			ValaSourceReference* _tmp180_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp180_ = _tmp179_;
			vala_report_error (_tmp180_, "Sealed classes are not fully supported yet");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp181_;
		ValaList* _tmp182_;
		gint _en_size = 0;
		ValaList* _tmp183_;
		gint _tmp184_;
		gint _tmp185_;
		gint _en_index = 0;
		_tmp181_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_tmp182_ = _vala_iterable_ref0 (_tmp181_);
		_en_list = _tmp182_;
		_tmp183_ = _en_list;
		_tmp184_ = vala_collection_get_size ((ValaCollection*) _tmp183_);
		_tmp185_ = _tmp184_;
		_en_size = _tmp185_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp186_;
			gpointer _tmp187_;
			ValaEnum* _tmp188_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp186_ = _en_list;
			_tmp187_ = vala_list_get (_tmp186_, _en_index);
			en = (ValaEnum*) _tmp187_;
			_tmp188_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp188_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp189_;
		ValaList* _tmp190_;
		gint _f_size = 0;
		ValaList* _tmp191_;
		gint _tmp192_;
		gint _tmp193_;
		gint _f_index = 0;
		_tmp189_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_tmp190_ = _vala_iterable_ref0 (_tmp189_);
		_f_list = _tmp190_;
		_tmp191_ = _f_list;
		_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
		_tmp193_ = _tmp192_;
		_f_size = _tmp193_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp194_;
			gpointer _tmp195_;
			gboolean _tmp196_ = FALSE;
			gboolean _tmp197_;
			gboolean _tmp198_;
			ValaField* _tmp216_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp194_ = _f_list;
			_tmp195_ = vala_list_get (_tmp194_, _f_index);
			f = (ValaField*) _tmp195_;
			_tmp197_ = vala_class_get_is_compact (self);
			_tmp198_ = _tmp197_;
			if (_tmp198_) {
				ValaField* _tmp199_;
				ValaMemberBinding _tmp200_;
				ValaMemberBinding _tmp201_;
				_tmp199_ = f;
				_tmp200_ = vala_field_get_binding (_tmp199_);
				_tmp201_ = _tmp200_;
				_tmp196_ = _tmp201_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp196_ = FALSE;
			}
			if (_tmp196_) {
				gboolean _tmp202_ = FALSE;
				gboolean _tmp203_;
				gboolean _tmp204_;
				ValaField* _tmp210_;
				ValaMemberBinding _tmp211_;
				ValaMemberBinding _tmp212_;
				_tmp203_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp204_ = _tmp203_;
				if (!_tmp204_) {
					ValaField* _tmp205_;
					ValaSymbolAccessibility _tmp206_;
					ValaSymbolAccessibility _tmp207_;
					_tmp205_ = f;
					_tmp206_ = vala_symbol_get_access ((ValaSymbol*) _tmp205_);
					_tmp207_ = _tmp206_;
					_tmp202_ = _tmp207_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp202_ = FALSE;
				}
				if (_tmp202_) {
					ValaSourceReference* _tmp208_;
					ValaSourceReference* _tmp209_;
					_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp209_ = _tmp208_;
					vala_report_error (_tmp209_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp210_ = f;
				_tmp211_ = vala_field_get_binding (_tmp210_);
				_tmp212_ = _tmp211_;
				if (_tmp212_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					_tmp213_ = f;
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp213_);
					_tmp215_ = _tmp214_;
					vala_report_error (_tmp215_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp216_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp216_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp217_;
		ValaList* _tmp218_;
		gint _c_size = 0;
		ValaList* _tmp219_;
		gint _tmp220_;
		gint _tmp221_;
		gint _c_index = 0;
		_tmp217_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_tmp218_ = _vala_iterable_ref0 (_tmp217_);
		_c_list = _tmp218_;
		_tmp219_ = _c_list;
		_tmp220_ = vala_collection_get_size ((ValaCollection*) _tmp219_);
		_tmp221_ = _tmp220_;
		_c_size = _tmp221_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp222_;
			gpointer _tmp223_;
			ValaConstant* _tmp224_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp222_ = _c_list;
			_tmp223_ = vala_list_get (_tmp222_, _c_index);
			c = (ValaConstant*) _tmp223_;
			_tmp224_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp224_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp225_;
		ValaList* _tmp226_;
		gint _m_size = 0;
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _m_index = 0;
		_tmp225_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_tmp226_ = _vala_iterable_ref0 (_tmp225_);
		_m_list = _tmp226_;
		_tmp227_ = _m_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_m_size = _tmp229_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp230_;
			gpointer _tmp231_;
			ValaMethod* _tmp232_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp230_ = _m_list;
			_tmp231_ = vala_list_get (_tmp230_, _m_index);
			m = (ValaMethod*) _tmp231_;
			_tmp232_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp232_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp233_;
		ValaList* _tmp234_;
		gint _prop_size = 0;
		ValaList* _tmp235_;
		gint _tmp236_;
		gint _tmp237_;
		gint _prop_index = 0;
		_tmp233_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_tmp234_ = _vala_iterable_ref0 (_tmp233_);
		_prop_list = _tmp234_;
		_tmp235_ = _prop_list;
		_tmp236_ = vala_collection_get_size ((ValaCollection*) _tmp235_);
		_tmp237_ = _tmp236_;
		_prop_size = _tmp237_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp238_;
			gpointer _tmp239_;
			gboolean _tmp240_ = FALSE;
			ValaProperty* _tmp241_;
			ValaAttribute* _tmp242_;
			ValaProperty* _tmp249_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp238_ = _prop_list;
			_tmp239_ = vala_list_get (_tmp238_, _prop_index);
			prop = (ValaProperty*) _tmp239_;
			_tmp241_ = prop;
			_tmp242_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp241_, "NoAccessorMethod");
			if (_tmp242_ != NULL) {
				ValaSemanticAnalyzer* _tmp243_;
				ValaSemanticAnalyzer* _tmp244_;
				ValaClass* _tmp245_;
				_tmp243_ = vala_code_context_get_analyzer (context);
				_tmp244_ = _tmp243_;
				_tmp245_ = _tmp244_->object_type;
				_tmp240_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp245_);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaProperty* _tmp246_;
				ValaSourceReference* _tmp247_;
				ValaSourceReference* _tmp248_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp246_ = prop;
				_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp246_);
				_tmp248_ = _tmp247_;
				vala_report_error (_tmp248_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp249_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp250_;
		ValaList* _tmp251_;
		gint _sig_size = 0;
		ValaList* _tmp252_;
		gint _tmp253_;
		gint _tmp254_;
		gint _sig_index = 0;
		_tmp250_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_tmp251_ = _vala_iterable_ref0 (_tmp250_);
		_sig_list = _tmp251_;
		_tmp252_ = _sig_list;
		_tmp253_ = vala_collection_get_size ((ValaCollection*) _tmp252_);
		_tmp254_ = _tmp253_;
		_sig_size = _tmp254_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp255_;
			gpointer _tmp256_;
			ValaSignal* _tmp257_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp255_ = _sig_list;
			_tmp256_ = vala_list_get (_tmp255_, _sig_index);
			sig = (ValaSignal*) _tmp256_;
			_tmp257_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp257_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp258_ = vala_class_get_constructor (self);
	_tmp259_ = _tmp258_;
	if (_tmp259_ != NULL) {
		ValaConstructor* _tmp260_;
		ValaConstructor* _tmp261_;
		_tmp260_ = vala_class_get_constructor (self);
		_tmp261_ = _tmp260_;
		vala_code_node_check ((ValaCodeNode*) _tmp261_, context);
	}
	_tmp262_ = vala_class_get_class_constructor (self);
	_tmp263_ = _tmp262_;
	if (_tmp263_ != NULL) {
		ValaConstructor* _tmp264_;
		ValaConstructor* _tmp265_;
		_tmp264_ = vala_class_get_class_constructor (self);
		_tmp265_ = _tmp264_;
		vala_code_node_check ((ValaCodeNode*) _tmp265_, context);
	}
	_tmp266_ = vala_class_get_static_constructor (self);
	_tmp267_ = _tmp266_;
	if (_tmp267_ != NULL) {
		ValaConstructor* _tmp268_;
		ValaConstructor* _tmp269_;
		_tmp268_ = vala_class_get_static_constructor (self);
		_tmp269_ = _tmp268_;
		vala_code_node_check ((ValaCodeNode*) _tmp269_, context);
	}
	_tmp270_ = vala_class_get_destructor (self);
	_tmp271_ = _tmp270_;
	if (_tmp271_ != NULL) {
		ValaDestructor* _tmp272_;
		ValaDestructor* _tmp273_;
		_tmp272_ = vala_class_get_destructor (self);
		_tmp273_ = _tmp272_;
		vala_code_node_check ((ValaCodeNode*) _tmp273_, context);
	}
	_tmp274_ = vala_class_get_static_destructor (self);
	_tmp275_ = _tmp274_;
	if (_tmp275_ != NULL) {
		ValaDestructor* _tmp276_;
		ValaDestructor* _tmp277_;
		_tmp276_ = vala_class_get_static_destructor (self);
		_tmp277_ = _tmp276_;
		vala_code_node_check ((ValaCodeNode*) _tmp277_, context);
	}
	_tmp278_ = vala_class_get_class_destructor (self);
	_tmp279_ = _tmp278_;
	if (_tmp279_ != NULL) {
		ValaDestructor* _tmp280_;
		ValaDestructor* _tmp281_;
		_tmp280_ = vala_class_get_class_destructor (self);
		_tmp281_ = _tmp280_;
		vala_code_node_check ((ValaCodeNode*) _tmp281_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp282_;
		ValaList* _tmp283_;
		gint _cl_size = 0;
		ValaList* _tmp284_;
		gint _tmp285_;
		gint _tmp286_;
		gint _cl_index = 0;
		_tmp282_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_tmp283_ = _vala_iterable_ref0 (_tmp282_);
		_cl_list = _tmp283_;
		_tmp284_ = _cl_list;
		_tmp285_ = vala_collection_get_size ((ValaCollection*) _tmp284_);
		_tmp286_ = _tmp285_;
		_cl_size = _tmp286_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp287_;
			gpointer _tmp288_;
			ValaClass* _tmp289_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp287_ = _cl_list;
			_tmp288_ = vala_list_get (_tmp287_, _cl_index);
			cl = (ValaClass*) _tmp288_;
			_tmp289_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp289_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp290_;
		ValaList* _tmp291_;
		gint _iface_size = 0;
		ValaList* _tmp292_;
		gint _tmp293_;
		gint _tmp294_;
		gint _iface_index = 0;
		_tmp290_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_tmp291_ = _vala_iterable_ref0 (_tmp290_);
		_iface_list = _tmp291_;
		_tmp292_ = _iface_list;
		_tmp293_ = vala_collection_get_size ((ValaCollection*) _tmp292_);
		_tmp294_ = _tmp293_;
		_iface_size = _tmp294_;
		_iface_index = -1;
		while (TRUE) {
			ValaInterface* iface = NULL;
			ValaList* _tmp295_;
			gpointer _tmp296_;
			ValaInterface* _tmp297_;
			_iface_index = _iface_index + 1;
			if (!(_iface_index < _iface_size)) {
				break;
			}
			_tmp295_ = _iface_list;
			_tmp296_ = vala_list_get (_tmp295_, _iface_index);
			iface = (ValaInterface*) _tmp296_;
			_tmp297_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp297_, context);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp298_;
		ValaList* _tmp299_;
		gint _st_size = 0;
		ValaList* _tmp300_;
		gint _tmp301_;
		gint _tmp302_;
		gint _st_index = 0;
		_tmp298_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_tmp299_ = _vala_iterable_ref0 (_tmp298_);
		_st_list = _tmp299_;
		_tmp300_ = _st_list;
		_tmp301_ = vala_collection_get_size ((ValaCollection*) _tmp300_);
		_tmp302_ = _tmp301_;
		_st_size = _tmp302_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp303_;
			gpointer _tmp304_;
			ValaStruct* _tmp305_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp303_ = _st_list;
			_tmp304_ = vala_list_get (_tmp303_, _st_index);
			st = (ValaStruct*) _tmp304_;
			_tmp305_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp305_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp306_;
		ValaList* _tmp307_;
		gint _d_size = 0;
		ValaList* _tmp308_;
		gint _tmp309_;
		gint _tmp310_;
		gint _d_index = 0;
		_tmp306_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_tmp307_ = _vala_iterable_ref0 (_tmp306_);
		_d_list = _tmp307_;
		_tmp308_ = _d_list;
		_tmp309_ = vala_collection_get_size ((ValaCollection*) _tmp308_);
		_tmp310_ = _tmp309_;
		_d_size = _tmp310_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp311_;
			gpointer _tmp312_;
			ValaDelegate* _tmp313_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp311_ = _d_list;
			_tmp312_ = vala_list_get (_tmp311_, _d_index);
			d = (ValaDelegate*) _tmp312_;
			_tmp313_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp313_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp314_ = vala_class_get_is_compact (self);
	_tmp315_ = _tmp314_;
	if (_tmp315_) {
		gboolean _tmp332_ = FALSE;
		gboolean _tmp333_ = FALSE;
		gboolean _tmp334_ = FALSE;
		gboolean _tmp335_;
		gboolean _tmp336_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp316_;
			ValaList* _tmp317_;
			gint _base_type_size = 0;
			ValaList* _tmp318_;
			gint _tmp319_;
			gint _tmp320_;
			gint _base_type_index = 0;
			_tmp316_ = vala_class_get_base_types (self);
			_tmp317_ = _vala_iterable_ref0 (_tmp316_);
			_base_type_list = _tmp317_;
			_tmp318_ = _base_type_list;
			_tmp319_ = vala_collection_get_size ((ValaCollection*) _tmp318_);
			_tmp320_ = _tmp319_;
			_base_type_size = _tmp320_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp321_;
				gpointer _tmp322_;
				ValaDataType* _tmp323_;
				ValaTypeSymbol* _tmp324_;
				ValaTypeSymbol* _tmp325_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp321_ = _base_type_list;
				_tmp322_ = vala_list_get (_tmp321_, _base_type_index);
				base_type = (ValaDataType*) _tmp322_;
				_tmp323_ = base_type;
				_tmp324_ = vala_data_type_get_type_symbol (_tmp323_);
				_tmp325_ = _tmp324_;
				if (VALA_IS_INTERFACE (_tmp325_)) {
					ValaSourceReference* _tmp326_;
					ValaSourceReference* _tmp327_;
					gchar* _tmp328_;
					gchar* _tmp329_;
					gchar* _tmp330_;
					gchar* _tmp331_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp327_ = _tmp326_;
					_tmp328_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp329_ = _tmp328_;
					_tmp330_ = g_strdup_printf ("compact classes `%s' may not implement interfaces", _tmp329_);
					_tmp331_ = _tmp330_;
					vala_report_error (_tmp327_, _tmp331_);
					_g_free0 (_tmp331_);
					_g_free0 (_tmp329_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp335_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp336_ = _tmp335_;
		if (!_tmp336_) {
			gboolean _tmp337_;
			gboolean _tmp338_;
			_tmp337_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp338_ = _tmp337_;
			_tmp334_ = !_tmp338_;
		} else {
			_tmp334_ = FALSE;
		}
		if (_tmp334_) {
			ValaClass* _tmp339_;
			_tmp339_ = self->priv->_base_class;
			_tmp333_ = _tmp339_ != NULL;
		} else {
			_tmp333_ = FALSE;
		}
		if (_tmp333_) {
			ValaClass* _tmp340_;
			ValaSemanticAnalyzer* _tmp341_;
			ValaSemanticAnalyzer* _tmp342_;
			ValaClass* _tmp343_;
			_tmp340_ = self->priv->_base_class;
			_tmp341_ = vala_code_context_get_analyzer (context);
			_tmp342_ = _tmp341_;
			_tmp343_ = _tmp342_->gsource_type;
			_tmp332_ = _tmp340_ != _tmp343_;
		} else {
			_tmp332_ = FALSE;
		}
		if (_tmp332_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp344_;
				ValaList* _tmp345_;
				gint _f_size = 0;
				ValaList* _tmp346_;
				gint _tmp347_;
				gint _tmp348_;
				gint _f_index = 0;
				_tmp344_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_tmp345_ = _vala_iterable_ref0 (_tmp344_);
				_f_list = _tmp345_;
				_tmp346_ = _f_list;
				_tmp347_ = vala_collection_get_size ((ValaCollection*) _tmp346_);
				_tmp348_ = _tmp347_;
				_f_size = _tmp348_;
				_f_index = -1;
				while (TRUE) {
					ValaField* f = NULL;
					ValaList* _tmp349_;
					gpointer _tmp350_;
					ValaField* _tmp351_;
					ValaMemberBinding _tmp352_;
					ValaMemberBinding _tmp353_;
					_f_index = _f_index + 1;
					if (!(_f_index < _f_size)) {
						break;
					}
					_tmp349_ = _f_list;
					_tmp350_ = vala_list_get (_tmp349_, _f_index);
					f = (ValaField*) _tmp350_;
					_tmp351_ = f;
					_tmp352_ = vala_field_get_binding (_tmp351_);
					_tmp353_ = _tmp352_;
					if (_tmp353_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp354_;
						ValaSourceReference* _tmp355_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp354_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp355_ = _tmp354_;
						vala_report_error (_tmp355_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp356_ = g_direct_equal;
	_tmp357_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp356_);
	prerequisites = (ValaList*) _tmp357_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp358_;
		ValaList* _tmp359_;
		gint _base_type_size = 0;
		ValaList* _tmp360_;
		gint _tmp361_;
		gint _tmp362_;
		gint _base_type_index = 0;
		_tmp358_ = vala_class_get_base_types (self);
		_tmp359_ = _vala_iterable_ref0 (_tmp358_);
		_base_type_list = _tmp359_;
		_tmp360_ = _base_type_list;
		_tmp361_ = vala_collection_get_size ((ValaCollection*) _tmp360_);
		_tmp362_ = _tmp361_;
		_base_type_size = _tmp362_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp363_;
			gpointer _tmp364_;
			ValaDataType* _tmp365_;
			ValaTypeSymbol* _tmp366_;
			ValaTypeSymbol* _tmp367_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp363_ = _base_type_list;
			_tmp364_ = vala_list_get (_tmp363_, _base_type_index);
			base_type = (ValaDataType*) _tmp364_;
			_tmp365_ = base_type;
			_tmp366_ = vala_data_type_get_type_symbol (_tmp365_);
			_tmp367_ = _tmp366_;
			if (VALA_IS_INTERFACE (_tmp367_)) {
				ValaDataType* _tmp368_;
				ValaTypeSymbol* _tmp369_;
				ValaTypeSymbol* _tmp370_;
				ValaList* _tmp371_;
				_tmp368_ = base_type;
				_tmp369_ = vala_data_type_get_type_symbol (_tmp368_);
				_tmp370_ = _tmp369_;
				_tmp371_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp370_, VALA_TYPE_INTERFACE, ValaInterface), _tmp371_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp372_ = g_direct_equal;
	_tmp373_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp372_);
	missing_prereqs = (ValaList*) _tmp373_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp374_;
		ValaList* _tmp375_;
		gint _prereq_size = 0;
		ValaList* _tmp376_;
		gint _tmp377_;
		gint _tmp378_;
		gint _prereq_index = 0;
		_tmp374_ = prerequisites;
		_tmp375_ = _vala_iterable_ref0 (_tmp374_);
		_prereq_list = _tmp375_;
		_tmp376_ = _prereq_list;
		_tmp377_ = vala_collection_get_size ((ValaCollection*) _tmp376_);
		_tmp378_ = _tmp377_;
		_prereq_size = _tmp378_;
		_prereq_index = -1;
		while (TRUE) {
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp379_;
			gpointer _tmp380_;
			ValaTypeSymbol* _tmp381_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp379_ = _prereq_list;
			_tmp380_ = vala_list_get (_tmp379_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp380_;
			_tmp381_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp381_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp382_;
				ValaTypeSymbol* _tmp383_;
				gchar* _tmp384_;
				gchar* _tmp385_;
				_tmp382_ = missing_prereqs;
				_tmp383_ = prereq;
				_tmp384_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp383_);
				_tmp385_ = _tmp384_;
				vala_list_insert (_tmp382_, 0, _tmp385_);
				_g_free0 (_tmp385_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp386_ = missing_prereqs;
	_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
	_tmp388_ = _tmp387_;
	if (_tmp388_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp389_;
		gchar* _tmp390_;
		gchar* _tmp391_;
		gchar* _tmp392_;
		gboolean first = FALSE;
		const gchar* _tmp406_;
		gchar* _tmp407_;
		ValaSourceReference* _tmp408_;
		ValaSourceReference* _tmp409_;
		const gchar* _tmp410_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp389_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp390_ = _tmp389_;
		_tmp391_ = g_strdup_printf ("%s: some prerequisites (", _tmp390_);
		_tmp392_ = _tmp391_;
		_g_free0 (_tmp390_);
		error_string = _tmp392_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp393_;
			ValaList* _tmp394_;
			gint _s_size = 0;
			ValaList* _tmp395_;
			gint _tmp396_;
			gint _tmp397_;
			gint _s_index = 0;
			_tmp393_ = missing_prereqs;
			_tmp394_ = _vala_iterable_ref0 (_tmp393_);
			_s_list = _tmp394_;
			_tmp395_ = _s_list;
			_tmp396_ = vala_collection_get_size ((ValaCollection*) _tmp395_);
			_tmp397_ = _tmp396_;
			_s_size = _tmp397_;
			_s_index = -1;
			while (TRUE) {
				gchar* s = NULL;
				ValaList* _tmp398_;
				gpointer _tmp399_;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp398_ = _s_list;
				_tmp399_ = vala_list_get (_tmp398_, _s_index);
				s = (gchar*) _tmp399_;
				if (first) {
					const gchar* _tmp400_;
					const gchar* _tmp401_;
					gchar* _tmp402_;
					_tmp400_ = error_string;
					_tmp401_ = s;
					_tmp402_ = g_strdup_printf ("%s`%s'", _tmp400_, _tmp401_);
					_g_free0 (error_string);
					error_string = _tmp402_;
					first = FALSE;
				} else {
					const gchar* _tmp403_;
					const gchar* _tmp404_;
					gchar* _tmp405_;
					_tmp403_ = error_string;
					_tmp404_ = s;
					_tmp405_ = g_strdup_printf ("%s, `%s'", _tmp403_, _tmp404_);
					_g_free0 (error_string);
					error_string = _tmp405_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp406_ = error_string;
		_tmp407_ = g_strconcat (_tmp406_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp407_;
		_tmp408_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp409_ = _tmp408_;
		_tmp410_ = error_string;
		vala_report_error (_tmp409_, _tmp410_);
		_g_free0 (error_string);
	}
	_tmp411_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp412_ = _tmp411_;
	if (_tmp412_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp565_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp413_;
			ValaList* _tmp414_;
			gint _base_type_size = 0;
			ValaList* _tmp415_;
			gint _tmp416_;
			gint _tmp417_;
			gint _base_type_index = 0;
			_tmp413_ = vala_class_get_base_types (self);
			_tmp414_ = _vala_iterable_ref0 (_tmp413_);
			_base_type_list = _tmp414_;
			_tmp415_ = _base_type_list;
			_tmp416_ = vala_collection_get_size ((ValaCollection*) _tmp415_);
			_tmp417_ = _tmp416_;
			_base_type_size = _tmp417_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp418_;
				gpointer _tmp419_;
				ValaDataType* _tmp420_;
				ValaTypeSymbol* _tmp421_;
				ValaTypeSymbol* _tmp422_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp418_ = _base_type_list;
				_tmp419_ = vala_list_get (_tmp418_, _base_type_index);
				base_type = (ValaDataType*) _tmp419_;
				_tmp420_ = base_type;
				_tmp421_ = vala_data_type_get_type_symbol (_tmp420_);
				_tmp422_ = _tmp421_;
				if (VALA_IS_INTERFACE (_tmp422_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp423_;
					ValaTypeSymbol* _tmp424_;
					ValaTypeSymbol* _tmp425_;
					gboolean _tmp426_ = FALSE;
					ValaClass* _tmp427_;
					_tmp423_ = base_type;
					_tmp424_ = vala_data_type_get_type_symbol (_tmp423_);
					_tmp425_ = _tmp424_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp425_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp427_ = self->priv->_base_class;
					if (_tmp427_ != NULL) {
						ValaClass* _tmp428_;
						ValaInterface* _tmp429_;
						_tmp428_ = self->priv->_base_class;
						_tmp429_ = iface;
						_tmp426_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp428_, (ValaTypeSymbol*) _tmp429_);
					} else {
						_tmp426_ = FALSE;
					}
					if (_tmp426_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp430_;
						ValaList* _tmp431_;
						ValaList* _tmp432_;
						gint _m_size = 0;
						ValaList* _tmp433_;
						gint _tmp434_;
						gint _tmp435_;
						gint _m_index = 0;
						_tmp430_ = iface;
						_tmp431_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp430_);
						_tmp432_ = _vala_iterable_ref0 (_tmp431_);
						_m_list = _tmp432_;
						_tmp433_ = _m_list;
						_tmp434_ = vala_collection_get_size ((ValaCollection*) _tmp433_);
						_tmp435_ = _tmp434_;
						_m_size = _tmp435_;
						_m_index = -1;
						while (TRUE) {
							ValaMethod* m = NULL;
							ValaList* _tmp436_;
							gpointer _tmp437_;
							ValaMethod* _tmp438_;
							gboolean _tmp439_;
							gboolean _tmp440_;
							_m_index = _m_index + 1;
							if (!(_m_index < _m_size)) {
								break;
							}
							_tmp436_ = _m_list;
							_tmp437_ = vala_list_get (_tmp436_, _m_index);
							m = (ValaMethod*) _tmp437_;
							_tmp438_ = m;
							_tmp439_ = vala_method_get_is_abstract (_tmp438_);
							_tmp440_ = _tmp439_;
							if (_tmp440_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp441_ = FALSE;
									ValaClass* _tmp442_;
									ValaClass* _tmp494_;
									ValaClass* _tmp495_;
									_tmp442_ = base_class;
									if (_tmp442_ != NULL) {
										_tmp441_ = !implemented;
									} else {
										_tmp441_ = FALSE;
									}
									if (!_tmp441_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp443_;
										ValaList* _tmp444_;
										ValaList* _tmp445_;
										gint _impl_size = 0;
										ValaList* _tmp446_;
										gint _tmp447_;
										gint _tmp448_;
										gint _impl_index = 0;
										_tmp443_ = base_class;
										_tmp444_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp443_);
										_tmp445_ = _vala_iterable_ref0 (_tmp444_);
										_impl_list = _tmp445_;
										_tmp446_ = _impl_list;
										_tmp447_ = vala_collection_get_size ((ValaCollection*) _tmp446_);
										_tmp448_ = _tmp447_;
										_impl_size = _tmp448_;
										_impl_index = -1;
										while (TRUE) {
											ValaMethod* impl = NULL;
											ValaList* _tmp449_;
											gpointer _tmp450_;
											gboolean _tmp451_ = FALSE;
											ValaMethod* _tmp452_;
											ValaMethod* _tmp453_;
											ValaMethod* _tmp454_;
											ValaMethod* _tmp455_;
											_impl_index = _impl_index + 1;
											if (!(_impl_index < _impl_size)) {
												break;
											}
											_tmp449_ = _impl_list;
											_tmp450_ = vala_list_get (_tmp449_, _impl_index);
											impl = (ValaMethod*) _tmp450_;
											_tmp452_ = impl;
											_tmp453_ = vala_method_get_base_interface_method (_tmp452_);
											_tmp454_ = _tmp453_;
											_tmp455_ = m;
											if (_tmp454_ == _tmp455_) {
												_tmp451_ = TRUE;
											} else {
												gboolean _tmp456_ = FALSE;
												gboolean _tmp457_ = FALSE;
												gboolean _tmp458_ = FALSE;
												gboolean _tmp459_ = FALSE;
												ValaClass* _tmp460_;
												_tmp460_ = base_class;
												if (_tmp460_ != self) {
													ValaMethod* _tmp461_;
													ValaMethod* _tmp462_;
													ValaMethod* _tmp463_;
													_tmp461_ = impl;
													_tmp462_ = vala_method_get_base_interface_method (_tmp461_);
													_tmp463_ = _tmp462_;
													_tmp459_ = _tmp463_ == NULL;
												} else {
													_tmp459_ = FALSE;
												}
												if (_tmp459_) {
													ValaMethod* _tmp464_;
													const gchar* _tmp465_;
													const gchar* _tmp466_;
													ValaMethod* _tmp467_;
													const gchar* _tmp468_;
													const gchar* _tmp469_;
													_tmp464_ = impl;
													_tmp465_ = vala_symbol_get_name ((ValaSymbol*) _tmp464_);
													_tmp466_ = _tmp465_;
													_tmp467_ = m;
													_tmp468_ = vala_symbol_get_name ((ValaSymbol*) _tmp467_);
													_tmp469_ = _tmp468_;
													_tmp458_ = g_strcmp0 (_tmp466_, _tmp469_) == 0;
												} else {
													_tmp458_ = FALSE;
												}
												if (_tmp458_) {
													gboolean _tmp470_ = FALSE;
													ValaMethod* _tmp471_;
													ValaDataType* _tmp472_;
													ValaDataType* _tmp473_;
													_tmp471_ = impl;
													_tmp472_ = vala_method_get_base_interface_type (_tmp471_);
													_tmp473_ = _tmp472_;
													if (_tmp473_ == NULL) {
														_tmp470_ = TRUE;
													} else {
														ValaMethod* _tmp474_;
														ValaDataType* _tmp475_;
														ValaDataType* _tmp476_;
														ValaTypeSymbol* _tmp477_;
														ValaTypeSymbol* _tmp478_;
														ValaInterface* _tmp479_;
														_tmp474_ = impl;
														_tmp475_ = vala_method_get_base_interface_type (_tmp474_);
														_tmp476_ = _tmp475_;
														_tmp477_ = vala_data_type_get_type_symbol (_tmp476_);
														_tmp478_ = _tmp477_;
														_tmp479_ = iface;
														_tmp470_ = _tmp478_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp479_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp457_ = _tmp470_;
												} else {
													_tmp457_ = FALSE;
												}
												if (_tmp457_) {
													ValaMethod* _tmp480_;
													ValaMethod* _tmp481_;
													_tmp480_ = impl;
													_tmp481_ = m;
													_tmp456_ = vala_method_compatible_no_error (_tmp480_, _tmp481_);
												} else {
													_tmp456_ = FALSE;
												}
												_tmp451_ = _tmp456_;
											}
											if (_tmp451_) {
												ValaMethod* _tmp482_;
												ValaVersionAttribute* _tmp483_;
												ValaVersionAttribute* _tmp484_;
												ValaSourceReference* _tmp485_;
												ValaSourceReference* _tmp486_;
												ValaMethod* _tmp487_;
												ValaMethod* _tmp488_;
												ValaMethod* _tmp489_;
												ValaMethod* _tmp490_;
												_tmp482_ = impl;
												_tmp483_ = vala_symbol_get_version ((ValaSymbol*) _tmp482_);
												_tmp484_ = _tmp483_;
												_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp486_ = _tmp485_;
												vala_version_attribute_check (_tmp484_, _tmp486_);
												_tmp487_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp487_, TRUE);
												implemented = TRUE;
												_tmp488_ = impl;
												_tmp489_ = vala_method_get_base_interface_method (_tmp488_);
												_tmp490_ = _tmp489_;
												if (_tmp490_ == NULL) {
													ValaHashMap* _tmp491_;
													ValaMethod* _tmp492_;
													ValaMethod* _tmp493_;
													_tmp491_ = self->priv->implicit_implementations;
													_tmp492_ = m;
													_tmp493_ = impl;
													vala_map_set ((ValaMap*) _tmp491_, _tmp492_, _tmp493_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp494_ = base_class;
									_tmp495_ = _tmp494_->priv->_base_class;
									base_class = _tmp495_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp496_;
									ValaSourceReference* _tmp497_;
									gchar* _tmp498_;
									gchar* _tmp499_;
									ValaMethod* _tmp500_;
									gchar* _tmp501_;
									gchar* _tmp502_;
									gchar* _tmp503_;
									gchar* _tmp504_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp496_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp497_ = _tmp496_;
									_tmp498_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp499_ = _tmp498_;
									_tmp500_ = m;
									_tmp501_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp500_);
									_tmp502_ = _tmp501_;
									_tmp503_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp499_, _tmp502_);
									_tmp504_ = _tmp503_;
									vala_report_error (_tmp497_, _tmp504_);
									_g_free0 (_tmp504_);
									_g_free0 (_tmp502_);
									_g_free0 (_tmp499_);
								}
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp505_;
						ValaList* _tmp506_;
						ValaList* _tmp507_;
						gint _prop_size = 0;
						ValaList* _tmp508_;
						gint _tmp509_;
						gint _tmp510_;
						gint _prop_index = 0;
						_tmp505_ = iface;
						_tmp506_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp505_);
						_tmp507_ = _vala_iterable_ref0 (_tmp506_);
						_prop_list = _tmp507_;
						_tmp508_ = _prop_list;
						_tmp509_ = vala_collection_get_size ((ValaCollection*) _tmp508_);
						_tmp510_ = _tmp509_;
						_prop_size = _tmp510_;
						_prop_index = -1;
						while (TRUE) {
							ValaProperty* prop = NULL;
							ValaList* _tmp511_;
							gpointer _tmp512_;
							ValaProperty* _tmp513_;
							gboolean _tmp514_;
							gboolean _tmp515_;
							_prop_index = _prop_index + 1;
							if (!(_prop_index < _prop_size)) {
								break;
							}
							_tmp511_ = _prop_list;
							_tmp512_ = vala_list_get (_tmp511_, _prop_index);
							prop = (ValaProperty*) _tmp512_;
							_tmp513_ = prop;
							_tmp514_ = vala_property_get_is_abstract (_tmp513_);
							_tmp515_ = _tmp514_;
							if (_tmp515_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp528_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp516_ = FALSE;
									ValaClass* _tmp517_;
									ValaClass* _tmp519_;
									ValaScope* _tmp520_;
									ValaScope* _tmp521_;
									ValaProperty* _tmp522_;
									const gchar* _tmp523_;
									const gchar* _tmp524_;
									ValaSymbol* _tmp525_;
									ValaClass* _tmp526_;
									ValaClass* _tmp527_;
									_tmp517_ = base_class;
									if (_tmp517_ != NULL) {
										ValaSymbol* _tmp518_;
										_tmp518_ = sym;
										_tmp516_ = !VALA_IS_PROPERTY (_tmp518_);
									} else {
										_tmp516_ = FALSE;
									}
									if (!_tmp516_) {
										break;
									}
									_tmp519_ = base_class;
									_tmp520_ = vala_symbol_get_scope ((ValaSymbol*) _tmp519_);
									_tmp521_ = _tmp520_;
									_tmp522_ = prop;
									_tmp523_ = vala_symbol_get_name ((ValaSymbol*) _tmp522_);
									_tmp524_ = _tmp523_;
									_tmp525_ = vala_scope_lookup (_tmp521_, _tmp524_);
									_vala_code_node_unref0 (sym);
									sym = _tmp525_;
									_tmp526_ = base_class;
									_tmp527_ = _tmp526_->priv->_base_class;
									base_class = _tmp527_;
								}
								_tmp528_ = sym;
								if (VALA_IS_PROPERTY (_tmp528_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp529_;
									ValaProperty* _tmp530_;
									gchar* invalid_match = NULL;
									gboolean _tmp531_ = FALSE;
									ValaProperty* _tmp532_;
									gboolean _tmp533_;
									gboolean _tmp534_;
									ValaSymbol* _tmp550_;
									ValaVersionAttribute* _tmp551_;
									ValaVersionAttribute* _tmp552_;
									ValaSourceReference* _tmp553_;
									ValaSourceReference* _tmp554_;
									ValaSymbol* _tmp555_;
									_tmp529_ = sym;
									_tmp530_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp529_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp530_;
									invalid_match = NULL;
									_tmp532_ = base_prop;
									_tmp533_ = vala_symbol_get_hides ((ValaSymbol*) _tmp532_);
									_tmp534_ = _tmp533_;
									if (!_tmp534_) {
										ValaProperty* _tmp535_;
										ValaProperty* _tmp536_;
										gchar* _tmp537_ = NULL;
										gboolean _tmp538_;
										_tmp535_ = base_prop;
										_tmp536_ = prop;
										_tmp538_ = vala_property_compatible (_tmp535_, _tmp536_, &_tmp537_);
										_g_free0 (invalid_match);
										invalid_match = _tmp537_;
										_tmp531_ = !_tmp538_;
									} else {
										_tmp531_ = FALSE;
									}
									if (_tmp531_) {
										ValaSourceReference* _tmp539_;
										ValaSourceReference* _tmp540_;
										ValaProperty* _tmp541_;
										gchar* _tmp542_;
										gchar* _tmp543_;
										ValaProperty* _tmp544_;
										gchar* _tmp545_;
										gchar* _tmp546_;
										const gchar* _tmp547_;
										gchar* _tmp548_;
										gchar* _tmp549_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp539_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp540_ = _tmp539_;
										_tmp541_ = prop;
										_tmp542_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp541_);
										_tmp543_ = _tmp542_;
										_tmp544_ = base_prop;
										_tmp545_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp544_);
										_tmp546_ = _tmp545_;
										_tmp547_ = invalid_match;
										_tmp548_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp543_, _tmp546_, _tmp547_);
										_tmp549_ = _tmp548_;
										vala_report_error (_tmp540_, _tmp549_);
										_g_free0 (_tmp549_);
										_g_free0 (_tmp546_);
										_g_free0 (_tmp543_);
									}
									_tmp550_ = sym;
									_tmp551_ = vala_symbol_get_version (_tmp550_);
									_tmp552_ = _tmp551_;
									_tmp553_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp554_ = _tmp553_;
									vala_version_attribute_check (_tmp552_, _tmp554_);
									_tmp555_ = sym;
									vala_symbol_set_used (_tmp555_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp556_;
									ValaSourceReference* _tmp557_;
									gchar* _tmp558_;
									gchar* _tmp559_;
									ValaProperty* _tmp560_;
									gchar* _tmp561_;
									gchar* _tmp562_;
									gchar* _tmp563_;
									gchar* _tmp564_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp556_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp557_ = _tmp556_;
									_tmp558_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp559_ = _tmp558_;
									_tmp560_ = prop;
									_tmp561_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp560_);
									_tmp562_ = _tmp561_;
									_tmp563_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp559_, _tmp562_);
									_tmp564_ = _tmp563_;
									vala_report_error (_tmp557_, _tmp564_);
									_g_free0 (_tmp564_);
									_g_free0 (_tmp562_);
									_g_free0 (_tmp559_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp565_ = self->priv->_is_abstract;
		if (!_tmp565_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp566_;
			_tmp566_ = self->priv->_base_class;
			base_class = _tmp566_;
			while (TRUE) {
				gboolean _tmp567_ = FALSE;
				ValaClass* _tmp568_;
				ValaClass* _tmp631_;
				ValaClass* _tmp632_;
				_tmp568_ = base_class;
				if (_tmp568_ != NULL) {
					ValaClass* _tmp569_;
					gboolean _tmp570_;
					_tmp569_ = base_class;
					_tmp570_ = _tmp569_->priv->_is_abstract;
					_tmp567_ = _tmp570_;
				} else {
					_tmp567_ = FALSE;
				}
				if (!_tmp567_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp571_;
					ValaList* _tmp572_;
					ValaList* _tmp573_;
					gint _base_method_size = 0;
					ValaList* _tmp574_;
					gint _tmp575_;
					gint _tmp576_;
					gint _base_method_index = 0;
					_tmp571_ = base_class;
					_tmp572_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp571_);
					_tmp573_ = _vala_iterable_ref0 (_tmp572_);
					_base_method_list = _tmp573_;
					_tmp574_ = _base_method_list;
					_tmp575_ = vala_collection_get_size ((ValaCollection*) _tmp574_);
					_tmp576_ = _tmp575_;
					_base_method_size = _tmp576_;
					_base_method_index = -1;
					while (TRUE) {
						ValaMethod* base_method = NULL;
						ValaList* _tmp577_;
						gpointer _tmp578_;
						ValaMethod* _tmp579_;
						gboolean _tmp580_;
						gboolean _tmp581_;
						_base_method_index = _base_method_index + 1;
						if (!(_base_method_index < _base_method_size)) {
							break;
						}
						_tmp577_ = _base_method_list;
						_tmp578_ = vala_list_get (_tmp577_, _base_method_index);
						base_method = (ValaMethod*) _tmp578_;
						_tmp579_ = base_method;
						_tmp580_ = vala_method_get_is_abstract (_tmp579_);
						_tmp581_ = _tmp580_;
						if (_tmp581_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp582_;
							const gchar* _tmp583_;
							const gchar* _tmp584_;
							ValaSymbol* _tmp585_;
							ValaMethod* _tmp586_;
							gboolean _tmp587_ = FALSE;
							ValaMethod* _tmp588_;
							_tmp582_ = base_method;
							_tmp583_ = vala_symbol_get_name ((ValaSymbol*) _tmp582_);
							_tmp584_ = _tmp583_;
							_tmp585_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp584_);
							_tmp586_ = VALA_IS_METHOD (_tmp585_) ? ((ValaMethod*) _tmp585_) : NULL;
							if (_tmp586_ == NULL) {
								_vala_code_node_unref0 (_tmp585_);
							}
							override_method = _tmp586_;
							_tmp588_ = override_method;
							if (_tmp588_ == NULL) {
								_tmp587_ = TRUE;
							} else {
								ValaMethod* _tmp589_;
								gboolean _tmp590_;
								gboolean _tmp591_;
								_tmp589_ = override_method;
								_tmp590_ = vala_method_get_overrides (_tmp589_);
								_tmp591_ = _tmp590_;
								_tmp587_ = !_tmp591_;
							}
							if (_tmp587_) {
								ValaSourceReference* _tmp592_;
								ValaSourceReference* _tmp593_;
								gchar* _tmp594_;
								gchar* _tmp595_;
								ValaMethod* _tmp596_;
								gchar* _tmp597_;
								gchar* _tmp598_;
								gchar* _tmp599_;
								gchar* _tmp600_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp593_ = _tmp592_;
								_tmp594_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp595_ = _tmp594_;
								_tmp596_ = base_method;
								_tmp597_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp596_);
								_tmp598_ = _tmp597_;
								_tmp599_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp595_, _tmp598_);
								_tmp600_ = _tmp599_;
								vala_report_error (_tmp593_, _tmp600_);
								_g_free0 (_tmp600_);
								_g_free0 (_tmp598_);
								_g_free0 (_tmp595_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp601_;
					ValaList* _tmp602_;
					ValaList* _tmp603_;
					gint _base_property_size = 0;
					ValaList* _tmp604_;
					gint _tmp605_;
					gint _tmp606_;
					gint _base_property_index = 0;
					_tmp601_ = base_class;
					_tmp602_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp601_);
					_tmp603_ = _vala_iterable_ref0 (_tmp602_);
					_base_property_list = _tmp603_;
					_tmp604_ = _base_property_list;
					_tmp605_ = vala_collection_get_size ((ValaCollection*) _tmp604_);
					_tmp606_ = _tmp605_;
					_base_property_size = _tmp606_;
					_base_property_index = -1;
					while (TRUE) {
						ValaProperty* base_property = NULL;
						ValaList* _tmp607_;
						gpointer _tmp608_;
						ValaProperty* _tmp609_;
						gboolean _tmp610_;
						gboolean _tmp611_;
						_base_property_index = _base_property_index + 1;
						if (!(_base_property_index < _base_property_size)) {
							break;
						}
						_tmp607_ = _base_property_list;
						_tmp608_ = vala_list_get (_tmp607_, _base_property_index);
						base_property = (ValaProperty*) _tmp608_;
						_tmp609_ = base_property;
						_tmp610_ = vala_property_get_is_abstract (_tmp609_);
						_tmp611_ = _tmp610_;
						if (_tmp611_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp612_;
							const gchar* _tmp613_;
							const gchar* _tmp614_;
							ValaSymbol* _tmp615_;
							ValaProperty* _tmp616_;
							gboolean _tmp617_ = FALSE;
							ValaProperty* _tmp618_;
							_tmp612_ = base_property;
							_tmp613_ = vala_symbol_get_name ((ValaSymbol*) _tmp612_);
							_tmp614_ = _tmp613_;
							_tmp615_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp614_);
							_tmp616_ = VALA_IS_PROPERTY (_tmp615_) ? ((ValaProperty*) _tmp615_) : NULL;
							if (_tmp616_ == NULL) {
								_vala_code_node_unref0 (_tmp615_);
							}
							override_property = _tmp616_;
							_tmp618_ = override_property;
							if (_tmp618_ == NULL) {
								_tmp617_ = TRUE;
							} else {
								ValaProperty* _tmp619_;
								gboolean _tmp620_;
								gboolean _tmp621_;
								_tmp619_ = override_property;
								_tmp620_ = vala_property_get_overrides (_tmp619_);
								_tmp621_ = _tmp620_;
								_tmp617_ = !_tmp621_;
							}
							if (_tmp617_) {
								ValaSourceReference* _tmp622_;
								ValaSourceReference* _tmp623_;
								gchar* _tmp624_;
								gchar* _tmp625_;
								ValaProperty* _tmp626_;
								gchar* _tmp627_;
								gchar* _tmp628_;
								gchar* _tmp629_;
								gchar* _tmp630_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp622_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp623_ = _tmp622_;
								_tmp624_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp625_ = _tmp624_;
								_tmp626_ = base_property;
								_tmp627_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp626_);
								_tmp628_ = _tmp627_;
								_tmp629_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp625_, _tmp628_);
								_tmp630_ = _tmp629_;
								vala_report_error (_tmp623_, _tmp630_);
								_g_free0 (_tmp630_);
								_g_free0 (_tmp628_);
								_g_free0 (_tmp625_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp631_ = base_class;
				_tmp632_ = _tmp631_->priv->_base_class;
				base_class = _tmp632_;
			}
		}
	}
	_tmp633_ = vala_code_context_get_analyzer (context);
	_tmp634_ = _tmp633_;
	_tmp635_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp634_, _tmp635_);
	_tmp636_ = vala_code_context_get_analyzer (context);
	_tmp637_ = _tmp636_;
	_tmp638_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp637_, _tmp638_);
	_tmp639_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp640_ = _tmp639_;
	result = !_tmp640_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashMap* _tmp5_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_, _tmp3_, _tmp4_);
	self->priv->implicit_implementations = _tmp5_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

