/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp290_ = FALSE;
	ValaMethod* _tmp291_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp455_;
	ValaCCodeExpression* _tmp456_;
	gboolean _tmp457_ = FALSE;
	ValaMethod* _tmp458_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp486_ = FALSE;
	ValaMethod* _tmp487_;
	gboolean _tmp638_ = FALSE;
	ValaMethod* _tmp639_;
	ValaMethod* _tmp689_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp877_;
	ValaIterator* _tmp878_;
	ValaIterator* _tmp1297_;
	gboolean _tmp1307_ = FALSE;
	gboolean _tmp1308_ = FALSE;
	ValaMethod* _tmp1309_;
	gboolean _tmp1438_ = FALSE;
	ValaDelegate* _tmp1439_;
	gboolean _tmp1536_ = FALSE;
	ValaMethod* _tmp1537_;
	gboolean _tmp1553_;
	gboolean _tmp1554_;
	gboolean _tmp1597_ = FALSE;
	ValaDelegate* _tmp1598_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1616_;
	ValaDataType* _tmp1617_;
	gboolean _tmp1618_ = FALSE;
	ValaDataType* _tmp1619_;
	ValaCCodeFunctionCall* _tmp1647_;
	ValaCCodeFunctionCall* _tmp1648_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1661_;
	ValaCCodeFunctionCall* _tmp1662_;
	ValaCCodeFunctionCall* _tmp1677_;
	gboolean _tmp1692_;
	gboolean _tmp1693_;
	gboolean _tmp1717_;
	gboolean _tmp1718_;
	gboolean _tmp1753_ = FALSE;
	gboolean _tmp1754_ = FALSE;
	ValaMethod* _tmp1755_;
	gboolean _tmp1793_ = FALSE;
	gboolean _tmp1794_ = FALSE;
	gboolean _tmp1795_ = FALSE;
	gboolean _tmp1796_ = FALSE;
	gboolean _tmp1797_ = FALSE;
	ValaMethod* _tmp1798_;
	gboolean _tmp1815_ = FALSE;
	gboolean _tmp1816_ = FALSE;
	ValaMethod* _tmp1817_;
	ValaMethod* _tmp1836_;
	gboolean _tmp1952_ = FALSE;
	ValaCodeNode* _tmp1953_;
	ValaCodeNode* _tmp1954_;
	ValaList* _tmp2054_;
	ValaIterator* _tmp2055_;
	gboolean _tmp2148_ = FALSE;
	gboolean _tmp2149_ = FALSE;
	ValaMethod* _tmp2150_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp240_ = FALSE;
		ValaMemberAccess* _tmp241_;
		const gchar* _tmp242_;
		const gchar* _tmp243_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp241_ = ma;
		_tmp242_ = vala_member_access_get_member_name (_tmp241_);
		_tmp243_ = _tmp242_;
		if (g_strcmp0 (_tmp243_, "begin") == 0) {
			ValaMemberAccess* _tmp244_;
			ValaExpression* _tmp245_;
			ValaExpression* _tmp246_;
			ValaSymbol* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaMemberAccess* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			_tmp244_ = ma;
			_tmp245_ = vala_member_access_get_inner (_tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
			_tmp248_ = _tmp247_;
			_tmp249_ = ma;
			_tmp250_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp249_);
			_tmp251_ = _tmp250_;
			_tmp240_ = _tmp248_ == _tmp251_;
		} else {
			_tmp240_ = FALSE;
		}
		if (_tmp240_) {
			ValaCCodeFunctionCall* _tmp252_;
			ValaCCodeFunctionCall* _tmp253_;
			ValaMethod* _tmp254_;
			ValaList* _tmp255_;
			_tmp252_ = async_call;
			_tmp253_ = _vala_ccode_node_ref0 (_tmp252_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp253_;
			_tmp254_ = m;
			_tmp255_ = vala_method_get_async_begin_parameters (_tmp254_);
			_vala_iterable_unref0 (params);
			params = _tmp255_;
		} else {
			gboolean _tmp256_ = FALSE;
			ValaMemberAccess* _tmp257_;
			const gchar* _tmp258_;
			const gchar* _tmp259_;
			_tmp257_ = ma;
			_tmp258_ = vala_member_access_get_member_name (_tmp257_);
			_tmp259_ = _tmp258_;
			if (g_strcmp0 (_tmp259_, "end") == 0) {
				ValaMemberAccess* _tmp260_;
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				ValaSymbol* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaMemberAccess* _tmp265_;
				ValaSymbol* _tmp266_;
				ValaSymbol* _tmp267_;
				_tmp260_ = ma;
				_tmp261_ = vala_member_access_get_inner (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_expression_get_symbol_reference (_tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = ma;
				_tmp266_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp265_);
				_tmp267_ = _tmp266_;
				_tmp256_ = _tmp264_ == _tmp267_;
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaCCodeFunctionCall* _tmp268_;
				ValaCCodeFunctionCall* _tmp269_;
				ValaMethod* _tmp270_;
				ValaList* _tmp271_;
				_tmp268_ = finish_call;
				_tmp269_ = _vala_ccode_node_ref0 (_tmp268_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp269_;
				_tmp270_ = m;
				_tmp271_ = vala_method_get_async_end_parameters (_tmp270_);
				_vala_iterable_unref0 (params);
				params = _tmp271_;
			} else {
				gboolean _tmp272_;
				gboolean _tmp273_;
				_tmp272_ = vala_method_call_get_is_yield_expression (expr);
				_tmp273_ = _tmp272_;
				if (!_tmp273_) {
					ValaCCodeFunctionCall* _tmp274_;
					ValaCCodeFunctionCall* _tmp275_;
					ValaMethod* _tmp276_;
					ValaList* _tmp277_;
					_tmp274_ = async_call;
					_tmp275_ = _vala_ccode_node_ref0 (_tmp274_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp275_;
					_tmp276_ = m;
					_tmp277_ = vala_method_get_async_begin_parameters (_tmp276_);
					_vala_iterable_unref0 (params);
					params = _tmp277_;
				} else {
					ValaCCodeFunctionCall* _tmp278_;
					ValaCCodeFunctionCall* _tmp279_;
					GHashFunc _tmp280_;
					GEqualFunc _tmp281_;
					GEqualFunc _tmp282_;
					ValaHashMap* _tmp283_;
					ValaHashMap* _tmp284_;
					ValaMethod* _tmp285_;
					ValaCCodeIdentifier* _tmp286_;
					ValaCCodeIdentifier* _tmp287_;
					ValaCCodeMemberAccess* _tmp288_;
					ValaCCodeMemberAccess* _tmp289_;
					_tmp278_ = finish_call;
					_tmp279_ = _vala_ccode_node_ref0 (_tmp278_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp279_;
					_tmp280_ = g_direct_hash;
					_tmp281_ = g_direct_equal;
					_tmp282_ = g_direct_equal;
					_tmp283_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp280_, _tmp281_, _tmp282_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp283_;
					_tmp284_ = out_arg_map;
					_tmp285_ = m;
					_tmp286_ = vala_ccode_identifier_new ("_data_");
					_tmp287_ = _tmp286_;
					_tmp288_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp287_, "_res_");
					_tmp289_ = _tmp288_;
					vala_map_set ((ValaMap*) _tmp284_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp285_), FALSE)), (ValaCCodeExpression*) _tmp289_);
					_vala_ccode_node_unref0 (_tmp289_);
					_vala_ccode_node_unref0 (_tmp287_);
				}
			}
		}
	}
	_tmp291_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp291_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp292_;
		ValaSymbol* _tmp293_;
		ValaSymbol* _tmp294_;
		_tmp292_ = m;
		_tmp293_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp292_);
		_tmp294_ = _tmp293_;
		_tmp290_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp294_, VALA_TYPE_CLASS);
	} else {
		_tmp290_ = FALSE;
	}
	if (_tmp290_) {
		ValaCodeContext* _tmp295_;
		ValaCodeContext* _tmp296_;
		ValaProfile _tmp297_;
		ValaProfile _tmp298_;
		ValaClass* _tmp310_;
		ValaClass* _tmp311_;
		gboolean _tmp312_;
		gboolean _tmp313_;
		_tmp295_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_code_context_get_profile (_tmp296_);
		_tmp298_ = _tmp297_;
		if (_tmp298_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp299_;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			gboolean _tmp302_;
			gboolean _tmp303_;
			_tmp299_ = m;
			_tmp300_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp301_, VALA_TYPE_CLASS, ValaClass));
			_tmp303_ = _tmp302_;
			if (!_tmp303_) {
				ValaCCodeFunctionCall* _tmp304_;
				ValaCCodeExpression* _tmp305_;
				ValaCCodeExpression* _tmp306_;
				_tmp304_ = ccall;
				_tmp305_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp306_ = _tmp305_;
				vala_ccode_function_call_add_argument (_tmp304_, _tmp306_);
				_vala_ccode_node_unref0 (_tmp306_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp307_;
			ValaCCodeExpression* _tmp308_;
			ValaCCodeExpression* _tmp309_;
			_tmp307_ = ccall;
			_tmp308_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp309_ = _tmp308_;
			vala_ccode_function_call_add_argument (_tmp307_, _tmp309_);
			_vala_ccode_node_unref0 (_tmp309_);
		}
		_tmp310_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp311_ = _tmp310_;
		_tmp312_ = vala_class_get_is_compact (_tmp311_);
		_tmp313_ = _tmp312_;
		if (!_tmp313_) {
			ValaClass* _tmp314_;
			ValaClass* _tmp315_;
			ValaMethod* _tmp316_;
			ValaSymbol* _tmp317_;
			ValaSymbol* _tmp318_;
			_tmp314_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp315_ = _tmp314_;
			_tmp316_ = m;
			_tmp317_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp316_);
			_tmp318_ = _tmp317_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp318_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp319_;
					ValaClass* _tmp320_;
					ValaList* _tmp321_;
					ValaList* _tmp322_;
					gint _base_type_size = 0;
					ValaList* _tmp323_;
					gint _tmp324_;
					gint _tmp325_;
					gint _base_type_index = 0;
					_tmp319_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = vala_class_get_base_types (_tmp320_);
					_tmp322_ = _vala_iterable_ref0 (_tmp321_);
					_base_type_list = _tmp322_;
					_tmp323_ = _base_type_list;
					_tmp324_ = vala_collection_get_size ((ValaCollection*) _tmp323_);
					_tmp325_ = _tmp324_;
					_base_type_size = _tmp325_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp326_;
						gpointer _tmp327_;
						ValaDataType* _tmp328_;
						ValaTypeSymbol* _tmp329_;
						ValaTypeSymbol* _tmp330_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp326_ = _base_type_list;
						_tmp327_ = vala_list_get (_tmp326_, _base_type_index);
						base_type = (ValaDataType*) _tmp327_;
						_tmp328_ = base_type;
						_tmp329_ = vala_data_type_get_type_symbol (_tmp328_);
						_tmp330_ = _tmp329_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp331_;
							gchar* _tmp332_;
							gchar* _tmp333_;
							gboolean _tmp334_;
							ValaHashMap* _tmp340_;
							ValaDataType* _tmp341_;
							ValaList* _tmp342_;
							ValaList* _tmp343_;
							type_parameters = NULL;
							_tmp331_ = m;
							_tmp332_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp331_);
							_tmp333_ = _tmp332_;
							_tmp334_ = g_strcmp0 (_tmp333_, "g_object_new") == 0;
							_g_free0 (_tmp333_);
							if (_tmp334_) {
								ValaDataType* _tmp335_;
								ValaTypeSymbol* _tmp336_;
								ValaTypeSymbol* _tmp337_;
								ValaList* _tmp338_;
								ValaList* _tmp339_;
								_tmp335_ = base_type;
								_tmp336_ = vala_data_type_get_type_symbol (_tmp335_);
								_tmp337_ = _tmp336_;
								_tmp338_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp337_, VALA_TYPE_CLASS, ValaClass));
								_tmp339_ = _vala_iterable_ref0 (_tmp338_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp339_;
							}
							_tmp340_ = in_arg_map;
							_tmp341_ = base_type;
							_tmp342_ = vala_data_type_get_type_arguments (_tmp341_);
							_tmp343_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp340_, _tmp342_, (ValaCodeNode*) expr, TRUE, _tmp343_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp344_;
				ValaSymbol* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaClass* _tmp347_;
				type_param_index = 0;
				_tmp344_ = m;
				_tmp345_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp344_);
				_tmp346_ = _tmp345_;
				_tmp347_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp346_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp347_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp348_;
					ValaList* _tmp349_;
					ValaList* _tmp350_;
					gint _type_param_size = 0;
					ValaList* _tmp351_;
					gint _tmp352_;
					gint _tmp353_;
					gint _type_param_index = 0;
					_tmp348_ = cl;
					_tmp349_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp348_);
					_tmp350_ = _vala_iterable_ref0 (_tmp349_);
					_type_param_list = _tmp350_;
					_tmp351_ = _type_param_list;
					_tmp352_ = vala_collection_get_size ((ValaCollection*) _tmp351_);
					_tmp353_ = _tmp352_;
					_type_param_size = _tmp353_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp354_;
						gpointer _tmp355_;
						ValaHashMap* _tmp356_;
						ValaTypeParameter* _tmp357_;
						const gchar* _tmp358_;
						const gchar* _tmp359_;
						gchar* _tmp360_;
						gchar* _tmp361_;
						gchar* _tmp362_;
						gchar* _tmp363_;
						ValaCCodeIdentifier* _tmp364_;
						ValaCCodeIdentifier* _tmp365_;
						ValaHashMap* _tmp366_;
						ValaTypeParameter* _tmp367_;
						const gchar* _tmp368_;
						const gchar* _tmp369_;
						gchar* _tmp370_;
						gchar* _tmp371_;
						gchar* _tmp372_;
						gchar* _tmp373_;
						ValaCCodeIdentifier* _tmp374_;
						ValaCCodeIdentifier* _tmp375_;
						ValaHashMap* _tmp376_;
						ValaTypeParameter* _tmp377_;
						const gchar* _tmp378_;
						const gchar* _tmp379_;
						gchar* _tmp380_;
						gchar* _tmp381_;
						gchar* _tmp382_;
						gchar* _tmp383_;
						ValaCCodeIdentifier* _tmp384_;
						ValaCCodeIdentifier* _tmp385_;
						gint _tmp386_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp354_ = _type_param_list;
						_tmp355_ = vala_list_get (_tmp354_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp355_;
						_tmp356_ = in_arg_map;
						_tmp357_ = type_param;
						_tmp358_ = vala_symbol_get_name ((ValaSymbol*) _tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = g_utf8_strdown (_tmp359_, (gssize) -1);
						_tmp361_ = _tmp360_;
						_tmp362_ = g_strdup_printf ("%s_type", _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_ccode_identifier_new (_tmp363_);
						_tmp365_ = _tmp364_;
						vala_map_set ((ValaMap*) _tmp356_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp365_);
						_vala_ccode_node_unref0 (_tmp365_);
						_g_free0 (_tmp363_);
						_g_free0 (_tmp361_);
						_tmp366_ = in_arg_map;
						_tmp367_ = type_param;
						_tmp368_ = vala_symbol_get_name ((ValaSymbol*) _tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = g_utf8_strdown (_tmp369_, (gssize) -1);
						_tmp371_ = _tmp370_;
						_tmp372_ = g_strdup_printf ("%s_dup_func", _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = vala_ccode_identifier_new (_tmp373_);
						_tmp375_ = _tmp374_;
						vala_map_set ((ValaMap*) _tmp366_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp375_);
						_vala_ccode_node_unref0 (_tmp375_);
						_g_free0 (_tmp373_);
						_g_free0 (_tmp371_);
						_tmp376_ = in_arg_map;
						_tmp377_ = type_param;
						_tmp378_ = vala_symbol_get_name ((ValaSymbol*) _tmp377_);
						_tmp379_ = _tmp378_;
						_tmp380_ = g_utf8_strdown (_tmp379_, (gssize) -1);
						_tmp381_ = _tmp380_;
						_tmp382_ = g_strdup_printf ("%s_destroy_func", _tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = vala_ccode_identifier_new (_tmp383_);
						_tmp385_ = _tmp384_;
						vala_map_set ((ValaMap*) _tmp376_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp385_);
						_vala_ccode_node_unref0 (_tmp385_);
						_g_free0 (_tmp383_);
						_g_free0 (_tmp381_);
						_tmp386_ = type_param_index;
						type_param_index = _tmp386_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp387_;
			ValaClass* _tmp388_;
			ValaClass* _tmp389_;
			ValaClass* _tmp390_;
			ValaClass* _tmp391_;
			_tmp387_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp388_ = _tmp387_;
			_tmp389_ = vala_class_get_base_class (_tmp388_);
			_tmp390_ = _tmp389_;
			_tmp391_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp390_ == _tmp391_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp392_;
				ValaClass* _tmp393_;
				gchar* _tmp394_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp395_;
				ValaCCodeDeclaration* _tmp396_;
				ValaCCodeDeclaration* _tmp397_;
				const gchar* _tmp398_;
				const gchar* _tmp399_;
				const gchar* _tmp400_;
				const gchar* _tmp401_;
				gchar* _tmp402_;
				gchar* _tmp403_;
				ValaCCodeConstant* _tmp404_;
				ValaCCodeConstant* _tmp405_;
				ValaCCodeVariableDeclarator* _tmp406_;
				ValaCCodeVariableDeclarator* _tmp407_;
				ValaCCodeFunction* _tmp408_;
				ValaCCodeFunction* _tmp409_;
				ValaCCodeDeclaration* _tmp410_;
				ValaCCodeFunctionCall* _tmp411_;
				ValaCCodeIdentifier* _tmp412_;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeUnaryExpression* _tmp414_;
				ValaCCodeUnaryExpression* _tmp415_;
				ValaCCodeCastExpression* _tmp416_;
				ValaCCodeCastExpression* _tmp417_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp418_;
				ValaCCodeIdentifier* _tmp419_;
				ValaCCodeFunctionCall* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				ValaClass* _tmp423_;
				ValaClass* _tmp424_;
				gchar* _tmp425_;
				gchar* _tmp426_;
				ValaCCodeIdentifier* _tmp427_;
				ValaCCodeIdentifier* _tmp428_;
				ValaCCodeFunctionCall* _tmp429_;
				ValaCCodeFunctionCall* _tmp430_;
				_tmp392_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp393_ = _tmp392_;
				_tmp394_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp393_, NULL);
				class_prefix = _tmp394_;
				_tmp395_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp395_;
				_tmp396_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp396_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp397_ = funcs;
				_tmp398_ = class_prefix;
				_tmp399_ = class_prefix;
				_tmp400_ = class_prefix;
				_tmp401_ = class_prefix;
				_tmp402_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp398_, _tmp399_, _tmp400_, _tmp401_);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_ccode_constant_new (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp406_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp405_, NULL);
				_tmp407_ = _tmp406_;
				vala_ccode_declaration_add_declarator (_tmp397_, (ValaCCodeDeclarator*) _tmp407_);
				_vala_ccode_node_unref0 (_tmp407_);
				_vala_ccode_node_unref0 (_tmp405_);
				_g_free0 (_tmp403_);
				_tmp408_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp409_ = _tmp408_;
				_tmp410_ = funcs;
				vala_ccode_function_add_statement (_tmp409_, (ValaCCodeNode*) _tmp410_);
				_tmp411_ = ccall;
				_tmp412_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp415_, "GSourceFuncs *");
				_tmp417_ = _tmp416_;
				vala_ccode_function_call_add_argument (_tmp411_, (ValaCCodeExpression*) _tmp417_);
				_vala_ccode_node_unref0 (_tmp417_);
				_vala_ccode_node_unref0 (_tmp415_);
				_vala_ccode_node_unref0 (_tmp413_);
				_tmp418_ = vala_ccode_identifier_new ("sizeof");
				_tmp419_ = _tmp418_;
				_tmp420_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp419_);
				_tmp421_ = _tmp420_;
				_vala_ccode_node_unref0 (_tmp419_);
				csizeof = _tmp421_;
				_tmp422_ = csizeof;
				_tmp423_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp424_ = _tmp423_;
				_tmp425_ = vala_get_ccode_name ((ValaCodeNode*) _tmp424_);
				_tmp426_ = _tmp425_;
				_tmp427_ = vala_ccode_identifier_new (_tmp426_);
				_tmp428_ = _tmp427_;
				vala_ccode_function_call_add_argument (_tmp422_, (ValaCCodeExpression*) _tmp428_);
				_vala_ccode_node_unref0 (_tmp428_);
				_g_free0 (_tmp426_);
				_tmp429_ = ccall;
				_tmp430_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp429_, (ValaCCodeExpression*) _tmp430_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp431_ = FALSE;
		ValaMethod* _tmp432_;
		_tmp432_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp432_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp433_;
			ValaSymbol* _tmp434_;
			ValaSymbol* _tmp435_;
			_tmp433_ = m;
			_tmp434_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp433_);
			_tmp435_ = _tmp434_;
			_tmp431_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp435_, VALA_TYPE_STRUCT);
		} else {
			_tmp431_ = FALSE;
		}
		if (_tmp431_) {
			ValaCCodeFunctionCall* _tmp436_;
			ValaCCodeExpression* _tmp437_;
			ValaCCodeExpression* _tmp438_;
			_tmp436_ = ccall;
			_tmp437_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp438_ = _tmp437_;
			vala_ccode_function_call_add_argument (_tmp436_, _tmp438_);
			_vala_ccode_node_unref0 (_tmp438_);
		} else {
			gboolean _tmp439_ = FALSE;
			gboolean _tmp440_ = FALSE;
			gboolean _tmp441_ = FALSE;
			gboolean _tmp442_ = FALSE;
			ValaMethod* _tmp443_;
			_tmp443_ = m;
			if (_tmp443_ != NULL) {
				ValaMethod* _tmp444_;
				_tmp444_ = m;
				_tmp442_ = vala_method_has_type_parameters (_tmp444_);
			} else {
				_tmp442_ = FALSE;
			}
			if (_tmp442_) {
				ValaMethod* _tmp445_;
				_tmp445_ = m;
				_tmp441_ = !vala_get_ccode_has_generic_type_parameter (_tmp445_);
			} else {
				_tmp441_ = FALSE;
			}
			if (_tmp441_) {
				ValaMethod* _tmp446_;
				_tmp446_ = m;
				_tmp440_ = !vala_get_ccode_simple_generics (_tmp446_);
			} else {
				_tmp440_ = FALSE;
			}
			if (_tmp440_) {
				gboolean _tmp447_ = FALSE;
				ValaCCodeFunctionCall* _tmp448_;
				ValaCCodeFunctionCall* _tmp449_;
				_tmp448_ = ccall;
				_tmp449_ = finish_call;
				if (_tmp448_ != _tmp449_) {
					_tmp447_ = TRUE;
				} else {
					gboolean _tmp450_;
					gboolean _tmp451_;
					_tmp450_ = vala_method_call_get_is_yield_expression (expr);
					_tmp451_ = _tmp450_;
					_tmp447_ = _tmp451_;
				}
				_tmp439_ = _tmp447_;
			} else {
				_tmp439_ = FALSE;
			}
			if (_tmp439_) {
				ValaHashMap* _tmp452_;
				ValaMemberAccess* _tmp453_;
				ValaList* _tmp454_;
				_tmp452_ = in_arg_map;
				_tmp453_ = ma;
				_tmp454_ = vala_member_access_get_type_arguments (_tmp453_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp452_, _tmp454_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp455_ = ccall;
	_tmp456_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp455_);
	ccall_expr = _tmp456_;
	_tmp458_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp458_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp459_;
		ValaCodeContext* _tmp460_;
		ValaProfile _tmp461_;
		ValaProfile _tmp462_;
		_tmp459_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_code_context_get_profile (_tmp460_);
		_tmp462_ = _tmp461_;
		_tmp457_ = _tmp462_ != VALA_PROFILE_POSIX;
	} else {
		_tmp457_ = FALSE;
	}
	if (_tmp457_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp463_;
		ValaExpression* _tmp464_;
		ValaExpression* _tmp465_;
		ValaDataType* _tmp466_;
		ValaDataType* _tmp467_;
		ValaArrayType* _tmp468_;
		ValaHashMap* _tmp469_;
		ValaArrayType* _tmp470_;
		ValaDataType* _tmp471_;
		ValaDataType* _tmp472_;
		gchar* _tmp473_;
		gchar* _tmp474_;
		ValaCCodeIdentifier* _tmp475_;
		ValaCCodeIdentifier* _tmp476_;
		_tmp463_ = ma;
		_tmp464_ = vala_member_access_get_inner (_tmp463_);
		_tmp465_ = _tmp464_;
		_tmp466_ = vala_expression_get_value_type (_tmp465_);
		_tmp467_ = _tmp466_;
		_tmp468_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp467_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp468_;
		_tmp469_ = in_arg_map;
		_tmp470_ = array_type;
		_tmp471_ = vala_array_type_get_element_type (_tmp470_);
		_tmp472_ = _tmp471_;
		_tmp473_ = vala_get_ccode_name ((ValaCodeNode*) _tmp472_);
		_tmp474_ = _tmp473_;
		_tmp475_ = vala_ccode_identifier_new (_tmp474_);
		_tmp476_ = _tmp475_;
		vala_map_set ((ValaMap*) _tmp469_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp476_);
		_vala_ccode_node_unref0 (_tmp476_);
		_g_free0 (_tmp474_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp477_;
		_tmp477_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp477_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp478_;
			_tmp478_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp478_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp479_;
				ValaExpression* _tmp480_;
				ValaExpression* _tmp481_;
				ValaTargetValue* _tmp482_;
				ValaTargetValue* _tmp483_;
				ValaTargetValue* _tmp484_;
				ValaTargetValue* _tmp485_;
				_tmp479_ = ma;
				_tmp480_ = vala_member_access_get_inner (_tmp479_);
				_tmp481_ = _tmp480_;
				_tmp482_ = vala_expression_get_target_value (_tmp481_);
				_tmp483_ = _tmp482_;
				_tmp484_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp483_, (ValaCodeNode*) expr);
				_tmp485_ = _tmp484_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp485_);
				_vala_target_value_unref0 (_tmp485_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp487_ = m;
	if (_tmp487_ != NULL) {
		ValaMethod* _tmp488_;
		gboolean _tmp489_;
		gboolean _tmp490_;
		_tmp488_ = m;
		_tmp489_ = vala_method_get_is_async_callback (_tmp488_);
		_tmp490_ = _tmp489_;
		_tmp486_ = _tmp490_;
	} else {
		_tmp486_ = FALSE;
	}
	if (_tmp486_) {
		ValaMethod* _tmp491_;
		ValaMethod* _tmp492_;
		gboolean _tmp493_;
		gboolean _tmp494_;
		ValaHashMap* _tmp508_;
		ValaMethod* _tmp509_;
		ValaCCodeExpression* _tmp510_;
		ValaHashMap* _tmp511_;
		ValaMethod* _tmp512_;
		ValaCCodeExpression* _tmp513_;
		_tmp491_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_method_get_closure (_tmp492_);
		_tmp494_ = _tmp493_;
		if (_tmp494_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp495_;
			ValaSymbol* _tmp496_;
			ValaSymbol* _tmp497_;
			ValaBlock* _tmp498_;
			ValaBlock* _tmp499_;
			ValaBlock* _tmp500_;
			ValaBlock* _tmp501_;
			gchar* _tmp502_;
			gchar* _tmp503_;
			ValaCCodeExpression* _tmp504_;
			ValaCCodeExpression* _tmp505_;
			ValaCCodeMemberAccess* _tmp506_;
			_tmp495_ = m;
			_tmp496_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp497_, VALA_TYPE_METHOD, ValaMethod));
			_tmp499_ = _tmp498_;
			_tmp500_ = _vala_code_node_ref0 (_tmp499_);
			block = _tmp500_;
			_tmp501_ = block;
			_tmp502_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp501_));
			_tmp503_ = _tmp502_;
			_tmp504_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp503_);
			_tmp505_ = _tmp504_;
			_tmp506_ = vala_ccode_member_access_new_pointer (_tmp505_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp506_;
			_vala_ccode_node_unref0 (_tmp505_);
			_g_free0 (_tmp503_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp507_;
			_tmp507_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp507_;
		}
		_tmp508_ = in_arg_map;
		_tmp509_ = m;
		_tmp510_ = instance;
		vala_map_set ((ValaMap*) _tmp508_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp509_), FALSE)), _tmp510_);
		_tmp511_ = out_arg_map;
		_tmp512_ = m;
		_tmp513_ = instance;
		vala_map_set ((ValaMap*) _tmp511_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp512_), FALSE)), _tmp513_);
	} else {
		gboolean _tmp514_ = FALSE;
		gboolean _tmp515_ = FALSE;
		ValaMethod* _tmp516_;
		_tmp516_ = m;
		if (_tmp516_ != NULL) {
			ValaMethod* _tmp517_;
			ValaMemberBinding _tmp518_;
			ValaMemberBinding _tmp519_;
			_tmp517_ = m;
			_tmp518_ = vala_method_get_binding (_tmp517_);
			_tmp519_ = _tmp518_;
			_tmp515_ = _tmp519_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp515_ = FALSE;
		}
		if (_tmp515_) {
			ValaMethod* _tmp520_;
			_tmp520_ = m;
			_tmp514_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp520_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp514_ = FALSE;
		}
		if (_tmp514_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp521_;
			ValaExpression* _tmp522_;
			ValaExpression* _tmp523_;
			ValaTargetValue* _tmp524_;
			ValaTargetValue* _tmp525_;
			ValaTargetValue* _tmp526_;
			gboolean _tmp527_ = FALSE;
			gboolean _tmp528_ = FALSE;
			ValaMemberAccess* _tmp529_;
			const gchar* _tmp530_;
			const gchar* _tmp531_;
			ValaTargetValue* _tmp553_;
			ValaCCodeExpression* _tmp554_;
			ValaCCodeExpression* _tmp555_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp556_;
			ValaSymbol* _tmp557_;
			ValaSymbol* _tmp558_;
			ValaStruct* _tmp559_;
			gboolean _tmp560_ = FALSE;
			ValaStruct* _tmp561_;
			gboolean _tmp569_;
			gboolean _tmp570_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_inner (_tmp521_);
			_tmp523_ = _tmp522_;
			_tmp524_ = vala_expression_get_target_value (_tmp523_);
			_tmp525_ = _tmp524_;
			_tmp526_ = _vala_target_value_ref0 (_tmp525_);
			instance_value = _tmp526_;
			_tmp529_ = ma;
			_tmp530_ = vala_member_access_get_member_name (_tmp529_);
			_tmp531_ = _tmp530_;
			if (g_strcmp0 (_tmp531_, "begin") == 0) {
				_tmp528_ = TRUE;
			} else {
				ValaMemberAccess* _tmp532_;
				const gchar* _tmp533_;
				const gchar* _tmp534_;
				_tmp532_ = ma;
				_tmp533_ = vala_member_access_get_member_name (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp528_ = g_strcmp0 (_tmp534_, "end") == 0;
			}
			if (_tmp528_) {
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaSymbol* _tmp538_;
				ValaSymbol* _tmp539_;
				ValaMemberAccess* _tmp540_;
				ValaSymbol* _tmp541_;
				ValaSymbol* _tmp542_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = vala_expression_get_symbol_reference (_tmp537_);
				_tmp539_ = _tmp538_;
				_tmp540_ = ma;
				_tmp541_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp540_);
				_tmp542_ = _tmp541_;
				_tmp527_ = _tmp539_ == _tmp542_;
			} else {
				_tmp527_ = FALSE;
			}
			if (_tmp527_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp543_;
				ValaExpression* _tmp544_;
				ValaExpression* _tmp545_;
				ValaMemberAccess* _tmp546_;
				ValaMemberAccess* _tmp547_;
				ValaExpression* _tmp548_;
				ValaExpression* _tmp549_;
				ValaTargetValue* _tmp550_;
				ValaTargetValue* _tmp551_;
				ValaTargetValue* _tmp552_;
				_tmp543_ = ma;
				_tmp544_ = vala_member_access_get_inner (_tmp543_);
				_tmp545_ = _tmp544_;
				_tmp546_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp545_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp546_;
				_tmp547_ = inner_ma;
				_tmp548_ = vala_member_access_get_inner (_tmp547_);
				_tmp549_ = _tmp548_;
				_tmp550_ = vala_expression_get_target_value (_tmp549_);
				_tmp551_ = _tmp550_;
				_tmp552_ = _vala_target_value_ref0 (_tmp551_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp552_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp553_ = instance_value;
			_tmp554_ = vala_get_cvalue_ (_tmp553_);
			_tmp555_ = _vala_ccode_node_ref0 (_tmp554_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp555_;
			_tmp556_ = m;
			_tmp557_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp556_);
			_tmp558_ = _tmp557_;
			_tmp559_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp558_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp558_) : NULL);
			st = _tmp559_;
			_tmp561_ = st;
			if (_tmp561_ != NULL) {
				ValaStruct* _tmp562_;
				_tmp562_ = st;
				_tmp560_ = !vala_struct_is_simple_type (_tmp562_);
			} else {
				_tmp560_ = FALSE;
			}
			if (_tmp560_) {
				ValaTargetValue* _tmp563_;
				ValaTargetValue* _tmp566_;
				ValaCCodeExpression* _tmp567_;
				ValaCCodeUnaryExpression* _tmp568_;
				_tmp563_ = instance_value;
				if (!vala_get_lvalue (_tmp563_)) {
					ValaTargetValue* _tmp564_;
					ValaTargetValue* _tmp565_;
					_tmp564_ = instance_value;
					_tmp565_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp564_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp565_;
				}
				_tmp566_ = instance_value;
				_tmp567_ = vala_get_cvalue_ (_tmp566_);
				_tmp568_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp567_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp568_;
			}
			_tmp569_ = vala_method_call_get_is_yield_expression (expr);
			_tmp570_ = _tmp569_;
			if (_tmp570_) {
				ValaHashMap* _tmp571_;
				ValaMethod* _tmp572_;
				ValaCCodeExpression* _tmp573_;
				ValaMethod* _tmp574_;
				_tmp571_ = in_arg_map;
				_tmp572_ = m;
				_tmp573_ = instance;
				vala_map_set ((ValaMap*) _tmp571_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp572_), FALSE)), _tmp573_);
				_tmp574_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp574_)) {
					ValaHashMap* _tmp575_;
					ValaMethod* _tmp576_;
					ValaCCodeExpression* _tmp577_;
					_tmp575_ = out_arg_map;
					_tmp576_ = m;
					_tmp577_ = instance;
					vala_map_set ((ValaMap*) _tmp575_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp576_), FALSE)), _tmp577_);
				}
			} else {
				gboolean _tmp578_ = FALSE;
				ValaMemberAccess* _tmp579_;
				const gchar* _tmp580_;
				const gchar* _tmp581_;
				_tmp579_ = ma;
				_tmp580_ = vala_member_access_get_member_name (_tmp579_);
				_tmp581_ = _tmp580_;
				if (g_strcmp0 (_tmp581_, "end") != 0) {
					_tmp578_ = TRUE;
				} else {
					ValaMethod* _tmp582_;
					_tmp582_ = m;
					_tmp578_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp582_);
				}
				if (_tmp578_) {
					ValaHashMap* _tmp583_;
					ValaMethod* _tmp584_;
					ValaCCodeExpression* _tmp585_;
					ValaHashMap* _tmp586_;
					ValaMethod* _tmp587_;
					ValaCCodeExpression* _tmp588_;
					_tmp583_ = out_arg_map;
					_tmp584_ = m;
					_tmp585_ = instance;
					vala_map_set ((ValaMap*) _tmp583_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp584_), FALSE)), _tmp585_);
					_tmp586_ = in_arg_map;
					_tmp587_ = m;
					_tmp588_ = instance;
					vala_map_set ((ValaMap*) _tmp586_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp587_), FALSE)), _tmp588_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp589_ = FALSE;
			ValaMethod* _tmp590_;
			_tmp590_ = m;
			if (_tmp590_ != NULL) {
				ValaMethod* _tmp591_;
				ValaMemberBinding _tmp592_;
				ValaMemberBinding _tmp593_;
				_tmp591_ = m;
				_tmp592_ = vala_method_get_binding (_tmp591_);
				_tmp593_ = _tmp592_;
				_tmp589_ = _tmp593_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp589_ = FALSE;
			}
			if (_tmp589_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp594_;
				ValaSymbol* _tmp595_;
				ValaSymbol* _tmp596_;
				ValaClass* _tmp597_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp598_;
				gchar* _tmp599_;
				gchar* _tmp600_;
				ValaCCodeIdentifier* _tmp601_;
				ValaCCodeIdentifier* _tmp602_;
				ValaCCodeFunctionCall* _tmp603_;
				ValaCCodeFunctionCall* _tmp604_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp605_;
				ValaExpression* _tmp606_;
				ValaExpression* _tmp607_;
				ValaCCodeFunctionCall* _tmp630_;
				ValaCCodeExpression* _tmp631_;
				ValaHashMap* _tmp632_;
				ValaMethod* _tmp633_;
				ValaCCodeFunctionCall* _tmp634_;
				ValaHashMap* _tmp635_;
				ValaMethod* _tmp636_;
				ValaCCodeFunctionCall* _tmp637_;
				_tmp594_ = m;
				_tmp595_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp594_);
				_tmp596_ = _tmp595_;
				_tmp597_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp596_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp597_;
				_tmp598_ = cl;
				_tmp599_ = vala_get_ccode_class_type_function (_tmp598_);
				_tmp600_ = _tmp599_;
				_tmp601_ = vala_ccode_identifier_new (_tmp600_);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp602_);
				_tmp604_ = _tmp603_;
				_vala_ccode_node_unref0 (_tmp602_);
				_g_free0 (_tmp600_);
				cast = _tmp604_;
				_tmp605_ = ma;
				_tmp606_ = vala_member_access_get_inner (_tmp605_);
				_tmp607_ = _tmp606_;
				if (_tmp607_ == NULL) {
					ValaDataType* _tmp608_;
					_tmp608_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp608_ == NULL) {
						ValaCCodeIdentifier* _tmp609_;
						_tmp609_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp609_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp610_;
						ValaCCodeIdentifier* _tmp611_;
						ValaCCodeFunctionCall* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeFunctionCall* _tmp614_;
						ValaCCodeExpression* _tmp615_;
						ValaCCodeExpression* _tmp616_;
						ValaCCodeFunctionCall* _tmp617_;
						ValaCCodeExpression* _tmp618_;
						_tmp610_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp611_ = _tmp610_;
						_tmp612_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp611_);
						_tmp613_ = _tmp612_;
						_vala_ccode_node_unref0 (_tmp611_);
						k = _tmp613_;
						_tmp614_ = k;
						_tmp615_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp616_ = _tmp615_;
						vala_ccode_function_call_add_argument (_tmp614_, _tmp616_);
						_vala_ccode_node_unref0 (_tmp616_);
						_tmp617_ = k;
						_tmp618_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp617_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp618_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp619_;
					ValaCCodeIdentifier* _tmp620_;
					ValaCCodeFunctionCall* _tmp621_;
					ValaCCodeFunctionCall* _tmp622_;
					ValaCCodeFunctionCall* _tmp623_;
					ValaMemberAccess* _tmp624_;
					ValaExpression* _tmp625_;
					ValaExpression* _tmp626_;
					ValaCCodeExpression* _tmp627_;
					ValaCCodeFunctionCall* _tmp628_;
					ValaCCodeExpression* _tmp629_;
					_tmp619_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp620_);
					_tmp622_ = _tmp621_;
					_vala_ccode_node_unref0 (_tmp620_);
					k = _tmp622_;
					_tmp623_ = k;
					_tmp624_ = ma;
					_tmp625_ = vala_member_access_get_inner (_tmp624_);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_get_cvalue (_tmp626_);
					vala_ccode_function_call_add_argument (_tmp623_, _tmp627_);
					_tmp628_ = k;
					_tmp629_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp628_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp629_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp630_ = cast;
				_tmp631_ = klass;
				vala_ccode_function_call_add_argument (_tmp630_, _tmp631_);
				_tmp632_ = in_arg_map;
				_tmp633_ = m;
				_tmp634_ = cast;
				vala_map_set ((ValaMap*) _tmp632_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp633_), FALSE)), (ValaCCodeExpression*) _tmp634_);
				_tmp635_ = out_arg_map;
				_tmp636_ = m;
				_tmp637_ = cast;
				vala_map_set ((ValaMap*) _tmp635_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp636_), FALSE)), (ValaCCodeExpression*) _tmp637_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp639_ = m;
	if (_tmp639_ != NULL) {
		ValaMethod* _tmp640_;
		_tmp640_ = m;
		_tmp638_ = vala_get_ccode_has_generic_type_parameter (_tmp640_);
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaMethod* _tmp641_;
		_tmp641_ = m;
		if (vala_method_has_type_parameters (_tmp641_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp642_;
				ValaList* _tmp643_;
				ValaList* _tmp644_;
				gint _type_arg_size = 0;
				ValaList* _tmp645_;
				gint _tmp646_;
				gint _tmp647_;
				gint _type_arg_index = 0;
				_tmp642_ = ma;
				_tmp643_ = vala_member_access_get_type_arguments (_tmp642_);
				_tmp644_ = _vala_iterable_ref0 (_tmp643_);
				_type_arg_list = _tmp644_;
				_tmp645_ = _type_arg_list;
				_tmp646_ = vala_collection_get_size ((ValaCollection*) _tmp645_);
				_tmp647_ = _tmp646_;
				_type_arg_size = _tmp647_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp648_;
					gpointer _tmp649_;
					gboolean _tmp650_ = FALSE;
					gboolean _tmp651_ = FALSE;
					gboolean _tmp652_ = FALSE;
					ValaMethod* _tmp653_;
					ValaHashMap* _tmp661_;
					ValaMethod* _tmp662_;
					ValaDataType* _tmp663_;
					gchar* _tmp664_;
					gchar* _tmp665_;
					ValaCCodeIdentifier* _tmp666_;
					ValaCCodeIdentifier* _tmp667_;
					gint _tmp668_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp648_ = _type_arg_list;
					_tmp649_ = vala_list_get (_tmp648_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp649_;
					_tmp653_ = m;
					if (vala_get_ccode_simple_generics (_tmp653_)) {
						ValaDataType* _tmp654_;
						_tmp654_ = type_arg;
						_tmp652_ = vala_data_type_is_real_struct_type (_tmp654_);
					} else {
						_tmp652_ = FALSE;
					}
					if (_tmp652_) {
						ValaDataType* _tmp655_;
						gboolean _tmp656_;
						gboolean _tmp657_;
						_tmp655_ = type_arg;
						_tmp656_ = vala_data_type_get_nullable (_tmp655_);
						_tmp657_ = _tmp656_;
						_tmp651_ = !_tmp657_;
					} else {
						_tmp651_ = FALSE;
					}
					if (_tmp651_) {
						ValaDataType* _tmp658_;
						_tmp658_ = type_arg;
						_tmp650_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp658_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp650_ = FALSE;
					}
					if (_tmp650_) {
						ValaDataType* _tmp659_;
						ValaPointerType* _tmp660_;
						_tmp659_ = type_arg;
						_tmp660_ = vala_pointer_type_new (_tmp659_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp660_;
					}
					_tmp661_ = in_arg_map;
					_tmp662_ = m;
					_tmp663_ = type_arg;
					_tmp664_ = vala_get_ccode_name ((ValaCodeNode*) _tmp663_);
					_tmp665_ = _tmp664_;
					_tmp666_ = vala_ccode_identifier_new (_tmp665_);
					_tmp667_ = _tmp666_;
					vala_map_set ((ValaMap*) _tmp661_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp662_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp667_);
					_vala_ccode_node_unref0 (_tmp667_);
					_g_free0 (_tmp665_);
					_tmp668_ = type_param_index;
					type_param_index = _tmp668_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp669_;
				ValaExpression* _tmp670_;
				ValaExpression* _tmp671_;
				ValaDataType* _tmp672_;
				ValaDataType* _tmp673_;
				ValaList* _tmp674_;
				ValaList* _tmp675_;
				gint _type_arg_size = 0;
				ValaList* _tmp676_;
				gint _tmp677_;
				gint _tmp678_;
				gint _type_arg_index = 0;
				_tmp669_ = ma;
				_tmp670_ = vala_member_access_get_inner (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_expression_get_value_type (_tmp671_);
				_tmp673_ = _tmp672_;
				_tmp674_ = vala_data_type_get_type_arguments (_tmp673_);
				_tmp675_ = _vala_iterable_ref0 (_tmp674_);
				_type_arg_list = _tmp675_;
				_tmp676_ = _type_arg_list;
				_tmp677_ = vala_collection_get_size ((ValaCollection*) _tmp676_);
				_tmp678_ = _tmp677_;
				_type_arg_size = _tmp678_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp679_;
					gpointer _tmp680_;
					ValaHashMap* _tmp681_;
					ValaMethod* _tmp682_;
					ValaDataType* _tmp683_;
					gchar* _tmp684_;
					gchar* _tmp685_;
					ValaCCodeIdentifier* _tmp686_;
					ValaCCodeIdentifier* _tmp687_;
					gint _tmp688_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp679_ = _type_arg_list;
					_tmp680_ = vala_list_get (_tmp679_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp680_;
					_tmp681_ = in_arg_map;
					_tmp682_ = m;
					_tmp683_ = type_arg;
					_tmp684_ = vala_get_ccode_name ((ValaCodeNode*) _tmp683_);
					_tmp685_ = _tmp684_;
					_tmp686_ = vala_ccode_identifier_new (_tmp685_);
					_tmp687_ = _tmp686_;
					vala_map_set ((ValaMap*) _tmp681_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp682_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp687_);
					_vala_ccode_node_unref0 (_tmp687_);
					_g_free0 (_tmp685_);
					_tmp688_ = type_param_index;
					type_param_index = _tmp688_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp689_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp689_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp690_;
		ValaExpression* _tmp691_;
		ValaExpression* _tmp692_;
		ValaDataType* _tmp693_;
		ValaDataType* _tmp694_;
		ValaArrayType* _tmp695_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp696_;
		ValaCCodeIdentifier* _tmp697_;
		ValaCCodeFunctionCall* _tmp698_;
		ValaCCodeFunctionCall* _tmp699_;
		ValaCCodeFunctionCall* _tmp700_;
		ValaArrayType* _tmp701_;
		ValaDataType* _tmp702_;
		ValaDataType* _tmp703_;
		gchar* _tmp704_;
		gchar* _tmp705_;
		ValaCCodeIdentifier* _tmp706_;
		ValaCCodeIdentifier* _tmp707_;
		ValaHashMap* _tmp708_;
		ValaCCodeFunctionCall* _tmp709_;
		_tmp690_ = ma;
		_tmp691_ = vala_member_access_get_inner (_tmp690_);
		_tmp692_ = _tmp691_;
		_tmp693_ = vala_expression_get_value_type (_tmp692_);
		_tmp694_ = _tmp693_;
		_tmp695_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp694_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp695_;
		_tmp696_ = vala_ccode_identifier_new ("sizeof");
		_tmp697_ = _tmp696_;
		_tmp698_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp697_);
		_tmp699_ = _tmp698_;
		_vala_ccode_node_unref0 (_tmp697_);
		csizeof = _tmp699_;
		_tmp700_ = csizeof;
		_tmp701_ = array_type;
		_tmp702_ = vala_array_type_get_element_type (_tmp701_);
		_tmp703_ = _tmp702_;
		_tmp704_ = vala_get_ccode_name ((ValaCodeNode*) _tmp703_);
		_tmp705_ = _tmp704_;
		_tmp706_ = vala_ccode_identifier_new (_tmp705_);
		_tmp707_ = _tmp706_;
		vala_ccode_function_call_add_argument (_tmp700_, (ValaCCodeExpression*) _tmp707_);
		_vala_ccode_node_unref0 (_tmp707_);
		_g_free0 (_tmp705_);
		_tmp708_ = in_arg_map;
		_tmp709_ = csizeof;
		vala_map_set ((ValaMap*) _tmp708_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp709_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp710_;
		_tmp710_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp710_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp711_;
			ValaMethod* _tmp712_;
			ValaMethod* _tmp713_;
			gint param_nr = 0;
			ValaMethod* _tmp775_;
			ValaCCodeBaseModuleEmitContext* _tmp776_;
			_tmp711_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp712_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp711_, (ValaSymbol*) _tmp712_);
			_tmp713_ = m;
			vala_method_clear_parameters (_tmp713_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp714_;
				ValaList* _tmp715_;
				gint _arg_size = 0;
				ValaList* _tmp716_;
				gint _tmp717_;
				gint _tmp718_;
				gint _arg_index = 0;
				_tmp714_ = vala_method_call_get_argument_list (expr);
				_tmp715_ = _vala_iterable_ref0 (_tmp714_);
				_arg_list = _tmp715_;
				_tmp716_ = _arg_list;
				_tmp717_ = vala_collection_get_size ((ValaCollection*) _tmp716_);
				_tmp718_ = _tmp717_;
				_arg_size = _tmp718_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp719_;
					gpointer _tmp720_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp721_;
					ValaUnaryExpression* _tmp722_;
					gboolean _tmp723_ = FALSE;
					ValaUnaryExpression* _tmp724_;
					gint _tmp765_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp719_ = _arg_list;
					_tmp720_ = vala_list_get (_tmp719_, _arg_index);
					arg = (ValaExpression*) _tmp720_;
					_tmp721_ = arg;
					_tmp722_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp721_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp721_) : NULL);
					unary = _tmp722_;
					_tmp724_ = unary;
					if (_tmp724_ != NULL) {
						ValaUnaryExpression* _tmp725_;
						ValaUnaryOperator _tmp726_;
						ValaUnaryOperator _tmp727_;
						_tmp725_ = unary;
						_tmp726_ = vala_unary_expression_get_operator (_tmp725_);
						_tmp727_ = _tmp726_;
						_tmp723_ = _tmp727_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp723_ = FALSE;
					}
					if (_tmp723_) {
						ValaParameter* param = NULL;
						gchar* _tmp728_;
						gchar* _tmp729_;
						ValaUnaryExpression* _tmp730_;
						ValaExpression* _tmp731_;
						ValaExpression* _tmp732_;
						ValaDataType* _tmp733_;
						ValaDataType* _tmp734_;
						ValaParameter* _tmp735_;
						ValaParameter* _tmp736_;
						ValaParameter* _tmp737_;
						ValaMethod* _tmp738_;
						ValaParameter* _tmp739_;
						_tmp728_ = g_strdup_printf ("param%d", param_nr);
						_tmp729_ = _tmp728_;
						_tmp730_ = unary;
						_tmp731_ = vala_unary_expression_get_inner (_tmp730_);
						_tmp732_ = _tmp731_;
						_tmp733_ = vala_expression_get_value_type (_tmp732_);
						_tmp734_ = _tmp733_;
						_tmp735_ = vala_parameter_new (_tmp729_, _tmp734_, NULL);
						_tmp736_ = _tmp735_;
						_g_free0 (_tmp729_);
						param = _tmp736_;
						_tmp737_ = param;
						vala_parameter_set_direction (_tmp737_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp738_ = m;
						_tmp739_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp738_, _tmp739_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp740_ = FALSE;
						ValaUnaryExpression* _tmp741_;
						_tmp741_ = unary;
						if (_tmp741_ != NULL) {
							ValaUnaryExpression* _tmp742_;
							ValaUnaryOperator _tmp743_;
							ValaUnaryOperator _tmp744_;
							_tmp742_ = unary;
							_tmp743_ = vala_unary_expression_get_operator (_tmp742_);
							_tmp744_ = _tmp743_;
							_tmp740_ = _tmp744_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp740_ = FALSE;
						}
						if (_tmp740_) {
							ValaParameter* param = NULL;
							gchar* _tmp745_;
							gchar* _tmp746_;
							ValaUnaryExpression* _tmp747_;
							ValaExpression* _tmp748_;
							ValaExpression* _tmp749_;
							ValaDataType* _tmp750_;
							ValaDataType* _tmp751_;
							ValaParameter* _tmp752_;
							ValaParameter* _tmp753_;
							ValaParameter* _tmp754_;
							ValaMethod* _tmp755_;
							ValaParameter* _tmp756_;
							_tmp745_ = g_strdup_printf ("param%d", param_nr);
							_tmp746_ = _tmp745_;
							_tmp747_ = unary;
							_tmp748_ = vala_unary_expression_get_inner (_tmp747_);
							_tmp749_ = _tmp748_;
							_tmp750_ = vala_expression_get_value_type (_tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = vala_parameter_new (_tmp746_, _tmp751_, NULL);
							_tmp753_ = _tmp752_;
							_g_free0 (_tmp746_);
							param = _tmp753_;
							_tmp754_ = param;
							vala_parameter_set_direction (_tmp754_, VALA_PARAMETER_DIRECTION_REF);
							_tmp755_ = m;
							_tmp756_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp755_, _tmp756_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp757_;
							gchar* _tmp758_;
							gchar* _tmp759_;
							ValaExpression* _tmp760_;
							ValaDataType* _tmp761_;
							ValaDataType* _tmp762_;
							ValaParameter* _tmp763_;
							ValaParameter* _tmp764_;
							_tmp757_ = m;
							_tmp758_ = g_strdup_printf ("param%d", param_nr);
							_tmp759_ = _tmp758_;
							_tmp760_ = arg;
							_tmp761_ = vala_expression_get_value_type (_tmp760_);
							_tmp762_ = _tmp761_;
							_tmp763_ = vala_parameter_new (_tmp759_, _tmp762_, NULL);
							_tmp764_ = _tmp763_;
							vala_callable_add_parameter ((ValaCallable*) _tmp757_, _tmp764_);
							_vala_code_node_unref0 (_tmp764_);
							_g_free0 (_tmp759_);
						}
					}
					_tmp765_ = param_nr;
					param_nr = _tmp765_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp766_;
				ValaList* _tmp767_;
				ValaList* _tmp768_;
				gint _param_size = 0;
				ValaList* _tmp769_;
				gint _tmp770_;
				gint _tmp771_;
				gint _param_index = 0;
				_tmp766_ = m;
				_tmp767_ = vala_callable_get_parameters ((ValaCallable*) _tmp766_);
				_tmp768_ = _vala_iterable_ref0 (_tmp767_);
				_param_list = _tmp768_;
				_tmp769_ = _param_list;
				_tmp770_ = vala_collection_get_size ((ValaCollection*) _tmp769_);
				_tmp771_ = _tmp770_;
				_param_size = _tmp771_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp772_;
					gpointer _tmp773_;
					ValaParameter* _tmp774_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp772_ = _param_list;
					_tmp773_ = vala_list_get (_tmp772_, _param_index);
					param = (ValaParameter*) _tmp773_;
					_tmp774_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp774_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp775_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp775_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp776_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp776_);
		} else {
			gboolean _tmp777_ = FALSE;
			gboolean _tmp778_ = FALSE;
			ValaMethod* _tmp779_;
			_tmp779_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp779_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp780_;
				ValaCodeContext* _tmp781_;
				ValaProfile _tmp782_;
				ValaProfile _tmp783_;
				_tmp780_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp781_ = _tmp780_;
				_tmp782_ = vala_code_context_get_profile (_tmp781_);
				_tmp783_ = _tmp782_;
				_tmp778_ = _tmp783_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp778_ = FALSE;
			}
			if (_tmp778_) {
				ValaMethod* _tmp784_;
				ValaSymbol* _tmp785_;
				ValaSymbol* _tmp786_;
				_tmp784_ = m;
				_tmp785_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp784_);
				_tmp786_ = _tmp785_;
				_tmp777_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp786_, VALA_TYPE_CLASS);
			} else {
				_tmp777_ = FALSE;
			}
			if (_tmp777_) {
				ValaCCodeFunction* _tmp787_;
				ValaCCodeFunction* _tmp788_;
				ValaCCodeExpression* _tmp789_;
				ValaCCodeExpression* _tmp790_;
				ValaCCodeFunctionCall* _tmp791_;
				ValaClass* _tmp792_;
				ValaClass* _tmp793_;
				gchar* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				ValaCCodeCastExpression* _tmp798_;
				ValaCCodeCastExpression* _tmp799_;
				ValaMethod* _tmp800_;
				ValaMethod* _tmp801_;
				ValaBlock* _tmp802_;
				ValaBlock* _tmp803_;
				gboolean _tmp804_;
				gboolean _tmp805_;
				gboolean _tmp832_ = FALSE;
				ValaClass* _tmp833_;
				ValaClass* _tmp834_;
				gboolean _tmp835_;
				gboolean _tmp836_;
				_tmp787_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp788_ = _tmp787_;
				_tmp789_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp790_ = _tmp789_;
				_tmp791_ = ccall;
				_tmp792_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_get_ccode_name ((ValaCodeNode*) _tmp793_);
				_tmp795_ = _tmp794_;
				_tmp796_ = g_strconcat (_tmp795_, "*", NULL);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp791_, _tmp797_);
				_tmp799_ = _tmp798_;
				vala_ccode_function_add_assignment (_tmp788_, _tmp790_, (ValaCCodeExpression*) _tmp799_);
				_vala_ccode_node_unref0 (_tmp799_);
				_g_free0 (_tmp797_);
				_g_free0 (_tmp795_);
				_vala_ccode_node_unref0 (_tmp790_);
				_tmp800_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp801_ = _tmp800_;
				_tmp802_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp801_);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_block_get_captured (_tmp803_);
				_tmp805_ = _tmp804_;
				if (_tmp805_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp806_;
					ValaClass* _tmp807_;
					ValaObjectType* _tmp808_;
					ValaObjectType* _tmp809_;
					ValaSourceReference* _tmp810_;
					ValaSourceReference* _tmp811_;
					ValaCCodeExpression* _tmp812_;
					ValaCCodeExpression* _tmp813_;
					ValaCCodeFunctionCall* _tmp814_;
					ValaCCodeFunctionCall* _tmp815_;
					ValaCCodeFunctionCall* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeFunction* _tmp819_;
					ValaCCodeFunction* _tmp820_;
					ValaMethod* _tmp821_;
					ValaMethod* _tmp822_;
					ValaBlock* _tmp823_;
					ValaBlock* _tmp824_;
					gchar* _tmp825_;
					gchar* _tmp826_;
					ValaCCodeExpression* _tmp827_;
					ValaCCodeExpression* _tmp828_;
					ValaCCodeMemberAccess* _tmp829_;
					ValaCCodeMemberAccess* _tmp830_;
					ValaCCodeFunctionCall* _tmp831_;
					_tmp806_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp807_ = _tmp806_;
					_tmp808_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp807_);
					_tmp809_ = _tmp808_;
					_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp809_, _tmp811_, FALSE);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_ccode_function_call_new (_tmp813_);
					_tmp815_ = _tmp814_;
					_vala_ccode_node_unref0 (_tmp813_);
					_vala_code_node_unref0 (_tmp809_);
					ref_call = _tmp815_;
					_tmp816_ = ref_call;
					_tmp817_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp818_ = _tmp817_;
					vala_ccode_function_call_add_argument (_tmp816_, _tmp818_);
					_vala_ccode_node_unref0 (_tmp818_);
					_tmp819_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp820_ = _tmp819_;
					_tmp821_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					_tmp823_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp822_);
					_tmp824_ = _tmp823_;
					_tmp825_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp824_));
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp826_);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_ccode_member_access_new_pointer (_tmp828_, "self");
					_tmp830_ = _tmp829_;
					_tmp831_ = ref_call;
					vala_ccode_function_add_assignment (_tmp820_, (ValaCCodeExpression*) _tmp830_, (ValaCCodeExpression*) _tmp831_);
					_vala_ccode_node_unref0 (_tmp830_);
					_vala_ccode_node_unref0 (_tmp828_);
					_g_free0 (_tmp826_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp833_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp834_ = _tmp833_;
				_tmp835_ = vala_class_get_is_compact (_tmp834_);
				_tmp836_ = _tmp835_;
				if (!_tmp836_) {
					ValaClass* _tmp837_;
					ValaClass* _tmp838_;
					_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp838_ = _tmp837_;
					_tmp832_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp838_);
				} else {
					_tmp832_ = FALSE;
				}
				if (_tmp832_) {
					gchar** suffices = NULL;
					gchar* _tmp839_;
					gchar* _tmp840_;
					gchar* _tmp841_;
					gchar** _tmp842_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp839_ = g_strdup ("type");
					_tmp840_ = g_strdup ("dup_func");
					_tmp841_ = g_strdup ("destroy_func");
					_tmp842_ = g_new0 (gchar*, 3 + 1);
					_tmp842_[0] = _tmp839_;
					_tmp842_[1] = _tmp840_;
					_tmp842_[2] = _tmp841_;
					suffices = _tmp842_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp843_;
						ValaClass* _tmp844_;
						ValaList* _tmp845_;
						ValaList* _tmp846_;
						gint _type_param_size = 0;
						ValaList* _tmp847_;
						gint _tmp848_;
						gint _tmp849_;
						gint _type_param_index = 0;
						_tmp843_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp844_ = _tmp843_;
						_tmp845_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp844_);
						_tmp846_ = _vala_iterable_ref0 (_tmp845_);
						_type_param_list = _tmp846_;
						_tmp847_ = _type_param_list;
						_tmp848_ = vala_collection_get_size ((ValaCollection*) _tmp847_);
						_tmp849_ = _tmp848_;
						_type_param_size = _tmp849_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp850_;
							gpointer _tmp851_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp852_;
							ValaCCodeIdentifier* _tmp853_;
							ValaCCodeMemberAccess* _tmp854_;
							ValaCCodeMemberAccess* _tmp855_;
							gchar** _tmp856_;
							gint _tmp856__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp850_ = _type_param_list;
							_tmp851_ = vala_list_get (_tmp850_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp851_;
							_tmp852_ = vala_ccode_identifier_new ("self");
							_tmp853_ = _tmp852_;
							_tmp854_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp853_, "priv");
							_tmp855_ = _tmp854_;
							_vala_ccode_node_unref0 (_tmp853_);
							priv_access = _tmp855_;
							_tmp856_ = suffices;
							_tmp856__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp856_;
								suffix_collection_length1 = _tmp856__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp857_;
									gchar* suffix = NULL;
									_tmp857_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp857_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp858_;
										const gchar* _tmp859_;
										const gchar* _tmp860_;
										gchar* _tmp861_;
										gchar* _tmp862_;
										const gchar* _tmp863_;
										gchar* _tmp864_;
										gchar* _tmp865_;
										ValaCCodeIdentifier* _tmp866_;
										ValaCCodeIdentifier* _tmp867_;
										ValaCCodeFunction* _tmp868_;
										ValaCCodeFunction* _tmp869_;
										ValaCCodeMemberAccess* _tmp870_;
										ValaCCodeIdentifier* _tmp871_;
										const gchar* _tmp872_;
										const gchar* _tmp873_;
										ValaCCodeMemberAccess* _tmp874_;
										ValaCCodeMemberAccess* _tmp875_;
										ValaCCodeIdentifier* _tmp876_;
										_tmp858_ = type_param;
										_tmp859_ = vala_symbol_get_name ((ValaSymbol*) _tmp858_);
										_tmp860_ = _tmp859_;
										_tmp861_ = g_utf8_strdown (_tmp860_, (gssize) -1);
										_tmp862_ = _tmp861_;
										_tmp863_ = suffix;
										_tmp864_ = g_strdup_printf ("%s_%s", _tmp862_, _tmp863_);
										_tmp865_ = _tmp864_;
										_tmp866_ = vala_ccode_identifier_new (_tmp865_);
										_tmp867_ = _tmp866_;
										_g_free0 (_tmp865_);
										_g_free0 (_tmp862_);
										param_name = _tmp867_;
										_tmp868_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp869_ = _tmp868_;
										_tmp870_ = priv_access;
										_tmp871_ = param_name;
										_tmp872_ = vala_ccode_identifier_get_name (_tmp871_);
										_tmp873_ = _tmp872_;
										_tmp874_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp870_, _tmp873_);
										_tmp875_ = _tmp874_;
										_tmp876_ = param_name;
										vala_ccode_function_add_assignment (_tmp869_, (ValaCCodeExpression*) _tmp875_, (ValaCCodeExpression*) _tmp876_);
										_vala_ccode_node_unref0 (_tmp875_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp877_ = params;
	_tmp878_ = vala_iterable_iterator ((ValaIterable*) _tmp877_);
	params_it = _tmp878_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp879_;
		ValaList* _tmp880_;
		gint _arg_size = 0;
		ValaList* _tmp881_;
		gint _tmp882_;
		gint _tmp883_;
		gint _arg_index = 0;
		_tmp879_ = vala_method_call_get_argument_list (expr);
		_tmp880_ = _vala_iterable_ref0 (_tmp879_);
		_arg_list = _tmp880_;
		_tmp881_ = _arg_list;
		_tmp882_ = vala_collection_get_size ((ValaCollection*) _tmp881_);
		_tmp883_ = _tmp882_;
		_arg_size = _tmp883_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp884_;
			gpointer _tmp885_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp886_;
			ValaCCodeExpression* _tmp887_;
			ValaCCodeExpression* _tmp888_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp889_;
			ValaHashMap* _tmp890_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp891_;
			gboolean _tmp901_ = FALSE;
			ValaParameter* _tmp902_;
			gdouble _tmp1247_ = 0.0;
			ValaParameter* _tmp1248_;
			ValaHashMap* _tmp1250_;
			ValaCCodeExpression* _tmp1251_;
			gboolean _tmp1252_ = FALSE;
			ValaMethod* _tmp1253_;
			gboolean _tmp1278_ = FALSE;
			ValaExpression* _tmp1279_;
			gint _tmp1296_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp884_ = _arg_list;
			_tmp885_ = vala_list_get (_tmp884_, _arg_index);
			arg = (ValaExpression*) _tmp885_;
			_tmp886_ = arg;
			_tmp887_ = vala_get_cvalue (_tmp886_);
			_tmp888_ = _vala_ccode_node_ref0 (_tmp887_);
			cexpr = _tmp888_;
			_tmp889_ = in_arg_map;
			_tmp890_ = _vala_map_ref0 (_tmp889_);
			carg_map = _tmp890_;
			param = NULL;
			_tmp891_ = params_it;
			if (vala_iterator_next (_tmp891_)) {
				ValaIterator* _tmp892_;
				gpointer _tmp893_;
				gboolean _tmp894_ = FALSE;
				ValaParameter* _tmp895_;
				gboolean _tmp896_;
				gboolean _tmp897_;
				_tmp892_ = params_it;
				_tmp893_ = vala_iterator_get (_tmp892_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp893_;
				_tmp895_ = param;
				_tmp896_ = vala_parameter_get_params_array (_tmp895_);
				_tmp897_ = _tmp896_;
				if (_tmp897_) {
					_tmp894_ = TRUE;
				} else {
					ValaParameter* _tmp898_;
					gboolean _tmp899_;
					gboolean _tmp900_;
					_tmp898_ = param;
					_tmp899_ = vala_parameter_get_ellipsis (_tmp898_);
					_tmp900_ = _tmp899_;
					_tmp894_ = _tmp900_;
				}
				ellipsis = _tmp894_;
			}
			_tmp902_ = param;
			if (_tmp902_ != NULL) {
				_tmp901_ = !ellipsis;
			} else {
				_tmp901_ = FALSE;
			}
			if (_tmp901_) {
				ValaParameter* _tmp903_;
				ValaParameterDirection _tmp904_;
				ValaParameterDirection _tmp905_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp908_;
				ValaUnaryExpression* _tmp909_;
				gboolean _tmp910_ = FALSE;
				ValaUnaryExpression* _tmp911_;
				ValaParameter* _tmp1177_;
				gchar* _tmp1178_;
				gchar* _tmp1179_;
				gboolean _tmp1180_;
				_tmp903_ = param;
				_tmp904_ = vala_parameter_get_direction (_tmp903_);
				_tmp905_ = _tmp904_;
				if (_tmp905_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp906_;
					ValaHashMap* _tmp907_;
					_tmp906_ = out_arg_map;
					_tmp907_ = _vala_map_ref0 (_tmp906_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp907_;
				}
				_tmp908_ = arg;
				_tmp909_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp908_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp908_) : NULL);
				unary = _tmp909_;
				_tmp911_ = unary;
				if (_tmp911_ == NULL) {
					_tmp910_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp912_;
					ValaUnaryOperator _tmp913_;
					ValaUnaryOperator _tmp914_;
					_tmp912_ = unary;
					_tmp913_ = vala_unary_expression_get_operator (_tmp912_);
					_tmp914_ = _tmp913_;
					_tmp910_ = _tmp914_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp910_) {
					gboolean _tmp915_ = FALSE;
					gboolean _tmp916_ = FALSE;
					ValaParameter* _tmp917_;
					ValaParameter* _tmp1053_;
					ValaExpression* _tmp1054_;
					ValaCCodeExpression* _tmp1055_;
					ValaCCodeExpression* _tmp1056_;
					_tmp917_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp917_)) {
						ValaParameter* _tmp918_;
						ValaDataType* _tmp919_;
						ValaDataType* _tmp920_;
						_tmp918_ = param;
						_tmp919_ = vala_variable_get_variable_type ((ValaVariable*) _tmp918_);
						_tmp920_ = _tmp919_;
						_tmp916_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp920_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp916_ = FALSE;
					}
					if (_tmp916_) {
						ValaParameter* _tmp921_;
						ValaDataType* _tmp922_;
						ValaDataType* _tmp923_;
						gboolean _tmp924_;
						gboolean _tmp925_;
						_tmp921_ = param;
						_tmp922_ = vala_variable_get_variable_type ((ValaVariable*) _tmp921_);
						_tmp923_ = _tmp922_;
						_tmp924_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp923_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp925_ = _tmp924_;
						_tmp915_ = !_tmp925_;
					} else {
						_tmp915_ = FALSE;
					}
					if (_tmp915_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp926_;
						ValaDataType* _tmp927_;
						ValaDataType* _tmp928_;
						ValaArrayType* _tmp929_;
						gchar* _tmp930_ = NULL;
						ValaParameter* _tmp931_;
						gchar* _tmp932_;
						gchar* length_ctype = NULL;
						gchar* _tmp935_;
						gboolean _tmp936_ = FALSE;
						ValaUnaryExpression* _tmp937_;
						_tmp926_ = param;
						_tmp927_ = vala_variable_get_variable_type ((ValaVariable*) _tmp926_);
						_tmp928_ = _tmp927_;
						_tmp929_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp928_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp929_;
						_tmp931_ = param;
						_tmp932_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp931_);
						_tmp930_ = _tmp932_;
						if (_tmp930_ == NULL) {
							ValaArrayType* _tmp933_;
							gchar* _tmp934_;
							_tmp933_ = array_type;
							_tmp934_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp933_);
							_g_free0 (_tmp930_);
							_tmp930_ = _tmp934_;
						}
						_tmp935_ = _tmp930_;
						_tmp930_ = NULL;
						length_ctype = _tmp935_;
						_tmp937_ = unary;
						if (_tmp937_ != NULL) {
							ValaUnaryExpression* _tmp938_;
							ValaUnaryOperator _tmp939_;
							ValaUnaryOperator _tmp940_;
							_tmp938_ = unary;
							_tmp939_ = vala_unary_expression_get_operator (_tmp938_);
							_tmp940_ = _tmp939_;
							_tmp936_ = _tmp940_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp936_ = FALSE;
						}
						if (_tmp936_) {
							const gchar* _tmp941_;
							gchar* _tmp942_;
							_tmp941_ = length_ctype;
							_tmp942_ = g_strdup_printf ("%s*", _tmp941_);
							_g_free0 (length_ctype);
							length_ctype = _tmp942_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp943_ = FALSE;
								_tmp943_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp945_;
									gint _tmp946_;
									gint _tmp947_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp948_;
									ValaCCodeExpression* _tmp949_;
									ValaCCodeExpression* _tmp950_;
									const gchar* _tmp951_;
									ValaCCodeCastExpression* _tmp952_;
									ValaCCodeCastExpression* _tmp953_;
									ValaHashMap* _tmp954_;
									ValaParameter* _tmp955_;
									ValaCCodeCastExpression* _tmp956_;
									if (!_tmp943_) {
										gint _tmp944_;
										_tmp944_ = dim;
										dim = _tmp944_ + 1;
									}
									_tmp943_ = FALSE;
									_tmp945_ = array_type;
									_tmp946_ = vala_array_type_get_rank (_tmp945_);
									_tmp947_ = _tmp946_;
									if (!(dim <= _tmp947_)) {
										break;
									}
									_tmp948_ = arg;
									_tmp949_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp948_, dim);
									_tmp950_ = _tmp949_;
									_tmp951_ = length_ctype;
									_tmp952_ = vala_ccode_cast_expression_new (_tmp950_, _tmp951_);
									_tmp953_ = _tmp952_;
									_vala_ccode_node_unref0 (_tmp950_);
									array_length_expr = _tmp953_;
									_tmp954_ = carg_map;
									_tmp955_ = param;
									_tmp956_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp954_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp955_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp956_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp930_);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp957_ = FALSE;
						ValaParameter* _tmp958_;
						_tmp958_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp958_)) {
							ValaParameter* _tmp959_;
							ValaDataType* _tmp960_;
							ValaDataType* _tmp961_;
							_tmp959_ = param;
							_tmp960_ = vala_variable_get_variable_type ((ValaVariable*) _tmp959_);
							_tmp961_ = _tmp960_;
							_tmp957_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp961_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp957_ = FALSE;
						}
						if (_tmp957_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp962_;
							ValaDataType* _tmp963_;
							ValaDataType* _tmp964_;
							ValaDelegateType* _tmp965_;
							ValaDelegateType* _tmp966_;
							ValaDelegate* _tmp967_;
							ValaDelegate* _tmp968_;
							gboolean _tmp969_;
							gboolean _tmp970_;
							_tmp962_ = param;
							_tmp963_ = vala_variable_get_variable_type ((ValaVariable*) _tmp962_);
							_tmp964_ = _tmp963_;
							_tmp965_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp964_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp965_;
							_tmp966_ = deleg_type;
							_tmp967_ = vala_delegate_type_get_delegate_symbol (_tmp966_);
							_tmp968_ = _tmp967_;
							_tmp969_ = vala_delegate_get_has_target (_tmp968_);
							_tmp970_ = _tmp969_;
							if (_tmp970_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp971_;
								ValaCCodeExpression* _tmp972_ = NULL;
								ValaCCodeExpression* _tmp973_;
								ValaCCodeExpression* _tmp974_;
								ValaParameter* _tmp975_;
								gchar* _tmp976_;
								gchar* _tmp977_;
								gboolean _tmp978_;
								_tmp971_ = arg;
								_tmp973_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp971_, &_tmp972_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp972_;
								delegate_target = _tmp973_;
								_tmp974_ = delegate_target;
								_vala_assert (_tmp974_ != NULL, "delegate_target != null");
								_tmp975_ = param;
								_tmp976_ = vala_get_ccode_type ((ValaCodeNode*) _tmp975_);
								_tmp977_ = _tmp976_;
								_tmp978_ = g_strcmp0 (_tmp977_, "GClosure*") == 0;
								_g_free0 (_tmp977_);
								if (_tmp978_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp979_;
									ValaCCodeIdentifier* _tmp980_;
									ValaCCodeFunctionCall* _tmp981_;
									ValaCCodeFunctionCall* _tmp982_;
									ValaCCodeFunctionCall* _tmp983_;
									ValaCCodeExpression* _tmp984_;
									ValaCCodeCastExpression* _tmp985_;
									ValaCCodeCastExpression* _tmp986_;
									ValaCCodeFunctionCall* _tmp987_;
									ValaCCodeExpression* _tmp988_;
									ValaCCodeFunctionCall* _tmp989_;
									ValaCCodeExpression* _tmp990_;
									ValaCCodeCastExpression* _tmp991_;
									ValaCCodeCastExpression* _tmp992_;
									ValaCCodeExpression* _tmp993_;
									ValaCCodeIdentifier* _tmp994_;
									ValaCCodeIdentifier* _tmp995_;
									ValaCCodeBinaryExpression* _tmp996_;
									ValaCCodeBinaryExpression* _tmp997_;
									ValaCCodeIdentifier* _tmp998_;
									ValaCCodeIdentifier* _tmp999_;
									ValaCCodeFunctionCall* _tmp1000_;
									ValaCCodeConditionalExpression* _tmp1001_;
									_tmp979_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp980_ = _tmp979_;
									_tmp981_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp980_);
									_tmp982_ = _tmp981_;
									_vala_ccode_node_unref0 (_tmp980_);
									closure_new = _tmp982_;
									_tmp983_ = closure_new;
									_tmp984_ = cexpr;
									_tmp985_ = vala_ccode_cast_expression_new (_tmp984_, "GCallback");
									_tmp986_ = _tmp985_;
									vala_ccode_function_call_add_argument (_tmp983_, (ValaCCodeExpression*) _tmp986_);
									_vala_ccode_node_unref0 (_tmp986_);
									_tmp987_ = closure_new;
									_tmp988_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp987_, _tmp988_);
									_tmp989_ = closure_new;
									_tmp990_ = delegate_target_destroy_notify;
									_tmp991_ = vala_ccode_cast_expression_new (_tmp990_, "GClosureNotify");
									_tmp992_ = _tmp991_;
									vala_ccode_function_call_add_argument (_tmp989_, (ValaCCodeExpression*) _tmp992_);
									_vala_ccode_node_unref0 (_tmp992_);
									_tmp993_ = cexpr;
									_tmp994_ = vala_ccode_identifier_new ("NULL");
									_tmp995_ = _tmp994_;
									_tmp996_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp993_, (ValaCCodeExpression*) _tmp995_);
									_tmp997_ = _tmp996_;
									_tmp998_ = vala_ccode_identifier_new ("NULL");
									_tmp999_ = _tmp998_;
									_tmp1000_ = closure_new;
									_tmp1001_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp997_, (ValaCCodeExpression*) _tmp999_, (ValaCCodeExpression*) _tmp1000_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1001_;
									_vala_ccode_node_unref0 (_tmp999_);
									_vala_ccode_node_unref0 (_tmp997_);
									_vala_ccode_node_unref0 (_tmp995_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1002_;
									ValaParameter* _tmp1003_;
									ValaCCodeExpression* _tmp1004_;
									ValaDelegateType* _tmp1005_;
									_tmp1002_ = carg_map;
									_tmp1003_ = param;
									_tmp1004_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1002_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1003_), FALSE)), _tmp1004_);
									_tmp1005_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1005_)) {
										ValaCCodeExpression* _tmp1006_;
										ValaHashMap* _tmp1007_;
										ValaParameter* _tmp1008_;
										ValaCCodeExpression* _tmp1009_;
										_tmp1006_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1006_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1007_ = carg_map;
										_tmp1008_ = param;
										_tmp1009_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1007_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1008_) + 0.01, FALSE)), _tmp1009_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1010_;
							ValaDataType* _tmp1011_;
							ValaDataType* _tmp1012_;
							_tmp1010_ = param;
							_tmp1011_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1010_);
							_tmp1012_ = _tmp1011_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1012_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1013_;
								ValaParameter* _tmp1014_;
								ValaExpression* _tmp1015_;
								ValaCCodeExpression* _tmp1016_ = NULL;
								ValaCCodeExpression* _tmp1017_;
								ValaCCodeExpression* _tmp1018_;
								_tmp1013_ = carg_map;
								_tmp1014_ = param;
								_tmp1015_ = arg;
								_tmp1017_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1015_, &_tmp1016_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1016_;
								_tmp1018_ = _tmp1017_;
								vala_map_set ((ValaMap*) _tmp1013_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1014_), FALSE)), _tmp1018_);
								_vala_ccode_node_unref0 (_tmp1018_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1019_;
								ValaDataType* _tmp1020_;
								ValaDataType* _tmp1021_;
								_tmp1019_ = param;
								_tmp1020_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1019_);
								_tmp1021_ = _tmp1020_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1021_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1022_ = FALSE;
									ValaMethod* _tmp1023_;
									_tmp1023_ = m;
									if (_tmp1023_ != NULL) {
										ValaMethod* _tmp1024_;
										_tmp1024_ = m;
										_tmp1022_ = vala_get_ccode_simple_generics (_tmp1024_);
									} else {
										_tmp1022_ = FALSE;
									}
									if (_tmp1022_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1025_;
										ValaDataType* _tmp1026_;
										ValaDataType* _tmp1027_;
										ValaGenericType* _tmp1028_;
										gint type_param_index = 0;
										ValaMethod* _tmp1029_;
										ValaGenericType* _tmp1030_;
										ValaTypeParameter* _tmp1031_;
										ValaTypeParameter* _tmp1032_;
										const gchar* _tmp1033_;
										const gchar* _tmp1034_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1035_;
										ValaList* _tmp1036_;
										gpointer _tmp1037_;
										ValaParameter* _tmp1038_;
										ValaDataType* _tmp1039_;
										ValaDataType* _tmp1040_;
										gboolean _tmp1041_;
										gboolean _tmp1042_;
										_tmp1025_ = param;
										_tmp1026_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1025_);
										_tmp1027_ = _tmp1026_;
										_tmp1028_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1027_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1028_;
										_tmp1029_ = m;
										_tmp1030_ = generic_type;
										_tmp1031_ = vala_generic_type_get_type_parameter (_tmp1030_);
										_tmp1032_ = _tmp1031_;
										_tmp1033_ = vala_symbol_get_name ((ValaSymbol*) _tmp1032_);
										_tmp1034_ = _tmp1033_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1029_, _tmp1034_);
										_tmp1035_ = ma;
										_tmp1036_ = vala_member_access_get_type_arguments (_tmp1035_);
										_tmp1037_ = vala_list_get (_tmp1036_, type_param_index);
										type_arg = (ValaDataType*) _tmp1037_;
										_tmp1038_ = param;
										_tmp1039_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1038_);
										_tmp1040_ = _tmp1039_;
										_tmp1041_ = vala_data_type_get_value_owned (_tmp1040_);
										_tmp1042_ = _tmp1041_;
										if (_tmp1042_) {
											ValaDataType* _tmp1043_;
											_tmp1043_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1043_)) {
												ValaHashMap* _tmp1044_;
												ValaParameter* _tmp1045_;
												ValaDataType* _tmp1046_;
												ValaCCodeExpression* _tmp1047_;
												ValaCCodeExpression* _tmp1048_;
												_tmp1044_ = carg_map;
												_tmp1045_ = param;
												_tmp1046_ = type_arg;
												_tmp1047_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1046_, FALSE);
												_tmp1048_ = _tmp1047_;
												vala_map_set ((ValaMap*) _tmp1044_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1045_), FALSE)), _tmp1048_);
												_vala_ccode_node_unref0 (_tmp1048_);
											} else {
												ValaHashMap* _tmp1049_;
												ValaParameter* _tmp1050_;
												ValaCCodeConstant* _tmp1051_;
												ValaCCodeConstant* _tmp1052_;
												_tmp1049_ = carg_map;
												_tmp1050_ = param;
												_tmp1051_ = vala_ccode_constant_new ("NULL");
												_tmp1052_ = _tmp1051_;
												vala_map_set ((ValaMap*) _tmp1049_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1050_), FALSE)), (ValaCCodeExpression*) _tmp1052_);
												_vala_ccode_node_unref0 (_tmp1052_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1053_ = param;
					_tmp1054_ = arg;
					_tmp1055_ = cexpr;
					_tmp1056_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1053_, _tmp1054_, _tmp1055_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1056_;
				} else {
					ValaExpression* _tmp1057_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1058_;
					ValaDataType* _tmp1059_;
					ValaDataType* _tmp1060_;
					ValaParameter* _tmp1061_;
					ValaDataType* _tmp1062_;
					ValaDataType* _tmp1063_;
					gboolean _tmp1064_;
					gboolean _tmp1065_;
					ValaLocalVariable* _tmp1066_;
					ValaLocalVariable* _tmp1067_;
					ValaExpression* _tmp1068_;
					ValaLocalVariable* _tmp1069_;
					const gchar* _tmp1070_;
					const gchar* _tmp1071_;
					ValaCCodeExpression* _tmp1072_;
					ValaCCodeExpression* _tmp1073_;
					ValaExpression* _tmp1074_;
					ValaTargetValue* _tmp1075_;
					ValaTargetValue* _tmp1076_;
					ValaExpression* _tmp1077_;
					ValaDataType* _tmp1078_;
					ValaDataType* _tmp1079_;
					ValaExpression* _tmp1080_;
					ValaCCodeExpression* _tmp1081_;
					ValaCCodeUnaryExpression* _tmp1082_;
					gboolean _tmp1083_ = FALSE;
					gboolean _tmp1084_ = FALSE;
					ValaParameter* _tmp1085_;
					_tmp1057_ = arg;
					vala_expression_set_target_value (_tmp1057_, NULL);
					_tmp1058_ = param;
					_tmp1059_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1058_);
					_tmp1060_ = _tmp1059_;
					_tmp1061_ = param;
					_tmp1062_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1061_);
					_tmp1063_ = _tmp1062_;
					_tmp1064_ = vala_data_type_get_value_owned (_tmp1063_);
					_tmp1065_ = _tmp1064_;
					_tmp1066_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1060_, _tmp1065_, NULL, TRUE);
					temp_var = _tmp1066_;
					_tmp1067_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1067_, FALSE);
					_tmp1068_ = arg;
					_tmp1069_ = temp_var;
					_tmp1070_ = vala_symbol_get_name ((ValaSymbol*) _tmp1069_);
					_tmp1071_ = _tmp1070_;
					_tmp1072_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1071_);
					_tmp1073_ = _tmp1072_;
					vala_set_cvalue (_tmp1068_, _tmp1073_);
					_vala_ccode_node_unref0 (_tmp1073_);
					_tmp1074_ = arg;
					_tmp1075_ = vala_expression_get_target_value (_tmp1074_);
					_tmp1076_ = _tmp1075_;
					_tmp1077_ = arg;
					_tmp1078_ = vala_expression_get_target_type (_tmp1077_);
					_tmp1079_ = _tmp1078_;
					vala_target_value_set_value_type (_tmp1076_, _tmp1079_);
					_tmp1080_ = arg;
					_tmp1081_ = vala_get_cvalue (_tmp1080_);
					_tmp1082_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1081_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1082_;
					_tmp1085_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1085_)) {
						ValaParameter* _tmp1086_;
						ValaDataType* _tmp1087_;
						ValaDataType* _tmp1088_;
						_tmp1086_ = param;
						_tmp1087_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1086_);
						_tmp1088_ = _tmp1087_;
						_tmp1084_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1088_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1084_ = FALSE;
					}
					if (_tmp1084_) {
						ValaParameter* _tmp1089_;
						ValaDataType* _tmp1090_;
						ValaDataType* _tmp1091_;
						gboolean _tmp1092_;
						gboolean _tmp1093_;
						_tmp1089_ = param;
						_tmp1090_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1089_);
						_tmp1091_ = _tmp1090_;
						_tmp1092_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1091_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1093_ = _tmp1092_;
						_tmp1083_ = !_tmp1093_;
					} else {
						_tmp1083_ = FALSE;
					}
					if (_tmp1083_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1094_;
						ValaDataType* _tmp1095_;
						ValaDataType* _tmp1096_;
						ValaArrayType* _tmp1097_;
						gchar* _tmp1098_ = NULL;
						ValaParameter* _tmp1099_;
						gchar* _tmp1100_;
						gchar* length_ctype = NULL;
						gchar* _tmp1103_;
						_tmp1094_ = param;
						_tmp1095_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1094_);
						_tmp1096_ = _tmp1095_;
						_tmp1097_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1096_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1097_;
						_tmp1099_ = param;
						_tmp1100_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1099_);
						_tmp1098_ = _tmp1100_;
						if (_tmp1098_ == NULL) {
							ValaArrayType* _tmp1101_;
							gchar* _tmp1102_;
							_tmp1101_ = array_type;
							_tmp1102_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1101_);
							_g_free0 (_tmp1098_);
							_tmp1098_ = _tmp1102_;
						}
						_tmp1103_ = _tmp1098_;
						_tmp1098_ = NULL;
						length_ctype = _tmp1103_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1104_ = FALSE;
								_tmp1104_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1106_;
									gint _tmp1107_;
									gint _tmp1108_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1109_;
									ValaCType* _tmp1110_;
									ValaCType* _tmp1111_;
									ValaLocalVariable* _tmp1112_;
									ValaLocalVariable* _tmp1113_;
									ValaLocalVariable* _tmp1114_;
									ValaExpression* _tmp1115_;
									ValaLocalVariable* _tmp1116_;
									const gchar* _tmp1117_;
									const gchar* _tmp1118_;
									ValaCCodeExpression* _tmp1119_;
									ValaCCodeExpression* _tmp1120_;
									ValaHashMap* _tmp1121_;
									ValaParameter* _tmp1122_;
									ValaExpression* _tmp1123_;
									ValaList* _tmp1124_;
									gpointer _tmp1125_;
									ValaCCodeExpression* _tmp1126_;
									ValaCCodeUnaryExpression* _tmp1127_;
									ValaCCodeUnaryExpression* _tmp1128_;
									if (!_tmp1104_) {
										gint _tmp1105_;
										_tmp1105_ = dim;
										dim = _tmp1105_ + 1;
									}
									_tmp1104_ = FALSE;
									_tmp1106_ = array_type;
									_tmp1107_ = vala_array_type_get_rank (_tmp1106_);
									_tmp1108_ = _tmp1107_;
									if (!(dim <= _tmp1108_)) {
										break;
									}
									_tmp1109_ = length_ctype;
									_tmp1110_ = vala_ctype_new (_tmp1109_, "0");
									_tmp1111_ = _tmp1110_;
									_tmp1112_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1111_, TRUE, NULL, TRUE);
									_tmp1113_ = _tmp1112_;
									_vala_code_node_unref0 (_tmp1111_);
									temp_array_length = _tmp1113_;
									_tmp1114_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1114_, FALSE);
									_tmp1115_ = arg;
									_tmp1116_ = temp_array_length;
									_tmp1117_ = vala_symbol_get_name ((ValaSymbol*) _tmp1116_);
									_tmp1118_ = _tmp1117_;
									_tmp1119_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1118_);
									_tmp1120_ = _tmp1119_;
									vala_append_array_length (_tmp1115_, _tmp1120_);
									_vala_ccode_node_unref0 (_tmp1120_);
									_tmp1121_ = carg_map;
									_tmp1122_ = param;
									_tmp1123_ = arg;
									_tmp1124_ = vala_get_array_lengths (_tmp1123_);
									_tmp1125_ = vala_list_get (_tmp1124_, dim - 1);
									_tmp1126_ = (ValaCCodeExpression*) _tmp1125_;
									_tmp1127_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1126_);
									_tmp1128_ = _tmp1127_;
									vala_map_set ((ValaMap*) _tmp1121_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1122_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1128_);
									_vala_ccode_node_unref0 (_tmp1128_);
									_vala_ccode_node_unref0 (_tmp1126_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp1098_);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1129_ = FALSE;
						ValaParameter* _tmp1130_;
						_tmp1130_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1130_)) {
							ValaParameter* _tmp1131_;
							ValaDataType* _tmp1132_;
							ValaDataType* _tmp1133_;
							_tmp1131_ = param;
							_tmp1132_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1131_);
							_tmp1133_ = _tmp1132_;
							_tmp1129_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1133_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1129_ = FALSE;
						}
						if (_tmp1129_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1134_;
							ValaDataType* _tmp1135_;
							ValaDataType* _tmp1136_;
							ValaDelegateType* _tmp1137_;
							ValaDelegateType* _tmp1138_;
							ValaDelegate* _tmp1139_;
							ValaDelegate* _tmp1140_;
							gboolean _tmp1141_;
							gboolean _tmp1142_;
							_tmp1134_ = param;
							_tmp1135_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1134_);
							_tmp1136_ = _tmp1135_;
							_tmp1137_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1136_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1137_;
							_tmp1138_ = deleg_type;
							_tmp1139_ = vala_delegate_type_get_delegate_symbol (_tmp1138_);
							_tmp1140_ = _tmp1139_;
							_tmp1141_ = vala_delegate_get_has_target (_tmp1140_);
							_tmp1142_ = _tmp1141_;
							if (_tmp1142_) {
								ValaVoidType* _tmp1143_;
								ValaVoidType* _tmp1144_;
								ValaPointerType* _tmp1145_;
								ValaPointerType* _tmp1146_;
								ValaLocalVariable* _tmp1147_;
								ValaLocalVariable* _tmp1148_;
								ValaExpression* _tmp1149_;
								ValaLocalVariable* _tmp1150_;
								const gchar* _tmp1151_;
								const gchar* _tmp1152_;
								ValaCCodeExpression* _tmp1153_;
								ValaCCodeExpression* _tmp1154_;
								ValaHashMap* _tmp1155_;
								ValaParameter* _tmp1156_;
								ValaExpression* _tmp1157_;
								ValaCCodeExpression* _tmp1158_;
								ValaCCodeUnaryExpression* _tmp1159_;
								ValaCCodeUnaryExpression* _tmp1160_;
								ValaDelegateType* _tmp1161_;
								_tmp1143_ = vala_void_type_new (NULL);
								_tmp1144_ = _tmp1143_;
								_tmp1145_ = vala_pointer_type_new ((ValaDataType*) _tmp1144_, NULL);
								_tmp1146_ = _tmp1145_;
								_tmp1147_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1146_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1147_;
								_vala_code_node_unref0 (_tmp1146_);
								_vala_code_node_unref0 (_tmp1144_);
								_tmp1148_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1148_, FALSE);
								_tmp1149_ = arg;
								_tmp1150_ = temp_var;
								_tmp1151_ = vala_symbol_get_name ((ValaSymbol*) _tmp1150_);
								_tmp1152_ = _tmp1151_;
								_tmp1153_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1152_);
								_tmp1154_ = _tmp1153_;
								vala_set_delegate_target (_tmp1149_, _tmp1154_);
								_vala_ccode_node_unref0 (_tmp1154_);
								_tmp1155_ = carg_map;
								_tmp1156_ = param;
								_tmp1157_ = arg;
								_tmp1158_ = vala_get_delegate_target (_tmp1157_);
								_tmp1159_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1158_);
								_tmp1160_ = _tmp1159_;
								vala_map_set ((ValaMap*) _tmp1155_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1156_), FALSE)), (ValaCCodeExpression*) _tmp1160_);
								_vala_ccode_node_unref0 (_tmp1160_);
								_tmp1161_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1161_)) {
									ValaDataType* _tmp1162_;
									ValaLocalVariable* _tmp1163_;
									ValaLocalVariable* _tmp1164_;
									ValaExpression* _tmp1165_;
									ValaLocalVariable* _tmp1166_;
									const gchar* _tmp1167_;
									const gchar* _tmp1168_;
									ValaCCodeExpression* _tmp1169_;
									ValaCCodeExpression* _tmp1170_;
									ValaHashMap* _tmp1171_;
									ValaParameter* _tmp1172_;
									ValaExpression* _tmp1173_;
									ValaCCodeExpression* _tmp1174_;
									ValaCCodeUnaryExpression* _tmp1175_;
									ValaCCodeUnaryExpression* _tmp1176_;
									_tmp1162_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1163_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1162_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1163_;
									_tmp1164_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1164_, FALSE);
									_tmp1165_ = arg;
									_tmp1166_ = temp_var;
									_tmp1167_ = vala_symbol_get_name ((ValaSymbol*) _tmp1166_);
									_tmp1168_ = _tmp1167_;
									_tmp1169_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1168_);
									_tmp1170_ = _tmp1169_;
									vala_set_delegate_target_destroy_notify (_tmp1165_, _tmp1170_);
									_vala_ccode_node_unref0 (_tmp1170_);
									_tmp1171_ = carg_map;
									_tmp1172_ = param;
									_tmp1173_ = arg;
									_tmp1174_ = vala_get_delegate_target_destroy_notify (_tmp1173_);
									_tmp1175_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1174_);
									_tmp1176_ = _tmp1175_;
									vala_map_set ((ValaMap*) _tmp1171_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1172_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1176_);
									_vala_ccode_node_unref0 (_tmp1176_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1177_ = param;
				_tmp1178_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1177_);
				_tmp1179_ = _tmp1178_;
				_tmp1180_ = _tmp1179_ != NULL;
				_g_free0 (_tmp1179_);
				if (_tmp1180_) {
					ValaCCodeExpression* _tmp1181_;
					ValaParameter* _tmp1182_;
					gchar* _tmp1183_;
					gchar* _tmp1184_;
					ValaCCodeCastExpression* _tmp1185_;
					_tmp1181_ = cexpr;
					_tmp1182_ = param;
					_tmp1183_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1182_);
					_tmp1184_ = _tmp1183_;
					_tmp1185_ = vala_ccode_cast_expression_new (_tmp1181_, _tmp1184_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1185_;
					_g_free0 (_tmp1184_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1186_;
				ValaUnaryExpression* _tmp1187_;
				gboolean _tmp1188_ = FALSE;
				gboolean _tmp1189_ = FALSE;
				_tmp1186_ = arg;
				_tmp1187_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1186_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1186_) : NULL);
				unary = _tmp1187_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1190_;
					_tmp1190_ = unary;
					_tmp1189_ = _tmp1190_ != NULL;
				} else {
					_tmp1189_ = FALSE;
				}
				if (_tmp1189_) {
					ValaUnaryExpression* _tmp1191_;
					ValaUnaryOperator _tmp1192_;
					ValaUnaryOperator _tmp1193_;
					_tmp1191_ = unary;
					_tmp1192_ = vala_unary_expression_get_operator (_tmp1191_);
					_tmp1193_ = _tmp1192_;
					_tmp1188_ = _tmp1193_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1188_ = FALSE;
				}
				if (_tmp1188_) {
					ValaHashMap* _tmp1194_;
					ValaHashMap* _tmp1195_;
					ValaExpression* _tmp1196_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1197_;
					ValaDataType* _tmp1198_;
					ValaDataType* _tmp1199_;
					ValaExpression* _tmp1200_;
					ValaDataType* _tmp1201_;
					ValaDataType* _tmp1202_;
					gboolean _tmp1203_;
					gboolean _tmp1204_;
					ValaLocalVariable* _tmp1205_;
					ValaLocalVariable* _tmp1206_;
					ValaExpression* _tmp1207_;
					ValaLocalVariable* _tmp1208_;
					const gchar* _tmp1209_;
					const gchar* _tmp1210_;
					ValaCCodeExpression* _tmp1211_;
					ValaCCodeExpression* _tmp1212_;
					ValaExpression* _tmp1213_;
					ValaTargetValue* _tmp1214_;
					ValaTargetValue* _tmp1215_;
					ValaExpression* _tmp1216_;
					ValaDataType* _tmp1217_;
					ValaDataType* _tmp1218_;
					gboolean _tmp1219_ = FALSE;
					ValaExpression* _tmp1220_;
					ValaDataType* _tmp1221_;
					ValaDataType* _tmp1222_;
					ValaExpression* _tmp1241_;
					ValaCCodeExpression* _tmp1242_;
					ValaCCodeUnaryExpression* _tmp1243_;
					_tmp1194_ = out_arg_map;
					_tmp1195_ = _vala_map_ref0 (_tmp1194_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1195_;
					_tmp1196_ = arg;
					vala_expression_set_target_value (_tmp1196_, NULL);
					_tmp1197_ = arg;
					_tmp1198_ = vala_expression_get_value_type (_tmp1197_);
					_tmp1199_ = _tmp1198_;
					_tmp1200_ = arg;
					_tmp1201_ = vala_expression_get_value_type (_tmp1200_);
					_tmp1202_ = _tmp1201_;
					_tmp1203_ = vala_data_type_get_value_owned (_tmp1202_);
					_tmp1204_ = _tmp1203_;
					_tmp1205_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1199_, _tmp1204_, NULL, TRUE);
					temp_var = _tmp1205_;
					_tmp1206_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1206_, FALSE);
					_tmp1207_ = arg;
					_tmp1208_ = temp_var;
					_tmp1209_ = vala_symbol_get_name ((ValaSymbol*) _tmp1208_);
					_tmp1210_ = _tmp1209_;
					_tmp1211_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1210_);
					_tmp1212_ = _tmp1211_;
					vala_set_cvalue (_tmp1207_, _tmp1212_);
					_vala_ccode_node_unref0 (_tmp1212_);
					_tmp1213_ = arg;
					_tmp1214_ = vala_expression_get_target_value (_tmp1213_);
					_tmp1215_ = _tmp1214_;
					_tmp1216_ = arg;
					_tmp1217_ = vala_expression_get_value_type (_tmp1216_);
					_tmp1218_ = _tmp1217_;
					vala_target_value_set_value_type (_tmp1215_, _tmp1218_);
					_tmp1220_ = arg;
					_tmp1221_ = vala_expression_get_value_type (_tmp1220_);
					_tmp1222_ = _tmp1221_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1222_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1223_;
						ValaDataType* _tmp1224_;
						ValaDataType* _tmp1225_;
						ValaDelegate* _tmp1226_;
						ValaDelegate* _tmp1227_;
						gboolean _tmp1228_;
						gboolean _tmp1229_;
						_tmp1223_ = arg;
						_tmp1224_ = vala_expression_get_value_type (_tmp1223_);
						_tmp1225_ = _tmp1224_;
						_tmp1226_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1225_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1227_ = _tmp1226_;
						_tmp1228_ = vala_delegate_get_has_target (_tmp1227_);
						_tmp1229_ = _tmp1228_;
						_tmp1219_ = _tmp1229_;
					} else {
						_tmp1219_ = FALSE;
					}
					if (_tmp1219_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1230_;
						ValaTargetValue* _tmp1231_;
						ValaTargetValue* _tmp1232_;
						ValaGLibValue* _tmp1233_;
						ValaCCodeExpression* _tmp1234_;
						ValaGLibValue* _tmp1237_;
						ValaCCodeExpression* _tmp1238_;
						_tmp1230_ = arg;
						_tmp1231_ = vala_expression_get_target_value (_tmp1230_);
						_tmp1232_ = _tmp1231_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1232_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1233_ = arg_value;
						_tmp1234_ = _tmp1233_->delegate_target_cvalue;
						if (_tmp1234_ == NULL) {
							ValaGLibValue* _tmp1235_;
							ValaCCodeConstant* _tmp1236_;
							_tmp1235_ = arg_value;
							_tmp1236_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1235_->delegate_target_cvalue);
							_tmp1235_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1236_;
						}
						_tmp1237_ = arg_value;
						_tmp1238_ = _tmp1237_->delegate_target_destroy_notify_cvalue;
						if (_tmp1238_ == NULL) {
							ValaGLibValue* _tmp1239_;
							ValaCCodeConstant* _tmp1240_;
							_tmp1239_ = arg_value;
							_tmp1240_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1239_->delegate_target_destroy_notify_cvalue);
							_tmp1239_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1240_;
						}
					}
					_tmp1241_ = arg;
					_tmp1242_ = vala_get_cvalue (_tmp1241_);
					_tmp1243_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1242_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1243_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1244_;
					ValaCCodeExpression* _tmp1245_;
					ValaCCodeExpression* _tmp1246_;
					_tmp1244_ = arg;
					_tmp1245_ = cexpr;
					_tmp1246_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1244_, _tmp1245_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1246_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1248_ = param;
			if (_tmp1248_ != NULL) {
				ValaParameter* _tmp1249_;
				_tmp1249_ = param;
				_tmp1247_ = vala_get_ccode_pos (_tmp1249_);
			} else {
				_tmp1247_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1247_, ellipsis);
			_tmp1250_ = carg_map;
			_tmp1251_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1250_, (gpointer) ((gintptr) arg_pos), _tmp1251_);
			_tmp1253_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1253_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1254_;
				ValaCodeContext* _tmp1255_;
				ValaProfile _tmp1256_;
				ValaProfile _tmp1257_;
				_tmp1254_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1255_ = _tmp1254_;
				_tmp1256_ = vala_code_context_get_profile (_tmp1255_);
				_tmp1257_ = _tmp1256_;
				_tmp1252_ = _tmp1257_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1252_ = FALSE;
			}
			if (_tmp1252_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1258_;
				ValaExpression* _tmp1259_;
				ValaExpression* _tmp1260_;
				ValaDataType* _tmp1261_;
				ValaDataType* _tmp1262_;
				ValaDataType* _tmp1263_;
				ValaDataType* _tmp1264_;
				gchar* _tmp1265_;
				gchar* _tmp1266_;
				gchar* _tmp1267_;
				gchar* _tmp1268_;
				ValaCCodeIdentifier* _tmp1269_;
				ValaCCodeIdentifier* _tmp1270_;
				ValaHashMap* _tmp1271_;
				ValaCCodeIdentifier* _tmp1272_;
				ValaCCodeExpression* _tmp1273_;
				ValaCCodeBinaryExpression* _tmp1274_;
				ValaCCodeBinaryExpression* _tmp1275_;
				_tmp1258_ = ma;
				_tmp1259_ = vala_member_access_get_inner (_tmp1258_);
				_tmp1260_ = _tmp1259_;
				_tmp1261_ = vala_expression_get_value_type (_tmp1260_);
				_tmp1262_ = _tmp1261_;
				_tmp1263_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1262_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1264_ = _tmp1263_;
				_tmp1265_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1264_);
				_tmp1266_ = _tmp1265_;
				_tmp1267_ = g_strdup_printf ("sizeof (%s)", _tmp1266_);
				_tmp1268_ = _tmp1267_;
				_tmp1269_ = vala_ccode_identifier_new (_tmp1268_);
				_tmp1270_ = _tmp1269_;
				_g_free0 (_tmp1268_);
				_g_free0 (_tmp1266_);
				csizeof = _tmp1270_;
				_tmp1271_ = carg_map;
				_tmp1272_ = csizeof;
				_tmp1273_ = cexpr;
				_tmp1274_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1272_, _tmp1273_);
				_tmp1275_ = _tmp1274_;
				vala_map_set ((ValaMap*) _tmp1271_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1275_);
				_vala_ccode_node_unref0 (_tmp1275_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1276_;
				ValaCCodeExpression* _tmp1277_;
				_tmp1276_ = carg_map;
				_tmp1277_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1276_, (gpointer) ((gintptr) arg_pos), _tmp1277_);
			}
			_tmp1279_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1279_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1278_ = ellipsis;
			} else {
				_tmp1278_ = FALSE;
			}
			if (_tmp1278_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1280_;
				ValaNamedArgument* _tmp1281_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1282_;
				const gchar* _tmp1283_;
				const gchar* _tmp1284_;
				gchar** _tmp1285_;
				gchar** _tmp1286_;
				gchar** _tmp1287_;
				gint _tmp1287__length1;
				gchar* _tmp1288_;
				gchar* _tmp1289_;
				ValaHashMap* _tmp1290_;
				const gchar* _tmp1291_;
				gchar* _tmp1292_;
				gchar* _tmp1293_;
				ValaCCodeConstant* _tmp1294_;
				ValaCCodeConstant* _tmp1295_;
				_tmp1280_ = arg;
				_tmp1281_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1280_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1281_;
				_tmp1282_ = named_arg;
				_tmp1283_ = vala_named_argument_get_name (_tmp1282_);
				_tmp1284_ = _tmp1283_;
				_tmp1286_ = _tmp1285_ = g_strsplit (_tmp1284_, "_", 0);
				_tmp1287_ = _tmp1286_;
				_tmp1287__length1 = _vala_array_length (_tmp1285_);
				_tmp1288_ = _vala_g_strjoinv ("-", _tmp1287_, (gint) _vala_array_length (_tmp1285_));
				_tmp1289_ = _tmp1288_;
				_tmp1287_ = (_vala_array_free (_tmp1287_, _tmp1287__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1289_;
				_tmp1290_ = carg_map;
				_tmp1291_ = name;
				_tmp1292_ = g_strdup_printf ("\"%s\"", _tmp1291_);
				_tmp1293_ = _tmp1292_;
				_tmp1294_ = vala_ccode_constant_new (_tmp1293_);
				_tmp1295_ = _tmp1294_;
				vala_map_set ((ValaMap*) _tmp1290_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1295_);
				_vala_ccode_node_unref0 (_tmp1295_);
				_g_free0 (_tmp1293_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1296_ = i;
			i = _tmp1296_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1297_ = params_it;
	if (vala_iterator_next (_tmp1297_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1298_;
		gpointer _tmp1299_;
		gboolean _tmp1300_ = FALSE;
		ValaParameter* _tmp1301_;
		gboolean _tmp1302_;
		gboolean _tmp1303_;
		_tmp1298_ = params_it;
		_tmp1299_ = vala_iterator_get (_tmp1298_);
		param = (ValaParameter*) _tmp1299_;
		_tmp1301_ = param;
		_tmp1302_ = vala_parameter_get_params_array (_tmp1301_);
		_tmp1303_ = _tmp1302_;
		if (_tmp1303_) {
			_tmp1300_ = TRUE;
		} else {
			ValaParameter* _tmp1304_;
			gboolean _tmp1305_;
			gboolean _tmp1306_;
			_tmp1304_ = param;
			_tmp1305_ = vala_parameter_get_ellipsis (_tmp1304_);
			_tmp1306_ = _tmp1305_;
			_tmp1300_ = _tmp1306_;
		}
		_vala_assert (_tmp1300_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1309_ = m;
	if (_tmp1309_ != NULL) {
		ValaMethod* _tmp1310_;
		ValaDataType* _tmp1311_;
		ValaDataType* _tmp1312_;
		_tmp1310_ = m;
		_tmp1311_ = vala_callable_get_return_type ((ValaCallable*) _tmp1310_);
		_tmp1312_ = _tmp1311_;
		_tmp1308_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1312_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1308_ = FALSE;
	}
	if (_tmp1308_) {
		ValaCCodeFunctionCall* _tmp1313_;
		ValaCCodeFunctionCall* _tmp1314_;
		_tmp1313_ = async_call;
		_tmp1314_ = ccall;
		_tmp1307_ = _tmp1313_ != _tmp1314_;
	} else {
		_tmp1307_ = FALSE;
	}
	if (_tmp1307_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1315_;
		ValaDataType* _tmp1316_;
		ValaDataType* _tmp1317_;
		ValaArrayType* _tmp1318_;
		_tmp1315_ = m;
		_tmp1316_ = vala_callable_get_return_type ((ValaCallable*) _tmp1315_);
		_tmp1317_ = _tmp1316_;
		_tmp1318_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1317_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1318_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1319_ = FALSE;
				_tmp1319_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1321_;
					gint _tmp1322_;
					gint _tmp1323_;
					ValaMethod* _tmp1324_;
					if (!_tmp1319_) {
						gint _tmp1320_;
						_tmp1320_ = dim;
						dim = _tmp1320_ + 1;
					}
					_tmp1319_ = FALSE;
					_tmp1321_ = array_type;
					_tmp1322_ = vala_array_type_get_rank (_tmp1321_);
					_tmp1323_ = _tmp1322_;
					if (!(dim <= _tmp1323_)) {
						break;
					}
					_tmp1324_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1324_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1325_;
						ValaDataType* _tmp1326_;
						ValaLocalVariable* _tmp1327_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1328_;
						const gchar* _tmp1329_;
						const gchar* _tmp1330_;
						ValaCCodeExpression* _tmp1331_;
						ValaLocalVariable* _tmp1332_;
						ValaCCodeExpression* _tmp1333_;
						ValaCCodeExpression* _tmp1334_;
						ValaCCodeAssignment* _tmp1335_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1336_;
						ValaCCodeIdentifier* _tmp1337_;
						ValaCCodeFunctionCall* _tmp1338_;
						ValaCCodeFunctionCall* _tmp1339_;
						ValaCCodeFunctionCall* _tmp1340_;
						ValaCCodeExpression* _tmp1341_;
						ValaCCodeFunctionCall* _tmp1342_;
						_tmp1325_ = itype;
						_tmp1326_ = vala_data_type_get_return_type (_tmp1325_);
						_tmp1327_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1326_, TRUE, NULL, FALSE);
						temp_var = _tmp1327_;
						_tmp1328_ = temp_var;
						_tmp1329_ = vala_symbol_get_name ((ValaSymbol*) _tmp1328_);
						_tmp1330_ = _tmp1329_;
						_tmp1331_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1330_);
						temp_ref = _tmp1331_;
						_tmp1332_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1332_, FALSE);
						_tmp1333_ = temp_ref;
						_tmp1334_ = ccall_expr;
						_tmp1335_ = vala_ccode_assignment_new (_tmp1333_, _tmp1334_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1335_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1336_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1337_ = _tmp1336_;
						_tmp1338_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1337_);
						_tmp1339_ = _tmp1338_;
						_vala_ccode_node_unref0 (_tmp1337_);
						len_call = _tmp1339_;
						_tmp1340_ = len_call;
						_tmp1341_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1340_, _tmp1341_);
						_tmp1342_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1342_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1343_;
						_tmp1343_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1343_)) {
							gchar* _tmp1344_ = NULL;
							ValaMethod* _tmp1345_;
							gchar* _tmp1346_;
							gchar* length_ctype = NULL;
							gchar* _tmp1349_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1350_;
							ValaCType* _tmp1351_;
							ValaCType* _tmp1352_;
							ValaLocalVariable* _tmp1353_;
							ValaLocalVariable* _tmp1354_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1355_;
							const gchar* _tmp1356_;
							const gchar* _tmp1357_;
							ValaCCodeExpression* _tmp1358_;
							ValaLocalVariable* _tmp1359_;
							ValaHashMap* _tmp1360_;
							ValaMethod* _tmp1361_;
							ValaCCodeExpression* _tmp1362_;
							ValaCCodeUnaryExpression* _tmp1363_;
							ValaCCodeUnaryExpression* _tmp1364_;
							ValaCCodeExpression* _tmp1365_;
							_tmp1345_ = m;
							_tmp1346_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1345_);
							_tmp1344_ = _tmp1346_;
							if (_tmp1344_ == NULL) {
								ValaArrayType* _tmp1347_;
								gchar* _tmp1348_;
								_tmp1347_ = array_type;
								_tmp1348_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1347_);
								_g_free0 (_tmp1344_);
								_tmp1344_ = _tmp1348_;
							}
							_tmp1349_ = _tmp1344_;
							_tmp1344_ = NULL;
							length_ctype = _tmp1349_;
							_tmp1350_ = length_ctype;
							_tmp1351_ = vala_ctype_new (_tmp1350_, "0");
							_tmp1352_ = _tmp1351_;
							_tmp1353_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1352_, TRUE, NULL, TRUE);
							_tmp1354_ = _tmp1353_;
							_vala_code_node_unref0 (_tmp1352_);
							temp_var = _tmp1354_;
							_tmp1355_ = temp_var;
							_tmp1356_ = vala_symbol_get_name ((ValaSymbol*) _tmp1355_);
							_tmp1357_ = _tmp1356_;
							_tmp1358_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1357_);
							temp_ref = _tmp1358_;
							_tmp1359_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1359_, FALSE);
							_tmp1360_ = out_arg_map;
							_tmp1361_ = m;
							_tmp1362_ = temp_ref;
							_tmp1363_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1362_);
							_tmp1364_ = _tmp1363_;
							vala_map_set ((ValaMap*) _tmp1360_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1361_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1364_);
							_vala_ccode_node_unref0 (_tmp1364_);
							_tmp1365_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1365_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1344_);
						} else {
							ValaMethod* _tmp1366_;
							gchar* _tmp1367_;
							gchar* _tmp1368_;
							gboolean _tmp1369_;
							_tmp1366_ = m;
							_tmp1367_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1366_);
							_tmp1368_ = _tmp1367_;
							_tmp1369_ = _tmp1368_ != NULL;
							_g_free0 (_tmp1368_);
							if (_tmp1369_) {
								ValaMethod* _tmp1370_;
								gchar* _tmp1371_;
								gchar* _tmp1372_;
								ValaCCodeConstant* _tmp1373_;
								ValaCCodeConstant* _tmp1374_;
								_tmp1370_ = m;
								_tmp1371_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1370_);
								_tmp1372_ = _tmp1371_;
								_tmp1373_ = vala_ccode_constant_new (_tmp1372_);
								_tmp1374_ = _tmp1373_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1374_);
								_vala_ccode_node_unref0 (_tmp1374_);
								_g_free0 (_tmp1372_);
							} else {
								ValaCCodeConstant* _tmp1375_;
								ValaCCodeConstant* _tmp1376_;
								_tmp1375_ = vala_ccode_constant_new ("-1");
								_tmp1376_ = _tmp1375_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1376_);
								_vala_ccode_node_unref0 (_tmp1376_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1377_ = FALSE;
		gboolean _tmp1378_ = FALSE;
		ValaMethod* _tmp1379_;
		_tmp1379_ = m;
		if (_tmp1379_ != NULL) {
			ValaMethod* _tmp1380_;
			ValaDataType* _tmp1381_;
			ValaDataType* _tmp1382_;
			_tmp1380_ = m;
			_tmp1381_ = vala_callable_get_return_type ((ValaCallable*) _tmp1380_);
			_tmp1382_ = _tmp1381_;
			_tmp1378_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1382_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1378_ = FALSE;
		}
		if (_tmp1378_) {
			ValaCCodeFunctionCall* _tmp1383_;
			ValaCCodeFunctionCall* _tmp1384_;
			_tmp1383_ = async_call;
			_tmp1384_ = ccall;
			_tmp1377_ = _tmp1383_ != _tmp1384_;
		} else {
			_tmp1377_ = FALSE;
		}
		if (_tmp1377_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1385_;
			ValaDataType* _tmp1386_;
			ValaDataType* _tmp1387_;
			ValaDelegateType* _tmp1388_;
			gboolean _tmp1389_ = FALSE;
			ValaMethod* _tmp1390_;
			_tmp1385_ = m;
			_tmp1386_ = vala_callable_get_return_type ((ValaCallable*) _tmp1385_);
			_tmp1387_ = _tmp1386_;
			_tmp1388_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1387_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1388_;
			_tmp1390_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1390_)) {
				ValaDelegateType* _tmp1391_;
				ValaDelegate* _tmp1392_;
				ValaDelegate* _tmp1393_;
				gboolean _tmp1394_;
				gboolean _tmp1395_;
				_tmp1391_ = deleg_type;
				_tmp1392_ = vala_delegate_type_get_delegate_symbol (_tmp1391_);
				_tmp1393_ = _tmp1392_;
				_tmp1394_ = vala_delegate_get_has_target (_tmp1393_);
				_tmp1395_ = _tmp1394_;
				_tmp1389_ = _tmp1395_;
			} else {
				_tmp1389_ = FALSE;
			}
			if (_tmp1389_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1396_;
				ValaVoidType* _tmp1397_;
				ValaPointerType* _tmp1398_;
				ValaPointerType* _tmp1399_;
				ValaLocalVariable* _tmp1400_;
				ValaLocalVariable* _tmp1401_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1402_;
				const gchar* _tmp1403_;
				const gchar* _tmp1404_;
				ValaCCodeExpression* _tmp1405_;
				ValaLocalVariable* _tmp1406_;
				ValaHashMap* _tmp1407_;
				ValaMethod* _tmp1408_;
				ValaCCodeExpression* _tmp1409_;
				ValaCCodeUnaryExpression* _tmp1410_;
				ValaCCodeUnaryExpression* _tmp1411_;
				ValaCCodeExpression* _tmp1412_;
				ValaDelegateType* _tmp1413_;
				_tmp1396_ = vala_void_type_new (NULL);
				_tmp1397_ = _tmp1396_;
				_tmp1398_ = vala_pointer_type_new ((ValaDataType*) _tmp1397_, NULL);
				_tmp1399_ = _tmp1398_;
				_tmp1400_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1399_, TRUE, NULL, TRUE);
				_tmp1401_ = _tmp1400_;
				_vala_code_node_unref0 (_tmp1399_);
				_vala_code_node_unref0 (_tmp1397_);
				temp_var = _tmp1401_;
				_tmp1402_ = temp_var;
				_tmp1403_ = vala_symbol_get_name ((ValaSymbol*) _tmp1402_);
				_tmp1404_ = _tmp1403_;
				_tmp1405_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1404_);
				temp_ref = _tmp1405_;
				_tmp1406_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1406_, FALSE);
				_tmp1407_ = out_arg_map;
				_tmp1408_ = m;
				_tmp1409_ = temp_ref;
				_tmp1410_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1409_);
				_tmp1411_ = _tmp1410_;
				vala_map_set ((ValaMap*) _tmp1407_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1408_), FALSE)), (ValaCCodeExpression*) _tmp1411_);
				_vala_ccode_node_unref0 (_tmp1411_);
				_tmp1412_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1412_);
				_tmp1413_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1413_)) {
					ValaDataType* _tmp1414_;
					ValaLocalVariable* _tmp1415_;
					ValaLocalVariable* _tmp1416_;
					const gchar* _tmp1417_;
					const gchar* _tmp1418_;
					ValaCCodeExpression* _tmp1419_;
					ValaLocalVariable* _tmp1420_;
					ValaHashMap* _tmp1421_;
					ValaMethod* _tmp1422_;
					ValaCCodeExpression* _tmp1423_;
					ValaCCodeUnaryExpression* _tmp1424_;
					ValaCCodeUnaryExpression* _tmp1425_;
					ValaCCodeExpression* _tmp1426_;
					_tmp1414_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1415_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1414_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1415_;
					_tmp1416_ = temp_var;
					_tmp1417_ = vala_symbol_get_name ((ValaSymbol*) _tmp1416_);
					_tmp1418_ = _tmp1417_;
					_tmp1419_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1418_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1419_;
					_tmp1420_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1420_, FALSE);
					_tmp1421_ = out_arg_map;
					_tmp1422_ = m;
					_tmp1423_ = temp_ref;
					_tmp1424_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1423_);
					_tmp1425_ = _tmp1424_;
					vala_map_set ((ValaMap*) _tmp1421_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1422_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1425_);
					_vala_ccode_node_unref0 (_tmp1425_);
					_tmp1426_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1426_);
				} else {
					ValaCCodeConstant* _tmp1427_;
					ValaCCodeConstant* _tmp1428_;
					_tmp1427_ = vala_ccode_constant_new ("NULL");
					_tmp1428_ = _tmp1427_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1428_);
					_vala_ccode_node_unref0 (_tmp1428_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1429_;
				ValaCCodeConstant* _tmp1430_;
				ValaDelegateType* _tmp1431_;
				ValaDelegate* _tmp1432_;
				ValaDelegate* _tmp1433_;
				gboolean _tmp1434_;
				gboolean _tmp1435_;
				_tmp1429_ = vala_ccode_constant_new ("NULL");
				_tmp1430_ = _tmp1429_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1430_);
				_vala_ccode_node_unref0 (_tmp1430_);
				_tmp1431_ = deleg_type;
				_tmp1432_ = vala_delegate_type_get_delegate_symbol (_tmp1431_);
				_tmp1433_ = _tmp1432_;
				_tmp1434_ = vala_delegate_get_has_target (_tmp1433_);
				_tmp1435_ = _tmp1434_;
				if (_tmp1435_) {
					ValaCCodeConstant* _tmp1436_;
					ValaCCodeConstant* _tmp1437_;
					_tmp1436_ = vala_ccode_constant_new ("NULL");
					_tmp1437_ = _tmp1436_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1437_);
					_vala_ccode_node_unref0 (_tmp1437_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1439_ = deleg;
	if (_tmp1439_ != NULL) {
		ValaDelegate* _tmp1440_;
		ValaDataType* _tmp1441_;
		ValaDataType* _tmp1442_;
		_tmp1440_ = deleg;
		_tmp1441_ = vala_callable_get_return_type ((ValaCallable*) _tmp1440_);
		_tmp1442_ = _tmp1441_;
		_tmp1438_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1442_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1438_ = FALSE;
	}
	if (_tmp1438_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1443_;
		ValaDataType* _tmp1444_;
		ValaDataType* _tmp1445_;
		ValaArrayType* _tmp1446_;
		_tmp1443_ = deleg;
		_tmp1444_ = vala_callable_get_return_type ((ValaCallable*) _tmp1443_);
		_tmp1445_ = _tmp1444_;
		_tmp1446_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1445_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1446_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1447_ = FALSE;
				_tmp1447_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1449_;
					gint _tmp1450_;
					gint _tmp1451_;
					ValaDelegate* _tmp1452_;
					if (!_tmp1447_) {
						gint _tmp1448_;
						_tmp1448_ = dim;
						dim = _tmp1448_ + 1;
					}
					_tmp1447_ = FALSE;
					_tmp1449_ = array_type;
					_tmp1450_ = vala_array_type_get_rank (_tmp1449_);
					_tmp1451_ = _tmp1450_;
					if (!(dim <= _tmp1451_)) {
						break;
					}
					_tmp1452_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1452_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1453_;
						ValaDataType* _tmp1454_;
						ValaLocalVariable* _tmp1455_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1456_;
						const gchar* _tmp1457_;
						const gchar* _tmp1458_;
						ValaCCodeExpression* _tmp1459_;
						ValaLocalVariable* _tmp1460_;
						ValaCCodeExpression* _tmp1461_;
						ValaCCodeExpression* _tmp1462_;
						ValaCCodeAssignment* _tmp1463_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1464_;
						ValaCCodeIdentifier* _tmp1465_;
						ValaCCodeFunctionCall* _tmp1466_;
						ValaCCodeFunctionCall* _tmp1467_;
						ValaCCodeFunctionCall* _tmp1468_;
						ValaCCodeExpression* _tmp1469_;
						ValaCCodeFunctionCall* _tmp1470_;
						_tmp1453_ = itype;
						_tmp1454_ = vala_data_type_get_return_type (_tmp1453_);
						_tmp1455_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1454_, TRUE, NULL, FALSE);
						temp_var = _tmp1455_;
						_tmp1456_ = temp_var;
						_tmp1457_ = vala_symbol_get_name ((ValaSymbol*) _tmp1456_);
						_tmp1458_ = _tmp1457_;
						_tmp1459_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1458_);
						temp_ref = _tmp1459_;
						_tmp1460_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1460_, FALSE);
						_tmp1461_ = temp_ref;
						_tmp1462_ = ccall_expr;
						_tmp1463_ = vala_ccode_assignment_new (_tmp1461_, _tmp1462_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1463_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1464_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1465_ = _tmp1464_;
						_tmp1466_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1465_);
						_tmp1467_ = _tmp1466_;
						_vala_ccode_node_unref0 (_tmp1465_);
						len_call = _tmp1467_;
						_tmp1468_ = len_call;
						_tmp1469_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1468_, _tmp1469_);
						_tmp1470_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1470_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1471_;
						_tmp1471_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1471_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1472_;
							ValaDataType* _tmp1473_;
							ValaDataType* _tmp1474_;
							ValaLocalVariable* _tmp1475_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1476_;
							const gchar* _tmp1477_;
							const gchar* _tmp1478_;
							ValaCCodeExpression* _tmp1479_;
							ValaLocalVariable* _tmp1480_;
							ValaHashMap* _tmp1481_;
							ValaDelegate* _tmp1482_;
							ValaCCodeExpression* _tmp1483_;
							ValaCCodeUnaryExpression* _tmp1484_;
							ValaCCodeUnaryExpression* _tmp1485_;
							ValaCCodeExpression* _tmp1486_;
							_tmp1472_ = array_type;
							_tmp1473_ = vala_array_type_get_length_type (_tmp1472_);
							_tmp1474_ = _tmp1473_;
							_tmp1475_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1474_, TRUE, NULL, TRUE);
							temp_var = _tmp1475_;
							_tmp1476_ = temp_var;
							_tmp1477_ = vala_symbol_get_name ((ValaSymbol*) _tmp1476_);
							_tmp1478_ = _tmp1477_;
							_tmp1479_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1478_);
							temp_ref = _tmp1479_;
							_tmp1480_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1480_, FALSE);
							_tmp1481_ = out_arg_map;
							_tmp1482_ = deleg;
							_tmp1483_ = temp_ref;
							_tmp1484_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1483_);
							_tmp1485_ = _tmp1484_;
							vala_map_set ((ValaMap*) _tmp1481_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1482_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1485_);
							_vala_ccode_node_unref0 (_tmp1485_);
							_tmp1486_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1486_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1487_;
							ValaCCodeConstant* _tmp1488_;
							_tmp1487_ = vala_ccode_constant_new ("-1");
							_tmp1488_ = _tmp1487_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1488_);
							_vala_ccode_node_unref0 (_tmp1488_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1489_ = FALSE;
		gboolean _tmp1490_ = FALSE;
		ValaDelegate* _tmp1491_;
		_tmp1491_ = deleg;
		if (_tmp1491_ != NULL) {
			ValaDelegate* _tmp1492_;
			ValaDataType* _tmp1493_;
			ValaDataType* _tmp1494_;
			_tmp1492_ = deleg;
			_tmp1493_ = vala_callable_get_return_type ((ValaCallable*) _tmp1492_);
			_tmp1494_ = _tmp1493_;
			_tmp1490_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1494_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1490_ = FALSE;
		}
		if (_tmp1490_) {
			ValaDelegate* _tmp1495_;
			_tmp1495_ = deleg;
			_tmp1489_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1495_);
		} else {
			_tmp1489_ = FALSE;
		}
		if (_tmp1489_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1496_;
			ValaDataType* _tmp1497_;
			ValaDataType* _tmp1498_;
			ValaDelegateType* _tmp1499_;
			ValaDelegateType* _tmp1500_;
			ValaDelegate* _tmp1501_;
			ValaDelegate* _tmp1502_;
			gboolean _tmp1503_;
			gboolean _tmp1504_;
			_tmp1496_ = deleg;
			_tmp1497_ = vala_callable_get_return_type ((ValaCallable*) _tmp1496_);
			_tmp1498_ = _tmp1497_;
			_tmp1499_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1498_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1499_;
			_tmp1500_ = deleg_type;
			_tmp1501_ = vala_delegate_type_get_delegate_symbol (_tmp1500_);
			_tmp1502_ = _tmp1501_;
			_tmp1503_ = vala_delegate_get_has_target (_tmp1502_);
			_tmp1504_ = _tmp1503_;
			if (_tmp1504_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1505_;
				ValaVoidType* _tmp1506_;
				ValaPointerType* _tmp1507_;
				ValaPointerType* _tmp1508_;
				ValaLocalVariable* _tmp1509_;
				ValaLocalVariable* _tmp1510_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1511_;
				const gchar* _tmp1512_;
				const gchar* _tmp1513_;
				ValaCCodeExpression* _tmp1514_;
				ValaLocalVariable* _tmp1515_;
				ValaHashMap* _tmp1516_;
				ValaDelegate* _tmp1517_;
				ValaCCodeExpression* _tmp1518_;
				ValaCCodeUnaryExpression* _tmp1519_;
				ValaCCodeUnaryExpression* _tmp1520_;
				ValaCCodeExpression* _tmp1521_;
				ValaDelegateType* _tmp1522_;
				_tmp1505_ = vala_void_type_new (NULL);
				_tmp1506_ = _tmp1505_;
				_tmp1507_ = vala_pointer_type_new ((ValaDataType*) _tmp1506_, NULL);
				_tmp1508_ = _tmp1507_;
				_tmp1509_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1508_, TRUE, NULL, TRUE);
				_tmp1510_ = _tmp1509_;
				_vala_code_node_unref0 (_tmp1508_);
				_vala_code_node_unref0 (_tmp1506_);
				temp_var = _tmp1510_;
				_tmp1511_ = temp_var;
				_tmp1512_ = vala_symbol_get_name ((ValaSymbol*) _tmp1511_);
				_tmp1513_ = _tmp1512_;
				_tmp1514_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1513_);
				temp_ref = _tmp1514_;
				_tmp1515_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1515_, FALSE);
				_tmp1516_ = out_arg_map;
				_tmp1517_ = deleg;
				_tmp1518_ = temp_ref;
				_tmp1519_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1518_);
				_tmp1520_ = _tmp1519_;
				vala_map_set ((ValaMap*) _tmp1516_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1517_), FALSE)), (ValaCCodeExpression*) _tmp1520_);
				_vala_ccode_node_unref0 (_tmp1520_);
				_tmp1521_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1521_);
				_tmp1522_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1522_)) {
					ValaDataType* _tmp1523_;
					ValaLocalVariable* _tmp1524_;
					ValaLocalVariable* _tmp1525_;
					const gchar* _tmp1526_;
					const gchar* _tmp1527_;
					ValaCCodeExpression* _tmp1528_;
					ValaLocalVariable* _tmp1529_;
					ValaHashMap* _tmp1530_;
					ValaDelegate* _tmp1531_;
					ValaCCodeExpression* _tmp1532_;
					ValaCCodeUnaryExpression* _tmp1533_;
					ValaCCodeUnaryExpression* _tmp1534_;
					ValaCCodeExpression* _tmp1535_;
					_tmp1523_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1524_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1523_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1524_;
					_tmp1525_ = temp_var;
					_tmp1526_ = vala_symbol_get_name ((ValaSymbol*) _tmp1525_);
					_tmp1527_ = _tmp1526_;
					_tmp1528_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1527_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1528_;
					_tmp1529_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1529_, FALSE);
					_tmp1530_ = out_arg_map;
					_tmp1531_ = deleg;
					_tmp1532_ = temp_ref;
					_tmp1533_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1532_);
					_tmp1534_ = _tmp1533_;
					vala_map_set ((ValaMap*) _tmp1530_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1531_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1534_);
					_vala_ccode_node_unref0 (_tmp1534_);
					_tmp1535_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1535_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1537_ = m;
	if (_tmp1537_ != NULL) {
		ValaMethod* _tmp1538_;
		gboolean _tmp1539_;
		gboolean _tmp1540_;
		_tmp1538_ = m;
		_tmp1539_ = vala_method_get_coroutine (_tmp1538_);
		_tmp1540_ = _tmp1539_;
		_tmp1536_ = _tmp1540_;
	} else {
		_tmp1536_ = FALSE;
	}
	if (_tmp1536_) {
		gboolean _tmp1541_;
		gboolean _tmp1542_;
		_tmp1541_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1542_ = _tmp1541_;
		if (_tmp1542_) {
			ValaHashMap* _tmp1543_;
			ValaMethod* _tmp1544_;
			ValaMethod* _tmp1545_;
			gchar* _tmp1546_;
			gchar* _tmp1547_;
			ValaCCodeIdentifier* _tmp1548_;
			ValaCCodeIdentifier* _tmp1549_;
			ValaHashMap* _tmp1550_;
			ValaCCodeIdentifier* _tmp1551_;
			ValaCCodeIdentifier* _tmp1552_;
			_tmp1543_ = in_arg_map;
			_tmp1544_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1545_ = _tmp1544_;
			_tmp1546_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1545_);
			_tmp1547_ = _tmp1546_;
			_tmp1548_ = vala_ccode_identifier_new (_tmp1547_);
			_tmp1549_ = _tmp1548_;
			vala_map_set ((ValaMap*) _tmp1543_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1549_);
			_vala_ccode_node_unref0 (_tmp1549_);
			_g_free0 (_tmp1547_);
			_tmp1550_ = in_arg_map;
			_tmp1551_ = vala_ccode_identifier_new ("_data_");
			_tmp1552_ = _tmp1551_;
			vala_map_set ((ValaMap*) _tmp1550_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1552_);
			_vala_ccode_node_unref0 (_tmp1552_);
		}
	}
	_tmp1553_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1554_ = _tmp1553_;
	if (_tmp1554_) {
		ValaCallable* _tmp1555_ = NULL;
		ValaMethod* _tmp1556_;
		ValaHashMap* _tmp1558_;
		ValaCCodeExpression* _tmp1559_;
		ValaCCodeExpression* _tmp1560_;
		ValaCCodeUnaryExpression* _tmp1561_;
		ValaCCodeUnaryExpression* _tmp1562_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1556_ = m;
		_tmp1555_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1556_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1555_ == NULL) {
			ValaDelegate* _tmp1557_;
			_tmp1557_ = deleg;
			_tmp1555_ = (ValaCallable*) _tmp1557_;
		}
		_tmp1558_ = out_arg_map;
		_tmp1559_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1560_ = _tmp1559_;
		_tmp1561_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1560_);
		_tmp1562_ = _tmp1561_;
		vala_map_set ((ValaMap*) _tmp1558_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1555_), FALSE)), (ValaCCodeExpression*) _tmp1562_);
		_vala_ccode_node_unref0 (_tmp1562_);
		_vala_ccode_node_unref0 (_tmp1560_);
	} else {
		gboolean _tmp1563_ = FALSE;
		gboolean _tmp1564_ = FALSE;
		ValaMethod* _tmp1565_;
		_tmp1565_ = m;
		if (_tmp1565_ != NULL) {
			ValaMethod* _tmp1566_;
			_tmp1566_ = m;
			_tmp1564_ = vala_method_has_error_type_parameter (_tmp1566_);
		} else {
			_tmp1564_ = FALSE;
		}
		if (_tmp1564_) {
			ValaCCodeFunctionCall* _tmp1567_;
			ValaCCodeFunctionCall* _tmp1568_;
			_tmp1567_ = async_call;
			_tmp1568_ = ccall;
			_tmp1563_ = _tmp1567_ != _tmp1568_;
		} else {
			_tmp1563_ = FALSE;
		}
		if (_tmp1563_) {
			ValaHashMap* _tmp1569_;
			ValaMethod* _tmp1570_;
			ValaCCodeConstant* _tmp1571_;
			ValaCCodeConstant* _tmp1572_;
			_tmp1569_ = out_arg_map;
			_tmp1570_ = m;
			_tmp1571_ = vala_ccode_constant_new ("NULL");
			_tmp1572_ = _tmp1571_;
			vala_map_set ((ValaMap*) _tmp1569_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1570_), FALSE)), (ValaCCodeExpression*) _tmp1572_);
			_vala_ccode_node_unref0 (_tmp1572_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1573_;
		_tmp1573_ = m;
		if (_tmp1573_ == NULL) {
			ValaHashMap* _tmp1574_;
			ValaCCodeConstant* _tmp1575_;
			ValaCCodeConstant* _tmp1576_;
			_tmp1574_ = in_arg_map;
			_tmp1575_ = vala_ccode_constant_new ("NULL");
			_tmp1576_ = _tmp1575_;
			vala_map_set ((ValaMap*) _tmp1574_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1576_);
			_vala_ccode_node_unref0 (_tmp1576_);
		} else {
			gboolean _tmp1577_ = FALSE;
			gboolean _tmp1578_ = FALSE;
			gboolean _tmp1579_ = FALSE;
			ValaMethod* _tmp1580_;
			gboolean _tmp1581_;
			gboolean _tmp1582_;
			_tmp1580_ = m;
			_tmp1581_ = vala_method_get_printf_format (_tmp1580_);
			_tmp1582_ = _tmp1581_;
			if (!_tmp1582_) {
				ValaMethod* _tmp1583_;
				gboolean _tmp1584_;
				gboolean _tmp1585_;
				_tmp1583_ = m;
				_tmp1584_ = vala_method_get_scanf_format (_tmp1583_);
				_tmp1585_ = _tmp1584_;
				_tmp1579_ = !_tmp1585_;
			} else {
				_tmp1579_ = FALSE;
			}
			if (_tmp1579_) {
				ValaMethod* _tmp1586_;
				gchar* _tmp1587_;
				gchar* _tmp1588_;
				_tmp1586_ = m;
				_tmp1587_ = vala_get_ccode_sentinel (_tmp1586_);
				_tmp1588_ = _tmp1587_;
				_tmp1578_ = g_strcmp0 (_tmp1588_, "") != 0;
				_g_free0 (_tmp1588_);
			} else {
				_tmp1578_ = FALSE;
			}
			if (_tmp1578_) {
				gboolean _tmp1589_;
				gboolean _tmp1590_;
				_tmp1589_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1590_ = _tmp1589_;
				_tmp1577_ = !_tmp1590_;
			} else {
				_tmp1577_ = FALSE;
			}
			if (_tmp1577_) {
				ValaHashMap* _tmp1591_;
				ValaMethod* _tmp1592_;
				gchar* _tmp1593_;
				gchar* _tmp1594_;
				ValaCCodeConstant* _tmp1595_;
				ValaCCodeConstant* _tmp1596_;
				_tmp1591_ = in_arg_map;
				_tmp1592_ = m;
				_tmp1593_ = vala_get_ccode_sentinel (_tmp1592_);
				_tmp1594_ = _tmp1593_;
				_tmp1595_ = vala_ccode_constant_new (_tmp1594_);
				_tmp1596_ = _tmp1595_;
				vala_map_set ((ValaMap*) _tmp1591_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1596_);
				_vala_ccode_node_unref0 (_tmp1596_);
				_g_free0 (_tmp1594_);
			}
		}
	}
	_tmp1598_ = deleg;
	if (_tmp1598_ != NULL) {
		ValaDelegate* _tmp1599_;
		gboolean _tmp1600_;
		gboolean _tmp1601_;
		_tmp1599_ = deleg;
		_tmp1600_ = vala_delegate_get_has_target (_tmp1599_);
		_tmp1601_ = _tmp1600_;
		_tmp1597_ = _tmp1601_;
	} else {
		_tmp1597_ = FALSE;
	}
	if (_tmp1597_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1602_;
		ValaDelegate* _tmp1603_;
		ValaExpression* _tmp1604_;
		ValaExpression* _tmp1605_;
		ValaCCodeExpression* _tmp1606_ = NULL;
		ValaCCodeExpression* _tmp1607_;
		ValaCCodeExpression* _tmp1608_;
		ValaHashMap* _tmp1609_;
		ValaDelegate* _tmp1610_;
		ValaExpression* _tmp1611_;
		ValaExpression* _tmp1612_;
		ValaCCodeExpression* _tmp1613_ = NULL;
		ValaCCodeExpression* _tmp1614_;
		ValaCCodeExpression* _tmp1615_;
		_tmp1602_ = in_arg_map;
		_tmp1603_ = deleg;
		_tmp1604_ = vala_method_call_get_call (expr);
		_tmp1605_ = _tmp1604_;
		_tmp1607_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1605_, &_tmp1606_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1606_;
		_tmp1608_ = _tmp1607_;
		vala_map_set ((ValaMap*) _tmp1602_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1603_), FALSE)), _tmp1608_);
		_vala_ccode_node_unref0 (_tmp1608_);
		_tmp1609_ = out_arg_map;
		_tmp1610_ = deleg;
		_tmp1611_ = vala_method_call_get_call (expr);
		_tmp1612_ = _tmp1611_;
		_tmp1614_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1612_, &_tmp1613_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1613_;
		_tmp1615_ = _tmp1614_;
		vala_map_set ((ValaMap*) _tmp1609_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1610_), FALSE)), _tmp1615_);
		_vala_ccode_node_unref0 (_tmp1615_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1616_ = itype;
	_tmp1617_ = vala_data_type_get_return_type (_tmp1616_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1617_);
	_tmp1619_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1619_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1620_;
		ValaDataType* _tmp1621_;
		_tmp1620_ = itype;
		_tmp1621_ = vala_data_type_get_return_type (_tmp1620_);
		_tmp1618_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1621_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1618_ = FALSE;
	}
	if (_tmp1618_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1622_;
		ValaSignal* _tmp1623_;
		ValaSignal* _tmp1624_;
		ValaSignal* _tmp1625_;
		gboolean _tmp1626_ = FALSE;
		gboolean _tmp1627_ = FALSE;
		ValaMemberAccess* _tmp1628_;
		_tmp1622_ = itype;
		_tmp1623_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1622_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1624_ = _tmp1623_;
		_tmp1625_ = _vala_code_node_ref0 (_tmp1624_);
		sig = _tmp1625_;
		_tmp1628_ = ma;
		if (_tmp1628_ != NULL) {
			ValaMemberAccess* _tmp1629_;
			ValaExpression* _tmp1630_;
			ValaExpression* _tmp1631_;
			_tmp1629_ = ma;
			_tmp1630_ = vala_member_access_get_inner (_tmp1629_);
			_tmp1631_ = _tmp1630_;
			_tmp1627_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1631_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1627_ = FALSE;
		}
		if (_tmp1627_) {
			ValaSignal* _tmp1632_;
			gboolean _tmp1633_;
			gboolean _tmp1634_;
			_tmp1632_ = sig;
			_tmp1633_ = vala_signal_get_is_virtual (_tmp1632_);
			_tmp1634_ = _tmp1633_;
			_tmp1626_ = _tmp1634_;
		} else {
			_tmp1626_ = FALSE;
		}
		if (_tmp1626_) {
		} else {
			gboolean _tmp1635_ = FALSE;
			ValaSignal* _tmp1636_;
			_tmp1636_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1636_)) {
				_tmp1635_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1637_;
				ValaSourceReference* _tmp1638_;
				ValaSourceReference* _tmp1639_;
				ValaSourceFile* _tmp1640_;
				ValaSourceFile* _tmp1641_;
				ValaSignal* _tmp1642_;
				ValaSourceReference* _tmp1643_;
				ValaSourceReference* _tmp1644_;
				ValaSourceFile* _tmp1645_;
				ValaSourceFile* _tmp1646_;
				_tmp1637_ = ma;
				_tmp1638_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1637_);
				_tmp1639_ = _tmp1638_;
				_tmp1640_ = vala_source_reference_get_file (_tmp1639_);
				_tmp1641_ = _tmp1640_;
				_tmp1642_ = sig;
				_tmp1643_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1642_);
				_tmp1644_ = _tmp1643_;
				_tmp1645_ = vala_source_reference_get_file (_tmp1644_);
				_tmp1646_ = _tmp1645_;
				_tmp1635_ = _tmp1641_ == _tmp1646_;
			}
			if (_tmp1635_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1647_ = async_call;
	_tmp1648_ = ccall;
	if (_tmp1647_ == _tmp1648_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1649_;
		ValaDataType* _tmp1650_;
		ValaLocalVariable* _tmp1651_;
		ValaLocalVariable* _tmp1652_;
		const gchar* _tmp1653_;
		const gchar* _tmp1654_;
		ValaCCodeExpression* _tmp1655_;
		ValaLocalVariable* _tmp1656_;
		ValaHashMap* _tmp1657_;
		ValaCCodeExpression* _tmp1658_;
		ValaCCodeUnaryExpression* _tmp1659_;
		ValaCCodeUnaryExpression* _tmp1660_;
		_tmp1649_ = itype;
		_tmp1650_ = vala_data_type_get_return_type (_tmp1649_);
		_tmp1651_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1650_, TRUE, NULL, TRUE);
		out_param_var = _tmp1651_;
		_tmp1652_ = out_param_var;
		_tmp1653_ = vala_symbol_get_name ((ValaSymbol*) _tmp1652_);
		_tmp1654_ = _tmp1653_;
		_tmp1655_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1654_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1655_;
		_tmp1656_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1656_, FALSE);
		_tmp1657_ = out_arg_map;
		_tmp1658_ = out_param_ref;
		_tmp1659_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1658_);
		_tmp1660_ = _tmp1659_;
		vala_map_set ((ValaMap*) _tmp1657_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1660_);
		_vala_ccode_node_unref0 (_tmp1660_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1661_ = async_call;
	_tmp1662_ = ccall;
	if (_tmp1661_ != _tmp1662_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1673_;
			ValaHashMap* _tmp1674_;
			gpointer _tmp1675_;
			ValaCCodeExpression* _tmp1676_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1663_;
				ValaSet* _tmp1664_;
				ValaSet* _tmp1665_;
				ValaIterator* _tmp1666_;
				ValaIterator* _tmp1667_;
				_tmp1663_ = out_arg_map;
				_tmp1664_ = vala_map_get_keys ((ValaMap*) _tmp1663_);
				_tmp1665_ = _tmp1664_;
				_tmp1666_ = vala_iterable_iterator ((ValaIterable*) _tmp1665_);
				_tmp1667_ = _tmp1666_;
				_vala_iterable_unref0 (_tmp1665_);
				_pos_it = _tmp1667_;
				while (TRUE) {
					ValaIterator* _tmp1668_;
					gint pos = 0;
					ValaIterator* _tmp1669_;
					gpointer _tmp1670_;
					gboolean _tmp1671_ = FALSE;
					_tmp1668_ = _pos_it;
					if (!vala_iterator_next (_tmp1668_)) {
						break;
					}
					_tmp1669_ = _pos_it;
					_tmp1670_ = vala_iterator_get (_tmp1669_);
					pos = (gint) ((gintptr) _tmp1670_);
					if (pos > last_pos) {
						gboolean _tmp1672_ = FALSE;
						if (min_pos == -1) {
							_tmp1672_ = TRUE;
						} else {
							_tmp1672_ = pos < min_pos;
						}
						_tmp1671_ = _tmp1672_;
					} else {
						_tmp1671_ = FALSE;
					}
					if (_tmp1671_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1673_ = ccall;
			_tmp1674_ = out_arg_map;
			_tmp1675_ = vala_map_get ((ValaMap*) _tmp1674_, (gpointer) ((gintptr) min_pos));
			_tmp1676_ = (ValaCCodeExpression*) _tmp1675_;
			vala_ccode_function_call_add_argument (_tmp1673_, _tmp1676_);
			_vala_ccode_node_unref0 (_tmp1676_);
			last_pos = min_pos;
		}
	}
	_tmp1677_ = async_call;
	if (_tmp1677_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1688_;
			ValaHashMap* _tmp1689_;
			gpointer _tmp1690_;
			ValaCCodeExpression* _tmp1691_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1678_;
				ValaSet* _tmp1679_;
				ValaSet* _tmp1680_;
				ValaIterator* _tmp1681_;
				ValaIterator* _tmp1682_;
				_tmp1678_ = in_arg_map;
				_tmp1679_ = vala_map_get_keys ((ValaMap*) _tmp1678_);
				_tmp1680_ = _tmp1679_;
				_tmp1681_ = vala_iterable_iterator ((ValaIterable*) _tmp1680_);
				_tmp1682_ = _tmp1681_;
				_vala_iterable_unref0 (_tmp1680_);
				_pos_it = _tmp1682_;
				while (TRUE) {
					ValaIterator* _tmp1683_;
					gint pos = 0;
					ValaIterator* _tmp1684_;
					gpointer _tmp1685_;
					gboolean _tmp1686_ = FALSE;
					_tmp1683_ = _pos_it;
					if (!vala_iterator_next (_tmp1683_)) {
						break;
					}
					_tmp1684_ = _pos_it;
					_tmp1685_ = vala_iterator_get (_tmp1684_);
					pos = (gint) ((gintptr) _tmp1685_);
					if (pos > last_pos) {
						gboolean _tmp1687_ = FALSE;
						if (min_pos == -1) {
							_tmp1687_ = TRUE;
						} else {
							_tmp1687_ = pos < min_pos;
						}
						_tmp1686_ = _tmp1687_;
					} else {
						_tmp1686_ = FALSE;
					}
					if (_tmp1686_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1688_ = async_call;
			_tmp1689_ = in_arg_map;
			_tmp1690_ = vala_map_get ((ValaMap*) _tmp1689_, (gpointer) ((gintptr) min_pos));
			_tmp1691_ = (ValaCCodeExpression*) _tmp1690_;
			vala_ccode_function_call_add_argument (_tmp1688_, _tmp1691_);
			_vala_ccode_node_unref0 (_tmp1691_);
			last_pos = min_pos;
		}
	}
	_tmp1692_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1693_ = _tmp1692_;
	if (_tmp1693_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1694_;
		gint _tmp1695_;
		ValaCCodeFunction* _tmp1696_;
		ValaCCodeFunction* _tmp1697_;
		ValaCCodeIdentifier* _tmp1698_;
		ValaCCodeIdentifier* _tmp1699_;
		ValaCCodeMemberAccess* _tmp1700_;
		ValaCCodeMemberAccess* _tmp1701_;
		gchar* _tmp1702_;
		gchar* _tmp1703_;
		ValaCCodeConstant* _tmp1704_;
		ValaCCodeConstant* _tmp1705_;
		ValaCCodeFunction* _tmp1706_;
		ValaCCodeFunction* _tmp1707_;
		ValaCCodeFunctionCall* _tmp1708_;
		ValaCCodeFunction* _tmp1709_;
		ValaCCodeFunction* _tmp1710_;
		ValaCCodeConstant* _tmp1711_;
		ValaCCodeConstant* _tmp1712_;
		ValaCCodeFunction* _tmp1713_;
		ValaCCodeFunction* _tmp1714_;
		gchar* _tmp1715_;
		gchar* _tmp1716_;
		_tmp1694_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1695_ = _tmp1694_->next_coroutine_state;
		_tmp1694_->next_coroutine_state = _tmp1695_ + 1;
		state = _tmp1695_;
		_tmp1696_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1697_ = _tmp1696_;
		_tmp1698_ = vala_ccode_identifier_new ("_data_");
		_tmp1699_ = _tmp1698_;
		_tmp1700_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1699_, "_state_");
		_tmp1701_ = _tmp1700_;
		_tmp1702_ = g_strdup_printf ("%i", state);
		_tmp1703_ = _tmp1702_;
		_tmp1704_ = vala_ccode_constant_new (_tmp1703_);
		_tmp1705_ = _tmp1704_;
		vala_ccode_function_add_assignment (_tmp1697_, (ValaCCodeExpression*) _tmp1701_, (ValaCCodeExpression*) _tmp1705_);
		_vala_ccode_node_unref0 (_tmp1705_);
		_g_free0 (_tmp1703_);
		_vala_ccode_node_unref0 (_tmp1701_);
		_vala_ccode_node_unref0 (_tmp1699_);
		_tmp1706_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1707_ = _tmp1706_;
		_tmp1708_ = async_call;
		vala_ccode_function_add_expression (_tmp1707_, (ValaCCodeExpression*) _tmp1708_);
		_tmp1709_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1710_ = _tmp1709_;
		_tmp1711_ = vala_ccode_constant_new ("FALSE");
		_tmp1712_ = _tmp1711_;
		vala_ccode_function_add_return (_tmp1710_, (ValaCCodeExpression*) _tmp1712_);
		_vala_ccode_node_unref0 (_tmp1712_);
		_tmp1713_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1714_ = _tmp1713_;
		_tmp1715_ = g_strdup_printf ("_state_%d", state);
		_tmp1716_ = _tmp1715_;
		vala_ccode_function_add_label (_tmp1714_, _tmp1716_);
		_g_free0 (_tmp1716_);
	}
	_tmp1717_ = vala_method_call_get_is_assert (expr);
	_tmp1718_ = _tmp1717_;
	if (_tmp1718_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1719_;
		ValaSourceReference* _tmp1720_;
		ValaSourceLocation _tmp1721_ = {0};
		ValaSourceLocation _tmp1722_;
		gchar* _tmp1723_;
		ValaSourceReference* _tmp1724_;
		ValaSourceReference* _tmp1725_;
		ValaSourceLocation _tmp1726_ = {0};
		ValaSourceLocation _tmp1727_;
		gchar* _tmp1728_;
		ValaSourceReference* _tmp1729_;
		ValaSourceReference* _tmp1730_;
		ValaSourceLocation _tmp1731_ = {0};
		ValaSourceLocation _tmp1732_;
		gchar* _tmp1733_;
		gchar* _tmp1734_;
		ValaCCodeFunctionCall* _tmp1735_;
		ValaCCodeIdentifier* _tmp1736_;
		ValaCCodeIdentifier* _tmp1737_;
		ValaCCodeFunctionCall* _tmp1738_;
		const gchar* _tmp1739_;
		gchar* _tmp1740_;
		gchar* _tmp1741_;
		gchar* _tmp1742_;
		gchar* _tmp1743_;
		gchar* _tmp1744_;
		gchar* _tmp1745_;
		ValaCCodeConstant* _tmp1746_;
		ValaCCodeConstant* _tmp1747_;
		_tmp1719_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1720_ = _tmp1719_;
		vala_source_reference_get_begin (_tmp1720_, &_tmp1721_);
		_tmp1722_ = _tmp1721_;
		_tmp1723_ = _tmp1722_.pos;
		_tmp1724_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1725_ = _tmp1724_;
		vala_source_reference_get_end (_tmp1725_, &_tmp1726_);
		_tmp1727_ = _tmp1726_;
		_tmp1728_ = _tmp1727_.pos;
		_tmp1729_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1730_ = _tmp1729_;
		vala_source_reference_get_begin (_tmp1730_, &_tmp1731_);
		_tmp1732_ = _tmp1731_;
		_tmp1733_ = _tmp1732_.pos;
		_tmp1734_ = string_substring ((const gchar*) _tmp1723_, (glong) 0, (glong) ((gint) (_tmp1728_ - _tmp1733_)));
		message = _tmp1734_;
		_tmp1735_ = ccall;
		_tmp1736_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1737_ = _tmp1736_;
		vala_ccode_function_call_set_call (_tmp1735_, (ValaCCodeExpression*) _tmp1737_);
		_vala_ccode_node_unref0 (_tmp1737_);
		_tmp1738_ = ccall;
		_tmp1739_ = message;
		_tmp1740_ = string_replace (_tmp1739_, "\n", " ");
		_tmp1741_ = _tmp1740_;
		_tmp1742_ = g_strescape (_tmp1741_, "");
		_tmp1743_ = _tmp1742_;
		_tmp1744_ = g_strdup_printf ("\"%s\"", _tmp1743_);
		_tmp1745_ = _tmp1744_;
		_tmp1746_ = vala_ccode_constant_new (_tmp1745_);
		_tmp1747_ = _tmp1746_;
		vala_ccode_function_call_add_argument (_tmp1738_, (ValaCCodeExpression*) _tmp1747_);
		_vala_ccode_node_unref0 (_tmp1747_);
		_g_free0 (_tmp1745_);
		_g_free0 (_tmp1743_);
		_g_free0 (_tmp1741_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1748_;
		ValaCCodeFunction* _tmp1749_;
		ValaCCodeExpression* _tmp1750_;
		ValaCCodeExpression* _tmp1751_;
		ValaCCodeExpression* _tmp1752_;
		_tmp1748_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1749_ = _tmp1748_;
		_tmp1750_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1749_, _tmp1750_);
		_tmp1751_ = out_param_ref;
		_tmp1752_ = _vala_ccode_node_ref0 (_tmp1751_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1752_;
	}
	_tmp1755_ = m;
	if (_tmp1755_ != NULL) {
		ValaMethod* _tmp1756_;
		ValaMemberBinding _tmp1757_;
		ValaMemberBinding _tmp1758_;
		_tmp1756_ = m;
		_tmp1757_ = vala_method_get_binding (_tmp1756_);
		_tmp1758_ = _tmp1757_;
		_tmp1754_ = _tmp1758_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1754_ = FALSE;
	}
	if (_tmp1754_) {
		ValaMethod* _tmp1759_;
		gboolean _tmp1760_;
		gboolean _tmp1761_;
		_tmp1759_ = m;
		_tmp1760_ = vala_method_get_returns_modified_pointer (_tmp1759_);
		_tmp1761_ = _tmp1760_;
		_tmp1753_ = _tmp1761_;
	} else {
		_tmp1753_ = FALSE;
	}
	if (_tmp1753_) {
		gboolean _tmp1762_ = FALSE;
		gboolean _tmp1763_ = FALSE;
		ValaMemberAccess* _tmp1764_;
		_tmp1764_ = ma;
		if (_tmp1764_ != NULL) {
			ValaMemberAccess* _tmp1765_;
			ValaExpression* _tmp1766_;
			ValaExpression* _tmp1767_;
			ValaSymbol* _tmp1768_;
			ValaSymbol* _tmp1769_;
			_tmp1765_ = ma;
			_tmp1766_ = vala_member_access_get_inner (_tmp1765_);
			_tmp1767_ = _tmp1766_;
			_tmp1768_ = vala_expression_get_symbol_reference (_tmp1767_);
			_tmp1769_ = _tmp1768_;
			_tmp1763_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1769_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1763_ = FALSE;
		}
		if (_tmp1763_) {
			ValaMemberAccess* _tmp1770_;
			ValaExpression* _tmp1771_;
			ValaExpression* _tmp1772_;
			_tmp1770_ = ma;
			_tmp1771_ = vala_member_access_get_inner (_tmp1770_);
			_tmp1772_ = _tmp1771_;
			_tmp1762_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1772_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1762_ = FALSE;
		}
		if (_tmp1762_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1773_;
			ValaExpression* _tmp1774_;
			ValaExpression* _tmp1775_;
			ValaSymbol* _tmp1776_;
			ValaSymbol* _tmp1777_;
			ValaProperty* _tmp1778_;
			ValaProperty* _tmp1779_;
			ValaMemberAccess* _tmp1780_;
			ValaExpression* _tmp1781_;
			ValaExpression* _tmp1782_;
			ValaExpression* _tmp1783_;
			ValaExpression* _tmp1784_;
			ValaDataType* _tmp1785_;
			ValaDataType* _tmp1786_;
			ValaCCodeExpression* _tmp1787_;
			ValaGLibValue* _tmp1788_;
			ValaGLibValue* _tmp1789_;
			_tmp1773_ = ma;
			_tmp1774_ = vala_member_access_get_inner (_tmp1773_);
			_tmp1775_ = _tmp1774_;
			_tmp1776_ = vala_expression_get_symbol_reference (_tmp1775_);
			_tmp1777_ = _tmp1776_;
			_tmp1778_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1777_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1778_;
			_tmp1779_ = prop;
			_tmp1780_ = ma;
			_tmp1781_ = vala_member_access_get_inner (_tmp1780_);
			_tmp1782_ = _tmp1781_;
			_tmp1783_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1782_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1784_ = _tmp1783_;
			_tmp1785_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1786_ = _tmp1785_;
			_tmp1787_ = ccall_expr;
			_tmp1788_ = vala_glib_value_new (_tmp1786_, _tmp1787_, FALSE);
			_tmp1789_ = _tmp1788_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1779_, _tmp1784_, (ValaTargetValue*) _tmp1789_);
			_vala_target_value_unref0 (_tmp1789_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1790_;
			ValaCCodeExpression* _tmp1791_;
			ValaCCodeAssignment* _tmp1792_;
			_tmp1790_ = instance;
			_tmp1791_ = ccall_expr;
			_tmp1792_ = vala_ccode_assignment_new (_tmp1790_, _tmp1791_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1792_;
		}
	}
	_tmp1798_ = m;
	if (_tmp1798_ != NULL) {
		ValaMethod* _tmp1799_;
		_tmp1799_ = m;
		_tmp1797_ = vala_get_ccode_simple_generics (_tmp1799_);
	} else {
		_tmp1797_ = FALSE;
	}
	if (_tmp1797_) {
		ValaMethod* _tmp1800_;
		ValaDataType* _tmp1801_;
		ValaDataType* _tmp1802_;
		_tmp1800_ = m;
		_tmp1801_ = vala_callable_get_return_type ((ValaCallable*) _tmp1800_);
		_tmp1802_ = _tmp1801_;
		_tmp1796_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1802_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1796_ = FALSE;
	}
	if (_tmp1796_) {
		ValaDataType* _tmp1803_;
		ValaDataType* _tmp1804_;
		_tmp1803_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1804_ = _tmp1803_;
		_tmp1795_ = vala_data_type_is_real_struct_type (_tmp1804_);
	} else {
		_tmp1795_ = FALSE;
	}
	if (_tmp1795_) {
		ValaDataType* _tmp1805_;
		ValaDataType* _tmp1806_;
		gboolean _tmp1807_;
		gboolean _tmp1808_;
		_tmp1805_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1806_ = _tmp1805_;
		_tmp1807_ = vala_data_type_get_nullable (_tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1794_ = !_tmp1808_;
	} else {
		_tmp1794_ = FALSE;
	}
	if (_tmp1794_) {
		ValaDataType* _tmp1809_;
		ValaDataType* _tmp1810_;
		_tmp1809_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1810_ = _tmp1809_;
		_tmp1793_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1810_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1793_ = FALSE;
	}
	if (_tmp1793_) {
		ValaCCodeExpression* _tmp1811_;
		ValaCCodeParenthesizedExpression* _tmp1812_;
		ValaCCodeParenthesizedExpression* _tmp1813_;
		ValaCCodeUnaryExpression* _tmp1814_;
		_tmp1811_ = ccall_expr;
		_tmp1812_ = vala_ccode_parenthesized_expression_new (_tmp1811_);
		_tmp1813_ = _tmp1812_;
		_tmp1814_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1813_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1814_;
		_vala_ccode_node_unref0 (_tmp1813_);
	}
	_tmp1817_ = m;
	if (_tmp1817_ != NULL) {
		ValaMethod* _tmp1818_;
		gchar* _tmp1819_;
		gchar* _tmp1820_;
		_tmp1818_ = m;
		_tmp1819_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1818_);
		_tmp1820_ = _tmp1819_;
		_tmp1816_ = _tmp1820_ != NULL;
		_g_free0 (_tmp1820_);
	} else {
		_tmp1816_ = FALSE;
	}
	if (_tmp1816_) {
		ValaMethod* _tmp1821_;
		gchar* _tmp1822_;
		gchar* _tmp1823_;
		ValaMethod* _tmp1824_;
		ValaDataType* _tmp1825_;
		ValaDataType* _tmp1826_;
		gchar* _tmp1827_;
		gchar* _tmp1828_;
		_tmp1821_ = m;
		_tmp1822_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1824_ = m;
		_tmp1825_ = vala_callable_get_return_type ((ValaCallable*) _tmp1824_);
		_tmp1826_ = _tmp1825_;
		_tmp1827_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1826_);
		_tmp1828_ = _tmp1827_;
		_tmp1815_ = g_strcmp0 (_tmp1823_, _tmp1828_) != 0;
		_g_free0 (_tmp1828_);
		_g_free0 (_tmp1823_);
	} else {
		_tmp1815_ = FALSE;
	}
	if (_tmp1815_) {
		ValaCCodeExpression* _tmp1829_;
		ValaMethod* _tmp1830_;
		ValaDataType* _tmp1831_;
		ValaDataType* _tmp1832_;
		gchar* _tmp1833_;
		gchar* _tmp1834_;
		ValaCCodeCastExpression* _tmp1835_;
		_tmp1829_ = ccall_expr;
		_tmp1830_ = m;
		_tmp1831_ = vala_callable_get_return_type ((ValaCallable*) _tmp1830_);
		_tmp1832_ = _tmp1831_;
		_tmp1833_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1832_);
		_tmp1834_ = _tmp1833_;
		_tmp1835_ = vala_ccode_cast_expression_new (_tmp1829_, _tmp1834_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1835_;
		_g_free0 (_tmp1834_);
	}
	_tmp1836_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1836_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1837_;
		ValaIterator* _tmp1838_;
		ValaIterator* _tmp1839_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1840_;
		gpointer _tmp1841_;
		ValaExpression* _tmp1842_;
		ValaCCodeExpression* _tmp1843_;
		ValaCCodeExpression* _tmp1844_;
		ValaCCodeExpression* _tmp1845_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1846_;
		ValaLocalVariable* _tmp1847_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1848_;
		const gchar* _tmp1849_;
		const gchar* _tmp1850_;
		ValaCCodeExpression* _tmp1851_;
		ValaLocalVariable* _tmp1852_;
		ValaCCodeFile* _tmp1853_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1854_;
		ValaExpression* _tmp1855_;
		ValaExpression* _tmp1856_;
		ValaCCodeExpression* _tmp1857_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1858_;
		ValaExpression* _tmp1859_;
		ValaExpression* _tmp1860_;
		ValaCCodeExpression* _tmp1861_;
		ValaCCodeExpression* _tmp1862_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1863_;
		ValaExpression* _tmp1864_;
		ValaExpression* _tmp1865_;
		ValaDataType* _tmp1866_;
		ValaDataType* _tmp1867_;
		ValaArrayType* _tmp1868_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1869_;
		ValaDataType* _tmp1870_;
		ValaDataType* _tmp1871_;
		gchar* _tmp1872_;
		gchar* _tmp1873_;
		gchar* _tmp1874_;
		gchar* _tmp1875_;
		ValaCCodeIdentifier* _tmp1876_;
		ValaCCodeIdentifier* _tmp1877_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1878_;
		ValaCCodeExpression* _tmp1879_;
		ValaCCodeBinaryExpression* _tmp1880_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1881_;
		ValaCCodeExpression* _tmp1882_;
		ValaCCodeBinaryExpression* _tmp1883_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1884_;
		ValaCCodeIdentifier* _tmp1885_;
		ValaCCodeFunctionCall* _tmp1886_;
		ValaCCodeFunctionCall* _tmp1887_;
		ValaCCodeFunctionCall* _tmp1888_;
		ValaCCodeExpression* _tmp1889_;
		ValaCCodeExpression* _tmp1890_;
		ValaCCodeBinaryExpression* _tmp1891_;
		ValaCCodeBinaryExpression* _tmp1892_;
		ValaCCodeFunctionCall* _tmp1893_;
		ValaCCodeConstant* _tmp1894_;
		ValaCCodeConstant* _tmp1895_;
		ValaCCodeFunctionCall* _tmp1896_;
		ValaCCodeIdentifier* _tmp1897_;
		ValaCCodeBinaryExpression* _tmp1898_;
		ValaCCodeBinaryExpression* _tmp1899_;
		ValaCCodeBinaryExpression* _tmp1900_;
		ValaCCodeFunction* _tmp1901_;
		ValaCCodeFunction* _tmp1902_;
		ValaCCodeExpression* _tmp1903_;
		ValaCCodeExpression* _tmp1904_;
		ValaCCodeFunction* _tmp1905_;
		ValaCCodeFunction* _tmp1906_;
		ValaCCodeExpression* _tmp1907_;
		ValaCCodeFunction* _tmp1908_;
		ValaCCodeFunction* _tmp1909_;
		ValaCCodeBinaryExpression* _tmp1910_;
		ValaCCodeFunctionCall* _tmp1911_;
		ValaCCodeConstant* _tmp1912_;
		ValaCCodeConstant* _tmp1913_;
		ValaCCodeConditionalExpression* _tmp1914_;
		ValaCCodeConditionalExpression* _tmp1915_;
		ValaCCodeFunction* _tmp1916_;
		ValaCCodeFunction* _tmp1917_;
		ValaMemberAccess* _tmp1918_;
		ValaExpression* _tmp1919_;
		ValaExpression* _tmp1920_;
		ValaCCodeExpression* _tmp1921_;
		ValaCCodeExpression* _tmp1922_;
		ValaCCodeExpression* _tmp1923_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1924_;
		ValaExpression* _tmp1925_;
		ValaExpression* _tmp1926_;
		ValaSymbol* _tmp1927_;
		ValaSymbol* _tmp1928_;
		ValaSymbol* _tmp1929_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1930_;
		ValaLocalVariable* _tmp1931_;
		gboolean _tmp1932_ = FALSE;
		gboolean _tmp1933_ = FALSE;
		ValaSymbol* _tmp1934_;
		_tmp1837_ = vala_method_call_get_argument_list (expr);
		_tmp1838_ = vala_iterable_iterator ((ValaIterable*) _tmp1837_);
		arg_it = _tmp1838_;
		_tmp1839_ = arg_it;
		vala_iterator_next (_tmp1839_);
		_tmp1840_ = arg_it;
		_tmp1841_ = vala_iterator_get (_tmp1840_);
		_tmp1842_ = (ValaExpression*) _tmp1841_;
		_tmp1843_ = vala_get_cvalue (_tmp1842_);
		_tmp1844_ = _vala_ccode_node_ref0 (_tmp1843_);
		_tmp1845_ = _tmp1844_;
		_vala_code_node_unref0 (_tmp1842_);
		new_size = _tmp1845_;
		_tmp1846_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1847_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1846_, TRUE, NULL, FALSE);
		temp_decl = _tmp1847_;
		_tmp1848_ = temp_decl;
		_tmp1849_ = vala_symbol_get_name ((ValaSymbol*) _tmp1848_);
		_tmp1850_ = _tmp1849_;
		_tmp1851_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1850_);
		temp_ref = _tmp1851_;
		_tmp1852_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1852_, FALSE);
		_tmp1853_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1853_, "string.h", FALSE);
		_tmp1854_ = ma;
		_tmp1855_ = vala_member_access_get_inner (_tmp1854_);
		_tmp1856_ = _tmp1855_;
		_tmp1857_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1856_, 1);
		clen = _tmp1857_;
		_tmp1858_ = ma;
		_tmp1859_ = vala_member_access_get_inner (_tmp1858_);
		_tmp1860_ = _tmp1859_;
		_tmp1861_ = vala_get_cvalue (_tmp1860_);
		_tmp1862_ = _vala_ccode_node_ref0 (_tmp1861_);
		celems = _tmp1862_;
		_tmp1863_ = ma;
		_tmp1864_ = vala_member_access_get_inner (_tmp1863_);
		_tmp1865_ = _tmp1864_;
		_tmp1866_ = vala_expression_get_value_type (_tmp1865_);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1867_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1868_;
		_tmp1869_ = array_type;
		_tmp1870_ = vala_array_type_get_element_type (_tmp1869_);
		_tmp1871_ = _tmp1870_;
		_tmp1872_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1871_);
		_tmp1873_ = _tmp1872_;
		_tmp1874_ = g_strdup_printf ("sizeof (%s)", _tmp1873_);
		_tmp1875_ = _tmp1874_;
		_tmp1876_ = vala_ccode_identifier_new (_tmp1875_);
		_tmp1877_ = _tmp1876_;
		_g_free0 (_tmp1875_);
		_g_free0 (_tmp1873_);
		csizeof = _tmp1877_;
		_tmp1878_ = temp_ref;
		_tmp1879_ = clen;
		_tmp1880_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1878_, _tmp1879_);
		cdelta = _tmp1880_;
		_tmp1881_ = temp_ref;
		_tmp1882_ = clen;
		_tmp1883_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1881_, _tmp1882_);
		ccheck = _tmp1883_;
		_tmp1884_ = vala_ccode_identifier_new ("memset");
		_tmp1885_ = _tmp1884_;
		_tmp1886_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1885_);
		_tmp1887_ = _tmp1886_;
		_vala_ccode_node_unref0 (_tmp1885_);
		czero = _tmp1887_;
		_tmp1888_ = czero;
		_tmp1889_ = celems;
		_tmp1890_ = clen;
		_tmp1891_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1889_, _tmp1890_);
		_tmp1892_ = _tmp1891_;
		vala_ccode_function_call_add_argument (_tmp1888_, (ValaCCodeExpression*) _tmp1892_);
		_vala_ccode_node_unref0 (_tmp1892_);
		_tmp1893_ = czero;
		_tmp1894_ = vala_ccode_constant_new ("0");
		_tmp1895_ = _tmp1894_;
		vala_ccode_function_call_add_argument (_tmp1893_, (ValaCCodeExpression*) _tmp1895_);
		_vala_ccode_node_unref0 (_tmp1895_);
		_tmp1896_ = czero;
		_tmp1897_ = csizeof;
		_tmp1898_ = cdelta;
		_tmp1899_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1897_, (ValaCCodeExpression*) _tmp1898_);
		_tmp1900_ = _tmp1899_;
		vala_ccode_function_call_add_argument (_tmp1896_, (ValaCCodeExpression*) _tmp1900_);
		_vala_ccode_node_unref0 (_tmp1900_);
		_tmp1901_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1902_ = _tmp1901_;
		_tmp1903_ = temp_ref;
		_tmp1904_ = new_size;
		vala_ccode_function_add_assignment (_tmp1902_, _tmp1903_, _tmp1904_);
		_tmp1905_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1906_ = _tmp1905_;
		_tmp1907_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1906_, _tmp1907_);
		_tmp1908_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1909_ = _tmp1908_;
		_tmp1910_ = ccheck;
		_tmp1911_ = czero;
		_tmp1912_ = vala_ccode_constant_new ("NULL");
		_tmp1913_ = _tmp1912_;
		_tmp1914_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1910_, (ValaCCodeExpression*) _tmp1911_, (ValaCCodeExpression*) _tmp1913_);
		_tmp1915_ = _tmp1914_;
		vala_ccode_function_add_expression (_tmp1909_, (ValaCCodeExpression*) _tmp1915_);
		_vala_ccode_node_unref0 (_tmp1915_);
		_vala_ccode_node_unref0 (_tmp1913_);
		_tmp1916_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1917_ = _tmp1916_;
		_tmp1918_ = ma;
		_tmp1919_ = vala_member_access_get_inner (_tmp1918_);
		_tmp1920_ = _tmp1919_;
		_tmp1921_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1920_, 1);
		_tmp1922_ = _tmp1921_;
		_tmp1923_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1917_, _tmp1922_, _tmp1923_);
		_vala_ccode_node_unref0 (_tmp1922_);
		_tmp1924_ = ma;
		_tmp1925_ = vala_member_access_get_inner (_tmp1924_);
		_tmp1926_ = _tmp1925_;
		_tmp1927_ = vala_expression_get_symbol_reference (_tmp1926_);
		_tmp1928_ = _tmp1927_;
		_tmp1929_ = _vala_code_node_ref0 (_tmp1928_);
		array_var = _tmp1929_;
		_tmp1930_ = array_var;
		_tmp1931_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1930_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1930_) : NULL);
		array_local = _tmp1931_;
		_tmp1934_ = array_var;
		if (_tmp1934_ != NULL) {
			ValaSymbol* _tmp1935_;
			_tmp1935_ = array_var;
			_tmp1933_ = vala_symbol_is_internal_symbol (_tmp1935_);
		} else {
			_tmp1933_ = FALSE;
		}
		if (_tmp1933_) {
			gboolean _tmp1936_ = FALSE;
			gboolean _tmp1937_ = FALSE;
			ValaSymbol* _tmp1938_;
			_tmp1938_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1938_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1939_;
				gboolean _tmp1940_;
				gboolean _tmp1941_;
				_tmp1939_ = array_local;
				_tmp1940_ = vala_local_variable_get_captured (_tmp1939_);
				_tmp1941_ = _tmp1940_;
				_tmp1937_ = !_tmp1941_;
			} else {
				_tmp1937_ = FALSE;
			}
			if (_tmp1937_) {
				_tmp1936_ = TRUE;
			} else {
				ValaSymbol* _tmp1942_;
				_tmp1942_ = array_var;
				_tmp1936_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1942_, VALA_TYPE_FIELD);
			}
			_tmp1932_ = _tmp1936_;
		} else {
			_tmp1932_ = FALSE;
		}
		if (_tmp1932_) {
			ValaCCodeFunction* _tmp1943_;
			ValaCCodeFunction* _tmp1944_;
			ValaMemberAccess* _tmp1945_;
			ValaExpression* _tmp1946_;
			ValaExpression* _tmp1947_;
			ValaTargetValue* _tmp1948_;
			ValaTargetValue* _tmp1949_;
			ValaCCodeExpression* _tmp1950_;
			ValaCCodeExpression* _tmp1951_;
			_tmp1943_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1944_ = _tmp1943_;
			_tmp1945_ = ma;
			_tmp1946_ = vala_member_access_get_inner (_tmp1945_);
			_tmp1947_ = _tmp1946_;
			_tmp1948_ = vala_expression_get_target_value (_tmp1947_);
			_tmp1949_ = _tmp1948_;
			_tmp1950_ = vala_get_array_size_cvalue (_tmp1949_);
			_tmp1951_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1944_, _tmp1950_, _tmp1951_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1953_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1954_ = _tmp1953_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1954_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1955_;
		ValaDataType* _tmp1956_;
		_tmp1955_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1956_ = _tmp1955_;
		_tmp1952_ = !vala_data_type_is_disposable (_tmp1956_);
	} else {
		_tmp1952_ = FALSE;
	}
	if (_tmp1952_) {
		gboolean _tmp1957_ = FALSE;
		ValaCCodeExpression* _tmp1958_;
		_tmp1958_ = ccall_expr;
		if (_tmp1958_ != NULL) {
			_tmp1957_ = !return_result_via_out_param;
		} else {
			_tmp1957_ = FALSE;
		}
		if (_tmp1957_) {
			ValaCCodeFunction* _tmp1959_;
			ValaCCodeFunction* _tmp1960_;
			ValaCCodeExpression* _tmp1961_;
			_tmp1959_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1960_ = _tmp1959_;
			_tmp1961_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1960_, _tmp1961_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1962_;
		ValaDataType* _tmp1963_;
		ValaDataType* _tmp1964_;
		gboolean _tmp1965_ = FALSE;
		ValaDataType* _tmp1966_;
		ValaDataType* _tmp1967_;
		gboolean _tmp2020_ = FALSE;
		ValaMethod* _tmp2021_;
		_tmp1962_ = itype;
		_tmp1963_ = vala_data_type_get_return_type (_tmp1962_);
		_tmp1964_ = _vala_code_node_ref0 (_tmp1963_);
		result_type = _tmp1964_;
		_tmp1966_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1967_ = _tmp1966_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1967_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1968_;
			ValaDataType* _tmp1969_;
			_tmp1968_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1969_ = _tmp1968_;
			_tmp1965_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1969_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1965_ = FALSE;
		}
		if (_tmp1965_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1970_;
			ValaDataType* _tmp1971_;
			ValaTypeParameter* _tmp1972_;
			ValaTypeParameter* _tmp1973_;
			ValaTypeParameter* _tmp1974_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1975_;
			ValaSymbol* _tmp1976_;
			ValaSymbol* _tmp1977_;
			ValaSymbol* _tmp1978_;
			ValaSymbol* _tmp1979_;
			ValaStruct* _tmp1980_;
			gboolean _tmp1981_ = FALSE;
			ValaTypeParameter* _tmp1982_;
			ValaSymbol* _tmp1983_;
			ValaSymbol* _tmp1984_;
			ValaTypeSymbol* _tmp1985_;
			gboolean _tmp1994_ = FALSE;
			gboolean _tmp1995_ = FALSE;
			ValaStruct* _tmp1996_;
			_tmp1970_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1971_ = _tmp1970_;
			_tmp1972_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1971_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1973_ = _tmp1972_;
			_tmp1974_ = _vala_code_node_ref0 (_tmp1973_);
			type_parameter = _tmp1974_;
			_tmp1975_ = type_parameter;
			_tmp1976_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1975_);
			_tmp1977_ = _tmp1976_;
			_tmp1978_ = vala_symbol_get_parent_symbol (_tmp1977_);
			_tmp1979_ = _tmp1978_;
			_tmp1980_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1979_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1979_) : NULL);
			st = _tmp1980_;
			_tmp1982_ = type_parameter;
			_tmp1983_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1982_);
			_tmp1984_ = _tmp1983_;
			_tmp1985_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1984_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1985_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1981_ = TRUE;
			} else {
				gboolean _tmp1986_ = FALSE;
				ValaStruct* _tmp1987_;
				_tmp1987_ = st;
				if (_tmp1987_ != NULL) {
					ValaStruct* _tmp1988_;
					gchar* _tmp1989_;
					gchar* _tmp1990_;
					_tmp1988_ = st;
					_tmp1989_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1988_);
					_tmp1990_ = _tmp1989_;
					_tmp1986_ = g_strcmp0 (_tmp1990_, "va_list") == 0;
					_g_free0 (_tmp1990_);
				} else {
					_tmp1986_ = FALSE;
				}
				_tmp1981_ = _tmp1986_;
			}
			if (_tmp1981_) {
				ValaDataType* _tmp1991_;
				ValaDataType* _tmp1992_;
				ValaDataType* _tmp1993_;
				_tmp1991_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1992_ = _tmp1991_;
				_tmp1993_ = _vala_code_node_ref0 (_tmp1992_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1993_;
			}
			_tmp1996_ = st;
			if (_tmp1996_ != NULL) {
				ValaStruct* _tmp1997_;
				gchar* _tmp1998_;
				gchar* _tmp1999_;
				_tmp1997_ = st;
				_tmp1998_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1997_);
				_tmp1999_ = _tmp1998_;
				_tmp1995_ = g_strcmp0 (_tmp1999_, "va_list") == 0;
				_g_free0 (_tmp1999_);
			} else {
				_tmp1995_ = FALSE;
			}
			if (_tmp1995_) {
				ValaMemberAccess* _tmp2000_;
				const gchar* _tmp2001_;
				const gchar* _tmp2002_;
				_tmp2000_ = ma;
				_tmp2001_ = vala_member_access_get_member_name (_tmp2000_);
				_tmp2002_ = _tmp2001_;
				_tmp1994_ = g_strcmp0 (_tmp2002_, "arg") == 0;
			} else {
				_tmp1994_ = FALSE;
			}
			if (_tmp1994_) {
				gboolean _tmp2003_ = FALSE;
				ValaDataType* _tmp2004_;
				_tmp2004_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2004_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2005_;
					ValaDelegate* _tmp2006_;
					ValaDelegate* _tmp2007_;
					gboolean _tmp2008_;
					gboolean _tmp2009_;
					_tmp2005_ = result_type;
					_tmp2006_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2005_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2007_ = _tmp2006_;
					_tmp2008_ = vala_delegate_get_has_target (_tmp2007_);
					_tmp2009_ = _tmp2008_;
					_tmp2003_ = _tmp2009_;
				} else {
					_tmp2003_ = FALSE;
				}
				if (_tmp2003_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2010_;
					ValaTargetValue* _tmp2011_;
					ValaGLibValue* _tmp2012_;
					ValaCCodeExpression* _tmp2013_;
					ValaGLibValue* _tmp2016_;
					ValaCCodeExpression* _tmp2017_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2010_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2011_ = _tmp2010_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2011_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2012_ = arg_value;
					_tmp2013_ = _tmp2012_->delegate_target_cvalue;
					if (_tmp2013_ == NULL) {
						ValaGLibValue* _tmp2014_;
						ValaCCodeConstant* _tmp2015_;
						_tmp2014_ = arg_value;
						_tmp2015_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2014_->delegate_target_cvalue);
						_tmp2014_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2015_;
					}
					_tmp2016_ = arg_value;
					_tmp2017_ = _tmp2016_->delegate_target_destroy_notify_cvalue;
					if (_tmp2017_ == NULL) {
						ValaGLibValue* _tmp2018_;
						ValaCCodeConstant* _tmp2019_;
						_tmp2018_ = arg_value;
						_tmp2019_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2018_->delegate_target_destroy_notify_cvalue);
						_tmp2018_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2019_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2021_ = m;
		if (_tmp2021_ != NULL) {
			ValaMethod* _tmp2022_;
			_tmp2022_ = m;
			_tmp2020_ = vala_method_get_format_arg_index (_tmp2022_) >= 0;
		} else {
			_tmp2020_ = FALSE;
		}
		if (_tmp2020_) {
			ValaCCodeExpression* _tmp2023_;
			_tmp2023_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2023_);
		} else {
			gboolean _tmp2024_ = FALSE;
			ValaMethod* _tmp2025_;
			_tmp2025_ = m;
			if (_tmp2025_ != NULL) {
				ValaMethod* _tmp2026_;
				_tmp2026_ = m;
				_tmp2024_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2026_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2024_ = FALSE;
			}
			if (_tmp2024_) {
				ValaCCodeExpression* _tmp2027_;
				_tmp2027_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2027_);
			} else {
				gboolean _tmp2028_ = FALSE;
				gboolean _tmp2029_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2029_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2029_ = FALSE;
				}
				if (_tmp2029_) {
					gboolean _tmp2030_ = FALSE;
					ValaDataType* _tmp2031_;
					_tmp2031_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2031_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2032_;
						_tmp2032_ = result_type;
						_tmp2030_ = !vala_data_type_is_disposable (_tmp2032_);
					} else {
						_tmp2030_ = FALSE;
					}
					_tmp2028_ = _tmp2030_;
				} else {
					_tmp2028_ = FALSE;
				}
				if (_tmp2028_) {
					ValaCCodeExpression* _tmp2033_;
					_tmp2033_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2033_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2034_;
						ValaDataType* _tmp2035_;
						gboolean _tmp2036_;
						gboolean _tmp2037_;
						ValaLocalVariable* _tmp2038_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2039_;
						const gchar* _tmp2040_;
						const gchar* _tmp2041_;
						ValaCCodeExpression* _tmp2042_;
						ValaLocalVariable* _tmp2043_;
						ValaCCodeFunction* _tmp2044_;
						ValaCCodeFunction* _tmp2045_;
						ValaCCodeExpression* _tmp2046_;
						ValaCCodeExpression* _tmp2047_;
						ValaCCodeExpression* _tmp2048_;
						ValaTargetValue* _tmp2049_;
						ValaTargetValue* _tmp2050_;
						_tmp2034_ = result_type;
						_tmp2035_ = result_type;
						_tmp2036_ = vala_data_type_get_value_owned (_tmp2035_);
						_tmp2037_ = _tmp2036_;
						_tmp2038_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2034_, _tmp2037_, NULL, FALSE);
						temp_var = _tmp2038_;
						_tmp2039_ = temp_var;
						_tmp2040_ = vala_symbol_get_name ((ValaSymbol*) _tmp2039_);
						_tmp2041_ = _tmp2040_;
						_tmp2042_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2041_);
						temp_ref = _tmp2042_;
						_tmp2043_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2043_, FALSE);
						_tmp2044_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2045_ = _tmp2044_;
						_tmp2046_ = temp_ref;
						_tmp2047_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2045_, _tmp2046_, _tmp2047_);
						_tmp2048_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2048_);
						_tmp2049_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2050_ = _tmp2049_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2050_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2051_;
						ValaTargetValue* _tmp2052_;
						ValaTargetValue* _tmp2053_;
						_tmp2051_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2051_);
						_tmp2052_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2053_ = _tmp2052_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2053_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2054_ = params;
	_tmp2055_ = vala_iterable_iterator ((ValaIterable*) _tmp2054_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2055_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2056_;
		ValaList* _tmp2057_;
		gint _arg_size = 0;
		ValaList* _tmp2058_;
		gint _tmp2059_;
		gint _tmp2060_;
		gint _arg_index = 0;
		_tmp2056_ = vala_method_call_get_argument_list (expr);
		_tmp2057_ = _vala_iterable_ref0 (_tmp2056_);
		_arg_list = _tmp2057_;
		_tmp2058_ = _arg_list;
		_tmp2059_ = vala_collection_get_size ((ValaCollection*) _tmp2058_);
		_tmp2060_ = _tmp2059_;
		_arg_size = _tmp2060_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp2061_;
			gpointer _tmp2062_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2063_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2066_;
			ValaUnaryExpression* _tmp2067_;
			gboolean _tmp2068_ = FALSE;
			ValaUnaryExpression* _tmp2069_;
			ValaUnaryExpression* _tmp2073_;
			ValaExpression* _tmp2074_;
			ValaExpression* _tmp2075_;
			ValaDataType* _tmp2076_;
			ValaDataType* _tmp2077_;
			gboolean _tmp2087_ = FALSE;
			ValaMemberAccess* _tmp2088_;
			ValaSymbol* _tmp2089_;
			ValaSymbol* _tmp2090_;
			ValaUnaryExpression* _tmp2106_;
			ValaExpression* _tmp2107_;
			ValaExpression* _tmp2108_;
			ValaTargetValue* _tmp2109_;
			ValaTargetValue* _tmp2110_;
			ValaUnaryExpression* _tmp2111_;
			ValaTargetValue* _tmp2112_;
			ValaTargetValue* _tmp2113_;
			ValaUnaryExpression* _tmp2114_;
			ValaExpression* _tmp2115_;
			ValaExpression* _tmp2116_;
			ValaDataType* _tmp2117_;
			ValaDataType* _tmp2118_;
			ValaExpression* _tmp2119_;
			ValaTargetValue* _tmp2120_;
			ValaTargetValue* _tmp2121_;
			ValaSourceReference* _tmp2122_;
			ValaSourceReference* _tmp2123_;
			gboolean _tmp2124_ = FALSE;
			ValaParameter* _tmp2125_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp2061_ = _arg_list;
			_tmp2062_ = vala_list_get (_tmp2061_, _arg_index);
			arg = (ValaExpression*) _tmp2062_;
			param = NULL;
			_tmp2063_ = params_it;
			if (vala_iterator_next (_tmp2063_)) {
				ValaIterator* _tmp2064_;
				gpointer _tmp2065_;
				_tmp2064_ = params_it;
				_tmp2065_ = vala_iterator_get (_tmp2064_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2065_;
			}
			_tmp2066_ = arg;
			_tmp2067_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2066_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2066_) : NULL);
			unary = _tmp2067_;
			_tmp2069_ = unary;
			if (_tmp2069_ == NULL) {
				_tmp2068_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2070_;
				ValaUnaryOperator _tmp2071_;
				ValaUnaryOperator _tmp2072_;
				_tmp2070_ = unary;
				_tmp2071_ = vala_unary_expression_get_operator (_tmp2070_);
				_tmp2072_ = _tmp2071_;
				_tmp2068_ = _tmp2072_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2068_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2073_ = unary;
			_tmp2074_ = vala_unary_expression_get_inner (_tmp2073_);
			_tmp2075_ = _tmp2074_;
			_tmp2076_ = vala_expression_get_value_type (_tmp2075_);
			_tmp2077_ = _tmp2076_;
			if (vala_ccode_base_module_requires_destroy (_tmp2077_)) {
				ValaCCodeFunction* _tmp2078_;
				ValaCCodeFunction* _tmp2079_;
				ValaUnaryExpression* _tmp2080_;
				ValaExpression* _tmp2081_;
				ValaExpression* _tmp2082_;
				ValaTargetValue* _tmp2083_;
				ValaTargetValue* _tmp2084_;
				ValaCCodeExpression* _tmp2085_;
				ValaCCodeExpression* _tmp2086_;
				_tmp2078_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2079_ = _tmp2078_;
				_tmp2080_ = unary;
				_tmp2081_ = vala_unary_expression_get_inner (_tmp2080_);
				_tmp2082_ = _tmp2081_;
				_tmp2083_ = vala_expression_get_target_value (_tmp2082_);
				_tmp2084_ = _tmp2083_;
				_tmp2085_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2084_, FALSE);
				_tmp2086_ = _tmp2085_;
				vala_ccode_function_add_expression (_tmp2079_, _tmp2086_);
				_vala_ccode_node_unref0 (_tmp2086_);
			}
			_tmp2088_ = ma;
			_tmp2089_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2088_);
			_tmp2090_ = _tmp2089_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2090_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2091_;
				ValaTargetValue* _tmp2092_;
				ValaTargetValue* _tmp2093_;
				ValaDataType* _tmp2094_;
				ValaDataType* _tmp2095_;
				_tmp2091_ = unary;
				_tmp2092_ = vala_expression_get_target_value ((ValaExpression*) _tmp2091_);
				_tmp2093_ = _tmp2092_;
				_tmp2094_ = vala_target_value_get_value_type (_tmp2093_);
				_tmp2095_ = _tmp2094_;
				_tmp2087_ = _tmp2095_ == NULL;
			} else {
				_tmp2087_ = FALSE;
			}
			if (_tmp2087_) {
				ValaUnaryExpression* _tmp2096_;
				ValaTargetValue* _tmp2097_;
				ValaTargetValue* _tmp2098_;
				ValaUnaryExpression* _tmp2099_;
				ValaExpression* _tmp2100_;
				ValaExpression* _tmp2101_;
				ValaDataType* _tmp2102_;
				ValaDataType* _tmp2103_;
				ValaDataType* _tmp2104_;
				ValaDataType* _tmp2105_;
				_tmp2096_ = unary;
				_tmp2097_ = vala_expression_get_target_value ((ValaExpression*) _tmp2096_);
				_tmp2098_ = _tmp2097_;
				_tmp2099_ = unary;
				_tmp2100_ = vala_unary_expression_get_inner (_tmp2099_);
				_tmp2101_ = _tmp2100_;
				_tmp2102_ = vala_expression_get_value_type (_tmp2101_);
				_tmp2103_ = _tmp2102_;
				_tmp2104_ = vala_data_type_copy (_tmp2103_);
				_tmp2105_ = _tmp2104_;
				vala_target_value_set_value_type (_tmp2098_, _tmp2105_);
				_vala_code_node_unref0 (_tmp2105_);
			}
			_tmp2106_ = unary;
			_tmp2107_ = vala_unary_expression_get_inner (_tmp2106_);
			_tmp2108_ = _tmp2107_;
			_tmp2109_ = vala_expression_get_target_value (_tmp2108_);
			_tmp2110_ = _tmp2109_;
			_tmp2111_ = unary;
			_tmp2112_ = vala_expression_get_target_value ((ValaExpression*) _tmp2111_);
			_tmp2113_ = _tmp2112_;
			_tmp2114_ = unary;
			_tmp2115_ = vala_unary_expression_get_inner (_tmp2114_);
			_tmp2116_ = _tmp2115_;
			_tmp2117_ = vala_expression_get_value_type (_tmp2116_);
			_tmp2118_ = _tmp2117_;
			_tmp2119_ = arg;
			_tmp2120_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2113_, _tmp2118_, (ValaCodeNode*) _tmp2119_);
			_tmp2121_ = _tmp2120_;
			_tmp2122_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2123_ = _tmp2122_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2110_, _tmp2121_, _tmp2123_);
			_vala_target_value_unref0 (_tmp2121_);
			_tmp2125_ = param;
			if (_tmp2125_ != NULL) {
				ValaParameter* _tmp2126_;
				_tmp2126_ = param;
				_tmp2124_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2126_);
			} else {
				_tmp2124_ = FALSE;
			}
			if (_tmp2124_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2127_;
				ValaCCodeIdentifier* _tmp2128_;
				ValaCCodeFunctionCall* _tmp2129_;
				ValaCCodeFunctionCall* _tmp2130_;
				ValaCCodeFunctionCall* _tmp2131_;
				ValaUnaryExpression* _tmp2132_;
				ValaExpression* _tmp2133_;
				ValaExpression* _tmp2134_;
				ValaTargetValue* _tmp2135_;
				ValaTargetValue* _tmp2136_;
				ValaCCodeExpression* _tmp2137_;
				ValaCCodeFunction* _tmp2138_;
				ValaCCodeFunction* _tmp2139_;
				ValaUnaryExpression* _tmp2140_;
				ValaExpression* _tmp2141_;
				ValaExpression* _tmp2142_;
				ValaTargetValue* _tmp2143_;
				ValaTargetValue* _tmp2144_;
				ValaCCodeExpression* _tmp2145_;
				ValaCCodeExpression* _tmp2146_;
				ValaCCodeFunctionCall* _tmp2147_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2127_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2128_ = _tmp2127_;
				_tmp2129_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2128_);
				_tmp2130_ = _tmp2129_;
				_vala_ccode_node_unref0 (_tmp2128_);
				len_call = _tmp2130_;
				_tmp2131_ = len_call;
				_tmp2132_ = unary;
				_tmp2133_ = vala_unary_expression_get_inner (_tmp2132_);
				_tmp2134_ = _tmp2133_;
				_tmp2135_ = vala_expression_get_target_value (_tmp2134_);
				_tmp2136_ = _tmp2135_;
				_tmp2137_ = vala_get_cvalue_ (_tmp2136_);
				vala_ccode_function_call_add_argument (_tmp2131_, _tmp2137_);
				_tmp2138_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2139_ = _tmp2138_;
				_tmp2140_ = unary;
				_tmp2141_ = vala_unary_expression_get_inner (_tmp2140_);
				_tmp2142_ = _tmp2141_;
				_tmp2143_ = vala_expression_get_target_value (_tmp2142_);
				_tmp2144_ = _tmp2143_;
				_tmp2145_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2144_, 1);
				_tmp2146_ = _tmp2145_;
				_tmp2147_ = len_call;
				vala_ccode_function_add_assignment (_tmp2139_, _tmp2146_, (ValaCCodeExpression*) _tmp2147_);
				_vala_ccode_node_unref0 (_tmp2146_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2150_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2150_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2151_;
		ValaSymbol* _tmp2152_;
		ValaSymbol* _tmp2153_;
		_tmp2151_ = m;
		_tmp2152_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2151_);
		_tmp2153_ = _tmp2152_;
		_tmp2149_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2153_, VALA_TYPE_CLASS);
	} else {
		_tmp2149_ = FALSE;
	}
	if (_tmp2149_) {
		gboolean _tmp2154_ = FALSE;
		gboolean _tmp2155_ = FALSE;
		ValaClass* _tmp2156_;
		ValaClass* _tmp2157_;
		gboolean _tmp2158_;
		gboolean _tmp2159_;
		_tmp2156_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2157_ = _tmp2156_;
		_tmp2158_ = vala_class_get_is_compact (_tmp2157_);
		_tmp2159_ = _tmp2158_;
		if (_tmp2159_) {
			ValaClass* _tmp2160_;
			ValaClass* _tmp2161_;
			ValaClass* _tmp2162_;
			ValaClass* _tmp2163_;
			_tmp2160_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2161_ = _tmp2160_;
			_tmp2162_ = vala_class_get_base_class (_tmp2161_);
			_tmp2163_ = _tmp2162_;
			_tmp2155_ = _tmp2163_ != NULL;
		} else {
			_tmp2155_ = FALSE;
		}
		if (_tmp2155_) {
			_tmp2154_ = TRUE;
		} else {
			ValaClass* _tmp2164_;
			ValaClass* _tmp2165_;
			ValaClass* _tmp2166_;
			ValaClass* _tmp2167_;
			ValaClass* _tmp2168_;
			_tmp2164_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2165_ = _tmp2164_;
			_tmp2166_ = vala_class_get_base_class (_tmp2165_);
			_tmp2167_ = _tmp2166_;
			_tmp2168_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2154_ = _tmp2167_ == _tmp2168_;
		}
		_tmp2148_ = _tmp2154_;
	} else {
		_tmp2148_ = FALSE;
	}
	if (_tmp2148_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2169_;
		ValaClass* _tmp2170_;
		gchar* _tmp2171_;
		gchar* _tmp2172_;
		gchar* _tmp2173_;
		gchar* _tmp2174_;
		ValaCCodeIdentifier* _tmp2175_;
		ValaCCodeIdentifier* _tmp2176_;
		ValaCCodeFunctionCall* _tmp2177_;
		ValaCCodeFunctionCall* _tmp2178_;
		ValaCCodeFunctionCall* _tmp2179_;
		ValaCCodeExpression* _tmp2180_;
		ValaCCodeExpression* _tmp2181_;
		ValaClass* _tmp2182_;
		ValaClass* _tmp2183_;
		gboolean _tmp2184_;
		gboolean _tmp2185_;
		ValaCCodeFunction* _tmp2189_;
		ValaCCodeFunction* _tmp2190_;
		ValaCCodeFunctionCall* _tmp2191_;
		_tmp2169_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2170_ = _tmp2169_;
		_tmp2171_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2170_, NULL);
		_tmp2172_ = _tmp2171_;
		_tmp2173_ = g_strdup_printf ("%s_instance_init", _tmp2172_);
		_tmp2174_ = _tmp2173_;
		_tmp2175_ = vala_ccode_identifier_new (_tmp2174_);
		_tmp2176_ = _tmp2175_;
		_tmp2177_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2176_);
		_tmp2178_ = _tmp2177_;
		_vala_ccode_node_unref0 (_tmp2176_);
		_g_free0 (_tmp2174_);
		_g_free0 (_tmp2172_);
		cinitcall = _tmp2178_;
		_tmp2179_ = cinitcall;
		_tmp2180_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2181_ = _tmp2180_;
		vala_ccode_function_call_add_argument (_tmp2179_, _tmp2181_);
		_vala_ccode_node_unref0 (_tmp2181_);
		_tmp2182_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2183_ = _tmp2182_;
		_tmp2184_ = vala_class_get_is_compact (_tmp2183_);
		_tmp2185_ = _tmp2184_;
		if (!_tmp2185_) {
			ValaCCodeFunctionCall* _tmp2186_;
			ValaCCodeConstant* _tmp2187_;
			ValaCCodeConstant* _tmp2188_;
			_tmp2186_ = cinitcall;
			_tmp2187_ = vala_ccode_constant_new ("NULL");
			_tmp2188_ = _tmp2187_;
			vala_ccode_function_call_add_argument (_tmp2186_, (ValaCCodeExpression*) _tmp2188_);
			_vala_ccode_node_unref0 (_tmp2188_);
		}
		_tmp2189_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2190_ = _tmp2189_;
		_tmp2191_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2190_, (ValaCCodeExpression*) _tmp2191_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeFile* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaEnumValue* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaEnumValue* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp25_ = _enum_value_list;
			_tmp26_ = vala_list_get (_tmp25_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp26_;
			_tmp27_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp28_ = _tmp27_;
			_tmp29_ = enum_value;
			_tmp30_ = vala_get_ccode_name ((ValaCodeNode*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_ccode_identifier_new (_tmp31_);
			_tmp33_ = _tmp32_;
			vala_ccode_function_add_case (_tmp28_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
			_g_free0 (_tmp31_);
			_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = enum_value;
			_tmp37_ = vala_get_ccode_name ((ValaCodeNode*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat ("\"", _tmp38_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp40_, "\"", NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_ccode_constant_new (_tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_function_add_return (_tmp35_, (ValaCCodeExpression*) _tmp44_);
			_vala_ccode_node_unref0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp46_ = _tmp45_;
	vala_ccode_function_close (_tmp46_);
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_ccode_constant_new ("NULL");
	_tmp50_ = _tmp49_;
	vala_ccode_function_add_return (_tmp48_, (ValaCCodeExpression*) _tmp50_);
	_vala_ccode_node_unref0 (_tmp50_);
	_tmp51_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp52_ = function;
	vala_ccode_file_add_function_declaration (_tmp51_, _tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function (_tmp53_, _tmp54_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaUnaryExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp7_) : NULL;
			_tmp9_ = unary;
			if (_tmp9_ != NULL) {
				gboolean _tmp10_ = FALSE;
				ValaUnaryExpression* _tmp11_;
				ValaUnaryOperator _tmp12_;
				ValaUnaryOperator _tmp13_;
				_tmp11_ = unary;
				_tmp12_ = vala_unary_expression_get_operator (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp10_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp14_;
					ValaUnaryOperator _tmp15_;
					ValaUnaryOperator _tmp16_;
					_tmp14_ = unary;
					_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp10_ = _tmp16_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp8_ = _tmp10_;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

