/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp543_ = FALSE;
	gboolean _tmp544_ = FALSE;
	gboolean _tmp545_ = FALSE;
	ValaExpression* _tmp546_;
	ValaExpression* _tmp547_;
	ValaSymbol* _tmp573_;
	ValaSymbol* _tmp574_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp622_;
	ValaSymbol* _tmp623_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp624_;
	ValaSymbol* _tmp625_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1012_;
	ValaSymbol* _tmp1013_;
	ValaSymbol* _tmp1015_;
	ValaVersionAttribute* _tmp1016_;
	ValaVersionAttribute* _tmp1017_;
	ValaSourceReference* _tmp1018_;
	ValaSourceReference* _tmp1019_;
	gboolean _tmp1020_ = FALSE;
	ValaSymbolAccessibility _tmp1021_;
	gboolean _tmp1077_ = FALSE;
	gboolean _tmp1104_ = FALSE;
	gboolean _tmp1105_ = FALSE;
	ValaDataType* _tmp1357_;
	ValaDataType* _tmp1358_;
	gboolean _tmp1361_;
	gboolean _tmp1362_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		const gchar* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		base_symbol = (ValaSymbol*) _tmp18_;
		_tmp19_ = base_symbol;
		_tmp20_ = vala_symbol_get_scope (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_scope_lookup (_tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp25_ = vala_member_access_get_inner (self);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == NULL) {
			const gchar* _tmp27_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean _tmp138_ = FALSE;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp27_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp27_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp28_;
				ValaSemanticAnalyzer* _tmp29_;
				_tmp28_ = vala_code_context_get_analyzer (context);
				_tmp29_ = _tmp28_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp29_)) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp32_ = vala_code_context_get_analyzer (context);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_semantic_analyzer_get_current_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			base_symbol = _tmp35_;
			method_found = FALSE;
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			sym = _tmp39_;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				ValaSymbol* _tmp41_;
				ValaSymbol* _tmp87_;
				const gchar* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp132_;
				ValaSymbol* _tmp133_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp137_;
				_tmp41_ = sym;
				if (_tmp41_ != NULL) {
					ValaSymbol* _tmp42_;
					ValaSymbol* _tmp43_;
					_tmp42_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp43_ = _tmp42_;
					_tmp40_ = _tmp43_ == NULL;
				} else {
					_tmp40_ = FALSE;
				}
				if (!_tmp40_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp44_;
					_tmp44_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp44_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp45_;
						ValaCreationMethod* _tmp46_;
						ValaParameter* _tmp47_;
						ValaParameter* _tmp48_;
						_tmp45_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp46_ = cm;
						_tmp47_ = vala_method_get_this_parameter ((ValaMethod*) _tmp46_);
						_tmp48_ = _tmp47_;
						this_parameter = _tmp48_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp49_;
						_tmp49_ = sym;
						if (VALA_IS_PROPERTY (_tmp49_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp50_;
							ValaProperty* _tmp51_;
							ValaParameter* _tmp52_;
							ValaParameter* _tmp53_;
							ValaProperty* _tmp54_;
							ValaMemberBinding _tmp55_;
							ValaMemberBinding _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							_tmp50_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp51_ = prop;
							_tmp52_ = vala_property_get_this_parameter (_tmp51_);
							_tmp53_ = _tmp52_;
							this_parameter = _tmp53_;
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_binding (_tmp54_);
							_tmp56_ = _tmp55_;
							may_access_instance_members = _tmp56_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_klass_members = _tmp59_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp60_;
							_tmp60_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp60_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp61_;
								ValaConstructor* _tmp62_;
								ValaParameter* _tmp63_;
								ValaParameter* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaMemberBinding _tmp66_;
								ValaMemberBinding _tmp67_;
								_tmp61_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp62_ = c;
								_tmp63_ = vala_constructor_get_this_parameter (_tmp62_);
								_tmp64_ = _tmp63_;
								this_parameter = _tmp64_;
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_binding (_tmp65_);
								_tmp67_ = _tmp66_;
								may_access_instance_members = _tmp67_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp68_;
								_tmp68_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp68_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp69_;
									ValaDestructor* _tmp70_;
									ValaParameter* _tmp71_;
									ValaParameter* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaMemberBinding _tmp74_;
									ValaMemberBinding _tmp75_;
									_tmp69_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp70_ = d;
									_tmp71_ = vala_destructor_get_this_parameter (_tmp70_);
									_tmp72_ = _tmp71_;
									this_parameter = _tmp72_;
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_binding (_tmp73_);
									_tmp75_ = _tmp74_;
									may_access_instance_members = _tmp75_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp76_;
									_tmp76_ = sym;
									if (VALA_IS_METHOD (_tmp76_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp77_;
										ValaMethod* _tmp78_;
										ValaParameter* _tmp79_;
										ValaParameter* _tmp80_;
										ValaMethod* _tmp81_;
										ValaMemberBinding _tmp82_;
										ValaMemberBinding _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										_tmp77_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_METHOD, ValaMethod);
										_tmp78_ = m;
										_tmp79_ = vala_method_get_this_parameter (_tmp78_);
										_tmp80_ = _tmp79_;
										this_parameter = _tmp80_;
										_tmp81_ = m;
										_tmp82_ = vala_method_get_binding (_tmp81_);
										_tmp83_ = _tmp82_;
										may_access_instance_members = _tmp83_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_klass_members = _tmp86_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp87_ = sym;
				_tmp88_ = self->priv->_member_name;
				_tmp89_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp87_, _tmp88_);
				_tmp90_ = _tmp89_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp90_);
				_vala_code_node_unref0 (_tmp90_);
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp94_ = _tmp93_;
				if (_tmp94_ == NULL) {
					ValaSymbol* _tmp95_;
					_tmp95_ = sym;
					_tmp92_ = VALA_IS_TYPESYMBOL (_tmp95_);
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					_tmp91_ = may_access_instance_members;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaParameter* _tmp96_;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					const gchar* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					gboolean _tmp102_ = FALSE;
					ValaSymbol* _tmp103_;
					ValaSymbol* _tmp104_;
					_tmp96_ = this_parameter;
					_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = self->priv->_member_name;
					_tmp100_ = vala_data_type_get_member (_tmp98_, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp101_);
					_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp104_ = _tmp103_;
					if (_tmp104_ != NULL) {
						ValaSymbol* _tmp105_;
						ValaSymbol* _tmp106_;
						_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp106_ = _tmp105_;
						_tmp102_ = vala_member_access_is_instance_symbol (_tmp106_);
					} else {
						_tmp102_ = FALSE;
					}
					if (_tmp102_) {
						ValaSourceReference* _tmp107_;
						ValaSourceReference* _tmp108_;
						ValaMemberAccess* _tmp109_;
						ValaMemberAccess* _tmp110_;
						ValaExpression* _tmp111_;
						ValaExpression* _tmp112_;
						ValaParameter* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaExpression* _tmp118_;
						ValaExpression* _tmp119_;
						ValaDataType* _tmp120_;
						ValaDataType* _tmp121_;
						ValaExpression* _tmp122_;
						ValaExpression* _tmp123_;
						ValaParameter* _tmp124_;
						ValaExpression* _tmp125_;
						ValaExpression* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						const gchar* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaSymbol* _tmp131_;
						_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_member_access_new (NULL, "this", _tmp108_);
						_tmp110_ = _tmp109_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp110_);
						_vala_code_node_unref0 (_tmp110_);
						_tmp111_ = vala_member_access_get_inner (self);
						_tmp112_ = _tmp111_;
						_tmp113_ = this_parameter;
						_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) _tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_data_type_copy (_tmp115_);
						_tmp117_ = _tmp116_;
						vala_expression_set_value_type (_tmp112_, _tmp117_);
						_vala_code_node_unref0 (_tmp117_);
						_tmp118_ = vala_member_access_get_inner (self);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_expression_get_value_type (_tmp119_);
						_tmp121_ = _tmp120_;
						vala_data_type_set_value_owned (_tmp121_, FALSE);
						_tmp122_ = vala_member_access_get_inner (self);
						_tmp123_ = _tmp122_;
						_tmp124_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp123_, (ValaSymbol*) _tmp124_);
						_tmp125_ = vala_member_access_get_inner (self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_expression_get_value_type (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = self->priv->_member_name;
						_tmp130_ = vala_data_type_get_member (_tmp128_, _tmp129_);
						_tmp131_ = _tmp130_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp131_);
						_vala_code_node_unref0 (_tmp131_);
					}
				}
				_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp133_ = _tmp132_;
				if (_tmp133_ == NULL) {
					ValaSymbol* _tmp134_;
					_tmp134_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp134_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp135_ = sym;
				_tmp136_ = vala_symbol_get_parent_symbol (_tmp135_);
				_tmp137_ = _tmp136_;
				sym = _tmp137_;
			}
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			if (_tmp140_ == NULL) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp138_ = _tmp142_ != NULL;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					ValaList* _tmp145_;
					ValaList* _tmp146_;
					ValaList* _tmp147_;
					gint _ns_size = 0;
					ValaList* _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					gint _ns_index = 0;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_source_reference_get_using_directives (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = _vala_iterable_ref0 (_tmp146_);
					_ns_list = _tmp147_;
					_tmp148_ = _ns_list;
					_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
					_tmp150_ = _tmp149_;
					_ns_size = _tmp150_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp151_;
						gpointer _tmp152_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp153_;
						ValaSymbol* _tmp154_;
						ValaSymbol* _tmp155_;
						ValaScope* _tmp156_;
						ValaScope* _tmp157_;
						const gchar* _tmp158_;
						ValaSymbol* _tmp159_;
						ValaSymbol* _tmp160_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp151_ = _ns_list;
						_tmp152_ = vala_list_get (_tmp151_, _ns_index);
						ns = (ValaUsingDirective*) _tmp152_;
						_tmp153_ = ns;
						_tmp154_ = vala_using_directive_get_namespace_symbol (_tmp153_);
						_tmp155_ = _tmp154_;
						_tmp156_ = vala_symbol_get_scope (_tmp155_);
						_tmp157_ = _tmp156_;
						_tmp158_ = self->priv->_member_name;
						_tmp159_ = vala_scope_lookup (_tmp157_, _tmp158_);
						local_sym = _tmp159_;
						_tmp160_ = local_sym;
						if (_tmp160_ != NULL) {
							gboolean _tmp161_ = FALSE;
							ValaSymbol* _tmp162_;
							ValaSymbol* _tmp163_;
							ValaSymbol* _tmp179_;
							_tmp162_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp163_ = _tmp162_;
							if (_tmp163_ != NULL) {
								ValaSymbol* _tmp164_;
								ValaSymbol* _tmp165_;
								ValaSymbol* _tmp166_;
								_tmp164_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp165_ = _tmp164_;
								_tmp166_ = local_sym;
								_tmp161_ = _tmp165_ != _tmp166_;
							} else {
								_tmp161_ = FALSE;
							}
							if (_tmp161_) {
								ValaSourceReference* _tmp167_;
								ValaSourceReference* _tmp168_;
								const gchar* _tmp169_;
								ValaSymbol* _tmp170_;
								ValaSymbol* _tmp171_;
								gchar* _tmp172_;
								gchar* _tmp173_;
								ValaSymbol* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								gchar* _tmp177_;
								gchar* _tmp178_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp168_ = _tmp167_;
								_tmp169_ = self->priv->_member_name;
								_tmp170_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp171_ = _tmp170_;
								_tmp172_ = vala_symbol_get_full_name (_tmp171_);
								_tmp173_ = _tmp172_;
								_tmp174_ = local_sym;
								_tmp175_ = vala_symbol_get_full_name (_tmp174_);
								_tmp176_ = _tmp175_;
								_tmp177_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp169_, _tmp173_, _tmp176_);
								_tmp178_ = _tmp177_;
								vala_report_error (_tmp168_, _tmp178_);
								_g_free0 (_tmp178_);
								_g_free0 (_tmp176_);
								_g_free0 (_tmp173_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp179_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp179_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			gboolean _tmp182_;
			gboolean _tmp183_;
			ValaExpression* _tmp184_;
			ValaExpression* _tmp185_;
			ValaDataType* _tmp186_;
			ValaDataType* _tmp187_;
			ValaExpression* _tmp205_;
			ValaExpression* _tmp206_;
			gboolean _tmp221_ = FALSE;
			ValaExpression* _tmp222_;
			ValaExpression* _tmp223_;
			gboolean _tmp230_ = FALSE;
			ValaExpression* _tmp231_;
			ValaExpression* _tmp232_;
			gboolean _tmp253_ = FALSE;
			ValaExpression* _tmp254_;
			ValaExpression* _tmp255_;
			gboolean _tmp274_ = FALSE;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			gboolean _tmp310_ = FALSE;
			gboolean _tmp311_ = FALSE;
			ValaSymbol* _tmp312_;
			ValaSymbol* _tmp313_;
			gboolean _tmp525_ = FALSE;
			ValaSymbol* _tmp526_;
			ValaSymbol* _tmp527_;
			_tmp180_ = vala_member_access_get_inner (self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_code_node_get_error ((ValaCodeNode*) _tmp181_);
			_tmp183_ = _tmp182_;
			if (_tmp183_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp184_ = vala_member_access_get_inner (self);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_expression_get_value_type (_tmp185_);
			_tmp187_ = _tmp186_;
			if (VALA_IS_POINTER_TYPE (_tmp187_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp188_;
				ValaExpression* _tmp189_;
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				gboolean _tmp192_ = FALSE;
				ValaPointerType* _tmp193_;
				_tmp188_ = vala_member_access_get_inner (self);
				_tmp189_ = _tmp188_;
				_tmp190_ = vala_expression_get_value_type (_tmp189_);
				_tmp191_ = _tmp190_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp191_) ? ((ValaPointerType*) _tmp191_) : NULL;
				_tmp193_ = pointer_type;
				if (_tmp193_ != NULL) {
					ValaPointerType* _tmp194_;
					ValaDataType* _tmp195_;
					ValaDataType* _tmp196_;
					_tmp194_ = pointer_type;
					_tmp195_ = vala_pointer_type_get_base_type (_tmp194_);
					_tmp196_ = _tmp195_;
					_tmp192_ = VALA_IS_VALUE_TYPE (_tmp196_);
				} else {
					_tmp192_ = FALSE;
				}
				if (_tmp192_) {
					ValaExpression* _tmp197_;
					ValaExpression* _tmp198_;
					ValaSourceReference* _tmp199_;
					ValaSourceReference* _tmp200_;
					ValaPointerIndirection* _tmp201_;
					ValaPointerIndirection* _tmp202_;
					ValaExpression* _tmp203_;
					ValaExpression* _tmp204_;
					_tmp197_ = vala_member_access_get_inner (self);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp200_ = _tmp199_;
					_tmp201_ = vala_pointer_indirection_new (_tmp198_, _tmp200_);
					_tmp202_ = _tmp201_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp202_);
					_vala_code_node_unref0 (_tmp202_);
					_tmp203_ = vala_member_access_get_inner (self);
					_tmp204_ = _tmp203_;
					vala_code_node_check ((ValaCodeNode*) _tmp204_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp205_ = vala_member_access_get_inner (self);
			_tmp206_ = _tmp205_;
			if (VALA_IS_MEMBER_ACCESS (_tmp206_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp207_;
				ValaExpression* _tmp208_;
				ValaMemberAccess* _tmp209_;
				gboolean _tmp210_;
				_tmp207_ = vala_member_access_get_inner (self);
				_tmp208_ = _tmp207_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp208_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp209_ = ma;
				_tmp210_ = _tmp209_->priv->_prototype_access;
				if (_tmp210_) {
					ValaSourceReference* _tmp211_;
					ValaSourceReference* _tmp212_;
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaSymbol* _tmp215_;
					ValaSymbol* _tmp216_;
					gchar* _tmp217_;
					gchar* _tmp218_;
					gchar* _tmp219_;
					gchar* _tmp220_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp212_ = _tmp211_;
					_tmp213_ = vala_member_access_get_inner (self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_expression_get_symbol_reference (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_symbol_get_full_name (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp218_);
					_tmp220_ = _tmp219_;
					vala_report_error (_tmp212_, _tmp220_);
					_g_free0 (_tmp220_);
					_g_free0 (_tmp218_);
					result = FALSE;
					return result;
				}
			}
			_tmp222_ = vala_member_access_get_inner (self);
			_tmp223_ = _tmp222_;
			if (VALA_IS_CAST_EXPRESSION (_tmp223_)) {
				ValaExpression* _tmp224_;
				ValaExpression* _tmp225_;
				gboolean _tmp226_;
				gboolean _tmp227_;
				_tmp224_ = vala_member_access_get_inner (self);
				_tmp225_ = _tmp224_;
				_tmp226_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp225_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp227_ = _tmp226_;
				_tmp221_ = _tmp227_;
			} else {
				_tmp221_ = FALSE;
			}
			if (_tmp221_) {
				ValaSourceReference* _tmp228_;
				ValaSourceReference* _tmp229_;
				_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp229_ = _tmp228_;
				vala_report_warning (_tmp229_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp231_ = vala_member_access_get_inner (self);
			_tmp232_ = _tmp231_;
			if (VALA_IS_MEMBER_ACCESS (_tmp232_)) {
				_tmp230_ = TRUE;
			} else {
				ValaExpression* _tmp233_;
				ValaExpression* _tmp234_;
				_tmp233_ = vala_member_access_get_inner (self);
				_tmp234_ = _tmp233_;
				_tmp230_ = VALA_IS_BASE_ACCESS (_tmp234_);
			}
			if (_tmp230_) {
				ValaExpression* _tmp235_;
				ValaExpression* _tmp236_;
				ValaSymbol* _tmp237_;
				ValaSymbol* _tmp238_;
				gboolean _tmp239_ = FALSE;
				ValaSymbol* _tmp240_;
				ValaSymbol* _tmp241_;
				_tmp235_ = vala_member_access_get_inner (self);
				_tmp236_ = _tmp235_;
				_tmp237_ = vala_expression_get_symbol_reference (_tmp236_);
				_tmp238_ = _tmp237_;
				base_symbol = _tmp238_;
				_tmp240_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp241_ = _tmp240_;
				if (_tmp241_ == NULL) {
					gboolean _tmp242_ = FALSE;
					ValaSymbol* _tmp243_;
					_tmp243_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp243_)) {
						_tmp242_ = TRUE;
					} else {
						ValaSymbol* _tmp244_;
						_tmp244_ = base_symbol;
						_tmp242_ = VALA_IS_TYPESYMBOL (_tmp244_);
					}
					_tmp239_ = _tmp242_;
				} else {
					_tmp239_ = FALSE;
				}
				if (_tmp239_) {
					ValaSymbol* _tmp245_;
					ValaScope* _tmp246_;
					ValaScope* _tmp247_;
					const gchar* _tmp248_;
					ValaSymbol* _tmp249_;
					ValaSymbol* _tmp250_;
					ValaExpression* _tmp251_;
					ValaExpression* _tmp252_;
					_tmp245_ = base_symbol;
					_tmp246_ = vala_symbol_get_scope (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = self->priv->_member_name;
					_tmp249_ = vala_scope_lookup (_tmp247_, _tmp248_);
					_tmp250_ = _tmp249_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
					_vala_code_node_unref0 (_tmp250_);
					_tmp251_ = vala_member_access_get_inner (self);
					_tmp252_ = _tmp251_;
					if (VALA_IS_BASE_ACCESS (_tmp252_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp254_ = vala_member_access_get_inner (self);
			_tmp255_ = _tmp254_;
			if (VALA_IS_MEMBER_ACCESS (_tmp255_)) {
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaSymbol* _tmp258_;
				ValaSymbol* _tmp259_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_symbol_reference (_tmp257_);
				_tmp259_ = _tmp258_;
				_tmp253_ = VALA_IS_TYPEPARAMETER (_tmp259_);
			} else {
				_tmp253_ = FALSE;
			}
			if (_tmp253_) {
				ValaExpression* _tmp260_;
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				ValaExpression* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaSymbol* _tmp265_;
				ValaGenericType* _tmp266_;
				ValaGenericType* _tmp267_;
				ValaExpression* _tmp268_;
				ValaExpression* _tmp269_;
				ValaDataType* _tmp270_;
				ValaDataType* _tmp271_;
				ValaSourceReference* _tmp272_;
				ValaSourceReference* _tmp273_;
				_tmp260_ = vala_member_access_get_inner (self);
				_tmp261_ = _tmp260_;
				_tmp262_ = vala_member_access_get_inner (self);
				_tmp263_ = _tmp262_;
				_tmp264_ = vala_expression_get_symbol_reference (_tmp263_);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp265_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp267_ = _tmp266_;
				vala_expression_set_value_type (_tmp261_, (ValaDataType*) _tmp267_);
				_vala_code_node_unref0 (_tmp267_);
				_tmp268_ = vala_member_access_get_inner (self);
				_tmp269_ = _tmp268_;
				_tmp270_ = vala_expression_get_value_type (_tmp269_);
				_tmp271_ = _tmp270_;
				_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp273_ = _tmp272_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp271_, _tmp273_);
			}
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp276_ = _tmp275_;
			if (_tmp276_ == NULL) {
				ValaExpression* _tmp277_;
				ValaExpression* _tmp278_;
				ValaDataType* _tmp279_;
				ValaDataType* _tmp280_;
				_tmp277_ = vala_member_access_get_inner (self);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_expression_get_value_type (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp274_ = _tmp280_ != NULL;
			} else {
				_tmp274_ = FALSE;
			}
			if (_tmp274_) {
				gboolean _tmp281_;
				ValaSymbol* _tmp308_;
				ValaSymbol* _tmp309_;
				_tmp281_ = self->priv->_pointer_member_access;
				if (_tmp281_) {
					ValaExpression* _tmp282_;
					ValaExpression* _tmp283_;
					ValaDataType* _tmp284_;
					ValaDataType* _tmp285_;
					const gchar* _tmp286_;
					ValaSymbol* _tmp287_;
					ValaSymbol* _tmp288_;
					_tmp282_ = vala_member_access_get_inner (self);
					_tmp283_ = _tmp282_;
					_tmp284_ = vala_expression_get_value_type (_tmp283_);
					_tmp285_ = _tmp284_;
					_tmp286_ = self->priv->_member_name;
					_tmp287_ = vala_data_type_get_pointer_member (_tmp285_, _tmp286_);
					_tmp288_ = _tmp287_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp288_);
					_vala_code_node_unref0 (_tmp288_);
				} else {
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					ValaTypeSymbol* _tmp293_;
					ValaTypeSymbol* _tmp294_;
					ValaExpression* _tmp301_;
					ValaExpression* _tmp302_;
					ValaDataType* _tmp303_;
					ValaDataType* _tmp304_;
					const gchar* _tmp305_;
					ValaSymbol* _tmp306_;
					ValaSymbol* _tmp307_;
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = vala_data_type_get_type_symbol (_tmp292_);
					_tmp294_ = _tmp293_;
					if (_tmp294_ != NULL) {
						ValaExpression* _tmp295_;
						ValaExpression* _tmp296_;
						ValaDataType* _tmp297_;
						ValaDataType* _tmp298_;
						ValaTypeSymbol* _tmp299_;
						ValaTypeSymbol* _tmp300_;
						_tmp295_ = vala_member_access_get_inner (self);
						_tmp296_ = _tmp295_;
						_tmp297_ = vala_expression_get_value_type (_tmp296_);
						_tmp298_ = _tmp297_;
						_tmp299_ = vala_data_type_get_type_symbol (_tmp298_);
						_tmp300_ = _tmp299_;
						base_symbol = (ValaSymbol*) _tmp300_;
					}
					_tmp301_ = vala_member_access_get_inner (self);
					_tmp302_ = _tmp301_;
					_tmp303_ = vala_expression_get_value_type (_tmp302_);
					_tmp304_ = _tmp303_;
					_tmp305_ = self->priv->_member_name;
					_tmp306_ = vala_data_type_get_member (_tmp304_, _tmp305_);
					_tmp307_ = _tmp306_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp307_);
					_vala_code_node_unref0 (_tmp307_);
				}
				_tmp308_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp309_ = _tmp308_;
				if (_tmp309_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp312_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp313_ = _tmp312_;
			if (_tmp313_ == NULL) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaDataType* _tmp316_;
				ValaDataType* _tmp317_;
				_tmp314_ = vala_member_access_get_inner (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_expression_get_value_type (_tmp315_);
				_tmp317_ = _tmp316_;
				_tmp311_ = _tmp317_ != NULL;
			} else {
				_tmp311_ = FALSE;
			}
			if (_tmp311_) {
				ValaExpression* _tmp318_;
				ValaExpression* _tmp319_;
				ValaDataType* _tmp320_;
				ValaDataType* _tmp321_;
				gboolean _tmp322_;
				gboolean _tmp323_;
				_tmp318_ = vala_member_access_get_inner (self);
				_tmp319_ = _tmp318_;
				_tmp320_ = vala_expression_get_value_type (_tmp319_);
				_tmp321_ = _tmp320_;
				_tmp322_ = vala_data_type_get_is_dynamic (_tmp321_);
				_tmp323_ = _tmp322_;
				_tmp310_ = _tmp323_;
			} else {
				_tmp310_ = FALSE;
			}
			if (_tmp310_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp324_;
				ValaExpression* _tmp325_;
				ValaDataType* _tmp326_;
				ValaDataType* _tmp327_;
				ValaObjectType* _tmp328_;
				ValaCodeNode* _tmp329_;
				ValaCodeNode* _tmp330_;
				ValaSymbol* _tmp473_;
				ValaSymbol* _tmp474_;
				ValaSymbol* _tmp523_;
				ValaSymbol* _tmp524_;
				_tmp324_ = vala_member_access_get_inner (self);
				_tmp325_ = _tmp324_;
				_tmp326_ = vala_expression_get_value_type (_tmp325_);
				_tmp327_ = _tmp326_;
				_tmp328_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp327_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp328_;
				_tmp329_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp330_ = _tmp329_;
				if (VALA_IS_METHOD_CALL (_tmp330_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp331_;
					ValaCodeNode* _tmp332_;
					ValaMethodCall* _tmp333_;
					ValaExpression* _tmp334_;
					ValaExpression* _tmp335_;
					_tmp331_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp332_ = _tmp331_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp332_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp333_ = invoc;
					_tmp334_ = vala_method_call_get_call (_tmp333_);
					_tmp335_ = _tmp334_;
					if (_tmp335_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp336_;
						ValaDataType* _tmp337_;
						ValaDataType* _tmp338_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp353_;
						ValaExpression* _tmp354_;
						ValaDataType* _tmp355_;
						ValaDataType* _tmp356_;
						const gchar* _tmp357_;
						ValaDataType* _tmp358_;
						ValaSourceReference* _tmp359_;
						ValaSourceReference* _tmp360_;
						ValaDynamicMethod* _tmp361_;
						ValaDynamicMethod* _tmp362_;
						ValaMethodCall* _tmp363_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp364_;
						ValaErrorType* _tmp365_;
						ValaDynamicMethod* _tmp366_;
						ValaErrorType* _tmp367_;
						ValaDynamicMethod* _tmp368_;
						ValaDynamicMethod* _tmp369_;
						ValaParameter* _tmp370_;
						ValaParameter* _tmp371_;
						ValaDynamicMethod* _tmp372_;
						ValaObjectType* _tmp373_;
						ValaDataType* _tmp374_;
						ValaDataType* _tmp375_;
						ValaParameter* _tmp376_;
						ValaParameter* _tmp377_;
						ValaObjectType* _tmp378_;
						ValaTypeSymbol* _tmp379_;
						ValaTypeSymbol* _tmp380_;
						ValaScope* _tmp381_;
						ValaScope* _tmp382_;
						ValaDynamicMethod* _tmp383_;
						ValaDynamicMethod* _tmp384_;
						_tmp336_ = invoc;
						_tmp337_ = vala_expression_get_target_type ((ValaExpression*) _tmp336_);
						_tmp338_ = _tmp337_;
						if (_tmp338_ != NULL) {
							ValaMethodCall* _tmp339_;
							ValaDataType* _tmp340_;
							ValaDataType* _tmp341_;
							ValaDataType* _tmp342_;
							ValaDataType* _tmp343_;
							_tmp339_ = invoc;
							_tmp340_ = vala_expression_get_target_type ((ValaExpression*) _tmp339_);
							_tmp341_ = _tmp340_;
							_tmp342_ = vala_data_type_copy (_tmp341_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp342_;
							_tmp343_ = ret_type;
							vala_data_type_set_value_owned (_tmp343_, TRUE);
						} else {
							ValaMethodCall* _tmp344_;
							ValaCodeNode* _tmp345_;
							ValaCodeNode* _tmp346_;
							_tmp344_ = invoc;
							_tmp345_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp344_);
							_tmp346_ = _tmp345_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp346_)) {
								ValaVoidType* _tmp347_;
								_tmp347_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp347_;
							} else {
								ValaExpression* _tmp348_;
								ValaExpression* _tmp349_;
								ValaDataType* _tmp350_;
								ValaDataType* _tmp351_;
								ValaDataType* _tmp352_;
								_tmp348_ = vala_member_access_get_inner (self);
								_tmp349_ = _tmp348_;
								_tmp350_ = vala_expression_get_value_type (_tmp349_);
								_tmp351_ = _tmp350_;
								_tmp352_ = vala_data_type_copy (_tmp351_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp352_;
							}
						}
						_tmp353_ = vala_member_access_get_inner (self);
						_tmp354_ = _tmp353_;
						_tmp355_ = vala_expression_get_value_type (_tmp354_);
						_tmp356_ = _tmp355_;
						_tmp357_ = self->priv->_member_name;
						_tmp358_ = ret_type;
						_tmp359_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp360_ = _tmp359_;
						_tmp361_ = vala_dynamic_method_new (_tmp356_, _tmp357_, _tmp358_, _tmp360_, NULL);
						m = _tmp361_;
						_tmp362_ = m;
						_tmp363_ = invoc;
						vala_dynamic_method_set_invocation (_tmp362_, _tmp363_);
						_tmp364_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp364_;
						_tmp365_ = err;
						vala_error_type_set_dynamic_error (_tmp365_, TRUE);
						_tmp366_ = m;
						_tmp367_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp366_, (ValaDataType*) _tmp367_);
						_tmp368_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp368_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp369_ = m;
						_tmp370_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp371_ = _tmp370_;
						vala_callable_add_parameter ((ValaCallable*) _tmp369_, _tmp371_);
						_vala_code_node_unref0 (_tmp371_);
						_tmp372_ = m;
						_tmp373_ = dynamic_object_type;
						_tmp374_ = vala_data_type_copy ((ValaDataType*) _tmp373_);
						_tmp375_ = _tmp374_;
						_tmp376_ = vala_parameter_new ("this", _tmp375_, NULL);
						_tmp377_ = _tmp376_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp372_, _tmp377_);
						_vala_code_node_unref0 (_tmp377_);
						_vala_code_node_unref0 (_tmp375_);
						_tmp378_ = dynamic_object_type;
						_tmp379_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp378_);
						_tmp380_ = _tmp379_;
						_tmp381_ = vala_symbol_get_scope ((ValaSymbol*) _tmp380_);
						_tmp382_ = _tmp381_;
						_tmp383_ = m;
						vala_scope_add (_tmp382_, NULL, (ValaSymbol*) _tmp383_);
						_tmp384_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp384_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp385_;
					ValaCodeNode* _tmp386_;
					_tmp385_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp386_ = _tmp385_;
					if (VALA_IS_ASSIGNMENT (_tmp386_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp387_;
						ValaCodeNode* _tmp388_;
						ValaAssignment* _tmp389_;
						ValaExpression* _tmp390_;
						ValaExpression* _tmp391_;
						_tmp387_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp388_ = _tmp387_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp388_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp389_ = a;
						_tmp390_ = vala_assignment_get_left (_tmp389_);
						_tmp391_ = _tmp390_;
						if (_tmp391_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp392_;
							ValaExpression* _tmp393_;
							ValaDataType* _tmp394_;
							ValaDataType* _tmp395_;
							const gchar* _tmp396_;
							ValaSourceReference* _tmp397_;
							ValaSourceReference* _tmp398_;
							ValaDynamicProperty* _tmp399_;
							ValaDynamicProperty* _tmp400_;
							ValaDynamicProperty* _tmp401_;
							ValaDynamicProperty* _tmp402_;
							ValaSourceReference* _tmp403_;
							ValaSourceReference* _tmp404_;
							ValaPropertyAccessor* _tmp405_;
							ValaPropertyAccessor* _tmp406_;
							ValaDynamicProperty* _tmp407_;
							ValaExpression* _tmp408_;
							ValaExpression* _tmp409_;
							ValaDataType* _tmp410_;
							ValaDataType* _tmp411_;
							ValaTypeSymbol* _tmp412_;
							ValaTypeSymbol* _tmp413_;
							ValaScope* _tmp414_;
							ValaScope* _tmp415_;
							ValaObjectType* _tmp416_;
							ValaTypeSymbol* _tmp417_;
							ValaTypeSymbol* _tmp418_;
							ValaScope* _tmp419_;
							ValaScope* _tmp420_;
							ValaDynamicProperty* _tmp421_;
							ValaDynamicProperty* _tmp422_;
							_tmp392_ = vala_member_access_get_inner (self);
							_tmp393_ = _tmp392_;
							_tmp394_ = vala_expression_get_value_type (_tmp393_);
							_tmp395_ = _tmp394_;
							_tmp396_ = self->priv->_member_name;
							_tmp397_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp398_ = _tmp397_;
							_tmp399_ = vala_dynamic_property_new (_tmp395_, _tmp396_, _tmp398_, NULL);
							prop = _tmp399_;
							_tmp400_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp400_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp401_ = prop;
							_tmp402_ = prop;
							_tmp403_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp402_);
							_tmp404_ = _tmp403_;
							_tmp405_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp404_, NULL);
							_tmp406_ = _tmp405_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp401_, _tmp406_);
							_vala_code_node_unref0 (_tmp406_);
							_tmp407_ = prop;
							_tmp408_ = vala_member_access_get_inner (self);
							_tmp409_ = _tmp408_;
							_tmp410_ = vala_expression_get_value_type (_tmp409_);
							_tmp411_ = _tmp410_;
							_tmp412_ = vala_data_type_get_type_symbol (_tmp411_);
							_tmp413_ = _tmp412_;
							_tmp414_ = vala_symbol_get_scope ((ValaSymbol*) _tmp413_);
							_tmp415_ = _tmp414_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp407_, _tmp415_);
							_tmp416_ = dynamic_object_type;
							_tmp417_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp416_);
							_tmp418_ = _tmp417_;
							_tmp419_ = vala_symbol_get_scope ((ValaSymbol*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = prop;
							vala_scope_add (_tmp420_, NULL, (ValaSymbol*) _tmp421_);
							_tmp422_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp422_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp423_ = FALSE;
						gboolean _tmp424_ = FALSE;
						ValaCodeNode* _tmp425_;
						ValaCodeNode* _tmp426_;
						_tmp425_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp426_ = _tmp425_;
						if (VALA_IS_MEMBER_ACCESS (_tmp426_)) {
							ValaExpression* _tmp427_;
							ValaExpression* _tmp428_;
							_tmp427_ = vala_member_access_get_inner (self);
							_tmp428_ = _tmp427_;
							_tmp424_ = VALA_IS_MEMBER_ACCESS (_tmp428_);
						} else {
							_tmp424_ = FALSE;
						}
						if (_tmp424_) {
							ValaCodeNode* _tmp429_;
							ValaCodeNode* _tmp430_;
							ValaCodeNode* _tmp431_;
							ValaCodeNode* _tmp432_;
							_tmp429_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp430_ = _tmp429_;
							_tmp431_ = vala_code_node_get_parent_node (_tmp430_);
							_tmp432_ = _tmp431_;
							_tmp423_ = VALA_IS_METHOD_CALL (_tmp432_);
						} else {
							_tmp423_ = FALSE;
						}
						if (_tmp423_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							gboolean _tmp435_ = FALSE;
							ValaMemberAccess* _tmp436_;
							const gchar* _tmp437_;
							_tmp433_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp434_ = _tmp433_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp434_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp436_ = ma;
							_tmp437_ = _tmp436_->priv->_member_name;
							if (g_strcmp0 (_tmp437_, "connect") == 0) {
								_tmp435_ = TRUE;
							} else {
								ValaMemberAccess* _tmp438_;
								const gchar* _tmp439_;
								_tmp438_ = ma;
								_tmp439_ = _tmp438_->priv->_member_name;
								_tmp435_ = g_strcmp0 (_tmp439_, "connect_after") == 0;
							}
							if (_tmp435_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp440_;
								ValaExpression* _tmp441_;
								ValaDataType* _tmp442_;
								ValaDataType* _tmp443_;
								const gchar* _tmp444_;
								ValaVoidType* _tmp445_;
								ValaVoidType* _tmp446_;
								ValaSourceReference* _tmp447_;
								ValaSourceReference* _tmp448_;
								ValaDynamicSignal* _tmp449_;
								ValaDynamicSignal* _tmp450_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp451_;
								ValaCodeNode* _tmp452_;
								ValaCodeNode* _tmp453_;
								ValaCodeNode* _tmp454_;
								ValaMethodCall* _tmp455_;
								ValaMethodCall* _tmp456_;
								ValaList* _tmp457_;
								gint _tmp458_;
								gint _tmp459_;
								ValaDynamicSignal* _tmp465_;
								ValaObjectType* _tmp466_;
								ValaTypeSymbol* _tmp467_;
								ValaTypeSymbol* _tmp468_;
								ValaScope* _tmp469_;
								ValaScope* _tmp470_;
								ValaDynamicSignal* _tmp471_;
								ValaDynamicSignal* _tmp472_;
								_tmp440_ = vala_member_access_get_inner (self);
								_tmp441_ = _tmp440_;
								_tmp442_ = vala_expression_get_value_type (_tmp441_);
								_tmp443_ = _tmp442_;
								_tmp444_ = self->priv->_member_name;
								_tmp445_ = vala_void_type_new (NULL);
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp448_ = _tmp447_;
								_tmp449_ = vala_dynamic_signal_new (_tmp443_, _tmp444_, (ValaDataType*) _tmp446_, _tmp448_, NULL);
								_tmp450_ = _tmp449_;
								_vala_code_node_unref0 (_tmp446_);
								s = _tmp450_;
								_tmp451_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp452_ = _tmp451_;
								_tmp453_ = vala_code_node_get_parent_node (_tmp452_);
								_tmp454_ = _tmp453_;
								_tmp455_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp454_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp455_;
								_tmp456_ = mcall;
								_tmp457_ = vala_method_call_get_argument_list (_tmp456_);
								_tmp458_ = vala_collection_get_size ((ValaCollection*) _tmp457_);
								_tmp459_ = _tmp458_;
								if (_tmp459_ > 0) {
									ValaDynamicSignal* _tmp460_;
									ValaMethodCall* _tmp461_;
									ValaList* _tmp462_;
									gpointer _tmp463_;
									ValaExpression* _tmp464_;
									_tmp460_ = s;
									_tmp461_ = mcall;
									_tmp462_ = vala_method_call_get_argument_list (_tmp461_);
									_tmp463_ = vala_list_get (_tmp462_, 0);
									_tmp464_ = (ValaExpression*) _tmp463_;
									vala_dynamic_signal_set_handler (_tmp460_, _tmp464_);
									_vala_code_node_unref0 (_tmp464_);
								}
								_tmp465_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp465_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp466_ = dynamic_object_type;
								_tmp467_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp466_);
								_tmp468_ = _tmp467_;
								_tmp469_ = vala_symbol_get_scope ((ValaSymbol*) _tmp468_);
								_tmp470_ = _tmp469_;
								_tmp471_ = s;
								vala_scope_add (_tmp470_, NULL, (ValaSymbol*) _tmp471_);
								_tmp472_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp472_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp473_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp474_ = _tmp473_;
				if (_tmp474_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp475_;
					ValaExpression* _tmp476_;
					ValaDataType* _tmp477_;
					ValaDataType* _tmp478_;
					const gchar* _tmp479_;
					ValaSourceReference* _tmp480_;
					ValaSourceReference* _tmp481_;
					ValaDynamicProperty* _tmp482_;
					ValaDataType* _tmp483_;
					ValaDataType* _tmp484_;
					ValaDynamicProperty* _tmp495_;
					ValaDynamicProperty* _tmp496_;
					ValaDynamicProperty* _tmp497_;
					ValaDataType* _tmp498_;
					ValaDataType* _tmp499_;
					ValaDataType* _tmp500_;
					ValaDataType* _tmp501_;
					ValaDynamicProperty* _tmp502_;
					ValaSourceReference* _tmp503_;
					ValaSourceReference* _tmp504_;
					ValaPropertyAccessor* _tmp505_;
					ValaPropertyAccessor* _tmp506_;
					ValaDynamicProperty* _tmp507_;
					ValaExpression* _tmp508_;
					ValaExpression* _tmp509_;
					ValaDataType* _tmp510_;
					ValaDataType* _tmp511_;
					ValaTypeSymbol* _tmp512_;
					ValaTypeSymbol* _tmp513_;
					ValaScope* _tmp514_;
					ValaScope* _tmp515_;
					ValaObjectType* _tmp516_;
					ValaTypeSymbol* _tmp517_;
					ValaTypeSymbol* _tmp518_;
					ValaScope* _tmp519_;
					ValaScope* _tmp520_;
					ValaDynamicProperty* _tmp521_;
					ValaDynamicProperty* _tmp522_;
					_tmp475_ = vala_member_access_get_inner (self);
					_tmp476_ = _tmp475_;
					_tmp477_ = vala_expression_get_value_type (_tmp476_);
					_tmp478_ = _tmp477_;
					_tmp479_ = self->priv->_member_name;
					_tmp480_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp481_ = _tmp480_;
					_tmp482_ = vala_dynamic_property_new (_tmp478_, _tmp479_, _tmp481_, NULL);
					prop = _tmp482_;
					_tmp483_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp484_ = _tmp483_;
					if (_tmp484_ != NULL) {
						ValaDynamicProperty* _tmp485_;
						ValaDataType* _tmp486_;
						ValaDataType* _tmp487_;
						_tmp485_ = prop;
						_tmp486_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp487_ = _tmp486_;
						vala_property_set_property_type ((ValaProperty*) _tmp485_, _tmp487_);
					} else {
						ValaDynamicProperty* _tmp488_;
						ValaExpression* _tmp489_;
						ValaExpression* _tmp490_;
						ValaDataType* _tmp491_;
						ValaDataType* _tmp492_;
						ValaDataType* _tmp493_;
						ValaDataType* _tmp494_;
						_tmp488_ = prop;
						_tmp489_ = vala_member_access_get_inner (self);
						_tmp490_ = _tmp489_;
						_tmp491_ = vala_expression_get_value_type (_tmp490_);
						_tmp492_ = _tmp491_;
						_tmp493_ = vala_data_type_copy (_tmp492_);
						_tmp494_ = _tmp493_;
						vala_property_set_property_type ((ValaProperty*) _tmp488_, _tmp494_);
						_vala_code_node_unref0 (_tmp494_);
					}
					_tmp495_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp495_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp496_ = prop;
					_tmp497_ = prop;
					_tmp498_ = vala_property_get_property_type ((ValaProperty*) _tmp497_);
					_tmp499_ = _tmp498_;
					_tmp500_ = vala_data_type_copy (_tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = prop;
					_tmp503_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp502_);
					_tmp504_ = _tmp503_;
					_tmp505_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp501_, NULL, _tmp504_, NULL);
					_tmp506_ = _tmp505_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp496_, _tmp506_);
					_vala_code_node_unref0 (_tmp506_);
					_vala_code_node_unref0 (_tmp501_);
					_tmp507_ = prop;
					_tmp508_ = vala_member_access_get_inner (self);
					_tmp509_ = _tmp508_;
					_tmp510_ = vala_expression_get_value_type (_tmp509_);
					_tmp511_ = _tmp510_;
					_tmp512_ = vala_data_type_get_type_symbol (_tmp511_);
					_tmp513_ = _tmp512_;
					_tmp514_ = vala_symbol_get_scope ((ValaSymbol*) _tmp513_);
					_tmp515_ = _tmp514_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp507_, _tmp515_);
					_tmp516_ = dynamic_object_type;
					_tmp517_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp516_);
					_tmp518_ = _tmp517_;
					_tmp519_ = vala_symbol_get_scope ((ValaSymbol*) _tmp518_);
					_tmp520_ = _tmp519_;
					_tmp521_ = prop;
					vala_scope_add (_tmp520_, NULL, (ValaSymbol*) _tmp521_);
					_tmp522_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp522_);
					_vala_code_node_unref0 (prop);
				}
				_tmp523_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp524_ = _tmp523_;
				if (_tmp524_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp526_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp527_ = _tmp526_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp527_)) {
				ValaExpression* _tmp528_;
				ValaExpression* _tmp529_;
				ValaDataType* _tmp530_;
				ValaDataType* _tmp531_;
				_tmp528_ = vala_member_access_get_inner (self);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_expression_get_value_type (_tmp529_);
				_tmp531_ = _tmp530_;
				_tmp525_ = VALA_IS_ARRAY_TYPE (_tmp531_);
			} else {
				_tmp525_ = FALSE;
			}
			if (_tmp525_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp532_;
				ValaExpression* _tmp533_;
				ValaDataType* _tmp534_;
				ValaDataType* _tmp535_;
				gboolean _tmp536_ = FALSE;
				ValaArrayType* _tmp537_;
				_tmp532_ = vala_member_access_get_inner (self);
				_tmp533_ = _tmp532_;
				_tmp534_ = vala_expression_get_value_type (_tmp533_);
				_tmp535_ = _tmp534_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp535_) ? ((ValaArrayType*) _tmp535_) : NULL;
				_tmp537_ = value_array_type;
				if (_tmp537_ != NULL) {
					ValaArrayType* _tmp538_;
					gboolean _tmp539_;
					gboolean _tmp540_;
					_tmp538_ = value_array_type;
					_tmp539_ = vala_array_type_get_inline_allocated (_tmp538_);
					_tmp540_ = _tmp539_;
					_tmp536_ = _tmp540_;
				} else {
					_tmp536_ = FALSE;
				}
				if (_tmp536_) {
					ValaSourceReference* _tmp541_;
					ValaSourceReference* _tmp542_;
					_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp542_ = _tmp541_;
					vala_report_error (_tmp542_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp546_ = vala_member_access_get_inner (self);
	_tmp547_ = _tmp546_;
	if (_tmp547_ == NULL) {
		ValaSymbol* _tmp548_;
		ValaSymbol* _tmp549_;
		_tmp548_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp549_ = _tmp548_;
		_tmp545_ = _tmp549_ == NULL;
	} else {
		_tmp545_ = FALSE;
	}
	if (_tmp545_) {
		ValaDataType* _tmp550_;
		ValaDataType* _tmp551_;
		_tmp550_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp551_ = _tmp550_;
		_tmp544_ = _tmp551_ != NULL;
	} else {
		_tmp544_ = FALSE;
	}
	if (_tmp544_) {
		ValaDataType* _tmp552_;
		ValaDataType* _tmp553_;
		ValaTypeSymbol* _tmp554_;
		ValaTypeSymbol* _tmp555_;
		_tmp552_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp553_ = _tmp552_;
		_tmp554_ = vala_data_type_get_type_symbol (_tmp553_);
		_tmp555_ = _tmp554_;
		_tmp543_ = VALA_IS_ENUM (_tmp555_);
	} else {
		_tmp543_ = FALSE;
	}
	if (_tmp543_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp556_;
		ValaDataType* _tmp557_;
		ValaTypeSymbol* _tmp558_;
		ValaTypeSymbol* _tmp559_;
		_tmp556_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp557_ = _tmp556_;
		_tmp558_ = vala_data_type_get_type_symbol (_tmp557_);
		_tmp559_ = _tmp558_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp559_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp560_;
			ValaList* _tmp561_;
			ValaList* _tmp562_;
			gint _val_size = 0;
			ValaList* _tmp563_;
			gint _tmp564_;
			gint _tmp565_;
			gint _val_index = 0;
			_tmp560_ = enum_type;
			_tmp561_ = vala_enum_get_values (_tmp560_);
			_tmp562_ = _vala_iterable_ref0 (_tmp561_);
			_val_list = _tmp562_;
			_tmp563_ = _val_list;
			_tmp564_ = vala_collection_get_size ((ValaCollection*) _tmp563_);
			_tmp565_ = _tmp564_;
			_val_size = _tmp565_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp566_;
				gpointer _tmp567_;
				const gchar* _tmp568_;
				ValaEnumValue* _tmp569_;
				const gchar* _tmp570_;
				const gchar* _tmp571_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp566_ = _val_list;
				_tmp567_ = vala_list_get (_tmp566_, _val_index);
				val = (ValaEnumValue*) _tmp567_;
				_tmp568_ = self->priv->_member_name;
				_tmp569_ = val;
				_tmp570_ = vala_symbol_get_name ((ValaSymbol*) _tmp569_);
				_tmp571_ = _tmp570_;
				if (g_strcmp0 (_tmp568_, _tmp571_) == 0) {
					ValaEnumValue* _tmp572_;
					_tmp572_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp572_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp573_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp574_ = _tmp573_;
	if (_tmp574_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp575_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp576_ = FALSE;
		ValaExpression* _tmp577_;
		ValaExpression* _tmp578_;
		gchar* base_type_package = NULL;
		gchar* _tmp598_;
		gboolean _tmp599_ = FALSE;
		ValaSymbol* _tmp600_;
		ValaSourceReference* _tmp615_;
		ValaSourceReference* _tmp616_;
		const gchar* _tmp617_;
		const gchar* _tmp618_;
		const gchar* _tmp619_;
		gchar* _tmp620_;
		gchar* _tmp621_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp575_ = g_strdup ("(null)");
		base_type_name = _tmp575_;
		base_type = NULL;
		_tmp577_ = vala_member_access_get_inner (self);
		_tmp578_ = _tmp577_;
		if (_tmp578_ != NULL) {
			ValaExpression* _tmp579_;
			ValaExpression* _tmp580_;
			ValaDataType* _tmp581_;
			ValaDataType* _tmp582_;
			_tmp579_ = vala_member_access_get_inner (self);
			_tmp580_ = _tmp579_;
			_tmp581_ = vala_expression_get_value_type (_tmp580_);
			_tmp582_ = _tmp581_;
			_tmp576_ = _tmp582_ != NULL;
		} else {
			_tmp576_ = FALSE;
		}
		if (_tmp576_) {
			ValaExpression* _tmp583_;
			ValaExpression* _tmp584_;
			ValaDataType* _tmp585_;
			ValaDataType* _tmp586_;
			gchar* _tmp587_;
			ValaExpression* _tmp588_;
			ValaExpression* _tmp589_;
			ValaDataType* _tmp590_;
			ValaDataType* _tmp591_;
			ValaTypeSymbol* _tmp592_;
			ValaTypeSymbol* _tmp593_;
			_tmp583_ = vala_member_access_get_inner (self);
			_tmp584_ = _tmp583_;
			_tmp585_ = vala_expression_get_value_type (_tmp584_);
			_tmp586_ = _tmp585_;
			_tmp587_ = vala_code_node_to_string ((ValaCodeNode*) _tmp586_);
			_g_free0 (base_type_name);
			base_type_name = _tmp587_;
			_tmp588_ = vala_member_access_get_inner (self);
			_tmp589_ = _tmp588_;
			_tmp590_ = vala_expression_get_value_type (_tmp589_);
			_tmp591_ = _tmp590_;
			_tmp592_ = vala_data_type_get_type_symbol (_tmp591_);
			_tmp593_ = _tmp592_;
			base_type = (ValaSymbol*) _tmp593_;
		} else {
			ValaSymbol* _tmp594_;
			_tmp594_ = base_symbol;
			if (_tmp594_ != NULL) {
				ValaSymbol* _tmp595_;
				gchar* _tmp596_;
				ValaSymbol* _tmp597_;
				_tmp595_ = base_symbol;
				_tmp596_ = vala_symbol_get_full_name (_tmp595_);
				_g_free0 (base_type_name);
				base_type_name = _tmp596_;
				_tmp597_ = base_symbol;
				base_type = _tmp597_;
			}
		}
		_tmp598_ = g_strdup ("");
		base_type_package = _tmp598_;
		_tmp600_ = base_type;
		if (_tmp600_ != NULL) {
			ValaSymbol* _tmp601_;
			gboolean _tmp602_;
			gboolean _tmp603_;
			_tmp601_ = base_type;
			_tmp602_ = vala_symbol_get_external_package (_tmp601_);
			_tmp603_ = _tmp602_;
			_tmp599_ = _tmp603_;
		} else {
			_tmp599_ = FALSE;
		}
		if (_tmp599_) {
			ValaSymbol* _tmp604_;
			ValaSourceReference* _tmp605_;
			ValaSourceReference* _tmp606_;
			ValaSourceFile* _tmp607_;
			ValaSourceFile* _tmp608_;
			const gchar* _tmp609_;
			const gchar* _tmp610_;
			gchar* _tmp611_;
			const gchar* _tmp612_;
			_tmp604_ = base_symbol;
			_tmp605_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp604_);
			_tmp606_ = _tmp605_;
			_tmp607_ = vala_source_reference_get_file (_tmp606_);
			_tmp608_ = _tmp607_;
			_tmp609_ = vala_source_file_get_package_name (_tmp608_);
			_tmp610_ = _tmp609_;
			_tmp611_ = g_strdup (_tmp610_);
			_g_free0 (base_type_package);
			base_type_package = _tmp611_;
			_tmp612_ = base_type_package;
			if (_tmp612_ != NULL) {
				const gchar* _tmp613_;
				gchar* _tmp614_;
				_tmp613_ = base_type_package;
				_tmp614_ = g_strdup_printf (" (%s)", _tmp613_);
				_g_free0 (base_type_package);
				base_type_package = _tmp614_;
			}
		}
		_tmp615_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp616_ = _tmp615_;
		_tmp617_ = self->priv->_member_name;
		_tmp618_ = base_type_name;
		_tmp619_ = base_type_package;
		_tmp620_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp617_, _tmp618_, _tmp619_);
		_tmp621_ = _tmp620_;
		vala_report_error (_tmp616_, _tmp621_);
		_g_free0 (_tmp621_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	}
	_tmp622_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp623_ = _tmp622_;
	member = _tmp623_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp624_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp624_, context)) {
		result = FALSE;
		return result;
	}
	_tmp625_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp625_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp626_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp627_;
		ValaSymbol* _tmp628_;
		ValaSymbol* _tmp629_;
		gboolean _tmp630_ = FALSE;
		ValaBlock* _tmp631_;
		_tmp626_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp626_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp627_ = local;
		_tmp628_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp627_);
		_tmp629_ = _tmp628_;
		block = VALA_IS_BLOCK (_tmp629_) ? ((ValaBlock*) _tmp629_) : NULL;
		_tmp631_ = block;
		if (_tmp631_ != NULL) {
			ValaBlock* _tmp632_;
			ValaSymbol* _tmp633_;
			ValaSemanticAnalyzer* _tmp634_;
			ValaSemanticAnalyzer* _tmp635_;
			ValaSymbol* _tmp636_;
			ValaSymbol* _tmp637_;
			_tmp632_ = block;
			_tmp633_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp632_);
			_tmp634_ = vala_code_context_get_analyzer (context);
			_tmp635_ = _tmp634_;
			_tmp636_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp635_);
			_tmp637_ = _tmp636_;
			_tmp630_ = _tmp633_ != _tmp637_;
		} else {
			_tmp630_ = FALSE;
		}
		if (_tmp630_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp638_;
			ValaSemanticAnalyzer* _tmp639_;
			ValaSymbol* _tmp640_;
			ValaSymbol* _tmp641_;
			ValaLocalVariable* _tmp652_;
			ValaBlock* _tmp653_;
			_tmp638_ = vala_code_context_get_analyzer (context);
			_tmp639_ = _tmp638_;
			_tmp640_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp639_);
			_tmp641_ = _tmp640_;
			sym = _tmp641_;
			while (TRUE) {
				ValaSymbol* _tmp642_;
				ValaBlock* _tmp643_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp644_;
				ValaMethod* _tmp645_;
				ValaSymbol* _tmp649_;
				ValaSymbol* _tmp650_;
				ValaSymbol* _tmp651_;
				_tmp642_ = sym;
				_tmp643_ = block;
				if (!(_tmp642_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp643_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp644_ = sym;
				method = VALA_IS_METHOD (_tmp644_) ? ((ValaMethod*) _tmp644_) : NULL;
				_tmp645_ = method;
				if (_tmp645_ != NULL) {
					ValaMethod* _tmp646_;
					ValaMethod* _tmp647_;
					ValaLocalVariable* _tmp648_;
					_tmp646_ = method;
					vala_method_set_closure (_tmp646_, TRUE);
					_tmp647_ = method;
					_tmp648_ = local;
					vala_method_add_captured_variable (_tmp647_, _tmp648_);
				}
				_tmp649_ = sym;
				_tmp650_ = vala_symbol_get_parent_symbol (_tmp649_);
				_tmp651_ = _tmp650_;
				sym = _tmp651_;
			}
			_tmp652_ = local;
			vala_local_variable_set_captured (_tmp652_, TRUE);
			_tmp653_ = block;
			vala_block_set_captured (_tmp653_, TRUE);
		}
	} else {
		ValaSymbol* _tmp654_;
		_tmp654_ = member;
		if (VALA_IS_PARAMETER (_tmp654_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp655_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp656_;
			ValaSymbol* _tmp657_;
			ValaSymbol* _tmp658_;
			gboolean _tmp659_ = FALSE;
			gboolean _tmp660_ = FALSE;
			ValaMethod* _tmp661_;
			_tmp655_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp655_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp656_ = param;
			_tmp657_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp656_);
			_tmp658_ = _tmp657_;
			m = VALA_IS_METHOD (_tmp658_) ? ((ValaMethod*) _tmp658_) : NULL;
			_tmp661_ = m;
			if (_tmp661_ != NULL) {
				ValaMethod* _tmp662_;
				ValaSemanticAnalyzer* _tmp663_;
				ValaSemanticAnalyzer* _tmp664_;
				ValaSymbol* _tmp665_;
				ValaSymbol* _tmp666_;
				_tmp662_ = m;
				_tmp663_ = vala_code_context_get_analyzer (context);
				_tmp664_ = _tmp663_;
				_tmp665_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp664_);
				_tmp666_ = _tmp665_;
				_tmp660_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp662_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp666_;
			} else {
				_tmp660_ = FALSE;
			}
			if (_tmp660_) {
				ValaParameter* _tmp667_;
				ValaMethod* _tmp668_;
				ValaParameter* _tmp669_;
				ValaParameter* _tmp670_;
				_tmp667_ = param;
				_tmp668_ = m;
				_tmp669_ = vala_method_get_this_parameter (_tmp668_);
				_tmp670_ = _tmp669_;
				_tmp659_ = _tmp667_ != _tmp670_;
			} else {
				_tmp659_ = FALSE;
			}
			if (_tmp659_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp671_;
				ValaSemanticAnalyzer* _tmp672_;
				ValaSymbol* _tmp673_;
				ValaSymbol* _tmp674_;
				ValaParameter* _tmp683_;
				ValaMethod* _tmp684_;
				ValaBlock* _tmp685_;
				ValaBlock* _tmp686_;
				ValaParameter* _tmp687_;
				ValaParameterDirection _tmp688_;
				ValaParameterDirection _tmp689_;
				_tmp671_ = vala_code_context_get_analyzer (context);
				_tmp672_ = _tmp671_;
				_tmp673_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp672_);
				_tmp674_ = _tmp673_;
				sym = _tmp674_;
				while (TRUE) {
					ValaSymbol* _tmp675_;
					ValaMethod* _tmp676_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp677_;
					ValaMethod* _tmp678_;
					ValaSymbol* _tmp680_;
					ValaSymbol* _tmp681_;
					ValaSymbol* _tmp682_;
					_tmp675_ = sym;
					_tmp676_ = m;
					if (!(_tmp675_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp676_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp677_ = sym;
					method = VALA_IS_METHOD (_tmp677_) ? ((ValaMethod*) _tmp677_) : NULL;
					_tmp678_ = method;
					if (_tmp678_ != NULL) {
						ValaMethod* _tmp679_;
						_tmp679_ = method;
						vala_method_set_closure (_tmp679_, TRUE);
					}
					_tmp680_ = sym;
					_tmp681_ = vala_symbol_get_parent_symbol (_tmp680_);
					_tmp682_ = _tmp681_;
					sym = _tmp682_;
				}
				_tmp683_ = param;
				vala_parameter_set_captured (_tmp683_, TRUE);
				_tmp684_ = m;
				_tmp685_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp684_);
				_tmp686_ = _tmp685_;
				vala_block_set_captured (_tmp686_, TRUE);
				_tmp687_ = param;
				_tmp688_ = vala_parameter_get_direction (_tmp687_);
				_tmp689_ = _tmp688_;
				if (_tmp689_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp690_;
					ValaSourceReference* _tmp691_;
					ValaParameter* _tmp692_;
					gchar* _tmp693_;
					gchar* _tmp694_;
					gchar* _tmp695_;
					gchar* _tmp696_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp690_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp691_ = _tmp690_;
					_tmp692_ = param;
					_tmp693_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp692_);
					_tmp694_ = _tmp693_;
					_tmp695_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp694_);
					_tmp696_ = _tmp695_;
					vala_report_error (_tmp691_, _tmp696_);
					_g_free0 (_tmp696_);
					_g_free0 (_tmp694_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp697_;
				ValaSymbol* _tmp698_;
				ValaSymbol* _tmp699_;
				ValaSymbol* _tmp700_;
				ValaSymbol* _tmp701_;
				gboolean _tmp702_ = FALSE;
				gboolean _tmp703_ = FALSE;
				ValaPropertyAccessor* _tmp704_;
				_tmp697_ = param;
				_tmp698_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp697_);
				_tmp699_ = _tmp698_;
				_tmp700_ = vala_symbol_get_parent_symbol (_tmp699_);
				_tmp701_ = _tmp700_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp701_) ? ((ValaPropertyAccessor*) _tmp701_) : NULL;
				_tmp704_ = acc;
				if (_tmp704_ != NULL) {
					ValaPropertyAccessor* _tmp705_;
					ValaSemanticAnalyzer* _tmp706_;
					ValaSemanticAnalyzer* _tmp707_;
					ValaSymbol* _tmp708_;
					ValaSymbol* _tmp709_;
					_tmp705_ = acc;
					_tmp706_ = vala_code_context_get_analyzer (context);
					_tmp707_ = _tmp706_;
					_tmp708_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp707_);
					_tmp709_ = _tmp708_;
					_tmp703_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp705_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp709_;
				} else {
					_tmp703_ = FALSE;
				}
				if (_tmp703_) {
					ValaParameter* _tmp710_;
					ValaPropertyAccessor* _tmp711_;
					ValaProperty* _tmp712_;
					ValaProperty* _tmp713_;
					ValaParameter* _tmp714_;
					ValaParameter* _tmp715_;
					_tmp710_ = param;
					_tmp711_ = acc;
					_tmp712_ = vala_property_accessor_get_prop (_tmp711_);
					_tmp713_ = _tmp712_;
					_tmp714_ = vala_property_get_this_parameter (_tmp713_);
					_tmp715_ = _tmp714_;
					_tmp702_ = _tmp710_ != _tmp715_;
				} else {
					_tmp702_ = FALSE;
				}
				if (_tmp702_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp716_;
					ValaSemanticAnalyzer* _tmp717_;
					ValaSymbol* _tmp718_;
					ValaSymbol* _tmp719_;
					ValaParameter* _tmp728_;
					ValaPropertyAccessor* _tmp729_;
					ValaBlock* _tmp730_;
					ValaBlock* _tmp731_;
					_tmp716_ = vala_code_context_get_analyzer (context);
					_tmp717_ = _tmp716_;
					_tmp718_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp717_);
					_tmp719_ = _tmp718_;
					sym = _tmp719_;
					while (TRUE) {
						ValaSymbol* _tmp720_;
						ValaMethod* _tmp721_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp722_;
						ValaMethod* _tmp723_;
						ValaSymbol* _tmp725_;
						ValaSymbol* _tmp726_;
						ValaSymbol* _tmp727_;
						_tmp720_ = sym;
						_tmp721_ = m;
						if (!(_tmp720_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp721_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp722_ = sym;
						method = VALA_IS_METHOD (_tmp722_) ? ((ValaMethod*) _tmp722_) : NULL;
						_tmp723_ = method;
						if (_tmp723_ != NULL) {
							ValaMethod* _tmp724_;
							_tmp724_ = method;
							vala_method_set_closure (_tmp724_, TRUE);
						}
						_tmp725_ = sym;
						_tmp726_ = vala_symbol_get_parent_symbol (_tmp725_);
						_tmp727_ = _tmp726_;
						sym = _tmp727_;
					}
					_tmp728_ = param;
					vala_parameter_set_captured (_tmp728_, TRUE);
					_tmp729_ = acc;
					_tmp730_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp729_);
					_tmp731_ = _tmp730_;
					vala_block_set_captured (_tmp731_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp732_;
			_tmp732_ = member;
			if (VALA_IS_FIELD (_tmp732_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp733_;
				ValaField* _tmp734_;
				ValaSymbolAccessibility _tmp735_;
				ValaSymbolAccessibility _tmp736_;
				ValaField* _tmp737_;
				ValaMemberBinding _tmp738_;
				ValaMemberBinding _tmp739_;
				ValaField* _tmp740_;
				ValaMemberBinding _tmp741_;
				ValaMemberBinding _tmp742_;
				ValaField* _tmp743_;
				ValaDataType* _tmp744_;
				ValaDataType* _tmp745_;
				_tmp733_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp733_, VALA_TYPE_FIELD, ValaField);
				_tmp734_ = f;
				_tmp735_ = vala_symbol_get_access ((ValaSymbol*) _tmp734_);
				_tmp736_ = _tmp735_;
				access = _tmp736_;
				_tmp737_ = f;
				_tmp738_ = vala_field_get_binding (_tmp737_);
				_tmp739_ = _tmp738_;
				instance = _tmp739_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp740_ = f;
				_tmp741_ = vala_field_get_binding (_tmp740_);
				_tmp742_ = _tmp741_;
				klass = _tmp742_ == VALA_MEMBER_BINDING_CLASS;
				_tmp743_ = f;
				_tmp744_ = vala_variable_get_variable_type ((ValaVariable*) _tmp743_);
				_tmp745_ = _tmp744_;
				if (VALA_IS_GENERIC_TYPE (_tmp745_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp746_;
				_tmp746_ = member;
				if (VALA_IS_CONSTANT (_tmp746_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp747_;
					ValaConstant* _tmp748_;
					ValaSymbolAccessibility _tmp749_;
					ValaSymbolAccessibility _tmp750_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp751_;
					ValaSymbol* _tmp752_;
					ValaSymbol* _tmp753_;
					gboolean _tmp754_ = FALSE;
					ValaBlock* _tmp755_;
					_tmp747_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp747_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp748_ = c;
					_tmp749_ = vala_symbol_get_access ((ValaSymbol*) _tmp748_);
					_tmp750_ = _tmp749_;
					access = _tmp750_;
					_tmp751_ = c;
					_tmp752_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp751_);
					_tmp753_ = _tmp752_;
					block = VALA_IS_BLOCK (_tmp753_) ? ((ValaBlock*) _tmp753_) : NULL;
					_tmp755_ = block;
					if (_tmp755_ != NULL) {
						ValaBlock* _tmp756_;
						ValaSymbol* _tmp757_;
						ValaSemanticAnalyzer* _tmp758_;
						ValaSemanticAnalyzer* _tmp759_;
						ValaSymbol* _tmp760_;
						ValaSymbol* _tmp761_;
						_tmp756_ = block;
						_tmp757_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp756_);
						_tmp758_ = vala_code_context_get_analyzer (context);
						_tmp759_ = _tmp758_;
						_tmp760_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp759_);
						_tmp761_ = _tmp760_;
						_tmp754_ = _tmp757_ != _tmp761_;
					} else {
						_tmp754_ = FALSE;
					}
					if (_tmp754_) {
						ValaSourceReference* _tmp762_;
						ValaSourceReference* _tmp763_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp762_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp763_ = _tmp762_;
						vala_report_error (_tmp763_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp764_;
					_tmp764_ = member;
					if (VALA_IS_METHOD (_tmp764_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp765_;
						ValaMethod* _tmp766_;
						gboolean _tmp767_;
						gboolean _tmp768_;
						ValaMethod* _tmp857_;
						ValaSymbolAccessibility _tmp858_;
						ValaSymbolAccessibility _tmp859_;
						ValaMethod* _tmp860_;
						ValaMethod* _tmp864_;
						ValaMemberBinding _tmp865_;
						ValaMemberBinding _tmp866_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp885_;
						ValaDataType* _tmp886_;
						ValaDataType* _tmp887_;
						gboolean _tmp888_ = FALSE;
						ValaGenericType* _tmp889_;
						_tmp765_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp765_, VALA_TYPE_METHOD, ValaMethod);
						_tmp766_ = m;
						_tmp767_ = vala_method_get_is_async_callback (_tmp766_);
						_tmp768_ = _tmp767_;
						if (_tmp768_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp769_;
							ValaSemanticAnalyzer* _tmp770_;
							ValaMethod* _tmp771_;
							ValaMethod* _tmp772_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp773_;
							ValaMethod* _tmp802_;
							ValaSemanticAnalyzer* _tmp803_;
							ValaSemanticAnalyzer* _tmp804_;
							ValaMethod* _tmp805_;
							ValaMethod* _tmp806_;
							ValaMethod* _tmp822_;
							ValaMethod* _tmp823_;
							ValaMethod* _tmp824_;
							ValaSymbol* _tmp825_;
							ValaSymbol* _tmp826_;
							_tmp769_ = vala_code_context_get_analyzer (context);
							_tmp770_ = _tmp769_;
							_tmp771_ = vala_semantic_analyzer_get_current_async_method (_tmp770_);
							_tmp772_ = _tmp771_;
							async_method = _tmp772_;
							is_valid_access = FALSE;
							_tmp773_ = async_method;
							if (_tmp773_ != NULL) {
								ValaMethod* _tmp774_;
								ValaMethod* _tmp775_;
								ValaMethod* _tmp776_;
								_tmp774_ = m;
								_tmp775_ = async_method;
								_tmp776_ = vala_method_get_callback_method (_tmp775_);
								if (_tmp774_ == _tmp776_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp777_ = FALSE;
									ValaMethod* _tmp778_;
									ValaMethod* _tmp779_;
									ValaMethod* _tmp780_;
									_tmp778_ = async_method;
									_tmp779_ = vala_method_get_base_method (_tmp778_);
									_tmp780_ = _tmp779_;
									if (_tmp780_ != NULL) {
										ValaMethod* _tmp781_;
										ValaMethod* _tmp782_;
										ValaMethod* _tmp783_;
										ValaMethod* _tmp784_;
										ValaMethod* _tmp785_;
										_tmp781_ = m;
										_tmp782_ = async_method;
										_tmp783_ = vala_method_get_base_method (_tmp782_);
										_tmp784_ = _tmp783_;
										_tmp785_ = vala_method_get_callback_method (_tmp784_);
										_tmp777_ = _tmp781_ == _tmp785_;
									} else {
										_tmp777_ = FALSE;
									}
									if (_tmp777_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp786_ = FALSE;
										ValaMethod* _tmp787_;
										ValaMethod* _tmp788_;
										ValaMethod* _tmp789_;
										_tmp787_ = async_method;
										_tmp788_ = vala_method_get_base_interface_method (_tmp787_);
										_tmp789_ = _tmp788_;
										if (_tmp789_ != NULL) {
											ValaMethod* _tmp790_;
											ValaMethod* _tmp791_;
											ValaMethod* _tmp792_;
											ValaMethod* _tmp793_;
											ValaMethod* _tmp794_;
											_tmp790_ = m;
											_tmp791_ = async_method;
											_tmp792_ = vala_method_get_base_interface_method (_tmp791_);
											_tmp793_ = _tmp792_;
											_tmp794_ = vala_method_get_callback_method (_tmp793_);
											_tmp786_ = _tmp790_ == _tmp794_;
										} else {
											_tmp786_ = FALSE;
										}
										if (_tmp786_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp795_;
								ValaSourceReference* _tmp796_;
								ValaMethod* _tmp797_;
								gchar* _tmp798_;
								gchar* _tmp799_;
								gchar* _tmp800_;
								gchar* _tmp801_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp795_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp796_ = _tmp795_;
								_tmp797_ = m;
								_tmp798_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp797_);
								_tmp799_ = _tmp798_;
								_tmp800_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp799_);
								_tmp801_ = _tmp800_;
								vala_report_error (_tmp796_, _tmp801_);
								_g_free0 (_tmp801_);
								_g_free0 (_tmp799_);
								result = FALSE;
								return result;
							}
							_tmp802_ = async_method;
							_tmp803_ = vala_code_context_get_analyzer (context);
							_tmp804_ = _tmp803_;
							_tmp805_ = vala_semantic_analyzer_get_current_method (_tmp804_);
							_tmp806_ = _tmp805_;
							if (_tmp802_ != _tmp806_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp807_;
								ValaSemanticAnalyzer* _tmp808_;
								ValaMethod* _tmp809_;
								ValaMethod* _tmp810_;
								ValaMethod* _tmp819_;
								ValaBlock* _tmp820_;
								ValaBlock* _tmp821_;
								_tmp807_ = vala_code_context_get_analyzer (context);
								_tmp808_ = _tmp807_;
								_tmp809_ = vala_semantic_analyzer_get_current_method (_tmp808_);
								_tmp810_ = _tmp809_;
								sym = (ValaSymbol*) _tmp810_;
								while (TRUE) {
									ValaSymbol* _tmp811_;
									ValaMethod* _tmp812_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp813_;
									ValaMethod* _tmp814_;
									ValaSymbol* _tmp816_;
									ValaSymbol* _tmp817_;
									ValaSymbol* _tmp818_;
									_tmp811_ = sym;
									_tmp812_ = async_method;
									if (!(_tmp811_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp812_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp813_ = sym;
									method = VALA_IS_METHOD (_tmp813_) ? ((ValaMethod*) _tmp813_) : NULL;
									_tmp814_ = method;
									if (_tmp814_ != NULL) {
										ValaMethod* _tmp815_;
										_tmp815_ = method;
										vala_method_set_closure (_tmp815_, TRUE);
									}
									_tmp816_ = sym;
									_tmp817_ = vala_symbol_get_parent_symbol (_tmp816_);
									_tmp818_ = _tmp817_;
									sym = _tmp818_;
								}
								_tmp819_ = async_method;
								_tmp820_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp819_);
								_tmp821_ = _tmp820_;
								vala_block_set_captured (_tmp821_, TRUE);
							}
							_tmp822_ = async_method;
							_tmp823_ = vala_method_get_callback_method (_tmp822_);
							m = _tmp823_;
							_tmp824_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp824_);
							_tmp825_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp826_ = _tmp825_;
							member = _tmp826_;
						} else {
							ValaMethod* _tmp827_;
							ValaMethod* _tmp828_;
							ValaMethod* _tmp829_;
							_tmp827_ = m;
							_tmp828_ = vala_method_get_base_method (_tmp827_);
							_tmp829_ = _tmp828_;
							if (_tmp829_ != NULL) {
								ValaMethod* _tmp830_;
								ValaMethod* _tmp831_;
								ValaMethod* _tmp832_;
								ValaMethod* _tmp833_;
								ValaSignal* _tmp834_;
								ValaSignal* _tmp835_;
								ValaSymbol* _tmp840_;
								ValaSymbol* _tmp841_;
								_tmp830_ = m;
								_tmp831_ = vala_method_get_base_method (_tmp830_);
								_tmp832_ = _tmp831_;
								m = _tmp832_;
								_tmp833_ = m;
								_tmp834_ = vala_method_get_signal_reference (_tmp833_);
								_tmp835_ = _tmp834_;
								if (_tmp835_ != NULL) {
									ValaMethod* _tmp836_;
									ValaSignal* _tmp837_;
									ValaSignal* _tmp838_;
									_tmp836_ = m;
									_tmp837_ = vala_method_get_signal_reference (_tmp836_);
									_tmp838_ = _tmp837_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp838_);
								} else {
									ValaMethod* _tmp839_;
									_tmp839_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp839_);
								}
								_tmp840_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp841_ = _tmp840_;
								member = _tmp841_;
							} else {
								ValaMethod* _tmp842_;
								ValaMethod* _tmp843_;
								ValaMethod* _tmp844_;
								_tmp842_ = m;
								_tmp843_ = vala_method_get_base_interface_method (_tmp842_);
								_tmp844_ = _tmp843_;
								if (_tmp844_ != NULL) {
									ValaMethod* _tmp845_;
									ValaMethod* _tmp846_;
									ValaMethod* _tmp847_;
									ValaMethod* _tmp848_;
									ValaSignal* _tmp849_;
									ValaSignal* _tmp850_;
									ValaSymbol* _tmp855_;
									ValaSymbol* _tmp856_;
									_tmp845_ = m;
									_tmp846_ = vala_method_get_base_interface_method (_tmp845_);
									_tmp847_ = _tmp846_;
									m = _tmp847_;
									_tmp848_ = m;
									_tmp849_ = vala_method_get_signal_reference (_tmp848_);
									_tmp850_ = _tmp849_;
									if (_tmp850_ != NULL) {
										ValaMethod* _tmp851_;
										ValaSignal* _tmp852_;
										ValaSignal* _tmp853_;
										_tmp851_ = m;
										_tmp852_ = vala_method_get_signal_reference (_tmp851_);
										_tmp853_ = _tmp852_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp853_);
									} else {
										ValaMethod* _tmp854_;
										_tmp854_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp854_);
									}
									_tmp855_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp856_ = _tmp855_;
									member = _tmp856_;
								}
							}
						}
						_tmp857_ = m;
						_tmp858_ = vala_symbol_get_access ((ValaSymbol*) _tmp857_);
						_tmp859_ = _tmp858_;
						access = _tmp859_;
						_tmp860_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp860_)) {
							ValaMethod* _tmp861_;
							ValaMemberBinding _tmp862_;
							ValaMemberBinding _tmp863_;
							_tmp861_ = m;
							_tmp862_ = vala_method_get_binding (_tmp861_);
							_tmp863_ = _tmp862_;
							instance = _tmp863_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp864_ = m;
						_tmp865_ = vala_method_get_binding (_tmp864_);
						_tmp866_ = _tmp865_;
						klass = _tmp866_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp867_;
							ValaList* _tmp868_;
							ValaList* _tmp869_;
							gint _param_size = 0;
							ValaList* _tmp870_;
							gint _tmp871_;
							gint _tmp872_;
							gint _param_index = 0;
							_tmp867_ = m;
							_tmp868_ = vala_callable_get_parameters ((ValaCallable*) _tmp867_);
							_tmp869_ = _vala_iterable_ref0 (_tmp868_);
							_param_list = _tmp869_;
							_tmp870_ = _param_list;
							_tmp871_ = vala_collection_get_size ((ValaCollection*) _tmp870_);
							_tmp872_ = _tmp871_;
							_param_size = _tmp872_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp873_;
								gpointer _tmp874_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp875_;
								ValaDataType* _tmp876_;
								ValaDataType* _tmp877_;
								gboolean _tmp878_ = FALSE;
								ValaGenericType* _tmp879_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp873_ = _param_list;
								_tmp874_ = vala_list_get (_tmp873_, _param_index);
								param = (ValaParameter*) _tmp874_;
								_tmp875_ = param;
								_tmp876_ = vala_variable_get_variable_type ((ValaVariable*) _tmp875_);
								_tmp877_ = _tmp876_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp877_) ? ((ValaGenericType*) _tmp877_) : NULL;
								_tmp879_ = generic_type;
								if (_tmp879_ != NULL) {
									ValaGenericType* _tmp880_;
									ValaTypeParameter* _tmp881_;
									ValaTypeParameter* _tmp882_;
									ValaSymbol* _tmp883_;
									ValaSymbol* _tmp884_;
									_tmp880_ = generic_type;
									_tmp881_ = vala_generic_type_get_type_parameter (_tmp880_);
									_tmp882_ = _tmp881_;
									_tmp883_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp882_);
									_tmp884_ = _tmp883_;
									_tmp878_ = VALA_IS_TYPESYMBOL (_tmp884_);
								} else {
									_tmp878_ = FALSE;
								}
								if (_tmp878_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp885_ = m;
						_tmp886_ = vala_callable_get_return_type ((ValaCallable*) _tmp885_);
						_tmp887_ = _tmp886_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp887_) ? ((ValaGenericType*) _tmp887_) : NULL;
						_tmp889_ = generic_type;
						if (_tmp889_ != NULL) {
							ValaGenericType* _tmp890_;
							ValaTypeParameter* _tmp891_;
							ValaTypeParameter* _tmp892_;
							ValaSymbol* _tmp893_;
							ValaSymbol* _tmp894_;
							_tmp890_ = generic_type;
							_tmp891_ = vala_generic_type_get_type_parameter (_tmp890_);
							_tmp892_ = _tmp891_;
							_tmp893_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp892_);
							_tmp894_ = _tmp893_;
							_tmp888_ = VALA_IS_TYPESYMBOL (_tmp894_);
						} else {
							_tmp888_ = FALSE;
						}
						if (_tmp888_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp895_;
						_tmp895_ = member;
						if (VALA_IS_PROPERTY (_tmp895_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp896_;
							ValaProperty* _tmp897_;
							ValaProperty* _tmp898_;
							ValaProperty* _tmp899_;
							ValaProperty* _tmp900_;
							ValaProperty* _tmp916_;
							ValaSymbolAccessibility _tmp917_;
							ValaSymbolAccessibility _tmp918_;
							gboolean _tmp919_;
							gboolean _tmp920_;
							ValaProperty* _tmp985_;
							ValaMemberBinding _tmp986_;
							ValaMemberBinding _tmp987_;
							ValaProperty* _tmp988_;
							ValaDataType* _tmp989_;
							ValaDataType* _tmp990_;
							_tmp896_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp896_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp897_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp897_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp898_ = prop;
							_tmp899_ = vala_property_get_base_property (_tmp898_);
							_tmp900_ = _tmp899_;
							if (_tmp900_ != NULL) {
								ValaProperty* _tmp901_;
								ValaProperty* _tmp902_;
								ValaProperty* _tmp903_;
								ValaProperty* _tmp904_;
								ValaSymbol* _tmp905_;
								ValaSymbol* _tmp906_;
								_tmp901_ = prop;
								_tmp902_ = vala_property_get_base_property (_tmp901_);
								_tmp903_ = _tmp902_;
								prop = _tmp903_;
								_tmp904_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp904_);
								_tmp905_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp906_ = _tmp905_;
								member = _tmp906_;
							} else {
								ValaProperty* _tmp907_;
								ValaProperty* _tmp908_;
								ValaProperty* _tmp909_;
								_tmp907_ = prop;
								_tmp908_ = vala_property_get_base_interface_property (_tmp907_);
								_tmp909_ = _tmp908_;
								if (_tmp909_ != NULL) {
									ValaProperty* _tmp910_;
									ValaProperty* _tmp911_;
									ValaProperty* _tmp912_;
									ValaProperty* _tmp913_;
									ValaSymbol* _tmp914_;
									ValaSymbol* _tmp915_;
									_tmp910_ = prop;
									_tmp911_ = vala_property_get_base_interface_property (_tmp910_);
									_tmp912_ = _tmp911_;
									prop = _tmp912_;
									_tmp913_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp913_);
									_tmp914_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp915_ = _tmp914_;
									member = _tmp915_;
								}
							}
							_tmp916_ = prop;
							_tmp917_ = vala_symbol_get_access ((ValaSymbol*) _tmp916_);
							_tmp918_ = _tmp917_;
							access = _tmp918_;
							_tmp919_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp920_ = _tmp919_;
							if (_tmp920_) {
								ValaProperty* _tmp921_;
								ValaPropertyAccessor* _tmp922_;
								ValaPropertyAccessor* _tmp923_;
								ValaProperty* _tmp931_;
								ValaSymbolAccessibility _tmp932_;
								ValaSymbolAccessibility _tmp933_;
								_tmp921_ = prop;
								_tmp922_ = vala_property_get_set_accessor (_tmp921_);
								_tmp923_ = _tmp922_;
								if (_tmp923_ == NULL) {
									ValaSourceReference* _tmp924_;
									ValaSourceReference* _tmp925_;
									ValaProperty* _tmp926_;
									gchar* _tmp927_;
									gchar* _tmp928_;
									gchar* _tmp929_;
									gchar* _tmp930_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp924_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp925_ = _tmp924_;
									_tmp926_ = prop;
									_tmp927_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp926_);
									_tmp928_ = _tmp927_;
									_tmp929_ = g_strdup_printf ("Property `%s' is read-only", _tmp928_);
									_tmp930_ = _tmp929_;
									vala_report_error (_tmp925_, _tmp930_);
									_g_free0 (_tmp930_);
									_g_free0 (_tmp928_);
									result = FALSE;
									return result;
								}
								_tmp931_ = prop;
								_tmp932_ = vala_symbol_get_access ((ValaSymbol*) _tmp931_);
								_tmp933_ = _tmp932_;
								if (_tmp933_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp934_;
									ValaPropertyAccessor* _tmp935_;
									ValaPropertyAccessor* _tmp936_;
									ValaSymbolAccessibility _tmp937_;
									ValaSymbolAccessibility _tmp938_;
									_tmp934_ = prop;
									_tmp935_ = vala_property_get_set_accessor (_tmp934_);
									_tmp936_ = _tmp935_;
									_tmp937_ = vala_symbol_get_access ((ValaSymbol*) _tmp936_);
									_tmp938_ = _tmp937_;
									access = _tmp938_;
								} else {
									gboolean _tmp939_ = FALSE;
									ValaProperty* _tmp940_;
									ValaSymbolAccessibility _tmp941_;
									ValaSymbolAccessibility _tmp942_;
									_tmp940_ = prop;
									_tmp941_ = vala_symbol_get_access ((ValaSymbol*) _tmp940_);
									_tmp942_ = _tmp941_;
									if (_tmp942_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp943_;
										ValaPropertyAccessor* _tmp944_;
										ValaPropertyAccessor* _tmp945_;
										ValaSymbolAccessibility _tmp946_;
										ValaSymbolAccessibility _tmp947_;
										_tmp943_ = prop;
										_tmp944_ = vala_property_get_set_accessor (_tmp943_);
										_tmp945_ = _tmp944_;
										_tmp946_ = vala_symbol_get_access ((ValaSymbol*) _tmp945_);
										_tmp947_ = _tmp946_;
										_tmp939_ = _tmp947_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp939_ = FALSE;
									}
									if (_tmp939_) {
										ValaProperty* _tmp948_;
										ValaPropertyAccessor* _tmp949_;
										ValaPropertyAccessor* _tmp950_;
										ValaSymbolAccessibility _tmp951_;
										ValaSymbolAccessibility _tmp952_;
										_tmp948_ = prop;
										_tmp949_ = vala_property_get_set_accessor (_tmp948_);
										_tmp950_ = _tmp949_;
										_tmp951_ = vala_symbol_get_access ((ValaSymbol*) _tmp950_);
										_tmp952_ = _tmp951_;
										access = _tmp952_;
									}
								}
							} else {
								ValaProperty* _tmp953_;
								ValaPropertyAccessor* _tmp954_;
								ValaPropertyAccessor* _tmp955_;
								ValaProperty* _tmp963_;
								ValaSymbolAccessibility _tmp964_;
								ValaSymbolAccessibility _tmp965_;
								_tmp953_ = prop;
								_tmp954_ = vala_property_get_get_accessor (_tmp953_);
								_tmp955_ = _tmp954_;
								if (_tmp955_ == NULL) {
									ValaSourceReference* _tmp956_;
									ValaSourceReference* _tmp957_;
									ValaProperty* _tmp958_;
									gchar* _tmp959_;
									gchar* _tmp960_;
									gchar* _tmp961_;
									gchar* _tmp962_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp956_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp957_ = _tmp956_;
									_tmp958_ = prop;
									_tmp959_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp958_);
									_tmp960_ = _tmp959_;
									_tmp961_ = g_strdup_printf ("Property `%s' is write-only", _tmp960_);
									_tmp962_ = _tmp961_;
									vala_report_error (_tmp957_, _tmp962_);
									_g_free0 (_tmp962_);
									_g_free0 (_tmp960_);
									result = FALSE;
									return result;
								}
								_tmp963_ = prop;
								_tmp964_ = vala_symbol_get_access ((ValaSymbol*) _tmp963_);
								_tmp965_ = _tmp964_;
								if (_tmp965_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp966_;
									ValaPropertyAccessor* _tmp967_;
									ValaPropertyAccessor* _tmp968_;
									ValaSymbolAccessibility _tmp969_;
									ValaSymbolAccessibility _tmp970_;
									_tmp966_ = prop;
									_tmp967_ = vala_property_get_get_accessor (_tmp966_);
									_tmp968_ = _tmp967_;
									_tmp969_ = vala_symbol_get_access ((ValaSymbol*) _tmp968_);
									_tmp970_ = _tmp969_;
									access = _tmp970_;
								} else {
									gboolean _tmp971_ = FALSE;
									ValaProperty* _tmp972_;
									ValaSymbolAccessibility _tmp973_;
									ValaSymbolAccessibility _tmp974_;
									_tmp972_ = prop;
									_tmp973_ = vala_symbol_get_access ((ValaSymbol*) _tmp972_);
									_tmp974_ = _tmp973_;
									if (_tmp974_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp975_;
										ValaPropertyAccessor* _tmp976_;
										ValaPropertyAccessor* _tmp977_;
										ValaSymbolAccessibility _tmp978_;
										ValaSymbolAccessibility _tmp979_;
										_tmp975_ = prop;
										_tmp976_ = vala_property_get_get_accessor (_tmp975_);
										_tmp977_ = _tmp976_;
										_tmp978_ = vala_symbol_get_access ((ValaSymbol*) _tmp977_);
										_tmp979_ = _tmp978_;
										_tmp971_ = _tmp979_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp971_ = FALSE;
									}
									if (_tmp971_) {
										ValaProperty* _tmp980_;
										ValaPropertyAccessor* _tmp981_;
										ValaPropertyAccessor* _tmp982_;
										ValaSymbolAccessibility _tmp983_;
										ValaSymbolAccessibility _tmp984_;
										_tmp980_ = prop;
										_tmp981_ = vala_property_get_get_accessor (_tmp980_);
										_tmp982_ = _tmp981_;
										_tmp983_ = vala_symbol_get_access ((ValaSymbol*) _tmp982_);
										_tmp984_ = _tmp983_;
										access = _tmp984_;
									}
								}
							}
							_tmp985_ = prop;
							_tmp986_ = vala_property_get_binding (_tmp985_);
							_tmp987_ = _tmp986_;
							instance = _tmp987_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp988_ = prop;
							_tmp989_ = vala_property_get_property_type (_tmp988_);
							_tmp990_ = _tmp989_;
							if (VALA_IS_GENERIC_TYPE (_tmp990_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp991_;
							_tmp991_ = member;
							if (VALA_IS_SIGNAL (_tmp991_)) {
								ValaSymbol* _tmp992_;
								ValaSymbolAccessibility _tmp993_;
								ValaSymbolAccessibility _tmp994_;
								instance = TRUE;
								_tmp992_ = member;
								_tmp993_ = vala_symbol_get_access (_tmp992_);
								_tmp994_ = _tmp993_;
								access = _tmp994_;
							} else {
								gboolean _tmp995_ = FALSE;
								gboolean _tmp996_;
								_tmp996_ = self->priv->_creation_member;
								if (!_tmp996_) {
									ValaSymbol* _tmp997_;
									_tmp997_ = member;
									_tmp995_ = VALA_IS_ERROR_CODE (_tmp997_);
								} else {
									_tmp995_ = FALSE;
								}
								if (_tmp995_) {
									ValaSymbol* _tmp998_;
									ValaConstant* _tmp999_;
									ValaConstant* _tmp1000_;
									ValaSymbol* _tmp1001_;
									ValaSymbol* _tmp1002_;
									_tmp998_ = member;
									_tmp999_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp998_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1000_ = _tmp999_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1000_);
									_tmp1001_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1002_ = _tmp1001_;
									member = _tmp1002_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1003_;
		ValaSymbol* _tmp1004_;
		ValaCodeNode* _tmp1005_;
		ValaCodeNode* _tmp1006_;
		ValaCodeNode* _tmp1007_;
		gboolean _tmp1008_ = FALSE;
		ValaCodeNode* _tmp1009_;
		_tmp1003_ = parent;
		_tmp1004_ = member;
		if (!(_tmp1003_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1004_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1005_ = parent;
		_tmp1006_ = vala_code_node_get_parent_node (_tmp1005_);
		_tmp1007_ = _tmp1006_;
		parent = _tmp1007_;
		_tmp1009_ = parent;
		if (_tmp1009_ == NULL) {
			_tmp1008_ = TRUE;
		} else {
			ValaCodeNode* _tmp1010_;
			ValaSymbol* _tmp1011_;
			_tmp1010_ = parent;
			_tmp1011_ = member;
			_tmp1008_ = _tmp1010_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1011_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1008_) {
			break;
		}
	}
	_tmp1012_ = parent;
	_tmp1013_ = member;
	if (_tmp1012_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1013_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1014_;
		_tmp1014_ = member;
		vala_symbol_set_used (_tmp1014_, TRUE);
	}
	_tmp1015_ = member;
	_tmp1016_ = vala_symbol_get_version (_tmp1015_);
	_tmp1017_ = _tmp1016_;
	_tmp1018_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1019_ = _tmp1018_;
	vala_version_attribute_check (_tmp1017_, _tmp1019_);
	_tmp1021_ = access;
	if (_tmp1021_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1022_;
		ValaSymbol* _tmp1023_;
		ValaSymbol* _tmp1024_;
		_tmp1022_ = member;
		_tmp1023_ = vala_symbol_get_parent_symbol (_tmp1022_);
		_tmp1024_ = _tmp1023_;
		_tmp1020_ = VALA_IS_TYPESYMBOL (_tmp1024_);
	} else {
		_tmp1020_ = FALSE;
	}
	if (_tmp1020_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1025_;
		ValaSymbol* _tmp1026_;
		ValaSymbol* _tmp1027_;
		gboolean in_subtype = FALSE;
		_tmp1025_ = member;
		_tmp1026_ = vala_symbol_get_parent_symbol (_tmp1025_);
		_tmp1027_ = _tmp1026_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1027_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1028_;
			ValaSemanticAnalyzer* _tmp1029_;
			ValaSymbol* _tmp1030_;
			ValaSymbol* _tmp1031_;
			ValaSymbol* _tmp1032_;
			_tmp1028_ = vala_code_context_get_analyzer (context);
			_tmp1029_ = _tmp1028_;
			_tmp1030_ = vala_semantic_analyzer_get_current_symbol (_tmp1029_);
			_tmp1031_ = _tmp1030_;
			_tmp1032_ = _vala_code_node_ref0 (_tmp1031_);
			this_symbol = _tmp1032_;
			{
				gboolean _tmp1033_ = FALSE;
				_tmp1033_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1038_;
					ValaSymbol* _tmp1039_;
					ValaTypeSymbol* _tmp1040_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1041_;
					gboolean _tmp1042_ = FALSE;
					ValaClass* _tmp1043_;
					if (!_tmp1033_) {
						ValaSymbol* _tmp1034_;
						ValaSymbol* _tmp1035_;
						ValaSymbol* _tmp1036_;
						ValaSymbol* _tmp1037_;
						_tmp1034_ = this_symbol;
						_tmp1035_ = vala_symbol_get_parent_symbol (_tmp1034_);
						_tmp1036_ = _tmp1035_;
						_tmp1037_ = _vala_code_node_ref0 (_tmp1036_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1037_;
					}
					_tmp1033_ = FALSE;
					_tmp1038_ = this_symbol;
					if (!(_tmp1038_ != NULL)) {
						break;
					}
					_tmp1039_ = this_symbol;
					_tmp1040_ = target_type;
					if (_tmp1039_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1040_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1041_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1041_) ? ((ValaClass*) _tmp1041_) : NULL;
					_tmp1043_ = cl;
					if (_tmp1043_ != NULL) {
						ValaClass* _tmp1044_;
						ValaTypeSymbol* _tmp1045_;
						_tmp1044_ = cl;
						_tmp1045_ = target_type;
						_tmp1042_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1044_, _tmp1045_);
					} else {
						_tmp1042_ = FALSE;
					}
					if (_tmp1042_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1046_;
			ValaSourceReference* _tmp1047_;
			ValaSymbol* _tmp1048_;
			gchar* _tmp1049_;
			gchar* _tmp1050_;
			gchar* _tmp1051_;
			gchar* _tmp1052_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1046_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1047_ = _tmp1046_;
			_tmp1048_ = member;
			_tmp1049_ = vala_symbol_get_full_name (_tmp1048_);
			_tmp1050_ = _tmp1049_;
			_tmp1051_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1050_);
			_tmp1052_ = _tmp1051_;
			vala_report_error (_tmp1047_, _tmp1052_);
			_g_free0 (_tmp1052_);
			_g_free0 (_tmp1050_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1053_;
		_tmp1053_ = access;
		if (_tmp1053_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1054_;
			ValaSymbol* _tmp1055_;
			ValaSymbol* _tmp1056_;
			gboolean in_target_type = FALSE;
			_tmp1054_ = member;
			_tmp1055_ = vala_symbol_get_parent_symbol (_tmp1054_);
			_tmp1056_ = _tmp1055_;
			target_type = _tmp1056_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1057_;
				ValaSemanticAnalyzer* _tmp1058_;
				ValaSymbol* _tmp1059_;
				ValaSymbol* _tmp1060_;
				ValaSymbol* _tmp1061_;
				_tmp1057_ = vala_code_context_get_analyzer (context);
				_tmp1058_ = _tmp1057_;
				_tmp1059_ = vala_semantic_analyzer_get_current_symbol (_tmp1058_);
				_tmp1060_ = _tmp1059_;
				_tmp1061_ = _vala_code_node_ref0 (_tmp1060_);
				this_symbol = _tmp1061_;
				{
					gboolean _tmp1062_ = FALSE;
					_tmp1062_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1067_;
						ValaSymbol* _tmp1068_;
						ValaSymbol* _tmp1069_;
						if (!_tmp1062_) {
							ValaSymbol* _tmp1063_;
							ValaSymbol* _tmp1064_;
							ValaSymbol* _tmp1065_;
							ValaSymbol* _tmp1066_;
							_tmp1063_ = this_symbol;
							_tmp1064_ = vala_symbol_get_parent_symbol (_tmp1063_);
							_tmp1065_ = _tmp1064_;
							_tmp1066_ = _vala_code_node_ref0 (_tmp1065_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1066_;
						}
						_tmp1062_ = FALSE;
						_tmp1067_ = this_symbol;
						if (!(_tmp1067_ != NULL)) {
							break;
						}
						_tmp1068_ = target_type;
						_tmp1069_ = this_symbol;
						if (_tmp1068_ == _tmp1069_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1070_;
				ValaSourceReference* _tmp1071_;
				ValaSymbol* _tmp1072_;
				gchar* _tmp1073_;
				gchar* _tmp1074_;
				gchar* _tmp1075_;
				gchar* _tmp1076_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1070_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1071_ = _tmp1070_;
				_tmp1072_ = member;
				_tmp1073_ = vala_symbol_get_full_name (_tmp1072_);
				_tmp1074_ = _tmp1073_;
				_tmp1075_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1074_);
				_tmp1076_ = _tmp1075_;
				vala_report_error (_tmp1071_, _tmp1076_);
				_g_free0 (_tmp1076_);
				_g_free0 (_tmp1074_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1078_;
		ValaExpression* _tmp1079_;
		_tmp1078_ = vala_member_access_get_inner (self);
		_tmp1079_ = _tmp1078_;
		_tmp1077_ = _tmp1079_ != NULL;
	} else {
		_tmp1077_ = FALSE;
	}
	if (_tmp1077_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1080_;
		ValaExpression* _tmp1081_;
		ValaDataType* _tmp1082_;
		ValaDataType* _tmp1083_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1084_;
		ValaExpression* _tmp1085_;
		ValaDataType* _tmp1086_;
		ValaDataType* _tmp1087_;
		ValaPointerType* _tmp1088_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1092_;
		gboolean _tmp1093_ = FALSE;
		gboolean _tmp1094_ = FALSE;
		ValaObjectType* _tmp1095_;
		_tmp1080_ = vala_member_access_get_inner (self);
		_tmp1081_ = _tmp1080_;
		_tmp1082_ = vala_expression_get_value_type (_tmp1081_);
		_tmp1083_ = _tmp1082_;
		instance_type = _tmp1083_;
		_tmp1084_ = vala_member_access_get_inner (self);
		_tmp1085_ = _tmp1084_;
		_tmp1086_ = vala_expression_get_value_type (_tmp1085_);
		_tmp1087_ = _tmp1086_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1087_) ? ((ValaPointerType*) _tmp1087_) : NULL;
		_tmp1088_ = pointer_type;
		if (_tmp1088_ != NULL) {
			ValaPointerType* _tmp1089_;
			ValaDataType* _tmp1090_;
			ValaDataType* _tmp1091_;
			_tmp1089_ = pointer_type;
			_tmp1090_ = vala_pointer_type_get_base_type (_tmp1089_);
			_tmp1091_ = _tmp1090_;
			instance_type = _tmp1091_;
		}
		_tmp1092_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1092_) ? ((ValaObjectType*) _tmp1092_) : NULL;
		_tmp1095_ = object_type;
		if (_tmp1095_ != NULL) {
			ValaObjectType* _tmp1096_;
			ValaObjectTypeSymbol* _tmp1097_;
			ValaObjectTypeSymbol* _tmp1098_;
			_tmp1096_ = object_type;
			_tmp1097_ = vala_object_type_get_object_type_symbol (_tmp1096_);
			_tmp1098_ = _tmp1097_;
			_tmp1094_ = vala_object_type_symbol_has_type_parameters (_tmp1098_);
		} else {
			_tmp1094_ = FALSE;
		}
		if (_tmp1094_) {
			ValaDataType* _tmp1099_;
			_tmp1099_ = instance_type;
			_tmp1093_ = !vala_data_type_has_type_arguments (_tmp1099_);
		} else {
			_tmp1093_ = FALSE;
		}
		if (_tmp1093_) {
			ValaExpression* _tmp1100_;
			ValaExpression* _tmp1101_;
			ValaSourceReference* _tmp1102_;
			ValaSourceReference* _tmp1103_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1100_ = vala_member_access_get_inner (self);
			_tmp1101_ = _tmp1100_;
			_tmp1102_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1101_);
			_tmp1103_ = _tmp1102_;
			vala_report_error (_tmp1103_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1105_ = !may_access_instance_members;
	} else {
		_tmp1105_ = FALSE;
	}
	if (_tmp1105_) {
		_tmp1104_ = TRUE;
	} else {
		gboolean _tmp1106_ = FALSE;
		if (klass) {
			_tmp1106_ = !may_access_klass_members;
		} else {
			_tmp1106_ = FALSE;
		}
		_tmp1104_ = _tmp1106_;
	}
	if (_tmp1104_) {
		ValaSymbol* _tmp1107_;
		ValaSymbol* _tmp1108_;
		ValaDataType* _tmp1131_;
		ValaDataType* _tmp1132_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1107_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1108_ = _tmp1107_;
		if (VALA_IS_METHOD (_tmp1108_)) {
			ValaSemanticAnalyzer* _tmp1109_;
			ValaSemanticAnalyzer* _tmp1110_;
			ValaSymbol* _tmp1111_;
			ValaSymbol* _tmp1112_;
			gboolean _tmp1113_;
			gboolean _tmp1114_;
			ValaDataType* _tmp1115_;
			ValaDataType* _tmp1116_;
			_tmp1109_ = vala_code_context_get_analyzer (context);
			_tmp1110_ = _tmp1109_;
			_tmp1111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1112_ = _tmp1111_;
			_tmp1113_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1114_ = _tmp1113_;
			_tmp1115_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1110_, _tmp1112_, _tmp1114_);
			_tmp1116_ = _tmp1115_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1116_);
			_vala_code_node_unref0 (_tmp1116_);
		} else {
			ValaSymbol* _tmp1117_;
			ValaSymbol* _tmp1118_;
			_tmp1117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1118_ = _tmp1117_;
			if (VALA_IS_FIELD (_tmp1118_)) {
				ValaSymbol* _tmp1119_;
				ValaSymbol* _tmp1120_;
				ValaFieldPrototype* _tmp1121_;
				ValaFieldPrototype* _tmp1122_;
				_tmp1119_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1120_ = _tmp1119_;
				_tmp1121_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1120_, VALA_TYPE_FIELD, ValaField));
				_tmp1122_ = _tmp1121_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1122_);
				_vala_code_node_unref0 (_tmp1122_);
			} else {
				ValaSymbol* _tmp1123_;
				ValaSymbol* _tmp1124_;
				_tmp1123_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1124_ = _tmp1123_;
				if (VALA_IS_PROPERTY (_tmp1124_)) {
					ValaSymbol* _tmp1125_;
					ValaSymbol* _tmp1126_;
					ValaPropertyPrototype* _tmp1127_;
					ValaPropertyPrototype* _tmp1128_;
					_tmp1125_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1126_ = _tmp1125_;
					_tmp1127_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1126_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1128_ = _tmp1127_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1128_);
					_vala_code_node_unref0 (_tmp1128_);
				} else {
					ValaInvalidType* _tmp1129_;
					ValaInvalidType* _tmp1130_;
					_tmp1129_ = vala_invalid_type_new ();
					_tmp1130_ = _tmp1129_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1130_);
					_vala_code_node_unref0 (_tmp1130_);
				}
			}
		}
		_tmp1131_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1132_ = _tmp1131_;
		if (_tmp1132_ != NULL) {
			ValaDataType* _tmp1133_;
			ValaDataType* _tmp1134_;
			ValaDataType* _tmp1135_;
			ValaDataType* _tmp1136_;
			gboolean _tmp1137_;
			gboolean _tmp1138_;
			_tmp1133_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1134_ = _tmp1133_;
			_tmp1135_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1136_ = _tmp1135_;
			_tmp1137_ = vala_data_type_get_value_owned (_tmp1136_);
			_tmp1138_ = _tmp1137_;
			vala_data_type_set_value_owned (_tmp1134_, _tmp1138_);
		}
	} else {
		gboolean _tmp1139_ = FALSE;
		gboolean _tmp1160_ = FALSE;
		gboolean _tmp1161_ = FALSE;
		gboolean _tmp1162_ = FALSE;
		gboolean _tmp1163_ = FALSE;
		gboolean _tmp1180_ = FALSE;
		gboolean _tmp1181_ = FALSE;
		gboolean _tmp1182_ = FALSE;
		gboolean _tmp1183_ = FALSE;
		gboolean _tmp1184_ = FALSE;
		gboolean _tmp1185_;
		gboolean _tmp1186_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1213_;
		ValaSymbol* _tmp1214_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1215_;
		ValaExpression* _tmp1216_;
		gboolean _tmp1217_ = FALSE;
		gboolean _tmp1218_ = FALSE;
		gboolean _tmp1219_ = FALSE;
		gboolean _tmp1220_ = FALSE;
		gboolean _tmp1221_ = FALSE;
		ValaMethod* _tmp1222_;
		ValaSemanticAnalyzer* _tmp1259_;
		ValaSemanticAnalyzer* _tmp1260_;
		ValaSymbol* _tmp1261_;
		ValaSymbol* _tmp1262_;
		gboolean _tmp1263_;
		gboolean _tmp1264_;
		ValaDataType* _tmp1265_;
		ValaDataType* _tmp1266_;
		gboolean _tmp1267_ = FALSE;
		ValaExpression* _tmp1268_;
		ValaExpression* _tmp1269_;
		ValaSymbol* _tmp1282_;
		ValaSymbol* _tmp1283_;
		if (instance) {
			ValaExpression* _tmp1140_;
			ValaExpression* _tmp1141_;
			_tmp1140_ = vala_member_access_get_inner (self);
			_tmp1141_ = _tmp1140_;
			_tmp1139_ = _tmp1141_ == NULL;
		} else {
			_tmp1139_ = FALSE;
		}
		if (_tmp1139_) {
			ValaSourceReference* _tmp1142_;
			ValaSourceReference* _tmp1143_;
			ValaMemberAccess* _tmp1144_;
			ValaMemberAccess* _tmp1145_;
			ValaExpression* _tmp1146_;
			ValaExpression* _tmp1147_;
			ValaParameter* _tmp1148_;
			ValaDataType* _tmp1149_;
			ValaDataType* _tmp1150_;
			ValaDataType* _tmp1151_;
			ValaDataType* _tmp1152_;
			ValaExpression* _tmp1153_;
			ValaExpression* _tmp1154_;
			ValaDataType* _tmp1155_;
			ValaDataType* _tmp1156_;
			ValaExpression* _tmp1157_;
			ValaExpression* _tmp1158_;
			ValaParameter* _tmp1159_;
			_tmp1142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1143_ = _tmp1142_;
			_tmp1144_ = vala_member_access_new (NULL, "this", _tmp1143_);
			_tmp1145_ = _tmp1144_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1145_);
			_vala_code_node_unref0 (_tmp1145_);
			_tmp1146_ = vala_member_access_get_inner (self);
			_tmp1147_ = _tmp1146_;
			_tmp1148_ = this_parameter;
			_tmp1149_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1148_);
			_tmp1150_ = _tmp1149_;
			_tmp1151_ = vala_data_type_copy (_tmp1150_);
			_tmp1152_ = _tmp1151_;
			vala_expression_set_value_type (_tmp1147_, _tmp1152_);
			_vala_code_node_unref0 (_tmp1152_);
			_tmp1153_ = vala_member_access_get_inner (self);
			_tmp1154_ = _tmp1153_;
			_tmp1155_ = vala_expression_get_value_type (_tmp1154_);
			_tmp1156_ = _tmp1155_;
			vala_data_type_set_value_owned (_tmp1156_, FALSE);
			_tmp1157_ = vala_member_access_get_inner (self);
			_tmp1158_ = _tmp1157_;
			_tmp1159_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1158_, (ValaSymbol*) _tmp1159_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1163_ = !klass;
		} else {
			_tmp1163_ = FALSE;
		}
		if (_tmp1163_) {
			ValaSymbol* _tmp1164_;
			ValaSymbol* _tmp1165_;
			_tmp1164_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1165_ = _tmp1164_;
			_tmp1162_ = !VALA_IS_CREATION_METHOD (_tmp1165_);
		} else {
			_tmp1162_ = FALSE;
		}
		if (_tmp1162_) {
			_tmp1161_ = may_access_instance_members;
		} else {
			_tmp1161_ = FALSE;
		}
		if (_tmp1161_) {
			ValaExpression* _tmp1166_;
			ValaExpression* _tmp1167_;
			_tmp1166_ = vala_member_access_get_inner (self);
			_tmp1167_ = _tmp1166_;
			_tmp1160_ = _tmp1167_ != NULL;
		} else {
			_tmp1160_ = FALSE;
		}
		if (_tmp1160_) {
			ValaExpression* _tmp1168_;
			ValaExpression* _tmp1169_;
			ValaSymbol* _tmp1170_;
			ValaSymbol* _tmp1171_;
			_tmp1168_ = vala_member_access_get_inner (self);
			_tmp1169_ = _tmp1168_;
			_tmp1170_ = vala_expression_get_symbol_reference (_tmp1169_);
			_tmp1171_ = _tmp1170_;
			if (VALA_IS_METHOD (_tmp1171_)) {
			} else {
				ValaSourceReference* _tmp1172_;
				ValaSourceReference* _tmp1173_;
				ValaSymbol* _tmp1174_;
				ValaSymbol* _tmp1175_;
				gchar* _tmp1176_;
				gchar* _tmp1177_;
				gchar* _tmp1178_;
				gchar* _tmp1179_;
				_tmp1172_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1173_ = _tmp1172_;
				_tmp1174_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1175_ = _tmp1174_;
				_tmp1176_ = vala_symbol_get_full_name (_tmp1175_);
				_tmp1177_ = _tmp1176_;
				_tmp1178_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1177_);
				_tmp1179_ = _tmp1178_;
				vala_report_warning (_tmp1173_, _tmp1179_);
				_g_free0 (_tmp1179_);
				_g_free0 (_tmp1177_);
			}
		}
		_tmp1185_ = vala_code_context_get_experimental_non_null (context);
		_tmp1186_ = _tmp1185_;
		if (_tmp1186_) {
			_tmp1184_ = instance;
		} else {
			_tmp1184_ = FALSE;
		}
		if (_tmp1184_) {
			ValaExpression* _tmp1187_;
			ValaExpression* _tmp1188_;
			ValaDataType* _tmp1189_;
			ValaDataType* _tmp1190_;
			gboolean _tmp1191_;
			gboolean _tmp1192_;
			_tmp1187_ = vala_member_access_get_inner (self);
			_tmp1188_ = _tmp1187_;
			_tmp1189_ = vala_expression_get_value_type (_tmp1188_);
			_tmp1190_ = _tmp1189_;
			_tmp1191_ = vala_data_type_get_nullable (_tmp1190_);
			_tmp1192_ = _tmp1191_;
			_tmp1183_ = _tmp1192_;
		} else {
			_tmp1183_ = FALSE;
		}
		if (_tmp1183_) {
			ValaExpression* _tmp1193_;
			ValaExpression* _tmp1194_;
			ValaDataType* _tmp1195_;
			ValaDataType* _tmp1196_;
			_tmp1193_ = vala_member_access_get_inner (self);
			_tmp1194_ = _tmp1193_;
			_tmp1195_ = vala_expression_get_value_type (_tmp1194_);
			_tmp1196_ = _tmp1195_;
			_tmp1182_ = !VALA_IS_POINTER_TYPE (_tmp1196_);
		} else {
			_tmp1182_ = FALSE;
		}
		if (_tmp1182_) {
			ValaExpression* _tmp1197_;
			ValaExpression* _tmp1198_;
			ValaDataType* _tmp1199_;
			ValaDataType* _tmp1200_;
			_tmp1197_ = vala_member_access_get_inner (self);
			_tmp1198_ = _tmp1197_;
			_tmp1199_ = vala_expression_get_value_type (_tmp1198_);
			_tmp1200_ = _tmp1199_;
			_tmp1181_ = !VALA_IS_GENERIC_TYPE (_tmp1200_);
		} else {
			_tmp1181_ = FALSE;
		}
		if (_tmp1181_) {
			ValaExpression* _tmp1201_;
			ValaExpression* _tmp1202_;
			ValaDataType* _tmp1203_;
			ValaDataType* _tmp1204_;
			_tmp1201_ = vala_member_access_get_inner (self);
			_tmp1202_ = _tmp1201_;
			_tmp1203_ = vala_expression_get_value_type (_tmp1202_);
			_tmp1204_ = _tmp1203_;
			_tmp1180_ = !VALA_IS_ARRAY_TYPE (_tmp1204_);
		} else {
			_tmp1180_ = FALSE;
		}
		if (_tmp1180_) {
			ValaSourceReference* _tmp1205_;
			ValaSourceReference* _tmp1206_;
			ValaSymbol* _tmp1207_;
			ValaSymbol* _tmp1208_;
			gchar* _tmp1209_;
			gchar* _tmp1210_;
			gchar* _tmp1211_;
			gchar* _tmp1212_;
			_tmp1205_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1206_ = _tmp1205_;
			_tmp1207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1208_ = _tmp1207_;
			_tmp1209_ = vala_symbol_get_full_name (_tmp1208_);
			_tmp1210_ = _tmp1209_;
			_tmp1211_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1210_);
			_tmp1212_ = _tmp1211_;
			vala_report_error (_tmp1206_, _tmp1212_);
			_g_free0 (_tmp1212_);
			_g_free0 (_tmp1210_);
		}
		_tmp1213_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1214_ = _tmp1213_;
		m = VALA_IS_METHOD (_tmp1214_) ? ((ValaMethod*) _tmp1214_) : NULL;
		_tmp1215_ = vala_member_access_get_inner (self);
		_tmp1216_ = _tmp1215_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1216_) ? ((ValaMemberAccess*) _tmp1216_) : NULL;
		_tmp1222_ = m;
		if (_tmp1222_ != NULL) {
			ValaMethod* _tmp1223_;
			ValaMemberBinding _tmp1224_;
			ValaMemberBinding _tmp1225_;
			_tmp1223_ = m;
			_tmp1224_ = vala_method_get_binding (_tmp1223_);
			_tmp1225_ = _tmp1224_;
			_tmp1221_ = _tmp1225_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1221_ = FALSE;
		}
		if (_tmp1221_) {
			ValaMethod* _tmp1226_;
			ValaSymbol* _tmp1227_;
			ValaSymbol* _tmp1228_;
			_tmp1226_ = m;
			_tmp1227_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1226_);
			_tmp1228_ = _tmp1227_;
			_tmp1220_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1228_);
		} else {
			_tmp1220_ = FALSE;
		}
		if (_tmp1220_) {
			ValaExpression* _tmp1229_;
			ValaExpression* _tmp1230_;
			_tmp1229_ = vala_member_access_get_inner (self);
			_tmp1230_ = _tmp1229_;
			_tmp1219_ = _tmp1230_ != NULL;
		} else {
			_tmp1219_ = FALSE;
		}
		if (_tmp1219_) {
			ValaExpression* _tmp1231_;
			ValaExpression* _tmp1232_;
			ValaDataType* _tmp1233_;
			ValaDataType* _tmp1234_;
			_tmp1231_ = vala_member_access_get_inner (self);
			_tmp1232_ = _tmp1231_;
			_tmp1233_ = vala_expression_get_value_type (_tmp1232_);
			_tmp1234_ = _tmp1233_;
			_tmp1218_ = _tmp1234_ == NULL;
		} else {
			_tmp1218_ = FALSE;
		}
		if (_tmp1218_) {
			ValaMemberAccess* _tmp1235_;
			ValaList* _tmp1236_;
			gint _tmp1237_;
			gint _tmp1238_;
			_tmp1235_ = inner_ma;
			_tmp1236_ = _tmp1235_->priv->type_argument_list;
			_tmp1237_ = vala_collection_get_size ((ValaCollection*) _tmp1236_);
			_tmp1238_ = _tmp1237_;
			_tmp1217_ = _tmp1238_ > 0;
		} else {
			_tmp1217_ = FALSE;
		}
		if (_tmp1217_) {
			ValaExpression* _tmp1239_;
			ValaExpression* _tmp1240_;
			ValaMethod* _tmp1241_;
			ValaSymbol* _tmp1242_;
			ValaSymbol* _tmp1243_;
			ValaObjectType* _tmp1244_;
			ValaObjectType* _tmp1245_;
			_tmp1239_ = vala_member_access_get_inner (self);
			_tmp1240_ = _tmp1239_;
			_tmp1241_ = m;
			_tmp1242_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1241_);
			_tmp1243_ = _tmp1242_;
			_tmp1244_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1243_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1245_ = _tmp1244_;
			vala_expression_set_value_type (_tmp1240_, (ValaDataType*) _tmp1245_);
			_vala_code_node_unref0 (_tmp1245_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1246_;
				ValaList* _tmp1247_;
				ValaList* _tmp1248_;
				gint _type_argument_size = 0;
				ValaList* _tmp1249_;
				gint _tmp1250_;
				gint _tmp1251_;
				gint _type_argument_index = 0;
				_tmp1246_ = inner_ma;
				_tmp1247_ = _tmp1246_->priv->type_argument_list;
				_tmp1248_ = _vala_iterable_ref0 (_tmp1247_);
				_type_argument_list = _tmp1248_;
				_tmp1249_ = _type_argument_list;
				_tmp1250_ = vala_collection_get_size ((ValaCollection*) _tmp1249_);
				_tmp1251_ = _tmp1250_;
				_type_argument_size = _tmp1251_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1252_;
					gpointer _tmp1253_;
					ValaExpression* _tmp1254_;
					ValaExpression* _tmp1255_;
					ValaDataType* _tmp1256_;
					ValaDataType* _tmp1257_;
					ValaDataType* _tmp1258_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1252_ = _type_argument_list;
					_tmp1253_ = vala_list_get (_tmp1252_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1253_;
					_tmp1254_ = vala_member_access_get_inner (self);
					_tmp1255_ = _tmp1254_;
					_tmp1256_ = vala_expression_get_value_type (_tmp1255_);
					_tmp1257_ = _tmp1256_;
					_tmp1258_ = type_argument;
					vala_data_type_add_type_argument (_tmp1257_, _tmp1258_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1259_ = vala_code_context_get_analyzer (context);
		_tmp1260_ = _tmp1259_;
		_tmp1261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1262_ = _tmp1261_;
		_tmp1263_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1264_ = _tmp1263_;
		_tmp1265_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1260_, _tmp1262_, _tmp1264_);
		_tmp1266_ = _tmp1265_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1266_);
		_vala_code_node_unref0 (_tmp1266_);
		_tmp1268_ = vala_member_access_get_inner (self);
		_tmp1269_ = _tmp1268_;
		if (_tmp1269_ != NULL) {
			ValaDataType* _tmp1270_;
			ValaDataType* _tmp1271_;
			_tmp1270_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1271_ = _tmp1270_;
			_tmp1267_ = _tmp1271_ != NULL;
		} else {
			_tmp1267_ = FALSE;
		}
		if (_tmp1267_) {
			ValaDataType* _tmp1272_;
			ValaDataType* _tmp1273_;
			ValaExpression* _tmp1274_;
			ValaExpression* _tmp1275_;
			ValaDataType* _tmp1276_;
			ValaDataType* _tmp1277_;
			ValaDataType* _tmp1278_;
			ValaDataType* _tmp1279_;
			_tmp1272_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1273_ = _tmp1272_;
			_tmp1274_ = vala_member_access_get_inner (self);
			_tmp1275_ = _tmp1274_;
			_tmp1276_ = vala_expression_get_value_type (_tmp1275_);
			_tmp1277_ = _tmp1276_;
			_tmp1278_ = vala_data_type_get_actual_type (_tmp1273_, _tmp1277_, NULL, (ValaCodeNode*) self);
			_tmp1279_ = _tmp1278_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1279_);
			_vala_code_node_unref0 (_tmp1279_);
		} else {
			ValaDataType* _tmp1280_;
			ValaDataType* _tmp1281_;
			_tmp1280_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1281_ = _tmp1280_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1281_);
		}
		_tmp1282_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1283_ = _tmp1282_;
		if (VALA_IS_METHOD (_tmp1283_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1284_;
			ValaSymbol* _tmp1285_;
			ValaDataType* _tmp1286_;
			ValaDataType* _tmp1287_;
			gboolean _tmp1294_ = FALSE;
			_tmp1284_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1285_ = _tmp1284_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1285_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1286_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1287_ = _tmp1286_;
			if (_tmp1287_ != NULL) {
				ValaDataType* _tmp1288_;
				ValaDataType* _tmp1289_;
				ValaDataType* _tmp1290_;
				ValaDataType* _tmp1291_;
				gboolean _tmp1292_;
				gboolean _tmp1293_;
				_tmp1288_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1289_ = _tmp1288_;
				_tmp1290_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1291_ = _tmp1290_;
				_tmp1292_ = vala_data_type_get_value_owned (_tmp1291_);
				_tmp1293_ = _tmp1292_;
				vala_data_type_set_value_owned (_tmp1289_, _tmp1293_);
			}
			if (instance) {
				ValaMethod* _tmp1295_;
				ValaSymbol* _tmp1296_;
				ValaSymbol* _tmp1297_;
				_tmp1295_ = method;
				_tmp1296_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1295_);
				_tmp1297_ = _tmp1296_;
				_tmp1294_ = VALA_IS_TYPESYMBOL (_tmp1297_);
			} else {
				_tmp1294_ = FALSE;
			}
			if (_tmp1294_) {
				ValaExpression* _tmp1298_;
				ValaExpression* _tmp1299_;
				ValaMethod* _tmp1300_;
				ValaSymbol* _tmp1301_;
				ValaSymbol* _tmp1302_;
				ValaDataType* _tmp1303_;
				ValaDataType* _tmp1304_;
				ValaExpression* _tmp1305_;
				ValaExpression* _tmp1306_;
				ValaDataType* _tmp1307_;
				ValaDataType* _tmp1308_;
				ValaMethod* _tmp1309_;
				ValaParameter* _tmp1310_;
				ValaParameter* _tmp1311_;
				ValaDataType* _tmp1312_;
				ValaDataType* _tmp1313_;
				gboolean _tmp1314_;
				gboolean _tmp1315_;
				_tmp1298_ = vala_member_access_get_inner (self);
				_tmp1299_ = _tmp1298_;
				_tmp1300_ = method;
				_tmp1301_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1300_);
				_tmp1302_ = _tmp1301_;
				_tmp1303_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1302_);
				_tmp1304_ = _tmp1303_;
				vala_expression_set_target_type (_tmp1299_, _tmp1304_);
				_vala_code_node_unref0 (_tmp1304_);
				_tmp1305_ = vala_member_access_get_inner (self);
				_tmp1306_ = _tmp1305_;
				_tmp1307_ = vala_expression_get_target_type (_tmp1306_);
				_tmp1308_ = _tmp1307_;
				_tmp1309_ = method;
				_tmp1310_ = vala_method_get_this_parameter (_tmp1309_);
				_tmp1311_ = _tmp1310_;
				_tmp1312_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1311_);
				_tmp1313_ = _tmp1312_;
				_tmp1314_ = vala_data_type_get_value_owned (_tmp1313_);
				_tmp1315_ = _tmp1314_;
				vala_data_type_set_value_owned (_tmp1308_, _tmp1315_);
			}
		} else {
			gboolean _tmp1316_ = FALSE;
			gboolean _tmp1317_ = FALSE;
			ValaSymbol* _tmp1318_;
			ValaSymbol* _tmp1319_;
			_tmp1318_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1319_ = _tmp1318_;
			if (VALA_IS_PROPERTY (_tmp1319_)) {
				_tmp1317_ = instance;
			} else {
				_tmp1317_ = FALSE;
			}
			if (_tmp1317_) {
				ValaSymbol* _tmp1320_;
				ValaSymbol* _tmp1321_;
				ValaSymbol* _tmp1322_;
				ValaSymbol* _tmp1323_;
				_tmp1320_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1321_ = _tmp1320_;
				_tmp1322_ = vala_symbol_get_parent_symbol (_tmp1321_);
				_tmp1323_ = _tmp1322_;
				_tmp1316_ = _tmp1323_ != NULL;
			} else {
				_tmp1316_ = FALSE;
			}
			if (_tmp1316_) {
				ValaExpression* _tmp1324_;
				ValaExpression* _tmp1325_;
				ValaSymbol* _tmp1326_;
				ValaSymbol* _tmp1327_;
				ValaSymbol* _tmp1328_;
				ValaSymbol* _tmp1329_;
				ValaDataType* _tmp1330_;
				ValaDataType* _tmp1331_;
				_tmp1324_ = vala_member_access_get_inner (self);
				_tmp1325_ = _tmp1324_;
				_tmp1326_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1327_ = _tmp1326_;
				_tmp1328_ = vala_symbol_get_parent_symbol (_tmp1327_);
				_tmp1329_ = _tmp1328_;
				_tmp1330_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1329_);
				_tmp1331_ = _tmp1330_;
				vala_expression_set_target_type (_tmp1325_, _tmp1331_);
				_vala_code_node_unref0 (_tmp1331_);
			} else {
				gboolean _tmp1332_ = FALSE;
				gboolean _tmp1333_ = FALSE;
				gboolean _tmp1334_ = FALSE;
				ValaSymbol* _tmp1335_;
				ValaSymbol* _tmp1336_;
				_tmp1335_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1336_ = _tmp1335_;
				if (VALA_IS_FIELD (_tmp1336_)) {
					_tmp1334_ = TRUE;
				} else {
					ValaSymbol* _tmp1337_;
					ValaSymbol* _tmp1338_;
					_tmp1337_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1338_ = _tmp1337_;
					_tmp1334_ = VALA_IS_SIGNAL (_tmp1338_);
				}
				if (_tmp1334_) {
					_tmp1333_ = instance;
				} else {
					_tmp1333_ = FALSE;
				}
				if (_tmp1333_) {
					ValaSymbol* _tmp1339_;
					ValaSymbol* _tmp1340_;
					ValaSymbol* _tmp1341_;
					ValaSymbol* _tmp1342_;
					_tmp1339_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1340_ = _tmp1339_;
					_tmp1341_ = vala_symbol_get_parent_symbol (_tmp1340_);
					_tmp1342_ = _tmp1341_;
					_tmp1332_ = _tmp1342_ != NULL;
				} else {
					_tmp1332_ = FALSE;
				}
				if (_tmp1332_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1343_;
					ValaSymbol* _tmp1344_;
					ValaSymbol* _tmp1345_;
					ValaSymbol* _tmp1346_;
					ValaDataType* _tmp1347_;
					ValaExpression* _tmp1348_;
					ValaExpression* _tmp1349_;
					ValaDataType* _tmp1350_;
					ValaExpression* _tmp1351_;
					ValaExpression* _tmp1352_;
					ValaDataType* _tmp1353_;
					ValaDataType* _tmp1354_;
					ValaDataType* _tmp1355_;
					ValaDataType* _tmp1356_;
					_tmp1343_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1344_ = _tmp1343_;
					_tmp1345_ = vala_symbol_get_parent_symbol (_tmp1344_);
					_tmp1346_ = _tmp1345_;
					_tmp1347_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1346_);
					parent_type = _tmp1347_;
					_tmp1348_ = vala_member_access_get_inner (self);
					_tmp1349_ = _tmp1348_;
					_tmp1350_ = parent_type;
					_tmp1351_ = vala_member_access_get_inner (self);
					_tmp1352_ = _tmp1351_;
					_tmp1353_ = vala_expression_get_value_type (_tmp1352_);
					_tmp1354_ = _tmp1353_;
					_tmp1355_ = vala_data_type_get_actual_type (_tmp1350_, _tmp1354_, NULL, (ValaCodeNode*) self);
					_tmp1356_ = _tmp1355_;
					vala_expression_set_target_type (_tmp1349_, _tmp1356_);
					_vala_code_node_unref0 (_tmp1356_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1357_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1358_ = _tmp1357_;
	if (_tmp1358_ != NULL) {
		ValaDataType* _tmp1359_;
		ValaDataType* _tmp1360_;
		_tmp1359_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1360_ = _tmp1359_;
		vala_code_node_check ((ValaCodeNode*) _tmp1360_, context);
	}
	_tmp1361_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1362_ = _tmp1361_;
	result = !_tmp1362_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

