/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;

static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp13_ = _arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _arg_index);
			arg = (ValaExpression*) _tmp14_;
			_tmp15_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp16_ = self->priv->object_initializer;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp21_ = _init_list;
			_tmp22_ = vala_list_get (_tmp21_, _init_index);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaExpression* _tmp12_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _arg_index);
			arg = (ValaExpression*) _tmp11_;
			_tmp12_ = arg;
			if (!vala_expression_is_accessible (_tmp12_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp13_ = self->priv->object_initializer;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaMemberInitializer* _tmp20_;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp18_ = _init_list;
			_tmp19_ = vala_list_get (_tmp18_, _init_index);
			init = (ValaMemberInitializer*) _tmp19_;
			_tmp20_ = init;
			_tmp21_ = vala_member_initializer_get_initializer (_tmp20_);
			_tmp22_ = _tmp21_;
			if (!vala_expression_is_accessible (_tmp22_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	gint given_num_type_args = 0;
	ValaDataType* _tmp115_;
	ValaDataType* _tmp116_;
	ValaList* _tmp117_;
	gint _tmp118_;
	gint _tmp119_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp120_;
	gboolean _tmp246_ = FALSE;
	ValaSymbol* _tmp247_;
	ValaSymbol* _tmp248_;
	ValaSymbol* _tmp259_;
	ValaSymbol* _tmp260_;
	ValaTypeSymbol* _tmp476_;
	gboolean _tmp477_;
	gboolean _tmp478_;
	gboolean _tmp495_;
	gboolean _tmp496_;
	gboolean _tmp549_;
	gboolean _tmp550_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp56_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		type_args = _tmp31_;
		_tmp32_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp32_)) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp37_;
			ValaMethod* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaMethod* _tmp47_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp48_;
			ValaMemberAccess* _tmp49_;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp33_ = constructor_sym;
			_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _vala_code_node_ref0 (_tmp35_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp36_;
			_tmp37_ = constructor_sym;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp38_;
			_tmp39_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaMethod* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = constructor;
				_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strdup_printf ("`%s' is not a creation method", _tmp44_);
				_tmp46_ = _tmp45_;
				vala_report_error (_tmp41_, _tmp46_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp44_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp47_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp47_);
			_tmp48_ = vala_object_creation_expression_get_member_name (self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_member_access_get_inner (_tmp49_);
			_tmp51_ = _tmp50_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				ValaList* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_tmp55_ = _vala_iterable_ref0 (_tmp54_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp55_;
			}
			_vala_code_node_unref0 (constructor);
		}
		_tmp56_ = type_sym;
		if (VALA_IS_CLASS (_tmp56_)) {
			ValaSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			gboolean _tmp60_;
			gboolean _tmp61_;
			_tmp57_ = type_sym;
			_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp58_;
			_tmp59_ = type;
			_tmp60_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CLASS, ValaClass));
			_tmp61_ = _tmp60_;
			if (_tmp61_) {
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaErrorType* _tmp64_;
				ValaErrorType* _tmp65_;
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_error_type_new (NULL, NULL, _tmp63_);
				_tmp65_ = _tmp64_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp65_);
				_vala_code_node_unref0 (_tmp65_);
			} else {
				ValaTypeSymbol* _tmp66_;
				ValaObjectType* _tmp67_;
				ValaObjectType* _tmp68_;
				_tmp66_ = type;
				_tmp67_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_CLASS, ValaClass));
				_tmp68_ = _tmp67_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
			}
		} else {
			ValaSymbol* _tmp69_;
			_tmp69_ = type_sym;
			if (VALA_IS_STRUCT (_tmp69_)) {
				ValaSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaStructValueType* _tmp73_;
				ValaStructValueType* _tmp74_;
				_tmp70_ = type_sym;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp71_;
				_tmp72_ = type;
				_tmp73_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp74_ = _tmp73_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp74_);
				_vala_code_node_unref0 (_tmp74_);
			} else {
				ValaSymbol* _tmp75_;
				_tmp75_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp75_)) {
					ValaSymbol* _tmp76_;
					ValaTypeSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSymbol* _tmp79_;
					ValaSymbol* _tmp80_;
					ValaSymbol* _tmp81_;
					ValaSourceReference* _tmp82_;
					ValaSourceReference* _tmp83_;
					ValaErrorType* _tmp84_;
					ValaErrorType* _tmp85_;
					ValaSymbol* _tmp86_;
					_tmp76_ = type_sym;
					_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
					_vala_code_node_unref0 (type);
					type = _tmp77_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_symbol_get_parent_symbol (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = type_sym;
					_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp83_ = _tmp82_;
					_tmp84_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp83_);
					_tmp85_ = _tmp84_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp85_);
					_vala_code_node_unref0 (_tmp85_);
					_tmp86_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp86_);
				} else {
					ValaSourceReference* _tmp87_;
					ValaSourceReference* _tmp88_;
					ValaSymbol* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp88_ = _tmp87_;
					_tmp89_ = type_sym;
					_tmp90_ = vala_symbol_get_full_name (_tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp91_);
					_tmp93_ = _tmp92_;
					vala_report_error (_tmp88_, _tmp93_);
					_g_free0 (_tmp93_);
					_g_free0 (_tmp91_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp94_;
			ValaList* _tmp95_;
			gint _type_arg_size = 0;
			ValaList* _tmp96_;
			gint _tmp97_;
			gint _tmp98_;
			gint _type_arg_index = 0;
			_tmp94_ = type_args;
			_tmp95_ = _vala_iterable_ref0 (_tmp94_);
			_type_arg_list = _tmp95_;
			_tmp96_ = _type_arg_list;
			_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
			_tmp98_ = _tmp97_;
			_type_arg_size = _tmp98_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp99_;
				gpointer _tmp100_;
				ValaDataType* _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp99_ = _type_arg_list;
				_tmp100_ = vala_list_get (_tmp99_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp100_;
				_tmp101_ = vala_object_creation_expression_get_type_reference (self);
				_tmp102_ = _tmp101_;
				_tmp103_ = type_arg;
				vala_data_type_add_type_argument (_tmp102_, _tmp103_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp104_;
		ValaDataType* _tmp105_;
		ValaTypeSymbol* _tmp106_;
		ValaTypeSymbol* _tmp107_;
		ValaTypeSymbol* _tmp108_;
		_tmp104_ = vala_object_creation_expression_get_type_reference (self);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = _vala_code_node_ref0 (_tmp107_);
		_vala_code_node_unref0 (type);
		type = _tmp108_;
	}
	_tmp109_ = vala_object_creation_expression_get_type_reference (self);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_data_type_copy (_tmp110_);
	_tmp112_ = _tmp111_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp112_);
	_vala_code_node_unref0 (_tmp112_);
	_tmp113_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp114_ = _tmp113_;
	vala_data_type_set_value_owned (_tmp114_, TRUE);
	_tmp115_ = vala_object_creation_expression_get_type_reference (self);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_data_type_get_type_arguments (_tmp116_);
	_tmp118_ = vala_collection_get_size ((ValaCollection*) _tmp117_);
	_tmp119_ = _tmp118_;
	given_num_type_args = _tmp119_;
	expected_num_type_args = 0;
	_tmp120_ = type;
	if (VALA_IS_CLASS (_tmp120_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp121_;
		ValaClass* _tmp122_;
		ValaClass* _tmp123_;
		ValaList* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		gboolean _tmp127_;
		ValaClass* _tmp130_;
		gboolean _tmp131_;
		gboolean _tmp132_;
		ValaSymbol* _tmp140_;
		ValaSymbol* _tmp141_;
		gboolean _tmp162_ = FALSE;
		ValaSymbol* _tmp163_;
		ValaSymbol* _tmp164_;
		_tmp121_ = type;
		_tmp122_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp122_;
		_tmp123_ = cl;
		_tmp124_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp123_);
		_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
		_tmp126_ = _tmp125_;
		expected_num_type_args = _tmp126_;
		_tmp127_ = self->priv->_struct_creation;
		if (_tmp127_) {
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			vala_report_error (_tmp129_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp130_ = cl;
		_tmp131_ = vala_class_get_is_abstract (_tmp130_);
		_tmp132_ = _tmp131_;
		if (_tmp132_) {
			ValaSourceReference* _tmp133_;
			ValaSourceReference* _tmp134_;
			ValaClass* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp134_ = _tmp133_;
			_tmp135_ = cl;
			_tmp136_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp137_);
			_tmp139_ = _tmp138_;
			vala_report_error (_tmp134_, _tmp139_);
			_g_free0 (_tmp139_);
			_g_free0 (_tmp137_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp140_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp141_ = _tmp140_;
		if (_tmp141_ == NULL) {
			ValaClass* _tmp142_;
			ValaCreationMethod* _tmp143_;
			ValaCreationMethod* _tmp144_;
			ValaSymbol* _tmp145_;
			ValaSymbol* _tmp146_;
			ValaSymbol* _tmp154_;
			ValaSymbol* _tmp155_;
			ValaSymbol* _tmp156_;
			ValaSymbol* _tmp157_;
			ValaVersionAttribute* _tmp158_;
			ValaVersionAttribute* _tmp159_;
			ValaSourceReference* _tmp160_;
			ValaSourceReference* _tmp161_;
			_tmp142_ = cl;
			_tmp143_ = vala_class_get_default_construction_method (_tmp142_);
			_tmp144_ = _tmp143_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp144_);
			_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp146_ = _tmp145_;
			if (_tmp146_ == NULL) {
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				ValaClass* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				_tmp149_ = cl;
				_tmp150_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp149_);
				_tmp151_ = _tmp150_;
				_tmp152_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp151_);
				_tmp153_ = _tmp152_;
				vala_report_error (_tmp148_, _tmp153_);
				_g_free0 (_tmp153_);
				_g_free0 (_tmp151_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp155_ = _tmp154_;
			vala_symbol_set_used (_tmp155_, TRUE);
			_tmp156_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_symbol_get_version (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp161_ = _tmp160_;
			vala_version_attribute_check (_tmp159_, _tmp161_);
		}
		_tmp163_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp164_ = _tmp163_;
		if (_tmp164_ != NULL) {
			gboolean _tmp165_ = FALSE;
			ValaSymbol* _tmp166_;
			ValaSymbol* _tmp167_;
			ValaSymbolAccessibility _tmp168_;
			ValaSymbolAccessibility _tmp169_;
			_tmp166_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_symbol_get_access (_tmp167_);
			_tmp169_ = _tmp168_;
			if (_tmp169_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp165_ = TRUE;
			} else {
				ValaSymbol* _tmp170_;
				ValaSymbol* _tmp171_;
				ValaSymbolAccessibility _tmp172_;
				ValaSymbolAccessibility _tmp173_;
				_tmp170_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_symbol_get_access (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp165_ = _tmp173_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp162_ = _tmp165_;
		} else {
			_tmp162_ = FALSE;
		}
		if (_tmp162_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp174_;
				ValaSemanticAnalyzer* _tmp175_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp174_ = vala_code_context_get_analyzer (context);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_semantic_analyzer_get_current_symbol (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = _vala_code_node_ref0 (_tmp177_);
				this_symbol = _tmp178_;
				{
					gboolean _tmp179_ = FALSE;
					_tmp179_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp184_;
						ValaSymbol* _tmp185_;
						ValaClass* _tmp186_;
						if (!_tmp179_) {
							ValaSymbol* _tmp180_;
							ValaSymbol* _tmp181_;
							ValaSymbol* _tmp182_;
							ValaSymbol* _tmp183_;
							_tmp180_ = this_symbol;
							_tmp181_ = vala_symbol_get_parent_symbol (_tmp180_);
							_tmp182_ = _tmp181_;
							_tmp183_ = _vala_code_node_ref0 (_tmp182_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp183_;
						}
						_tmp179_ = FALSE;
						_tmp184_ = this_symbol;
						if (!(_tmp184_ != NULL)) {
							break;
						}
						_tmp185_ = this_symbol;
						_tmp186_ = cl;
						if (_tmp185_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp186_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp187_;
				ValaSourceReference* _tmp188_;
				ValaSymbol* _tmp189_;
				ValaSymbol* _tmp190_;
				gchar* _tmp191_;
				gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp188_ = _tmp187_;
				_tmp189_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_symbol_get_full_name (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp192_);
				_tmp194_ = _tmp193_;
				vala_report_error (_tmp188_, _tmp194_);
				_g_free0 (_tmp194_);
				_g_free0 (_tmp192_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp195_;
			ValaClass* _tmp196_;
			gchar* _tmp197_;
			gchar* _tmp198_;
			gboolean _tmp199_;
			ValaClass* _tmp202_;
			ValaClass* _tmp203_;
			ValaClass* _tmp204_;
			ValaClass* _tmp205_;
			_tmp195_ = cl;
			if (!(_tmp195_ != NULL)) {
				break;
			}
			_tmp196_ = cl;
			_tmp197_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp196_, "CCode", "ref_sink_function", NULL);
			_tmp198_ = _tmp197_;
			_tmp199_ = _tmp198_ != NULL;
			_g_free0 (_tmp198_);
			if (_tmp199_) {
				ValaDataType* _tmp200_;
				ValaDataType* _tmp201_;
				_tmp200_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp201_ = _tmp200_;
				vala_data_type_set_floating_reference (_tmp201_, TRUE);
				break;
			}
			_tmp202_ = cl;
			_tmp203_ = vala_class_get_base_class (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp205_ = _vala_code_node_ref0 (_tmp204_);
			_vala_code_node_unref0 (cl);
			cl = _tmp205_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp206_;
		_tmp206_ = type;
		if (VALA_IS_STRUCT (_tmp206_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp207_;
			ValaStruct* _tmp208_;
			ValaStruct* _tmp209_;
			ValaList* _tmp210_;
			gint _tmp211_;
			gint _tmp212_;
			gboolean _tmp213_ = FALSE;
			gboolean _tmp214_;
			ValaSymbol* _tmp219_;
			ValaSymbol* _tmp220_;
			gboolean _tmp224_ = FALSE;
			gboolean _tmp225_ = FALSE;
			gboolean _tmp226_ = FALSE;
			ValaProfile _tmp227_;
			ValaProfile _tmp228_;
			_tmp207_ = type;
			_tmp208_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp207_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp208_;
			_tmp209_ = st;
			_tmp210_ = vala_struct_get_type_parameters (_tmp209_);
			_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
			_tmp212_ = _tmp211_;
			expected_num_type_args = _tmp212_;
			_tmp214_ = self->priv->_struct_creation;
			if (!_tmp214_) {
				gboolean _tmp215_;
				gboolean _tmp216_;
				_tmp215_ = vala_code_context_get_deprecated (context);
				_tmp216_ = _tmp215_;
				_tmp213_ = !_tmp216_;
			} else {
				_tmp213_ = FALSE;
			}
			if (_tmp213_) {
				ValaSourceReference* _tmp217_;
				ValaSourceReference* _tmp218_;
				_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp218_ = _tmp217_;
				vala_report_warning (_tmp218_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp219_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp220_ = _tmp219_;
			if (_tmp220_ == NULL) {
				ValaStruct* _tmp221_;
				ValaCreationMethod* _tmp222_;
				ValaCreationMethod* _tmp223_;
				_tmp221_ = st;
				_tmp222_ = vala_struct_get_default_construction_method (_tmp221_);
				_tmp223_ = _tmp222_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp223_);
			}
			_tmp227_ = vala_code_context_get_profile (context);
			_tmp228_ = _tmp227_;
			if (_tmp228_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp229_;
				_tmp229_ = st;
				_tmp226_ = vala_struct_is_simple_type (_tmp229_);
			} else {
				_tmp226_ = FALSE;
			}
			if (_tmp226_) {
				ValaSymbol* _tmp230_;
				ValaSymbol* _tmp231_;
				_tmp230_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp231_ = _tmp230_;
				_tmp225_ = _tmp231_ == NULL;
			} else {
				_tmp225_ = FALSE;
			}
			if (_tmp225_) {
				ValaList* _tmp232_;
				gint _tmp233_;
				gint _tmp234_;
				_tmp232_ = self->priv->object_initializer;
				_tmp233_ = vala_collection_get_size ((ValaCollection*) _tmp232_);
				_tmp234_ = _tmp233_;
				_tmp224_ = _tmp234_ == 0;
			} else {
				_tmp224_ = FALSE;
			}
			if (_tmp224_) {
				ValaSourceReference* _tmp235_;
				ValaSourceReference* _tmp236_;
				ValaStruct* _tmp237_;
				gchar* _tmp238_;
				gchar* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp236_ = _tmp235_;
				_tmp237_ = st;
				_tmp238_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp237_);
				_tmp239_ = _tmp238_;
				_tmp240_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp239_);
				_tmp241_ = _tmp240_;
				vala_report_error (_tmp236_, _tmp241_);
				_g_free0 (_tmp241_);
				_g_free0 (_tmp239_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	if (expected_num_type_args > given_num_type_args) {
		ValaSourceReference* _tmp242_;
		ValaSourceReference* _tmp243_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp243_ = _tmp242_;
		vala_report_error (_tmp243_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		if (expected_num_type_args < given_num_type_args) {
			ValaSourceReference* _tmp244_;
			ValaSourceReference* _tmp245_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp245_ = _tmp244_;
			vala_report_error (_tmp245_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp247_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp248_ = _tmp247_;
	if (_tmp248_ == NULL) {
		ValaList* _tmp249_;
		gint _tmp250_;
		gint _tmp251_;
		_tmp249_ = self->priv->argument_list;
		_tmp250_ = vala_collection_get_size ((ValaCollection*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp246_ = _tmp251_ != 0;
	} else {
		_tmp246_ = FALSE;
	}
	if (_tmp246_) {
		ValaSourceReference* _tmp252_;
		ValaSourceReference* _tmp253_;
		ValaTypeSymbol* _tmp254_;
		gchar* _tmp255_;
		gchar* _tmp256_;
		gchar* _tmp257_;
		gchar* _tmp258_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp252_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp253_ = _tmp252_;
		_tmp254_ = type;
		_tmp255_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp254_);
		_tmp256_ = _tmp255_;
		_tmp257_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp256_);
		_tmp258_ = _tmp257_;
		vala_report_error (_tmp253_, _tmp258_);
		_g_free0 (_tmp258_);
		_g_free0 (_tmp256_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp260_ = _tmp259_;
	if (VALA_IS_METHOD (_tmp260_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp261_;
		ValaSymbol* _tmp262_;
		ValaMethod* _tmp263_;
		gboolean _tmp264_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp283_;
		ValaIterator* _tmp284_;
		ValaMethod* _tmp314_;
		gboolean _tmp315_;
		gboolean _tmp316_;
		ValaSemanticAnalyzer* _tmp373_;
		ValaSemanticAnalyzer* _tmp374_;
		ValaMethod* _tmp375_;
		ValaMethodType* _tmp376_;
		ValaMethodType* _tmp377_;
		ValaMethod* _tmp378_;
		ValaList* _tmp379_;
		ValaList* _tmp380_;
		_tmp261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp262_ = _tmp261_;
		_tmp263_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp262_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp263_;
		_tmp264_ = self->priv->_is_yield_expression;
		if (_tmp264_) {
			ValaMethod* _tmp265_;
			gboolean _tmp266_;
			gboolean _tmp267_;
			gboolean _tmp270_ = FALSE;
			ValaSemanticAnalyzer* _tmp271_;
			ValaSemanticAnalyzer* _tmp272_;
			ValaMethod* _tmp273_;
			ValaMethod* _tmp274_;
			_tmp265_ = m;
			_tmp266_ = vala_method_get_coroutine (_tmp265_);
			_tmp267_ = _tmp266_;
			if (!_tmp267_) {
				ValaSourceReference* _tmp268_;
				ValaSourceReference* _tmp269_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp269_ = _tmp268_;
				vala_report_error (_tmp269_, "yield expression requires async method");
			}
			_tmp271_ = vala_code_context_get_analyzer (context);
			_tmp272_ = _tmp271_;
			_tmp273_ = vala_semantic_analyzer_get_current_method (_tmp272_);
			_tmp274_ = _tmp273_;
			if (_tmp274_ == NULL) {
				_tmp270_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp275_;
				ValaSemanticAnalyzer* _tmp276_;
				ValaMethod* _tmp277_;
				ValaMethod* _tmp278_;
				gboolean _tmp279_;
				gboolean _tmp280_;
				_tmp275_ = vala_code_context_get_analyzer (context);
				_tmp276_ = _tmp275_;
				_tmp277_ = vala_semantic_analyzer_get_current_method (_tmp276_);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_method_get_coroutine (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp270_ = !_tmp280_;
			}
			if (_tmp270_) {
				ValaSourceReference* _tmp281_;
				ValaSourceReference* _tmp282_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp281_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp282_ = _tmp281_;
				vala_report_error (_tmp282_, "yield expression not available outside async method");
			}
		}
		last_arg = NULL;
		_tmp283_ = self->priv->argument_list;
		_tmp284_ = vala_iterable_iterator ((ValaIterable*) _tmp283_);
		arg_it = _tmp284_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp285_;
			ValaList* _tmp286_;
			ValaList* _tmp287_;
			gint _param_size = 0;
			ValaList* _tmp288_;
			gint _tmp289_;
			gint _tmp290_;
			gint _param_index = 0;
			_tmp285_ = m;
			_tmp286_ = vala_callable_get_parameters ((ValaCallable*) _tmp285_);
			_tmp287_ = _vala_iterable_ref0 (_tmp286_);
			_param_list = _tmp287_;
			_tmp288_ = _param_list;
			_tmp289_ = vala_collection_get_size ((ValaCollection*) _tmp288_);
			_tmp290_ = _tmp289_;
			_param_size = _tmp290_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp291_;
				gpointer _tmp292_;
				ValaParameter* _tmp293_;
				ValaParameter* _tmp294_;
				gboolean _tmp295_;
				gboolean _tmp296_;
				ValaIterator* _tmp297_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp291_ = _param_list;
				_tmp292_ = vala_list_get (_tmp291_, _param_index);
				param = (ValaParameter*) _tmp292_;
				_tmp293_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp293_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp294_ = param;
				_tmp295_ = vala_parameter_get_ellipsis (_tmp294_);
				_tmp296_ = _tmp295_;
				if (_tmp296_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp297_ = arg_it;
				if (vala_iterator_next (_tmp297_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp298_;
					gpointer _tmp299_;
					ValaExpression* _tmp300_;
					ValaParameter* _tmp301_;
					ValaDataType* _tmp302_;
					ValaDataType* _tmp303_;
					ValaExpression* _tmp304_;
					ValaExpression* _tmp305_;
					ValaDataType* _tmp306_;
					ValaDataType* _tmp307_;
					ValaDataType* _tmp308_;
					ValaDataType* _tmp309_;
					ValaDataType* _tmp310_;
					ValaDataType* _tmp311_;
					ValaExpression* _tmp312_;
					ValaExpression* _tmp313_;
					_tmp298_ = arg_it;
					_tmp299_ = vala_iterator_get (_tmp298_);
					arg = (ValaExpression*) _tmp299_;
					_tmp300_ = arg;
					_tmp301_ = param;
					_tmp302_ = vala_variable_get_variable_type ((ValaVariable*) _tmp301_);
					_tmp303_ = _tmp302_;
					vala_expression_set_formal_target_type (_tmp300_, _tmp303_);
					_tmp304_ = arg;
					_tmp305_ = arg;
					_tmp306_ = vala_expression_get_formal_target_type (_tmp305_);
					_tmp307_ = _tmp306_;
					_tmp308_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp309_ = _tmp308_;
					_tmp310_ = vala_data_type_get_actual_type (_tmp307_, _tmp309_, NULL, (ValaCodeNode*) self);
					_tmp311_ = _tmp310_;
					vala_expression_set_target_type (_tmp304_, _tmp311_);
					_vala_code_node_unref0 (_tmp311_);
					_tmp312_ = arg;
					_tmp313_ = _vala_code_node_ref0 (_tmp312_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp313_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp314_ = m;
		_tmp315_ = vala_method_get_printf_format (_tmp314_);
		_tmp316_ = _tmp315_;
		if (_tmp316_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp317_;
			ValaStringLiteral* _tmp356_;
			format_literal = NULL;
			_tmp317_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp317_)) {
			} else {
				ValaExpression* _tmp318_;
				_tmp318_ = last_arg;
				if (_tmp318_ != NULL) {
					ValaExpression* _tmp319_;
					ValaStringLiteral* _tmp320_;
					gboolean _tmp321_ = FALSE;
					ValaStringLiteral* _tmp322_;
					_tmp319_ = last_arg;
					_tmp320_ = vala_string_literal_get_format_literal (_tmp319_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp320_;
					_tmp322_ = format_literal;
					if (_tmp322_ == NULL) {
						ValaList* _tmp323_;
						gint _tmp324_;
						gint _tmp325_;
						ValaMethod* _tmp326_;
						ValaList* _tmp327_;
						gint _tmp328_;
						gint _tmp329_;
						_tmp323_ = self->priv->argument_list;
						_tmp324_ = vala_collection_get_size ((ValaCollection*) _tmp323_);
						_tmp325_ = _tmp324_;
						_tmp326_ = m;
						_tmp327_ = vala_callable_get_parameters ((ValaCallable*) _tmp326_);
						_tmp328_ = vala_collection_get_size ((ValaCollection*) _tmp327_);
						_tmp329_ = _tmp328_;
						_tmp321_ = _tmp325_ == (_tmp329_ - 1);
					} else {
						_tmp321_ = FALSE;
					}
					if (_tmp321_) {
						ValaStringLiteral* _tmp330_;
						ValaStringLiteral* _tmp331_;
						ValaSemanticAnalyzer* _tmp332_;
						ValaSemanticAnalyzer* _tmp333_;
						ValaDataType* _tmp334_;
						ValaDataType* _tmp335_;
						ValaDataType* _tmp336_;
						ValaList* _tmp337_;
						ValaList* _tmp338_;
						gint _tmp339_;
						gint _tmp340_;
						ValaStringLiteral* _tmp341_;
						ValaList* _tmp342_;
						ValaIterator* _tmp343_;
						_tmp330_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp330_;
						_tmp331_ = format_literal;
						_tmp332_ = vala_code_context_get_analyzer (context);
						_tmp333_ = _tmp332_;
						_tmp334_ = _tmp333_->string_type;
						_tmp335_ = vala_data_type_copy (_tmp334_);
						_tmp336_ = _tmp335_;
						vala_expression_set_target_type ((ValaExpression*) _tmp331_, _tmp336_);
						_vala_code_node_unref0 (_tmp336_);
						_tmp337_ = self->priv->argument_list;
						_tmp338_ = self->priv->argument_list;
						_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
						_tmp340_ = _tmp339_;
						_tmp341_ = format_literal;
						vala_list_insert (_tmp337_, _tmp340_ - 1, (ValaExpression*) _tmp341_);
						_tmp342_ = self->priv->argument_list;
						_tmp343_ = vala_iterable_iterator ((ValaIterable*) _tmp342_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp343_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp344_;
							ValaList* _tmp345_;
							ValaList* _tmp346_;
							gint _param_size = 0;
							ValaList* _tmp347_;
							gint _tmp348_;
							gint _tmp349_;
							gint _param_index = 0;
							_tmp344_ = m;
							_tmp345_ = vala_callable_get_parameters ((ValaCallable*) _tmp344_);
							_tmp346_ = _vala_iterable_ref0 (_tmp345_);
							_param_list = _tmp346_;
							_tmp347_ = _param_list;
							_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
							_tmp349_ = _tmp348_;
							_param_size = _tmp349_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp350_;
								gpointer _tmp351_;
								ValaParameter* _tmp352_;
								gboolean _tmp353_;
								gboolean _tmp354_;
								ValaIterator* _tmp355_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp350_ = _param_list;
								_tmp351_ = vala_list_get (_tmp350_, _param_index);
								param = (ValaParameter*) _tmp351_;
								_tmp352_ = param;
								_tmp353_ = vala_parameter_get_ellipsis (_tmp352_);
								_tmp354_ = _tmp353_;
								if (_tmp354_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp355_ = arg_it;
								vala_iterator_next (_tmp355_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp356_ = format_literal;
			if (_tmp356_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp357_;
				gchar* _tmp358_;
				ValaSemanticAnalyzer* _tmp359_;
				ValaSemanticAnalyzer* _tmp360_;
				const gchar* _tmp361_;
				ValaIterator* _tmp362_;
				ValaSourceReference* _tmp363_;
				ValaSourceReference* _tmp364_;
				_tmp357_ = format_literal;
				_tmp358_ = vala_string_literal_eval (_tmp357_);
				format = _tmp358_;
				_tmp359_ = vala_code_context_get_analyzer (context);
				_tmp360_ = _tmp359_;
				_tmp361_ = format;
				_tmp362_ = arg_it;
				_tmp363_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp364_ = _tmp363_;
				if (!vala_semantic_analyzer_check_print_format (_tmp360_, _tmp361_, _tmp362_, _tmp364_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp365_;
			ValaList* _tmp366_;
			gint _arg_size = 0;
			ValaList* _tmp367_;
			gint _tmp368_;
			gint _tmp369_;
			gint _arg_index = 0;
			_tmp365_ = self->priv->argument_list;
			_tmp366_ = _vala_iterable_ref0 (_tmp365_);
			_arg_list = _tmp366_;
			_tmp367_ = _arg_list;
			_tmp368_ = vala_collection_get_size ((ValaCollection*) _tmp367_);
			_tmp369_ = _tmp368_;
			_arg_size = _tmp369_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp370_;
				gpointer _tmp371_;
				ValaExpression* _tmp372_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp370_ = _arg_list;
				_tmp371_ = vala_list_get (_tmp370_, _arg_index);
				arg = (ValaExpression*) _tmp371_;
				_tmp372_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp372_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp373_ = vala_code_context_get_analyzer (context);
		_tmp374_ = _tmp373_;
		_tmp375_ = m;
		_tmp376_ = vala_method_type_new (_tmp375_);
		_tmp377_ = _tmp376_;
		_tmp378_ = m;
		_tmp379_ = vala_callable_get_parameters ((ValaCallable*) _tmp378_);
		_tmp380_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp374_, (ValaExpression*) self, (ValaDataType*) _tmp377_, _tmp379_, _tmp380_);
		_vala_code_node_unref0 (_tmp377_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp381_;
		ValaDataType* _tmp382_;
		_tmp381_ = vala_object_creation_expression_get_type_reference (self);
		_tmp382_ = _tmp381_;
		if (VALA_IS_ERROR_TYPE (_tmp382_)) {
			ValaDataType* _tmp383_;
			ValaDataType* _tmp384_;
			ValaMemberAccess* _tmp387_;
			ValaMemberAccess* _tmp388_;
			ValaList* _tmp407_;
			gint _tmp408_;
			gint _tmp409_;
			_tmp383_ = vala_object_creation_expression_get_type_reference (self);
			_tmp384_ = _tmp383_;
			if (_tmp384_ != NULL) {
				ValaDataType* _tmp385_;
				ValaDataType* _tmp386_;
				_tmp385_ = vala_object_creation_expression_get_type_reference (self);
				_tmp386_ = _tmp385_;
				vala_code_node_check ((ValaCodeNode*) _tmp386_, context);
			}
			_tmp387_ = vala_object_creation_expression_get_member_name (self);
			_tmp388_ = _tmp387_;
			if (_tmp388_ != NULL) {
				ValaMemberAccess* _tmp389_;
				ValaMemberAccess* _tmp390_;
				_tmp389_ = vala_object_creation_expression_get_member_name (self);
				_tmp390_ = _tmp389_;
				vala_code_node_check ((ValaCodeNode*) _tmp390_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp391_;
				ValaList* _tmp392_;
				gint _arg_size = 0;
				ValaList* _tmp393_;
				gint _tmp394_;
				gint _tmp395_;
				gint _arg_index = 0;
				_tmp391_ = self->priv->argument_list;
				_tmp392_ = _vala_iterable_ref0 (_tmp391_);
				_arg_list = _tmp392_;
				_tmp393_ = _arg_list;
				_tmp394_ = vala_collection_get_size ((ValaCollection*) _tmp393_);
				_tmp395_ = _tmp394_;
				_arg_size = _tmp395_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp396_;
					gpointer _tmp397_;
					ValaExpression* _tmp398_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp396_ = _arg_list;
					_tmp397_ = vala_list_get (_tmp396_, _arg_index);
					arg = (ValaExpression*) _tmp397_;
					_tmp398_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp398_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp399_;
				ValaList* _tmp400_;
				gint _init_size = 0;
				ValaList* _tmp401_;
				gint _tmp402_;
				gint _tmp403_;
				gint _init_index = 0;
				_tmp399_ = self->priv->object_initializer;
				_tmp400_ = _vala_iterable_ref0 (_tmp399_);
				_init_list = _tmp400_;
				_tmp401_ = _init_list;
				_tmp402_ = vala_collection_get_size ((ValaCollection*) _tmp401_);
				_tmp403_ = _tmp402_;
				_init_size = _tmp403_;
				_init_index = -1;
				while (TRUE) {
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp404_;
					gpointer _tmp405_;
					ValaMemberInitializer* _tmp406_;
					_init_index = _init_index + 1;
					if (!(_init_index < _init_size)) {
						break;
					}
					_tmp404_ = _init_list;
					_tmp405_ = vala_list_get (_tmp404_, _init_index);
					init = (ValaMemberInitializer*) _tmp405_;
					_tmp406_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp406_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp407_ = self->priv->argument_list;
			_tmp408_ = vala_collection_get_size ((ValaCollection*) _tmp407_);
			_tmp409_ = _tmp408_;
			if (_tmp409_ == 0) {
				ValaSourceReference* _tmp410_;
				ValaSourceReference* _tmp411_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp410_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp411_ = _tmp410_;
				vala_report_error (_tmp411_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp412_;
				ValaIterator* _tmp413_;
				ValaIterator* _tmp414_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp415_;
				gpointer _tmp416_;
				gboolean _tmp417_ = FALSE;
				ValaExpression* _tmp418_;
				ValaDataType* _tmp419_;
				ValaDataType* _tmp420_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp429_;
				ValaStringLiteral* _tmp430_;
				ValaStringLiteral* _tmp431_;
				ValaList* _tmp440_;
				ValaIterator* _tmp441_;
				ValaIterator* _tmp442_;
				ValaSemanticAnalyzer* _tmp443_;
				ValaSemanticAnalyzer* _tmp444_;
				ValaIterator* _tmp445_;
				ValaSourceReference* _tmp446_;
				ValaSourceReference* _tmp447_;
				_tmp412_ = self->priv->argument_list;
				_tmp413_ = vala_iterable_iterator ((ValaIterable*) _tmp412_);
				arg_it = _tmp413_;
				_tmp414_ = arg_it;
				vala_iterator_next (_tmp414_);
				_tmp415_ = arg_it;
				_tmp416_ = vala_iterator_get (_tmp415_);
				ex = (ValaExpression*) _tmp416_;
				_tmp418_ = ex;
				_tmp419_ = vala_expression_get_value_type (_tmp418_);
				_tmp420_ = _tmp419_;
				if (_tmp420_ == NULL) {
					_tmp417_ = TRUE;
				} else {
					ValaExpression* _tmp421_;
					ValaDataType* _tmp422_;
					ValaDataType* _tmp423_;
					ValaSemanticAnalyzer* _tmp424_;
					ValaSemanticAnalyzer* _tmp425_;
					ValaDataType* _tmp426_;
					_tmp421_ = ex;
					_tmp422_ = vala_expression_get_value_type (_tmp421_);
					_tmp423_ = _tmp422_;
					_tmp424_ = vala_code_context_get_analyzer (context);
					_tmp425_ = _tmp424_;
					_tmp426_ = _tmp425_->string_type;
					_tmp417_ = !vala_data_type_compatible (_tmp423_, _tmp426_);
				}
				if (_tmp417_) {
					ValaSourceReference* _tmp427_;
					ValaSourceReference* _tmp428_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp427_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp428_ = _tmp427_;
					vala_report_error (_tmp428_, "Invalid type for argument 1");
				}
				_tmp429_ = ex;
				_tmp430_ = vala_string_literal_get_format_literal (_tmp429_);
				format_literal = _tmp430_;
				_tmp431_ = format_literal;
				if (_tmp431_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp432_;
					gchar* _tmp433_;
					ValaSemanticAnalyzer* _tmp434_;
					ValaSemanticAnalyzer* _tmp435_;
					const gchar* _tmp436_;
					ValaIterator* _tmp437_;
					ValaSourceReference* _tmp438_;
					ValaSourceReference* _tmp439_;
					_tmp432_ = format_literal;
					_tmp433_ = vala_string_literal_eval (_tmp432_);
					format = _tmp433_;
					_tmp434_ = vala_code_context_get_analyzer (context);
					_tmp435_ = _tmp434_;
					_tmp436_ = format;
					_tmp437_ = arg_it;
					_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp439_ = _tmp438_;
					if (!vala_semantic_analyzer_check_print_format (_tmp435_, _tmp436_, _tmp437_, _tmp439_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp440_ = self->priv->argument_list;
				_tmp441_ = vala_iterable_iterator ((ValaIterable*) _tmp440_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp441_;
				_tmp442_ = arg_it;
				vala_iterator_next (_tmp442_);
				_tmp443_ = vala_code_context_get_analyzer (context);
				_tmp444_ = _tmp443_;
				_tmp445_ = arg_it;
				_tmp446_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp447_ = _tmp446_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp444_, _tmp445_, 1, _tmp447_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp448_;
		ValaList* _tmp449_;
		gint _arg_size = 0;
		ValaList* _tmp450_;
		gint _tmp451_;
		gint _tmp452_;
		gint _arg_index = 0;
		_tmp448_ = self->priv->argument_list;
		_tmp449_ = _vala_iterable_ref0 (_tmp448_);
		_arg_list = _tmp449_;
		_tmp450_ = _arg_list;
		_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
		_tmp452_ = _tmp451_;
		_arg_size = _tmp452_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp453_;
			gpointer _tmp454_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp455_;
			gboolean _tmp456_ = FALSE;
			ValaSizeofExpression* _tmp457_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp453_ = _arg_list;
			_tmp454_ = vala_list_get (_tmp453_, _arg_index);
			arg = (ValaExpression*) _tmp454_;
			_tmp455_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp455_) ? ((ValaSizeofExpression*) _tmp455_) : NULL;
			_tmp457_ = sizeof_expr;
			if (_tmp457_ != NULL) {
				ValaSizeofExpression* _tmp458_;
				ValaDataType* _tmp459_;
				ValaDataType* _tmp460_;
				_tmp458_ = sizeof_expr;
				_tmp459_ = vala_sizeof_expression_get_type_reference (_tmp458_);
				_tmp460_ = _tmp459_;
				_tmp456_ = VALA_IS_GENERIC_TYPE (_tmp460_);
			} else {
				_tmp456_ = FALSE;
			}
			if (_tmp456_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp461_;
				ValaDataType* _tmp462_;
				ValaDataType* _tmp463_;
				ValaDataType* _tmp464_;
				ValaDataType* _tmp465_;
				ValaDataType* _tmp466_;
				ValaDataType* _tmp467_;
				ValaList* _tmp468_;
				ValaDataType* _tmp469_;
				ValaExpression* _tmp470_;
				ValaDataType* _tmp471_;
				ValaSourceReference* _tmp472_;
				ValaSourceReference* _tmp473_;
				ValaSizeofExpression* _tmp474_;
				ValaSizeofExpression* _tmp475_;
				_tmp461_ = sizeof_expr;
				_tmp462_ = vala_sizeof_expression_get_type_reference (_tmp461_);
				_tmp463_ = _tmp462_;
				_tmp464_ = vala_object_creation_expression_get_type_reference (self);
				_tmp465_ = _tmp464_;
				_tmp466_ = vala_object_creation_expression_get_type_reference (self);
				_tmp467_ = _tmp466_;
				_tmp468_ = vala_data_type_get_type_arguments (_tmp467_);
				_tmp469_ = vala_data_type_get_actual_type (_tmp463_, _tmp465_, _tmp468_, (ValaCodeNode*) self);
				sizeof_type = _tmp469_;
				_tmp470_ = arg;
				_tmp471_ = sizeof_type;
				_tmp472_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp473_ = _tmp472_;
				_tmp474_ = vala_sizeof_expression_new (_tmp471_, _tmp473_);
				_tmp475_ = _tmp474_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp470_, (ValaExpression*) _tmp475_);
				_vala_code_node_unref0 (_tmp475_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp476_ = type;
	_tmp477_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp476_);
	_tmp478_ = _tmp477_;
	if (!_tmp478_) {
		ValaSemanticAnalyzer* _tmp479_;
		ValaSemanticAnalyzer* _tmp480_;
		ValaDataType* _tmp481_;
		ValaDataType* _tmp482_;
		_tmp479_ = vala_code_context_get_analyzer (context);
		_tmp480_ = _tmp479_;
		_tmp481_ = vala_object_creation_expression_get_type_reference (self);
		_tmp482_ = _tmp481_;
		vala_semantic_analyzer_check_type (_tmp480_, _tmp482_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp483_;
		ValaList* _tmp484_;
		gint _init_size = 0;
		ValaList* _tmp485_;
		gint _tmp486_;
		gint _tmp487_;
		gint _init_index = 0;
		_tmp483_ = vala_object_creation_expression_get_object_initializer (self);
		_tmp484_ = _vala_iterable_ref0 (_tmp483_);
		_init_list = _tmp484_;
		_tmp485_ = _init_list;
		_tmp486_ = vala_collection_get_size ((ValaCollection*) _tmp485_);
		_tmp487_ = _tmp486_;
		_init_size = _tmp487_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp488_;
			gpointer _tmp489_;
			ValaSemanticAnalyzer* _tmp490_;
			ValaSemanticAnalyzer* _tmp491_;
			ValaMemberInitializer* _tmp492_;
			ValaDataType* _tmp493_;
			ValaDataType* _tmp494_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp488_ = _init_list;
			_tmp489_ = vala_list_get (_tmp488_, _init_index);
			init = (ValaMemberInitializer*) _tmp489_;
			_tmp490_ = vala_code_context_get_analyzer (context);
			_tmp491_ = _tmp490_;
			_tmp492_ = init;
			_tmp493_ = vala_object_creation_expression_get_type_reference (self);
			_tmp494_ = _tmp493_;
			vala_semantic_analyzer_visit_member_initializer (_tmp491_, _tmp492_, _tmp494_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp495_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp496_ = _tmp495_;
	if (_tmp496_) {
		gboolean _tmp497_ = FALSE;
		ValaCodeNode* _tmp498_;
		ValaCodeNode* _tmp499_;
		_tmp498_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp499_ = _tmp498_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp499_)) {
			_tmp497_ = TRUE;
		} else {
			ValaCodeNode* _tmp500_;
			ValaCodeNode* _tmp501_;
			_tmp500_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp501_ = _tmp500_;
			_tmp497_ = VALA_IS_EXPRESSION_STATEMENT (_tmp501_);
		}
		if (_tmp497_) {
		} else {
			ValaSemanticAnalyzer* _tmp502_;
			ValaSemanticAnalyzer* _tmp503_;
			ValaSymbol* _tmp504_;
			ValaSymbol* _tmp505_;
			_tmp502_ = vala_code_context_get_analyzer (context);
			_tmp503_ = _tmp502_;
			_tmp504_ = vala_semantic_analyzer_get_current_symbol (_tmp503_);
			_tmp505_ = _tmp504_;
			if (!VALA_IS_BLOCK (_tmp505_)) {
				ValaSourceReference* _tmp506_;
				ValaSourceReference* _tmp507_;
				_tmp506_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp507_ = _tmp506_;
				vala_report_error (_tmp507_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp508_;
				ValaCodeNode* _tmp509_;
				ValaCodeNode* _tmp510_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp511_;
				ValaDataType* _tmp512_;
				ValaDataType* _tmp513_;
				ValaDataType* _tmp514_;
				gchar* _tmp515_;
				gchar* _tmp516_;
				ValaSourceReference* _tmp517_;
				ValaSourceReference* _tmp518_;
				ValaLocalVariable* _tmp519_;
				ValaLocalVariable* _tmp520_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp521_;
				ValaSourceReference* _tmp522_;
				ValaSourceReference* _tmp523_;
				ValaDeclarationStatement* _tmp524_;
				ValaSemanticAnalyzer* _tmp525_;
				ValaSemanticAnalyzer* _tmp526_;
				ValaBlock* _tmp527_;
				ValaDeclarationStatement* _tmp528_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp529_;
				ValaDataType* _tmp530_;
				ValaDataType* _tmp531_;
				ValaExpression* _tmp532_;
				ValaLocalVariable* _tmp533_;
				ValaDeclarationStatement* _tmp534_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp535_;
				ValaSemanticAnalyzer* _tmp536_;
				ValaSymbol* _tmp537_;
				ValaSymbol* _tmp538_;
				ValaBlock* _tmp539_;
				ValaBlock* _tmp540_;
				ValaLocalVariable* _tmp541_;
				ValaSemanticAnalyzer* _tmp542_;
				ValaSemanticAnalyzer* _tmp543_;
				ValaBlock* _tmp544_;
				ValaLocalVariable* _tmp545_;
				ValaCodeNode* _tmp546_;
				ValaExpression* _tmp547_;
				ValaExpression* _tmp548_;
				_tmp508_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp509_ = _tmp508_;
				_tmp510_ = _vala_code_node_ref0 (_tmp509_);
				old_parent_node = _tmp510_;
				_tmp511_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp512_ = _tmp511_;
				_tmp513_ = vala_data_type_copy (_tmp512_);
				_tmp514_ = _tmp513_;
				_tmp515_ = vala_code_node_get_temp_name ();
				_tmp516_ = _tmp515_;
				_tmp517_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp518_ = _tmp517_;
				_tmp519_ = vala_local_variable_new (_tmp514_, _tmp516_, NULL, _tmp518_);
				_tmp520_ = _tmp519_;
				_g_free0 (_tmp516_);
				_vala_code_node_unref0 (_tmp514_);
				local = _tmp520_;
				_tmp521_ = local;
				_tmp522_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp523_ = _tmp522_;
				_tmp524_ = vala_declaration_statement_new ((ValaSymbol*) _tmp521_, _tmp523_);
				decl = _tmp524_;
				_tmp525_ = vala_code_context_get_analyzer (context);
				_tmp526_ = _tmp525_;
				_tmp527_ = _tmp526_->insert_block;
				_tmp528_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp527_, (ValaStatement*) _tmp528_);
				_tmp529_ = local;
				_tmp530_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp531_ = _tmp530_;
				_tmp532_ = vala_semantic_analyzer_create_temp_access (_tmp529_, _tmp531_);
				temp_access = _tmp532_;
				_tmp533_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp533_, (ValaExpression*) self);
				_tmp534_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp534_, context);
				_tmp535_ = vala_code_context_get_analyzer (context);
				_tmp536_ = _tmp535_;
				_tmp537_ = vala_semantic_analyzer_get_current_symbol (_tmp536_);
				_tmp538_ = _tmp537_;
				_tmp539_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp538_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp539_;
				_tmp540_ = block;
				_tmp541_ = local;
				vala_block_remove_local_variable (_tmp540_, _tmp541_);
				_tmp542_ = vala_code_context_get_analyzer (context);
				_tmp543_ = _tmp542_;
				_tmp544_ = _tmp543_->insert_block;
				_tmp545_ = local;
				vala_block_add_local_variable (_tmp544_, _tmp545_);
				_tmp546_ = old_parent_node;
				_tmp547_ = temp_access;
				vala_code_node_replace_expression (_tmp546_, (ValaExpression*) self, _tmp547_);
				_tmp548_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp548_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp549_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp550_ = _tmp549_;
	result = !_tmp550_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp8_ = self->priv->object_initializer;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaMemberInitializer* _tmp15_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp13_ = _init_list;
			_tmp14_ = vala_list_get (_tmp13_, _init_index);
			init = (ValaMemberInitializer*) _tmp14_;
			_tmp15_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp15_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp8_ = self->priv->object_initializer;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaMemberInitializer* _tmp15_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp13_ = _init_list;
			_tmp14_ = vala_list_get (_tmp13_, _init_index);
			init = (ValaMemberInitializer*) _tmp14_;
			_tmp15_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}

