/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaList* _tmp16_;
	ValaDataType* _tmp17_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp167_;
	GEqualFunc _tmp168_;
	GEqualFunc _tmp169_;
	ValaHashMap* _tmp170_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp171_;
	ValaHashMap* _tmp172_;
	gboolean _tmp173_ = FALSE;
	ValaMethod* _tmp174_;
	gboolean _tmp291_ = FALSE;
	ValaMethod* _tmp292_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp456_;
	ValaCCodeExpression* _tmp457_;
	gboolean _tmp458_ = FALSE;
	ValaMethod* _tmp459_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp487_ = FALSE;
	ValaMethod* _tmp488_;
	gboolean _tmp642_ = FALSE;
	ValaMethod* _tmp643_;
	ValaMethod* _tmp693_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp878_;
	ValaIterator* _tmp879_;
	ValaIterator* _tmp1298_;
	gboolean _tmp1308_ = FALSE;
	gboolean _tmp1309_ = FALSE;
	ValaMethod* _tmp1310_;
	gboolean _tmp1430_ = FALSE;
	ValaDelegate* _tmp1431_;
	gboolean _tmp1526_ = FALSE;
	ValaMethod* _tmp1527_;
	gboolean _tmp1543_;
	gboolean _tmp1544_;
	ValaDataType* _tmp1587_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1611_;
	ValaDataType* _tmp1612_;
	gboolean _tmp1613_ = FALSE;
	ValaDataType* _tmp1614_;
	ValaCCodeFunctionCall* _tmp1642_;
	ValaCCodeFunctionCall* _tmp1643_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1656_;
	ValaCCodeFunctionCall* _tmp1657_;
	ValaCCodeFunctionCall* _tmp1672_;
	gboolean _tmp1687_;
	gboolean _tmp1688_;
	gboolean _tmp1712_;
	gboolean _tmp1713_;
	gboolean _tmp1748_ = FALSE;
	gboolean _tmp1749_ = FALSE;
	ValaMethod* _tmp1750_;
	gboolean _tmp1788_ = FALSE;
	gboolean _tmp1789_ = FALSE;
	gboolean _tmp1790_ = FALSE;
	gboolean _tmp1791_ = FALSE;
	gboolean _tmp1792_ = FALSE;
	ValaMethod* _tmp1793_;
	gboolean _tmp1810_ = FALSE;
	gboolean _tmp1811_ = FALSE;
	ValaMethod* _tmp1812_;
	ValaMethod* _tmp1831_;
	gboolean _tmp1946_ = FALSE;
	ValaCodeNode* _tmp1947_;
	ValaCodeNode* _tmp1948_;
	ValaList* _tmp2048_;
	ValaIterator* _tmp2049_;
	gboolean _tmp2124_ = FALSE;
	gboolean _tmp2125_ = FALSE;
	ValaMethod* _tmp2126_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_tmp16_ = _vala_iterable_ref0 (_tmp15_);
	_vala_iterable_unref0 (params);
	params = _tmp16_;
	_tmp17_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp18_;
		ValaDataType* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		ValaMethod* _tmp23_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ValaMemberAccess* _tmp31_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		_tmp18_ = ma;
		_vala_assert (_tmp18_ != NULL, "ma != null");
		_tmp19_ = itype;
		_tmp20_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		_vala_code_node_unref0 (m);
		m = _tmp22_;
		_tmp23_ = m;
		if (!vala_get_ccode_simple_generics (_tmp23_)) {
			ValaCodeContext* _tmp24_;
			ValaCodeContext* _tmp25_;
			ValaSemanticAnalyzer* _tmp26_;
			ValaSemanticAnalyzer* _tmp27_;
			ValaMemberAccess* _tmp28_;
			_tmp24_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp27_, _tmp28_);
		}
		_tmp31_ = ma;
		_tmp32_ = vala_member_access_get_inner (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp33_ != NULL) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp30_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValaMemberAccess* _tmp39_;
			ValaExpression* _tmp40_;
			ValaExpression* _tmp41_;
			ValaDataType* _tmp42_;
			ValaDataType* _tmp43_;
			ValaMethod* _tmp44_;
			ValaMethod* _tmp45_;
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_inner (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_expression_get_value_type (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp45_ = m;
			_tmp29_ = _tmp44_ == _tmp45_;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp46_;
			ValaExpression* _tmp47_;
			ValaExpression* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			ValaTypeSymbol* _tmp51_;
			ValaTypeSymbol* _tmp52_;
			ValaCCodeFunctionCall* _tmp53_;
			ValaEnum* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			ValaCCodeIdentifier* _tmp57_;
			ValaCCodeIdentifier* _tmp58_;
			_tmp46_ = ma;
			_tmp47_ = vala_member_access_get_inner (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_expression_get_value_type (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
			_tmp52_ = _tmp51_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_ENUM, ValaEnum);
			_tmp53_ = ccall;
			_tmp54_ = en;
			_tmp55_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_ccode_identifier_new (_tmp56_);
			_tmp58_ = _tmp57_;
			vala_ccode_function_call_set_call (_tmp53_, (ValaCCodeExpression*) _tmp58_);
			_vala_ccode_node_unref0 (_tmp58_);
			_g_free0 (_tmp56_);
		} else {
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			gboolean _tmp61_ = FALSE;
			gboolean _tmp62_ = FALSE;
			ValaCodeContext* _tmp63_;
			ValaCodeContext* _tmp64_;
			ValaProfile _tmp65_;
			ValaProfile _tmp66_;
			_tmp63_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_code_context_get_profile (_tmp64_);
			_tmp66_ = _tmp65_;
			if (_tmp66_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp62_ = _tmp69_ != NULL;
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				ValaDataType* _tmp73_;
				ValaDataType* _tmp74_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_expression_get_value_type (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp61_ = _tmp74_ != NULL;
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValaMemberAccess* _tmp75_;
				ValaExpression* _tmp76_;
				ValaExpression* _tmp77_;
				ValaDataType* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaDataType* _tmp82_;
				ValaTypeSymbol* _tmp83_;
				ValaTypeSymbol* _tmp84_;
				_tmp75_ = ma;
				_tmp76_ = vala_member_access_get_inner (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_get_value_type (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = vala_data_type_get_type_symbol (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp83_ = vala_data_type_get_type_symbol (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp60_ = _tmp81_ == _tmp84_;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp85_;
				const gchar* _tmp86_;
				const gchar* _tmp87_;
				_tmp85_ = ma;
				_tmp86_ = vala_member_access_get_member_name (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp59_ = g_strcmp0 (_tmp87_, "printf") == 0;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaCCodeFunctionCall* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				ValaCCodeIdentifier* _tmp91_;
				ValaCCodeIdentifier* _tmp92_;
				_tmp88_ = ccall;
				_tmp89_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_ccode_identifier_new (_tmp90_);
				_tmp92_ = _tmp91_;
				vala_ccode_function_call_set_call (_tmp88_, (ValaCCodeExpression*) _tmp92_);
				_vala_ccode_node_unref0 (_tmp92_);
				_g_free0 (_tmp90_);
			} else {
				gboolean _tmp93_;
				gboolean _tmp94_;
				_tmp93_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp94_ = _tmp93_;
				if (_tmp94_) {
					ValaCCodeFunctionCall* _tmp95_;
					ValaMethod* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					ValaCCodeIdentifier* _tmp99_;
					ValaCCodeIdentifier* _tmp100_;
					_tmp95_ = ccall;
					_tmp96_ = m;
					_tmp97_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp98_ = _tmp97_;
					_tmp99_ = vala_ccode_identifier_new (_tmp98_);
					_tmp100_ = _tmp99_;
					vala_ccode_function_call_set_call (_tmp95_, (ValaCCodeExpression*) _tmp100_);
					_vala_ccode_node_unref0 (_tmp100_);
					_g_free0 (_tmp98_);
				}
			}
		}
	} else {
		ValaDataType* _tmp101_;
		_tmp101_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp102_;
			ValaSignalType* _tmp103_;
			gboolean _tmp104_ = FALSE;
			gboolean _tmp105_ = FALSE;
			ValaMemberAccess* _tmp106_;
			_tmp102_ = itype;
			_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp103_;
			_tmp106_ = ma;
			if (_tmp106_ != NULL) {
				ValaMemberAccess* _tmp107_;
				ValaExpression* _tmp108_;
				ValaExpression* _tmp109_;
				_tmp107_ = ma;
				_tmp108_ = vala_member_access_get_inner (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp105_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp105_ = FALSE;
			}
			if (_tmp105_) {
				ValaSignalType* _tmp110_;
				ValaSignal* _tmp111_;
				ValaSignal* _tmp112_;
				gboolean _tmp113_;
				gboolean _tmp114_;
				_tmp110_ = sig_type;
				_tmp111_ = vala_signal_type_get_signal_symbol (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = vala_signal_get_is_virtual (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp104_ = _tmp114_;
			} else {
				_tmp104_ = FALSE;
			}
			if (_tmp104_) {
				ValaSignalType* _tmp115_;
				ValaSignal* _tmp116_;
				ValaSignal* _tmp117_;
				ValaMethod* _tmp118_;
				ValaMethod* _tmp119_;
				ValaMethod* _tmp120_;
				_tmp115_ = sig_type;
				_tmp116_ = vala_signal_type_get_signal_symbol (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = vala_signal_get_default_handler (_tmp117_);
				_tmp119_ = _tmp118_;
				_tmp120_ = _vala_code_node_ref0 (_tmp119_);
				_vala_code_node_unref0 (m);
				m = _tmp120_;
			} else {
				ValaExpression* _tmp121_;
				ValaExpression* _tmp122_;
				ValaCCodeExpression* _tmp123_;
				_tmp121_ = vala_method_call_get_call (expr);
				_tmp122_ = _tmp121_;
				_tmp123_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp122_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp124_;
			_tmp124_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp124_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaTypeSymbol* _tmp127_;
				ValaClass* _tmp128_;
				ValaClass* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaCreationMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaMethod* _tmp133_;
				ValaCCodeFile* _tmp134_;
				gchar* real_name = NULL;
				ValaMethod* _tmp135_;
				gchar* _tmp136_;
				gboolean _tmp137_;
				gboolean _tmp138_;
				const gchar* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeIdentifier* _tmp143_;
				ValaCCodeFunctionCall* _tmp144_;
				_tmp125_ = itype;
				_tmp126_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp127_ = _tmp126_;
				_tmp128_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp128_;
				_tmp129_ = cl;
				_tmp130_ = vala_class_get_default_construction_method (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = _vala_code_node_ref0 ((ValaMethod*) _tmp131_);
				_vala_code_node_unref0 (m);
				m = _tmp132_;
				_tmp133_ = m;
				_tmp134_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp133_, _tmp134_);
				_tmp135_ = m;
				_tmp136_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp135_);
				real_name = _tmp136_;
				_tmp137_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp138_ = _tmp137_;
				if (_tmp138_) {
					ValaMethod* _tmp139_;
					gchar* _tmp140_;
					_tmp139_ = m;
					_tmp140_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp140_;
				}
				_tmp141_ = real_name;
				_tmp142_ = vala_ccode_identifier_new (_tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp143_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp144_;
				_vala_ccode_node_unref0 (_tmp143_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp145_;
				_tmp145_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaTypeSymbol* _tmp148_;
					ValaStruct* _tmp149_;
					ValaStruct* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaCreationMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaMethod* _tmp154_;
					ValaCCodeFile* _tmp155_;
					ValaMethod* _tmp156_;
					gchar* _tmp157_;
					gchar* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeIdentifier* _tmp160_;
					ValaCCodeFunctionCall* _tmp161_;
					_tmp146_ = itype;
					_tmp147_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp148_ = _tmp147_;
					_tmp149_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp149_;
					_tmp150_ = st;
					_tmp151_ = vala_struct_get_default_construction_method (_tmp150_);
					_tmp152_ = _tmp151_;
					_tmp153_ = _vala_code_node_ref0 ((ValaMethod*) _tmp152_);
					_vala_code_node_unref0 (m);
					m = _tmp153_;
					_tmp154_ = m;
					_tmp155_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp154_, _tmp155_);
					_tmp156_ = m;
					_tmp157_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp156_);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_ccode_identifier_new (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp160_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp161_;
					_vala_ccode_node_unref0 (_tmp160_);
					_g_free0 (_tmp158_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp162_;
					_tmp162_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp162_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						ValaDelegate* _tmp166_;
						_tmp163_ = itype;
						_tmp164_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp165_ = _tmp164_;
						_tmp166_ = _vala_code_node_ref0 (_tmp165_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp166_;
					}
				}
			}
		}
	}
	_tmp167_ = g_direct_hash;
	_tmp168_ = g_direct_equal;
	_tmp169_ = g_direct_equal;
	_tmp170_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp167_, _tmp168_, _tmp169_);
	in_arg_map = _tmp170_;
	_tmp171_ = in_arg_map;
	_tmp172_ = _vala_map_ref0 (_tmp171_);
	out_arg_map = _tmp172_;
	_tmp174_ = m;
	if (_tmp174_ != NULL) {
		ValaMethod* _tmp175_;
		gboolean _tmp176_;
		gboolean _tmp177_;
		_tmp175_ = m;
		_tmp176_ = vala_method_get_coroutine (_tmp175_);
		_tmp177_ = _tmp176_;
		_tmp173_ = _tmp177_;
	} else {
		_tmp173_ = FALSE;
	}
	if (_tmp173_) {
		ValaMethod* _tmp178_;
		gchar* _tmp179_;
		gchar* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeIdentifier* _tmp182_;
		ValaCCodeFunctionCall* _tmp183_;
		ValaMethod* _tmp184_;
		gchar* _tmp185_;
		gchar* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeIdentifier* _tmp188_;
		ValaCCodeFunctionCall* _tmp189_;
		ValaMemberAccess* _tmp190_;
		ValaExpression* _tmp191_;
		ValaExpression* _tmp192_;
		gboolean _tmp241_ = FALSE;
		ValaMemberAccess* _tmp242_;
		const gchar* _tmp243_;
		const gchar* _tmp244_;
		_tmp178_ = m;
		_tmp179_ = vala_get_ccode_name ((ValaCodeNode*) _tmp178_);
		_tmp180_ = _tmp179_;
		_tmp181_ = vala_ccode_identifier_new (_tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp182_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp183_;
		_vala_ccode_node_unref0 (_tmp182_);
		_g_free0 (_tmp180_);
		_tmp184_ = m;
		_tmp185_ = vala_get_ccode_finish_name (_tmp184_);
		_tmp186_ = _tmp185_;
		_tmp187_ = vala_ccode_identifier_new (_tmp186_);
		_tmp188_ = _tmp187_;
		_tmp189_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp188_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp189_;
		_vala_ccode_node_unref0 (_tmp188_);
		_g_free0 (_tmp186_);
		_tmp190_ = ma;
		_tmp191_ = vala_member_access_get_inner (_tmp190_);
		_tmp192_ = _tmp191_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaMethod* _tmp195_;
			ValaCCodeExpression* _tmp226_;
			vcast = NULL;
			_tmp193_ = m;
			_tmp194_ = vala_method_get_base_method (_tmp193_);
			_tmp195_ = _tmp194_;
			if (_tmp195_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaSymbol* _tmp200_;
				ValaClass* _tmp201_;
				gchar* _tmp202_;
				gchar* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeIdentifier* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaCCodeExpression* _tmp207_;
				ValaClass* _tmp208_;
				ValaClass* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				ValaCCodeIdentifier* _tmp215_;
				_tmp196_ = m;
				_tmp197_ = vala_method_get_base_method (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp198_);
				_tmp200_ = _tmp199_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALA_TYPE_CLASS, ValaClass);
				_tmp201_ = base_class;
				_tmp202_ = vala_get_ccode_class_type_function (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_identifier_new (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp205_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp206_;
				_vala_ccode_node_unref0 (_tmp205_);
				_g_free0 (_tmp203_);
				_tmp207_ = vcast;
				_tmp208_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp209_ = _tmp208_;
				_tmp210_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp209_, NULL);
				_tmp211_ = _tmp210_;
				_tmp212_ = g_strdup_printf ("%s_parent_class", _tmp211_);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_ccode_identifier_new (_tmp213_);
				_tmp215_ = _tmp214_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp207_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp215_);
				_vala_ccode_node_unref0 (_tmp215_);
				_g_free0 (_tmp213_);
				_g_free0 (_tmp211_);
			} else {
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				ValaMethod* _tmp218_;
				_tmp216_ = m;
				_tmp217_ = vala_method_get_base_interface_method (_tmp216_);
				_tmp218_ = _tmp217_;
				if (_tmp218_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaMethod* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaSymbol* _tmp223_;
					ValaInterface* _tmp224_;
					ValaCCodeExpression* _tmp225_;
					_tmp219_ = m;
					_tmp220_ = vala_method_get_base_interface_method (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp221_);
					_tmp223_ = _tmp222_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp224_ = base_iface;
					_tmp225_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp224_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp225_;
				}
			}
			_tmp226_ = vcast;
			if (_tmp226_ != NULL) {
				ValaCCodeFunctionCall* _tmp227_;
				ValaCCodeExpression* _tmp228_;
				ValaMethod* _tmp229_;
				gchar* _tmp230_;
				gchar* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeMemberAccess* _tmp233_;
				ValaCCodeFunctionCall* _tmp234_;
				ValaCCodeExpression* _tmp235_;
				ValaMethod* _tmp236_;
				gchar* _tmp237_;
				gchar* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				ValaCCodeMemberAccess* _tmp240_;
				_tmp227_ = async_call;
				_tmp228_ = vcast;
				_tmp229_ = m;
				_tmp230_ = vala_get_ccode_vfunc_name (_tmp229_);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_ccode_member_access_new_pointer (_tmp228_, _tmp231_);
				_tmp233_ = _tmp232_;
				vala_ccode_function_call_set_call (_tmp227_, (ValaCCodeExpression*) _tmp233_);
				_vala_ccode_node_unref0 (_tmp233_);
				_g_free0 (_tmp231_);
				_tmp234_ = finish_call;
				_tmp235_ = vcast;
				_tmp236_ = m;
				_tmp237_ = vala_get_ccode_finish_vfunc_name (_tmp236_);
				_tmp238_ = _tmp237_;
				_tmp239_ = vala_ccode_member_access_new_pointer (_tmp235_, _tmp238_);
				_tmp240_ = _tmp239_;
				vala_ccode_function_call_set_call (_tmp234_, (ValaCCodeExpression*) _tmp240_);
				_vala_ccode_node_unref0 (_tmp240_);
				_g_free0 (_tmp238_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp242_ = ma;
		_tmp243_ = vala_member_access_get_member_name (_tmp242_);
		_tmp244_ = _tmp243_;
		if (g_strcmp0 (_tmp244_, "begin") == 0) {
			ValaMemberAccess* _tmp245_;
			ValaExpression* _tmp246_;
			ValaExpression* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaSymbol* _tmp249_;
			ValaMemberAccess* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			_tmp245_ = ma;
			_tmp246_ = vala_member_access_get_inner (_tmp245_);
			_tmp247_ = _tmp246_;
			_tmp248_ = vala_expression_get_symbol_reference (_tmp247_);
			_tmp249_ = _tmp248_;
			_tmp250_ = ma;
			_tmp251_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp250_);
			_tmp252_ = _tmp251_;
			_tmp241_ = _tmp249_ == _tmp252_;
		} else {
			_tmp241_ = FALSE;
		}
		if (_tmp241_) {
			ValaCCodeFunctionCall* _tmp253_;
			ValaCCodeFunctionCall* _tmp254_;
			ValaMethod* _tmp255_;
			ValaList* _tmp256_;
			_tmp253_ = async_call;
			_tmp254_ = _vala_ccode_node_ref0 (_tmp253_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp254_;
			_tmp255_ = m;
			_tmp256_ = vala_method_get_async_begin_parameters (_tmp255_);
			_vala_iterable_unref0 (params);
			params = _tmp256_;
		} else {
			gboolean _tmp257_ = FALSE;
			ValaMemberAccess* _tmp258_;
			const gchar* _tmp259_;
			const gchar* _tmp260_;
			_tmp258_ = ma;
			_tmp259_ = vala_member_access_get_member_name (_tmp258_);
			_tmp260_ = _tmp259_;
			if (g_strcmp0 (_tmp260_, "end") == 0) {
				ValaMemberAccess* _tmp261_;
				ValaExpression* _tmp262_;
				ValaExpression* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaSymbol* _tmp265_;
				ValaMemberAccess* _tmp266_;
				ValaSymbol* _tmp267_;
				ValaSymbol* _tmp268_;
				_tmp261_ = ma;
				_tmp262_ = vala_member_access_get_inner (_tmp261_);
				_tmp263_ = _tmp262_;
				_tmp264_ = vala_expression_get_symbol_reference (_tmp263_);
				_tmp265_ = _tmp264_;
				_tmp266_ = ma;
				_tmp267_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp266_);
				_tmp268_ = _tmp267_;
				_tmp257_ = _tmp265_ == _tmp268_;
			} else {
				_tmp257_ = FALSE;
			}
			if (_tmp257_) {
				ValaCCodeFunctionCall* _tmp269_;
				ValaCCodeFunctionCall* _tmp270_;
				ValaMethod* _tmp271_;
				ValaList* _tmp272_;
				_tmp269_ = finish_call;
				_tmp270_ = _vala_ccode_node_ref0 (_tmp269_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp270_;
				_tmp271_ = m;
				_tmp272_ = vala_method_get_async_end_parameters (_tmp271_);
				_vala_iterable_unref0 (params);
				params = _tmp272_;
			} else {
				gboolean _tmp273_;
				gboolean _tmp274_;
				_tmp273_ = vala_method_call_get_is_yield_expression (expr);
				_tmp274_ = _tmp273_;
				if (!_tmp274_) {
					ValaCCodeFunctionCall* _tmp275_;
					ValaCCodeFunctionCall* _tmp276_;
					ValaMethod* _tmp277_;
					ValaList* _tmp278_;
					_tmp275_ = async_call;
					_tmp276_ = _vala_ccode_node_ref0 (_tmp275_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp276_;
					_tmp277_ = m;
					_tmp278_ = vala_method_get_async_begin_parameters (_tmp277_);
					_vala_iterable_unref0 (params);
					params = _tmp278_;
				} else {
					ValaCCodeFunctionCall* _tmp279_;
					ValaCCodeFunctionCall* _tmp280_;
					GHashFunc _tmp281_;
					GEqualFunc _tmp282_;
					GEqualFunc _tmp283_;
					ValaHashMap* _tmp284_;
					ValaHashMap* _tmp285_;
					ValaMethod* _tmp286_;
					ValaCCodeIdentifier* _tmp287_;
					ValaCCodeIdentifier* _tmp288_;
					ValaCCodeMemberAccess* _tmp289_;
					ValaCCodeMemberAccess* _tmp290_;
					_tmp279_ = finish_call;
					_tmp280_ = _vala_ccode_node_ref0 (_tmp279_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp280_;
					_tmp281_ = g_direct_hash;
					_tmp282_ = g_direct_equal;
					_tmp283_ = g_direct_equal;
					_tmp284_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp281_, _tmp282_, _tmp283_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp284_;
					_tmp285_ = out_arg_map;
					_tmp286_ = m;
					_tmp287_ = vala_ccode_identifier_new ("_data_");
					_tmp288_ = _tmp287_;
					_tmp289_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp288_, "_res_");
					_tmp290_ = _tmp289_;
					vala_map_set ((ValaMap*) _tmp285_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp286_), FALSE)), (ValaCCodeExpression*) _tmp290_);
					_vala_ccode_node_unref0 (_tmp290_);
					_vala_ccode_node_unref0 (_tmp288_);
				}
			}
		}
	}
	_tmp292_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp293_;
		ValaSymbol* _tmp294_;
		ValaSymbol* _tmp295_;
		_tmp293_ = m;
		_tmp294_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp293_);
		_tmp295_ = _tmp294_;
		_tmp291_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp295_, VALA_TYPE_CLASS);
	} else {
		_tmp291_ = FALSE;
	}
	if (_tmp291_) {
		ValaCodeContext* _tmp296_;
		ValaCodeContext* _tmp297_;
		ValaProfile _tmp298_;
		ValaProfile _tmp299_;
		ValaClass* _tmp311_;
		ValaClass* _tmp312_;
		gboolean _tmp313_;
		gboolean _tmp314_;
		_tmp296_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp297_ = _tmp296_;
		_tmp298_ = vala_code_context_get_profile (_tmp297_);
		_tmp299_ = _tmp298_;
		if (_tmp299_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp300_;
			ValaSymbol* _tmp301_;
			ValaSymbol* _tmp302_;
			gboolean _tmp303_;
			gboolean _tmp304_;
			_tmp300_ = m;
			_tmp301_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp300_);
			_tmp302_ = _tmp301_;
			_tmp303_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, VALA_TYPE_CLASS, ValaClass));
			_tmp304_ = _tmp303_;
			if (!_tmp304_) {
				ValaCCodeFunctionCall* _tmp305_;
				ValaCCodeExpression* _tmp306_;
				ValaCCodeExpression* _tmp307_;
				_tmp305_ = ccall;
				_tmp306_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp307_ = _tmp306_;
				vala_ccode_function_call_add_argument (_tmp305_, _tmp307_);
				_vala_ccode_node_unref0 (_tmp307_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp308_;
			ValaCCodeExpression* _tmp309_;
			ValaCCodeExpression* _tmp310_;
			_tmp308_ = ccall;
			_tmp309_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp310_ = _tmp309_;
			vala_ccode_function_call_add_argument (_tmp308_, _tmp310_);
			_vala_ccode_node_unref0 (_tmp310_);
		}
		_tmp311_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp312_ = _tmp311_;
		_tmp313_ = vala_class_get_is_compact (_tmp312_);
		_tmp314_ = _tmp313_;
		if (!_tmp314_) {
			ValaClass* _tmp315_;
			ValaClass* _tmp316_;
			ValaMethod* _tmp317_;
			ValaSymbol* _tmp318_;
			ValaSymbol* _tmp319_;
			_tmp315_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp316_ = _tmp315_;
			_tmp317_ = m;
			_tmp318_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp317_);
			_tmp319_ = _tmp318_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp316_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp319_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp320_;
					ValaClass* _tmp321_;
					ValaList* _tmp322_;
					ValaList* _tmp323_;
					gint _base_type_size = 0;
					ValaList* _tmp324_;
					gint _tmp325_;
					gint _tmp326_;
					gint _base_type_index = 0;
					_tmp320_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp321_ = _tmp320_;
					_tmp322_ = vala_class_get_base_types (_tmp321_);
					_tmp323_ = _vala_iterable_ref0 (_tmp322_);
					_base_type_list = _tmp323_;
					_tmp324_ = _base_type_list;
					_tmp325_ = vala_collection_get_size ((ValaCollection*) _tmp324_);
					_tmp326_ = _tmp325_;
					_base_type_size = _tmp326_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp327_;
						gpointer _tmp328_;
						ValaDataType* _tmp329_;
						ValaTypeSymbol* _tmp330_;
						ValaTypeSymbol* _tmp331_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp327_ = _base_type_list;
						_tmp328_ = vala_list_get (_tmp327_, _base_type_index);
						base_type = (ValaDataType*) _tmp328_;
						_tmp329_ = base_type;
						_tmp330_ = vala_data_type_get_type_symbol (_tmp329_);
						_tmp331_ = _tmp330_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp331_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp332_;
							gchar* _tmp333_;
							gchar* _tmp334_;
							gboolean _tmp335_;
							ValaHashMap* _tmp341_;
							ValaDataType* _tmp342_;
							ValaList* _tmp343_;
							ValaList* _tmp344_;
							type_parameters = NULL;
							_tmp332_ = m;
							_tmp333_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp332_);
							_tmp334_ = _tmp333_;
							_tmp335_ = g_strcmp0 (_tmp334_, "g_object_new") == 0;
							_g_free0 (_tmp334_);
							if (_tmp335_) {
								ValaDataType* _tmp336_;
								ValaTypeSymbol* _tmp337_;
								ValaTypeSymbol* _tmp338_;
								ValaList* _tmp339_;
								ValaList* _tmp340_;
								_tmp336_ = base_type;
								_tmp337_ = vala_data_type_get_type_symbol (_tmp336_);
								_tmp338_ = _tmp337_;
								_tmp339_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp338_, VALA_TYPE_CLASS, ValaClass));
								_tmp340_ = _vala_iterable_ref0 (_tmp339_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp340_;
							}
							_tmp341_ = in_arg_map;
							_tmp342_ = base_type;
							_tmp343_ = vala_data_type_get_type_arguments (_tmp342_);
							_tmp344_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp341_, _tmp343_, (ValaCodeNode*) expr, TRUE, _tmp344_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaSymbol* _tmp347_;
				ValaClass* _tmp348_;
				type_param_index = 0;
				_tmp345_ = m;
				_tmp346_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp347_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp348_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp349_;
					ValaList* _tmp350_;
					ValaList* _tmp351_;
					gint _type_param_size = 0;
					ValaList* _tmp352_;
					gint _tmp353_;
					gint _tmp354_;
					gint _type_param_index = 0;
					_tmp349_ = cl;
					_tmp350_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp349_);
					_tmp351_ = _vala_iterable_ref0 (_tmp350_);
					_type_param_list = _tmp351_;
					_tmp352_ = _type_param_list;
					_tmp353_ = vala_collection_get_size ((ValaCollection*) _tmp352_);
					_tmp354_ = _tmp353_;
					_type_param_size = _tmp354_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp355_;
						gpointer _tmp356_;
						ValaHashMap* _tmp357_;
						ValaTypeParameter* _tmp358_;
						const gchar* _tmp359_;
						const gchar* _tmp360_;
						gchar* _tmp361_;
						gchar* _tmp362_;
						gchar* _tmp363_;
						gchar* _tmp364_;
						ValaCCodeIdentifier* _tmp365_;
						ValaCCodeIdentifier* _tmp366_;
						ValaHashMap* _tmp367_;
						ValaTypeParameter* _tmp368_;
						const gchar* _tmp369_;
						const gchar* _tmp370_;
						gchar* _tmp371_;
						gchar* _tmp372_;
						gchar* _tmp373_;
						gchar* _tmp374_;
						ValaCCodeIdentifier* _tmp375_;
						ValaCCodeIdentifier* _tmp376_;
						ValaHashMap* _tmp377_;
						ValaTypeParameter* _tmp378_;
						const gchar* _tmp379_;
						const gchar* _tmp380_;
						gchar* _tmp381_;
						gchar* _tmp382_;
						gchar* _tmp383_;
						gchar* _tmp384_;
						ValaCCodeIdentifier* _tmp385_;
						ValaCCodeIdentifier* _tmp386_;
						gint _tmp387_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp355_ = _type_param_list;
						_tmp356_ = vala_list_get (_tmp355_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp356_;
						_tmp357_ = in_arg_map;
						_tmp358_ = type_param;
						_tmp359_ = vala_symbol_get_name ((ValaSymbol*) _tmp358_);
						_tmp360_ = _tmp359_;
						_tmp361_ = g_utf8_strdown (_tmp360_, (gssize) -1);
						_tmp362_ = _tmp361_;
						_tmp363_ = g_strdup_printf ("%s_type", _tmp362_);
						_tmp364_ = _tmp363_;
						_tmp365_ = vala_ccode_identifier_new (_tmp364_);
						_tmp366_ = _tmp365_;
						vala_map_set ((ValaMap*) _tmp357_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp366_);
						_vala_ccode_node_unref0 (_tmp366_);
						_g_free0 (_tmp364_);
						_g_free0 (_tmp362_);
						_tmp367_ = in_arg_map;
						_tmp368_ = type_param;
						_tmp369_ = vala_symbol_get_name ((ValaSymbol*) _tmp368_);
						_tmp370_ = _tmp369_;
						_tmp371_ = g_utf8_strdown (_tmp370_, (gssize) -1);
						_tmp372_ = _tmp371_;
						_tmp373_ = g_strdup_printf ("%s_dup_func", _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = vala_ccode_identifier_new (_tmp374_);
						_tmp376_ = _tmp375_;
						vala_map_set ((ValaMap*) _tmp367_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp376_);
						_vala_ccode_node_unref0 (_tmp376_);
						_g_free0 (_tmp374_);
						_g_free0 (_tmp372_);
						_tmp377_ = in_arg_map;
						_tmp378_ = type_param;
						_tmp379_ = vala_symbol_get_name ((ValaSymbol*) _tmp378_);
						_tmp380_ = _tmp379_;
						_tmp381_ = g_utf8_strdown (_tmp380_, (gssize) -1);
						_tmp382_ = _tmp381_;
						_tmp383_ = g_strdup_printf ("%s_destroy_func", _tmp382_);
						_tmp384_ = _tmp383_;
						_tmp385_ = vala_ccode_identifier_new (_tmp384_);
						_tmp386_ = _tmp385_;
						vala_map_set ((ValaMap*) _tmp377_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp386_);
						_vala_ccode_node_unref0 (_tmp386_);
						_g_free0 (_tmp384_);
						_g_free0 (_tmp382_);
						_tmp387_ = type_param_index;
						type_param_index = _tmp387_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp388_;
			ValaClass* _tmp389_;
			ValaClass* _tmp390_;
			ValaClass* _tmp391_;
			ValaClass* _tmp392_;
			_tmp388_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp389_ = _tmp388_;
			_tmp390_ = vala_class_get_base_class (_tmp389_);
			_tmp391_ = _tmp390_;
			_tmp392_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp391_ == _tmp392_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp393_;
				ValaClass* _tmp394_;
				gchar* _tmp395_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp396_;
				ValaCCodeDeclaration* _tmp397_;
				ValaCCodeDeclaration* _tmp398_;
				const gchar* _tmp399_;
				const gchar* _tmp400_;
				const gchar* _tmp401_;
				const gchar* _tmp402_;
				gchar* _tmp403_;
				gchar* _tmp404_;
				ValaCCodeConstant* _tmp405_;
				ValaCCodeConstant* _tmp406_;
				ValaCCodeVariableDeclarator* _tmp407_;
				ValaCCodeVariableDeclarator* _tmp408_;
				ValaCCodeFunction* _tmp409_;
				ValaCCodeFunction* _tmp410_;
				ValaCCodeDeclaration* _tmp411_;
				ValaCCodeFunctionCall* _tmp412_;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeUnaryExpression* _tmp415_;
				ValaCCodeUnaryExpression* _tmp416_;
				ValaCCodeCastExpression* _tmp417_;
				ValaCCodeCastExpression* _tmp418_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp419_;
				ValaCCodeIdentifier* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				ValaCCodeFunctionCall* _tmp423_;
				ValaClass* _tmp424_;
				ValaClass* _tmp425_;
				gchar* _tmp426_;
				gchar* _tmp427_;
				ValaCCodeIdentifier* _tmp428_;
				ValaCCodeIdentifier* _tmp429_;
				ValaCCodeFunctionCall* _tmp430_;
				ValaCCodeFunctionCall* _tmp431_;
				_tmp393_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp394_, NULL);
				class_prefix = _tmp395_;
				_tmp396_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp396_;
				_tmp397_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp397_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp398_ = funcs;
				_tmp399_ = class_prefix;
				_tmp400_ = class_prefix;
				_tmp401_ = class_prefix;
				_tmp402_ = class_prefix;
				_tmp403_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp399_, _tmp400_, _tmp401_, _tmp402_);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_ccode_constant_new (_tmp404_);
				_tmp406_ = _tmp405_;
				_tmp407_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp406_, NULL);
				_tmp408_ = _tmp407_;
				vala_ccode_declaration_add_declarator (_tmp398_, (ValaCCodeDeclarator*) _tmp408_);
				_vala_ccode_node_unref0 (_tmp408_);
				_vala_ccode_node_unref0 (_tmp406_);
				_g_free0 (_tmp404_);
				_tmp409_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp410_ = _tmp409_;
				_tmp411_ = funcs;
				vala_ccode_function_add_statement (_tmp410_, (ValaCCodeNode*) _tmp411_);
				_tmp412_ = ccall;
				_tmp413_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp414_ = _tmp413_;
				_tmp415_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp414_);
				_tmp416_ = _tmp415_;
				_tmp417_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp416_, "GSourceFuncs *");
				_tmp418_ = _tmp417_;
				vala_ccode_function_call_add_argument (_tmp412_, (ValaCCodeExpression*) _tmp418_);
				_vala_ccode_node_unref0 (_tmp418_);
				_vala_ccode_node_unref0 (_tmp416_);
				_vala_ccode_node_unref0 (_tmp414_);
				_tmp419_ = vala_ccode_identifier_new ("sizeof");
				_tmp420_ = _tmp419_;
				_tmp421_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp420_);
				_tmp422_ = _tmp421_;
				_vala_ccode_node_unref0 (_tmp420_);
				csizeof = _tmp422_;
				_tmp423_ = csizeof;
				_tmp424_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp425_ = _tmp424_;
				_tmp426_ = vala_get_ccode_name ((ValaCodeNode*) _tmp425_);
				_tmp427_ = _tmp426_;
				_tmp428_ = vala_ccode_identifier_new (_tmp427_);
				_tmp429_ = _tmp428_;
				vala_ccode_function_call_add_argument (_tmp423_, (ValaCCodeExpression*) _tmp429_);
				_vala_ccode_node_unref0 (_tmp429_);
				_g_free0 (_tmp427_);
				_tmp430_ = ccall;
				_tmp431_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp430_, (ValaCCodeExpression*) _tmp431_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp432_ = FALSE;
		ValaMethod* _tmp433_;
		_tmp433_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp433_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp434_;
			ValaSymbol* _tmp435_;
			ValaSymbol* _tmp436_;
			_tmp434_ = m;
			_tmp435_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp434_);
			_tmp436_ = _tmp435_;
			_tmp432_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp436_, VALA_TYPE_STRUCT);
		} else {
			_tmp432_ = FALSE;
		}
		if (_tmp432_) {
			ValaCCodeFunctionCall* _tmp437_;
			ValaCCodeExpression* _tmp438_;
			ValaCCodeExpression* _tmp439_;
			_tmp437_ = ccall;
			_tmp438_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp439_ = _tmp438_;
			vala_ccode_function_call_add_argument (_tmp437_, _tmp439_);
			_vala_ccode_node_unref0 (_tmp439_);
		} else {
			gboolean _tmp440_ = FALSE;
			gboolean _tmp441_ = FALSE;
			gboolean _tmp442_ = FALSE;
			gboolean _tmp443_ = FALSE;
			ValaMethod* _tmp444_;
			_tmp444_ = m;
			if (_tmp444_ != NULL) {
				ValaMethod* _tmp445_;
				_tmp445_ = m;
				_tmp443_ = vala_method_has_type_parameters (_tmp445_);
			} else {
				_tmp443_ = FALSE;
			}
			if (_tmp443_) {
				ValaMethod* _tmp446_;
				_tmp446_ = m;
				_tmp442_ = !vala_get_ccode_has_generic_type_parameter (_tmp446_);
			} else {
				_tmp442_ = FALSE;
			}
			if (_tmp442_) {
				ValaMethod* _tmp447_;
				_tmp447_ = m;
				_tmp441_ = !vala_get_ccode_simple_generics (_tmp447_);
			} else {
				_tmp441_ = FALSE;
			}
			if (_tmp441_) {
				gboolean _tmp448_ = FALSE;
				ValaCCodeFunctionCall* _tmp449_;
				ValaCCodeFunctionCall* _tmp450_;
				_tmp449_ = ccall;
				_tmp450_ = finish_call;
				if (_tmp449_ != _tmp450_) {
					_tmp448_ = TRUE;
				} else {
					gboolean _tmp451_;
					gboolean _tmp452_;
					_tmp451_ = vala_method_call_get_is_yield_expression (expr);
					_tmp452_ = _tmp451_;
					_tmp448_ = _tmp452_;
				}
				_tmp440_ = _tmp448_;
			} else {
				_tmp440_ = FALSE;
			}
			if (_tmp440_) {
				ValaHashMap* _tmp453_;
				ValaMemberAccess* _tmp454_;
				ValaList* _tmp455_;
				_tmp453_ = in_arg_map;
				_tmp454_ = ma;
				_tmp455_ = vala_member_access_get_type_arguments (_tmp454_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp453_, _tmp455_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp456_ = ccall;
	_tmp457_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp456_);
	ccall_expr = _tmp457_;
	_tmp459_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp459_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp460_;
		ValaCodeContext* _tmp461_;
		ValaProfile _tmp462_;
		ValaProfile _tmp463_;
		_tmp460_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp461_ = _tmp460_;
		_tmp462_ = vala_code_context_get_profile (_tmp461_);
		_tmp463_ = _tmp462_;
		_tmp458_ = _tmp463_ != VALA_PROFILE_POSIX;
	} else {
		_tmp458_ = FALSE;
	}
	if (_tmp458_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp464_;
		ValaExpression* _tmp465_;
		ValaExpression* _tmp466_;
		ValaDataType* _tmp467_;
		ValaDataType* _tmp468_;
		ValaArrayType* _tmp469_;
		ValaHashMap* _tmp470_;
		ValaArrayType* _tmp471_;
		ValaDataType* _tmp472_;
		ValaDataType* _tmp473_;
		gchar* _tmp474_;
		gchar* _tmp475_;
		ValaCCodeIdentifier* _tmp476_;
		ValaCCodeIdentifier* _tmp477_;
		_tmp464_ = ma;
		_tmp465_ = vala_member_access_get_inner (_tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_expression_get_value_type (_tmp466_);
		_tmp468_ = _tmp467_;
		_tmp469_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp468_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp469_;
		_tmp470_ = in_arg_map;
		_tmp471_ = array_type;
		_tmp472_ = vala_array_type_get_element_type (_tmp471_);
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_get_ccode_name ((ValaCodeNode*) _tmp473_);
		_tmp475_ = _tmp474_;
		_tmp476_ = vala_ccode_identifier_new (_tmp475_);
		_tmp477_ = _tmp476_;
		vala_map_set ((ValaMap*) _tmp470_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp477_);
		_vala_ccode_node_unref0 (_tmp477_);
		_g_free0 (_tmp475_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp478_;
		_tmp478_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp478_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp479_;
			_tmp479_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp479_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp480_;
				ValaExpression* _tmp481_;
				ValaExpression* _tmp482_;
				ValaTargetValue* _tmp483_;
				ValaTargetValue* _tmp484_;
				ValaTargetValue* _tmp485_;
				ValaTargetValue* _tmp486_;
				_tmp480_ = ma;
				_tmp481_ = vala_member_access_get_inner (_tmp480_);
				_tmp482_ = _tmp481_;
				_tmp483_ = vala_expression_get_target_value (_tmp482_);
				_tmp484_ = _tmp483_;
				_tmp485_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp484_, (ValaCodeNode*) expr);
				_tmp486_ = _tmp485_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp486_);
				_vala_target_value_unref0 (_tmp486_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp488_ = m;
	if (_tmp488_ != NULL) {
		ValaMethod* _tmp489_;
		gboolean _tmp490_;
		gboolean _tmp491_;
		_tmp489_ = m;
		_tmp490_ = vala_method_get_is_async_callback (_tmp489_);
		_tmp491_ = _tmp490_;
		_tmp487_ = _tmp491_;
	} else {
		_tmp487_ = FALSE;
	}
	if (_tmp487_) {
		ValaMethod* _tmp492_;
		ValaMethod* _tmp493_;
		gboolean _tmp494_;
		gboolean _tmp495_;
		ValaHashMap* _tmp509_;
		ValaMethod* _tmp510_;
		ValaCCodeExpression* _tmp511_;
		ValaHashMap* _tmp512_;
		ValaMethod* _tmp513_;
		ValaCCodeExpression* _tmp514_;
		_tmp492_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp493_ = _tmp492_;
		_tmp494_ = vala_method_get_closure (_tmp493_);
		_tmp495_ = _tmp494_;
		if (_tmp495_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp496_;
			ValaSymbol* _tmp497_;
			ValaSymbol* _tmp498_;
			ValaBlock* _tmp499_;
			ValaBlock* _tmp500_;
			ValaBlock* _tmp501_;
			ValaBlock* _tmp502_;
			gchar* _tmp503_;
			gchar* _tmp504_;
			ValaCCodeExpression* _tmp505_;
			ValaCCodeExpression* _tmp506_;
			ValaCCodeMemberAccess* _tmp507_;
			_tmp496_ = m;
			_tmp497_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp496_);
			_tmp498_ = _tmp497_;
			_tmp499_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp498_, VALA_TYPE_METHOD, ValaMethod));
			_tmp500_ = _tmp499_;
			_tmp501_ = _vala_code_node_ref0 (_tmp500_);
			block = _tmp501_;
			_tmp502_ = block;
			_tmp503_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp502_));
			_tmp504_ = _tmp503_;
			_tmp505_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp504_);
			_tmp506_ = _tmp505_;
			_tmp507_ = vala_ccode_member_access_new_pointer (_tmp506_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp507_;
			_vala_ccode_node_unref0 (_tmp506_);
			_g_free0 (_tmp504_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp508_;
			_tmp508_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp508_;
		}
		_tmp509_ = in_arg_map;
		_tmp510_ = m;
		_tmp511_ = instance;
		vala_map_set ((ValaMap*) _tmp509_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp510_), FALSE)), _tmp511_);
		_tmp512_ = out_arg_map;
		_tmp513_ = m;
		_tmp514_ = instance;
		vala_map_set ((ValaMap*) _tmp512_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp513_), FALSE)), _tmp514_);
	} else {
		gboolean _tmp515_ = FALSE;
		gboolean _tmp516_ = FALSE;
		ValaMethod* _tmp517_;
		_tmp517_ = m;
		if (_tmp517_ != NULL) {
			ValaMethod* _tmp518_;
			ValaMemberBinding _tmp519_;
			ValaMemberBinding _tmp520_;
			_tmp518_ = m;
			_tmp519_ = vala_method_get_binding (_tmp518_);
			_tmp520_ = _tmp519_;
			_tmp516_ = _tmp520_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp516_ = FALSE;
		}
		if (_tmp516_) {
			ValaMethod* _tmp521_;
			_tmp521_ = m;
			_tmp515_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp521_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp515_ = FALSE;
		}
		if (_tmp515_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp522_;
			ValaExpression* _tmp523_;
			ValaExpression* _tmp524_;
			ValaTargetValue* _tmp525_;
			ValaTargetValue* _tmp526_;
			ValaTargetValue* _tmp527_;
			gboolean _tmp528_ = FALSE;
			gboolean _tmp529_ = FALSE;
			ValaMemberAccess* _tmp530_;
			const gchar* _tmp531_;
			const gchar* _tmp532_;
			ValaTargetValue* _tmp554_;
			ValaCCodeExpression* _tmp555_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp556_;
			ValaSymbol* _tmp557_;
			ValaSymbol* _tmp558_;
			ValaStruct* _tmp559_;
			gboolean _tmp560_ = FALSE;
			ValaStruct* _tmp561_;
			gboolean _tmp570_;
			gboolean _tmp571_;
			_tmp522_ = ma;
			_tmp523_ = vala_member_access_get_inner (_tmp522_);
			_tmp524_ = _tmp523_;
			_tmp525_ = vala_expression_get_target_value (_tmp524_);
			_tmp526_ = _tmp525_;
			_tmp527_ = _vala_target_value_ref0 (_tmp526_);
			instance_value = _tmp527_;
			_tmp530_ = ma;
			_tmp531_ = vala_member_access_get_member_name (_tmp530_);
			_tmp532_ = _tmp531_;
			if (g_strcmp0 (_tmp532_, "begin") == 0) {
				_tmp529_ = TRUE;
			} else {
				ValaMemberAccess* _tmp533_;
				const gchar* _tmp534_;
				const gchar* _tmp535_;
				_tmp533_ = ma;
				_tmp534_ = vala_member_access_get_member_name (_tmp533_);
				_tmp535_ = _tmp534_;
				_tmp529_ = g_strcmp0 (_tmp535_, "end") == 0;
			}
			if (_tmp529_) {
				ValaMemberAccess* _tmp536_;
				ValaExpression* _tmp537_;
				ValaExpression* _tmp538_;
				ValaSymbol* _tmp539_;
				ValaSymbol* _tmp540_;
				ValaMemberAccess* _tmp541_;
				ValaSymbol* _tmp542_;
				ValaSymbol* _tmp543_;
				_tmp536_ = ma;
				_tmp537_ = vala_member_access_get_inner (_tmp536_);
				_tmp538_ = _tmp537_;
				_tmp539_ = vala_expression_get_symbol_reference (_tmp538_);
				_tmp540_ = _tmp539_;
				_tmp541_ = ma;
				_tmp542_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp541_);
				_tmp543_ = _tmp542_;
				_tmp528_ = _tmp540_ == _tmp543_;
			} else {
				_tmp528_ = FALSE;
			}
			if (_tmp528_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp544_;
				ValaExpression* _tmp545_;
				ValaExpression* _tmp546_;
				ValaMemberAccess* _tmp547_;
				ValaMemberAccess* _tmp548_;
				ValaExpression* _tmp549_;
				ValaExpression* _tmp550_;
				ValaTargetValue* _tmp551_;
				ValaTargetValue* _tmp552_;
				ValaTargetValue* _tmp553_;
				_tmp544_ = ma;
				_tmp545_ = vala_member_access_get_inner (_tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp546_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp547_;
				_tmp548_ = inner_ma;
				_tmp549_ = vala_member_access_get_inner (_tmp548_);
				_tmp550_ = _tmp549_;
				_tmp551_ = vala_expression_get_target_value (_tmp550_);
				_tmp552_ = _tmp551_;
				_tmp553_ = _vala_target_value_ref0 (_tmp552_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp553_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp554_ = instance_value;
			_tmp555_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp554_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp555_;
			_tmp556_ = m;
			_tmp557_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp556_);
			_tmp558_ = _tmp557_;
			_tmp559_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp558_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp558_) : NULL);
			st = _tmp559_;
			_tmp561_ = st;
			if (_tmp561_ != NULL) {
				ValaStruct* _tmp562_;
				_tmp562_ = st;
				_tmp560_ = !vala_struct_is_simple_type (_tmp562_);
			} else {
				_tmp560_ = FALSE;
			}
			if (_tmp560_) {
				ValaTargetValue* _tmp563_;
				ValaTargetValue* _tmp566_;
				ValaCCodeExpression* _tmp567_;
				ValaCCodeExpression* _tmp568_;
				ValaCCodeUnaryExpression* _tmp569_;
				_tmp563_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp563_)) {
					ValaTargetValue* _tmp564_;
					ValaTargetValue* _tmp565_;
					_tmp564_ = instance_value;
					_tmp565_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp564_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp565_;
				}
				_tmp566_ = instance_value;
				_tmp567_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp566_);
				_tmp568_ = _tmp567_;
				_tmp569_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp568_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp569_;
				_vala_ccode_node_unref0 (_tmp568_);
			}
			_tmp570_ = vala_method_call_get_is_yield_expression (expr);
			_tmp571_ = _tmp570_;
			if (_tmp571_) {
				ValaHashMap* _tmp572_;
				ValaMethod* _tmp573_;
				ValaCCodeExpression* _tmp574_;
				ValaMethod* _tmp575_;
				_tmp572_ = in_arg_map;
				_tmp573_ = m;
				_tmp574_ = instance;
				vala_map_set ((ValaMap*) _tmp572_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp573_), FALSE)), _tmp574_);
				_tmp575_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp575_)) {
					ValaHashMap* _tmp576_;
					ValaMethod* _tmp577_;
					ValaCCodeExpression* _tmp578_;
					_tmp576_ = out_arg_map;
					_tmp577_ = m;
					_tmp578_ = instance;
					vala_map_set ((ValaMap*) _tmp576_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp577_), FALSE)), _tmp578_);
				}
			} else {
				gboolean _tmp579_ = FALSE;
				ValaMemberAccess* _tmp580_;
				const gchar* _tmp581_;
				const gchar* _tmp582_;
				_tmp580_ = ma;
				_tmp581_ = vala_member_access_get_member_name (_tmp580_);
				_tmp582_ = _tmp581_;
				if (g_strcmp0 (_tmp582_, "end") != 0) {
					_tmp579_ = TRUE;
				} else {
					ValaMethod* _tmp583_;
					_tmp583_ = m;
					_tmp579_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp583_);
				}
				if (_tmp579_) {
					ValaHashMap* _tmp584_;
					ValaMethod* _tmp585_;
					ValaCCodeExpression* _tmp586_;
					ValaHashMap* _tmp587_;
					ValaMethod* _tmp588_;
					ValaCCodeExpression* _tmp589_;
					_tmp584_ = out_arg_map;
					_tmp585_ = m;
					_tmp586_ = instance;
					vala_map_set ((ValaMap*) _tmp584_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp585_), FALSE)), _tmp586_);
					_tmp587_ = in_arg_map;
					_tmp588_ = m;
					_tmp589_ = instance;
					vala_map_set ((ValaMap*) _tmp587_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp588_), FALSE)), _tmp589_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp590_ = FALSE;
			ValaMethod* _tmp591_;
			_tmp591_ = m;
			if (_tmp591_ != NULL) {
				ValaMethod* _tmp592_;
				ValaMemberBinding _tmp593_;
				ValaMemberBinding _tmp594_;
				_tmp592_ = m;
				_tmp593_ = vala_method_get_binding (_tmp592_);
				_tmp594_ = _tmp593_;
				_tmp590_ = _tmp594_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp590_ = FALSE;
			}
			if (_tmp590_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp595_;
				ValaSymbol* _tmp596_;
				ValaSymbol* _tmp597_;
				ValaClass* _tmp598_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp599_;
				gchar* _tmp600_;
				gchar* _tmp601_;
				ValaCCodeIdentifier* _tmp602_;
				ValaCCodeIdentifier* _tmp603_;
				ValaCCodeFunctionCall* _tmp604_;
				ValaCCodeFunctionCall* _tmp605_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp606_;
				ValaExpression* _tmp607_;
				ValaExpression* _tmp608_;
				ValaCCodeFunctionCall* _tmp634_;
				ValaCCodeExpression* _tmp635_;
				ValaHashMap* _tmp636_;
				ValaMethod* _tmp637_;
				ValaCCodeFunctionCall* _tmp638_;
				ValaHashMap* _tmp639_;
				ValaMethod* _tmp640_;
				ValaCCodeFunctionCall* _tmp641_;
				_tmp595_ = m;
				_tmp596_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp595_);
				_tmp597_ = _tmp596_;
				_tmp598_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp597_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp598_;
				_tmp599_ = cl;
				_tmp600_ = vala_get_ccode_class_type_function (_tmp599_);
				_tmp601_ = _tmp600_;
				_tmp602_ = vala_ccode_identifier_new (_tmp601_);
				_tmp603_ = _tmp602_;
				_tmp604_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp603_);
				_tmp605_ = _tmp604_;
				_vala_ccode_node_unref0 (_tmp603_);
				_g_free0 (_tmp601_);
				cast = _tmp605_;
				_tmp606_ = ma;
				_tmp607_ = vala_member_access_get_inner (_tmp606_);
				_tmp608_ = _tmp607_;
				if (_tmp608_ == NULL) {
					ValaDataType* _tmp609_;
					ValaDataType* _tmp610_;
					gboolean _tmp611_;
					_tmp609_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp610_ = _tmp609_;
					_tmp611_ = _tmp610_ == NULL;
					_vala_code_node_unref0 (_tmp610_);
					if (_tmp611_) {
						ValaCCodeIdentifier* _tmp612_;
						_tmp612_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp612_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp613_;
						ValaCCodeIdentifier* _tmp614_;
						ValaCCodeFunctionCall* _tmp615_;
						ValaCCodeFunctionCall* _tmp616_;
						ValaCCodeFunctionCall* _tmp617_;
						ValaCCodeExpression* _tmp618_;
						ValaCCodeExpression* _tmp619_;
						ValaCCodeFunctionCall* _tmp620_;
						ValaCCodeExpression* _tmp621_;
						_tmp613_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp614_ = _tmp613_;
						_tmp615_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp614_);
						_tmp616_ = _tmp615_;
						_vala_ccode_node_unref0 (_tmp614_);
						k = _tmp616_;
						_tmp617_ = k;
						_tmp618_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp619_ = _tmp618_;
						vala_ccode_function_call_add_argument (_tmp617_, _tmp619_);
						_vala_ccode_node_unref0 (_tmp619_);
						_tmp620_ = k;
						_tmp621_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp620_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp621_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp622_;
					ValaCCodeIdentifier* _tmp623_;
					ValaCCodeFunctionCall* _tmp624_;
					ValaCCodeFunctionCall* _tmp625_;
					ValaCCodeFunctionCall* _tmp626_;
					ValaMemberAccess* _tmp627_;
					ValaExpression* _tmp628_;
					ValaExpression* _tmp629_;
					ValaCCodeExpression* _tmp630_;
					ValaCCodeExpression* _tmp631_;
					ValaCCodeFunctionCall* _tmp632_;
					ValaCCodeExpression* _tmp633_;
					_tmp622_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp623_ = _tmp622_;
					_tmp624_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp623_);
					_tmp625_ = _tmp624_;
					_vala_ccode_node_unref0 (_tmp623_);
					k = _tmp625_;
					_tmp626_ = k;
					_tmp627_ = ma;
					_tmp628_ = vala_member_access_get_inner (_tmp627_);
					_tmp629_ = _tmp628_;
					_tmp630_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp629_);
					_tmp631_ = _tmp630_;
					vala_ccode_function_call_add_argument (_tmp626_, _tmp631_);
					_vala_ccode_node_unref0 (_tmp631_);
					_tmp632_ = k;
					_tmp633_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp632_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp633_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp634_ = cast;
				_tmp635_ = klass;
				vala_ccode_function_call_add_argument (_tmp634_, _tmp635_);
				_tmp636_ = in_arg_map;
				_tmp637_ = m;
				_tmp638_ = cast;
				vala_map_set ((ValaMap*) _tmp636_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp637_), FALSE)), (ValaCCodeExpression*) _tmp638_);
				_tmp639_ = out_arg_map;
				_tmp640_ = m;
				_tmp641_ = cast;
				vala_map_set ((ValaMap*) _tmp639_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp640_), FALSE)), (ValaCCodeExpression*) _tmp641_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp643_ = m;
	if (_tmp643_ != NULL) {
		ValaMethod* _tmp644_;
		_tmp644_ = m;
		_tmp642_ = vala_get_ccode_has_generic_type_parameter (_tmp644_);
	} else {
		_tmp642_ = FALSE;
	}
	if (_tmp642_) {
		ValaMethod* _tmp645_;
		_tmp645_ = m;
		if (vala_method_has_type_parameters (_tmp645_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp646_;
				ValaList* _tmp647_;
				ValaList* _tmp648_;
				gint _type_arg_size = 0;
				ValaList* _tmp649_;
				gint _tmp650_;
				gint _tmp651_;
				gint _type_arg_index = 0;
				_tmp646_ = ma;
				_tmp647_ = vala_member_access_get_type_arguments (_tmp646_);
				_tmp648_ = _vala_iterable_ref0 (_tmp647_);
				_type_arg_list = _tmp648_;
				_tmp649_ = _type_arg_list;
				_tmp650_ = vala_collection_get_size ((ValaCollection*) _tmp649_);
				_tmp651_ = _tmp650_;
				_type_arg_size = _tmp651_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp652_;
					gpointer _tmp653_;
					gboolean _tmp654_ = FALSE;
					gboolean _tmp655_ = FALSE;
					gboolean _tmp656_ = FALSE;
					ValaMethod* _tmp657_;
					ValaHashMap* _tmp665_;
					ValaMethod* _tmp666_;
					ValaDataType* _tmp667_;
					gchar* _tmp668_;
					gchar* _tmp669_;
					ValaCCodeIdentifier* _tmp670_;
					ValaCCodeIdentifier* _tmp671_;
					gint _tmp672_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp652_ = _type_arg_list;
					_tmp653_ = vala_list_get (_tmp652_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp653_;
					_tmp657_ = m;
					if (vala_get_ccode_simple_generics (_tmp657_)) {
						ValaDataType* _tmp658_;
						_tmp658_ = type_arg;
						_tmp656_ = vala_data_type_is_real_struct_type (_tmp658_);
					} else {
						_tmp656_ = FALSE;
					}
					if (_tmp656_) {
						ValaDataType* _tmp659_;
						gboolean _tmp660_;
						gboolean _tmp661_;
						_tmp659_ = type_arg;
						_tmp660_ = vala_data_type_get_nullable (_tmp659_);
						_tmp661_ = _tmp660_;
						_tmp655_ = !_tmp661_;
					} else {
						_tmp655_ = FALSE;
					}
					if (_tmp655_) {
						ValaDataType* _tmp662_;
						_tmp662_ = type_arg;
						_tmp654_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp662_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp654_ = FALSE;
					}
					if (_tmp654_) {
						ValaDataType* _tmp663_;
						ValaPointerType* _tmp664_;
						_tmp663_ = type_arg;
						_tmp664_ = vala_pointer_type_new (_tmp663_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp664_;
					}
					_tmp665_ = in_arg_map;
					_tmp666_ = m;
					_tmp667_ = type_arg;
					_tmp668_ = vala_get_ccode_name ((ValaCodeNode*) _tmp667_);
					_tmp669_ = _tmp668_;
					_tmp670_ = vala_ccode_identifier_new (_tmp669_);
					_tmp671_ = _tmp670_;
					vala_map_set ((ValaMap*) _tmp665_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp666_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp671_);
					_vala_ccode_node_unref0 (_tmp671_);
					_g_free0 (_tmp669_);
					_tmp672_ = type_param_index;
					type_param_index = _tmp672_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp673_;
				ValaExpression* _tmp674_;
				ValaExpression* _tmp675_;
				ValaDataType* _tmp676_;
				ValaDataType* _tmp677_;
				ValaList* _tmp678_;
				ValaList* _tmp679_;
				gint _type_arg_size = 0;
				ValaList* _tmp680_;
				gint _tmp681_;
				gint _tmp682_;
				gint _type_arg_index = 0;
				_tmp673_ = ma;
				_tmp674_ = vala_member_access_get_inner (_tmp673_);
				_tmp675_ = _tmp674_;
				_tmp676_ = vala_expression_get_value_type (_tmp675_);
				_tmp677_ = _tmp676_;
				_tmp678_ = vala_data_type_get_type_arguments (_tmp677_);
				_tmp679_ = _vala_iterable_ref0 (_tmp678_);
				_type_arg_list = _tmp679_;
				_tmp680_ = _type_arg_list;
				_tmp681_ = vala_collection_get_size ((ValaCollection*) _tmp680_);
				_tmp682_ = _tmp681_;
				_type_arg_size = _tmp682_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp683_;
					gpointer _tmp684_;
					ValaHashMap* _tmp685_;
					ValaMethod* _tmp686_;
					ValaDataType* _tmp687_;
					gchar* _tmp688_;
					gchar* _tmp689_;
					ValaCCodeIdentifier* _tmp690_;
					ValaCCodeIdentifier* _tmp691_;
					gint _tmp692_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp683_ = _type_arg_list;
					_tmp684_ = vala_list_get (_tmp683_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp684_;
					_tmp685_ = in_arg_map;
					_tmp686_ = m;
					_tmp687_ = type_arg;
					_tmp688_ = vala_get_ccode_name ((ValaCodeNode*) _tmp687_);
					_tmp689_ = _tmp688_;
					_tmp690_ = vala_ccode_identifier_new (_tmp689_);
					_tmp691_ = _tmp690_;
					vala_map_set ((ValaMap*) _tmp685_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp686_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp691_);
					_vala_ccode_node_unref0 (_tmp691_);
					_g_free0 (_tmp689_);
					_tmp692_ = type_param_index;
					type_param_index = _tmp692_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp693_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp693_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp694_;
		ValaExpression* _tmp695_;
		ValaExpression* _tmp696_;
		ValaDataType* _tmp697_;
		ValaDataType* _tmp698_;
		ValaArrayType* _tmp699_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp700_;
		ValaCCodeIdentifier* _tmp701_;
		ValaCCodeFunctionCall* _tmp702_;
		ValaCCodeFunctionCall* _tmp703_;
		ValaCCodeFunctionCall* _tmp704_;
		ValaArrayType* _tmp705_;
		ValaDataType* _tmp706_;
		ValaDataType* _tmp707_;
		gchar* _tmp708_;
		gchar* _tmp709_;
		ValaCCodeIdentifier* _tmp710_;
		ValaCCodeIdentifier* _tmp711_;
		ValaHashMap* _tmp712_;
		ValaCCodeFunctionCall* _tmp713_;
		_tmp694_ = ma;
		_tmp695_ = vala_member_access_get_inner (_tmp694_);
		_tmp696_ = _tmp695_;
		_tmp697_ = vala_expression_get_value_type (_tmp696_);
		_tmp698_ = _tmp697_;
		_tmp699_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp698_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp699_;
		_tmp700_ = vala_ccode_identifier_new ("sizeof");
		_tmp701_ = _tmp700_;
		_tmp702_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp701_);
		_tmp703_ = _tmp702_;
		_vala_ccode_node_unref0 (_tmp701_);
		csizeof = _tmp703_;
		_tmp704_ = csizeof;
		_tmp705_ = array_type;
		_tmp706_ = vala_array_type_get_element_type (_tmp705_);
		_tmp707_ = _tmp706_;
		_tmp708_ = vala_get_ccode_name ((ValaCodeNode*) _tmp707_);
		_tmp709_ = _tmp708_;
		_tmp710_ = vala_ccode_identifier_new (_tmp709_);
		_tmp711_ = _tmp710_;
		vala_ccode_function_call_add_argument (_tmp704_, (ValaCCodeExpression*) _tmp711_);
		_vala_ccode_node_unref0 (_tmp711_);
		_g_free0 (_tmp709_);
		_tmp712_ = in_arg_map;
		_tmp713_ = csizeof;
		vala_map_set ((ValaMap*) _tmp712_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp713_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp714_;
		_tmp714_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp714_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp715_;
			gint param_nr = 0;
			ValaMethod* _tmp777_;
			_tmp715_ = m;
			vala_method_clear_parameters (_tmp715_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp716_;
				ValaList* _tmp717_;
				gint _arg_size = 0;
				ValaList* _tmp718_;
				gint _tmp719_;
				gint _tmp720_;
				gint _arg_index = 0;
				_tmp716_ = vala_method_call_get_argument_list (expr);
				_tmp717_ = _vala_iterable_ref0 (_tmp716_);
				_arg_list = _tmp717_;
				_tmp718_ = _arg_list;
				_tmp719_ = vala_collection_get_size ((ValaCollection*) _tmp718_);
				_tmp720_ = _tmp719_;
				_arg_size = _tmp720_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp721_;
					gpointer _tmp722_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp723_;
					ValaUnaryExpression* _tmp724_;
					gboolean _tmp725_ = FALSE;
					ValaUnaryExpression* _tmp726_;
					gint _tmp767_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp721_ = _arg_list;
					_tmp722_ = vala_list_get (_tmp721_, _arg_index);
					arg = (ValaExpression*) _tmp722_;
					_tmp723_ = arg;
					_tmp724_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp723_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp723_) : NULL);
					unary = _tmp724_;
					_tmp726_ = unary;
					if (_tmp726_ != NULL) {
						ValaUnaryExpression* _tmp727_;
						ValaUnaryOperator _tmp728_;
						ValaUnaryOperator _tmp729_;
						_tmp727_ = unary;
						_tmp728_ = vala_unary_expression_get_operator (_tmp727_);
						_tmp729_ = _tmp728_;
						_tmp725_ = _tmp729_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp725_ = FALSE;
					}
					if (_tmp725_) {
						ValaParameter* param = NULL;
						gchar* _tmp730_;
						gchar* _tmp731_;
						ValaUnaryExpression* _tmp732_;
						ValaExpression* _tmp733_;
						ValaExpression* _tmp734_;
						ValaDataType* _tmp735_;
						ValaDataType* _tmp736_;
						ValaParameter* _tmp737_;
						ValaParameter* _tmp738_;
						ValaParameter* _tmp739_;
						ValaMethod* _tmp740_;
						ValaParameter* _tmp741_;
						_tmp730_ = g_strdup_printf ("param%d", param_nr);
						_tmp731_ = _tmp730_;
						_tmp732_ = unary;
						_tmp733_ = vala_unary_expression_get_inner (_tmp732_);
						_tmp734_ = _tmp733_;
						_tmp735_ = vala_expression_get_value_type (_tmp734_);
						_tmp736_ = _tmp735_;
						_tmp737_ = vala_parameter_new (_tmp731_, _tmp736_, NULL);
						_tmp738_ = _tmp737_;
						_g_free0 (_tmp731_);
						param = _tmp738_;
						_tmp739_ = param;
						vala_parameter_set_direction (_tmp739_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp740_ = m;
						_tmp741_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp740_, _tmp741_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp742_ = FALSE;
						ValaUnaryExpression* _tmp743_;
						_tmp743_ = unary;
						if (_tmp743_ != NULL) {
							ValaUnaryExpression* _tmp744_;
							ValaUnaryOperator _tmp745_;
							ValaUnaryOperator _tmp746_;
							_tmp744_ = unary;
							_tmp745_ = vala_unary_expression_get_operator (_tmp744_);
							_tmp746_ = _tmp745_;
							_tmp742_ = _tmp746_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp742_ = FALSE;
						}
						if (_tmp742_) {
							ValaParameter* param = NULL;
							gchar* _tmp747_;
							gchar* _tmp748_;
							ValaUnaryExpression* _tmp749_;
							ValaExpression* _tmp750_;
							ValaExpression* _tmp751_;
							ValaDataType* _tmp752_;
							ValaDataType* _tmp753_;
							ValaParameter* _tmp754_;
							ValaParameter* _tmp755_;
							ValaParameter* _tmp756_;
							ValaMethod* _tmp757_;
							ValaParameter* _tmp758_;
							_tmp747_ = g_strdup_printf ("param%d", param_nr);
							_tmp748_ = _tmp747_;
							_tmp749_ = unary;
							_tmp750_ = vala_unary_expression_get_inner (_tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = vala_expression_get_value_type (_tmp751_);
							_tmp753_ = _tmp752_;
							_tmp754_ = vala_parameter_new (_tmp748_, _tmp753_, NULL);
							_tmp755_ = _tmp754_;
							_g_free0 (_tmp748_);
							param = _tmp755_;
							_tmp756_ = param;
							vala_parameter_set_direction (_tmp756_, VALA_PARAMETER_DIRECTION_REF);
							_tmp757_ = m;
							_tmp758_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp757_, _tmp758_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp759_;
							gchar* _tmp760_;
							gchar* _tmp761_;
							ValaExpression* _tmp762_;
							ValaDataType* _tmp763_;
							ValaDataType* _tmp764_;
							ValaParameter* _tmp765_;
							ValaParameter* _tmp766_;
							_tmp759_ = m;
							_tmp760_ = g_strdup_printf ("param%d", param_nr);
							_tmp761_ = _tmp760_;
							_tmp762_ = arg;
							_tmp763_ = vala_expression_get_value_type (_tmp762_);
							_tmp764_ = _tmp763_;
							_tmp765_ = vala_parameter_new (_tmp761_, _tmp764_, NULL);
							_tmp766_ = _tmp765_;
							vala_callable_add_parameter ((ValaCallable*) _tmp759_, _tmp766_);
							_vala_code_node_unref0 (_tmp766_);
							_g_free0 (_tmp761_);
						}
					}
					_tmp767_ = param_nr;
					param_nr = _tmp767_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp768_;
				ValaList* _tmp769_;
				ValaList* _tmp770_;
				gint _param_size = 0;
				ValaList* _tmp771_;
				gint _tmp772_;
				gint _tmp773_;
				gint _param_index = 0;
				_tmp768_ = m;
				_tmp769_ = vala_callable_get_parameters ((ValaCallable*) _tmp768_);
				_tmp770_ = _vala_iterable_ref0 (_tmp769_);
				_param_list = _tmp770_;
				_tmp771_ = _param_list;
				_tmp772_ = vala_collection_get_size ((ValaCollection*) _tmp771_);
				_tmp773_ = _tmp772_;
				_param_size = _tmp773_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp774_;
					gpointer _tmp775_;
					ValaParameter* _tmp776_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp774_ = _param_list;
					_tmp775_ = vala_list_get (_tmp774_, _param_index);
					param = (ValaParameter*) _tmp775_;
					_tmp776_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp776_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp777_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp777_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp778_ = FALSE;
			gboolean _tmp779_ = FALSE;
			ValaMethod* _tmp780_;
			_tmp780_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp780_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp781_;
				ValaCodeContext* _tmp782_;
				ValaProfile _tmp783_;
				ValaProfile _tmp784_;
				_tmp781_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp782_ = _tmp781_;
				_tmp783_ = vala_code_context_get_profile (_tmp782_);
				_tmp784_ = _tmp783_;
				_tmp779_ = _tmp784_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp779_ = FALSE;
			}
			if (_tmp779_) {
				ValaMethod* _tmp785_;
				ValaSymbol* _tmp786_;
				ValaSymbol* _tmp787_;
				_tmp785_ = m;
				_tmp786_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp785_);
				_tmp787_ = _tmp786_;
				_tmp778_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp787_, VALA_TYPE_CLASS);
			} else {
				_tmp778_ = FALSE;
			}
			if (_tmp778_) {
				ValaCCodeFunction* _tmp788_;
				ValaCCodeFunction* _tmp789_;
				ValaCCodeExpression* _tmp790_;
				ValaCCodeExpression* _tmp791_;
				ValaCCodeFunctionCall* _tmp792_;
				ValaClass* _tmp793_;
				ValaClass* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				gchar* _tmp798_;
				ValaCCodeCastExpression* _tmp799_;
				ValaCCodeCastExpression* _tmp800_;
				ValaMethod* _tmp801_;
				ValaMethod* _tmp802_;
				ValaBlock* _tmp803_;
				ValaBlock* _tmp804_;
				gboolean _tmp805_;
				gboolean _tmp806_;
				gboolean _tmp833_ = FALSE;
				ValaClass* _tmp834_;
				ValaClass* _tmp835_;
				gboolean _tmp836_;
				gboolean _tmp837_;
				_tmp788_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp789_ = _tmp788_;
				_tmp790_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp791_ = _tmp790_;
				_tmp792_ = ccall;
				_tmp793_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp794_ = _tmp793_;
				_tmp795_ = vala_get_ccode_name ((ValaCodeNode*) _tmp794_);
				_tmp796_ = _tmp795_;
				_tmp797_ = g_strconcat (_tmp796_, "*", NULL);
				_tmp798_ = _tmp797_;
				_tmp799_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp792_, _tmp798_);
				_tmp800_ = _tmp799_;
				vala_ccode_function_add_assignment (_tmp789_, _tmp791_, (ValaCCodeExpression*) _tmp800_);
				_vala_ccode_node_unref0 (_tmp800_);
				_g_free0 (_tmp798_);
				_g_free0 (_tmp796_);
				_vala_ccode_node_unref0 (_tmp791_);
				_tmp801_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp802_ = _tmp801_;
				_tmp803_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp802_);
				_tmp804_ = _tmp803_;
				_tmp805_ = vala_block_get_captured (_tmp804_);
				_tmp806_ = _tmp805_;
				if (_tmp806_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp807_;
					ValaClass* _tmp808_;
					ValaObjectType* _tmp809_;
					ValaObjectType* _tmp810_;
					ValaSourceReference* _tmp811_;
					ValaSourceReference* _tmp812_;
					ValaCCodeExpression* _tmp813_;
					ValaCCodeExpression* _tmp814_;
					ValaCCodeFunctionCall* _tmp815_;
					ValaCCodeFunctionCall* _tmp816_;
					ValaCCodeFunctionCall* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeExpression* _tmp819_;
					ValaCCodeFunction* _tmp820_;
					ValaCCodeFunction* _tmp821_;
					ValaMethod* _tmp822_;
					ValaMethod* _tmp823_;
					ValaBlock* _tmp824_;
					ValaBlock* _tmp825_;
					gchar* _tmp826_;
					gchar* _tmp827_;
					ValaCCodeExpression* _tmp828_;
					ValaCCodeExpression* _tmp829_;
					ValaCCodeMemberAccess* _tmp830_;
					ValaCCodeMemberAccess* _tmp831_;
					ValaCCodeFunctionCall* _tmp832_;
					_tmp807_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp808_ = _tmp807_;
					_tmp809_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp808_);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp812_ = _tmp811_;
					_tmp813_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp810_, _tmp812_, FALSE);
					_tmp814_ = _tmp813_;
					_tmp815_ = vala_ccode_function_call_new (_tmp814_);
					_tmp816_ = _tmp815_;
					_vala_ccode_node_unref0 (_tmp814_);
					_vala_code_node_unref0 (_tmp810_);
					ref_call = _tmp816_;
					_tmp817_ = ref_call;
					_tmp818_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp819_ = _tmp818_;
					vala_ccode_function_call_add_argument (_tmp817_, _tmp819_);
					_vala_ccode_node_unref0 (_tmp819_);
					_tmp820_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp821_ = _tmp820_;
					_tmp822_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp823_ = _tmp822_;
					_tmp824_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp823_);
					_tmp825_ = _tmp824_;
					_tmp826_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp825_));
					_tmp827_ = _tmp826_;
					_tmp828_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp827_);
					_tmp829_ = _tmp828_;
					_tmp830_ = vala_ccode_member_access_new_pointer (_tmp829_, "self");
					_tmp831_ = _tmp830_;
					_tmp832_ = ref_call;
					vala_ccode_function_add_assignment (_tmp821_, (ValaCCodeExpression*) _tmp831_, (ValaCCodeExpression*) _tmp832_);
					_vala_ccode_node_unref0 (_tmp831_);
					_vala_ccode_node_unref0 (_tmp829_);
					_g_free0 (_tmp827_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp834_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp835_ = _tmp834_;
				_tmp836_ = vala_class_get_is_compact (_tmp835_);
				_tmp837_ = _tmp836_;
				if (!_tmp837_) {
					ValaClass* _tmp838_;
					ValaClass* _tmp839_;
					_tmp838_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp839_ = _tmp838_;
					_tmp833_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp839_);
				} else {
					_tmp833_ = FALSE;
				}
				if (_tmp833_) {
					gchar** suffices = NULL;
					gchar* _tmp840_;
					gchar* _tmp841_;
					gchar* _tmp842_;
					gchar** _tmp843_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp840_ = g_strdup ("type");
					_tmp841_ = g_strdup ("dup_func");
					_tmp842_ = g_strdup ("destroy_func");
					_tmp843_ = g_new0 (gchar*, 3 + 1);
					_tmp843_[0] = _tmp840_;
					_tmp843_[1] = _tmp841_;
					_tmp843_[2] = _tmp842_;
					suffices = _tmp843_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp844_;
						ValaClass* _tmp845_;
						ValaList* _tmp846_;
						ValaList* _tmp847_;
						gint _type_param_size = 0;
						ValaList* _tmp848_;
						gint _tmp849_;
						gint _tmp850_;
						gint _type_param_index = 0;
						_tmp844_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp845_ = _tmp844_;
						_tmp846_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp845_);
						_tmp847_ = _vala_iterable_ref0 (_tmp846_);
						_type_param_list = _tmp847_;
						_tmp848_ = _type_param_list;
						_tmp849_ = vala_collection_get_size ((ValaCollection*) _tmp848_);
						_tmp850_ = _tmp849_;
						_type_param_size = _tmp850_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp851_;
							gpointer _tmp852_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp853_;
							ValaCCodeIdentifier* _tmp854_;
							ValaCCodeMemberAccess* _tmp855_;
							ValaCCodeMemberAccess* _tmp856_;
							gchar** _tmp857_;
							gint _tmp857__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp851_ = _type_param_list;
							_tmp852_ = vala_list_get (_tmp851_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp852_;
							_tmp853_ = vala_ccode_identifier_new ("self");
							_tmp854_ = _tmp853_;
							_tmp855_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp854_, "priv");
							_tmp856_ = _tmp855_;
							_vala_ccode_node_unref0 (_tmp854_);
							priv_access = _tmp856_;
							_tmp857_ = suffices;
							_tmp857__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp857_;
								suffix_collection_length1 = _tmp857__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp858_;
									gchar* suffix = NULL;
									_tmp858_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp858_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp859_;
										const gchar* _tmp860_;
										const gchar* _tmp861_;
										gchar* _tmp862_;
										gchar* _tmp863_;
										const gchar* _tmp864_;
										gchar* _tmp865_;
										gchar* _tmp866_;
										ValaCCodeIdentifier* _tmp867_;
										ValaCCodeIdentifier* _tmp868_;
										ValaCCodeFunction* _tmp869_;
										ValaCCodeFunction* _tmp870_;
										ValaCCodeMemberAccess* _tmp871_;
										ValaCCodeIdentifier* _tmp872_;
										const gchar* _tmp873_;
										const gchar* _tmp874_;
										ValaCCodeMemberAccess* _tmp875_;
										ValaCCodeMemberAccess* _tmp876_;
										ValaCCodeIdentifier* _tmp877_;
										_tmp859_ = type_param;
										_tmp860_ = vala_symbol_get_name ((ValaSymbol*) _tmp859_);
										_tmp861_ = _tmp860_;
										_tmp862_ = g_utf8_strdown (_tmp861_, (gssize) -1);
										_tmp863_ = _tmp862_;
										_tmp864_ = suffix;
										_tmp865_ = g_strdup_printf ("%s_%s", _tmp863_, _tmp864_);
										_tmp866_ = _tmp865_;
										_tmp867_ = vala_ccode_identifier_new (_tmp866_);
										_tmp868_ = _tmp867_;
										_g_free0 (_tmp866_);
										_g_free0 (_tmp863_);
										param_name = _tmp868_;
										_tmp869_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp870_ = _tmp869_;
										_tmp871_ = priv_access;
										_tmp872_ = param_name;
										_tmp873_ = vala_ccode_identifier_get_name (_tmp872_);
										_tmp874_ = _tmp873_;
										_tmp875_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp871_, _tmp874_);
										_tmp876_ = _tmp875_;
										_tmp877_ = param_name;
										vala_ccode_function_add_assignment (_tmp870_, (ValaCCodeExpression*) _tmp876_, (ValaCCodeExpression*) _tmp877_);
										_vala_ccode_node_unref0 (_tmp876_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp878_ = params;
	_tmp879_ = vala_iterable_iterator ((ValaIterable*) _tmp878_);
	params_it = _tmp879_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp880_;
		ValaList* _tmp881_;
		gint _arg_size = 0;
		ValaList* _tmp882_;
		gint _tmp883_;
		gint _tmp884_;
		gint _arg_index = 0;
		_tmp880_ = vala_method_call_get_argument_list (expr);
		_tmp881_ = _vala_iterable_ref0 (_tmp880_);
		_arg_list = _tmp881_;
		_tmp882_ = _arg_list;
		_tmp883_ = vala_collection_get_size ((ValaCollection*) _tmp882_);
		_tmp884_ = _tmp883_;
		_arg_size = _tmp884_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp885_;
			gpointer _tmp886_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp887_;
			ValaCCodeExpression* _tmp888_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp889_;
			ValaHashMap* _tmp890_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp891_;
			gboolean _tmp901_ = FALSE;
			ValaParameter* _tmp902_;
			gdouble _tmp1248_ = 0.0;
			ValaParameter* _tmp1249_;
			ValaHashMap* _tmp1251_;
			ValaCCodeExpression* _tmp1252_;
			gboolean _tmp1253_ = FALSE;
			ValaMethod* _tmp1254_;
			gboolean _tmp1279_ = FALSE;
			ValaExpression* _tmp1280_;
			gint _tmp1297_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp885_ = _arg_list;
			_tmp886_ = vala_list_get (_tmp885_, _arg_index);
			arg = (ValaExpression*) _tmp886_;
			_tmp887_ = arg;
			_tmp888_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp887_);
			cexpr = _tmp888_;
			_tmp889_ = in_arg_map;
			_tmp890_ = _vala_map_ref0 (_tmp889_);
			carg_map = _tmp890_;
			param = NULL;
			_tmp891_ = params_it;
			if (vala_iterator_next (_tmp891_)) {
				ValaIterator* _tmp892_;
				gpointer _tmp893_;
				gboolean _tmp894_ = FALSE;
				ValaParameter* _tmp895_;
				gboolean _tmp896_;
				gboolean _tmp897_;
				_tmp892_ = params_it;
				_tmp893_ = vala_iterator_get (_tmp892_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp893_;
				_tmp895_ = param;
				_tmp896_ = vala_parameter_get_params_array (_tmp895_);
				_tmp897_ = _tmp896_;
				if (_tmp897_) {
					_tmp894_ = TRUE;
				} else {
					ValaParameter* _tmp898_;
					gboolean _tmp899_;
					gboolean _tmp900_;
					_tmp898_ = param;
					_tmp899_ = vala_parameter_get_ellipsis (_tmp898_);
					_tmp900_ = _tmp899_;
					_tmp894_ = _tmp900_;
				}
				ellipsis = _tmp894_;
			}
			_tmp902_ = param;
			if (_tmp902_ != NULL) {
				_tmp901_ = !ellipsis;
			} else {
				_tmp901_ = FALSE;
			}
			if (_tmp901_) {
				ValaParameter* _tmp903_;
				ValaParameterDirection _tmp904_;
				ValaParameterDirection _tmp905_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp908_;
				ValaUnaryExpression* _tmp909_;
				gboolean _tmp910_ = FALSE;
				ValaUnaryExpression* _tmp911_;
				ValaParameter* _tmp1177_;
				gchar* _tmp1178_;
				gchar* _tmp1179_;
				gboolean _tmp1180_;
				_tmp903_ = param;
				_tmp904_ = vala_parameter_get_direction (_tmp903_);
				_tmp905_ = _tmp904_;
				if (_tmp905_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp906_;
					ValaHashMap* _tmp907_;
					_tmp906_ = out_arg_map;
					_tmp907_ = _vala_map_ref0 (_tmp906_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp907_;
				}
				_tmp908_ = arg;
				_tmp909_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp908_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp908_) : NULL);
				unary = _tmp909_;
				_tmp911_ = unary;
				if (_tmp911_ == NULL) {
					_tmp910_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp912_;
					ValaUnaryOperator _tmp913_;
					ValaUnaryOperator _tmp914_;
					_tmp912_ = unary;
					_tmp913_ = vala_unary_expression_get_operator (_tmp912_);
					_tmp914_ = _tmp913_;
					_tmp910_ = _tmp914_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp910_) {
					gboolean _tmp915_ = FALSE;
					gboolean _tmp916_ = FALSE;
					ValaParameter* _tmp917_;
					ValaParameter* _tmp1051_;
					ValaExpression* _tmp1052_;
					ValaCCodeExpression* _tmp1053_;
					ValaCCodeExpression* _tmp1054_;
					_tmp917_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp917_)) {
						ValaParameter* _tmp918_;
						ValaDataType* _tmp919_;
						ValaDataType* _tmp920_;
						_tmp918_ = param;
						_tmp919_ = vala_variable_get_variable_type ((ValaVariable*) _tmp918_);
						_tmp920_ = _tmp919_;
						_tmp916_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp920_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp916_ = FALSE;
					}
					if (_tmp916_) {
						ValaParameter* _tmp921_;
						ValaDataType* _tmp922_;
						ValaDataType* _tmp923_;
						gboolean _tmp924_;
						gboolean _tmp925_;
						_tmp921_ = param;
						_tmp922_ = vala_variable_get_variable_type ((ValaVariable*) _tmp921_);
						_tmp923_ = _tmp922_;
						_tmp924_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp923_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp925_ = _tmp924_;
						_tmp915_ = !_tmp925_;
					} else {
						_tmp915_ = FALSE;
					}
					if (_tmp915_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp926_;
						ValaDataType* _tmp927_;
						ValaDataType* _tmp928_;
						ValaArrayType* _tmp929_;
						gchar* _tmp930_ = NULL;
						ValaParameter* _tmp931_;
						gchar* _tmp932_;
						gchar* length_ctype = NULL;
						gchar* _tmp935_;
						gboolean _tmp936_ = FALSE;
						ValaUnaryExpression* _tmp937_;
						_tmp926_ = param;
						_tmp927_ = vala_variable_get_variable_type ((ValaVariable*) _tmp926_);
						_tmp928_ = _tmp927_;
						_tmp929_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp928_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp929_;
						_tmp931_ = param;
						_tmp932_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp931_);
						_tmp930_ = _tmp932_;
						if (_tmp930_ == NULL) {
							ValaArrayType* _tmp933_;
							gchar* _tmp934_;
							_tmp933_ = array_type;
							_tmp934_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp933_);
							_g_free0 (_tmp930_);
							_tmp930_ = _tmp934_;
						}
						_tmp935_ = _tmp930_;
						_tmp930_ = NULL;
						length_ctype = _tmp935_;
						_tmp937_ = unary;
						if (_tmp937_ != NULL) {
							ValaUnaryExpression* _tmp938_;
							ValaUnaryOperator _tmp939_;
							ValaUnaryOperator _tmp940_;
							_tmp938_ = unary;
							_tmp939_ = vala_unary_expression_get_operator (_tmp938_);
							_tmp940_ = _tmp939_;
							_tmp936_ = _tmp940_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp936_ = FALSE;
						}
						if (_tmp936_) {
							const gchar* _tmp941_;
							gchar* _tmp942_;
							_tmp941_ = length_ctype;
							_tmp942_ = g_strdup_printf ("%s*", _tmp941_);
							_g_free0 (length_ctype);
							length_ctype = _tmp942_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp943_ = FALSE;
								_tmp943_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp945_;
									gint _tmp946_;
									gint _tmp947_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp948_;
									ValaCCodeExpression* _tmp949_;
									ValaCCodeExpression* _tmp950_;
									const gchar* _tmp951_;
									ValaCCodeCastExpression* _tmp952_;
									ValaCCodeCastExpression* _tmp953_;
									ValaHashMap* _tmp954_;
									ValaParameter* _tmp955_;
									ValaCCodeCastExpression* _tmp956_;
									if (!_tmp943_) {
										gint _tmp944_;
										_tmp944_ = dim;
										dim = _tmp944_ + 1;
									}
									_tmp943_ = FALSE;
									_tmp945_ = array_type;
									_tmp946_ = vala_array_type_get_rank (_tmp945_);
									_tmp947_ = _tmp946_;
									if (!(dim <= _tmp947_)) {
										break;
									}
									_tmp948_ = arg;
									_tmp949_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp948_, dim);
									_tmp950_ = _tmp949_;
									_tmp951_ = length_ctype;
									_tmp952_ = vala_ccode_cast_expression_new (_tmp950_, _tmp951_);
									_tmp953_ = _tmp952_;
									_vala_ccode_node_unref0 (_tmp950_);
									array_length_expr = _tmp953_;
									_tmp954_ = carg_map;
									_tmp955_ = param;
									_tmp956_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp954_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp955_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp956_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp930_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp957_;
						ValaDataType* _tmp958_;
						ValaDataType* _tmp959_;
						_tmp957_ = param;
						_tmp958_ = vala_variable_get_variable_type ((ValaVariable*) _tmp957_);
						_tmp959_ = _tmp958_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp959_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp960_;
							ValaDataType* _tmp961_;
							ValaDataType* _tmp962_;
							ValaDelegateType* _tmp963_;
							ValaDelegateType* _tmp964_;
							ValaDelegate* _tmp965_;
							ValaDelegate* _tmp966_;
							gboolean _tmp967_;
							gboolean _tmp968_;
							_tmp960_ = param;
							_tmp961_ = vala_variable_get_variable_type ((ValaVariable*) _tmp960_);
							_tmp962_ = _tmp961_;
							_tmp963_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp962_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp963_;
							_tmp964_ = deleg_type;
							_tmp965_ = vala_delegate_type_get_delegate_symbol (_tmp964_);
							_tmp966_ = _tmp965_;
							_tmp967_ = vala_delegate_get_has_target (_tmp966_);
							_tmp968_ = _tmp967_;
							if (_tmp968_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp969_;
								ValaCCodeExpression* _tmp970_ = NULL;
								ValaCCodeExpression* _tmp971_;
								ValaCCodeExpression* _tmp972_;
								ValaParameter* _tmp973_;
								gchar* _tmp974_;
								gchar* _tmp975_;
								gboolean _tmp976_;
								_tmp969_ = arg;
								_tmp971_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp969_, &_tmp970_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp970_;
								delegate_target = _tmp971_;
								_tmp972_ = delegate_target;
								_vala_assert (_tmp972_ != NULL, "delegate_target != null");
								_tmp973_ = param;
								_tmp974_ = vala_get_ccode_type ((ValaCodeNode*) _tmp973_);
								_tmp975_ = _tmp974_;
								_tmp976_ = g_strcmp0 (_tmp975_, "GClosure*") == 0;
								_g_free0 (_tmp975_);
								if (_tmp976_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp977_;
									ValaCCodeIdentifier* _tmp978_;
									ValaCCodeFunctionCall* _tmp979_;
									ValaCCodeFunctionCall* _tmp980_;
									ValaCCodeFunctionCall* _tmp981_;
									ValaCCodeExpression* _tmp982_;
									ValaCCodeCastExpression* _tmp983_;
									ValaCCodeCastExpression* _tmp984_;
									ValaCCodeFunctionCall* _tmp985_;
									ValaCCodeExpression* _tmp986_;
									ValaCCodeFunctionCall* _tmp987_;
									ValaCCodeExpression* _tmp988_;
									ValaCCodeCastExpression* _tmp989_;
									ValaCCodeCastExpression* _tmp990_;
									ValaCCodeExpression* _tmp991_;
									ValaCCodeIdentifier* _tmp992_;
									ValaCCodeIdentifier* _tmp993_;
									ValaCCodeBinaryExpression* _tmp994_;
									ValaCCodeBinaryExpression* _tmp995_;
									ValaCCodeIdentifier* _tmp996_;
									ValaCCodeIdentifier* _tmp997_;
									ValaCCodeFunctionCall* _tmp998_;
									ValaCCodeConditionalExpression* _tmp999_;
									_tmp977_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp978_ = _tmp977_;
									_tmp979_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp978_);
									_tmp980_ = _tmp979_;
									_vala_ccode_node_unref0 (_tmp978_);
									closure_new = _tmp980_;
									_tmp981_ = closure_new;
									_tmp982_ = cexpr;
									_tmp983_ = vala_ccode_cast_expression_new (_tmp982_, "GCallback");
									_tmp984_ = _tmp983_;
									vala_ccode_function_call_add_argument (_tmp981_, (ValaCCodeExpression*) _tmp984_);
									_vala_ccode_node_unref0 (_tmp984_);
									_tmp985_ = closure_new;
									_tmp986_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp985_, _tmp986_);
									_tmp987_ = closure_new;
									_tmp988_ = delegate_target_destroy_notify;
									_tmp989_ = vala_ccode_cast_expression_new (_tmp988_, "GClosureNotify");
									_tmp990_ = _tmp989_;
									vala_ccode_function_call_add_argument (_tmp987_, (ValaCCodeExpression*) _tmp990_);
									_vala_ccode_node_unref0 (_tmp990_);
									_tmp991_ = cexpr;
									_tmp992_ = vala_ccode_identifier_new ("NULL");
									_tmp993_ = _tmp992_;
									_tmp994_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp991_, (ValaCCodeExpression*) _tmp993_);
									_tmp995_ = _tmp994_;
									_tmp996_ = vala_ccode_identifier_new ("NULL");
									_tmp997_ = _tmp996_;
									_tmp998_ = closure_new;
									_tmp999_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp995_, (ValaCCodeExpression*) _tmp997_, (ValaCCodeExpression*) _tmp998_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp999_;
									_vala_ccode_node_unref0 (_tmp997_);
									_vala_ccode_node_unref0 (_tmp995_);
									_vala_ccode_node_unref0 (_tmp993_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1000_;
									ValaParameter* _tmp1001_;
									ValaCCodeExpression* _tmp1002_;
									ValaDelegateType* _tmp1003_;
									_tmp1000_ = carg_map;
									_tmp1001_ = param;
									_tmp1002_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1000_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1001_), FALSE)), _tmp1002_);
									_tmp1003_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1003_)) {
										ValaCCodeExpression* _tmp1004_;
										ValaHashMap* _tmp1005_;
										ValaParameter* _tmp1006_;
										ValaCCodeExpression* _tmp1007_;
										_tmp1004_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1004_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1005_ = carg_map;
										_tmp1006_ = param;
										_tmp1007_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1005_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1006_) + 0.01, FALSE)), _tmp1007_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1008_;
							ValaDataType* _tmp1009_;
							ValaDataType* _tmp1010_;
							_tmp1008_ = param;
							_tmp1009_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1008_);
							_tmp1010_ = _tmp1009_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1010_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1011_;
								ValaParameter* _tmp1012_;
								ValaExpression* _tmp1013_;
								ValaCCodeExpression* _tmp1014_ = NULL;
								ValaCCodeExpression* _tmp1015_;
								ValaCCodeExpression* _tmp1016_;
								_tmp1011_ = carg_map;
								_tmp1012_ = param;
								_tmp1013_ = arg;
								_tmp1015_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1013_, &_tmp1014_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1014_;
								_tmp1016_ = _tmp1015_;
								vala_map_set ((ValaMap*) _tmp1011_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1012_), FALSE)), _tmp1016_);
								_vala_ccode_node_unref0 (_tmp1016_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1017_;
								ValaDataType* _tmp1018_;
								ValaDataType* _tmp1019_;
								_tmp1017_ = param;
								_tmp1018_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1017_);
								_tmp1019_ = _tmp1018_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1019_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1020_ = FALSE;
									ValaMethod* _tmp1021_;
									_tmp1021_ = m;
									if (_tmp1021_ != NULL) {
										ValaMethod* _tmp1022_;
										_tmp1022_ = m;
										_tmp1020_ = vala_get_ccode_simple_generics (_tmp1022_);
									} else {
										_tmp1020_ = FALSE;
									}
									if (_tmp1020_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1023_;
										ValaDataType* _tmp1024_;
										ValaDataType* _tmp1025_;
										ValaGenericType* _tmp1026_;
										gint type_param_index = 0;
										ValaMethod* _tmp1027_;
										ValaGenericType* _tmp1028_;
										ValaTypeParameter* _tmp1029_;
										ValaTypeParameter* _tmp1030_;
										const gchar* _tmp1031_;
										const gchar* _tmp1032_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1033_;
										ValaList* _tmp1034_;
										gpointer _tmp1035_;
										ValaParameter* _tmp1036_;
										ValaDataType* _tmp1037_;
										ValaDataType* _tmp1038_;
										gboolean _tmp1039_;
										gboolean _tmp1040_;
										_tmp1023_ = param;
										_tmp1024_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1023_);
										_tmp1025_ = _tmp1024_;
										_tmp1026_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1025_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1026_;
										_tmp1027_ = m;
										_tmp1028_ = generic_type;
										_tmp1029_ = vala_generic_type_get_type_parameter (_tmp1028_);
										_tmp1030_ = _tmp1029_;
										_tmp1031_ = vala_symbol_get_name ((ValaSymbol*) _tmp1030_);
										_tmp1032_ = _tmp1031_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1027_, _tmp1032_);
										_tmp1033_ = ma;
										_tmp1034_ = vala_member_access_get_type_arguments (_tmp1033_);
										_tmp1035_ = vala_list_get (_tmp1034_, type_param_index);
										type_arg = (ValaDataType*) _tmp1035_;
										_tmp1036_ = param;
										_tmp1037_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1036_);
										_tmp1038_ = _tmp1037_;
										_tmp1039_ = vala_data_type_get_value_owned (_tmp1038_);
										_tmp1040_ = _tmp1039_;
										if (_tmp1040_) {
											ValaDataType* _tmp1041_;
											_tmp1041_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1041_)) {
												ValaHashMap* _tmp1042_;
												ValaParameter* _tmp1043_;
												ValaDataType* _tmp1044_;
												ValaCCodeExpression* _tmp1045_;
												ValaCCodeExpression* _tmp1046_;
												_tmp1042_ = carg_map;
												_tmp1043_ = param;
												_tmp1044_ = type_arg;
												_tmp1045_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1044_, FALSE);
												_tmp1046_ = _tmp1045_;
												vala_map_set ((ValaMap*) _tmp1042_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1043_), FALSE)), _tmp1046_);
												_vala_ccode_node_unref0 (_tmp1046_);
											} else {
												ValaHashMap* _tmp1047_;
												ValaParameter* _tmp1048_;
												ValaCCodeConstant* _tmp1049_;
												ValaCCodeConstant* _tmp1050_;
												_tmp1047_ = carg_map;
												_tmp1048_ = param;
												_tmp1049_ = vala_ccode_constant_new ("NULL");
												_tmp1050_ = _tmp1049_;
												vala_map_set ((ValaMap*) _tmp1047_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1048_), FALSE)), (ValaCCodeExpression*) _tmp1050_);
												_vala_ccode_node_unref0 (_tmp1050_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1051_ = param;
					_tmp1052_ = arg;
					_tmp1053_ = cexpr;
					_tmp1054_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1051_, _tmp1052_, _tmp1053_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1054_;
				} else {
					ValaExpression* _tmp1055_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1056_;
					ValaDataType* _tmp1057_;
					ValaDataType* _tmp1058_;
					ValaParameter* _tmp1059_;
					ValaDataType* _tmp1060_;
					ValaDataType* _tmp1061_;
					gboolean _tmp1062_;
					gboolean _tmp1063_;
					ValaLocalVariable* _tmp1064_;
					ValaLocalVariable* _tmp1065_;
					ValaExpression* _tmp1066_;
					ValaLocalVariable* _tmp1067_;
					const gchar* _tmp1068_;
					const gchar* _tmp1069_;
					ValaCCodeExpression* _tmp1070_;
					ValaCCodeExpression* _tmp1071_;
					ValaExpression* _tmp1072_;
					ValaTargetValue* _tmp1073_;
					ValaTargetValue* _tmp1074_;
					ValaExpression* _tmp1075_;
					ValaDataType* _tmp1076_;
					ValaDataType* _tmp1077_;
					ValaExpression* _tmp1078_;
					ValaCCodeExpression* _tmp1079_;
					ValaCCodeExpression* _tmp1080_;
					ValaCCodeUnaryExpression* _tmp1081_;
					gboolean _tmp1082_ = FALSE;
					gboolean _tmp1083_ = FALSE;
					ValaParameter* _tmp1084_;
					_tmp1055_ = arg;
					vala_expression_set_target_value (_tmp1055_, NULL);
					_tmp1056_ = param;
					_tmp1057_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1056_);
					_tmp1058_ = _tmp1057_;
					_tmp1059_ = param;
					_tmp1060_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1059_);
					_tmp1061_ = _tmp1060_;
					_tmp1062_ = vala_data_type_get_value_owned (_tmp1061_);
					_tmp1063_ = _tmp1062_;
					_tmp1064_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1058_, _tmp1063_, NULL, TRUE);
					temp_var = _tmp1064_;
					_tmp1065_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1065_, FALSE);
					_tmp1066_ = arg;
					_tmp1067_ = temp_var;
					_tmp1068_ = vala_symbol_get_name ((ValaSymbol*) _tmp1067_);
					_tmp1069_ = _tmp1068_;
					_tmp1070_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1069_);
					_tmp1071_ = _tmp1070_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1066_, _tmp1071_);
					_vala_ccode_node_unref0 (_tmp1071_);
					_tmp1072_ = arg;
					_tmp1073_ = vala_expression_get_target_value (_tmp1072_);
					_tmp1074_ = _tmp1073_;
					_tmp1075_ = arg;
					_tmp1076_ = vala_expression_get_target_type (_tmp1075_);
					_tmp1077_ = _tmp1076_;
					vala_target_value_set_value_type (_tmp1074_, _tmp1077_);
					_tmp1078_ = arg;
					_tmp1079_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1078_);
					_tmp1080_ = _tmp1079_;
					_tmp1081_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1080_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1081_;
					_vala_ccode_node_unref0 (_tmp1080_);
					_tmp1084_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1084_)) {
						ValaParameter* _tmp1085_;
						ValaDataType* _tmp1086_;
						ValaDataType* _tmp1087_;
						_tmp1085_ = param;
						_tmp1086_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1085_);
						_tmp1087_ = _tmp1086_;
						_tmp1083_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1087_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1083_ = FALSE;
					}
					if (_tmp1083_) {
						ValaParameter* _tmp1088_;
						ValaDataType* _tmp1089_;
						ValaDataType* _tmp1090_;
						gboolean _tmp1091_;
						gboolean _tmp1092_;
						_tmp1088_ = param;
						_tmp1089_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1088_);
						_tmp1090_ = _tmp1089_;
						_tmp1091_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1090_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1092_ = _tmp1091_;
						_tmp1082_ = !_tmp1092_;
					} else {
						_tmp1082_ = FALSE;
					}
					if (_tmp1082_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1093_;
						ValaDataType* _tmp1094_;
						ValaDataType* _tmp1095_;
						ValaArrayType* _tmp1096_;
						gchar* _tmp1097_ = NULL;
						ValaParameter* _tmp1098_;
						gchar* _tmp1099_;
						gchar* length_ctype = NULL;
						gchar* _tmp1102_;
						_tmp1093_ = param;
						_tmp1094_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1093_);
						_tmp1095_ = _tmp1094_;
						_tmp1096_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1095_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1096_;
						_tmp1098_ = param;
						_tmp1099_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1098_);
						_tmp1097_ = _tmp1099_;
						if (_tmp1097_ == NULL) {
							ValaArrayType* _tmp1100_;
							gchar* _tmp1101_;
							_tmp1100_ = array_type;
							_tmp1101_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1100_);
							_g_free0 (_tmp1097_);
							_tmp1097_ = _tmp1101_;
						}
						_tmp1102_ = _tmp1097_;
						_tmp1097_ = NULL;
						length_ctype = _tmp1102_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1103_ = FALSE;
								_tmp1103_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1105_;
									gint _tmp1106_;
									gint _tmp1107_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1108_;
									ValaCType* _tmp1109_;
									ValaCType* _tmp1110_;
									ValaLocalVariable* _tmp1111_;
									ValaLocalVariable* _tmp1112_;
									ValaLocalVariable* _tmp1113_;
									ValaExpression* _tmp1114_;
									ValaLocalVariable* _tmp1115_;
									const gchar* _tmp1116_;
									const gchar* _tmp1117_;
									ValaCCodeExpression* _tmp1118_;
									ValaCCodeExpression* _tmp1119_;
									ValaHashMap* _tmp1120_;
									ValaParameter* _tmp1121_;
									ValaExpression* _tmp1122_;
									ValaList* _tmp1123_;
									ValaList* _tmp1124_;
									gpointer _tmp1125_;
									ValaCCodeExpression* _tmp1126_;
									ValaCCodeUnaryExpression* _tmp1127_;
									ValaCCodeUnaryExpression* _tmp1128_;
									if (!_tmp1103_) {
										gint _tmp1104_;
										_tmp1104_ = dim;
										dim = _tmp1104_ + 1;
									}
									_tmp1103_ = FALSE;
									_tmp1105_ = array_type;
									_tmp1106_ = vala_array_type_get_rank (_tmp1105_);
									_tmp1107_ = _tmp1106_;
									if (!(dim <= _tmp1107_)) {
										break;
									}
									_tmp1108_ = length_ctype;
									_tmp1109_ = vala_ctype_new (_tmp1108_, "0");
									_tmp1110_ = _tmp1109_;
									_tmp1111_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1110_, TRUE, NULL, TRUE);
									_tmp1112_ = _tmp1111_;
									_vala_code_node_unref0 (_tmp1110_);
									temp_array_length = _tmp1112_;
									_tmp1113_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1113_, FALSE);
									_tmp1114_ = arg;
									_tmp1115_ = temp_array_length;
									_tmp1116_ = vala_symbol_get_name ((ValaSymbol*) _tmp1115_);
									_tmp1117_ = _tmp1116_;
									_tmp1118_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1117_);
									_tmp1119_ = _tmp1118_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1114_, _tmp1119_);
									_vala_ccode_node_unref0 (_tmp1119_);
									_tmp1120_ = carg_map;
									_tmp1121_ = param;
									_tmp1122_ = arg;
									_tmp1123_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1122_);
									_tmp1124_ = _tmp1123_;
									_tmp1125_ = vala_list_get (_tmp1124_, dim - 1);
									_tmp1126_ = (ValaCCodeExpression*) _tmp1125_;
									_tmp1127_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1126_);
									_tmp1128_ = _tmp1127_;
									vala_map_set ((ValaMap*) _tmp1120_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1121_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1128_);
									_vala_ccode_node_unref0 (_tmp1128_);
									_vala_ccode_node_unref0 (_tmp1126_);
									_vala_iterable_unref0 (_tmp1124_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp1097_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1129_;
						ValaDataType* _tmp1130_;
						ValaDataType* _tmp1131_;
						_tmp1129_ = param;
						_tmp1130_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1129_);
						_tmp1131_ = _tmp1130_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1131_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1132_;
							ValaDataType* _tmp1133_;
							ValaDataType* _tmp1134_;
							ValaDelegateType* _tmp1135_;
							ValaDelegateType* _tmp1136_;
							ValaDelegate* _tmp1137_;
							ValaDelegate* _tmp1138_;
							gboolean _tmp1139_;
							gboolean _tmp1140_;
							_tmp1132_ = param;
							_tmp1133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1132_);
							_tmp1134_ = _tmp1133_;
							_tmp1135_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1134_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1135_;
							_tmp1136_ = deleg_type;
							_tmp1137_ = vala_delegate_type_get_delegate_symbol (_tmp1136_);
							_tmp1138_ = _tmp1137_;
							_tmp1139_ = vala_delegate_get_has_target (_tmp1138_);
							_tmp1140_ = _tmp1139_;
							if (_tmp1140_) {
								ValaVoidType* _tmp1141_;
								ValaVoidType* _tmp1142_;
								ValaPointerType* _tmp1143_;
								ValaPointerType* _tmp1144_;
								ValaLocalVariable* _tmp1145_;
								ValaLocalVariable* _tmp1146_;
								ValaExpression* _tmp1147_;
								ValaLocalVariable* _tmp1148_;
								const gchar* _tmp1149_;
								const gchar* _tmp1150_;
								ValaCCodeExpression* _tmp1151_;
								ValaCCodeExpression* _tmp1152_;
								ValaHashMap* _tmp1153_;
								ValaParameter* _tmp1154_;
								ValaExpression* _tmp1155_;
								ValaCCodeExpression* _tmp1156_;
								ValaCCodeExpression* _tmp1157_;
								ValaCCodeUnaryExpression* _tmp1158_;
								ValaCCodeUnaryExpression* _tmp1159_;
								ValaDelegateType* _tmp1160_;
								_tmp1141_ = vala_void_type_new (NULL);
								_tmp1142_ = _tmp1141_;
								_tmp1143_ = vala_pointer_type_new ((ValaDataType*) _tmp1142_, NULL);
								_tmp1144_ = _tmp1143_;
								_tmp1145_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1144_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1145_;
								_vala_code_node_unref0 (_tmp1144_);
								_vala_code_node_unref0 (_tmp1142_);
								_tmp1146_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1146_, FALSE);
								_tmp1147_ = arg;
								_tmp1148_ = temp_var;
								_tmp1149_ = vala_symbol_get_name ((ValaSymbol*) _tmp1148_);
								_tmp1150_ = _tmp1149_;
								_tmp1151_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1150_);
								_tmp1152_ = _tmp1151_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1147_, _tmp1152_);
								_vala_ccode_node_unref0 (_tmp1152_);
								_tmp1153_ = carg_map;
								_tmp1154_ = param;
								_tmp1155_ = arg;
								_tmp1156_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1155_);
								_tmp1157_ = _tmp1156_;
								_tmp1158_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1157_);
								_tmp1159_ = _tmp1158_;
								vala_map_set ((ValaMap*) _tmp1153_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1154_), FALSE)), (ValaCCodeExpression*) _tmp1159_);
								_vala_ccode_node_unref0 (_tmp1159_);
								_vala_ccode_node_unref0 (_tmp1157_);
								_tmp1160_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1160_)) {
									ValaDataType* _tmp1161_;
									ValaLocalVariable* _tmp1162_;
									ValaLocalVariable* _tmp1163_;
									ValaExpression* _tmp1164_;
									ValaLocalVariable* _tmp1165_;
									const gchar* _tmp1166_;
									const gchar* _tmp1167_;
									ValaCCodeExpression* _tmp1168_;
									ValaCCodeExpression* _tmp1169_;
									ValaHashMap* _tmp1170_;
									ValaParameter* _tmp1171_;
									ValaExpression* _tmp1172_;
									ValaCCodeExpression* _tmp1173_;
									ValaCCodeExpression* _tmp1174_;
									ValaCCodeUnaryExpression* _tmp1175_;
									ValaCCodeUnaryExpression* _tmp1176_;
									_tmp1161_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1162_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1161_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1162_;
									_tmp1163_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1163_, FALSE);
									_tmp1164_ = arg;
									_tmp1165_ = temp_var;
									_tmp1166_ = vala_symbol_get_name ((ValaSymbol*) _tmp1165_);
									_tmp1167_ = _tmp1166_;
									_tmp1168_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1167_);
									_tmp1169_ = _tmp1168_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1164_, _tmp1169_);
									_vala_ccode_node_unref0 (_tmp1169_);
									_tmp1170_ = carg_map;
									_tmp1171_ = param;
									_tmp1172_ = arg;
									_tmp1173_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1172_);
									_tmp1174_ = _tmp1173_;
									_tmp1175_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1174_);
									_tmp1176_ = _tmp1175_;
									vala_map_set ((ValaMap*) _tmp1170_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1171_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1176_);
									_vala_ccode_node_unref0 (_tmp1176_);
									_vala_ccode_node_unref0 (_tmp1174_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1177_ = param;
				_tmp1178_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1177_);
				_tmp1179_ = _tmp1178_;
				_tmp1180_ = _tmp1179_ != NULL;
				_g_free0 (_tmp1179_);
				if (_tmp1180_) {
					ValaCCodeExpression* _tmp1181_;
					ValaParameter* _tmp1182_;
					gchar* _tmp1183_;
					gchar* _tmp1184_;
					ValaCCodeCastExpression* _tmp1185_;
					_tmp1181_ = cexpr;
					_tmp1182_ = param;
					_tmp1183_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1182_);
					_tmp1184_ = _tmp1183_;
					_tmp1185_ = vala_ccode_cast_expression_new (_tmp1181_, _tmp1184_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1185_;
					_g_free0 (_tmp1184_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1186_;
				ValaUnaryExpression* _tmp1187_;
				gboolean _tmp1188_ = FALSE;
				gboolean _tmp1189_ = FALSE;
				_tmp1186_ = arg;
				_tmp1187_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1186_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1186_) : NULL);
				unary = _tmp1187_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1190_;
					_tmp1190_ = unary;
					_tmp1189_ = _tmp1190_ != NULL;
				} else {
					_tmp1189_ = FALSE;
				}
				if (_tmp1189_) {
					ValaUnaryExpression* _tmp1191_;
					ValaUnaryOperator _tmp1192_;
					ValaUnaryOperator _tmp1193_;
					_tmp1191_ = unary;
					_tmp1192_ = vala_unary_expression_get_operator (_tmp1191_);
					_tmp1193_ = _tmp1192_;
					_tmp1188_ = _tmp1193_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1188_ = FALSE;
				}
				if (_tmp1188_) {
					ValaHashMap* _tmp1194_;
					ValaHashMap* _tmp1195_;
					ValaExpression* _tmp1196_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1197_;
					ValaDataType* _tmp1198_;
					ValaDataType* _tmp1199_;
					ValaExpression* _tmp1200_;
					ValaDataType* _tmp1201_;
					ValaDataType* _tmp1202_;
					gboolean _tmp1203_;
					gboolean _tmp1204_;
					ValaLocalVariable* _tmp1205_;
					ValaLocalVariable* _tmp1206_;
					ValaExpression* _tmp1207_;
					ValaLocalVariable* _tmp1208_;
					const gchar* _tmp1209_;
					const gchar* _tmp1210_;
					ValaCCodeExpression* _tmp1211_;
					ValaCCodeExpression* _tmp1212_;
					ValaExpression* _tmp1213_;
					ValaTargetValue* _tmp1214_;
					ValaTargetValue* _tmp1215_;
					ValaExpression* _tmp1216_;
					ValaDataType* _tmp1217_;
					ValaDataType* _tmp1218_;
					gboolean _tmp1219_ = FALSE;
					ValaExpression* _tmp1220_;
					ValaDataType* _tmp1221_;
					ValaDataType* _tmp1222_;
					ValaExpression* _tmp1241_;
					ValaCCodeExpression* _tmp1242_;
					ValaCCodeExpression* _tmp1243_;
					ValaCCodeUnaryExpression* _tmp1244_;
					_tmp1194_ = out_arg_map;
					_tmp1195_ = _vala_map_ref0 (_tmp1194_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1195_;
					_tmp1196_ = arg;
					vala_expression_set_target_value (_tmp1196_, NULL);
					_tmp1197_ = arg;
					_tmp1198_ = vala_expression_get_value_type (_tmp1197_);
					_tmp1199_ = _tmp1198_;
					_tmp1200_ = arg;
					_tmp1201_ = vala_expression_get_value_type (_tmp1200_);
					_tmp1202_ = _tmp1201_;
					_tmp1203_ = vala_data_type_get_value_owned (_tmp1202_);
					_tmp1204_ = _tmp1203_;
					_tmp1205_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1199_, _tmp1204_, NULL, TRUE);
					temp_var = _tmp1205_;
					_tmp1206_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1206_, FALSE);
					_tmp1207_ = arg;
					_tmp1208_ = temp_var;
					_tmp1209_ = vala_symbol_get_name ((ValaSymbol*) _tmp1208_);
					_tmp1210_ = _tmp1209_;
					_tmp1211_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1210_);
					_tmp1212_ = _tmp1211_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1207_, _tmp1212_);
					_vala_ccode_node_unref0 (_tmp1212_);
					_tmp1213_ = arg;
					_tmp1214_ = vala_expression_get_target_value (_tmp1213_);
					_tmp1215_ = _tmp1214_;
					_tmp1216_ = arg;
					_tmp1217_ = vala_expression_get_value_type (_tmp1216_);
					_tmp1218_ = _tmp1217_;
					vala_target_value_set_value_type (_tmp1215_, _tmp1218_);
					_tmp1220_ = arg;
					_tmp1221_ = vala_expression_get_value_type (_tmp1220_);
					_tmp1222_ = _tmp1221_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1222_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1223_;
						ValaDataType* _tmp1224_;
						ValaDataType* _tmp1225_;
						ValaDelegate* _tmp1226_;
						ValaDelegate* _tmp1227_;
						gboolean _tmp1228_;
						gboolean _tmp1229_;
						_tmp1223_ = arg;
						_tmp1224_ = vala_expression_get_value_type (_tmp1223_);
						_tmp1225_ = _tmp1224_;
						_tmp1226_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1225_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1227_ = _tmp1226_;
						_tmp1228_ = vala_delegate_get_has_target (_tmp1227_);
						_tmp1229_ = _tmp1228_;
						_tmp1219_ = _tmp1229_;
					} else {
						_tmp1219_ = FALSE;
					}
					if (_tmp1219_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1230_;
						ValaTargetValue* _tmp1231_;
						ValaTargetValue* _tmp1232_;
						ValaGLibValue* _tmp1233_;
						ValaCCodeExpression* _tmp1234_;
						ValaGLibValue* _tmp1237_;
						ValaCCodeExpression* _tmp1238_;
						_tmp1230_ = arg;
						_tmp1231_ = vala_expression_get_target_value (_tmp1230_);
						_tmp1232_ = _tmp1231_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1232_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1233_ = arg_value;
						_tmp1234_ = _tmp1233_->delegate_target_cvalue;
						if (_tmp1234_ == NULL) {
							ValaGLibValue* _tmp1235_;
							ValaCCodeConstant* _tmp1236_;
							_tmp1235_ = arg_value;
							_tmp1236_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1235_->delegate_target_cvalue);
							_tmp1235_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1236_;
						}
						_tmp1237_ = arg_value;
						_tmp1238_ = _tmp1237_->delegate_target_destroy_notify_cvalue;
						if (_tmp1238_ == NULL) {
							ValaGLibValue* _tmp1239_;
							ValaCCodeConstant* _tmp1240_;
							_tmp1239_ = arg_value;
							_tmp1240_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1239_->delegate_target_destroy_notify_cvalue);
							_tmp1239_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1240_;
						}
					}
					_tmp1241_ = arg;
					_tmp1242_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1241_);
					_tmp1243_ = _tmp1242_;
					_tmp1244_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1243_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1244_;
					_vala_ccode_node_unref0 (_tmp1243_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1245_;
					ValaCCodeExpression* _tmp1246_;
					ValaCCodeExpression* _tmp1247_;
					_tmp1245_ = arg;
					_tmp1246_ = cexpr;
					_tmp1247_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1245_, _tmp1246_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1247_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1249_ = param;
			if (_tmp1249_ != NULL) {
				ValaParameter* _tmp1250_;
				_tmp1250_ = param;
				_tmp1248_ = vala_get_ccode_pos (_tmp1250_);
			} else {
				_tmp1248_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1248_, ellipsis);
			_tmp1251_ = carg_map;
			_tmp1252_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1251_, (gpointer) ((gintptr) arg_pos), _tmp1252_);
			_tmp1254_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1254_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1255_;
				ValaCodeContext* _tmp1256_;
				ValaProfile _tmp1257_;
				ValaProfile _tmp1258_;
				_tmp1255_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1256_ = _tmp1255_;
				_tmp1257_ = vala_code_context_get_profile (_tmp1256_);
				_tmp1258_ = _tmp1257_;
				_tmp1253_ = _tmp1258_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1253_ = FALSE;
			}
			if (_tmp1253_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1259_;
				ValaExpression* _tmp1260_;
				ValaExpression* _tmp1261_;
				ValaDataType* _tmp1262_;
				ValaDataType* _tmp1263_;
				ValaDataType* _tmp1264_;
				ValaDataType* _tmp1265_;
				gchar* _tmp1266_;
				gchar* _tmp1267_;
				gchar* _tmp1268_;
				gchar* _tmp1269_;
				ValaCCodeIdentifier* _tmp1270_;
				ValaCCodeIdentifier* _tmp1271_;
				ValaHashMap* _tmp1272_;
				ValaCCodeIdentifier* _tmp1273_;
				ValaCCodeExpression* _tmp1274_;
				ValaCCodeBinaryExpression* _tmp1275_;
				ValaCCodeBinaryExpression* _tmp1276_;
				_tmp1259_ = ma;
				_tmp1260_ = vala_member_access_get_inner (_tmp1259_);
				_tmp1261_ = _tmp1260_;
				_tmp1262_ = vala_expression_get_value_type (_tmp1261_);
				_tmp1263_ = _tmp1262_;
				_tmp1264_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1263_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1265_ = _tmp1264_;
				_tmp1266_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1265_);
				_tmp1267_ = _tmp1266_;
				_tmp1268_ = g_strdup_printf ("sizeof (%s)", _tmp1267_);
				_tmp1269_ = _tmp1268_;
				_tmp1270_ = vala_ccode_identifier_new (_tmp1269_);
				_tmp1271_ = _tmp1270_;
				_g_free0 (_tmp1269_);
				_g_free0 (_tmp1267_);
				csizeof = _tmp1271_;
				_tmp1272_ = carg_map;
				_tmp1273_ = csizeof;
				_tmp1274_ = cexpr;
				_tmp1275_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1273_, _tmp1274_);
				_tmp1276_ = _tmp1275_;
				vala_map_set ((ValaMap*) _tmp1272_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1276_);
				_vala_ccode_node_unref0 (_tmp1276_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1277_;
				ValaCCodeExpression* _tmp1278_;
				_tmp1277_ = carg_map;
				_tmp1278_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1277_, (gpointer) ((gintptr) arg_pos), _tmp1278_);
			}
			_tmp1280_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1280_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1279_ = ellipsis;
			} else {
				_tmp1279_ = FALSE;
			}
			if (_tmp1279_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1281_;
				ValaNamedArgument* _tmp1282_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1283_;
				const gchar* _tmp1284_;
				const gchar* _tmp1285_;
				gchar** _tmp1286_;
				gchar** _tmp1287_;
				gchar** _tmp1288_;
				gint _tmp1288__length1;
				gchar* _tmp1289_;
				gchar* _tmp1290_;
				ValaHashMap* _tmp1291_;
				const gchar* _tmp1292_;
				gchar* _tmp1293_;
				gchar* _tmp1294_;
				ValaCCodeConstant* _tmp1295_;
				ValaCCodeConstant* _tmp1296_;
				_tmp1281_ = arg;
				_tmp1282_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1281_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1282_;
				_tmp1283_ = named_arg;
				_tmp1284_ = vala_named_argument_get_name (_tmp1283_);
				_tmp1285_ = _tmp1284_;
				_tmp1287_ = _tmp1286_ = g_strsplit (_tmp1285_, "_", 0);
				_tmp1288_ = _tmp1287_;
				_tmp1288__length1 = _vala_array_length (_tmp1286_);
				_tmp1289_ = _vala_g_strjoinv ("-", _tmp1288_, (gint) _vala_array_length (_tmp1286_));
				_tmp1290_ = _tmp1289_;
				_tmp1288_ = (_vala_array_free (_tmp1288_, _tmp1288__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1290_;
				_tmp1291_ = carg_map;
				_tmp1292_ = name;
				_tmp1293_ = g_strdup_printf ("\"%s\"", _tmp1292_);
				_tmp1294_ = _tmp1293_;
				_tmp1295_ = vala_ccode_constant_new (_tmp1294_);
				_tmp1296_ = _tmp1295_;
				vala_map_set ((ValaMap*) _tmp1291_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1296_);
				_vala_ccode_node_unref0 (_tmp1296_);
				_g_free0 (_tmp1294_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1297_ = i;
			i = _tmp1297_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1298_ = params_it;
	if (vala_iterator_next (_tmp1298_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1299_;
		gpointer _tmp1300_;
		gboolean _tmp1301_ = FALSE;
		ValaParameter* _tmp1302_;
		gboolean _tmp1303_;
		gboolean _tmp1304_;
		_tmp1299_ = params_it;
		_tmp1300_ = vala_iterator_get (_tmp1299_);
		param = (ValaParameter*) _tmp1300_;
		_tmp1302_ = param;
		_tmp1303_ = vala_parameter_get_params_array (_tmp1302_);
		_tmp1304_ = _tmp1303_;
		if (_tmp1304_) {
			_tmp1301_ = TRUE;
		} else {
			ValaParameter* _tmp1305_;
			gboolean _tmp1306_;
			gboolean _tmp1307_;
			_tmp1305_ = param;
			_tmp1306_ = vala_parameter_get_ellipsis (_tmp1305_);
			_tmp1307_ = _tmp1306_;
			_tmp1301_ = _tmp1307_;
		}
		_vala_assert (_tmp1301_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1310_ = m;
	if (_tmp1310_ != NULL) {
		ValaMethod* _tmp1311_;
		ValaDataType* _tmp1312_;
		ValaDataType* _tmp1313_;
		_tmp1311_ = m;
		_tmp1312_ = vala_callable_get_return_type ((ValaCallable*) _tmp1311_);
		_tmp1313_ = _tmp1312_;
		_tmp1309_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1313_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1309_ = FALSE;
	}
	if (_tmp1309_) {
		ValaCCodeFunctionCall* _tmp1314_;
		ValaCCodeFunctionCall* _tmp1315_;
		_tmp1314_ = async_call;
		_tmp1315_ = ccall;
		_tmp1308_ = _tmp1314_ != _tmp1315_;
	} else {
		_tmp1308_ = FALSE;
	}
	if (_tmp1308_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1316_;
		ValaDataType* _tmp1317_;
		ValaDataType* _tmp1318_;
		ValaArrayType* _tmp1319_;
		_tmp1316_ = m;
		_tmp1317_ = vala_callable_get_return_type ((ValaCallable*) _tmp1316_);
		_tmp1318_ = _tmp1317_;
		_tmp1319_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1318_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1319_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1320_ = FALSE;
				_tmp1320_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1322_;
					gint _tmp1323_;
					gint _tmp1324_;
					ValaMethod* _tmp1325_;
					if (!_tmp1320_) {
						gint _tmp1321_;
						_tmp1321_ = dim;
						dim = _tmp1321_ + 1;
					}
					_tmp1320_ = FALSE;
					_tmp1322_ = array_type;
					_tmp1323_ = vala_array_type_get_rank (_tmp1322_);
					_tmp1324_ = _tmp1323_;
					if (!(dim <= _tmp1324_)) {
						break;
					}
					_tmp1325_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1325_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1326_;
						ValaDataType* _tmp1327_;
						ValaLocalVariable* _tmp1328_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1329_;
						const gchar* _tmp1330_;
						const gchar* _tmp1331_;
						ValaCCodeExpression* _tmp1332_;
						ValaLocalVariable* _tmp1333_;
						ValaCCodeExpression* _tmp1334_;
						ValaCCodeExpression* _tmp1335_;
						ValaCCodeAssignment* _tmp1336_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1337_;
						ValaCCodeIdentifier* _tmp1338_;
						ValaCCodeFunctionCall* _tmp1339_;
						ValaCCodeFunctionCall* _tmp1340_;
						ValaCCodeFunctionCall* _tmp1341_;
						ValaCCodeExpression* _tmp1342_;
						ValaCCodeFunctionCall* _tmp1343_;
						_tmp1326_ = itype;
						_tmp1327_ = vala_data_type_get_return_type (_tmp1326_);
						_tmp1328_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1327_, TRUE, NULL, FALSE);
						temp_var = _tmp1328_;
						_tmp1329_ = temp_var;
						_tmp1330_ = vala_symbol_get_name ((ValaSymbol*) _tmp1329_);
						_tmp1331_ = _tmp1330_;
						_tmp1332_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1331_);
						temp_ref = _tmp1332_;
						_tmp1333_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1333_, FALSE);
						_tmp1334_ = temp_ref;
						_tmp1335_ = ccall_expr;
						_tmp1336_ = vala_ccode_assignment_new (_tmp1334_, _tmp1335_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1336_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1337_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1338_ = _tmp1337_;
						_tmp1339_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1338_);
						_tmp1340_ = _tmp1339_;
						_vala_ccode_node_unref0 (_tmp1338_);
						len_call = _tmp1340_;
						_tmp1341_ = len_call;
						_tmp1342_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1341_, _tmp1342_);
						_tmp1343_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1343_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1344_;
						_tmp1344_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1344_)) {
							gchar* _tmp1345_ = NULL;
							ValaMethod* _tmp1346_;
							gchar* _tmp1347_;
							gchar* length_ctype = NULL;
							gchar* _tmp1350_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1351_;
							ValaCType* _tmp1352_;
							ValaCType* _tmp1353_;
							ValaLocalVariable* _tmp1354_;
							ValaLocalVariable* _tmp1355_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1356_;
							const gchar* _tmp1357_;
							const gchar* _tmp1358_;
							ValaCCodeExpression* _tmp1359_;
							ValaLocalVariable* _tmp1360_;
							ValaHashMap* _tmp1361_;
							ValaMethod* _tmp1362_;
							ValaCCodeExpression* _tmp1363_;
							ValaCCodeUnaryExpression* _tmp1364_;
							ValaCCodeUnaryExpression* _tmp1365_;
							ValaCCodeExpression* _tmp1366_;
							_tmp1346_ = m;
							_tmp1347_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1346_);
							_tmp1345_ = _tmp1347_;
							if (_tmp1345_ == NULL) {
								ValaArrayType* _tmp1348_;
								gchar* _tmp1349_;
								_tmp1348_ = array_type;
								_tmp1349_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1348_);
								_g_free0 (_tmp1345_);
								_tmp1345_ = _tmp1349_;
							}
							_tmp1350_ = _tmp1345_;
							_tmp1345_ = NULL;
							length_ctype = _tmp1350_;
							_tmp1351_ = length_ctype;
							_tmp1352_ = vala_ctype_new (_tmp1351_, "0");
							_tmp1353_ = _tmp1352_;
							_tmp1354_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1353_, TRUE, NULL, TRUE);
							_tmp1355_ = _tmp1354_;
							_vala_code_node_unref0 (_tmp1353_);
							temp_var = _tmp1355_;
							_tmp1356_ = temp_var;
							_tmp1357_ = vala_symbol_get_name ((ValaSymbol*) _tmp1356_);
							_tmp1358_ = _tmp1357_;
							_tmp1359_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1358_);
							temp_ref = _tmp1359_;
							_tmp1360_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1360_, FALSE);
							_tmp1361_ = out_arg_map;
							_tmp1362_ = m;
							_tmp1363_ = temp_ref;
							_tmp1364_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1363_);
							_tmp1365_ = _tmp1364_;
							vala_map_set ((ValaMap*) _tmp1361_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1362_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1365_);
							_vala_ccode_node_unref0 (_tmp1365_);
							_tmp1366_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1366_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1345_);
						} else {
							ValaMethod* _tmp1367_;
							gchar* _tmp1368_;
							gchar* _tmp1369_;
							gboolean _tmp1370_;
							_tmp1367_ = m;
							_tmp1368_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1367_);
							_tmp1369_ = _tmp1368_;
							_tmp1370_ = _tmp1369_ != NULL;
							_g_free0 (_tmp1369_);
							if (_tmp1370_) {
								ValaMethod* _tmp1371_;
								gchar* _tmp1372_;
								gchar* _tmp1373_;
								ValaCCodeConstant* _tmp1374_;
								ValaCCodeConstant* _tmp1375_;
								_tmp1371_ = m;
								_tmp1372_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1371_);
								_tmp1373_ = _tmp1372_;
								_tmp1374_ = vala_ccode_constant_new (_tmp1373_);
								_tmp1375_ = _tmp1374_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1375_);
								_vala_ccode_node_unref0 (_tmp1375_);
								_g_free0 (_tmp1373_);
							} else {
								ValaCCodeConstant* _tmp1376_;
								ValaCCodeConstant* _tmp1377_;
								_tmp1376_ = vala_ccode_constant_new ("-1");
								_tmp1377_ = _tmp1376_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1377_);
								_vala_ccode_node_unref0 (_tmp1377_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1378_ = FALSE;
		gboolean _tmp1379_ = FALSE;
		ValaMethod* _tmp1380_;
		_tmp1380_ = m;
		if (_tmp1380_ != NULL) {
			ValaMethod* _tmp1381_;
			ValaDataType* _tmp1382_;
			ValaDataType* _tmp1383_;
			_tmp1381_ = m;
			_tmp1382_ = vala_callable_get_return_type ((ValaCallable*) _tmp1381_);
			_tmp1383_ = _tmp1382_;
			_tmp1379_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1383_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1379_ = FALSE;
		}
		if (_tmp1379_) {
			ValaCCodeFunctionCall* _tmp1384_;
			ValaCCodeFunctionCall* _tmp1385_;
			_tmp1384_ = async_call;
			_tmp1385_ = ccall;
			_tmp1378_ = _tmp1384_ != _tmp1385_;
		} else {
			_tmp1378_ = FALSE;
		}
		if (_tmp1378_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1386_;
			ValaDataType* _tmp1387_;
			ValaDataType* _tmp1388_;
			ValaDelegateType* _tmp1389_;
			ValaDelegateType* _tmp1390_;
			ValaDelegate* _tmp1391_;
			ValaDelegate* _tmp1392_;
			gboolean _tmp1393_;
			gboolean _tmp1394_;
			_tmp1386_ = m;
			_tmp1387_ = vala_callable_get_return_type ((ValaCallable*) _tmp1386_);
			_tmp1388_ = _tmp1387_;
			_tmp1389_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1388_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1389_;
			_tmp1390_ = deleg_type;
			_tmp1391_ = vala_delegate_type_get_delegate_symbol (_tmp1390_);
			_tmp1392_ = _tmp1391_;
			_tmp1393_ = vala_delegate_get_has_target (_tmp1392_);
			_tmp1394_ = _tmp1393_;
			if (_tmp1394_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1395_;
				ValaVoidType* _tmp1396_;
				ValaPointerType* _tmp1397_;
				ValaPointerType* _tmp1398_;
				ValaLocalVariable* _tmp1399_;
				ValaLocalVariable* _tmp1400_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1401_;
				const gchar* _tmp1402_;
				const gchar* _tmp1403_;
				ValaCCodeExpression* _tmp1404_;
				ValaLocalVariable* _tmp1405_;
				ValaHashMap* _tmp1406_;
				ValaMethod* _tmp1407_;
				ValaCCodeExpression* _tmp1408_;
				ValaCCodeUnaryExpression* _tmp1409_;
				ValaCCodeUnaryExpression* _tmp1410_;
				ValaCCodeExpression* _tmp1411_;
				ValaDelegateType* _tmp1412_;
				_tmp1395_ = vala_void_type_new (NULL);
				_tmp1396_ = _tmp1395_;
				_tmp1397_ = vala_pointer_type_new ((ValaDataType*) _tmp1396_, NULL);
				_tmp1398_ = _tmp1397_;
				_tmp1399_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1398_, TRUE, NULL, TRUE);
				_tmp1400_ = _tmp1399_;
				_vala_code_node_unref0 (_tmp1398_);
				_vala_code_node_unref0 (_tmp1396_);
				temp_var = _tmp1400_;
				_tmp1401_ = temp_var;
				_tmp1402_ = vala_symbol_get_name ((ValaSymbol*) _tmp1401_);
				_tmp1403_ = _tmp1402_;
				_tmp1404_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1403_);
				temp_ref = _tmp1404_;
				_tmp1405_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1405_, FALSE);
				_tmp1406_ = out_arg_map;
				_tmp1407_ = m;
				_tmp1408_ = temp_ref;
				_tmp1409_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1408_);
				_tmp1410_ = _tmp1409_;
				vala_map_set ((ValaMap*) _tmp1406_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1407_), FALSE)), (ValaCCodeExpression*) _tmp1410_);
				_vala_ccode_node_unref0 (_tmp1410_);
				_tmp1411_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1411_);
				_tmp1412_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1412_)) {
					ValaDataType* _tmp1413_;
					ValaLocalVariable* _tmp1414_;
					ValaLocalVariable* _tmp1415_;
					const gchar* _tmp1416_;
					const gchar* _tmp1417_;
					ValaCCodeExpression* _tmp1418_;
					ValaLocalVariable* _tmp1419_;
					ValaHashMap* _tmp1420_;
					ValaMethod* _tmp1421_;
					ValaCCodeExpression* _tmp1422_;
					ValaCCodeUnaryExpression* _tmp1423_;
					ValaCCodeUnaryExpression* _tmp1424_;
					ValaCCodeExpression* _tmp1425_;
					_tmp1413_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1414_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1413_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1414_;
					_tmp1415_ = temp_var;
					_tmp1416_ = vala_symbol_get_name ((ValaSymbol*) _tmp1415_);
					_tmp1417_ = _tmp1416_;
					_tmp1418_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1417_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1418_;
					_tmp1419_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1419_, FALSE);
					_tmp1420_ = out_arg_map;
					_tmp1421_ = m;
					_tmp1422_ = temp_ref;
					_tmp1423_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1422_);
					_tmp1424_ = _tmp1423_;
					vala_map_set ((ValaMap*) _tmp1420_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1421_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1424_);
					_vala_ccode_node_unref0 (_tmp1424_);
					_tmp1425_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1425_);
				} else {
					ValaCCodeConstant* _tmp1426_;
					ValaCCodeConstant* _tmp1427_;
					_tmp1426_ = vala_ccode_constant_new ("NULL");
					_tmp1427_ = _tmp1426_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1427_);
					_vala_ccode_node_unref0 (_tmp1427_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1428_;
				ValaCCodeConstant* _tmp1429_;
				_tmp1428_ = vala_ccode_constant_new ("NULL");
				_tmp1429_ = _tmp1428_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1429_);
				_vala_ccode_node_unref0 (_tmp1429_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1431_ = deleg;
	if (_tmp1431_ != NULL) {
		ValaDelegate* _tmp1432_;
		ValaDataType* _tmp1433_;
		ValaDataType* _tmp1434_;
		_tmp1432_ = deleg;
		_tmp1433_ = vala_callable_get_return_type ((ValaCallable*) _tmp1432_);
		_tmp1434_ = _tmp1433_;
		_tmp1430_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1434_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1430_ = FALSE;
	}
	if (_tmp1430_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1435_;
		ValaDataType* _tmp1436_;
		ValaDataType* _tmp1437_;
		ValaArrayType* _tmp1438_;
		_tmp1435_ = deleg;
		_tmp1436_ = vala_callable_get_return_type ((ValaCallable*) _tmp1435_);
		_tmp1437_ = _tmp1436_;
		_tmp1438_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1437_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1438_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1439_ = FALSE;
				_tmp1439_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1441_;
					gint _tmp1442_;
					gint _tmp1443_;
					ValaDelegate* _tmp1444_;
					if (!_tmp1439_) {
						gint _tmp1440_;
						_tmp1440_ = dim;
						dim = _tmp1440_ + 1;
					}
					_tmp1439_ = FALSE;
					_tmp1441_ = array_type;
					_tmp1442_ = vala_array_type_get_rank (_tmp1441_);
					_tmp1443_ = _tmp1442_;
					if (!(dim <= _tmp1443_)) {
						break;
					}
					_tmp1444_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1444_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1445_;
						ValaDataType* _tmp1446_;
						ValaLocalVariable* _tmp1447_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1448_;
						const gchar* _tmp1449_;
						const gchar* _tmp1450_;
						ValaCCodeExpression* _tmp1451_;
						ValaLocalVariable* _tmp1452_;
						ValaCCodeExpression* _tmp1453_;
						ValaCCodeExpression* _tmp1454_;
						ValaCCodeAssignment* _tmp1455_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1456_;
						ValaCCodeIdentifier* _tmp1457_;
						ValaCCodeFunctionCall* _tmp1458_;
						ValaCCodeFunctionCall* _tmp1459_;
						ValaCCodeFunctionCall* _tmp1460_;
						ValaCCodeExpression* _tmp1461_;
						ValaCCodeFunctionCall* _tmp1462_;
						_tmp1445_ = itype;
						_tmp1446_ = vala_data_type_get_return_type (_tmp1445_);
						_tmp1447_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1446_, TRUE, NULL, FALSE);
						temp_var = _tmp1447_;
						_tmp1448_ = temp_var;
						_tmp1449_ = vala_symbol_get_name ((ValaSymbol*) _tmp1448_);
						_tmp1450_ = _tmp1449_;
						_tmp1451_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1450_);
						temp_ref = _tmp1451_;
						_tmp1452_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1452_, FALSE);
						_tmp1453_ = temp_ref;
						_tmp1454_ = ccall_expr;
						_tmp1455_ = vala_ccode_assignment_new (_tmp1453_, _tmp1454_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1455_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1456_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1457_ = _tmp1456_;
						_tmp1458_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1457_);
						_tmp1459_ = _tmp1458_;
						_vala_ccode_node_unref0 (_tmp1457_);
						len_call = _tmp1459_;
						_tmp1460_ = len_call;
						_tmp1461_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1460_, _tmp1461_);
						_tmp1462_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1462_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1463_;
						_tmp1463_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1463_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1464_;
							ValaDataType* _tmp1465_;
							ValaDataType* _tmp1466_;
							ValaLocalVariable* _tmp1467_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1468_;
							const gchar* _tmp1469_;
							const gchar* _tmp1470_;
							ValaCCodeExpression* _tmp1471_;
							ValaLocalVariable* _tmp1472_;
							ValaHashMap* _tmp1473_;
							ValaDelegate* _tmp1474_;
							ValaCCodeExpression* _tmp1475_;
							ValaCCodeUnaryExpression* _tmp1476_;
							ValaCCodeUnaryExpression* _tmp1477_;
							ValaCCodeExpression* _tmp1478_;
							_tmp1464_ = array_type;
							_tmp1465_ = vala_array_type_get_length_type (_tmp1464_);
							_tmp1466_ = _tmp1465_;
							_tmp1467_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1466_, TRUE, NULL, TRUE);
							temp_var = _tmp1467_;
							_tmp1468_ = temp_var;
							_tmp1469_ = vala_symbol_get_name ((ValaSymbol*) _tmp1468_);
							_tmp1470_ = _tmp1469_;
							_tmp1471_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1470_);
							temp_ref = _tmp1471_;
							_tmp1472_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1472_, FALSE);
							_tmp1473_ = out_arg_map;
							_tmp1474_ = deleg;
							_tmp1475_ = temp_ref;
							_tmp1476_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1475_);
							_tmp1477_ = _tmp1476_;
							vala_map_set ((ValaMap*) _tmp1473_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1474_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1477_);
							_vala_ccode_node_unref0 (_tmp1477_);
							_tmp1478_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1478_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1479_;
							ValaCCodeConstant* _tmp1480_;
							_tmp1479_ = vala_ccode_constant_new ("-1");
							_tmp1480_ = _tmp1479_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1480_);
							_vala_ccode_node_unref0 (_tmp1480_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1481_ = FALSE;
		ValaDelegate* _tmp1482_;
		_tmp1482_ = deleg;
		if (_tmp1482_ != NULL) {
			ValaDelegate* _tmp1483_;
			ValaDataType* _tmp1484_;
			ValaDataType* _tmp1485_;
			_tmp1483_ = deleg;
			_tmp1484_ = vala_callable_get_return_type ((ValaCallable*) _tmp1483_);
			_tmp1485_ = _tmp1484_;
			_tmp1481_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1485_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1481_ = FALSE;
		}
		if (_tmp1481_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1486_;
			ValaDataType* _tmp1487_;
			ValaDataType* _tmp1488_;
			ValaDelegateType* _tmp1489_;
			ValaDelegateType* _tmp1490_;
			ValaDelegate* _tmp1491_;
			ValaDelegate* _tmp1492_;
			gboolean _tmp1493_;
			gboolean _tmp1494_;
			_tmp1486_ = deleg;
			_tmp1487_ = vala_callable_get_return_type ((ValaCallable*) _tmp1486_);
			_tmp1488_ = _tmp1487_;
			_tmp1489_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1488_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1489_;
			_tmp1490_ = deleg_type;
			_tmp1491_ = vala_delegate_type_get_delegate_symbol (_tmp1490_);
			_tmp1492_ = _tmp1491_;
			_tmp1493_ = vala_delegate_get_has_target (_tmp1492_);
			_tmp1494_ = _tmp1493_;
			if (_tmp1494_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1495_;
				ValaVoidType* _tmp1496_;
				ValaPointerType* _tmp1497_;
				ValaPointerType* _tmp1498_;
				ValaLocalVariable* _tmp1499_;
				ValaLocalVariable* _tmp1500_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1501_;
				const gchar* _tmp1502_;
				const gchar* _tmp1503_;
				ValaCCodeExpression* _tmp1504_;
				ValaLocalVariable* _tmp1505_;
				ValaHashMap* _tmp1506_;
				ValaDelegate* _tmp1507_;
				ValaCCodeExpression* _tmp1508_;
				ValaCCodeUnaryExpression* _tmp1509_;
				ValaCCodeUnaryExpression* _tmp1510_;
				ValaCCodeExpression* _tmp1511_;
				ValaDelegateType* _tmp1512_;
				_tmp1495_ = vala_void_type_new (NULL);
				_tmp1496_ = _tmp1495_;
				_tmp1497_ = vala_pointer_type_new ((ValaDataType*) _tmp1496_, NULL);
				_tmp1498_ = _tmp1497_;
				_tmp1499_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1498_, TRUE, NULL, TRUE);
				_tmp1500_ = _tmp1499_;
				_vala_code_node_unref0 (_tmp1498_);
				_vala_code_node_unref0 (_tmp1496_);
				temp_var = _tmp1500_;
				_tmp1501_ = temp_var;
				_tmp1502_ = vala_symbol_get_name ((ValaSymbol*) _tmp1501_);
				_tmp1503_ = _tmp1502_;
				_tmp1504_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1503_);
				temp_ref = _tmp1504_;
				_tmp1505_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1505_, FALSE);
				_tmp1506_ = out_arg_map;
				_tmp1507_ = deleg;
				_tmp1508_ = temp_ref;
				_tmp1509_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1508_);
				_tmp1510_ = _tmp1509_;
				vala_map_set ((ValaMap*) _tmp1506_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1507_), FALSE)), (ValaCCodeExpression*) _tmp1510_);
				_vala_ccode_node_unref0 (_tmp1510_);
				_tmp1511_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1511_);
				_tmp1512_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1512_)) {
					ValaDataType* _tmp1513_;
					ValaLocalVariable* _tmp1514_;
					ValaLocalVariable* _tmp1515_;
					const gchar* _tmp1516_;
					const gchar* _tmp1517_;
					ValaCCodeExpression* _tmp1518_;
					ValaLocalVariable* _tmp1519_;
					ValaHashMap* _tmp1520_;
					ValaDelegate* _tmp1521_;
					ValaCCodeExpression* _tmp1522_;
					ValaCCodeUnaryExpression* _tmp1523_;
					ValaCCodeUnaryExpression* _tmp1524_;
					ValaCCodeExpression* _tmp1525_;
					_tmp1513_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1514_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1513_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1514_;
					_tmp1515_ = temp_var;
					_tmp1516_ = vala_symbol_get_name ((ValaSymbol*) _tmp1515_);
					_tmp1517_ = _tmp1516_;
					_tmp1518_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1517_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1518_;
					_tmp1519_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1519_, FALSE);
					_tmp1520_ = out_arg_map;
					_tmp1521_ = deleg;
					_tmp1522_ = temp_ref;
					_tmp1523_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1522_);
					_tmp1524_ = _tmp1523_;
					vala_map_set ((ValaMap*) _tmp1520_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1521_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1524_);
					_vala_ccode_node_unref0 (_tmp1524_);
					_tmp1525_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1525_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1527_ = m;
	if (_tmp1527_ != NULL) {
		ValaMethod* _tmp1528_;
		gboolean _tmp1529_;
		gboolean _tmp1530_;
		_tmp1528_ = m;
		_tmp1529_ = vala_method_get_coroutine (_tmp1528_);
		_tmp1530_ = _tmp1529_;
		_tmp1526_ = _tmp1530_;
	} else {
		_tmp1526_ = FALSE;
	}
	if (_tmp1526_) {
		gboolean _tmp1531_;
		gboolean _tmp1532_;
		_tmp1531_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1532_ = _tmp1531_;
		if (_tmp1532_) {
			ValaHashMap* _tmp1533_;
			ValaMethod* _tmp1534_;
			ValaMethod* _tmp1535_;
			gchar* _tmp1536_;
			gchar* _tmp1537_;
			ValaCCodeIdentifier* _tmp1538_;
			ValaCCodeIdentifier* _tmp1539_;
			ValaHashMap* _tmp1540_;
			ValaCCodeIdentifier* _tmp1541_;
			ValaCCodeIdentifier* _tmp1542_;
			_tmp1533_ = in_arg_map;
			_tmp1534_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1535_ = _tmp1534_;
			_tmp1536_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1535_);
			_tmp1537_ = _tmp1536_;
			_tmp1538_ = vala_ccode_identifier_new (_tmp1537_);
			_tmp1539_ = _tmp1538_;
			vala_map_set ((ValaMap*) _tmp1533_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1539_);
			_vala_ccode_node_unref0 (_tmp1539_);
			_g_free0 (_tmp1537_);
			_tmp1540_ = in_arg_map;
			_tmp1541_ = vala_ccode_identifier_new ("_data_");
			_tmp1542_ = _tmp1541_;
			vala_map_set ((ValaMap*) _tmp1540_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1542_);
			_vala_ccode_node_unref0 (_tmp1542_);
		}
	}
	_tmp1543_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1544_ = _tmp1543_;
	if (_tmp1544_) {
		ValaCallable* _tmp1545_ = NULL;
		ValaMethod* _tmp1546_;
		ValaHashMap* _tmp1548_;
		ValaCCodeExpression* _tmp1549_;
		ValaCCodeExpression* _tmp1550_;
		ValaCCodeUnaryExpression* _tmp1551_;
		ValaCCodeUnaryExpression* _tmp1552_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1546_ = m;
		_tmp1545_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1546_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1545_ == NULL) {
			ValaDelegate* _tmp1547_;
			_tmp1547_ = deleg;
			_tmp1545_ = (ValaCallable*) _tmp1547_;
		}
		_tmp1548_ = out_arg_map;
		_tmp1549_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1550_ = _tmp1549_;
		_tmp1551_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1550_);
		_tmp1552_ = _tmp1551_;
		vala_map_set ((ValaMap*) _tmp1548_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1545_), FALSE)), (ValaCCodeExpression*) _tmp1552_);
		_vala_ccode_node_unref0 (_tmp1552_);
		_vala_ccode_node_unref0 (_tmp1550_);
	} else {
		gboolean _tmp1553_ = FALSE;
		gboolean _tmp1554_ = FALSE;
		ValaMethod* _tmp1555_;
		_tmp1555_ = m;
		if (_tmp1555_ != NULL) {
			ValaMethod* _tmp1556_;
			_tmp1556_ = m;
			_tmp1554_ = vala_method_has_error_type_parameter (_tmp1556_);
		} else {
			_tmp1554_ = FALSE;
		}
		if (_tmp1554_) {
			ValaCCodeFunctionCall* _tmp1557_;
			ValaCCodeFunctionCall* _tmp1558_;
			_tmp1557_ = async_call;
			_tmp1558_ = ccall;
			_tmp1553_ = _tmp1557_ != _tmp1558_;
		} else {
			_tmp1553_ = FALSE;
		}
		if (_tmp1553_) {
			ValaHashMap* _tmp1559_;
			ValaMethod* _tmp1560_;
			ValaCCodeConstant* _tmp1561_;
			ValaCCodeConstant* _tmp1562_;
			_tmp1559_ = out_arg_map;
			_tmp1560_ = m;
			_tmp1561_ = vala_ccode_constant_new ("NULL");
			_tmp1562_ = _tmp1561_;
			vala_map_set ((ValaMap*) _tmp1559_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1560_), FALSE)), (ValaCCodeExpression*) _tmp1562_);
			_vala_ccode_node_unref0 (_tmp1562_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1563_;
		_tmp1563_ = m;
		if (_tmp1563_ == NULL) {
			ValaHashMap* _tmp1564_;
			ValaCCodeConstant* _tmp1565_;
			ValaCCodeConstant* _tmp1566_;
			_tmp1564_ = in_arg_map;
			_tmp1565_ = vala_ccode_constant_new ("NULL");
			_tmp1566_ = _tmp1565_;
			vala_map_set ((ValaMap*) _tmp1564_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1566_);
			_vala_ccode_node_unref0 (_tmp1566_);
		} else {
			gboolean _tmp1567_ = FALSE;
			gboolean _tmp1568_ = FALSE;
			gboolean _tmp1569_ = FALSE;
			ValaMethod* _tmp1570_;
			gboolean _tmp1571_;
			gboolean _tmp1572_;
			_tmp1570_ = m;
			_tmp1571_ = vala_method_get_printf_format (_tmp1570_);
			_tmp1572_ = _tmp1571_;
			if (!_tmp1572_) {
				ValaMethod* _tmp1573_;
				gboolean _tmp1574_;
				gboolean _tmp1575_;
				_tmp1573_ = m;
				_tmp1574_ = vala_method_get_scanf_format (_tmp1573_);
				_tmp1575_ = _tmp1574_;
				_tmp1569_ = !_tmp1575_;
			} else {
				_tmp1569_ = FALSE;
			}
			if (_tmp1569_) {
				ValaMethod* _tmp1576_;
				gchar* _tmp1577_;
				gchar* _tmp1578_;
				_tmp1576_ = m;
				_tmp1577_ = vala_get_ccode_sentinel (_tmp1576_);
				_tmp1578_ = _tmp1577_;
				_tmp1568_ = g_strcmp0 (_tmp1578_, "") != 0;
				_g_free0 (_tmp1578_);
			} else {
				_tmp1568_ = FALSE;
			}
			if (_tmp1568_) {
				gboolean _tmp1579_;
				gboolean _tmp1580_;
				_tmp1579_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1580_ = _tmp1579_;
				_tmp1567_ = !_tmp1580_;
			} else {
				_tmp1567_ = FALSE;
			}
			if (_tmp1567_) {
				ValaHashMap* _tmp1581_;
				ValaMethod* _tmp1582_;
				gchar* _tmp1583_;
				gchar* _tmp1584_;
				ValaCCodeConstant* _tmp1585_;
				ValaCCodeConstant* _tmp1586_;
				_tmp1581_ = in_arg_map;
				_tmp1582_ = m;
				_tmp1583_ = vala_get_ccode_sentinel (_tmp1582_);
				_tmp1584_ = _tmp1583_;
				_tmp1585_ = vala_ccode_constant_new (_tmp1584_);
				_tmp1586_ = _tmp1585_;
				vala_map_set ((ValaMap*) _tmp1581_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1586_);
				_vala_ccode_node_unref0 (_tmp1586_);
				_g_free0 (_tmp1584_);
			}
		}
	}
	_tmp1587_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1587_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1588_;
		ValaDelegateType* _tmp1589_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1590_;
		ValaDelegate* _tmp1591_;
		ValaDelegate* _tmp1592_;
		ValaDelegate* _tmp1593_;
		ValaDelegate* _tmp1594_;
		gboolean _tmp1595_;
		gboolean _tmp1596_;
		_tmp1588_ = itype;
		_tmp1589_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1588_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1589_;
		_tmp1590_ = deleg_type;
		_tmp1591_ = vala_delegate_type_get_delegate_symbol (_tmp1590_);
		_tmp1592_ = _tmp1591_;
		_tmp1593_ = _vala_code_node_ref0 (_tmp1592_);
		d = _tmp1593_;
		_tmp1594_ = d;
		_tmp1595_ = vala_delegate_get_has_target (_tmp1594_);
		_tmp1596_ = _tmp1595_;
		if (_tmp1596_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1597_;
			ValaDelegate* _tmp1598_;
			ValaExpression* _tmp1599_;
			ValaExpression* _tmp1600_;
			ValaCCodeExpression* _tmp1601_ = NULL;
			ValaCCodeExpression* _tmp1602_;
			ValaCCodeExpression* _tmp1603_;
			ValaHashMap* _tmp1604_;
			ValaDelegate* _tmp1605_;
			ValaExpression* _tmp1606_;
			ValaExpression* _tmp1607_;
			ValaCCodeExpression* _tmp1608_ = NULL;
			ValaCCodeExpression* _tmp1609_;
			ValaCCodeExpression* _tmp1610_;
			_tmp1597_ = in_arg_map;
			_tmp1598_ = d;
			_tmp1599_ = vala_method_call_get_call (expr);
			_tmp1600_ = _tmp1599_;
			_tmp1602_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1600_, &_tmp1601_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1601_;
			_tmp1603_ = _tmp1602_;
			vala_map_set ((ValaMap*) _tmp1597_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1598_), FALSE)), _tmp1603_);
			_vala_ccode_node_unref0 (_tmp1603_);
			_tmp1604_ = out_arg_map;
			_tmp1605_ = d;
			_tmp1606_ = vala_method_call_get_call (expr);
			_tmp1607_ = _tmp1606_;
			_tmp1609_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1607_, &_tmp1608_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1608_;
			_tmp1610_ = _tmp1609_;
			vala_map_set ((ValaMap*) _tmp1604_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1605_), FALSE)), _tmp1610_);
			_vala_ccode_node_unref0 (_tmp1610_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1611_ = itype;
	_tmp1612_ = vala_data_type_get_return_type (_tmp1611_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1612_);
	_tmp1614_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1614_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1615_;
		ValaDataType* _tmp1616_;
		_tmp1615_ = itype;
		_tmp1616_ = vala_data_type_get_return_type (_tmp1615_);
		_tmp1613_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1616_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1613_ = FALSE;
	}
	if (_tmp1613_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1617_;
		ValaSignal* _tmp1618_;
		ValaSignal* _tmp1619_;
		ValaSignal* _tmp1620_;
		gboolean _tmp1621_ = FALSE;
		gboolean _tmp1622_ = FALSE;
		ValaMemberAccess* _tmp1623_;
		_tmp1617_ = itype;
		_tmp1618_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1617_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1619_ = _tmp1618_;
		_tmp1620_ = _vala_code_node_ref0 (_tmp1619_);
		sig = _tmp1620_;
		_tmp1623_ = ma;
		if (_tmp1623_ != NULL) {
			ValaMemberAccess* _tmp1624_;
			ValaExpression* _tmp1625_;
			ValaExpression* _tmp1626_;
			_tmp1624_ = ma;
			_tmp1625_ = vala_member_access_get_inner (_tmp1624_);
			_tmp1626_ = _tmp1625_;
			_tmp1622_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1626_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1622_ = FALSE;
		}
		if (_tmp1622_) {
			ValaSignal* _tmp1627_;
			gboolean _tmp1628_;
			gboolean _tmp1629_;
			_tmp1627_ = sig;
			_tmp1628_ = vala_signal_get_is_virtual (_tmp1627_);
			_tmp1629_ = _tmp1628_;
			_tmp1621_ = _tmp1629_;
		} else {
			_tmp1621_ = FALSE;
		}
		if (_tmp1621_) {
		} else {
			gboolean _tmp1630_ = FALSE;
			ValaSignal* _tmp1631_;
			_tmp1631_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1631_)) {
				_tmp1630_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1632_;
				ValaSourceReference* _tmp1633_;
				ValaSourceReference* _tmp1634_;
				ValaSourceFile* _tmp1635_;
				ValaSourceFile* _tmp1636_;
				ValaSignal* _tmp1637_;
				ValaSourceReference* _tmp1638_;
				ValaSourceReference* _tmp1639_;
				ValaSourceFile* _tmp1640_;
				ValaSourceFile* _tmp1641_;
				_tmp1632_ = ma;
				_tmp1633_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1632_);
				_tmp1634_ = _tmp1633_;
				_tmp1635_ = vala_source_reference_get_file (_tmp1634_);
				_tmp1636_ = _tmp1635_;
				_tmp1637_ = sig;
				_tmp1638_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1637_);
				_tmp1639_ = _tmp1638_;
				_tmp1640_ = vala_source_reference_get_file (_tmp1639_);
				_tmp1641_ = _tmp1640_;
				_tmp1630_ = _tmp1636_ == _tmp1641_;
			}
			if (_tmp1630_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1642_ = async_call;
	_tmp1643_ = ccall;
	if (_tmp1642_ == _tmp1643_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1644_;
		ValaDataType* _tmp1645_;
		ValaLocalVariable* _tmp1646_;
		ValaLocalVariable* _tmp1647_;
		const gchar* _tmp1648_;
		const gchar* _tmp1649_;
		ValaCCodeExpression* _tmp1650_;
		ValaLocalVariable* _tmp1651_;
		ValaHashMap* _tmp1652_;
		ValaCCodeExpression* _tmp1653_;
		ValaCCodeUnaryExpression* _tmp1654_;
		ValaCCodeUnaryExpression* _tmp1655_;
		_tmp1644_ = itype;
		_tmp1645_ = vala_data_type_get_return_type (_tmp1644_);
		_tmp1646_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1645_, TRUE, NULL, TRUE);
		out_param_var = _tmp1646_;
		_tmp1647_ = out_param_var;
		_tmp1648_ = vala_symbol_get_name ((ValaSymbol*) _tmp1647_);
		_tmp1649_ = _tmp1648_;
		_tmp1650_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1649_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1650_;
		_tmp1651_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1651_, FALSE);
		_tmp1652_ = out_arg_map;
		_tmp1653_ = out_param_ref;
		_tmp1654_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1653_);
		_tmp1655_ = _tmp1654_;
		vala_map_set ((ValaMap*) _tmp1652_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1655_);
		_vala_ccode_node_unref0 (_tmp1655_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1656_ = async_call;
	_tmp1657_ = ccall;
	if (_tmp1656_ != _tmp1657_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1668_;
			ValaHashMap* _tmp1669_;
			gpointer _tmp1670_;
			ValaCCodeExpression* _tmp1671_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1658_;
				ValaSet* _tmp1659_;
				ValaSet* _tmp1660_;
				ValaIterator* _tmp1661_;
				ValaIterator* _tmp1662_;
				_tmp1658_ = out_arg_map;
				_tmp1659_ = vala_map_get_keys ((ValaMap*) _tmp1658_);
				_tmp1660_ = _tmp1659_;
				_tmp1661_ = vala_iterable_iterator ((ValaIterable*) _tmp1660_);
				_tmp1662_ = _tmp1661_;
				_vala_iterable_unref0 (_tmp1660_);
				_pos_it = _tmp1662_;
				while (TRUE) {
					ValaIterator* _tmp1663_;
					gint pos = 0;
					ValaIterator* _tmp1664_;
					gpointer _tmp1665_;
					gboolean _tmp1666_ = FALSE;
					_tmp1663_ = _pos_it;
					if (!vala_iterator_next (_tmp1663_)) {
						break;
					}
					_tmp1664_ = _pos_it;
					_tmp1665_ = vala_iterator_get (_tmp1664_);
					pos = (gint) ((gintptr) _tmp1665_);
					if (pos > last_pos) {
						gboolean _tmp1667_ = FALSE;
						if (min_pos == -1) {
							_tmp1667_ = TRUE;
						} else {
							_tmp1667_ = pos < min_pos;
						}
						_tmp1666_ = _tmp1667_;
					} else {
						_tmp1666_ = FALSE;
					}
					if (_tmp1666_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1668_ = ccall;
			_tmp1669_ = out_arg_map;
			_tmp1670_ = vala_map_get ((ValaMap*) _tmp1669_, (gpointer) ((gintptr) min_pos));
			_tmp1671_ = (ValaCCodeExpression*) _tmp1670_;
			vala_ccode_function_call_add_argument (_tmp1668_, _tmp1671_);
			_vala_ccode_node_unref0 (_tmp1671_);
			last_pos = min_pos;
		}
	}
	_tmp1672_ = async_call;
	if (_tmp1672_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1683_;
			ValaHashMap* _tmp1684_;
			gpointer _tmp1685_;
			ValaCCodeExpression* _tmp1686_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1673_;
				ValaSet* _tmp1674_;
				ValaSet* _tmp1675_;
				ValaIterator* _tmp1676_;
				ValaIterator* _tmp1677_;
				_tmp1673_ = in_arg_map;
				_tmp1674_ = vala_map_get_keys ((ValaMap*) _tmp1673_);
				_tmp1675_ = _tmp1674_;
				_tmp1676_ = vala_iterable_iterator ((ValaIterable*) _tmp1675_);
				_tmp1677_ = _tmp1676_;
				_vala_iterable_unref0 (_tmp1675_);
				_pos_it = _tmp1677_;
				while (TRUE) {
					ValaIterator* _tmp1678_;
					gint pos = 0;
					ValaIterator* _tmp1679_;
					gpointer _tmp1680_;
					gboolean _tmp1681_ = FALSE;
					_tmp1678_ = _pos_it;
					if (!vala_iterator_next (_tmp1678_)) {
						break;
					}
					_tmp1679_ = _pos_it;
					_tmp1680_ = vala_iterator_get (_tmp1679_);
					pos = (gint) ((gintptr) _tmp1680_);
					if (pos > last_pos) {
						gboolean _tmp1682_ = FALSE;
						if (min_pos == -1) {
							_tmp1682_ = TRUE;
						} else {
							_tmp1682_ = pos < min_pos;
						}
						_tmp1681_ = _tmp1682_;
					} else {
						_tmp1681_ = FALSE;
					}
					if (_tmp1681_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1683_ = async_call;
			_tmp1684_ = in_arg_map;
			_tmp1685_ = vala_map_get ((ValaMap*) _tmp1684_, (gpointer) ((gintptr) min_pos));
			_tmp1686_ = (ValaCCodeExpression*) _tmp1685_;
			vala_ccode_function_call_add_argument (_tmp1683_, _tmp1686_);
			_vala_ccode_node_unref0 (_tmp1686_);
			last_pos = min_pos;
		}
	}
	_tmp1687_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1688_ = _tmp1687_;
	if (_tmp1688_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1689_;
		gint _tmp1690_;
		ValaCCodeFunction* _tmp1691_;
		ValaCCodeFunction* _tmp1692_;
		ValaCCodeIdentifier* _tmp1693_;
		ValaCCodeIdentifier* _tmp1694_;
		ValaCCodeMemberAccess* _tmp1695_;
		ValaCCodeMemberAccess* _tmp1696_;
		gchar* _tmp1697_;
		gchar* _tmp1698_;
		ValaCCodeConstant* _tmp1699_;
		ValaCCodeConstant* _tmp1700_;
		ValaCCodeFunction* _tmp1701_;
		ValaCCodeFunction* _tmp1702_;
		ValaCCodeFunctionCall* _tmp1703_;
		ValaCCodeFunction* _tmp1704_;
		ValaCCodeFunction* _tmp1705_;
		ValaCCodeConstant* _tmp1706_;
		ValaCCodeConstant* _tmp1707_;
		ValaCCodeFunction* _tmp1708_;
		ValaCCodeFunction* _tmp1709_;
		gchar* _tmp1710_;
		gchar* _tmp1711_;
		_tmp1689_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1690_ = _tmp1689_->next_coroutine_state;
		_tmp1689_->next_coroutine_state = _tmp1690_ + 1;
		state = _tmp1690_;
		_tmp1691_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1692_ = _tmp1691_;
		_tmp1693_ = vala_ccode_identifier_new ("_data_");
		_tmp1694_ = _tmp1693_;
		_tmp1695_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1694_, "_state_");
		_tmp1696_ = _tmp1695_;
		_tmp1697_ = g_strdup_printf ("%i", state);
		_tmp1698_ = _tmp1697_;
		_tmp1699_ = vala_ccode_constant_new (_tmp1698_);
		_tmp1700_ = _tmp1699_;
		vala_ccode_function_add_assignment (_tmp1692_, (ValaCCodeExpression*) _tmp1696_, (ValaCCodeExpression*) _tmp1700_);
		_vala_ccode_node_unref0 (_tmp1700_);
		_g_free0 (_tmp1698_);
		_vala_ccode_node_unref0 (_tmp1696_);
		_vala_ccode_node_unref0 (_tmp1694_);
		_tmp1701_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1702_ = _tmp1701_;
		_tmp1703_ = async_call;
		vala_ccode_function_add_expression (_tmp1702_, (ValaCCodeExpression*) _tmp1703_);
		_tmp1704_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1705_ = _tmp1704_;
		_tmp1706_ = vala_ccode_constant_new ("FALSE");
		_tmp1707_ = _tmp1706_;
		vala_ccode_function_add_return (_tmp1705_, (ValaCCodeExpression*) _tmp1707_);
		_vala_ccode_node_unref0 (_tmp1707_);
		_tmp1708_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1709_ = _tmp1708_;
		_tmp1710_ = g_strdup_printf ("_state_%d", state);
		_tmp1711_ = _tmp1710_;
		vala_ccode_function_add_label (_tmp1709_, _tmp1711_);
		_g_free0 (_tmp1711_);
	}
	_tmp1712_ = vala_method_call_get_is_assert (expr);
	_tmp1713_ = _tmp1712_;
	if (_tmp1713_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1714_;
		ValaSourceReference* _tmp1715_;
		ValaSourceLocation _tmp1716_ = {0};
		ValaSourceLocation _tmp1717_;
		gchar* _tmp1718_;
		ValaSourceReference* _tmp1719_;
		ValaSourceReference* _tmp1720_;
		ValaSourceLocation _tmp1721_ = {0};
		ValaSourceLocation _tmp1722_;
		gchar* _tmp1723_;
		ValaSourceReference* _tmp1724_;
		ValaSourceReference* _tmp1725_;
		ValaSourceLocation _tmp1726_ = {0};
		ValaSourceLocation _tmp1727_;
		gchar* _tmp1728_;
		gchar* _tmp1729_;
		ValaCCodeFunctionCall* _tmp1730_;
		ValaCCodeIdentifier* _tmp1731_;
		ValaCCodeIdentifier* _tmp1732_;
		ValaCCodeFunctionCall* _tmp1733_;
		const gchar* _tmp1734_;
		gchar* _tmp1735_;
		gchar* _tmp1736_;
		gchar* _tmp1737_;
		gchar* _tmp1738_;
		gchar* _tmp1739_;
		gchar* _tmp1740_;
		ValaCCodeConstant* _tmp1741_;
		ValaCCodeConstant* _tmp1742_;
		_tmp1714_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1715_ = _tmp1714_;
		vala_source_reference_get_begin (_tmp1715_, &_tmp1716_);
		_tmp1717_ = _tmp1716_;
		_tmp1718_ = _tmp1717_.pos;
		_tmp1719_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1720_ = _tmp1719_;
		vala_source_reference_get_end (_tmp1720_, &_tmp1721_);
		_tmp1722_ = _tmp1721_;
		_tmp1723_ = _tmp1722_.pos;
		_tmp1724_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1725_ = _tmp1724_;
		vala_source_reference_get_begin (_tmp1725_, &_tmp1726_);
		_tmp1727_ = _tmp1726_;
		_tmp1728_ = _tmp1727_.pos;
		_tmp1729_ = string_substring ((const gchar*) _tmp1718_, (glong) 0, (glong) ((gint) (_tmp1723_ - _tmp1728_)));
		message = _tmp1729_;
		_tmp1730_ = ccall;
		_tmp1731_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1732_ = _tmp1731_;
		vala_ccode_function_call_set_call (_tmp1730_, (ValaCCodeExpression*) _tmp1732_);
		_vala_ccode_node_unref0 (_tmp1732_);
		_tmp1733_ = ccall;
		_tmp1734_ = message;
		_tmp1735_ = string_replace (_tmp1734_, "\n", " ");
		_tmp1736_ = _tmp1735_;
		_tmp1737_ = g_strescape (_tmp1736_, "");
		_tmp1738_ = _tmp1737_;
		_tmp1739_ = g_strdup_printf ("\"%s\"", _tmp1738_);
		_tmp1740_ = _tmp1739_;
		_tmp1741_ = vala_ccode_constant_new (_tmp1740_);
		_tmp1742_ = _tmp1741_;
		vala_ccode_function_call_add_argument (_tmp1733_, (ValaCCodeExpression*) _tmp1742_);
		_vala_ccode_node_unref0 (_tmp1742_);
		_g_free0 (_tmp1740_);
		_g_free0 (_tmp1738_);
		_g_free0 (_tmp1736_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1743_;
		ValaCCodeFunction* _tmp1744_;
		ValaCCodeExpression* _tmp1745_;
		ValaCCodeExpression* _tmp1746_;
		ValaCCodeExpression* _tmp1747_;
		_tmp1743_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1744_ = _tmp1743_;
		_tmp1745_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1744_, _tmp1745_);
		_tmp1746_ = out_param_ref;
		_tmp1747_ = _vala_ccode_node_ref0 (_tmp1746_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1747_;
	}
	_tmp1750_ = m;
	if (_tmp1750_ != NULL) {
		ValaMethod* _tmp1751_;
		ValaMemberBinding _tmp1752_;
		ValaMemberBinding _tmp1753_;
		_tmp1751_ = m;
		_tmp1752_ = vala_method_get_binding (_tmp1751_);
		_tmp1753_ = _tmp1752_;
		_tmp1749_ = _tmp1753_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1749_ = FALSE;
	}
	if (_tmp1749_) {
		ValaMethod* _tmp1754_;
		gboolean _tmp1755_;
		gboolean _tmp1756_;
		_tmp1754_ = m;
		_tmp1755_ = vala_method_get_returns_modified_pointer (_tmp1754_);
		_tmp1756_ = _tmp1755_;
		_tmp1748_ = _tmp1756_;
	} else {
		_tmp1748_ = FALSE;
	}
	if (_tmp1748_) {
		gboolean _tmp1757_ = FALSE;
		gboolean _tmp1758_ = FALSE;
		ValaMemberAccess* _tmp1759_;
		_tmp1759_ = ma;
		if (_tmp1759_ != NULL) {
			ValaMemberAccess* _tmp1760_;
			ValaExpression* _tmp1761_;
			ValaExpression* _tmp1762_;
			ValaSymbol* _tmp1763_;
			ValaSymbol* _tmp1764_;
			_tmp1760_ = ma;
			_tmp1761_ = vala_member_access_get_inner (_tmp1760_);
			_tmp1762_ = _tmp1761_;
			_tmp1763_ = vala_expression_get_symbol_reference (_tmp1762_);
			_tmp1764_ = _tmp1763_;
			_tmp1758_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1764_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1758_ = FALSE;
		}
		if (_tmp1758_) {
			ValaMemberAccess* _tmp1765_;
			ValaExpression* _tmp1766_;
			ValaExpression* _tmp1767_;
			_tmp1765_ = ma;
			_tmp1766_ = vala_member_access_get_inner (_tmp1765_);
			_tmp1767_ = _tmp1766_;
			_tmp1757_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1767_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1757_ = FALSE;
		}
		if (_tmp1757_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1768_;
			ValaExpression* _tmp1769_;
			ValaExpression* _tmp1770_;
			ValaSymbol* _tmp1771_;
			ValaSymbol* _tmp1772_;
			ValaProperty* _tmp1773_;
			ValaProperty* _tmp1774_;
			ValaMemberAccess* _tmp1775_;
			ValaExpression* _tmp1776_;
			ValaExpression* _tmp1777_;
			ValaExpression* _tmp1778_;
			ValaExpression* _tmp1779_;
			ValaDataType* _tmp1780_;
			ValaDataType* _tmp1781_;
			ValaCCodeExpression* _tmp1782_;
			ValaGLibValue* _tmp1783_;
			ValaGLibValue* _tmp1784_;
			_tmp1768_ = ma;
			_tmp1769_ = vala_member_access_get_inner (_tmp1768_);
			_tmp1770_ = _tmp1769_;
			_tmp1771_ = vala_expression_get_symbol_reference (_tmp1770_);
			_tmp1772_ = _tmp1771_;
			_tmp1773_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1772_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1773_;
			_tmp1774_ = prop;
			_tmp1775_ = ma;
			_tmp1776_ = vala_member_access_get_inner (_tmp1775_);
			_tmp1777_ = _tmp1776_;
			_tmp1778_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1777_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1779_ = _tmp1778_;
			_tmp1780_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1781_ = _tmp1780_;
			_tmp1782_ = ccall_expr;
			_tmp1783_ = vala_glib_value_new (_tmp1781_, _tmp1782_, FALSE);
			_tmp1784_ = _tmp1783_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1774_, _tmp1779_, (ValaTargetValue*) _tmp1784_);
			_vala_target_value_unref0 (_tmp1784_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1785_;
			ValaCCodeExpression* _tmp1786_;
			ValaCCodeAssignment* _tmp1787_;
			_tmp1785_ = instance;
			_tmp1786_ = ccall_expr;
			_tmp1787_ = vala_ccode_assignment_new (_tmp1785_, _tmp1786_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1787_;
		}
	}
	_tmp1793_ = m;
	if (_tmp1793_ != NULL) {
		ValaMethod* _tmp1794_;
		_tmp1794_ = m;
		_tmp1792_ = vala_get_ccode_simple_generics (_tmp1794_);
	} else {
		_tmp1792_ = FALSE;
	}
	if (_tmp1792_) {
		ValaMethod* _tmp1795_;
		ValaDataType* _tmp1796_;
		ValaDataType* _tmp1797_;
		_tmp1795_ = m;
		_tmp1796_ = vala_callable_get_return_type ((ValaCallable*) _tmp1795_);
		_tmp1797_ = _tmp1796_;
		_tmp1791_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1797_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1791_ = FALSE;
	}
	if (_tmp1791_) {
		ValaDataType* _tmp1798_;
		ValaDataType* _tmp1799_;
		_tmp1798_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1799_ = _tmp1798_;
		_tmp1790_ = vala_data_type_is_real_struct_type (_tmp1799_);
	} else {
		_tmp1790_ = FALSE;
	}
	if (_tmp1790_) {
		ValaDataType* _tmp1800_;
		ValaDataType* _tmp1801_;
		gboolean _tmp1802_;
		gboolean _tmp1803_;
		_tmp1800_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1801_ = _tmp1800_;
		_tmp1802_ = vala_data_type_get_nullable (_tmp1801_);
		_tmp1803_ = _tmp1802_;
		_tmp1789_ = !_tmp1803_;
	} else {
		_tmp1789_ = FALSE;
	}
	if (_tmp1789_) {
		ValaDataType* _tmp1804_;
		ValaDataType* _tmp1805_;
		_tmp1804_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1805_ = _tmp1804_;
		_tmp1788_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1805_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1788_ = FALSE;
	}
	if (_tmp1788_) {
		ValaCCodeExpression* _tmp1806_;
		ValaCCodeParenthesizedExpression* _tmp1807_;
		ValaCCodeParenthesizedExpression* _tmp1808_;
		ValaCCodeUnaryExpression* _tmp1809_;
		_tmp1806_ = ccall_expr;
		_tmp1807_ = vala_ccode_parenthesized_expression_new (_tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1809_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1808_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1809_;
		_vala_ccode_node_unref0 (_tmp1808_);
	}
	_tmp1812_ = m;
	if (_tmp1812_ != NULL) {
		ValaMethod* _tmp1813_;
		gchar* _tmp1814_;
		gchar* _tmp1815_;
		_tmp1813_ = m;
		_tmp1814_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1813_);
		_tmp1815_ = _tmp1814_;
		_tmp1811_ = _tmp1815_ != NULL;
		_g_free0 (_tmp1815_);
	} else {
		_tmp1811_ = FALSE;
	}
	if (_tmp1811_) {
		ValaMethod* _tmp1816_;
		gchar* _tmp1817_;
		gchar* _tmp1818_;
		ValaMethod* _tmp1819_;
		ValaDataType* _tmp1820_;
		ValaDataType* _tmp1821_;
		gchar* _tmp1822_;
		gchar* _tmp1823_;
		_tmp1816_ = m;
		_tmp1817_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = m;
		_tmp1820_ = vala_callable_get_return_type ((ValaCallable*) _tmp1819_);
		_tmp1821_ = _tmp1820_;
		_tmp1822_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1810_ = g_strcmp0 (_tmp1818_, _tmp1823_) != 0;
		_g_free0 (_tmp1823_);
		_g_free0 (_tmp1818_);
	} else {
		_tmp1810_ = FALSE;
	}
	if (_tmp1810_) {
		ValaCCodeExpression* _tmp1824_;
		ValaMethod* _tmp1825_;
		ValaDataType* _tmp1826_;
		ValaDataType* _tmp1827_;
		gchar* _tmp1828_;
		gchar* _tmp1829_;
		ValaCCodeCastExpression* _tmp1830_;
		_tmp1824_ = ccall_expr;
		_tmp1825_ = m;
		_tmp1826_ = vala_callable_get_return_type ((ValaCallable*) _tmp1825_);
		_tmp1827_ = _tmp1826_;
		_tmp1828_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1827_);
		_tmp1829_ = _tmp1828_;
		_tmp1830_ = vala_ccode_cast_expression_new (_tmp1824_, _tmp1829_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1830_;
		_g_free0 (_tmp1829_);
	}
	_tmp1831_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1831_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1832_;
		ValaIterator* _tmp1833_;
		ValaIterator* _tmp1834_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1835_;
		gpointer _tmp1836_;
		ValaExpression* _tmp1837_;
		ValaCCodeExpression* _tmp1838_;
		ValaCCodeExpression* _tmp1839_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1840_;
		ValaLocalVariable* _tmp1841_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1842_;
		const gchar* _tmp1843_;
		const gchar* _tmp1844_;
		ValaCCodeExpression* _tmp1845_;
		ValaLocalVariable* _tmp1846_;
		ValaCCodeFile* _tmp1847_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1848_;
		ValaExpression* _tmp1849_;
		ValaExpression* _tmp1850_;
		ValaCCodeExpression* _tmp1851_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1852_;
		ValaExpression* _tmp1853_;
		ValaExpression* _tmp1854_;
		ValaCCodeExpression* _tmp1855_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1856_;
		ValaExpression* _tmp1857_;
		ValaExpression* _tmp1858_;
		ValaDataType* _tmp1859_;
		ValaDataType* _tmp1860_;
		ValaArrayType* _tmp1861_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1862_;
		ValaDataType* _tmp1863_;
		ValaDataType* _tmp1864_;
		gchar* _tmp1865_;
		gchar* _tmp1866_;
		gchar* _tmp1867_;
		gchar* _tmp1868_;
		ValaCCodeIdentifier* _tmp1869_;
		ValaCCodeIdentifier* _tmp1870_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1871_;
		ValaCCodeExpression* _tmp1872_;
		ValaCCodeBinaryExpression* _tmp1873_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1874_;
		ValaCCodeExpression* _tmp1875_;
		ValaCCodeBinaryExpression* _tmp1876_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1877_;
		ValaCCodeIdentifier* _tmp1878_;
		ValaCCodeFunctionCall* _tmp1879_;
		ValaCCodeFunctionCall* _tmp1880_;
		ValaCCodeFunctionCall* _tmp1881_;
		ValaCCodeExpression* _tmp1882_;
		ValaCCodeExpression* _tmp1883_;
		ValaCCodeBinaryExpression* _tmp1884_;
		ValaCCodeBinaryExpression* _tmp1885_;
		ValaCCodeFunctionCall* _tmp1886_;
		ValaCCodeConstant* _tmp1887_;
		ValaCCodeConstant* _tmp1888_;
		ValaCCodeFunctionCall* _tmp1889_;
		ValaCCodeIdentifier* _tmp1890_;
		ValaCCodeBinaryExpression* _tmp1891_;
		ValaCCodeBinaryExpression* _tmp1892_;
		ValaCCodeBinaryExpression* _tmp1893_;
		ValaCCodeFunction* _tmp1894_;
		ValaCCodeFunction* _tmp1895_;
		ValaCCodeExpression* _tmp1896_;
		ValaCCodeExpression* _tmp1897_;
		ValaCCodeFunction* _tmp1898_;
		ValaCCodeFunction* _tmp1899_;
		ValaCCodeExpression* _tmp1900_;
		ValaCCodeFunction* _tmp1901_;
		ValaCCodeFunction* _tmp1902_;
		ValaCCodeBinaryExpression* _tmp1903_;
		ValaCCodeFunctionCall* _tmp1904_;
		ValaCCodeConstant* _tmp1905_;
		ValaCCodeConstant* _tmp1906_;
		ValaCCodeConditionalExpression* _tmp1907_;
		ValaCCodeConditionalExpression* _tmp1908_;
		ValaCCodeFunction* _tmp1909_;
		ValaCCodeFunction* _tmp1910_;
		ValaMemberAccess* _tmp1911_;
		ValaExpression* _tmp1912_;
		ValaExpression* _tmp1913_;
		ValaCCodeExpression* _tmp1914_;
		ValaCCodeExpression* _tmp1915_;
		ValaCCodeExpression* _tmp1916_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1917_;
		ValaExpression* _tmp1918_;
		ValaExpression* _tmp1919_;
		ValaSymbol* _tmp1920_;
		ValaSymbol* _tmp1921_;
		ValaSymbol* _tmp1922_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1923_;
		ValaLocalVariable* _tmp1924_;
		gboolean _tmp1925_ = FALSE;
		gboolean _tmp1926_ = FALSE;
		ValaSymbol* _tmp1927_;
		_tmp1832_ = vala_method_call_get_argument_list (expr);
		_tmp1833_ = vala_iterable_iterator ((ValaIterable*) _tmp1832_);
		arg_it = _tmp1833_;
		_tmp1834_ = arg_it;
		vala_iterator_next (_tmp1834_);
		_tmp1835_ = arg_it;
		_tmp1836_ = vala_iterator_get (_tmp1835_);
		_tmp1837_ = (ValaExpression*) _tmp1836_;
		_tmp1838_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1837_);
		_tmp1839_ = _tmp1838_;
		_vala_code_node_unref0 (_tmp1837_);
		new_size = _tmp1839_;
		_tmp1840_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1841_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1840_, TRUE, NULL, FALSE);
		temp_decl = _tmp1841_;
		_tmp1842_ = temp_decl;
		_tmp1843_ = vala_symbol_get_name ((ValaSymbol*) _tmp1842_);
		_tmp1844_ = _tmp1843_;
		_tmp1845_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1844_);
		temp_ref = _tmp1845_;
		_tmp1846_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1846_, FALSE);
		_tmp1847_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1847_, "string.h", FALSE);
		_tmp1848_ = ma;
		_tmp1849_ = vala_member_access_get_inner (_tmp1848_);
		_tmp1850_ = _tmp1849_;
		_tmp1851_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1850_, 1);
		clen = _tmp1851_;
		_tmp1852_ = ma;
		_tmp1853_ = vala_member_access_get_inner (_tmp1852_);
		_tmp1854_ = _tmp1853_;
		_tmp1855_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1854_);
		celems = _tmp1855_;
		_tmp1856_ = ma;
		_tmp1857_ = vala_member_access_get_inner (_tmp1856_);
		_tmp1858_ = _tmp1857_;
		_tmp1859_ = vala_expression_get_value_type (_tmp1858_);
		_tmp1860_ = _tmp1859_;
		_tmp1861_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1860_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1861_;
		_tmp1862_ = array_type;
		_tmp1863_ = vala_array_type_get_element_type (_tmp1862_);
		_tmp1864_ = _tmp1863_;
		_tmp1865_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1864_);
		_tmp1866_ = _tmp1865_;
		_tmp1867_ = g_strdup_printf ("sizeof (%s)", _tmp1866_);
		_tmp1868_ = _tmp1867_;
		_tmp1869_ = vala_ccode_identifier_new (_tmp1868_);
		_tmp1870_ = _tmp1869_;
		_g_free0 (_tmp1868_);
		_g_free0 (_tmp1866_);
		csizeof = _tmp1870_;
		_tmp1871_ = temp_ref;
		_tmp1872_ = clen;
		_tmp1873_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1871_, _tmp1872_);
		cdelta = _tmp1873_;
		_tmp1874_ = temp_ref;
		_tmp1875_ = clen;
		_tmp1876_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1874_, _tmp1875_);
		ccheck = _tmp1876_;
		_tmp1877_ = vala_ccode_identifier_new ("memset");
		_tmp1878_ = _tmp1877_;
		_tmp1879_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1878_);
		_tmp1880_ = _tmp1879_;
		_vala_ccode_node_unref0 (_tmp1878_);
		czero = _tmp1880_;
		_tmp1881_ = czero;
		_tmp1882_ = celems;
		_tmp1883_ = clen;
		_tmp1884_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1882_, _tmp1883_);
		_tmp1885_ = _tmp1884_;
		vala_ccode_function_call_add_argument (_tmp1881_, (ValaCCodeExpression*) _tmp1885_);
		_vala_ccode_node_unref0 (_tmp1885_);
		_tmp1886_ = czero;
		_tmp1887_ = vala_ccode_constant_new ("0");
		_tmp1888_ = _tmp1887_;
		vala_ccode_function_call_add_argument (_tmp1886_, (ValaCCodeExpression*) _tmp1888_);
		_vala_ccode_node_unref0 (_tmp1888_);
		_tmp1889_ = czero;
		_tmp1890_ = csizeof;
		_tmp1891_ = cdelta;
		_tmp1892_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1890_, (ValaCCodeExpression*) _tmp1891_);
		_tmp1893_ = _tmp1892_;
		vala_ccode_function_call_add_argument (_tmp1889_, (ValaCCodeExpression*) _tmp1893_);
		_vala_ccode_node_unref0 (_tmp1893_);
		_tmp1894_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1895_ = _tmp1894_;
		_tmp1896_ = temp_ref;
		_tmp1897_ = new_size;
		vala_ccode_function_add_assignment (_tmp1895_, _tmp1896_, _tmp1897_);
		_tmp1898_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1899_ = _tmp1898_;
		_tmp1900_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1899_, _tmp1900_);
		_tmp1901_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1902_ = _tmp1901_;
		_tmp1903_ = ccheck;
		_tmp1904_ = czero;
		_tmp1905_ = vala_ccode_constant_new ("NULL");
		_tmp1906_ = _tmp1905_;
		_tmp1907_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1903_, (ValaCCodeExpression*) _tmp1904_, (ValaCCodeExpression*) _tmp1906_);
		_tmp1908_ = _tmp1907_;
		vala_ccode_function_add_expression (_tmp1902_, (ValaCCodeExpression*) _tmp1908_);
		_vala_ccode_node_unref0 (_tmp1908_);
		_vala_ccode_node_unref0 (_tmp1906_);
		_tmp1909_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1910_ = _tmp1909_;
		_tmp1911_ = ma;
		_tmp1912_ = vala_member_access_get_inner (_tmp1911_);
		_tmp1913_ = _tmp1912_;
		_tmp1914_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1913_, 1);
		_tmp1915_ = _tmp1914_;
		_tmp1916_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1910_, _tmp1915_, _tmp1916_);
		_vala_ccode_node_unref0 (_tmp1915_);
		_tmp1917_ = ma;
		_tmp1918_ = vala_member_access_get_inner (_tmp1917_);
		_tmp1919_ = _tmp1918_;
		_tmp1920_ = vala_expression_get_symbol_reference (_tmp1919_);
		_tmp1921_ = _tmp1920_;
		_tmp1922_ = _vala_code_node_ref0 (_tmp1921_);
		array_var = _tmp1922_;
		_tmp1923_ = array_var;
		_tmp1924_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1923_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1923_) : NULL);
		array_local = _tmp1924_;
		_tmp1927_ = array_var;
		if (_tmp1927_ != NULL) {
			ValaSymbol* _tmp1928_;
			_tmp1928_ = array_var;
			_tmp1926_ = vala_symbol_is_internal_symbol (_tmp1928_);
		} else {
			_tmp1926_ = FALSE;
		}
		if (_tmp1926_) {
			gboolean _tmp1929_ = FALSE;
			gboolean _tmp1930_ = FALSE;
			ValaSymbol* _tmp1931_;
			_tmp1931_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1931_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1932_;
				gboolean _tmp1933_;
				gboolean _tmp1934_;
				_tmp1932_ = array_local;
				_tmp1933_ = vala_local_variable_get_captured (_tmp1932_);
				_tmp1934_ = _tmp1933_;
				_tmp1930_ = !_tmp1934_;
			} else {
				_tmp1930_ = FALSE;
			}
			if (_tmp1930_) {
				_tmp1929_ = TRUE;
			} else {
				ValaSymbol* _tmp1935_;
				_tmp1935_ = array_var;
				_tmp1929_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1935_, VALA_TYPE_FIELD);
			}
			_tmp1925_ = _tmp1929_;
		} else {
			_tmp1925_ = FALSE;
		}
		if (_tmp1925_) {
			ValaCCodeFunction* _tmp1936_;
			ValaCCodeFunction* _tmp1937_;
			ValaMemberAccess* _tmp1938_;
			ValaExpression* _tmp1939_;
			ValaExpression* _tmp1940_;
			ValaTargetValue* _tmp1941_;
			ValaTargetValue* _tmp1942_;
			ValaCCodeExpression* _tmp1943_;
			ValaCCodeExpression* _tmp1944_;
			ValaCCodeExpression* _tmp1945_;
			_tmp1936_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1937_ = _tmp1936_;
			_tmp1938_ = ma;
			_tmp1939_ = vala_member_access_get_inner (_tmp1938_);
			_tmp1940_ = _tmp1939_;
			_tmp1941_ = vala_expression_get_target_value (_tmp1940_);
			_tmp1942_ = _tmp1941_;
			_tmp1943_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1942_);
			_tmp1944_ = _tmp1943_;
			_tmp1945_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1937_, _tmp1944_, _tmp1945_);
			_vala_ccode_node_unref0 (_tmp1944_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1947_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1948_ = _tmp1947_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1948_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1949_;
		ValaDataType* _tmp1950_;
		_tmp1949_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1950_ = _tmp1949_;
		_tmp1946_ = !vala_data_type_is_disposable (_tmp1950_);
	} else {
		_tmp1946_ = FALSE;
	}
	if (_tmp1946_) {
		gboolean _tmp1951_ = FALSE;
		ValaCCodeExpression* _tmp1952_;
		_tmp1952_ = ccall_expr;
		if (_tmp1952_ != NULL) {
			_tmp1951_ = !return_result_via_out_param;
		} else {
			_tmp1951_ = FALSE;
		}
		if (_tmp1951_) {
			ValaCCodeFunction* _tmp1953_;
			ValaCCodeFunction* _tmp1954_;
			ValaCCodeExpression* _tmp1955_;
			_tmp1953_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1954_ = _tmp1953_;
			_tmp1955_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1954_, _tmp1955_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1956_;
		ValaDataType* _tmp1957_;
		ValaDataType* _tmp1958_;
		gboolean _tmp1959_ = FALSE;
		ValaDataType* _tmp1960_;
		ValaDataType* _tmp1961_;
		gboolean _tmp2014_ = FALSE;
		ValaMethod* _tmp2015_;
		_tmp1956_ = itype;
		_tmp1957_ = vala_data_type_get_return_type (_tmp1956_);
		_tmp1958_ = _vala_code_node_ref0 (_tmp1957_);
		result_type = _tmp1958_;
		_tmp1960_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1961_ = _tmp1960_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1961_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1962_;
			ValaDataType* _tmp1963_;
			_tmp1962_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1963_ = _tmp1962_;
			_tmp1959_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1963_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1959_ = FALSE;
		}
		if (_tmp1959_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1964_;
			ValaDataType* _tmp1965_;
			ValaTypeParameter* _tmp1966_;
			ValaTypeParameter* _tmp1967_;
			ValaTypeParameter* _tmp1968_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1969_;
			ValaSymbol* _tmp1970_;
			ValaSymbol* _tmp1971_;
			ValaSymbol* _tmp1972_;
			ValaSymbol* _tmp1973_;
			ValaStruct* _tmp1974_;
			gboolean _tmp1975_ = FALSE;
			ValaTypeParameter* _tmp1976_;
			ValaSymbol* _tmp1977_;
			ValaSymbol* _tmp1978_;
			ValaTypeSymbol* _tmp1979_;
			gboolean _tmp1988_ = FALSE;
			gboolean _tmp1989_ = FALSE;
			ValaStruct* _tmp1990_;
			_tmp1964_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1965_ = _tmp1964_;
			_tmp1966_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1965_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1967_ = _tmp1966_;
			_tmp1968_ = _vala_code_node_ref0 (_tmp1967_);
			type_parameter = _tmp1968_;
			_tmp1969_ = type_parameter;
			_tmp1970_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1969_);
			_tmp1971_ = _tmp1970_;
			_tmp1972_ = vala_symbol_get_parent_symbol (_tmp1971_);
			_tmp1973_ = _tmp1972_;
			_tmp1974_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1973_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1973_) : NULL);
			st = _tmp1974_;
			_tmp1976_ = type_parameter;
			_tmp1977_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1976_);
			_tmp1978_ = _tmp1977_;
			_tmp1979_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1978_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1979_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1975_ = TRUE;
			} else {
				gboolean _tmp1980_ = FALSE;
				ValaStruct* _tmp1981_;
				_tmp1981_ = st;
				if (_tmp1981_ != NULL) {
					ValaStruct* _tmp1982_;
					gchar* _tmp1983_;
					gchar* _tmp1984_;
					_tmp1982_ = st;
					_tmp1983_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1982_);
					_tmp1984_ = _tmp1983_;
					_tmp1980_ = g_strcmp0 (_tmp1984_, "va_list") == 0;
					_g_free0 (_tmp1984_);
				} else {
					_tmp1980_ = FALSE;
				}
				_tmp1975_ = _tmp1980_;
			}
			if (_tmp1975_) {
				ValaDataType* _tmp1985_;
				ValaDataType* _tmp1986_;
				ValaDataType* _tmp1987_;
				_tmp1985_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1986_ = _tmp1985_;
				_tmp1987_ = _vala_code_node_ref0 (_tmp1986_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1987_;
			}
			_tmp1990_ = st;
			if (_tmp1990_ != NULL) {
				ValaStruct* _tmp1991_;
				gchar* _tmp1992_;
				gchar* _tmp1993_;
				_tmp1991_ = st;
				_tmp1992_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1991_);
				_tmp1993_ = _tmp1992_;
				_tmp1989_ = g_strcmp0 (_tmp1993_, "va_list") == 0;
				_g_free0 (_tmp1993_);
			} else {
				_tmp1989_ = FALSE;
			}
			if (_tmp1989_) {
				ValaMemberAccess* _tmp1994_;
				const gchar* _tmp1995_;
				const gchar* _tmp1996_;
				_tmp1994_ = ma;
				_tmp1995_ = vala_member_access_get_member_name (_tmp1994_);
				_tmp1996_ = _tmp1995_;
				_tmp1988_ = g_strcmp0 (_tmp1996_, "arg") == 0;
			} else {
				_tmp1988_ = FALSE;
			}
			if (_tmp1988_) {
				gboolean _tmp1997_ = FALSE;
				ValaDataType* _tmp1998_;
				_tmp1998_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1998_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp1999_;
					ValaDelegate* _tmp2000_;
					ValaDelegate* _tmp2001_;
					gboolean _tmp2002_;
					gboolean _tmp2003_;
					_tmp1999_ = result_type;
					_tmp2000_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1999_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2001_ = _tmp2000_;
					_tmp2002_ = vala_delegate_get_has_target (_tmp2001_);
					_tmp2003_ = _tmp2002_;
					_tmp1997_ = _tmp2003_;
				} else {
					_tmp1997_ = FALSE;
				}
				if (_tmp1997_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2004_;
					ValaTargetValue* _tmp2005_;
					ValaGLibValue* _tmp2006_;
					ValaCCodeExpression* _tmp2007_;
					ValaGLibValue* _tmp2010_;
					ValaCCodeExpression* _tmp2011_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, NULL);
					_tmp2004_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2005_ = _tmp2004_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2005_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2006_ = arg_value;
					_tmp2007_ = _tmp2006_->delegate_target_cvalue;
					if (_tmp2007_ == NULL) {
						ValaGLibValue* _tmp2008_;
						ValaCCodeConstant* _tmp2009_;
						_tmp2008_ = arg_value;
						_tmp2009_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2008_->delegate_target_cvalue);
						_tmp2008_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2009_;
					}
					_tmp2010_ = arg_value;
					_tmp2011_ = _tmp2010_->delegate_target_destroy_notify_cvalue;
					if (_tmp2011_ == NULL) {
						ValaGLibValue* _tmp2012_;
						ValaCCodeConstant* _tmp2013_;
						_tmp2012_ = arg_value;
						_tmp2013_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2012_->delegate_target_destroy_notify_cvalue);
						_tmp2012_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2013_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2015_ = m;
		if (_tmp2015_ != NULL) {
			ValaMethod* _tmp2016_;
			_tmp2016_ = m;
			_tmp2014_ = vala_method_get_format_arg_index (_tmp2016_) >= 0;
		} else {
			_tmp2014_ = FALSE;
		}
		if (_tmp2014_) {
			ValaCCodeExpression* _tmp2017_;
			_tmp2017_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2017_);
		} else {
			gboolean _tmp2018_ = FALSE;
			ValaMethod* _tmp2019_;
			_tmp2019_ = m;
			if (_tmp2019_ != NULL) {
				ValaMethod* _tmp2020_;
				_tmp2020_ = m;
				_tmp2018_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2020_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2018_ = FALSE;
			}
			if (_tmp2018_) {
				ValaCCodeExpression* _tmp2021_;
				_tmp2021_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2021_);
			} else {
				gboolean _tmp2022_ = FALSE;
				gboolean _tmp2023_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2023_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2023_ = FALSE;
				}
				if (_tmp2023_) {
					gboolean _tmp2024_ = FALSE;
					ValaDataType* _tmp2025_;
					_tmp2025_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2025_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2026_;
						_tmp2026_ = result_type;
						_tmp2024_ = !vala_data_type_is_disposable (_tmp2026_);
					} else {
						_tmp2024_ = FALSE;
					}
					_tmp2022_ = _tmp2024_;
				} else {
					_tmp2022_ = FALSE;
				}
				if (_tmp2022_) {
					ValaCCodeExpression* _tmp2027_;
					_tmp2027_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2027_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2028_;
						ValaDataType* _tmp2029_;
						gboolean _tmp2030_;
						gboolean _tmp2031_;
						ValaLocalVariable* _tmp2032_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2033_;
						const gchar* _tmp2034_;
						const gchar* _tmp2035_;
						ValaCCodeExpression* _tmp2036_;
						ValaLocalVariable* _tmp2037_;
						ValaCCodeFunction* _tmp2038_;
						ValaCCodeFunction* _tmp2039_;
						ValaCCodeExpression* _tmp2040_;
						ValaCCodeExpression* _tmp2041_;
						ValaCCodeExpression* _tmp2042_;
						ValaTargetValue* _tmp2043_;
						ValaTargetValue* _tmp2044_;
						_tmp2028_ = result_type;
						_tmp2029_ = result_type;
						_tmp2030_ = vala_data_type_get_value_owned (_tmp2029_);
						_tmp2031_ = _tmp2030_;
						_tmp2032_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2028_, _tmp2031_, NULL, FALSE);
						temp_var = _tmp2032_;
						_tmp2033_ = temp_var;
						_tmp2034_ = vala_symbol_get_name ((ValaSymbol*) _tmp2033_);
						_tmp2035_ = _tmp2034_;
						_tmp2036_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2035_);
						temp_ref = _tmp2036_;
						_tmp2037_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2037_, FALSE);
						_tmp2038_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2039_ = _tmp2038_;
						_tmp2040_ = temp_ref;
						_tmp2041_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2039_, _tmp2040_, _tmp2041_);
						_tmp2042_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2042_);
						_tmp2043_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2044_ = _tmp2043_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2044_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2045_;
						ValaTargetValue* _tmp2046_;
						ValaTargetValue* _tmp2047_;
						_tmp2045_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2045_);
						_tmp2046_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2047_ = _tmp2046_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2047_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2048_ = params;
	_tmp2049_ = vala_iterable_iterator ((ValaIterable*) _tmp2048_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2049_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2050_;
		ValaList* _tmp2051_;
		gint _arg_size = 0;
		ValaList* _tmp2052_;
		gint _tmp2053_;
		gint _tmp2054_;
		gint _arg_index = 0;
		_tmp2050_ = vala_method_call_get_argument_list (expr);
		_tmp2051_ = _vala_iterable_ref0 (_tmp2050_);
		_arg_list = _tmp2051_;
		_tmp2052_ = _arg_list;
		_tmp2053_ = vala_collection_get_size ((ValaCollection*) _tmp2052_);
		_tmp2054_ = _tmp2053_;
		_arg_size = _tmp2054_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp2055_;
			gpointer _tmp2056_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2057_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2060_;
			ValaUnaryExpression* _tmp2061_;
			gboolean _tmp2062_ = FALSE;
			ValaUnaryExpression* _tmp2063_;
			ValaUnaryExpression* _tmp2067_;
			ValaExpression* _tmp2068_;
			ValaExpression* _tmp2069_;
			ValaDataType* _tmp2070_;
			ValaDataType* _tmp2071_;
			ValaUnaryExpression* _tmp2081_;
			ValaExpression* _tmp2082_;
			ValaExpression* _tmp2083_;
			ValaTargetValue* _tmp2084_;
			ValaTargetValue* _tmp2085_;
			ValaUnaryExpression* _tmp2086_;
			ValaTargetValue* _tmp2087_;
			ValaTargetValue* _tmp2088_;
			ValaUnaryExpression* _tmp2089_;
			ValaExpression* _tmp2090_;
			ValaExpression* _tmp2091_;
			ValaDataType* _tmp2092_;
			ValaDataType* _tmp2093_;
			ValaExpression* _tmp2094_;
			ValaTargetValue* _tmp2095_;
			ValaTargetValue* _tmp2096_;
			ValaSourceReference* _tmp2097_;
			ValaSourceReference* _tmp2098_;
			gboolean _tmp2099_ = FALSE;
			ValaParameter* _tmp2100_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp2055_ = _arg_list;
			_tmp2056_ = vala_list_get (_tmp2055_, _arg_index);
			arg = (ValaExpression*) _tmp2056_;
			param = NULL;
			_tmp2057_ = params_it;
			if (vala_iterator_next (_tmp2057_)) {
				ValaIterator* _tmp2058_;
				gpointer _tmp2059_;
				_tmp2058_ = params_it;
				_tmp2059_ = vala_iterator_get (_tmp2058_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2059_;
			}
			_tmp2060_ = arg;
			_tmp2061_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2060_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2060_) : NULL);
			unary = _tmp2061_;
			_tmp2063_ = unary;
			if (_tmp2063_ == NULL) {
				_tmp2062_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2064_;
				ValaUnaryOperator _tmp2065_;
				ValaUnaryOperator _tmp2066_;
				_tmp2064_ = unary;
				_tmp2065_ = vala_unary_expression_get_operator (_tmp2064_);
				_tmp2066_ = _tmp2065_;
				_tmp2062_ = _tmp2066_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2062_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2067_ = unary;
			_tmp2068_ = vala_unary_expression_get_inner (_tmp2067_);
			_tmp2069_ = _tmp2068_;
			_tmp2070_ = vala_expression_get_value_type (_tmp2069_);
			_tmp2071_ = _tmp2070_;
			if (vala_ccode_base_module_requires_destroy (_tmp2071_)) {
				ValaCCodeFunction* _tmp2072_;
				ValaCCodeFunction* _tmp2073_;
				ValaUnaryExpression* _tmp2074_;
				ValaExpression* _tmp2075_;
				ValaExpression* _tmp2076_;
				ValaTargetValue* _tmp2077_;
				ValaTargetValue* _tmp2078_;
				ValaCCodeExpression* _tmp2079_;
				ValaCCodeExpression* _tmp2080_;
				_tmp2072_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2073_ = _tmp2072_;
				_tmp2074_ = unary;
				_tmp2075_ = vala_unary_expression_get_inner (_tmp2074_);
				_tmp2076_ = _tmp2075_;
				_tmp2077_ = vala_expression_get_target_value (_tmp2076_);
				_tmp2078_ = _tmp2077_;
				_tmp2079_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2078_, FALSE);
				_tmp2080_ = _tmp2079_;
				vala_ccode_function_add_expression (_tmp2073_, _tmp2080_);
				_vala_ccode_node_unref0 (_tmp2080_);
			}
			_tmp2081_ = unary;
			_tmp2082_ = vala_unary_expression_get_inner (_tmp2081_);
			_tmp2083_ = _tmp2082_;
			_tmp2084_ = vala_expression_get_target_value (_tmp2083_);
			_tmp2085_ = _tmp2084_;
			_tmp2086_ = unary;
			_tmp2087_ = vala_expression_get_target_value ((ValaExpression*) _tmp2086_);
			_tmp2088_ = _tmp2087_;
			_tmp2089_ = unary;
			_tmp2090_ = vala_unary_expression_get_inner (_tmp2089_);
			_tmp2091_ = _tmp2090_;
			_tmp2092_ = vala_expression_get_value_type (_tmp2091_);
			_tmp2093_ = _tmp2092_;
			_tmp2094_ = arg;
			_tmp2095_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2088_, _tmp2093_, (ValaCodeNode*) _tmp2094_);
			_tmp2096_ = _tmp2095_;
			_tmp2097_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2098_ = _tmp2097_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2085_, _tmp2096_, _tmp2098_);
			_vala_target_value_unref0 (_tmp2096_);
			_tmp2100_ = param;
			if (_tmp2100_ != NULL) {
				ValaParameter* _tmp2101_;
				_tmp2101_ = param;
				_tmp2099_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2101_);
			} else {
				_tmp2099_ = FALSE;
			}
			if (_tmp2099_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2102_;
				ValaCCodeIdentifier* _tmp2103_;
				ValaCCodeFunctionCall* _tmp2104_;
				ValaCCodeFunctionCall* _tmp2105_;
				ValaCCodeFunctionCall* _tmp2106_;
				ValaUnaryExpression* _tmp2107_;
				ValaExpression* _tmp2108_;
				ValaExpression* _tmp2109_;
				ValaTargetValue* _tmp2110_;
				ValaTargetValue* _tmp2111_;
				ValaCCodeExpression* _tmp2112_;
				ValaCCodeExpression* _tmp2113_;
				ValaCCodeFunction* _tmp2114_;
				ValaCCodeFunction* _tmp2115_;
				ValaUnaryExpression* _tmp2116_;
				ValaExpression* _tmp2117_;
				ValaExpression* _tmp2118_;
				ValaTargetValue* _tmp2119_;
				ValaTargetValue* _tmp2120_;
				ValaCCodeExpression* _tmp2121_;
				ValaCCodeExpression* _tmp2122_;
				ValaCCodeFunctionCall* _tmp2123_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2102_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2103_ = _tmp2102_;
				_tmp2104_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2103_);
				_tmp2105_ = _tmp2104_;
				_vala_ccode_node_unref0 (_tmp2103_);
				len_call = _tmp2105_;
				_tmp2106_ = len_call;
				_tmp2107_ = unary;
				_tmp2108_ = vala_unary_expression_get_inner (_tmp2107_);
				_tmp2109_ = _tmp2108_;
				_tmp2110_ = vala_expression_get_target_value (_tmp2109_);
				_tmp2111_ = _tmp2110_;
				_tmp2112_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2111_);
				_tmp2113_ = _tmp2112_;
				vala_ccode_function_call_add_argument (_tmp2106_, _tmp2113_);
				_vala_ccode_node_unref0 (_tmp2113_);
				_tmp2114_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2115_ = _tmp2114_;
				_tmp2116_ = unary;
				_tmp2117_ = vala_unary_expression_get_inner (_tmp2116_);
				_tmp2118_ = _tmp2117_;
				_tmp2119_ = vala_expression_get_target_value (_tmp2118_);
				_tmp2120_ = _tmp2119_;
				_tmp2121_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2120_, 1);
				_tmp2122_ = _tmp2121_;
				_tmp2123_ = len_call;
				vala_ccode_function_add_assignment (_tmp2115_, _tmp2122_, (ValaCCodeExpression*) _tmp2123_);
				_vala_ccode_node_unref0 (_tmp2122_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2126_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2126_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2127_;
		ValaSymbol* _tmp2128_;
		ValaSymbol* _tmp2129_;
		_tmp2127_ = m;
		_tmp2128_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2127_);
		_tmp2129_ = _tmp2128_;
		_tmp2125_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2129_, VALA_TYPE_CLASS);
	} else {
		_tmp2125_ = FALSE;
	}
	if (_tmp2125_) {
		gboolean _tmp2130_ = FALSE;
		gboolean _tmp2131_ = FALSE;
		ValaClass* _tmp2132_;
		ValaClass* _tmp2133_;
		gboolean _tmp2134_;
		gboolean _tmp2135_;
		_tmp2132_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2133_ = _tmp2132_;
		_tmp2134_ = vala_class_get_is_compact (_tmp2133_);
		_tmp2135_ = _tmp2134_;
		if (_tmp2135_) {
			ValaClass* _tmp2136_;
			ValaClass* _tmp2137_;
			ValaClass* _tmp2138_;
			ValaClass* _tmp2139_;
			_tmp2136_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2137_ = _tmp2136_;
			_tmp2138_ = vala_class_get_base_class (_tmp2137_);
			_tmp2139_ = _tmp2138_;
			_tmp2131_ = _tmp2139_ != NULL;
		} else {
			_tmp2131_ = FALSE;
		}
		if (_tmp2131_) {
			_tmp2130_ = TRUE;
		} else {
			ValaClass* _tmp2140_;
			ValaClass* _tmp2141_;
			ValaClass* _tmp2142_;
			ValaClass* _tmp2143_;
			ValaClass* _tmp2144_;
			_tmp2140_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2141_ = _tmp2140_;
			_tmp2142_ = vala_class_get_base_class (_tmp2141_);
			_tmp2143_ = _tmp2142_;
			_tmp2144_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2130_ = _tmp2143_ == _tmp2144_;
		}
		_tmp2124_ = _tmp2130_;
	} else {
		_tmp2124_ = FALSE;
	}
	if (_tmp2124_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2145_;
		ValaClass* _tmp2146_;
		gchar* _tmp2147_;
		gchar* _tmp2148_;
		gchar* _tmp2149_;
		gchar* _tmp2150_;
		ValaCCodeIdentifier* _tmp2151_;
		ValaCCodeIdentifier* _tmp2152_;
		ValaCCodeFunctionCall* _tmp2153_;
		ValaCCodeFunctionCall* _tmp2154_;
		ValaCCodeFunctionCall* _tmp2155_;
		ValaCCodeExpression* _tmp2156_;
		ValaCCodeExpression* _tmp2157_;
		ValaClass* _tmp2158_;
		ValaClass* _tmp2159_;
		gboolean _tmp2160_;
		gboolean _tmp2161_;
		ValaCCodeFunction* _tmp2165_;
		ValaCCodeFunction* _tmp2166_;
		ValaCCodeFunctionCall* _tmp2167_;
		_tmp2145_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2146_ = _tmp2145_;
		_tmp2147_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2146_, NULL);
		_tmp2148_ = _tmp2147_;
		_tmp2149_ = g_strdup_printf ("%s_instance_init", _tmp2148_);
		_tmp2150_ = _tmp2149_;
		_tmp2151_ = vala_ccode_identifier_new (_tmp2150_);
		_tmp2152_ = _tmp2151_;
		_tmp2153_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2152_);
		_tmp2154_ = _tmp2153_;
		_vala_ccode_node_unref0 (_tmp2152_);
		_g_free0 (_tmp2150_);
		_g_free0 (_tmp2148_);
		cinitcall = _tmp2154_;
		_tmp2155_ = cinitcall;
		_tmp2156_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2157_ = _tmp2156_;
		vala_ccode_function_call_add_argument (_tmp2155_, _tmp2157_);
		_vala_ccode_node_unref0 (_tmp2157_);
		_tmp2158_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2159_ = _tmp2158_;
		_tmp2160_ = vala_class_get_is_compact (_tmp2159_);
		_tmp2161_ = _tmp2160_;
		if (!_tmp2161_) {
			ValaCCodeFunctionCall* _tmp2162_;
			ValaCCodeConstant* _tmp2163_;
			ValaCCodeConstant* _tmp2164_;
			_tmp2162_ = cinitcall;
			_tmp2163_ = vala_ccode_constant_new ("NULL");
			_tmp2164_ = _tmp2163_;
			vala_ccode_function_call_add_argument (_tmp2162_, (ValaCCodeExpression*) _tmp2164_);
			_vala_ccode_node_unref0 (_tmp2164_);
		}
		_tmp2165_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2166_ = _tmp2165_;
		_tmp2167_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2166_, (ValaCCodeExpression*) _tmp2167_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeFile* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaEnumValue* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaEnumValue* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp25_ = _enum_value_list;
			_tmp26_ = vala_list_get (_tmp25_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp26_;
			_tmp27_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp28_ = _tmp27_;
			_tmp29_ = enum_value;
			_tmp30_ = vala_get_ccode_name ((ValaCodeNode*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_ccode_identifier_new (_tmp31_);
			_tmp33_ = _tmp32_;
			vala_ccode_function_add_case (_tmp28_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
			_g_free0 (_tmp31_);
			_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = enum_value;
			_tmp37_ = vala_get_ccode_name ((ValaCodeNode*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat ("\"", _tmp38_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp40_, "\"", NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_ccode_constant_new (_tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_function_add_return (_tmp35_, (ValaCCodeExpression*) _tmp44_);
			_vala_ccode_node_unref0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp46_ = _tmp45_;
	vala_ccode_function_close (_tmp46_);
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_ccode_constant_new ("NULL");
	_tmp50_ = _tmp49_;
	vala_ccode_function_add_return (_tmp48_, (ValaCCodeExpression*) _tmp50_);
	_vala_ccode_node_unref0 (_tmp50_);
	_tmp51_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp52_ = function;
	vala_ccode_file_add_function_declaration (_tmp51_, _tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function (_tmp53_, _tmp54_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaUnaryExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp7_) : NULL;
			_tmp9_ = unary;
			if (_tmp9_ != NULL) {
				gboolean _tmp10_ = FALSE;
				ValaUnaryExpression* _tmp11_;
				ValaUnaryOperator _tmp12_;
				ValaUnaryOperator _tmp13_;
				_tmp11_ = unary;
				_tmp12_ = vala_unary_expression_get_operator (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp10_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp14_;
					ValaUnaryOperator _tmp15_;
					ValaUnaryOperator _tmp16_;
					_tmp14_ = unary;
					_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp10_ = _tmp16_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp8_ = _tmp10_;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

