/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};

static gpointer vala_ccode_compiler_parent_class = NULL;

static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj);

ValaCCodeCompiler*
vala_ccode_compiler_construct (GType object_type)
{
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}

ValaCCodeCompiler*
vala_ccode_compiler_new (void)
{
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}

/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
vala_ccode_compiler_compile (ValaCCodeCompiler* self,
                             ValaCodeContext* context,
                             const gchar* cc_command,
                             gchar** cc_options,
                             gint cc_options_length1)
{
	gchar* pc = NULL;
	gchar* _tmp0_;
	ValaProfile _tmp1_;
	ValaProfile _tmp2_;
	gchar* pkgflags = NULL;
	const gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* cmdline = NULL;
	gchar* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	ValaList* source_files = NULL;
	ValaList* _tmp59_;
	ValaList* _tmp60_;
	ValaList* c_source_files = NULL;
	ValaList* _tmp80_;
	ValaList* _tmp81_;
	const gchar* _tmp96_;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gboolean _tmp111_;
	gboolean _tmp112_;
	gboolean _tmp121_;
	gboolean _tmp122_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_strdup ("");
	pc = _tmp0_;
	_tmp1_ = vala_code_context_get_profile (context);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_PROFILE_GOBJECT) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = pc;
		_tmp4_ = g_strconcat (_tmp3_, " gobject-2.0", NULL);
		_g_free0 (pc);
		pc = _tmp4_;
	}
	{
		ValaList* _pkg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _pkg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _pkg_index = 0;
		_tmp5_ = vala_code_context_get_packages (context);
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_pkg_list = _tmp6_;
		_tmp7_ = _pkg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_pkg_size = _tmp9_;
		_pkg_index = -1;
		while (TRUE) {
			gchar* pkg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
			_pkg_index = _pkg_index + 1;
			if (!(_pkg_index < _pkg_size)) {
				break;
			}
			_tmp10_ = _pkg_list;
			_tmp11_ = vala_list_get (_tmp10_, _pkg_index);
			pkg = (gchar*) _tmp11_;
			_tmp12_ = pkg;
			if (vala_code_context_pkg_config_exists (context, _tmp12_)) {
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp13_ = pc;
				_tmp14_ = pkg;
				_tmp15_ = g_strconcat (" ", _tmp14_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
				_g_free0 (pc);
				pc = _tmp17_;
				_g_free0 (_tmp16_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp18_ = pc;
	_tmp19_ = strlen (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ > 0) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = pc;
		_tmp22_ = vala_code_context_pkg_config_compile_flags (context, _tmp21_);
		_g_free0 (pkgflags);
		pkgflags = _tmp22_;
		_tmp23_ = pkgflags;
		if (_tmp23_ == NULL) {
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
	} else {
		gchar* _tmp24_;
		_tmp24_ = g_strdup ("");
		_g_free0 (pkgflags);
		pkgflags = _tmp24_;
	}
	if (cc_command == NULL) {
		cc_command = "cc";
	}
	_tmp25_ = g_strdup (cc_command);
	cmdline = _tmp25_;
	_tmp26_ = vala_code_context_get_debug (context);
	_tmp27_ = _tmp26_;
	if (_tmp27_) {
		const gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp28_ = cmdline;
		_tmp29_ = g_strconcat (_tmp28_, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp29_;
	}
	_tmp30_ = vala_code_context_get_compile_only (context);
	_tmp31_ = _tmp30_;
	if (_tmp31_) {
		const gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp32_ = cmdline;
		_tmp33_ = g_strconcat (_tmp32_, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp33_;
	} else {
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = vala_code_context_get_output (context);
		_tmp35_ = _tmp34_;
		if (_tmp35_ != NULL) {
			gchar* output = NULL;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_ = FALSE;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp36_ = vala_code_context_get_output (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strdup (_tmp37_);
			output = _tmp38_;
			_tmp41_ = vala_code_context_get_directory (context);
			_tmp42_ = _tmp41_;
			if (_tmp42_ != NULL) {
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				_tmp43_ = vala_code_context_get_directory (context);
				_tmp44_ = _tmp43_;
				_tmp40_ = g_strcmp0 (_tmp44_, "") != 0;
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				_tmp45_ = vala_code_context_get_output (context);
				_tmp46_ = _tmp45_;
				_tmp39_ = !g_path_is_absolute (_tmp46_);
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				_tmp47_ = vala_code_context_get_directory (context);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_code_context_get_output (context);
				_tmp50_ = _tmp49_;
				_tmp51_ = g_strdup_printf ("%s%c%s", _tmp48_, (gint) G_DIR_SEPARATOR, _tmp50_);
				_g_free0 (output);
				output = _tmp51_;
			}
			_tmp52_ = cmdline;
			_tmp53_ = output;
			_tmp54_ = g_shell_quote (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat (" -o ", _tmp55_, NULL);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strconcat (_tmp52_, _tmp57_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp58_;
			_g_free0 (_tmp57_);
			_g_free0 (_tmp55_);
			_g_free0 (output);
		}
	}
	_tmp59_ = vala_code_context_get_source_files (context);
	_tmp60_ = _vala_iterable_ref0 (_tmp59_);
	source_files = _tmp60_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp61_;
		ValaList* _tmp62_;
		gint _file_size = 0;
		ValaList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _file_index = 0;
		_tmp61_ = source_files;
		_tmp62_ = _vala_iterable_ref0 (_tmp61_);
		_file_list = _tmp62_;
		_tmp63_ = _file_list;
		_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_file_size = _tmp65_;
		_file_index = -1;
		while (TRUE) {
			ValaSourceFile* file = NULL;
			ValaList* _tmp66_;
			gpointer _tmp67_;
			ValaSourceFile* _tmp68_;
			ValaSourceFileType _tmp69_;
			ValaSourceFileType _tmp70_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp66_ = _file_list;
			_tmp67_ = vala_list_get (_tmp66_, _file_index);
			file = (ValaSourceFile*) _tmp67_;
			_tmp68_ = file;
			_tmp69_ = vala_source_file_get_file_type (_tmp68_);
			_tmp70_ = _tmp69_;
			if (_tmp70_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				const gchar* _tmp71_;
				ValaSourceFile* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				_tmp71_ = cmdline;
				_tmp72_ = file;
				_tmp73_ = vala_source_file_get_csource_filename (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_shell_quote (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_strconcat (" ", _tmp76_, NULL);
				_tmp78_ = _tmp77_;
				_tmp79_ = g_strconcat (_tmp71_, _tmp78_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp79_;
				_g_free0 (_tmp78_);
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp80_ = vala_code_context_get_c_source_files (context);
	_tmp81_ = _vala_iterable_ref0 (_tmp80_);
	c_source_files = _tmp81_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp82_;
		ValaList* _tmp83_;
		gint _file_size = 0;
		ValaList* _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _file_index = 0;
		_tmp82_ = c_source_files;
		_tmp83_ = _vala_iterable_ref0 (_tmp82_);
		_file_list = _tmp83_;
		_tmp84_ = _file_list;
		_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
		_tmp86_ = _tmp85_;
		_file_size = _tmp86_;
		_file_index = -1;
		while (TRUE) {
			gchar* file = NULL;
			ValaList* _tmp87_;
			gpointer _tmp88_;
			const gchar* _tmp89_;
			const gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp87_ = _file_list;
			_tmp88_ = vala_list_get (_tmp87_, _file_index);
			file = (gchar*) _tmp88_;
			_tmp89_ = cmdline;
			_tmp90_ = file;
			_tmp91_ = g_shell_quote (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = g_strconcat (" ", _tmp92_, NULL);
			_tmp94_ = _tmp93_;
			_tmp95_ = g_strconcat (_tmp89_, _tmp94_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp95_;
			_g_free0 (_tmp94_);
			_g_free0 (_tmp92_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp96_ = cmdline;
	_tmp97_ = pkgflags;
	_tmp98_ = string_strip (_tmp97_);
	_tmp99_ = _tmp98_;
	_tmp100_ = g_strconcat (" ", _tmp99_, NULL);
	_tmp101_ = _tmp100_;
	_tmp102_ = g_strconcat (_tmp96_, _tmp101_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp102_;
	_g_free0 (_tmp101_);
	_g_free0 (_tmp99_);
	{
		gchar** cc_option_collection = NULL;
		gint cc_option_collection_length1 = 0;
		gint _cc_option_collection_size_ = 0;
		gint cc_option_it = 0;
		cc_option_collection = cc_options;
		cc_option_collection_length1 = cc_options_length1;
		for (cc_option_it = 0; cc_option_it < cc_option_collection_length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp103_;
			gchar* cc_option = NULL;
			_tmp103_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp103_;
			{
				const gchar* _tmp104_;
				const gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				_tmp104_ = cmdline;
				_tmp105_ = cc_option;
				_tmp106_ = g_shell_quote (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp108_ = g_strconcat (" ", _tmp107_, NULL);
				_tmp109_ = _tmp108_;
				_tmp110_ = g_strconcat (_tmp104_, _tmp109_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp110_;
				_g_free0 (_tmp109_);
				_g_free0 (_tmp107_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp111_ = vala_code_context_get_verbose_mode (context);
	_tmp112_ = _tmp111_;
	if (_tmp112_) {
		FILE* _tmp113_;
		const gchar* _tmp114_;
		_tmp113_ = stdout;
		_tmp114_ = cmdline;
		fprintf (_tmp113_, "%s\n", _tmp114_);
	}
	{
		gint exit_status = 0;
		const gchar* _tmp115_;
		gint _tmp116_ = 0;
		_tmp115_ = cmdline;
		g_spawn_command_line_sync (_tmp115_, NULL, NULL, &_tmp116_, &_inner_error0_);
		exit_status = _tmp116_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_vala_iterable_unref0 (c_source_files);
			_vala_iterable_unref0 (source_files);
			_g_free0 (cmdline);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (exit_status != 0) {
			gchar* _tmp117_;
			gchar* _tmp118_;
			_tmp117_ = g_strdup_printf ("cc exited with status %d", exit_status);
			_tmp118_ = _tmp117_;
			vala_report_error (NULL, _tmp118_);
			_g_free0 (_tmp118_);
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp119_;
		const gchar* _tmp120_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp119_ = e;
		_tmp120_ = _tmp119_->message;
		vala_report_error (NULL, _tmp120_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp121_ = vala_code_context_get_save_csources (context);
	_tmp122_ = _tmp121_;
	if (!_tmp122_) {
		{
			ValaList* _file_list = NULL;
			ValaList* _tmp123_;
			ValaList* _tmp124_;
			gint _file_size = 0;
			ValaList* _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			gint _file_index = 0;
			_tmp123_ = source_files;
			_tmp124_ = _vala_iterable_ref0 (_tmp123_);
			_file_list = _tmp124_;
			_tmp125_ = _file_list;
			_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
			_tmp127_ = _tmp126_;
			_file_size = _tmp127_;
			_file_index = -1;
			while (TRUE) {
				ValaSourceFile* file = NULL;
				ValaList* _tmp128_;
				gpointer _tmp129_;
				ValaSourceFile* _tmp130_;
				ValaSourceFileType _tmp131_;
				ValaSourceFileType _tmp132_;
				_file_index = _file_index + 1;
				if (!(_file_index < _file_size)) {
					break;
				}
				_tmp128_ = _file_list;
				_tmp129_ = vala_list_get (_tmp128_, _file_index);
				file = (ValaSourceFile*) _tmp129_;
				_tmp130_ = file;
				_tmp131_ = vala_source_file_get_file_type (_tmp130_);
				_tmp132_ = _tmp131_;
				if (_tmp132_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
					ValaSourceFile* _tmp133_;
					gchar* _tmp134_;
					gchar* _tmp135_;
					_tmp133_ = file;
					_tmp134_ = vala_source_file_get_csource_filename (_tmp133_);
					_tmp135_ = _tmp134_;
					g_unlink (_tmp135_);
					_g_free0 (_tmp135_);
				}
				_vala_source_file_unref0 (file);
			}
			_vala_iterable_unref0 (_file_list);
		}
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}

static void
vala_value_ccode_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_ccode_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_ccode_compiler_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_ccode_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_ccode_compiler_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_ccode_compiler_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	ValaCCodeCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_ccode_compiler (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_ccode_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_ccode_compiler (GValue* value,
                               gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}

void
vala_value_take_ccode_compiler (GValue* value,
                                gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}

static void
vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass,
                                gpointer klass_data)
{
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeCompilerClass *) klass)->finalize = vala_ccode_compiler_finalize;
}

static void
vala_ccode_compiler_instance_init (ValaCCodeCompiler * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
vala_ccode_compiler_finalize (ValaCCodeCompiler * obj)
{
	ValaCCodeCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler);
	g_signal_handlers_destroy (self);
}

/**
 * Interface to the C compiler.
 */
GType
vala_ccode_compiler_get_type (void)
{
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}

gpointer
vala_ccode_compiler_ref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_ccode_compiler_unref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

