/* valaccodenode.c generated by valac, the Vala compiler
 * generated from valaccodenode.vala, do not modify */

/* valaccodenode.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccode.h"
#include <gobject/gvaluecollector.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
typedef struct _ValaParamSpecCCodeNode ValaParamSpecCCodeNode;

struct _ValaCCodeNodePrivate {
	ValaCCodeLineDirective* _line;
	ValaCCodeModifiers _modifiers;
};

struct _ValaParamSpecCCodeNode {
	GParamSpec parent_instance;
};

static gint ValaCCodeNode_private_offset;
static gpointer vala_ccode_node_parent_class = NULL;

static void vala_ccode_node_real_write (ValaCCodeNode* self,
                                 ValaCCodeWriter* writer);
static void vala_ccode_node_real_write_declaration (ValaCCodeNode* self,
                                             ValaCCodeWriter* writer);
static void vala_ccode_node_real_write_combined (ValaCCodeNode* self,
                                          ValaCCodeWriter* writer);
static void vala_ccode_node_finalize (ValaCCodeNode * obj);

static inline gpointer
vala_ccode_node_get_instance_private (ValaCCodeNode* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCCodeNode_private_offset);
}

ValaCCodeLineDirective*
vala_ccode_node_get_line (ValaCCodeNode* self)
{
	ValaCCodeLineDirective* result;
	ValaCCodeLineDirective* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_line;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

void
vala_ccode_node_set_line (ValaCCodeNode* self,
                          ValaCCodeLineDirective* value)
{
	ValaCCodeLineDirective* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_ccode_node_ref0 (value);
	_vala_ccode_node_unref0 (self->priv->_line);
	self->priv->_line = _tmp0_;
}

ValaCCodeModifiers
vala_ccode_node_get_modifiers (ValaCCodeNode* self)
{
	ValaCCodeModifiers result;
	ValaCCodeModifiers _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}

void
vala_ccode_node_set_modifiers (ValaCCodeNode* self,
                               ValaCCodeModifiers value)
{
	g_return_if_fail (self != NULL);
	self->priv->_modifiers = value;
}

/**
 * Writes this code node and all children with the specified C code
 * writer.
 *
 * @param writer a C code writer
 */
static void
vala_ccode_node_real_write (ValaCCodeNode* self,
                            ValaCCodeWriter* writer)
{
	g_critical ("Type `%s' does not implement abstract method `vala_ccode_node_write'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
vala_ccode_node_write (ValaCCodeNode* self,
                       ValaCCodeWriter* writer)
{
	g_return_if_fail (self != NULL);
	VALA_CCODE_NODE_GET_CLASS (self)->write (self, writer);
}

/**
 * Writes declaration for this code node with the specified C code
 * writer if necessary.
 *
 * @param writer a C code writer
 */
static void
vala_ccode_node_real_write_declaration (ValaCCodeNode* self,
                                        ValaCCodeWriter* writer)
{
	g_return_if_fail (writer != NULL);
}

void
vala_ccode_node_write_declaration (ValaCCodeNode* self,
                                   ValaCCodeWriter* writer)
{
	g_return_if_fail (self != NULL);
	VALA_CCODE_NODE_GET_CLASS (self)->write_declaration (self, writer);
}

/**
 * Writes declaration and implementation combined for this code node and
 * all children with the specified C code writer.
 *
 * @param writer a C code writer
 */
static void
vala_ccode_node_real_write_combined (ValaCCodeNode* self,
                                     ValaCCodeWriter* writer)
{
	g_return_if_fail (writer != NULL);
	vala_ccode_node_write_declaration (self, writer);
	vala_ccode_node_write (self, writer);
}

void
vala_ccode_node_write_combined (ValaCCodeNode* self,
                                ValaCCodeWriter* writer)
{
	g_return_if_fail (self != NULL);
	VALA_CCODE_NODE_GET_CLASS (self)->write_combined (self, writer);
}

ValaCCodeNode*
vala_ccode_node_construct (GType object_type)
{
	ValaCCodeNode* self = NULL;
	self = (ValaCCodeNode*) g_type_create_instance (object_type);
	return self;
}

static void
vala_value_ccode_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_ccode_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_ccode_node_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_ccode_node_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_ccode_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_ccode_node_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCCodeNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_ccode_node_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	ValaCCodeNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_ccode_node (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ValaParamSpecCCodeNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_ccode_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_NODE), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_ccode_node (GValue* value,
                           gpointer v_object)
{
	ValaCCodeNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_node_unref (old);
	}
}

void
vala_value_take_ccode_node (GValue* value,
                            gpointer v_object)
{
	ValaCCodeNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_node_unref (old);
	}
}

static void
vala_ccode_node_class_init (ValaCCodeNodeClass * klass,
                            gpointer klass_data)
{
	vala_ccode_node_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_node_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCCodeNode_private_offset);
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_node_real_write;
	((ValaCCodeNodeClass *) klass)->write_declaration = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_node_real_write_declaration;
	((ValaCCodeNodeClass *) klass)->write_combined = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_node_real_write_combined;
}

static void
vala_ccode_node_instance_init (ValaCCodeNode * self,
                               gpointer klass)
{
	self->priv = vala_ccode_node_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_ccode_node_finalize (ValaCCodeNode * obj)
{
	ValaCCodeNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_NODE, ValaCCodeNode);
	g_signal_handlers_destroy (self);
	_vala_ccode_node_unref0 (self->priv->_line);
}

/**
 * Represents a node in the C code tree.
 */
GType
vala_ccode_node_get_type (void)
{
	static volatile gsize vala_ccode_node_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_node_init, vala_value_ccode_node_free_value, vala_value_ccode_node_copy_value, vala_value_ccode_node_peek_pointer, "p", vala_value_ccode_node_collect_value, "p", vala_value_ccode_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeNode), 0, (GInstanceInitFunc) vala_ccode_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_node_type_id;
		vala_ccode_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeNode", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		ValaCCodeNode_private_offset = g_type_add_instance_private (vala_ccode_node_type_id, sizeof (ValaCCodeNodePrivate));
		g_once_init_leave (&vala_ccode_node_type_id__volatile, vala_ccode_node_type_id);
	}
	return vala_ccode_node_type_id__volatile;
}

gpointer
vala_ccode_node_ref (gpointer instance)
{
	ValaCCodeNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_ccode_node_unref (gpointer instance)
{
	ValaCCodeNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

