/* valadatatype.c generated by valac, the Vala compiler
 * generated from valadatatype.vala, do not modify */

/* valadatatype.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaDataTypePrivate {
	gboolean _value_owned;
	gboolean _nullable;
	ValaTypeSymbol* _data_type;
	gboolean _floating_reference;
	gboolean _is_dynamic;
	ValaList* type_argument_list;
};

static gint ValaDataType_private_offset;
static gpointer vala_data_type_parent_class = NULL;
static ValaList* vala_data_type__empty_type_list;
static ValaList* vala_data_type__empty_type_list = NULL;

static void vala_data_type_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_data_type_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gchar* vala_data_type_real_to_string (ValaCodeNode* base);
static gchar* vala_data_type_real_to_qualified_string (ValaDataType* self,
                                                ValaScope* scope);
static ValaDataType* vala_data_type_real_copy (ValaDataType* self);
static gboolean vala_data_type_real_equals (ValaDataType* self,
                                     ValaDataType* type2);
static gboolean vala_data_type_real_stricter (ValaDataType* self,
                                       ValaDataType* type2);
static void vala_data_type_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_data_type_real_compatible (ValaDataType* self,
                                         ValaDataType* target_type);
G_GNUC_INTERNAL ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type,
                                                                        ValaTypeSymbol* type_symbol,
                                                                        ValaCodeNode* node_reference);
static gboolean vala_data_type_real_is_invokable (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_return_type (ValaDataType* self);
static ValaList* vala_data_type_real_get_parameters (ValaDataType* self);
static gboolean vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self);
static gboolean vala_data_type_real_is_accessible (ValaDataType* self,
                                            ValaSymbol* sym);
static ValaSymbol* vala_data_type_real_get_member (ValaDataType* self,
                                            const gchar* member_name);
static ValaSymbol* vala_data_type_real_get_pointer_member (ValaDataType* self,
                                                    const gchar* member_name);
static gboolean vala_data_type_real_is_real_struct_type (ValaDataType* self);
static gboolean vala_data_type_real_is_disposable (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_actual_type (ValaDataType* self,
                                                   ValaDataType* derived_instance_type,
                                                   ValaList* method_type_arguments,
                                                   ValaCodeNode* node_reference);
static ValaDataType* vala_data_type_real_infer_type_argument (ValaDataType* self,
                                                       ValaTypeParameter* type_param,
                                                       ValaDataType* value_type);
static gchar* vala_data_type_real_to_prototype_string (ValaDataType* self,
                                                const gchar* override_name);
static void vala_data_type_finalize (ValaCodeNode * obj);

static inline gpointer
vala_data_type_get_instance_private (ValaDataType* self)
{
	return G_STRUCT_MEMBER_P (self, ValaDataType_private_offset);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_data_type_add_type_argument (ValaDataType* self,
                                  ValaDataType* arg)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_argument_list);
		self->priv->type_argument_list = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp3_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_data_type_get_type_arguments (ValaDataType* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_argument_list;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_data_type__empty_type_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_data_type__empty_type_list);
		vala_data_type__empty_type_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_data_type__empty_type_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

gboolean
vala_data_type_has_type_arguments (ValaDataType* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->type_argument_list;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_ > 0;
	return result;
}

/**
 * Removes all generic type arguments.
 */
void
vala_data_type_remove_all_type_arguments (ValaDataType* self)
{
	g_return_if_fail (self != NULL);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	self->priv->type_argument_list = NULL;
}

static void
vala_data_type_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaDataType * self;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_data_type (visitor, self);
}

static void
vala_data_type_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaDataType * self;
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp1_ = self->priv->type_argument_list;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_argument_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp5_;
			ValaList* _tmp6_;
			gint _type_arg_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _type_arg_index = 0;
			_tmp5_ = self->priv->type_argument_list;
			_tmp6_ = _vala_iterable_ref0 (_tmp5_);
			_type_arg_list = _tmp6_;
			_tmp7_ = _type_arg_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_type_arg_size = _tmp9_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp10_;
				gpointer _tmp11_;
				ValaDataType* _tmp12_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp10_ = _type_arg_list;
				_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp11_;
				_tmp12_ = type_arg;
				vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
}

static gchar*
vala_data_type_real_to_string (ValaCodeNode* base)
{
	ValaDataType * self;
	gchar* _tmp0_;
	gchar* result = NULL;
	self = (ValaDataType*) base;
	_tmp0_ = vala_data_type_to_qualified_string (self, NULL);
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_scope_ref0 (gpointer self)
{
	return self ? vala_scope_ref (self) : NULL;
}

static gchar*
vala_data_type_real_to_qualified_string (ValaDataType* self,
                                         ValaScope* scope)
{
	gchar* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaList* type_args = NULL;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gboolean _tmp65_;
	gchar* result = NULL;
	_tmp0_ = self->priv->_data_type;
	if (_tmp0_ != NULL) {
		ValaSymbol* global_symbol = NULL;
		ValaTypeSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* sym = NULL;
		ValaScope* parent_scope = NULL;
		ValaScope* _tmp16_;
		gboolean _tmp29_ = FALSE;
		ValaSymbol* _tmp30_;
		_tmp1_ = self->priv->_data_type;
		_tmp2_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp1_);
		global_symbol = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			ValaSymbol* _tmp4_;
			ValaSymbol* _tmp5_;
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp4_ = global_symbol;
			_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
			_tmp6_ = _tmp5_;
			if (_tmp6_ != NULL) {
				ValaSymbol* _tmp7_;
				ValaSymbol* _tmp8_;
				ValaSymbol* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp7_ = global_symbol;
				_tmp8_ = vala_symbol_get_parent_symbol (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_symbol_get_name (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp3_ = _tmp11_ != NULL;
			} else {
				_tmp3_ = FALSE;
			}
			if (!_tmp3_) {
				break;
			}
			_tmp12_ = global_symbol;
			_tmp13_ = vala_symbol_get_parent_symbol (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _vala_code_node_ref0 (_tmp14_);
			_vala_code_node_unref0 (global_symbol);
			global_symbol = _tmp15_;
		}
		sym = NULL;
		_tmp16_ = _vala_scope_ref0 (scope);
		parent_scope = _tmp16_;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			ValaSymbol* _tmp18_;
			ValaScope* _tmp20_;
			ValaSymbol* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			ValaSymbol* _tmp24_;
			ValaScope* _tmp25_;
			ValaScope* _tmp26_;
			ValaScope* _tmp27_;
			ValaScope* _tmp28_;
			_tmp18_ = sym;
			if (_tmp18_ == NULL) {
				ValaScope* _tmp19_;
				_tmp19_ = parent_scope;
				_tmp17_ = _tmp19_ != NULL;
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp20_ = parent_scope;
			_tmp21_ = global_symbol;
			_tmp22_ = vala_symbol_get_name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_scope_lookup (_tmp20_, _tmp23_);
			_vala_code_node_unref0 (sym);
			sym = _tmp24_;
			_tmp25_ = parent_scope;
			_tmp26_ = vala_scope_get_parent_scope (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _vala_scope_ref0 (_tmp27_);
			_vala_scope_unref0 (parent_scope);
			parent_scope = _tmp28_;
		}
		_tmp30_ = sym;
		if (_tmp30_ != NULL) {
			ValaSymbol* _tmp31_;
			ValaSymbol* _tmp32_;
			_tmp31_ = global_symbol;
			_tmp32_ = sym;
			_tmp29_ = _tmp31_ != _tmp32_;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			ValaTypeSymbol* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp33_ = self->priv->_data_type;
			_tmp34_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat ("global::", _tmp35_, NULL);
			_g_free0 (s);
			s = _tmp36_;
			_g_free0 (_tmp35_);
		} else {
			ValaTypeSymbol* _tmp37_;
			gchar* _tmp38_;
			_tmp37_ = self->priv->_data_type;
			_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp37_);
			_g_free0 (s);
			s = _tmp38_;
		}
		_vala_scope_unref0 (parent_scope);
		_vala_code_node_unref0 (sym);
		_vala_code_node_unref0 (global_symbol);
	} else {
		gchar* _tmp39_;
		_tmp39_ = g_strdup ("null");
		_g_free0 (s);
		s = _tmp39_;
	}
	_tmp40_ = vala_data_type_get_type_arguments (self);
	type_args = _tmp40_;
	_tmp41_ = type_args;
	_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (_tmp43_ > 0) {
		const gchar* _tmp44_;
		gchar* _tmp45_;
		gboolean first = FALSE;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		_tmp44_ = s;
		_tmp45_ = g_strconcat (_tmp44_, "<", NULL);
		_g_free0 (s);
		s = _tmp45_;
		first = TRUE;
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp46_;
			ValaList* _tmp47_;
			gint _type_arg_size = 0;
			ValaList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _type_arg_index = 0;
			_tmp46_ = type_args;
			_tmp47_ = _vala_iterable_ref0 (_tmp46_);
			_type_arg_list = _tmp47_;
			_tmp48_ = _type_arg_list;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_type_arg_size = _tmp50_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				ValaDataType* _tmp55_;
				const gchar* _tmp58_;
				ValaDataType* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp51_ = _type_arg_list;
				_tmp52_ = vala_list_get (_tmp51_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp52_;
				if (!first) {
					const gchar* _tmp53_;
					gchar* _tmp54_;
					_tmp53_ = s;
					_tmp54_ = g_strconcat (_tmp53_, ",", NULL);
					_g_free0 (s);
					s = _tmp54_;
				} else {
					first = FALSE;
				}
				_tmp55_ = type_arg;
				if (vala_data_type_is_weak (_tmp55_)) {
					const gchar* _tmp56_;
					gchar* _tmp57_;
					_tmp56_ = s;
					_tmp57_ = g_strconcat (_tmp56_, "weak ", NULL);
					_g_free0 (s);
					s = _tmp57_;
				}
				_tmp58_ = s;
				_tmp59_ = type_arg;
				_tmp60_ = vala_data_type_to_qualified_string (_tmp59_, scope);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strconcat (_tmp58_, _tmp61_, NULL);
				_g_free0 (s);
				s = _tmp62_;
				_g_free0 (_tmp61_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_tmp63_ = s;
		_tmp64_ = g_strconcat (_tmp63_, ">", NULL);
		_g_free0 (s);
		s = _tmp64_;
	}
	_tmp65_ = self->priv->_nullable;
	if (_tmp65_) {
		const gchar* _tmp66_;
		gchar* _tmp67_;
		_tmp66_ = s;
		_tmp67_ = g_strconcat (_tmp66_, "?", NULL);
		_g_free0 (s);
		s = _tmp67_;
	}
	result = s;
	_vala_iterable_unref0 (type_args);
	return result;
}

gchar*
vala_data_type_to_qualified_string (ValaDataType* self,
                                    ValaScope* scope)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->to_qualified_string (self, scope);
}

/**
 * Creates a shallow copy of this type reference.
 *
 * @return copy of this type reference
 */
static ValaDataType*
vala_data_type_real_copy (ValaDataType* self)
{
	g_critical ("Type `%s' does not implement abstract method `vala_data_type_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

ValaDataType*
vala_data_type_copy (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->copy (self);
}

/**
 * Checks two type references for equality. May only be used with
 * resolved type references.
 *
 * @param type2 a type reference
 * @return      true if this type reference is equal to type2, false
 *              otherwise
 */
static gboolean
vala_data_type_real_equals (ValaDataType* self,
                            ValaDataType* type2)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp10_;
	gboolean _tmp11_;
	ValaList* type_args = NULL;
	ValaList* _tmp12_;
	ValaList* type2_args = NULL;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	ValaList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gboolean result = FALSE;
	g_return_val_if_fail (type2 != NULL, FALSE);
	if (vala_data_type_is_disposable (type2) != vala_data_type_is_disposable (self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = type2->priv->_nullable;
	_tmp1_ = self->priv->_nullable;
	if (_tmp0_ != _tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = type2->priv->_data_type;
	_tmp3_ = self->priv->_data_type;
	if (_tmp2_ != _tmp3_) {
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (type2)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = VALA_IS_GENERIC_TYPE (self);
	}
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		ValaTypeParameter* _tmp6_;
		ValaTypeParameter* _tmp7_;
		ValaTypeParameter* _tmp8_;
		ValaTypeParameter* _tmp9_;
		if (!VALA_IS_GENERIC_TYPE (type2)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = !VALA_IS_GENERIC_TYPE (self);
		}
		if (_tmp5_) {
			result = FALSE;
			return result;
		}
		_tmp6_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (type2, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		_tmp9_ = _tmp8_;
		if (!vala_typeparameter_equals (_tmp7_, _tmp9_)) {
			result = FALSE;
			return result;
		}
	}
	_tmp10_ = type2->priv->_floating_reference;
	_tmp11_ = self->priv->_floating_reference;
	if (_tmp10_ != _tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = vala_data_type_get_type_arguments (self);
	type_args = _tmp12_;
	_tmp13_ = vala_data_type_get_type_arguments (type2);
	type2_args = _tmp13_;
	_tmp14_ = type2_args;
	_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = type_args;
	_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp16_ != _tmp19_) {
		result = FALSE;
		_vala_iterable_unref0 (type2_args);
		_vala_iterable_unref0 (type_args);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				ValaList* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				ValaList* _tmp25_;
				gpointer _tmp26_;
				ValaDataType* _tmp27_;
				ValaList* _tmp28_;
				gpointer _tmp29_;
				ValaDataType* _tmp30_;
				gboolean _tmp31_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = type_args;
				_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
				_tmp24_ = _tmp23_;
				if (!(i < _tmp24_)) {
					break;
				}
				_tmp25_ = type2_args;
				_tmp26_ = vala_list_get (_tmp25_, i);
				_tmp27_ = (ValaDataType*) _tmp26_;
				_tmp28_ = type_args;
				_tmp29_ = vala_list_get (_tmp28_, i);
				_tmp30_ = (ValaDataType*) _tmp29_;
				_tmp31_ = !vala_data_type_equals (_tmp27_, _tmp30_);
				_vala_code_node_unref0 (_tmp30_);
				_vala_code_node_unref0 (_tmp27_);
				if (_tmp31_) {
					result = FALSE;
					_vala_iterable_unref0 (type2_args);
					_vala_iterable_unref0 (type_args);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_vala_iterable_unref0 (type2_args);
	_vala_iterable_unref0 (type_args);
	return result;
}

gboolean
vala_data_type_equals (ValaDataType* self,
                       ValaDataType* type2)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->equals (self, type2);
}

/**
 * Checks whether this type reference is at least as strict as the
 * specified type reference type2.
 *
 * @param type2 a type reference
 * @return      true if this type reference is stricter or equal
 */
static gboolean
vala_data_type_real_stricter (ValaDataType* self,
                              ValaDataType* type2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaTypeSymbol* _tmp4_;
	ValaTypeSymbol* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean result = FALSE;
	g_return_val_if_fail (type2 != NULL, FALSE);
	if (vala_data_type_is_disposable (type2) != vala_data_type_is_disposable (self)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = type2->priv->_nullable;
	if (!_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_nullable;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (self)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = VALA_IS_GENERIC_TYPE (type2);
	}
	if (_tmp3_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = type2->priv->_data_type;
	_tmp5_ = self->priv->_data_type;
	if (_tmp4_ != _tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = type2->priv->_floating_reference;
	_tmp7_ = self->priv->_floating_reference;
	if (_tmp6_ != _tmp7_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
vala_data_type_stricter (ValaDataType* self,
                         ValaDataType* type2)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->stricter (self, type2);
}

static void
vala_data_type_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaDataType * self;
	ValaList* _tmp0_;
	self = (ValaDataType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					ValaList* _tmp3_;
					gint _tmp4_;
					gint _tmp5_;
					ValaList* _tmp6_;
					gpointer _tmp7_;
					ValaDataType* _tmp8_;
					gboolean _tmp9_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->type_argument_list;
					_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
					_tmp5_ = _tmp4_;
					if (!(i < _tmp5_)) {
						break;
					}
					_tmp6_ = self->priv->type_argument_list;
					_tmp7_ = vala_list_get (_tmp6_, i);
					_tmp8_ = (ValaDataType*) _tmp7_;
					_tmp9_ = _tmp8_ == old_type;
					_vala_code_node_unref0 (_tmp8_);
					if (_tmp9_) {
						ValaList* _tmp10_;
						_tmp10_ = self->priv->type_argument_list;
						vala_list_set (_tmp10_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static gboolean
vala_data_type_real_compatible (ValaDataType* self,
                                ValaDataType* target_type)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_;
	ValaCodeContext* _tmp11_;
	ValaProfile _tmp12_;
	ValaProfile _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	ValaTypeSymbol* _tmp39_;
	ValaList* type_args = NULL;
	ValaList* _tmp42_;
	ValaList* target_type_args = NULL;
	ValaList* _tmp43_;
	ValaList* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	ValaList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	ValaTypeSymbol* _tmp65_;
	gboolean _tmp91_ = FALSE;
	ValaTypeSymbol* _tmp92_;
	gboolean result = FALSE;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp2_ = vala_code_context_get ();
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_context_get_experimental_non_null (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_vala_code_context_unref0 (_tmp3_);
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = self->priv->_nullable;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp8_;
		_tmp8_ = target_type->priv->_nullable;
		_tmp0_ = !_tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = vala_code_context_get ();
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_code_context_get_profile (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_ == VALA_PROFILE_GOBJECT;
	_vala_code_context_unref0 (_tmp11_);
	if (_tmp14_) {
		ValaTypeSymbol* _tmp15_;
		_tmp15_ = target_type->priv->_data_type;
		_tmp9_ = _tmp15_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaTypeSymbol* _tmp16_;
		ValaCodeContext* _tmp17_;
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaStructValueType* _tmp21_;
		ValaTypeSymbol* _tmp22_;
		gboolean _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaCodeContext* _tmp25_;
		ValaCodeContext* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaObjectType* _tmp29_;
		ValaTypeSymbol* _tmp30_;
		gboolean _tmp31_;
		_tmp16_ = target_type->priv->_data_type;
		_tmp17_ = vala_code_context_get ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_->gvalue_type;
		_tmp22_ = ((ValaDataType*) _tmp21_)->priv->_data_type;
		_tmp23_ = vala_typesymbol_is_subtype_of (_tmp16_, _tmp22_);
		_vala_code_context_unref0 (_tmp18_);
		if (_tmp23_) {
			result = TRUE;
			return result;
		}
		_tmp24_ = target_type->priv->_data_type;
		_tmp25_ = vala_code_context_get ();
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_context_get_analyzer (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->gvariant_type;
		_tmp30_ = ((ValaDataType*) _tmp29_)->priv->_data_type;
		_tmp31_ = vala_typesymbol_is_subtype_of (_tmp24_, _tmp30_);
		_vala_code_context_unref0 (_tmp26_);
		if (_tmp31_) {
			result = TRUE;
			return result;
		}
	}
	if (VALA_IS_POINTER_TYPE (target_type)) {
		gboolean _tmp32_ = FALSE;
		if (VALA_IS_GENERIC_TYPE (self)) {
			_tmp32_ = TRUE;
		} else {
			gboolean _tmp33_ = FALSE;
			ValaTypeSymbol* _tmp34_;
			_tmp34_ = self->priv->_data_type;
			if (_tmp34_ != NULL) {
				gboolean _tmp35_ = FALSE;
				ValaTypeSymbol* _tmp36_;
				_tmp36_ = self->priv->_data_type;
				if (vala_typesymbol_is_reference_type (_tmp36_)) {
					_tmp35_ = TRUE;
				} else {
					_tmp35_ = VALA_IS_DELEGATE_TYPE (self);
				}
				_tmp33_ = _tmp35_;
			} else {
				_tmp33_ = FALSE;
			}
			_tmp32_ = _tmp33_;
		}
		if (_tmp32_) {
			result = TRUE;
			return result;
		}
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (target_type)) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_ARRAY_TYPE (self) != VALA_IS_ARRAY_TYPE (target_type)) {
		result = FALSE;
		return result;
	}
	_tmp39_ = self->priv->_data_type;
	if (VALA_IS_ENUM (_tmp39_)) {
		ValaTypeSymbol* _tmp40_;
		_tmp40_ = target_type->priv->_data_type;
		_tmp38_ = VALA_IS_STRUCT (_tmp40_);
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		ValaTypeSymbol* _tmp41_;
		_tmp41_ = target_type->priv->_data_type;
		_tmp37_ = vala_struct_is_integer_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		result = TRUE;
		return result;
	}
	_tmp42_ = vala_data_type_get_type_arguments (self);
	type_args = _tmp42_;
	_tmp43_ = vala_data_type_get_type_arguments (target_type);
	target_type_args = _tmp43_;
	_tmp44_ = type_args;
	_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = target_type_args;
	_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	if (_tmp46_ == _tmp49_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp50_ = FALSE;
				_tmp50_ = TRUE;
				while (TRUE) {
					ValaList* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp55_;
					gpointer _tmp56_;
					ValaDataType* target_type_arg = NULL;
					ValaList* _tmp57_;
					gpointer _tmp58_;
					gboolean _tmp59_ = FALSE;
					ValaDataType* _tmp60_;
					if (!_tmp50_) {
						gint _tmp51_;
						_tmp51_ = i;
						i = _tmp51_ + 1;
					}
					_tmp50_ = FALSE;
					_tmp52_ = type_args;
					_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
					_tmp54_ = _tmp53_;
					if (!(i < _tmp54_)) {
						break;
					}
					_tmp55_ = type_args;
					_tmp56_ = vala_list_get (_tmp55_, i);
					type_arg = (ValaDataType*) _tmp56_;
					_tmp57_ = target_type_args;
					_tmp58_ = vala_list_get (_tmp57_, i);
					target_type_arg = (ValaDataType*) _tmp58_;
					_tmp60_ = type_arg;
					if (!vala_data_type_is_non_null_simple_type (_tmp60_)) {
						ValaDataType* _tmp61_;
						ValaDataType* _tmp62_;
						_tmp61_ = type_arg;
						_tmp62_ = target_type_arg;
						_tmp59_ = vala_data_type_is_weak (_tmp61_) != vala_data_type_is_weak (_tmp62_);
					} else {
						_tmp59_ = FALSE;
					}
					if (_tmp59_) {
						result = FALSE;
						_vala_code_node_unref0 (target_type_arg);
						_vala_code_node_unref0 (type_arg);
						_vala_iterable_unref0 (target_type_args);
						_vala_iterable_unref0 (type_args);
						return result;
					}
					_vala_code_node_unref0 (target_type_arg);
					_vala_code_node_unref0 (type_arg);
				}
			}
		}
	}
	_tmp65_ = self->priv->_data_type;
	if (_tmp65_ != NULL) {
		ValaTypeSymbol* _tmp66_;
		_tmp66_ = target_type->priv->_data_type;
		_tmp64_ = _tmp66_ != NULL;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		ValaTypeSymbol* _tmp67_;
		ValaTypeSymbol* _tmp68_;
		_tmp67_ = self->priv->_data_type;
		_tmp68_ = target_type->priv->_data_type;
		_tmp63_ = vala_typesymbol_is_subtype_of (_tmp67_, _tmp68_);
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		ValaDataType* base_type = NULL;
		ValaTypeSymbol* _tmp69_;
		ValaDataType* _tmp70_;
		ValaList* base_type_args = NULL;
		ValaDataType* _tmp71_;
		ValaList* _tmp72_;
		ValaList* _tmp73_;
		gint _tmp74_;
		gint _tmp75_;
		ValaList* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		_tmp69_ = target_type->priv->_data_type;
		_tmp70_ = vala_semantic_analyzer_get_instance_base_type_for_member (self, _tmp69_, (ValaCodeNode*) self);
		base_type = _tmp70_;
		_tmp71_ = base_type;
		_tmp72_ = vala_data_type_get_type_arguments (_tmp71_);
		base_type_args = _tmp72_;
		_tmp73_ = base_type_args;
		_tmp74_ = vala_collection_get_size ((ValaCollection*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = target_type_args;
		_tmp77_ = vala_collection_get_size ((ValaCollection*) _tmp76_);
		_tmp78_ = _tmp77_;
		if (_tmp75_ == _tmp78_) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp79_ = FALSE;
					_tmp79_ = TRUE;
					while (TRUE) {
						ValaList* _tmp81_;
						gint _tmp82_;
						gint _tmp83_;
						ValaList* _tmp84_;
						gpointer _tmp85_;
						ValaDataType* _tmp86_;
						ValaList* _tmp87_;
						gpointer _tmp88_;
						ValaDataType* _tmp89_;
						gboolean _tmp90_;
						if (!_tmp79_) {
							gint _tmp80_;
							_tmp80_ = i;
							i = _tmp80_ + 1;
						}
						_tmp79_ = FALSE;
						_tmp81_ = base_type_args;
						_tmp82_ = vala_collection_get_size ((ValaCollection*) _tmp81_);
						_tmp83_ = _tmp82_;
						if (!(i < _tmp83_)) {
							break;
						}
						_tmp84_ = base_type_args;
						_tmp85_ = vala_list_get (_tmp84_, i);
						_tmp86_ = (ValaDataType*) _tmp85_;
						_tmp87_ = target_type_args;
						_tmp88_ = vala_list_get (_tmp87_, i);
						_tmp89_ = (ValaDataType*) _tmp88_;
						_tmp90_ = !vala_data_type_compatible (_tmp86_, _tmp89_);
						_vala_code_node_unref0 (_tmp89_);
						_vala_code_node_unref0 (_tmp86_);
						if (_tmp90_) {
							result = FALSE;
							_vala_iterable_unref0 (base_type_args);
							_vala_code_node_unref0 (base_type);
							_vala_iterable_unref0 (target_type_args);
							_vala_iterable_unref0 (type_args);
							return result;
						}
					}
				}
			}
		}
		result = TRUE;
		_vala_iterable_unref0 (base_type_args);
		_vala_code_node_unref0 (base_type);
		_vala_iterable_unref0 (target_type_args);
		_vala_iterable_unref0 (type_args);
		return result;
	}
	_tmp92_ = self->priv->_data_type;
	if (VALA_IS_STRUCT (_tmp92_)) {
		ValaTypeSymbol* _tmp93_;
		_tmp93_ = target_type->priv->_data_type;
		_tmp91_ = VALA_IS_STRUCT (_tmp93_);
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaStruct* expr_struct = NULL;
		ValaTypeSymbol* _tmp94_;
		ValaStruct* _tmp95_;
		ValaStruct* expect_struct = NULL;
		ValaTypeSymbol* _tmp96_;
		ValaStruct* _tmp97_;
		gboolean _tmp98_ = FALSE;
		ValaStruct* _tmp99_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaStruct* _tmp103_;
		gboolean _tmp114_ = FALSE;
		ValaStruct* _tmp115_;
		ValaStruct* _tmp117_;
		ValaStruct* _tmp118_;
		_tmp94_ = self->priv->_data_type;
		_tmp95_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_STRUCT, ValaStruct));
		expr_struct = _tmp95_;
		_tmp96_ = target_type->priv->_data_type;
		_tmp97_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_STRUCT, ValaStruct));
		expect_struct = _tmp97_;
		_tmp99_ = expr_struct;
		if (vala_struct_is_integer_type (_tmp99_)) {
			ValaStruct* _tmp100_;
			_tmp100_ = expect_struct;
			_tmp98_ = vala_struct_is_floating_type (_tmp100_);
		} else {
			_tmp98_ = FALSE;
		}
		if (_tmp98_) {
			result = TRUE;
			_vala_code_node_unref0 (expect_struct);
			_vala_code_node_unref0 (expr_struct);
			_vala_iterable_unref0 (target_type_args);
			_vala_iterable_unref0 (type_args);
			return result;
		}
		_tmp103_ = expr_struct;
		if (vala_struct_is_integer_type (_tmp103_)) {
			ValaStruct* _tmp104_;
			_tmp104_ = expect_struct;
			_tmp102_ = vala_struct_is_integer_type (_tmp104_);
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			_tmp101_ = TRUE;
		} else {
			gboolean _tmp105_ = FALSE;
			ValaStruct* _tmp106_;
			_tmp106_ = expr_struct;
			if (vala_struct_is_floating_type (_tmp106_)) {
				ValaStruct* _tmp107_;
				_tmp107_ = expect_struct;
				_tmp105_ = vala_struct_is_floating_type (_tmp107_);
			} else {
				_tmp105_ = FALSE;
			}
			_tmp101_ = _tmp105_;
		}
		if (_tmp101_) {
			ValaStruct* _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			ValaStruct* _tmp111_;
			gint _tmp112_;
			gint _tmp113_;
			_tmp108_ = expr_struct;
			_tmp109_ = vala_struct_get_rank (_tmp108_);
			_tmp110_ = _tmp109_;
			_tmp111_ = expect_struct;
			_tmp112_ = vala_struct_get_rank (_tmp111_);
			_tmp113_ = _tmp112_;
			if (_tmp110_ <= _tmp113_) {
				result = TRUE;
				_vala_code_node_unref0 (expect_struct);
				_vala_code_node_unref0 (expr_struct);
				_vala_iterable_unref0 (target_type_args);
				_vala_iterable_unref0 (type_args);
				return result;
			}
		}
		_tmp115_ = expr_struct;
		if (vala_struct_is_boolean_type (_tmp115_)) {
			ValaStruct* _tmp116_;
			_tmp116_ = expect_struct;
			_tmp114_ = vala_struct_is_boolean_type (_tmp116_);
		} else {
			_tmp114_ = FALSE;
		}
		if (_tmp114_) {
			result = TRUE;
			_vala_code_node_unref0 (expect_struct);
			_vala_code_node_unref0 (expr_struct);
			_vala_iterable_unref0 (target_type_args);
			_vala_iterable_unref0 (type_args);
			return result;
		}
		_tmp117_ = expect_struct;
		_tmp118_ = expr_struct;
		if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp117_, (ValaTypeSymbol*) _tmp118_)) {
			result = TRUE;
			_vala_code_node_unref0 (expect_struct);
			_vala_code_node_unref0 (expr_struct);
			_vala_iterable_unref0 (target_type_args);
			_vala_iterable_unref0 (type_args);
			return result;
		}
		_vala_code_node_unref0 (expect_struct);
		_vala_code_node_unref0 (expr_struct);
	}
	result = FALSE;
	_vala_iterable_unref0 (target_type_args);
	_vala_iterable_unref0 (type_args);
	return result;
}

gboolean
vala_data_type_compatible (ValaDataType* self,
                           ValaDataType* target_type)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->compatible (self, target_type);
}

/**
 * Returns whether instances of this type are invokable.
 *
 * @return true if invokable, false otherwise
 */
static gboolean
vala_data_type_real_is_invokable (ValaDataType* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}

gboolean
vala_data_type_is_invokable (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_invokable (self);
}

/**
 * Returns the return type of this invokable.
 *
 * @return return type
 */
static ValaDataType*
vala_data_type_real_get_return_type (ValaDataType* self)
{
	ValaDataType* result = NULL;
	result = NULL;
	return result;
}

ValaDataType*
vala_data_type_get_return_type (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_return_type (self);
}

/**
 * Returns copy of the list of invocation parameters.
 *
 * @return parameter list
 */
static ValaList*
vala_data_type_real_get_parameters (ValaDataType* self)
{
	ValaList* result = NULL;
	result = NULL;
	return result;
}

ValaList*
vala_data_type_get_parameters (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_parameters (self);
}

static gboolean
vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaTypeSymbol* _tmp2_;
	gboolean result = FALSE;
	_tmp2_ = self->priv->_data_type;
	if (_tmp2_ != NULL) {
		ValaTypeSymbol* _tmp3_;
		_tmp3_ = self->priv->_data_type;
		_tmp1_ = vala_typesymbol_is_reference_type (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_GENERIC_TYPE (self);
	}
	result = _tmp0_;
	return result;
}

gboolean
vala_data_type_is_reference_type_or_type_parameter (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_reference_type_or_type_parameter (self);
}

static gboolean
vala_data_type_real_is_accessible (ValaDataType* self,
                                   ValaSymbol* sym)
{
	ValaTypeSymbol* _tmp7_;
	gboolean result = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp0_;
		gint _type_arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_arg_index = 0;
		_tmp0_ = vala_data_type_get_type_arguments (self);
		_type_arg_list = _tmp0_;
		_tmp1_ = _type_arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_arg_size = _tmp3_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaDataType* _tmp6_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp4_ = _type_arg_list;
			_tmp5_ = vala_list_get (_tmp4_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp5_;
			_tmp6_ = type_arg;
			if (!vala_data_type_is_accessible (_tmp6_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (type_arg);
				_vala_iterable_unref0 (_type_arg_list);
				return result;
			}
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	_tmp7_ = self->priv->_data_type;
	if (_tmp7_ != NULL) {
		ValaTypeSymbol* _tmp8_;
		_tmp8_ = self->priv->_data_type;
		result = vala_symbol_is_accessible ((ValaSymbol*) _tmp8_, sym);
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
vala_data_type_is_accessible (ValaDataType* self,
                              ValaSymbol* sym)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_accessible (self, sym);
}

static ValaSymbol*
vala_data_type_real_get_member (ValaDataType* self,
                                const gchar* member_name)
{
	ValaTypeSymbol* _tmp0_;
	ValaSymbol* result = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	if (_tmp0_ != NULL) {
		ValaTypeSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		_tmp1_ = self->priv->_data_type;
		_tmp2_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp1_, member_name);
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

ValaSymbol*
vala_data_type_get_member (ValaDataType* self,
                           const gchar* member_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_member (self, member_name);
}

static ValaSymbol*
vala_data_type_real_get_pointer_member (ValaDataType* self,
                                        const gchar* member_name)
{
	ValaSymbol* result = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	result = NULL;
	return result;
}

ValaSymbol*
vala_data_type_get_pointer_member (ValaDataType* self,
                                   const gchar* member_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_pointer_member (self, member_name);
}

/**
 * Checks whether this data type references a real struct. A real struct
 * is a struct which is not a simple (fundamental) type.
 */
static gboolean
vala_data_type_real_is_real_struct_type (ValaDataType* self)
{
	ValaStruct* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean result = FALSE;
	_tmp0_ = self->priv->_data_type;
	_tmp1_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
	s = _tmp1_;
	_tmp3_ = s;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = s;
		_tmp2_ = !vala_struct_is_simple_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_vala_code_node_unref0 (s);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (s);
	return result;
}

gboolean
vala_data_type_is_real_struct_type (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_real_struct_type (self);
}

gboolean
vala_data_type_is_real_non_null_struct_type (ValaDataType* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_data_type_is_real_struct_type (self)) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_nullable;
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
vala_data_type_is_non_null_simple_type (ValaDataType* self)
{
	ValaStruct* s = NULL;
	ValaTypeSymbol* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaStruct* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_data_type;
	s = VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL;
	_tmp2_ = s;
	if (_tmp2_ != NULL) {
		ValaStruct* _tmp3_;
		_tmp3_ = s;
		_tmp1_ = vala_struct_is_simple_type (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_nullable;
		result = !_tmp4_;
		return result;
	}
	result = FALSE;
	return result;
}

/**
 * Returns whether the value needs to be disposed, i.e. whether
 * allocated memory or other resources need to be released when
 * the value is no longer needed.
 */
static gboolean
vala_data_type_real_is_disposable (ValaDataType* self)
{
	gboolean _tmp0_;
	gboolean result = FALSE;
	_tmp0_ = self->priv->_value_owned;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	if (vala_data_type_is_reference_type_or_type_parameter (self)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
vala_data_type_is_disposable (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_disposable (self);
}

static ValaDataType*
vala_data_type_real_get_actual_type (ValaDataType* self,
                                     ValaDataType* derived_instance_type,
                                     ValaList* method_type_arguments,
                                     ValaCodeNode* node_reference)
{
	ValaDataType* _result_ = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_;
	ValaList* _tmp3_;
	ValaDataType* result = NULL;
	_tmp0_ = vala_data_type_copy (self);
	_result_ = _tmp0_;
	if (derived_instance_type == NULL) {
		_tmp1_ = method_type_arguments == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = _result_;
		return result;
	}
	_tmp2_ = _result_;
	_tmp3_ = _tmp2_->priv->type_argument_list;
	if (_tmp3_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					ValaDataType* _tmp6_;
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaDataType* _tmp10_;
					ValaList* _tmp11_;
					ValaDataType* _tmp12_;
					ValaList* _tmp13_;
					gpointer _tmp14_;
					ValaDataType* _tmp15_;
					ValaDataType* _tmp16_;
					ValaDataType* _tmp17_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = _result_;
					_tmp7_ = _tmp6_->priv->type_argument_list;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = _result_;
					_tmp11_ = _tmp10_->priv->type_argument_list;
					_tmp12_ = _result_;
					_tmp13_ = _tmp12_->priv->type_argument_list;
					_tmp14_ = vala_list_get (_tmp13_, i);
					_tmp15_ = (ValaDataType*) _tmp14_;
					_tmp16_ = vala_data_type_get_actual_type (_tmp15_, derived_instance_type, method_type_arguments, node_reference);
					_tmp17_ = _tmp16_;
					vala_list_set (_tmp11_, i, _tmp17_);
					_vala_code_node_unref0 (_tmp17_);
					_vala_code_node_unref0 (_tmp15_);
				}
			}
		}
	}
	result = _result_;
	return result;
}

ValaDataType*
vala_data_type_get_actual_type (ValaDataType* self,
                                ValaDataType* derived_instance_type,
                                ValaList* method_type_arguments,
                                ValaCodeNode* node_reference)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_actual_type (self, derived_instance_type, method_type_arguments, node_reference);
}

/**
 * Search for the type parameter in this formal type and match it in
 * value_type.
 */
static ValaDataType*
vala_data_type_real_infer_type_argument (ValaDataType* self,
                                         ValaTypeParameter* type_param,
                                         ValaDataType* value_type)
{
	ValaIterator* value_type_arg_it = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaIterator* _tmp2_;
	ValaIterator* _tmp3_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (type_param != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0_ = vala_data_type_get_type_arguments (value_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_iterable_unref0 (_tmp1_);
	value_type_arg_it = _tmp3_;
	{
		ValaList* _formal_type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _formal_type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _formal_type_arg_index = 0;
		_tmp4_ = vala_data_type_get_type_arguments (self);
		_formal_type_arg_list = _tmp4_;
		_tmp5_ = _formal_type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_formal_type_arg_size = _tmp7_;
		_formal_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* formal_type_arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaIterator* _tmp10_;
			_formal_type_arg_index = _formal_type_arg_index + 1;
			if (!(_formal_type_arg_index < _formal_type_arg_size)) {
				break;
			}
			_tmp8_ = _formal_type_arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _formal_type_arg_index);
			formal_type_arg = (ValaDataType*) _tmp9_;
			_tmp10_ = value_type_arg_it;
			if (vala_iterator_next (_tmp10_)) {
				ValaDataType* inferred_type = NULL;
				ValaDataType* _tmp11_;
				ValaIterator* _tmp12_;
				gpointer _tmp13_;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				ValaDataType* _tmp16_;
				ValaDataType* _tmp17_;
				_tmp11_ = formal_type_arg;
				_tmp12_ = value_type_arg_it;
				_tmp13_ = vala_iterator_get (_tmp12_);
				_tmp14_ = (ValaDataType*) _tmp13_;
				_tmp15_ = vala_data_type_infer_type_argument (_tmp11_, type_param, _tmp14_);
				_tmp16_ = _tmp15_;
				_vala_code_node_unref0 (_tmp14_);
				inferred_type = _tmp16_;
				_tmp17_ = inferred_type;
				if (_tmp17_ != NULL) {
					result = inferred_type;
					_vala_code_node_unref0 (formal_type_arg);
					_vala_iterable_unref0 (_formal_type_arg_list);
					_vala_iterator_unref0 (value_type_arg_it);
					return result;
				}
				_vala_code_node_unref0 (inferred_type);
			}
			_vala_code_node_unref0 (formal_type_arg);
		}
		_vala_iterable_unref0 (_formal_type_arg_list);
	}
	result = NULL;
	_vala_iterator_unref0 (value_type_arg_it);
	return result;
}

ValaDataType*
vala_data_type_infer_type_argument (ValaDataType* self,
                                    ValaTypeParameter* type_param,
                                    ValaDataType* value_type)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->infer_type_argument (self, type_param, value_type);
}

/**
 * Returns a stringified representation used for detailed error output
 *
 * @param override_name used as name if given
 * @return stringified representation
 */
static gchar*
vala_data_type_real_to_prototype_string (ValaDataType* self,
                                         const gchar* override_name)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
	if (vala_data_type_is_weak (self)) {
		_tmp0_ = "unowned ";
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = vala_data_type_to_qualified_string (self, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s%s", _tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

gchar*
vala_data_type_to_prototype_string (ValaDataType* self,
                                    const gchar* override_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->to_prototype_string (self, override_name);
}

gboolean
vala_data_type_is_weak (ValaDataType* self)
{
	gboolean _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_value_owned;
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (VALA_IS_VOID_TYPE (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = VALA_IS_POINTER_TYPE (self);
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		} else {
			if (VALA_IS_VALUE_TYPE (self)) {
				gboolean _tmp2_;
				_tmp2_ = self->priv->_nullable;
				if (_tmp2_) {
					result = TRUE;
					return result;
				}
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
vala_data_type_get_type_signature (ValaDataType* self,
                                   ValaSymbol* symbol)
{
	ValaArrayType* array_type = NULL;
	ValaArrayType* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (symbol != NULL) {
		gchar* sig = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "signature", NULL);
		sig = _tmp0_;
		_tmp1_ = sig;
		if (_tmp1_ != NULL) {
			result = sig;
			return result;
		}
		_g_free0 (sig);
	}
	array_type = VALA_IS_ARRAY_TYPE (self) ? ((ValaArrayType*) self) : NULL;
	_tmp2_ = array_type;
	if (_tmp2_ != NULL) {
		gchar* element_type_signature = NULL;
		ValaArrayType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		ValaArrayType* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp3_ = array_type;
		_tmp4_ = vala_array_type_get_element_type (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_type_signature (_tmp5_, NULL);
		element_type_signature = _tmp6_;
		_tmp7_ = element_type_signature;
		if (_tmp7_ == NULL) {
			result = NULL;
			_g_free0 (element_type_signature);
			return result;
		}
		_tmp8_ = array_type;
		_tmp9_ = vala_array_type_get_rank (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strnfill ((gsize) _tmp10_, 'a');
		_tmp12_ = _tmp11_;
		_tmp13_ = element_type_signature;
		_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp12_);
		result = _tmp15_;
		_g_free0 (element_type_signature);
		return result;
	} else {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		ValaTypeSymbol* _tmp18_;
		_tmp18_ = self->priv->_data_type;
		if (_tmp18_ != NULL) {
			ValaTypeSymbol* _tmp19_;
			_tmp19_ = self->priv->_data_type;
			_tmp17_ = VALA_IS_ENUM (_tmp19_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			ValaTypeSymbol* _tmp20_;
			_tmp20_ = self->priv->_data_type;
			_tmp16_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp20_, "DBus", "use_string_marshalling", FALSE);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("s");
			result = _tmp21_;
			return result;
		} else {
			ValaTypeSymbol* _tmp22_;
			_tmp22_ = self->priv->_data_type;
			if (_tmp22_ != NULL) {
				gchar* sig = NULL;
				ValaTypeSymbol* _tmp23_;
				gchar* _tmp24_;
				ValaStruct* st = NULL;
				ValaTypeSymbol* _tmp25_;
				ValaEnum* en = NULL;
				ValaTypeSymbol* _tmp26_;
				gboolean _tmp27_ = FALSE;
				const gchar* _tmp28_;
				ValaList* type_args = NULL;
				ValaList* _tmp61_;
				gboolean _tmp62_ = FALSE;
				gboolean _tmp63_ = FALSE;
				const gchar* _tmp64_;
				gboolean _tmp86_ = FALSE;
				const gchar* _tmp87_;
				_tmp23_ = self->priv->_data_type;
				_tmp24_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp23_, "CCode", "type_signature", NULL);
				sig = _tmp24_;
				_tmp25_ = self->priv->_data_type;
				st = VALA_IS_STRUCT (_tmp25_) ? ((ValaStruct*) _tmp25_) : NULL;
				_tmp26_ = self->priv->_data_type;
				en = VALA_IS_ENUM (_tmp26_) ? ((ValaEnum*) _tmp26_) : NULL;
				_tmp28_ = sig;
				if (_tmp28_ == NULL) {
					ValaStruct* _tmp29_;
					_tmp29_ = st;
					_tmp27_ = _tmp29_ != NULL;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					GString* str = NULL;
					GString* _tmp30_;
					GString* _tmp31_;
					GString* _tmp49_;
					GString* _tmp50_;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					_tmp30_ = g_string_new ("");
					str = _tmp30_;
					_tmp31_ = str;
					g_string_append_c (_tmp31_, '(');
					{
						ValaList* _f_list = NULL;
						ValaStruct* _tmp32_;
						ValaList* _tmp33_;
						gint _f_size = 0;
						ValaList* _tmp34_;
						gint _tmp35_;
						gint _tmp36_;
						gint _f_index = 0;
						_tmp32_ = st;
						_tmp33_ = vala_struct_get_fields (_tmp32_);
						_f_list = _tmp33_;
						_tmp34_ = _f_list;
						_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
						_tmp36_ = _tmp35_;
						_f_size = _tmp36_;
						_f_index = -1;
						while (TRUE) {
							ValaField* f = NULL;
							ValaList* _tmp37_;
							gpointer _tmp38_;
							ValaField* _tmp39_;
							ValaMemberBinding _tmp40_;
							ValaMemberBinding _tmp41_;
							_f_index = _f_index + 1;
							if (!(_f_index < _f_size)) {
								break;
							}
							_tmp37_ = _f_list;
							_tmp38_ = vala_list_get (_tmp37_, _f_index);
							f = (ValaField*) _tmp38_;
							_tmp39_ = f;
							_tmp40_ = vala_field_get_binding (_tmp39_);
							_tmp41_ = _tmp40_;
							if (_tmp41_ == VALA_MEMBER_BINDING_INSTANCE) {
								GString* _tmp42_;
								ValaField* _tmp43_;
								ValaDataType* _tmp44_;
								ValaDataType* _tmp45_;
								ValaField* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								_tmp42_ = str;
								_tmp43_ = f;
								_tmp44_ = vala_variable_get_variable_type ((ValaVariable*) _tmp43_);
								_tmp45_ = _tmp44_;
								_tmp46_ = f;
								_tmp47_ = vala_data_type_get_type_signature (_tmp45_, (ValaSymbol*) _tmp46_);
								_tmp48_ = _tmp47_;
								g_string_append (_tmp42_, _tmp48_);
								_g_free0 (_tmp48_);
							}
							_vala_code_node_unref0 (f);
						}
						_vala_iterable_unref0 (_f_list);
					}
					_tmp49_ = str;
					g_string_append_c (_tmp49_, ')');
					_tmp50_ = str;
					_tmp51_ = _tmp50_->str;
					_tmp52_ = g_strdup (_tmp51_);
					_g_free0 (sig);
					sig = _tmp52_;
					_g_string_free0 (str);
				} else {
					gboolean _tmp53_ = FALSE;
					const gchar* _tmp54_;
					_tmp54_ = sig;
					if (_tmp54_ == NULL) {
						ValaEnum* _tmp55_;
						_tmp55_ = en;
						_tmp53_ = _tmp55_ != NULL;
					} else {
						_tmp53_ = FALSE;
					}
					if (_tmp53_) {
						ValaEnum* _tmp56_;
						gboolean _tmp57_;
						gboolean _tmp58_;
						_tmp56_ = en;
						_tmp57_ = vala_enum_get_is_flags (_tmp56_);
						_tmp58_ = _tmp57_;
						if (_tmp58_) {
							gchar* _tmp59_;
							_tmp59_ = g_strdup ("u");
							result = _tmp59_;
							_g_free0 (sig);
							return result;
						} else {
							gchar* _tmp60_;
							_tmp60_ = g_strdup ("i");
							result = _tmp60_;
							_g_free0 (sig);
							return result;
						}
					}
				}
				_tmp61_ = vala_data_type_get_type_arguments (self);
				type_args = _tmp61_;
				_tmp64_ = sig;
				if (_tmp64_ != NULL) {
					const gchar* _tmp65_;
					_tmp65_ = sig;
					_tmp63_ = string_contains (_tmp65_, "%s");
				} else {
					_tmp63_ = FALSE;
				}
				if (_tmp63_) {
					ValaList* _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					_tmp66_ = type_args;
					_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp62_ = _tmp68_ > 0;
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					gchar* element_sig = NULL;
					gchar* _tmp69_;
					const gchar* _tmp83_;
					const gchar* _tmp84_;
					gchar* _tmp85_;
					_tmp69_ = g_strdup ("");
					element_sig = _tmp69_;
					{
						ValaList* _type_arg_list = NULL;
						ValaList* _tmp70_;
						ValaList* _tmp71_;
						gint _type_arg_size = 0;
						ValaList* _tmp72_;
						gint _tmp73_;
						gint _tmp74_;
						gint _type_arg_index = 0;
						_tmp70_ = type_args;
						_tmp71_ = _vala_iterable_ref0 (_tmp70_);
						_type_arg_list = _tmp71_;
						_tmp72_ = _type_arg_list;
						_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
						_tmp74_ = _tmp73_;
						_type_arg_size = _tmp74_;
						_type_arg_index = -1;
						while (TRUE) {
							ValaDataType* type_arg = NULL;
							ValaList* _tmp75_;
							gpointer _tmp76_;
							gchar* s = NULL;
							ValaDataType* _tmp77_;
							gchar* _tmp78_;
							const gchar* _tmp79_;
							_type_arg_index = _type_arg_index + 1;
							if (!(_type_arg_index < _type_arg_size)) {
								break;
							}
							_tmp75_ = _type_arg_list;
							_tmp76_ = vala_list_get (_tmp75_, _type_arg_index);
							type_arg = (ValaDataType*) _tmp76_;
							_tmp77_ = type_arg;
							_tmp78_ = vala_data_type_get_type_signature (_tmp77_, NULL);
							s = _tmp78_;
							_tmp79_ = s;
							if (_tmp79_ != NULL) {
								const gchar* _tmp80_;
								const gchar* _tmp81_;
								gchar* _tmp82_;
								_tmp80_ = element_sig;
								_tmp81_ = s;
								_tmp82_ = g_strconcat (_tmp80_, _tmp81_, NULL);
								_g_free0 (element_sig);
								element_sig = _tmp82_;
							}
							_g_free0 (s);
							_vala_code_node_unref0 (type_arg);
						}
						_vala_iterable_unref0 (_type_arg_list);
					}
					_tmp83_ = sig;
					_tmp84_ = element_sig;
					_tmp85_ = string_replace (_tmp83_, "%s", _tmp84_);
					_g_free0 (sig);
					sig = _tmp85_;
					_g_free0 (element_sig);
				}
				_tmp87_ = sig;
				if (_tmp87_ == NULL) {
					gboolean _tmp88_ = FALSE;
					gboolean _tmp89_ = FALSE;
					ValaTypeSymbol* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					gboolean _tmp93_;
					_tmp90_ = self->priv->_data_type;
					_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = g_strcmp0 (_tmp92_, "GLib.UnixInputStream") == 0;
					_g_free0 (_tmp92_);
					if (_tmp93_) {
						_tmp89_ = TRUE;
					} else {
						ValaTypeSymbol* _tmp94_;
						gchar* _tmp95_;
						gchar* _tmp96_;
						_tmp94_ = self->priv->_data_type;
						_tmp95_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp94_);
						_tmp96_ = _tmp95_;
						_tmp89_ = g_strcmp0 (_tmp96_, "GLib.UnixOutputStream") == 0;
						_g_free0 (_tmp96_);
					}
					if (_tmp89_) {
						_tmp88_ = TRUE;
					} else {
						ValaTypeSymbol* _tmp97_;
						gchar* _tmp98_;
						gchar* _tmp99_;
						_tmp97_ = self->priv->_data_type;
						_tmp98_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp97_);
						_tmp99_ = _tmp98_;
						_tmp88_ = g_strcmp0 (_tmp99_, "GLib.Socket") == 0;
						_g_free0 (_tmp99_);
					}
					_tmp86_ = _tmp88_;
				} else {
					_tmp86_ = FALSE;
				}
				if (_tmp86_) {
					gchar* _tmp100_;
					_tmp100_ = g_strdup ("h");
					result = _tmp100_;
					_vala_iterable_unref0 (type_args);
					_g_free0 (sig);
					return result;
				}
				result = sig;
				_vala_iterable_unref0 (type_args);
				return result;
			} else {
				result = NULL;
				return result;
			}
		}
	}
}

ValaDataType*
vala_data_type_construct (GType object_type)
{
	ValaDataType* self = NULL;
	self = (ValaDataType*) vala_code_node_construct (object_type);
	return self;
}

gboolean
vala_data_type_get_value_owned (ValaDataType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_value_owned;
	return result;
}

void
vala_data_type_set_value_owned (ValaDataType* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_value_owned = value;
}

gboolean
vala_data_type_get_nullable (ValaDataType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_nullable;
	return result;
}

void
vala_data_type_set_nullable (ValaDataType* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_nullable = value;
}

ValaTypeSymbol*
vala_data_type_get_data_type (ValaDataType* self)
{
	ValaTypeSymbol* result;
	ValaTypeSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

void
vala_data_type_set_data_type (ValaDataType* self,
                              ValaTypeSymbol* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_data_type = value;
}

gboolean
vala_data_type_get_floating_reference (ValaDataType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_floating_reference;
	return result;
}

void
vala_data_type_set_floating_reference (ValaDataType* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_floating_reference = value;
}

gboolean
vala_data_type_get_is_dynamic (ValaDataType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_dynamic;
	return result;
}

void
vala_data_type_set_is_dynamic (ValaDataType* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_dynamic = value;
}

static void
vala_data_type_class_init (ValaDataTypeClass * klass,
                           gpointer klass_data)
{
	vala_data_type_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_data_type_finalize;
	g_type_class_adjust_private_offset (klass, &ValaDataType_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_data_type_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_data_type_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_data_type_real_to_string;
	((ValaDataTypeClass *) klass)->to_qualified_string = (gchar* (*) (ValaDataType*, ValaScope*)) vala_data_type_real_to_qualified_string;
	((ValaDataTypeClass *) klass)->copy = (ValaDataType* (*) (ValaDataType*)) vala_data_type_real_copy;
	((ValaDataTypeClass *) klass)->equals = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_equals;
	((ValaDataTypeClass *) klass)->stricter = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_stricter;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_data_type_real_replace_type;
	((ValaDataTypeClass *) klass)->compatible = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_compatible;
	((ValaDataTypeClass *) klass)->is_invokable = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_invokable;
	((ValaDataTypeClass *) klass)->get_return_type = (ValaDataType* (*) (ValaDataType*)) vala_data_type_real_get_return_type;
	((ValaDataTypeClass *) klass)->get_parameters = (ValaList* (*) (ValaDataType*)) vala_data_type_real_get_parameters;
	((ValaDataTypeClass *) klass)->is_reference_type_or_type_parameter = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_reference_type_or_type_parameter;
	((ValaDataTypeClass *) klass)->is_accessible = (gboolean (*) (ValaDataType*, ValaSymbol*)) vala_data_type_real_is_accessible;
	((ValaDataTypeClass *) klass)->get_member = (ValaSymbol* (*) (ValaDataType*, const gchar*)) vala_data_type_real_get_member;
	((ValaDataTypeClass *) klass)->get_pointer_member = (ValaSymbol* (*) (ValaDataType*, const gchar*)) vala_data_type_real_get_pointer_member;
	((ValaDataTypeClass *) klass)->is_real_struct_type = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_real_struct_type;
	((ValaDataTypeClass *) klass)->is_disposable = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_disposable;
	((ValaDataTypeClass *) klass)->get_actual_type = (ValaDataType* (*) (ValaDataType*, ValaDataType*, ValaList*, ValaCodeNode*)) vala_data_type_real_get_actual_type;
	((ValaDataTypeClass *) klass)->infer_type_argument = (ValaDataType* (*) (ValaDataType*, ValaTypeParameter*, ValaDataType*)) vala_data_type_real_infer_type_argument;
	((ValaDataTypeClass *) klass)->to_prototype_string = (gchar* (*) (ValaDataType*, const gchar*)) vala_data_type_real_to_prototype_string;
}

static void
vala_data_type_instance_init (ValaDataType * self,
                              gpointer klass)
{
	self->priv = vala_data_type_get_instance_private (self);
}

static void
vala_data_type_finalize (ValaCodeNode * obj)
{
	ValaDataType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DATA_TYPE, ValaDataType);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_data_type_parent_class)->finalize (obj);
}

/**
 * A reference to a data type. This is used to specify static types of
 * expressions.
 */
GType
vala_data_type_get_type (void)
{
	static volatile gsize vala_data_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_data_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDataTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_data_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDataType), 0, (GInstanceInitFunc) vala_data_type_instance_init, NULL };
		GType vala_data_type_type_id;
		vala_data_type_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDataType", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		ValaDataType_private_offset = g_type_add_instance_private (vala_data_type_type_id, sizeof (ValaDataTypePrivate));
		g_once_init_leave (&vala_data_type_type_id__volatile, vala_data_type_type_id);
	}
	return vala_data_type_type_id__volatile;
}

