/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaObjectType* _tmp11_;
		ValaObjectType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", (ValaDataType*) _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ > 0;
		_vala_iterable_unref0 (_tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp50_;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp50_;
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_tmp70_ = self->priv->_is_abstract;
		if (_tmp70_) {
			ValaCreationMethod* _tmp71_;
			ValaSymbolAccessibility _tmp72_;
			ValaSymbolAccessibility _tmp73_;
			_tmp71_ = cm;
			_tmp72_ = vala_symbol_get_access ((ValaSymbol*) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp69_ = _tmp73_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp69_ = FALSE;
		}
		if (_tmp69_) {
			gboolean _tmp74_;
			gboolean _tmp75_;
			_tmp74_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp75_ = _tmp74_;
			if (_tmp75_) {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_warning (_tmp77_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp79_ = _tmp78_;
				vala_report_error (_tmp79_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (cm);
				return;
			}
		}
		_vala_code_node_unref0 (cm);
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaObjectType* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	ValaField* _tmp12_;
	ValaField* _tmp13_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_parameter_new ("this", (ValaDataType*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	vala_property_set_this_parameter (prop, _tmp3_);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (_tmp1_);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_property_get_this_parameter (prop);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	vala_scope_add (_tmp5_, _tmp9_, (ValaSymbol*) _tmp11_);
	_tmp12_ = vala_property_get_field (prop);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaField* _tmp14_;
		ValaField* _tmp15_;
		_tmp14_ = vala_property_get_field (prop);
		_tmp15_ = _tmp14_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp15_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp57_;
	ValaConstructor* _tmp58_;
	ValaConstructor* _tmp61_;
	ValaConstructor* _tmp62_;
	ValaConstructor* _tmp65_;
	ValaConstructor* _tmp66_;
	ValaDestructor* _tmp69_;
	ValaDestructor* _tmp70_;
	ValaDestructor* _tmp73_;
	ValaDestructor* _tmp74_;
	ValaDestructor* _tmp77_;
	ValaDestructor* _tmp78_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp8_;
		gint _p_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _p_index = 0;
		_tmp8_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp8_;
		_tmp9_ = _p_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_p_size = _tmp11_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaTypeParameter* _tmp14_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp12_ = _p_list;
			_tmp13_ = vala_list_get (_tmp12_, _p_index);
			p = (ValaTypeParameter*) _tmp13_;
			_tmp14_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp15_;
		gint _en_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _en_index = 0;
		_tmp15_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp15_;
		_tmp16_ = _en_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_en_size = _tmp18_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaEnum* _tmp21_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp19_ = _en_list;
			_tmp20_ = vala_list_get (_tmp19_, _en_index);
			en = (ValaEnum*) _tmp20_;
			_tmp21_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp22_;
		gint _f_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _f_index = 0;
		_tmp22_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp22_;
		_tmp23_ = _f_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_f_size = _tmp25_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaField* _tmp28_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp26_ = _f_list;
			_tmp27_ = vala_list_get (_tmp26_, _f_index);
			f = (ValaField*) _tmp27_;
			_tmp28_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp29_;
		gint _c_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _c_index = 0;
		_tmp29_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp29_;
		_tmp30_ = _c_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_c_size = _tmp32_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp33_;
			gpointer _tmp34_;
			ValaConstant* _tmp35_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp33_ = _c_list;
			_tmp34_ = vala_list_get (_tmp33_, _c_index);
			c = (ValaConstant*) _tmp34_;
			_tmp35_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp36_;
		gint _m_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _m_index = 0;
		_tmp36_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp36_;
		_tmp37_ = _m_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_m_size = _tmp39_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp40_;
			gpointer _tmp41_;
			ValaMethod* _tmp42_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp40_ = _m_list;
			_tmp41_ = vala_list_get (_tmp40_, _m_index);
			m = (ValaMethod*) _tmp41_;
			_tmp42_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp42_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp43_;
		gint _prop_size = 0;
		ValaList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _prop_index = 0;
		_tmp43_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp43_;
		_tmp44_ = _prop_list;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_prop_size = _tmp46_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp47_;
			gpointer _tmp48_;
			ValaProperty* _tmp49_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp47_ = _prop_list;
			_tmp48_ = vala_list_get (_tmp47_, _prop_index);
			prop = (ValaProperty*) _tmp48_;
			_tmp49_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp50_;
		gint _sig_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _sig_index = 0;
		_tmp50_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp50_;
		_tmp51_ = _sig_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_sig_size = _tmp53_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp54_;
			gpointer _tmp55_;
			ValaSignal* _tmp56_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp54_ = _sig_list;
			_tmp55_ = vala_list_get (_tmp54_, _sig_index);
			sig = (ValaSignal*) _tmp55_;
			_tmp56_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp56_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp57_ = vala_class_get_constructor (self);
	_tmp58_ = _tmp57_;
	if (_tmp58_ != NULL) {
		ValaConstructor* _tmp59_;
		ValaConstructor* _tmp60_;
		_tmp59_ = vala_class_get_constructor (self);
		_tmp60_ = _tmp59_;
		vala_code_node_accept ((ValaCodeNode*) _tmp60_, visitor);
	}
	_tmp61_ = vala_class_get_class_constructor (self);
	_tmp62_ = _tmp61_;
	if (_tmp62_ != NULL) {
		ValaConstructor* _tmp63_;
		ValaConstructor* _tmp64_;
		_tmp63_ = vala_class_get_class_constructor (self);
		_tmp64_ = _tmp63_;
		vala_code_node_accept ((ValaCodeNode*) _tmp64_, visitor);
	}
	_tmp65_ = vala_class_get_static_constructor (self);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != NULL) {
		ValaConstructor* _tmp67_;
		ValaConstructor* _tmp68_;
		_tmp67_ = vala_class_get_static_constructor (self);
		_tmp68_ = _tmp67_;
		vala_code_node_accept ((ValaCodeNode*) _tmp68_, visitor);
	}
	_tmp69_ = vala_class_get_destructor (self);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaDestructor* _tmp71_;
		ValaDestructor* _tmp72_;
		_tmp71_ = vala_class_get_destructor (self);
		_tmp72_ = _tmp71_;
		vala_code_node_accept ((ValaCodeNode*) _tmp72_, visitor);
	}
	_tmp73_ = vala_class_get_static_destructor (self);
	_tmp74_ = _tmp73_;
	if (_tmp74_ != NULL) {
		ValaDestructor* _tmp75_;
		ValaDestructor* _tmp76_;
		_tmp75_ = vala_class_get_static_destructor (self);
		_tmp76_ = _tmp75_;
		vala_code_node_accept ((ValaCodeNode*) _tmp76_, visitor);
	}
	_tmp77_ = vala_class_get_class_destructor (self);
	_tmp78_ = _tmp77_;
	if (_tmp78_ != NULL) {
		ValaDestructor* _tmp79_;
		ValaDestructor* _tmp80_;
		_tmp79_ = vala_class_get_class_destructor (self);
		_tmp80_ = _tmp79_;
		vala_code_node_accept ((ValaCodeNode*) _tmp80_, visitor);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp81_;
		gint _cl_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _cl_index = 0;
		_tmp81_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp81_;
		_tmp82_ = _cl_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_cl_size = _tmp84_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp85_;
			gpointer _tmp86_;
			ValaClass* _tmp87_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp85_ = _cl_list;
			_tmp86_ = vala_list_get (_tmp85_, _cl_index);
			cl = (ValaClass*) _tmp86_;
			_tmp87_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp87_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp88_;
		gint _st_size = 0;
		ValaList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _st_index = 0;
		_tmp88_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp88_;
		_tmp89_ = _st_list;
		_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_st_size = _tmp91_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp92_;
			gpointer _tmp93_;
			ValaStruct* _tmp94_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp92_ = _st_list;
			_tmp93_ = vala_list_get (_tmp92_, _st_index);
			st = (ValaStruct*) _tmp93_;
			_tmp94_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp94_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp95_;
		gint _d_size = 0;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _d_index = 0;
		_tmp95_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp95_;
		_tmp96_ = _d_list;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_d_size = _tmp98_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp99_;
			gpointer _tmp100_;
			ValaDelegate* _tmp101_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp99_ = _d_list;
			_tmp100_ = vala_list_get (_tmp99_, _d_index);
			d = (ValaDelegate*) _tmp100_;
			_tmp101_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp101_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = base_type;
				_tmp13_ = vala_data_type_get_data_type (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp7_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp4_ = _prereq_list;
			_tmp5_ = vala_list_get (_tmp4_, _prereq_index);
			prereq = (ValaDataType*) _tmp5_;
			_tmp6_ = prereq;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_code_node_ref0 (_tmp8_);
			type = _tmp9_;
			_tmp10_ = type;
			if (_tmp10_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp11_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp11_);
			_tmp12_ = type;
			if (VALA_IS_INTERFACE (_tmp12_)) {
				ValaTypeSymbol* _tmp13_;
				_tmp13_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp4_ = _base_type_list;
			_tmp5_ = vala_list_get (_tmp4_, _base_type_index);
			base_type = (ValaDataType*) _tmp5_;
			_tmp6_ = base_type;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			if (VALA_IS_CLASS (_tmp8_)) {
				ValaDataType* _tmp9_;
				ValaTypeSymbol* _tmp10_;
				ValaTypeSymbol* _tmp11_;
				_tmp9_ = base_type;
				_tmp10_ = vala_data_type_get_data_type (_tmp9_);
				_tmp11_ = _tmp10_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = base_type;
				_tmp13_ = vala_data_type_get_data_type (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp4_ = _base_type_list;
			_tmp5_ = vala_list_get (_tmp4_, _base_type_index);
			base_type = (ValaDataType*) _tmp5_;
			_tmp6_ = base_type;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaCreationMethod* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSourceFile* _tmp29_;
	ValaSourceFile* _tmp30_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	gboolean _tmp110_ = FALSE;
	ValaClass* _tmp111_;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp125_;
	gboolean _tmp126_;
	gboolean _tmp136_ = FALSE;
	gboolean _tmp137_;
	gboolean _tmp138_;
	ValaConstructor* _tmp221_;
	ValaConstructor* _tmp222_;
	ValaConstructor* _tmp225_;
	ValaConstructor* _tmp226_;
	ValaConstructor* _tmp229_;
	ValaConstructor* _tmp230_;
	ValaDestructor* _tmp233_;
	ValaDestructor* _tmp234_;
	ValaDestructor* _tmp237_;
	ValaDestructor* _tmp238_;
	ValaDestructor* _tmp241_;
	ValaDestructor* _tmp242_;
	gboolean _tmp266_;
	gboolean _tmp267_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp306_;
	ValaArrayList* _tmp307_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp321_;
	ValaArrayList* _tmp322_;
	ValaList* _tmp335_;
	gint _tmp336_;
	gint _tmp337_;
	ValaSourceFileType _tmp360_;
	ValaSourceFileType _tmp361_;
	ValaSemanticAnalyzer* _tmp583_;
	ValaSemanticAnalyzer* _tmp584_;
	ValaSourceFile* _tmp585_;
	ValaSemanticAnalyzer* _tmp586_;
	ValaSemanticAnalyzer* _tmp587_;
	ValaSymbol* _tmp588_;
	gboolean _tmp589_;
	gboolean _tmp590_;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_default_construction_method;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceFile* _tmp8_;
		ValaSourceFile* _tmp9_;
		ValaSourceFileType _tmp10_;
		ValaSourceFileType _tmp11_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_source_reference_get_file (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_source_file_get_file_type (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp4_ = _tmp11_ == VALA_SOURCE_FILE_TYPE_SOURCE;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaCreationMethod* m = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaCreationMethod* _tmp16_;
		ValaSymbolAccessibility _tmp17_ = 0;
		gboolean _tmp18_;
		ValaCreationMethod* _tmp19_;
		ValaCreationMethod* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaBlock* _tmp23_;
		ValaBlock* _tmp24_;
		ValaCreationMethod* _tmp25_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_creation_method_new (_tmp13_, NULL, _tmp15_, NULL);
		m = _tmp16_;
		_tmp18_ = self->priv->_is_abstract;
		if (_tmp18_) {
			_tmp17_ = VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
		} else {
			_tmp17_ = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		}
		_tmp19_ = m;
		vala_symbol_set_access ((ValaSymbol*) _tmp19_, _tmp17_);
		_tmp20_ = m;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_block_new (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp20_, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
		_tmp25_ = m;
		vala_symbol_add_method ((ValaSymbol*) self, (ValaMethod*) _tmp25_);
		_vala_code_node_unref0 (m);
	}
	_tmp26_ = vala_code_context_get_analyzer (context);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_semantic_analyzer_get_current_source_file (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _vala_source_file_ref0 (_tmp29_);
	old_source_file = _tmp30_;
	_tmp31_ = vala_code_context_get_analyzer (context);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_semantic_analyzer_get_current_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _vala_code_node_ref0 (_tmp34_);
	old_symbol = _tmp35_;
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaSemanticAnalyzer* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		_tmp38_ = vala_code_context_get_analyzer (context);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_source_reference_get_file (_tmp41_);
		_tmp43_ = _tmp42_;
		vala_semantic_analyzer_set_current_source_file (_tmp39_, _tmp43_);
	}
	_tmp44_ = vala_code_context_get_analyzer (context);
	_tmp45_ = _tmp44_;
	vala_semantic_analyzer_set_current_symbol (_tmp45_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp46_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _base_type_reference_index = 0;
		_tmp46_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp46_;
		_tmp47_ = _base_type_reference_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_base_type_reference_size = _tmp49_;
		_base_type_reference_index = -1;
		while (TRUE) {
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp50_;
			gpointer _tmp51_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			ValaSemanticAnalyzer* _tmp63_;
			ValaSemanticAnalyzer* _tmp64_;
			ValaDataType* _tmp65_;
			gint n_type_args = 0;
			ValaDataType* _tmp75_;
			ValaList* _tmp76_;
			ValaList* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			gint n_type_params = 0;
			ValaDataType* _tmp81_;
			ValaTypeSymbol* _tmp82_;
			ValaTypeSymbol* _tmp83_;
			ValaList* _tmp84_;
			ValaList* _tmp85_;
			gint _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
			_base_type_reference_index = _base_type_reference_index + 1;
			if (!(_base_type_reference_index < _base_type_reference_size)) {
				break;
			}
			_tmp50_ = _base_type_reference_list;
			_tmp51_ = vala_list_get (_tmp50_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp51_;
			_tmp52_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp52_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp53_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp53_)) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaDataType* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				_tmp56_ = base_type_reference;
				_tmp57_ = vala_code_node_to_string ((ValaCodeNode*) _tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strdup_printf ("base type `%s' of class `%s' is not an object type", _tmp58_, _tmp60_);
				_tmp62_ = _tmp61_;
				vala_report_error (_tmp55_, _tmp62_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				_g_free0 (_tmp58_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp63_ = vala_code_context_get_analyzer (context);
			_tmp64_ = _tmp63_;
			_tmp65_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp64_, (ValaSymbol*) self, _tmp65_)) {
				ValaSourceReference* _tmp66_;
				ValaSourceReference* _tmp67_;
				ValaDataType* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp67_ = _tmp66_;
				_tmp68_ = base_type_reference;
				_tmp69_ = vala_code_node_to_string ((ValaCodeNode*) _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp72_ = _tmp71_;
				_tmp73_ = g_strdup_printf ("base type `%s' is less accessible than class `%s'", _tmp70_, _tmp72_);
				_tmp74_ = _tmp73_;
				vala_report_error (_tmp67_, _tmp74_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp72_);
				_g_free0 (_tmp70_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp75_ = base_type_reference;
			_tmp76_ = vala_data_type_get_type_arguments (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_collection_get_size ((ValaCollection*) _tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = _tmp79_;
			_vala_iterable_unref0 (_tmp77_);
			n_type_args = _tmp80_;
			_tmp81_ = base_type_reference;
			_tmp82_ = vala_data_type_get_data_type (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp85_ = _tmp84_;
			_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = _tmp87_;
			_vala_iterable_unref0 (_tmp85_);
			n_type_params = _tmp88_;
			if (n_type_args < n_type_params) {
				ValaDataType* _tmp89_;
				ValaSourceReference* _tmp90_;
				ValaSourceReference* _tmp91_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp89_ = base_type_reference;
				_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp89_);
				_tmp91_ = _tmp90_;
				vala_report_error (_tmp91_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					ValaDataType* _tmp92_;
					ValaSourceReference* _tmp93_;
					ValaSourceReference* _tmp94_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp92_ = base_type_reference;
					_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp92_);
					_tmp94_ = _tmp93_;
					vala_report_error (_tmp94_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp95_;
		ValaList* _tmp96_;
		gint _type_size = 0;
		ValaList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		gint _type_index = 0;
		_tmp95_ = self->priv->base_types;
		_tmp96_ = _vala_iterable_ref0 (_tmp95_);
		_type_list = _tmp96_;
		_tmp97_ = _type_list;
		_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
		_tmp99_ = _tmp98_;
		_type_size = _tmp99_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp100_;
			gpointer _tmp101_;
			ValaDataType* _tmp102_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp100_ = _type_list;
			_tmp101_ = vala_list_get (_tmp100_, _type_index);
			type = (ValaDataType*) _tmp101_;
			_tmp102_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp102_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp103_;
		gint _p_size = 0;
		ValaList* _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
		gint _p_index = 0;
		_tmp103_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp103_;
		_tmp104_ = _p_list;
		_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
		_tmp106_ = _tmp105_;
		_p_size = _tmp106_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp107_;
			gpointer _tmp108_;
			ValaTypeParameter* _tmp109_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp107_ = _p_list;
			_tmp108_ = vala_list_get (_tmp107_, _p_index);
			p = (ValaTypeParameter*) _tmp108_;
			_tmp109_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp109_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp111_ = self->priv->_base_class;
	if (_tmp111_ != NULL) {
		ValaClass* _tmp112_;
		gboolean _tmp113_;
		gboolean _tmp114_;
		_tmp112_ = self->priv->_base_class;
		_tmp113_ = vala_class_get_is_singleton (_tmp112_);
		_tmp114_ = _tmp113_;
		_tmp110_ = _tmp114_;
	} else {
		_tmp110_ = FALSE;
	}
	if (_tmp110_) {
		ValaSourceReference* _tmp115_;
		ValaSourceReference* _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		ValaClass* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = self->priv->_base_class;
		_tmp120_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp119_);
		_tmp121_ = _tmp120_;
		_tmp122_ = g_strdup_printf ("`%s' cannot inherit from SingleInstance class `%s'", _tmp118_, _tmp121_);
		_tmp123_ = _tmp122_;
		vala_report_error (_tmp116_, _tmp123_);
		_g_free0 (_tmp123_);
		_g_free0 (_tmp121_);
		_g_free0 (_tmp118_);
	}
	_tmp125_ = vala_class_get_is_singleton (self);
	_tmp126_ = _tmp125_;
	if (_tmp126_) {
		ValaSemanticAnalyzer* _tmp127_;
		ValaSemanticAnalyzer* _tmp128_;
		ValaClass* _tmp129_;
		_tmp127_ = vala_code_context_get_analyzer (context);
		_tmp128_ = _tmp127_;
		_tmp129_ = _tmp128_->object_type;
		_tmp124_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp129_);
	} else {
		_tmp124_ = FALSE;
	}
	if (_tmp124_) {
		ValaSourceReference* _tmp130_;
		ValaSourceReference* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = g_strdup_printf ("SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp133_);
		_tmp135_ = _tmp134_;
		vala_report_error (_tmp131_, _tmp135_);
		_g_free0 (_tmp135_);
		_g_free0 (_tmp133_);
	}
	_tmp137_ = vala_class_get_is_singleton (self);
	_tmp138_ = _tmp137_;
	if (_tmp138_) {
		ValaConstructor* _tmp139_;
		ValaConstructor* _tmp140_;
		_tmp139_ = vala_class_get_constructor (self);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_ == NULL;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp141_;
		ValaSourceReference* _tmp142_;
		ValaConstructor* _tmp143_;
		ValaConstructor* _tmp144_;
		ValaSourceReference* _tmp145_;
		ValaSourceReference* _tmp146_;
		ValaBlock* _tmp147_;
		ValaBlock* _tmp148_;
		ValaConstructor* _tmp149_;
		_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp142_ = _tmp141_;
		_tmp143_ = vala_constructor_new (_tmp142_);
		c = _tmp143_;
		_tmp144_ = c;
		_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_block_new (_tmp146_);
		_tmp148_ = _tmp147_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp144_, _tmp148_);
		_vala_code_node_unref0 (_tmp148_);
		_tmp149_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp149_);
		_vala_code_node_unref0 (c);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp150_;
		gint _en_size = 0;
		ValaList* _tmp151_;
		gint _tmp152_;
		gint _tmp153_;
		gint _en_index = 0;
		_tmp150_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp150_;
		_tmp151_ = _en_list;
		_tmp152_ = vala_collection_get_size ((ValaCollection*) _tmp151_);
		_tmp153_ = _tmp152_;
		_en_size = _tmp153_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp154_;
			gpointer _tmp155_;
			ValaEnum* _tmp156_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp154_ = _en_list;
			_tmp155_ = vala_list_get (_tmp154_, _en_index);
			en = (ValaEnum*) _tmp155_;
			_tmp156_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp156_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp157_;
		gint _f_size = 0;
		ValaList* _tmp158_;
		gint _tmp159_;
		gint _tmp160_;
		gint _f_index = 0;
		_tmp157_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp157_;
		_tmp158_ = _f_list;
		_tmp159_ = vala_collection_get_size ((ValaCollection*) _tmp158_);
		_tmp160_ = _tmp159_;
		_f_size = _tmp160_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp161_;
			gpointer _tmp162_;
			gboolean _tmp163_ = FALSE;
			gboolean _tmp164_;
			gboolean _tmp165_;
			ValaField* _tmp183_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp161_ = _f_list;
			_tmp162_ = vala_list_get (_tmp161_, _f_index);
			f = (ValaField*) _tmp162_;
			_tmp164_ = vala_class_get_is_compact (self);
			_tmp165_ = _tmp164_;
			if (_tmp165_) {
				ValaField* _tmp166_;
				ValaMemberBinding _tmp167_;
				ValaMemberBinding _tmp168_;
				_tmp166_ = f;
				_tmp167_ = vala_field_get_binding (_tmp166_);
				_tmp168_ = _tmp167_;
				_tmp163_ = _tmp168_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp163_ = FALSE;
			}
			if (_tmp163_) {
				gboolean _tmp169_ = FALSE;
				gboolean _tmp170_;
				gboolean _tmp171_;
				ValaField* _tmp177_;
				ValaMemberBinding _tmp178_;
				ValaMemberBinding _tmp179_;
				_tmp170_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp171_ = _tmp170_;
				if (!_tmp171_) {
					ValaField* _tmp172_;
					ValaSymbolAccessibility _tmp173_;
					ValaSymbolAccessibility _tmp174_;
					_tmp172_ = f;
					_tmp173_ = vala_symbol_get_access ((ValaSymbol*) _tmp172_);
					_tmp174_ = _tmp173_;
					_tmp169_ = _tmp174_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp169_ = FALSE;
				}
				if (_tmp169_) {
					ValaSourceReference* _tmp175_;
					ValaSourceReference* _tmp176_;
					_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp176_ = _tmp175_;
					vala_report_error (_tmp176_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp177_ = f;
				_tmp178_ = vala_field_get_binding (_tmp177_);
				_tmp179_ = _tmp178_;
				if (_tmp179_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp180_;
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					_tmp180_ = f;
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp180_);
					_tmp182_ = _tmp181_;
					vala_report_error (_tmp182_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp183_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp183_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp184_;
		gint _c_size = 0;
		ValaList* _tmp185_;
		gint _tmp186_;
		gint _tmp187_;
		gint _c_index = 0;
		_tmp184_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp184_;
		_tmp185_ = _c_list;
		_tmp186_ = vala_collection_get_size ((ValaCollection*) _tmp185_);
		_tmp187_ = _tmp186_;
		_c_size = _tmp187_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp188_;
			gpointer _tmp189_;
			ValaConstant* _tmp190_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp188_ = _c_list;
			_tmp189_ = vala_list_get (_tmp188_, _c_index);
			c = (ValaConstant*) _tmp189_;
			_tmp190_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp190_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp191_;
		gint _m_size = 0;
		ValaList* _tmp192_;
		gint _tmp193_;
		gint _tmp194_;
		gint _m_index = 0;
		_tmp191_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp191_;
		_tmp192_ = _m_list;
		_tmp193_ = vala_collection_get_size ((ValaCollection*) _tmp192_);
		_tmp194_ = _tmp193_;
		_m_size = _tmp194_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp195_;
			gpointer _tmp196_;
			ValaMethod* _tmp197_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp195_ = _m_list;
			_tmp196_ = vala_list_get (_tmp195_, _m_index);
			m = (ValaMethod*) _tmp196_;
			_tmp197_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp197_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp198_;
		gint _prop_size = 0;
		ValaList* _tmp199_;
		gint _tmp200_;
		gint _tmp201_;
		gint _prop_index = 0;
		_tmp198_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp198_;
		_tmp199_ = _prop_list;
		_tmp200_ = vala_collection_get_size ((ValaCollection*) _tmp199_);
		_tmp201_ = _tmp200_;
		_prop_size = _tmp201_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp202_;
			gpointer _tmp203_;
			gboolean _tmp204_ = FALSE;
			ValaProperty* _tmp205_;
			ValaAttribute* _tmp206_;
			ValaProperty* _tmp213_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp202_ = _prop_list;
			_tmp203_ = vala_list_get (_tmp202_, _prop_index);
			prop = (ValaProperty*) _tmp203_;
			_tmp205_ = prop;
			_tmp206_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp205_, "NoAccessorMethod");
			if (_tmp206_ != NULL) {
				ValaSemanticAnalyzer* _tmp207_;
				ValaSemanticAnalyzer* _tmp208_;
				ValaClass* _tmp209_;
				_tmp207_ = vala_code_context_get_analyzer (context);
				_tmp208_ = _tmp207_;
				_tmp209_ = _tmp208_->object_type;
				_tmp204_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp209_);
			} else {
				_tmp204_ = FALSE;
			}
			if (_tmp204_) {
				ValaProperty* _tmp210_;
				ValaSourceReference* _tmp211_;
				ValaSourceReference* _tmp212_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp210_ = prop;
				_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp210_);
				_tmp212_ = _tmp211_;
				vala_report_error (_tmp212_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp213_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp213_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp214_;
		gint _sig_size = 0;
		ValaList* _tmp215_;
		gint _tmp216_;
		gint _tmp217_;
		gint _sig_index = 0;
		_tmp214_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp214_;
		_tmp215_ = _sig_list;
		_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
		_tmp217_ = _tmp216_;
		_sig_size = _tmp217_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp218_;
			gpointer _tmp219_;
			ValaSignal* _tmp220_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp218_ = _sig_list;
			_tmp219_ = vala_list_get (_tmp218_, _sig_index);
			sig = (ValaSignal*) _tmp219_;
			_tmp220_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp220_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp221_ = vala_class_get_constructor (self);
	_tmp222_ = _tmp221_;
	if (_tmp222_ != NULL) {
		ValaConstructor* _tmp223_;
		ValaConstructor* _tmp224_;
		_tmp223_ = vala_class_get_constructor (self);
		_tmp224_ = _tmp223_;
		vala_code_node_check ((ValaCodeNode*) _tmp224_, context);
	}
	_tmp225_ = vala_class_get_class_constructor (self);
	_tmp226_ = _tmp225_;
	if (_tmp226_ != NULL) {
		ValaConstructor* _tmp227_;
		ValaConstructor* _tmp228_;
		_tmp227_ = vala_class_get_class_constructor (self);
		_tmp228_ = _tmp227_;
		vala_code_node_check ((ValaCodeNode*) _tmp228_, context);
	}
	_tmp229_ = vala_class_get_static_constructor (self);
	_tmp230_ = _tmp229_;
	if (_tmp230_ != NULL) {
		ValaConstructor* _tmp231_;
		ValaConstructor* _tmp232_;
		_tmp231_ = vala_class_get_static_constructor (self);
		_tmp232_ = _tmp231_;
		vala_code_node_check ((ValaCodeNode*) _tmp232_, context);
	}
	_tmp233_ = vala_class_get_destructor (self);
	_tmp234_ = _tmp233_;
	if (_tmp234_ != NULL) {
		ValaDestructor* _tmp235_;
		ValaDestructor* _tmp236_;
		_tmp235_ = vala_class_get_destructor (self);
		_tmp236_ = _tmp235_;
		vala_code_node_check ((ValaCodeNode*) _tmp236_, context);
	}
	_tmp237_ = vala_class_get_static_destructor (self);
	_tmp238_ = _tmp237_;
	if (_tmp238_ != NULL) {
		ValaDestructor* _tmp239_;
		ValaDestructor* _tmp240_;
		_tmp239_ = vala_class_get_static_destructor (self);
		_tmp240_ = _tmp239_;
		vala_code_node_check ((ValaCodeNode*) _tmp240_, context);
	}
	_tmp241_ = vala_class_get_class_destructor (self);
	_tmp242_ = _tmp241_;
	if (_tmp242_ != NULL) {
		ValaDestructor* _tmp243_;
		ValaDestructor* _tmp244_;
		_tmp243_ = vala_class_get_class_destructor (self);
		_tmp244_ = _tmp243_;
		vala_code_node_check ((ValaCodeNode*) _tmp244_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp245_;
		gint _cl_size = 0;
		ValaList* _tmp246_;
		gint _tmp247_;
		gint _tmp248_;
		gint _cl_index = 0;
		_tmp245_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp245_;
		_tmp246_ = _cl_list;
		_tmp247_ = vala_collection_get_size ((ValaCollection*) _tmp246_);
		_tmp248_ = _tmp247_;
		_cl_size = _tmp248_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp249_;
			gpointer _tmp250_;
			ValaClass* _tmp251_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp249_ = _cl_list;
			_tmp250_ = vala_list_get (_tmp249_, _cl_index);
			cl = (ValaClass*) _tmp250_;
			_tmp251_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp251_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp252_;
		gint _st_size = 0;
		ValaList* _tmp253_;
		gint _tmp254_;
		gint _tmp255_;
		gint _st_index = 0;
		_tmp252_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp252_;
		_tmp253_ = _st_list;
		_tmp254_ = vala_collection_get_size ((ValaCollection*) _tmp253_);
		_tmp255_ = _tmp254_;
		_st_size = _tmp255_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp256_;
			gpointer _tmp257_;
			ValaStruct* _tmp258_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp256_ = _st_list;
			_tmp257_ = vala_list_get (_tmp256_, _st_index);
			st = (ValaStruct*) _tmp257_;
			_tmp258_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp258_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp259_;
		gint _d_size = 0;
		ValaList* _tmp260_;
		gint _tmp261_;
		gint _tmp262_;
		gint _d_index = 0;
		_tmp259_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp259_;
		_tmp260_ = _d_list;
		_tmp261_ = vala_collection_get_size ((ValaCollection*) _tmp260_);
		_tmp262_ = _tmp261_;
		_d_size = _tmp262_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp263_;
			gpointer _tmp264_;
			ValaDelegate* _tmp265_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp263_ = _d_list;
			_tmp264_ = vala_list_get (_tmp263_, _d_index);
			d = (ValaDelegate*) _tmp264_;
			_tmp265_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp265_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp266_ = vala_class_get_is_compact (self);
	_tmp267_ = _tmp266_;
	if (_tmp267_) {
		gboolean _tmp283_ = FALSE;
		gboolean _tmp284_ = FALSE;
		gboolean _tmp285_ = FALSE;
		gboolean _tmp286_;
		gboolean _tmp287_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp268_;
			gint _base_type_size = 0;
			ValaList* _tmp269_;
			gint _tmp270_;
			gint _tmp271_;
			gint _base_type_index = 0;
			_tmp268_ = vala_class_get_base_types (self);
			_base_type_list = _tmp268_;
			_tmp269_ = _base_type_list;
			_tmp270_ = vala_collection_get_size ((ValaCollection*) _tmp269_);
			_tmp271_ = _tmp270_;
			_base_type_size = _tmp271_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp272_;
				gpointer _tmp273_;
				ValaDataType* _tmp274_;
				ValaTypeSymbol* _tmp275_;
				ValaTypeSymbol* _tmp276_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp272_ = _base_type_list;
				_tmp273_ = vala_list_get (_tmp272_, _base_type_index);
				base_type = (ValaDataType*) _tmp273_;
				_tmp274_ = base_type;
				_tmp275_ = vala_data_type_get_data_type (_tmp274_);
				_tmp276_ = _tmp275_;
				if (VALA_IS_INTERFACE (_tmp276_)) {
					ValaSourceReference* _tmp277_;
					ValaSourceReference* _tmp278_;
					gchar* _tmp279_;
					gchar* _tmp280_;
					gchar* _tmp281_;
					gchar* _tmp282_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp278_ = _tmp277_;
					_tmp279_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp280_ = _tmp279_;
					_tmp281_ = g_strdup_printf ("compact classes `%s' may not implement interfaces", _tmp280_);
					_tmp282_ = _tmp281_;
					vala_report_error (_tmp278_, _tmp282_);
					_g_free0 (_tmp282_);
					_g_free0 (_tmp280_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp286_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp287_ = _tmp286_;
		if (!_tmp287_) {
			gboolean _tmp288_;
			gboolean _tmp289_;
			_tmp288_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp289_ = _tmp288_;
			_tmp285_ = !_tmp289_;
		} else {
			_tmp285_ = FALSE;
		}
		if (_tmp285_) {
			ValaClass* _tmp290_;
			_tmp290_ = self->priv->_base_class;
			_tmp284_ = _tmp290_ != NULL;
		} else {
			_tmp284_ = FALSE;
		}
		if (_tmp284_) {
			ValaClass* _tmp291_;
			ValaSemanticAnalyzer* _tmp292_;
			ValaSemanticAnalyzer* _tmp293_;
			ValaClass* _tmp294_;
			_tmp291_ = self->priv->_base_class;
			_tmp292_ = vala_code_context_get_analyzer (context);
			_tmp293_ = _tmp292_;
			_tmp294_ = _tmp293_->gsource_type;
			_tmp283_ = _tmp291_ != _tmp294_;
		} else {
			_tmp283_ = FALSE;
		}
		if (_tmp283_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp295_;
				gint _f_size = 0;
				ValaList* _tmp296_;
				gint _tmp297_;
				gint _tmp298_;
				gint _f_index = 0;
				_tmp295_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp295_;
				_tmp296_ = _f_list;
				_tmp297_ = vala_collection_get_size ((ValaCollection*) _tmp296_);
				_tmp298_ = _tmp297_;
				_f_size = _tmp298_;
				_f_index = -1;
				while (TRUE) {
					ValaField* f = NULL;
					ValaList* _tmp299_;
					gpointer _tmp300_;
					ValaField* _tmp301_;
					ValaMemberBinding _tmp302_;
					ValaMemberBinding _tmp303_;
					_f_index = _f_index + 1;
					if (!(_f_index < _f_size)) {
						break;
					}
					_tmp299_ = _f_list;
					_tmp300_ = vala_list_get (_tmp299_, _f_index);
					f = (ValaField*) _tmp300_;
					_tmp301_ = f;
					_tmp302_ = vala_field_get_binding (_tmp301_);
					_tmp303_ = _tmp302_;
					if (_tmp303_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp304_;
						ValaSourceReference* _tmp305_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp304_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp305_ = _tmp304_;
						vala_report_error (_tmp305_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp306_ = g_direct_equal;
	_tmp307_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp306_);
	prerequisites = (ValaList*) _tmp307_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp308_;
		gint _base_type_size = 0;
		ValaList* _tmp309_;
		gint _tmp310_;
		gint _tmp311_;
		gint _base_type_index = 0;
		_tmp308_ = vala_class_get_base_types (self);
		_base_type_list = _tmp308_;
		_tmp309_ = _base_type_list;
		_tmp310_ = vala_collection_get_size ((ValaCollection*) _tmp309_);
		_tmp311_ = _tmp310_;
		_base_type_size = _tmp311_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp312_;
			gpointer _tmp313_;
			ValaDataType* _tmp314_;
			ValaTypeSymbol* _tmp315_;
			ValaTypeSymbol* _tmp316_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp312_ = _base_type_list;
			_tmp313_ = vala_list_get (_tmp312_, _base_type_index);
			base_type = (ValaDataType*) _tmp313_;
			_tmp314_ = base_type;
			_tmp315_ = vala_data_type_get_data_type (_tmp314_);
			_tmp316_ = _tmp315_;
			if (VALA_IS_INTERFACE (_tmp316_)) {
				ValaDataType* _tmp317_;
				ValaTypeSymbol* _tmp318_;
				ValaTypeSymbol* _tmp319_;
				ValaList* _tmp320_;
				_tmp317_ = base_type;
				_tmp318_ = vala_data_type_get_data_type (_tmp317_);
				_tmp319_ = _tmp318_;
				_tmp320_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp319_, VALA_TYPE_INTERFACE, ValaInterface), _tmp320_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp321_ = g_direct_equal;
	_tmp322_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp321_);
	missing_prereqs = (ValaList*) _tmp322_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp323_;
		ValaList* _tmp324_;
		gint _prereq_size = 0;
		ValaList* _tmp325_;
		gint _tmp326_;
		gint _tmp327_;
		gint _prereq_index = 0;
		_tmp323_ = prerequisites;
		_tmp324_ = _vala_iterable_ref0 (_tmp323_);
		_prereq_list = _tmp324_;
		_tmp325_ = _prereq_list;
		_tmp326_ = vala_collection_get_size ((ValaCollection*) _tmp325_);
		_tmp327_ = _tmp326_;
		_prereq_size = _tmp327_;
		_prereq_index = -1;
		while (TRUE) {
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp328_;
			gpointer _tmp329_;
			ValaTypeSymbol* _tmp330_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp328_ = _prereq_list;
			_tmp329_ = vala_list_get (_tmp328_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp329_;
			_tmp330_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp331_;
				ValaTypeSymbol* _tmp332_;
				gchar* _tmp333_;
				gchar* _tmp334_;
				_tmp331_ = missing_prereqs;
				_tmp332_ = prereq;
				_tmp333_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp332_);
				_tmp334_ = _tmp333_;
				vala_list_insert (_tmp331_, 0, _tmp334_);
				_g_free0 (_tmp334_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp335_ = missing_prereqs;
	_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
	_tmp337_ = _tmp336_;
	if (_tmp337_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp338_;
		gchar* _tmp339_;
		gchar* _tmp340_;
		gchar* _tmp341_;
		gboolean first = FALSE;
		const gchar* _tmp355_;
		gchar* _tmp356_;
		ValaSourceReference* _tmp357_;
		ValaSourceReference* _tmp358_;
		const gchar* _tmp359_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp338_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp339_ = _tmp338_;
		_tmp340_ = g_strdup_printf ("%s: some prerequisites (", _tmp339_);
		_tmp341_ = _tmp340_;
		_g_free0 (_tmp339_);
		error_string = _tmp341_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp342_;
			ValaList* _tmp343_;
			gint _s_size = 0;
			ValaList* _tmp344_;
			gint _tmp345_;
			gint _tmp346_;
			gint _s_index = 0;
			_tmp342_ = missing_prereqs;
			_tmp343_ = _vala_iterable_ref0 (_tmp342_);
			_s_list = _tmp343_;
			_tmp344_ = _s_list;
			_tmp345_ = vala_collection_get_size ((ValaCollection*) _tmp344_);
			_tmp346_ = _tmp345_;
			_s_size = _tmp346_;
			_s_index = -1;
			while (TRUE) {
				gchar* s = NULL;
				ValaList* _tmp347_;
				gpointer _tmp348_;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp347_ = _s_list;
				_tmp348_ = vala_list_get (_tmp347_, _s_index);
				s = (gchar*) _tmp348_;
				if (first) {
					const gchar* _tmp349_;
					const gchar* _tmp350_;
					gchar* _tmp351_;
					_tmp349_ = error_string;
					_tmp350_ = s;
					_tmp351_ = g_strdup_printf ("%s`%s'", _tmp349_, _tmp350_);
					_g_free0 (error_string);
					error_string = _tmp351_;
					first = FALSE;
				} else {
					const gchar* _tmp352_;
					const gchar* _tmp353_;
					gchar* _tmp354_;
					_tmp352_ = error_string;
					_tmp353_ = s;
					_tmp354_ = g_strdup_printf ("%s, `%s'", _tmp352_, _tmp353_);
					_g_free0 (error_string);
					error_string = _tmp354_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp355_ = error_string;
		_tmp356_ = g_strconcat (_tmp355_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp356_;
		_tmp357_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp358_ = _tmp357_;
		_tmp359_ = error_string;
		vala_report_error (_tmp358_, _tmp359_);
		_g_free0 (error_string);
	}
	_tmp360_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp361_ = _tmp360_;
	if (_tmp361_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp515_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp362_;
			gint _base_type_size = 0;
			ValaList* _tmp363_;
			gint _tmp364_;
			gint _tmp365_;
			gint _base_type_index = 0;
			_tmp362_ = vala_class_get_base_types (self);
			_base_type_list = _tmp362_;
			_tmp363_ = _base_type_list;
			_tmp364_ = vala_collection_get_size ((ValaCollection*) _tmp363_);
			_tmp365_ = _tmp364_;
			_base_type_size = _tmp365_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp366_;
				gpointer _tmp367_;
				ValaDataType* _tmp368_;
				ValaTypeSymbol* _tmp369_;
				ValaTypeSymbol* _tmp370_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp366_ = _base_type_list;
				_tmp367_ = vala_list_get (_tmp366_, _base_type_index);
				base_type = (ValaDataType*) _tmp367_;
				_tmp368_ = base_type;
				_tmp369_ = vala_data_type_get_data_type (_tmp368_);
				_tmp370_ = _tmp369_;
				if (VALA_IS_INTERFACE (_tmp370_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp371_;
					ValaTypeSymbol* _tmp372_;
					ValaTypeSymbol* _tmp373_;
					ValaInterface* _tmp374_;
					gboolean _tmp375_ = FALSE;
					ValaClass* _tmp376_;
					_tmp371_ = base_type;
					_tmp372_ = vala_data_type_get_data_type (_tmp371_);
					_tmp373_ = _tmp372_;
					_tmp374_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp373_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp374_;
					_tmp376_ = self->priv->_base_class;
					if (_tmp376_ != NULL) {
						ValaClass* _tmp377_;
						ValaInterface* _tmp378_;
						_tmp377_ = self->priv->_base_class;
						_tmp378_ = iface;
						_tmp375_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp377_, (ValaTypeSymbol*) _tmp378_);
					} else {
						_tmp375_ = FALSE;
					}
					if (_tmp375_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp379_;
						ValaList* _tmp380_;
						gint _m_size = 0;
						ValaList* _tmp381_;
						gint _tmp382_;
						gint _tmp383_;
						gint _m_index = 0;
						_tmp379_ = iface;
						_tmp380_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp379_);
						_m_list = _tmp380_;
						_tmp381_ = _m_list;
						_tmp382_ = vala_collection_get_size ((ValaCollection*) _tmp381_);
						_tmp383_ = _tmp382_;
						_m_size = _tmp383_;
						_m_index = -1;
						while (TRUE) {
							ValaMethod* m = NULL;
							ValaList* _tmp384_;
							gpointer _tmp385_;
							ValaMethod* _tmp386_;
							gboolean _tmp387_;
							gboolean _tmp388_;
							_m_index = _m_index + 1;
							if (!(_m_index < _m_size)) {
								break;
							}
							_tmp384_ = _m_list;
							_tmp385_ = vala_list_get (_tmp384_, _m_index);
							m = (ValaMethod*) _tmp385_;
							_tmp386_ = m;
							_tmp387_ = vala_method_get_is_abstract (_tmp386_);
							_tmp388_ = _tmp387_;
							if (_tmp388_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp389_;
								implemented = FALSE;
								_tmp389_ = _vala_code_node_ref0 (self);
								base_class = _tmp389_;
								while (TRUE) {
									gboolean _tmp390_ = FALSE;
									ValaClass* _tmp391_;
									ValaClass* _tmp442_;
									ValaClass* _tmp443_;
									ValaClass* _tmp444_;
									_tmp391_ = base_class;
									if (_tmp391_ != NULL) {
										_tmp390_ = !implemented;
									} else {
										_tmp390_ = FALSE;
									}
									if (!_tmp390_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp392_;
										ValaList* _tmp393_;
										gint _impl_size = 0;
										ValaList* _tmp394_;
										gint _tmp395_;
										gint _tmp396_;
										gint _impl_index = 0;
										_tmp392_ = base_class;
										_tmp393_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp392_);
										_impl_list = _tmp393_;
										_tmp394_ = _impl_list;
										_tmp395_ = vala_collection_get_size ((ValaCollection*) _tmp394_);
										_tmp396_ = _tmp395_;
										_impl_size = _tmp396_;
										_impl_index = -1;
										while (TRUE) {
											ValaMethod* impl = NULL;
											ValaList* _tmp397_;
											gpointer _tmp398_;
											gboolean _tmp399_ = FALSE;
											ValaMethod* _tmp400_;
											ValaMethod* _tmp401_;
											ValaMethod* _tmp402_;
											ValaMethod* _tmp403_;
											_impl_index = _impl_index + 1;
											if (!(_impl_index < _impl_size)) {
												break;
											}
											_tmp397_ = _impl_list;
											_tmp398_ = vala_list_get (_tmp397_, _impl_index);
											impl = (ValaMethod*) _tmp398_;
											_tmp400_ = impl;
											_tmp401_ = vala_method_get_base_interface_method (_tmp400_);
											_tmp402_ = _tmp401_;
											_tmp403_ = m;
											if (_tmp402_ == _tmp403_) {
												_tmp399_ = TRUE;
											} else {
												gboolean _tmp404_ = FALSE;
												gboolean _tmp405_ = FALSE;
												gboolean _tmp406_ = FALSE;
												gboolean _tmp407_ = FALSE;
												ValaClass* _tmp408_;
												_tmp408_ = base_class;
												if (_tmp408_ != self) {
													ValaMethod* _tmp409_;
													ValaMethod* _tmp410_;
													ValaMethod* _tmp411_;
													_tmp409_ = impl;
													_tmp410_ = vala_method_get_base_interface_method (_tmp409_);
													_tmp411_ = _tmp410_;
													_tmp407_ = _tmp411_ == NULL;
												} else {
													_tmp407_ = FALSE;
												}
												if (_tmp407_) {
													ValaMethod* _tmp412_;
													const gchar* _tmp413_;
													const gchar* _tmp414_;
													ValaMethod* _tmp415_;
													const gchar* _tmp416_;
													const gchar* _tmp417_;
													_tmp412_ = impl;
													_tmp413_ = vala_symbol_get_name ((ValaSymbol*) _tmp412_);
													_tmp414_ = _tmp413_;
													_tmp415_ = m;
													_tmp416_ = vala_symbol_get_name ((ValaSymbol*) _tmp415_);
													_tmp417_ = _tmp416_;
													_tmp406_ = g_strcmp0 (_tmp414_, _tmp417_) == 0;
												} else {
													_tmp406_ = FALSE;
												}
												if (_tmp406_) {
													gboolean _tmp418_ = FALSE;
													ValaMethod* _tmp419_;
													ValaDataType* _tmp420_;
													ValaDataType* _tmp421_;
													_tmp419_ = impl;
													_tmp420_ = vala_method_get_base_interface_type (_tmp419_);
													_tmp421_ = _tmp420_;
													if (_tmp421_ == NULL) {
														_tmp418_ = TRUE;
													} else {
														ValaMethod* _tmp422_;
														ValaDataType* _tmp423_;
														ValaDataType* _tmp424_;
														ValaTypeSymbol* _tmp425_;
														ValaTypeSymbol* _tmp426_;
														ValaInterface* _tmp427_;
														_tmp422_ = impl;
														_tmp423_ = vala_method_get_base_interface_type (_tmp422_);
														_tmp424_ = _tmp423_;
														_tmp425_ = vala_data_type_get_data_type (_tmp424_);
														_tmp426_ = _tmp425_;
														_tmp427_ = iface;
														_tmp418_ = _tmp426_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp427_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp405_ = _tmp418_;
												} else {
													_tmp405_ = FALSE;
												}
												if (_tmp405_) {
													ValaMethod* _tmp428_;
													ValaMethod* _tmp429_;
													_tmp428_ = impl;
													_tmp429_ = m;
													_tmp404_ = vala_method_compatible_no_error (_tmp428_, _tmp429_);
												} else {
													_tmp404_ = FALSE;
												}
												_tmp399_ = _tmp404_;
											}
											if (_tmp399_) {
												ValaMethod* _tmp430_;
												ValaVersionAttribute* _tmp431_;
												ValaVersionAttribute* _tmp432_;
												ValaSourceReference* _tmp433_;
												ValaSourceReference* _tmp434_;
												ValaMethod* _tmp435_;
												ValaMethod* _tmp436_;
												ValaMethod* _tmp437_;
												ValaMethod* _tmp438_;
												_tmp430_ = impl;
												_tmp431_ = vala_symbol_get_version ((ValaSymbol*) _tmp430_);
												_tmp432_ = _tmp431_;
												_tmp433_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp434_ = _tmp433_;
												vala_version_attribute_check (_tmp432_, _tmp434_);
												_tmp435_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp435_, TRUE);
												implemented = TRUE;
												_tmp436_ = impl;
												_tmp437_ = vala_method_get_base_interface_method (_tmp436_);
												_tmp438_ = _tmp437_;
												if (_tmp438_ == NULL) {
													ValaHashMap* _tmp439_;
													ValaMethod* _tmp440_;
													ValaMethod* _tmp441_;
													_tmp439_ = self->priv->implicit_implementations;
													_tmp440_ = m;
													_tmp441_ = impl;
													vala_map_set ((ValaMap*) _tmp439_, _tmp440_, _tmp441_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp442_ = base_class;
									_tmp443_ = _tmp442_->priv->_base_class;
									_tmp444_ = _vala_code_node_ref0 (_tmp443_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp444_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp445_;
									ValaSourceReference* _tmp446_;
									gchar* _tmp447_;
									gchar* _tmp448_;
									ValaMethod* _tmp449_;
									gchar* _tmp450_;
									gchar* _tmp451_;
									gchar* _tmp452_;
									gchar* _tmp453_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp445_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp446_ = _tmp445_;
									_tmp447_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp448_ = _tmp447_;
									_tmp449_ = m;
									_tmp450_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp449_);
									_tmp451_ = _tmp450_;
									_tmp452_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp448_, _tmp451_);
									_tmp453_ = _tmp452_;
									vala_report_error (_tmp446_, _tmp453_);
									_g_free0 (_tmp453_);
									_g_free0 (_tmp451_);
									_g_free0 (_tmp448_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp454_;
						ValaList* _tmp455_;
						gint _prop_size = 0;
						ValaList* _tmp456_;
						gint _tmp457_;
						gint _tmp458_;
						gint _prop_index = 0;
						_tmp454_ = iface;
						_tmp455_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp454_);
						_prop_list = _tmp455_;
						_tmp456_ = _prop_list;
						_tmp457_ = vala_collection_get_size ((ValaCollection*) _tmp456_);
						_tmp458_ = _tmp457_;
						_prop_size = _tmp458_;
						_prop_index = -1;
						while (TRUE) {
							ValaProperty* prop = NULL;
							ValaList* _tmp459_;
							gpointer _tmp460_;
							ValaProperty* _tmp461_;
							gboolean _tmp462_;
							gboolean _tmp463_;
							_prop_index = _prop_index + 1;
							if (!(_prop_index < _prop_size)) {
								break;
							}
							_tmp459_ = _prop_list;
							_tmp460_ = vala_list_get (_tmp459_, _prop_index);
							prop = (ValaProperty*) _tmp460_;
							_tmp461_ = prop;
							_tmp462_ = vala_property_get_is_abstract (_tmp461_);
							_tmp463_ = _tmp462_;
							if (_tmp463_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp464_;
								ValaSymbol* _tmp478_;
								sym = NULL;
								_tmp464_ = _vala_code_node_ref0 (self);
								base_class = _tmp464_;
								while (TRUE) {
									gboolean _tmp465_ = FALSE;
									ValaClass* _tmp466_;
									ValaClass* _tmp468_;
									ValaScope* _tmp469_;
									ValaScope* _tmp470_;
									ValaProperty* _tmp471_;
									const gchar* _tmp472_;
									const gchar* _tmp473_;
									ValaSymbol* _tmp474_;
									ValaClass* _tmp475_;
									ValaClass* _tmp476_;
									ValaClass* _tmp477_;
									_tmp466_ = base_class;
									if (_tmp466_ != NULL) {
										ValaSymbol* _tmp467_;
										_tmp467_ = sym;
										_tmp465_ = !VALA_IS_PROPERTY (_tmp467_);
									} else {
										_tmp465_ = FALSE;
									}
									if (!_tmp465_) {
										break;
									}
									_tmp468_ = base_class;
									_tmp469_ = vala_symbol_get_scope ((ValaSymbol*) _tmp468_);
									_tmp470_ = _tmp469_;
									_tmp471_ = prop;
									_tmp472_ = vala_symbol_get_name ((ValaSymbol*) _tmp471_);
									_tmp473_ = _tmp472_;
									_tmp474_ = vala_scope_lookup (_tmp470_, _tmp473_);
									_vala_code_node_unref0 (sym);
									sym = _tmp474_;
									_tmp475_ = base_class;
									_tmp476_ = _tmp475_->priv->_base_class;
									_tmp477_ = _vala_code_node_ref0 (_tmp476_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp477_;
								}
								_tmp478_ = sym;
								if (VALA_IS_PROPERTY (_tmp478_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp479_;
									ValaProperty* _tmp480_;
									gchar* invalid_match = NULL;
									gboolean _tmp481_ = FALSE;
									ValaProperty* _tmp482_;
									gboolean _tmp483_;
									gboolean _tmp484_;
									ValaSymbol* _tmp500_;
									ValaVersionAttribute* _tmp501_;
									ValaVersionAttribute* _tmp502_;
									ValaSourceReference* _tmp503_;
									ValaSourceReference* _tmp504_;
									ValaSymbol* _tmp505_;
									_tmp479_ = sym;
									_tmp480_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp479_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp480_;
									invalid_match = NULL;
									_tmp482_ = base_prop;
									_tmp483_ = vala_symbol_get_hides ((ValaSymbol*) _tmp482_);
									_tmp484_ = _tmp483_;
									if (!_tmp484_) {
										ValaProperty* _tmp485_;
										ValaProperty* _tmp486_;
										gchar* _tmp487_ = NULL;
										gboolean _tmp488_;
										_tmp485_ = base_prop;
										_tmp486_ = prop;
										_tmp488_ = vala_property_compatible (_tmp485_, _tmp486_, &_tmp487_);
										_g_free0 (invalid_match);
										invalid_match = _tmp487_;
										_tmp481_ = !_tmp488_;
									} else {
										_tmp481_ = FALSE;
									}
									if (_tmp481_) {
										ValaSourceReference* _tmp489_;
										ValaSourceReference* _tmp490_;
										ValaProperty* _tmp491_;
										gchar* _tmp492_;
										gchar* _tmp493_;
										ValaProperty* _tmp494_;
										gchar* _tmp495_;
										gchar* _tmp496_;
										const gchar* _tmp497_;
										gchar* _tmp498_;
										gchar* _tmp499_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp489_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp490_ = _tmp489_;
										_tmp491_ = prop;
										_tmp492_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp491_);
										_tmp493_ = _tmp492_;
										_tmp494_ = base_prop;
										_tmp495_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp494_);
										_tmp496_ = _tmp495_;
										_tmp497_ = invalid_match;
										_tmp498_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp493_, _tmp496_, _tmp497_);
										_tmp499_ = _tmp498_;
										vala_report_error (_tmp490_, _tmp499_);
										_g_free0 (_tmp499_);
										_g_free0 (_tmp496_);
										_g_free0 (_tmp493_);
									}
									_tmp500_ = sym;
									_tmp501_ = vala_symbol_get_version (_tmp500_);
									_tmp502_ = _tmp501_;
									_tmp503_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp504_ = _tmp503_;
									vala_version_attribute_check (_tmp502_, _tmp504_);
									_tmp505_ = sym;
									vala_symbol_set_used (_tmp505_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp506_;
									ValaSourceReference* _tmp507_;
									gchar* _tmp508_;
									gchar* _tmp509_;
									ValaProperty* _tmp510_;
									gchar* _tmp511_;
									gchar* _tmp512_;
									gchar* _tmp513_;
									gchar* _tmp514_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp506_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp507_ = _tmp506_;
									_tmp508_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp509_ = _tmp508_;
									_tmp510_ = prop;
									_tmp511_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp510_);
									_tmp512_ = _tmp511_;
									_tmp513_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp509_, _tmp512_);
									_tmp514_ = _tmp513_;
									vala_report_error (_tmp507_, _tmp514_);
									_g_free0 (_tmp514_);
									_g_free0 (_tmp512_);
									_g_free0 (_tmp509_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp515_ = self->priv->_is_abstract;
		if (!_tmp515_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp516_;
			ValaClass* _tmp517_;
			_tmp516_ = self->priv->_base_class;
			_tmp517_ = _vala_code_node_ref0 (_tmp516_);
			base_class = _tmp517_;
			while (TRUE) {
				gboolean _tmp518_ = FALSE;
				ValaClass* _tmp519_;
				ValaClass* _tmp580_;
				ValaClass* _tmp581_;
				ValaClass* _tmp582_;
				_tmp519_ = base_class;
				if (_tmp519_ != NULL) {
					ValaClass* _tmp520_;
					gboolean _tmp521_;
					_tmp520_ = base_class;
					_tmp521_ = _tmp520_->priv->_is_abstract;
					_tmp518_ = _tmp521_;
				} else {
					_tmp518_ = FALSE;
				}
				if (!_tmp518_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp522_;
					ValaList* _tmp523_;
					gint _base_method_size = 0;
					ValaList* _tmp524_;
					gint _tmp525_;
					gint _tmp526_;
					gint _base_method_index = 0;
					_tmp522_ = base_class;
					_tmp523_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp522_);
					_base_method_list = _tmp523_;
					_tmp524_ = _base_method_list;
					_tmp525_ = vala_collection_get_size ((ValaCollection*) _tmp524_);
					_tmp526_ = _tmp525_;
					_base_method_size = _tmp526_;
					_base_method_index = -1;
					while (TRUE) {
						ValaMethod* base_method = NULL;
						ValaList* _tmp527_;
						gpointer _tmp528_;
						ValaMethod* _tmp529_;
						gboolean _tmp530_;
						gboolean _tmp531_;
						_base_method_index = _base_method_index + 1;
						if (!(_base_method_index < _base_method_size)) {
							break;
						}
						_tmp527_ = _base_method_list;
						_tmp528_ = vala_list_get (_tmp527_, _base_method_index);
						base_method = (ValaMethod*) _tmp528_;
						_tmp529_ = base_method;
						_tmp530_ = vala_method_get_is_abstract (_tmp529_);
						_tmp531_ = _tmp530_;
						if (_tmp531_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp532_;
							const gchar* _tmp533_;
							const gchar* _tmp534_;
							ValaSymbol* _tmp535_;
							ValaMethod* _tmp536_;
							gboolean _tmp537_ = FALSE;
							ValaMethod* _tmp538_;
							_tmp532_ = base_method;
							_tmp533_ = vala_symbol_get_name ((ValaSymbol*) _tmp532_);
							_tmp534_ = _tmp533_;
							_tmp535_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp534_);
							_tmp536_ = VALA_IS_METHOD (_tmp535_) ? ((ValaMethod*) _tmp535_) : NULL;
							if (_tmp536_ == NULL) {
								_vala_code_node_unref0 (_tmp535_);
							}
							override_method = _tmp536_;
							_tmp538_ = override_method;
							if (_tmp538_ == NULL) {
								_tmp537_ = TRUE;
							} else {
								ValaMethod* _tmp539_;
								gboolean _tmp540_;
								gboolean _tmp541_;
								_tmp539_ = override_method;
								_tmp540_ = vala_method_get_overrides (_tmp539_);
								_tmp541_ = _tmp540_;
								_tmp537_ = !_tmp541_;
							}
							if (_tmp537_) {
								ValaSourceReference* _tmp542_;
								ValaSourceReference* _tmp543_;
								gchar* _tmp544_;
								gchar* _tmp545_;
								ValaMethod* _tmp546_;
								gchar* _tmp547_;
								gchar* _tmp548_;
								gchar* _tmp549_;
								gchar* _tmp550_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp542_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp543_ = _tmp542_;
								_tmp544_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp545_ = _tmp544_;
								_tmp546_ = base_method;
								_tmp547_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp546_);
								_tmp548_ = _tmp547_;
								_tmp549_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp545_, _tmp548_);
								_tmp550_ = _tmp549_;
								vala_report_error (_tmp543_, _tmp550_);
								_g_free0 (_tmp550_);
								_g_free0 (_tmp548_);
								_g_free0 (_tmp545_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp551_;
					ValaList* _tmp552_;
					gint _base_property_size = 0;
					ValaList* _tmp553_;
					gint _tmp554_;
					gint _tmp555_;
					gint _base_property_index = 0;
					_tmp551_ = base_class;
					_tmp552_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp551_);
					_base_property_list = _tmp552_;
					_tmp553_ = _base_property_list;
					_tmp554_ = vala_collection_get_size ((ValaCollection*) _tmp553_);
					_tmp555_ = _tmp554_;
					_base_property_size = _tmp555_;
					_base_property_index = -1;
					while (TRUE) {
						ValaProperty* base_property = NULL;
						ValaList* _tmp556_;
						gpointer _tmp557_;
						ValaProperty* _tmp558_;
						gboolean _tmp559_;
						gboolean _tmp560_;
						_base_property_index = _base_property_index + 1;
						if (!(_base_property_index < _base_property_size)) {
							break;
						}
						_tmp556_ = _base_property_list;
						_tmp557_ = vala_list_get (_tmp556_, _base_property_index);
						base_property = (ValaProperty*) _tmp557_;
						_tmp558_ = base_property;
						_tmp559_ = vala_property_get_is_abstract (_tmp558_);
						_tmp560_ = _tmp559_;
						if (_tmp560_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp561_;
							const gchar* _tmp562_;
							const gchar* _tmp563_;
							ValaSymbol* _tmp564_;
							ValaProperty* _tmp565_;
							gboolean _tmp566_ = FALSE;
							ValaProperty* _tmp567_;
							_tmp561_ = base_property;
							_tmp562_ = vala_symbol_get_name ((ValaSymbol*) _tmp561_);
							_tmp563_ = _tmp562_;
							_tmp564_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp563_);
							_tmp565_ = VALA_IS_PROPERTY (_tmp564_) ? ((ValaProperty*) _tmp564_) : NULL;
							if (_tmp565_ == NULL) {
								_vala_code_node_unref0 (_tmp564_);
							}
							override_property = _tmp565_;
							_tmp567_ = override_property;
							if (_tmp567_ == NULL) {
								_tmp566_ = TRUE;
							} else {
								ValaProperty* _tmp568_;
								gboolean _tmp569_;
								gboolean _tmp570_;
								_tmp568_ = override_property;
								_tmp569_ = vala_property_get_overrides (_tmp568_);
								_tmp570_ = _tmp569_;
								_tmp566_ = !_tmp570_;
							}
							if (_tmp566_) {
								ValaSourceReference* _tmp571_;
								ValaSourceReference* _tmp572_;
								gchar* _tmp573_;
								gchar* _tmp574_;
								ValaProperty* _tmp575_;
								gchar* _tmp576_;
								gchar* _tmp577_;
								gchar* _tmp578_;
								gchar* _tmp579_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp571_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp572_ = _tmp571_;
								_tmp573_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp574_ = _tmp573_;
								_tmp575_ = base_property;
								_tmp576_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp575_);
								_tmp577_ = _tmp576_;
								_tmp578_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp574_, _tmp577_);
								_tmp579_ = _tmp578_;
								vala_report_error (_tmp572_, _tmp579_);
								_g_free0 (_tmp579_);
								_g_free0 (_tmp577_);
								_g_free0 (_tmp574_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp580_ = base_class;
				_tmp581_ = _tmp580_->priv->_base_class;
				_tmp582_ = _vala_code_node_ref0 (_tmp581_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp582_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp583_ = vala_code_context_get_analyzer (context);
	_tmp584_ = _tmp583_;
	_tmp585_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp584_, _tmp585_);
	_tmp586_ = vala_code_context_get_analyzer (context);
	_tmp587_ = _tmp586_;
	_tmp588_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp587_, _tmp588_);
	_tmp589_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp590_ = _tmp589_;
	result = !_tmp590_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

void
vala_class_set_is_singleton (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_singleton);
	self->priv->_is_singleton = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SingleInstance", value, NULL);
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		ValaDestructor* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaDestructor* _tmp16_;
		ValaObjectType* _tmp17_;
		ValaObjectType* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		ValaDestructor* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		ValaDestructor* _tmp24_;
		ValaParameter* _tmp25_;
		ValaParameter* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ValaDestructor* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
		_tmp5_ = self->priv->_destructor;
		_tmp6_ = vala_destructor_get_this_parameter (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaDestructor* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			ValaDestructor* _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameter* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = self->priv->_destructor;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_destructor;
			_tmp12_ = vala_destructor_get_this_parameter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			vala_scope_remove (_tmp10_, _tmp15_);
		}
		_tmp16_ = self->priv->_destructor;
		_tmp17_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_parameter_new ("this", (ValaDataType*) _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		vala_destructor_set_this_parameter (_tmp16_, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp21_ = self->priv->_destructor;
		_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_destructor;
		_tmp25_ = vala_destructor_get_this_parameter (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_destructor;
		_tmp30_ = vala_destructor_get_this_parameter (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_scope_add (_tmp23_, _tmp28_, (ValaSymbol*) _tmp31_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashMap* _tmp5_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_, _tmp3_, _tmp4_);
	self->priv->implicit_implementations = _tmp5_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

