/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSemanticAnalyzer* _tmp31_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp44_;
	ValaDataType* _tmp45_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	ValaArrayType* _tmp49_;
	ValaExpression* _tmp61_;
	ValaExpression* _tmp62_;
	gboolean _tmp185_ = FALSE;
	ValaMemberBinding _tmp186_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp191_;
	ValaSymbol* _tmp192_;
	gboolean _tmp201_ = FALSE;
	gboolean _tmp202_ = FALSE;
	gboolean _tmp203_;
	gboolean _tmp204_;
	ValaSemanticAnalyzer* _tmp219_;
	ValaSemanticAnalyzer* _tmp220_;
	ValaSourceFile* _tmp221_;
	ValaSemanticAnalyzer* _tmp222_;
	ValaSemanticAnalyzer* _tmp223_;
	ValaSymbol* _tmp224_;
	gboolean _tmp225_;
	gboolean _tmp226_;
	gboolean result = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	vala_code_node_check ((ValaCodeNode*) _tmp29_, context);
	_tmp30_ = vala_code_context_get_analyzer (context);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp33_ = _tmp32_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp31_, (ValaSymbol*) self, _tmp33_)) {
		ValaSourceReference* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strdup_printf ("field type `%s' is less accessible than field `%s'", _tmp39_, _tmp41_);
		_tmp43_ = _tmp42_;
		vala_report_error (_tmp35_, _tmp43_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp44_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp45_ = _tmp44_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp45_) ? ((ValaArrayType*) _tmp45_) : NULL;
	_tmp49_ = variable_array_type;
	if (_tmp49_ != NULL) {
		ValaArrayType* _tmp50_;
		gboolean _tmp51_;
		gboolean _tmp52_;
		_tmp50_ = variable_array_type;
		_tmp51_ = vala_array_type_get_fixed_length (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp48_ = _tmp52_;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp47_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp54_);
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaInitializerList* _tmp57_;
		ValaInitializerList* _tmp58_;
		_tmp55_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp58_ = _tmp57_;
		_tmp46_ = _tmp58_ == NULL;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		ValaSourceReference* _tmp59_;
		ValaSourceReference* _tmp60_;
		_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp60_ = _tmp59_;
		vala_report_warning (_tmp60_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp62_ = _tmp61_;
	if (_tmp62_ != NULL) {
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp67_;
		ValaExpression* _tmp68_;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp74_;
		ValaExpression* _tmp75_;
		ValaExpression* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaExpression* _tmp81_;
		ValaExpression* _tmp82_;
		ValaDataType* _tmp83_;
		ValaDataType* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaArrayType* _tmp104_;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_ = FALSE;
		ValaArrayType* _tmp120_;
		ValaExpression* _tmp130_;
		ValaExpression* _tmp131_;
		ValaDataType* _tmp132_;
		ValaDataType* _tmp133_;
		gboolean _tmp143_ = FALSE;
		ValaSymbol* _tmp144_;
		ValaSymbol* _tmp145_;
		gboolean _tmp150_ = FALSE;
		gboolean _tmp151_ = FALSE;
		ValaSymbol* _tmp152_;
		ValaSymbol* _tmp153_;
		gboolean _tmp167_ = FALSE;
		gboolean _tmp168_ = FALSE;
		gboolean _tmp169_ = FALSE;
		ValaMemberBinding _tmp170_;
		gboolean _tmp181_;
		gboolean _tmp182_;
		_tmp63_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp66_ = _tmp65_;
		vala_expression_set_target_type (_tmp64_, _tmp66_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp68_ = _tmp67_;
		if (VALA_IS_INITIALIZER_LIST (_tmp68_)) {
			ValaExpression* _tmp69_;
			ValaExpression* _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			_tmp69_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp72_ = _tmp71_;
			initializer_size = _tmp72_;
			is_initializer_list = TRUE;
		}
		_tmp73_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp74_ = _tmp73_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp74_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp75_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_expression_get_value_type (_tmp76_);
		_tmp78_ = _tmp77_;
		if (_tmp78_ == NULL) {
			ValaSourceReference* _tmp79_;
			ValaSourceReference* _tmp80_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp80_ = _tmp79_;
			vala_report_error (_tmp80_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp81_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_expression_get_value_type (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp86_ = _tmp85_;
		if (!vala_data_type_compatible (_tmp84_, _tmp86_)) {
			ValaSourceReference* _tmp87_;
			ValaSourceReference* _tmp88_;
			ValaExpression* _tmp89_;
			ValaExpression* _tmp90_;
			ValaDataType* _tmp91_;
			ValaDataType* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			ValaDataType* _tmp95_;
			ValaDataType* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp90_ = _tmp89_;
			_tmp91_ = vala_expression_get_value_type (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_code_node_to_string ((ValaCodeNode*) _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_code_node_to_string ((ValaCodeNode*) _tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp94_, _tmp98_);
			_tmp100_ = _tmp99_;
			vala_report_error (_tmp88_, _tmp100_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp98_);
			_g_free0 (_tmp94_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp104_ = variable_array_type;
		if (_tmp104_ != NULL) {
			ValaArrayType* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp105_ = variable_array_type;
			_tmp106_ = vala_array_type_get_inline_allocated (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp103_ = _tmp107_;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaArrayType* _tmp108_;
			gboolean _tmp109_;
			gboolean _tmp110_;
			_tmp108_ = variable_array_type;
			_tmp109_ = vala_array_type_get_fixed_length (_tmp108_);
			_tmp110_ = _tmp109_;
			_tmp102_ = !_tmp110_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			_tmp101_ = is_initializer_list;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			ValaArrayType* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			ValaIntegerLiteral* _tmp114_;
			ValaIntegerLiteral* _tmp115_;
			ValaArrayType* _tmp116_;
			ValaArrayType* _tmp117_;
			_tmp111_ = variable_array_type;
			_tmp112_ = g_strdup_printf ("%i", initializer_size);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_integer_literal_new (_tmp113_, NULL);
			_tmp115_ = _tmp114_;
			vala_array_type_set_length (_tmp111_, (ValaExpression*) _tmp115_);
			_vala_code_node_unref0 (_tmp115_);
			_g_free0 (_tmp113_);
			_tmp116_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp116_, TRUE);
			_tmp117_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp117_, FALSE);
		}
		_tmp120_ = variable_array_type;
		if (_tmp120_ != NULL) {
			ValaArrayType* _tmp121_;
			gboolean _tmp122_;
			gboolean _tmp123_;
			_tmp121_ = variable_array_type;
			_tmp122_ = vala_array_type_get_inline_allocated (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp119_ = _tmp123_;
		} else {
			_tmp119_ = FALSE;
		}
		if (_tmp119_) {
			ValaExpression* _tmp124_;
			ValaExpression* _tmp125_;
			ValaDataType* _tmp126_;
			ValaDataType* _tmp127_;
			_tmp124_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_expression_get_value_type (_tmp125_);
			_tmp127_ = _tmp126_;
			_tmp118_ = !VALA_IS_ARRAY_TYPE (_tmp127_);
		} else {
			_tmp118_ = FALSE;
		}
		if (_tmp118_) {
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			vala_report_error (_tmp129_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp130_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_expression_get_value_type (_tmp131_);
		_tmp133_ = _tmp132_;
		if (vala_data_type_is_disposable (_tmp133_)) {
			gboolean _tmp134_ = FALSE;
			ValaDataType* _tmp135_;
			ValaDataType* _tmp136_;
			_tmp135_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp136_ = _tmp135_;
			if (!VALA_IS_POINTER_TYPE (_tmp136_)) {
				ValaDataType* _tmp137_;
				ValaDataType* _tmp138_;
				gboolean _tmp139_;
				gboolean _tmp140_;
				_tmp137_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp138_ = _tmp137_;
				_tmp139_ = vala_data_type_get_value_owned (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp134_ = !_tmp140_;
			} else {
				_tmp134_ = FALSE;
			}
			if (_tmp134_) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				vala_report_error (_tmp142_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp144_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp145_ = _tmp144_;
		if (VALA_IS_NAMESPACE (_tmp145_)) {
			ValaExpression* _tmp146_;
			ValaExpression* _tmp147_;
			_tmp146_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp147_ = _tmp146_;
			_tmp143_ = !vala_expression_is_constant (_tmp147_);
		} else {
			_tmp143_ = FALSE;
		}
		if (_tmp143_) {
			ValaSourceReference* _tmp148_;
			ValaSourceReference* _tmp149_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp149_ = _tmp148_;
			vala_report_error (_tmp149_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp152_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp153_ = _tmp152_;
		if (VALA_IS_NAMESPACE (_tmp153_)) {
			ValaExpression* _tmp154_;
			ValaExpression* _tmp155_;
			_tmp154_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp155_ = _tmp154_;
			_tmp151_ = vala_expression_is_constant (_tmp155_);
		} else {
			_tmp151_ = FALSE;
		}
		if (_tmp151_) {
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			_tmp156_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp157_ = _tmp156_;
			_tmp150_ = vala_expression_is_non_null (_tmp157_);
		} else {
			_tmp150_ = FALSE;
		}
		if (_tmp150_) {
			gboolean _tmp158_ = FALSE;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			_tmp159_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp160_ = _tmp159_;
			if (vala_data_type_is_disposable (_tmp160_)) {
				ValaDataType* _tmp161_;
				ValaDataType* _tmp162_;
				gboolean _tmp163_;
				gboolean _tmp164_;
				_tmp161_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp162_ = _tmp161_;
				_tmp163_ = vala_data_type_get_value_owned (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp158_ = _tmp164_;
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp166_ = _tmp165_;
				vala_report_error (_tmp166_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp170_ = self->priv->_binding;
		if (_tmp170_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp171_;
			ValaSymbol* _tmp172_;
			_tmp171_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp172_ = _tmp171_;
			_tmp169_ = VALA_IS_CLASS (_tmp172_);
		} else {
			_tmp169_ = FALSE;
		}
		if (_tmp169_) {
			ValaSymbol* _tmp173_;
			ValaSymbol* _tmp174_;
			gboolean _tmp175_;
			gboolean _tmp176_;
			_tmp173_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp174_, VALA_TYPE_CLASS, ValaClass));
			_tmp176_ = _tmp175_;
			_tmp168_ = _tmp176_;
		} else {
			_tmp168_ = FALSE;
		}
		if (_tmp168_) {
			ValaExpression* _tmp177_;
			ValaExpression* _tmp178_;
			_tmp177_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp178_ = _tmp177_;
			_tmp167_ = !vala_expression_is_constant (_tmp178_);
		} else {
			_tmp167_ = FALSE;
		}
		if (_tmp167_) {
			ValaSourceReference* _tmp179_;
			ValaSourceReference* _tmp180_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp180_ = _tmp179_;
			vala_report_error (_tmp180_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp181_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp182_ = _tmp181_;
		if (_tmp182_) {
			ValaSourceReference* _tmp183_;
			ValaSourceReference* _tmp184_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp184_ = _tmp183_;
			vala_report_error (_tmp184_, "External fields cannot use initializers");
		}
	}
	_tmp186_ = self->priv->_binding;
	if (_tmp186_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp187_;
		ValaSymbol* _tmp188_;
		_tmp187_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp188_ = _tmp187_;
		_tmp185_ = VALA_IS_INTERFACE (_tmp188_);
	} else {
		_tmp185_ = FALSE;
	}
	if (_tmp185_) {
		ValaSourceReference* _tmp189_;
		ValaSourceReference* _tmp190_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp190_ = _tmp189_;
		vala_report_error (_tmp190_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp191_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp192_ = _tmp191_;
	if (VALA_IS_CLASS (_tmp192_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp193_;
		ValaSymbol* _tmp194_;
		ValaClass* _tmp195_;
		gboolean _tmp196_ = FALSE;
		ValaClass* _tmp197_;
		gboolean _tmp198_;
		gboolean _tmp199_;
		_tmp193_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp194_ = _tmp193_;
		_tmp195_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp194_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp195_;
		_tmp197_ = cl;
		_tmp198_ = vala_class_get_is_compact (_tmp197_);
		_tmp199_ = _tmp198_;
		if (_tmp199_) {
			ValaClass* _tmp200_;
			_tmp200_ = cl;
			_tmp196_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp200_);
		} else {
			_tmp196_ = FALSE;
		}
		if (_tmp196_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp203_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp204_ = _tmp203_;
	if (!_tmp204_) {
		gboolean _tmp205_;
		gboolean _tmp206_;
		_tmp205_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp206_ = _tmp205_;
		_tmp202_ = !_tmp206_;
	} else {
		_tmp202_ = FALSE;
	}
	if (_tmp202_) {
		ValaSymbol* _tmp207_;
		ValaSymbol* _tmp208_;
		_tmp207_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp208_ = _tmp207_;
		_tmp201_ = _tmp208_ != NULL;
		_vala_code_node_unref0 (_tmp208_);
	} else {
		_tmp201_ = FALSE;
	}
	if (_tmp201_) {
		ValaSourceReference* _tmp209_;
		ValaSourceReference* _tmp210_;
		gchar* _tmp211_;
		gchar* _tmp212_;
		ValaSymbol* _tmp213_;
		ValaSymbol* _tmp214_;
		gchar* _tmp215_;
		gchar* _tmp216_;
		gchar* _tmp217_;
		gchar* _tmp218_;
		_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp210_ = _tmp209_;
		_tmp211_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp212_ = _tmp211_;
		_tmp213_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp214_ = _tmp213_;
		_tmp215_ = vala_symbol_get_full_name (_tmp214_);
		_tmp216_ = _tmp215_;
		_tmp217_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp212_, _tmp216_);
		_tmp218_ = _tmp217_;
		vala_report_warning (_tmp210_, _tmp218_);
		_g_free0 (_tmp218_);
		_g_free0 (_tmp216_);
		_vala_code_node_unref0 (_tmp214_);
		_g_free0 (_tmp212_);
	}
	_tmp219_ = vala_code_context_get_analyzer (context);
	_tmp220_ = _tmp219_;
	_tmp221_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp220_, _tmp221_);
	_tmp222_ = vala_code_context_get_analyzer (context);
	_tmp223_ = _tmp222_;
	_tmp224_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp223_, _tmp224_);
	_tmp225_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp226_ = _tmp225_;
	result = !_tmp226_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

