/* valareferencetransferexpression.c generated by valac, the Vala compiler
 * generated from valareferencetransferexpression.vala, do not modify */

/* valareferencetransferexpression.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaReferenceTransferExpressionPrivate {
	ValaExpression* _inner;
};

static gint ValaReferenceTransferExpression_private_offset;
static gpointer vala_reference_transfer_expression_parent_class = NULL;

static void vala_reference_transfer_expression_real_accept (ValaCodeNode* base,
                                                     ValaCodeVisitor* visitor);
static void vala_reference_transfer_expression_real_accept_children (ValaCodeNode* base,
                                                              ValaCodeVisitor* visitor);
static void vala_reference_transfer_expression_real_replace_expression (ValaCodeNode* base,
                                                                 ValaExpression* old_node,
                                                                 ValaExpression* new_node);
static gboolean vala_reference_transfer_expression_real_is_pure (ValaExpression* base);
static gboolean vala_reference_transfer_expression_real_is_accessible (ValaExpression* base,
                                                                ValaSymbol* sym);
static gboolean vala_reference_transfer_expression_real_check (ValaCodeNode* base,
                                                        ValaCodeContext* context);
static void vala_reference_transfer_expression_real_emit (ValaCodeNode* base,
                                                   ValaCodeGenerator* codegen);
static void vala_reference_transfer_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                    ValaCollection* collection);
static void vala_reference_transfer_expression_real_get_used_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static gchar* vala_reference_transfer_expression_real_to_string (ValaCodeNode* base);
static void vala_reference_transfer_expression_finalize (ValaCodeNode * obj);

static inline gpointer
vala_reference_transfer_expression_get_instance_private (ValaReferenceTransferExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaReferenceTransferExpression_private_offset);
}

/**
 * Creates a new reference transfer expression.
 *
 * @param inner variable whose reference is to be transferred
 * @return      newly created reference transfer expression
 */
ValaReferenceTransferExpression*
vala_reference_transfer_expression_construct (GType object_type,
                                              ValaExpression* inner,
                                              ValaSourceReference* source_reference)
{
	ValaReferenceTransferExpression* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	self = (ValaReferenceTransferExpression*) vala_expression_construct (object_type);
	vala_reference_transfer_expression_set_inner (self, inner);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaReferenceTransferExpression*
vala_reference_transfer_expression_new (ValaExpression* inner,
                                        ValaSourceReference* source_reference)
{
	return vala_reference_transfer_expression_construct (VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, inner, source_reference);
}

static void
vala_reference_transfer_expression_real_accept (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor)
{
	ValaReferenceTransferExpression * self;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_reference_transfer_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_reference_transfer_expression_real_accept_children (ValaCodeNode* base,
                                                         ValaCodeVisitor* visitor)
{
	ValaReferenceTransferExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_reference_transfer_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}

static void
vala_reference_transfer_expression_real_replace_expression (ValaCodeNode* base,
                                                            ValaExpression* old_node,
                                                            ValaExpression* new_node)
{
	ValaReferenceTransferExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_reference_transfer_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_reference_transfer_expression_set_inner (self, new_node);
	}
}

static gboolean
vala_reference_transfer_expression_real_is_pure (ValaExpression* base)
{
	ValaReferenceTransferExpression * self;
	gboolean result = FALSE;
	self = (ValaReferenceTransferExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_reference_transfer_expression_real_is_accessible (ValaExpression* base,
                                                       ValaSymbol* sym)
{
	ValaReferenceTransferExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result = FALSE;
	self = (ValaReferenceTransferExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_reference_transfer_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}

static gboolean
vala_reference_transfer_expression_real_check (ValaCodeNode* base,
                                               ValaCodeContext* context)
{
	ValaReferenceTransferExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_ = FALSE;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	gboolean _tmp19_ = FALSE;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gboolean is_owned_delegate = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	ValaExpression* _tmp32_;
	ValaExpression* _tmp33_;
	ValaDataType* _tmp34_;
	ValaDataType* _tmp35_;
	ValaExpression* _tmp42_;
	ValaExpression* _tmp43_;
	ValaDataType* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaDataType* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	gboolean result = FALSE;
	self = (ValaReferenceTransferExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_reference_transfer_expression_get_inner (self);
	_tmp5_ = _tmp4_;
	vala_expression_set_lvalue (_tmp5_, TRUE);
	_tmp6_ = vala_reference_transfer_expression_get_inner (self);
	_tmp7_ = _tmp6_;
	vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	_tmp8_ = vala_reference_transfer_expression_get_inner (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_code_node_get_error ((ValaCodeNode*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp13_ = vala_reference_transfer_expression_get_inner (self);
	_tmp14_ = _tmp13_;
	if (VALA_IS_MEMBER_ACCESS (_tmp14_)) {
		_tmp12_ = TRUE;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_reference_transfer_expression_get_inner (self);
		_tmp16_ = _tmp15_;
		_tmp12_ = VALA_IS_ELEMENT_ACCESS (_tmp16_);
	}
	if (!_tmp12_) {
		ValaSourceReference* _tmp17_;
		ValaSourceReference* _tmp18_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp18_ = _tmp17_;
		vala_report_error (_tmp18_, "Reference transfer not supported for this expression");
		result = FALSE;
		return result;
	}
	_tmp20_ = vala_reference_transfer_expression_get_inner (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_expression_get_value_type (_tmp21_);
	_tmp23_ = _tmp22_;
	if (VALA_IS_DELEGATE_TYPE (_tmp23_)) {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp24_ = vala_reference_transfer_expression_get_inner (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_expression_get_value_type (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_data_type_get_value_owned (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp19_ = _tmp29_;
	} else {
		_tmp19_ = FALSE;
	}
	is_owned_delegate = _tmp19_;
	_tmp32_ = vala_reference_transfer_expression_get_inner (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_expression_get_value_type (_tmp33_);
	_tmp35_ = _tmp34_;
	if (!vala_data_type_is_disposable (_tmp35_)) {
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		_tmp36_ = vala_reference_transfer_expression_get_inner (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_expression_get_value_type (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp31_ = !VALA_IS_POINTER_TYPE (_tmp39_);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		_tmp30_ = !is_owned_delegate;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		vala_report_error (_tmp41_, "No reference to be transferred");
		result = FALSE;
		return result;
	}
	_tmp42_ = vala_reference_transfer_expression_get_inner (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_expression_get_value_type (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_data_type_copy (_tmp45_);
	_tmp47_ = _tmp46_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp47_);
	_vala_code_node_unref0 (_tmp47_);
	_tmp48_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp49_ = _tmp48_;
	vala_data_type_set_value_owned (_tmp49_, TRUE);
	_tmp50_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp51_ = _tmp50_;
	vala_code_node_check ((ValaCodeNode*) _tmp51_, context);
	_tmp52_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp53_ = _tmp52_;
	result = !_tmp53_;
	return result;
}

static void
vala_reference_transfer_expression_real_emit (ValaCodeNode* base,
                                              ValaCodeGenerator* codegen)
{
	ValaReferenceTransferExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_reference_transfer_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_reference_transfer_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_reference_transfer_expression_real_get_defined_variables (ValaCodeNode* base,
                                                               ValaCollection* collection)
{
	ValaReferenceTransferExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaParameter* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_reference_transfer_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_reference_transfer_expression_get_inner (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_symbol_reference (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_reference_transfer_expression_get_inner (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_symbol_reference (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp10_) ? ((ValaParameter*) _tmp10_) : NULL);
	param = _tmp11_;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

static void
vala_reference_transfer_expression_real_get_used_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaReferenceTransferExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaParameter* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_reference_transfer_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_reference_transfer_expression_get_inner (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_symbol_reference (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_reference_transfer_expression_get_inner (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_symbol_reference (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp10_) ? ((ValaParameter*) _tmp10_) : NULL);
	param = _tmp11_;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

static gchar*
vala_reference_transfer_expression_real_to_string (ValaCodeNode* base)
{
	ValaReferenceTransferExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result = NULL;
	self = (ValaReferenceTransferExpression*) base;
	_tmp0_ = vala_reference_transfer_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("(owned) %s", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

ValaExpression*
vala_reference_transfer_expression_get_inner (ValaReferenceTransferExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_reference_transfer_expression_set_inner (ValaReferenceTransferExpression* self,
                                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static void
vala_reference_transfer_expression_class_init (ValaReferenceTransferExpressionClass * klass,
                                               gpointer klass_data)
{
	vala_reference_transfer_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_reference_transfer_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaReferenceTransferExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_reference_transfer_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_reference_transfer_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_reference_transfer_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_reference_transfer_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_reference_transfer_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_reference_transfer_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_reference_transfer_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_reference_transfer_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_reference_transfer_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_reference_transfer_expression_real_to_string;
}

static void
vala_reference_transfer_expression_instance_init (ValaReferenceTransferExpression * self,
                                                  gpointer klass)
{
	self->priv = vala_reference_transfer_expression_get_instance_private (self);
}

static void
vala_reference_transfer_expression_finalize (ValaCodeNode * obj)
{
	ValaReferenceTransferExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	VALA_CODE_NODE_CLASS (vala_reference_transfer_expression_parent_class)->finalize (obj);
}

/**
 * Represents a reference transfer expression.
 *
 * {{{ (owned) foo }}}
 */
GType
vala_reference_transfer_expression_get_type (void)
{
	static volatile gsize vala_reference_transfer_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_reference_transfer_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReferenceTransferExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_reference_transfer_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReferenceTransferExpression), 0, (GInstanceInitFunc) vala_reference_transfer_expression_instance_init, NULL };
		GType vala_reference_transfer_expression_type_id;
		vala_reference_transfer_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaReferenceTransferExpression", &g_define_type_info, 0);
		ValaReferenceTransferExpression_private_offset = g_type_add_instance_private (vala_reference_transfer_expression_type_id, sizeof (ValaReferenceTransferExpressionPrivate));
		g_once_init_leave (&vala_reference_transfer_expression_type_id__volatile, vala_reference_transfer_expression_type_id);
	}
	return vala_reference_transfer_expression_type_id__volatile;
}

