/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp595_ = FALSE;
	gboolean _tmp596_ = FALSE;
	gboolean _tmp597_ = FALSE;
	ValaExpression* _tmp598_;
	ValaExpression* _tmp599_;
	ValaSymbol* _tmp625_;
	ValaSymbol* _tmp626_;
	ValaSymbol* _tmp655_;
	ValaSymbol* _tmp656_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp695_;
	ValaSymbol* _tmp696_;
	ValaSymbol* _tmp697_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp698_;
	ValaSymbol* _tmp699_;
	ValaSymbol* _tmp1121_;
	ValaSymbol* _tmp1122_;
	ValaVersionAttribute* _tmp1123_;
	ValaVersionAttribute* _tmp1124_;
	ValaSourceReference* _tmp1125_;
	ValaSourceReference* _tmp1126_;
	gboolean _tmp1127_ = FALSE;
	ValaSymbolAccessibility _tmp1128_;
	gboolean _tmp1187_ = FALSE;
	gboolean _tmp1218_ = FALSE;
	gboolean _tmp1219_ = FALSE;
	ValaDataType* _tmp1499_;
	ValaDataType* _tmp1500_;
	gboolean _tmp1503_;
	gboolean _tmp1504_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (VALA_IS_PROPERTY (_tmp54_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp67_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp77_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (VALA_IS_METHOD (_tmp87_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = VALA_IS_TYPESYMBOL (_tmp108_);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp147_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaUsingDirective* _tmp167_;
						gboolean _tmp168_;
						gboolean _tmp169_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						ValaScope* _tmp173_;
						ValaScope* _tmp174_;
						const gchar* _tmp175_;
						ValaSymbol* _tmp176_;
						ValaSymbol* _tmp177_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_code_node_get_error ((ValaCodeNode*) _tmp167_);
						_tmp169_ = _tmp168_;
						if (_tmp169_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp170_ = ns;
						_tmp171_ = vala_using_directive_get_namespace_symbol (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = vala_symbol_get_scope (_tmp172_);
						_tmp174_ = _tmp173_;
						_tmp175_ = self->priv->_member_name;
						_tmp176_ = vala_scope_lookup (_tmp174_, _tmp175_);
						local_sym = _tmp176_;
						_tmp177_ = local_sym;
						if (_tmp177_ != NULL) {
							gboolean _tmp178_ = FALSE;
							ValaSymbol* _tmp179_;
							ValaSymbol* _tmp180_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp196_;
							ValaSymbol* _tmp197_;
							ValaSymbol* _tmp198_;
							ValaMemberAccess* inner_ma = NULL;
							ValaExpression* _tmp218_;
							ValaExpression* _tmp219_;
							ValaSymbol* _tmp220_;
							_tmp179_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp180_ = _tmp179_;
							if (_tmp180_ != NULL) {
								ValaSymbol* _tmp181_;
								ValaSymbol* _tmp182_;
								ValaSymbol* _tmp183_;
								_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = local_sym;
								_tmp178_ = _tmp182_ != _tmp183_;
							} else {
								_tmp178_ = FALSE;
							}
							if (_tmp178_) {
								ValaSourceReference* _tmp184_;
								ValaSourceReference* _tmp185_;
								const gchar* _tmp186_;
								ValaSymbol* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								ValaSymbol* _tmp191_;
								gchar* _tmp192_;
								gchar* _tmp193_;
								gchar* _tmp194_;
								gchar* _tmp195_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = self->priv->_member_name;
								_tmp187_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp188_ = _tmp187_;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = local_sym;
								_tmp192_ = vala_symbol_get_full_name (_tmp191_);
								_tmp193_ = _tmp192_;
								_tmp194_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp186_, _tmp190_, _tmp193_);
								_tmp195_ = _tmp194_;
								vala_report_error (_tmp185_, _tmp195_);
								_g_free0 (_tmp195_);
								_g_free0 (_tmp193_);
								_g_free0 (_tmp190_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp196_ = local_sym;
							_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
							_tmp198_ = _tmp197_;
							inner_sym = _tmp198_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp199_ = FALSE;
								ValaSymbol* _tmp200_;
								ValaMemberAccess* _tmp204_;
								ValaSymbol* _tmp205_;
								const gchar* _tmp206_;
								const gchar* _tmp207_;
								ValaSourceReference* _tmp208_;
								ValaSourceReference* _tmp209_;
								ValaMemberAccess* _tmp210_;
								ValaMemberAccess* _tmp211_;
								ValaMemberAccess* _tmp212_;
								ValaExpression* _tmp213_;
								ValaExpression* _tmp214_;
								ValaSymbol* _tmp215_;
								ValaSymbol* _tmp216_;
								ValaSymbol* _tmp217_;
								_tmp200_ = inner_sym;
								if (_tmp200_ != NULL) {
									ValaSymbol* _tmp201_;
									const gchar* _tmp202_;
									const gchar* _tmp203_;
									_tmp201_ = inner_sym;
									_tmp202_ = vala_symbol_get_name (_tmp201_);
									_tmp203_ = _tmp202_;
									_tmp199_ = _tmp203_ != NULL;
								} else {
									_tmp199_ = FALSE;
								}
								if (!_tmp199_) {
									break;
								}
								_tmp204_ = inner_ma;
								_tmp205_ = inner_sym;
								_tmp206_ = vala_symbol_get_name (_tmp205_);
								_tmp207_ = _tmp206_;
								_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp209_ = _tmp208_;
								_tmp210_ = vala_member_access_new (NULL, _tmp207_, _tmp209_);
								_tmp211_ = _tmp210_;
								vala_member_access_set_inner (_tmp204_, (ValaExpression*) _tmp211_);
								_vala_code_node_unref0 (_tmp211_);
								_tmp212_ = inner_ma;
								_tmp213_ = vala_member_access_get_inner (_tmp212_);
								_tmp214_ = _tmp213_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp214_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp215_ = inner_sym;
								_tmp216_ = vala_symbol_get_parent_symbol (_tmp215_);
								_tmp217_ = _tmp216_;
								inner_sym = _tmp217_;
							}
							_tmp218_ = vala_member_access_get_inner (self);
							_tmp219_ = _tmp218_;
							vala_code_node_check ((ValaCodeNode*) _tmp219_, context);
							_tmp220_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp220_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp221_;
			ValaExpression* _tmp222_;
			gboolean _tmp223_;
			gboolean _tmp224_;
			ValaExpression* _tmp225_;
			ValaExpression* _tmp226_;
			ValaDataType* _tmp227_;
			ValaDataType* _tmp228_;
			ValaExpression* _tmp247_;
			ValaExpression* _tmp248_;
			gboolean _tmp264_ = FALSE;
			ValaExpression* _tmp265_;
			ValaExpression* _tmp266_;
			gboolean _tmp288_ = FALSE;
			ValaSymbol* _tmp289_;
			ValaSymbol* _tmp290_;
			gboolean _tmp325_ = FALSE;
			gboolean _tmp326_ = FALSE;
			ValaSymbol* _tmp327_;
			ValaSymbol* _tmp328_;
			gboolean _tmp566_ = FALSE;
			ValaSymbol* _tmp567_;
			ValaSymbol* _tmp568_;
			_tmp221_ = vala_member_access_get_inner (self);
			_tmp222_ = _tmp221_;
			_tmp223_ = vala_code_node_get_error ((ValaCodeNode*) _tmp222_);
			_tmp224_ = _tmp223_;
			if (_tmp224_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp225_ = vala_member_access_get_inner (self);
			_tmp226_ = _tmp225_;
			_tmp227_ = vala_expression_get_value_type (_tmp226_);
			_tmp228_ = _tmp227_;
			if (VALA_IS_POINTER_TYPE (_tmp228_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp229_;
				ValaExpression* _tmp230_;
				ValaDataType* _tmp231_;
				ValaDataType* _tmp232_;
				ValaPointerType* _tmp233_;
				gboolean _tmp234_ = FALSE;
				ValaPointerType* _tmp235_;
				_tmp229_ = vala_member_access_get_inner (self);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_expression_get_value_type (_tmp230_);
				_tmp232_ = _tmp231_;
				_tmp233_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp232_) ? ((ValaPointerType*) _tmp232_) : NULL);
				pointer_type = _tmp233_;
				_tmp235_ = pointer_type;
				if (_tmp235_ != NULL) {
					ValaPointerType* _tmp236_;
					ValaDataType* _tmp237_;
					ValaDataType* _tmp238_;
					_tmp236_ = pointer_type;
					_tmp237_ = vala_pointer_type_get_base_type (_tmp236_);
					_tmp238_ = _tmp237_;
					_tmp234_ = VALA_IS_VALUE_TYPE (_tmp238_);
				} else {
					_tmp234_ = FALSE;
				}
				if (_tmp234_) {
					ValaExpression* _tmp239_;
					ValaExpression* _tmp240_;
					ValaSourceReference* _tmp241_;
					ValaSourceReference* _tmp242_;
					ValaPointerIndirection* _tmp243_;
					ValaPointerIndirection* _tmp244_;
					ValaExpression* _tmp245_;
					ValaExpression* _tmp246_;
					_tmp239_ = vala_member_access_get_inner (self);
					_tmp240_ = _tmp239_;
					_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_pointer_indirection_new (_tmp240_, _tmp242_);
					_tmp244_ = _tmp243_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp244_);
					_vala_code_node_unref0 (_tmp244_);
					_tmp245_ = vala_member_access_get_inner (self);
					_tmp246_ = _tmp245_;
					vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp247_ = vala_member_access_get_inner (self);
			_tmp248_ = _tmp247_;
			if (VALA_IS_MEMBER_ACCESS (_tmp248_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp249_;
				ValaExpression* _tmp250_;
				ValaMemberAccess* _tmp251_;
				ValaMemberAccess* _tmp252_;
				gboolean _tmp253_;
				_tmp249_ = vala_member_access_get_inner (self);
				_tmp250_ = _tmp249_;
				_tmp251_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp250_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp251_;
				_tmp252_ = ma;
				_tmp253_ = _tmp252_->priv->_prototype_access;
				if (_tmp253_) {
					ValaSourceReference* _tmp254_;
					ValaSourceReference* _tmp255_;
					ValaExpression* _tmp256_;
					ValaExpression* _tmp257_;
					ValaSymbol* _tmp258_;
					ValaSymbol* _tmp259_;
					gchar* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					gchar* _tmp263_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp255_ = _tmp254_;
					_tmp256_ = vala_member_access_get_inner (self);
					_tmp257_ = _tmp256_;
					_tmp258_ = vala_expression_get_symbol_reference (_tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = vala_symbol_get_full_name (_tmp259_);
					_tmp261_ = _tmp260_;
					_tmp262_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp261_);
					_tmp263_ = _tmp262_;
					vala_report_error (_tmp255_, _tmp263_);
					_g_free0 (_tmp263_);
					_g_free0 (_tmp261_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp265_ = vala_member_access_get_inner (self);
			_tmp266_ = _tmp265_;
			if (VALA_IS_MEMBER_ACCESS (_tmp266_)) {
				_tmp264_ = TRUE;
			} else {
				ValaExpression* _tmp267_;
				ValaExpression* _tmp268_;
				_tmp267_ = vala_member_access_get_inner (self);
				_tmp268_ = _tmp267_;
				_tmp264_ = VALA_IS_BASE_ACCESS (_tmp268_);
			}
			if (_tmp264_) {
				ValaExpression* _tmp269_;
				ValaExpression* _tmp270_;
				ValaSymbol* _tmp271_;
				ValaSymbol* _tmp272_;
				ValaSymbol* _tmp273_;
				gboolean _tmp274_ = FALSE;
				ValaSymbol* _tmp275_;
				ValaSymbol* _tmp276_;
				_tmp269_ = vala_member_access_get_inner (self);
				_tmp270_ = _tmp269_;
				_tmp271_ = vala_expression_get_symbol_reference (_tmp270_);
				_tmp272_ = _tmp271_;
				_tmp273_ = _vala_code_node_ref0 (_tmp272_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp273_;
				_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp276_ = _tmp275_;
				if (_tmp276_ == NULL) {
					gboolean _tmp277_ = FALSE;
					ValaSymbol* _tmp278_;
					_tmp278_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp278_)) {
						_tmp277_ = TRUE;
					} else {
						ValaSymbol* _tmp279_;
						_tmp279_ = base_symbol;
						_tmp277_ = VALA_IS_TYPESYMBOL (_tmp279_);
					}
					_tmp274_ = _tmp277_;
				} else {
					_tmp274_ = FALSE;
				}
				if (_tmp274_) {
					ValaSymbol* _tmp280_;
					ValaScope* _tmp281_;
					ValaScope* _tmp282_;
					const gchar* _tmp283_;
					ValaSymbol* _tmp284_;
					ValaSymbol* _tmp285_;
					ValaExpression* _tmp286_;
					ValaExpression* _tmp287_;
					_tmp280_ = base_symbol;
					_tmp281_ = vala_symbol_get_scope (_tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = self->priv->_member_name;
					_tmp284_ = vala_scope_lookup (_tmp282_, _tmp283_);
					_tmp285_ = _tmp284_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp285_);
					_vala_code_node_unref0 (_tmp285_);
					_tmp286_ = vala_member_access_get_inner (self);
					_tmp287_ = _tmp286_;
					if (VALA_IS_BASE_ACCESS (_tmp287_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp289_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp290_ = _tmp289_;
			if (_tmp290_ == NULL) {
				ValaExpression* _tmp291_;
				ValaExpression* _tmp292_;
				ValaDataType* _tmp293_;
				ValaDataType* _tmp294_;
				_tmp291_ = vala_member_access_get_inner (self);
				_tmp292_ = _tmp291_;
				_tmp293_ = vala_expression_get_value_type (_tmp292_);
				_tmp294_ = _tmp293_;
				_tmp288_ = _tmp294_ != NULL;
			} else {
				_tmp288_ = FALSE;
			}
			if (_tmp288_) {
				gboolean _tmp295_;
				ValaSymbol* _tmp323_;
				ValaSymbol* _tmp324_;
				_tmp295_ = self->priv->_pointer_member_access;
				if (_tmp295_) {
					ValaExpression* _tmp296_;
					ValaExpression* _tmp297_;
					ValaDataType* _tmp298_;
					ValaDataType* _tmp299_;
					const gchar* _tmp300_;
					ValaSymbol* _tmp301_;
					ValaSymbol* _tmp302_;
					_tmp296_ = vala_member_access_get_inner (self);
					_tmp297_ = _tmp296_;
					_tmp298_ = vala_expression_get_value_type (_tmp297_);
					_tmp299_ = _tmp298_;
					_tmp300_ = self->priv->_member_name;
					_tmp301_ = vala_data_type_get_pointer_member (_tmp299_, _tmp300_);
					_tmp302_ = _tmp301_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp302_);
					_vala_code_node_unref0 (_tmp302_);
				} else {
					ValaExpression* _tmp303_;
					ValaExpression* _tmp304_;
					ValaDataType* _tmp305_;
					ValaDataType* _tmp306_;
					ValaTypeSymbol* _tmp307_;
					ValaTypeSymbol* _tmp308_;
					ValaExpression* _tmp316_;
					ValaExpression* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					const gchar* _tmp320_;
					ValaSymbol* _tmp321_;
					ValaSymbol* _tmp322_;
					_tmp303_ = vala_member_access_get_inner (self);
					_tmp304_ = _tmp303_;
					_tmp305_ = vala_expression_get_value_type (_tmp304_);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_data_type_get_data_type (_tmp306_);
					_tmp308_ = _tmp307_;
					if (_tmp308_ != NULL) {
						ValaExpression* _tmp309_;
						ValaExpression* _tmp310_;
						ValaDataType* _tmp311_;
						ValaDataType* _tmp312_;
						ValaTypeSymbol* _tmp313_;
						ValaTypeSymbol* _tmp314_;
						ValaSymbol* _tmp315_;
						_tmp309_ = vala_member_access_get_inner (self);
						_tmp310_ = _tmp309_;
						_tmp311_ = vala_expression_get_value_type (_tmp310_);
						_tmp312_ = _tmp311_;
						_tmp313_ = vala_data_type_get_data_type (_tmp312_);
						_tmp314_ = _tmp313_;
						_tmp315_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp314_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp315_;
					}
					_tmp316_ = vala_member_access_get_inner (self);
					_tmp317_ = _tmp316_;
					_tmp318_ = vala_expression_get_value_type (_tmp317_);
					_tmp319_ = _tmp318_;
					_tmp320_ = self->priv->_member_name;
					_tmp321_ = vala_data_type_get_member (_tmp319_, _tmp320_);
					_tmp322_ = _tmp321_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp322_);
					_vala_code_node_unref0 (_tmp322_);
				}
				_tmp323_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp324_ = _tmp323_;
				if (_tmp324_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp327_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp328_ = _tmp327_;
			if (_tmp328_ == NULL) {
				ValaExpression* _tmp329_;
				ValaExpression* _tmp330_;
				ValaDataType* _tmp331_;
				ValaDataType* _tmp332_;
				_tmp329_ = vala_member_access_get_inner (self);
				_tmp330_ = _tmp329_;
				_tmp331_ = vala_expression_get_value_type (_tmp330_);
				_tmp332_ = _tmp331_;
				_tmp326_ = _tmp332_ != NULL;
			} else {
				_tmp326_ = FALSE;
			}
			if (_tmp326_) {
				ValaExpression* _tmp333_;
				ValaExpression* _tmp334_;
				ValaDataType* _tmp335_;
				ValaDataType* _tmp336_;
				gboolean _tmp337_;
				gboolean _tmp338_;
				_tmp333_ = vala_member_access_get_inner (self);
				_tmp334_ = _tmp333_;
				_tmp335_ = vala_expression_get_value_type (_tmp334_);
				_tmp336_ = _tmp335_;
				_tmp337_ = vala_data_type_get_is_dynamic (_tmp336_);
				_tmp338_ = _tmp337_;
				_tmp325_ = _tmp338_;
			} else {
				_tmp325_ = FALSE;
			}
			if (_tmp325_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp339_;
				ValaExpression* _tmp340_;
				ValaDataType* _tmp341_;
				ValaDataType* _tmp342_;
				ValaObjectType* _tmp343_;
				ValaCodeNode* _tmp344_;
				ValaCodeNode* _tmp345_;
				ValaSymbol* _tmp514_;
				ValaSymbol* _tmp515_;
				ValaSymbol* _tmp564_;
				ValaSymbol* _tmp565_;
				_tmp339_ = vala_member_access_get_inner (self);
				_tmp340_ = _tmp339_;
				_tmp341_ = vala_expression_get_value_type (_tmp340_);
				_tmp342_ = _tmp341_;
				_tmp343_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp342_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp343_;
				_tmp344_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp345_ = _tmp344_;
				if (VALA_IS_METHOD_CALL (_tmp345_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp346_;
					ValaCodeNode* _tmp347_;
					ValaMethodCall* _tmp348_;
					ValaMethodCall* _tmp349_;
					ValaExpression* _tmp350_;
					ValaExpression* _tmp351_;
					_tmp346_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp347_ = _tmp346_;
					_tmp348_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp347_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp348_;
					_tmp349_ = invoc;
					_tmp350_ = vala_method_call_get_call (_tmp349_);
					_tmp351_ = _tmp350_;
					if (_tmp351_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp352_;
						ValaDataType* _tmp353_;
						ValaDataType* _tmp354_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp369_;
						ValaExpression* _tmp370_;
						ValaDataType* _tmp371_;
						ValaDataType* _tmp372_;
						const gchar* _tmp373_;
						ValaDataType* _tmp374_;
						ValaSourceReference* _tmp375_;
						ValaSourceReference* _tmp376_;
						ValaDynamicMethod* _tmp377_;
						ValaDynamicMethod* _tmp378_;
						ValaMethodCall* _tmp379_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp380_;
						ValaErrorType* _tmp381_;
						ValaDynamicMethod* _tmp382_;
						ValaErrorType* _tmp383_;
						ValaDynamicMethod* _tmp384_;
						ValaDynamicMethod* _tmp385_;
						ValaParameter* _tmp386_;
						ValaParameter* _tmp387_;
						ValaDynamicMethod* _tmp388_;
						ValaObjectType* _tmp389_;
						ValaDataType* _tmp390_;
						ValaDataType* _tmp391_;
						ValaParameter* _tmp392_;
						ValaParameter* _tmp393_;
						ValaObjectType* _tmp394_;
						ValaObjectTypeSymbol* _tmp395_;
						ValaObjectTypeSymbol* _tmp396_;
						ValaScope* _tmp397_;
						ValaScope* _tmp398_;
						ValaDynamicMethod* _tmp399_;
						ValaDynamicMethod* _tmp400_;
						_tmp352_ = invoc;
						_tmp353_ = vala_expression_get_target_type ((ValaExpression*) _tmp352_);
						_tmp354_ = _tmp353_;
						if (_tmp354_ != NULL) {
							ValaMethodCall* _tmp355_;
							ValaDataType* _tmp356_;
							ValaDataType* _tmp357_;
							ValaDataType* _tmp358_;
							ValaDataType* _tmp359_;
							_tmp355_ = invoc;
							_tmp356_ = vala_expression_get_target_type ((ValaExpression*) _tmp355_);
							_tmp357_ = _tmp356_;
							_tmp358_ = vala_data_type_copy (_tmp357_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp358_;
							_tmp359_ = ret_type;
							vala_data_type_set_value_owned (_tmp359_, TRUE);
						} else {
							ValaMethodCall* _tmp360_;
							ValaCodeNode* _tmp361_;
							ValaCodeNode* _tmp362_;
							_tmp360_ = invoc;
							_tmp361_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp360_);
							_tmp362_ = _tmp361_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp362_)) {
								ValaVoidType* _tmp363_;
								_tmp363_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp363_;
							} else {
								ValaExpression* _tmp364_;
								ValaExpression* _tmp365_;
								ValaDataType* _tmp366_;
								ValaDataType* _tmp367_;
								ValaDataType* _tmp368_;
								_tmp364_ = vala_member_access_get_inner (self);
								_tmp365_ = _tmp364_;
								_tmp366_ = vala_expression_get_value_type (_tmp365_);
								_tmp367_ = _tmp366_;
								_tmp368_ = vala_data_type_copy (_tmp367_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp368_;
							}
						}
						_tmp369_ = vala_member_access_get_inner (self);
						_tmp370_ = _tmp369_;
						_tmp371_ = vala_expression_get_value_type (_tmp370_);
						_tmp372_ = _tmp371_;
						_tmp373_ = self->priv->_member_name;
						_tmp374_ = ret_type;
						_tmp375_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp376_ = _tmp375_;
						_tmp377_ = vala_dynamic_method_new (_tmp372_, _tmp373_, _tmp374_, _tmp376_, NULL);
						m = _tmp377_;
						_tmp378_ = m;
						_tmp379_ = invoc;
						vala_dynamic_method_set_invocation (_tmp378_, _tmp379_);
						_tmp380_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp380_;
						_tmp381_ = err;
						vala_error_type_set_dynamic_error (_tmp381_, TRUE);
						_tmp382_ = m;
						_tmp383_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp382_, (ValaDataType*) _tmp383_);
						_tmp384_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp384_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp385_ = m;
						_tmp386_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp387_ = _tmp386_;
						vala_callable_add_parameter ((ValaCallable*) _tmp385_, _tmp387_);
						_vala_code_node_unref0 (_tmp387_);
						_tmp388_ = m;
						_tmp389_ = dynamic_object_type;
						_tmp390_ = vala_data_type_copy ((ValaDataType*) _tmp389_);
						_tmp391_ = _tmp390_;
						_tmp392_ = vala_parameter_new ("this", _tmp391_, NULL);
						_tmp393_ = _tmp392_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp388_, _tmp393_);
						_vala_code_node_unref0 (_tmp393_);
						_vala_code_node_unref0 (_tmp391_);
						_tmp394_ = dynamic_object_type;
						_tmp395_ = vala_object_type_get_type_symbol (_tmp394_);
						_tmp396_ = _tmp395_;
						_tmp397_ = vala_symbol_get_scope ((ValaSymbol*) _tmp396_);
						_tmp398_ = _tmp397_;
						_tmp399_ = m;
						vala_scope_add (_tmp398_, NULL, (ValaSymbol*) _tmp399_);
						_tmp400_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp400_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp401_;
					ValaCodeNode* _tmp402_;
					_tmp401_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp402_ = _tmp401_;
					if (VALA_IS_ASSIGNMENT (_tmp402_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp403_;
						ValaCodeNode* _tmp404_;
						ValaAssignment* _tmp405_;
						ValaAssignment* _tmp406_;
						ValaExpression* _tmp407_;
						ValaExpression* _tmp408_;
						_tmp403_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp404_ = _tmp403_;
						_tmp405_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp404_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp405_;
						_tmp406_ = a;
						_tmp407_ = vala_assignment_get_left (_tmp406_);
						_tmp408_ = _tmp407_;
						if (_tmp408_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp409_;
							ValaExpression* _tmp410_;
							ValaDataType* _tmp411_;
							ValaDataType* _tmp412_;
							const gchar* _tmp413_;
							ValaSourceReference* _tmp414_;
							ValaSourceReference* _tmp415_;
							ValaDynamicProperty* _tmp416_;
							ValaDynamicProperty* _tmp417_;
							ValaDynamicProperty* _tmp418_;
							ValaDynamicProperty* _tmp419_;
							ValaSourceReference* _tmp420_;
							ValaSourceReference* _tmp421_;
							ValaPropertyAccessor* _tmp422_;
							ValaPropertyAccessor* _tmp423_;
							ValaDynamicProperty* _tmp424_;
							ValaExpression* _tmp425_;
							ValaExpression* _tmp426_;
							ValaDataType* _tmp427_;
							ValaDataType* _tmp428_;
							ValaTypeSymbol* _tmp429_;
							ValaTypeSymbol* _tmp430_;
							ValaScope* _tmp431_;
							ValaScope* _tmp432_;
							ValaObjectType* _tmp433_;
							ValaObjectTypeSymbol* _tmp434_;
							ValaObjectTypeSymbol* _tmp435_;
							ValaScope* _tmp436_;
							ValaScope* _tmp437_;
							ValaDynamicProperty* _tmp438_;
							ValaDynamicProperty* _tmp439_;
							_tmp409_ = vala_member_access_get_inner (self);
							_tmp410_ = _tmp409_;
							_tmp411_ = vala_expression_get_value_type (_tmp410_);
							_tmp412_ = _tmp411_;
							_tmp413_ = self->priv->_member_name;
							_tmp414_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp415_ = _tmp414_;
							_tmp416_ = vala_dynamic_property_new (_tmp412_, _tmp413_, _tmp415_, NULL);
							prop = _tmp416_;
							_tmp417_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp417_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp418_ = prop;
							_tmp419_ = prop;
							_tmp420_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp419_);
							_tmp421_ = _tmp420_;
							_tmp422_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp421_, NULL);
							_tmp423_ = _tmp422_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp418_, _tmp423_);
							_vala_code_node_unref0 (_tmp423_);
							_tmp424_ = prop;
							_tmp425_ = vala_member_access_get_inner (self);
							_tmp426_ = _tmp425_;
							_tmp427_ = vala_expression_get_value_type (_tmp426_);
							_tmp428_ = _tmp427_;
							_tmp429_ = vala_data_type_get_data_type (_tmp428_);
							_tmp430_ = _tmp429_;
							_tmp431_ = vala_symbol_get_scope ((ValaSymbol*) _tmp430_);
							_tmp432_ = _tmp431_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp424_, _tmp432_);
							_tmp433_ = dynamic_object_type;
							_tmp434_ = vala_object_type_get_type_symbol (_tmp433_);
							_tmp435_ = _tmp434_;
							_tmp436_ = vala_symbol_get_scope ((ValaSymbol*) _tmp435_);
							_tmp437_ = _tmp436_;
							_tmp438_ = prop;
							vala_scope_add (_tmp437_, NULL, (ValaSymbol*) _tmp438_);
							_tmp439_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp439_);
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp440_ = FALSE;
						gboolean _tmp441_ = FALSE;
						ValaCodeNode* _tmp442_;
						ValaCodeNode* _tmp443_;
						_tmp442_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp443_ = _tmp442_;
						if (VALA_IS_MEMBER_ACCESS (_tmp443_)) {
							ValaExpression* _tmp444_;
							ValaExpression* _tmp445_;
							_tmp444_ = vala_member_access_get_inner (self);
							_tmp445_ = _tmp444_;
							_tmp441_ = VALA_IS_MEMBER_ACCESS (_tmp445_);
						} else {
							_tmp441_ = FALSE;
						}
						if (_tmp441_) {
							ValaCodeNode* _tmp446_;
							ValaCodeNode* _tmp447_;
							ValaCodeNode* _tmp448_;
							ValaCodeNode* _tmp449_;
							_tmp446_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp447_ = _tmp446_;
							_tmp448_ = vala_code_node_get_parent_node (_tmp447_);
							_tmp449_ = _tmp448_;
							_tmp440_ = VALA_IS_METHOD_CALL (_tmp449_);
						} else {
							_tmp440_ = FALSE;
						}
						if (_tmp440_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp450_;
							ValaCodeNode* _tmp451_;
							ValaMemberAccess* _tmp452_;
							gboolean _tmp453_ = FALSE;
							ValaMemberAccess* _tmp454_;
							const gchar* _tmp455_;
							_tmp450_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp451_ = _tmp450_;
							_tmp452_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp451_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp452_;
							_tmp454_ = ma;
							_tmp455_ = _tmp454_->priv->_member_name;
							if (g_strcmp0 (_tmp455_, "connect") == 0) {
								_tmp453_ = TRUE;
							} else {
								ValaMemberAccess* _tmp456_;
								const gchar* _tmp457_;
								_tmp456_ = ma;
								_tmp457_ = _tmp456_->priv->_member_name;
								_tmp453_ = g_strcmp0 (_tmp457_, "connect_after") == 0;
							}
							if (_tmp453_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp458_;
								ValaExpression* _tmp459_;
								ValaDataType* _tmp460_;
								ValaDataType* _tmp461_;
								const gchar* _tmp462_;
								ValaVoidType* _tmp463_;
								ValaVoidType* _tmp464_;
								ValaSourceReference* _tmp465_;
								ValaSourceReference* _tmp466_;
								ValaDynamicSignal* _tmp467_;
								ValaDynamicSignal* _tmp468_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp469_;
								ValaCodeNode* _tmp470_;
								ValaCodeNode* _tmp471_;
								ValaCodeNode* _tmp472_;
								ValaMethodCall* _tmp473_;
								ValaMethodCall* _tmp474_;
								ValaList* _tmp475_;
								ValaList* _tmp476_;
								gint _tmp477_;
								gint _tmp478_;
								gboolean _tmp479_;
								ValaDynamicSignal* _tmp506_;
								ValaObjectType* _tmp507_;
								ValaObjectTypeSymbol* _tmp508_;
								ValaObjectTypeSymbol* _tmp509_;
								ValaScope* _tmp510_;
								ValaScope* _tmp511_;
								ValaDynamicSignal* _tmp512_;
								ValaDynamicSignal* _tmp513_;
								_tmp458_ = vala_member_access_get_inner (self);
								_tmp459_ = _tmp458_;
								_tmp460_ = vala_expression_get_value_type (_tmp459_);
								_tmp461_ = _tmp460_;
								_tmp462_ = self->priv->_member_name;
								_tmp463_ = vala_void_type_new (NULL);
								_tmp464_ = _tmp463_;
								_tmp465_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp466_ = _tmp465_;
								_tmp467_ = vala_dynamic_signal_new (_tmp461_, _tmp462_, (ValaDataType*) _tmp464_, _tmp466_, NULL);
								_tmp468_ = _tmp467_;
								_vala_code_node_unref0 (_tmp464_);
								s = _tmp468_;
								_tmp469_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp470_ = _tmp469_;
								_tmp471_ = vala_code_node_get_parent_node (_tmp470_);
								_tmp472_ = _tmp471_;
								_tmp473_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp472_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp473_;
								_tmp474_ = mcall;
								_tmp475_ = vala_method_call_get_argument_list (_tmp474_);
								_tmp476_ = _tmp475_;
								_tmp477_ = vala_collection_get_size ((ValaCollection*) _tmp476_);
								_tmp478_ = _tmp477_;
								_tmp479_ = _tmp478_ > 0;
								_vala_iterable_unref0 (_tmp476_);
								if (_tmp479_) {
									ValaDynamicSignal* _tmp480_;
									ValaMethodCall* _tmp481_;
									ValaList* _tmp482_;
									ValaList* _tmp483_;
									gpointer _tmp484_;
									ValaExpression* _tmp485_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp486_;
									ValaExpression* _tmp487_;
									ValaExpression* _tmp488_;
									gboolean _tmp489_ = FALSE;
									gboolean _tmp490_ = FALSE;
									ValaMemberAccess* _tmp491_;
									_tmp480_ = s;
									_tmp481_ = mcall;
									_tmp482_ = vala_method_call_get_argument_list (_tmp481_);
									_tmp483_ = _tmp482_;
									_tmp484_ = vala_list_get (_tmp483_, 0);
									_tmp485_ = (ValaExpression*) _tmp484_;
									vala_dynamic_signal_set_handler (_tmp480_, _tmp485_);
									_vala_code_node_unref0 (_tmp485_);
									_vala_iterable_unref0 (_tmp483_);
									_tmp486_ = s;
									_tmp487_ = vala_dynamic_signal_get_handler (_tmp486_);
									_tmp488_ = _tmp487_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp488_) ? ((ValaMemberAccess*) _tmp488_) : NULL;
									_tmp491_ = arg;
									if (_tmp491_ == NULL) {
										_tmp490_ = TRUE;
									} else {
										ValaMemberAccess* _tmp492_;
										_tmp492_ = arg;
										_tmp490_ = !vala_code_node_check ((ValaCodeNode*) _tmp492_, context);
									}
									if (_tmp490_) {
										_tmp489_ = TRUE;
									} else {
										ValaMemberAccess* _tmp493_;
										ValaSymbol* _tmp494_;
										ValaSymbol* _tmp495_;
										_tmp493_ = arg;
										_tmp494_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp493_);
										_tmp495_ = _tmp494_;
										_tmp489_ = !VALA_IS_METHOD (_tmp495_);
									}
									if (_tmp489_) {
										ValaDynamicSignal* _tmp496_;
										ValaExpression* _tmp497_;
										ValaExpression* _tmp498_;
										ValaSourceReference* _tmp499_;
										ValaSourceReference* _tmp500_;
										ValaDynamicSignal* _tmp501_;
										gchar* _tmp502_;
										gchar* _tmp503_;
										gchar* _tmp504_;
										gchar* _tmp505_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp496_ = s;
										_tmp497_ = vala_dynamic_signal_get_handler (_tmp496_);
										_tmp498_ = _tmp497_;
										_tmp499_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp498_);
										_tmp500_ = _tmp499_;
										_tmp501_ = s;
										_tmp502_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp501_);
										_tmp503_ = _tmp502_;
										_tmp504_ = g_strdup_printf ("Invalid handler for `%s'", _tmp503_);
										_tmp505_ = _tmp504_;
										vala_report_error (_tmp500_, _tmp505_);
										_g_free0 (_tmp505_);
										_g_free0 (_tmp503_);
									}
								}
								_tmp506_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp506_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp507_ = dynamic_object_type;
								_tmp508_ = vala_object_type_get_type_symbol (_tmp507_);
								_tmp509_ = _tmp508_;
								_tmp510_ = vala_symbol_get_scope ((ValaSymbol*) _tmp509_);
								_tmp511_ = _tmp510_;
								_tmp512_ = s;
								vala_scope_add (_tmp511_, NULL, (ValaSymbol*) _tmp512_);
								_tmp513_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp513_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp514_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp515_ = _tmp514_;
				if (_tmp515_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp516_;
					ValaExpression* _tmp517_;
					ValaDataType* _tmp518_;
					ValaDataType* _tmp519_;
					const gchar* _tmp520_;
					ValaSourceReference* _tmp521_;
					ValaSourceReference* _tmp522_;
					ValaDynamicProperty* _tmp523_;
					ValaDataType* _tmp524_;
					ValaDataType* _tmp525_;
					ValaDynamicProperty* _tmp536_;
					ValaDynamicProperty* _tmp537_;
					ValaDynamicProperty* _tmp538_;
					ValaDataType* _tmp539_;
					ValaDataType* _tmp540_;
					ValaDataType* _tmp541_;
					ValaDataType* _tmp542_;
					ValaDynamicProperty* _tmp543_;
					ValaSourceReference* _tmp544_;
					ValaSourceReference* _tmp545_;
					ValaPropertyAccessor* _tmp546_;
					ValaPropertyAccessor* _tmp547_;
					ValaDynamicProperty* _tmp548_;
					ValaExpression* _tmp549_;
					ValaExpression* _tmp550_;
					ValaDataType* _tmp551_;
					ValaDataType* _tmp552_;
					ValaTypeSymbol* _tmp553_;
					ValaTypeSymbol* _tmp554_;
					ValaScope* _tmp555_;
					ValaScope* _tmp556_;
					ValaObjectType* _tmp557_;
					ValaObjectTypeSymbol* _tmp558_;
					ValaObjectTypeSymbol* _tmp559_;
					ValaScope* _tmp560_;
					ValaScope* _tmp561_;
					ValaDynamicProperty* _tmp562_;
					ValaDynamicProperty* _tmp563_;
					_tmp516_ = vala_member_access_get_inner (self);
					_tmp517_ = _tmp516_;
					_tmp518_ = vala_expression_get_value_type (_tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = self->priv->_member_name;
					_tmp521_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp522_ = _tmp521_;
					_tmp523_ = vala_dynamic_property_new (_tmp519_, _tmp520_, _tmp522_, NULL);
					prop = _tmp523_;
					_tmp524_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp525_ = _tmp524_;
					if (_tmp525_ != NULL) {
						ValaDynamicProperty* _tmp526_;
						ValaDataType* _tmp527_;
						ValaDataType* _tmp528_;
						_tmp526_ = prop;
						_tmp527_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp528_ = _tmp527_;
						vala_property_set_property_type ((ValaProperty*) _tmp526_, _tmp528_);
					} else {
						ValaDynamicProperty* _tmp529_;
						ValaExpression* _tmp530_;
						ValaExpression* _tmp531_;
						ValaDataType* _tmp532_;
						ValaDataType* _tmp533_;
						ValaDataType* _tmp534_;
						ValaDataType* _tmp535_;
						_tmp529_ = prop;
						_tmp530_ = vala_member_access_get_inner (self);
						_tmp531_ = _tmp530_;
						_tmp532_ = vala_expression_get_value_type (_tmp531_);
						_tmp533_ = _tmp532_;
						_tmp534_ = vala_data_type_copy (_tmp533_);
						_tmp535_ = _tmp534_;
						vala_property_set_property_type ((ValaProperty*) _tmp529_, _tmp535_);
						_vala_code_node_unref0 (_tmp535_);
					}
					_tmp536_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp536_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp537_ = prop;
					_tmp538_ = prop;
					_tmp539_ = vala_property_get_property_type ((ValaProperty*) _tmp538_);
					_tmp540_ = _tmp539_;
					_tmp541_ = vala_data_type_copy (_tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = prop;
					_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp543_);
					_tmp545_ = _tmp544_;
					_tmp546_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp542_, NULL, _tmp545_, NULL);
					_tmp547_ = _tmp546_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp537_, _tmp547_);
					_vala_code_node_unref0 (_tmp547_);
					_vala_code_node_unref0 (_tmp542_);
					_tmp548_ = prop;
					_tmp549_ = vala_member_access_get_inner (self);
					_tmp550_ = _tmp549_;
					_tmp551_ = vala_expression_get_value_type (_tmp550_);
					_tmp552_ = _tmp551_;
					_tmp553_ = vala_data_type_get_data_type (_tmp552_);
					_tmp554_ = _tmp553_;
					_tmp555_ = vala_symbol_get_scope ((ValaSymbol*) _tmp554_);
					_tmp556_ = _tmp555_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp548_, _tmp556_);
					_tmp557_ = dynamic_object_type;
					_tmp558_ = vala_object_type_get_type_symbol (_tmp557_);
					_tmp559_ = _tmp558_;
					_tmp560_ = vala_symbol_get_scope ((ValaSymbol*) _tmp559_);
					_tmp561_ = _tmp560_;
					_tmp562_ = prop;
					vala_scope_add (_tmp561_, NULL, (ValaSymbol*) _tmp562_);
					_tmp563_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp563_);
					_vala_code_node_unref0 (prop);
				}
				_tmp564_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp565_ = _tmp564_;
				if (_tmp565_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp567_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp568_ = _tmp567_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp568_)) {
				ValaExpression* _tmp569_;
				ValaExpression* _tmp570_;
				ValaSymbol* _tmp571_;
				ValaSymbol* _tmp572_;
				_tmp569_ = vala_member_access_get_inner (self);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_expression_get_symbol_reference (_tmp570_);
				_tmp572_ = _tmp571_;
				_tmp566_ = VALA_IS_VARIABLE (_tmp572_);
			} else {
				_tmp566_ = FALSE;
			}
			if (_tmp566_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp573_;
				ValaSemanticAnalyzer* _tmp574_;
				ValaExpression* _tmp575_;
				ValaExpression* _tmp576_;
				ValaSymbol* _tmp577_;
				ValaSymbol* _tmp578_;
				ValaDataType* _tmp579_;
				ValaArrayType* _tmp580_;
				gboolean _tmp581_ = FALSE;
				ValaArrayType* _tmp582_;
				_tmp573_ = vala_code_context_get_analyzer (context);
				_tmp574_ = _tmp573_;
				_tmp575_ = vala_member_access_get_inner (self);
				_tmp576_ = _tmp575_;
				_tmp577_ = vala_expression_get_symbol_reference (_tmp576_);
				_tmp578_ = _tmp577_;
				_tmp579_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp574_, _tmp578_, TRUE);
				_tmp580_ = VALA_IS_ARRAY_TYPE (_tmp579_) ? ((ValaArrayType*) _tmp579_) : NULL;
				if (_tmp580_ == NULL) {
					_vala_code_node_unref0 (_tmp579_);
				}
				inner_type = _tmp580_;
				_tmp582_ = inner_type;
				if (_tmp582_ != NULL) {
					ValaArrayType* _tmp583_;
					gboolean _tmp584_;
					gboolean _tmp585_;
					_tmp583_ = inner_type;
					_tmp584_ = vala_array_type_get_inline_allocated (_tmp583_);
					_tmp585_ = _tmp584_;
					_tmp581_ = _tmp585_;
				} else {
					_tmp581_ = FALSE;
				}
				if (_tmp581_) {
					ValaSourceReference* _tmp586_;
					ValaSourceReference* _tmp587_;
					_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp587_ = _tmp586_;
					vala_report_error (_tmp587_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp588_ = FALSE;
					ValaArrayType* _tmp589_;
					_tmp589_ = inner_type;
					if (_tmp589_ != NULL) {
						ValaArrayType* _tmp590_;
						gboolean _tmp591_;
						gboolean _tmp592_;
						_tmp590_ = inner_type;
						_tmp591_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp590_);
						_tmp592_ = _tmp591_;
						_tmp588_ = !_tmp592_;
					} else {
						_tmp588_ = FALSE;
					}
					if (_tmp588_) {
						ValaSourceReference* _tmp593_;
						ValaSourceReference* _tmp594_;
						_tmp593_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp594_ = _tmp593_;
						vala_report_error (_tmp594_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp598_ = vala_member_access_get_inner (self);
	_tmp599_ = _tmp598_;
	if (_tmp599_ == NULL) {
		ValaSymbol* _tmp600_;
		ValaSymbol* _tmp601_;
		_tmp600_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp601_ = _tmp600_;
		_tmp597_ = _tmp601_ == NULL;
	} else {
		_tmp597_ = FALSE;
	}
	if (_tmp597_) {
		ValaDataType* _tmp602_;
		ValaDataType* _tmp603_;
		_tmp602_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp603_ = _tmp602_;
		_tmp596_ = _tmp603_ != NULL;
	} else {
		_tmp596_ = FALSE;
	}
	if (_tmp596_) {
		ValaDataType* _tmp604_;
		ValaDataType* _tmp605_;
		ValaTypeSymbol* _tmp606_;
		ValaTypeSymbol* _tmp607_;
		_tmp604_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp605_ = _tmp604_;
		_tmp606_ = vala_data_type_get_data_type (_tmp605_);
		_tmp607_ = _tmp606_;
		_tmp595_ = VALA_IS_ENUM (_tmp607_);
	} else {
		_tmp595_ = FALSE;
	}
	if (_tmp595_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp608_;
		ValaDataType* _tmp609_;
		ValaTypeSymbol* _tmp610_;
		ValaTypeSymbol* _tmp611_;
		ValaEnum* _tmp612_;
		_tmp608_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp609_ = _tmp608_;
		_tmp610_ = vala_data_type_get_data_type (_tmp609_);
		_tmp611_ = _tmp610_;
		_tmp612_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp611_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp612_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp613_;
			ValaList* _tmp614_;
			gint _val_size = 0;
			ValaList* _tmp615_;
			gint _tmp616_;
			gint _tmp617_;
			gint _val_index = 0;
			_tmp613_ = enum_type;
			_tmp614_ = vala_enum_get_values (_tmp613_);
			_val_list = _tmp614_;
			_tmp615_ = _val_list;
			_tmp616_ = vala_collection_get_size ((ValaCollection*) _tmp615_);
			_tmp617_ = _tmp616_;
			_val_size = _tmp617_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp618_;
				gpointer _tmp619_;
				const gchar* _tmp620_;
				ValaEnumValue* _tmp621_;
				const gchar* _tmp622_;
				const gchar* _tmp623_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp618_ = _val_list;
				_tmp619_ = vala_list_get (_tmp618_, _val_index);
				val = (ValaEnumValue*) _tmp619_;
				_tmp620_ = self->priv->_member_name;
				_tmp621_ = val;
				_tmp622_ = vala_symbol_get_name ((ValaSymbol*) _tmp621_);
				_tmp623_ = _tmp622_;
				if (g_strcmp0 (_tmp620_, _tmp623_) == 0) {
					ValaEnumValue* _tmp624_;
					_tmp624_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp624_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp625_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp626_ = _tmp625_;
	if (_tmp626_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp627_;
		gboolean _tmp628_ = FALSE;
		ValaExpression* _tmp629_;
		ValaExpression* _tmp630_;
		ValaSourceReference* _tmp643_;
		ValaSourceReference* _tmp644_;
		const gchar* _tmp645_;
		const gchar* _tmp646_;
		gchar* _tmp647_;
		gchar* _tmp648_;
		ValaInvalidType* _tmp649_;
		ValaInvalidType* _tmp650_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp627_ = g_strdup ("(null)");
		base_type_name = _tmp627_;
		_tmp629_ = vala_member_access_get_inner (self);
		_tmp630_ = _tmp629_;
		if (_tmp630_ != NULL) {
			ValaExpression* _tmp631_;
			ValaExpression* _tmp632_;
			ValaDataType* _tmp633_;
			ValaDataType* _tmp634_;
			_tmp631_ = vala_member_access_get_inner (self);
			_tmp632_ = _tmp631_;
			_tmp633_ = vala_expression_get_value_type (_tmp632_);
			_tmp634_ = _tmp633_;
			_tmp628_ = _tmp634_ != NULL;
		} else {
			_tmp628_ = FALSE;
		}
		if (_tmp628_) {
			ValaExpression* _tmp635_;
			ValaExpression* _tmp636_;
			ValaDataType* _tmp637_;
			ValaDataType* _tmp638_;
			gchar* _tmp639_;
			_tmp635_ = vala_member_access_get_inner (self);
			_tmp636_ = _tmp635_;
			_tmp637_ = vala_expression_get_value_type (_tmp636_);
			_tmp638_ = _tmp637_;
			_tmp639_ = vala_code_node_to_string ((ValaCodeNode*) _tmp638_);
			_g_free0 (base_type_name);
			base_type_name = _tmp639_;
		} else {
			ValaSymbol* _tmp640_;
			_tmp640_ = base_symbol;
			if (_tmp640_ != NULL) {
				ValaSymbol* _tmp641_;
				gchar* _tmp642_;
				_tmp641_ = base_symbol;
				_tmp642_ = vala_symbol_get_full_name (_tmp641_);
				_g_free0 (base_type_name);
				base_type_name = _tmp642_;
			}
		}
		_tmp643_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp644_ = _tmp643_;
		_tmp645_ = self->priv->_member_name;
		_tmp646_ = base_type_name;
		_tmp647_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp645_, _tmp646_);
		_tmp648_ = _tmp647_;
		vala_report_error (_tmp644_, _tmp648_);
		_g_free0 (_tmp648_);
		_tmp649_ = vala_invalid_type_new ();
		_tmp650_ = _tmp649_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp650_);
		_vala_code_node_unref0 (_tmp650_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	} else {
		ValaSymbol* _tmp651_;
		ValaSymbol* _tmp652_;
		gboolean _tmp653_;
		gboolean _tmp654_;
		_tmp651_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp652_ = _tmp651_;
		_tmp653_ = vala_code_node_get_error ((ValaCodeNode*) _tmp652_);
		_tmp654_ = _tmp653_;
		if (_tmp654_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
	}
	_tmp655_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp656_ = _tmp655_;
	if (VALA_IS_SIGNAL (_tmp656_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp657_;
		ValaSymbol* _tmp658_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp665_;
		ValaCodeNode* _tmp666_;
		ValaCodeNode* _tmp667_;
		gboolean _tmp668_ = FALSE;
		gboolean _tmp669_ = FALSE;
		gboolean _tmp670_ = FALSE;
		ValaCodeNode* _tmp671_;
		_tmp657_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp658_ = _tmp657_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp658_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp659_;
			ValaCodeNode* _tmp660_;
			ValaCodeNode* _tmp661_;
			ValaCodeNode* _tmp662_;
			ValaCodeNode* _tmp663_;
			ValaCodeNode* _tmp664_;
			_tmp659_ = ma;
			_tmp660_ = vala_code_node_get_parent_node (_tmp659_);
			_tmp661_ = _tmp660_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp661_)) {
				break;
			}
			_tmp662_ = ma;
			_tmp663_ = vala_code_node_get_parent_node (_tmp662_);
			_tmp664_ = _tmp663_;
			ma = _tmp664_;
		}
		_tmp665_ = ma;
		_tmp666_ = vala_code_node_get_parent_node (_tmp665_);
		_tmp667_ = _tmp666_;
		parent = _tmp667_;
		_tmp671_ = parent;
		if (_tmp671_ != NULL) {
			ValaCodeNode* _tmp672_;
			_tmp672_ = parent;
			_tmp670_ = !VALA_IS_ELEMENT_ACCESS (_tmp672_);
		} else {
			_tmp670_ = FALSE;
		}
		if (_tmp670_) {
			ValaCodeNode* _tmp673_;
			ValaExpression* _tmp674_;
			ValaExpression* _tmp675_;
			_tmp673_ = ma;
			_tmp674_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp673_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp675_ = _tmp674_;
			_tmp669_ = !VALA_IS_BASE_ACCESS (_tmp675_);
		} else {
			_tmp669_ = FALSE;
		}
		if (_tmp669_) {
			gboolean _tmp676_ = FALSE;
			ValaCodeNode* _tmp677_;
			_tmp677_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp677_)) {
				_tmp676_ = TRUE;
			} else {
				ValaCodeNode* _tmp678_;
				ValaList* _tmp679_;
				ValaList* _tmp680_;
				_tmp678_ = parent;
				_tmp679_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp678_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp680_ = _tmp679_;
				_tmp676_ = vala_collection_contains ((ValaCollection*) _tmp680_, (ValaExpression*) self);
				_vala_iterable_unref0 (_tmp680_);
			}
			_tmp668_ = _tmp676_;
		} else {
			_tmp668_ = FALSE;
		}
		if (_tmp668_) {
			ValaSignal* _tmp681_;
			ValaAttribute* _tmp682_;
			_tmp681_ = sig;
			_tmp682_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp681_, "HasEmitter");
			if (_tmp682_ != NULL) {
				ValaSignal* _tmp683_;
				ValaSignal* _tmp684_;
				ValaMethod* _tmp685_;
				ValaMethod* _tmp686_;
				_tmp683_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp683_, context)) {
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_tmp684_ = sig;
				_tmp685_ = vala_signal_get_emitter (_tmp684_);
				_tmp686_ = _tmp685_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp686_);
			} else {
				ValaSourceReference* _tmp687_;
				ValaSourceReference* _tmp688_;
				ValaSymbol* _tmp689_;
				ValaSymbol* _tmp690_;
				gchar* _tmp691_;
				gchar* _tmp692_;
				gchar* _tmp693_;
				gchar* _tmp694_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp687_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp688_ = _tmp687_;
				_tmp689_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp690_ = _tmp689_;
				_tmp691_ = vala_symbol_get_full_name (_tmp690_);
				_tmp692_ = _tmp691_;
				_tmp693_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp692_);
				_tmp694_ = _tmp693_;
				vala_report_error (_tmp688_, _tmp694_);
				_g_free0 (_tmp694_);
				_g_free0 (_tmp692_);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
		}
	}
	_tmp695_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp696_ = _tmp695_;
	_tmp697_ = _vala_code_node_ref0 (_tmp696_);
	member = _tmp697_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp698_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp698_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp699_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp699_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp700_;
		ValaLocalVariable* _tmp701_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp702_;
		ValaSymbol* _tmp703_;
		ValaSymbol* _tmp704_;
		ValaBlock* _tmp705_;
		gboolean _tmp706_ = FALSE;
		ValaBlock* _tmp707_;
		_tmp700_ = member;
		_tmp701_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp700_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp701_;
		_tmp702_ = local;
		_tmp703_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp702_);
		_tmp704_ = _tmp703_;
		_tmp705_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp704_) ? ((ValaBlock*) _tmp704_) : NULL);
		block = _tmp705_;
		_tmp707_ = block;
		if (_tmp707_ != NULL) {
			ValaSemanticAnalyzer* _tmp708_;
			ValaSemanticAnalyzer* _tmp709_;
			ValaBlock* _tmp710_;
			ValaSymbol* _tmp711_;
			ValaSymbol* _tmp712_;
			ValaSemanticAnalyzer* _tmp713_;
			ValaSemanticAnalyzer* _tmp714_;
			ValaSymbol* _tmp715_;
			ValaSymbol* _tmp716_;
			_tmp708_ = vala_code_context_get_analyzer (context);
			_tmp709_ = _tmp708_;
			_tmp710_ = block;
			_tmp711_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp709_, (ValaSymbol*) _tmp710_);
			_tmp712_ = _tmp711_;
			_tmp713_ = vala_code_context_get_analyzer (context);
			_tmp714_ = _tmp713_;
			_tmp715_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp714_);
			_tmp716_ = _tmp715_;
			_tmp706_ = _tmp712_ != _tmp716_;
			_vala_code_node_unref0 (_tmp712_);
		} else {
			_tmp706_ = FALSE;
		}
		if (_tmp706_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp717_;
			ValaSemanticAnalyzer* _tmp718_;
			ValaSymbol* _tmp719_;
			ValaSymbol* _tmp720_;
			ValaSymbol* _tmp721_;
			ValaLocalVariable* _tmp734_;
			ValaBlock* _tmp735_;
			_tmp717_ = vala_code_context_get_analyzer (context);
			_tmp718_ = _tmp717_;
			_tmp719_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp718_);
			_tmp720_ = _tmp719_;
			_tmp721_ = _vala_code_node_ref0 (_tmp720_);
			sym = _tmp721_;
			while (TRUE) {
				ValaSymbol* _tmp722_;
				ValaBlock* _tmp723_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp724_;
				ValaMethod* _tmp725_;
				ValaMethod* _tmp726_;
				ValaSymbol* _tmp730_;
				ValaSymbol* _tmp731_;
				ValaSymbol* _tmp732_;
				ValaSymbol* _tmp733_;
				_tmp722_ = sym;
				_tmp723_ = block;
				if (!(_tmp722_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp723_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp724_ = sym;
				_tmp725_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp724_) ? ((ValaMethod*) _tmp724_) : NULL);
				method = _tmp725_;
				_tmp726_ = method;
				if (_tmp726_ != NULL) {
					ValaMethod* _tmp727_;
					ValaMethod* _tmp728_;
					ValaLocalVariable* _tmp729_;
					_tmp727_ = method;
					vala_method_set_closure (_tmp727_, TRUE);
					_tmp728_ = method;
					_tmp729_ = local;
					vala_method_add_captured_variable (_tmp728_, _tmp729_);
				}
				_tmp730_ = sym;
				_tmp731_ = vala_symbol_get_parent_symbol (_tmp730_);
				_tmp732_ = _tmp731_;
				_tmp733_ = _vala_code_node_ref0 (_tmp732_);
				_vala_code_node_unref0 (sym);
				sym = _tmp733_;
				_vala_code_node_unref0 (method);
			}
			_tmp734_ = local;
			vala_local_variable_set_captured (_tmp734_, TRUE);
			_tmp735_ = block;
			vala_block_set_captured (_tmp735_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp736_;
		_tmp736_ = member;
		if (VALA_IS_PARAMETER (_tmp736_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp737_;
			ValaParameter* _tmp738_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp739_;
			ValaSymbol* _tmp740_;
			ValaSymbol* _tmp741_;
			ValaMethod* _tmp742_;
			gboolean _tmp743_ = FALSE;
			gboolean _tmp744_ = FALSE;
			ValaMethod* _tmp745_;
			_tmp737_ = member;
			_tmp738_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp737_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp738_;
			_tmp739_ = param;
			_tmp740_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp739_);
			_tmp741_ = _tmp740_;
			_tmp742_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp741_) ? ((ValaMethod*) _tmp741_) : NULL);
			m = _tmp742_;
			_tmp745_ = m;
			if (_tmp745_ != NULL) {
				ValaMethod* _tmp746_;
				ValaSemanticAnalyzer* _tmp747_;
				ValaSemanticAnalyzer* _tmp748_;
				ValaSymbol* _tmp749_;
				ValaSymbol* _tmp750_;
				_tmp746_ = m;
				_tmp747_ = vala_code_context_get_analyzer (context);
				_tmp748_ = _tmp747_;
				_tmp749_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp748_);
				_tmp750_ = _tmp749_;
				_tmp744_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp746_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp750_;
			} else {
				_tmp744_ = FALSE;
			}
			if (_tmp744_) {
				ValaParameter* _tmp751_;
				ValaMethod* _tmp752_;
				ValaParameter* _tmp753_;
				ValaParameter* _tmp754_;
				_tmp751_ = param;
				_tmp752_ = m;
				_tmp753_ = vala_method_get_this_parameter (_tmp752_);
				_tmp754_ = _tmp753_;
				_tmp743_ = _tmp751_ != _tmp754_;
			} else {
				_tmp743_ = FALSE;
			}
			if (_tmp743_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp755_;
				ValaSemanticAnalyzer* _tmp756_;
				ValaSymbol* _tmp757_;
				ValaSymbol* _tmp758_;
				ValaSymbol* _tmp759_;
				ValaParameter* _tmp770_;
				ValaMethod* _tmp771_;
				ValaBlock* _tmp772_;
				ValaBlock* _tmp773_;
				ValaParameter* _tmp774_;
				ValaParameterDirection _tmp775_;
				ValaParameterDirection _tmp776_;
				_tmp755_ = vala_code_context_get_analyzer (context);
				_tmp756_ = _tmp755_;
				_tmp757_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp756_);
				_tmp758_ = _tmp757_;
				_tmp759_ = _vala_code_node_ref0 (_tmp758_);
				sym = _tmp759_;
				while (TRUE) {
					ValaSymbol* _tmp760_;
					ValaMethod* _tmp761_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp762_;
					ValaMethod* _tmp763_;
					ValaMethod* _tmp764_;
					ValaSymbol* _tmp766_;
					ValaSymbol* _tmp767_;
					ValaSymbol* _tmp768_;
					ValaSymbol* _tmp769_;
					_tmp760_ = sym;
					_tmp761_ = m;
					if (!(_tmp760_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp761_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp762_ = sym;
					_tmp763_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp762_) ? ((ValaMethod*) _tmp762_) : NULL);
					method = _tmp763_;
					_tmp764_ = method;
					if (_tmp764_ != NULL) {
						ValaMethod* _tmp765_;
						_tmp765_ = method;
						vala_method_set_closure (_tmp765_, TRUE);
					}
					_tmp766_ = sym;
					_tmp767_ = vala_symbol_get_parent_symbol (_tmp766_);
					_tmp768_ = _tmp767_;
					_tmp769_ = _vala_code_node_ref0 (_tmp768_);
					_vala_code_node_unref0 (sym);
					sym = _tmp769_;
					_vala_code_node_unref0 (method);
				}
				_tmp770_ = param;
				vala_parameter_set_captured (_tmp770_, TRUE);
				_tmp771_ = m;
				_tmp772_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp771_);
				_tmp773_ = _tmp772_;
				vala_block_set_captured (_tmp773_, TRUE);
				_tmp774_ = param;
				_tmp775_ = vala_parameter_get_direction (_tmp774_);
				_tmp776_ = _tmp775_;
				if (_tmp776_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp777_;
					ValaSourceReference* _tmp778_;
					ValaParameter* _tmp779_;
					gchar* _tmp780_;
					gchar* _tmp781_;
					gchar* _tmp782_;
					gchar* _tmp783_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp777_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp778_ = _tmp777_;
					_tmp779_ = param;
					_tmp780_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp779_);
					_tmp781_ = _tmp780_;
					_tmp782_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp781_);
					_tmp783_ = _tmp782_;
					vala_report_error (_tmp778_, _tmp783_);
					_g_free0 (_tmp783_);
					_g_free0 (_tmp781_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp784_;
				ValaSymbol* _tmp785_;
				ValaSymbol* _tmp786_;
				ValaSymbol* _tmp787_;
				ValaSymbol* _tmp788_;
				ValaPropertyAccessor* _tmp789_;
				gboolean _tmp790_ = FALSE;
				gboolean _tmp791_ = FALSE;
				ValaPropertyAccessor* _tmp792_;
				_tmp784_ = param;
				_tmp785_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp784_);
				_tmp786_ = _tmp785_;
				_tmp787_ = vala_symbol_get_parent_symbol (_tmp786_);
				_tmp788_ = _tmp787_;
				_tmp789_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp788_) ? ((ValaPropertyAccessor*) _tmp788_) : NULL);
				acc = _tmp789_;
				_tmp792_ = acc;
				if (_tmp792_ != NULL) {
					ValaPropertyAccessor* _tmp793_;
					ValaSemanticAnalyzer* _tmp794_;
					ValaSemanticAnalyzer* _tmp795_;
					ValaSymbol* _tmp796_;
					ValaSymbol* _tmp797_;
					_tmp793_ = acc;
					_tmp794_ = vala_code_context_get_analyzer (context);
					_tmp795_ = _tmp794_;
					_tmp796_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp795_);
					_tmp797_ = _tmp796_;
					_tmp791_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp793_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp797_;
				} else {
					_tmp791_ = FALSE;
				}
				if (_tmp791_) {
					ValaParameter* _tmp798_;
					ValaPropertyAccessor* _tmp799_;
					ValaProperty* _tmp800_;
					ValaProperty* _tmp801_;
					ValaParameter* _tmp802_;
					ValaParameter* _tmp803_;
					_tmp798_ = param;
					_tmp799_ = acc;
					_tmp800_ = vala_property_accessor_get_prop (_tmp799_);
					_tmp801_ = _tmp800_;
					_tmp802_ = vala_property_get_this_parameter (_tmp801_);
					_tmp803_ = _tmp802_;
					_tmp790_ = _tmp798_ != _tmp803_;
				} else {
					_tmp790_ = FALSE;
				}
				if (_tmp790_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp804_;
					ValaSemanticAnalyzer* _tmp805_;
					ValaSymbol* _tmp806_;
					ValaSymbol* _tmp807_;
					ValaSymbol* _tmp808_;
					ValaParameter* _tmp819_;
					ValaPropertyAccessor* _tmp820_;
					ValaBlock* _tmp821_;
					ValaBlock* _tmp822_;
					_tmp804_ = vala_code_context_get_analyzer (context);
					_tmp805_ = _tmp804_;
					_tmp806_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp805_);
					_tmp807_ = _tmp806_;
					_tmp808_ = _vala_code_node_ref0 (_tmp807_);
					sym = _tmp808_;
					while (TRUE) {
						ValaSymbol* _tmp809_;
						ValaMethod* _tmp810_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp811_;
						ValaMethod* _tmp812_;
						ValaMethod* _tmp813_;
						ValaSymbol* _tmp815_;
						ValaSymbol* _tmp816_;
						ValaSymbol* _tmp817_;
						ValaSymbol* _tmp818_;
						_tmp809_ = sym;
						_tmp810_ = m;
						if (!(_tmp809_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp810_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp811_ = sym;
						_tmp812_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp811_) ? ((ValaMethod*) _tmp811_) : NULL);
						method = _tmp812_;
						_tmp813_ = method;
						if (_tmp813_ != NULL) {
							ValaMethod* _tmp814_;
							_tmp814_ = method;
							vala_method_set_closure (_tmp814_, TRUE);
						}
						_tmp815_ = sym;
						_tmp816_ = vala_symbol_get_parent_symbol (_tmp815_);
						_tmp817_ = _tmp816_;
						_tmp818_ = _vala_code_node_ref0 (_tmp817_);
						_vala_code_node_unref0 (sym);
						sym = _tmp818_;
						_vala_code_node_unref0 (method);
					}
					_tmp819_ = param;
					vala_parameter_set_captured (_tmp819_, TRUE);
					_tmp820_ = acc;
					_tmp821_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp820_);
					_tmp822_ = _tmp821_;
					vala_block_set_captured (_tmp822_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp823_;
			_tmp823_ = member;
			if (VALA_IS_FIELD (_tmp823_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp824_;
				ValaField* _tmp825_;
				ValaField* _tmp826_;
				ValaSymbolAccessibility _tmp827_;
				ValaSymbolAccessibility _tmp828_;
				ValaField* _tmp829_;
				ValaMemberBinding _tmp830_;
				ValaMemberBinding _tmp831_;
				ValaField* _tmp832_;
				ValaMemberBinding _tmp833_;
				ValaMemberBinding _tmp834_;
				ValaField* _tmp835_;
				ValaDataType* _tmp836_;
				ValaDataType* _tmp837_;
				_tmp824_ = member;
				_tmp825_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp824_, VALA_TYPE_FIELD, ValaField));
				f = _tmp825_;
				_tmp826_ = f;
				_tmp827_ = vala_symbol_get_access ((ValaSymbol*) _tmp826_);
				_tmp828_ = _tmp827_;
				access = _tmp828_;
				_tmp829_ = f;
				_tmp830_ = vala_field_get_binding (_tmp829_);
				_tmp831_ = _tmp830_;
				instance = _tmp831_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp832_ = f;
				_tmp833_ = vala_field_get_binding (_tmp832_);
				_tmp834_ = _tmp833_;
				klass = _tmp834_ == VALA_MEMBER_BINDING_CLASS;
				_tmp835_ = f;
				_tmp836_ = vala_variable_get_variable_type ((ValaVariable*) _tmp835_);
				_tmp837_ = _tmp836_;
				if (VALA_IS_GENERIC_TYPE (_tmp837_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp838_;
				_tmp838_ = member;
				if (VALA_IS_CONSTANT (_tmp838_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp839_;
					ValaConstant* _tmp840_;
					ValaConstant* _tmp841_;
					ValaSymbolAccessibility _tmp842_;
					ValaSymbolAccessibility _tmp843_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp844_;
					ValaSymbol* _tmp845_;
					ValaSymbol* _tmp846_;
					ValaBlock* _tmp847_;
					gboolean _tmp848_ = FALSE;
					ValaBlock* _tmp849_;
					_tmp839_ = member;
					_tmp840_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp839_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp840_;
					_tmp841_ = c;
					_tmp842_ = vala_symbol_get_access ((ValaSymbol*) _tmp841_);
					_tmp843_ = _tmp842_;
					access = _tmp843_;
					_tmp844_ = c;
					_tmp845_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp844_);
					_tmp846_ = _tmp845_;
					_tmp847_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp846_) ? ((ValaBlock*) _tmp846_) : NULL);
					block = _tmp847_;
					_tmp849_ = block;
					if (_tmp849_ != NULL) {
						ValaSemanticAnalyzer* _tmp850_;
						ValaSemanticAnalyzer* _tmp851_;
						ValaBlock* _tmp852_;
						ValaSymbol* _tmp853_;
						ValaSymbol* _tmp854_;
						ValaSemanticAnalyzer* _tmp855_;
						ValaSemanticAnalyzer* _tmp856_;
						ValaSymbol* _tmp857_;
						ValaSymbol* _tmp858_;
						_tmp850_ = vala_code_context_get_analyzer (context);
						_tmp851_ = _tmp850_;
						_tmp852_ = block;
						_tmp853_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp851_, (ValaSymbol*) _tmp852_);
						_tmp854_ = _tmp853_;
						_tmp855_ = vala_code_context_get_analyzer (context);
						_tmp856_ = _tmp855_;
						_tmp857_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp856_);
						_tmp858_ = _tmp857_;
						_tmp848_ = _tmp854_ != _tmp858_;
						_vala_code_node_unref0 (_tmp854_);
					} else {
						_tmp848_ = FALSE;
					}
					if (_tmp848_) {
						ValaSourceReference* _tmp859_;
						ValaSourceReference* _tmp860_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp859_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp860_ = _tmp859_;
						vala_report_error (_tmp860_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp861_;
					_tmp861_ = member;
					if (VALA_IS_METHOD (_tmp861_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp862_;
						ValaMethod* _tmp863_;
						ValaMethod* _tmp864_;
						gboolean _tmp865_;
						gboolean _tmp866_;
						ValaMethod* _tmp968_;
						ValaSymbolAccessibility _tmp969_;
						ValaSymbolAccessibility _tmp970_;
						ValaMethod* _tmp971_;
						ValaMethod* _tmp975_;
						ValaMemberBinding _tmp976_;
						ValaMemberBinding _tmp977_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp996_;
						ValaDataType* _tmp997_;
						ValaDataType* _tmp998_;
						ValaGenericType* _tmp999_;
						gboolean _tmp1000_ = FALSE;
						ValaGenericType* _tmp1001_;
						_tmp862_ = member;
						_tmp863_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp862_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp863_;
						_tmp864_ = m;
						_tmp865_ = vala_method_get_is_async_callback (_tmp864_);
						_tmp866_ = _tmp865_;
						if (_tmp866_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp867_;
							ValaSemanticAnalyzer* _tmp868_;
							ValaMethod* _tmp869_;
							ValaMethod* _tmp870_;
							ValaMethod* _tmp871_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp872_;
							ValaMethod* _tmp905_;
							ValaSemanticAnalyzer* _tmp906_;
							ValaSemanticAnalyzer* _tmp907_;
							ValaMethod* _tmp908_;
							ValaMethod* _tmp909_;
							ValaMethod* _tmp928_;
							ValaMethod* _tmp929_;
							ValaMethod* _tmp930_;
							ValaSymbol* _tmp931_;
							ValaSymbol* _tmp932_;
							ValaSymbol* _tmp933_;
							_tmp867_ = vala_code_context_get_analyzer (context);
							_tmp868_ = _tmp867_;
							_tmp869_ = vala_semantic_analyzer_get_current_async_method (_tmp868_);
							_tmp870_ = _tmp869_;
							_tmp871_ = _vala_code_node_ref0 (_tmp870_);
							async_method = _tmp871_;
							is_valid_access = FALSE;
							_tmp872_ = async_method;
							if (_tmp872_ != NULL) {
								ValaMethod* _tmp873_;
								ValaMethod* _tmp874_;
								ValaMethod* _tmp875_;
								ValaMethod* _tmp876_;
								gboolean _tmp877_;
								_tmp873_ = m;
								_tmp874_ = async_method;
								_tmp875_ = vala_method_get_callback_method (_tmp874_);
								_tmp876_ = _tmp875_;
								_tmp877_ = _tmp873_ == _tmp876_;
								_vala_code_node_unref0 (_tmp876_);
								if (_tmp877_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp878_ = FALSE;
									ValaMethod* _tmp879_;
									ValaMethod* _tmp880_;
									ValaMethod* _tmp881_;
									_tmp879_ = async_method;
									_tmp880_ = vala_method_get_base_method (_tmp879_);
									_tmp881_ = _tmp880_;
									if (_tmp881_ != NULL) {
										ValaMethod* _tmp882_;
										ValaMethod* _tmp883_;
										ValaMethod* _tmp884_;
										ValaMethod* _tmp885_;
										ValaMethod* _tmp886_;
										ValaMethod* _tmp887_;
										_tmp882_ = m;
										_tmp883_ = async_method;
										_tmp884_ = vala_method_get_base_method (_tmp883_);
										_tmp885_ = _tmp884_;
										_tmp886_ = vala_method_get_callback_method (_tmp885_);
										_tmp887_ = _tmp886_;
										_tmp878_ = _tmp882_ == _tmp887_;
										_vala_code_node_unref0 (_tmp887_);
									} else {
										_tmp878_ = FALSE;
									}
									if (_tmp878_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp888_ = FALSE;
										ValaMethod* _tmp889_;
										ValaMethod* _tmp890_;
										ValaMethod* _tmp891_;
										_tmp889_ = async_method;
										_tmp890_ = vala_method_get_base_interface_method (_tmp889_);
										_tmp891_ = _tmp890_;
										if (_tmp891_ != NULL) {
											ValaMethod* _tmp892_;
											ValaMethod* _tmp893_;
											ValaMethod* _tmp894_;
											ValaMethod* _tmp895_;
											ValaMethod* _tmp896_;
											ValaMethod* _tmp897_;
											_tmp892_ = m;
											_tmp893_ = async_method;
											_tmp894_ = vala_method_get_base_interface_method (_tmp893_);
											_tmp895_ = _tmp894_;
											_tmp896_ = vala_method_get_callback_method (_tmp895_);
											_tmp897_ = _tmp896_;
											_tmp888_ = _tmp892_ == _tmp897_;
											_vala_code_node_unref0 (_tmp897_);
										} else {
											_tmp888_ = FALSE;
										}
										if (_tmp888_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp898_;
								ValaSourceReference* _tmp899_;
								ValaMethod* _tmp900_;
								gchar* _tmp901_;
								gchar* _tmp902_;
								gchar* _tmp903_;
								gchar* _tmp904_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp898_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp899_ = _tmp898_;
								_tmp900_ = m;
								_tmp901_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp900_);
								_tmp902_ = _tmp901_;
								_tmp903_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp902_);
								_tmp904_ = _tmp903_;
								vala_report_error (_tmp899_, _tmp904_);
								_g_free0 (_tmp904_);
								_g_free0 (_tmp902_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp905_ = async_method;
							_tmp906_ = vala_code_context_get_analyzer (context);
							_tmp907_ = _tmp906_;
							_tmp908_ = vala_semantic_analyzer_get_current_method (_tmp907_);
							_tmp909_ = _tmp908_;
							if (_tmp905_ != _tmp909_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp910_;
								ValaSemanticAnalyzer* _tmp911_;
								ValaMethod* _tmp912_;
								ValaMethod* _tmp913_;
								ValaSymbol* _tmp914_;
								ValaMethod* _tmp925_;
								ValaBlock* _tmp926_;
								ValaBlock* _tmp927_;
								_tmp910_ = vala_code_context_get_analyzer (context);
								_tmp911_ = _tmp910_;
								_tmp912_ = vala_semantic_analyzer_get_current_method (_tmp911_);
								_tmp913_ = _tmp912_;
								_tmp914_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp913_);
								sym = _tmp914_;
								while (TRUE) {
									ValaSymbol* _tmp915_;
									ValaMethod* _tmp916_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp917_;
									ValaMethod* _tmp918_;
									ValaMethod* _tmp919_;
									ValaSymbol* _tmp921_;
									ValaSymbol* _tmp922_;
									ValaSymbol* _tmp923_;
									ValaSymbol* _tmp924_;
									_tmp915_ = sym;
									_tmp916_ = async_method;
									if (!(_tmp915_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp916_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp917_ = sym;
									_tmp918_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp917_) ? ((ValaMethod*) _tmp917_) : NULL);
									method = _tmp918_;
									_tmp919_ = method;
									if (_tmp919_ != NULL) {
										ValaMethod* _tmp920_;
										_tmp920_ = method;
										vala_method_set_closure (_tmp920_, TRUE);
									}
									_tmp921_ = sym;
									_tmp922_ = vala_symbol_get_parent_symbol (_tmp921_);
									_tmp923_ = _tmp922_;
									_tmp924_ = _vala_code_node_ref0 (_tmp923_);
									_vala_code_node_unref0 (sym);
									sym = _tmp924_;
									_vala_code_node_unref0 (method);
								}
								_tmp925_ = async_method;
								_tmp926_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp925_);
								_tmp927_ = _tmp926_;
								vala_block_set_captured (_tmp927_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp928_ = async_method;
							_tmp929_ = vala_method_get_callback_method (_tmp928_);
							_vala_code_node_unref0 (m);
							m = _tmp929_;
							_tmp930_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp930_);
							_tmp931_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp932_ = _tmp931_;
							_tmp933_ = _vala_code_node_ref0 (_tmp932_);
							_vala_code_node_unref0 (member);
							member = _tmp933_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp934_;
							ValaMethod* _tmp935_;
							ValaMethod* _tmp936_;
							_tmp934_ = m;
							_tmp935_ = vala_method_get_base_method (_tmp934_);
							_tmp936_ = _tmp935_;
							if (_tmp936_ != NULL) {
								ValaMethod* _tmp937_;
								ValaMethod* _tmp938_;
								ValaMethod* _tmp939_;
								ValaMethod* _tmp940_;
								ValaMethod* _tmp941_;
								ValaSignal* _tmp942_;
								ValaSignal* _tmp943_;
								ValaSymbol* _tmp948_;
								ValaSymbol* _tmp949_;
								ValaSymbol* _tmp950_;
								_tmp937_ = m;
								_tmp938_ = vala_method_get_base_method (_tmp937_);
								_tmp939_ = _tmp938_;
								_tmp940_ = _vala_code_node_ref0 (_tmp939_);
								_vala_code_node_unref0 (m);
								m = _tmp940_;
								_tmp941_ = m;
								_tmp942_ = vala_method_get_signal_reference (_tmp941_);
								_tmp943_ = _tmp942_;
								if (_tmp943_ != NULL) {
									ValaMethod* _tmp944_;
									ValaSignal* _tmp945_;
									ValaSignal* _tmp946_;
									_tmp944_ = m;
									_tmp945_ = vala_method_get_signal_reference (_tmp944_);
									_tmp946_ = _tmp945_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp946_);
								} else {
									ValaMethod* _tmp947_;
									_tmp947_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp947_);
								}
								_tmp948_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp949_ = _tmp948_;
								_tmp950_ = _vala_code_node_ref0 (_tmp949_);
								_vala_code_node_unref0 (member);
								member = _tmp950_;
							} else {
								ValaMethod* _tmp951_;
								ValaMethod* _tmp952_;
								ValaMethod* _tmp953_;
								_tmp951_ = m;
								_tmp952_ = vala_method_get_base_interface_method (_tmp951_);
								_tmp953_ = _tmp952_;
								if (_tmp953_ != NULL) {
									ValaMethod* _tmp954_;
									ValaMethod* _tmp955_;
									ValaMethod* _tmp956_;
									ValaMethod* _tmp957_;
									ValaMethod* _tmp958_;
									ValaSignal* _tmp959_;
									ValaSignal* _tmp960_;
									ValaSymbol* _tmp965_;
									ValaSymbol* _tmp966_;
									ValaSymbol* _tmp967_;
									_tmp954_ = m;
									_tmp955_ = vala_method_get_base_interface_method (_tmp954_);
									_tmp956_ = _tmp955_;
									_tmp957_ = _vala_code_node_ref0 (_tmp956_);
									_vala_code_node_unref0 (m);
									m = _tmp957_;
									_tmp958_ = m;
									_tmp959_ = vala_method_get_signal_reference (_tmp958_);
									_tmp960_ = _tmp959_;
									if (_tmp960_ != NULL) {
										ValaMethod* _tmp961_;
										ValaSignal* _tmp962_;
										ValaSignal* _tmp963_;
										_tmp961_ = m;
										_tmp962_ = vala_method_get_signal_reference (_tmp961_);
										_tmp963_ = _tmp962_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp963_);
									} else {
										ValaMethod* _tmp964_;
										_tmp964_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp964_);
									}
									_tmp965_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp966_ = _tmp965_;
									_tmp967_ = _vala_code_node_ref0 (_tmp966_);
									_vala_code_node_unref0 (member);
									member = _tmp967_;
								}
							}
						}
						_tmp968_ = m;
						_tmp969_ = vala_symbol_get_access ((ValaSymbol*) _tmp968_);
						_tmp970_ = _tmp969_;
						access = _tmp970_;
						_tmp971_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp971_)) {
							ValaMethod* _tmp972_;
							ValaMemberBinding _tmp973_;
							ValaMemberBinding _tmp974_;
							_tmp972_ = m;
							_tmp973_ = vala_method_get_binding (_tmp972_);
							_tmp974_ = _tmp973_;
							instance = _tmp974_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp975_ = m;
						_tmp976_ = vala_method_get_binding (_tmp975_);
						_tmp977_ = _tmp976_;
						klass = _tmp977_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp978_;
							ValaList* _tmp979_;
							gint _param_size = 0;
							ValaList* _tmp980_;
							gint _tmp981_;
							gint _tmp982_;
							gint _param_index = 0;
							_tmp978_ = m;
							_tmp979_ = vala_callable_get_parameters ((ValaCallable*) _tmp978_);
							_param_list = _tmp979_;
							_tmp980_ = _param_list;
							_tmp981_ = vala_collection_get_size ((ValaCollection*) _tmp980_);
							_tmp982_ = _tmp981_;
							_param_size = _tmp982_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp983_;
								gpointer _tmp984_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp985_;
								ValaDataType* _tmp986_;
								ValaDataType* _tmp987_;
								ValaGenericType* _tmp988_;
								gboolean _tmp989_ = FALSE;
								ValaGenericType* _tmp990_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp983_ = _param_list;
								_tmp984_ = vala_list_get (_tmp983_, _param_index);
								param = (ValaParameter*) _tmp984_;
								_tmp985_ = param;
								_tmp986_ = vala_variable_get_variable_type ((ValaVariable*) _tmp985_);
								_tmp987_ = _tmp986_;
								_tmp988_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp987_) ? ((ValaGenericType*) _tmp987_) : NULL);
								generic_type = _tmp988_;
								_tmp990_ = generic_type;
								if (_tmp990_ != NULL) {
									ValaGenericType* _tmp991_;
									ValaTypeParameter* _tmp992_;
									ValaTypeParameter* _tmp993_;
									ValaSymbol* _tmp994_;
									ValaSymbol* _tmp995_;
									_tmp991_ = generic_type;
									_tmp992_ = vala_generic_type_get_type_parameter (_tmp991_);
									_tmp993_ = _tmp992_;
									_tmp994_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp993_);
									_tmp995_ = _tmp994_;
									_tmp989_ = VALA_IS_TYPESYMBOL (_tmp995_);
								} else {
									_tmp989_ = FALSE;
								}
								if (_tmp989_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp996_ = m;
						_tmp997_ = vala_callable_get_return_type ((ValaCallable*) _tmp996_);
						_tmp998_ = _tmp997_;
						_tmp999_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp998_) ? ((ValaGenericType*) _tmp998_) : NULL);
						generic_type = _tmp999_;
						_tmp1001_ = generic_type;
						if (_tmp1001_ != NULL) {
							ValaGenericType* _tmp1002_;
							ValaTypeParameter* _tmp1003_;
							ValaTypeParameter* _tmp1004_;
							ValaSymbol* _tmp1005_;
							ValaSymbol* _tmp1006_;
							_tmp1002_ = generic_type;
							_tmp1003_ = vala_generic_type_get_type_parameter (_tmp1002_);
							_tmp1004_ = _tmp1003_;
							_tmp1005_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1004_);
							_tmp1006_ = _tmp1005_;
							_tmp1000_ = VALA_IS_TYPESYMBOL (_tmp1006_);
						} else {
							_tmp1000_ = FALSE;
						}
						if (_tmp1000_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp1007_;
						_tmp1007_ = member;
						if (VALA_IS_PROPERTY (_tmp1007_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1008_;
							ValaProperty* _tmp1009_;
							ValaProperty* _tmp1010_;
							ValaProperty* _tmp1011_;
							ValaProperty* _tmp1012_;
							ValaProperty* _tmp1013_;
							ValaProperty* _tmp1033_;
							ValaSymbolAccessibility _tmp1034_;
							ValaSymbolAccessibility _tmp1035_;
							gboolean _tmp1036_;
							gboolean _tmp1037_;
							ValaProperty* _tmp1102_;
							ValaMemberBinding _tmp1103_;
							ValaMemberBinding _tmp1104_;
							ValaProperty* _tmp1105_;
							ValaDataType* _tmp1106_;
							ValaDataType* _tmp1107_;
							_tmp1008_ = member;
							_tmp1009_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1008_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp1009_;
							_tmp1010_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1010_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp1011_ = prop;
							_tmp1012_ = vala_property_get_base_property (_tmp1011_);
							_tmp1013_ = _tmp1012_;
							if (_tmp1013_ != NULL) {
								ValaProperty* _tmp1014_;
								ValaProperty* _tmp1015_;
								ValaProperty* _tmp1016_;
								ValaProperty* _tmp1017_;
								ValaProperty* _tmp1018_;
								ValaSymbol* _tmp1019_;
								ValaSymbol* _tmp1020_;
								ValaSymbol* _tmp1021_;
								_tmp1014_ = prop;
								_tmp1015_ = vala_property_get_base_property (_tmp1014_);
								_tmp1016_ = _tmp1015_;
								_tmp1017_ = _vala_code_node_ref0 (_tmp1016_);
								_vala_code_node_unref0 (prop);
								prop = _tmp1017_;
								_tmp1018_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1018_);
								_tmp1019_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1020_ = _tmp1019_;
								_tmp1021_ = _vala_code_node_ref0 (_tmp1020_);
								_vala_code_node_unref0 (member);
								member = _tmp1021_;
							} else {
								ValaProperty* _tmp1022_;
								ValaProperty* _tmp1023_;
								ValaProperty* _tmp1024_;
								_tmp1022_ = prop;
								_tmp1023_ = vala_property_get_base_interface_property (_tmp1022_);
								_tmp1024_ = _tmp1023_;
								if (_tmp1024_ != NULL) {
									ValaProperty* _tmp1025_;
									ValaProperty* _tmp1026_;
									ValaProperty* _tmp1027_;
									ValaProperty* _tmp1028_;
									ValaProperty* _tmp1029_;
									ValaSymbol* _tmp1030_;
									ValaSymbol* _tmp1031_;
									ValaSymbol* _tmp1032_;
									_tmp1025_ = prop;
									_tmp1026_ = vala_property_get_base_interface_property (_tmp1025_);
									_tmp1027_ = _tmp1026_;
									_tmp1028_ = _vala_code_node_ref0 (_tmp1027_);
									_vala_code_node_unref0 (prop);
									prop = _tmp1028_;
									_tmp1029_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1029_);
									_tmp1030_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1031_ = _tmp1030_;
									_tmp1032_ = _vala_code_node_ref0 (_tmp1031_);
									_vala_code_node_unref0 (member);
									member = _tmp1032_;
								}
							}
							_tmp1033_ = prop;
							_tmp1034_ = vala_symbol_get_access ((ValaSymbol*) _tmp1033_);
							_tmp1035_ = _tmp1034_;
							access = _tmp1035_;
							_tmp1036_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1037_ = _tmp1036_;
							if (_tmp1037_) {
								ValaProperty* _tmp1038_;
								ValaPropertyAccessor* _tmp1039_;
								ValaPropertyAccessor* _tmp1040_;
								ValaProperty* _tmp1048_;
								ValaSymbolAccessibility _tmp1049_;
								ValaSymbolAccessibility _tmp1050_;
								_tmp1038_ = prop;
								_tmp1039_ = vala_property_get_set_accessor (_tmp1038_);
								_tmp1040_ = _tmp1039_;
								if (_tmp1040_ == NULL) {
									ValaSourceReference* _tmp1041_;
									ValaSourceReference* _tmp1042_;
									ValaProperty* _tmp1043_;
									gchar* _tmp1044_;
									gchar* _tmp1045_;
									gchar* _tmp1046_;
									gchar* _tmp1047_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1041_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1042_ = _tmp1041_;
									_tmp1043_ = prop;
									_tmp1044_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1043_);
									_tmp1045_ = _tmp1044_;
									_tmp1046_ = g_strdup_printf ("Property `%s' is read-only", _tmp1045_);
									_tmp1047_ = _tmp1046_;
									vala_report_error (_tmp1042_, _tmp1047_);
									_g_free0 (_tmp1047_);
									_g_free0 (_tmp1045_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1048_ = prop;
								_tmp1049_ = vala_symbol_get_access ((ValaSymbol*) _tmp1048_);
								_tmp1050_ = _tmp1049_;
								if (_tmp1050_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1051_;
									ValaPropertyAccessor* _tmp1052_;
									ValaPropertyAccessor* _tmp1053_;
									ValaSymbolAccessibility _tmp1054_;
									ValaSymbolAccessibility _tmp1055_;
									_tmp1051_ = prop;
									_tmp1052_ = vala_property_get_set_accessor (_tmp1051_);
									_tmp1053_ = _tmp1052_;
									_tmp1054_ = vala_symbol_get_access ((ValaSymbol*) _tmp1053_);
									_tmp1055_ = _tmp1054_;
									access = _tmp1055_;
								} else {
									gboolean _tmp1056_ = FALSE;
									ValaProperty* _tmp1057_;
									ValaSymbolAccessibility _tmp1058_;
									ValaSymbolAccessibility _tmp1059_;
									_tmp1057_ = prop;
									_tmp1058_ = vala_symbol_get_access ((ValaSymbol*) _tmp1057_);
									_tmp1059_ = _tmp1058_;
									if (_tmp1059_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1060_;
										ValaPropertyAccessor* _tmp1061_;
										ValaPropertyAccessor* _tmp1062_;
										ValaSymbolAccessibility _tmp1063_;
										ValaSymbolAccessibility _tmp1064_;
										_tmp1060_ = prop;
										_tmp1061_ = vala_property_get_set_accessor (_tmp1060_);
										_tmp1062_ = _tmp1061_;
										_tmp1063_ = vala_symbol_get_access ((ValaSymbol*) _tmp1062_);
										_tmp1064_ = _tmp1063_;
										_tmp1056_ = _tmp1064_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1056_ = FALSE;
									}
									if (_tmp1056_) {
										ValaProperty* _tmp1065_;
										ValaPropertyAccessor* _tmp1066_;
										ValaPropertyAccessor* _tmp1067_;
										ValaSymbolAccessibility _tmp1068_;
										ValaSymbolAccessibility _tmp1069_;
										_tmp1065_ = prop;
										_tmp1066_ = vala_property_get_set_accessor (_tmp1065_);
										_tmp1067_ = _tmp1066_;
										_tmp1068_ = vala_symbol_get_access ((ValaSymbol*) _tmp1067_);
										_tmp1069_ = _tmp1068_;
										access = _tmp1069_;
									}
								}
							} else {
								ValaProperty* _tmp1070_;
								ValaPropertyAccessor* _tmp1071_;
								ValaPropertyAccessor* _tmp1072_;
								ValaProperty* _tmp1080_;
								ValaSymbolAccessibility _tmp1081_;
								ValaSymbolAccessibility _tmp1082_;
								_tmp1070_ = prop;
								_tmp1071_ = vala_property_get_get_accessor (_tmp1070_);
								_tmp1072_ = _tmp1071_;
								if (_tmp1072_ == NULL) {
									ValaSourceReference* _tmp1073_;
									ValaSourceReference* _tmp1074_;
									ValaProperty* _tmp1075_;
									gchar* _tmp1076_;
									gchar* _tmp1077_;
									gchar* _tmp1078_;
									gchar* _tmp1079_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1073_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1074_ = _tmp1073_;
									_tmp1075_ = prop;
									_tmp1076_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1075_);
									_tmp1077_ = _tmp1076_;
									_tmp1078_ = g_strdup_printf ("Property `%s' is write-only", _tmp1077_);
									_tmp1079_ = _tmp1078_;
									vala_report_error (_tmp1074_, _tmp1079_);
									_g_free0 (_tmp1079_);
									_g_free0 (_tmp1077_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1080_ = prop;
								_tmp1081_ = vala_symbol_get_access ((ValaSymbol*) _tmp1080_);
								_tmp1082_ = _tmp1081_;
								if (_tmp1082_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1083_;
									ValaPropertyAccessor* _tmp1084_;
									ValaPropertyAccessor* _tmp1085_;
									ValaSymbolAccessibility _tmp1086_;
									ValaSymbolAccessibility _tmp1087_;
									_tmp1083_ = prop;
									_tmp1084_ = vala_property_get_get_accessor (_tmp1083_);
									_tmp1085_ = _tmp1084_;
									_tmp1086_ = vala_symbol_get_access ((ValaSymbol*) _tmp1085_);
									_tmp1087_ = _tmp1086_;
									access = _tmp1087_;
								} else {
									gboolean _tmp1088_ = FALSE;
									ValaProperty* _tmp1089_;
									ValaSymbolAccessibility _tmp1090_;
									ValaSymbolAccessibility _tmp1091_;
									_tmp1089_ = prop;
									_tmp1090_ = vala_symbol_get_access ((ValaSymbol*) _tmp1089_);
									_tmp1091_ = _tmp1090_;
									if (_tmp1091_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1092_;
										ValaPropertyAccessor* _tmp1093_;
										ValaPropertyAccessor* _tmp1094_;
										ValaSymbolAccessibility _tmp1095_;
										ValaSymbolAccessibility _tmp1096_;
										_tmp1092_ = prop;
										_tmp1093_ = vala_property_get_get_accessor (_tmp1092_);
										_tmp1094_ = _tmp1093_;
										_tmp1095_ = vala_symbol_get_access ((ValaSymbol*) _tmp1094_);
										_tmp1096_ = _tmp1095_;
										_tmp1088_ = _tmp1096_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1088_ = FALSE;
									}
									if (_tmp1088_) {
										ValaProperty* _tmp1097_;
										ValaPropertyAccessor* _tmp1098_;
										ValaPropertyAccessor* _tmp1099_;
										ValaSymbolAccessibility _tmp1100_;
										ValaSymbolAccessibility _tmp1101_;
										_tmp1097_ = prop;
										_tmp1098_ = vala_property_get_get_accessor (_tmp1097_);
										_tmp1099_ = _tmp1098_;
										_tmp1100_ = vala_symbol_get_access ((ValaSymbol*) _tmp1099_);
										_tmp1101_ = _tmp1100_;
										access = _tmp1101_;
									}
								}
							}
							_tmp1102_ = prop;
							_tmp1103_ = vala_property_get_binding (_tmp1102_);
							_tmp1104_ = _tmp1103_;
							instance = _tmp1104_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1105_ = prop;
							_tmp1106_ = vala_property_get_property_type (_tmp1105_);
							_tmp1107_ = _tmp1106_;
							if (VALA_IS_GENERIC_TYPE (_tmp1107_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1108_;
							_tmp1108_ = member;
							if (VALA_IS_SIGNAL (_tmp1108_)) {
								ValaSymbol* _tmp1109_;
								ValaSymbolAccessibility _tmp1110_;
								ValaSymbolAccessibility _tmp1111_;
								instance = TRUE;
								_tmp1109_ = member;
								_tmp1110_ = vala_symbol_get_access (_tmp1109_);
								_tmp1111_ = _tmp1110_;
								access = _tmp1111_;
							} else {
								gboolean _tmp1112_ = FALSE;
								gboolean _tmp1113_;
								_tmp1113_ = self->priv->_creation_member;
								if (!_tmp1113_) {
									ValaSymbol* _tmp1114_;
									_tmp1114_ = member;
									_tmp1112_ = VALA_IS_ERROR_CODE (_tmp1114_);
								} else {
									_tmp1112_ = FALSE;
								}
								if (_tmp1112_) {
									ValaSymbol* _tmp1115_;
									ValaConstant* _tmp1116_;
									ValaConstant* _tmp1117_;
									ValaSymbol* _tmp1118_;
									ValaSymbol* _tmp1119_;
									ValaSymbol* _tmp1120_;
									_tmp1115_ = member;
									_tmp1116_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1115_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1117_ = _tmp1116_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1117_);
									_tmp1118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1119_ = _tmp1118_;
									_tmp1120_ = _vala_code_node_ref0 (_tmp1119_);
									_vala_code_node_unref0 (member);
									member = _tmp1120_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1121_ = member;
	vala_symbol_set_used (_tmp1121_, TRUE);
	_tmp1122_ = member;
	_tmp1123_ = vala_symbol_get_version (_tmp1122_);
	_tmp1124_ = _tmp1123_;
	_tmp1125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1126_ = _tmp1125_;
	vala_version_attribute_check (_tmp1124_, _tmp1126_);
	_tmp1128_ = access;
	if (_tmp1128_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1129_;
		ValaSymbol* _tmp1130_;
		ValaSymbol* _tmp1131_;
		_tmp1129_ = member;
		_tmp1130_ = vala_symbol_get_parent_symbol (_tmp1129_);
		_tmp1131_ = _tmp1130_;
		_tmp1127_ = VALA_IS_TYPESYMBOL (_tmp1131_);
	} else {
		_tmp1127_ = FALSE;
	}
	if (_tmp1127_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1132_;
		ValaSymbol* _tmp1133_;
		ValaSymbol* _tmp1134_;
		ValaTypeSymbol* _tmp1135_;
		gboolean in_subtype = FALSE;
		_tmp1132_ = member;
		_tmp1133_ = vala_symbol_get_parent_symbol (_tmp1132_);
		_tmp1134_ = _tmp1133_;
		_tmp1135_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1134_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1135_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1136_;
			ValaSemanticAnalyzer* _tmp1137_;
			ValaSymbol* _tmp1138_;
			ValaSymbol* _tmp1139_;
			ValaSymbol* _tmp1140_;
			_tmp1136_ = vala_code_context_get_analyzer (context);
			_tmp1137_ = _tmp1136_;
			_tmp1138_ = vala_semantic_analyzer_get_current_symbol (_tmp1137_);
			_tmp1139_ = _tmp1138_;
			_tmp1140_ = _vala_code_node_ref0 (_tmp1139_);
			this_symbol = _tmp1140_;
			{
				gboolean _tmp1141_ = FALSE;
				_tmp1141_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1146_;
					ValaSymbol* _tmp1147_;
					ValaTypeSymbol* _tmp1148_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1149_;
					ValaClass* _tmp1150_;
					gboolean _tmp1151_ = FALSE;
					ValaClass* _tmp1152_;
					if (!_tmp1141_) {
						ValaSymbol* _tmp1142_;
						ValaSymbol* _tmp1143_;
						ValaSymbol* _tmp1144_;
						ValaSymbol* _tmp1145_;
						_tmp1142_ = this_symbol;
						_tmp1143_ = vala_symbol_get_parent_symbol (_tmp1142_);
						_tmp1144_ = _tmp1143_;
						_tmp1145_ = _vala_code_node_ref0 (_tmp1144_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1145_;
					}
					_tmp1141_ = FALSE;
					_tmp1146_ = this_symbol;
					if (!(_tmp1146_ != NULL)) {
						break;
					}
					_tmp1147_ = this_symbol;
					_tmp1148_ = target_type;
					if (_tmp1147_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1148_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1149_ = this_symbol;
					_tmp1150_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1149_) ? ((ValaClass*) _tmp1149_) : NULL);
					cl = _tmp1150_;
					_tmp1152_ = cl;
					if (_tmp1152_ != NULL) {
						ValaClass* _tmp1153_;
						ValaTypeSymbol* _tmp1154_;
						_tmp1153_ = cl;
						_tmp1154_ = target_type;
						_tmp1151_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1153_, _tmp1154_);
					} else {
						_tmp1151_ = FALSE;
					}
					if (_tmp1151_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1155_;
			ValaSourceReference* _tmp1156_;
			ValaSymbol* _tmp1157_;
			gchar* _tmp1158_;
			gchar* _tmp1159_;
			gchar* _tmp1160_;
			gchar* _tmp1161_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1156_ = _tmp1155_;
			_tmp1157_ = member;
			_tmp1158_ = vala_symbol_get_full_name (_tmp1157_);
			_tmp1159_ = _tmp1158_;
			_tmp1160_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1159_);
			_tmp1161_ = _tmp1160_;
			vala_report_error (_tmp1156_, _tmp1161_);
			_g_free0 (_tmp1161_);
			_g_free0 (_tmp1159_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1162_;
		_tmp1162_ = access;
		if (_tmp1162_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1163_;
			ValaSymbol* _tmp1164_;
			ValaSymbol* _tmp1165_;
			ValaSymbol* _tmp1166_;
			gboolean in_target_type = FALSE;
			_tmp1163_ = member;
			_tmp1164_ = vala_symbol_get_parent_symbol (_tmp1163_);
			_tmp1165_ = _tmp1164_;
			_tmp1166_ = _vala_code_node_ref0 (_tmp1165_);
			target_type = _tmp1166_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1167_;
				ValaSemanticAnalyzer* _tmp1168_;
				ValaSymbol* _tmp1169_;
				ValaSymbol* _tmp1170_;
				ValaSymbol* _tmp1171_;
				_tmp1167_ = vala_code_context_get_analyzer (context);
				_tmp1168_ = _tmp1167_;
				_tmp1169_ = vala_semantic_analyzer_get_current_symbol (_tmp1168_);
				_tmp1170_ = _tmp1169_;
				_tmp1171_ = _vala_code_node_ref0 (_tmp1170_);
				this_symbol = _tmp1171_;
				{
					gboolean _tmp1172_ = FALSE;
					_tmp1172_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1177_;
						ValaSymbol* _tmp1178_;
						ValaSymbol* _tmp1179_;
						if (!_tmp1172_) {
							ValaSymbol* _tmp1173_;
							ValaSymbol* _tmp1174_;
							ValaSymbol* _tmp1175_;
							ValaSymbol* _tmp1176_;
							_tmp1173_ = this_symbol;
							_tmp1174_ = vala_symbol_get_parent_symbol (_tmp1173_);
							_tmp1175_ = _tmp1174_;
							_tmp1176_ = _vala_code_node_ref0 (_tmp1175_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1176_;
						}
						_tmp1172_ = FALSE;
						_tmp1177_ = this_symbol;
						if (!(_tmp1177_ != NULL)) {
							break;
						}
						_tmp1178_ = target_type;
						_tmp1179_ = this_symbol;
						if (_tmp1178_ == _tmp1179_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1180_;
				ValaSourceReference* _tmp1181_;
				ValaSymbol* _tmp1182_;
				gchar* _tmp1183_;
				gchar* _tmp1184_;
				gchar* _tmp1185_;
				gchar* _tmp1186_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1180_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1181_ = _tmp1180_;
				_tmp1182_ = member;
				_tmp1183_ = vala_symbol_get_full_name (_tmp1182_);
				_tmp1184_ = _tmp1183_;
				_tmp1185_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1184_);
				_tmp1186_ = _tmp1185_;
				vala_report_error (_tmp1181_, _tmp1186_);
				_g_free0 (_tmp1186_);
				_g_free0 (_tmp1184_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1188_;
		ValaExpression* _tmp1189_;
		_tmp1188_ = vala_member_access_get_inner (self);
		_tmp1189_ = _tmp1188_;
		_tmp1187_ = _tmp1189_ != NULL;
	} else {
		_tmp1187_ = FALSE;
	}
	if (_tmp1187_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1190_;
		ValaExpression* _tmp1191_;
		ValaDataType* _tmp1192_;
		ValaDataType* _tmp1193_;
		ValaDataType* _tmp1194_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1195_;
		ValaExpression* _tmp1196_;
		ValaDataType* _tmp1197_;
		ValaDataType* _tmp1198_;
		ValaPointerType* _tmp1199_;
		ValaPointerType* _tmp1200_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1205_;
		ValaObjectType* _tmp1206_;
		gboolean _tmp1207_ = FALSE;
		gboolean _tmp1208_ = FALSE;
		ValaObjectType* _tmp1209_;
		_tmp1190_ = vala_member_access_get_inner (self);
		_tmp1191_ = _tmp1190_;
		_tmp1192_ = vala_expression_get_value_type (_tmp1191_);
		_tmp1193_ = _tmp1192_;
		_tmp1194_ = _vala_code_node_ref0 (_tmp1193_);
		instance_type = _tmp1194_;
		_tmp1195_ = vala_member_access_get_inner (self);
		_tmp1196_ = _tmp1195_;
		_tmp1197_ = vala_expression_get_value_type (_tmp1196_);
		_tmp1198_ = _tmp1197_;
		_tmp1199_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1198_) ? ((ValaPointerType*) _tmp1198_) : NULL);
		pointer_type = _tmp1199_;
		_tmp1200_ = pointer_type;
		if (_tmp1200_ != NULL) {
			ValaPointerType* _tmp1201_;
			ValaDataType* _tmp1202_;
			ValaDataType* _tmp1203_;
			ValaDataType* _tmp1204_;
			_tmp1201_ = pointer_type;
			_tmp1202_ = vala_pointer_type_get_base_type (_tmp1201_);
			_tmp1203_ = _tmp1202_;
			_tmp1204_ = _vala_code_node_ref0 (_tmp1203_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1204_;
		}
		_tmp1205_ = instance_type;
		_tmp1206_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1205_) ? ((ValaObjectType*) _tmp1205_) : NULL);
		object_type = _tmp1206_;
		_tmp1209_ = object_type;
		if (_tmp1209_ != NULL) {
			ValaObjectType* _tmp1210_;
			ValaObjectTypeSymbol* _tmp1211_;
			ValaObjectTypeSymbol* _tmp1212_;
			_tmp1210_ = object_type;
			_tmp1211_ = vala_object_type_get_type_symbol (_tmp1210_);
			_tmp1212_ = _tmp1211_;
			_tmp1208_ = vala_object_type_symbol_has_type_parameters (_tmp1212_);
		} else {
			_tmp1208_ = FALSE;
		}
		if (_tmp1208_) {
			ValaDataType* _tmp1213_;
			_tmp1213_ = instance_type;
			_tmp1207_ = !vala_data_type_has_type_arguments (_tmp1213_);
		} else {
			_tmp1207_ = FALSE;
		}
		if (_tmp1207_) {
			ValaExpression* _tmp1214_;
			ValaExpression* _tmp1215_;
			ValaSourceReference* _tmp1216_;
			ValaSourceReference* _tmp1217_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1214_ = vala_member_access_get_inner (self);
			_tmp1215_ = _tmp1214_;
			_tmp1216_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1215_);
			_tmp1217_ = _tmp1216_;
			vala_report_error (_tmp1217_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1219_ = !may_access_instance_members;
	} else {
		_tmp1219_ = FALSE;
	}
	if (_tmp1219_) {
		_tmp1218_ = TRUE;
	} else {
		gboolean _tmp1220_ = FALSE;
		if (klass) {
			_tmp1220_ = !may_access_klass_members;
		} else {
			_tmp1220_ = FALSE;
		}
		_tmp1218_ = _tmp1220_;
	}
	if (_tmp1218_) {
		ValaSymbol* _tmp1221_;
		ValaSymbol* _tmp1222_;
		ValaDataType* _tmp1245_;
		ValaDataType* _tmp1246_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1221_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1222_ = _tmp1221_;
		if (VALA_IS_METHOD (_tmp1222_)) {
			ValaSemanticAnalyzer* _tmp1223_;
			ValaSemanticAnalyzer* _tmp1224_;
			ValaSymbol* _tmp1225_;
			ValaSymbol* _tmp1226_;
			gboolean _tmp1227_;
			gboolean _tmp1228_;
			ValaDataType* _tmp1229_;
			ValaDataType* _tmp1230_;
			_tmp1223_ = vala_code_context_get_analyzer (context);
			_tmp1224_ = _tmp1223_;
			_tmp1225_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1226_ = _tmp1225_;
			_tmp1227_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1228_ = _tmp1227_;
			_tmp1229_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1224_, _tmp1226_, _tmp1228_);
			_tmp1230_ = _tmp1229_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1230_);
			_vala_code_node_unref0 (_tmp1230_);
		} else {
			ValaSymbol* _tmp1231_;
			ValaSymbol* _tmp1232_;
			_tmp1231_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1232_ = _tmp1231_;
			if (VALA_IS_FIELD (_tmp1232_)) {
				ValaSymbol* _tmp1233_;
				ValaSymbol* _tmp1234_;
				ValaFieldPrototype* _tmp1235_;
				ValaFieldPrototype* _tmp1236_;
				_tmp1233_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1234_ = _tmp1233_;
				_tmp1235_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1234_, VALA_TYPE_FIELD, ValaField));
				_tmp1236_ = _tmp1235_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1236_);
				_vala_code_node_unref0 (_tmp1236_);
			} else {
				ValaSymbol* _tmp1237_;
				ValaSymbol* _tmp1238_;
				_tmp1237_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1238_ = _tmp1237_;
				if (VALA_IS_PROPERTY (_tmp1238_)) {
					ValaSymbol* _tmp1239_;
					ValaSymbol* _tmp1240_;
					ValaPropertyPrototype* _tmp1241_;
					ValaPropertyPrototype* _tmp1242_;
					_tmp1239_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1240_ = _tmp1239_;
					_tmp1241_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1240_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1242_ = _tmp1241_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1242_);
					_vala_code_node_unref0 (_tmp1242_);
				} else {
					ValaInvalidType* _tmp1243_;
					ValaInvalidType* _tmp1244_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1243_ = vala_invalid_type_new ();
					_tmp1244_ = _tmp1243_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1244_);
					_vala_code_node_unref0 (_tmp1244_);
				}
			}
		}
		_tmp1245_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1246_ = _tmp1245_;
		if (_tmp1246_ != NULL) {
			ValaDataType* _tmp1247_;
			ValaDataType* _tmp1248_;
			ValaDataType* _tmp1249_;
			ValaDataType* _tmp1250_;
			gboolean _tmp1251_;
			gboolean _tmp1252_;
			_tmp1247_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1248_ = _tmp1247_;
			_tmp1249_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1250_ = _tmp1249_;
			_tmp1251_ = vala_data_type_get_value_owned (_tmp1250_);
			_tmp1252_ = _tmp1251_;
			vala_data_type_set_value_owned (_tmp1248_, _tmp1252_);
		}
	} else {
		gboolean _tmp1253_ = FALSE;
		gboolean _tmp1274_ = FALSE;
		gboolean _tmp1275_ = FALSE;
		gboolean _tmp1276_ = FALSE;
		gboolean _tmp1277_ = FALSE;
		gboolean _tmp1319_ = FALSE;
		gboolean _tmp1320_ = FALSE;
		gboolean _tmp1321_ = FALSE;
		gboolean _tmp1322_ = FALSE;
		gboolean _tmp1323_ = FALSE;
		gboolean _tmp1324_;
		gboolean _tmp1325_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1352_;
		ValaSymbol* _tmp1353_;
		ValaMethod* _tmp1354_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1355_;
		ValaExpression* _tmp1356_;
		ValaMemberAccess* _tmp1357_;
		gboolean _tmp1358_ = FALSE;
		gboolean _tmp1359_ = FALSE;
		gboolean _tmp1360_ = FALSE;
		gboolean _tmp1361_ = FALSE;
		gboolean _tmp1362_ = FALSE;
		ValaMethod* _tmp1363_;
		ValaSemanticAnalyzer* _tmp1400_;
		ValaSemanticAnalyzer* _tmp1401_;
		ValaSymbol* _tmp1402_;
		ValaSymbol* _tmp1403_;
		gboolean _tmp1404_;
		gboolean _tmp1405_;
		ValaDataType* _tmp1406_;
		ValaDataType* _tmp1407_;
		gboolean _tmp1408_ = FALSE;
		ValaExpression* _tmp1409_;
		ValaExpression* _tmp1410_;
		ValaSymbol* _tmp1423_;
		ValaSymbol* _tmp1424_;
		if (instance) {
			ValaExpression* _tmp1254_;
			ValaExpression* _tmp1255_;
			_tmp1254_ = vala_member_access_get_inner (self);
			_tmp1255_ = _tmp1254_;
			_tmp1253_ = _tmp1255_ == NULL;
		} else {
			_tmp1253_ = FALSE;
		}
		if (_tmp1253_) {
			ValaSourceReference* _tmp1256_;
			ValaSourceReference* _tmp1257_;
			ValaMemberAccess* _tmp1258_;
			ValaMemberAccess* _tmp1259_;
			ValaExpression* _tmp1260_;
			ValaExpression* _tmp1261_;
			ValaParameter* _tmp1262_;
			ValaDataType* _tmp1263_;
			ValaDataType* _tmp1264_;
			ValaDataType* _tmp1265_;
			ValaDataType* _tmp1266_;
			ValaExpression* _tmp1267_;
			ValaExpression* _tmp1268_;
			ValaDataType* _tmp1269_;
			ValaDataType* _tmp1270_;
			ValaExpression* _tmp1271_;
			ValaExpression* _tmp1272_;
			ValaParameter* _tmp1273_;
			_tmp1256_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1257_ = _tmp1256_;
			_tmp1258_ = vala_member_access_new (NULL, "this", _tmp1257_);
			_tmp1259_ = _tmp1258_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1259_);
			_vala_code_node_unref0 (_tmp1259_);
			_tmp1260_ = vala_member_access_get_inner (self);
			_tmp1261_ = _tmp1260_;
			_tmp1262_ = this_parameter;
			_tmp1263_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1262_);
			_tmp1264_ = _tmp1263_;
			_tmp1265_ = vala_data_type_copy (_tmp1264_);
			_tmp1266_ = _tmp1265_;
			vala_expression_set_value_type (_tmp1261_, _tmp1266_);
			_vala_code_node_unref0 (_tmp1266_);
			_tmp1267_ = vala_member_access_get_inner (self);
			_tmp1268_ = _tmp1267_;
			_tmp1269_ = vala_expression_get_value_type (_tmp1268_);
			_tmp1270_ = _tmp1269_;
			vala_data_type_set_value_owned (_tmp1270_, FALSE);
			_tmp1271_ = vala_member_access_get_inner (self);
			_tmp1272_ = _tmp1271_;
			_tmp1273_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1272_, (ValaSymbol*) _tmp1273_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1277_ = !klass;
		} else {
			_tmp1277_ = FALSE;
		}
		if (_tmp1277_) {
			ValaSymbol* _tmp1278_;
			ValaSymbol* _tmp1279_;
			_tmp1278_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1279_ = _tmp1278_;
			_tmp1276_ = !VALA_IS_CREATION_METHOD (_tmp1279_);
		} else {
			_tmp1276_ = FALSE;
		}
		if (_tmp1276_) {
			_tmp1275_ = may_access_instance_members;
		} else {
			_tmp1275_ = FALSE;
		}
		if (_tmp1275_) {
			ValaExpression* _tmp1280_;
			ValaExpression* _tmp1281_;
			_tmp1280_ = vala_member_access_get_inner (self);
			_tmp1281_ = _tmp1280_;
			_tmp1274_ = _tmp1281_ != NULL;
		} else {
			_tmp1274_ = FALSE;
		}
		if (_tmp1274_) {
			ValaExpression* _tmp1282_;
			ValaExpression* _tmp1283_;
			ValaSymbol* _tmp1284_;
			ValaSymbol* _tmp1285_;
			_tmp1282_ = vala_member_access_get_inner (self);
			_tmp1283_ = _tmp1282_;
			_tmp1284_ = vala_expression_get_symbol_reference (_tmp1283_);
			_tmp1285_ = _tmp1284_;
			if (VALA_IS_METHOD (_tmp1285_)) {
			} else {
				ValaSourceReference* _tmp1286_;
				ValaSourceReference* _tmp1287_;
				ValaSymbol* _tmp1288_;
				ValaSymbol* _tmp1289_;
				gchar* _tmp1290_;
				gchar* _tmp1291_;
				gchar* _tmp1292_;
				gchar* _tmp1293_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1294_;
				ValaSymbol* _tmp1295_;
				ValaSymbol* _tmp1296_;
				ValaSymbol* _tmp1297_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1317_;
				ValaExpression* _tmp1318_;
				_tmp1286_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1287_ = _tmp1286_;
				_tmp1288_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1289_ = _tmp1288_;
				_tmp1290_ = vala_symbol_get_full_name (_tmp1289_);
				_tmp1291_ = _tmp1290_;
				_tmp1292_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1291_);
				_tmp1293_ = _tmp1292_;
				vala_report_warning (_tmp1287_, _tmp1293_);
				_g_free0 (_tmp1293_);
				_g_free0 (_tmp1291_);
				_tmp1294_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1295_ = _tmp1294_;
				_tmp1296_ = vala_symbol_get_parent_symbol (_tmp1295_);
				_tmp1297_ = _tmp1296_;
				inner_sym = _tmp1297_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1298_ = FALSE;
					ValaSymbol* _tmp1299_;
					ValaMemberAccess* _tmp1303_;
					ValaSymbol* _tmp1304_;
					const gchar* _tmp1305_;
					const gchar* _tmp1306_;
					ValaSourceReference* _tmp1307_;
					ValaSourceReference* _tmp1308_;
					ValaMemberAccess* _tmp1309_;
					ValaMemberAccess* _tmp1310_;
					ValaMemberAccess* _tmp1311_;
					ValaExpression* _tmp1312_;
					ValaExpression* _tmp1313_;
					ValaSymbol* _tmp1314_;
					ValaSymbol* _tmp1315_;
					ValaSymbol* _tmp1316_;
					_tmp1299_ = inner_sym;
					if (_tmp1299_ != NULL) {
						ValaSymbol* _tmp1300_;
						const gchar* _tmp1301_;
						const gchar* _tmp1302_;
						_tmp1300_ = inner_sym;
						_tmp1301_ = vala_symbol_get_name (_tmp1300_);
						_tmp1302_ = _tmp1301_;
						_tmp1298_ = _tmp1302_ != NULL;
					} else {
						_tmp1298_ = FALSE;
					}
					if (!_tmp1298_) {
						break;
					}
					_tmp1303_ = inner_ma;
					_tmp1304_ = inner_sym;
					_tmp1305_ = vala_symbol_get_name (_tmp1304_);
					_tmp1306_ = _tmp1305_;
					_tmp1307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1308_ = _tmp1307_;
					_tmp1309_ = vala_member_access_new (NULL, _tmp1306_, _tmp1308_);
					_tmp1310_ = _tmp1309_;
					vala_member_access_set_inner (_tmp1303_, (ValaExpression*) _tmp1310_);
					_vala_code_node_unref0 (_tmp1310_);
					_tmp1311_ = inner_ma;
					_tmp1312_ = vala_member_access_get_inner (_tmp1311_);
					_tmp1313_ = _tmp1312_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1313_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1314_ = inner_sym;
					_tmp1315_ = vala_symbol_get_parent_symbol (_tmp1314_);
					_tmp1316_ = _tmp1315_;
					inner_sym = _tmp1316_;
				}
				_tmp1317_ = vala_member_access_get_inner (self);
				_tmp1318_ = _tmp1317_;
				vala_code_node_check ((ValaCodeNode*) _tmp1318_, context);
			}
		}
		_tmp1324_ = vala_code_context_get_experimental_non_null (context);
		_tmp1325_ = _tmp1324_;
		if (_tmp1325_) {
			_tmp1323_ = instance;
		} else {
			_tmp1323_ = FALSE;
		}
		if (_tmp1323_) {
			ValaExpression* _tmp1326_;
			ValaExpression* _tmp1327_;
			ValaDataType* _tmp1328_;
			ValaDataType* _tmp1329_;
			gboolean _tmp1330_;
			gboolean _tmp1331_;
			_tmp1326_ = vala_member_access_get_inner (self);
			_tmp1327_ = _tmp1326_;
			_tmp1328_ = vala_expression_get_value_type (_tmp1327_);
			_tmp1329_ = _tmp1328_;
			_tmp1330_ = vala_data_type_get_nullable (_tmp1329_);
			_tmp1331_ = _tmp1330_;
			_tmp1322_ = _tmp1331_;
		} else {
			_tmp1322_ = FALSE;
		}
		if (_tmp1322_) {
			ValaExpression* _tmp1332_;
			ValaExpression* _tmp1333_;
			ValaDataType* _tmp1334_;
			ValaDataType* _tmp1335_;
			_tmp1332_ = vala_member_access_get_inner (self);
			_tmp1333_ = _tmp1332_;
			_tmp1334_ = vala_expression_get_value_type (_tmp1333_);
			_tmp1335_ = _tmp1334_;
			_tmp1321_ = !VALA_IS_POINTER_TYPE (_tmp1335_);
		} else {
			_tmp1321_ = FALSE;
		}
		if (_tmp1321_) {
			ValaExpression* _tmp1336_;
			ValaExpression* _tmp1337_;
			ValaDataType* _tmp1338_;
			ValaDataType* _tmp1339_;
			_tmp1336_ = vala_member_access_get_inner (self);
			_tmp1337_ = _tmp1336_;
			_tmp1338_ = vala_expression_get_value_type (_tmp1337_);
			_tmp1339_ = _tmp1338_;
			_tmp1320_ = !VALA_IS_GENERIC_TYPE (_tmp1339_);
		} else {
			_tmp1320_ = FALSE;
		}
		if (_tmp1320_) {
			ValaExpression* _tmp1340_;
			ValaExpression* _tmp1341_;
			ValaDataType* _tmp1342_;
			ValaDataType* _tmp1343_;
			_tmp1340_ = vala_member_access_get_inner (self);
			_tmp1341_ = _tmp1340_;
			_tmp1342_ = vala_expression_get_value_type (_tmp1341_);
			_tmp1343_ = _tmp1342_;
			_tmp1319_ = !VALA_IS_ARRAY_TYPE (_tmp1343_);
		} else {
			_tmp1319_ = FALSE;
		}
		if (_tmp1319_) {
			ValaSourceReference* _tmp1344_;
			ValaSourceReference* _tmp1345_;
			ValaSymbol* _tmp1346_;
			ValaSymbol* _tmp1347_;
			gchar* _tmp1348_;
			gchar* _tmp1349_;
			gchar* _tmp1350_;
			gchar* _tmp1351_;
			_tmp1344_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1345_ = _tmp1344_;
			_tmp1346_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1347_ = _tmp1346_;
			_tmp1348_ = vala_symbol_get_full_name (_tmp1347_);
			_tmp1349_ = _tmp1348_;
			_tmp1350_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1349_);
			_tmp1351_ = _tmp1350_;
			vala_report_error (_tmp1345_, _tmp1351_);
			_g_free0 (_tmp1351_);
			_g_free0 (_tmp1349_);
		}
		_tmp1352_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1353_ = _tmp1352_;
		_tmp1354_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1353_) ? ((ValaMethod*) _tmp1353_) : NULL);
		m = _tmp1354_;
		_tmp1355_ = vala_member_access_get_inner (self);
		_tmp1356_ = _tmp1355_;
		_tmp1357_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1356_) ? ((ValaMemberAccess*) _tmp1356_) : NULL);
		inner_ma = _tmp1357_;
		_tmp1363_ = m;
		if (_tmp1363_ != NULL) {
			ValaMethod* _tmp1364_;
			ValaMemberBinding _tmp1365_;
			ValaMemberBinding _tmp1366_;
			_tmp1364_ = m;
			_tmp1365_ = vala_method_get_binding (_tmp1364_);
			_tmp1366_ = _tmp1365_;
			_tmp1362_ = _tmp1366_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1362_ = FALSE;
		}
		if (_tmp1362_) {
			ValaMethod* _tmp1367_;
			ValaSymbol* _tmp1368_;
			ValaSymbol* _tmp1369_;
			_tmp1367_ = m;
			_tmp1368_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1367_);
			_tmp1369_ = _tmp1368_;
			_tmp1361_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1369_);
		} else {
			_tmp1361_ = FALSE;
		}
		if (_tmp1361_) {
			ValaExpression* _tmp1370_;
			ValaExpression* _tmp1371_;
			_tmp1370_ = vala_member_access_get_inner (self);
			_tmp1371_ = _tmp1370_;
			_tmp1360_ = _tmp1371_ != NULL;
		} else {
			_tmp1360_ = FALSE;
		}
		if (_tmp1360_) {
			ValaExpression* _tmp1372_;
			ValaExpression* _tmp1373_;
			ValaDataType* _tmp1374_;
			ValaDataType* _tmp1375_;
			_tmp1372_ = vala_member_access_get_inner (self);
			_tmp1373_ = _tmp1372_;
			_tmp1374_ = vala_expression_get_value_type (_tmp1373_);
			_tmp1375_ = _tmp1374_;
			_tmp1359_ = _tmp1375_ == NULL;
		} else {
			_tmp1359_ = FALSE;
		}
		if (_tmp1359_) {
			ValaMemberAccess* _tmp1376_;
			ValaList* _tmp1377_;
			gint _tmp1378_;
			gint _tmp1379_;
			_tmp1376_ = inner_ma;
			_tmp1377_ = _tmp1376_->priv->type_argument_list;
			_tmp1378_ = vala_collection_get_size ((ValaCollection*) _tmp1377_);
			_tmp1379_ = _tmp1378_;
			_tmp1358_ = _tmp1379_ > 0;
		} else {
			_tmp1358_ = FALSE;
		}
		if (_tmp1358_) {
			ValaExpression* _tmp1380_;
			ValaExpression* _tmp1381_;
			ValaMethod* _tmp1382_;
			ValaSymbol* _tmp1383_;
			ValaSymbol* _tmp1384_;
			ValaObjectType* _tmp1385_;
			ValaObjectType* _tmp1386_;
			_tmp1380_ = vala_member_access_get_inner (self);
			_tmp1381_ = _tmp1380_;
			_tmp1382_ = m;
			_tmp1383_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1382_);
			_tmp1384_ = _tmp1383_;
			_tmp1385_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1384_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1386_ = _tmp1385_;
			vala_expression_set_value_type (_tmp1381_, (ValaDataType*) _tmp1386_);
			_vala_code_node_unref0 (_tmp1386_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1387_;
				ValaList* _tmp1388_;
				ValaList* _tmp1389_;
				gint _type_argument_size = 0;
				ValaList* _tmp1390_;
				gint _tmp1391_;
				gint _tmp1392_;
				gint _type_argument_index = 0;
				_tmp1387_ = inner_ma;
				_tmp1388_ = _tmp1387_->priv->type_argument_list;
				_tmp1389_ = _vala_iterable_ref0 (_tmp1388_);
				_type_argument_list = _tmp1389_;
				_tmp1390_ = _type_argument_list;
				_tmp1391_ = vala_collection_get_size ((ValaCollection*) _tmp1390_);
				_tmp1392_ = _tmp1391_;
				_type_argument_size = _tmp1392_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1393_;
					gpointer _tmp1394_;
					ValaExpression* _tmp1395_;
					ValaExpression* _tmp1396_;
					ValaDataType* _tmp1397_;
					ValaDataType* _tmp1398_;
					ValaDataType* _tmp1399_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1393_ = _type_argument_list;
					_tmp1394_ = vala_list_get (_tmp1393_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1394_;
					_tmp1395_ = vala_member_access_get_inner (self);
					_tmp1396_ = _tmp1395_;
					_tmp1397_ = vala_expression_get_value_type (_tmp1396_);
					_tmp1398_ = _tmp1397_;
					_tmp1399_ = type_argument;
					vala_data_type_add_type_argument (_tmp1398_, _tmp1399_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1400_ = vala_code_context_get_analyzer (context);
		_tmp1401_ = _tmp1400_;
		_tmp1402_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1403_ = _tmp1402_;
		_tmp1404_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1405_ = _tmp1404_;
		_tmp1406_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1401_, _tmp1403_, _tmp1405_);
		_tmp1407_ = _tmp1406_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1407_);
		_vala_code_node_unref0 (_tmp1407_);
		_tmp1409_ = vala_member_access_get_inner (self);
		_tmp1410_ = _tmp1409_;
		if (_tmp1410_ != NULL) {
			ValaDataType* _tmp1411_;
			ValaDataType* _tmp1412_;
			_tmp1411_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1412_ = _tmp1411_;
			_tmp1408_ = _tmp1412_ != NULL;
		} else {
			_tmp1408_ = FALSE;
		}
		if (_tmp1408_) {
			ValaDataType* _tmp1413_;
			ValaDataType* _tmp1414_;
			ValaExpression* _tmp1415_;
			ValaExpression* _tmp1416_;
			ValaDataType* _tmp1417_;
			ValaDataType* _tmp1418_;
			ValaDataType* _tmp1419_;
			ValaDataType* _tmp1420_;
			_tmp1413_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1414_ = _tmp1413_;
			_tmp1415_ = vala_member_access_get_inner (self);
			_tmp1416_ = _tmp1415_;
			_tmp1417_ = vala_expression_get_value_type (_tmp1416_);
			_tmp1418_ = _tmp1417_;
			_tmp1419_ = vala_data_type_get_actual_type (_tmp1414_, _tmp1418_, NULL, (ValaCodeNode*) self);
			_tmp1420_ = _tmp1419_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1420_);
			_vala_code_node_unref0 (_tmp1420_);
		} else {
			ValaDataType* _tmp1421_;
			ValaDataType* _tmp1422_;
			_tmp1421_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1422_ = _tmp1421_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1422_);
		}
		_tmp1423_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1424_ = _tmp1423_;
		if (VALA_IS_METHOD (_tmp1424_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1425_;
			ValaSymbol* _tmp1426_;
			ValaMethod* _tmp1427_;
			ValaDataType* _tmp1428_;
			ValaDataType* _tmp1429_;
			gboolean _tmp1436_ = FALSE;
			_tmp1425_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1426_ = _tmp1425_;
			_tmp1427_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1426_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1427_;
			_tmp1428_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1429_ = _tmp1428_;
			if (_tmp1429_ != NULL) {
				ValaDataType* _tmp1430_;
				ValaDataType* _tmp1431_;
				ValaDataType* _tmp1432_;
				ValaDataType* _tmp1433_;
				gboolean _tmp1434_;
				gboolean _tmp1435_;
				_tmp1430_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1431_ = _tmp1430_;
				_tmp1432_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1433_ = _tmp1432_;
				_tmp1434_ = vala_data_type_get_value_owned (_tmp1433_);
				_tmp1435_ = _tmp1434_;
				vala_data_type_set_value_owned (_tmp1431_, _tmp1435_);
			}
			if (instance) {
				ValaMethod* _tmp1437_;
				ValaSymbol* _tmp1438_;
				ValaSymbol* _tmp1439_;
				_tmp1437_ = method;
				_tmp1438_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1437_);
				_tmp1439_ = _tmp1438_;
				_tmp1436_ = VALA_IS_TYPESYMBOL (_tmp1439_);
			} else {
				_tmp1436_ = FALSE;
			}
			if (_tmp1436_) {
				ValaExpression* _tmp1440_;
				ValaExpression* _tmp1441_;
				ValaMethod* _tmp1442_;
				ValaSymbol* _tmp1443_;
				ValaSymbol* _tmp1444_;
				ValaDataType* _tmp1445_;
				ValaDataType* _tmp1446_;
				ValaExpression* _tmp1447_;
				ValaExpression* _tmp1448_;
				ValaDataType* _tmp1449_;
				ValaDataType* _tmp1450_;
				ValaMethod* _tmp1451_;
				ValaParameter* _tmp1452_;
				ValaParameter* _tmp1453_;
				ValaDataType* _tmp1454_;
				ValaDataType* _tmp1455_;
				gboolean _tmp1456_;
				gboolean _tmp1457_;
				_tmp1440_ = vala_member_access_get_inner (self);
				_tmp1441_ = _tmp1440_;
				_tmp1442_ = method;
				_tmp1443_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1442_);
				_tmp1444_ = _tmp1443_;
				_tmp1445_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1444_);
				_tmp1446_ = _tmp1445_;
				vala_expression_set_target_type (_tmp1441_, _tmp1446_);
				_vala_code_node_unref0 (_tmp1446_);
				_tmp1447_ = vala_member_access_get_inner (self);
				_tmp1448_ = _tmp1447_;
				_tmp1449_ = vala_expression_get_target_type (_tmp1448_);
				_tmp1450_ = _tmp1449_;
				_tmp1451_ = method;
				_tmp1452_ = vala_method_get_this_parameter (_tmp1451_);
				_tmp1453_ = _tmp1452_;
				_tmp1454_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1453_);
				_tmp1455_ = _tmp1454_;
				_tmp1456_ = vala_data_type_get_value_owned (_tmp1455_);
				_tmp1457_ = _tmp1456_;
				vala_data_type_set_value_owned (_tmp1450_, _tmp1457_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1458_;
			ValaSymbol* _tmp1459_;
			_tmp1458_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1459_ = _tmp1458_;
			if (VALA_IS_PROPERTY (_tmp1459_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1460_;
				ValaSymbol* _tmp1461_;
				ValaProperty* _tmp1462_;
				gboolean _tmp1463_ = FALSE;
				_tmp1460_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1461_ = _tmp1460_;
				_tmp1462_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1461_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1462_;
				if (instance) {
					ValaProperty* _tmp1464_;
					ValaSymbol* _tmp1465_;
					ValaSymbol* _tmp1466_;
					_tmp1464_ = prop;
					_tmp1465_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1464_);
					_tmp1466_ = _tmp1465_;
					_tmp1463_ = _tmp1466_ != NULL;
				} else {
					_tmp1463_ = FALSE;
				}
				if (_tmp1463_) {
					ValaExpression* _tmp1467_;
					ValaExpression* _tmp1468_;
					ValaProperty* _tmp1469_;
					ValaSymbol* _tmp1470_;
					ValaSymbol* _tmp1471_;
					ValaDataType* _tmp1472_;
					ValaDataType* _tmp1473_;
					_tmp1467_ = vala_member_access_get_inner (self);
					_tmp1468_ = _tmp1467_;
					_tmp1469_ = prop;
					_tmp1470_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1469_);
					_tmp1471_ = _tmp1470_;
					_tmp1472_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1471_);
					_tmp1473_ = _tmp1472_;
					vala_expression_set_target_type (_tmp1468_, _tmp1473_);
					_vala_code_node_unref0 (_tmp1473_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1474_ = FALSE;
				gboolean _tmp1475_ = FALSE;
				gboolean _tmp1476_ = FALSE;
				ValaSymbol* _tmp1477_;
				ValaSymbol* _tmp1478_;
				_tmp1477_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1478_ = _tmp1477_;
				if (VALA_IS_FIELD (_tmp1478_)) {
					_tmp1476_ = TRUE;
				} else {
					ValaSymbol* _tmp1479_;
					ValaSymbol* _tmp1480_;
					_tmp1479_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1480_ = _tmp1479_;
					_tmp1476_ = VALA_IS_SIGNAL (_tmp1480_);
				}
				if (_tmp1476_) {
					_tmp1475_ = instance;
				} else {
					_tmp1475_ = FALSE;
				}
				if (_tmp1475_) {
					ValaSymbol* _tmp1481_;
					ValaSymbol* _tmp1482_;
					ValaSymbol* _tmp1483_;
					ValaSymbol* _tmp1484_;
					_tmp1481_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1482_ = _tmp1481_;
					_tmp1483_ = vala_symbol_get_parent_symbol (_tmp1482_);
					_tmp1484_ = _tmp1483_;
					_tmp1474_ = _tmp1484_ != NULL;
				} else {
					_tmp1474_ = FALSE;
				}
				if (_tmp1474_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1485_;
					ValaSymbol* _tmp1486_;
					ValaSymbol* _tmp1487_;
					ValaSymbol* _tmp1488_;
					ValaDataType* _tmp1489_;
					ValaExpression* _tmp1490_;
					ValaExpression* _tmp1491_;
					ValaDataType* _tmp1492_;
					ValaExpression* _tmp1493_;
					ValaExpression* _tmp1494_;
					ValaDataType* _tmp1495_;
					ValaDataType* _tmp1496_;
					ValaDataType* _tmp1497_;
					ValaDataType* _tmp1498_;
					_tmp1485_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1486_ = _tmp1485_;
					_tmp1487_ = vala_symbol_get_parent_symbol (_tmp1486_);
					_tmp1488_ = _tmp1487_;
					_tmp1489_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1488_);
					parent_type = _tmp1489_;
					_tmp1490_ = vala_member_access_get_inner (self);
					_tmp1491_ = _tmp1490_;
					_tmp1492_ = parent_type;
					_tmp1493_ = vala_member_access_get_inner (self);
					_tmp1494_ = _tmp1493_;
					_tmp1495_ = vala_expression_get_value_type (_tmp1494_);
					_tmp1496_ = _tmp1495_;
					_tmp1497_ = vala_data_type_get_actual_type (_tmp1492_, _tmp1496_, NULL, (ValaCodeNode*) self);
					_tmp1498_ = _tmp1497_;
					vala_expression_set_target_type (_tmp1491_, _tmp1498_);
					_vala_code_node_unref0 (_tmp1498_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1499_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1500_ = _tmp1499_;
	if (_tmp1500_ != NULL) {
		ValaDataType* _tmp1501_;
		ValaDataType* _tmp1502_;
		_tmp1501_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1502_ = _tmp1501_;
		vala_code_node_check ((ValaCodeNode*) _tmp1502_, context);
	}
	_tmp1503_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1504_ = _tmp1503_;
	result = !_tmp1504_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = VALA_IS_ARRAY_TYPE (_tmp55_);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp57_) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = VALA_IS_POINTER_INDIRECTION (_tmp63_);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp67_) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (VALA_IS_METHOD (_tmp75_)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = VALA_IS_VARIABLE (_tmp83_);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = VALA_IS_ELEMENT_ACCESS (_tmp85_);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp91_ = _tmp96_ != NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp97_;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaClass* _tmp103_;
		_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_METHOD, ValaMethod));
		_tmp100_ = _tmp99_;
		cl = VALA_IS_CLASS (_tmp100_) ? ((ValaClass*) _tmp100_) : NULL;
		_tmp103_ = cl;
		if (_tmp103_ != NULL) {
			ValaClass* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			_tmp104_ = cl;
			_tmp105_ = vala_class_get_is_compact (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp102_ = _tmp106_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp107_;
			_tmp107_ = ma;
			_tmp101_ = _tmp107_ != NULL;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			ValaMemberAccess* _tmp108_;
			ValaMemberAccess* _tmp109_;
			_tmp108_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp108_, TRUE);
			_tmp109_ = ma;
			vala_member_access_check_lvalue_access (_tmp109_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

