/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

static gint ValaInitializerList_private_offset;
static gpointer vala_initializer_list_parent_class = NULL;

static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);

static inline gpointer
vala_initializer_list_get_instance_private (ValaInitializerList* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInitializerList_private_offset);
}

/**
 * Appends the specified expression to this initializer
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the expression
 *
 * @return expression list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Creates a new initializer
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}

static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_constant (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_pure (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* result = NULL;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _initializer_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_initializer_list = _tmp2_;
		_tmp3_ = _initializer_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_initializer_size = _tmp5_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			if (first) {
				GString* _tmp8_;
				ValaExpression* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = builder;
				_tmp9_ = initializer;
				_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
				_tmp11_ = _tmp10_;
				g_string_append (_tmp8_, _tmp11_);
				_g_free0 (_tmp11_);
				first = FALSE;
			} else {
				GString* _tmp12_;
				ValaExpression* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = builder;
				_tmp13_ = initializer;
				_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) _tmp13_);
				_tmp15_ = _tmp14_;
				g_string_append_printf (_tmp12_, ", %s", _tmp15_);
				_g_free0 (_tmp15_);
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	_tmp16_ = builder;
	g_string_append_c (_tmp16_, '}');
	_tmp17_ = builder;
	_tmp18_ = _tmp17_->str;
	_tmp19_ = g_strdup (_tmp18_);
	result = _tmp19_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->initializers;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->initializers;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->initializers;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _error_ = FALSE;
	ValaDataType* _tmp273_;
	ValaDataType* _tmp274_;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		if (VALA_IS_ARRAY_TYPE (_tmp9_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			ValaArrayType* _tmp12_;
			gboolean requires_constants_only = FALSE;
			ValaCodeNode* node = NULL;
			ValaCodeNode* _tmp13_;
			ValaCodeNode* _tmp14_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			ValaCodeNode* _tmp22_;
			ValaCodeNode* _tmp23_;
			ValaDataType* inner_target_type = NULL;
			ValaArrayType* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp12_;
			requires_constants_only = FALSE;
			_tmp13_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp14_ = _tmp13_;
			node = _tmp14_;
			while (TRUE) {
				ValaCodeNode* _tmp15_;
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				ValaCodeNode* _tmp19_;
				_tmp15_ = node;
				if (!(_tmp15_ != NULL)) {
					break;
				}
				_tmp16_ = node;
				if (VALA_IS_CONSTANT (_tmp16_)) {
					requires_constants_only = TRUE;
					break;
				}
				_tmp17_ = node;
				_tmp18_ = vala_code_node_get_parent_node (_tmp17_);
				_tmp19_ = _tmp18_;
				node = _tmp19_;
			}
			_tmp22_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp23_)) {
				_tmp21_ = !requires_constants_only;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gboolean _tmp24_ = FALSE;
				ValaCodeNode* _tmp25_;
				ValaCodeNode* _tmp26_;
				_tmp25_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				if (!VALA_IS_INITIALIZER_LIST (_tmp26_)) {
					_tmp24_ = TRUE;
				} else {
					ValaCodeNode* _tmp27_;
					ValaCodeNode* _tmp28_;
					ValaDataType* _tmp29_;
					ValaDataType* _tmp30_;
					ValaTypeSymbol* _tmp31_;
					ValaTypeSymbol* _tmp32_;
					_tmp27_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp28_ = _tmp27_;
					_tmp29_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
					_tmp30_ = _tmp29_;
					_tmp31_ = vala_data_type_get_data_type (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp24_ = VALA_IS_STRUCT (_tmp32_);
				}
				_tmp20_ = _tmp24_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp33_;
				ValaCodeNode* _tmp34_;
				ValaCodeNode* _tmp35_;
				ValaArrayCreationExpression* array_creation = NULL;
				ValaArrayType* _tmp36_;
				ValaDataType* _tmp37_;
				ValaDataType* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaArrayType* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaArrayCreationExpression* _tmp46_;
				ValaArrayCreationExpression* _tmp47_;
				ValaArrayCreationExpression* _tmp48_;
				ValaArrayType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaDataType* _tmp51_;
				ValaDataType* _tmp52_;
				ValaDataType* _tmp53_;
				ValaArrayCreationExpression* _tmp54_;
				ValaDataType* _tmp55_;
				ValaDataType* _tmp56_;
				ValaArrayCreationExpression* _tmp57_;
				ValaDataType* _tmp58_;
				ValaDataType* _tmp59_;
				ValaCodeNode* _tmp60_;
				ValaArrayCreationExpression* _tmp61_;
				ValaArrayCreationExpression* _tmp62_;
				_tmp33_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = _vala_code_node_ref0 (_tmp34_);
				old_parent_node = _tmp35_;
				_tmp36_ = array_type;
				_tmp37_ = vala_array_type_get_element_type (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_data_type_copy (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = array_type;
				_tmp42_ = vala_array_type_get_rank (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_array_creation_expression_new (_tmp40_, _tmp43_, self, _tmp45_);
				_tmp47_ = _tmp46_;
				_vala_code_node_unref0 (_tmp40_);
				array_creation = _tmp47_;
				_tmp48_ = array_creation;
				_tmp49_ = array_type;
				_tmp50_ = vala_array_type_get_length_type (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_data_type_copy (_tmp51_);
				_tmp53_ = _tmp52_;
				vala_array_creation_expression_set_length_type (_tmp48_, _tmp53_);
				_vala_code_node_unref0 (_tmp53_);
				_tmp54_ = array_creation;
				_tmp55_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp56_ = _tmp55_;
				vala_expression_set_target_type ((ValaExpression*) _tmp54_, _tmp56_);
				_tmp57_ = array_creation;
				_tmp58_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp59_ = _tmp58_;
				vala_expression_set_formal_target_type ((ValaExpression*) _tmp57_, _tmp59_);
				_tmp60_ = old_parent_node;
				_tmp61_ = array_creation;
				vala_code_node_replace_expression (_tmp60_, (ValaExpression*) self, (ValaExpression*) _tmp61_);
				vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
				_tmp62_ = array_creation;
				result = vala_code_node_check ((ValaCodeNode*) _tmp62_, context);
				_vala_code_node_unref0 (array_creation);
				_vala_code_node_unref0 (old_parent_node);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp63_ = array_type;
			_tmp64_ = vala_array_type_get_rank (_tmp63_);
			_tmp65_ = _tmp64_;
			if (_tmp65_ > 1) {
				ValaArrayType* inner_array_type = NULL;
				ValaArrayType* _tmp66_;
				ValaDataType* _tmp67_;
				ValaArrayType* _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
				ValaArrayType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp66_ = array_type;
				_tmp67_ = vala_data_type_copy ((ValaDataType*) _tmp66_);
				inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp68_ = inner_array_type;
				_tmp69_ = vala_array_type_get_rank (_tmp68_);
				_tmp70_ = _tmp69_;
				vala_array_type_set_rank (_tmp68_, _tmp70_ - 1);
				_tmp71_ = inner_array_type;
				_tmp72_ = _vala_code_node_ref0 ((ValaDataType*) _tmp71_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp72_;
				_vala_code_node_unref0 (inner_array_type);
			} else {
				ValaArrayType* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				_tmp73_ = array_type;
				_tmp74_ = vala_array_type_get_element_type (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_data_type_copy (_tmp75_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp76_;
			}
			{
				ValaList* _e_list = NULL;
				ValaList* _tmp77_;
				gint _e_size = 0;
				ValaList* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				gint _e_index = 0;
				_tmp77_ = vala_initializer_list_get_initializers (self);
				_e_list = _tmp77_;
				_tmp78_ = _e_list;
				_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
				_tmp80_ = _tmp79_;
				_e_size = _tmp80_;
				_e_index = -1;
				while (TRUE) {
					ValaExpression* e = NULL;
					ValaList* _tmp81_;
					gpointer _tmp82_;
					ValaExpression* _tmp83_;
					ValaDataType* _tmp84_;
					_e_index = _e_index + 1;
					if (!(_e_index < _e_size)) {
						break;
					}
					_tmp81_ = _e_list;
					_tmp82_ = vala_list_get (_tmp81_, _e_index);
					e = (ValaExpression*) _tmp82_;
					_tmp83_ = e;
					_tmp84_ = inner_target_type;
					vala_expression_set_target_type (_tmp83_, _tmp84_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			_vala_code_node_unref0 (inner_target_type);
			_vala_code_node_unref0 (array_type);
		} else {
			ValaDataType* _tmp85_;
			ValaDataType* _tmp86_;
			ValaTypeSymbol* _tmp87_;
			ValaTypeSymbol* _tmp88_;
			_tmp85_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp86_ = _tmp85_;
			_tmp87_ = vala_data_type_get_data_type (_tmp86_);
			_tmp88_ = _tmp87_;
			if (VALA_IS_STRUCT (_tmp88_)) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				ValaTypeSymbol* _tmp91_;
				ValaTypeSymbol* _tmp92_;
				ValaStruct* _tmp93_;
				gboolean _tmp101_ = FALSE;
				ValaCodeNode* _tmp102_;
				ValaCodeNode* _tmp103_;
				gboolean in_array_creation_initializer = FALSE;
				ValaObjectCreationExpression* struct_creation = NULL;
				ValaIterator* field_it = NULL;
				ValaStruct* _tmp152_;
				ValaList* _tmp153_;
				ValaList* _tmp154_;
				ValaIterator* _tmp155_;
				ValaIterator* _tmp156_;
				_tmp89_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_data_type_get_data_type (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, VALA_TYPE_STRUCT, ValaStruct));
				st = _tmp93_;
				while (TRUE) {
					ValaStruct* _tmp94_;
					ValaStruct* _tmp95_;
					ValaStruct* _tmp96_;
					ValaStruct* _tmp97_;
					ValaStruct* _tmp98_;
					ValaStruct* _tmp99_;
					ValaStruct* _tmp100_;
					_tmp94_ = st;
					_tmp95_ = vala_struct_get_base_struct (_tmp94_);
					_tmp96_ = _tmp95_;
					if (!(_tmp96_ != NULL)) {
						break;
					}
					_tmp97_ = st;
					_tmp98_ = vala_struct_get_base_struct (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = _vala_code_node_ref0 (_tmp99_);
					_vala_code_node_unref0 (st);
					st = _tmp100_;
				}
				_tmp102_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp103_ = _tmp102_;
				if (VALA_IS_INITIALIZER_LIST (_tmp103_)) {
					ValaCodeNode* _tmp104_;
					ValaCodeNode* _tmp105_;
					ValaCodeNode* _tmp106_;
					ValaCodeNode* _tmp107_;
					_tmp104_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_code_node_get_parent_node (_tmp105_);
					_tmp107_ = _tmp106_;
					_tmp101_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp107_);
				} else {
					_tmp101_ = FALSE;
				}
				in_array_creation_initializer = _tmp101_;
				struct_creation = NULL;
				if (in_array_creation_initializer) {
					ValaSymbol* sym = NULL;
					ValaStruct* _tmp108_;
					ValaMemberAccess* ma = NULL;
					ValaSymbol* _tmp109_;
					const gchar* _tmp110_;
					const gchar* _tmp111_;
					ValaSourceReference* _tmp112_;
					ValaSourceReference* _tmp113_;
					ValaMemberAccess* _tmp114_;
					ValaMemberAccess* _tmp115_;
					ValaMemberAccess* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaMemberAccess* inner = NULL;
					ValaMemberAccess* _tmp118_;
					ValaMemberAccess* _tmp119_;
					ValaMemberAccess* _tmp142_;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					ValaObjectCreationExpression* _tmp145_;
					ValaObjectCreationExpression* _tmp146_;
					ValaDataType* _tmp147_;
					ValaDataType* _tmp148_;
					ValaDataType* _tmp149_;
					ValaDataType* _tmp150_;
					ValaObjectCreationExpression* _tmp151_;
					_tmp108_ = st;
					sym = (ValaSymbol*) _tmp108_;
					_tmp109_ = sym;
					_tmp110_ = vala_symbol_get_name (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp113_ = _tmp112_;
					_tmp114_ = vala_member_access_new_simple (_tmp111_, _tmp113_);
					ma = _tmp114_;
					_tmp115_ = ma;
					vala_member_access_set_creation_member (_tmp115_, TRUE);
					_tmp116_ = ma;
					_tmp117_ = sym;
					vala_expression_set_symbol_reference ((ValaExpression*) _tmp116_, _tmp117_);
					_tmp118_ = ma;
					_tmp119_ = _vala_code_node_ref0 (_tmp118_);
					inner = _tmp119_;
					while (TRUE) {
						gboolean _tmp120_ = FALSE;
						ValaSymbol* _tmp121_;
						ValaSymbol* _tmp122_;
						ValaSymbol* _tmp123_;
						ValaSymbol* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaSymbol* _tmp131_;
						ValaMemberAccess* ma_inner = NULL;
						ValaSymbol* _tmp132_;
						const gchar* _tmp133_;
						const gchar* _tmp134_;
						ValaSourceReference* _tmp135_;
						ValaSourceReference* _tmp136_;
						ValaMemberAccess* _tmp137_;
						ValaMemberAccess* _tmp138_;
						ValaMemberAccess* _tmp139_;
						ValaMemberAccess* _tmp140_;
						ValaMemberAccess* _tmp141_;
						_tmp121_ = sym;
						_tmp122_ = vala_symbol_get_parent_symbol (_tmp121_);
						_tmp123_ = _tmp122_;
						if (_tmp123_ != NULL) {
							ValaSymbol* _tmp124_;
							ValaSymbol* _tmp125_;
							ValaSymbol* _tmp126_;
							ValaNamespace* _tmp127_;
							ValaNamespace* _tmp128_;
							_tmp124_ = sym;
							_tmp125_ = vala_symbol_get_parent_symbol (_tmp124_);
							_tmp126_ = _tmp125_;
							_tmp127_ = vala_code_context_get_root (context);
							_tmp128_ = _tmp127_;
							_tmp120_ = _tmp126_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp128_, VALA_TYPE_SYMBOL, ValaSymbol);
						} else {
							_tmp120_ = FALSE;
						}
						if (!_tmp120_) {
							break;
						}
						_tmp129_ = sym;
						_tmp130_ = vala_symbol_get_parent_symbol (_tmp129_);
						_tmp131_ = _tmp130_;
						sym = _tmp131_;
						_tmp132_ = sym;
						_tmp133_ = vala_symbol_get_name (_tmp132_);
						_tmp134_ = _tmp133_;
						_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp136_ = _tmp135_;
						_tmp137_ = vala_member_access_new_simple (_tmp134_, _tmp136_);
						ma_inner = _tmp137_;
						_tmp138_ = inner;
						_tmp139_ = ma_inner;
						vala_member_access_set_inner (_tmp138_, (ValaExpression*) _tmp139_);
						_tmp140_ = ma_inner;
						_tmp141_ = _vala_code_node_ref0 (_tmp140_);
						_vala_code_node_unref0 (inner);
						inner = _tmp141_;
						_vala_code_node_unref0 (ma_inner);
					}
					_tmp142_ = ma;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_object_creation_expression_new (_tmp142_, _tmp144_);
					_vala_code_node_unref0 (struct_creation);
					struct_creation = _tmp145_;
					_tmp146_ = struct_creation;
					_tmp147_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp148_ = _tmp147_;
					_tmp149_ = vala_data_type_copy (_tmp148_);
					_tmp150_ = _tmp149_;
					vala_expression_set_target_type ((ValaExpression*) _tmp146_, _tmp150_);
					_vala_code_node_unref0 (_tmp150_);
					_tmp151_ = struct_creation;
					vala_object_creation_expression_set_struct_creation (_tmp151_, TRUE);
					_vala_code_node_unref0 (inner);
					_vala_code_node_unref0 (ma);
				}
				_tmp152_ = st;
				_tmp153_ = vala_struct_get_fields (_tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_iterable_iterator ((ValaIterable*) _tmp154_);
				_tmp156_ = _tmp155_;
				_vala_iterable_unref0 (_tmp154_);
				field_it = _tmp156_;
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp157_;
					gint _e_size = 0;
					ValaList* _tmp158_;
					gint _tmp159_;
					gint _tmp160_;
					gint _e_index = 0;
					_tmp157_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp157_;
					_tmp158_ = _e_list;
					_tmp159_ = vala_collection_get_size ((ValaCollection*) _tmp158_);
					_tmp160_ = _tmp159_;
					_e_size = _tmp160_;
					_e_index = -1;
					while (TRUE) {
						ValaExpression* e = NULL;
						ValaList* _tmp161_;
						gpointer _tmp162_;
						ValaField* field = NULL;
						_e_index = _e_index + 1;
						if (!(_e_index < _e_size)) {
							break;
						}
						_tmp161_ = _e_list;
						_tmp162_ = vala_list_get (_tmp161_, _e_index);
						e = (ValaExpression*) _tmp162_;
						field = NULL;
						while (TRUE) {
							ValaField* _tmp163_;
							ValaIterator* _tmp164_;
							ValaIterator* _tmp174_;
							gpointer _tmp175_;
							ValaField* _tmp176_;
							ValaMemberBinding _tmp177_;
							ValaMemberBinding _tmp178_;
							_tmp163_ = field;
							if (!(_tmp163_ == NULL)) {
								break;
							}
							_tmp164_ = field_it;
							if (!vala_iterator_next (_tmp164_)) {
								ValaExpression* _tmp165_;
								ValaSourceReference* _tmp166_;
								ValaSourceReference* _tmp167_;
								ValaDataType* _tmp168_;
								ValaDataType* _tmp169_;
								gchar* _tmp170_;
								gchar* _tmp171_;
								gchar* _tmp172_;
								gchar* _tmp173_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp165_ = e;
								_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp165_);
								_tmp167_ = _tmp166_;
								_tmp168_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp169_ = _tmp168_;
								_tmp170_ = vala_code_node_to_string ((ValaCodeNode*) _tmp169_);
								_tmp171_ = _tmp170_;
								_tmp172_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp171_);
								_tmp173_ = _tmp172_;
								vala_report_error (_tmp167_, _tmp173_);
								_g_free0 (_tmp173_);
								_g_free0 (_tmp171_);
								result = FALSE;
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (e);
								_vala_iterable_unref0 (_e_list);
								_vala_iterator_unref0 (field_it);
								_vala_code_node_unref0 (struct_creation);
								_vala_code_node_unref0 (st);
								return result;
							}
							_tmp174_ = field_it;
							_tmp175_ = vala_iterator_get (_tmp174_);
							_vala_code_node_unref0 (field);
							field = (ValaField*) _tmp175_;
							_tmp176_ = field;
							_tmp177_ = vala_field_get_binding (_tmp176_);
							_tmp178_ = _tmp177_;
							if (_tmp178_ != VALA_MEMBER_BINDING_INSTANCE) {
								_vala_code_node_unref0 (field);
								field = NULL;
							}
						}
						if (in_array_creation_initializer) {
							ValaMemberInitializer* member_init = NULL;
							ValaField* _tmp179_;
							const gchar* _tmp180_;
							const gchar* _tmp181_;
							ValaExpression* _tmp182_;
							ValaExpression* _tmp183_;
							ValaSourceReference* _tmp184_;
							ValaSourceReference* _tmp185_;
							ValaMemberInitializer* _tmp186_;
							ValaObjectCreationExpression* _tmp187_;
							ValaMemberInitializer* _tmp188_;
							_tmp179_ = field;
							_tmp180_ = vala_symbol_get_name ((ValaSymbol*) _tmp179_);
							_tmp181_ = _tmp180_;
							_tmp182_ = e;
							_tmp183_ = e;
							_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
							_tmp185_ = _tmp184_;
							_tmp186_ = vala_member_initializer_new (_tmp181_, _tmp182_, _tmp185_);
							member_init = _tmp186_;
							_tmp187_ = struct_creation;
							_tmp188_ = member_init;
							vala_object_creation_expression_add_member_initializer (_tmp187_, _tmp188_);
							_vala_code_node_unref0 (member_init);
						} else {
							ValaExpression* _tmp189_;
							ValaField* _tmp190_;
							ValaDataType* _tmp191_;
							ValaDataType* _tmp192_;
							ValaDataType* _tmp193_;
							ValaDataType* _tmp194_;
							ValaDataType* _tmp195_;
							ValaDataType* _tmp196_;
							gboolean _tmp197_;
							gboolean _tmp198_;
							_tmp189_ = e;
							_tmp190_ = field;
							_tmp191_ = vala_variable_get_variable_type ((ValaVariable*) _tmp190_);
							_tmp192_ = _tmp191_;
							_tmp193_ = vala_data_type_copy (_tmp192_);
							_tmp194_ = _tmp193_;
							vala_expression_set_target_type (_tmp189_, _tmp194_);
							_vala_code_node_unref0 (_tmp194_);
							_tmp195_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp196_ = _tmp195_;
							_tmp197_ = vala_data_type_get_value_owned (_tmp196_);
							_tmp198_ = _tmp197_;
							if (!_tmp198_) {
								ValaExpression* _tmp199_;
								ValaDataType* _tmp200_;
								ValaDataType* _tmp201_;
								_tmp199_ = e;
								_tmp200_ = vala_expression_get_target_type (_tmp199_);
								_tmp201_ = _tmp200_;
								vala_data_type_set_value_owned (_tmp201_, FALSE);
							}
						}
						_vala_code_node_unref0 (field);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				if (in_array_creation_initializer) {
					ValaCodeNode* _tmp202_;
					ValaCodeNode* _tmp203_;
					ValaObjectCreationExpression* _tmp204_;
					ValaObjectCreationExpression* _tmp205_;
					_tmp202_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp203_ = _tmp202_;
					_tmp204_ = struct_creation;
					vala_code_node_replace_expression (_tmp203_, (ValaExpression*) self, (ValaExpression*) _tmp204_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					_tmp205_ = struct_creation;
					result = vala_code_node_check ((ValaCodeNode*) _tmp205_, context);
					_vala_iterator_unref0 (field_it);
					_vala_code_node_unref0 (struct_creation);
					_vala_code_node_unref0 (st);
					return result;
				}
				_vala_iterator_unref0 (field_it);
				_vala_code_node_unref0 (struct_creation);
				_vala_code_node_unref0 (st);
			} else {
				ValaSourceReference* _tmp206_;
				ValaSourceReference* _tmp207_;
				ValaDataType* _tmp208_;
				ValaDataType* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp207_ = _tmp206_;
				_tmp208_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp209_ = _tmp208_;
				_tmp210_ = vala_code_node_to_string ((ValaCodeNode*) _tmp209_);
				_tmp211_ = _tmp210_;
				_tmp212_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp211_);
				_tmp213_ = _tmp212_;
				vala_report_error (_tmp207_, _tmp213_);
				_g_free0 (_tmp213_);
				_g_free0 (_tmp211_);
				result = FALSE;
				return result;
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp214_;
		ValaList* _tmp215_;
		gint _expr_size = 0;
		ValaList* _tmp216_;
		gint _tmp217_;
		gint _tmp218_;
		gint _expr_index = 0;
		_tmp214_ = self->priv->initializers;
		_tmp215_ = _vala_iterable_ref0 (_tmp214_);
		_expr_list = _tmp215_;
		_tmp216_ = _expr_list;
		_tmp217_ = vala_collection_get_size ((ValaCollection*) _tmp216_);
		_tmp218_ = _tmp217_;
		_expr_size = _tmp218_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp219_;
			gpointer _tmp220_;
			ValaExpression* _tmp221_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp219_ = _expr_list;
			_tmp220_ = vala_list_get (_tmp219_, _expr_index);
			expr = (ValaExpression*) _tmp220_;
			_tmp221_ = expr;
			vala_code_node_check ((ValaCodeNode*) _tmp221_, context);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_error_ = FALSE;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp222_;
		gint _e_size = 0;
		ValaList* _tmp223_;
		gint _tmp224_;
		gint _tmp225_;
		gint _e_index = 0;
		_tmp222_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp222_;
		_tmp223_ = _e_list;
		_tmp224_ = vala_collection_get_size ((ValaCollection*) _tmp223_);
		_tmp225_ = _tmp224_;
		_e_size = _tmp225_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp226_;
			gpointer _tmp227_;
			ValaExpression* _tmp228_;
			ValaDataType* _tmp229_;
			ValaDataType* _tmp230_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp234_;
			ValaUnaryExpression* _tmp235_;
			gboolean _tmp236_ = FALSE;
			ValaUnaryExpression* _tmp237_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp226_ = _e_list;
			_tmp227_ = vala_list_get (_tmp226_, _e_index);
			e = (ValaExpression*) _tmp227_;
			_tmp228_ = e;
			_tmp229_ = vala_expression_get_value_type (_tmp228_);
			_tmp230_ = _tmp229_;
			if (_tmp230_ == NULL) {
				ValaExpression* _tmp231_;
				ValaSourceReference* _tmp232_;
				ValaSourceReference* _tmp233_;
				_error_ = TRUE;
				_tmp231_ = e;
				_tmp232_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp231_);
				_tmp233_ = _tmp232_;
				vala_report_error (_tmp233_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp234_ = e;
			_tmp235_ = _vala_code_node_ref0 (VALA_IS_UNARY_EXPRESSION (_tmp234_) ? ((ValaUnaryExpression*) _tmp234_) : NULL);
			unary = _tmp235_;
			_tmp237_ = unary;
			if (_tmp237_ != NULL) {
				gboolean _tmp238_ = FALSE;
				ValaUnaryExpression* _tmp239_;
				ValaUnaryOperator _tmp240_;
				ValaUnaryOperator _tmp241_;
				_tmp239_ = unary;
				_tmp240_ = vala_unary_expression_get_operator (_tmp239_);
				_tmp241_ = _tmp240_;
				if (_tmp241_ == VALA_UNARY_OPERATOR_REF) {
					_tmp238_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp242_;
					ValaUnaryOperator _tmp243_;
					ValaUnaryOperator _tmp244_;
					_tmp242_ = unary;
					_tmp243_ = vala_unary_expression_get_operator (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp238_ = _tmp244_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp236_ = _tmp238_;
			} else {
				_tmp236_ = FALSE;
			}
			if (_tmp236_) {
			} else {
				ValaExpression* _tmp245_;
				ValaDataType* _tmp246_;
				ValaDataType* _tmp247_;
				ValaExpression* _tmp248_;
				ValaDataType* _tmp249_;
				ValaDataType* _tmp250_;
				_tmp245_ = e;
				_tmp246_ = vala_expression_get_value_type (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp248_ = e;
				_tmp249_ = vala_expression_get_target_type (_tmp248_);
				_tmp250_ = _tmp249_;
				if (!vala_data_type_compatible (_tmp247_, _tmp250_)) {
					ValaExpression* _tmp251_;
					ValaExpression* _tmp252_;
					ValaSourceReference* _tmp253_;
					ValaSourceReference* _tmp254_;
					ValaExpression* _tmp255_;
					ValaDataType* _tmp256_;
					ValaDataType* _tmp257_;
					gchar* _tmp258_;
					gchar* _tmp259_;
					ValaExpression* _tmp260_;
					ValaDataType* _tmp261_;
					ValaDataType* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					gchar* _tmp265_;
					gchar* _tmp266_;
					_error_ = TRUE;
					_tmp251_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp251_, TRUE);
					_tmp252_ = e;
					_tmp253_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp252_);
					_tmp254_ = _tmp253_;
					_tmp255_ = e;
					_tmp256_ = vala_expression_get_target_type (_tmp255_);
					_tmp257_ = _tmp256_;
					_tmp258_ = vala_code_node_to_string ((ValaCodeNode*) _tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = e;
					_tmp261_ = vala_expression_get_value_type (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp263_ = vala_code_node_to_string ((ValaCodeNode*) _tmp262_);
					_tmp264_ = _tmp263_;
					_tmp265_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp259_, _tmp264_);
					_tmp266_ = _tmp265_;
					vala_report_error (_tmp254_, _tmp266_);
					_g_free0 (_tmp266_);
					_g_free0 (_tmp264_);
					_g_free0 (_tmp259_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	if (!_error_) {
		ValaDataType* _tmp267_;
		ValaDataType* _tmp268_;
		ValaDataType* _tmp269_;
		ValaDataType* _tmp270_;
		ValaDataType* _tmp271_;
		ValaDataType* _tmp272_;
		_tmp267_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp268_ = _tmp267_;
		_tmp269_ = vala_data_type_copy (_tmp268_);
		_tmp270_ = _tmp269_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp270_);
		_vala_code_node_unref0 (_tmp270_);
		_tmp271_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp272_ = _tmp271_;
		vala_data_type_set_nullable (_tmp272_, FALSE);
	}
	_tmp273_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp274_ = _tmp273_;
	if (_tmp274_ != NULL) {
		ValaDataType* _tmp275_;
		ValaDataType* _tmp276_;
		_tmp275_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp276_ = _tmp275_;
		vala_code_node_check ((ValaCodeNode*) _tmp276_, context);
	}
	result = !_error_;
	return result;
}

static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
vala_initializer_list_class_init (ValaInitializerListClass * klass,
                                  gpointer klass_data)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInitializerList_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}

static void
vala_initializer_list_instance_init (ValaInitializerList * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_initializer_list_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}

static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}

/**
 * Represents an array or struct initializer list in the source code.
 */
GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		ValaInitializerList_private_offset = g_type_add_instance_private (vala_initializer_list_type_id, sizeof (ValaInitializerListPrivate));
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}

