/* valaccodewriter.c generated by valac, the Vala compiler
 * generated from valaccodewriter.vala, do not modify */

/* valaccodewriter.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccode.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <vala.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <utime.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _ValaParamSpecCCodeWriter ValaParamSpecCCodeWriter;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaCCodeWriterPrivate {
	gchar* _filename;
	gchar* source_filename;
	gboolean _line_directives;
	gchar* temp_filename;
	gboolean file_exists;
	FILE* stream;
	gint indent;
	gint current_line_number;
	gboolean using_line_directive;
	gboolean _bol;
	gboolean _bael;
};

struct _ValaParamSpecCCodeWriter {
	GParamSpec parent_instance;
};

static gint ValaCCodeWriter_private_offset;
static gpointer vala_ccode_writer_parent_class = NULL;
static GRegex* vala_ccode_writer_fix_indent_regex;
static GRegex* vala_ccode_writer_fix_indent_regex = NULL;

static void vala_ccode_writer_finalize (ValaCCodeWriter * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_ccode_writer_get_instance_private (ValaCCodeWriter* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCCodeWriter_private_offset);
}

ValaCCodeWriter*
vala_ccode_writer_construct (GType object_type,
                             const gchar* filename,
                             const gchar* source_filename)
{
	ValaCCodeWriter* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ValaCCodeWriter*) g_type_create_instance (object_type);
	vala_ccode_writer_set_filename (self, filename);
	_tmp0_ = g_strdup (source_filename);
	_g_free0 (self->priv->source_filename);
	self->priv->source_filename = _tmp0_;
	return self;
}

ValaCCodeWriter*
vala_ccode_writer_new (const gchar* filename,
                       const gchar* source_filename)
{
	return vala_ccode_writer_construct (VALA_TYPE_CCODE_WRITER, filename, source_filename);
}

/**
 * Opens the file.
 *
 * @return true if the file has been opened successfully,
 *         false otherwise
 */
gboolean
vala_ccode_writer_open (ValaCCodeWriter* self,
                        gboolean write_version)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	FILE* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* opening = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_filename;
	self->priv->file_exists = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	if (self->priv->file_exists) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		FILE* _tmp4_;
		_tmp1_ = self->priv->_filename;
		_tmp2_ = g_strdup_printf ("%s.valatmp", _tmp1_);
		_g_free0 (self->priv->temp_filename);
		self->priv->temp_filename = _tmp2_;
		_tmp3_ = self->priv->temp_filename;
		_tmp4_ = g_fopen (_tmp3_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp4_;
	} else {
		gchar* dirname = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		FILE* _tmp9_;
		_tmp5_ = self->priv->_filename;
		_tmp6_ = g_path_get_dirname (_tmp5_);
		dirname = _tmp6_;
		_tmp7_ = dirname;
		g_mkdir_with_parents (_tmp7_, 0755);
		_tmp8_ = self->priv->_filename;
		_tmp9_ = g_fopen (_tmp8_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp9_;
		_g_free0 (dirname);
	}
	_tmp10_ = self->priv->stream;
	if (_tmp10_ == NULL) {
		result = FALSE;
		return result;
	}
	if (write_version) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = self->priv->_filename;
		_tmp13_ = g_path_get_basename (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("/* %s generated by valac %s, the Vala compiler", _tmp14_, VALA_BUILD_VERSION);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp15_;
		_g_free0 (_tmp14_);
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = self->priv->_filename;
		_tmp17_ = g_path_get_basename (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("/* %s generated by valac, the Vala compiler", _tmp18_);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp19_;
		_g_free0 (_tmp18_);
	}
	_tmp20_ = g_strdup (_tmp11_);
	opening = _tmp20_;
	_tmp21_ = opening;
	vala_ccode_writer_write_string (self, _tmp21_);
	_tmp22_ = self->priv->source_filename;
	if (_tmp22_ != NULL) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		vala_ccode_writer_write_newline (self);
		_tmp23_ = self->priv->source_filename;
		_tmp24_ = g_path_get_basename (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf (" * generated from %s", _tmp25_);
		_tmp27_ = _tmp26_;
		vala_ccode_writer_write_string (self, _tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
	}
	vala_ccode_writer_write_string (self, ", do not modify */");
	vala_ccode_writer_write_newline (self);
	vala_ccode_writer_write_newline (self);
	result = TRUE;
	_g_free0 (opening);
	_g_free0 (_tmp11_);
	return result;
}

/**
 * Closes the file.
 */
void
vala_ccode_writer_close (ValaCCodeWriter* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
	if (self->priv->file_exists) {
		gboolean changed = FALSE;
		changed = TRUE;
		{
			GMappedFile* old_file = NULL;
			const gchar* _tmp0_;
			GMappedFile* _tmp1_;
			GMappedFile* new_file = NULL;
			const gchar* _tmp2_;
			GMappedFile* _tmp3_;
			gsize len = 0UL;
			GMappedFile* _tmp4_;
			GMappedFile* _tmp5_;
			_tmp0_ = self->priv->_filename;
			_tmp1_ = g_mapped_file_new (_tmp0_, FALSE, &_inner_error0_);
			old_file = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp2_ = self->priv->temp_filename;
			_tmp3_ = g_mapped_file_new (_tmp2_, FALSE, &_inner_error0_);
			new_file = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_mapped_file_unref0 (old_file);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_mapped_file_unref0 (old_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp4_ = old_file;
			len = g_mapped_file_get_length (_tmp4_);
			_tmp5_ = new_file;
			if (len == g_mapped_file_get_length (_tmp5_)) {
				GMappedFile* _tmp6_;
				gchar* _tmp7_;
				GMappedFile* _tmp8_;
				gchar* _tmp9_;
				_tmp6_ = old_file;
				_tmp7_ = g_mapped_file_get_contents (_tmp6_);
				_tmp8_ = new_file;
				_tmp9_ = g_mapped_file_get_contents (_tmp8_);
				if (memcmp (_tmp7_, _tmp9_, len) == 0) {
					changed = FALSE;
				}
			}
			_g_mapped_file_unref0 (old_file);
			old_file = NULL;
			_g_mapped_file_unref0 (new_file);
			new_file = NULL;
			_g_mapped_file_unref0 (new_file);
			_g_mapped_file_unref0 (old_file);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (changed) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->priv->temp_filename;
			_tmp11_ = self->priv->_filename;
			g_rename (_tmp10_, _tmp11_);
		} else {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = self->priv->temp_filename;
			g_unlink (_tmp12_);
			_tmp13_ = self->priv->source_filename;
			if (_tmp13_ != NULL) {
				struct stat stats = {0};
				const gchar* _tmp14_;
				struct stat target_stats = {0};
				const gchar* _tmp15_;
				struct stat _tmp16_;
				struct stat _tmp17_;
				_tmp14_ = self->priv->source_filename;
				g_stat (_tmp14_, &stats);
				_tmp15_ = self->priv->_filename;
				g_stat (_tmp15_, &target_stats);
				_tmp16_ = stats;
				_tmp17_ = target_stats;
				if (_tmp16_.st_mtime >= _tmp17_.st_mtime) {
					struct utimbuf timebuf = {0};
					struct stat _tmp18_;
					struct stat _tmp19_;
					struct utimbuf _tmp20_ = {0};
					const gchar* _tmp21_;
					struct utimbuf _tmp22_;
					_tmp18_ = stats;
					_tmp19_ = stats;
					_tmp20_.actime = _tmp18_.st_atime + 1;
					_tmp20_.modtime = _tmp19_.st_mtime + 1;
					timebuf = _tmp20_;
					_tmp21_ = self->priv->_filename;
					_tmp22_ = timebuf;
					g_utime (_tmp21_, &_tmp22_);
				}
			}
		}
	}
}

/**
 * Writes tabs according to the current indent level.
 */
void
vala_ccode_writer_write_indent (ValaCCodeWriter* self,
                                ValaCCodeLineDirective* line)
{
	gboolean _tmp0_;
	FILE* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_line_directives;
	if (_tmp0_) {
		if (line != NULL) {
			vala_ccode_node_write ((ValaCCodeNode*) line, self);
			self->priv->using_line_directive = TRUE;
		} else {
			if (self->priv->using_line_directive) {
				const gchar* _tmp1_;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp1_ = self->priv->_filename;
				_tmp2_ = g_path_get_basename (_tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strdup_printf ("#line %d \"%s\"", self->priv->current_line_number + 1, _tmp3_);
				_tmp5_ = _tmp4_;
				vala_ccode_writer_write_string (self, _tmp5_);
				_g_free0 (_tmp5_);
				_g_free0 (_tmp3_);
				vala_ccode_writer_write_newline (self);
				self->priv->using_line_directive = FALSE;
			}
		}
	}
	if (!self->priv->_bol) {
		vala_ccode_writer_write_newline (self);
	}
	_tmp6_ = self->priv->stream;
	_tmp7_ = g_strnfill ((gsize) self->priv->indent, '\t');
	_tmp8_ = _tmp7_;
	fputs (_tmp8_, _tmp6_);
	_g_free0 (_tmp8_);
	self->priv->_bol = FALSE;
}

/**
 * Writes n spaces.
 */
void
vala_ccode_writer_write_nspaces (ValaCCodeWriter* self,
                                 guint n)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stream;
	_tmp1_ = g_strnfill ((gsize) n, ' ');
	_tmp2_ = _tmp1_;
	fputs (_tmp2_, _tmp0_);
	_g_free0 (_tmp2_);
}

/**
 * Writes the specified string.
 *
 * @param s a string
 */
void
vala_ccode_writer_write_string (ValaCCodeWriter* self,
                                const gchar* s)
{
	FILE* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->stream;
	fputs (s, _tmp0_);
	self->priv->_bol = FALSE;
}

/**
 * Writes a newline.
 */
void
vala_ccode_writer_write_newline (ValaCCodeWriter* self)
{
	FILE* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_bol) {
		self->priv->_bael = FALSE;
	} else {
		if (!self->priv->_bael) {
			self->priv->_bael = TRUE;
		} else {
			return;
		}
	}
	_tmp0_ = self->priv->stream;
	fputc ('\n', _tmp0_);
	_tmp1_ = self->priv->current_line_number;
	self->priv->current_line_number = _tmp1_ + 1;
	self->priv->_bol = TRUE;
}

/**
 * Opens a new block, increasing the indent level.
 */
void
vala_ccode_writer_write_begin_block (ValaCCodeWriter* self)
{
	FILE* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_bol) {
		FILE* _tmp0_;
		_tmp0_ = self->priv->stream;
		fputc (' ', _tmp0_);
	} else {
		vala_ccode_writer_write_indent (self, NULL);
	}
	_tmp1_ = self->priv->stream;
	fputc ('{', _tmp1_);
	vala_ccode_writer_write_newline (self);
	_tmp2_ = self->priv->indent;
	self->priv->indent = _tmp2_ + 1;
}

/**
 * Closes the current block, decreasing the indent level.
 */
void
vala_ccode_writer_write_end_block (ValaCCodeWriter* self)
{
	gint _tmp0_;
	FILE* _tmp1_;
	g_return_if_fail (self != NULL);
	_vala_assert (self->priv->indent > 0, "indent > 0");
	_tmp0_ = self->priv->indent;
	self->priv->indent = _tmp0_ - 1;
	vala_ccode_writer_write_indent (self, NULL);
	_tmp1_ = self->priv->stream;
	fputc ('}', _tmp1_);
}

/**
 * Writes the specified text as comment.
 *
 * @param text the comment text
 */
void
vala_ccode_writer_write_comment (ValaCCodeWriter* self,
                                 const gchar* text)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	{
		FILE* _tmp0_;
		gboolean first = FALSE;
		GRegex* _tmp1_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		FILE* _tmp23_;
		vala_ccode_writer_write_indent (self, NULL);
		_tmp0_ = self->priv->stream;
		fputs ("/*", _tmp0_);
		first = TRUE;
		_tmp1_ = vala_ccode_writer_fix_indent_regex;
		if (_tmp1_ == NULL) {
			GRegex* _tmp2_ = NULL;
			GRegex* _tmp3_;
			GRegex* _tmp4_;
			_tmp3_ = g_regex_new ("^\t+", 0, 0, &_inner_error0_);
			_tmp2_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch1_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp4_ = _tmp2_;
			_tmp2_ = NULL;
			_g_regex_unref0 (vala_ccode_writer_fix_indent_regex);
			vala_ccode_writer_fix_indent_regex = _tmp4_;
			_g_regex_unref0 (_tmp2_);
		}
		_tmp6_ = _tmp5_ = g_strsplit (text, "\n", 0);
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp6_;
			line_collection_length1 = _vala_array_length (_tmp5_);
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				const gchar* line = NULL;
				line = line_collection[line_it];
				{
					gchar* _tmp7_ = NULL;
					GRegex* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar** lineparts = NULL;
					gchar** _tmp11_;
					gchar** _tmp12_;
					gint lineparts_length1;
					gint _lineparts_size_;
					if (!first) {
						vala_ccode_writer_write_indent (self, NULL);
					} else {
						first = FALSE;
					}
					_tmp8_ = vala_ccode_writer_fix_indent_regex;
					_tmp9_ = line;
					_tmp10_ = g_regex_replace_literal (_tmp8_, _tmp9_, (gssize) -1, 0, "", 0, &_inner_error0_);
					_tmp7_ = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch1_g_regex_error;
						}
						line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp12_ = _tmp11_ = g_strsplit (_tmp7_, "*/", 0);
					lineparts = _tmp12_;
					lineparts_length1 = _vala_array_length (_tmp11_);
					_lineparts_size_ = lineparts_length1;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp13_ = FALSE;
							_tmp13_ = TRUE;
							while (TRUE) {
								gchar** _tmp15_;
								gint _tmp15__length1;
								const gchar* _tmp16_;
								FILE* _tmp17_;
								gchar** _tmp18_;
								gint _tmp18__length1;
								const gchar* _tmp19_;
								gchar** _tmp20_;
								gint _tmp20__length1;
								const gchar* _tmp21_;
								if (!_tmp13_) {
									gint _tmp14_;
									_tmp14_ = i;
									i = _tmp14_ + 1;
								}
								_tmp13_ = FALSE;
								_tmp15_ = lineparts;
								_tmp15__length1 = lineparts_length1;
								_tmp16_ = _tmp15_[i];
								if (!(_tmp16_ != NULL)) {
									break;
								}
								_tmp17_ = self->priv->stream;
								_tmp18_ = lineparts;
								_tmp18__length1 = lineparts_length1;
								_tmp19_ = _tmp18_[i];
								fputs (_tmp19_, _tmp17_);
								_tmp20_ = lineparts;
								_tmp20__length1 = lineparts_length1;
								_tmp21_ = _tmp20_[i + 1];
								if (_tmp21_ != NULL) {
									FILE* _tmp22_;
									_tmp22_ = self->priv->stream;
									fputs ("* /", _tmp22_);
								}
							}
						}
					}
					lineparts = (_vala_array_free (lineparts, lineparts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp7_);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp23_ = self->priv->stream;
		fputs ("*/", _tmp23_);
		vala_ccode_writer_write_newline (self);
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

const gchar*
vala_ccode_writer_get_filename (ValaCCodeWriter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

void
vala_ccode_writer_set_filename (ValaCCodeWriter* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
}

gboolean
vala_ccode_writer_get_line_directives (ValaCCodeWriter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_line_directives;
	return result;
}

void
vala_ccode_writer_set_line_directives (ValaCCodeWriter* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_line_directives = value;
}

gboolean
vala_ccode_writer_get_bol (ValaCCodeWriter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_bol;
	return result;
}

static void
vala_value_ccode_writer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_ccode_writer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_ccode_writer_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_ccode_writer_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_ccode_writer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_ccode_writer_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCCodeWriter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_ccode_writer_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	ValaCCodeWriter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_ccode_writer (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ValaParamSpecCCodeWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_ccode_writer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_WRITER), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_ccode_writer (GValue* value,
                             gpointer v_object)
{
	ValaCCodeWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_writer_unref (old);
	}
}

void
vala_value_take_ccode_writer (GValue* value,
                              gpointer v_object)
{
	ValaCCodeWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_writer_unref (old);
	}
}

static void
vala_ccode_writer_class_init (ValaCCodeWriterClass * klass,
                              gpointer klass_data)
{
	vala_ccode_writer_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeWriterClass *) klass)->finalize = vala_ccode_writer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCCodeWriter_private_offset);
}

static void
vala_ccode_writer_instance_init (ValaCCodeWriter * self,
                                 gpointer klass)
{
	self->priv = vala_ccode_writer_get_instance_private (self);
	self->priv->current_line_number = 1;
	self->priv->_bol = TRUE;
	self->priv->_bael = FALSE;
	self->ref_count = 1;
}

static void
vala_ccode_writer_finalize (ValaCCodeWriter * obj)
{
	ValaCCodeWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_WRITER, ValaCCodeWriter);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->source_filename);
	_g_free0 (self->priv->temp_filename);
	_fclose0 (self->priv->stream);
}

/**
 * Represents a writer to write C source files.
 */
GType
vala_ccode_writer_get_type (void)
{
	static volatile gsize vala_ccode_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_writer_init, vala_value_ccode_writer_free_value, vala_value_ccode_writer_copy_value, vala_value_ccode_writer_peek_pointer, "p", vala_value_ccode_writer_collect_value, "p", vala_value_ccode_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeWriter), 0, (GInstanceInitFunc) vala_ccode_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_writer_type_id;
		vala_ccode_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValaCCodeWriter_private_offset = g_type_add_instance_private (vala_ccode_writer_type_id, sizeof (ValaCCodeWriterPrivate));
		g_once_init_leave (&vala_ccode_writer_type_id__volatile, vala_ccode_writer_type_id);
	}
	return vala_ccode_writer_type_id__volatile;
}

gpointer
vala_ccode_writer_ref (gpointer instance)
{
	ValaCCodeWriter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_ccode_writer_unref (gpointer instance)
{
	ValaCCodeWriter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

