/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;

static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp7_ = _expr_list;
			_tmp8_ = vala_list_get (_tmp7_, _expr_index);
			expr = (ValaExpression*) _tmp8_;
			_tmp9_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp15_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp16_;
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = method_type;
			_tmp17_ = vala_method_type_get_method_symbol (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "GLib.NC_") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				gboolean _tmp22_ = FALSE;
				ValaList* _tmp23_;
				gpointer _tmp24_;
				ValaExpression* _tmp25_;
				gboolean _tmp26_;
				_tmp23_ = self->priv->argument_list;
				_tmp24_ = vala_list_get (_tmp23_, 0);
				_tmp25_ = (ValaExpression*) _tmp24_;
				_tmp26_ = vala_expression_is_constant (_tmp25_);
				_vala_code_node_unref0 (_tmp25_);
				if (_tmp26_) {
					ValaList* _tmp27_;
					gpointer _tmp28_;
					ValaExpression* _tmp29_;
					_tmp27_ = self->priv->argument_list;
					_tmp28_ = vala_list_get (_tmp27_, 1);
					_tmp29_ = (ValaExpression*) _tmp28_;
					_tmp22_ = vala_expression_is_constant (_tmp29_);
					_vala_code_node_unref0 (_tmp29_);
				} else {
					_tmp22_ = FALSE;
				}
				result = _tmp22_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp8_ = vala_method_call_get_call (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_accessible (_tmp9_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (_tmp5_);
	mtype = _tmp6_;
	_tmp7_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaMethod* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		ValaMethod* _tmp15_;
		_tmp8_ = mtype;
		_tmp9_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		m = _tmp11_;
		_tmp15_ = m;
		if (_tmp15_ != NULL) {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = m;
			_tmp17_ = vala_method_get_coroutine (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gboolean _tmp19_;
			_tmp19_ = self->priv->_is_yield_expression;
			_tmp13_ = !_tmp19_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp20_ = vala_method_call_get_call (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp23_ = _tmp22_;
			_tmp12_ = g_strcmp0 (_tmp23_, "end") != 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			ValaMethod* _tmp24_;
			_tmp24_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp24_, collection, source_reference);
		}
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp25_;
		_tmp25_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_OBJECT_TYPE)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp26_;
			ValaObjectTypeSymbol* _tmp27_;
			ValaObjectTypeSymbol* _tmp28_;
			ValaClass* _tmp29_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp30_;
			ValaCreationMethod* _tmp31_;
			ValaCreationMethod* _tmp32_;
			ValaCreationMethod* _tmp33_;
			ValaCreationMethod* _tmp34_;
			_tmp26_ = mtype;
			_tmp27_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp28_ = _tmp27_;
			_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp29_;
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_default_construction_method (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = _vala_code_node_ref0 (_tmp32_);
			m = _tmp33_;
			_tmp34_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp34_, collection, source_reference);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp35_;
			_tmp35_ = mtype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp36_;
				ValaDelegate* _tmp37_;
				ValaDelegate* _tmp38_;
				ValaDelegate* _tmp39_;
				ValaDelegate* _tmp40_;
				_tmp36_ = mtype;
				_tmp37_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp38_ = _tmp37_;
				_tmp39_ = _vala_code_node_ref0 (_tmp38_);
				d = _tmp39_;
				_tmp40_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp40_, collection, source_reference);
				_vala_code_node_unref0 (d);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp41_;
		ValaList* _tmp42_;
		gint _expr_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _expr_index = 0;
		_tmp41_ = self->priv->argument_list;
		_tmp42_ = _vala_iterable_ref0 (_tmp41_);
		_expr_list = _tmp42_;
		_tmp43_ = _expr_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_expr_size = _tmp45_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaExpression* _tmp48_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp46_ = _expr_list;
			_tmp47_ = vala_list_get (_tmp46_, _expr_index);
			expr = (ValaExpression*) _tmp47_;
			_tmp48_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp48_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_vala_code_node_unref0 (mtype);
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp108_;
	ValaExpression* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	gboolean _tmp113_ = FALSE;
	ValaProfile _tmp114_;
	ValaProfile _tmp115_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp145_;
	gboolean _tmp238_ = FALSE;
	ValaExpression* _tmp239_;
	ValaExpression* _tmp240_;
	gboolean _tmp310_ = FALSE;
	gboolean _tmp311_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp326_;
	ValaDataType* _tmp327_;
	ValaList* params = NULL;
	ValaDataType* _tmp328_;
	ValaList* _tmp329_;
	ValaDataType* _tmp330_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp397_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp398_;
	ValaIterator* _tmp399_;
	gboolean _tmp448_ = FALSE;
	ValaDataType* _tmp449_;
	gboolean _tmp469_ = FALSE;
	ValaDataType* _tmp470_;
	gboolean force_lambda_method_closure = FALSE;
	ValaDataType* _tmp561_;
	ValaDataType* _tmp572_;
	ValaDataType* _tmp573_;
	ValaDataType* _tmp574_;
	ValaDataType* _tmp575_;
	ValaDataType* _tmp576_;
	ValaDataType* _tmp577_;
	ValaList* _tmp578_;
	ValaDataType* _tmp579_;
	ValaDataType* _tmp580_;
	ValaDataType* _tmp581_;
	ValaSemanticAnalyzer* _tmp820_;
	ValaSemanticAnalyzer* _tmp821_;
	ValaDataType* _tmp822_;
	ValaList* _tmp823_;
	ValaList* _tmp824_;
	ValaList* _tmp825_;
	gboolean _tmp826_;
	gboolean _tmp851_ = FALSE;
	gboolean _tmp852_ = FALSE;
	ValaCreationMethod* _tmp853_;
	ValaDataType* _tmp882_;
	ValaDataType* _tmp883_;
	gboolean _tmp884_;
	gboolean _tmp885_;
	gboolean _tmp938_;
	gboolean _tmp939_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			ValaMemberAccess* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaMemberAccess* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp91_ = FALSE;
			ValaMemberAccess* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp19_;
			_tmp20_ = ma;
			_tmp21_ = vala_member_access_get_prototype_access (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_method_call_get_call (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_expression_get_symbol_reference (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_type_arguments (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp60_;
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				ValaMethod* _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaMethod* _tmp65_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_SIGNAL)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					ValaMemberAccess* _tmp53_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp51_) : NULL);
					sig = _tmp52_;
					_tmp53_ = sig;
					if (_tmp53_ != NULL) {
						ValaMemberAccess* _tmp54_;
						ValaExpression* _tmp55_;
						ValaExpression* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						_tmp54_ = sig;
						_tmp55_ = vala_member_access_get_inner (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_expression_get_value_type (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = _vala_code_node_ref0 (_tmp58_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp59_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp60_ = ma;
				_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp62_) : NULL);
				m = _tmp63_;
				_tmp65_ = m;
				if (_tmp65_ != NULL) {
					ValaMethod* _tmp66_;
					gboolean _tmp67_;
					gboolean _tmp68_;
					_tmp66_ = m;
					_tmp67_ = vala_method_get_coroutine (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp64_ = _tmp68_;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					gboolean _tmp69_ = FALSE;
					ValaMemberAccess* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = ma;
					_tmp71_ = vala_member_access_get_member_name (_tmp70_);
					_tmp72_ = _tmp71_;
					if (g_strcmp0 (_tmp72_, "begin") == 0) {
						_tmp69_ = TRUE;
					} else {
						ValaMemberAccess* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						_tmp73_ = ma;
						_tmp74_ = vala_member_access_get_member_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp69_ = g_strcmp0 (_tmp75_, "end") == 0;
					}
					if (_tmp69_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp76_;
						ValaExpression* _tmp77_;
						ValaExpression* _tmp78_;
						ValaMemberAccess* _tmp79_;
						gboolean _tmp80_ = FALSE;
						ValaMemberAccess* _tmp81_;
						_tmp76_ = ma;
						_tmp77_ = vala_member_access_get_inner (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp78_) : NULL);
						method_access = _tmp79_;
						_tmp81_ = method_access;
						if (_tmp81_ != NULL) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp80_ = _tmp84_ != NULL;
						} else {
							_tmp80_ = FALSE;
						}
						if (_tmp80_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaDataType* _tmp88_;
							ValaDataType* _tmp89_;
							ValaDataType* _tmp90_;
							_tmp85_ = method_access;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_value_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp90_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp92_ = ma;
			_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
			_tmp94_ = _tmp93_;
			if (_tmp94_ != NULL) {
				ValaMemberAccess* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaAttribute* _tmp98_;
				_tmp95_ = ma;
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp97_, "Assert");
				_tmp91_ = _tmp98_ != NULL;
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaList* args = NULL;
				ValaList* _tmp99_;
				ValaList* _tmp100_;
				gint _tmp101_;
				gint _tmp102_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp99_ = vala_method_call_get_argument_list (self);
				args = _tmp99_;
				_tmp100_ = args;
				_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp102_ == 1) {
					ValaList* _tmp103_;
					gpointer _tmp104_;
					ValaExpression* _tmp105_;
					ValaSourceReference* _tmp106_;
					ValaSourceReference* _tmp107_;
					_tmp103_ = args;
					_tmp104_ = vala_list_get (_tmp103_, 0);
					_tmp105_ = (ValaExpression*) _tmp104_;
					_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp105_);
					_tmp107_ = _tmp106_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp107_);
					_vala_code_node_unref0 (_tmp105_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp108_ = vala_method_call_get_call (self);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_expression_get_value_type (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = _vala_code_node_ref0 (_tmp111_);
	mtype = _tmp112_;
	_tmp114_ = vala_code_context_get_profile (context);
	_tmp115_ = _tmp114_;
	if (_tmp115_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp116_;
		ValaExpression* _tmp117_;
		ValaSymbol* _tmp118_;
		ValaSymbol* _tmp119_;
		ValaSemanticAnalyzer* _tmp120_;
		ValaSemanticAnalyzer* _tmp121_;
		ValaClass* _tmp122_;
		_tmp116_ = vala_method_call_get_call (self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_expression_get_symbol_reference (_tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_code_context_get_analyzer (context);
		_tmp121_ = _tmp120_;
		_tmp122_ = _tmp121_->object_type;
		_tmp113_ = _tmp119_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp113_ = FALSE;
	}
	gobject_chainup = _tmp113_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp126_;
		ValaMemberAccess* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp139_ = FALSE;
		ValaMemberAccess* _tmp140_;
		_tmp123_ = vala_method_call_get_call (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = _vala_code_node_ref0 (_tmp124_);
		expr = _tmp125_;
		_tmp126_ = expr;
		_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp126_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp126_) : NULL);
		ma = _tmp127_;
		_tmp129_ = ma;
		if (_tmp129_ != NULL) {
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp132_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaMemberAccess* _tmp138_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = _vala_code_node_ref0 (_tmp135_);
			_vala_code_node_unref0 (expr);
			expr = _tmp136_;
			_tmp137_ = expr;
			_tmp138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp137_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp138_;
		}
		_tmp140_ = ma;
		if (_tmp140_ != NULL) {
			ValaMemberAccess* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_member_access_get_member_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp139_ = g_strcmp0 (_tmp143_, "this") == 0;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp144_;
			_tmp144_ = expr;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_BASE_ACCESS)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp145_ = self->priv->_is_chainup;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp150_;
		ValaCreationMethod* _tmp158_;
		ValaDataType* _tmp159_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		_tmp149_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp148_, VALA_TYPE_CREATION_METHOD) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		if (_tmp149_ == NULL) {
			_vala_code_node_unref0 (_tmp148_);
		}
		cm = _tmp149_;
		_tmp150_ = cm;
		if (_tmp150_ == NULL) {
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp152_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp153_ = cm;
			_tmp154_ = vala_creation_method_get_chain_up (_tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp157_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp158_ = cm;
		vala_creation_method_set_chain_up (_tmp158_, TRUE);
		_tmp159_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp160_;
			ValaObjectType* _tmp161_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp162_;
			ValaObjectTypeSymbol* _tmp163_;
			ValaObjectTypeSymbol* _tmp164_;
			ValaClass* _tmp165_;
			ValaClass* _tmp166_;
			ValaCreationMethod* _tmp167_;
			ValaCreationMethod* _tmp168_;
			ValaCreationMethod* _tmp169_;
			ValaCreationMethod* _tmp170_;
			_tmp160_ = mtype;
			_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp161_;
			_tmp162_ = otype;
			_tmp163_ = vala_object_type_get_type_symbol (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp165_;
			_tmp166_ = cl;
			_tmp167_ = vala_class_get_default_construction_method (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = _vala_code_node_ref0 (_tmp168_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp169_;
			_tmp170_ = base_cm;
			if (_tmp170_ == NULL) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaClass* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = cl;
				_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strdup_printf ("chain up to `%s' not supported", _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp172_, _tmp177_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp178_;
				gboolean _tmp179_;
				gboolean _tmp180_;
				_tmp178_ = base_cm;
				_tmp179_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp178_);
				_tmp180_ = _tmp179_;
				if (!_tmp180_) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaCreationMethod* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					_tmp183_ = base_cm;
					_tmp184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = g_strdup_printf ("chain up to `%s' not supported", _tmp185_);
					_tmp187_ = _tmp186_;
					vala_report_error (_tmp182_, _tmp187_);
					_g_free0 (_tmp187_);
					_g_free0 (_tmp185_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp188_ = FALSE;
			ValaExpression* _tmp189_;
			ValaExpression* _tmp190_;
			ValaSymbol* _tmp191_;
			ValaSymbol* _tmp192_;
			_tmp189_ = vala_method_call_get_call (self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
			_tmp192_ = _tmp191_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_CREATION_METHOD)) {
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp193_ = vala_method_call_get_call (self);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_expression_get_symbol_reference (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp188_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp198_, VALA_TYPE_CLASS);
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaExpression* _tmp199_;
				ValaExpression* _tmp200_;
				ValaSymbol* _tmp201_;
				ValaSymbol* _tmp202_;
				ValaCreationMethod* _tmp203_;
				ValaCreationMethod* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp199_ = vala_method_call_get_call (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_expression_get_symbol_reference (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp203_;
				_tmp204_ = base_cm;
				_tmp205_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (!_tmp206_) {
					ValaSourceReference* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaCreationMethod* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp208_ = _tmp207_;
					_tmp209_ = base_cm;
					_tmp210_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = g_strdup_printf ("chain up to `%s' not supported", _tmp211_);
					_tmp213_ = _tmp212_;
					vala_report_error (_tmp208_, _tmp213_);
					_g_free0 (_tmp213_);
					_g_free0 (_tmp211_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp214_;
					ValaSymbol* _tmp215_;
					ValaSymbol* _tmp216_;
					ValaClass* _tmp217_;
					gboolean _tmp218_ = FALSE;
					ValaClass* _tmp219_;
					ValaExpression* _tmp226_;
					ValaExpression* _tmp227_;
					ValaSemanticAnalyzer* _tmp228_;
					ValaSemanticAnalyzer* _tmp229_;
					ValaClass* _tmp230_;
					ValaObjectType* _tmp231_;
					ValaObjectType* _tmp232_;
					ValaExpression* _tmp233_;
					ValaExpression* _tmp234_;
					ValaDataType* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					_tmp214_ = cm;
					_tmp215_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp216_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp216_) : NULL);
					cl = _tmp217_;
					_tmp219_ = cl;
					if (_tmp219_ == NULL) {
						_tmp218_ = TRUE;
					} else {
						ValaClass* _tmp220_;
						ValaSemanticAnalyzer* _tmp221_;
						ValaSemanticAnalyzer* _tmp222_;
						ValaClass* _tmp223_;
						_tmp220_ = cl;
						_tmp221_ = vala_code_context_get_analyzer (context);
						_tmp222_ = _tmp221_;
						_tmp223_ = _tmp222_->object_type;
						_tmp218_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp220_, (ValaTypeSymbol*) _tmp223_);
					}
					if (_tmp218_) {
						ValaSourceReference* _tmp224_;
						ValaSourceReference* _tmp225_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp225_ = _tmp224_;
						vala_report_error (_tmp225_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp226_ = vala_method_call_get_call (self);
					_tmp227_ = _tmp226_;
					_tmp228_ = vala_code_context_get_analyzer (context);
					_tmp229_ = _tmp228_;
					_tmp230_ = _tmp229_->object_type;
					_tmp231_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp230_);
					_tmp232_ = _tmp231_;
					vala_expression_set_value_type (_tmp227_, (ValaDataType*) _tmp232_);
					_vala_code_node_unref0 (_tmp232_);
					_tmp233_ = vala_method_call_get_call (self);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_expression_get_value_type (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (_tmp236_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp237_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp239_ = vala_method_call_get_call (self);
	_tmp240_ = _tmp239_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp240_, VALA_TYPE_MEMBER_ACCESS)) {
		gboolean _tmp241_ = FALSE;
		gboolean _tmp242_ = FALSE;
		ValaExpression* _tmp243_;
		ValaExpression* _tmp244_;
		ValaSymbol* _tmp245_;
		ValaSymbol* _tmp246_;
		_tmp243_ = vala_method_call_get_call (self);
		_tmp244_ = _tmp243_;
		_tmp245_ = vala_expression_get_symbol_reference (_tmp244_);
		_tmp246_ = _tmp245_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp246_, VALA_TYPE_CREATION_METHOD)) {
			ValaExpression* _tmp247_;
			ValaExpression* _tmp248_;
			ValaSymbol* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			_tmp247_ = vala_method_call_get_call (self);
			_tmp248_ = _tmp247_;
			_tmp249_ = vala_expression_get_symbol_reference (_tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_symbol_get_parent_symbol (_tmp250_);
			_tmp252_ = _tmp251_;
			_tmp242_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_STRUCT);
		} else {
			_tmp242_ = FALSE;
		}
		if (_tmp242_) {
			_tmp241_ = TRUE;
		} else {
			ValaExpression* _tmp253_;
			ValaExpression* _tmp254_;
			ValaSymbol* _tmp255_;
			ValaSymbol* _tmp256_;
			_tmp253_ = vala_method_call_get_call (self);
			_tmp254_ = _tmp253_;
			_tmp255_ = vala_expression_get_symbol_reference (_tmp254_);
			_tmp256_ = _tmp255_;
			_tmp241_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp256_, VALA_TYPE_STRUCT);
		}
		_tmp238_ = _tmp241_;
	} else {
		_tmp238_ = FALSE;
	}
	if (_tmp238_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp257_;
		ValaExpression* _tmp258_;
		ValaSymbol* _tmp259_;
		ValaSymbol* _tmp260_;
		ValaStruct* _tmp261_;
		gboolean _tmp262_ = FALSE;
		gboolean _tmp263_ = FALSE;
		ValaStruct* _tmp264_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp275_;
		ValaExpression* _tmp276_;
		ValaSourceReference* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaObjectCreationExpression* _tmp279_;
		ValaObjectCreationExpression* _tmp280_;
		ValaObjectCreationExpression* _tmp289_;
		ValaDataType* _tmp290_;
		ValaDataType* _tmp291_;
		ValaSemanticAnalyzer* _tmp292_;
		ValaSemanticAnalyzer* _tmp293_;
		ValaList* _tmp294_;
		ValaCodeNode* _tmp295_;
		ValaCodeNode* _tmp296_;
		ValaObjectCreationExpression* _tmp297_;
		ValaObjectCreationExpression* _tmp298_;
		_tmp257_ = vala_method_call_get_call (self);
		_tmp258_ = _tmp257_;
		_tmp259_ = vala_expression_get_symbol_reference (_tmp258_);
		_tmp260_ = _tmp259_;
		_tmp261_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp260_) : NULL);
		st = _tmp261_;
		_tmp264_ = st;
		if (_tmp264_ != NULL) {
			ValaStruct* _tmp265_;
			ValaCreationMethod* _tmp266_;
			ValaCreationMethod* _tmp267_;
			_tmp265_ = st;
			_tmp266_ = vala_struct_get_default_construction_method (_tmp265_);
			_tmp267_ = _tmp266_;
			_tmp263_ = _tmp267_ == NULL;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			gboolean _tmp268_ = FALSE;
			gboolean _tmp269_ = FALSE;
			ValaStruct* _tmp270_;
			_tmp270_ = st;
			if (vala_struct_is_boolean_type (_tmp270_)) {
				_tmp269_ = TRUE;
			} else {
				ValaStruct* _tmp271_;
				_tmp271_ = st;
				_tmp269_ = vala_struct_is_integer_type (_tmp271_);
			}
			if (_tmp269_) {
				_tmp268_ = TRUE;
			} else {
				ValaStruct* _tmp272_;
				_tmp272_ = st;
				_tmp268_ = vala_struct_is_floating_type (_tmp272_);
			}
			_tmp262_ = _tmp268_;
		} else {
			_tmp262_ = FALSE;
		}
		if (_tmp262_) {
			ValaSourceReference* _tmp273_;
			ValaSourceReference* _tmp274_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp274_ = _tmp273_;
			vala_report_error (_tmp274_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp275_ = vala_method_call_get_call (self);
		_tmp276_ = _tmp275_;
		_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp278_ = _tmp277_;
		_tmp279_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp276_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp278_);
		struct_creation_expression = _tmp279_;
		_tmp280_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp280_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp281_;
			gint _arg_size = 0;
			ValaList* _tmp282_;
			gint _tmp283_;
			gint _tmp284_;
			gint _arg_index = 0;
			_tmp281_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp281_;
			_tmp282_ = _arg_list;
			_tmp283_ = vala_collection_get_size ((ValaCollection*) _tmp282_);
			_tmp284_ = _tmp283_;
			_arg_size = _tmp284_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp285_;
				gpointer _tmp286_;
				ValaObjectCreationExpression* _tmp287_;
				ValaExpression* _tmp288_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp285_ = _arg_list;
				_tmp286_ = vala_list_get (_tmp285_, _arg_index);
				arg = (ValaExpression*) _tmp286_;
				_tmp287_ = struct_creation_expression;
				_tmp288_ = arg;
				vala_object_creation_expression_add_argument (_tmp287_, _tmp288_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp289_ = struct_creation_expression;
		_tmp290_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp291_ = _tmp290_;
		vala_expression_set_target_type ((ValaExpression*) _tmp289_, _tmp291_);
		_tmp292_ = vala_code_context_get_analyzer (context);
		_tmp293_ = _tmp292_;
		_tmp294_ = _tmp293_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp294_, (ValaCodeNode*) self);
		_tmp295_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp296_, (ValaExpression*) self, (ValaExpression*) _tmp297_);
		_tmp298_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp298_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp299_ = FALSE;
		gboolean _tmp300_ = FALSE;
		gboolean _tmp301_;
		_tmp301_ = self->priv->_is_chainup;
		if (!_tmp301_) {
			ValaExpression* _tmp302_;
			ValaExpression* _tmp303_;
			_tmp302_ = vala_method_call_get_call (self);
			_tmp303_ = _tmp302_;
			_tmp300_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp303_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp300_ = FALSE;
		}
		if (_tmp300_) {
			ValaExpression* _tmp304_;
			ValaExpression* _tmp305_;
			ValaSymbol* _tmp306_;
			ValaSymbol* _tmp307_;
			_tmp304_ = vala_method_call_get_call (self);
			_tmp305_ = _tmp304_;
			_tmp306_ = vala_expression_get_symbol_reference (_tmp305_);
			_tmp307_ = _tmp306_;
			_tmp299_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp307_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp299_ = FALSE;
		}
		if (_tmp299_) {
			ValaSourceReference* _tmp308_;
			ValaSourceReference* _tmp309_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp309_ = _tmp308_;
			vala_report_error (_tmp309_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp311_ = self->priv->_is_chainup;
	if (!_tmp311_) {
		ValaDataType* _tmp312_;
		_tmp312_ = mtype;
		_tmp310_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp312_, VALA_TYPE_OBJECT_TYPE);
	} else {
		_tmp310_ = FALSE;
	}
	if (_tmp310_) {
		ValaSourceReference* _tmp313_;
		ValaSourceReference* _tmp314_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp313_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp314_ = _tmp313_;
		vala_report_error (_tmp314_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp315_ = FALSE;
		ValaDataType* _tmp316_;
		_tmp316_ = mtype;
		if (_tmp316_ != NULL) {
			ValaDataType* _tmp317_;
			_tmp317_ = mtype;
			_tmp315_ = vala_data_type_is_invokable (_tmp317_);
		} else {
			_tmp315_ = FALSE;
		}
		if (_tmp315_) {
		} else {
			ValaExpression* _tmp318_;
			ValaExpression* _tmp319_;
			ValaSymbol* _tmp320_;
			ValaSymbol* _tmp321_;
			_tmp318_ = vala_method_call_get_call (self);
			_tmp319_ = _tmp318_;
			_tmp320_ = vala_expression_get_symbol_reference (_tmp319_);
			_tmp321_ = _tmp320_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp321_, VALA_TYPE_CLASS)) {
				ValaSourceReference* _tmp322_;
				ValaSourceReference* _tmp323_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp323_ = _tmp322_;
				vala_report_error (_tmp323_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp324_;
				ValaSourceReference* _tmp325_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp324_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp325_ = _tmp324_;
				vala_report_error (_tmp325_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp326_ = mtype;
	_tmp327_ = vala_data_type_get_return_type (_tmp326_);
	ret_type = _tmp327_;
	_tmp328_ = mtype;
	_tmp329_ = vala_data_type_get_parameters (_tmp328_);
	params = _tmp329_;
	_tmp330_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp331_;
		ValaMethod* _tmp332_;
		ValaMethod* _tmp333_;
		ValaMethod* _tmp334_;
		gboolean _tmp335_ = FALSE;
		ValaMethod* _tmp336_;
		ValaMethod* _tmp373_;
		_tmp331_ = mtype;
		_tmp332_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp331_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp333_ = _tmp332_;
		_tmp334_ = _vala_code_node_ref0 (_tmp333_);
		m = _tmp334_;
		_tmp336_ = m;
		if (_tmp336_ != NULL) {
			ValaMethod* _tmp337_;
			gboolean _tmp338_;
			gboolean _tmp339_;
			_tmp337_ = m;
			_tmp338_ = vala_method_get_coroutine (_tmp337_);
			_tmp339_ = _tmp338_;
			_tmp335_ = _tmp339_;
		} else {
			_tmp335_ = FALSE;
		}
		if (_tmp335_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp340_;
			ValaExpression* _tmp341_;
			ValaMemberAccess* _tmp342_;
			gboolean _tmp343_;
			_tmp340_ = vala_method_call_get_call (self);
			_tmp341_ = _tmp340_;
			_tmp342_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp341_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp342_;
			_tmp343_ = self->priv->_is_yield_expression;
			if (!_tmp343_) {
				ValaMemberAccess* _tmp344_;
				const gchar* _tmp345_;
				const gchar* _tmp346_;
				_tmp344_ = ma;
				_tmp345_ = vala_member_access_get_member_name (_tmp344_);
				_tmp346_ = _tmp345_;
				if (g_strcmp0 (_tmp346_, "end") != 0) {
					ValaMemberAccess* _tmp347_;
					const gchar* _tmp348_;
					const gchar* _tmp349_;
					ValaMethod* _tmp353_;
					ValaList* _tmp354_;
					ValaVoidType* _tmp355_;
					_tmp347_ = ma;
					_tmp348_ = vala_member_access_get_member_name (_tmp347_);
					_tmp349_ = _tmp348_;
					if (g_strcmp0 (_tmp349_, "begin") != 0) {
						ValaMemberAccess* _tmp350_;
						ValaSourceReference* _tmp351_;
						ValaSourceReference* _tmp352_;
						_tmp350_ = ma;
						_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp350_);
						_tmp352_ = _tmp351_;
						vala_report_deprecated (_tmp352_, "implicit .begin is deprecated");
					}
					_tmp353_ = m;
					_tmp354_ = vala_method_get_async_begin_parameters (_tmp353_);
					_vala_iterable_unref0 (params);
					params = _tmp354_;
					_tmp355_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp355_;
				} else {
					ValaMethod* _tmp356_;
					ValaList* _tmp357_;
					_tmp356_ = m;
					_tmp357_ = vala_method_get_async_end_parameters (_tmp356_);
					_vala_iterable_unref0 (params);
					params = _tmp357_;
				}
			} else {
				gboolean _tmp358_ = FALSE;
				ValaMemberAccess* _tmp359_;
				const gchar* _tmp360_;
				const gchar* _tmp361_;
				_tmp359_ = ma;
				_tmp360_ = vala_member_access_get_member_name (_tmp359_);
				_tmp361_ = _tmp360_;
				if (g_strcmp0 (_tmp361_, "begin") == 0) {
					_tmp358_ = TRUE;
				} else {
					ValaMemberAccess* _tmp362_;
					const gchar* _tmp363_;
					const gchar* _tmp364_;
					_tmp362_ = ma;
					_tmp363_ = vala_member_access_get_member_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp358_ = g_strcmp0 (_tmp364_, "end") == 0;
				}
				if (_tmp358_) {
					ValaMemberAccess* _tmp365_;
					ValaSourceReference* _tmp366_;
					ValaSourceReference* _tmp367_;
					ValaMemberAccess* _tmp368_;
					const gchar* _tmp369_;
					const gchar* _tmp370_;
					gchar* _tmp371_;
					gchar* _tmp372_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp365_ = ma;
					_tmp366_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp365_);
					_tmp367_ = _tmp366_;
					_tmp368_ = ma;
					_tmp369_ = vala_member_access_get_member_name (_tmp368_);
					_tmp370_ = _tmp369_;
					_tmp371_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp370_);
					_tmp372_ = _tmp371_;
					vala_report_error (_tmp367_, _tmp372_);
					_g_free0 (_tmp372_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp373_ = m;
		if (_tmp373_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp374_;
			ValaExpression* _tmp375_;
			ValaMemberAccess* _tmp376_;
			gint n_type_params = 0;
			ValaMethod* _tmp377_;
			ValaList* _tmp378_;
			ValaList* _tmp379_;
			gint _tmp380_;
			gint _tmp381_;
			gint _tmp382_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp383_;
			ValaList* _tmp384_;
			ValaList* _tmp385_;
			gint _tmp386_;
			gint _tmp387_;
			gint _tmp388_;
			gboolean _tmp389_ = FALSE;
			_tmp374_ = vala_method_call_get_call (self);
			_tmp375_ = _tmp374_;
			_tmp376_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp375_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp376_;
			_tmp377_ = m;
			_tmp378_ = vala_method_get_type_parameters (_tmp377_);
			_tmp379_ = _tmp378_;
			_tmp380_ = vala_collection_get_size ((ValaCollection*) _tmp379_);
			_tmp381_ = _tmp380_;
			_tmp382_ = _tmp381_;
			_vala_iterable_unref0 (_tmp379_);
			n_type_params = _tmp382_;
			_tmp383_ = ma;
			_tmp384_ = vala_member_access_get_type_arguments (_tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = vala_collection_get_size ((ValaCollection*) _tmp385_);
			_tmp387_ = _tmp386_;
			_tmp388_ = _tmp387_;
			_vala_iterable_unref0 (_tmp385_);
			n_type_args = _tmp388_;
			if (n_type_args > 0) {
				_tmp389_ = n_type_args < n_type_params;
			} else {
				_tmp389_ = FALSE;
			}
			if (_tmp389_) {
				ValaMemberAccess* _tmp390_;
				ValaSourceReference* _tmp391_;
				ValaSourceReference* _tmp392_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp390_ = ma;
				_tmp391_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp390_);
				_tmp392_ = _tmp391_;
				vala_report_error (_tmp392_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp393_ = FALSE;
				if (n_type_args > 0) {
					_tmp393_ = n_type_args > n_type_params;
				} else {
					_tmp393_ = FALSE;
				}
				if (_tmp393_) {
					ValaMemberAccess* _tmp394_;
					ValaSourceReference* _tmp395_;
					ValaSourceReference* _tmp396_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp394_ = ma;
					_tmp395_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp394_);
					_tmp396_ = _tmp395_;
					vala_report_error (_tmp396_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp397_ = vala_method_call_get_argument_list (self);
	args = _tmp397_;
	_tmp398_ = args;
	_tmp399_ = vala_iterable_iterator ((ValaIterable*) _tmp398_);
	arg_it = _tmp399_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp400_;
		ValaList* _tmp401_;
		gint _param_size = 0;
		ValaList* _tmp402_;
		gint _tmp403_;
		gint _tmp404_;
		gint _param_index = 0;
		_tmp400_ = params;
		_tmp401_ = _vala_iterable_ref0 (_tmp400_);
		_param_list = _tmp401_;
		_tmp402_ = _param_list;
		_tmp403_ = vala_collection_get_size ((ValaCollection*) _tmp402_);
		_tmp404_ = _tmp403_;
		_param_size = _tmp404_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp405_;
			gpointer _tmp406_;
			ValaParameter* _tmp407_;
			ValaParameter* _tmp408_;
			gboolean _tmp409_;
			gboolean _tmp410_;
			ValaParameter* _tmp411_;
			gboolean _tmp412_;
			gboolean _tmp413_;
			ValaIterator* _tmp431_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp405_ = _param_list;
			_tmp406_ = vala_list_get (_tmp405_, _param_index);
			param = (ValaParameter*) _tmp406_;
			_tmp407_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp407_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp408_ = param;
			_tmp409_ = vala_parameter_get_ellipsis (_tmp408_);
			_tmp410_ = _tmp409_;
			if (_tmp410_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp411_ = param;
			_tmp412_ = vala_parameter_get_params_array (_tmp411_);
			_tmp413_ = _tmp412_;
			if (_tmp413_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp414_;
				ValaDataType* _tmp415_;
				ValaDataType* _tmp416_;
				ValaArrayType* _tmp417_;
				_tmp414_ = param;
				_tmp415_ = vala_variable_get_variable_type ((ValaVariable*) _tmp414_);
				_tmp416_ = _tmp415_;
				_tmp417_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp416_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp417_;
				while (TRUE) {
					ValaIterator* _tmp418_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp419_;
					gpointer _tmp420_;
					ValaExpression* _tmp421_;
					ValaArrayType* _tmp422_;
					ValaDataType* _tmp423_;
					ValaDataType* _tmp424_;
					ValaExpression* _tmp425_;
					ValaDataType* _tmp426_;
					ValaDataType* _tmp427_;
					ValaArrayType* _tmp428_;
					gboolean _tmp429_;
					gboolean _tmp430_;
					_tmp418_ = arg_it;
					if (!vala_iterator_next (_tmp418_)) {
						break;
					}
					_tmp419_ = arg_it;
					_tmp420_ = vala_iterator_get (_tmp419_);
					arg = (ValaExpression*) _tmp420_;
					_tmp421_ = arg;
					_tmp422_ = array_type;
					_tmp423_ = vala_array_type_get_element_type (_tmp422_);
					_tmp424_ = _tmp423_;
					vala_expression_set_target_type (_tmp421_, _tmp424_);
					_tmp425_ = arg;
					_tmp426_ = vala_expression_get_target_type (_tmp425_);
					_tmp427_ = _tmp426_;
					_tmp428_ = array_type;
					_tmp429_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp428_);
					_tmp430_ = _tmp429_;
					vala_data_type_set_value_owned (_tmp427_, _tmp430_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp431_ = arg_it;
			if (vala_iterator_next (_tmp431_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp432_;
				gpointer _tmp433_;
				ValaExpression* _tmp434_;
				ValaParameter* _tmp435_;
				ValaDataType* _tmp436_;
				ValaDataType* _tmp437_;
				ValaExpression* _tmp438_;
				ValaExpression* _tmp439_;
				ValaDataType* _tmp440_;
				ValaDataType* _tmp441_;
				ValaDataType* _tmp442_;
				ValaList* _tmp443_;
				ValaDataType* _tmp444_;
				ValaDataType* _tmp445_;
				ValaExpression* _tmp446_;
				ValaExpression* _tmp447_;
				_tmp432_ = arg_it;
				_tmp433_ = vala_iterator_get (_tmp432_);
				arg = (ValaExpression*) _tmp433_;
				_tmp434_ = arg;
				_tmp435_ = param;
				_tmp436_ = vala_variable_get_variable_type ((ValaVariable*) _tmp435_);
				_tmp437_ = _tmp436_;
				vala_expression_set_formal_target_type (_tmp434_, _tmp437_);
				_tmp438_ = arg;
				_tmp439_ = arg;
				_tmp440_ = vala_expression_get_formal_target_type (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = target_object_type;
				_tmp443_ = method_type_args;
				_tmp444_ = vala_data_type_get_actual_type (_tmp441_, _tmp442_, _tmp443_, (ValaCodeNode*) self);
				_tmp445_ = _tmp444_;
				vala_expression_set_target_type (_tmp438_, _tmp445_);
				_vala_code_node_unref0 (_tmp445_);
				_tmp446_ = arg;
				_tmp447_ = _vala_code_node_ref0 (_tmp446_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp447_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp449_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp449_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp450_;
		ValaMethod* _tmp451_;
		ValaMethod* _tmp452_;
		ValaAttribute* _tmp453_;
		_tmp450_ = mtype;
		_tmp451_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp450_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp452_ = _tmp451_;
		_tmp453_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp452_, "Print");
		_tmp448_ = _tmp453_ != NULL;
	} else {
		_tmp448_ = FALSE;
	}
	if (_tmp448_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp454_;
		ValaSourceReference* _tmp455_;
		ValaTemplate* _tmp456_;
		ValaList* _tmp467_;
		ValaTemplate* _tmp468_;
		_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp455_ = _tmp454_;
		_tmp456_ = vala_template_new (_tmp455_);
		template = _tmp456_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp457_;
			ValaList* _tmp458_;
			gint _arg_size = 0;
			ValaList* _tmp459_;
			gint _tmp460_;
			gint _tmp461_;
			gint _arg_index = 0;
			_tmp457_ = self->priv->argument_list;
			_tmp458_ = _vala_iterable_ref0 (_tmp457_);
			_arg_list = _tmp458_;
			_tmp459_ = _arg_list;
			_tmp460_ = vala_collection_get_size ((ValaCollection*) _tmp459_);
			_tmp461_ = _tmp460_;
			_arg_size = _tmp461_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp462_;
				gpointer _tmp463_;
				ValaExpression* _tmp464_;
				ValaTemplate* _tmp465_;
				ValaExpression* _tmp466_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp462_ = _arg_list;
				_tmp463_ = vala_list_get (_tmp462_, _arg_index);
				arg = (ValaExpression*) _tmp463_;
				_tmp464_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp464_, NULL);
				_tmp465_ = template;
				_tmp466_ = arg;
				vala_template_add_expression (_tmp465_, _tmp466_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp467_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp467_);
		_tmp468_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp468_);
		_vala_code_node_unref0 (template);
	}
	_tmp470_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp471_;
		ValaMethod* _tmp472_;
		ValaMethod* _tmp473_;
		gboolean _tmp474_;
		gboolean _tmp475_;
		_tmp471_ = mtype;
		_tmp472_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp471_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_method_get_printf_format (_tmp473_);
		_tmp475_ = _tmp474_;
		_tmp469_ = _tmp475_;
	} else {
		_tmp469_ = FALSE;
	}
	if (_tmp469_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp476_;
		ValaStringLiteral* _tmp521_;
		format_literal = NULL;
		_tmp476_ = last_arg;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp476_, VALA_TYPE_NULL_LITERAL)) {
		} else {
			ValaExpression* _tmp477_;
			_tmp477_ = last_arg;
			if (_tmp477_ != NULL) {
				ValaExpression* _tmp478_;
				ValaStringLiteral* _tmp479_;
				gboolean _tmp480_ = FALSE;
				ValaStringLiteral* _tmp481_;
				_tmp478_ = last_arg;
				_tmp479_ = vala_string_literal_get_format_literal (_tmp478_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp479_;
				_tmp481_ = format_literal;
				if (_tmp481_ == NULL) {
					ValaList* _tmp482_;
					gint _tmp483_;
					gint _tmp484_;
					ValaList* _tmp485_;
					gint _tmp486_;
					gint _tmp487_;
					_tmp482_ = args;
					_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
					_tmp484_ = _tmp483_;
					_tmp485_ = params;
					_tmp486_ = vala_collection_get_size ((ValaCollection*) _tmp485_);
					_tmp487_ = _tmp486_;
					_tmp480_ = _tmp484_ == (_tmp487_ - 1);
				} else {
					_tmp480_ = FALSE;
				}
				if (_tmp480_) {
					ValaStringLiteral* _tmp488_;
					ValaStringLiteral* _tmp489_;
					ValaSemanticAnalyzer* _tmp490_;
					ValaSemanticAnalyzer* _tmp491_;
					ValaDataType* _tmp492_;
					ValaDataType* _tmp493_;
					ValaDataType* _tmp494_;
					ValaList* _tmp495_;
					ValaList* _tmp496_;
					gint _tmp497_;
					gint _tmp498_;
					ValaStringLiteral* _tmp499_;
					ValaList* _tmp500_;
					ValaIterator* _tmp501_;
					_tmp488_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp488_;
					_tmp489_ = format_literal;
					_tmp490_ = vala_code_context_get_analyzer (context);
					_tmp491_ = _tmp490_;
					_tmp492_ = _tmp491_->string_type;
					_tmp493_ = vala_data_type_copy (_tmp492_);
					_tmp494_ = _tmp493_;
					vala_expression_set_target_type ((ValaExpression*) _tmp489_, _tmp494_);
					_vala_code_node_unref0 (_tmp494_);
					_tmp495_ = self->priv->argument_list;
					_tmp496_ = args;
					_tmp497_ = vala_collection_get_size ((ValaCollection*) _tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = format_literal;
					vala_list_insert (_tmp495_, _tmp498_ - 1, (ValaExpression*) _tmp499_);
					_tmp500_ = self->priv->argument_list;
					_tmp501_ = vala_iterable_iterator ((ValaIterable*) _tmp500_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp501_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp502_;
						ValaList* _tmp503_;
						gint _param_size = 0;
						ValaList* _tmp504_;
						gint _tmp505_;
						gint _tmp506_;
						gint _param_index = 0;
						_tmp502_ = params;
						_tmp503_ = _vala_iterable_ref0 (_tmp502_);
						_param_list = _tmp503_;
						_tmp504_ = _param_list;
						_tmp505_ = vala_collection_get_size ((ValaCollection*) _tmp504_);
						_tmp506_ = _tmp505_;
						_param_size = _tmp506_;
						_param_index = -1;
						while (TRUE) {
							ValaParameter* param = NULL;
							ValaList* _tmp507_;
							gpointer _tmp508_;
							ValaParameter* _tmp509_;
							gboolean _tmp510_;
							gboolean _tmp511_;
							ValaIterator* _tmp512_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp507_ = _param_list;
							_tmp508_ = vala_list_get (_tmp507_, _param_index);
							param = (ValaParameter*) _tmp508_;
							_tmp509_ = param;
							_tmp510_ = vala_parameter_get_ellipsis (_tmp509_);
							_tmp511_ = _tmp510_;
							if (_tmp511_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp512_ = arg_it;
							vala_iterator_next (_tmp512_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp513_;
				ValaExpression* _tmp514_;
				ValaMemberAccess* _tmp515_;
				ValaMemberAccess* _tmp516_;
				_tmp513_ = vala_method_call_get_call (self);
				_tmp514_ = _tmp513_;
				_tmp515_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp514_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp514_) : NULL);
				ma = _tmp515_;
				_tmp516_ = ma;
				if (_tmp516_ != NULL) {
					ValaMemberAccess* _tmp517_;
					ValaExpression* _tmp518_;
					ValaExpression* _tmp519_;
					ValaStringLiteral* _tmp520_;
					_tmp517_ = ma;
					_tmp518_ = vala_member_access_get_inner (_tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = vala_string_literal_get_format_literal (_tmp519_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp520_;
				}
				_vala_code_node_unref0 (ma);
			}
		}
		_tmp521_ = format_literal;
		if (_tmp521_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp522_;
			gchar* _tmp523_;
			ValaSemanticAnalyzer* _tmp524_;
			ValaSemanticAnalyzer* _tmp525_;
			const gchar* _tmp526_;
			ValaIterator* _tmp527_;
			ValaSourceReference* _tmp528_;
			ValaSourceReference* _tmp529_;
			_tmp522_ = format_literal;
			_tmp523_ = vala_string_literal_eval (_tmp522_);
			format = _tmp523_;
			_tmp524_ = vala_code_context_get_analyzer (context);
			_tmp525_ = _tmp524_;
			_tmp526_ = format;
			_tmp527_ = arg_it;
			_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp529_ = _tmp528_;
			if (!vala_semantic_analyzer_check_print_format (_tmp525_, _tmp526_, _tmp527_, _tmp529_)) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp530_;
		gint _arg_size = 0;
		ValaList* _tmp531_;
		gint _tmp532_;
		gint _tmp533_;
		gint _arg_index = 0;
		_tmp530_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp530_;
		_tmp531_ = _arg_list;
		_tmp532_ = vala_collection_get_size ((ValaCollection*) _tmp531_);
		_tmp533_ = _tmp532_;
		_arg_size = _tmp533_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp534_;
			gpointer _tmp535_;
			ValaExpression* _tmp536_;
			gboolean _tmp537_ = FALSE;
			ValaExpression* _tmp538_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp534_ = _arg_list;
			_tmp535_ = vala_list_get (_tmp534_, _arg_index);
			arg = (ValaExpression*) _tmp535_;
			_tmp536_ = arg;
			vala_code_node_check ((ValaCodeNode*) _tmp536_, context);
			_tmp538_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp538_, VALA_TYPE_LAMBDA_EXPRESSION)) {
				ValaExpression* _tmp539_;
				ValaMethod* _tmp540_;
				ValaMethod* _tmp541_;
				gboolean _tmp542_;
				gboolean _tmp543_;
				_tmp539_ = arg;
				_tmp540_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp539_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_method_get_closure (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp537_ = _tmp543_;
			} else {
				_tmp537_ = FALSE;
			}
			if (_tmp537_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	if (force_lambda_method_closure) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp544_;
			gint _arg_size = 0;
			ValaList* _tmp545_;
			gint _tmp546_;
			gint _tmp547_;
			gint _arg_index = 0;
			_tmp544_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp544_;
			_tmp545_ = _arg_list;
			_tmp546_ = vala_collection_get_size ((ValaCollection*) _tmp545_);
			_tmp547_ = _tmp546_;
			_arg_size = _tmp547_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp548_;
				gpointer _tmp549_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp550_;
				gboolean _tmp551_ = FALSE;
				ValaLambdaExpression* _tmp552_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp548_ = _arg_list;
				_tmp549_ = vala_list_get (_tmp548_, _arg_index);
				arg = (ValaExpression*) _tmp549_;
				_tmp550_ = arg;
				lambda = G_TYPE_CHECK_INSTANCE_TYPE (_tmp550_, VALA_TYPE_LAMBDA_EXPRESSION) ? ((ValaLambdaExpression*) _tmp550_) : NULL;
				_tmp552_ = lambda;
				if (_tmp552_ != NULL) {
					ValaLambdaExpression* _tmp553_;
					ValaMethod* _tmp554_;
					ValaMethod* _tmp555_;
					ValaMemberBinding _tmp556_;
					ValaMemberBinding _tmp557_;
					_tmp553_ = lambda;
					_tmp554_ = vala_lambda_expression_get_method (_tmp553_);
					_tmp555_ = _tmp554_;
					_tmp556_ = vala_method_get_binding (_tmp555_);
					_tmp557_ = _tmp556_;
					_tmp551_ = _tmp557_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp551_ = FALSE;
				}
				if (_tmp551_) {
					ValaLambdaExpression* _tmp558_;
					ValaMethod* _tmp559_;
					ValaMethod* _tmp560_;
					_tmp558_ = lambda;
					_tmp559_ = vala_lambda_expression_get_method (_tmp558_);
					_tmp560_ = _tmp559_;
					vala_method_set_closure (_tmp560_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
	}
	_tmp561_ = ret_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp561_, VALA_TYPE_VOID_TYPE)) {
		gboolean _tmp562_ = FALSE;
		gboolean _tmp563_ = FALSE;
		ValaCodeNode* _tmp564_;
		ValaCodeNode* _tmp565_;
		_tmp564_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp565_ = _tmp564_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp565_, VALA_TYPE_EXPRESSION_STATEMENT)) {
			ValaCodeNode* _tmp566_;
			ValaCodeNode* _tmp567_;
			_tmp566_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp567_ = _tmp566_;
			_tmp563_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp567_, VALA_TYPE_FOR_STATEMENT);
		} else {
			_tmp563_ = FALSE;
		}
		if (_tmp563_) {
			ValaCodeNode* _tmp568_;
			ValaCodeNode* _tmp569_;
			_tmp568_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp569_ = _tmp568_;
			_tmp562_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp569_, VALA_TYPE_YIELD_STATEMENT);
		} else {
			_tmp562_ = FALSE;
		}
		if (_tmp562_) {
			ValaSourceReference* _tmp570_;
			ValaSourceReference* _tmp571_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp570_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp571_ = _tmp570_;
			vala_report_error (_tmp571_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp572_ = ret_type;
	_tmp573_ = vala_data_type_copy (_tmp572_);
	_tmp574_ = _tmp573_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp574_);
	_vala_code_node_unref0 (_tmp574_);
	_tmp575_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp576_ = _tmp575_;
	_tmp577_ = target_object_type;
	_tmp578_ = method_type_args;
	_tmp579_ = vala_data_type_get_actual_type (_tmp576_, _tmp577_, _tmp578_, (ValaCodeNode*) self);
	_tmp580_ = _tmp579_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp580_);
	_vala_code_node_unref0 (_tmp580_);
	_tmp581_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp581_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp582_;
		ValaMethod* _tmp583_;
		ValaMethod* _tmp584_;
		ValaMethod* _tmp585_;
		gboolean _tmp586_;
		ValaMethod* _tmp605_;
		gboolean _tmp606_;
		gboolean _tmp607_;
		ValaMethod* _tmp610_;
		gboolean _tmp611_;
		gboolean _tmp612_;
		gboolean _tmp617_ = FALSE;
		gboolean _tmp618_ = FALSE;
		gboolean _tmp619_ = FALSE;
		gboolean _tmp620_;
		gboolean _tmp621_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp633_;
		ValaSymbol* _tmp634_;
		ValaSymbol* _tmp635_;
		gboolean _tmp636_ = FALSE;
		ValaSignal* _tmp637_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp648_;
		ValaSymbol* _tmp649_;
		ValaSymbol* _tmp650_;
		ValaDynamicSignal* _tmp651_;
		gboolean _tmp652_ = FALSE;
		ValaDynamicSignal* _tmp653_;
		gboolean _tmp695_ = FALSE;
		ValaMethod* _tmp696_;
		gboolean _tmp805_ = FALSE;
		ValaMethod* _tmp806_;
		_tmp582_ = mtype;
		_tmp583_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp582_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp584_ = _tmp583_;
		_tmp585_ = _vala_code_node_ref0 (_tmp584_);
		m = _tmp585_;
		_tmp586_ = self->priv->_is_yield_expression;
		if (_tmp586_) {
			ValaMethod* _tmp587_;
			gboolean _tmp588_;
			gboolean _tmp589_;
			gboolean _tmp592_ = FALSE;
			ValaSemanticAnalyzer* _tmp593_;
			ValaSemanticAnalyzer* _tmp594_;
			ValaMethod* _tmp595_;
			ValaMethod* _tmp596_;
			_tmp587_ = m;
			_tmp588_ = vala_method_get_coroutine (_tmp587_);
			_tmp589_ = _tmp588_;
			if (!_tmp589_) {
				ValaSourceReference* _tmp590_;
				ValaSourceReference* _tmp591_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp590_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp591_ = _tmp590_;
				vala_report_error (_tmp591_, "yield expression requires async method");
			}
			_tmp593_ = vala_code_context_get_analyzer (context);
			_tmp594_ = _tmp593_;
			_tmp595_ = vala_semantic_analyzer_get_current_method (_tmp594_);
			_tmp596_ = _tmp595_;
			if (_tmp596_ == NULL) {
				_tmp592_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp597_;
				ValaSemanticAnalyzer* _tmp598_;
				ValaMethod* _tmp599_;
				ValaMethod* _tmp600_;
				gboolean _tmp601_;
				gboolean _tmp602_;
				_tmp597_ = vala_code_context_get_analyzer (context);
				_tmp598_ = _tmp597_;
				_tmp599_ = vala_semantic_analyzer_get_current_method (_tmp598_);
				_tmp600_ = _tmp599_;
				_tmp601_ = vala_method_get_coroutine (_tmp600_);
				_tmp602_ = _tmp601_;
				_tmp592_ = !_tmp602_;
			}
			if (_tmp592_) {
				ValaSourceReference* _tmp603_;
				ValaSourceReference* _tmp604_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp603_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp604_ = _tmp603_;
				vala_report_error (_tmp604_, "yield expression not available outside async method");
			}
		}
		_tmp605_ = m;
		_tmp606_ = vala_method_get_returns_floating_reference (_tmp605_);
		_tmp607_ = _tmp606_;
		if (_tmp607_) {
			ValaDataType* _tmp608_;
			ValaDataType* _tmp609_;
			_tmp608_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp609_ = _tmp608_;
			vala_data_type_set_floating_reference (_tmp609_, TRUE);
		}
		_tmp610_ = m;
		_tmp611_ = vala_method_get_returns_modified_pointer (_tmp610_);
		_tmp612_ = _tmp611_;
		if (_tmp612_) {
			ValaExpression* _tmp613_;
			ValaExpression* _tmp614_;
			ValaExpression* _tmp615_;
			ValaExpression* _tmp616_;
			_tmp613_ = vala_method_call_get_call (self);
			_tmp614_ = _tmp613_;
			_tmp615_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp614_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp616_ = _tmp615_;
			vala_expression_set_lvalue (_tmp616_, TRUE);
		}
		_tmp620_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp621_ = _tmp620_;
		if (_tmp621_) {
			ValaDataType* _tmp622_;
			ValaDataType* _tmp623_;
			gboolean _tmp624_;
			gboolean _tmp625_;
			_tmp622_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp623_ = _tmp622_;
			_tmp624_ = vala_data_type_get_nullable (_tmp623_);
			_tmp625_ = _tmp624_;
			_tmp619_ = !_tmp625_;
		} else {
			_tmp619_ = FALSE;
		}
		if (_tmp619_) {
			ValaDataType* _tmp626_;
			ValaDataType* _tmp627_;
			gboolean _tmp628_;
			gboolean _tmp629_;
			_tmp626_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp627_ = _tmp626_;
			_tmp628_ = vala_data_type_get_floating_reference (_tmp627_);
			_tmp629_ = _tmp628_;
			_tmp618_ = _tmp629_;
		} else {
			_tmp618_ = FALSE;
		}
		if (_tmp618_) {
			ValaDataType* _tmp630_;
			_tmp630_ = ret_type;
			_tmp617_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp630_, VALA_TYPE_OBJECT_TYPE);
		} else {
			_tmp617_ = FALSE;
		}
		if (_tmp617_) {
			ValaDataType* _tmp631_;
			ValaDataType* _tmp632_;
			_tmp631_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp632_ = _tmp631_;
			vala_data_type_set_nullable (_tmp632_, TRUE);
		}
		_tmp633_ = m;
		_tmp634_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp633_);
		_tmp635_ = _tmp634_;
		sig = G_TYPE_CHECK_INSTANCE_TYPE (_tmp635_, VALA_TYPE_SIGNAL) ? ((ValaSignal*) _tmp635_) : NULL;
		_tmp637_ = sig;
		if (_tmp637_ != NULL) {
			ValaMethod* _tmp638_;
			const gchar* _tmp639_;
			const gchar* _tmp640_;
			_tmp638_ = m;
			_tmp639_ = vala_symbol_get_name ((ValaSymbol*) _tmp638_);
			_tmp640_ = _tmp639_;
			_tmp636_ = g_strcmp0 (_tmp640_, "disconnect") == 0;
		} else {
			_tmp636_ = FALSE;
		}
		if (_tmp636_) {
			ValaExpression* param = NULL;
			ValaList* _tmp641_;
			ValaList* _tmp642_;
			gpointer _tmp643_;
			ValaExpression* _tmp644_;
			ValaExpression* _tmp645_;
			_tmp641_ = vala_method_call_get_argument_list (self);
			_tmp642_ = _tmp641_;
			_tmp643_ = vala_list_get (_tmp642_, 0);
			_tmp644_ = (ValaExpression*) _tmp643_;
			_vala_iterable_unref0 (_tmp642_);
			param = _tmp644_;
			_tmp645_ = param;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp645_, VALA_TYPE_LAMBDA_EXPRESSION)) {
				ValaSourceReference* _tmp646_;
				ValaSourceReference* _tmp647_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp646_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp647_ = _tmp646_;
				vala_report_error (_tmp647_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (m);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_tmp648_ = m;
		_tmp649_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp648_);
		_tmp650_ = _tmp649_;
		_tmp651_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp650_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp650_) : NULL);
		dynamic_sig = _tmp651_;
		_tmp653_ = dynamic_sig;
		if (_tmp653_ != NULL) {
			ValaDynamicSignal* _tmp654_;
			ValaExpression* _tmp655_;
			ValaExpression* _tmp656_;
			_tmp654_ = dynamic_sig;
			_tmp655_ = vala_dynamic_signal_get_handler (_tmp654_);
			_tmp656_ = _tmp655_;
			_tmp652_ = _tmp656_ != NULL;
		} else {
			_tmp652_ = FALSE;
		}
		if (_tmp652_) {
			ValaDynamicSignal* _tmp657_;
			ValaDynamicSignal* _tmp658_;
			ValaExpression* _tmp659_;
			ValaExpression* _tmp660_;
			ValaDataType* _tmp661_;
			ValaDataType* _tmp662_;
			ValaDataType* _tmp663_;
			ValaDataType* _tmp664_;
			ValaDataType* _tmp665_;
			ValaDataType* _tmp666_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp682_;
			ValaExpression* _tmp683_;
			ValaExpression* _tmp684_;
			ValaDynamicSignal* _tmp685_;
			ValaDynamicSignal* _tmp686_;
			ValaSymbol* _tmp687_;
			ValaSymbol* _tmp688_;
			ValaObjectType* _tmp689_;
			ValaObjectType* _tmp690_;
			ValaDelegate* _tmp691_;
			ValaDelegate* _tmp692_;
			ValaDelegateType* _tmp693_;
			ValaDelegateType* _tmp694_;
			_tmp657_ = dynamic_sig;
			_tmp658_ = dynamic_sig;
			_tmp659_ = vala_dynamic_signal_get_handler (_tmp658_);
			_tmp660_ = _tmp659_;
			_tmp661_ = vala_expression_get_value_type (_tmp660_);
			_tmp662_ = _tmp661_;
			_tmp663_ = vala_data_type_get_return_type (_tmp662_);
			_tmp664_ = _tmp663_;
			_tmp665_ = vala_data_type_copy (_tmp664_);
			_tmp666_ = _tmp665_;
			vala_callable_set_return_type ((ValaCallable*) _tmp657_, _tmp666_);
			_vala_code_node_unref0 (_tmp666_);
			_vala_code_node_unref0 (_tmp664_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp667_;
				ValaExpression* _tmp668_;
				ValaExpression* _tmp669_;
				ValaDataType* _tmp670_;
				ValaDataType* _tmp671_;
				ValaList* _tmp672_;
				gint _param_size = 0;
				ValaList* _tmp673_;
				gint _tmp674_;
				gint _tmp675_;
				gint _param_index = 0;
				_tmp667_ = dynamic_sig;
				_tmp668_ = vala_dynamic_signal_get_handler (_tmp667_);
				_tmp669_ = _tmp668_;
				_tmp670_ = vala_expression_get_value_type (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_data_type_get_parameters (_tmp671_);
				_param_list = _tmp672_;
				_tmp673_ = _param_list;
				_tmp674_ = vala_collection_get_size ((ValaCollection*) _tmp673_);
				_tmp675_ = _tmp674_;
				_param_size = _tmp675_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp676_;
					gpointer _tmp677_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp676_ = _param_list;
					_tmp677_ = vala_list_get (_tmp676_, _param_index);
					param = (ValaParameter*) _tmp677_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp678_;
						ValaParameter* _tmp679_;
						ValaParameter* _tmp680_;
						ValaParameter* _tmp681_;
						_tmp678_ = dynamic_sig;
						_tmp679_ = param;
						_tmp680_ = vala_parameter_copy (_tmp679_);
						_tmp681_ = _tmp680_;
						vala_callable_add_parameter ((ValaCallable*) _tmp678_, _tmp681_);
						_vala_code_node_unref0 (_tmp681_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp682_ = dynamic_sig;
			_tmp683_ = vala_dynamic_signal_get_handler (_tmp682_);
			_tmp684_ = _tmp683_;
			_tmp685_ = dynamic_sig;
			_tmp686_ = dynamic_sig;
			_tmp687_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp686_);
			_tmp688_ = _tmp687_;
			_tmp689_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp688_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp690_ = _tmp689_;
			_tmp691_ = vala_signal_get_delegate ((ValaSignal*) _tmp685_, (ValaDataType*) _tmp690_, (ValaCodeNode*) self);
			_tmp692_ = _tmp691_;
			_tmp693_ = vala_delegate_type_new (_tmp692_);
			_tmp694_ = _tmp693_;
			vala_expression_set_target_type (_tmp684_, (ValaDataType*) _tmp694_);
			_vala_code_node_unref0 (_tmp694_);
			_vala_code_node_unref0 (_tmp692_);
			_vala_code_node_unref0 (_tmp690_);
		}
		_tmp696_ = m;
		if (_tmp696_ != NULL) {
			ValaMethod* _tmp697_;
			_tmp697_ = m;
			_tmp695_ = vala_method_has_type_parameters (_tmp697_);
		} else {
			_tmp695_ = FALSE;
		}
		if (_tmp695_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp698_;
			ValaExpression* _tmp699_;
			ValaMemberAccess* _tmp700_;
			ValaMemberAccess* _tmp701_;
			ValaList* _tmp702_;
			ValaList* _tmp703_;
			gint _tmp704_;
			gint _tmp705_;
			gboolean _tmp706_;
			_tmp698_ = vala_method_call_get_call (self);
			_tmp699_ = _tmp698_;
			_tmp700_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp699_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp700_;
			_tmp701_ = ma;
			_tmp702_ = vala_member_access_get_type_arguments (_tmp701_);
			_tmp703_ = _tmp702_;
			_tmp704_ = vala_collection_get_size ((ValaCollection*) _tmp703_);
			_tmp705_ = _tmp704_;
			_tmp706_ = _tmp705_ == 0;
			_vala_iterable_unref0 (_tmp703_);
			if (_tmp706_) {
				ValaList* _tmp772_;
				ValaIterator* _tmp773_;
				ValaDataType* _tmp799_;
				ValaDataType* _tmp800_;
				ValaDataType* _tmp801_;
				ValaList* _tmp802_;
				ValaDataType* _tmp803_;
				ValaDataType* _tmp804_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp707_;
					ValaList* _tmp708_;
					gint _type_param_size = 0;
					ValaList* _tmp709_;
					gint _tmp710_;
					gint _tmp711_;
					gint _type_param_index = 0;
					_tmp707_ = m;
					_tmp708_ = vala_method_get_type_parameters (_tmp707_);
					_type_param_list = _tmp708_;
					_tmp709_ = _type_param_list;
					_tmp710_ = vala_collection_get_size ((ValaCollection*) _tmp709_);
					_tmp711_ = _tmp710_;
					_type_param_size = _tmp711_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp712_;
						gpointer _tmp713_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp714_;
						ValaIterator* _tmp715_;
						gboolean _tmp750_ = FALSE;
						ValaDataType* _tmp751_;
						ValaDataType* _tmp761_;
						ValaMemberAccess* _tmp770_;
						ValaDataType* _tmp771_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp712_ = _type_param_list;
						_tmp713_ = vala_list_get (_tmp712_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp713_;
						type_arg = NULL;
						_tmp714_ = args;
						_tmp715_ = vala_iterable_iterator ((ValaIterable*) _tmp714_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp715_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp716_;
							ValaList* _tmp717_;
							gint _param_size = 0;
							ValaList* _tmp718_;
							gint _tmp719_;
							gint _tmp720_;
							gint _param_index = 0;
							_tmp716_ = params;
							_tmp717_ = _vala_iterable_ref0 (_tmp716_);
							_param_list = _tmp717_;
							_tmp718_ = _param_list;
							_tmp719_ = vala_collection_get_size ((ValaCollection*) _tmp718_);
							_tmp720_ = _tmp719_;
							_param_size = _tmp720_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp721_;
								gpointer _tmp722_;
								gboolean _tmp723_ = FALSE;
								ValaParameter* _tmp724_;
								gboolean _tmp725_;
								gboolean _tmp726_;
								ValaIterator* _tmp730_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp721_ = _param_list;
								_tmp722_ = vala_list_get (_tmp721_, _param_index);
								param = (ValaParameter*) _tmp722_;
								_tmp724_ = param;
								_tmp725_ = vala_parameter_get_ellipsis (_tmp724_);
								_tmp726_ = _tmp725_;
								if (_tmp726_) {
									_tmp723_ = TRUE;
								} else {
									ValaParameter* _tmp727_;
									gboolean _tmp728_;
									gboolean _tmp729_;
									_tmp727_ = param;
									_tmp728_ = vala_parameter_get_params_array (_tmp727_);
									_tmp729_ = _tmp728_;
									_tmp723_ = _tmp729_;
								}
								if (_tmp723_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp730_ = arg_it;
								if (vala_iterator_next (_tmp730_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp731_;
									gpointer _tmp732_;
									ValaParameter* _tmp733_;
									ValaDataType* _tmp734_;
									ValaDataType* _tmp735_;
									ValaTypeParameter* _tmp736_;
									ValaExpression* _tmp737_;
									ValaDataType* _tmp738_;
									ValaDataType* _tmp739_;
									ValaDataType* _tmp740_;
									ValaDataType* _tmp741_;
									ValaExpression* _tmp742_;
									ValaExpression* _tmp743_;
									ValaDataType* _tmp744_;
									ValaDataType* _tmp745_;
									ValaDataType* _tmp746_;
									ValaList* _tmp747_;
									ValaDataType* _tmp748_;
									ValaDataType* _tmp749_;
									_tmp731_ = arg_it;
									_tmp732_ = vala_iterator_get (_tmp731_);
									arg = (ValaExpression*) _tmp732_;
									_tmp733_ = param;
									_tmp734_ = vala_variable_get_variable_type ((ValaVariable*) _tmp733_);
									_tmp735_ = _tmp734_;
									_tmp736_ = type_param;
									_tmp737_ = arg;
									_tmp738_ = vala_expression_get_value_type (_tmp737_);
									_tmp739_ = _tmp738_;
									_tmp740_ = vala_data_type_infer_type_argument (_tmp735_, _tmp736_, _tmp739_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp740_;
									_tmp741_ = type_arg;
									if (_tmp741_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp742_ = arg;
									_tmp743_ = arg;
									_tmp744_ = vala_expression_get_formal_target_type (_tmp743_);
									_tmp745_ = _tmp744_;
									_tmp746_ = target_object_type;
									_tmp747_ = method_type_args;
									_tmp748_ = vala_data_type_get_actual_type (_tmp745_, _tmp746_, _tmp747_, (ValaCodeNode*) self);
									_tmp749_ = _tmp748_;
									vala_expression_set_target_type (_tmp742_, _tmp749_);
									_vala_code_node_unref0 (_tmp749_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp751_ = type_arg;
						if (_tmp751_ == NULL) {
							ValaDataType* _tmp752_;
							ValaDataType* _tmp753_;
							_tmp752_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp753_ = _tmp752_;
							_tmp750_ = _tmp753_ != NULL;
						} else {
							_tmp750_ = FALSE;
						}
						if (_tmp750_) {
							ValaMethod* _tmp754_;
							ValaDataType* _tmp755_;
							ValaDataType* _tmp756_;
							ValaTypeParameter* _tmp757_;
							ValaDataType* _tmp758_;
							ValaDataType* _tmp759_;
							ValaDataType* _tmp760_;
							_tmp754_ = m;
							_tmp755_ = vala_callable_get_return_type ((ValaCallable*) _tmp754_);
							_tmp756_ = _tmp755_;
							_tmp757_ = type_param;
							_tmp758_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp759_ = _tmp758_;
							_tmp760_ = vala_data_type_infer_type_argument (_tmp756_, _tmp757_, _tmp759_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp760_;
						}
						_tmp761_ = type_arg;
						if (_tmp761_ == NULL) {
							ValaMemberAccess* _tmp762_;
							ValaSourceReference* _tmp763_;
							ValaSourceReference* _tmp764_;
							ValaTypeParameter* _tmp765_;
							gchar* _tmp766_;
							gchar* _tmp767_;
							gchar* _tmp768_;
							gchar* _tmp769_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp762_ = ma;
							_tmp763_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp762_);
							_tmp764_ = _tmp763_;
							_tmp765_ = type_param;
							_tmp766_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp765_);
							_tmp767_ = _tmp766_;
							_tmp768_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp767_);
							_tmp769_ = _tmp768_;
							vala_report_error (_tmp764_, _tmp769_);
							_g_free0 (_tmp769_);
							_g_free0 (_tmp767_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp770_ = ma;
						_tmp771_ = type_arg;
						vala_member_access_add_type_argument (_tmp770_, _tmp771_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp772_ = args;
				_tmp773_ = vala_iterable_iterator ((ValaIterable*) _tmp772_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp773_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp774_;
					ValaList* _tmp775_;
					gint _param_size = 0;
					ValaList* _tmp776_;
					gint _tmp777_;
					gint _tmp778_;
					gint _param_index = 0;
					_tmp774_ = params;
					_tmp775_ = _vala_iterable_ref0 (_tmp774_);
					_param_list = _tmp775_;
					_tmp776_ = _param_list;
					_tmp777_ = vala_collection_get_size ((ValaCollection*) _tmp776_);
					_tmp778_ = _tmp777_;
					_param_size = _tmp778_;
					_param_index = -1;
					while (TRUE) {
						ValaParameter* param = NULL;
						ValaList* _tmp779_;
						gpointer _tmp780_;
						gboolean _tmp781_ = FALSE;
						ValaParameter* _tmp782_;
						gboolean _tmp783_;
						gboolean _tmp784_;
						ValaIterator* _tmp788_;
						_param_index = _param_index + 1;
						if (!(_param_index < _param_size)) {
							break;
						}
						_tmp779_ = _param_list;
						_tmp780_ = vala_list_get (_tmp779_, _param_index);
						param = (ValaParameter*) _tmp780_;
						_tmp782_ = param;
						_tmp783_ = vala_parameter_get_ellipsis (_tmp782_);
						_tmp784_ = _tmp783_;
						if (_tmp784_) {
							_tmp781_ = TRUE;
						} else {
							ValaParameter* _tmp785_;
							gboolean _tmp786_;
							gboolean _tmp787_;
							_tmp785_ = param;
							_tmp786_ = vala_parameter_get_params_array (_tmp785_);
							_tmp787_ = _tmp786_;
							_tmp781_ = _tmp787_;
						}
						if (_tmp781_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp788_ = arg_it;
						if (vala_iterator_next (_tmp788_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp789_;
							gpointer _tmp790_;
							ValaExpression* _tmp791_;
							ValaExpression* _tmp792_;
							ValaDataType* _tmp793_;
							ValaDataType* _tmp794_;
							ValaDataType* _tmp795_;
							ValaList* _tmp796_;
							ValaDataType* _tmp797_;
							ValaDataType* _tmp798_;
							_tmp789_ = arg_it;
							_tmp790_ = vala_iterator_get (_tmp789_);
							arg = (ValaExpression*) _tmp790_;
							_tmp791_ = arg;
							_tmp792_ = arg;
							_tmp793_ = vala_expression_get_formal_target_type (_tmp792_);
							_tmp794_ = _tmp793_;
							_tmp795_ = target_object_type;
							_tmp796_ = method_type_args;
							_tmp797_ = vala_data_type_get_actual_type (_tmp794_, _tmp795_, _tmp796_, (ValaCodeNode*) self);
							_tmp798_ = _tmp797_;
							vala_expression_set_target_type (_tmp791_, _tmp798_);
							_vala_code_node_unref0 (_tmp798_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp799_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp800_ = _tmp799_;
				_tmp801_ = target_object_type;
				_tmp802_ = method_type_args;
				_tmp803_ = vala_data_type_get_actual_type (_tmp800_, _tmp801_, _tmp802_, (ValaCodeNode*) self);
				_tmp804_ = _tmp803_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp804_);
				_vala_code_node_unref0 (_tmp804_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp806_ = m;
		if (_tmp806_ != NULL) {
			ValaMethod* _tmp807_;
			gboolean _tmp808_;
			gboolean _tmp809_;
			_tmp807_ = m;
			_tmp808_ = vala_method_get_coroutine (_tmp807_);
			_tmp809_ = _tmp808_;
			_tmp805_ = _tmp809_;
		} else {
			_tmp805_ = FALSE;
		}
		if (_tmp805_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp810_;
			ValaExpression* _tmp811_;
			ValaMemberAccess* _tmp812_;
			ValaMemberAccess* _tmp813_;
			const gchar* _tmp814_;
			const gchar* _tmp815_;
			_tmp810_ = vala_method_call_get_call (self);
			_tmp811_ = _tmp810_;
			_tmp812_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp811_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp812_;
			_tmp813_ = ma;
			_tmp814_ = vala_member_access_get_member_name (_tmp813_);
			_tmp815_ = _tmp814_;
			if (g_strcmp0 (_tmp815_, "end") == 0) {
				ValaMethod* _tmp816_;
				ValaMethod* _tmp817_;
				ValaMethod* _tmp818_;
				ValaMethodType* _tmp819_;
				_tmp816_ = m;
				_tmp817_ = vala_method_get_end_method (_tmp816_);
				_tmp818_ = _tmp817_;
				_tmp819_ = vala_method_type_new (_tmp818_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp819_;
				_vala_code_node_unref0 (_tmp818_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	}
	_tmp820_ = vala_code_context_get_analyzer (context);
	_tmp821_ = _tmp820_;
	_tmp822_ = mtype;
	_tmp823_ = params;
	_tmp824_ = vala_method_call_get_argument_list (self);
	_tmp825_ = _tmp824_;
	_tmp826_ = !vala_semantic_analyzer_check_arguments (_tmp821_, (ValaExpression*) self, _tmp822_, _tmp823_, _tmp825_);
	_vala_iterable_unref0 (_tmp825_);
	if (_tmp826_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp827_;
		gint _arg_size = 0;
		ValaList* _tmp828_;
		gint _tmp829_;
		gint _tmp830_;
		gint _arg_index = 0;
		_tmp827_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp827_;
		_tmp828_ = _arg_list;
		_tmp829_ = vala_collection_get_size ((ValaCollection*) _tmp828_);
		_tmp830_ = _tmp829_;
		_arg_size = _tmp830_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp831_;
			gpointer _tmp832_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp833_;
			gboolean _tmp834_ = FALSE;
			ValaSizeofExpression* _tmp835_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp831_ = _arg_list;
			_tmp832_ = vala_list_get (_tmp831_, _arg_index);
			arg = (ValaExpression*) _tmp832_;
			_tmp833_ = arg;
			sizeof_expr = G_TYPE_CHECK_INSTANCE_TYPE (_tmp833_, VALA_TYPE_SIZEOF_EXPRESSION) ? ((ValaSizeofExpression*) _tmp833_) : NULL;
			_tmp835_ = sizeof_expr;
			if (_tmp835_ != NULL) {
				ValaSizeofExpression* _tmp836_;
				ValaDataType* _tmp837_;
				ValaDataType* _tmp838_;
				_tmp836_ = sizeof_expr;
				_tmp837_ = vala_sizeof_expression_get_type_reference (_tmp836_);
				_tmp838_ = _tmp837_;
				_tmp834_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp838_, VALA_TYPE_GENERIC_TYPE);
			} else {
				_tmp834_ = FALSE;
			}
			if (_tmp834_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp839_;
				ValaDataType* _tmp840_;
				ValaDataType* _tmp841_;
				ValaDataType* _tmp842_;
				ValaList* _tmp843_;
				ValaDataType* _tmp844_;
				ValaExpression* _tmp845_;
				ValaDataType* _tmp846_;
				ValaSourceReference* _tmp847_;
				ValaSourceReference* _tmp848_;
				ValaSizeofExpression* _tmp849_;
				ValaSizeofExpression* _tmp850_;
				_tmp839_ = sizeof_expr;
				_tmp840_ = vala_sizeof_expression_get_type_reference (_tmp839_);
				_tmp841_ = _tmp840_;
				_tmp842_ = target_object_type;
				_tmp843_ = method_type_args;
				_tmp844_ = vala_data_type_get_actual_type (_tmp841_, _tmp842_, _tmp843_, (ValaCodeNode*) self);
				sizeof_type = _tmp844_;
				_tmp845_ = arg;
				_tmp846_ = sizeof_type;
				_tmp847_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp848_ = _tmp847_;
				_tmp849_ = vala_sizeof_expression_new (_tmp846_, _tmp848_);
				_tmp850_ = _tmp849_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp845_, (ValaExpression*) _tmp850_);
				_vala_code_node_unref0 (_tmp850_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp853_ = base_cm;
	if (_tmp853_ != NULL) {
		ValaCreationMethod* _tmp854_;
		_tmp854_ = base_cm;
		_tmp852_ = vala_method_is_variadic ((ValaMethod*) _tmp854_);
	} else {
		_tmp852_ = FALSE;
	}
	if (_tmp852_) {
		ValaList* _tmp855_;
		gint _tmp856_;
		gint _tmp857_;
		ValaCreationMethod* _tmp858_;
		ValaList* _tmp859_;
		ValaList* _tmp860_;
		gint _tmp861_;
		gint _tmp862_;
		_tmp855_ = args;
		_tmp856_ = vala_collection_get_size ((ValaCollection*) _tmp855_);
		_tmp857_ = _tmp856_;
		_tmp858_ = base_cm;
		_tmp859_ = vala_callable_get_parameters ((ValaCallable*) _tmp858_);
		_tmp860_ = _tmp859_;
		_tmp861_ = vala_collection_get_size ((ValaCollection*) _tmp860_);
		_tmp862_ = _tmp861_;
		_tmp851_ = _tmp857_ == _tmp862_;
		_vala_iterable_unref0 (_tmp860_);
	} else {
		_tmp851_ = FALSE;
	}
	if (_tmp851_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp863_;
		ValaList* _tmp864_;
		gint _tmp865_;
		gint _tmp866_;
		gpointer _tmp867_;
		gboolean _tmp868_ = FALSE;
		ValaExpression* _tmp869_;
		ValaDataType* _tmp870_;
		ValaDataType* _tmp871_;
		_tmp863_ = args;
		_tmp864_ = args;
		_tmp865_ = vala_collection_get_size ((ValaCollection*) _tmp864_);
		_tmp866_ = _tmp865_;
		_tmp867_ = vala_list_get (_tmp863_, _tmp866_ - 1);
		this_last_arg = (ValaExpression*) _tmp867_;
		_tmp869_ = this_last_arg;
		_tmp870_ = vala_expression_get_value_type (_tmp869_);
		_tmp871_ = _tmp870_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp871_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
			ValaExpression* _tmp872_;
			ValaDataType* _tmp873_;
			ValaDataType* _tmp874_;
			ValaTypeSymbol* _tmp875_;
			ValaTypeSymbol* _tmp876_;
			ValaSemanticAnalyzer* _tmp877_;
			ValaSemanticAnalyzer* _tmp878_;
			ValaDataType* _tmp879_;
			ValaTypeSymbol* _tmp880_;
			ValaTypeSymbol* _tmp881_;
			_tmp872_ = this_last_arg;
			_tmp873_ = vala_expression_get_value_type (_tmp872_);
			_tmp874_ = _tmp873_;
			_tmp875_ = vala_data_type_get_data_type (_tmp874_);
			_tmp876_ = _tmp875_;
			_tmp877_ = vala_code_context_get_analyzer (context);
			_tmp878_ = _tmp877_;
			_tmp879_ = _tmp878_->va_list_type;
			_tmp880_ = vala_data_type_get_data_type (_tmp879_);
			_tmp881_ = _tmp880_;
			_tmp868_ = _tmp876_ == _tmp881_;
		} else {
			_tmp868_ = FALSE;
		}
		if (_tmp868_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp882_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp883_ = _tmp882_;
	vala_code_node_check ((ValaCodeNode*) _tmp883_, context);
	_tmp884_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp885_ = _tmp884_;
	if (_tmp885_) {
		gboolean _tmp886_ = FALSE;
		ValaCodeNode* _tmp887_;
		ValaCodeNode* _tmp888_;
		_tmp887_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp888_ = _tmp887_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp888_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp886_ = TRUE;
		} else {
			ValaCodeNode* _tmp889_;
			ValaCodeNode* _tmp890_;
			_tmp889_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp890_ = _tmp889_;
			_tmp886_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp890_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp886_) {
		} else {
			ValaSemanticAnalyzer* _tmp891_;
			ValaSemanticAnalyzer* _tmp892_;
			ValaSymbol* _tmp893_;
			ValaSymbol* _tmp894_;
			_tmp891_ = vala_code_context_get_analyzer (context);
			_tmp892_ = _tmp891_;
			_tmp893_ = vala_semantic_analyzer_get_current_symbol (_tmp892_);
			_tmp894_ = _tmp893_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp894_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp895_;
				ValaSourceReference* _tmp896_;
				_tmp895_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp896_ = _tmp895_;
				vala_report_error (_tmp896_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp897_;
				ValaCodeNode* _tmp898_;
				ValaCodeNode* _tmp899_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp900_;
				ValaDataType* _tmp901_;
				ValaDataType* _tmp902_;
				ValaDataType* _tmp903_;
				gchar* _tmp904_;
				gchar* _tmp905_;
				ValaSourceReference* _tmp906_;
				ValaSourceReference* _tmp907_;
				ValaLocalVariable* _tmp908_;
				ValaLocalVariable* _tmp909_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp910_;
				ValaSourceReference* _tmp911_;
				ValaSourceReference* _tmp912_;
				ValaDeclarationStatement* _tmp913_;
				ValaSemanticAnalyzer* _tmp914_;
				ValaSemanticAnalyzer* _tmp915_;
				ValaBlock* _tmp916_;
				ValaDeclarationStatement* _tmp917_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp918_;
				ValaDataType* _tmp919_;
				ValaDataType* _tmp920_;
				ValaExpression* _tmp921_;
				ValaLocalVariable* _tmp922_;
				ValaDeclarationStatement* _tmp923_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp924_;
				ValaSemanticAnalyzer* _tmp925_;
				ValaSymbol* _tmp926_;
				ValaSymbol* _tmp927_;
				ValaBlock* _tmp928_;
				ValaBlock* _tmp929_;
				ValaLocalVariable* _tmp930_;
				ValaSemanticAnalyzer* _tmp931_;
				ValaSemanticAnalyzer* _tmp932_;
				ValaBlock* _tmp933_;
				ValaLocalVariable* _tmp934_;
				ValaCodeNode* _tmp935_;
				ValaExpression* _tmp936_;
				ValaExpression* _tmp937_;
				_tmp897_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp898_ = _tmp897_;
				_tmp899_ = _vala_code_node_ref0 (_tmp898_);
				old_parent_node = _tmp899_;
				_tmp900_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp901_ = _tmp900_;
				_tmp902_ = vala_data_type_copy (_tmp901_);
				_tmp903_ = _tmp902_;
				_tmp904_ = vala_code_node_get_temp_name ();
				_tmp905_ = _tmp904_;
				_tmp906_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp907_ = _tmp906_;
				_tmp908_ = vala_local_variable_new (_tmp903_, _tmp905_, NULL, _tmp907_);
				_tmp909_ = _tmp908_;
				_g_free0 (_tmp905_);
				_vala_code_node_unref0 (_tmp903_);
				local = _tmp909_;
				_tmp910_ = local;
				_tmp911_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp912_ = _tmp911_;
				_tmp913_ = vala_declaration_statement_new ((ValaSymbol*) _tmp910_, _tmp912_);
				decl = _tmp913_;
				_tmp914_ = vala_code_context_get_analyzer (context);
				_tmp915_ = _tmp914_;
				_tmp916_ = _tmp915_->insert_block;
				_tmp917_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp916_, (ValaStatement*) _tmp917_);
				_tmp918_ = local;
				_tmp919_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp920_ = _tmp919_;
				_tmp921_ = vala_semantic_analyzer_create_temp_access (_tmp918_, _tmp920_);
				temp_access = _tmp921_;
				_tmp922_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp922_, (ValaExpression*) self);
				_tmp923_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp923_, context);
				_tmp924_ = vala_code_context_get_analyzer (context);
				_tmp925_ = _tmp924_;
				_tmp926_ = vala_semantic_analyzer_get_current_symbol (_tmp925_);
				_tmp927_ = _tmp926_;
				_tmp928_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp927_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp928_;
				_tmp929_ = block;
				_tmp930_ = local;
				vala_block_remove_local_variable (_tmp929_, _tmp930_);
				_tmp931_ = vala_code_context_get_analyzer (context);
				_tmp932_ = _tmp931_;
				_tmp933_ = _tmp932_->insert_block;
				_tmp934_ = local;
				vala_block_add_local_variable (_tmp933_, _tmp934_);
				_tmp935_ = old_parent_node;
				_tmp936_ = temp_access;
				vala_code_node_replace_expression (_tmp935_, (ValaExpression*) self, _tmp936_);
				_tmp937_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp937_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp938_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp939_ = _tmp938_;
	result = !_tmp939_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		_tmp18_ = vala_method_call_get_call (self);
		_tmp19_ = _tmp18_;
		vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _expr_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _expr_index = 0;
		_tmp20_ = self->priv->argument_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_expr_list = _tmp21_;
		_tmp22_ = _expr_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_expr_size = _tmp24_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaExpression* _tmp27_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp25_ = _expr_list;
			_tmp26_ = vala_list_get (_tmp25_, _expr_index);
			expr = (ValaExpression*) _tmp26_;
			_tmp27_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp27_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		format_arg = vala_method_get_format_arg_index (_tmp8_);
		if (format_arg >= 0) {
			ValaList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp10_ = self->priv->argument_list;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp9_ = format_arg < _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			ValaStringLiteral* _tmp16_;
			ValaStringLiteral* _tmp17_;
			_tmp13_ = self->priv->argument_list;
			_tmp14_ = vala_list_get (_tmp13_, format_arg);
			_tmp15_ = (ValaExpression*) _tmp14_;
			_tmp16_ = vala_string_literal_get_format_literal (_tmp15_);
			_tmp17_ = _tmp16_;
			_vala_code_node_unref0 (_tmp15_);
			result = _tmp17_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	gchar* result = NULL;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			GString* _tmp18_;
			ValaExpression* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp15_ = _expr_list;
			_tmp16_ = vala_list_get (_tmp15_, _expr_index);
			expr = (ValaExpression*) _tmp16_;
			if (!first) {
				GString* _tmp17_;
				_tmp17_ = b;
				g_string_append (_tmp17_, ", ");
			}
			_tmp18_ = b;
			_tmp19_ = expr;
			_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			g_string_append (_tmp18_, _tmp21_);
			_g_free0 (_tmp21_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp22_ = b;
	g_string_append (_tmp22_, "))");
	_tmp23_ = b;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	_g_string_free0 (b);
	return result;
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

